/* 
 * copy mail to temp
 */

#include <stdio.h>
#include <ctype.h>
#include "mail.h"

extern char *Mailpgm, *mailfile, PREPEND[], TO[], line[LSIZE];
extern char *getdate(), *frflsh(), *calloc(), *strchr();
extern int nlet;

struct   let   NullLet;      /* readonly null letter */

copymt(f1, f2)
FILE *f1, *f2;
{
   char   *topic();

   long nextadr;
   register int i, lines = 0;
   int   cnt;
   char *lp, *sp, *cp, subject[LSIZE], heuristic[LSIZE], firstln[LSIZE];

   /* Do cleanup */
   for (i = 0; i < nlet; i++) {
      if (let[i].sender)
         free(let[i].sender);
      if (let[i].subject)
         free(let[i].subject);
      if (let[i].postmark)
         free(let[i].postmark);
      let[i] = NullLet;      /* ..STRUCTURE ASSIGNMENT.. */
   }
   nlet = nextadr = 0;
#if 0
   let[0].adr = 0;
#endif
   line[LSIZE-2] = 0;

   lp = fgets(line, LSIZE, f1);
   while (lp != NULL) {
      if (!Isfrom(line)) {
         fprintf(stderr, "%s: File %s not in mail format\n",
             Mailpgm, mailfile);
         unmailock();
         exit(1);
      }
      if (nlet >= (MAXLET-2)) {
         fprintf(stderr,
             "%s: Too many letters (more than %d): split %s\n",
             Mailpgm, MAXLET-3, mailfile);
         unmailock();
         exit(1);
      }
      if (nlet > 0) {
         let[nlet-1].llns = lines;
         lines = 0;
      }
      let[nlet].postmark = getdate(line);
      let[nlet].adr = nextadr;
      let[nlet].change = 0;
      nextadr += strlen(line);
      fputs(line, f2);
      lines++;
      fradd(line);

      /* Copy remaining ">From" lines */
      while (NULL != (lp=fgets(line, LSIZE, f1)))
      {
         /* assume blank line between header and message */
         if(strncmp(line, "Subject: ", 9) == 0) break;
         if(strlen(line) < 2) break;
         nextadr += strlen(line);
         fputs(line, f2);
         lines++;
         if(Isfrom(line+1)) fradd(line);
      }

      /* Save address of sender of this letter */
      sp = frflsh(0);
      if ((cp = calloc(strlen(sp) + 1, 1)) != NULL)
         strcpy(cp, sp);
      let[nlet].sender = cp;

      /* Copy text lines after "From" and ">From"s */
      subject[0] = '\0';
      heuristic[0] = '\0';
      firstln[0] = '\0';
      while (lp != NULL && !Isfrom(line)) {
         /* First priority subject */
         if (subject[0] == '\0'
             && (sp = topic(lp)) != NULL) {
            strncpy(subject, sp, sizeof(subject));
            subject[sizeof(subject) - 1] = '\0';
         }

         /* Second priority subject */
         if (subject[0] == '\0'
             && heuristic[0] == '\0'
             && strlen(lp) > 12
             && strncmp(lp, PREPEND, strlen(PREPEND))
             && strncmp(lp, TO, strlen(TO))) {
            strncpy(heuristic, lp, sizeof(heuristic));
            heuristic[sizeof(heuristic) - 1] = '\0';
         }

         /* Third priority subject */
         if (subject[0] == '\0'
             && heuristic[0] == '\0'
             && firstln[0] == '\0'
             && *lp
             && !allblank(lp)
             && strncmp(lp, TO, strlen(TO))) {
            strncpy(firstln, lp, sizeof(firstln));
            firstln[sizeof(firstln) - 1] = '\0';
         }
         nextadr += strlen(line);
         fputs(line, f2);
         lines++;

         /* Handle long lines (> LSIZE bytes) */
         if (line[LSIZE-2] && line[LSIZE-2] != '\n') {
            do {
               line[LSIZE-2] = 0;
               if (!(lp = fgets(line, LSIZE, f1)))
                  break;
               nextadr += strlen(line);
               fputs(line,f2);
            } while (line[LSIZE-2] && line[LSIZE-2] != '\n');
         }
         line[LSIZE-2] = 0;
         lp = fgets(line, LSIZE, f1);
      }

      /* If letter has no subject, use first "significant" line */
      if (subject[0])
         sp = subject;
      else if (heuristic[0])
         sp = heuristic;
      else if (firstln[0])
         sp = firstln;
      else
         sp = NULL;
      if (sp != NULL) {
         while (*sp && isspace(*sp))
            ++sp;
         if ((cp = strchr(sp, '\n')) != NULL)
            cnt = cp - sp;
         else
            cnt = strlen(sp);
         cnt = (cnt > 44) ? 44 : cnt;
         if ((cp = calloc(cnt + 1, 1)) != NULL) {
            strncpy(cp, sp, cnt);
            cp[cnt] = '\0';
            let[nlet].subject = cp;
         }
      }
      else
         let[nlet].subject = NULL;
      ++nlet;
   }
   let[nlet].adr = nextadr;   /* last plus 1 */
   let[nlet-1].llns = lines;
}
