.ad l
.nh
.TH import 1 "10 October 1992" "ImageMagick"
.SH NAME
import - capture some or all of an X server screen and save the image to
a file.
.SH SYNOPSIS
.B "import"
[ \fIoptions\fP ... ] \fIfile\fP
.SH DESCRIPTION
\fBimport\fP reads an image from any visible window on an X server and
outputs it as an image file.  You can capture a single window, the
entire screen, or any rectangular portion of the screen.  Use
\fBdisplay\fP (see \fBdisplay(1)\fP) for redisplay, printing, editing,
formatting, archiving, image processing, etc. of the captured image.
.PP
The target window can be specified by id, name, or may be selected by
clicking the mouse in the desired window.  If you press a button and
then drag, a rectangle will form which expands and contracts as
the mouse moves.  To save the portion of the screen  defined by the
rectangle, just release the button.  The keyboard bell is rung once at
the beginning of the screen capture and twice when it completes.
.PP
.SH EXAMPLES
.PP
To select an X window with the mouse and save it in the MIFF image
format to a file titled window.miff, use:
.PP
.B
     import window.miff
.PP
To select an X window and save it in the Encapsulated Postscript format
to include in another document, use:
.PP
.B
     import figure.eps
.PP
To capture the entire X server screen in the JPEG image format in a file
titled root.jpeg, use:
.PP
.B
     import -window root root.jpeg
.SH OPTIONS
\fBimport\fP options can appear on the command line or in your X resources
file (see \fBX(1)\fP).  Options on the command line supersede values specified
in your X resources file.
.TP 5
.B "-border"
include image borders in the output image.
.TP 5
.B "-clip \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the clipped image.  See \fBX(1)\fP for details
about the geometry specification.
 
Use clipping to crop a particular area of an image.
.TP 5
.B "-colors \fIvalue\fP"
preferred number of colors in the image.
 
The actual number of colors in the image may be less than your request,
but never more.  Note, this is a color reduction option.  Images with
less unique colors than specified with this option will remain unchanged.
Refer to \fBquantize(9)\fP for more details.
 
Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect
the color reduction algorithm.
.TP 5
.B "-colorspace \fIvalue\fP"
the type of colorspace: \fBGRAY\fP, \fBRGB\fP, \fBXYZ\fP, \fBYCbCr\fP,
\fBYIQ\fP, or \fBYUV\fP.
 
Color reduction, by default, takes place in the RGB color space.
Empirical evidence suggests that distances in color spaces such as YUV
or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Refer to \fBquantize(9)\fP for
more details.
 
The \fB-colors\fP or \fB-monochrome\fP option is required for this option
to take effect.
.TP 5
.B "-compress \fItype\fP"
the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.
See \fBmiff(5)\fP for details.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP 5
.B "-delay \fIseconds\fP"
pause before selecting target window.

This option is useful when you need time to ready the target window before
it is captured to a file.
.TP 5
.B "-density \fI<width>x<height>
vertical and horizonal density of the image.

This option specifies an image density whose interpretation changes
with the type of image.  The default is 72 dots per inch in the
horizonal and vertical direction for Postscript.  Text files default to
80 characters in width and 60 lines in height.  Use this option to
alter the default density.
.TP 5
.B "-descend"
obtain image by descending window hierarchy.

Normally the colormap of the chosen window is used to obtain the red,
green, and blue values.  This option reads each subwindow and its
colormap of the chosen window.  The final image is guarenteed to have the
correct colors but obtaining the image is significantly slower.
.TP 5
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP 5
.B "-dither"
apply Floyd/Steinberg error diffusion to the image.
 
The basic strategy of dithering is to trade intensity resolution for
spatial resolution by averaging the intensities of several neighboring
pixels.  Images which suffer from severe contouring when reducing colors
can be improved with this option.
 
The \fB-colors\fP option is required for dithering to take effect.
.TP 5
.B "-frame"
include window manager frame.
.TP 5
.B "-geometry \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
the width and height of the image.

If the specified image size is smaller than the actual image size, the
image is first reduced to an integral of the specified image size with
an antialias digital filter.  The image is then scaled to the exact
specified image size with pixel replication.  If the specified image
size is greater than the actual image size, the image is first enlarged
to an integral of the specified image size with bilinear
interpolation.  The image is then scaled to the exact specified image
size with pixel replication.
 
Use this option to specify the width and height of raw images whose
dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, and \fBCMYK\fP.
.TP 5
.B "-interlace \fItype\fP"
the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.

This option is used to specify the type of interlacing scheme for raw
image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not
interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline
interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses
plane interlacing (RRRRRR...GGGGGG...BBBBBB...).
.TP 5
.B "-monochrome"
transform image to black and white.
.TP 5
.B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the Postscript page.

Use this option to specify the dimensions of the Postscript page in picas.  The
default is to center the image on a letter page, 612 by 792 picas.
Other common sizes are:

    540x720   Note
    612x1008  Legal
    842x1190  A3
    595x842   A4
    421x595   A5
    297x421   A6
    709x1002  B4
    612x936   U.S. Foolscap
    612x936   European Foolscap
    396x612   Half Letter
    792x1224  11x17
    1224x792  Ledger

The page geometry is relative to the vertical and horizonal density of the
Postscript page.  See \fB-density\fP for details.
.TP 5
.B "-quality \fIvalue\fP"
JPEG quality setting.

Quality is 0 (worst) to 100 (best). The default is 75.
.TP 5
.B "-scene \fIvalue\fP"
image scene number.
.TP 5
.B "-screen"
This option indicates that the GetImage request used to obtain the image
should be done on the root window, rather than directly on the specified
window.  In this way, you can obtain pieces of other windows that overlap
the specified window, and more importantly, you can capture menus or other
popups that are independent windows but appear over the specified window.
.TP 5
.B "-treedepth \fIvalue\fP"
Normally, this integer value is zero or one.  A zero or one tells
\fBconvert\fP to choose a optimal tree depth for the color reduction
algorithm.
 
An optimal depth generally allows the best representation of the source
image with the fastest computational speed and the least amount of
memory.  However, the default depth is inappropriate for some images.
To assure the best representation, try values between 2 and 8 for this
parameter.  Refer to \fBquantize(9)\fP for more details.
 
The \fB-colors\fP option is required for this option to take effect.
.TP 5
.B -verbose
print detailed information about the image.

This information is printed: image scene number;  image name;  image size;
the image class (\fIDirectClass\fP or \fIPseudoClass\fP);  the total
number of unique colors;  and the number of seconds to read and write the
image.
.TP 5
.B "-window \fIid\fP"
select window with this id or name.

With this option you can specify the target window by id or name rather
than using the mouse.  Specify 'root' to select X's root window as the
target window.
.PP
Change \fI-\fP to \fI+\fP in any option above to reverse its effect.  For
example \fB+frame\fP means do include window manager frame.
.PP
\fIfile\fP specifies the image filename.  By default, the image is
written in the Postscript image format.  To specify a particular image
format, precede the filename with an image format name and a colon
(i.e.  ps:image) or specify the image type as the filename suffix (i.e.
image.ps).  See \fBconvert(1)\fP for a list of valid image formats.
.PP
If \fIfile\fP has the extension \fB.Z\fP or \fB.gz\fP, the file size is
compressed using with \fBcompress\fP or \fBgzip\fP respectively.  If
\fIfile\fP already exists, you will be prompted as to whether it
should be overwritten.
.SH ENVIRONMENT
.PP
.TP 5
.B display
To get the default host, display number, and screen.
.SH SEE ALSO
.B
display(1), animate(1), mogrify(1), convert(1), quantize(9), X(1), miff(5)
.SH COPYRIGHT
Copyright 1993 E. I. du Pont de Nemours & Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
& Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours & Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours & Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours & Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising
out of or in connection with the use or performance of this software.
.SH AUTHORS
John Cristy, E.I. du Pont De Nemours & Company Incorporated
