#ifndef lint
static char *RCSid = "$Header: /u/dhay/bemp/src3/player/commands/RCS/upda.c,v 1.3 91/03/20 00:16:42 dhay Exp $";
#endif /* not lint */

/*
 * upda.c
 *
 * Give the time of the next update
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include "misc.h"

#ifdef	UPDATESCHED
#include "keyword.h"
#include "wantupd.h"

#ifdef BLITZ
extern int update_blitz();
#endif /* BLITZ */
/*
 * Tell what the update policy is, and when the next update
 * is likely to be.
 */
upda()
{
	extern int s_p_etu, etu_per_update;
#ifdef BLITZ
	extern int blitz_time;
#endif /* BLITZ */
	time_t now, next, delta;
	int pol, wpol;
	int min, absmin;
	int want, pop;
	char *p;
	char *ctime();

	(void) time(&now);
	demand_update_info(&pol, &wpol, &min, &absmin);
	switch (pol) {
	case UDP_NORMAL:
		next_update_time(&now, &next, &delta);
		pr("\nUpdates occur at times specified by the ETU rates.\n");
		pr(fmt("The next update is at %19.19s.\n\n", ctime(&next)));
		break;
	case UDP_TIMES:
		next_update_time(&now, &next, &delta);
		pr("\nUpdates occur at scheduled times.\n");
		pr(fmt("The next update is at %19.19s.\n\n", ctime(&next)));
		break;
#ifdef BLITZ
        case UDP_BLITZ:
                next_update_time(&now, &next, &delta);
                pr(fmt("\nBlitz Updates occur every %d minutes. \n",blitz_time));
                pr(fmt("The next update is at %19.19s.\n\n",ctime(&next)));
		break;
#endif /* BLITZ */
	case UDP_NOREG:
		pr("There are no regularly scheduled updates.\n\n");
		break;
	default:
		pr("Update policy is inconsistent.\n\n");
	}

#ifdef	DEMANDUPDATE
	switch (wpol) {
	case UDDEM_TMCHECK:
		next_update_check_time(&now, &next, &delta);
		pr("Demand updates occur at update CHECK times.\n");
		pr(fmt("The next update check is at %19.19s.\n\n",
				ctime(&next)));
		break;
	case UDDEM_COMSET:
		pr("Demand updates occur right after the demand is set.\n\n");
		break;
	case UDDEM_DISABLE:
		pr("Demand updates are disabled.\n\n");
		break;
	default:
		pr("Update demand policy is inconsistent.\n\n");
	}
#endif	DEMANDUPDATE

	if ((pol == UDP_TIMES)
#ifdef	DEMANDUPDATE
				|| (wpol == UDDEM_TMCHECK)
#endif	DEMANDUPDATE
				) {
		if (p=kw_find("update_times"))
			pr(fmt("The update schedule is: %s\n", p));
	}
#ifdef	DEMANDUPDATE
	if (wpol != UDDEM_DISABLE) {
		if (p=kw_find("update_demandtimes"))
			pr(fmt("Demand updates are allowed during: %s\n", p));
		if (min == 0) {
			pr("Demand updates are disabled by a mininum of 0\n");
		} else {
			if (min < absmin) min = absmin;
			pr(fmt("Demand updates require %d country(s) to want one.\n",min));
		}
	}
#endif	DEMANDUPDATE
	if (p=kw_find("days"))
		pr(fmt("Game days are: %s\n", p));
	if (p=kw_find("hours"))
		pr(fmt("Game hours are: %s\n", p));

	pr(fmt("The current time is %19.19s.\n", ctime(&now)));
	return(0);
}

#else	UPDATESCHED
#include <time.h>

upda()
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	time_t	now;
	time_t	upd_time;
	time_t	next_update;
	int	secs_per_update;
	int	delta;

	(void) time(&now);
	upd_time = now + adj_update;
	secs_per_update = etu_per_update * s_p_etu;
	delta = secs_per_update - (upd_time % secs_per_update);
	next_update = now + delta;
	pr(fmt("The next update is at %19.19s.\n",ctime(&next_update)));
	pr(fmt("The current time is %19.19s.\n",ctime(&now)));
	return 0;
}
#endif	UPDATESCHED
