# include "AnimObject.h"
# include "AnimObject.r"

/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
*/

#include <vgagl.h>
#include <sys/time.h>
#include "io.h"

static void delay(void)
{
	static struct timeval tv = {0,900};

	debug_printf("sleeping\n");
	select(0,NULL,NULL,NULL,&tv);
}

static struct GObject * AnimObject_gomove (void * _self, int x1, int y1, int x2, int y2) {

	struct GObject *self = cast(GObject, _self);

	int step, xstep = (x2-x1)/ANIMSTEPS, ystep = (y2-y1)/ANIMSTEPS;

	debug_printf("AnimObject->gomove\n");
	debug_printf("\tmoving from %d,%d to %d,%d\n",x1,y1,x2,y2);

	for(step=1;step < ANIMSTEPS; step++)
	{	gl_fillbox(x1,y1,self->width, self->height,0);
		godisplay(self, x1+xstep*step, y1+ystep*step);
	}
	gl_fillbox(x1, y1, self->width, self->height, 0);
	godisplay(self, x2, y2);
	return (void *) self;
}

static const void * initAnimObject (void)
{
	return ((struct Object *) AnimObject) -> class ? AnimObject :
		(AnimObject = new(GClass,
			"AnimObject", GObject, sizeof(struct AnimObject),
			gomove, "gomove", AnimObject_gomove,
			(void *) 0));
}

static const struct ClassInit _AnimObject = { { MAGIC }, initAnimObject };
const void * AnimObject = & _AnimObject;
