/*
** Astrolog (Version 3.05) File: astrolog.h
**
** By Walter D. Pullen (astrolog@byron.u.washington.edu)
** Initially programmed 8/28,30, 9/10,13,16,20,23, 10/3,6,7, 11/7,10,21/1991.
** Last change made 5/9/1993.
**
** IMPORTANT: The planetary calculation routines used in this program
** have been Copyrighted and the core of this program is basically a
** conversion to C of the routines created by James Neely as listed in
** Michael Erlewine's 'Manual of Computer Programming for Astrologers',
** available from Matrix Software. The copyright gives us permission to
** use the routines for our own purposes but not to sell them or profit
** from them in any way.
**
** IN ADDITION: the graphics database and chart display routines used in
** this program are Copyright (C) 1991-1993 by Walter D. Pullen. Permission
** is granted to freely use and distribute these routines provided one
** doesn't sell, restrict, or profit from them in any way. Modification
** is allowed provided these notices remain with any altered or edited
** versions of the program.
*/

/*
** To compile: For most systems, especially Unix based ones, the only changes
** that should need to be made to the code are to edit or comment out the 11
** #define's below to equal the particulars of your own locale and system:
*/

#define DEFAULT_LONG  -7.42  /* Change these values to the longitude W and */
#define DEFAULT_LAT   45.06  /* latitude N of your current location.       */
                             /* Use negative values for east/south areas.  */
#define DEFAULT_ZONE   1.00  /* Change to default time zone of current     */
                             /* location in hours before (west of) GMT.    */

#if (0)
#error this is obsolete. See Makefile
#define DEFAULT_DIR "/usr/local/astrolog/"
                     /* Change this string to directory path program       */
                     /* should look in for chart files if not in current.  */
                     /* For PC users, use two backslashes instead of one   */
                     /* forward slash to divide subdirectories.            */
                     /* (The above string must end with a slash!)          */
#endif

#define SWITCHES /* Comment out this #define if your system can not handle */
                 /* parameters on the command line (like Mac's, etc.)      */
#define TIME     /* Comment out this #define if your compiler can't take   */
                 /* the calls to 'time' or 'localtime' as in time.h        */
#define GRAPH    /* Commant out this #define if you don't want graphics.   */
#define X11      /* Comment out this #define if you don't have X windows.  */
/*#define MSC       Comment out this #define if you don't have access      */
                 /* to the Microsoft C PC graphics library as in graph.h.  */
#define NOPC     /* Comment out this #define if you have a PC system.      */
#define ATOF     /* Comment out this #define if you have a system in which */
                 /* atof() isn't defined in stdio.h, such as VMS and NeXT. */

/*
** Although not necessary, one may like to change some of the values below:
** These constants affect some of the default parameters, etc.
*/

#define DEFAULT_INFOFILE "astrolog.dat" /* Name of file to look in for     */
                                        /* default parameters (which will  */
                                        /* override the values here.)      */
#define DEFAULT_SYSTEM 0     /* Normally, Placidus houses are used (unless */
                             /* user specifies otherwise). If you want a   */
                             /* different default system, change this numb */
                             /* to value from 0..9 (values same as in -c). */
#define DEFAULT_ASPECTS 5    /* Default number of aspects to consider.     */

#define WHEELCOLS 15    /* Affects the width of each house in wheel display */
#define WHEELROWS 11    /* Max no. of objects that can be in a wheel house. */
#define MAXINDAY 100    /* Max number of aspects or transits displayable.   */
#define MAXCROSS 500    /* Max number of latitude crossings displayable.    */
#define DIVISIONS 24    /* Greater numbers == more accuracy but slower      */
                        /* calculation, of exact aspect and transit times.  */

#ifdef GRAPH
#define BITMAPMODE 'C'  /* For graphics, this char affects how bitmaps are */
                        /* written. 'N' is written like with the 'bitmap'  */
                        /* program, 'C' is compacted somewhat (files have  */
                        /* less spaces), and 'V' is compacted even more.   */
                        /* 'A' means write as rectangular Ascii text file. */
                        /* 'B' means write as Windows bitmap (.bmp) file.  */
#ifdef NOPC
#define BITMAPX  1168   /* Maximum window size allowed (standard) */
#define BITMAPY  1024
#else
#define BITMAPX  728    /* Maximum window size allowed (for PC's) */
#define BITMAPY  720
#endif
#define BITMAPX1 180    /* Minimum window size allowed */
#define BITMAPY1 180
#ifdef NOPC
#define DEFAULTX 600    /* Default window size (standard) */
#define DEFAULTY 600
#else
#define DEFAULTX 480    /* Default window size (for PC's) */
#define DEFAULTY 480
#endif
#define CELLSIZE  14    /* Size for each cell in the aspect grid      */
#define DEFORB   7.0    /* Min distance glyphs can be from each other */
#endif

#define BOXH  (ansi ? 196 : '-')    /* Ansi and Ascii characters used to */
#define BOXV  (ansi ? 179 : '|')    /* print text charts.                */
#define BOXC  (ansi ? 197 : '|')
#define BOXNW (ansi ? 218 : '+')
#define BOXNE (ansi ? 191 : '+')
#define BOXSW (ansi ? 192 : '+')
#define BOXSE (ansi ? 217 : '+')
#define BOXJN (ansi ? 193 : '-')
#define BOXJS (ansi ? 194 : '-')
#define BOXJW (ansi ? 180 : '|')
#define BOXJE (ansi ? 195 : '|')
#define DEGR1 (ansi ? 248 : ',')
#define DEGR2 (ansi ? 248 : ' ')


/*
** One shouldn't need to change anything below this line to compile.
*/

#include <stdio.h>
#ifndef ATOF
#include <stdlib.h>
#endif
#include <math.h>
#ifndef NOPC
#include <malloc.h>
#endif
#ifdef TIME
#include <time.h>
#endif
#ifdef X11
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif
#ifdef MSC
#include <graph.h>
#include <conio.h>
#endif

/*
** Make sure only legal combinations of the graphics options are active.
*/

#ifdef X11
#define WIN
#ifndef GRAPH
"X11 implies GRAPH"
#endif
#ifdef MSC
"X11 implies not MSC"
#endif
#ifndef NOPC
"X11 implies NOPC"
#endif
#endif
#ifdef MSC
#define WIN
#ifndef GRAPH
"MSC implies GRAPH"
#endif
#ifdef X11
"MSC imples not X11"
#endif
#ifdef NOPC
"MSC imples not NOPC"
#endif
#endif


/*
*******************************************************************************
** Constants
*******************************************************************************
*/

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  1
#endif
#define APPNAME  "Astrolog"
#define VERSION  "3.05"
#define DATE     "April 1993"
#define ADDRESS  "astrolog@byron.u.washington.edu"
#define OFF      0
#define ON       1
#define STRING   80
#undef  PI
#define PI       3.14159265358979323846
#define DEGREES  360.0
#define DEGTORAD (180.0/PI)
#define SD2000   -24.736467
#define SCALE    (scale/100)
#define ESCAPE   '\33'
#define SIGNS    12
#define SYSTEMS  10
#define ASPECTS  18
#define ASPECTI  11
#define FONTX    6
#define FONTY    10

/* Object array index values */

#define PLANETS 14
#define THINGS  16
#define OBJECTS 20
#define URANIANS 8
#define STARS   47
#define BASE    32
#define TOTAL   79
#define C_LO    21
#define C_HI    24
#define U_LO    25
#define U_HI    32
#define S_LO    33
#define S_HI    79

/* Bit mask values for chart specification */

#define DASHv 0x1
#define DASHw 0x2
#define DASHg 0x4
#define DASHm 0x8
#define DASHZ 0x10
#define DASHS 0x20
#define DASHj 0x40
#define DASHL 0x80
#define DASHd 0x100
#define DASHE 0x200
#define DASHT 0x400
#define DASHe 0x3FF

/* Bit mask values for subchart specification */

#define DASHv0 0x1
#define DASHw0 0x2
#define DASHg0 0x4
#define DASHga 0x8
#define DASHm0 0x10
#define DASHZ0 0x20
#define DASHj0 0x40
#define DASHL0 0x80
#define DASHdm 0x100
#define DASHEy 0x200
#define DASHXW0 0x400
#define DASHXP0 0x800

/* Bit mask values for option specification */

#define DASHs 0x1
#define DASHC 0x2
#define DASHu 0x4
#define DASHf 0x8
#define DASH3 0x10
#define DASHG 0x20
#define DASHo 0x40
#define DASHX 0x80
#define DASHs0 0x100
#define DASHp0 0x200
#define DASHo0 0x400

/* Relationship chart modes */

#define DASHr  1
#define DASHrc 2
#define DASHrm 3
#define DASHrd 4
#define DASHrb 5
#define DASHr0 -1

/* Ansi colors */

#define BLACK   0
#define MAROON  1
#define DKGREEN 2
#define ORANGE  3
#define DKBLUE  4
#define PURPLE  5
#define DKCYAN  6
#define LTGRAY  7
#define DKGRAY  8
#define RED     9
#define GREEN   10
#define YELLOW  11
#define BLUE    12
#define MAGENTA 13
#define CYAN    14
#define WHITE   15


/*
*******************************************************************************
** Macro functions
*******************************************************************************
*/

#define LOBYTE(A) ((byte) (A))
#define HIBYTE(A) ((byte) ((word)(A) >> 8 & 0xFF))
#define LOWORD(A) ((word) (A))
#define HIWORD(A) ((word) ((dword)(A) >> 16 & 0xFFFF))
#define MAKEWORD(L, H) ((word)LOBYTE(L) | (byte)(H) << 8)
#define MAKELONG(L, H) ((dword)LOWORD(L) | (word)(H) << 16)
#define RGB(R, G, B) ((dword)((byte)(R) | (word)(G)<<8 | (dword)(byte)(B)<<16))
#define RGBR(R) LOBYTE(R)
#define RGBG(G) HIBYTE(G)
#define RGBB(B) ((byte) ((dword)(B) >> 16 & 0xFF))

#define MAX(A, B) ((A) > (B) ? (A) : (B))
#define MIN(A, B) ((A) < (B) ? (A) : (B))
#define FRACT(A) ((A) - floor(A))
#define CAP(B) ((B) >= 'a' && (B) <= 'z' ? (B) - 'a' + 'A' : (B))
#define DTOR(A) ((A)/DEGTORAD)
#define RTOD(A) ((A)*DEGTORAD)
#define ASIN(A) ((A)*(A) == 1.0 ? (A)*PI/2.0 : atan((A)/sqrt(1.0-(A)*(A))))
#define ACOS(A) ((A) == 0.0 ? 0.0 : atan(sqrt(1.0-(A)*(A))/(A)))
#define SIND(A) sin((A)/DEGTORAD)
#define COSD(A) cos((A)/DEGTORAD)
#define SWAP(A, B) (A)^=(B)^=(A)^=(B)
#define SORT(A, B) if ((A) > (B)) SWAP(A, B)

#define SIGNAM(A) signname[A][0], signname[A][1], signname[A][2]
#define OBJNAM(A) objectname[A][0], objectname[A][1], objectname[A][2]
#define dabs(A) fabs(A)
#define ecltoequ(Z, L) CoorXform(Z, L, DTOR( 23.44578889))
#define equtoecl(Z, L) CoorXform(Z, L, DTOR(-23.44578889))
#define equtolocal(Z, L, T) CoorXform(Z, L, T)

#ifdef NOPC
#define DASH '-'
#define PTR *
#define Allocate(P, B, T) (P) = (T) malloc(B)
#define Deallocate(P) free(P)
#else
#define DASH '/'
#define PTR huge *
#define Allocate(P, B, T) (P) = (T) halloc((long)(B), sizeof(byte))
#define Deallocate(P) hfree(P)
#endif


/*
*******************************************************************************
** Type definitions
*******************************************************************************
*/

#define byte  unsigned char
#define word  unsigned short
#define dword unsigned long
#define real  double

typedef struct _gridstruct {
  byte  n[TOTAL+1][TOTAL+1];
  short v[TOTAL+1][TOTAL+1];
} gridstruct;

#ifdef GRAPH
#define color unsigned long
#define bit color

typedef struct _circlestruct {
  real x[360+1];
  real y[360+1];
} circlestruct;

#ifdef NOPC
typedef struct _bitmapstruct {
  byte m[BITMAPX >> 1][BITMAPY];
} bitmapstruct;
typedef bitmapstruct *bitmap;
#else
typedef byte huge *bitmap;
#endif

#ifdef X11
#define Xcolor(A) XSetForeground(disp, gc, rgbind[(A)])
#endif
#ifdef MSC
#define Xcolor(A) _setcolor((short)(A))
#endif
#endif


/*
*******************************************************************************
** External declarations
*******************************************************************************
*/

/* From data.c */

extern int total, aspects, universe, centerplanet,
  housesystem, ansi, divisions, smartcusp, column80,
  todisplay, exdisplay, operation, relation,
  interpret, progress, multiplyfactor, onasc,
  wheelrows, graphstep, autom;
extern char *filename, *filename2, *appname, string[];
extern real progday, defzone, deflong, deflat, modulus;
extern real Mon, Day, Yea, Tim, Zon, Lon, Lat,
  M, D, Y, F, X, L5, LA,
  SD, Mon2, Yea2, Delta, T, JD, Jdp,
  MC, Asc, Vtx;

extern real planet[], planetalt[], house[], ret[],
  spacex[], spacey[], spacez[], force[],
  planet1[], planet2[], planetalt1[], planetalt2[],
  house1[], house2[], ret1[], ret2[];
extern gridstruct PTR grid;
extern byte inhouse[], inhouse1[], inhouse2[];
extern int starname[], objectansi[];

extern byte ignore[], ignore2[], errorcount[];
extern char *signname[], *signabbrev[], *signenglish[], *housetradition[],
  *objectname[], *systemname[], *aspectname[], *aspectabbrev[], *aspectglyph[],
  *element[], *mode[], *post[], *monthname[], *dayname[];
extern real aspectangle[], aspectorb[], planetorb[], planetadd[],
  starbright[], planetdata[], stardata[];
extern int ruler1[], ruler2[], exalt[], rules[],
  mainansi[], rainbowansi[], elemansi[], aspectansi[];
extern real objectinf[], houseinf[], aspectinf[];
extern char *mindpart[], *description[], *desire[], *lifearea[],
  *interact[], *therefore[], *modifier[3][11];

/* From general.c */

extern void SwapReal(), Terminate(), TooFew(), BadVal(), BadVal2(), PrintTab(),
  AnsiColor(), PrintMinute(), PrintAltitude(), InputData();
extern int StringLen(), Mod12(), DayInMonth(), ReadWorldData();
extern real Sgn(), DecToDeg(), Mod(), MinDistance(), Midpoint(),
  Orb(), ReadPlanetData(), ReadStarData();
extern char Dignify(), *StringLocation();

/* From formulas.c */

extern real MdyToJulian(), ProcessInput(), CastChart();
extern void JulianToMdy(), CoorXform(), HousePlace(), CastStar();

/* From charts.c */

extern void ChartLocation(), ChartGrid(), DisplayGrands(), ChartWheel(),
  ChartMidpoint(), ChartHorizon(), ChartSpace(), ChartInfluence(),
  ChartAstroGraph();

/* From options.c */

extern void CreateGrid(), CreateGridRelation(), CastRelation(),
  DisplayTransit(), DisplayEphemeris(), PrintChart();

#ifdef GRAPH
/* From xdata.c */

#ifdef X11
extern Colormap cmap;
extern Display *disp;
extern GC gc, pmgc;
extern KeySym key;
extern Pixmap pixmap, icon;
extern Window window, root;
extern XEvent event;
extern XSizeHints hint;
extern int screen, depth;
extern char xkey[];
extern char icon_bits[];
extern char *rgbname[];
extern color rgbind[];
#endif
extern bitmap bm;
extern color fg, bg, rgb[], rgbbmp[], maincolor[], rainbowcolor[],
  elemcolor[], aspectcolor[], objectcolor[], hilite, gray, on, off;
extern char modex, bitmapmode, *dispname, outputfile[];
extern int xmono, xcolor, xroot, xreverse, xbitmap, xtext, bonus, label, xeast,
  turtlex, turtley, scale, chartx, charty, degree, xnow;
extern real tilt;

extern char *signdraw[], *objectdraw[], *housedraw[], *aspectdraw[],
  *asciidraw[], *worlddata[];

/* From xcharts.c */

extern void XChart();

/* From xgeneral.c */

extern void DrawPoint(), DrawSpot(), DrawBlock(), DrawBox(),
  DrawLine(), DrawWrap(), DrawClip(), DrawTurtle();

/* From xdriver.c */

extern void XDisplaySwitches(), XAction();
extern int XProcess();
#endif

/* From driver.c */

extern void Prints();

/* astrolog.h */
