/*
 *  intfc.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// This file contains the interactive interface between
// the guts of C++ and the user interface code

#ifndef INTFC_DOT_H
#define INTFC_DOT_H
#include "ObjProDSP/portable.h"
#include "ObjProGen/slist.h"
#include "ObjProGui/yachead.h"
#include "ObjProDSP/entenm.h"
#include "ObjProArith/hrdarth.h"

extern char * InUseString[] ;

#define EntityReqCall EntityReqCreate
	// same options are  used for created an object and calling
	// a procedure

class InteractiveEntity ;
class InteractiveEntityList ;
class OutTokens ;

typedef class UserEntity *
	(*CreateEntity)(OutTokens&,EntityReq,InteractiveEntity&,
		ArithType::ArithCapabilities
		arith=(ArithType::ArithCapabilities) TheArithType) ;
typedef void (*OptInteractiveInit)(class InteractiveEntity *) ;

class UserParameters ;

class InteractiveEntity {
	class EntityList * EntityInstances ;
	CreateEntity DoCreate ;
	const char * EntityClassName ;
	UserParameters * Parameters ;
	ValueType ThisValue ;
	ValueType ** Members ;
	InteractiveEntityList * BaseClass ;
	InteractiveEntity * BaseEntity ;
	InteractiveEntity * DerivedEntity ;
	InteractiveEntity * BrotherEntity ;
	const char * HeaderFile ;
public:
	InteractiveEntity(const char*Name,EntityList*InitList,CreateEntity Cre,
		InteractiveType IntTyp, const char * header=0,
		ValueType ** members=0, const char * base_entity_name = 0) ;
	void Display() ;
	void Describe(OutTokens&,ListEntity) ;
	UserEntity * InteractiveCreate(OutTokens& Out);
	UserEntity * InteractiveCreateDefault(OutTokens& Out);
	UserEntity * Create(OutTokens& Out);
	UserEntity * DoRequest(OutTokens& Out,EntityReq Req) ;
	void Delete(OutTokens& Out);
	void SetParameters (UserParameters * Par) {Parameters = Par;}
	int GetParameters(int32 NextNameIndex) ;
	int32 GetIntParameterValue(const char * name);
	void * GetArrayParameterValue(const char * name);
	int32 GetLengthArrayParameterValue(const char * name);
	const char * GetStringParameterValue(const char * name);
	double GetFloatParameterValue(const char * name);
	UserParameters * GetParameterArray() {return Parameters;}
	class OneParameter * GetOneParameter(const char * Name) ;
	UserEntity * GetEntityParameterValue(const char * name);
	int32 ListSize() ;
	const char * GetClassName() { return EntityClassName; }
	UserEntity * GetEntity(OutTokens&) ;
	ValueType * GetValue() { return &ThisValue; }
	ValueType * FindObj(const char * name) ;
	UserEntity * GetObject(const char * name) ;
	ValueType * FindTypeObj(const char * name)
		{return FindObj(name) ? GetValue() : 0 ;}
	UserEntity * Declare (ValueType *) ;
	ValueType ** GetMembers() { return Members; }
	ValueType * GetMember(const char * Name) ;
	Procedure * GetMemberProcedure(const char * Name) ;
	void Dump(OutTokens&,ValueTypeList *Lst=0);
	InteractiveEntityList * GetBaseClass() {return BaseClass;}
	EntityList * GetInstances() {return EntityInstances;}
	InteractiveEntity * GetBaseEntity() {return BaseEntity;}
	InteractiveEntity * GetDerivedEntity() {return DerivedEntity;}
	InteractiveEntity * GetBrotherEntity() {return BrotherEntity;}
	void SetBrotherEntity(InteractiveEntity * brother);
	void SetDerivedEntity(InteractiveEntity * derived);
	int SaveState(OutTokens&,CppListCmds);
	int CppList(OutTokens&,CppListCmds,UserEntity *);
	int IsInMenus() {return DoCreate !=0;}
	void DeleteAll();
	int IsClassMember(const char * ClassName);
	void ClearNets();
} ;

 
class InteractiveEntityList: public SingleList {
	const char * BaseClassName ;
public:
	ErrCode Insert(InteractiveEntity *nt) {return SingleList::Insert(nt);}
	ErrCode Append(InteractiveEntity *nt) {return SingleList::Append(nt);}
	class InteractiveEntity * Get()
		{return (InteractiveEntity *) SingleList::Get();}
	InteractiveEntityList(const char * Name):
		SingleList(){BaseClassName= Name;}
	void Display();
	int Size(){return SingleList::Size();}
	void Describe(OutTokens&,ListEntity);
	int CppList(OutTokens&);
	void Dump(OutTokens&,ValueTypeList*Lst=0);
	void Create();
	void Delete();
	void DeleteAll();
	InteractiveEntity * Find(const char * name) ;
	InteractiveEntity * GetInteractiveEntity(OutTokens&) ;
	ValueType * FindObj(const char * name);
	UserEntity * GetObject(const char * Name);
	ValueType * FindTypeObj(const char * name) ;
	const char * GetBaseClassName() { return BaseClassName;}
	InteractiveEntity * FindObjEnt(const char * name) ;
	int SaveState(OutTokens&,CppListCmds);
} ;


class InteractiveEntityIterator: public SingleListIterator {
public:
	InteractiveEntityIterator(InteractiveEntityList&df):
		SingleListIterator((SingleList&)df){}
	InteractiveEntity * operator()()
		{return (InteractiveEntity *) Next();}
};

void InteractiveInit() ;

class SimpleUserObject {
	const char * TypeName ;
	const char * Name ;
	class ArrayData * Array ;
	ValueType Value ;
	int no_cpp_dump:1 ;
public:
	SimpleUserObject(const char * Typ,const char * Nm, ValueType Val,
		ArrayData * array = 0, int no_dump=0):no_cpp_dump(no_dump)
		{TypeName=Typ; Name=Nm; Value=Val; Array= array;}
	SimpleUserObject(const char * Typ,const char * Nm,
		ArrayData * array = 0)
		{TypeName=Typ; Name=Nm; Array = array ;}
	void SetName(const char * nm) {Name=nm;}
	const char * GetName() {return Name ; }
	const char * GetTypeName() {return TypeName ; }
	ValueType * GetValue() { return &Value ; }
	void SetValue (ValueType Val) {Value = Val ; }
	int CppList(OutTokens&) ;
	void Dump(OutTokens&,class ValueTypeList* Lst=0) ;
	inline void Describe(OutTokens& Out,ListEntity Opt) ;
	int32 GetArraySize() ;
	ArrayData * GetArray();
	void SetArray(ArrayData * array);
	void Delete();
	int Remove();
} ;

class SimpleUserObjectList: public SingleList {
public:
	ErrCode Insert(SimpleUserObject *nt) {return SingleList::Insert(nt);}
	ErrCode Append(SimpleUserObject *nt) {return SingleList::Append(nt);}
	class SimpleUserObject * Get()
		{return (SimpleUserObject *) SingleList::Get();}
	SimpleUserObjectList(){;}
	SimpleUserObjectList(SimpleUserObject *nt):
		SingleList(nt) {}
	void Display();
	int Size() {return SingleList::Size();}
	void Create(const char * name);
	void Delete(const char * name);
	SimpleUserObject * GetSimpleUserObject(const char * name);
	DataValue * GetDataValue(char * name) ;
	int CppList(OutTokens& Out) ;
	void Dump(OutTokens&,ValueTypeList *Lst=0) ;
	void Describe(OutTokens&,ListEntity) ;
	int Remove(const char * Name);
	int Remove(SimpleUserObject * Obj);
} ;



class SimpleUserObjectIterator: public SingleListIterator {
public:
	SimpleUserObjectIterator(SimpleUserObjectList& df):
		SingleListIterator((SingleList&) df){}
	SimpleUserObject * operator()()
		{return (SimpleUserObject *) Next();}
};

class UserBasicObjects {
	const char * TypeName ;
	StringList * AliasList ;
	DecType Type ;
	SimpleUserObjectList * Objects ;
	ValueType ThisType ;
public:
	UserBasicObjects(const char *Name, ValueType,DecType) ;
	void ObjectAppend(SimpleUserObject * Obj) {Objects->Append(Obj);}
	void AliasAppend(char * name) {AliasList->Append(name);}
	StringList * GetAliasList() {return AliasList; }
	const char * GetTypeName() {return TypeName ; }
	ValueType * GetValueType() { return &ThisType ; }
	ValueType * Find (const char * name) ;
	ValueType * FindObj(const char * name) ;
	DecType GetType() {return Type;}
	int CppList(OutTokens&);
	void Dump(OutTokens&,ValueTypeList*Lst=0) ;
	void Describe(OutTokens&,ListEntity) ;
	int Remove(const char * Name);
	int Remove(SimpleUserObject * Obj);
} ;


class InteractiveGlobal {
	InteractiveEntityList ** AllEntities ;
			// array of interactive classes
			// terminated with a null pointer
	UserBasicObjects ** AllBasicObjs ;
			// array of descriptions of basic objects
			// like double and int
	char ** CReservedWords ;
public:
	InteractiveGlobal(InteractiveEntityList**All,UserBasicObjects**Objs,
		char ** Res)
		 {AllEntities=All;AllBasicObjs = Objs; CReservedWords = Res;}
	ValueType * CheckDeclarator(const char * name) ;
		// returns actual declaration entry
	ValueType * CheckNewDeclaration(const char * name) ;
		// returns copy to be used on right hand side of statement
	ValueType * CheckDeclaration(const char * name) ;
	ValueType * GetType(const char * name) ;
	NameInUse CheckNameInUse(const char * name) ;
	char * make_valid_name(char * base); // will delete input if new name made
	char * make_valid_name(const char * base);
	int CppList(const char * name) ; // list a basic entity in C++ syntax
	void EntityList(ListEntity);
	void ListReservedWords(OutTokens& out);
	InteractiveEntityList * GetInteractiveEntityList(enum InteractiveType);
	InteractiveEntity * GetInteractiveEntity(const char * Name);
	InteractiveEntity * GetInteractiveEntityFromObj(const char * Name) ;
	void SaveState(const char *);
	int save_state_kernel(OutTokens& Out);
	int SaveState(OutTokens&,CppListCmds);
	
	UserEntity * GetObject(const char * Name);
	InteractiveEntityList ** GetAllEntities() const {return AllEntities;}
	int RemoveSimpleUserObject(SimpleUserObject *);
	int RemoveSimpleUserObject(const char *);
	UserBasicObjects ** GetUserBasicObjects() const {return AllBasicObjs;}
	void DeleteAll();
	int IsPrimaryEntity(const char * Name) const ;
	ValueType * find_obj(const char * name) const ;
} ;

class EntityList: public SingleList {
public:
	ErrCode Insert(UserEntity *nt) {return SingleList::Insert(nt);}
	ErrCode Append(UserEntity  *nt) {return SingleList::Append(nt);}
	UserEntity  * Get()   {return (UserEntity  *) SingleList::Get();}
	EntityList(){;}
	int Size(){return SingleList::Size();}
	void virtual Describe(OutTokens&,enum ListEntity) ;
	void Delete(const char * Name);
	void DeleteAll();
} ;

class EntityListIterator: public SingleListIterator {
public:
	EntityListIterator(EntityList& df):
		SingleListIterator((SingleList&) df){}
	UserEntity * operator()()
		{return (UserEntity *) Next();}
};

inline int UserBasicObjects::CppList(OutTokens& Out)
{
	return Objects->CppList(Out) ;
}

inline void SimpleUserObject::Describe(OutTokens& Out,ListEntity)
{
	CppList(Out);
}

extern InteractiveGlobal * AllEntityLists ;

extern InteractiveEntityList * TheNodes;
extern InteractiveEntityList * TheCmpdNodes ;
extern InteractiveEntityList * TheNets;
extern InteractiveEntityList * TheBuffers ;
extern InteractiveEntityList * TheSchedulers ;
extern InteractiveEntityList * TheProcedures ;
extern InteractiveEntityList * TheMiscellaneousClasses ;

extern const char * LegalEntityName(const char * Name) ;
extern const char * MakeNewEntityName(const char * Base,int32 Size) ;
extern const char * MakeNewEntityNameSuf(const char * Base,const char * Suf) ;
extern void Fout(OutTokens& Out, double value);
extern int CheckReserved(const char * name) ;
extern const char * SaveFileName ;

#endif /* #ifdef INTFC_DOT_H */

