/*
 *  mentyp.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef MENTYP_DOT_H
#define MENTYP_DOT_H
struct MenuType {
	unsigned Dynamic : 1 ; 		// Changed while executing
	unsigned MultiUse : 1 ;		// Init routines determine actions
	unsigned History : 1 ;		// Uses previous menu selections
					// to select action
	unsigned Select : 1 ;		// uses current menu selection to
					// select action
	unsigned Orphan : 1 ;		// Menu for portion of a base clase
					// that is dynamicaly integrated into
					// the menus for all derived classes
	void Clear(){Dynamic=0;MultiUse=0;History=0;Select=0;Orphan=0;}
	void SetDynamic() {Dynamic=1;}
	void SetMultiUse() {MultiUse=1;}
	void SetHistory() {History=1;}
	void SetSelect() {Select=1;}
	void SetOrphan() {Orphan=1;History=1;}
	int IsDynamic() const {return Dynamic;}
	int IsMultiUse() const {return MultiUse;}
	int IsHistory() const {return History;}
	int IsSelect() const {return Select;}
	int IsOrphan() const {return Orphan;}
} ;

#endif /* #ifdef MENTYP_DOT_H */
