/*
 *  dspcom.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// Main DSP processing driver
// All it needs to do a periodic Check Read
// If 10 checks in a row fail then it starts sleeping 1 second
// between each check.

#include <iostream.h>

#include "hrdarth.h"
#include "sysintfc.h"
#include "shared.h"
#include "remmen.h"
#include "remcom.h"
#include "cgidbg.h"
#include "usercom.h"

#include "grphio.h"
#include "yacintfc.h"

#include "dynmnu.h"
#include "meninit.h"

#include "intfccomd.h"
#include "interinit.h"

#include "dspcom.h"

extern void InitAllMenuRoutines() ;

static int InitProcessingFinished(int)
{
	// LogOut << "InitProcessingFinished.\n" ;
/*
 *	if (!State.IsPreviousError()) *Output + OutputCppEntry <<
 *		"Enter DSP++ statements:\n" ;
 *	LogOut << "After output.\n" ;
 */
	return 0;
}

void CheckReadAndSleep()
{
 	static int LocCommandActive = 0 ;
	// LogOut << "CheckReadAndSleep, LocCommandActive = "<<LocCommandActive<<"\n";
	if (!LocCommandActive) {
		InterfaceControl.SendPacket(InitProcessingFinished,
			ReadyForInitReadState);
		LocCommandActive = 1;
/*
 *		LogMsg("CommandMain called");
 *		CommandMain();
 *		// InterpretMenuCommand(DEF_LocCommandMain,0);
 *		LogMsg("CommandMain exited");
 *		LocCommandActive = 0 ;
 */
	}
 
	ReadSeg->ReadPacket();
}

void DspMain()
{
	GraphicsMode = 1;

	Output = new OutCon(RedirectCGI) ;

	Output->SetWindow(OutputPrompt) ;


	InitInteractiveEntities->DoInit();

	extern void PullInAll();
	PullInAll();
	InitAllMenuRoutines();

	State.SetInteractive();

	FindHomesForOrphanMenus();
	CommandMain() ;
}
