/*
 *  procnode.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef PROCNODE_DOT_H
#define PROCNODE_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class ProcessNode: public ProcessNodeStr {
	int16  proc_in_1;
	int16  proc_out_2;
	int32  procEltSz_3;
	int32  procNodeDelay_4;
	int32  procDeltaIn_5;
	int32  procDeltaOut_6;
	int32  procOverlap_7;
	int32  procDelayIn_8;
	int32  procEltSzOut_9;
	int32  procBlockSize_10;
	TimingType  procTheTimingType_11;
	ArithType::ArithCapabilities  procArithTypeIn_12;
	ArithType::ArithCapabilities  procArithTypeOut_13;
public:
	ProcessNode (const char * Name, int16 proc_in, int16 proc_out, 
		int32 procEltSz, int32 procNodeDelay, int32 procDeltaIn, 
		int32 procDeltaOut, int32 procOverlap, int32 procDelayIn, 
		int32 procEltSzOut, int32 procBlockSize, 
		TimingType procTheTimingType, 
		ArithType::ArithCapabilities procArithTypeIn, 
		ArithType::ArithCapabilities procArithTypeOut);
	virtual ~ProcessNode();
	int16 Getproc_in() const {return proc_in_1;}
	int16 Getproc_out() const {return proc_out_2;}
	int32 GetprocEltSz() const {return procEltSz_3;}
	int32 GetprocNodeDelay() const {return procNodeDelay_4;}
	int32 GetprocDeltaIn() const {return procDeltaIn_5;}
	int32 GetprocDeltaOut() const {return procDeltaOut_6;}
	int32 GetprocOverlap() const {return procOverlap_7;}
	int32 GetprocDelayIn() const {return procDelayIn_8;}
	int32 GetprocEltSzOut() const {return procEltSzOut_9;}
	int32 GetprocBlockSize() const {return procBlockSize_10;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_11;}
	ArithType::ArithCapabilities GetprocArithTypeIn() const {return procArithTypeIn_12;}
	ArithType::ArithCapabilities GetprocArithTypeOut() const {return procArithTypeOut_13;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef PROCNODE_DOT_H */
