/*
 *  plotnd.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef PLOTND_DOT_H
#define PLOTND_DOT_H
#include "ObjProGui/plotndrm.h"
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/dsplstr.h"

class PlotNode: public DisplayNodeStr {
#line 24 "../plotnd.usr"
 
	RemoteSetupState SetupState ;
	int PlotId ;
	void RemoteSetup(RemoteSetupState Goal = RemoteSetupDone) ;
	MachWord ** X_DataBufPtrs ;
	int16 ** DataBufPtrs ;
	int * NextWordInBuf ;
	int HeaderComplete ;
	int Channels ;
	int PrescaleFlag ;
	class DataPlotHeader * PlotDesc ;
	class AxisScalingY * ChannelScale ;
	virtual void NewSampleRate() ;
	void AllocateBuffers();
#line 37 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/plotnd.h"
	int16  In_1;
	StreamStr* StreamIn_2;
	int16  ScaleFlag_3;
	TimingType  TheTimingType_4;
public:
	PlotNode (const char * Name, int16 In, StreamStr*StreamIn, int16 ScaleFlag, 
		TimingType TheTimingType);
	virtual ~PlotNode();
	int16 GetIn() const {return In_1;}
	StreamStr*GetStreamIn() const {return StreamIn_2;}
	int16 GetScaleFlag() const {return ScaleFlag_3;}
	TimingType GetTheTimingType() const {return TheTimingType_4;}
	virtual int CheckSafeDelete() ;
#line 39 "../plotnd.usr"
	int GetPlotId() {return PlotId;}
	void SetPlotId(int Id) {PlotId = Id;SetupState = RemoteSetupIdRec;}
	void CheckRemoteSetup() ;
	virtual void SendHeader() ;
	void WriteDataWord(MachWord Word,int Channel = 0);
	void WriteDataWord(CxMachWord Word,int Channel = 0);
	void WriteDataPacket();
	void X_CheckBuffer(int Channel) ;
	void X_WriteBuffer(int Channel) ;
	void CheckBuffer(int Channel) ;
	void WriteBuffer(int Channel) ;
	void SendComplete() {HeaderComplete=1;}
	void SetDataPlot(DataPlotHeader * desc) {PlotDesc = desc;}
	DataPlotHeader * GetDataPlot(){return PlotDesc;}
#line 66 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/plotnd.h"
};


#endif /* #ifdef PLOTND_DOT_H */
