/*
 *  add.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef ADD_DOT_H
#define ADD_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class Add: public ProcessNodeStr {
#line 82 "../add.usr"
 
	int32 element_size ;
	int32 block_size ;
#line 24 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/add.h"
	int32  NumberOfOverflows;
	int16  Channels_1;
	int16  ElementSize_2;
	double  Scale_3;
public:
	Add (const char * Name, int16 Channels, int16 ElementSize, double Scale);
	virtual ~Add();
	int16 GetChannels() const {return Channels_1;}
	int16 GetElementSize() const {return ElementSize_2;}
	double GetScale() const {return Scale_3;}
	virtual int CheckSafeDelete() ;
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetScale(double  Scale) { Scale_3 = Scale; parameter_changed(); }
};

extern Add * AddDef;


#endif /* #ifdef ADD_DOT_H */
