/*
 *  slist.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include "portable.h"
#include "slist.h"
#include "errcode.h"

Entity SingleList::GetFirst()
{
	if (Last) if (Last->Next) return (Last->Next)->Entry ;
	return 0;
}

Entity SingleList::GetLast()
{
	if (Last) return Last->Entry ;
	return 0 ;
}

ErrCode SingleList::Insert(Entity a)
{
	if (Last)  Last->Next = new SingleLink(a,Last->Next) ;
	else {
		Last = new SingleLink(a,0);
		Last->Next = Last ;
	}
	return OK;
}

ErrCode SingleList::Append(Entity a)
{
	if (Last) Last = Last->Next = new SingleLink(a,Last->Next) ;
	else {
		Last = new SingleLink(a,0);
		Last->Next = Last ;
	}
	return OK;
}

Entity SingleList::Pop()
{
	if (Last == 0) return 0 ;
	SingleLink * Previous = Last->Next ;
	if (Previous == Last) {
		Entity Return = Previous->Entry ;
		delete Last ;
		Previous = Last = 0;
		return Return ;
	}
	while (Previous->Next != Last) Previous = Previous->Next ;
	Previous->Next = Last->Next ;
	Entity Return = Last->Entry ;
	delete Last ;
	Last = Previous ;
	return Return ;
}

Entity SingleList::Get()
{
	if (Last == 0) return 0;
	SingleLink * First = Last->Next ;
	Entity Return = First->Entry ;
	if (First == Last) Last = 0;
	else Last->Next = First->Next ;
	delete First ;
	return Return ;
}

void SingleList::Clear()
{
	SingleLink * link = Last ;
	if (!link) return ;
	do {
		SingleLink * l = link ;
		link = link->Next ;
		// LogOut << "Clear Deleting " << (void *)  l << "\n" ;
		if (l) delete l ;
	} while (link!= Last) ;
	Last = 0 ;
}


int SingleList::Size() const
{
	SingleListIterator Iter(*this);
	int Sz = 0;
	while (Iter.Next()) Sz++;
	return Sz;
}

ErrCode SingleList::RemoveEntry (Entity Entry)
{
	SingleListIterator Iter(*this);
	if (!Last) return Warning ;
	SingleLink * Previous = Last ;
	Entity Ent;
	while(Ent = Iter.Next()) if (Ent == Entry) {
		SingleLink * Save = Previous->Next ;
		Previous->Next = Iter.CurrentEntry->Next ;
		if (Last == Save) Last = Previous ;
		if (Last == Save) Last = 0;
		delete Save ;
		return OK ;
	} else Previous = Previous->Next ;
	return Warning ;
}
		


Entity SingleListIterator::Next()
{
	SingleLink * Link ;
	if (!CurrentList) return 0;
	if (!CurrentList->Last) return 0;
	if ( !CurrentEntry )
		Link = CurrentEntry = CurrentList->Last->Next ;
			// Last->Next is First in list
	else {
		CurrentEntry = CurrentEntry->Next ;
		Link = (CurrentEntry == CurrentList->Last->Next) ?
			0 : CurrentEntry ;
	}
	return Link ? Link->Entry : 0 ;
}


ErrCode ConstSingleList::Insert(ConstEntity a)
{
	if (Last)  Last->Next = new ConstSingleLink(a,Last->Next) ;
	else {
		Last = new ConstSingleLink(a,0);
		Last->Next = Last ;
	}
	return OK;
}

ErrCode ConstSingleList::Append(ConstEntity a)
{
	if (Last) Last = Last->Next = new ConstSingleLink(a,Last->Next) ;
	else {
		Last = new ConstSingleLink(a,0);
		Last->Next = Last ;
	}
	return OK;
}


ConstEntity ConstSingleList::Pop()
{
	if (Last == 0) return 0 ;
	ConstSingleLink * Previous = Last->Next ;
	if (Previous == Last) {
		ConstEntity Return = Last->Entry ;
		delete Last ;
		Last = 0;
		return Return ;
	}
	while (Previous->Next != Last) Previous = Previous->Next ;
	Previous->Next = Last->Next ;
	ConstEntity Return = Last->Entry ;
	delete Last ;
	Last = Previous ;
	return Return ;
}


ConstEntity ConstSingleList::Get()
{
	if (Last == 0) return 0;
	ConstSingleLink * First = Last->Next ;
	ConstEntity Return = First->Entry ;
	if (First == Last) Last = 0 ;
	else Last->Next = First->Next ;
	delete First ;
	return Return ;
}

void ConstSingleList::Clear()
{
	ConstSingleLink * link = Last ;
	if (!link) return ;
	do {
		ConstSingleLink * l = link ;
		link = link->Next ;
		// LogOut << "Const Clear Deleting " << (void *)  l << "\n" ;
		if (l) delete l ;
	} while (link!= Last) ;
	Last = 0 ;
}

int ConstSingleList::Size() const
{
	ConstSingleListIterator Iter(*this);
	int Sz = 0;
	while (Iter.Next()) Sz++;
	return Sz;
}


ConstEntity ConstSingleListIterator::Next()
{
	ConstSingleLink * Link ;
	if (!CurrentList) return 0;
	if (!CurrentList->Last) return 0;
	if ( !CurrentEntry )
		Link = CurrentEntry = CurrentList->Last->Next ;
			// Last->Next is First in list
	else {
		CurrentEntry = CurrentEntry->Next ;
		Link = (CurrentEntry == CurrentList->Last->Next) ?
			0 : CurrentEntry ;
	}
	return Link ? Link->Entry : 0 ;
}

int ConstStringList::IsInList(const char * Check)
{
	ConstStringListIterator Next(*this);
	const char * Entry ;
	while (Entry = Next()) if(!strcmp(Entry,Check)) return 1;
	return 0;
}

int StringList::IsInList(const char * Check)
{
	StringListIterator Next(*this);
	const char * Entry ;
	while (Entry = Next()) if(!strcmp(Entry,Check)) return 1;
	return 0;
}

ErrCode SingleList::Append(SingleList * lst)
{
	Entity ent ;
	ErrCode Check ;
	while (ent = lst->Get()) 
		if ((Check = Append(ent)) != OK) return Check ;
	delete lst ;
	return OK ;
}

ErrCode ConstSingleList::Append(ConstSingleList * lst)
{
	ConstEntity ent ;
	ErrCode Check ;
	while (ent = lst->Get()) 
		if ((Check = Append(ent)) != OK) return Check ;
	delete lst ;
	return OK ;
}


