/*
 *  plotfile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef PLOTFILE_DOT_H
#define PLOTFILE_DOT_H
class DataPlot;
class PlotWindow;
class DataPlotHeader ;
class PacketHeader ;
class PlotFileManager {
	int OutFile ;
	int OutChannels ;
	int OutChannelSize ;

	int InFile ;
	int InChannels ;
	long InChannelSize ;
	int InPlotId ;

	int GetPlotId() ;	// dummy always returns 0 
	int WritePrologue(DataPlot& ThePlot) ;
	int ReadPrologue() ;
	int ReadPacket(PacketHeader& Head, char * Data) ;
	int WritePacket(PacketHeader& Head, const char * Data) ;
	int WriteChannelHeader(int Channel,DataPlot * PlotHead) ;
	int ReadHeader() ;
	int WritePlotData(DataPlot& ThePlot) ;
	int ReadPlotData() ;
	int Write(const char * Data, int Size) ;
	void ReadError();
	int Read(char * Data, int Size) ;
public:
	PlotFileManager();
	int WritePlot(const char * FileName, DataPlot& ThePlot);
	void ReadPlot(const char * FileName);
	void CompleteReadPlot() ;
	int ReadingPlotFile() {return InFile > 0 ;}
	int WritingPlotFile() {return OutFile > 0 ;}
};

extern PlotFileManager ThePlotFileManager ;

#endif /* #ifdef PLOTFILE_DOT_H */
