/*
 *  helpd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "help.h"
#include "shared.h"
#include "usercom.h"
#include "remcom.h"
#include "debug.h"


void HelpControl::SetHelpLevel(HelpLevel NewLevel)
{
	if (NewLevel < HelpLevelNone || NewLevel > HelpLevelAll) 
		DbgError("HelpControl::HelpServer","bad level");
	Level = NewLevel ;
}

static void Err(const char * Where)
{
	DbgError("HelpControl::",Where,"called on dsp side");
}

void HelpControl::DescribeMenuAction(const char ** )
{
	Err("DescribeMenuAction");
}

void HelpControl::AutoDescribeMenuAction(const char ** )
{
	Err("AutoDescribeMenuAction");
}

void HelpControl::DisplayHelpFile(const char * )
{
	Err("DisplayHelpFile");
}


void HelpControl::HelpServer(PacketHeader& Head,const char * Data)
{
	int NewLevel = Head.GetPlotChannel() ;
			// only using 16 bits remaining 16 can be used
			// for other purposes
	SetHelpLevel((HelpLevel) NewLevel);
} 

