/*
 *  dylistc.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include "ObjProUsr/dylist.h"
#include <complex.h>
#include <stream.h>
#include "ObjProArith/hrdarth.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSPcom/disphnd.h"
#include "ObjProDSPcom/glistker.h"
#ifdef INTERACTIVE
#include "ObjProDSPcom/disphnd.h"
#include "ObjProGui/timing.h"
#include "ObjProGen/newaloc.h"
#include "ObjProComGui/dyntext.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProShare/shared.h"
#include "ObjProGui/remcom.h"
#include "ObjProGui/tarparm.h"
#include "ObjProGui/dyntextd.h"
#include "ObjProGen/mkstr.h"
DfNode * Listing::target_replacement(const char * target)
{
	// LogOut << "Listing::target_replacement(" << target << ")\n" ;
	if (!strcmp(target,generic_cpp_name)) return 0 ;
	return default_output_replacement(target);
}
#endif

void Listing::ConstructorKernel()
{
	DisplayHandle = 0 ;
	WindowId = 0 ;
	FirstTime = 1 ;
#ifdef INTERACTIVE
	already_set = 0 ;
#endif
}

void Listing::SetupRemote()
{
#ifdef INTERACTIVE
	const char * ListCaption = 0 ;
	char * to_delete = 0 ;
	if (GetCaption()) ListCaption = GetCaption();
	else {
		DfNode * driver_node = GetDriverNode();
		ListCaption = to_delete = Concatenate(GetName(),"_list_of_",
			driver_node->GetName());
	}
	GetWindowHandle(DisplayHandle,GetName(),ListCaption);
	delete to_delete ;
#endif
}



#ifdef INTERACTIVE
void Listing::input_linked(int chan)
{
    // after one channel is linked set all other channels to be
    // identical
    if (already_set) return;
    already_set = 1 ;
    ArithType::ArithCapabilities typ = ArithType::ArithTypeUndefined ;
    for (int i = 0 ; i < GetIn() ; i++) {
        typ = GetInStream(i)->GetArithType();
        if (typ != ArithType::ArithCapabilityAny) break ;
    }
    if (typ ==  ArithType::ArithTypeUndefined) {
        State.Error("no arithmetic type set, cannot link node");
        return ;
    }
    
    for (i = 0 ; i < GetIn() ; i++)  GetInStream(i)->SetArithType(typ) ;
    set_read_integer_flag(integer_read_flag) ;
}

void Listing::NewSampleRate()
{
/*
 *	LogOut << "Listing::NewSampleRate called for `" << GetName()
 *		<< ", Handle = " << DisplayHandle << "'\n" ;
 */
	SampleRate = GetInLink(0)->GetTiming()->SampleRate ;
	// LogOut << "SampleRate = " << SampleRate << "\n" ;
	if (SampleRate < 1.e-10) SampleRate = 0.0 ;
	if (!DisplayHandle) return ;
	if (!TheDynamicTextController->CheckWindowOpen(DisplayHandle)) return;
	int Length = sizeof(double);
	char * Buf = new char[Length];
	MoveNBytes(Buf, (char *) &(SampleRate), Length);
	PacketHeader Head = PlotPacketHeader(PacketWindowTextControl,
		TextControlNewSampleRate,DisplayHandle,Length);
	WriteSeg->WritePacket(Head,Buf);
	delete Buf ;
/*
 *	LogOut << "Sent new sample rate " << SampleRate <<
 *			" for node `" << GetName() << "'.\n"  ;
 */
}
#endif

ErrCode Listing::Kernel(int32 k)
{
	if (FirstTime) {
#ifdef INTERACTIVE
		SetupRemote();
		while (!DisplayHandle)
			TheDynamicTextController->CheckForPacket();
		TheDynamicTextController->OpenWindowAndWait(DisplayHandle,
			&WindowId);
		NewSampleRate();
#endif
		FirstTime = 0;
		TheGenericKernel = new GenericList(*this,DisplayHandle,
			GetHex(),integer_read_flag);
	}
	return TheGenericKernel->List(k);
}
