# include	"sptree.h"

char *
spstats(q)
SPTREE *q;
{
# if INTERNAL_STATS != 0
	static char buf[128];
	long llen;
	long elen;
	long sloops;
#endif

	if (q == NULL)
		return "";
# if INTERNAL_STATS == 0
	return "";
# else
	llen = q->lookups ? (100 * q->lkpcmps) / q->lookups : 0;
	elen = q->enqs ? (100 * q->enqcmps)/q->enqs : 0;
	sloops = q->splays ? (100 * q->splayloops)/q->splays : 0;

	sprintf(buf, 
"Lookups(%ld %ld.%02ld) Insertions(%ld %ld.%02ld) Splays(%ld %ld.%02ld)",
		q->lookups, llen / 100,  llen % 100,
		q->enqs, elen / 100,  elen % 100,
		q->splays, sloops / 100, sloops % 100);

	return buf;
# endif
}

