/*
 *  amutil.h -- utility headers for rtree code
 *
 *	$Header: /private/postgres/src/lib/H/access/RCS/amutil.h,v 1.6 1992/03/05 00:39:41 hong Exp $
 */

/* DISK I/O IS ALL DONE FROM BUFMGR.C */


#include "storage/bufmgr.h"
#include "storage/itemptr.h"

/* utilities for writing and retrieving data from postgres buffers */

/*#define  GET_HEAP_TID(ITUP)		(&(ITUP)->t_tid)*/
/*ItemPointerData   temp2 = {3,56,456}*/
#define  GET_HEAP_TID(ITUP)		(temp2)


	
#define FillTid(itup, tid)	ItemPointerCopy(tid, &(itup)->t_tid)

/*---------------------*/

struct nodetid {
	int	blocknum,
		pageoff;
	};

typedef	struct nodetid	NodeTid;

struct	logical_page_struct{	/* the info. that getting a page returns */
	NodeTid	tid;
	char   *bs;
	int		pinned;
	int		locked;
	char	*pt;	/* pointer to start of page if pinned */
	};

typedef struct logical_page_struct	*LPage;

char	*LPage_Pin_Data();
void 	LPage_UnPin_Data();

#define	PIN_PAGE_DATA(page)		(LPage_Pin_Data(page))
#define	UNPIN_PAGE_DATA(page)		(LPage_UnPin_Data(page))
#define	PAGE_TID(page)		((page)->tid)

typedef	int	freespace; /* the offset to start of freespace in a buffer, */
			        /* stored at the head of the buffer.	*/

/* Definition of the root nodetid of a tree */
static	NodeTid	Root_Tid = {0, sizeof(freespace)};

#define	ROOT_TID	Root_Tid

#define ABOVEROOT	((int)0x00ffffff)


#define ABOVE_ROOT(tid)	(tid.pageoff == ABOVEROOT)

#define	max(a,b)	((a) < (b) ? (b) : (a))
#define	min(a,b)	((b) < (a) ? (b) : (a))

	
LPage GetPage();
LPage GetNewPage();
void FlushBuffers();
void InitBuffers();
