/*
 * buf_sync.h --
 *	Buffer synchronization modes and routines.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/storage/RCS/buf_sync.h,v 1.8 1990/08/18 00:40:37 cimarron Exp $
 */

#ifndef	BufSyncIncluded
#define	BufSyncIncluded

#include "ipci.h"
#ifndef sequent
#include <sys/sem.h>
#include <sys/shm.h>
#else
#include "/usr/att/usr/include/sys/sem.h"
#include "/usr/att/usr/include/sys/shm.h"
#endif

#include <stdio.h>
#include <sys/file.h>

#include "tmp/postgres.h"

#define BM_PIN             0x01

#define BM_SEM_INIT        255
#define BM_SEM_LOCK        (-255)

#define LT_SharedLock	    (-1)

#define PLT_LockStartValue  255
#define PLT_ExclusiveLock   (-255)
#define PLT_SharedLock	    (-1)

#define LT_SemKey   	    	274
#define LT_TransactionSemKey	275

/* the following manipulation modes are allowed	on a transaction    */
/*   semaphore	    	    	    	    	    	    	    */
typedef     int	    SemManipulationMode;  
#define	    PLT_SemUnlock   1
#define	    PLT_SemLock	    2
    	    	    	    	    	
/**************************************************
  externally callable functions go here :
 **************************************************/

extern void CreateBufferSemaphore();
extern void CreateBufferPoolMemory();
extern void InitSharedBuffers();
extern void InitBufferSemaphore();
extern void InitBufferPoolMemory();
extern void AttachSharedBuffers();
extern void ImmediateReleaseBufSem();	/* XXX A hack to force release! */

#endif /* !BufSyncIncluded */
