/*
 * Testing of new binary portal interface.
 * 
 * Do the following at the monitor:
 *

 create test1 (i1 = int4, i2 = int2, d = float4,p = polygon) \g
 append test1 (i1 = 7, d=3.567,p="(1.0,2.0,3.0,4.0)"::polygon) \g
 append test1 (i1 = 7, i2 = 3, d=3.567,p="(1.0,2.0,3.0,4.0)"::polygon) \g

 -- Anything else you can think of. 
 * Start up this program.
 * The correct contents of test1 should be printed
 *
 *	$Header: /private/postgres/test/RCS/iportal1.c,v 1.3 1992/07/29 18:23:39 clarsen Exp $
 */

#include "tmp/simplelists.h"
#include "tmp/libpq.h"
#include "utils/geo-decls.h"

void main()
{
    extern int PQAsyncNotifyWaiting;
    PQNotifyList *l;
    PortalBuffer *portalbuf;
    char *res;
    int ngroups,tupno, grpno, ntups, nflds;
    PQsetdb(getenv("USER"));

    PQexec("begin");
    res = (char *)PQexec("retrieve iportal junk (test1.all)");
    if (*res == 'E') {
	fprintf(stderr,"%s\nfailed",++res);
	goto exit_error;
    }
    res = (char *)PQexec("fetch all in junk");
    if (*res != 'P') {
	fprintf(stderr,"\nno portal");
	goto exit_error;
    }
    /* get tuples in relation */
    portalbuf = PQparray(++res);
    ngroups = PQngroups(portalbuf);
    for (grpno = 0; grpno < ngroups; grpno++) {
	ntups = PQntuplesGroup(portalbuf, grpno);
	if ((nflds = PQnfieldsGroup(portalbuf, grpno)) != 4) {
	    fprintf(stderr, "expected 4 attributes, got %d\n", nflds);
	    goto exit_error;
	}
	for (tupno = 0; tupno < ntups; tupno++) {
	    int *bla1;
	    char *bla2;
	    POLYGON *bla3;
	    int16 *bla4;
	    bla1 = (int *)PQgetvalue(portalbuf,tupno,0);
	    bla4 = PQgetvalue(portalbuf,tupno,1);
	    bla2 = PQgetvalue(portalbuf,tupno,2);
	    bla3 = PQgetvalue(portalbuf,tupno,3)-4;

	    printf ("got i1=%d(%d bytes), i2=%d(%d bytes), d=(%f)(%d bytes)|%x|%x|%x|%x\n\
 Polygon(%d bytes)\
  %d points (%f,%f,%f,%f)\n",
		    *bla1,PQgetlength(portalbuf,tupno,0),
		    *bla4,PQgetlength(portalbuf,tupno,1),
		    *((float *)bla2),
		    PQgetlength(portalbuf,tupno,2),
		    *bla2,*(bla2+1),*(bla2+2),*(bla2+3),
		    PQgetlength(portalbuf,tupno,3),
		    bla3->npts,
		    bla3->boundbox.xh,bla3->boundbox.yh,
		    bla3->boundbox.xl,bla3->boundbox.yl);
	}
    }

    PQexec("end");
    PQfinish();
    exit(0);
  exit_error:
    PQexec("end");
    PQfinish();
    exit(1);

}
