/****/
/*	version: $Id: dis_filename.c,v 5.47 1994/10/05 00:59:22 hitman Exp $ */
/* 	purpose: displays a file to the screen. */
/*	updates: All updates are handled by RCS */
/* 	Author: The Hitman 1994	*/
/****/

#include <stdio.h>
#include <stdlib.h>

#define LINESIZE 100

int
display_file (char const *filename)
{
  char line[LINESIZE];
  FILE *fp1;

#if DEBUG
  fprintf (stderr, "** %s: getting ready to open %s **\n", __FILE__, filename);
#endif
  /** Read a file and write it up on the screen one line at a time **/
  /* Open the file for read-only */
  if ((fp1 = fopen (filename, "r")) == NULL)
    {
#if DEBUG
      fprintf (stderr, "** %s: Something went wrong **\n", __FILE__);
#endif
      return (1);
    }
  while (fgets (line, LINESIZE - 1, fp1) != NULL)
    {
#if DEBUG
	fprintf (stderr, "** %s: Should be printing it out **\n", __FILE__);
#endif
      fprintf (stdout, "%s", line);
    }
#if DEBUG
      fprintf (stderr, "** %s: Everything went ok, at end of file now **\n", __FILE__);
#endif
  return (0);
}
