/****/
/*	version: $Id: check_speed.c,v 5.47 1994/10/05 00:59:22 hitman Exp $ */
/* 	purpose: Checks for the lock out speed and acts accordingly */
/*	updates: All updates are handled by RCS */
/* 	Author: The Hitman 1994	*/
/****/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "version.h"

#ifndef __MSDOS__
#	include "bbs_director.h"
#else /* not_MSDOS */
#	include "..\src\bbs_dire.h"
#endif /* MSDOS */

int
check_speed (void)
{
#ifndef __MSDOS__ /* msdos doesn't like this */
  FILE *in, *popen ();
  int speed = 0;

#	if DEBUG
  fprintf (stderr, "** %s: **\n", __FILE__);
#	endif
  /** Check for the lockout speed **/
  /** This really should read the speed from the users terminal */
  /*	device, actually use some of the functions in term.h */
  /*	this way the terminal mode can be setup and the speed */
  /* 	can be read quicker and more accurate. **/
  in = popen ("stty speed", "r");

  /** Check for and error with this popen thing **/
  if (in == (FILE *) NULL)
    {
      fprintf (stderr, "popen failed\n");
      exit (EXIT_FAILURE);
    }

  /** Get the output from the above and put it in the speed variable **/
  fscanf (in, "%d", &speed);

  /** The lockout speeds are hard coded for now but later we can */
  /*	read an system data file. **/
  switch (speed)
    {
    case 300:
    case 1200:
    case 2400:
      fprintf (stdout, "Sorry your speed is locked out of the BBS due to\n");
      fprintf (stdout, "Ansi Graphics in the menus...\n");
      fprintf (stdout, "--------< Also this is a beta project >------\n");
      exit (EXIT_FAILURE);
      break;
	}				/* switch */
#else /* not_MSDOS  */
	fprintf (stdout, "MSDOS Version, NO LINE SPEED CHECKING");
#endif /* MSDOS */
  return (EXIT_SUCCESS);
}				/* check_speed */
