#!/bin/sh
#
# [$Id: compile_all_menus.sh,v 5.123 1995/01/18 01:27:07 hitman Exp $]
# purpose: Create all menus from one command.  This also handles a few permissions changes.
MENU_DIR=menu
MENU_COMPILER=menu_edit
BBS_DIR="../.."

# Before anything check to make sure the two above variables work.
echo "Checking enviroment: "
if [ -f $BBS_DIR/$MENU_COMPILER ]; then
	echo "	$MENU_COMPILER...check"
else
	echo "	$MENU_COMPILER...missing!"
	echo ""
	echo "MENU_COMPILER=$MENU_COMPILER is mis-defined, or not compiled."
	echo ""
	exit 1
fi # check_for_compiler #
if [ -d $BBS_DIR/$MENU_DIR ]; then
	echo "	$MENU_DIR...check"
else
	echo "	$MENU_DIR...missing!"
	echo ""
	echo "MENU_DIR=$MENU_DIR is mis-defined, or not installed."
	echo ""
	exit 1
fi # check_for_menu_dir #
echo ""

# move to menu directory
CURR=`pwd`
cd $BBS_DIR

# make menus; catch problems if people use RCS to track changes on menus.
for MENU in `ls $MENU_DIR | awk -F. '{ print $1 }' | grep -v RCS`
do
	MENU_DATA=$MENU.dat

#	Make sure I can write to the menu data files.
	if [ -f $MENU_DATA ]; then
		chmod 644 $MENU_DATA
	fi # if_file_change #

#	Compile the menus
	$MENU_COMPILER -q $MENU

#	These are read-only, so make them that way
	chmod 444 $MENU.dat
done # compile_menus #

# go back to original directory
cd $CURR
