/*
version: $Id: interpre.c,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: Interpretes commands from the user, for the shell.  This program
	switches from a bypass to a non-bypass if the command cannot be found.
updates: All updates are handled by RCS
*/

#include <stdio.h>

#ifndef __MSDOS__
#	include <strings.h>
#	include "hsh_glob.h"
#	include "hshgen_s.h"
#else				/* NOT_msdos */
#	include <string.h>
#	include "..\src\hsh_glob.h"
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */

/** The switch for displaying help **/
#define HELP_DISP 2332

/* Define functions and procedures.                                 */
int             interprete(_character * Character);

int
interprete(_character * Character)
{
	/** The structure for the commands that the user will enter **/
	struct command
	{
		char           *name;
		int             index;
		char           *summary;
	};

#ifdef ENGLISH
	/** The official commands for the users to run and execute. **/
	struct command  dispatch[] =
	{
		{"quit", GOODBYE, "Quit the game and exit."},
		{"help", HELP_DISP, "Display help information."},
		{"clear", REDRAW_SCREEN, "Clear and redraw the screen."},
		{"show", SHELL_DISPLAY, "Show version information about game."},
		{"menu", DISPLAY_MENU, "Show the menu again."},
	};			/* dispatch[] */
#elif FRENCH			/* ENGLISH */
	/** The official commands for the users to run and execute. **/
	struct command  dispatch[] =
	{
		{"quit?", GOODBYE, "Quit the game and exit."},
		{"aider", HELP_DISP, "Montrer aider information(?)."},
		{"clear?", REDRAW_SCREEN, "Clear and redraw the screen."},
		{"montrer", SHELL_DISPLAY, "Montrer version information about game."},
		{"menu?", DISPLAY_MENU, "Show the menu again."},
	};			/* dispatch[] */
#endif				/* FRENCH */

	/** Define the size of each part of the commands. This is*/
	/* the total number of commands in the list also. * */
	int             numcmds = sizeof(dispatch) / sizeof(struct command);
	int             cnt;

#ifdef DEBUG
	/** I want to see what this function gets as in information **/
	fprintf(stderr, "** %s: **\n", __FILE__);
	fprintf(stderr, "** %s: Character->input_string = %s **\n", __FILE__, Character->input_string);
#endif				/* DEBUG */


	/* move through command stack and find out what they are talking
	   about this searches as far as the length of the command the user
	   enters. */
#ifdef DEBUG
	fprintf(stderr, "** %s: numcmds = %d **\n", __FILE__, numcmds);
#endif				/* DEBUG */
	for (cnt = 0; cnt < numcmds; ++cnt)
	{
		if (strncmp(Character->input_string, dispatch[cnt].name, strlen(Character->input_string)) == 0)
		{
#ifdef DEBUG
			fprintf(stderr, "** %s: Found a match! **\n", __FILE__);
			fprintf(stderr, "** %s: dispatch[%d].index = %d **\n",
				__FILE__, cnt, dispatch[cnt].index);
#endif
			/* Since the function has found a match set the
			   bypass as yes. Allow direct access to the
			   functions in the main, allow direct calls and
			   references(bypass 3calls). */
			Character->bypass = YES;
			/** Determine if user wants to see a help while the variables*/
			/* are local.  * */
			switch (dispatch[cnt].index)
			{
			case HELP_DISP:	/* display help for user */
				/** Display the commands first **/
				printf("\n");
#ifdef ENGLISH
				printf("Commands:");
#elif FRENCH			/* ENGLISH */
				printf("Commander:");
#endif				/* FRENCH */
				printf("\n\n");

				/** print out the commands from the commands list **/
				for (cnt = 0; cnt < numcmds; ++cnt)
				{
					printf("%s - %s\n", dispatch[cnt].name, dispatch[cnt].summary);
				}
				printf("\n");

				/** the for more information note **/
#ifdef ENGLISH
				printf("For more information send email to the support address listed below:\n\n");
#endif				/* ENGLISH */
				/* My current email address, this maybe needs
				   to be a make thing. */
				printf("\t%s\n\n", SUPPORT_ADDRESS);

				/* Jump out of everything and return */
				return (SHOW_PROMPT);
				break;	/* HELP_DISP */

			default:	/* if they don't want help go a head
					   and return */
				/* to the next function. * */
				/** Set the activity switch so the next function knows */
				/* what it is doing. * */
				Character->Activity = dispatch[cnt].index;
#ifdef DEBUG
				fprintf(stderr, "** %s: Case Default **\n", __FILE__);
				fprintf(stderr, "** %s: Character->Activity = %d **\n", __FILE__, Character->Activity);
#endif				/* DEBUG */
				/* before this returns I need to make sure
				   this is going to go to something in the
				   above menu if not I need to get it to
				   return normal. */
				return (dispatch[cnt].index);
				break;	/* default */
			}	/* switch */
		}		/* if */
	}			/* for */
/* since the command could not be found, just move on maybe another function will
need the information obtained. */
#ifdef DEBUG
	fprintf(stderr, "** %s: Command could not be found in tables **\n", __FILE__);
#endif				/* DEBUG */
	/* Since the program didn't find a command set the bypass to no and
	   do the next command in the state table */
	Character->bypass = NO;

/* this will either return to a prompt or return to more interpreters, this
is all up to the state table, fancy programming isn't it... */
	return (RET_NORMAL);
}				/* interpre.c */
