/*
version:  [$Id: get_menu_info.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose:  This program get information about the menu and returns it. This
	function get the menuname and the line number wanted, then returns just
	that menu option.
updates:  All updates are handled by RCS
Author:  The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>
#ifndef __MSDOS__
#	include <strings.h>
#endif				/* not_MSDOS */

#ifndef __MSDOS__
#	include "bbs_director.h"
#	include "menu_info.h"
#else				/* not_MSDOS */
#	include "..\src\bbs_dire.h"
#	include "..\src\menu_inf.h"
#endif				/* MSDOS */
#include "version.h"


MENU_struct     get_menu_info(char *Currmenu, int LineNumber);

MENU_struct 
get_menu_info(char *Currmenu, int LineNumber)
{
	MENU_struct     menu[MAXLINES];	/* I am the menu option from the
					   program */

	/* Work on a portable method of recording the size of the
	   MENU_structure without messing anything up.  This size should be
	   the same for every system, and always allow the read of the
	   datafiles.  So far you have to recompile you menus for a 16bit,
	   32bit, and 64bit machines.  All 16bit machine menus match, and
	   32bits the same.  */
	int             size = sizeof(MENU_struct);

	int             cnt = 0;
	int             count = 0;

	FILE           *data_file = NULL;

	char            filename[MAXLENGTH] = {0};

/* define some external functions. */
	extern char    *menu_data_filename(const char *);

	/* Create the first menu as the main.menu.  This is the first menu. */
#if DEBUG
	fprintf(stderr, "** %s: Lets read the first menu **\n", __FILE__);
#endif				/* DEBUG */

	/* Get the argument and give it to a variable, point to it then add
	   the rest of the items needed. */
	strcpy(filename, menu_data_filename((char *) Currmenu));	/* Set down the filename */


	/* This is a binary file that will be READ_ONLY.  No writes will come
	   to this file under this program. */
#if DEBUG
	fprintf(stderr, "** %s: filename = %s, Currmenu = %s **\n", __FILE__, filename, Currmenu);
#endif				/* DEBUG  */
	if ((data_file = fopen(filename, "rb")) == NULL)
	{
		/* one day put in some error handleing. */
		fprintf(stderr, "%s: %s(%d): %s: Need read permission\n", PROGRAM, __FILE__, __LINE__, filename);
		exit(EXIT_FAILURE);
	}			/* if_menu_not_readable */

	/* Make sure the file is at the beginning */
	fseek(data_file, 0, SEEK_SET);


	/* Pad the entire block of variables with end of string characters to
	   initialize everything */
#if DEBUG
	fprintf(stderr, "** %s: Initializing the variables with end of string **\n", __FILE__);
#endif				/* DEBUG */
	for (cnt = 0; cnt < MAXLINES; cnt++)
	{
		menu[cnt].index = (int) '\0';
		menu[cnt].keyword[0] = '\0';
		menu[cnt].description[0] = '\0';
		menu[cnt].information[0] = '\0';
		menu[cnt].other[0] = '\0';
	}			/* for_clean_out_menu */


#if DEBUG
	/* header for the below menu showing */
	fprintf(stderr, "** %s: The menu as follows: **\n", __FILE__);
#endif				/* DEBUG */
	/* REad the menu into memory. */
	/* set the count to zero to prevent reading where I left off */
	count = 0;

/* this next section just gets the total number of parts to this file,
basicaly the count of the sizeof, or number of records */
	while (count < MAXLINES && fread(&menu[count], size, 1, data_file) == 1)
	{
		/* I could put something really fancy in here but it would go
		   so fast that you wouldn't get a chance to see it.
		   Increment that thing. */
		count++;
	}			/* while_debuging_print */

	rewind(data_file);	/* rewind the data file when done */
	/*** This seems to be the end of getting the menu information ***/


#if DEBUG
	/* yes the menu[].index is a integer, but it is being used as a
	   character.  */
	count = 0;		/* start back at the begining */
	while (count < MAXLINES && fread(&menu[count], size, 1, data_file) == 1)
	{
		fprintf(stderr, "** %s: menu[%d].index = %c,\n", __FILE__, count, menu[count].index);
		fprintf(stderr, "\tmenu[%d].keyword = %s, menu[%d].description = %s  **\n", count, menu[count].keyword, count, menu[count].description);
		count++;	/* increment to the next position. */
	}			/* while_debugging_print_menu */


	/* mention of the files closing */
	fprintf(stderr, "** %s: closing data file next **\n", __FILE__);

#endif				/* DEBUG */
	fclose(data_file);

	/* end of reading menu ----------------------- */

	/* return the menu information to the other function */
#if DEBUG
	fprintf(stderr, "** %s: sizeof (menu) = %d **\n", __FILE__, sizeof(menu));
#endif				/* DEBUG */
	return (menu[LineNumber]);
}				/* get_menu_info */
