/*
version: $Id: control.h,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: The header file that defines the external functions for the main state functions.
updates: All updates are handled by RCS
*/

#ifndef __MSDOS__
#	include "hshgen_s.h"
#else /* not_MSDOS */
#	include "..\src\bbs_fn-s\hshgen_s.h"
#endif /* MSDOS */

#ifndef __CONTROL_H
#define __CONTROL_H

/****************************************************************/
/* External functions and procedures.                           */
/****************************************************************/
/* Below is for calls to function states.  The first column is  */
/* the funtions name and the second column is alway sequencal   */
/* numbers from 1..last_state.                                  */
#define SHELL_DISPLAY           1                /* System Jobs. */
extern int shell_display(_character *Character);
#define SHOW_PROMPT             2
extern int show_prompt(_character *Character);
#define LOGIN                   3
extern int login(_character *Character);
#define INTERPRETE              4
extern int interprete(_character *Character);
#define GET_COMMAND             5               /* Executing commands.                  */
extern int get_command(_character *Character);
#define GOODBYE                 6               /* Say goodbye */
extern int goodbye(_character *Character);
#define ERROR_HANDLE            7               /* What to do with errors!              */
extern int error_handle(_character *Character);
#define REDRAW_SCREEN           8
extern int redraw_screen(_character *Character);
#define DISPLAY_MENU			9		/* display the menu for the user */
extern int display_menu (_character *Character);
#define DISPLAY_BBS_VERSION		10
extern int display_bbs_version (_character *Character);
#define CHECK_SPEED				11
extern int check_speed (_character *Character);
#define SET_UP_ENV				12
extern int set_up_env (_character *Character);
#define IS_BBS_RUNNING			13
extern int is_bbs_running (_character *Character);
#define DISPLAY_SCREEN			14
extern int display_screen (_character *Character);
#define INTERP_FROM_MENU		15 	/* find commands from menu */
extern int interp_from_menu (_character *Character);
#define COMMAND_NOT_FOUND		16 	/* tell the user the commands are not found */
extern int command_not_found (_character *Character);

#endif /* __CONTROL_H */
