/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import java.beans.*;

/** This class holds preferences on default autohiding behaviour.
 *
 * @see AutoHideButtonPanel
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 */
public class AutoHidePolicy {

  /** A constant for expanding a button on rollover */
  public static final int EXPAND_ON_ROLLOVER = 0;

  /** A constant for expanding a button on click */
  public static final int EXPAND_ON_CLICK = 1;

  /** a constant designing the bound property DEFAULT_HIDE_BORDER */
  public static final String PROPERTY_DEFAULT_HIDE_BORDER = "defaultHideBorder";
  /** a constant designing the bound property DEFAULT_GAP */
  public static final String PROPERTY_DEFAULT_GAP = "defaultGap";

  /** a constant designing the bound property EXPAND_MODE */
  public static final String PROPERTY_EXPAND_MODE = "expandMode";

  /** a constant designing the bound property ROLLOVER_TRIGGER_DELAY */
  public static final String PROPERTY_ROLLOVER_TRIGGER_DELAY = "rolloverTriggerDelay";

  /** a constant designing the bound property EXPANSION_DURATION */
  public static final String PROPERTY_EXPANSION_DURATION = "expansionDuration";


  private static AutoHidePolicy policy = new AutoHidePolicy();

  /** where do we put the button at startup */
  private DockingConstants.Hide defaultHideBorder = DockingConstants.HIDE_LEFT;

  /** pixels between two buttons */
  private int defaultGap = 4;

  private int expandMode; // rollover / click
  private int rolloverTriggerDelay = 500; // wait before expansion (only for expandMode==ROLLOVER)
  private int expansionDuration = 300; // millis

  private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

  private AutoHidePolicy() {
  }

  /** Updates the default hide border.
   * <p>
   * Default is AutoHideExpandPanel.LEFT;
   *
   * @param defaultHideBorder values taken from DockingConstants.HIDE_TOP, HIDE_LEFT, HIDE_BOTTOM, HIDE_RIGHT
   * */
  public void setDefaultHideBorder(DockingConstants.Hide defaultHideBorder){
    DockingConstants.Hide old = this.defaultHideBorder;
    this.defaultHideBorder = defaultHideBorder;
    propertySupport.firePropertyChange(PROPERTY_DEFAULT_HIDE_BORDER, old, defaultHideBorder);
  }

  /** Returns the default hide border (used when not specified in a DockKey)*/
  public DockingConstants.Hide getDefaultHideBorder(){
    return defaultHideBorder;
  }

  /** Returns the default gap between border components */
  public int getDefaultGap(){
    return defaultGap;
  }

  /** Updates the gap (in pixels) between auto-hide buttons*/
  public void setDefaultGap(int gap){
    int old = this.defaultGap;
    this.defaultGap = gap;
    propertySupport.firePropertyChange(PROPERTY_DEFAULT_GAP, old, gap);
  }

  /** Returns the singleton instance of this class */
  public static AutoHidePolicy getPolicy(){
    return policy;
  }

  /** Returns the expand mode in use.
   *   @return EXPAND_ON_ROLLOVER or EXPAND_ON_CLICK
   * */
  public int getExpandMode(){
    return expandMode;
  }

  /** Updates the expand mode.
   * @param expandMode legal values are EXPAND_ON_ROLLOVER or EXPAND_ON_CLICK
   * */
  public void setExpandMode(int expandMode){
    int old = this.expandMode;
    this.expandMode = expandMode;
    propertySupport.firePropertyChange(PROPERTY_EXPAND_MODE, old, expandMode);
  }

  /** Returns the rollover trigger delay (in millis)
   *
   * */
  public int getRolloverTriggerDelay(){
    return rolloverTriggerDelay;
  }

  /** Updates the rollover trigger delay
   * @param delay  delay in millis before expanding a Dockable
   */
  public void setRolloverTriggerDelay(int delay){
    int old = this.rolloverTriggerDelay;
    this.rolloverTriggerDelay = delay;
    propertySupport.firePropertyChange(PROPERTY_ROLLOVER_TRIGGER_DELAY, old, delay);
  }

  /** Returns the expansion duration (in millis) */
  public int getExpansionDuration(){
    return expansionDuration;
  }

  /** Updates the expansion duration (time in millis) */
  public void setExpansionDuration(int millis){
    int old = expansionDuration;
    this.expansionDuration = millis;
    propertySupport.firePropertyChange(PROPERTY_EXPANSION_DURATION, old, millis);

  }

  /** Hook for property change notification */
  public void addPropertyChangeListener(PropertyChangeListener listener) {
    propertySupport.addPropertyChangeListener(listener);
  }

  /** Hook for property change notification */
  public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    propertySupport.addPropertyChangeListener(propertyName, listener);
  }

  /** Remove a property change notification */
  public void removePropertyChangeListener(PropertyChangeListener listener) {
    propertySupport.removePropertyChangeListener(listener);
  }

  /** Remove a property change notification */
  public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    propertySupport.removePropertyChangeListener(propertyName, listener);
  }



}
