/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */

package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitivebyte { 
  public int identifier;
  private byte byte0;
  private byte byte1;
  private byte byte2;
  private byte byte3;
  private byte byte4;
  private byte byte5;
  private byte byte6;
  private byte byte7;
  private static byte byte8;
  private transient byte byte9;
  private transient byte byte10;
  private transient byte byte11;
  private transient byte byte12;
  private transient byte byte13;
  private transient byte byte14;
  private final byte byte15 = 5;
  private volatile byte byte16;
  private volatile byte byte17;
  private volatile byte byte18;
  private volatile byte byte19;
  private volatile byte byte20;
  private volatile byte byte21;
  private volatile byte byte22;
  private volatile byte byte23;
  private static transient byte byte24;
  private static final byte byte25 = 5;
  private static volatile byte byte26;
  private transient final byte byte27 = 5;
  private transient volatile byte byte28;
  private transient volatile byte byte29;
  private transient volatile byte byte30;
  private transient volatile byte byte31;
  private transient volatile byte byte32;
  private transient volatile byte byte33;
  private static transient final byte byte34 = 5;
  private static transient volatile byte byte35;
  public byte byte36;
  public byte byte37;
  public byte byte38;
  public byte byte39;
  public byte byte40;
  public byte byte41;
  public byte byte42;
  public byte byte43;
  public static byte byte44;
  public transient byte byte45;
  public transient byte byte46;
  public transient byte byte47;
  public transient byte byte48;
  public transient byte byte49;
  public transient byte byte50;
  public final byte byte51 = 5;
  public volatile byte byte52;
  public volatile byte byte53;
  public volatile byte byte54;
  public volatile byte byte55;
  public volatile byte byte56;
  public volatile byte byte57;
  public volatile byte byte58;
  public volatile byte byte59;
  public static transient byte byte60;
  public static final byte byte61 = 5;
  public static volatile byte byte62;
  public transient final byte byte63 = 5;
  public transient volatile byte byte64;
  public transient volatile byte byte65;
  public transient volatile byte byte66;
  public transient volatile byte byte67;
  public transient volatile byte byte68;
  public transient volatile byte byte69;
  public static transient final byte byte70 = 5;
  public static transient volatile byte byte71;
  protected byte byte72;
  protected byte byte73;
  protected byte byte74;
  protected byte byte75;
  protected byte byte76;
  protected byte byte77;
  protected byte byte78;
  protected byte byte79;
  protected static byte byte80;
  protected transient byte byte81;
  protected transient byte byte82;
  protected transient byte byte83;
  protected transient byte byte84;
  protected transient byte byte85;
  protected transient byte byte86;
  protected final byte byte87 = 5;
  protected volatile byte byte88;
  protected volatile byte byte89;
  protected volatile byte byte90;
  protected volatile byte byte91;
  protected volatile byte byte92;
  protected volatile byte byte93;
  protected volatile byte byte94;
  protected volatile byte byte95;
  protected static transient byte byte96;
  protected static final byte byte97 = 5;
  protected static volatile byte byte98;
  protected transient final byte byte99 = 5;
  protected transient volatile byte byte100;
  protected transient volatile byte byte101;
  protected transient volatile byte byte102;
  protected transient volatile byte byte103;
  protected transient volatile byte byte104;
  protected transient volatile byte byte105;
  protected static transient final byte byte106 = 5;
  protected static transient volatile byte byte107;
  byte byte108;
  byte byte109;
  byte byte110;
  byte byte111;
  byte byte112;
  byte byte113;
  byte byte114;
  byte byte115;
  static byte byte116;
  transient byte byte117;
  transient byte byte118;
  transient byte byte119;
  transient byte byte120;
  transient byte byte121;
  transient byte byte122;
  final byte byte123 = 5;
  volatile byte byte124;
  volatile byte byte125;
  volatile byte byte126;
  volatile byte byte127;
  volatile byte byte128;
  volatile byte byte129;
  volatile byte byte130;
  volatile byte byte131;
  static transient byte byte132;
  static final byte byte133 = 5;
  static volatile byte byte134;
  transient final byte byte135 = 5;
  transient volatile byte byte136;
  transient volatile byte byte137;
  transient volatile byte byte138;
  transient volatile byte byte139;
  transient volatile byte byte140;
  transient volatile byte byte141;
  static transient final byte byte142 = 5;
  static transient volatile byte byte143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private byte byte0",
  "embedded= true   private byte byte1",
  "embedded= false   private byte byte2",
  "persistence-modifier= none    private byte byte3",
  "persistence-modifier= persistent    private byte byte4",
  "persistence-modifier= persistent  embedded= true   private byte byte5",
  "persistence-modifier= persistent  embedded= false   private byte byte6",
  "persistence-modifier= transactional    private byte byte7",
  "private static byte byte8",
  "private transient byte byte9",
  "persistence-modifier= none    private transient byte byte10",
  "persistence-modifier= persistent    private transient byte byte11",
  "persistence-modifier= persistent  embedded= true   private transient byte byte12",
  "persistence-modifier= persistent  embedded= false   private transient byte byte13",
  "persistence-modifier= transactional    private transient byte byte14",
  "private final byte byte15",
  "private volatile byte byte16",
  "embedded= true   private volatile byte byte17",
  "embedded= false   private volatile byte byte18",
  "persistence-modifier= none    private volatile byte byte19",
  "persistence-modifier= persistent    private volatile byte byte20",
  "persistence-modifier= persistent  embedded= true   private volatile byte byte21",
  "persistence-modifier= persistent  embedded= false   private volatile byte byte22",
  "persistence-modifier= transactional    private volatile byte byte23",
  "private static transient byte byte24",
  "private static final byte byte25",
  "private static volatile byte byte26",
  "private transient final byte byte27",
  "private transient volatile byte byte28",
  "persistence-modifier= none    private transient volatile byte byte29",
  "persistence-modifier= persistent    private transient volatile byte byte30",
  "persistence-modifier= persistent  embedded= true   private transient volatile byte byte31",
  "persistence-modifier= persistent  embedded= false   private transient volatile byte byte32",
  "persistence-modifier= transactional    private transient volatile byte byte33",
  "private static transient final byte byte34",
  "private static transient volatile byte byte35",
  "public byte byte36",
  "embedded= true   public byte byte37",
  "embedded= false   public byte byte38",
  "persistence-modifier= none    public byte byte39",
  "persistence-modifier= persistent    public byte byte40",
  "persistence-modifier= persistent  embedded= true   public byte byte41",
  "persistence-modifier= persistent  embedded= false   public byte byte42",
  "persistence-modifier= transactional    public byte byte43",
  "public static byte byte44",
  "public transient byte byte45",
  "persistence-modifier= none    public transient byte byte46",
  "persistence-modifier= persistent    public transient byte byte47",
  "persistence-modifier= persistent  embedded= true   public transient byte byte48",
  "persistence-modifier= persistent  embedded= false   public transient byte byte49",
  "persistence-modifier= transactional    public transient byte byte50",
  "public final byte byte51",
  "public volatile byte byte52",
  "embedded= true   public volatile byte byte53",
  "embedded= false   public volatile byte byte54",
  "persistence-modifier= none    public volatile byte byte55",
  "persistence-modifier= persistent    public volatile byte byte56",
  "persistence-modifier= persistent  embedded= true   public volatile byte byte57",
  "persistence-modifier= persistent  embedded= false   public volatile byte byte58",
  "persistence-modifier= transactional    public volatile byte byte59",
  "public static transient byte byte60",
  "public static final byte byte61",
  "public static volatile byte byte62",
  "public transient final byte byte63",
  "public transient volatile byte byte64",
  "persistence-modifier= none    public transient volatile byte byte65",
  "persistence-modifier= persistent    public transient volatile byte byte66",
  "persistence-modifier= persistent  embedded= true   public transient volatile byte byte67",
  "persistence-modifier= persistent  embedded= false   public transient volatile byte byte68",
  "persistence-modifier= transactional    public transient volatile byte byte69",
  "public static transient final byte byte70",
  "public static transient volatile byte byte71",
  "protected byte byte72",
  "embedded= true   protected byte byte73",
  "embedded= false   protected byte byte74",
  "persistence-modifier= none    protected byte byte75",
  "persistence-modifier= persistent    protected byte byte76",
  "persistence-modifier= persistent  embedded= true   protected byte byte77",
  "persistence-modifier= persistent  embedded= false   protected byte byte78",
  "persistence-modifier= transactional    protected byte byte79",
  "protected static byte byte80",
  "protected transient byte byte81",
  "persistence-modifier= none    protected transient byte byte82",
  "persistence-modifier= persistent    protected transient byte byte83",
  "persistence-modifier= persistent  embedded= true   protected transient byte byte84",
  "persistence-modifier= persistent  embedded= false   protected transient byte byte85",
  "persistence-modifier= transactional    protected transient byte byte86",
  "protected final byte byte87",
  "protected volatile byte byte88",
  "embedded= true   protected volatile byte byte89",
  "embedded= false   protected volatile byte byte90",
  "persistence-modifier= none    protected volatile byte byte91",
  "persistence-modifier= persistent    protected volatile byte byte92",
  "persistence-modifier= persistent  embedded= true   protected volatile byte byte93",
  "persistence-modifier= persistent  embedded= false   protected volatile byte byte94",
  "persistence-modifier= transactional    protected volatile byte byte95",
  "protected static transient byte byte96",
  "protected static final byte byte97",
  "protected static volatile byte byte98",
  "protected transient final byte byte99",
  "protected transient volatile byte byte100",
  "persistence-modifier= none    protected transient volatile byte byte101",
  "persistence-modifier= persistent    protected transient volatile byte byte102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile byte byte103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile byte byte104",
  "persistence-modifier= transactional    protected transient volatile byte byte105",
  "protected static transient final byte byte106",
  "protected static transient volatile byte byte107",
  "byte byte108",
  "embedded= true   byte byte109",
  "embedded= false   byte byte110",
  "persistence-modifier= none    byte byte111",
  "persistence-modifier= persistent    byte byte112",
  "persistence-modifier= persistent  embedded= true   byte byte113",
  "persistence-modifier= persistent  embedded= false   byte byte114",
  "persistence-modifier= transactional    byte byte115",
  "static byte byte116",
  "transient byte byte117",
  "persistence-modifier= none    transient byte byte118",
  "persistence-modifier= persistent    transient byte byte119",
  "persistence-modifier= persistent  embedded= true   transient byte byte120",
  "persistence-modifier= persistent  embedded= false   transient byte byte121",
  "persistence-modifier= transactional    transient byte byte122",
  "final byte byte123",
  "volatile byte byte124",
  "embedded= true   volatile byte byte125",
  "embedded= false   volatile byte byte126",
  "persistence-modifier= none    volatile byte byte127",
  "persistence-modifier= persistent    volatile byte byte128",
  "persistence-modifier= persistent  embedded= true   volatile byte byte129",
  "persistence-modifier= persistent  embedded= false   volatile byte byte130",
  "persistence-modifier= transactional    volatile byte byte131",
  "static transient byte byte132",
  "static final byte byte133",
  "static volatile byte byte134",
  "transient final byte byte135",
  "transient volatile byte byte136",
  "persistence-modifier= none    transient volatile byte byte137",
  "persistence-modifier= persistent    transient volatile byte byte138",
  "persistence-modifier= persistent  embedded= true   transient volatile byte byte139",
  "persistence-modifier= persistent  embedded= false   transient volatile byte byte140",
  "persistence-modifier= transactional    transient volatile byte byte141",
  "static transient final byte byte142",
  "static transient volatile byte byte143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public byte get(int index)
  {
    switch (index)
    {
      case(0):
        return byte0;
      case(1):
        return byte1;
      case(2):
        return byte2;
      case(3):
        return byte3;
      case(4):
        return byte4;
      case(5):
        return byte5;
      case(6):
        return byte6;
      case(7):
        return byte7;
      case(8):
        return byte8;
      case(9):
        return byte9;
      case(10):
        return byte10;
      case(11):
        return byte11;
      case(12):
        return byte12;
      case(13):
        return byte13;
      case(14):
        return byte14;
      case(15):
        return byte15;
      case(16):
        return byte16;
      case(17):
        return byte17;
      case(18):
        return byte18;
      case(19):
        return byte19;
      case(20):
        return byte20;
      case(21):
        return byte21;
      case(22):
        return byte22;
      case(23):
        return byte23;
      case(24):
        return byte24;
      case(25):
        return byte25;
      case(26):
        return byte26;
      case(27):
        return byte27;
      case(28):
        return byte28;
      case(29):
        return byte29;
      case(30):
        return byte30;
      case(31):
        return byte31;
      case(32):
        return byte32;
      case(33):
        return byte33;
      case(34):
        return byte34;
      case(35):
        return byte35;
      case(36):
        return byte36;
      case(37):
        return byte37;
      case(38):
        return byte38;
      case(39):
        return byte39;
      case(40):
        return byte40;
      case(41):
        return byte41;
      case(42):
        return byte42;
      case(43):
        return byte43;
      case(44):
        return byte44;
      case(45):
        return byte45;
      case(46):
        return byte46;
      case(47):
        return byte47;
      case(48):
        return byte48;
      case(49):
        return byte49;
      case(50):
        return byte50;
      case(51):
        return byte51;
      case(52):
        return byte52;
      case(53):
        return byte53;
      case(54):
        return byte54;
      case(55):
        return byte55;
      case(56):
        return byte56;
      case(57):
        return byte57;
      case(58):
        return byte58;
      case(59):
        return byte59;
      case(60):
        return byte60;
      case(61):
        return byte61;
      case(62):
        return byte62;
      case(63):
        return byte63;
      case(64):
        return byte64;
      case(65):
        return byte65;
      case(66):
        return byte66;
      case(67):
        return byte67;
      case(68):
        return byte68;
      case(69):
        return byte69;
      case(70):
        return byte70;
      case(71):
        return byte71;
      case(72):
        return byte72;
      case(73):
        return byte73;
      case(74):
        return byte74;
      case(75):
        return byte75;
      case(76):
        return byte76;
      case(77):
        return byte77;
      case(78):
        return byte78;
      case(79):
        return byte79;
      case(80):
        return byte80;
      case(81):
        return byte81;
      case(82):
        return byte82;
      case(83):
        return byte83;
      case(84):
        return byte84;
      case(85):
        return byte85;
      case(86):
        return byte86;
      case(87):
        return byte87;
      case(88):
        return byte88;
      case(89):
        return byte89;
      case(90):
        return byte90;
      case(91):
        return byte91;
      case(92):
        return byte92;
      case(93):
        return byte93;
      case(94):
        return byte94;
      case(95):
        return byte95;
      case(96):
        return byte96;
      case(97):
        return byte97;
      case(98):
        return byte98;
      case(99):
        return byte99;
      case(100):
        return byte100;
      case(101):
        return byte101;
      case(102):
        return byte102;
      case(103):
        return byte103;
      case(104):
        return byte104;
      case(105):
        return byte105;
      case(106):
        return byte106;
      case(107):
        return byte107;
      case(108):
        return byte108;
      case(109):
        return byte109;
      case(110):
        return byte110;
      case(111):
        return byte111;
      case(112):
        return byte112;
      case(113):
        return byte113;
      case(114):
        return byte114;
      case(115):
        return byte115;
      case(116):
        return byte116;
      case(117):
        return byte117;
      case(118):
        return byte118;
      case(119):
        return byte119;
      case(120):
        return byte120;
      case(121):
        return byte121;
      case(122):
        return byte122;
      case(123):
        return byte123;
      case(124):
        return byte124;
      case(125):
        return byte125;
      case(126):
        return byte126;
      case(127):
        return byte127;
      case(128):
        return byte128;
      case(129):
        return byte129;
      case(130):
        return byte130;
      case(131):
        return byte131;
      case(132):
        return byte132;
      case(133):
        return byte133;
      case(134):
        return byte134;
      case(135):
        return byte135;
      case(136):
        return byte136;
      case(137):
        return byte137;
      case(138):
        return byte138;
      case(139):
        return byte139;
      case(140):
        return byte140;
      case(141):
        return byte141;
      case(142):
        return byte142;
      case(143):
        return byte143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,byte value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        byte0= value;
         break;
      case(1):
        byte1= value;
         break;
      case(2):
        byte2= value;
         break;
      case(3):
        byte3= value;
         break;
      case(4):
        byte4= value;
         break;
      case(5):
        byte5= value;
         break;
      case(6):
        byte6= value;
         break;
      case(7):
        byte7= value;
         break;
      case(8):
        byte8= value;
         break;
      case(9):
        byte9= value;
         break;
      case(10):
        byte10= value;
         break;
      case(11):
        byte11= value;
         break;
      case(12):
        byte12= value;
         break;
      case(13):
        byte13= value;
         break;
      case(14):
        byte14= value;
         break;
      case(16):
        byte16= value;
         break;
      case(17):
        byte17= value;
         break;
      case(18):
        byte18= value;
         break;
      case(19):
        byte19= value;
         break;
      case(20):
        byte20= value;
         break;
      case(21):
        byte21= value;
         break;
      case(22):
        byte22= value;
         break;
      case(23):
        byte23= value;
         break;
      case(24):
        byte24= value;
         break;
      case(26):
        byte26= value;
         break;
      case(28):
        byte28= value;
         break;
      case(29):
        byte29= value;
         break;
      case(30):
        byte30= value;
         break;
      case(31):
        byte31= value;
         break;
      case(32):
        byte32= value;
         break;
      case(33):
        byte33= value;
         break;
      case(35):
        byte35= value;
         break;
      case(36):
        byte36= value;
         break;
      case(37):
        byte37= value;
         break;
      case(38):
        byte38= value;
         break;
      case(39):
        byte39= value;
         break;
      case(40):
        byte40= value;
         break;
      case(41):
        byte41= value;
         break;
      case(42):
        byte42= value;
         break;
      case(43):
        byte43= value;
         break;
      case(44):
        byte44= value;
         break;
      case(45):
        byte45= value;
         break;
      case(46):
        byte46= value;
         break;
      case(47):
        byte47= value;
         break;
      case(48):
        byte48= value;
         break;
      case(49):
        byte49= value;
         break;
      case(50):
        byte50= value;
         break;
      case(52):
        byte52= value;
         break;
      case(53):
        byte53= value;
         break;
      case(54):
        byte54= value;
         break;
      case(55):
        byte55= value;
         break;
      case(56):
        byte56= value;
         break;
      case(57):
        byte57= value;
         break;
      case(58):
        byte58= value;
         break;
      case(59):
        byte59= value;
         break;
      case(60):
        byte60= value;
         break;
      case(62):
        byte62= value;
         break;
      case(64):
        byte64= value;
         break;
      case(65):
        byte65= value;
         break;
      case(66):
        byte66= value;
         break;
      case(67):
        byte67= value;
         break;
      case(68):
        byte68= value;
         break;
      case(69):
        byte69= value;
         break;
      case(71):
        byte71= value;
         break;
      case(72):
        byte72= value;
         break;
      case(73):
        byte73= value;
         break;
      case(74):
        byte74= value;
         break;
      case(75):
        byte75= value;
         break;
      case(76):
        byte76= value;
         break;
      case(77):
        byte77= value;
         break;
      case(78):
        byte78= value;
         break;
      case(79):
        byte79= value;
         break;
      case(80):
        byte80= value;
         break;
      case(81):
        byte81= value;
         break;
      case(82):
        byte82= value;
         break;
      case(83):
        byte83= value;
         break;
      case(84):
        byte84= value;
         break;
      case(85):
        byte85= value;
         break;
      case(86):
        byte86= value;
         break;
      case(88):
        byte88= value;
         break;
      case(89):
        byte89= value;
         break;
      case(90):
        byte90= value;
         break;
      case(91):
        byte91= value;
         break;
      case(92):
        byte92= value;
         break;
      case(93):
        byte93= value;
         break;
      case(94):
        byte94= value;
         break;
      case(95):
        byte95= value;
         break;
      case(96):
        byte96= value;
         break;
      case(98):
        byte98= value;
         break;
      case(100):
        byte100= value;
         break;
      case(101):
        byte101= value;
         break;
      case(102):
        byte102= value;
         break;
      case(103):
        byte103= value;
         break;
      case(104):
        byte104= value;
         break;
      case(105):
        byte105= value;
         break;
      case(107):
        byte107= value;
         break;
      case(108):
        byte108= value;
         break;
      case(109):
        byte109= value;
         break;
      case(110):
        byte110= value;
         break;
      case(111):
        byte111= value;
         break;
      case(112):
        byte112= value;
         break;
      case(113):
        byte113= value;
         break;
      case(114):
        byte114= value;
         break;
      case(115):
        byte115= value;
         break;
      case(116):
        byte116= value;
         break;
      case(117):
        byte117= value;
         break;
      case(118):
        byte118= value;
         break;
      case(119):
        byte119= value;
         break;
      case(120):
        byte120= value;
         break;
      case(121):
        byte121= value;
         break;
      case(122):
        byte122= value;
         break;
      case(124):
        byte124= value;
         break;
      case(125):
        byte125= value;
         break;
      case(126):
        byte126= value;
         break;
      case(127):
        byte127= value;
         break;
      case(128):
        byte128= value;
         break;
      case(129):
        byte129= value;
         break;
      case(130):
        byte130= value;
         break;
      case(131):
        byte131= value;
         break;
      case(132):
        byte132= value;
         break;
      case(134):
        byte134= value;
         break;
      case(136):
        byte136= value;
         break;
      case(137):
        byte137= value;
         break;
      case(138):
        byte138= value;
         break;
      case(139):
        byte139= value;
         break;
      case(140):
        byte140= value;
         break;
      case(141):
        byte141= value;
         break;
      case(143):
        byte143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }
    }   
}
