/*
 *  @(#)JUnitTestInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.testserver.junit;


import net.sourceforge.groboutils.autodoc.v1.testserver.DefaultTestInfo;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;



/**
 * An implementation of TestInfo which is specific to JUnit.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:52:14 $
 */
public class JUnitTestInfo extends DefaultTestInfo
{
    
    
    /**
     * Constructor which defines a test-info object based on a Test instance.
     *
     * @param testObj the test for the TestInfo to describe.
     */
    public JUnitTestInfo( Object testObj )
    {
        if (testObj == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        setSuite( getSuiteName( testObj ) );
        setMethod( getMethodName( testObj ) );
    }
    
    
    /**
     * Discovers the name of the suite for the passed-in test object.
     *
     * @param testObj the test under inspection.
     * @return the name of the suite.
     */
    protected String getSuiteName( Object testObj )
    {
        String name;
        if (testObj instanceof TestSuite)
        {
            name = ((TestSuite)testObj).getName();
        }
        else
        if (testObj instanceof Class)
        {
            name = ((Class)testObj).getName();
        }
        else
        {
            name = testObj.getClass().getName();
        }
        return name;
    }
    
    
    /**
     * Discovers the name of the method for the passed-in test object.
     *
     * @param testObj the test under inspection.
     * @return the name of the test's test method.
     */
    protected String getMethodName( Object testObj )
    {
        String name;
        if (testObj instanceof TestCase)
        {
            name = ((TestCase)testObj).getName();
        }
        else
        {
            name = "run";
        }
        return name;
    }
}

