# The MIT License (MIT)
#
# Copyright (c) 2016 Adam Schubert
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import tests.TestCase as TestCase
from cron_descriptor import CasingTypeEnum, DescriptionTypeEnum, ExpressionDescriptor


class TestCasing(TestCase.TestCase):

    """
    Tests casing transformation
    """

    def test_sentence_casing(self):
        self.options.casing_type = CasingTypeEnum.Sentence
        ceh = ExpressionDescriptor("* * * * *", self.options)
        self.assertEqual(
            "Every minute",
            ceh.get_description(DescriptionTypeEnum.FULL))

    def test_title_casing(self):
        self.options.casing_type = CasingTypeEnum.Title
        ceh = ExpressionDescriptor("* * * * *", self.options)
        self.assertEqual(
            "Every Minute",
            ceh.get_description(DescriptionTypeEnum.FULL))

    def test_lower_casing(self):
        self.options.casing_type = CasingTypeEnum.LowerCase
        ceh = ExpressionDescriptor("* * * * *", self.options)
        self.assertEqual(
            "every minute",
            ceh.get_description(DescriptionTypeEnum.FULL))
