# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdvancedSettings(_model_base.Model):
    """Broker Advanced Settings.

    :ivar clients: Configurations related to All Clients.
    :vartype clients: ~azure.mgmt.iotoperations.models.ClientConfig
    :ivar encrypt_internal_traffic: The setting to enable or disable encryption of internal
     Traffic. Known values are: "Enabled" and "Disabled".
    :vartype encrypt_internal_traffic: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar internal_certs: Certificate rotation and private key configuration.
    :vartype internal_certs: ~azure.mgmt.iotoperations.models.CertManagerCertOptions
    """

    clients: Optional["_models.ClientConfig"] = rest_field()
    """Configurations related to All Clients."""
    encrypt_internal_traffic: Optional[Union[str, "_models.OperationalMode"]] = rest_field(
        name="encryptInternalTraffic"
    )
    """The setting to enable or disable encryption of internal Traffic. Known values are: \"Enabled\"
     and \"Disabled\"."""
    internal_certs: Optional["_models.CertManagerCertOptions"] = rest_field(name="internalCerts")
    """Certificate rotation and private key configuration."""

    @overload
    def __init__(
        self,
        *,
        clients: Optional["_models.ClientConfig"] = None,
        encrypt_internal_traffic: Optional[Union[str, "_models.OperationalMode"]] = None,
        internal_certs: Optional["_models.CertManagerCertOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthorizationConfig(_model_base.Model):
    """Broker AuthorizationConfig properties.

    :ivar cache: Enable caching of the authorization rules. Known values are: "Enabled" and
     "Disabled".
    :vartype cache: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar rules: The authorization rules to follow. If no rule is set, but Authorization Resource
     is used that would mean DenyAll.
    :vartype rules: list[~azure.mgmt.iotoperations.models.AuthorizationRule]
    """

    cache: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """Enable caching of the authorization rules. Known values are: \"Enabled\" and \"Disabled\"."""
    rules: Optional[List["_models.AuthorizationRule"]] = rest_field()
    """The authorization rules to follow. If no rule is set, but Authorization Resource is used that
     would mean DenyAll."""

    @overload
    def __init__(
        self,
        *,
        cache: Optional[Union[str, "_models.OperationalMode"]] = None,
        rules: Optional[List["_models.AuthorizationRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthorizationRule(_model_base.Model):
    """AuthorizationConfig Rule Properties.


    :ivar broker_resources: Give access to Broker methods and topics. Required.
    :vartype broker_resources: list[~azure.mgmt.iotoperations.models.BrokerResourceRule]
    :ivar principals: Give access to clients based on the following properties. Required.
    :vartype principals: ~azure.mgmt.iotoperations.models.PrincipalDefinition
    :ivar state_store_resources: Give access to state store resources.
    :vartype state_store_resources: list[~azure.mgmt.iotoperations.models.StateStoreResourceRule]
    """

    broker_resources: List["_models.BrokerResourceRule"] = rest_field(name="brokerResources")
    """Give access to Broker methods and topics. Required."""
    principals: "_models.PrincipalDefinition" = rest_field()
    """Give access to clients based on the following properties. Required."""
    state_store_resources: Optional[List["_models.StateStoreResourceRule"]] = rest_field(name="stateStoreResources")
    """Give access to state store resources."""

    @overload
    def __init__(
        self,
        *,
        broker_resources: List["_models.BrokerResourceRule"],
        principals: "_models.PrincipalDefinition",
        state_store_resources: Optional[List["_models.StateStoreResourceRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackendChain(_model_base.Model):
    """Desired properties of the backend instances of the broker.


    :ivar partitions: The desired number of physical backend partitions. Required.
    :vartype partitions: int
    :ivar redundancy_factor: The desired numbers of backend replicas (pods) in a physical
     partition. Required.
    :vartype redundancy_factor: int
    :ivar workers: Number of logical backend workers per replica (pod).
    :vartype workers: int
    """

    partitions: int = rest_field()
    """The desired number of physical backend partitions. Required."""
    redundancy_factor: int = rest_field(name="redundancyFactor")
    """The desired numbers of backend replicas (pods) in a physical partition. Required."""
    workers: Optional[int] = rest_field()
    """Number of logical backend workers per replica (pod)."""

    @overload
    def __init__(
        self,
        *,
        partitions: int,
        redundancy_factor: int,
        workers: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchingConfiguration(_model_base.Model):
    """Batching configuration.

    :ivar latency_seconds: Batching latency in seconds.
    :vartype latency_seconds: int
    :ivar max_messages: Maximum number of messages in a batch.
    :vartype max_messages: int
    """

    latency_seconds: Optional[int] = rest_field(name="latencySeconds")
    """Batching latency in seconds."""
    max_messages: Optional[int] = rest_field(name="maxMessages")
    """Maximum number of messages in a batch."""

    @overload
    def __init__(
        self,
        *,
        latency_seconds: Optional[int] = None,
        max_messages: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticationProperties(_model_base.Model):
    """BrokerAuthentication Resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar authentication_methods: Defines a set of Broker authentication methods to be used on
     ``BrokerListeners``. For each array element one authenticator type supported. Required.
    :vartype authentication_methods:
     list[~azure.mgmt.iotoperations.models.BrokerAuthenticatorMethods]
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    authentication_methods: List["_models.BrokerAuthenticatorMethods"] = rest_field(name="authenticationMethods")
    """Defines a set of Broker authentication methods to be used on ``BrokerListeners``. For each
     array element one authenticator type supported. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        authentication_methods: List["_models.BrokerAuthenticatorMethods"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    """


class BrokerAuthenticationResource(ProxyResource):
    """Instance broker authentication resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.BrokerAuthenticationProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.BrokerAuthenticationProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.BrokerAuthenticationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorCustomAuth(_model_base.Model):
    """Custom Authentication properties.


    :ivar x509: X509 Custom Auth type details. Required.
    :vartype x509: ~azure.mgmt.iotoperations.models.X509ManualCertificate
    """

    x509: "_models.X509ManualCertificate" = rest_field()
    """X509 Custom Auth type details. Required."""

    @overload
    def __init__(
        self,
        *,
        x509: "_models.X509ManualCertificate",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorMethodCustom(_model_base.Model):
    """Custom method for BrokerAuthentication.


    :ivar auth: Optional authentication needed for authenticating with the custom authentication
     server.
    :vartype auth: ~azure.mgmt.iotoperations.models.BrokerAuthenticatorCustomAuth
    :ivar ca_cert_config_map: Optional CA certificate for validating the custom authentication
     server's certificate.
    :vartype ca_cert_config_map: str
    :ivar endpoint: Endpoint of the custom authentication server. Must be an HTTPS endpoint.
     Required.
    :vartype endpoint: str
    :ivar headers: Additional HTTP headers to pass to the custom authentication server.
    :vartype headers: dict[str, str]
    """

    auth: Optional["_models.BrokerAuthenticatorCustomAuth"] = rest_field()
    """Optional authentication needed for authenticating with the custom authentication server."""
    ca_cert_config_map: Optional[str] = rest_field(name="caCertConfigMap")
    """Optional CA certificate for validating the custom authentication server's certificate."""
    endpoint: str = rest_field()
    """Endpoint of the custom authentication server. Must be an HTTPS endpoint. Required."""
    headers: Optional[Dict[str, str]] = rest_field()
    """Additional HTTP headers to pass to the custom authentication server."""

    @overload
    def __init__(
        self,
        *,
        endpoint: str,
        auth: Optional["_models.BrokerAuthenticatorCustomAuth"] = None,
        ca_cert_config_map: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorMethods(_model_base.Model):
    """Set of broker authentication policies. Only one method is supported for each entry.


    :ivar method: Custom authentication configuration. Required. Known values are: "Custom",
     "ServiceAccountToken", and "X509".
    :vartype method: str or ~azure.mgmt.iotoperations.models.BrokerAuthenticationMethod
    :ivar custom_settings: Custom authentication configuration.
    :vartype custom_settings: ~azure.mgmt.iotoperations.models.BrokerAuthenticatorMethodCustom
    :ivar service_account_token_settings: ServiceAccountToken authentication configuration.
    :vartype service_account_token_settings:
     ~azure.mgmt.iotoperations.models.BrokerAuthenticatorMethodSat
    :ivar x509_settings: X.509 authentication configuration.
    :vartype x509_settings: ~azure.mgmt.iotoperations.models.BrokerAuthenticatorMethodX509
    """

    method: Union[str, "_models.BrokerAuthenticationMethod"] = rest_field()
    """Custom authentication configuration. Required. Known values are: \"Custom\",
     \"ServiceAccountToken\", and \"X509\"."""
    custom_settings: Optional["_models.BrokerAuthenticatorMethodCustom"] = rest_field(name="customSettings")
    """Custom authentication configuration."""
    service_account_token_settings: Optional["_models.BrokerAuthenticatorMethodSat"] = rest_field(
        name="serviceAccountTokenSettings"
    )
    """ServiceAccountToken authentication configuration."""
    x509_settings: Optional["_models.BrokerAuthenticatorMethodX509"] = rest_field(name="x509Settings")
    """X.509 authentication configuration."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.BrokerAuthenticationMethod"],
        custom_settings: Optional["_models.BrokerAuthenticatorMethodCustom"] = None,
        service_account_token_settings: Optional["_models.BrokerAuthenticatorMethodSat"] = None,
        x509_settings: Optional["_models.BrokerAuthenticatorMethodX509"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorMethodSat(_model_base.Model):
    """Service Account Token for BrokerAuthentication.


    :ivar audiences: List of allowed audience. Required.
    :vartype audiences: list[str]
    """

    audiences: List[str] = rest_field()
    """List of allowed audience. Required."""

    @overload
    def __init__(
        self,
        *,
        audiences: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorMethodX509(_model_base.Model):
    """X509 for BrokerAuthentication.

    :ivar authorization_attributes: X509 authorization attributes properties.
    :vartype authorization_attributes: dict[str,
     ~azure.mgmt.iotoperations.models.BrokerAuthenticatorMethodX509Attributes]
    :ivar trusted_client_ca_cert: Name of the trusted client ca cert resource.
    :vartype trusted_client_ca_cert: str
    """

    authorization_attributes: Optional[Dict[str, "_models.BrokerAuthenticatorMethodX509Attributes"]] = rest_field(
        name="authorizationAttributes"
    )
    """X509 authorization attributes properties."""
    trusted_client_ca_cert: Optional[str] = rest_field(name="trustedClientCaCert")
    """Name of the trusted client ca cert resource."""

    @overload
    def __init__(
        self,
        *,
        authorization_attributes: Optional[Dict[str, "_models.BrokerAuthenticatorMethodX509Attributes"]] = None,
        trusted_client_ca_cert: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthenticatorMethodX509Attributes(_model_base.Model):
    """BrokerAuthenticatorMethodX509Attributes properties.


    :ivar attributes: Attributes object. Required.
    :vartype attributes: dict[str, str]
    :ivar subject: Subject of the X509 attribute. Required.
    :vartype subject: str
    """

    attributes: Dict[str, str] = rest_field()
    """Attributes object. Required."""
    subject: str = rest_field()
    """Subject of the X509 attribute. Required."""

    @overload
    def __init__(
        self,
        *,
        attributes: Dict[str, str],
        subject: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthorizationProperties(_model_base.Model):
    """BrokerAuthorization Resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar authorization_policies: The list of authorization policies supported by the Authorization
     Resource. Required.
    :vartype authorization_policies: ~azure.mgmt.iotoperations.models.AuthorizationConfig
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    authorization_policies: "_models.AuthorizationConfig" = rest_field(name="authorizationPolicies")
    """The list of authorization policies supported by the Authorization Resource. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        authorization_policies: "_models.AuthorizationConfig",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerAuthorizationResource(ProxyResource):
    """Instance broker authorizations resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.BrokerAuthorizationProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.BrokerAuthorizationProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.BrokerAuthorizationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerDiagnostics(_model_base.Model):
    """Broker Diagnostic Setting properties.

    :ivar logs: Diagnostic log settings for the resource.
    :vartype logs: ~azure.mgmt.iotoperations.models.DiagnosticsLogs
    :ivar metrics: The metrics settings for the resource.
    :vartype metrics: ~azure.mgmt.iotoperations.models.Metrics
    :ivar self_check: The self check properties.
    :vartype self_check: ~azure.mgmt.iotoperations.models.SelfCheck
    :ivar traces: The trace properties.
    :vartype traces: ~azure.mgmt.iotoperations.models.Traces
    """

    logs: Optional["_models.DiagnosticsLogs"] = rest_field()
    """Diagnostic log settings for the resource."""
    metrics: Optional["_models.Metrics"] = rest_field()
    """The metrics settings for the resource."""
    self_check: Optional["_models.SelfCheck"] = rest_field(name="selfCheck")
    """The self check properties."""
    traces: Optional["_models.Traces"] = rest_field()
    """The trace properties."""

    @overload
    def __init__(
        self,
        *,
        logs: Optional["_models.DiagnosticsLogs"] = None,
        metrics: Optional["_models.Metrics"] = None,
        self_check: Optional["_models.SelfCheck"] = None,
        traces: Optional["_models.Traces"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerListenerProperties(_model_base.Model):
    """Defines a Broker listener. A listener is a collection of ports on which the broker accepts
    connections from clients.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar service_name: Kubernetes Service name of this listener.
    :vartype service_name: str
    :ivar ports: Ports on which this listener accepts client connections. Required.
    :vartype ports: list[~azure.mgmt.iotoperations.models.ListenerPort]
    :ivar service_type: Kubernetes Service type of this listener. Known values are: "ClusterIp",
     "LoadBalancer", and "NodePort".
    :vartype service_type: str or ~azure.mgmt.iotoperations.models.ServiceType
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    service_name: Optional[str] = rest_field(name="serviceName")
    """Kubernetes Service name of this listener."""
    ports: List["_models.ListenerPort"] = rest_field()
    """Ports on which this listener accepts client connections. Required."""
    service_type: Optional[Union[str, "_models.ServiceType"]] = rest_field(name="serviceType")
    """Kubernetes Service type of this listener. Known values are: \"ClusterIp\", \"LoadBalancer\",
     and \"NodePort\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        ports: List["_models.ListenerPort"],
        service_name: Optional[str] = None,
        service_type: Optional[Union[str, "_models.ServiceType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerListenerResource(ProxyResource):
    """Instance broker resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.BrokerListenerProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.BrokerListenerProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.BrokerListenerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerProperties(_model_base.Model):
    """Broker Resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar advanced: Advanced settings of Broker.
    :vartype advanced: ~azure.mgmt.iotoperations.models.AdvancedSettings
    :ivar cardinality: The cardinality details of the broker.
    :vartype cardinality: ~azure.mgmt.iotoperations.models.Cardinality
    :ivar diagnostics: Spec defines the desired identities of Broker diagnostics settings.
    :vartype diagnostics: ~azure.mgmt.iotoperations.models.BrokerDiagnostics
    :ivar disk_backed_message_buffer: Settings of Disk Backed Message Buffer.
    :vartype disk_backed_message_buffer: ~azure.mgmt.iotoperations.models.DiskBackedMessageBuffer
    :ivar generate_resource_limits: This setting controls whether Kubernetes CPU resource limits
     are requested. Increasing the number of replicas or workers proportionally increases the amount
     of CPU resources requested. If this setting is enabled and there are insufficient CPU
     resources, an error will be emitted.
    :vartype generate_resource_limits: ~azure.mgmt.iotoperations.models.GenerateResourceLimits
    :ivar memory_profile: Memory profile of Broker. Known values are: "Tiny", "Low", "Medium", and
     "High".
    :vartype memory_profile: str or ~azure.mgmt.iotoperations.models.BrokerMemoryProfile
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    advanced: Optional["_models.AdvancedSettings"] = rest_field(visibility=["read", "create"])
    """Advanced settings of Broker."""
    cardinality: Optional["_models.Cardinality"] = rest_field(visibility=["read", "create"])
    """The cardinality details of the broker."""
    diagnostics: Optional["_models.BrokerDiagnostics"] = rest_field()
    """Spec defines the desired identities of Broker diagnostics settings."""
    disk_backed_message_buffer: Optional["_models.DiskBackedMessageBuffer"] = rest_field(
        name="diskBackedMessageBuffer", visibility=["read", "create"]
    )
    """Settings of Disk Backed Message Buffer."""
    generate_resource_limits: Optional["_models.GenerateResourceLimits"] = rest_field(
        name="generateResourceLimits", visibility=["read", "create"]
    )
    """This setting controls whether Kubernetes CPU resource limits are requested. Increasing the
     number of replicas or workers proportionally increases the amount of CPU resources requested.
     If this setting is enabled and there are insufficient CPU resources, an error will be emitted."""
    memory_profile: Optional[Union[str, "_models.BrokerMemoryProfile"]] = rest_field(
        name="memoryProfile", visibility=["read", "create"]
    )
    """Memory profile of Broker. Known values are: \"Tiny\", \"Low\", \"Medium\", and \"High\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        advanced: Optional["_models.AdvancedSettings"] = None,
        cardinality: Optional["_models.Cardinality"] = None,
        diagnostics: Optional["_models.BrokerDiagnostics"] = None,
        disk_backed_message_buffer: Optional["_models.DiskBackedMessageBuffer"] = None,
        generate_resource_limits: Optional["_models.GenerateResourceLimits"] = None,
        memory_profile: Optional[Union[str, "_models.BrokerMemoryProfile"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerResource(ProxyResource):
    """Instance broker resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.BrokerProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.BrokerProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.BrokerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrokerResourceRule(_model_base.Model):
    """Broker Resource Rule properties. This defines the objects that represent the actions or topics,
    such as - method.Connect, method.Publish, etc.


    :ivar method: Give access for a Broker method (i.e., Connect, Subscribe, or Publish). Required.
     Known values are: "Connect", "Publish", and "Subscribe".
    :vartype method: str or ~azure.mgmt.iotoperations.models.BrokerResourceDefinitionMethods
    :ivar client_ids: A list of client IDs that match the clients. The client IDs are
     case-sensitive and must match the client IDs provided by the clients during connection. This
     subfield may be set if the method is Connect.
    :vartype client_ids: list[str]
    :ivar topics: A list of topics or topic patterns that match the topics that the clients can
     publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
    :vartype topics: list[str]
    """

    method: Union[str, "_models.BrokerResourceDefinitionMethods"] = rest_field()
    """Give access for a Broker method (i.e., Connect, Subscribe, or Publish). Required. Known values
     are: \"Connect\", \"Publish\", and \"Subscribe\"."""
    client_ids: Optional[List[str]] = rest_field(name="clientIds")
    """A list of client IDs that match the clients. The client IDs are case-sensitive and must match
     the client IDs provided by the clients during connection. This subfield may be set if the
     method is Connect."""
    topics: Optional[List[str]] = rest_field()
    """A list of topics or topic patterns that match the topics that the clients can publish or
     subscribe to. This subfield is required if the method is Publish or Subscribe."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.BrokerResourceDefinitionMethods"],
        client_ids: Optional[List[str]] = None,
        topics: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Cardinality(_model_base.Model):
    """Cardinality properties.


    :ivar backend_chain: The backend broker desired properties. Required.
    :vartype backend_chain: ~azure.mgmt.iotoperations.models.BackendChain
    :ivar frontend: The frontend desired properties. Required.
    :vartype frontend: ~azure.mgmt.iotoperations.models.Frontend
    """

    backend_chain: "_models.BackendChain" = rest_field(name="backendChain")
    """The backend broker desired properties. Required."""
    frontend: "_models.Frontend" = rest_field()
    """The frontend desired properties. Required."""

    @overload
    def __init__(
        self,
        *,
        backend_chain: "_models.BackendChain",
        frontend: "_models.Frontend",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertManagerCertificateSpec(_model_base.Model):
    """Automatic TLS server certificate management with cert-manager.


    :ivar duration: Lifetime of certificate. Must be specified using a Go time.Duration format
     (h|m|s). E.g. 240h for 240 hours and 45m for 45 minutes.
    :vartype duration: str
    :ivar secret_name: Secret for storing server certificate. Any existing data will be
     overwritten. This is a reference to the secret through an identifying name, not the secret
     itself.
    :vartype secret_name: str
    :ivar renew_before: When to begin renewing certificate. Must be specified using a Go
     time.Duration format (h|m|s). E.g. 240h for 240 hours and 45m for 45 minutes.
    :vartype renew_before: str
    :ivar issuer_ref: cert-manager issuerRef. Required.
    :vartype issuer_ref: ~azure.mgmt.iotoperations.models.CertManagerIssuerRef
    :ivar private_key: Type of certificate private key.
    :vartype private_key: ~azure.mgmt.iotoperations.models.CertManagerPrivateKey
    :ivar san: Additional Subject Alternative Names (SANs) to include in the certificate.
    :vartype san: ~azure.mgmt.iotoperations.models.SanForCert
    """

    duration: Optional[str] = rest_field()
    """Lifetime of certificate. Must be specified using a Go time.Duration format (h|m|s). E.g. 240h
     for 240 hours and 45m for 45 minutes."""
    secret_name: Optional[str] = rest_field(name="secretName")
    """Secret for storing server certificate. Any existing data will be overwritten. This is a
     reference to the secret through an identifying name, not the secret itself."""
    renew_before: Optional[str] = rest_field(name="renewBefore")
    """When to begin renewing certificate. Must be specified using a Go time.Duration format (h|m|s).
     E.g. 240h for 240 hours and 45m for 45 minutes."""
    issuer_ref: "_models.CertManagerIssuerRef" = rest_field(name="issuerRef")
    """cert-manager issuerRef. Required."""
    private_key: Optional["_models.CertManagerPrivateKey"] = rest_field(name="privateKey")
    """Type of certificate private key."""
    san: Optional["_models.SanForCert"] = rest_field()
    """Additional Subject Alternative Names (SANs) to include in the certificate."""

    @overload
    def __init__(
        self,
        *,
        issuer_ref: "_models.CertManagerIssuerRef",
        duration: Optional[str] = None,
        secret_name: Optional[str] = None,
        renew_before: Optional[str] = None,
        private_key: Optional["_models.CertManagerPrivateKey"] = None,
        san: Optional["_models.SanForCert"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertManagerCertOptions(_model_base.Model):
    """Cert Manager Cert properties.


    :ivar duration: Lifetime of certificate. Must be specified using a Go time.Duration format
     (h|m|s). E.g. 240h for 240 hours and 45m for 45 minutes. Required.
    :vartype duration: str
    :ivar renew_before: When to begin renewing certificate. Must be specified using a Go
     time.Duration format (h|m|s). E.g. 240h for 240 hours and 45m for 45 minutes. Required.
    :vartype renew_before: str
    :ivar private_key: Configuration of certificate private key. Required.
    :vartype private_key: ~azure.mgmt.iotoperations.models.CertManagerPrivateKey
    """

    duration: str = rest_field()
    """Lifetime of certificate. Must be specified using a Go time.Duration format (h|m|s). E.g. 240h
     for 240 hours and 45m for 45 minutes. Required."""
    renew_before: str = rest_field(name="renewBefore")
    """When to begin renewing certificate. Must be specified using a Go time.Duration format (h|m|s).
     E.g. 240h for 240 hours and 45m for 45 minutes. Required."""
    private_key: "_models.CertManagerPrivateKey" = rest_field(name="privateKey")
    """Configuration of certificate private key. Required."""

    @overload
    def __init__(
        self,
        *,
        duration: str,
        renew_before: str,
        private_key: "_models.CertManagerPrivateKey",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertManagerIssuerRef(_model_base.Model):
    """Cert-Manager issuerRef properties.


    :ivar group: group of issuer. Required.
    :vartype group: str
    :ivar kind: kind of issuer (Issuer or ClusterIssuer). Required. Known values are: "Issuer" and
     "ClusterIssuer".
    :vartype kind: str or ~azure.mgmt.iotoperations.models.CertManagerIssuerKind
    :ivar name: name of issuer. Required.
    :vartype name: str
    """

    group: str = rest_field()
    """group of issuer. Required."""
    kind: Union[str, "_models.CertManagerIssuerKind"] = rest_field()
    """kind of issuer (Issuer or ClusterIssuer). Required. Known values are: \"Issuer\" and
     \"ClusterIssuer\"."""
    name: str = rest_field()
    """name of issuer. Required."""

    @overload
    def __init__(
        self,
        *,
        group: str,
        kind: Union[str, "_models.CertManagerIssuerKind"],
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CertManagerPrivateKey(_model_base.Model):
    """Cert Manager private key properties.


    :ivar algorithm: algorithm for private key. Required. Known values are: "Ec256", "Ec384",
     "Ec521", "Ed25519", "Rsa2048", "Rsa4096", and "Rsa8192".
    :vartype algorithm: str or ~azure.mgmt.iotoperations.models.PrivateKeyAlgorithm
    :ivar rotation_policy: cert-manager private key rotationPolicy. Required. Known values are:
     "Always" and "Never".
    :vartype rotation_policy: str or ~azure.mgmt.iotoperations.models.PrivateKeyRotationPolicy
    """

    algorithm: Union[str, "_models.PrivateKeyAlgorithm"] = rest_field()
    """algorithm for private key. Required. Known values are: \"Ec256\", \"Ec384\", \"Ec521\",
     \"Ed25519\", \"Rsa2048\", \"Rsa4096\", and \"Rsa8192\"."""
    rotation_policy: Union[str, "_models.PrivateKeyRotationPolicy"] = rest_field(name="rotationPolicy")
    """cert-manager private key rotationPolicy. Required. Known values are: \"Always\" and \"Never\"."""

    @overload
    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.PrivateKeyAlgorithm"],
        rotation_policy: Union[str, "_models.PrivateKeyRotationPolicy"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientConfig(_model_base.Model):
    """The settings of Client Config.

    :ivar max_session_expiry_seconds: Upper bound of Session Expiry Interval, in seconds.
    :vartype max_session_expiry_seconds: int
    :ivar max_message_expiry_seconds: Upper bound of Message Expiry Interval, in seconds.
    :vartype max_message_expiry_seconds: int
    :ivar max_packet_size_bytes: Max message size for a packet in Bytes.
    :vartype max_packet_size_bytes: int
    :ivar subscriber_queue_limit: The limit on the number of queued messages for a subscriber.
    :vartype subscriber_queue_limit: ~azure.mgmt.iotoperations.models.SubscriberQueueLimit
    :ivar max_receive_maximum: Upper bound of Receive Maximum that a client can request in the
     CONNECT packet.
    :vartype max_receive_maximum: int
    :ivar max_keep_alive_seconds: Upper bound of a client's Keep Alive, in seconds.
    :vartype max_keep_alive_seconds: int
    """

    max_session_expiry_seconds: Optional[int] = rest_field(name="maxSessionExpirySeconds")
    """Upper bound of Session Expiry Interval, in seconds."""
    max_message_expiry_seconds: Optional[int] = rest_field(name="maxMessageExpirySeconds")
    """Upper bound of Message Expiry Interval, in seconds."""
    max_packet_size_bytes: Optional[int] = rest_field(name="maxPacketSizeBytes")
    """Max message size for a packet in Bytes."""
    subscriber_queue_limit: Optional["_models.SubscriberQueueLimit"] = rest_field(name="subscriberQueueLimit")
    """The limit on the number of queued messages for a subscriber."""
    max_receive_maximum: Optional[int] = rest_field(name="maxReceiveMaximum")
    """Upper bound of Receive Maximum that a client can request in the CONNECT packet."""
    max_keep_alive_seconds: Optional[int] = rest_field(name="maxKeepAliveSeconds")
    """Upper bound of a client's Keep Alive, in seconds."""

    @overload
    def __init__(
        self,
        *,
        max_session_expiry_seconds: Optional[int] = None,
        max_message_expiry_seconds: Optional[int] = None,
        max_packet_size_bytes: Optional[int] = None,
        subscriber_queue_limit: Optional["_models.SubscriberQueueLimit"] = None,
        max_receive_maximum: Optional[int] = None,
        max_keep_alive_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowBuiltInTransformationDataset(_model_base.Model):
    """Dataflow BuiltIn Transformation dataset properties.


    :ivar key: The key of the dataset. Required.
    :vartype key: str
    :ivar description: A user provided optional description of the dataset.
    :vartype description: str
    :ivar schema_ref: The reference to the schema that describes the dataset. Allowed: JSON
     Schema/draft-7.
    :vartype schema_ref: str
    :ivar inputs: List of fields for enriching from the Broker State Store. Required.
    :vartype inputs: list[str]
    :ivar expression: Condition to enrich data from Broker State Store. Example: $1 < 0 || $1 > $2
     (Assuming inputs section $1 and $2 are provided).
    :vartype expression: str
    """

    key: str = rest_field()
    """The key of the dataset. Required."""
    description: Optional[str] = rest_field()
    """A user provided optional description of the dataset."""
    schema_ref: Optional[str] = rest_field(name="schemaRef")
    """The reference to the schema that describes the dataset. Allowed: JSON Schema/draft-7."""
    inputs: List[str] = rest_field()
    """List of fields for enriching from the Broker State Store. Required."""
    expression: Optional[str] = rest_field()
    """Condition to enrich data from Broker State Store. Example: $1 < 0 || $1 > $2 (Assuming inputs
     section $1 and $2 are provided)."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        inputs: List[str],
        description: Optional[str] = None,
        schema_ref: Optional[str] = None,
        expression: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowBuiltInTransformationFilter(_model_base.Model):
    """Dataflow BuiltIn Transformation filter properties.


    :ivar type: The type of dataflow operation. "Filter"
    :vartype type: str or ~azure.mgmt.iotoperations.models.FilterType
    :ivar description: A user provided optional description of the filter.
    :vartype description: str
    :ivar inputs: List of fields for filtering in JSON path expression. Required.
    :vartype inputs: list[str]
    :ivar expression: Condition to filter data. Can reference input fields with {n} where n is the
     index of the input field starting from 1. Example: $1 < 0 || $1 > $2 (Assuming inputs section
     $1 and $2 are provided). Required.
    :vartype expression: str
    """

    type: Optional[Union[str, "_models.FilterType"]] = rest_field()
    """The type of dataflow operation. \"Filter\""""
    description: Optional[str] = rest_field()
    """A user provided optional description of the filter."""
    inputs: List[str] = rest_field()
    """List of fields for filtering in JSON path expression. Required."""
    expression: str = rest_field()
    """Condition to filter data. Can reference input fields with {n} where n is the index of the input
     field starting from 1. Example: $1 < 0 || $1 > $2 (Assuming inputs section $1 and $2 are
     provided). Required."""

    @overload
    def __init__(
        self,
        *,
        inputs: List[str],
        expression: str,
        type: Optional[Union[str, "_models.FilterType"]] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowBuiltInTransformationMap(_model_base.Model):
    """Dataflow BuiltIn Transformation map properties.


    :ivar type: Type of transformation. Known values are: "NewProperties", "Rename", "Compute",
     "PassThrough", and "BuiltInFunction".
    :vartype type: str or ~azure.mgmt.iotoperations.models.DataflowMappingType
    :ivar description: A user provided optional description of the mapping function.
    :vartype description: str
    :ivar inputs: List of fields for mapping in JSON path expression. Required.
    :vartype inputs: list[str]
    :ivar expression: Modify the inputs field(s) to the final output field. Example: $1 * 2.2
     (Assuming inputs section $1 is provided).
    :vartype expression: str
    :ivar output: Where and how the input fields to be organized in the output record. Required.
    :vartype output: str
    """

    type: Optional[Union[str, "_models.DataflowMappingType"]] = rest_field()
    """Type of transformation. Known values are: \"NewProperties\", \"Rename\", \"Compute\",
     \"PassThrough\", and \"BuiltInFunction\"."""
    description: Optional[str] = rest_field()
    """A user provided optional description of the mapping function."""
    inputs: List[str] = rest_field()
    """List of fields for mapping in JSON path expression. Required."""
    expression: Optional[str] = rest_field()
    """Modify the inputs field(s) to the final output field. Example: $1 * 2.2 (Assuming inputs
     section $1 is provided)."""
    output: str = rest_field()
    """Where and how the input fields to be organized in the output record. Required."""

    @overload
    def __init__(
        self,
        *,
        inputs: List[str],
        output: str,
        type: Optional[Union[str, "_models.DataflowMappingType"]] = None,
        description: Optional[str] = None,
        expression: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowBuiltInTransformationSettings(_model_base.Model):
    """Dataflow BuiltIn Transformation properties.

    :ivar serialization_format: Serialization format. Optional; defaults to JSON. Allowed value
     JSON Schema/draft-7, Parquet. Default: Json. Known values are: "Delta", "Json", and "Parquet".
    :vartype serialization_format: str or
     ~azure.mgmt.iotoperations.models.TransformationSerializationFormat
    :ivar schema_ref: Reference to the schema that describes the output of the transformation.
    :vartype schema_ref: str
    :ivar datasets: Enrich data from Broker State Store. Dataset references a key in Broker State
     Store.
    :vartype datasets: list[~azure.mgmt.iotoperations.models.DataflowBuiltInTransformationDataset]
    :ivar filter: Filters input record or datapoints based on condition.
    :vartype filter: list[~azure.mgmt.iotoperations.models.DataflowBuiltInTransformationFilter]
    :ivar map: Maps input to output message.
    :vartype map: list[~azure.mgmt.iotoperations.models.DataflowBuiltInTransformationMap]
    """

    serialization_format: Optional[Union[str, "_models.TransformationSerializationFormat"]] = rest_field(
        name="serializationFormat"
    )
    """Serialization format. Optional; defaults to JSON. Allowed value JSON Schema/draft-7, Parquet.
     Default: Json. Known values are: \"Delta\", \"Json\", and \"Parquet\"."""
    schema_ref: Optional[str] = rest_field(name="schemaRef")
    """Reference to the schema that describes the output of the transformation."""
    datasets: Optional[List["_models.DataflowBuiltInTransformationDataset"]] = rest_field()
    """Enrich data from Broker State Store. Dataset references a key in Broker State Store."""
    filter: Optional[List["_models.DataflowBuiltInTransformationFilter"]] = rest_field()
    """Filters input record or datapoints based on condition."""
    map: Optional[List["_models.DataflowBuiltInTransformationMap"]] = rest_field()
    """Maps input to output message."""

    @overload
    def __init__(
        self,
        *,
        serialization_format: Optional[Union[str, "_models.TransformationSerializationFormat"]] = None,
        schema_ref: Optional[str] = None,
        datasets: Optional[List["_models.DataflowBuiltInTransformationDataset"]] = None,
        filter: Optional[
            List["_models.DataflowBuiltInTransformationFilter"]
        ] = None,  # pylint: disable=redefined-builtin
        map: Optional[List["_models.DataflowBuiltInTransformationMap"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowDestinationOperationSettings(_model_base.Model):
    """Dataflow Destination Operation properties.


    :ivar endpoint_ref: Reference to the Endpoint CR. Can be of Broker, Kafka, Fabric, ADLS, ADX
     type. Required.
    :vartype endpoint_ref: str
    :ivar data_destination: Destination location, can be a topic or table name. Supports dynamic
     values with $topic, $systemProperties, $userProperties, $payload, $context, and $subscription.
     Required.
    :vartype data_destination: str
    """

    endpoint_ref: str = rest_field(name="endpointRef")
    """Reference to the Endpoint CR. Can be of Broker, Kafka, Fabric, ADLS, ADX type. Required."""
    data_destination: str = rest_field(name="dataDestination")
    """Destination location, can be a topic or table name. Supports dynamic values with $topic,
     $systemProperties, $userProperties, $payload, $context, and $subscription. Required."""

    @overload
    def __init__(
        self,
        *,
        endpoint_ref: str,
        data_destination: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationAccessToken(_model_base.Model):  # pylint: disable=name-too-long
    """DataflowEndpoint Authentication Access Token properties.


    :ivar secret_ref: Token secret name. Required.
    :vartype secret_ref: str
    """

    secret_ref: str = rest_field(name="secretRef")
    """Token secret name. Required."""

    @overload
    def __init__(
        self,
        *,
        secret_ref: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationSasl(_model_base.Model):
    """DataflowEndpoint Authentication Sasl properties.


    :ivar sasl_type: Type of SASL authentication. Can be PLAIN, SCRAM-SHA-256, or SCRAM-SHA-512.
     Required. Known values are: "Plain", "ScramSha256", and "ScramSha512".
    :vartype sasl_type: str or
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSaslType
    :ivar secret_ref: Token secret name. Required.
    :vartype secret_ref: str
    """

    sasl_type: Union[str, "_models.DataflowEndpointAuthenticationSaslType"] = rest_field(name="saslType")
    """Type of SASL authentication. Can be PLAIN, SCRAM-SHA-256, or SCRAM-SHA-512. Required. Known
     values are: \"Plain\", \"ScramSha256\", and \"ScramSha512\"."""
    secret_ref: str = rest_field(name="secretRef")
    """Token secret name. Required."""

    @overload
    def __init__(
        self,
        *,
        sasl_type: Union[str, "_models.DataflowEndpointAuthenticationSaslType"],
        secret_ref: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationServiceAccountToken(_model_base.Model):  # pylint: disable=name-too-long
    """Service Account Token for BrokerAuthentication.


    :ivar audience: Audience of the service account. Optional, defaults to the broker internal
     service account audience. Required.
    :vartype audience: str
    """

    audience: str = rest_field()
    """Audience of the service account. Optional, defaults to the broker internal service account
     audience. Required."""

    @overload
    def __init__(
        self,
        *,
        audience: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationSystemAssignedManagedIdentity(_model_base.Model):  # pylint: disable=name-too-long
    """DataflowEndpoint Authentication SystemAssignedManagedIdentity properties.

    :ivar audience: Audience of the service to authenticate against. Optional; defaults to the
     audience for Service host configuration.
    :vartype audience: str
    """

    audience: Optional[str] = rest_field()
    """Audience of the service to authenticate against. Optional; defaults to the audience for Service
     host configuration."""

    @overload
    def __init__(
        self,
        *,
        audience: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationUserAssignedManagedIdentity(_model_base.Model):  # pylint: disable=name-too-long
    """DataflowEndpoint Authentication UserAssignedManagedIdentity properties.


    :ivar client_id: Client ID for the user-assigned managed identity. Required.
    :vartype client_id: str
    :ivar scope: Resource identifier (application ID URI) of the resource, affixed with the
     .default suffix.
    :vartype scope: str
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    """

    client_id: str = rest_field(name="clientId")
    """Client ID for the user-assigned managed identity. Required."""
    scope: Optional[str] = rest_field()
    """Resource identifier (application ID URI) of the resource, affixed with the .default suffix."""
    tenant_id: str = rest_field(name="tenantId")
    """Tenant ID. Required."""

    @overload
    def __init__(
        self,
        *,
        client_id: str,
        tenant_id: str,
        scope: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointAuthenticationX509(_model_base.Model):
    """DataflowEndpoint Authentication X509 properties.


    :ivar secret_ref: Secret reference of the X.509 certificate. Required.
    :vartype secret_ref: str
    """

    secret_ref: str = rest_field(name="secretRef")
    """Secret reference of the X.509 certificate. Required."""

    @overload
    def __init__(
        self,
        *,
        secret_ref: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointDataExplorer(_model_base.Model):
    """Azure Data Explorer endpoint properties.


    :ivar authentication: Authentication configuration. NOTE - only authentication property is
     allowed per entry. Required.
    :vartype authentication:
     ~azure.mgmt.iotoperations.models.DataflowEndpointDataExplorerAuthentication
    :ivar database: Database name. Required.
    :vartype database: str
    :ivar host: Host of the Azure Data Explorer in the form of
     :code:`<cluster>`.:code:`<region>`.kusto.windows.net . Required.
    :vartype host: str
    :ivar batching: Azure Data Explorer endpoint batching configuration.
    :vartype batching: ~azure.mgmt.iotoperations.models.BatchingConfiguration
    """

    authentication: "_models.DataflowEndpointDataExplorerAuthentication" = rest_field()
    """Authentication configuration. NOTE - only authentication property is allowed per entry.
     Required."""
    database: str = rest_field()
    """Database name. Required."""
    host: str = rest_field()
    """Host of the Azure Data Explorer in the form of
     :code:`<cluster>`.:code:`<region>`.kusto.windows.net . Required."""
    batching: Optional["_models.BatchingConfiguration"] = rest_field()
    """Azure Data Explorer endpoint batching configuration."""

    @overload
    def __init__(
        self,
        *,
        authentication: "_models.DataflowEndpointDataExplorerAuthentication",
        database: str,
        host: str,
        batching: Optional["_models.BatchingConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointDataExplorerAuthentication(_model_base.Model):  # pylint: disable=name-too-long
    """Azure Data Explorer Authentication properties. NOTE - only authentication property is allowed
    per entry.


    :ivar method: Mode of Authentication. Required. Known values are:
     "SystemAssignedManagedIdentity" and "UserAssignedManagedIdentity".
    :vartype method: str or ~azure.mgmt.iotoperations.models.DataExplorerAuthMethod
    :ivar system_assigned_managed_identity_settings: System-assigned managed identity
     authentication.
    :vartype system_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity
    :ivar user_assigned_managed_identity_settings: User-assigned managed identity authentication.
    :vartype user_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationUserAssignedManagedIdentity
    """

    method: Union[str, "_models.DataExplorerAuthMethod"] = rest_field()
    """Mode of Authentication. Required. Known values are: \"SystemAssignedManagedIdentity\" and
     \"UserAssignedManagedIdentity\"."""
    system_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
    ] = rest_field(name="systemAssignedManagedIdentitySettings")
    """System-assigned managed identity authentication."""
    user_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
    ] = rest_field(name="userAssignedManagedIdentitySettings")
    """User-assigned managed identity authentication."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.DataExplorerAuthMethod"],
        system_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
        ] = None,
        user_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
        ] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointDataLakeStorage(_model_base.Model):
    """Azure Data Lake endpoint properties.


    :ivar authentication: Authentication configuration. NOTE - only authentication property is
     allowed per entry. Required.
    :vartype authentication:
     ~azure.mgmt.iotoperations.models.DataflowEndpointDataLakeStorageAuthentication
    :ivar host: Host of the Azure Data Lake in the form of :code:`<account>`.blob.core.windows.net
     . Required.
    :vartype host: str
    :ivar batching: Azure Data Lake endpoint batching configuration.
    :vartype batching: ~azure.mgmt.iotoperations.models.BatchingConfiguration
    """

    authentication: "_models.DataflowEndpointDataLakeStorageAuthentication" = rest_field()
    """Authentication configuration. NOTE - only authentication property is allowed per entry.
     Required."""
    host: str = rest_field()
    """Host of the Azure Data Lake in the form of :code:`<account>`.blob.core.windows.net . Required."""
    batching: Optional["_models.BatchingConfiguration"] = rest_field()
    """Azure Data Lake endpoint batching configuration."""

    @overload
    def __init__(
        self,
        *,
        authentication: "_models.DataflowEndpointDataLakeStorageAuthentication",
        host: str,
        batching: Optional["_models.BatchingConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointDataLakeStorageAuthentication(_model_base.Model):  # pylint: disable=name-too-long
    """Azure Data Lake endpoint Authentication properties.  NOTE Enum - Only one method is supported
    for one entry.


    :ivar method: Mode of Authentication. Required. Known values are:
     "SystemAssignedManagedIdentity", "UserAssignedManagedIdentity", and "AccessToken".
    :vartype method: str or ~azure.mgmt.iotoperations.models.DataLakeStorageAuthMethod
    :ivar access_token_settings: SAS token authentication.
    :vartype access_token_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationAccessToken
    :ivar system_assigned_managed_identity_settings: System-assigned managed identity
     authentication.
    :vartype system_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity
    :ivar user_assigned_managed_identity_settings: User-assigned managed identity authentication.
    :vartype user_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationUserAssignedManagedIdentity
    """

    method: Union[str, "_models.DataLakeStorageAuthMethod"] = rest_field()
    """Mode of Authentication. Required. Known values are: \"SystemAssignedManagedIdentity\",
     \"UserAssignedManagedIdentity\", and \"AccessToken\"."""
    access_token_settings: Optional["_models.DataflowEndpointAuthenticationAccessToken"] = rest_field(
        name="accessTokenSettings"
    )
    """SAS token authentication."""
    system_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
    ] = rest_field(name="systemAssignedManagedIdentitySettings")
    """System-assigned managed identity authentication."""
    user_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
    ] = rest_field(name="userAssignedManagedIdentitySettings")
    """User-assigned managed identity authentication."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.DataLakeStorageAuthMethod"],
        access_token_settings: Optional["_models.DataflowEndpointAuthenticationAccessToken"] = None,
        system_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
        ] = None,
        user_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
        ] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointFabricOneLake(_model_base.Model):
    """Microsoft Fabric endpoint properties.


    :ivar authentication: Authentication configuration. NOTE - only one authentication property is
     allowed per entry. Required.
    :vartype authentication:
     ~azure.mgmt.iotoperations.models.DataflowEndpointFabricOneLakeAuthentication
    :ivar names: Names of the workspace and lakehouse. Required.
    :vartype names: ~azure.mgmt.iotoperations.models.DataflowEndpointFabricOneLakeNames
    :ivar one_lake_path_type: Type of location of the data in the workspace. Can be either tables
     or files. Required. Known values are: "Files" and "Tables".
    :vartype one_lake_path_type: str or
     ~azure.mgmt.iotoperations.models.DataflowEndpointFabricPathType
    :ivar host: Host of the Microsoft Fabric in the form of
     https://:code:`<host>`.fabric.microsoft.com. Required.
    :vartype host: str
    :ivar batching: Batching configuration.
    :vartype batching: ~azure.mgmt.iotoperations.models.BatchingConfiguration
    """

    authentication: "_models.DataflowEndpointFabricOneLakeAuthentication" = rest_field()
    """Authentication configuration. NOTE - only one authentication property is allowed per entry.
     Required."""
    names: "_models.DataflowEndpointFabricOneLakeNames" = rest_field()
    """Names of the workspace and lakehouse. Required."""
    one_lake_path_type: Union[str, "_models.DataflowEndpointFabricPathType"] = rest_field(name="oneLakePathType")
    """Type of location of the data in the workspace. Can be either tables or files. Required. Known
     values are: \"Files\" and \"Tables\"."""
    host: str = rest_field()
    """Host of the Microsoft Fabric in the form of https://:code:`<host>`.fabric.microsoft.com.
     Required."""
    batching: Optional["_models.BatchingConfiguration"] = rest_field()
    """Batching configuration."""

    @overload
    def __init__(
        self,
        *,
        authentication: "_models.DataflowEndpointFabricOneLakeAuthentication",
        names: "_models.DataflowEndpointFabricOneLakeNames",
        one_lake_path_type: Union[str, "_models.DataflowEndpointFabricPathType"],
        host: str,
        batching: Optional["_models.BatchingConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointFabricOneLakeAuthentication(_model_base.Model):  # pylint: disable=name-too-long
    """Microsoft Fabric endpoint. Authentication properties. NOTE - Only one method is supported for
    one entry.


    :ivar method: Mode of Authentication. Required. Known values are:
     "SystemAssignedManagedIdentity" and "UserAssignedManagedIdentity".
    :vartype method: str or ~azure.mgmt.iotoperations.models.FabricOneLakeAuthMethod
    :ivar system_assigned_managed_identity_settings: System-assigned managed identity
     authentication.
    :vartype system_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity
    :ivar user_assigned_managed_identity_settings: User-assigned managed identity authentication.
    :vartype user_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationUserAssignedManagedIdentity
    """

    method: Union[str, "_models.FabricOneLakeAuthMethod"] = rest_field()
    """Mode of Authentication. Required. Known values are: \"SystemAssignedManagedIdentity\" and
     \"UserAssignedManagedIdentity\"."""
    system_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
    ] = rest_field(name="systemAssignedManagedIdentitySettings")
    """System-assigned managed identity authentication."""
    user_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
    ] = rest_field(name="userAssignedManagedIdentitySettings")
    """User-assigned managed identity authentication."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.FabricOneLakeAuthMethod"],
        system_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
        ] = None,
        user_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
        ] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointFabricOneLakeNames(_model_base.Model):
    """Microsoft Fabric endpoint Names properties.


    :ivar lakehouse_name: Lakehouse name. Required.
    :vartype lakehouse_name: str
    :ivar workspace_name: Workspace name. Required.
    :vartype workspace_name: str
    """

    lakehouse_name: str = rest_field(name="lakehouseName")
    """Lakehouse name. Required."""
    workspace_name: str = rest_field(name="workspaceName")
    """Workspace name. Required."""

    @overload
    def __init__(
        self,
        *,
        lakehouse_name: str,
        workspace_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointKafka(_model_base.Model):
    """Kafka endpoint properties.


    :ivar authentication: Authentication configuration. NOTE - only authentication property is
     allowed per entry. Required.
    :vartype authentication: ~azure.mgmt.iotoperations.models.DataflowEndpointKafkaAuthentication
    :ivar consumer_group_id: Consumer group ID.
    :vartype consumer_group_id: str
    :ivar host: Kafka endpoint host. Required.
    :vartype host: str
    :ivar batching: Batching configuration.
    :vartype batching: ~azure.mgmt.iotoperations.models.DataflowEndpointKafkaBatching
    :ivar copy_mqtt_properties: Copy Broker properties. No effect if the endpoint is used as a
     source or if the dataflow doesn't have an Broker source. Known values are: "Enabled" and
     "Disabled".
    :vartype copy_mqtt_properties: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar compression: Compression. Can be none, gzip, lz4, or snappy. No effect if the endpoint is
     used as a source. Known values are: "None", "Gzip", "Snappy", and "Lz4".
    :vartype compression: str or ~azure.mgmt.iotoperations.models.DataflowEndpointKafkaCompression
    :ivar kafka_acks: Kafka acks. Can be all, one, or zero. No effect if the endpoint is used as a
     source. Known values are: "Zero", "One", and "All".
    :vartype kafka_acks: str or ~azure.mgmt.iotoperations.models.DataflowEndpointKafkaAcks
    :ivar partition_strategy: Partition handling strategy. Can be default or static. No effect if
     the endpoint is used as a source. Known values are: "Default", "Static", "Topic", and
     "Property".
    :vartype partition_strategy: str or
     ~azure.mgmt.iotoperations.models.DataflowEndpointKafkaPartitionStrategy
    :ivar tls: TLS configuration.
    :vartype tls: ~azure.mgmt.iotoperations.models.TlsProperties
    :ivar cloud_event_attributes: Cloud event mapping config. Known values are: "Propagate" and
     "CreateOrRemap".
    :vartype cloud_event_attributes: str or
     ~azure.mgmt.iotoperations.models.CloudEventAttributeType
    """

    authentication: "_models.DataflowEndpointKafkaAuthentication" = rest_field()
    """Authentication configuration. NOTE - only authentication property is allowed per entry.
     Required."""
    consumer_group_id: Optional[str] = rest_field(name="consumerGroupId")
    """Consumer group ID."""
    host: str = rest_field()
    """Kafka endpoint host. Required."""
    batching: Optional["_models.DataflowEndpointKafkaBatching"] = rest_field()
    """Batching configuration."""
    copy_mqtt_properties: Optional[Union[str, "_models.OperationalMode"]] = rest_field(name="copyMqttProperties")
    """Copy Broker properties. No effect if the endpoint is used as a source or if the dataflow
     doesn't have an Broker source. Known values are: \"Enabled\" and \"Disabled\"."""
    compression: Optional[Union[str, "_models.DataflowEndpointKafkaCompression"]] = rest_field()
    """Compression. Can be none, gzip, lz4, or snappy. No effect if the endpoint is used as a source.
     Known values are: \"None\", \"Gzip\", \"Snappy\", and \"Lz4\"."""
    kafka_acks: Optional[Union[str, "_models.DataflowEndpointKafkaAcks"]] = rest_field(name="kafkaAcks")
    """Kafka acks. Can be all, one, or zero. No effect if the endpoint is used as a source. Known
     values are: \"Zero\", \"One\", and \"All\"."""
    partition_strategy: Optional[Union[str, "_models.DataflowEndpointKafkaPartitionStrategy"]] = rest_field(
        name="partitionStrategy"
    )
    """Partition handling strategy. Can be default or static. No effect if the endpoint is used as a
     source. Known values are: \"Default\", \"Static\", \"Topic\", and \"Property\"."""
    tls: Optional["_models.TlsProperties"] = rest_field()
    """TLS configuration."""
    cloud_event_attributes: Optional[Union[str, "_models.CloudEventAttributeType"]] = rest_field(
        name="cloudEventAttributes"
    )
    """Cloud event mapping config. Known values are: \"Propagate\" and \"CreateOrRemap\"."""

    @overload
    def __init__(
        self,
        *,
        authentication: "_models.DataflowEndpointKafkaAuthentication",
        host: str,
        consumer_group_id: Optional[str] = None,
        batching: Optional["_models.DataflowEndpointKafkaBatching"] = None,
        copy_mqtt_properties: Optional[Union[str, "_models.OperationalMode"]] = None,
        compression: Optional[Union[str, "_models.DataflowEndpointKafkaCompression"]] = None,
        kafka_acks: Optional[Union[str, "_models.DataflowEndpointKafkaAcks"]] = None,
        partition_strategy: Optional[Union[str, "_models.DataflowEndpointKafkaPartitionStrategy"]] = None,
        tls: Optional["_models.TlsProperties"] = None,
        cloud_event_attributes: Optional[Union[str, "_models.CloudEventAttributeType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointKafkaAuthentication(_model_base.Model):
    """Kafka endpoint Authentication properties. NOTE - only authentication property is allowed per
    entry.


    :ivar method: Mode of Authentication. Required. Known values are:
     "SystemAssignedManagedIdentity", "UserAssignedManagedIdentity", "Sasl", "X509Certificate", and
     "Anonymous".
    :vartype method: str or ~azure.mgmt.iotoperations.models.KafkaAuthMethod
    :ivar system_assigned_managed_identity_settings: System-assigned managed identity
     authentication.
    :vartype system_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity
    :ivar user_assigned_managed_identity_settings: User-assigned managed identity authentication.
    :vartype user_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationUserAssignedManagedIdentity
    :ivar sasl_settings: SASL authentication.
    :vartype sasl_settings: ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSasl
    :ivar x509_certificate_settings: X.509 certificate authentication.
    :vartype x509_certificate_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationX509
    """

    method: Union[str, "_models.KafkaAuthMethod"] = rest_field()
    """Mode of Authentication. Required. Known values are: \"SystemAssignedManagedIdentity\",
     \"UserAssignedManagedIdentity\", \"Sasl\", \"X509Certificate\", and \"Anonymous\"."""
    system_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
    ] = rest_field(name="systemAssignedManagedIdentitySettings")
    """System-assigned managed identity authentication."""
    user_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
    ] = rest_field(name="userAssignedManagedIdentitySettings")
    """User-assigned managed identity authentication."""
    sasl_settings: Optional["_models.DataflowEndpointAuthenticationSasl"] = rest_field(name="saslSettings")
    """SASL authentication."""
    x509_certificate_settings: Optional["_models.DataflowEndpointAuthenticationX509"] = rest_field(
        name="x509CertificateSettings"
    )
    """X.509 certificate authentication."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.KafkaAuthMethod"],
        system_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
        ] = None,
        user_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
        ] = None,
        sasl_settings: Optional["_models.DataflowEndpointAuthenticationSasl"] = None,
        x509_certificate_settings: Optional["_models.DataflowEndpointAuthenticationX509"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointKafkaBatching(_model_base.Model):
    """Kafka endpoint Batching properties.

    :ivar mode: Mode for batching. Known values are: "Enabled" and "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar latency_ms: Batching latency in milliseconds.
    :vartype latency_ms: int
    :ivar max_bytes: Maximum number of bytes in a batch.
    :vartype max_bytes: int
    :ivar max_messages: Maximum number of messages in a batch.
    :vartype max_messages: int
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """Mode for batching. Known values are: \"Enabled\" and \"Disabled\"."""
    latency_ms: Optional[int] = rest_field(name="latencyMs")
    """Batching latency in milliseconds."""
    max_bytes: Optional[int] = rest_field(name="maxBytes")
    """Maximum number of bytes in a batch."""
    max_messages: Optional[int] = rest_field(name="maxMessages")
    """Maximum number of messages in a batch."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
        latency_ms: Optional[int] = None,
        max_bytes: Optional[int] = None,
        max_messages: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointLocalStorage(_model_base.Model):
    """Local persistent volume endpoint properties.


    :ivar persistent_volume_claim_ref: Persistent volume claim name. Required.
    :vartype persistent_volume_claim_ref: str
    """

    persistent_volume_claim_ref: str = rest_field(name="persistentVolumeClaimRef")
    """Persistent volume claim name. Required."""

    @overload
    def __init__(
        self,
        *,
        persistent_volume_claim_ref: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointMqtt(_model_base.Model):
    """Broker endpoint properties.


    :ivar authentication: authentication properties. DEFAULT: kubernetes.audience=aio-internal.
     NOTE - Enum field only property is allowed. Required.
    :vartype authentication: ~azure.mgmt.iotoperations.models.DataflowEndpointMqttAuthentication
    :ivar client_id_prefix: Client ID prefix. Client ID generated by the dataflow is
     :code:`<prefix>`-TBD. Optional; no prefix if omitted.
    :vartype client_id_prefix: str
    :ivar host: Host of the Broker in the form of :code:`<hostname>`::code:`<port>`. Optional;
     connects to Broker if omitted.
    :vartype host: str
    :ivar protocol: Enable or disable websockets. Known values are: "Mqtt" and "WebSockets".
    :vartype protocol: str or ~azure.mgmt.iotoperations.models.BrokerProtocolType
    :ivar keep_alive_seconds: Broker KeepAlive for connection in seconds.
    :vartype keep_alive_seconds: int
    :ivar retain: Whether or not to keep the retain setting. Known values are: "Keep" and "Never".
    :vartype retain: str or ~azure.mgmt.iotoperations.models.MqttRetainType
    :ivar max_inflight_messages: The max number of messages to keep in flight. For subscribe, this
     is the receive maximum. For publish, this is the maximum number of messages to send before
     waiting for an ack.
    :vartype max_inflight_messages: int
    :ivar qos: Qos for Broker connection.
    :vartype qos: int
    :ivar session_expiry_seconds: Session expiry in seconds.
    :vartype session_expiry_seconds: int
    :ivar tls: TLS configuration.
    :vartype tls: ~azure.mgmt.iotoperations.models.TlsProperties
    :ivar cloud_event_attributes: Cloud event mapping config. Known values are: "Propagate" and
     "CreateOrRemap".
    :vartype cloud_event_attributes: str or
     ~azure.mgmt.iotoperations.models.CloudEventAttributeType
    """

    authentication: "_models.DataflowEndpointMqttAuthentication" = rest_field()
    """authentication properties. DEFAULT: kubernetes.audience=aio-internal. NOTE - Enum field only
     property is allowed. Required."""
    client_id_prefix: Optional[str] = rest_field(name="clientIdPrefix")
    """Client ID prefix. Client ID generated by the dataflow is :code:`<prefix>`-TBD. Optional; no
     prefix if omitted."""
    host: Optional[str] = rest_field()
    """Host of the Broker in the form of :code:`<hostname>`::code:`<port>`. Optional; connects to
     Broker if omitted."""
    protocol: Optional[Union[str, "_models.BrokerProtocolType"]] = rest_field()
    """Enable or disable websockets. Known values are: \"Mqtt\" and \"WebSockets\"."""
    keep_alive_seconds: Optional[int] = rest_field(name="keepAliveSeconds")
    """Broker KeepAlive for connection in seconds."""
    retain: Optional[Union[str, "_models.MqttRetainType"]] = rest_field()
    """Whether or not to keep the retain setting. Known values are: \"Keep\" and \"Never\"."""
    max_inflight_messages: Optional[int] = rest_field(name="maxInflightMessages")
    """The max number of messages to keep in flight. For subscribe, this is the receive maximum. For
     publish, this is the maximum number of messages to send before waiting for an ack."""
    qos: Optional[int] = rest_field()
    """Qos for Broker connection."""
    session_expiry_seconds: Optional[int] = rest_field(name="sessionExpirySeconds")
    """Session expiry in seconds."""
    tls: Optional["_models.TlsProperties"] = rest_field()
    """TLS configuration."""
    cloud_event_attributes: Optional[Union[str, "_models.CloudEventAttributeType"]] = rest_field(
        name="cloudEventAttributes"
    )
    """Cloud event mapping config. Known values are: \"Propagate\" and \"CreateOrRemap\"."""

    @overload
    def __init__(
        self,
        *,
        authentication: "_models.DataflowEndpointMqttAuthentication",
        client_id_prefix: Optional[str] = None,
        host: Optional[str] = None,
        protocol: Optional[Union[str, "_models.BrokerProtocolType"]] = None,
        keep_alive_seconds: Optional[int] = None,
        retain: Optional[Union[str, "_models.MqttRetainType"]] = None,
        max_inflight_messages: Optional[int] = None,
        qos: Optional[int] = None,
        session_expiry_seconds: Optional[int] = None,
        tls: Optional["_models.TlsProperties"] = None,
        cloud_event_attributes: Optional[Union[str, "_models.CloudEventAttributeType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointMqttAuthentication(_model_base.Model):
    """Mqtt endpoint Authentication properties. NOTE - only authentication property is allowed per
    entry.


    :ivar method: Mode of Authentication. Required. Known values are:
     "SystemAssignedManagedIdentity", "UserAssignedManagedIdentity", "ServiceAccountToken",
     "X509Certificate", and "Anonymous".
    :vartype method: str or ~azure.mgmt.iotoperations.models.MqttAuthMethod
    :ivar system_assigned_managed_identity_settings: System-assigned managed identity
     authentication.
    :vartype system_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity
    :ivar user_assigned_managed_identity_settings: User-assigned managed identity authentication.
    :vartype user_assigned_managed_identity_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationUserAssignedManagedIdentity
    :ivar service_account_token_settings: Kubernetes service account token authentication. Default
     audience if not set is aio-internal.
    :vartype service_account_token_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationServiceAccountToken
    :ivar x509_certificate_settings: X.509 certificate authentication.
    :vartype x509_certificate_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointAuthenticationX509
    """

    method: Union[str, "_models.MqttAuthMethod"] = rest_field()
    """Mode of Authentication. Required. Known values are: \"SystemAssignedManagedIdentity\",
     \"UserAssignedManagedIdentity\", \"ServiceAccountToken\", \"X509Certificate\", and
     \"Anonymous\"."""
    system_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
    ] = rest_field(name="systemAssignedManagedIdentitySettings")
    """System-assigned managed identity authentication."""
    user_assigned_managed_identity_settings: Optional[
        "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
    ] = rest_field(name="userAssignedManagedIdentitySettings")
    """User-assigned managed identity authentication."""
    service_account_token_settings: Optional["_models.DataflowEndpointAuthenticationServiceAccountToken"] = rest_field(
        name="serviceAccountTokenSettings"
    )
    """Kubernetes service account token authentication. Default audience if not set is aio-internal."""
    x509_certificate_settings: Optional["_models.DataflowEndpointAuthenticationX509"] = rest_field(
        name="x509CertificateSettings"
    )
    """X.509 certificate authentication."""

    @overload
    def __init__(
        self,
        *,
        method: Union[str, "_models.MqttAuthMethod"],
        system_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationSystemAssignedManagedIdentity"
        ] = None,
        user_assigned_managed_identity_settings: Optional[
            "_models.DataflowEndpointAuthenticationUserAssignedManagedIdentity"
        ] = None,
        service_account_token_settings: Optional["_models.DataflowEndpointAuthenticationServiceAccountToken"] = None,
        x509_certificate_settings: Optional["_models.DataflowEndpointAuthenticationX509"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointProperties(_model_base.Model):
    """DataflowEndpoint Resource properties. NOTE - Only one type of endpoint is supported for one
    Resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar endpoint_type: Endpoint Type. Required. Known values are: "DataExplorer",
     "DataLakeStorage", "FabricOneLake", "Kafka", "LocalStorage", and "Mqtt".
    :vartype endpoint_type: str or ~azure.mgmt.iotoperations.models.EndpointType
    :ivar data_explorer_settings: Azure Data Explorer endpoint.
    :vartype data_explorer_settings: ~azure.mgmt.iotoperations.models.DataflowEndpointDataExplorer
    :ivar data_lake_storage_settings: Azure Data Lake endpoint.
    :vartype data_lake_storage_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointDataLakeStorage
    :ivar fabric_one_lake_settings: Microsoft Fabric endpoint.
    :vartype fabric_one_lake_settings:
     ~azure.mgmt.iotoperations.models.DataflowEndpointFabricOneLake
    :ivar kafka_settings: Kafka endpoint.
    :vartype kafka_settings: ~azure.mgmt.iotoperations.models.DataflowEndpointKafka
    :ivar local_storage_settings: Local persistent volume endpoint.
    :vartype local_storage_settings: ~azure.mgmt.iotoperations.models.DataflowEndpointLocalStorage
    :ivar mqtt_settings: Broker endpoint.
    :vartype mqtt_settings: ~azure.mgmt.iotoperations.models.DataflowEndpointMqtt
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    endpoint_type: Union[str, "_models.EndpointType"] = rest_field(name="endpointType")
    """Endpoint Type. Required. Known values are: \"DataExplorer\", \"DataLakeStorage\",
     \"FabricOneLake\", \"Kafka\", \"LocalStorage\", and \"Mqtt\"."""
    data_explorer_settings: Optional["_models.DataflowEndpointDataExplorer"] = rest_field(name="dataExplorerSettings")
    """Azure Data Explorer endpoint."""
    data_lake_storage_settings: Optional["_models.DataflowEndpointDataLakeStorage"] = rest_field(
        name="dataLakeStorageSettings"
    )
    """Azure Data Lake endpoint."""
    fabric_one_lake_settings: Optional["_models.DataflowEndpointFabricOneLake"] = rest_field(
        name="fabricOneLakeSettings"
    )
    """Microsoft Fabric endpoint."""
    kafka_settings: Optional["_models.DataflowEndpointKafka"] = rest_field(name="kafkaSettings")
    """Kafka endpoint."""
    local_storage_settings: Optional["_models.DataflowEndpointLocalStorage"] = rest_field(name="localStorageSettings")
    """Local persistent volume endpoint."""
    mqtt_settings: Optional["_models.DataflowEndpointMqtt"] = rest_field(name="mqttSettings")
    """Broker endpoint."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        endpoint_type: Union[str, "_models.EndpointType"],
        data_explorer_settings: Optional["_models.DataflowEndpointDataExplorer"] = None,
        data_lake_storage_settings: Optional["_models.DataflowEndpointDataLakeStorage"] = None,
        fabric_one_lake_settings: Optional["_models.DataflowEndpointFabricOneLake"] = None,
        kafka_settings: Optional["_models.DataflowEndpointKafka"] = None,
        local_storage_settings: Optional["_models.DataflowEndpointLocalStorage"] = None,
        mqtt_settings: Optional["_models.DataflowEndpointMqtt"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowEndpointResource(ProxyResource):
    """Instance dataflowEndpoint resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.DataflowEndpointProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.DataflowEndpointProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.DataflowEndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowOperation(_model_base.Model):
    """Dataflow Operation properties. NOTE - One only method is allowed to be used for one entry.


    :ivar operation_type: Type of operation. Required. Known values are: "Source", "Destination",
     and "BuiltInTransformation".
    :vartype operation_type: str or ~azure.mgmt.iotoperations.models.OperationType
    :ivar name: Optional user provided name of the transformation.
    :vartype name: str
    :ivar source_settings: Source configuration.
    :vartype source_settings: ~azure.mgmt.iotoperations.models.DataflowSourceOperationSettings
    :ivar built_in_transformation_settings: Built In Transformation configuration.
    :vartype built_in_transformation_settings:
     ~azure.mgmt.iotoperations.models.DataflowBuiltInTransformationSettings
    :ivar destination_settings: Destination configuration.
    :vartype destination_settings:
     ~azure.mgmt.iotoperations.models.DataflowDestinationOperationSettings
    """

    operation_type: Union[str, "_models.OperationType"] = rest_field(name="operationType")
    """Type of operation. Required. Known values are: \"Source\", \"Destination\", and
     \"BuiltInTransformation\"."""
    name: Optional[str] = rest_field()
    """Optional user provided name of the transformation."""
    source_settings: Optional["_models.DataflowSourceOperationSettings"] = rest_field(name="sourceSettings")
    """Source configuration."""
    built_in_transformation_settings: Optional["_models.DataflowBuiltInTransformationSettings"] = rest_field(
        name="builtInTransformationSettings"
    )
    """Built In Transformation configuration."""
    destination_settings: Optional["_models.DataflowDestinationOperationSettings"] = rest_field(
        name="destinationSettings"
    )
    """Destination configuration."""

    @overload
    def __init__(
        self,
        *,
        operation_type: Union[str, "_models.OperationType"],
        name: Optional[str] = None,
        source_settings: Optional["_models.DataflowSourceOperationSettings"] = None,
        built_in_transformation_settings: Optional["_models.DataflowBuiltInTransformationSettings"] = None,
        destination_settings: Optional["_models.DataflowDestinationOperationSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowProfileProperties(_model_base.Model):
    """DataflowProfile Resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar diagnostics: Spec defines the desired identities of NBC diagnostics settings.
    :vartype diagnostics: ~azure.mgmt.iotoperations.models.ProfileDiagnostics
    :ivar instance_count: To manually scale the dataflow profile, specify the maximum number of
     instances you want to run.
    :vartype instance_count: int
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    diagnostics: Optional["_models.ProfileDiagnostics"] = rest_field()
    """Spec defines the desired identities of NBC diagnostics settings."""
    instance_count: Optional[int] = rest_field(name="instanceCount")
    """To manually scale the dataflow profile, specify the maximum number of instances you want to
     run."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        diagnostics: Optional["_models.ProfileDiagnostics"] = None,
        instance_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowProfileResource(ProxyResource):
    """Instance dataflowProfile resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.DataflowProfileProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.DataflowProfileProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.DataflowProfileProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowProperties(_model_base.Model):
    """Dataflow Resource properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar mode: Mode for Dataflow. Optional; defaults to Enabled. Known values are: "Enabled" and
     "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar operations: List of operations including source and destination references as well as
     transformation. Required.
    :vartype operations: list[~azure.mgmt.iotoperations.models.DataflowOperation]
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """Mode for Dataflow. Optional; defaults to Enabled. Known values are: \"Enabled\" and
     \"Disabled\"."""
    operations: List["_models.DataflowOperation"] = rest_field()
    """List of operations including source and destination references as well as transformation.
     Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        operations: List["_models.DataflowOperation"],
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowResource(ProxyResource):
    """Instance dataflowProfile dataflow resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.DataflowProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    """

    properties: Optional["_models.DataflowProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        extended_location: "_models.ExtendedLocation",
        properties: Optional["_models.DataflowProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataflowSourceOperationSettings(_model_base.Model):
    """Dataflow Source Operation properties.


    :ivar endpoint_ref: Reference to the Dataflow Endpoint resource. Can only be of Broker and
     Kafka type. Required.
    :vartype endpoint_ref: str
    :ivar asset_ref: Reference to the resource in Azure Device Registry where the data in the
     endpoint originates from.
    :vartype asset_ref: str
    :ivar serialization_format: Content is a JSON Schema. Allowed: JSON Schema/draft-7. "Json"
    :vartype serialization_format: str or
     ~azure.mgmt.iotoperations.models.SourceSerializationFormat
    :ivar schema_ref: Schema CR reference. Data will be deserialized according to the schema, and
     dropped if it doesn't match.
    :vartype schema_ref: str
    :ivar data_sources: List of source locations. Can be Broker or Kafka topics. Supports wildcards
     # and +. Required.
    :vartype data_sources: list[str]
    """

    endpoint_ref: str = rest_field(name="endpointRef")
    """Reference to the Dataflow Endpoint resource. Can only be of Broker and Kafka type. Required."""
    asset_ref: Optional[str] = rest_field(name="assetRef")
    """Reference to the resource in Azure Device Registry where the data in the endpoint originates
     from."""
    serialization_format: Optional[Union[str, "_models.SourceSerializationFormat"]] = rest_field(
        name="serializationFormat"
    )
    """Content is a JSON Schema. Allowed: JSON Schema/draft-7. \"Json\""""
    schema_ref: Optional[str] = rest_field(name="schemaRef")
    """Schema CR reference. Data will be deserialized according to the schema, and dropped if it
     doesn't match."""
    data_sources: List[str] = rest_field(name="dataSources")
    """List of source locations. Can be Broker or Kafka topics. Supports wildcards # and +. Required."""

    @overload
    def __init__(
        self,
        *,
        endpoint_ref: str,
        data_sources: List[str],
        asset_ref: Optional[str] = None,
        serialization_format: Optional[Union[str, "_models.SourceSerializationFormat"]] = None,
        schema_ref: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiagnosticsLogs(_model_base.Model):
    """Diagnostic Log properties.

    :ivar level: The log level. Examples - 'debug', 'info', 'warn', 'error', 'trace'.
    :vartype level: str
    """

    level: Optional[str] = rest_field()
    """The log level. Examples - 'debug', 'info', 'warn', 'error', 'trace'."""

    @overload
    def __init__(
        self,
        *,
        level: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskBackedMessageBuffer(_model_base.Model):
    """DiskBackedMessageBuffer properties.


    :ivar max_size: The max size of the message buffer on disk. If a PVC template is specified
     using one of ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as
     the request and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor
     persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as
     its limit. See https://kubernetes.io/docs/concepts/storage/volumes/#emptydir for details.
     Required.
    :vartype max_size: str
    :ivar ephemeral_volume_claim_spec: Use the specified persistent volume claim template to mount
     a "generic ephemeral volume" for the message buffer. See
     https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes for
     details.
    :vartype ephemeral_volume_claim_spec: ~azure.mgmt.iotoperations.models.VolumeClaimSpec
    :ivar persistent_volume_claim_spec: Use the specified persistent volume claim template to mount
     a persistent volume for the message buffer.
    :vartype persistent_volume_claim_spec: ~azure.mgmt.iotoperations.models.VolumeClaimSpec
    """

    max_size: str = rest_field(name="maxSize")
    """The max size of the message buffer on disk. If a PVC template is specified using one of
     ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as the request
     and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor
     persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as
     its limit. See https://kubernetes.io/docs/concepts/storage/volumes/#emptydir for details.
     Required."""
    ephemeral_volume_claim_spec: Optional["_models.VolumeClaimSpec"] = rest_field(name="ephemeralVolumeClaimSpec")
    """Use the specified persistent volume claim template to mount a \"generic ephemeral volume\" for
     the message buffer. See
     https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes for
     details."""
    persistent_volume_claim_spec: Optional["_models.VolumeClaimSpec"] = rest_field(name="persistentVolumeClaimSpec")
    """Use the specified persistent volume claim template to mount a persistent volume for the message
     buffer."""

    @overload
    def __init__(
        self,
        *,
        max_size: str,
        ephemeral_volume_claim_spec: Optional["_models.VolumeClaimSpec"] = None,
        persistent_volume_claim_spec: Optional["_models.VolumeClaimSpec"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.iotoperations.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.iotoperations.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.iotoperations.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtendedLocation(_model_base.Model):
    """Extended location is an extension of Azure locations. They provide a way to use their Azure ARC
    enabled Kubernetes clusters as target locations for deploying Azure services instances.


    :ivar name: The name of the extended location. Required.
    :vartype name: str
    :ivar type: Type of ExtendedLocation. Required. "CustomLocation"
    :vartype type: str or ~azure.mgmt.iotoperations.models.ExtendedLocationType
    """

    name: str = rest_field()
    """The name of the extended location. Required."""
    type: Union[str, "_models.ExtendedLocationType"] = rest_field()
    """Type of ExtendedLocation. Required. \"CustomLocation\""""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ExtendedLocationType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Frontend(_model_base.Model):
    """The desired properties of the frontend instances of the Broker.


    :ivar replicas: The desired number of frontend instances (pods). Required.
    :vartype replicas: int
    :ivar workers: Number of logical frontend workers per instance (pod).
    :vartype workers: int
    """

    replicas: int = rest_field()
    """The desired number of frontend instances (pods). Required."""
    workers: Optional[int] = rest_field()
    """Number of logical frontend workers per instance (pod)."""

    @overload
    def __init__(
        self,
        *,
        replicas: int,
        workers: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GenerateResourceLimits(_model_base.Model):
    """GenerateResourceLimits properties.

    :ivar cpu: The toggle to enable/disable cpu resource limits. Known values are: "Enabled" and
     "Disabled".
    :vartype cpu: str or ~azure.mgmt.iotoperations.models.OperationalMode
    """

    cpu: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """The toggle to enable/disable cpu resource limits. Known values are: \"Enabled\" and
     \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        cpu: Optional[Union[str, "_models.OperationalMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstancePatchModel(_model_base.Model):
    """The Instance update model.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.iotoperations.models.ManagedServiceIdentity
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceProperties(_model_base.Model):
    """The properties of the Instance resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar description: Detailed description of the Instance.
    :vartype description: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.iotoperations.models.ProvisioningState
    :ivar version: The Azure IoT Operations version.
    :vartype version: str
    :ivar schema_registry_ref: The reference to the Schema Registry for this AIO Instance.
     Required.
    :vartype schema_registry_ref: ~azure.mgmt.iotoperations.models.SchemaRegistryRef
    """

    description: Optional[str] = rest_field()
    """Detailed description of the Instance."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    version: Optional[str] = rest_field(visibility=["read"])
    """The Azure IoT Operations version."""
    schema_registry_ref: "_models.SchemaRegistryRef" = rest_field(name="schemaRegistryRef")
    """The reference to the Schema Registry for this AIO Instance. Required."""

    @overload
    def __init__(
        self,
        *,
        schema_registry_ref: "_models.SchemaRegistryRef",
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceResource(TrackedResource):
    """A Instance resource is a logical container for a set of child resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotoperations.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotoperations.models.InstanceProperties
    :ivar extended_location: Edge location of the resource. Required.
    :vartype extended_location: ~azure.mgmt.iotoperations.models.ExtendedLocation
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.iotoperations.models.ManagedServiceIdentity
    """

    properties: Optional["_models.InstanceProperties"] = rest_field()
    """The resource-specific properties for this resource."""
    extended_location: "_models.ExtendedLocation" = rest_field(name="extendedLocation", visibility=["read", "create"])
    """Edge location of the resource. Required."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field()
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        extended_location: "_models.ExtendedLocation",
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.InstanceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KubernetesReference(_model_base.Model):
    """Kubernetes reference.


    :ivar api_group: APIGroup is the group for the resource being referenced. If APIGroup is not
     specified, the specified Kind must be in the core API group. For any other third-party types,
     APIGroup is required.
    :vartype api_group: str
    :ivar kind: Kind is the type of resource being referenced. Required.
    :vartype kind: str
    :ivar name: Name is the name of resource being referenced. Required.
    :vartype name: str
    :ivar namespace: Namespace is the namespace of the resource being referenced. This field is
     required when the resource has a namespace.
    :vartype namespace: str
    """

    api_group: Optional[str] = rest_field(name="apiGroup")
    """APIGroup is the group for the resource being referenced. If APIGroup is not specified, the
     specified Kind must be in the core API group. For any other third-party types, APIGroup is
     required."""
    kind: str = rest_field()
    """Kind is the type of resource being referenced. Required."""
    name: str = rest_field()
    """Name is the name of resource being referenced. Required."""
    namespace: Optional[str] = rest_field()
    """Namespace is the namespace of the resource being referenced. This field is required when the
     resource has a namespace."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        name: str,
        api_group: Optional[str] = None,
        namespace: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListenerPort(_model_base.Model):
    """Defines a TCP port on which a ``BrokerListener`` listens.


    :ivar authentication_ref: Reference to client authentication settings. Omit to disable
     authentication.
    :vartype authentication_ref: str
    :ivar authorization_ref: Reference to client authorization settings. Omit to disable
     authorization.
    :vartype authorization_ref: str
    :ivar node_port: Kubernetes node port. Only relevant when this port is associated with a
     ``NodePort`` listener.
    :vartype node_port: int
    :ivar port: TCP port for accepting client connections. Required.
    :vartype port: int
    :ivar protocol: Protocol to use for client connections. Known values are: "Mqtt" and
     "WebSockets".
    :vartype protocol: str or ~azure.mgmt.iotoperations.models.BrokerProtocolType
    :ivar tls: TLS server certificate settings for this port. Omit to disable TLS.
    :vartype tls: ~azure.mgmt.iotoperations.models.TlsCertMethod
    """

    authentication_ref: Optional[str] = rest_field(name="authenticationRef")
    """Reference to client authentication settings. Omit to disable authentication."""
    authorization_ref: Optional[str] = rest_field(name="authorizationRef")
    """Reference to client authorization settings. Omit to disable authorization."""
    node_port: Optional[int] = rest_field(name="nodePort")
    """Kubernetes node port. Only relevant when this port is associated with a ``NodePort`` listener."""
    port: int = rest_field()
    """TCP port for accepting client connections. Required."""
    protocol: Optional[Union[str, "_models.BrokerProtocolType"]] = rest_field()
    """Protocol to use for client connections. Known values are: \"Mqtt\" and \"WebSockets\"."""
    tls: Optional["_models.TlsCertMethod"] = rest_field()
    """TLS server certificate settings for this port. Omit to disable TLS."""

    @overload
    def __init__(
        self,
        *,
        port: int,
        authentication_ref: Optional[str] = None,
        authorization_ref: Optional[str] = None,
        node_port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.BrokerProtocolType"]] = None,
        tls: Optional["_models.TlsCertMethod"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LocalKubernetesReference(_model_base.Model):
    """Kubernetes reference.


    :ivar api_group: APIGroup is the group for the resource being referenced. If APIGroup is not
     specified, the specified Kind must be in the core API group. For any other third-party types,
     APIGroup is required.
    :vartype api_group: str
    :ivar kind: Kind is the type of resource being referenced. Required.
    :vartype kind: str
    :ivar name: Name is the name of resource being referenced. Required.
    :vartype name: str
    """

    api_group: Optional[str] = rest_field(name="apiGroup")
    """APIGroup is the group for the resource being referenced. If APIGroup is not specified, the
     specified Kind must be in the core API group. For any other third-party types, APIGroup is
     required."""
    kind: str = rest_field()
    """Kind is the type of resource being referenced. Required."""
    name: str = rest_field()
    """Name is the name of resource being referenced. Required."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        name: str,
        api_group: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_model_base.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.iotoperations.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.iotoperations.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field()
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities"
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Metrics(_model_base.Model):
    """Diagnostic Metrics properties.

    :ivar prometheus_port: The prometheus port to expose the metrics.
    :vartype prometheus_port: int
    """

    prometheus_port: Optional[int] = rest_field(name="prometheusPort")
    """The prometheus port to expose the metrics."""

    @overload
    def __init__(
        self,
        *,
        prometheus_port: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.iotoperations.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.iotoperations.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.iotoperations.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PrincipalDefinition(_model_base.Model):
    """PrincipalDefinition properties of Rule.

    :ivar attributes: A list of key-value pairs that match the attributes of the clients. The
     attributes are case-sensitive and must match the attributes provided by the clients during
     authentication.
    :vartype attributes: list[dict[str, str]]
    :ivar client_ids: A list of client IDs that match the clients. The client IDs are
     case-sensitive and must match the client IDs provided by the clients during connection.
    :vartype client_ids: list[str]
    :ivar usernames: A list of usernames that match the clients. The usernames are case-sensitive
     and must match the usernames provided by the clients during authentication.
    :vartype usernames: list[str]
    """

    attributes: Optional[List[Dict[str, str]]] = rest_field()
    """A list of key-value pairs that match the attributes of the clients. The attributes are
     case-sensitive and must match the attributes provided by the clients during authentication."""
    client_ids: Optional[List[str]] = rest_field(name="clientIds")
    """A list of client IDs that match the clients. The client IDs are case-sensitive and must match
     the client IDs provided by the clients during connection."""
    usernames: Optional[List[str]] = rest_field()
    """A list of usernames that match the clients. The usernames are case-sensitive and must match the
     usernames provided by the clients during authentication."""

    @overload
    def __init__(
        self,
        *,
        attributes: Optional[List[Dict[str, str]]] = None,
        client_ids: Optional[List[str]] = None,
        usernames: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProfileDiagnostics(_model_base.Model):
    """DataflowProfile Diagnostics properties.

    :ivar logs: Diagnostic log settings for the resource.
    :vartype logs: ~azure.mgmt.iotoperations.models.DiagnosticsLogs
    :ivar metrics: The metrics settings for the resource.
    :vartype metrics: ~azure.mgmt.iotoperations.models.Metrics
    """

    logs: Optional["_models.DiagnosticsLogs"] = rest_field()
    """Diagnostic log settings for the resource."""
    metrics: Optional["_models.Metrics"] = rest_field()
    """The metrics settings for the resource."""

    @overload
    def __init__(
        self,
        *,
        logs: Optional["_models.DiagnosticsLogs"] = None,
        metrics: Optional["_models.Metrics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SanForCert(_model_base.Model):
    """Subject Alternative Names (SANs) for certificate.


    :ivar dns: DNS SANs. Required.
    :vartype dns: list[str]
    :ivar ip: IP address SANs. Required.
    :vartype ip: list[str]
    """

    dns: List[str] = rest_field()
    """DNS SANs. Required."""
    ip: List[str] = rest_field()
    """IP address SANs. Required."""

    @overload
    def __init__(
        self,
        *,
        dns: List[str],
        ip: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SchemaRegistryRef(_model_base.Model):
    """The reference to the Schema Registry for this AIO Instance.


    :ivar resource_id: The resource ID of the Schema Registry. Required.
    :vartype resource_id: str
    """

    resource_id: str = rest_field(name="resourceId")
    """The resource ID of the Schema Registry. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SelfCheck(_model_base.Model):
    """Broker Diagnostic Self check properties.

    :ivar mode: The toggle to enable/disable self check. Known values are: "Enabled" and
     "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar interval_seconds: The self check interval.
    :vartype interval_seconds: int
    :ivar timeout_seconds: The timeout for self check.
    :vartype timeout_seconds: int
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """The toggle to enable/disable self check. Known values are: \"Enabled\" and \"Disabled\"."""
    interval_seconds: Optional[int] = rest_field(name="intervalSeconds")
    """The self check interval."""
    timeout_seconds: Optional[int] = rest_field(name="timeoutSeconds")
    """The timeout for self check."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
        interval_seconds: Optional[int] = None,
        timeout_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SelfTracing(_model_base.Model):
    """Diagnostic Self tracing properties.

    :ivar mode: The toggle to enable/disable self tracing. Known values are: "Enabled" and
     "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar interval_seconds: The self tracing interval.
    :vartype interval_seconds: int
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """The toggle to enable/disable self tracing. Known values are: \"Enabled\" and \"Disabled\"."""
    interval_seconds: Optional[int] = rest_field(name="intervalSeconds")
    """The self tracing interval."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
        interval_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StateStoreResourceRule(_model_base.Model):
    """State Store Resource Rule properties.


    :ivar key_type: Allowed keyTypes pattern, string, binary. The key type used for matching, for
     example pattern tries to match the key to a glob-style pattern and string checks key is equal
     to value provided in keys. Required. Known values are: "Pattern", "String", and "Binary".
    :vartype key_type: str or ~azure.mgmt.iotoperations.models.StateStoreResourceKeyTypes
    :ivar keys_property: Give access to state store keys for the corresponding principals defined.
     When key type is pattern set glob-style pattern (e.g., '\\ *', 'clients/*\\ '). Required.
    :vartype keys_property: list[str]
    :ivar method: Give access for ``Read``\\ , ``Write`` and ``ReadWrite`` access level. Required.
     Known values are: "Read", "Write", and "ReadWrite".
    :vartype method: str or ~azure.mgmt.iotoperations.models.StateStoreResourceDefinitionMethods
    """

    key_type: Union[str, "_models.StateStoreResourceKeyTypes"] = rest_field(name="keyType")
    """Allowed keyTypes pattern, string, binary. The key type used for matching, for example pattern
     tries to match the key to a glob-style pattern and string checks key is equal to value provided
     in keys. Required. Known values are: \"Pattern\", \"String\", and \"Binary\"."""
    keys_property: List[str] = rest_field(name="keys")
    """Give access to state store keys for the corresponding principals defined. When key type is
     pattern set glob-style pattern (e.g., '\ *', 'clients/*\ '). Required."""
    method: Union[str, "_models.StateStoreResourceDefinitionMethods"] = rest_field()
    """Give access for ``Read``\ , ``Write`` and ``ReadWrite`` access level. Required. Known values
     are: \"Read\", \"Write\", and \"ReadWrite\"."""

    @overload
    def __init__(
        self,
        *,
        key_type: Union[str, "_models.StateStoreResourceKeyTypes"],
        keys_property: List[str],
        method: Union[str, "_models.StateStoreResourceDefinitionMethods"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubscriberQueueLimit(_model_base.Model):
    """The settings of Subscriber Queue Limit.

    :ivar length: The maximum length of the queue before messages start getting dropped.
    :vartype length: int
    :ivar strategy: The strategy to use for dropping messages from the queue. Known values are:
     "None" and "DropOldest".
    :vartype strategy: str or ~azure.mgmt.iotoperations.models.SubscriberMessageDropStrategy
    """

    length: Optional[int] = rest_field()
    """The maximum length of the queue before messages start getting dropped."""
    strategy: Optional[Union[str, "_models.SubscriberMessageDropStrategy"]] = rest_field()
    """The strategy to use for dropping messages from the queue. Known values are: \"None\" and
     \"DropOldest\"."""

    @overload
    def __init__(
        self,
        *,
        length: Optional[int] = None,
        strategy: Optional[Union[str, "_models.SubscriberMessageDropStrategy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.iotoperations.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.iotoperations.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TlsCertMethod(_model_base.Model):
    """Collection of different TLS types, NOTE- Enum at a time only one of them needs to be supported.


    :ivar mode: Mode of TLS server certificate management. Required. Known values are: "Automatic"
     and "Manual".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.TlsCertMethodMode
    :ivar cert_manager_certificate_spec: Option 1 - Automatic TLS server certificate management
     with cert-manager.
    :vartype cert_manager_certificate_spec:
     ~azure.mgmt.iotoperations.models.CertManagerCertificateSpec
    :ivar manual: Option 2 - Manual TLS server certificate management through a defined secret.
    :vartype manual: ~azure.mgmt.iotoperations.models.X509ManualCertificate
    """

    mode: Union[str, "_models.TlsCertMethodMode"] = rest_field()
    """Mode of TLS server certificate management. Required. Known values are: \"Automatic\" and
     \"Manual\"."""
    cert_manager_certificate_spec: Optional["_models.CertManagerCertificateSpec"] = rest_field(
        name="certManagerCertificateSpec"
    )
    """Option 1 - Automatic TLS server certificate management with cert-manager."""
    manual: Optional["_models.X509ManualCertificate"] = rest_field()
    """Option 2 - Manual TLS server certificate management through a defined secret."""

    @overload
    def __init__(
        self,
        *,
        mode: Union[str, "_models.TlsCertMethodMode"],
        cert_manager_certificate_spec: Optional["_models.CertManagerCertificateSpec"] = None,
        manual: Optional["_models.X509ManualCertificate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TlsProperties(_model_base.Model):
    """Tls properties.

    :ivar mode: Mode for TLS. Known values are: "Enabled" and "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar trusted_ca_certificate_config_map_ref: Trusted CA certificate config map.
    :vartype trusted_ca_certificate_config_map_ref: str
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """Mode for TLS. Known values are: \"Enabled\" and \"Disabled\"."""
    trusted_ca_certificate_config_map_ref: Optional[str] = rest_field(name="trustedCaCertificateConfigMapRef")
    """Trusted CA certificate config map."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
        trusted_ca_certificate_config_map_ref: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Traces(_model_base.Model):
    """Broker Diagnostic Trace properties.

    :ivar mode: The toggle to enable/disable traces. Known values are: "Enabled" and "Disabled".
    :vartype mode: str or ~azure.mgmt.iotoperations.models.OperationalMode
    :ivar cache_size_megabytes: The cache size in megabytes.
    :vartype cache_size_megabytes: int
    :ivar self_tracing: The self tracing properties.
    :vartype self_tracing: ~azure.mgmt.iotoperations.models.SelfTracing
    :ivar span_channel_capacity: The span channel capacity.
    :vartype span_channel_capacity: int
    """

    mode: Optional[Union[str, "_models.OperationalMode"]] = rest_field()
    """The toggle to enable/disable traces. Known values are: \"Enabled\" and \"Disabled\"."""
    cache_size_megabytes: Optional[int] = rest_field(name="cacheSizeMegabytes")
    """The cache size in megabytes."""
    self_tracing: Optional["_models.SelfTracing"] = rest_field(name="selfTracing")
    """The self tracing properties."""
    span_channel_capacity: Optional[int] = rest_field(name="spanChannelCapacity")
    """The span channel capacity."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OperationalMode"]] = None,
        cache_size_megabytes: Optional[int] = None,
        self_tracing: Optional["_models.SelfTracing"] = None,
        span_channel_capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_model_base.Model):
    """User assigned identity properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VolumeClaimResourceRequirements(_model_base.Model):
    """VolumeClaimResourceRequirements properties.

    :ivar limits: Limits describes the maximum amount of compute resources allowed. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/.
    :vartype limits: dict[str, str]
    :ivar requests: Requests describes the minimum amount of compute resources required. If
     Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
     otherwise to an implementation-defined value. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/.
    :vartype requests: dict[str, str]
    """

    limits: Optional[Dict[str, str]] = rest_field()
    """Limits describes the maximum amount of compute resources allowed. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/."""
    requests: Optional[Dict[str, str]] = rest_field()
    """Requests describes the minimum amount of compute resources required. If Requests is omitted for
     a container, it defaults to Limits if that is explicitly specified, otherwise to an
     implementation-defined value. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/."""

    @overload
    def __init__(
        self,
        *,
        limits: Optional[Dict[str, str]] = None,
        requests: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeClaimSpec(_model_base.Model):
    """VolumeClaimSpec properties.

    :ivar volume_name: VolumeName is the binding reference to the PersistentVolume backing this
     claim.
    :vartype volume_name: str
    :ivar volume_mode: volumeMode defines what type of volume is required by the claim. Value of
     Filesystem is implied when not included in claim spec. This is a beta feature.
    :vartype volume_mode: str
    :ivar storage_class_name: Name of the StorageClass required by the claim. More info:
     https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1.
    :vartype storage_class_name: str
    :ivar access_modes: AccessModes contains the desired access modes the volume should have. More
     info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1.
    :vartype access_modes: list[str]
    :ivar data_source: This field can be used to specify either: * An existing VolumeSnapshot
     object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If
     the provisioner or an external controller can support the specified data source, it will create
     a new volume based on the contents of the specified data source. If the AnyVolumeDataSource
     feature gate is enabled, this field will always have the same contents as the DataSourceRef
     field.
    :vartype data_source: ~azure.mgmt.iotoperations.models.LocalKubernetesReference
    :ivar data_source_ref: Specifies the object from which to populate the volume with data, if a
     non-empty volume is desired. This may be any local object from a non-empty API group (non core
     object) or a PersistentVolumeClaim object. When this field is specified, volume binding will
     only succeed if the type of the specified object matches some installed volume populator or
     dynamic provisioner. This field will replace the functionality of the DataSource field and as
     such if both fields are non-empty, they must have the same value. For backwards compatibility,
     both fields (DataSource and DataSourceRef) will be set to the same value automatically if one
     of them is empty and the other is non-empty. There are two important differences between
     DataSource and DataSourceRef: * While DataSource only allows two specific types of objects,
     DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While
     DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and
     generates an error if a disallowed value is specified. (Beta) Using this field requires the
     AnyVolumeDataSource feature gate to be enabled.
    :vartype data_source_ref: ~azure.mgmt.iotoperations.models.KubernetesReference
    :ivar resources: Resources represents the minimum resources the volume should have. If
     RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource
     requirements that are lower than previous value but must still be higher than capacity recorded
     in the status field of the claim. More info:
     https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources.
    :vartype resources: ~azure.mgmt.iotoperations.models.VolumeClaimResourceRequirements
    :ivar selector: A label query over volumes to consider for binding.
    :vartype selector: ~azure.mgmt.iotoperations.models.VolumeClaimSpecSelector
    """

    volume_name: Optional[str] = rest_field(name="volumeName")
    """VolumeName is the binding reference to the PersistentVolume backing this claim."""
    volume_mode: Optional[str] = rest_field(name="volumeMode")
    """volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied
     when not included in claim spec. This is a beta feature."""
    storage_class_name: Optional[str] = rest_field(name="storageClassName")
    """Name of the StorageClass required by the claim. More info:
     https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1."""
    access_modes: Optional[List[str]] = rest_field(name="accessModes")
    """AccessModes contains the desired access modes the volume should have. More info:
     https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1."""
    data_source: Optional["_models.LocalKubernetesReference"] = rest_field(name="dataSource")
    """This field can be used to specify either: * An existing VolumeSnapshot object
     (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the
     provisioner or an external controller can support the specified data source, it will create a
     new volume based on the contents of the specified data source. If the AnyVolumeDataSource
     feature gate is enabled, this field will always have the same contents as the DataSourceRef
     field."""
    data_source_ref: Optional["_models.KubernetesReference"] = rest_field(name="dataSourceRef")
    """Specifies the object from which to populate the volume with data, if a non-empty volume is
     desired. This may be any local object from a non-empty API group (non core object) or a
     PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if
     the type of the specified object matches some installed volume populator or dynamic
     provisioner. This field will replace the functionality of the DataSource field and as such if
     both fields are non-empty, they must have the same value. For backwards compatibility, both
     fields (DataSource and DataSourceRef) will be set to the same value automatically if one of
     them is empty and the other is non-empty. There are two important differences between
     DataSource and DataSourceRef: * While DataSource only allows two specific types of objects,
     DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While
     DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and
     generates an error if a disallowed value is specified. (Beta) Using this field requires the
     AnyVolumeDataSource feature gate to be enabled."""
    resources: Optional["_models.VolumeClaimResourceRequirements"] = rest_field()
    """Resources represents the minimum resources the volume should have. If
     RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource
     requirements that are lower than previous value but must still be higher than capacity recorded
     in the status field of the claim. More info:
     https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources."""
    selector: Optional["_models.VolumeClaimSpecSelector"] = rest_field()
    """A label query over volumes to consider for binding."""

    @overload
    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        volume_mode: Optional[str] = None,
        storage_class_name: Optional[str] = None,
        access_modes: Optional[List[str]] = None,
        data_source: Optional["_models.LocalKubernetesReference"] = None,
        data_source_ref: Optional["_models.KubernetesReference"] = None,
        resources: Optional["_models.VolumeClaimResourceRequirements"] = None,
        selector: Optional["_models.VolumeClaimSpecSelector"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeClaimSpecSelector(_model_base.Model):
    """VolumeClaimSpecSelector properties.

    :ivar match_expressions: MatchExpressions is a list of label selector requirements. The
     requirements are ANDed.
    :vartype match_expressions:
     list[~azure.mgmt.iotoperations.models.VolumeClaimSpecSelectorMatchExpressions]
    :ivar match_labels: MatchLabels is a map of {key,value} pairs. A single {key,value} in the
     matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the
     operator is "In", and the values array contains only "value". The requirements are ANDed.
    :vartype match_labels: dict[str, str]
    """

    match_expressions: Optional[List["_models.VolumeClaimSpecSelectorMatchExpressions"]] = rest_field(
        name="matchExpressions"
    )
    """MatchExpressions is a list of label selector requirements. The requirements are ANDed."""
    match_labels: Optional[Dict[str, str]] = rest_field(name="matchLabels")
    """MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is
     equivalent to an element of matchExpressions, whose key field is \"key\", the operator is
     \"In\", and the values array contains only \"value\". The requirements are ANDed."""

    @overload
    def __init__(
        self,
        *,
        match_expressions: Optional[List["_models.VolumeClaimSpecSelectorMatchExpressions"]] = None,
        match_labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeClaimSpecSelectorMatchExpressions(_model_base.Model):
    """VolumeClaimSpecSelectorMatchExpressions properties.


    :ivar key: key is the label key that the selector applies to. Required.
    :vartype key: str
    :ivar operator: operator represents a key's relationship to a set of values. Valid operators
     are In, NotIn, Exists and DoesNotExist. Required. Known values are: "In", "NotIn", "Exists",
     and "DoesNotExist".
    :vartype operator: str or ~azure.mgmt.iotoperations.models.OperatorValues
    :ivar values_property: values is an array of string values. If the operator is In or NotIn, the
     values array must be non-empty. If the operator is Exists or DoesNotExist, the values array
     must be empty. This array is replaced during a strategic merge patch.
    :vartype values_property: list[str]
    """

    key: str = rest_field()
    """key is the label key that the selector applies to. Required."""
    operator: Union[str, "_models.OperatorValues"] = rest_field()
    """operator represents a key's relationship to a set of values. Valid operators are In, NotIn,
     Exists and DoesNotExist. Required. Known values are: \"In\", \"NotIn\", \"Exists\", and
     \"DoesNotExist\"."""
    values_property: Optional[List[str]] = rest_field(name="values")
    """values is an array of string values. If the operator is In or NotIn, the values array must be
     non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This
     array is replaced during a strategic merge patch."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        operator: Union[str, "_models.OperatorValues"],
        values_property: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class X509ManualCertificate(_model_base.Model):
    """X509 Certificate Authentication properties.


    :ivar secret_ref: Kubernetes secret containing an X.509 client certificate. This is a reference
     to the secret through an identifying name, not the secret itself. Required.
    :vartype secret_ref: str
    """

    secret_ref: str = rest_field(name="secretRef")
    """Kubernetes secret containing an X.509 client certificate. This is a reference to the secret
     through an identifying name, not the secret itself. Required."""

    @overload
    def __init__(
        self,
        *,
        secret_ref: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
