/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * Iterates over the parameters passed in (or out) of a call.
 * These are used in this Xml-Rpc package for input and output.
 *
 * @author Elias Ross
 * @version 1.0
 * @see IteratorAdapter How to wrap an existing Iterator
 * @see MapAdapter How to wrap an existing Map
 * @see XmlRpcHandler An example of how it is being used for input
 * and output.
 */
public interface ParamIterator 
{
	/**
	 * This indicates a top-level ParamIterator, used for iterating over
	 * the top-level &lt;param&gt; tags.
	 */
	int PARAMS_ITERATOR = 1;

	/**
	 * This is indicates a secondary or deeper &lt;array&gt; is being
	 * iterated over.
	 */
	int ARRAY_ITERATOR = 2;

	/**
	 * This is indicates a secondary or deeper &lt;struct&gt; is being
	 * iterated over.  <code>next()</code> should return a StructPair.
	 */
	int STRUCT_ITERATOR = 3;

	/**
	 * This is indicates parameters are being supplied from a
	 * &lt;fault&gt; result.
	 */
	int FAULT_ITERATOR = 4;

	/**
	 * The iterator type is used for hinting the kinds of data to
	 * expect from the next() call.  This is used primarily for
	 * clarifying the Xml-Rpc to Java datatype conversion upon data
	 * input, however, it is also useful for passing data out.  In
	 * the case of passing out structures, it makes it clear to
	 * format input data as a structure not an array.
	 */
	int getIteratorType();

	/** 
	 * This will return a basic java type, or possibly another
	 * ParamIterator.  Iterators returned in this way affect the
	 * underlying input/output stream.
	 * @see XmlRpcParamIterator#next()
	 * @see XmlRpcWriter#writeResponse(ParamIterator)
	 * @return next parameter
	 * @throws XmlRpcException if there is some problem retreiving the next
	 * parameter.
	 */
	Object next() 
		throws XmlRpcException;
	
	/** 
	 * @return true if an additional object is available for reading.
	 * @throws XmlRpcException if there is some problem checking for the next
	 * parameter from the stream.
	 */
	boolean hasNext() 
		throws XmlRpcException;

	/** 
	 * This method closes underlying input/output stream.
	 * Calling close() is required, since it will release underlying
	 * resources.
	 * @throws XmlRpcException if the close operation could not be
	 * completed.
	 */
	void close() 
		throws XmlRpcException;
}
