/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.builder.ByteArray;

public final class Label {
    private int pc = -1;
    private ByteArray code;
    private Label next;
    private int lastReference = -1;

    public Label(ByteArray code) {
        this.code = code;
    }

    public int getOffset(boolean isWide) {
        if (this.isDefined()) {
            int offset = this.pc - this.code.getPC();
            return offset;
        }
        int previous = 0;
        if (this.hasFixups()) {
            previous = this.lastReference - this.code.getPC();
            if (isWide) {
                throw new UnsupportedOperationException("Sorry, I never implemented isWide");
            }
        }
        this.lastReference = this.code.getPC();
        return previous;
    }

    public boolean hasFixups() {
        return this.lastReference != -1;
    }

    public Label next() {
        return this.next;
    }

    public boolean isDefined() {
        return this.pc != -1;
    }

    public void define() {
        this.setPC(this.code.getPC());
    }

    public void setPC(int pc) {
        if (this.pc != -1) {
            throw new IllegalStateException("Label has already been defined: " + this.pc);
        }
        this.pc = pc;
        if (this.hasFixups()) {
            int fixPC = this.lastReference;
            int prior = 0;
            do {
                prior = this.code.getI2(fixPC + 1);
                int offset = pc - fixPC;
                this.code.put2(fixPC + 1, offset);
                fixPC += prior;
            } while (prior != 0);
            this.lastReference = -1;
        }
    }
}

