# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AutoUpdateRingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Auto update Ring type."""

    PREVIEW = "Preview"
    """customer selection of preview update install mcc on their physical vm"""
    SLOW = "Slow"
    """customer selection of slow update to install mcc on their physical vm"""
    FAST = "Fast"
    """customer selection of fast / auto update to install mcc on their physical vm"""


class BgpReviewStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cache node resource Bgp review state as integer."""

    NOT_CONFIGURED = "NotConfigured"
    """bgp not configured"""
    IN_REVIEW = "InReview"
    """bgp is in review state"""
    APPROVED = "Approved"
    """bgp is in Approved state"""
    ATTENTION_REQUIRED = "AttentionRequired"
    """bgp is setup need an attention for more troubleshoot"""


class ConfigurationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cache node configuration setup state."""

    CONFIGURED = "Configured"
    """connected cache setup configured"""
    NOT_CONFIGURED_IP = "NotConfigured_Ip"
    """connected cache setup not configured"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CustomerTransitState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Customer resource transit states."""

    NO_TRANSIT = "NoTransit"
    """do not have transit"""
    COMBINED_TRANSIT = "CombinedTransit"
    """transit provider and have own subscribers"""
    TRANSIT_ONLY = "TransitOnly"
    """pure transit provider or network service provider"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class OsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operating System of the cache node."""

    WINDOWS = "Windows"
    """cache node installs on windows operating system"""
    LINUX = "Linux"
    """cache node installs on Linux Operating system"""
    EFLOW = "Eflow"
    """cache node installs on Azure Eflow"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    UNKNOWN = "Unknown"
    """unknown  state of the provisioning state"""
    ACCEPTED = "Accepted"
    """Accepted state of the provisioning state during the Async Operations"""
    UPGRADING = "Upgrading"
    """Upgrading state of the provisioning state"""
    DELETING = "Deleting"
    """Deleting state of the provisioning state"""


class ProxyRequired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Proxy details enum."""

    NONE = "None"
    """Proxy is not required in setup"""
    REQUIRED = "Required"
    """proxy is required in setup"""
