# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How to authenticate users who access local diagnostics APIs."""

    #: Use AAD SSO to authenticate the user (this requires internet access).
    AAD = "AAD"
    #: Use locally stored passwords to authenticate the user.
    PASSWORD = "Password"


class BillingSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU of the packet core control plane resource. The SKU list may change over time when a new
    SKU gets added or an exiting SKU gets removed.
    """

    #: 100 Mbps, 20 active SIMs plan
    G0 = "G0"
    #: 1 Gbps, 100 active SIMs plan
    G1 = "G1"
    #: 2 Gbps, 200 active SIMs plan
    G2 = "G2"
    #: 3 Gbps, 300 active SIMs plan
    G3 = "G3"
    #: 4 Gbps, 400 active SIMs plan
    G4 = "G4"
    #: 5 Gbps, 500 active SIMs plan
    G5 = "G5"
    #: 10 Gbps, 1000 active SIMs plan
    G10 = "G10"


class CertificateProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The certificate's provisioning state."""

    #: The certificate has not been provisioned.
    NOT_PROVISIONED = "NotProvisioned"
    #: The certificate has been provisioned.
    PROVISIONED = "Provisioned"
    #: The certificate failed to be provisioned. The "reason" property explains why.
    FAILED = "Failed"


class CoreNetworkType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The core network technology generation (5G core or EPC / 4G core)."""

    #: 5G core
    FIVE_GC = "5GC"
    #: EPC / 4G core
    EPC = "EPC"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class InstallationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The installation state of the packet core."""

    #: The packet core is uninstalled.
    UNINSTALLED = "Uninstalled"
    #: The packet core is installing.
    INSTALLING = "Installing"
    #: The packet core is installed.
    INSTALLED = "Installed"
    #: The packet core is updating its configuration.
    UPDATING = "Updating"
    #: The packet core is upgrading to a different software version.
    UPGRADING = "Upgrading"
    #: The packet core is uninstalling.
    UNINSTALLING = "Uninstalling"
    #: The packet core is reinstalling.
    REINSTALLING = "Reinstalling"
    #: The packet core is rolling back to its previous version.
    ROLLING_BACK = "RollingBack"
    #: The packet core is in failed state.
    FAILED = "Failed"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class NaptEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether network address and port translation is enabled."""

    #: NAPT is enabled
    ENABLED = "Enabled"
    #: NAPT is disabled
    DISABLED = "Disabled"


class ObsoleteVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether this version is obsolete."""

    #: This version is obsolete for use in new packet core control plane deployments.
    OBSOLETE = "Obsolete"
    #: This version is not obsolete for use in new packet core control plane deployments.
    NOT_OBSOLETE = "NotObsolete"


class PduSessionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PDU session type (IPv4/IPv6)."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class PlatformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The platform type where packet core is deployed. The contents of this enum can change."""

    #: If this option is chosen, you must set one of "azureStackEdgeDevice", "connectedCluster" or
    #: "customLocation". If multiple are set, they must be consistent with each other.
    AKS_HCI = "AKS-HCI"
    #: If this option is chosen, you must set one of "azureStackHciCluster", "connectedCluster" or
    #: "customLocation". If multiple are set, they must be consistent with each other.
    THREE_P_AZURE_STACK_HCI = "3P-AZURE-STACK-HCI"


class PreemptionCapability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preemption capability."""

    #: Cannot preempt
    NOT_PREEMPT = "NotPreempt"
    #: May preempt
    MAY_PREEMPT = "MayPreempt"


class PreemptionVulnerability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preemption vulnerability."""

    #: Cannot be preempted
    NOT_PREEMPTABLE = "NotPreemptable"
    #: May be preempted
    PREEMPTABLE = "Preemptable"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"


class RecommendedVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether this is the recommended version to use for new packet core control plane
    deployments.
    """

    #: This is the recommended version to use for new packet core control plane deployments.
    RECOMMENDED = "Recommended"
    #: This is not the recommended version to use for new packet core control plane deployments.
    NOT_RECOMMENDED = "NotRecommended"


class SdfDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Service data flow direction."""

    #: Traffic flowing from the UE to the data network.
    UPLINK = "Uplink"
    #: Traffic flowing from the data network to the UE.
    DOWNLINK = "Downlink"
    #: Traffic flowing both to and from the UE.
    BIDIRECTIONAL = "Bidirectional"


class SimState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the SIM resource."""

    #: The SIM is disabled because not all configuration required for enabling is present.
    DISABLED = "Disabled"
    #: The SIM is enabled.
    ENABLED = "Enabled"
    #: The SIM cannot be enabled because some of the associated configuration is invalid.
    INVALID = "Invalid"


class SiteProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource e.g. SIM/SIM policy on a site."""

    #: The resource should not be provisioned on this site.
    NOT_APPLICABLE = "NotApplicable"
    #: The resource is being added to this site.
    ADDING = "Adding"
    #: The resource is being updated on this site.
    UPDATING = "Updating"
    #: The resource is being deleted from this site.
    DELETING = "Deleting"
    #: The resource is provisioned on this site.
    PROVISIONED = "Provisioned"
    #: The resource failed to be provisioned on this site.
    FAILED = "Failed"


class TrafficControlPermission(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Traffic control permission."""

    #: Traffic matching this rule is allowed to flow.
    ENABLED = "Enabled"
    #: Traffic matching this rule is not allowed to flow.
    BLOCKED = "Blocked"


class VersionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of this packet core control plane version."""

    #: The state of this version is unknown.
    UNKNOWN = "Unknown"
    #: This version is a preview and is not suitable for production use.
    PREVIEW = "Preview"
    #: This version is currently being validated.
    VALIDATING = "Validating"
    #: This version failed validation.
    VALIDATION_FAILED = "ValidationFailed"
    #: This version is active and suitable for production use.
    ACTIVE = "Active"
    #: This version is deprecated and is no longer supported.
    DEPRECATED = "Deprecated"
