# Papers and talks, citations

## Papers

   * [Awkward Arrays in Python, C++, and Numba](https://doi.org/10.1051/epjconf/202024505023) (published in EPJ Web of Conferences; [arXiv](https://arxiv.org/abs/2001.06307)) on July 2, 2020.
   * [AwkwardForth: accelerating Uproot with an internal DSL](https://doi.org/10.1051/epjconf/202125103002) (published in EPJ Web of Conferences; [arXiv](https://arxiv.org/abs/2102.13516)) on February 24, 2021.
   * [An array-oriented Python interface for FastJet](https://doi.org/10.1088/1742-6596/2438/1/012011) (published in ACAT 2021 proceedings; [arXiv](https://arxiv.org/abs/2202.03911)) on February 8, 2022.
   * [Awkward to RDataFrame and back](https://doi.org/10.48550/arXiv.2302.09860) (to be published in ACAT 2022 proceedings; [arXiv](https://arxiv.org/abs/2302.09860)) on February 20, 2023.
   * [Using a DSL to read ROOT TTrees faster in Uproot](https://doi.org/10.48550/arXiv.2303.02202) (to be published in ACAT 2022 proceedings; [arXiv](https://arxiv.org/abs/2303.02202)) on March 3, 2023.
   * [The Awkward World of Python and C++](https://doi.org/10.48550/arXiv.2303.02205) (to be published in ACAT 2022 proceedings; [arXiv](https://arxiv.org/abs/2303.02205)) on March 3, 2023.
   * [Awkward Just-In-Time (JIT) Compilation: A Developer's Experience](https://doi.org/10.1051/epjconf/202429506003) (published in EPJ Web of Conferences; [arXiv](https://arxiv.org/abs/2310.01461)) on October 6, 2024.

## Talks

   * [StrangeLoop talk](https://www.thestrangeloop.com/2019/jagged-ragged-awkward-arrays.html) ([video](https://youtu.be/2NxWpU7NArk)) on September 14, 2019: motivation for Awkward Arrays.
   * [PyHEP talk](https://indico.cern.ch/event/833895/contributions/3577882) on October 17, 2019: motivation for Awkward 1.0.
   * [CHEP talk](https://indico.cern.ch/event/773049/contributions/3473258) on November 7, 2019: architecture of Awkward 1.0.
   * [Summary poster](https://github.com/jpivarski/2020-02-27-irishep-poster/blob/master/pivarski-irishep-poster.pdf) on February 27, 2020: overview.
   * [Presentation at SciPy 2020](http://conference.scipy.org.s3-website-us-east-1.amazonaws.com/proceedings/scipy2020/jim_pivarski.html) ([video](https://youtu.be/WlnUF3LRBj4)) on July 5, 2020: introduction beyond HEP.
   * [Lessons learned in Python-C++ integration](https://indico.cern.ch/event/855454/contributions/4605044/) ([video](https://videos.cern.ch/record/2295164)) on December 1, 2021: the motivation for Awkward version 2.0.
   * [Awkward Array updates](https://indico.cern.ch/event/1140031/) on April 6, 2022: an overview of Awkward version 2.0.
   * [CSSI summary (poster)](https://github.com/jpivarski-talks/2022-07-25-cssi-meeting-poster/blob/main/pivarski-awkward-cssi-poster.pdf) on July 5, 2022: applications beyond HEP.
   * [All about AwkwardForth](https://github.com/jpivarski-talks/2023-03-06-awkwardforth-for-atlas/blob/main/main.pdf) on March 6, 2023: how & why of the AwkwardForth minilanguage.
   * [Awkward Array in Tiled](https://indico.cern.ch/event/1311780/) on October 25, 2023: integration with the Tiled database.
   * [Awkward Array in Julia](https://indico.cern.ch/event/1292759/contributions/5613061/) on November 6, 2023: AwkwardArray.jl.
   * [Awkward family (poster)](https://github.com/jpivarski-talks/2024-03-11-acat2024-awkward-family-poster/blob/main/pivarski-acat2024-poster.pdf) on March 11, 2024: the ecosystem built around Awkward Array.
   * [MODE workshop talk](https://indi.to/8WZTS) on June 11, 2025: differentiable computation with Awkward Array and JAX.

## Tutorials

   * [Tutorial for the Electron Ion Collider (EIC)](https://github.com/jpivarski-talks/2020-04-08-eic-jlab) ([agenda](https://indico.bnl.gov/event/8242/), [video](https://www.youtube.com/watch?v=FoxNS6nlbD0)) on April 8, 2020.
   * [Uproot Awkward Columnar HATS (2020)](https://github.com/jpivarski-talks/2020-06-08-uproot-awkward-columnar-hats) ([agenda](https://indico.cern.ch/event/917675)) on June 8, 2020.
   * [Tutorial at PyHEP 2020](https://github.com/jpivarski-talks/2020-07-13-pyhep2020-tutorial) ([agenda](https://indico.cern.ch/event/882824/timetable), [video](https://youtu.be/ea-zYLQBS4U)) on July 13, 2020.
   * [PyHEP Numba tutorial](https://github.com/jpivarski-talks/2021-02-03-pyhep-numba-tutorial) ([agenda](https://indico.cern.ch/event/985350/), [video](https://youtu.be/X_BJrmofRWQ)) on February 3, 2021.
   * [Uproot Awkward Columnar HATS (2021)](https://github.com/jpivarski-talks/2021-06-14-uproot-awkward-columnar-hats) ([agenda](https://indico.cern.ch/event/1042866/)) on June 14, 2021.
   * [Tutorial at PyHEP 2021](https://github.com/jpivarski-talks/2021-07-06-pyhep-uproot-awkward-tutorial) ([agenda](https://indico.cern.ch/event/1019958/timetable/#20210705.detailed), [video](https://youtu.be/s47Nz0h0vcg)) on July 6, 2021.
   * [Tutorial for the STAR collaboration](https://github.com/jpivarski-talks/2021-09-13-star-uproot-awkward-tutorial) ([video](https://youtu.be/NnU_zp5s1MY)) on September 13, 2021.
   * [Loopy and Unloopy programming techniques (SciPy 2022)](https://github.com/jpivarski-talks/2022-07-11-scipy-loopy-tutorial) ([agenda](https://www.scipy2022.scipy.org/tutorials-schedule), [video](https://youtu.be/Dovyd72eD70)) on July 11, 2022.
   * [CoDaS-HEP Columnar Analysis](https://github.com/jpivarski-talks/2022-08-03-codas-hep-columnar-tutorial) ([agenda](https://indico.cern.ch/event/1151367/timetable/#41-columnar-data-analysis)) on August 3, 2022.
   * [HSF-India Mumbai](https://github.com/jpivarski-talks/2023-05-01-hsf-india-tutorial) ([agenda](https://indico.cern.ch/event/1254939/)) on May 1, 2023.
   * [Thinking in Arrays (SciPy 2023)](https://github.com/jpivarski-talks/2023-07-11-scipy2023-tutorial-thinking-in-arrays) ([agenda](https://www.scipy2023.scipy.org/schedule/), [video](https://youtu.be/d7etLJeK20M?si=m9b3YttCtz8nP31g)) on July 11, 2023.
   * [HSF-India Bhubaneswar](https://github.com/jpivarski-talks/2023-12-18-hsf-india-tutorial-bhubaneswar) ([agenda](https://indico.cern.ch/event/1328624/)) on December 18, 2023.

## Citations

To cite Awkward Array, please use [![](https://zenodo.org/badge/DOI/10.5281/zenodo.4341376.svg)](https://doi.org/10.5281/zenodo.4341376)

```bibtex
@software{Pivarski_Awkward_Array_2018,
author = {Pivarski, Jim and Osborne, Ianna and Ifrim, Ioana and Schreiner, Henry and Hollands, Angus and Biswas, Anish and Das, Pratyush and Roy Choudhury, Santam and Smith, Nicholas and Goyal, Manasvi},
doi = {10.5281/zenodo.4341376},
month = {10},
title = {{Awkward Array}},
year = {2018}
}
```
