/*
 * Copyright (c) 2013, European Bioinformatics Institute (EMBL-EBI)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of the FreeBSD Project.
 */

package uk.ac.ebi.beam;

import org.junit.Assert;
import org.junit.Test;

import static org.hamcrest.CoreMatchers.is;

/** @author John May */
public class AtomCentricDBConfigTest {

    @Test public void difluoroethene_implConfig() throws
                                                  InvalidSmilesException {
        String input = "F[C@H]=[C@H]F";
        Graph g = Parser.parse(input);
        Assert.assertThat(g.topologyOf(1)
                           .configuration(), is(Configuration.DB1));
        Assert.assertThat(g.topologyOf(2)
                           .configuration(), is(Configuration.DB1));
    }

    @Test public void difluoroethene_implConfig2() throws
                                                   InvalidSmilesException {
        String input = "F[C@@H]=[C@@H]F";
        Graph g = Parser.parse(input);
        Assert.assertThat(g.topologyOf(1)
                           .configuration(), is(Configuration.DB2));
        Assert.assertThat(g.topologyOf(2)
                           .configuration(), is(Configuration.DB2));
    }

    @Test public void difluoroethene_expConfig() throws InvalidSmilesException {
        String input = "F[C@DB1H]=[C@DB1H]F";
        Graph g = Parser.parse(input);
        Assert.assertThat(g.topologyOf(1)
                           .configuration(), is(Configuration.DB1));
        Assert.assertThat(g.topologyOf(2)
                           .configuration(), is(Configuration.DB1));
    }

    @Test public void difluoroethene_expConfig2() throws
                                                  InvalidSmilesException {
        String input = "F[C@DB2H]=[C@DB2H]F";
        Graph g = Parser.parse(input);
        Assert.assertThat(g.topologyOf(1)
                           .configuration(), is(Configuration.DB2));
        Assert.assertThat(g.topologyOf(2)
                           .configuration(), is(Configuration.DB2));
    }

    @Test public void difluoroethene() throws InvalidSmilesException {
        GeneratorTest.roundTrip("F[C@H]=[C@H]F");
        GeneratorTest.roundTrip("F[C@@H]=[C@@H]F");
        GeneratorTest.roundTrip("F[C@H]=[C@@H]F");
        GeneratorTest.roundTrip("F[C@@H]=[C@H]F");
    }

    @Test public void difluoroethene_permute() throws InvalidSmilesException {
        GeneratorTest.roundTrip("F[C@H]=[C@H]F",
                                new int[]{1, 0, 2, 3},
                                "[C@@H](F)=[C@H]F");
        GeneratorTest.roundTrip("[C@@H](F)=[C@H]F",
                                new int[]{1, 0, 2, 3},
                                "F[C@H]=[C@H]F");
    }

}
