/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.JiapiRuntimeException;
import alt.jiapi.reflect.Loader;
import java.lang.reflect.Modifier;
import org.apache.log4j.Category;

public class FieldAssignInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(FieldAssignInstrumentor.class);
    private String fieldName;
    private Object value;
    private JiapiMethod getFieldValue;

    public FieldAssignInstrumentor(String fieldName, Object value) {
        this.fieldName = fieldName;
        this.value = value;
        Runtime.setFieldValue(fieldName, value);
        try {
            Loader l = new Loader();
            JiapiClass jc = l.loadClass("alt.jiapi.Runtime");
            this.getFieldValue = jc.getDeclaredMethod("getFieldValue", new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public void instrument(InstructionList il) {
        int modifiers = il.getDeclaringMethod().getModifiers();
        if (Modifier.isNative(modifiers) || Modifier.isAbstract(modifiers)) {
            log.info((Object)("Skipping abstract or native method: " + il.getDeclaringMethod().getName()));
            this.forward(il);
            return;
        }
        InstructionFactory factory = il.getDeclaringMethod().getInstructionFactory();
        JiapiClass jc = this.getCurrentClass();
        JiapiField field = null;
        try {
            field = jc.getDeclaredField(this.fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new JiapiRuntimeException("No such field: " + e.getMessage());
        }
        il.add(factory.pushConstant(this.fieldName));
        il.add(factory.invoke(this.getFieldValue));
        il.add(factory.cast(field.getTypeName()));
        il.add(factory.setField(field));
        this.forward(il);
    }
}

