#!/usr/bin/env python
 ############################################################################
 #                                                                          #
 #                            SETUP.PY                                      #
 #                                                                          #
 #            Copyright (C) 2010-2011 Ada Core Technologies, Inc.           #
 #                                                                          #
 # This program is free software: you can redistribute it and/or modify     #
 # it under the terms of the GNU General Public License as published by     #
 # the Free Software Foundation, either version 3 of the License, or        #
 # (at your option) any later version.                                      #
 #                                                                          #
 # This program is distributed in the hope that it will be useful,          #
 # but WITHOUT ANY WARRANTY; without even the implied warranty of           #
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
 # GNU General Public License for more details.                             #
 #                                                                          #
 # You should have received a copy of the GNU General Public License        #
 # along with this program.  If not, see <http://www.gnu.org/licenses/>     #
 #                                                                          #
 ############################################################################

from distutils.command.build_ext import build_ext
from distutils.command.build_scripts import build_scripts
from distutils.core import setup
from distutils.extension import Extension
from distutils.sysconfig import get_python_inc, get_python_lib

import glob
import os
import platform
import sys

from gnatpython import __version__


# Distutils does not support support for compiled programs. So override de
# build_scripts command with ours. We first compile our program and copy
# it along with the Python scripts. Then we call the regular build_scripts
# command.
class build_scripts_gnatpython(build_scripts):
    def run(self):
        if 'Windows' in platform.system() or 'CYGWIN' in platform.system():
            os.system('gcc -o scripts/rlimit src/rlimit/rlimit-NT.c')
        else:
            os.system('gcc -o scripts/rlimit src/rlimit/rlimit.c')
        # Update the scripts list
        self.scripts = glob.glob('scripts/*')

        build_scripts.run(self)


# Our C module requires a mingw compiler. On windows python will use by
# default the Microsoft one and even if we use the --compiler=mingw option
# it does not seem to work all the time. So override the build_ext command.
# If the the platform is windows use out manual procedure. Otherwise use
# the regular build_ext implementation.
class build_ext_gnatpython(build_ext):
    def build_extension(self, ext):
        if 'Windows' not in platform.system() and \
          'CYGWIN' not in platform.system():
            return build_ext.build_extension(self, ext)
        else:
            # Get the python installation prefix
            python_prefix = sys.prefix

            # The Python version
            python_version = "%d.%d" % \
              (sys.version_info[0], sys.version_info[1])

            # The location of the static library (in fact an import library)
            python_lib = "%s/libs/libpython%s%s.a" % \
              (sys.prefix, sys.version_info[0], sys.version_info[1])

            # Find the location of Python includes in various locations.
            python_stdlib_dir = get_python_lib(True, False)
            python_include_dir = None
            for p in (get_python_inc(False),
                      python_stdlib_dir + '/config',
                      python_prefix + '/include/python/%s' % (python_version)):

                if os.path.isfile(p + '/Python.h'):
                    python_include_dir = p
                    break

            # Build our module with mingw GCC
            os.system('gcc -shared -static-libgcc -o %s/gnatpython/_term.pyd %s -I%s %s' % \
                      (self.build_lib, ' '.join(ext.sources),
                      python_include_dir,
                      python_lib))

setup(name='gnatpython',
      version=__version__,
      author="AdaCore",
      author_email="report@adacore.com",
      packages=['gnatpython'],
      scripts=glob.glob('scripts/*'),
      cmdclass={'build_scripts': build_scripts_gnatpython,
                'build_ext': build_ext_gnatpython},
      ext_modules=[Extension('gnatpython._term',
                             ['src/mod_term/terminals.c'])])
