# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceInputOutputSpecification(Model):
    """The swagger 2.0 schema describing the service's inputs or outputs. See
    Swagger specification: http://swagger.io/specification/.

    :param title: The title of your Swagger schema.
    :type title: str
    :param description: The description of the Swagger schema.
    :type description: str
    :param type: The type of the entity described in swagger. Always 'object'.
     Default value: "object" .
    :type type: str
    :param properties: Specifies a collection that contains the column schema
     for each input or output of the web service. For more information, see the
     Swagger specification.
    :type properties: dict
    """

    _validation = {
        'type': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{TableSpecification}'},
    }

    def __init__(self, properties, title=None, description=None, type="object"):
        self.title = title
        self.description = description
        self.type = type
        self.properties = properties
