/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.ExceptionConstants;
import org.aspectj.apache.bcel.generic.AllocationInstruction;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.ExceptionThrower;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.StackProducer;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.Visitor;
import org.aspectj.apache.bcel.util.ByteSequence;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(BasicType type) {
        this(type.getType());
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + Constants.TYPE_NAMES[this.type];
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        this.length = (short)2;
    }

    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

