
#if 1 /* enable DEBUG here */
#define IMMED #
#define	DBG_PUTC(x) \
	   moveb   IMMED x, 0xfffff907; \
	0: movew   0xfffff906, %d7; \
	   andw    IMMED 0x2000, %d7; \
	   beq     0b
#else
#defin DBG_PUTC(x)
#endif

#include <linux/config.h>
        
	.global _start
	.global _stext

	.global _rambase
	.global _ramvec
	.global _ramstart
	.global _ramend
	.global _data_rom_start

#ifdef CONFIG_INIT_LCD
	.global splash_bits
#endif

	.data

/*
 *	Set up the usable of RAM stuff. Size of RAM is determined then
 *	an initial stack set up at the end.
 */
.align 4
_ramvec:
.long   0
_rambase:
.long   0
_ramstart:
.long   0
_ramend:
.long   0
_data_rom_start:
.long   0


#ifdef CONFIG_INIT_LCD
splash_bits:
#include "bootlogo.rh"
#endif
        
	.text
_start:
_stext:
	movew	#0x2700,%sr

	DBG_PUTC('K')

#ifdef CONFIG_RELOCATE
	DBG_PUTC('R')
	/* Copy me to RAM */
	moveal	#__rom_start-0x400, %a0
	moveal	#__ram_start-0x400, %a1
	moveal	#__data_end, %a2

	/* Copy %a0 to %a1 until %a1 == %a2 */
LD1:
	movel	%a0@+, %d0
	movel	%d0, %a1@+
	cmpal	%a1, %a2
	bne	LD1
        
	DBG_PUTC('J')

	/* jump into the RAM copy */
	moveal	#ram_jump, %a0
	jmp	(%a0)

ram_jump:

#endif /* CONFIG_RELOCATE */


#ifdef CONFIG_INIT_LCD
	movel	#splash_bits, 0xfffffA00   /* LSSA */
	moveb	#0x28,   0xfffffA05        /* LVPW */
	movew	#0x280,  0xFFFFFa08        /* LXMAX */
	movew	#0x1df,   0xFFFFFa0a       /* LYMAX */
	moveb	#0,      0xfffffa29        /* LBAR */
	moveb	#0,      0xfffffa25        /* LPXCD */
	moveb	#0x08,   0xFFFFFa20        /* LPICF */
	moveb	#0x01,   0xFFFFFA21        /* -ve pol */
	moveb	#0x81,   0xfffffA27        /* LCKCON */
	movew	#0xff00, 0xfffff412        /* LCD pins */
#endif

#ifdef CONFIG_DIRECT_IO_ACCESS
	moveb	#0x0,   0xfffff000
#endif

	moveal	#__ramend-CONFIG_MEMORY_RESERVE*0x100000 - 0x10, %sp
	movew	#32767, %d0  /* PLL settle wait loop */
1:	subq	#1, %d0
	bne	1b

	DBG_PUTC('L')

	/* clear bss  */

	moveal	#_sbss, %a0
	moveal	#_ebss, %a1
        
	/* Copy 0 to %a0 until %a0 == %a1 */
1:
	clrl	%a0@+
	cmpal	%a0, %a1
	bhi	1b

	DBG_PUTC('D')

	movel	#_sdata,	%d0    
	movel	%d0,	_rambase        
	movel	#_ebss,  %d0
	movel	%d0,	_ramstart
	movel	#__ramend-CONFIG_MEMORY_RESERVE*0x100000, %d0
	movel	%d0,	_ramend
	movel	#__ramvec,	%d0
	movel	%d0,	_ramvec
		
	movel	#__data_end, %d0
	subl	#__data_start, %d0
	addl	#__rom_start,	%d0
		
	/*ALIGN 4*/
	addl	#4,	%d0
	andl	#4,	%d0
		
	movel	%d0,	_data_rom_start
		
#ifdef CONFIG_68328_SERIAL_UART2
	/* Enable RXD TXD port bits to enable UART2 */
	moveb   #0xcf,   0xfffff43b
#endif

	DBG_PUTC('M')
        
/*
 *	load the current task pointer and stack
 */
	lea	init_task_union,%a0
	movel	%a0, _current_task
	lea	0x2000(%a0),%sp

	DBG_PUTC('S')

1:	jsr	start_kernel
	DBG_PUTC('!')
   	bra 1b

_exit:
	jmp	_exit

	.data
env:
	.long	0
	.text


