# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python create_update_aws_cred_connector_subscription_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="20ff7fc3-e762-44dd-bd96-b71116dcdc23",
    )

    response = client.connectors.create_or_update(
        connector_name="aws_dev1",
        connector_setting={
            "properties": {
                "authenticationDetails": {
                    "authenticationType": "awsCreds",
                    "awsAccessKeyId": "<awsAccessKeyId>",
                    "awsSecretAccessKey": "<awsSecretAccessKey>",
                },
                "hybridComputeSettings": {
                    "autoProvision": "On",
                    "proxyServer": {"ip": "167.220.197.140", "port": "34"},
                    "region": "West US 2",
                    "resourceGroupName": "AwsConnectorRG",
                    "servicePrincipal": {"applicationId": "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1", "secret": "<secret>"},
                },
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2020-01-01-preview/examples/Connectors/CreateUpdateAwsCredConnectorSubscription_example.json
if __name__ == "__main__":
    main()
