
/*
 * $Id: who.c,v 1.8 1993/07/01 14:03:10 wade Exp $
 *
 * $Log: who.c,v $
 * Revision 1.8  1993/07/01  14:03:10  wade
 * RT clean compilation
 *
 * Revision 1.7  1993/05/24  16:23:49  wade
 * misc typecasting cleanup
 *
 * Revision 1.6  1993/02/22  16:04:47  wade
 * added finger demo support
 *
 * Revision 1.5  1993/01/06  20:32:24  wade
 * using XtCreatePopupShell now for popups
 *
 * Revision 1.4  1993/01/05  22:16:12  wade
 * changed Class name of popup to Xnetlib
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  16:58:02  larose
 * added rcs logging
 *
 *
 */
#include "xnl.h"


static char HOW_TO_ENROLL[] = "\n\
The \"who\" command uses the na-net whitepages.  To join the\n\
whitepages send mail to na.join-wp@na-net.ornl.gov.  In the \n\
message body specify the two mandatory fields and as many of\n\
the optional fields as you want.\n\
\n\
For more information on the NA-NET white pages send mail to\n\
na.help@na-net.ornl.gov.\n\
\n\
Press \"clear\" to get rid of this text.\n\
To never see this message again set the showWhoInfo resource\n\
to False in your application defaults file.\n\
\n\
Mandatory\n\
---------\n\
Last_name:\n\
First_name:\n\
\n\
\n\
Optional Fields\n\
---------------\n\
Middle_name:\n\
Other_name:\n\
Affiliation:\n\
Office_address:\n\
City_state_zip:\n\
Country:\n\
Office_phone:\n\
Research:\n\
Home_address:\n\
Home_phone:\n\
Fax:\n\
E_mail_address:\n\
Other:\n\
\n";

static char TMP[MAXLINE];

#define ENTRY_SEP app_resources.whoEntrySep


Widget whoLabel, whoEnterText, whoModprintButton, 
	whoQualifyButton, whoClearButton, whoSaveButton, whoCancelButton, 
	whoSaveDialog;

Widget whoToggles[11];

static Boolean click = True;
int whoSocket;
char whoStr[MAXLINE];
char entry[17][MAXLINE];

XtInputCallbackProc whoIncoming();
static void whoSave(), whoClear(),
        whoQualify(), whoMaskOk(), whoMaskClear(), whoMaskSet(),
        whoModprint(), whoToggle(), whoCancel();
void whoDoSave();

#define    SEARCH        0
#define    P_SEARCH    1
#define    SHOW        2
#define    P_SHOW        3

#define    NAME            0
#define    AFFILIATION        1
#define    OFFICE_ADDR        2
#define    OFFICE_PHONE    3
#define    RESEARCH        4
#define    HOME_ADDR        5
#define    HOME_PHONE        6
#define    FAX                7
#define    EMAIL            8
#define    OTHER            9
#define    DATE            10

Boolean        who_mask[4][11];

void
do_who(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    String s;
    Arg args[20];
    char line[MAXLINE];
    register int i;

    if (whoSocket) {
        return;
    }


    XtSetArg(args[0], XtNstring, &s); 
    XtGetValues(whoEnterText, args, 1);
    
    if (!strlen(s)) {
        set_status("no search string", RED);
        return;
    }

    strcpy(whoStr, s);
    i=0;
    while (whoStr[i]) {
        if ( (whoStr[i] == ' ') || (whoStr[i] == '\t') || 
                                        (whoStr[i] == '\n') ) {
            whoStr[i] = 0;
        } else
            i++;
    }
    XtSetArg(args[0], XtNstring, whoStr); 
    XtSetValues(whoEnterText, args, 1);

    sprintf(line, "looking up %s...", whoStr);
    set_status(line, YELLOW);

    strcpy(TMP, tmpnam(NULL));

    whoSocket = nlrexec_service_open("who", WhoisServer,
        EMAIL_ADDRESS);

    if (whoSocket) {
        swrite(whoSocket, whoStr);
        swrite(whoSocket, "\n");

        XtAppAddInput(XtWidgetToApplicationContext(w), whoSocket, 
            (XtPointer)XtInputReadMask, 
			(XtInputCallbackProc)whoIncoming, (XtPointer)NULL);

        set_cursor(CURSOR_BUSY, 0);
        set_cursor(CURSOR_BUSY, whoDisplayText);
        set_cursor(CURSOR_BUSY, whoEnterText);
        grey_the_bar(False);
        grey_the_button(whoCancelButton, True);
    } else {
        set_status("had a problem contacting the server", RED);
    }

}


XtInputCallbackProc whoIncoming(data, s, inputid)
XtPointer data;
int *s;
XtInputId *inputid;
{
    char line[MAXLINE], filename[MAXLINE];
    int got_one = 0;
    int matches = 0;
    FILE *fp;
    char buf[1024];
    int retval;

    XtRemoveInput(*inputid);

    strcpy(filename, TMP);

    if ((fp = fopen(filename, "w")) != NULL) {
#ifdef TERM
        while (retval=read(*s, buf, 1022)) {
#else
        while (retval=recv(*s, buf, 1022, NULL)) {
#endif
            fwrite(buf, 1, retval, fp);
        }
    } else {
        fprintf(stderr, "couldn't open <%s> to write\n", filename);
        return (XtInputCallbackProc)NULL;
    }

	shutdown(whoSocket, 2);
    close(whoSocket);
    whoSocket = (int)NULL;
	fclose(fp);

    if (NULL == (fp = fopen(filename, "r"))) {
        fprintf(stderr, "couldn't open temp whois file\n");
		return (XtInputCallbackProc)NULL;
    }


    XtUnmanageChild(whoDisplayText);

    while (fgets(line, MAXLINE -2, fp)) {
        replace_c(line, '\n', '\0');
        replace(line, "\001", "\n\t\t");
        strcpy(entry[ got_one % 17 ], line);
        if (strcmp(line, "_THE_END_THE_END_") == 0)
            break;
        got_one++;
        if (got_one && ((got_one % 17) == 0) ) {
          if (good_match(whoStr)) {
           matches++;
           if (who_mask[SHOW][NAME]) {
            sprintf(line, "%s %s %s (%s)\n",
                entry[1], entry[2], entry[0], entry[3]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][AFFILIATION]) && (strlen(entry[4]))) {
            sprintf(line, "%s\n", entry[4]);
            add_text(whoDisplayText, line);
           }

           if (who_mask[SHOW][OFFICE_ADDR]) {
            if (strlen(entry[5])) {
              sprintf(line, "%s\n", entry[5]);
              add_text(whoDisplayText, line);
            }
            if (strlen(entry[6])) {
              sprintf(line, "%s\n", entry[6]);
              add_text(whoDisplayText, line);
            }
            if (strlen(entry[7])) {
              sprintf(line, "%s\n\n", entry[7]);
              add_text(whoDisplayText, line);
            }
           }

           if ((who_mask[SHOW][OFFICE_PHONE]) && (strlen(entry[8]))) {
            sprintf(line, "office phone: %s\n", entry[8]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][RESEARCH]) && (strlen(entry[9]))) {
            sprintf(line, "    research: %s\n", entry[9]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][HOME_ADDR]) && (strlen(entry[10]))) {
            sprintf(line, "        home: %s\n", entry[10]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][HOME_PHONE]) && (strlen(entry[11]))) {
            sprintf(line, "  home phone: %s\n", entry[11]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][FAX]) && (strlen(entry[12]))) {
            sprintf(line, "         fax: %s\n", entry[12]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][EMAIL]) && (strlen(entry[13]))) {
            sprintf(line, "       email: %s\n", entry[13]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][OTHER]) && (strlen(entry[14]))) {
            sprintf(line, "\n%s\n", entry[14]);
            add_text(whoDisplayText, line);
           }

           if ((who_mask[SHOW][DATE]) && (strlen(entry[15]))) {
            sprintf(line, "       as of: %s\n", entry[15]);
            add_text(whoDisplayText, line);
           }
           add_text(whoDisplayText, ENTRY_SEP);
          } else {
          /* didn't match our qualifications */
          }
        }
    }
    fclose(fp);
    unlink(TMP);

    XtManageChild(whoDisplayText);

    if (!matches) {
        sprintf(line, "nothing found\n");
        add_text(whoDisplayText, line);
        add_text(whoDisplayText, ENTRY_SEP);
        sprintf(line, "nothing found");
        set_status(line, YELLOW);
    } else {
        sprintf(line, "found %d %s", matches,
            (matches > 1) ? "people" : "person");
        set_status(line, GREEN);
    }

    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, whoEnterText);
    set_cursor(CURSOR_NORMAL_XTERM, whoDisplayText);
    grey_the_button(whoCancelButton, False);
    grey_the_bar(True);

	return (XtInputCallbackProc)NULL;
}


        /*****************************************************
        0rintf ("Last name = %s\n", last_name);
        1rintf ("First name = %s\n", first_name);
        2rintf ("middle name = %s\n", middle_name);
        3rintf ("other name = %s\n", other_name);
        4rintf ("affiliation = %s\n", affiliation);
        5rintf ("office address = %s\n", office_address);
        6rintf ("city state zip = %s\n", city_state_zip);
        7rintf ("country = %s\n", country);
        8rintf ("office phone = %s\n", office_phone);
        9rintf ("research = %s\n", research);
        0rintf ("home address = %s\n", home_address);
        1rintf ("home phone = %s\n", home_phone);
        2rintf ("fax = %s\n", fax);
        3rintf ("e mail address = %s\n", e_mail_address);
        4rintf ("other = %s\n", other);
        5rintf ("date = %s\n", date);
        and one blank
        *****************************************************/

/* if it works with our qualifications mask it's a good one */
good_match(s) 
char *s;
{

    if ( who_mask[SEARCH][NAME]
                && (strfind_case_insense(entry[0], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][NAME]
                && (strfind_case_insense(entry[1], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][NAME]
                && (strfind_case_insense(entry[2], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][NAME]
                && (strfind_case_insense(entry[3], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][AFFILIATION]
                && (strfind_case_insense(entry[4], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][OFFICE_ADDR]
                && (strfind_case_insense(entry[5], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][OFFICE_ADDR]
                && (strfind_case_insense(entry[6], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][OFFICE_ADDR]
                && (strfind_case_insense(entry[7], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][OFFICE_PHONE]
                && (strfind_case_insense(entry[8], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][RESEARCH]
                && (strfind_case_insense(entry[9], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][HOME_ADDR]
                && (strfind_case_insense(entry[10], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][HOME_PHONE]
                && (strfind_case_insense(entry[11], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][FAX]
                && (strfind_case_insense(entry[12], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][EMAIL]
                && (strfind_case_insense(entry[13], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][OTHER]
                && (strfind_case_insense(entry[14], s)) )  {
        return 1;
    } else if ( who_mask[SEARCH][DATE]
                && (strfind_case_insense(entry[15], s)) )  {
        return 1;
    }
    
    /* nobody matched */
    return 0;
}

strfind_case_insense(s1, s2)
char *s1, *s2;
{
    char *a, *b;
    register int i;
    
    a = (char*)malloc( strlen(s1) +1);
    strcpy(a, s1);
    b = (char*)malloc( strlen(s2) +1);
    strcpy(b, s2);

    /* lowerfy */
    i = 0; while (a[i]) {
        if ((a[i] >= 'A') && (a[i] <= 'Z'))
            a[i] -= ('A' - 'a');
        i++;
    }
    i = 0; while (b[i]) {
        if ((b[i] >= 'A') && (b[i] <= 'Z'))
            b[i] -= ('A' - 'a');
        i++;
    }
    if ((char*)Strstr(a, b)) {
        free(a);
        free(b);
        return 1;
    } else {
        free(a);
        free(b);
        return 0;
    }
}


void whoCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{

        Mode_desired = MODE_WHO;
}

Popup_who(w)
Widget w;
{
    XtManageChild(whoForm);
    XtManageChild(whoDisplayText);

    grey_the_button(whoButton, False);

    if (!(DONT_WARP))
      XWarpPointer(XtDisplay(toplevel), None, XtWindow(whoEnterText),
        0,0,0,0, 5,5);

	currentDisplayText = whoDisplayText;

    set_status(WHO_HEADER, GREEN);

	return 1;
}

make_who(w)
Widget w;
{
    static char text_translations[] = "<Key>Return: do_who() ";
    Arg args[20];
    XtTranslations translations;
    register int n;
	Dimension height;
	Dimension label_height;

	con_help[MODE_WHO] = "\n\
Who mode allows searching for individuals in the Na-Net\n\
White Pages database.\n\
\n\
For a simple search on a person's name type a single name\n\
and press Return. At present, multi word searches are not\n\
allowed.\n\
\n\
For a more elaborate search, click on 'Modify Search', then\n\
set which items you care to search on. In this way you may\n\
search on fields other than names.\n\
\n\
To print less the the complete entry on each match, click on\n\
'Modify Listing', then set which items to list.\n\
\n\
Clear cleans up the window, removing matches you aren't\n\
interested in saving or printing.\n\
\n\
Save, saves the entries in the window to disk. \n";



    XtSetArg(args[0], XtNheight, &label_height);
    XtGetValues(exitButton, args, 1);

    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, label_height*2 +15); n++;
/*
*/
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    whoForm = XtCreateManagedWidget("whoButtonForm", formWidgetClass, 
        topPane, args, n);


#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;


    n = 0;
    XtSetArg(args[n], XtNlabel, "Modify Listing"); n++;
    FIX
    whoModprintButton = XtCreateManagedWidget("whoModList", 
            commandWidgetClass, whoForm, args, n);
    setfasthelpmessage( whoModprintButton, "pick what fields to show");

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoModprintButton); n++;
    XtSetArg(args[n], XtNlabel, "Modify Search"); n++;
    FIX
    whoQualifyButton = XtCreateManagedWidget("whoModSearch", 
            commandWidgetClass, whoForm, args, n);
    setfasthelpmessage( whoQualifyButton, "pick what fields to match against");


    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoQualifyButton); n++;
    XtSetArg(args[n], XtNlabel, "Save"); n++;
    if (FINGER_DEMO) {
        XtSetArg(args[n], XtNsensitive, False); n++;
    }
    FIX
    whoSaveButton = XtCreateManagedWidget("whoSave", 
            commandWidgetClass, whoForm, args, n);
    setfasthelpmessage( whoSaveButton, "save contents to a file");

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoSaveButton); n++;
    XtSetArg(args[n], XtNlabel, "Clear"); n++;
    FIX
    whoClearButton = XtCreateManagedWidget("whoClear",
            commandWidgetClass, whoForm, args, n);
    setfasthelpmessage( whoClearButton, "clear the display");

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoClearButton); n++;
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNlabel, "Cancel"); n++;
    FIX
    whoCancelButton = XtCreateManagedWidget("whoCancel",
            commandWidgetClass, whoForm, args, n);
    setfasthelpmessage( whoCancelButton, "cancel current request");


    n = 0;
    XtSetArg(args[n], XtNfromVert, whoModprintButton); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, "search for:"); n++;
    FIX
    whoLabel = XtCreateManagedWidget("whoLeftLabel", labelWidgetClass, whoForm,
            args, n);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoLabel); n++;
    XtSetArg(args[n], XtNfromVert, whoModprintButton); n++;
    XtSetArg(args[n], XtNwidth, 
        MAX(10, XNL_WIDTH - 3*(xtw(whoButton,"search for:") +9))); n++;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNeditType, XawtextEdit);                         n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever); n++;
    FIX
    whoEnterText = XtCreateManagedWidget("whoEnterText", asciiTextWidgetClass, 
            whoForm, args, n);

    translations = XtParseTranslationTable(text_translations);
    XtOverrideTranslations(whoEnterText, translations);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, whoEnterText); n++;
    XtSetArg(args[n], XtNfromVert, whoModprintButton); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNlabel, " ...and press <Return>"); n++;
    FIX
    XtCreateManagedWidget("whoRightLabel", labelWidgetClass, whoForm,
            args, n);

    XtSetArg(args[0], XtNheight, &height);
    XtGetValues(whoForm, args, 1);
    XawPanedSetMinMax(whoForm, height, height);

    n =0;
/*
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  
    XtSetArg(args[n], XtNfromVert, whoEnterText); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
*/
/*
    XtSetArg(args[n], XtNwidth, XNL_WIDTH);        n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT);        n++;
*/
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg(args[n], XtNdisplayNonprinting, False); n++;
    XtSetArg(args[n], XtNeditType, XawtextRead); n++;
	XtSetArg(args[n], XtNhyper, False); n++;
    if (SHOW_WHO_INFO) {
        XtSetArg(args[n], XtNstring, HOW_TO_ENROLL); n++;
    } 
    whoDisplayText = XtCreateManagedWidget("whoText",
        utkasciiTextWidgetClass, topPane, args, n);

    XtAddCallback(whoModprintButton, XtNcallback, whoModprint, 
        (XtPointer)whoDisplayText);
    XtAddCallback(whoQualifyButton, XtNcallback, whoQualify, 
        (XtPointer)whoDisplayText);
    XtAddCallback(whoClearButton, XtNcallback, whoClear, 
        (XtPointer)whoDisplayText);
	if (FINGER_DEMO == False)
      XtAddCallback(whoSaveButton, XtNcallback, whoSave, 
        (XtPointer)whoDisplayText);
    XtAddCallback(whoCancelButton, XtNcallback, whoCancel, 
        (XtPointer)whoDisplayText);



    return 1;
}

Popdown_who(w)
Widget w;
{
    grey_the_button(whoButton, True);

	currentDisplayText = NULL;

    XtUnmanageChild(whoForm);
    XtUnmanageChild(whoDisplayText);

    if (whoSocket)
        netlib_abort(whoSocket);
    return 1;
}

static void
whoQualify(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Widget popup_widg, form, button, radio, last;
    Arg args[20];
    register int n, i;

    /* set the proposed mask to what we actually have */
    for (i= NAME; i <= DATE; i++)
        who_mask[P_SEARCH][i] = who_mask[SEARCH][i];

    n = 0;
    XtSetArg(args[n], XtNx, 50);                         n++;
    XtSetArg(args[n], XtNy, 150);                        n++;
    XtSetArg(args[n], XtNallowShellResize, True);        n++;
    XtSetArg(args[n], XtNtitle, "Qualify the Whois search");        n++;
    popup_widg = XtCreatePopupShell("QualifySearch", 
        topLevelShellWidgetClass, toplevel, args, n);

    n = 0;
    XtSetArg(args[n], XtNresizable, True);               n++;
    form = XtCreateManagedWidget("whoPopupForm", formWidgetClass, 
        popup_widg, args, n);

    /* the top label */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0);  n++;
    XtSetArg(args[n], XtNlabel, "mark which parts to search");   n++;
    last = XtCreateManagedWidget("headLabel", 
        labelWidgetClass, form,args,n);

    /* now the toggles */
    /* the bitmap for the toggle widget is set as a fallback rcrc
        in main.c */
#define TOGGLE(part, label_label) \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNinternalHeight, 0); n++; \
    XtSetArg(args[n], XtNinternalWidth, 0); n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNstate, who_mask[P_SEARCH][part]);  n++; \
    XtSetArg(args[n], XtNbitmap, checkPix); n++; \
    whoToggles[part] = radio = XtCreateManagedWidget("searchToggle",  \
        toggleWidgetClass, form, args, n); \
    XtAddCallback(radio, XtNcallback, whoToggle,  \
        (XtPointer)((P_SEARCH * 100) + part)); \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNfromHoriz, radio);             n++; \
    button = XtCreateManagedWidget(label_label,  \
        labelWidgetClass, form, args, n); \
    last = radio;

    TOGGLE(NAME, "name")
    TOGGLE(AFFILIATION, "affiliation")
    TOGGLE(OFFICE_ADDR, "office address")
    TOGGLE(OFFICE_PHONE, "office phone")
    TOGGLE(RESEARCH, "research")
    TOGGLE(HOME_ADDR, "home address")
    TOGGLE(HOME_PHONE, "home phone")
    TOGGLE(FAX, "fax")
    TOGGLE(EMAIL, "email")
    TOGGLE(OTHER, "other information")
    TOGGLE(DATE, "date")


    /* now the set/clear/ok/cancel buttons */

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    XtSetArg(args[n], XtNlabel, "clear all");   n++;
    button = XtCreateManagedWidget("clearButton", 
        commandWidgetClass, form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskClear, 
        (XtPointer)P_SEARCH);

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNlabel, "set all");   n++;
    button = XtCreateManagedWidget("setButton", 
        commandWidgetClass, form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskSet, 
        (XtPointer)P_SEARCH);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("ok", commandWidgetClass, 
        form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskOk, (XtPointer)SEARCH);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("cancel", commandWidgetClass, 
        form, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    XtPopup(popup_widg, XtGrabExclusive);
}


static void
whoModprint(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Widget popup_widg, form, button, radio, last;
    Arg args[20];
    register int n, i;

    /* set the proposed mask to what we actually have */
    for (i= NAME; i <= DATE; i++)
        who_mask[P_SEARCH][i] = who_mask[SEARCH][i];

    n = 0;
    XtSetArg(args[n], XtNx, 50);                         n++;
    XtSetArg(args[n], XtNy, 150);                        n++;
    XtSetArg(args[n], XtNallowShellResize, True);        n++;
    XtSetArg(args[n], XtNtitle, "Modify the Listing");        n++;
    popup_widg = XtCreatePopupShell("ModifyListing", 
        topLevelShellWidgetClass, toplevel, args, n);

    n = 0;
    XtSetArg(args[n], XtNresizable, True);               n++;
    form = XtCreateManagedWidget("whoPopupForm", formWidgetClass, 
        popup_widg, args, n);

    /* the top label */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0);  n++;
    XtSetArg(args[n], XtNlabel, "mark which parts to show");   n++;
    last = XtCreateManagedWidget("headModPrintLabel", 
        labelWidgetClass, form,args,n);

    /* now the toggles */
    /* the bitmap for the toggle widget is set as a fallback rcrc
        in main.c */
#undef TOGGLE
#define TOGGLE(part, label_label) \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNinternalHeight, 0); n++; \
    XtSetArg(args[n], XtNinternalWidth, 0); n++; \
    XtSetArg(args[n], XtNstate, who_mask[P_SHOW][part]);  n++; \
    XtSetArg(args[n], XtNbitmap, checkPix); n++; \
    whoToggles[part] = radio = XtCreateManagedWidget("showToggle",  \
        toggleWidgetClass, form, args, n); \
    XtAddCallback(radio, XtNcallback, whoToggle,  \
        (XtPointer)((P_SHOW * 100) + part)); \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNfromHoriz, radio);             n++; \
    button = XtCreateManagedWidget(label_label,  \
        labelWidgetClass, form, args, n); \
    last = radio;

    TOGGLE(NAME, "name")
    TOGGLE(AFFILIATION, "affiliation")
    TOGGLE(OFFICE_ADDR, "office address")
    TOGGLE(OFFICE_PHONE, "office phone")
    TOGGLE(RESEARCH, "research")
    TOGGLE(HOME_ADDR, "home address")
    TOGGLE(HOME_PHONE, "home phone")
    TOGGLE(FAX, "fax")
    TOGGLE(EMAIL, "email")
    TOGGLE(OTHER, "other information")
    TOGGLE(DATE, "date")


    /* now the set/clear/ok/cancel buttons */

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    XtSetArg(args[n], XtNlabel, "clear all");   n++;
    button = XtCreateManagedWidget("clearButton", 
        commandWidgetClass, form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskClear, 
        (XtPointer)P_SHOW);

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNlabel, "set all");   n++;
    button = XtCreateManagedWidget("setButton", 
        commandWidgetClass, form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskSet, 
        (XtPointer)P_SHOW);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("ok", commandWidgetClass, 
        form, args, n);
    XtAddCallback(button, XtNcallback, whoMaskOk, (XtPointer)SHOW);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("cancel", commandWidgetClass, 
        form, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    XtPopup(popup_widg, XtGrabExclusive);
}


static void
whoToggle(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int ret = (int)call_data;
    Boolean state = (int)client_data;
    int mask_set, mask_part;

    mask_set = ret / 100;
    mask_part = ret % 100;

    who_mask[mask_set][mask_part] = state;
}

static void
whoClear(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];

    XtSetArg(args[0], XtNstring, "");
    XtSetValues(whoDisplayText, args, 1);
}


static void
whoSave(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[5];
    Widget  popup;
    Position    x, y;
    Dimension   width, height;
    register int n;


    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2), 
            (Position) (height / 2), &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);             n++;
    XtSetArg(args[n], XtNy, y);             n++;

    popup = XtCreatePopupShell("whoSavePopup", 
        transientShellWidgetClass, w, args, n);

    whoSaveDialog = XtCreateManagedWidget("whoSaveDialog", 
        dialogWidgetClass, popup,NULL, 0);

    XawDialogAddButton(whoSaveDialog, "ok", whoDoSave, 
        (XtPointer) whoSaveDialog);
    XawDialogAddButton(whoSaveDialog, "cancel", Destroy_form,
        (XtPointer)whoSaveDialog);

    XtPopup(popup, XtGrabExclusive);
}

void
whoDoSave(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char line[MAXLINE], filename[MAXLINE];
    String fname;
    Widget asciiSrc;

    fname = XawDialogGetValueString(whoSaveDialog);

    strcpy(filename, fname);

    XtSetArg(args[0], XtNtextSource, &asciiSrc);
    XtGetValues(whoDisplayText, args, 1);

    replace(filename, "~", Home);

    if (XawAsciiSaveAsFile(asciiSrc, filename)) {
        sprintf(line, "saved contents in %s", filename);
        set_status(line, GREEN);
    } else {
        sprintf(line, "couldn't save contents in %s", filename);
        set_status(line, RED);
    }

    XtDestroyWidget( XtParent(whoSaveDialog));
}

static void
whoCancel(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{

    grey_the_button(whoCancelButton, False);
    set_cursor(CURSOR_NORMAL, 0);
    set_cursor(CURSOR_NORMAL_XTERM, whoEnterText);
    set_cursor(CURSOR_NORMAL_XTERM, whoDisplayText);
    grey_the_bar(True);

    if (whoSocket)
        netlib_abort(whoSocket);
    whoSocket = (int)NULL;

    set_status("Who Request Interrupted by You", RED);
}



static void
whoMaskOk(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int which = (int)call_data;
    register int i;

    /* copy proposed mask to mask */
    for (i= NAME; i <= DATE; i++)
        who_mask[which][i] = who_mask[which +1][i];

    set_status("new search mask", GREEN);
}

static void
whoMaskClear(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int which = (int)call_data;
    Arg args[3];
    register int i;

    /* clear the mask */
    for (i= NAME; i <= DATE; i++) {
        who_mask[which][i] = False;
        XtSetArg(args[0], XtNstate, False);
        XtSetValues(whoToggles[i], args, 1);
    }
}

static void
whoMaskSet(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int which = (int)call_data;
    Arg args[3];
    register int i;

    /* clear the mask */
    for (i= NAME; i <= DATE; i++) {
        who_mask[which][i] = True;
        XtSetArg(args[0], XtNstate, True);
        XtSetValues(whoToggles[i], args, 1);
    }
}


whoInit()
{
    register int i;

    whoSocket = (int)NULL;

    for (i= NAME; i <= DATE; i++) {
        who_mask[SEARCH][i] = False;
        who_mask[P_SEARCH][i] = False;
        who_mask[SHOW][i] = True;
        who_mask[P_SHOW][i] = True;
    }
    who_mask[P_SEARCH][NAME] = who_mask[SEARCH][NAME] = True;
}

