/*-
 * Copyright (c) 2017 The FreeBSD Foundation
 * All rights reserved.
 *
 * This software was developed by Konstantin Belousov <kib@FreeBSD.org>
 * under sponsorship from the FreeBSD Foundation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/lib/libc/amd64/sys/amd64_detect_rdfsgsbase.c 323538 2017-09-13 11:29:48Z kib $");

#define	IN_RTLD	1
#include <sys/param.h>
#undef IN_RTLD
#include <machine/cpufunc.h>
#include <machine/specialreg.h>
#include "amd64_detect_rdfsgsbase.h"
#include "libc_private.h"

static int state = RDFSGS_UNKNOWN;

int
amd64_detect_rdfsgsbase(void)
{
	u_int p[4];

	if (__predict_true(state != RDFSGS_UNKNOWN))
		return (state);

	if (__getosreldate() >= P_OSREL_WRFSBASE ||
	    (P_OSREL_MAJOR(__getosreldate()) == 11 && __getosreldate() >=
	    P_OSREL_WRFSBASE_11)) {
		do_cpuid(0x0, p);
		if (p[0] >= 0x7) {
			cpuid_count(0x7, 0x0, p);
			if ((p[1] & CPUID_STDEXT_FSGSBASE) != 0) {
				state = RDFSGS_SUPPORTED;
				return (state);
			}
		}
	}
	state = RDFSGS_UNSUPPORTED;
	return (state);
}
