/*-
 * Copyright 2003-2011 Netlogic Microsystems (Netlogic). All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY Netlogic Microsystems ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NETLOGIC OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * NETLOGIC_BSD
 * $FreeBSD: stable/10/sys/mips/nlm/msgring.h 233545 2012-03-27 14:05:12Z jchandra $
 */

#ifndef _NLM_MSGRING_H
#define	_NLM_MSGRING_H
#define	CMS_DEFAULT_CREDIT	50
/*
 * packets are sent to VC 0 of a thread
 * freebacks are sent to VC 3 of a thread
 */
#define	XLPGE_RX_VC		0
#define	XLPGE_FB_VC		3

extern uint32_t xlp_msg_thread_mask;

struct nlm_fmn_msg;
typedef void (*msgring_handler)(int, int, int, int, struct nlm_fmn_msg *, void *);

int register_msgring_handler(int startb, int endb, msgring_handler action,
		                    void *arg);
int xlp_handle_msg_vc(u_int vcmask, int max_msgs);
void xlp_msgring_cpu_init(int, int, int);
void xlp_cms_enable_intr(int , int , int , int);
#endif /* _NLM_MSGRING_H */
