/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2013, 2016, 2025 Chelsio Communications.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* This file is automatically generated --- changes will be lost */
/* Generation Date : Thu Dec 11 08:42:50 PM IST 2025 */
/* Directory name: t4_reg.txt, Date: Not specified */
/* Directory name: t5_reg.txt, Changeset: 6946:9d3868c42009 */
/* Directory name: t6_reg.txt, Changeset: 4277:9c165d0f4899 */
/* Directory name: t7_sw_reg.txt, Changeset: 5950:7c934148528c */

#define MYPF_BASE 0x1b000
#define MYPF_REG(reg_addr) (MYPF_BASE + (reg_addr))

#define PF0_BASE 0x1e000
#define PF0_REG(reg_addr) (PF0_BASE + (reg_addr))

#define PF1_BASE 0x1e400
#define PF1_REG(reg_addr) (PF1_BASE + (reg_addr))

#define PF2_BASE 0x1e800
#define PF2_REG(reg_addr) (PF2_BASE + (reg_addr))

#define PF3_BASE 0x1ec00
#define PF3_REG(reg_addr) (PF3_BASE + (reg_addr))

#define PF4_BASE 0x1f000
#define PF4_REG(reg_addr) (PF4_BASE + (reg_addr))

#define PF5_BASE 0x1f400
#define PF5_REG(reg_addr) (PF5_BASE + (reg_addr))

#define PF6_BASE 0x1f800
#define PF6_REG(reg_addr) (PF6_BASE + (reg_addr))

#define PF7_BASE 0x1fc00
#define PF7_REG(reg_addr) (PF7_BASE + (reg_addr))

#define PF_STRIDE 0x400
#define PF_BASE(idx) (PF0_BASE + (idx) * PF_STRIDE)
#define PF_REG(idx, reg) (PF_BASE(idx) + (reg))

#define VF_SGE_BASE 0x0
#define VF_SGE_REG(reg_addr) (VF_SGE_BASE + (reg_addr))

#define VF_MPS_BASE 0x100
#define VF_MPS_REG(reg_addr) (VF_MPS_BASE + (reg_addr))

#define VF_PL_BASE 0x200
#define VF_PL_REG(reg_addr) (VF_PL_BASE + (reg_addr))

#define VF_MBDATA_BASE 0x240
#define VF_MBDATA_REG(reg_addr) (VF_MBDATA_BASE + (reg_addr))

#define VF_CIM_BASE 0x300
#define VF_CIM_REG(reg_addr) (VF_CIM_BASE + (reg_addr))

#define MYPORT_BASE 0x1c000
#define MYPORT_REG(reg_addr) (MYPORT_BASE + (reg_addr))

#define PORT0_BASE 0x20000
#define PORT0_REG(reg_addr) (PORT0_BASE + (reg_addr))

#define PORT1_BASE 0x22000
#define PORT1_REG(reg_addr) (PORT1_BASE + (reg_addr))

#define PORT2_BASE 0x24000
#define PORT2_REG(reg_addr) (PORT2_BASE + (reg_addr))

#define PORT3_BASE 0x26000
#define PORT3_REG(reg_addr) (PORT3_BASE + (reg_addr))

#define PORT_STRIDE 0x2000
#define PORT_BASE(idx) (PORT0_BASE + (idx) * PORT_STRIDE)
#define PORT_REG(idx, reg) (PORT_BASE(idx) + (reg))

#define SGE_QUEUE_BASE_MAP_HIGH(idx) (A_SGE_QUEUE_BASE_MAP_HIGH + (idx) * 8)
#define NUM_SGE_QUEUE_BASE_MAP_HIGH_INSTANCES 136

#define SGE_QUEUE_BASE_MAP_LOW(idx) (A_SGE_QUEUE_BASE_MAP_LOW + (idx) * 8)
#define NUM_SGE_QUEUE_BASE_MAP_LOW_INSTANCES 136

#define PCIE_DMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_DMA_INSTANCES 4

#define PCIE_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_CMD_INSTANCES 2

#define PCIE_HMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_HMA_INSTANCES 1

#define PCIE_MEM_ACCESS_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_MEM_ACCESS_INSTANCES 8

#define PCIE_MAILBOX_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_MAILBOX_INSTANCES 1

#define PCIE_FW_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_FW_INSTANCES 8

#define PCIE_FUNC_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_FUNC_INSTANCES 256

#define PCIE_FID(idx) (A_PCIE_FID + (idx) * 4)
#define NUM_PCIE_FID_INSTANCES 2048

#define PCIE_DMA_BUF_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_DMA_BUF_INSTANCES 4

#define MC_DDR3PHYDATX8_REG(reg_addr, idx) ((reg_addr) + (idx) * 256)
#define NUM_MC_DDR3PHYDATX8_INSTANCES 9

#define MC_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_BIST_STATUS_INSTANCES 18

#define EDC_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_BIST_STATUS_INSTANCES 18

#define CIM_PF_MAILBOX_DATA(idx) (A_CIM_PF_MAILBOX_DATA + (idx) * 4)
#define NUM_CIM_PF_MAILBOX_DATA_INSTANCES 16

#define MPS_TRC_FILTER_MATCH_CTL_A(idx) (A_MPS_TRC_FILTER_MATCH_CTL_A + (idx) * 4)
#define NUM_MPS_TRC_FILTER_MATCH_CTL_A_INSTANCES 4

#define MPS_TRC_FILTER_MATCH_CTL_B(idx) (A_MPS_TRC_FILTER_MATCH_CTL_B + (idx) * 4)
#define NUM_MPS_TRC_FILTER_MATCH_CTL_B_INSTANCES 4

#define MPS_TRC_FILTER_RUNT_CTL(idx) (A_MPS_TRC_FILTER_RUNT_CTL + (idx) * 4)
#define NUM_MPS_TRC_FILTER_RUNT_CTL_INSTANCES 4

#define MPS_TRC_FILTER_DROP(idx) (A_MPS_TRC_FILTER_DROP + (idx) * 4)
#define NUM_MPS_TRC_FILTER_DROP_INSTANCES 4

#define MPS_TRC_FILTER0_MATCH(idx) (A_MPS_TRC_FILTER0_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER0_MATCH_INSTANCES 28

#define MPS_TRC_FILTER0_DONT_CARE(idx) (A_MPS_TRC_FILTER0_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER0_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER1_MATCH(idx) (A_MPS_TRC_FILTER1_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER1_MATCH_INSTANCES 28

#define MPS_TRC_FILTER1_DONT_CARE(idx) (A_MPS_TRC_FILTER1_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER1_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER2_MATCH(idx) (A_MPS_TRC_FILTER2_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER2_MATCH_INSTANCES 28

#define MPS_TRC_FILTER2_DONT_CARE(idx) (A_MPS_TRC_FILTER2_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER2_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER3_MATCH(idx) (A_MPS_TRC_FILTER3_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER3_MATCH_INSTANCES 28

#define MPS_TRC_FILTER3_DONT_CARE(idx) (A_MPS_TRC_FILTER3_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER3_DONT_CARE_INSTANCES 28

#define MPS_PORT_CLS_HASH_SRAM(idx) (A_MPS_PORT_CLS_HASH_SRAM + (idx) * 4)
#define NUM_MPS_PORT_CLS_HASH_SRAM_INSTANCES 65

#define MPS_CLS_VLAN_TABLE(idx) (A_MPS_CLS_VLAN_TABLE + (idx) * 4)
#define NUM_MPS_CLS_VLAN_TABLE_INSTANCES 9

#define MPS_CLS_SRAM_L(idx) (A_MPS_CLS_SRAM_L + (idx) * 8)
#define NUM_MPS_CLS_SRAM_L_INSTANCES 336

#define MPS_CLS_SRAM_H(idx) (A_MPS_CLS_SRAM_H + (idx) * 8)
#define NUM_MPS_CLS_SRAM_H_INSTANCES 336

#define MPS_CLS_TCAM_Y_L(idx) (A_MPS_CLS_TCAM_Y_L + (idx) * 16)
#define NUM_MPS_CLS_TCAM_Y_L_INSTANCES 512

#define MPS_CLS_TCAM_Y_H(idx) (A_MPS_CLS_TCAM_Y_H + (idx) * 16)
#define NUM_MPS_CLS_TCAM_Y_H_INSTANCES 512

#define MPS_CLS_TCAM_X_L(idx) (A_MPS_CLS_TCAM_X_L + (idx) * 16)
#define NUM_MPS_CLS_TCAM_X_L_INSTANCES 512

#define MPS_CLS_TCAM_X_H(idx) (A_MPS_CLS_TCAM_X_H + (idx) * 16)
#define NUM_MPS_CLS_TCAM_X_H_INSTANCES 512

#define PL_SEMAPHORE_LOCK(idx) (A_PL_SEMAPHORE_LOCK + (idx) * 4)
#define NUM_PL_SEMAPHORE_LOCK_INSTANCES 8

#define PL_VF_SLICE_L(idx) (A_PL_VF_SLICE_L + (idx) * 8)
#define NUM_PL_VF_SLICE_L_INSTANCES 8

#define PL_VF_SLICE_H(idx) (A_PL_VF_SLICE_H + (idx) * 8)
#define NUM_PL_VF_SLICE_H_INSTANCES 8

#define PL_FLR_VF_STATUS(idx) (A_PL_FLR_VF_STATUS + (idx) * 4)
#define NUM_PL_FLR_VF_STATUS_INSTANCES 4

#define PL_VFID_MAP(idx) (A_PL_VFID_MAP + (idx) * 4)
#define NUM_PL_VFID_MAP_INSTANCES 256

#define LE_DB_MASK_IPV4(idx) (A_LE_DB_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_MASK_IPV4_INSTANCES 17

#define LE_DB_MASK_IPV6(idx) (A_LE_DB_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_MASK_IPV6_INSTANCES 17

#define LE_DB_DBGI_REQ_DATA(idx) (A_LE_DB_DBGI_REQ_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_DATA_INSTANCES 17

#define LE_DB_DBGI_REQ_MASK(idx) (A_LE_DB_DBGI_REQ_MASK + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_MASK_INSTANCES 17

#define LE_DB_DBGI_RSP_DATA(idx) (A_LE_DB_DBGI_RSP_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_RSP_DATA_INSTANCES 17

#define LE_DB_ACTIVE_MASK_IPV4(idx) (A_LE_DB_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV4_INSTANCES 17

#define LE_DB_ACTIVE_MASK_IPV6(idx) (A_LE_DB_ACTIVE_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV6_INSTANCES 17

#define LE_HASH_MASK_GEN_IPV4(idx) (A_LE_HASH_MASK_GEN_IPV4 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4_INSTANCES 4

#define LE_HASH_MASK_GEN_IPV6(idx) (A_LE_HASH_MASK_GEN_IPV6 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV6_INSTANCES 12

#define LE_HASH_MASK_CMP_IPV4(idx) (A_LE_HASH_MASK_CMP_IPV4 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV4_INSTANCES 4

#define LE_HASH_MASK_CMP_IPV6(idx) (A_LE_HASH_MASK_CMP_IPV6 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV6_INSTANCES 12

#define UP_TSCH_CHANNEL_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_UP_TSCH_CHANNEL_INSTANCES 4

#define CIM_CTL_MAILBOX_VF_STATUS(idx) (A_CIM_CTL_MAILBOX_VF_STATUS + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VF_STATUS_INSTANCES 4

#define CIM_CTL_MAILBOX_VFN_CTL(idx) (A_CIM_CTL_MAILBOX_VFN_CTL + (idx) * 16)
#define NUM_CIM_CTL_MAILBOX_VFN_CTL_INSTANCES 128

#define CIM_CTL_TSCH_CHANNEL_REG(reg_addr, idx) ((reg_addr) + (idx) * 288)
#define NUM_CIM_CTL_TSCH_CHANNEL_INSTANCES 4

#define CIM_CTL_TSCH_CHANNEL_TSCH_CLASS_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_CIM_CTL_TSCH_CHANNEL_TSCH_CLASS_INSTANCES 16

#define T5_MYPORT_BASE 0x2c000
#define T5_MYPORT_REG(reg_addr) (T5_MYPORT_BASE + (reg_addr))

#define T5_PORT0_BASE 0x30000
#define T5_PORT0_REG(reg_addr) (T5_PORT0_BASE + (reg_addr))

#define T5_PORT1_BASE 0x34000
#define T5_PORT1_REG(reg_addr) (T5_PORT1_BASE + (reg_addr))

#define T5_PORT2_BASE 0x38000
#define T5_PORT2_REG(reg_addr) (T5_PORT2_BASE + (reg_addr))

#define T5_PORT3_BASE 0x3c000
#define T5_PORT3_REG(reg_addr) (T5_PORT3_BASE + (reg_addr))

#define T5_PORT_STRIDE 0x4000
#define T5_PORT_BASE(idx) (T5_PORT0_BASE + (idx) * T5_PORT_STRIDE)
#define T5_PORT_REG(idx, reg) (T5_PORT_BASE(idx) + (reg))

#define PCIE_PF_INT_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_PF_INT_INSTANCES 8

#define PCIE_VF_INT_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_PCIE_VF_INT_INSTANCES 128

#define PCIE_FID_VFID(idx) (A_PCIE_FID_VFID + (idx) * 4)
#define NUM_PCIE_FID_VFID_INSTANCES 2048

#define PCIE_COOKIE_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_COOKIE_INSTANCES 8

#define PCIE_T5_DMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_DMA_INSTANCES 4

#define PCIE_T5_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_CMD_INSTANCES 3

#define PCIE_T5_HMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_HMA_INSTANCES 1

#define PCIE_PHY_PRESET_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_PHY_PRESET_INSTANCES 11

#define MPS_T5_CLS_SRAM_L(idx) (A_MPS_T5_CLS_SRAM_L + (idx) * 8)
#define NUM_MPS_T5_CLS_SRAM_L_INSTANCES 512

#define MPS_T5_CLS_SRAM_H(idx) (A_MPS_T5_CLS_SRAM_H + (idx) * 8)
#define NUM_MPS_T5_CLS_SRAM_H_INSTANCES 512

#define LE_T5_DB_MASK_IPV4(idx) (A_LE_T5_DB_MASK_IPV4 + (idx) * 4)
#define NUM_LE_T5_DB_MASK_IPV4_INSTANCES 5

#define LE_T5_DB_ACTIVE_MASK_IPV4(idx) (A_LE_T5_DB_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_T5_DB_ACTIVE_MASK_IPV4_INSTANCES 5

#define LE_HASH_MASK_GEN_IPV4T5(idx) (A_LE_HASH_MASK_GEN_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4T5_INSTANCES 5

#define LE_HASH_MASK_GEN_IPV6T5(idx) (A_LE_HASH_MASK_GEN_IPV6T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV6T5_INSTANCES 12

#define LE_HASH_MASK_CMP_IPV4T5(idx) (A_LE_HASH_MASK_CMP_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV4T5_INSTANCES 5

#define LE_HASH_MASK_CMP_IPV6T5(idx) (A_LE_HASH_MASK_CMP_IPV6T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_CMP_IPV6T5_INSTANCES 12

#define LE_DB_SECOND_ACTIVE_MASK_IPV4(idx) (A_LE_DB_SECOND_ACTIVE_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_ACTIVE_MASK_IPV4_INSTANCES 5

#define LE_DB_SECOND_GEN_HASH_MASK_IPV4(idx) (A_LE_DB_SECOND_GEN_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_GEN_HASH_MASK_IPV4_INSTANCES 5

#define LE_DB_SECOND_CMP_HASH_MASK_IPV4(idx) (A_LE_DB_SECOND_CMP_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_CMP_HASH_MASK_IPV4_INSTANCES 5

#define MC_ADR_REG(reg_addr, idx) ((reg_addr) + (idx) * 512)
#define NUM_MC_ADR_INSTANCES 2

#define MC_DDRPHY_DP18_REG(reg_addr, idx) ((reg_addr) + (idx) * 512)
#define NUM_MC_DDRPHY_DP18_INSTANCES 5

#define MC_CE_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_ERR_DATA_INSTANCES 8

#define MC_CE_COR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_COR_DATA_INSTANCES 8

#define MC_UE_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_ERR_DATA_INSTANCES 8

#define MC_UE_COR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_COR_DATA_INSTANCES 8

#define MC_P_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_P_BIST_STATUS_INSTANCES 18

#define EDC_H_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_H_BIST_STATUS_INSTANCES 18

#define EDC_H_ECC_ERR_DATA_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_EDC_H_ECC_ERR_DATA_INSTANCES 16

#define SGE_DEBUG1_DBP_THREAD(idx) (A_SGE_DEBUG1_DBP_THREAD + (idx) * 4)
#define NUM_SGE_DEBUG1_DBP_THREAD_INSTANCES 4

#define SGE_DEBUG0_DBP_THREAD(idx) (A_SGE_DEBUG0_DBP_THREAD + (idx) * 4)
#define NUM_SGE_DEBUG0_DBP_THREAD_INSTANCES 5

#define SGE_WC_EGRS_BAR2_OFF_PF(idx) (A_SGE_WC_EGRS_BAR2_OFF_PF + (idx) * 4)
#define NUM_SGE_WC_EGRS_BAR2_OFF_PF_INSTANCES 8

#define SGE_WC_EGRS_BAR2_OFF_VF(idx) (A_SGE_WC_EGRS_BAR2_OFF_VF + (idx) * 4)
#define NUM_SGE_WC_EGRS_BAR2_OFF_VF_INSTANCES 8

#define PCIE_T6_DMA_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T6_DMA_INSTANCES 2

#define PCIE_T6_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T6_CMD_INSTANCES 1

#define PCIE_VF_256_INT_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_PCIE_VF_256_INT_INSTANCES 128

#define MPS_CLS_REQUEST_TRACE_MAC_DA_L(idx) (A_MPS_CLS_REQUEST_TRACE_MAC_DA_L + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_MAC_DA_L_INSTANCES 8

#define MPS_CLS_REQUEST_TRACE_MAC_DA_H(idx) (A_MPS_CLS_REQUEST_TRACE_MAC_DA_H + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_MAC_DA_H_INSTANCES 8

#define MPS_CLS_REQUEST_TRACE_MAC_SA_L(idx) (A_MPS_CLS_REQUEST_TRACE_MAC_SA_L + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_MAC_SA_L_INSTANCES 8

#define MPS_CLS_REQUEST_TRACE_MAC_SA_H(idx) (A_MPS_CLS_REQUEST_TRACE_MAC_SA_H + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_MAC_SA_H_INSTANCES 8

#define MPS_CLS_REQUEST_TRACE_PORT_VLAN(idx) (A_MPS_CLS_REQUEST_TRACE_PORT_VLAN + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_PORT_VLAN_INSTANCES 8

#define MPS_CLS_REQUEST_TRACE_ENCAP(idx) (A_MPS_CLS_REQUEST_TRACE_ENCAP + (idx) * 32)
#define NUM_MPS_CLS_REQUEST_TRACE_ENCAP_INSTANCES 8

#define MPS_CLS_RESULT_TRACE(idx) (A_MPS_CLS_RESULT_TRACE + (idx) * 4)
#define NUM_MPS_CLS_RESULT_TRACE_INSTANCES 8

#define MPS_CLS_DIPIPV4_ID_TABLE(idx) (A_MPS_CLS_DIPIPV4_ID_TABLE + (idx) * 8)
#define NUM_MPS_CLS_DIPIPV4_ID_TABLE_INSTANCES 4

#define MPS_CLS_DIPIPV4_MASK_TABLE(idx) (A_MPS_CLS_DIPIPV4_MASK_TABLE + (idx) * 8)
#define NUM_MPS_CLS_DIPIPV4_MASK_TABLE_INSTANCES 4

#define MPS_CLS_DIPIPV6ID_0_TABLE(idx) (A_MPS_CLS_DIPIPV6ID_0_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6ID_0_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6ID_1_TABLE(idx) (A_MPS_CLS_DIPIPV6ID_1_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6ID_1_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6ID_2_TABLE(idx) (A_MPS_CLS_DIPIPV6ID_2_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6ID_2_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6ID_3_TABLE(idx) (A_MPS_CLS_DIPIPV6ID_3_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6ID_3_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6MASK_0_TABLE(idx) (A_MPS_CLS_DIPIPV6MASK_0_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6MASK_0_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6MASK_1_TABLE(idx) (A_MPS_CLS_DIPIPV6MASK_1_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6MASK_1_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6MASK_2_TABLE(idx) (A_MPS_CLS_DIPIPV6MASK_2_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6MASK_2_TABLE_INSTANCES 2

#define MPS_CLS_DIPIPV6MASK_3_TABLE(idx) (A_MPS_CLS_DIPIPV6MASK_3_TABLE + (idx) * 32)
#define NUM_MPS_CLS_DIPIPV6MASK_3_TABLE_INSTANCES 2

#define MPS_RX_HASH_LKP_TABLE(idx) (A_MPS_RX_HASH_LKP_TABLE + (idx) * 4)
#define NUM_MPS_RX_HASH_LKP_TABLE_INSTANCES 4

#define LE_DB_DBG_MATCH_DATA_MASK(idx) (A_LE_DB_DBG_MATCH_DATA_MASK + (idx) * 4)
#define NUM_LE_DB_DBG_MATCH_DATA_MASK_INSTANCES 8

#define LE_DB_DBG_MATCH_DATA(idx) (A_LE_DB_DBG_MATCH_DATA + (idx) * 4)
#define NUM_LE_DB_DBG_MATCH_DATA_INSTANCES 8

#define LE_DB_DBGI_REQ_DATA_T6(idx) (A_LE_DB_DBGI_REQ_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_DATA_T6_INSTANCES 11

#define LE_DB_DBGI_REQ_MASK_T6(idx) (A_LE_DB_DBGI_REQ_MASK + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_MASK_T6_INSTANCES 11

#define LE_DB_ACTIVE_MASK_IPV6_T6(idx) (A_LE_DB_ACTIVE_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV6_T6_INSTANCES 8

#define LE_HASH_MASK_GEN_IPV4T6(idx) (A_LE_HASH_MASK_GEN_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4T6_INSTANCES 8

#define T6_LE_HASH_MASK_GEN_IPV6T5(idx) (A_T6_LE_HASH_MASK_GEN_IPV6T5 + (idx) * 4)
#define NUM_T6_LE_HASH_MASK_GEN_IPV6T5_INSTANCES 8

#define LE_DB_PSV_FILTER_MASK_TUP_IPV4(idx) (A_LE_DB_PSV_FILTER_MASK_TUP_IPV4 + (idx) * 4)
#define NUM_LE_DB_PSV_FILTER_MASK_TUP_IPV4_INSTANCES 3

#define LE_DB_PSV_FILTER_MASK_FLT_IPV4(idx) (A_LE_DB_PSV_FILTER_MASK_FLT_IPV4 + (idx) * 4)
#define NUM_LE_DB_PSV_FILTER_MASK_FLT_IPV4_INSTANCES 2

#define LE_DB_PSV_FILTER_MASK_TUP_IPV6(idx) (A_LE_DB_PSV_FILTER_MASK_TUP_IPV6 + (idx) * 4)
#define NUM_LE_DB_PSV_FILTER_MASK_TUP_IPV6_INSTANCES 9

#define LE_DB_PSV_FILTER_MASK_FLT_IPV6(idx) (A_LE_DB_PSV_FILTER_MASK_FLT_IPV6 + (idx) * 4)
#define NUM_LE_DB_PSV_FILTER_MASK_FLT_IPV6_INSTANCES 2

#define LE_DB_SECOND_GEN_HASH_MASK_IPV4_T6(idx) (A_LE_DB_SECOND_GEN_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_GEN_HASH_MASK_IPV4_T6_INSTANCES 8

#define MC_DDRPHY_DP18_T6_REG(reg_addr, idx) ((reg_addr) + (idx) * 512)
#define NUM_MC_DDRPHY_DP18_T6_INSTANCES 9

#define MC_CE_ERR_DATA_T6_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_ERR_DATA_T6_INSTANCES 16

#define MC_UE_ERR_DATA_T6_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_ERR_DATA_T6_INSTANCES 16

#define CIM_CTL_MAILBOX_VF_STATUS_T6(idx) (A_CIM_CTL_MAILBOX_VF_STATUS + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VF_STATUS_T6_INSTANCES 8

#define CIM_CTL_MAILBOX_VFN_CTL_T6(idx) (A_CIM_CTL_MAILBOX_VFN_CTL + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VFN_CTL_T6_INSTANCES 256

#define T7_MYPORT_BASE 0x2e000
#define T7_MYPORT_REG(reg_addr) (T7_MYPORT_BASE + (reg_addr))

#define T7_PORT0_BASE 0x30000
#define T7_PORT0_REG(reg_addr) (T7_PORT0_BASE + (reg_addr))

#define T7_PORT1_BASE 0x32000
#define T7_PORT1_REG(reg_addr) (T7_PORT1_BASE + (reg_addr))

#define T7_PORT2_BASE 0x34000
#define T7_PORT2_REG(reg_addr) (T7_PORT2_BASE + (reg_addr))

#define T7_PORT3_BASE 0x36000
#define T7_PORT3_REG(reg_addr) (T7_PORT3_BASE + (reg_addr))

#define T7_PORT_STRIDE 0x2000
#define T7_PORT_BASE(idx) (T7_PORT0_BASE + (idx) * T7_PORT_STRIDE)
#define T7_PORT_REG(idx, reg) (T7_PORT_BASE(idx) + (reg))

#define PCIE_MEM_ACCESS_T7_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_MEM_ACCESS_T7_INSTANCES 16

#define PCIE_T7_CMD_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T7_CMD_INSTANCES 1

#define PCIE_T5_ARM_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_T5_ARM_INSTANCES 1

#define PCIE_JBOF_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_PCIE_JBOF_INSTANCES 16

#define PCIE_EMUADRRMAP_REG(reg_addr, idx) ((reg_addr) + (idx) * 32)
#define NUM_PCIE_EMUADRRMAP_INSTANCES 3

#define CIM_GFT_MASK(idx) (A_CIM_GFT_MASK + (idx) * 4)
#define NUM_CIM_GFT_MASK_INSTANCES 4

#define T7_MPS_TRC_FILTER_MATCH_CTL_A(idx) (A_T7_MPS_TRC_FILTER_MATCH_CTL_A + (idx) * 4)
#define NUM_T7_MPS_TRC_FILTER_MATCH_CTL_A_INSTANCES 8

#define T7_MPS_TRC_FILTER_MATCH_CTL_B(idx) (A_T7_MPS_TRC_FILTER_MATCH_CTL_B + (idx) * 4)
#define NUM_T7_MPS_TRC_FILTER_MATCH_CTL_B_INSTANCES 8

#define T7_MPS_TRC_FILTER_RUNT_CTL(idx) (A_T7_MPS_TRC_FILTER_RUNT_CTL + (idx) * 4)
#define NUM_T7_MPS_TRC_FILTER_RUNT_CTL_INSTANCES 8

#define T7_MPS_TRC_FILTER_DROP(idx) (A_T7_MPS_TRC_FILTER_DROP + (idx) * 4)
#define NUM_T7_MPS_TRC_FILTER_DROP_INSTANCES 8

#define MPS_TRC_FILTER4_MATCH(idx) (A_MPS_TRC_FILTER4_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER4_MATCH_INSTANCES 28

#define MPS_TRC_FILTER4_DONT_CARE(idx) (A_MPS_TRC_FILTER4_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER4_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER5_MATCH(idx) (A_MPS_TRC_FILTER5_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER5_MATCH_INSTANCES 28

#define MPS_TRC_FILTER5_DONT_CARE(idx) (A_MPS_TRC_FILTER5_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER5_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER6_MATCH(idx) (A_MPS_TRC_FILTER6_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER6_MATCH_INSTANCES 28

#define MPS_TRC_FILTER6_DONT_CARE(idx) (A_MPS_TRC_FILTER6_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER6_DONT_CARE_INSTANCES 28

#define MPS_TRC_FILTER7_MATCH(idx) (A_MPS_TRC_FILTER7_MATCH + (idx) * 4)
#define NUM_MPS_TRC_FILTER7_MATCH_INSTANCES 28

#define MPS_TRC_FILTER7_DONT_CARE(idx) (A_MPS_TRC_FILTER7_DONT_CARE + (idx) * 4)
#define NUM_MPS_TRC_FILTER7_DONT_CARE_INSTANCES 28

#define LE_DB_DBGI_REQ_DATA_T7(idx) (A_LE_DB_DBGI_REQ_DATA + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_DATA_T7_INSTANCES 13

#define LE_DB_DBGI_REQ_MASK_T7(idx) (A_LE_DB_DBGI_REQ_MASK + (idx) * 4)
#define NUM_LE_DB_DBGI_REQ_MASK_T7_INSTANCES 13

#define LE_DB_ACTIVE_MASK_IPV6_T7(idx) (A_LE_DB_ACTIVE_MASK_IPV6 + (idx) * 4)
#define NUM_LE_DB_ACTIVE_MASK_IPV6_T7_INSTANCES 8

#define LE_HASH_MASK_GEN_IPV4T7(idx) (A_LE_HASH_MASK_GEN_IPV4T5 + (idx) * 4)
#define NUM_LE_HASH_MASK_GEN_IPV4T7_INSTANCES 8

#define T7_LE_HASH_MASK_GEN_IPV6T5(idx) (A_T7_LE_HASH_MASK_GEN_IPV6T5 + (idx) * 4)
#define NUM_T7_LE_HASH_MASK_GEN_IPV6T5_INSTANCES 8

#define LE_DB_SECOND_GEN_HASH_MASK_IPV4_T7(idx) (A_LE_DB_SECOND_GEN_HASH_MASK_IPV4 + (idx) * 4)
#define NUM_LE_DB_SECOND_GEN_HASH_MASK_IPV4_T7_INSTANCES 8

#define TLS_TX_CH_REG(reg_addr, idx) ((reg_addr) + (idx) * 256)
#define NUM_TLS_TX_CH_INSTANCES 6

#define TLS_TX_CH_IND_REG(reg_addr, idx) ((reg_addr) + (idx) * 256)
#define NUM_TLS_TX_CH_IND_INSTANCES 6

#define ARM_CPU_REG(reg_addr, idx) ((reg_addr) + (idx) * 16)
#define NUM_ARM_CPU_INSTANCES 4

#define ARM_CCIM_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_ARM_CCIM_INSTANCES 4

#define ARM_CCIS_REG(reg_addr, idx) ((reg_addr) + (idx) * 8)
#define NUM_ARM_CCIS_INSTANCES 5

#define ARM_CCI_EVNTBUS(idx) (A_ARM_CCI_EVNTBUS + (idx) * 4)
#define NUM_ARM_CCI_EVNTBUS_INSTANCES 5

#define ARM_ARM_CFG1(idx) (A_ARM_ARM_CFG1 + (idx) * 4)
#define NUM_ARM_ARM_CFG1_INSTANCES 2

#define ARM_ARM_CFG2(idx) (A_ARM_ARM_CFG2 + (idx) * 4)
#define NUM_ARM_ARM_CFG2_INSTANCES 2

#define ARM_MSG_REG(reg_addr, idx) ((reg_addr) + (idx) * 48)
#define NUM_ARM_MSG_INSTANCES 4

#define ARM_MSG_PCIE_MESSAGE2AXI_CFG4(idx) (A_ARM_MSG_PCIE_MESSAGE2AXI_CFG4 + (idx) * 4)
#define NUM_ARM_MSG_PCIE_MESSAGE2AXI_CFG4_INSTANCES 2

#define MC_CE_ERR_DATA_T7_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_CE_ERR_DATA_T7_INSTANCES 16

#define MC_UE_ERR_DATA_T7_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_UE_ERR_DATA_T7_INSTANCES 16

#define MC_P_BIST_USER_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_MC_P_BIST_USER_INSTANCES 36

#define HMA_H_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_HMA_H_BIST_STATUS_INSTANCES 18

#define GCACHE_P_BIST_STATUS_REG(reg_addr, idx) ((reg_addr) + (idx) * 4)
#define NUM_GCACHE_P_BIST_STATUS_INSTANCES 18

#define CIM_CTL_MAILBOX_VF_STATUS_T7(idx) (A_CIM_CTL_MAILBOX_VF_STATUS + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VF_STATUS_T7_INSTANCES 8

#define CIM_CTL_MAILBOX_VFN_CTL_T7(idx) (A_CIM_CTL_MAILBOX_VFN_CTL + (idx) * 4)
#define NUM_CIM_CTL_MAILBOX_VFN_CTL_T7_INSTANCES 256

#define CIM_CTL_TID_MAP_EN(idx) (A_CIM_CTL_TID_MAP_EN + (idx) * 4)
#define NUM_CIM_CTL_TID_MAP_EN_INSTANCES 8

#define CIM_CTL_TID_MAP_CORE(idx) (A_CIM_CTL_TID_MAP_CORE + (idx) * 4)
#define NUM_CIM_CTL_TID_MAP_CORE_INSTANCES 8

#define CIM_CTL_CRYPTO_KEY_DATA(idx) (A_CIM_CTL_CRYPTO_KEY_DATA + (idx) * 4)
#define NUM_CIM_CTL_CRYPTO_KEY_DATA_INSTANCES 17

#define CIM_CTL_FLOWID_OP_VALID(idx) (A_CIM_CTL_FLOWID_OP_VALID + (idx) * 4)
#define NUM_CIM_CTL_FLOWID_OP_VALID_INSTANCES 8

#define CIM_CTL_SLV_REG(reg_addr, idx) ((reg_addr) + (idx) * 1024)
#define NUM_CIM_CTL_SLV_INSTANCES 7

#define EDC_STRIDE (EDC_1_BASE_ADDR - EDC_0_BASE_ADDR)
#define EDC_REG(reg, idx) (reg + EDC_STRIDE * idx)

#define EDC_T5_STRIDE (EDC_T51_BASE_ADDR - EDC_T50_BASE_ADDR)
#define EDC_T5_REG(reg, idx) (reg + EDC_T5_STRIDE * idx)

#define MC_STRIDE (MC_1_BASE_ADDR - MC_0_BASE_ADDR)
#define MC_REG(reg, idx) (reg + MC_STRIDE * idx)

#define MC_T7_STRIDE (MC_T71_BASE_ADDR - MC_T70_BASE_ADDR)
#define MC_T7_REG(reg, idx) (reg + MC_T7_STRIDE * idx)

/* registers for module SGE */
#define SGE_BASE_ADDR 0x1000

#define A_SGE_PF_KDOORBELL 0x0

#define S_QID    15
#define M_QID    0x1ffffU
#define V_QID(x) ((x) << S_QID)
#define G_QID(x) (((x) >> S_QID) & M_QID)

#define S_DBPRIO    14
#define V_DBPRIO(x) ((x) << S_DBPRIO)
#define F_DBPRIO    V_DBPRIO(1U)

#define S_PIDX    0
#define M_PIDX    0x3fffU
#define V_PIDX(x) ((x) << S_PIDX)
#define G_PIDX(x) (((x) >> S_PIDX) & M_PIDX)

#define A_SGE_VF_KDOORBELL 0x0

#define S_DBTYPE    13
#define V_DBTYPE(x) ((x) << S_DBTYPE)
#define F_DBTYPE    V_DBTYPE(1U)

#define S_PIDX_T5    0
#define M_PIDX_T5    0x1fffU
#define V_PIDX_T5(x) ((x) << S_PIDX_T5)
#define G_PIDX_T5(x) (((x) >> S_PIDX_T5) & M_PIDX_T5)

#define S_SYNC_T6    14
#define V_SYNC_T6(x) ((x) << S_SYNC_T6)
#define F_SYNC_T6    V_SYNC_T6(1U)

#define A_SGE_PF_GTS 0x4

#define S_INGRESSQID    16
#define M_INGRESSQID    0xffffU
#define V_INGRESSQID(x) ((x) << S_INGRESSQID)
#define G_INGRESSQID(x) (((x) >> S_INGRESSQID) & M_INGRESSQID)

#define S_TIMERREG    13
#define M_TIMERREG    0x7U
#define V_TIMERREG(x) ((x) << S_TIMERREG)
#define G_TIMERREG(x) (((x) >> S_TIMERREG) & M_TIMERREG)

#define S_SEINTARM    12
#define V_SEINTARM(x) ((x) << S_SEINTARM)
#define F_SEINTARM    V_SEINTARM(1U)

#define S_CIDXINC    0
#define M_CIDXINC    0xfffU
#define V_CIDXINC(x) ((x) << S_CIDXINC)
#define G_CIDXINC(x) (((x) >> S_CIDXINC) & M_CIDXINC)

#define A_SGE_VF_GTS 0x4
#define A_SGE_PF_KTIMESTAMP_LO 0x8
#define A_SGE_VF_KTIMESTAMP_LO 0x8
#define A_SGE_PF_KTIMESTAMP_HI 0xc

#define S_TSTAMPVAL    0
#define M_TSTAMPVAL    0xfffffffU
#define V_TSTAMPVAL(x) ((x) << S_TSTAMPVAL)
#define G_TSTAMPVAL(x) (((x) >> S_TSTAMPVAL) & M_TSTAMPVAL)

#define A_SGE_VF_KTIMESTAMP_HI 0xc
#define A_SGE_CONTROL 0x1008

#define S_IGRALLCPLTOFL    31
#define V_IGRALLCPLTOFL(x) ((x) << S_IGRALLCPLTOFL)
#define F_IGRALLCPLTOFL    V_IGRALLCPLTOFL(1U)

#define S_FLSPLITMIN    22
#define M_FLSPLITMIN    0x1ffU
#define V_FLSPLITMIN(x) ((x) << S_FLSPLITMIN)
#define G_FLSPLITMIN(x) (((x) >> S_FLSPLITMIN) & M_FLSPLITMIN)

#define S_FLSPLITMODE    20
#define M_FLSPLITMODE    0x3U
#define V_FLSPLITMODE(x) ((x) << S_FLSPLITMODE)
#define G_FLSPLITMODE(x) (((x) >> S_FLSPLITMODE) & M_FLSPLITMODE)

#define S_DCASYSTYPE    19
#define V_DCASYSTYPE(x) ((x) << S_DCASYSTYPE)
#define F_DCASYSTYPE    V_DCASYSTYPE(1U)

#define S_RXPKTCPLMODE    18
#define V_RXPKTCPLMODE(x) ((x) << S_RXPKTCPLMODE)
#define F_RXPKTCPLMODE    V_RXPKTCPLMODE(1U)

#define S_EGRSTATUSPAGESIZE    17
#define V_EGRSTATUSPAGESIZE(x) ((x) << S_EGRSTATUSPAGESIZE)
#define F_EGRSTATUSPAGESIZE    V_EGRSTATUSPAGESIZE(1U)

#define S_INGHINTENABLE1    15
#define V_INGHINTENABLE1(x) ((x) << S_INGHINTENABLE1)
#define F_INGHINTENABLE1    V_INGHINTENABLE1(1U)

#define S_INGHINTENABLE0    14
#define V_INGHINTENABLE0(x) ((x) << S_INGHINTENABLE0)
#define F_INGHINTENABLE0    V_INGHINTENABLE0(1U)

#define S_INGINTCOMPAREIDX    13
#define V_INGINTCOMPAREIDX(x) ((x) << S_INGINTCOMPAREIDX)
#define F_INGINTCOMPAREIDX    V_INGINTCOMPAREIDX(1U)

#define S_PKTSHIFT    10
#define M_PKTSHIFT    0x7U
#define V_PKTSHIFT(x) ((x) << S_PKTSHIFT)
#define G_PKTSHIFT(x) (((x) >> S_PKTSHIFT) & M_PKTSHIFT)

#define S_INGPCIEBOUNDARY    7
#define M_INGPCIEBOUNDARY    0x7U
#define V_INGPCIEBOUNDARY(x) ((x) << S_INGPCIEBOUNDARY)
#define G_INGPCIEBOUNDARY(x) (((x) >> S_INGPCIEBOUNDARY) & M_INGPCIEBOUNDARY)

#define S_INGPADBOUNDARY    4
#define M_INGPADBOUNDARY    0x7U
#define V_INGPADBOUNDARY(x) ((x) << S_INGPADBOUNDARY)
#define G_INGPADBOUNDARY(x) (((x) >> S_INGPADBOUNDARY) & M_INGPADBOUNDARY)

#define S_EGRPCIEBOUNDARY    1
#define M_EGRPCIEBOUNDARY    0x7U
#define V_EGRPCIEBOUNDARY(x) ((x) << S_EGRPCIEBOUNDARY)
#define G_EGRPCIEBOUNDARY(x) (((x) >> S_EGRPCIEBOUNDARY) & M_EGRPCIEBOUNDARY)

#define S_GLOBALENABLE    0
#define V_GLOBALENABLE(x) ((x) << S_GLOBALENABLE)
#define F_GLOBALENABLE    V_GLOBALENABLE(1U)

#define S_NUMOFFID    19
#define M_NUMOFFID    0x7U
#define V_NUMOFFID(x) ((x) << S_NUMOFFID)
#define G_NUMOFFID(x) (((x) >> S_NUMOFFID) & M_NUMOFFID)

#define S_INGHINTENABLE2    16
#define V_INGHINTENABLE2(x) ((x) << S_INGHINTENABLE2)
#define F_INGHINTENABLE2    V_INGHINTENABLE2(1U)

#define S_INGHINTENABLE3    3
#define V_INGHINTENABLE3(x) ((x) << S_INGHINTENABLE3)
#define F_INGHINTENABLE3    V_INGHINTENABLE3(1U)

#define S_TF_MODE    1
#define M_TF_MODE    0x3U
#define V_TF_MODE(x) ((x) << S_TF_MODE)
#define G_TF_MODE(x) (((x) >> S_TF_MODE) & M_TF_MODE)

#define A_SGE_HOST_PAGE_SIZE 0x100c

#define S_HOSTPAGESIZEPF7    28
#define M_HOSTPAGESIZEPF7    0xfU
#define V_HOSTPAGESIZEPF7(x) ((x) << S_HOSTPAGESIZEPF7)
#define G_HOSTPAGESIZEPF7(x) (((x) >> S_HOSTPAGESIZEPF7) & M_HOSTPAGESIZEPF7)

#define S_HOSTPAGESIZEPF6    24
#define M_HOSTPAGESIZEPF6    0xfU
#define V_HOSTPAGESIZEPF6(x) ((x) << S_HOSTPAGESIZEPF6)
#define G_HOSTPAGESIZEPF6(x) (((x) >> S_HOSTPAGESIZEPF6) & M_HOSTPAGESIZEPF6)

#define S_HOSTPAGESIZEPF5    20
#define M_HOSTPAGESIZEPF5    0xfU
#define V_HOSTPAGESIZEPF5(x) ((x) << S_HOSTPAGESIZEPF5)
#define G_HOSTPAGESIZEPF5(x) (((x) >> S_HOSTPAGESIZEPF5) & M_HOSTPAGESIZEPF5)

#define S_HOSTPAGESIZEPF4    16
#define M_HOSTPAGESIZEPF4    0xfU
#define V_HOSTPAGESIZEPF4(x) ((x) << S_HOSTPAGESIZEPF4)
#define G_HOSTPAGESIZEPF4(x) (((x) >> S_HOSTPAGESIZEPF4) & M_HOSTPAGESIZEPF4)

#define S_HOSTPAGESIZEPF3    12
#define M_HOSTPAGESIZEPF3    0xfU
#define V_HOSTPAGESIZEPF3(x) ((x) << S_HOSTPAGESIZEPF3)
#define G_HOSTPAGESIZEPF3(x) (((x) >> S_HOSTPAGESIZEPF3) & M_HOSTPAGESIZEPF3)

#define S_HOSTPAGESIZEPF2    8
#define M_HOSTPAGESIZEPF2    0xfU
#define V_HOSTPAGESIZEPF2(x) ((x) << S_HOSTPAGESIZEPF2)
#define G_HOSTPAGESIZEPF2(x) (((x) >> S_HOSTPAGESIZEPF2) & M_HOSTPAGESIZEPF2)

#define S_HOSTPAGESIZEPF1    4
#define M_HOSTPAGESIZEPF1    0xfU
#define V_HOSTPAGESIZEPF1(x) ((x) << S_HOSTPAGESIZEPF1)
#define G_HOSTPAGESIZEPF1(x) (((x) >> S_HOSTPAGESIZEPF1) & M_HOSTPAGESIZEPF1)

#define S_HOSTPAGESIZEPF0    0
#define M_HOSTPAGESIZEPF0    0xfU
#define V_HOSTPAGESIZEPF0(x) ((x) << S_HOSTPAGESIZEPF0)
#define G_HOSTPAGESIZEPF0(x) (((x) >> S_HOSTPAGESIZEPF0) & M_HOSTPAGESIZEPF0)

#define A_SGE_EGRESS_QUEUES_PER_PAGE_PF 0x1010

#define S_QUEUESPERPAGEPF7    28
#define M_QUEUESPERPAGEPF7    0xfU
#define V_QUEUESPERPAGEPF7(x) ((x) << S_QUEUESPERPAGEPF7)
#define G_QUEUESPERPAGEPF7(x) (((x) >> S_QUEUESPERPAGEPF7) & M_QUEUESPERPAGEPF7)

#define S_QUEUESPERPAGEPF6    24
#define M_QUEUESPERPAGEPF6    0xfU
#define V_QUEUESPERPAGEPF6(x) ((x) << S_QUEUESPERPAGEPF6)
#define G_QUEUESPERPAGEPF6(x) (((x) >> S_QUEUESPERPAGEPF6) & M_QUEUESPERPAGEPF6)

#define S_QUEUESPERPAGEPF5    20
#define M_QUEUESPERPAGEPF5    0xfU
#define V_QUEUESPERPAGEPF5(x) ((x) << S_QUEUESPERPAGEPF5)
#define G_QUEUESPERPAGEPF5(x) (((x) >> S_QUEUESPERPAGEPF5) & M_QUEUESPERPAGEPF5)

#define S_QUEUESPERPAGEPF4    16
#define M_QUEUESPERPAGEPF4    0xfU
#define V_QUEUESPERPAGEPF4(x) ((x) << S_QUEUESPERPAGEPF4)
#define G_QUEUESPERPAGEPF4(x) (((x) >> S_QUEUESPERPAGEPF4) & M_QUEUESPERPAGEPF4)

#define S_QUEUESPERPAGEPF3    12
#define M_QUEUESPERPAGEPF3    0xfU
#define V_QUEUESPERPAGEPF3(x) ((x) << S_QUEUESPERPAGEPF3)
#define G_QUEUESPERPAGEPF3(x) (((x) >> S_QUEUESPERPAGEPF3) & M_QUEUESPERPAGEPF3)

#define S_QUEUESPERPAGEPF2    8
#define M_QUEUESPERPAGEPF2    0xfU
#define V_QUEUESPERPAGEPF2(x) ((x) << S_QUEUESPERPAGEPF2)
#define G_QUEUESPERPAGEPF2(x) (((x) >> S_QUEUESPERPAGEPF2) & M_QUEUESPERPAGEPF2)

#define S_QUEUESPERPAGEPF1    4
#define M_QUEUESPERPAGEPF1    0xfU
#define V_QUEUESPERPAGEPF1(x) ((x) << S_QUEUESPERPAGEPF1)
#define G_QUEUESPERPAGEPF1(x) (((x) >> S_QUEUESPERPAGEPF1) & M_QUEUESPERPAGEPF1)

#define S_QUEUESPERPAGEPF0    0
#define M_QUEUESPERPAGEPF0    0xfU
#define V_QUEUESPERPAGEPF0(x) ((x) << S_QUEUESPERPAGEPF0)
#define G_QUEUESPERPAGEPF0(x) (((x) >> S_QUEUESPERPAGEPF0) & M_QUEUESPERPAGEPF0)

#define A_SGE_EGRESS_QUEUES_PER_PAGE_VF 0x1014

#define S_QUEUESPERPAGEVFPF7    28
#define M_QUEUESPERPAGEVFPF7    0xfU
#define V_QUEUESPERPAGEVFPF7(x) ((x) << S_QUEUESPERPAGEVFPF7)
#define G_QUEUESPERPAGEVFPF7(x) (((x) >> S_QUEUESPERPAGEVFPF7) & M_QUEUESPERPAGEVFPF7)

#define S_QUEUESPERPAGEVFPF6    24
#define M_QUEUESPERPAGEVFPF6    0xfU
#define V_QUEUESPERPAGEVFPF6(x) ((x) << S_QUEUESPERPAGEVFPF6)
#define G_QUEUESPERPAGEVFPF6(x) (((x) >> S_QUEUESPERPAGEVFPF6) & M_QUEUESPERPAGEVFPF6)

#define S_QUEUESPERPAGEVFPF5    20
#define M_QUEUESPERPAGEVFPF5    0xfU
#define V_QUEUESPERPAGEVFPF5(x) ((x) << S_QUEUESPERPAGEVFPF5)
#define G_QUEUESPERPAGEVFPF5(x) (((x) >> S_QUEUESPERPAGEVFPF5) & M_QUEUESPERPAGEVFPF5)

#define S_QUEUESPERPAGEVFPF4    16
#define M_QUEUESPERPAGEVFPF4    0xfU
#define V_QUEUESPERPAGEVFPF4(x) ((x) << S_QUEUESPERPAGEVFPF4)
#define G_QUEUESPERPAGEVFPF4(x) (((x) >> S_QUEUESPERPAGEVFPF4) & M_QUEUESPERPAGEVFPF4)

#define S_QUEUESPERPAGEVFPF3    12
#define M_QUEUESPERPAGEVFPF3    0xfU
#define V_QUEUESPERPAGEVFPF3(x) ((x) << S_QUEUESPERPAGEVFPF3)
#define G_QUEUESPERPAGEVFPF3(x) (((x) >> S_QUEUESPERPAGEVFPF3) & M_QUEUESPERPAGEVFPF3)

#define S_QUEUESPERPAGEVFPF2    8
#define M_QUEUESPERPAGEVFPF2    0xfU
#define V_QUEUESPERPAGEVFPF2(x) ((x) << S_QUEUESPERPAGEVFPF2)
#define G_QUEUESPERPAGEVFPF2(x) (((x) >> S_QUEUESPERPAGEVFPF2) & M_QUEUESPERPAGEVFPF2)

#define S_QUEUESPERPAGEVFPF1    4
#define M_QUEUESPERPAGEVFPF1    0xfU
#define V_QUEUESPERPAGEVFPF1(x) ((x) << S_QUEUESPERPAGEVFPF1)
#define G_QUEUESPERPAGEVFPF1(x) (((x) >> S_QUEUESPERPAGEVFPF1) & M_QUEUESPERPAGEVFPF1)

#define S_QUEUESPERPAGEVFPF0    0
#define M_QUEUESPERPAGEVFPF0    0xfU
#define V_QUEUESPERPAGEVFPF0(x) ((x) << S_QUEUESPERPAGEVFPF0)
#define G_QUEUESPERPAGEVFPF0(x) (((x) >> S_QUEUESPERPAGEVFPF0) & M_QUEUESPERPAGEVFPF0)

#define A_SGE_USER_MODE_LIMITS 0x1018

#define S_OPCODE_MIN    24
#define M_OPCODE_MIN    0xffU
#define V_OPCODE_MIN(x) ((x) << S_OPCODE_MIN)
#define G_OPCODE_MIN(x) (((x) >> S_OPCODE_MIN) & M_OPCODE_MIN)

#define S_OPCODE_MAX    16
#define M_OPCODE_MAX    0xffU
#define V_OPCODE_MAX(x) ((x) << S_OPCODE_MAX)
#define G_OPCODE_MAX(x) (((x) >> S_OPCODE_MAX) & M_OPCODE_MAX)

#define S_LENGTH_MIN    8
#define M_LENGTH_MIN    0xffU
#define V_LENGTH_MIN(x) ((x) << S_LENGTH_MIN)
#define G_LENGTH_MIN(x) (((x) >> S_LENGTH_MIN) & M_LENGTH_MIN)

#define S_LENGTH_MAX    0
#define M_LENGTH_MAX    0xffU
#define V_LENGTH_MAX(x) ((x) << S_LENGTH_MAX)
#define G_LENGTH_MAX(x) (((x) >> S_LENGTH_MAX) & M_LENGTH_MAX)

#define A_SGE_WR_ERROR 0x101c

#define S_WR_ERROR_OPCODE    0
#define M_WR_ERROR_OPCODE    0xffU
#define V_WR_ERROR_OPCODE(x) ((x) << S_WR_ERROR_OPCODE)
#define G_WR_ERROR_OPCODE(x) (((x) >> S_WR_ERROR_OPCODE) & M_WR_ERROR_OPCODE)

#define S_WR_SENDPATH_ERROR_OPCODE    16
#define M_WR_SENDPATH_ERROR_OPCODE    0xffU
#define V_WR_SENDPATH_ERROR_OPCODE(x) ((x) << S_WR_SENDPATH_ERROR_OPCODE)
#define G_WR_SENDPATH_ERROR_OPCODE(x) (((x) >> S_WR_SENDPATH_ERROR_OPCODE) & M_WR_SENDPATH_ERROR_OPCODE)

#define S_WR_SENDPATH_OPCODE    8
#define M_WR_SENDPATH_OPCODE    0xffU
#define V_WR_SENDPATH_OPCODE(x) ((x) << S_WR_SENDPATH_OPCODE)
#define G_WR_SENDPATH_OPCODE(x) (((x) >> S_WR_SENDPATH_OPCODE) & M_WR_SENDPATH_OPCODE)

#define A_SGE_PERR_INJECT 0x1020

#define S_MEMSEL    1
#define M_MEMSEL    0x1fU
#define V_MEMSEL(x) ((x) << S_MEMSEL)
#define G_MEMSEL(x) (((x) >> S_MEMSEL) & M_MEMSEL)

#define S_INJECTDATAERR    0
#define V_INJECTDATAERR(x) ((x) << S_INJECTDATAERR)
#define F_INJECTDATAERR    V_INJECTDATAERR(1U)

#define A_SGE_INT_CAUSE1 0x1024

#define S_PERR_FLM_CREDITFIFO    30
#define V_PERR_FLM_CREDITFIFO(x) ((x) << S_PERR_FLM_CREDITFIFO)
#define F_PERR_FLM_CREDITFIFO    V_PERR_FLM_CREDITFIFO(1U)

#define S_PERR_IMSG_HINT_FIFO    29
#define V_PERR_IMSG_HINT_FIFO(x) ((x) << S_PERR_IMSG_HINT_FIFO)
#define F_PERR_IMSG_HINT_FIFO    V_PERR_IMSG_HINT_FIFO(1U)

#define S_PERR_MC_PC    28
#define V_PERR_MC_PC(x) ((x) << S_PERR_MC_PC)
#define F_PERR_MC_PC    V_PERR_MC_PC(1U)

#define S_PERR_MC_IGR_CTXT    27
#define V_PERR_MC_IGR_CTXT(x) ((x) << S_PERR_MC_IGR_CTXT)
#define F_PERR_MC_IGR_CTXT    V_PERR_MC_IGR_CTXT(1U)

#define S_PERR_MC_EGR_CTXT    26
#define V_PERR_MC_EGR_CTXT(x) ((x) << S_PERR_MC_EGR_CTXT)
#define F_PERR_MC_EGR_CTXT    V_PERR_MC_EGR_CTXT(1U)

#define S_PERR_MC_FLM    25
#define V_PERR_MC_FLM(x) ((x) << S_PERR_MC_FLM)
#define F_PERR_MC_FLM    V_PERR_MC_FLM(1U)

#define S_PERR_PC_MCTAG    24
#define V_PERR_PC_MCTAG(x) ((x) << S_PERR_PC_MCTAG)
#define F_PERR_PC_MCTAG    V_PERR_PC_MCTAG(1U)

#define S_PERR_PC_CHPI_RSP1    23
#define V_PERR_PC_CHPI_RSP1(x) ((x) << S_PERR_PC_CHPI_RSP1)
#define F_PERR_PC_CHPI_RSP1    V_PERR_PC_CHPI_RSP1(1U)

#define S_PERR_PC_CHPI_RSP0    22
#define V_PERR_PC_CHPI_RSP0(x) ((x) << S_PERR_PC_CHPI_RSP0)
#define F_PERR_PC_CHPI_RSP0    V_PERR_PC_CHPI_RSP0(1U)

#define S_PERR_DBP_PC_RSP_FIFO3    21
#define V_PERR_DBP_PC_RSP_FIFO3(x) ((x) << S_PERR_DBP_PC_RSP_FIFO3)
#define F_PERR_DBP_PC_RSP_FIFO3    V_PERR_DBP_PC_RSP_FIFO3(1U)

#define S_PERR_DBP_PC_RSP_FIFO2    20
#define V_PERR_DBP_PC_RSP_FIFO2(x) ((x) << S_PERR_DBP_PC_RSP_FIFO2)
#define F_PERR_DBP_PC_RSP_FIFO2    V_PERR_DBP_PC_RSP_FIFO2(1U)

#define S_PERR_DBP_PC_RSP_FIFO1    19
#define V_PERR_DBP_PC_RSP_FIFO1(x) ((x) << S_PERR_DBP_PC_RSP_FIFO1)
#define F_PERR_DBP_PC_RSP_FIFO1    V_PERR_DBP_PC_RSP_FIFO1(1U)

#define S_PERR_DBP_PC_RSP_FIFO0    18
#define V_PERR_DBP_PC_RSP_FIFO0(x) ((x) << S_PERR_DBP_PC_RSP_FIFO0)
#define F_PERR_DBP_PC_RSP_FIFO0    V_PERR_DBP_PC_RSP_FIFO0(1U)

#define S_PERR_DMARBT    17
#define V_PERR_DMARBT(x) ((x) << S_PERR_DMARBT)
#define F_PERR_DMARBT    V_PERR_DMARBT(1U)

#define S_PERR_FLM_DBPFIFO    16
#define V_PERR_FLM_DBPFIFO(x) ((x) << S_PERR_FLM_DBPFIFO)
#define F_PERR_FLM_DBPFIFO    V_PERR_FLM_DBPFIFO(1U)

#define S_PERR_FLM_MCREQ_FIFO    15
#define V_PERR_FLM_MCREQ_FIFO(x) ((x) << S_PERR_FLM_MCREQ_FIFO)
#define F_PERR_FLM_MCREQ_FIFO    V_PERR_FLM_MCREQ_FIFO(1U)

#define S_PERR_FLM_HINTFIFO    14
#define V_PERR_FLM_HINTFIFO(x) ((x) << S_PERR_FLM_HINTFIFO)
#define F_PERR_FLM_HINTFIFO    V_PERR_FLM_HINTFIFO(1U)

#define S_PERR_ALIGN_CTL_FIFO3    13
#define V_PERR_ALIGN_CTL_FIFO3(x) ((x) << S_PERR_ALIGN_CTL_FIFO3)
#define F_PERR_ALIGN_CTL_FIFO3    V_PERR_ALIGN_CTL_FIFO3(1U)

#define S_PERR_ALIGN_CTL_FIFO2    12
#define V_PERR_ALIGN_CTL_FIFO2(x) ((x) << S_PERR_ALIGN_CTL_FIFO2)
#define F_PERR_ALIGN_CTL_FIFO2    V_PERR_ALIGN_CTL_FIFO2(1U)

#define S_PERR_ALIGN_CTL_FIFO1    11
#define V_PERR_ALIGN_CTL_FIFO1(x) ((x) << S_PERR_ALIGN_CTL_FIFO1)
#define F_PERR_ALIGN_CTL_FIFO1    V_PERR_ALIGN_CTL_FIFO1(1U)

#define S_PERR_ALIGN_CTL_FIFO0    10
#define V_PERR_ALIGN_CTL_FIFO0(x) ((x) << S_PERR_ALIGN_CTL_FIFO0)
#define F_PERR_ALIGN_CTL_FIFO0    V_PERR_ALIGN_CTL_FIFO0(1U)

#define S_PERR_EDMA_FIFO3    9
#define V_PERR_EDMA_FIFO3(x) ((x) << S_PERR_EDMA_FIFO3)
#define F_PERR_EDMA_FIFO3    V_PERR_EDMA_FIFO3(1U)

#define S_PERR_EDMA_FIFO2    8
#define V_PERR_EDMA_FIFO2(x) ((x) << S_PERR_EDMA_FIFO2)
#define F_PERR_EDMA_FIFO2    V_PERR_EDMA_FIFO2(1U)

#define S_PERR_EDMA_FIFO1    7
#define V_PERR_EDMA_FIFO1(x) ((x) << S_PERR_EDMA_FIFO1)
#define F_PERR_EDMA_FIFO1    V_PERR_EDMA_FIFO1(1U)

#define S_PERR_EDMA_FIFO0    6
#define V_PERR_EDMA_FIFO0(x) ((x) << S_PERR_EDMA_FIFO0)
#define F_PERR_EDMA_FIFO0    V_PERR_EDMA_FIFO0(1U)

#define S_PERR_PD_FIFO3    5
#define V_PERR_PD_FIFO3(x) ((x) << S_PERR_PD_FIFO3)
#define F_PERR_PD_FIFO3    V_PERR_PD_FIFO3(1U)

#define S_PERR_PD_FIFO2    4
#define V_PERR_PD_FIFO2(x) ((x) << S_PERR_PD_FIFO2)
#define F_PERR_PD_FIFO2    V_PERR_PD_FIFO2(1U)

#define S_PERR_PD_FIFO1    3
#define V_PERR_PD_FIFO1(x) ((x) << S_PERR_PD_FIFO1)
#define F_PERR_PD_FIFO1    V_PERR_PD_FIFO1(1U)

#define S_PERR_PD_FIFO0    2
#define V_PERR_PD_FIFO0(x) ((x) << S_PERR_PD_FIFO0)
#define F_PERR_PD_FIFO0    V_PERR_PD_FIFO0(1U)

#define S_PERR_ING_CTXT_MIFRSP    1
#define V_PERR_ING_CTXT_MIFRSP(x) ((x) << S_PERR_ING_CTXT_MIFRSP)
#define F_PERR_ING_CTXT_MIFRSP    V_PERR_ING_CTXT_MIFRSP(1U)

#define S_PERR_EGR_CTXT_MIFRSP    0
#define V_PERR_EGR_CTXT_MIFRSP(x) ((x) << S_PERR_EGR_CTXT_MIFRSP)
#define F_PERR_EGR_CTXT_MIFRSP    V_PERR_EGR_CTXT_MIFRSP(1U)

#define S_PERR_PC_CHPI_RSP2    31
#define V_PERR_PC_CHPI_RSP2(x) ((x) << S_PERR_PC_CHPI_RSP2)
#define F_PERR_PC_CHPI_RSP2    V_PERR_PC_CHPI_RSP2(1U)

#define S_PERR_PC_RSP    23
#define V_PERR_PC_RSP(x) ((x) << S_PERR_PC_RSP)
#define F_PERR_PC_RSP    V_PERR_PC_RSP(1U)

#define S_PERR_PC_REQ    22
#define V_PERR_PC_REQ(x) ((x) << S_PERR_PC_REQ)
#define F_PERR_PC_REQ    V_PERR_PC_REQ(1U)

#define S_PERR_HEADERSPLIT_FIFO3    28
#define V_PERR_HEADERSPLIT_FIFO3(x) ((x) << S_PERR_HEADERSPLIT_FIFO3)
#define F_PERR_HEADERSPLIT_FIFO3    V_PERR_HEADERSPLIT_FIFO3(1U)

#define S_PERR_HEADERSPLIT_FIFO2    27
#define V_PERR_HEADERSPLIT_FIFO2(x) ((x) << S_PERR_HEADERSPLIT_FIFO2)
#define F_PERR_HEADERSPLIT_FIFO2    V_PERR_HEADERSPLIT_FIFO2(1U)

#define S_PERR_PAYLOAD_FIFO3    26
#define V_PERR_PAYLOAD_FIFO3(x) ((x) << S_PERR_PAYLOAD_FIFO3)
#define F_PERR_PAYLOAD_FIFO3    V_PERR_PAYLOAD_FIFO3(1U)

#define S_PERR_PAYLOAD_FIFO2    25
#define V_PERR_PAYLOAD_FIFO2(x) ((x) << S_PERR_PAYLOAD_FIFO2)
#define F_PERR_PAYLOAD_FIFO2    V_PERR_PAYLOAD_FIFO2(1U)

#define A_SGE_INT_ENABLE1 0x1028
#define A_SGE_PERR_ENABLE1 0x102c
#define A_SGE_INT_CAUSE2 0x1030

#define S_PERR_HINT_DELAY_FIFO1    30
#define V_PERR_HINT_DELAY_FIFO1(x) ((x) << S_PERR_HINT_DELAY_FIFO1)
#define F_PERR_HINT_DELAY_FIFO1    V_PERR_HINT_DELAY_FIFO1(1U)

#define S_PERR_HINT_DELAY_FIFO0    29
#define V_PERR_HINT_DELAY_FIFO0(x) ((x) << S_PERR_HINT_DELAY_FIFO0)
#define F_PERR_HINT_DELAY_FIFO0    V_PERR_HINT_DELAY_FIFO0(1U)

#define S_PERR_IMSG_PD_FIFO    28
#define V_PERR_IMSG_PD_FIFO(x) ((x) << S_PERR_IMSG_PD_FIFO)
#define F_PERR_IMSG_PD_FIFO    V_PERR_IMSG_PD_FIFO(1U)

#define S_PERR_ULPTX_FIFO1    27
#define V_PERR_ULPTX_FIFO1(x) ((x) << S_PERR_ULPTX_FIFO1)
#define F_PERR_ULPTX_FIFO1    V_PERR_ULPTX_FIFO1(1U)

#define S_PERR_ULPTX_FIFO0    26
#define V_PERR_ULPTX_FIFO0(x) ((x) << S_PERR_ULPTX_FIFO0)
#define F_PERR_ULPTX_FIFO0    V_PERR_ULPTX_FIFO0(1U)

#define S_PERR_IDMA2IMSG_FIFO1    25
#define V_PERR_IDMA2IMSG_FIFO1(x) ((x) << S_PERR_IDMA2IMSG_FIFO1)
#define F_PERR_IDMA2IMSG_FIFO1    V_PERR_IDMA2IMSG_FIFO1(1U)

#define S_PERR_IDMA2IMSG_FIFO0    24
#define V_PERR_IDMA2IMSG_FIFO0(x) ((x) << S_PERR_IDMA2IMSG_FIFO0)
#define F_PERR_IDMA2IMSG_FIFO0    V_PERR_IDMA2IMSG_FIFO0(1U)

#define S_PERR_HEADERSPLIT_FIFO1    23
#define V_PERR_HEADERSPLIT_FIFO1(x) ((x) << S_PERR_HEADERSPLIT_FIFO1)
#define F_PERR_HEADERSPLIT_FIFO1    V_PERR_HEADERSPLIT_FIFO1(1U)

#define S_PERR_HEADERSPLIT_FIFO0    22
#define V_PERR_HEADERSPLIT_FIFO0(x) ((x) << S_PERR_HEADERSPLIT_FIFO0)
#define F_PERR_HEADERSPLIT_FIFO0    V_PERR_HEADERSPLIT_FIFO0(1U)

#define S_PERR_ESWITCH_FIFO3    21
#define V_PERR_ESWITCH_FIFO3(x) ((x) << S_PERR_ESWITCH_FIFO3)
#define F_PERR_ESWITCH_FIFO3    V_PERR_ESWITCH_FIFO3(1U)

#define S_PERR_ESWITCH_FIFO2    20
#define V_PERR_ESWITCH_FIFO2(x) ((x) << S_PERR_ESWITCH_FIFO2)
#define F_PERR_ESWITCH_FIFO2    V_PERR_ESWITCH_FIFO2(1U)

#define S_PERR_ESWITCH_FIFO1    19
#define V_PERR_ESWITCH_FIFO1(x) ((x) << S_PERR_ESWITCH_FIFO1)
#define F_PERR_ESWITCH_FIFO1    V_PERR_ESWITCH_FIFO1(1U)

#define S_PERR_ESWITCH_FIFO0    18
#define V_PERR_ESWITCH_FIFO0(x) ((x) << S_PERR_ESWITCH_FIFO0)
#define F_PERR_ESWITCH_FIFO0    V_PERR_ESWITCH_FIFO0(1U)

#define S_PERR_PC_DBP1    17
#define V_PERR_PC_DBP1(x) ((x) << S_PERR_PC_DBP1)
#define F_PERR_PC_DBP1    V_PERR_PC_DBP1(1U)

#define S_PERR_PC_DBP0    16
#define V_PERR_PC_DBP0(x) ((x) << S_PERR_PC_DBP0)
#define F_PERR_PC_DBP0    V_PERR_PC_DBP0(1U)

#define S_PERR_IMSG_OB_FIFO    15
#define V_PERR_IMSG_OB_FIFO(x) ((x) << S_PERR_IMSG_OB_FIFO)
#define F_PERR_IMSG_OB_FIFO    V_PERR_IMSG_OB_FIFO(1U)

#define S_PERR_CONM_SRAM    14
#define V_PERR_CONM_SRAM(x) ((x) << S_PERR_CONM_SRAM)
#define F_PERR_CONM_SRAM    V_PERR_CONM_SRAM(1U)

#define S_PERR_PC_MC_RSP    13
#define V_PERR_PC_MC_RSP(x) ((x) << S_PERR_PC_MC_RSP)
#define F_PERR_PC_MC_RSP    V_PERR_PC_MC_RSP(1U)

#define S_PERR_ISW_IDMA0_FIFO    12
#define V_PERR_ISW_IDMA0_FIFO(x) ((x) << S_PERR_ISW_IDMA0_FIFO)
#define F_PERR_ISW_IDMA0_FIFO    V_PERR_ISW_IDMA0_FIFO(1U)

#define S_PERR_ISW_IDMA1_FIFO    11
#define V_PERR_ISW_IDMA1_FIFO(x) ((x) << S_PERR_ISW_IDMA1_FIFO)
#define F_PERR_ISW_IDMA1_FIFO    V_PERR_ISW_IDMA1_FIFO(1U)

#define S_PERR_ISW_DBP_FIFO    10
#define V_PERR_ISW_DBP_FIFO(x) ((x) << S_PERR_ISW_DBP_FIFO)
#define F_PERR_ISW_DBP_FIFO    V_PERR_ISW_DBP_FIFO(1U)

#define S_PERR_ISW_GTS_FIFO    9
#define V_PERR_ISW_GTS_FIFO(x) ((x) << S_PERR_ISW_GTS_FIFO)
#define F_PERR_ISW_GTS_FIFO    V_PERR_ISW_GTS_FIFO(1U)

#define S_PERR_ITP_EVR    8
#define V_PERR_ITP_EVR(x) ((x) << S_PERR_ITP_EVR)
#define F_PERR_ITP_EVR    V_PERR_ITP_EVR(1U)

#define S_PERR_FLM_CNTXMEM    7
#define V_PERR_FLM_CNTXMEM(x) ((x) << S_PERR_FLM_CNTXMEM)
#define F_PERR_FLM_CNTXMEM    V_PERR_FLM_CNTXMEM(1U)

#define S_PERR_FLM_L1CACHE    6
#define V_PERR_FLM_L1CACHE(x) ((x) << S_PERR_FLM_L1CACHE)
#define F_PERR_FLM_L1CACHE    V_PERR_FLM_L1CACHE(1U)

#define S_PERR_DBP_HINT_FIFO    5
#define V_PERR_DBP_HINT_FIFO(x) ((x) << S_PERR_DBP_HINT_FIFO)
#define F_PERR_DBP_HINT_FIFO    V_PERR_DBP_HINT_FIFO(1U)

#define S_PERR_DBP_HP_FIFO    4
#define V_PERR_DBP_HP_FIFO(x) ((x) << S_PERR_DBP_HP_FIFO)
#define F_PERR_DBP_HP_FIFO    V_PERR_DBP_HP_FIFO(1U)

#define S_PERR_DBP_LP_FIFO    3
#define V_PERR_DBP_LP_FIFO(x) ((x) << S_PERR_DBP_LP_FIFO)
#define F_PERR_DBP_LP_FIFO    V_PERR_DBP_LP_FIFO(1U)

#define S_PERR_ING_CTXT_CACHE    2
#define V_PERR_ING_CTXT_CACHE(x) ((x) << S_PERR_ING_CTXT_CACHE)
#define F_PERR_ING_CTXT_CACHE    V_PERR_ING_CTXT_CACHE(1U)

#define S_PERR_EGR_CTXT_CACHE    1
#define V_PERR_EGR_CTXT_CACHE(x) ((x) << S_PERR_EGR_CTXT_CACHE)
#define F_PERR_EGR_CTXT_CACHE    V_PERR_EGR_CTXT_CACHE(1U)

#define S_PERR_BASE_SIZE    0
#define V_PERR_BASE_SIZE(x) ((x) << S_PERR_BASE_SIZE)
#define F_PERR_BASE_SIZE    V_PERR_BASE_SIZE(1U)

#define S_PERR_DBP_HINT_FL_FIFO    24
#define V_PERR_DBP_HINT_FL_FIFO(x) ((x) << S_PERR_DBP_HINT_FL_FIFO)
#define F_PERR_DBP_HINT_FL_FIFO    V_PERR_DBP_HINT_FL_FIFO(1U)

#define S_PERR_EGR_DBP_TX_COAL    23
#define V_PERR_EGR_DBP_TX_COAL(x) ((x) << S_PERR_EGR_DBP_TX_COAL)
#define F_PERR_EGR_DBP_TX_COAL    V_PERR_EGR_DBP_TX_COAL(1U)

#define S_PERR_DBP_FL_FIFO    22
#define V_PERR_DBP_FL_FIFO(x) ((x) << S_PERR_DBP_FL_FIFO)
#define F_PERR_DBP_FL_FIFO    V_PERR_DBP_FL_FIFO(1U)

#define S_PERR_PC_DBP2    15
#define V_PERR_PC_DBP2(x) ((x) << S_PERR_PC_DBP2)
#define F_PERR_PC_DBP2    V_PERR_PC_DBP2(1U)

#define S_DEQ_LL_PERR    21
#define V_DEQ_LL_PERR(x) ((x) << S_DEQ_LL_PERR)
#define F_DEQ_LL_PERR    V_DEQ_LL_PERR(1U)

#define S_ENQ_PERR    20
#define V_ENQ_PERR(x) ((x) << S_ENQ_PERR)
#define F_ENQ_PERR    V_ENQ_PERR(1U)

#define S_DEQ_OUT_PERR    19
#define V_DEQ_OUT_PERR(x) ((x) << S_DEQ_OUT_PERR)
#define F_DEQ_OUT_PERR    V_DEQ_OUT_PERR(1U)

#define S_BUF_PERR    18
#define V_BUF_PERR(x) ((x) << S_BUF_PERR)
#define F_BUF_PERR    V_BUF_PERR(1U)

#define S_PERR_DB_FIFO    3
#define V_PERR_DB_FIFO(x) ((x) << S_PERR_DB_FIFO)
#define F_PERR_DB_FIFO    V_PERR_DB_FIFO(1U)

#define S_TF_FIFO_PERR    24
#define V_TF_FIFO_PERR(x) ((x) << S_TF_FIFO_PERR)
#define F_TF_FIFO_PERR    V_TF_FIFO_PERR(1U)

#define S_PERR_ISW_IDMA3_FIFO    15
#define V_PERR_ISW_IDMA3_FIFO(x) ((x) << S_PERR_ISW_IDMA3_FIFO)
#define F_PERR_ISW_IDMA3_FIFO    V_PERR_ISW_IDMA3_FIFO(1U)

#define S_PERR_ISW_IDMA2_FIFO    13
#define V_PERR_ISW_IDMA2_FIFO(x) ((x) << S_PERR_ISW_IDMA2_FIFO)
#define F_PERR_ISW_IDMA2_FIFO    V_PERR_ISW_IDMA2_FIFO(1U)

#define S_SGE_IPP_FIFO_PERR    5
#define V_SGE_IPP_FIFO_PERR(x) ((x) << S_SGE_IPP_FIFO_PERR)
#define F_SGE_IPP_FIFO_PERR    V_SGE_IPP_FIFO_PERR(1U)

#define A_SGE_INT_ENABLE2 0x1034
#define A_SGE_PERR_ENABLE2 0x1038
#define A_SGE_INT_CAUSE3 0x103c

#define S_ERR_FLM_DBP    31
#define V_ERR_FLM_DBP(x) ((x) << S_ERR_FLM_DBP)
#define F_ERR_FLM_DBP    V_ERR_FLM_DBP(1U)

#define S_ERR_FLM_IDMA1    30
#define V_ERR_FLM_IDMA1(x) ((x) << S_ERR_FLM_IDMA1)
#define F_ERR_FLM_IDMA1    V_ERR_FLM_IDMA1(1U)

#define S_ERR_FLM_IDMA0    29
#define V_ERR_FLM_IDMA0(x) ((x) << S_ERR_FLM_IDMA0)
#define F_ERR_FLM_IDMA0    V_ERR_FLM_IDMA0(1U)

#define S_ERR_FLM_HINT    28
#define V_ERR_FLM_HINT(x) ((x) << S_ERR_FLM_HINT)
#define F_ERR_FLM_HINT    V_ERR_FLM_HINT(1U)

#define S_ERR_PCIE_ERROR3    27
#define V_ERR_PCIE_ERROR3(x) ((x) << S_ERR_PCIE_ERROR3)
#define F_ERR_PCIE_ERROR3    V_ERR_PCIE_ERROR3(1U)

#define S_ERR_PCIE_ERROR2    26
#define V_ERR_PCIE_ERROR2(x) ((x) << S_ERR_PCIE_ERROR2)
#define F_ERR_PCIE_ERROR2    V_ERR_PCIE_ERROR2(1U)

#define S_ERR_PCIE_ERROR1    25
#define V_ERR_PCIE_ERROR1(x) ((x) << S_ERR_PCIE_ERROR1)
#define F_ERR_PCIE_ERROR1    V_ERR_PCIE_ERROR1(1U)

#define S_ERR_PCIE_ERROR0    24
#define V_ERR_PCIE_ERROR0(x) ((x) << S_ERR_PCIE_ERROR0)
#define F_ERR_PCIE_ERROR0    V_ERR_PCIE_ERROR0(1U)

#define S_ERR_TIMER_ABOVE_MAX_QID    23
#define V_ERR_TIMER_ABOVE_MAX_QID(x) ((x) << S_ERR_TIMER_ABOVE_MAX_QID)
#define F_ERR_TIMER_ABOVE_MAX_QID    V_ERR_TIMER_ABOVE_MAX_QID(1U)

#define S_ERR_CPL_EXCEED_IQE_SIZE    22
#define V_ERR_CPL_EXCEED_IQE_SIZE(x) ((x) << S_ERR_CPL_EXCEED_IQE_SIZE)
#define F_ERR_CPL_EXCEED_IQE_SIZE    V_ERR_CPL_EXCEED_IQE_SIZE(1U)

#define S_ERR_INVALID_CIDX_INC    21
#define V_ERR_INVALID_CIDX_INC(x) ((x) << S_ERR_INVALID_CIDX_INC)
#define F_ERR_INVALID_CIDX_INC    V_ERR_INVALID_CIDX_INC(1U)

#define S_ERR_ITP_TIME_PAUSED    20
#define V_ERR_ITP_TIME_PAUSED(x) ((x) << S_ERR_ITP_TIME_PAUSED)
#define F_ERR_ITP_TIME_PAUSED    V_ERR_ITP_TIME_PAUSED(1U)

#define S_ERR_CPL_OPCODE_0    19
#define V_ERR_CPL_OPCODE_0(x) ((x) << S_ERR_CPL_OPCODE_0)
#define F_ERR_CPL_OPCODE_0    V_ERR_CPL_OPCODE_0(1U)

#define S_ERR_DROPPED_DB    18
#define V_ERR_DROPPED_DB(x) ((x) << S_ERR_DROPPED_DB)
#define F_ERR_DROPPED_DB    V_ERR_DROPPED_DB(1U)

#define S_ERR_DATA_CPL_ON_HIGH_QID1    17
#define V_ERR_DATA_CPL_ON_HIGH_QID1(x) ((x) << S_ERR_DATA_CPL_ON_HIGH_QID1)
#define F_ERR_DATA_CPL_ON_HIGH_QID1    V_ERR_DATA_CPL_ON_HIGH_QID1(1U)

#define S_ERR_DATA_CPL_ON_HIGH_QID0    16
#define V_ERR_DATA_CPL_ON_HIGH_QID0(x) ((x) << S_ERR_DATA_CPL_ON_HIGH_QID0)
#define F_ERR_DATA_CPL_ON_HIGH_QID0    V_ERR_DATA_CPL_ON_HIGH_QID0(1U)

#define S_ERR_BAD_DB_PIDX3    15
#define V_ERR_BAD_DB_PIDX3(x) ((x) << S_ERR_BAD_DB_PIDX3)
#define F_ERR_BAD_DB_PIDX3    V_ERR_BAD_DB_PIDX3(1U)

#define S_ERR_BAD_DB_PIDX2    14
#define V_ERR_BAD_DB_PIDX2(x) ((x) << S_ERR_BAD_DB_PIDX2)
#define F_ERR_BAD_DB_PIDX2    V_ERR_BAD_DB_PIDX2(1U)

#define S_ERR_BAD_DB_PIDX1    13
#define V_ERR_BAD_DB_PIDX1(x) ((x) << S_ERR_BAD_DB_PIDX1)
#define F_ERR_BAD_DB_PIDX1    V_ERR_BAD_DB_PIDX1(1U)

#define S_ERR_BAD_DB_PIDX0    12
#define V_ERR_BAD_DB_PIDX0(x) ((x) << S_ERR_BAD_DB_PIDX0)
#define F_ERR_BAD_DB_PIDX0    V_ERR_BAD_DB_PIDX0(1U)

#define S_ERR_ING_PCIE_CHAN    11
#define V_ERR_ING_PCIE_CHAN(x) ((x) << S_ERR_ING_PCIE_CHAN)
#define F_ERR_ING_PCIE_CHAN    V_ERR_ING_PCIE_CHAN(1U)

#define S_ERR_ING_CTXT_PRIO    10
#define V_ERR_ING_CTXT_PRIO(x) ((x) << S_ERR_ING_CTXT_PRIO)
#define F_ERR_ING_CTXT_PRIO    V_ERR_ING_CTXT_PRIO(1U)

#define S_ERR_EGR_CTXT_PRIO    9
#define V_ERR_EGR_CTXT_PRIO(x) ((x) << S_ERR_EGR_CTXT_PRIO)
#define F_ERR_EGR_CTXT_PRIO    V_ERR_EGR_CTXT_PRIO(1U)

#define S_DBFIFO_HP_INT    8
#define V_DBFIFO_HP_INT(x) ((x) << S_DBFIFO_HP_INT)
#define F_DBFIFO_HP_INT    V_DBFIFO_HP_INT(1U)

#define S_DBFIFO_LP_INT    7
#define V_DBFIFO_LP_INT(x) ((x) << S_DBFIFO_LP_INT)
#define F_DBFIFO_LP_INT    V_DBFIFO_LP_INT(1U)

#define S_REG_ADDRESS_ERR    6
#define V_REG_ADDRESS_ERR(x) ((x) << S_REG_ADDRESS_ERR)
#define F_REG_ADDRESS_ERR    V_REG_ADDRESS_ERR(1U)

#define S_INGRESS_SIZE_ERR    5
#define V_INGRESS_SIZE_ERR(x) ((x) << S_INGRESS_SIZE_ERR)
#define F_INGRESS_SIZE_ERR    V_INGRESS_SIZE_ERR(1U)

#define S_EGRESS_SIZE_ERR    4
#define V_EGRESS_SIZE_ERR(x) ((x) << S_EGRESS_SIZE_ERR)
#define F_EGRESS_SIZE_ERR    V_EGRESS_SIZE_ERR(1U)

#define S_ERR_INV_CTXT3    3
#define V_ERR_INV_CTXT3(x) ((x) << S_ERR_INV_CTXT3)
#define F_ERR_INV_CTXT3    V_ERR_INV_CTXT3(1U)

#define S_ERR_INV_CTXT2    2
#define V_ERR_INV_CTXT2(x) ((x) << S_ERR_INV_CTXT2)
#define F_ERR_INV_CTXT2    V_ERR_INV_CTXT2(1U)

#define S_ERR_INV_CTXT1    1
#define V_ERR_INV_CTXT1(x) ((x) << S_ERR_INV_CTXT1)
#define F_ERR_INV_CTXT1    V_ERR_INV_CTXT1(1U)

#define S_ERR_INV_CTXT0    0
#define V_ERR_INV_CTXT0(x) ((x) << S_ERR_INV_CTXT0)
#define F_ERR_INV_CTXT0    V_ERR_INV_CTXT0(1U)

#define S_DBP_TBUF_FULL    8
#define V_DBP_TBUF_FULL(x) ((x) << S_DBP_TBUF_FULL)
#define F_DBP_TBUF_FULL    V_DBP_TBUF_FULL(1U)

#define S_FATAL_WRE_LEN    7
#define V_FATAL_WRE_LEN(x) ((x) << S_FATAL_WRE_LEN)
#define F_FATAL_WRE_LEN    V_FATAL_WRE_LEN(1U)

#define A_SGE_INT_ENABLE3 0x1040
#define A_SGE_FL_BUFFER_SIZE0 0x1044

#define S_SIZE    4
#define CXGBE_M_SIZE    0xfffffffU
#define V_SIZE(x) ((x) << S_SIZE)
#define G_SIZE(x) (((x) >> S_SIZE) & CXGBE_M_SIZE)

#define S_T6_SIZE    4
#define M_T6_SIZE    0xfffffU
#define V_T6_SIZE(x) ((x) << S_T6_SIZE)
#define G_T6_SIZE(x) (((x) >> S_T6_SIZE) & M_T6_SIZE)

#define A_SGE_FL_BUFFER_SIZE1 0x1048
#define A_SGE_FL_BUFFER_SIZE2 0x104c
#define A_SGE_FL_BUFFER_SIZE3 0x1050
#define A_SGE_FL_BUFFER_SIZE4 0x1054
#define A_SGE_FL_BUFFER_SIZE5 0x1058
#define A_SGE_FL_BUFFER_SIZE6 0x105c
#define A_SGE_FL_BUFFER_SIZE7 0x1060
#define A_SGE_FL_BUFFER_SIZE8 0x1064
#define A_SGE_FL_BUFFER_SIZE9 0x1068
#define A_SGE_FL_BUFFER_SIZE10 0x106c
#define A_SGE_FL_BUFFER_SIZE11 0x1070
#define A_SGE_FL_BUFFER_SIZE12 0x1074
#define A_SGE_FL_BUFFER_SIZE13 0x1078
#define A_SGE_FL_BUFFER_SIZE14 0x107c
#define A_SGE_FL_BUFFER_SIZE15 0x1080
#define A_SGE_DBQ_CTXT_BADDR 0x1084

#define S_BASEADDR    3
#define M_BASEADDR    0x1fffffffU
#define V_BASEADDR(x) ((x) << S_BASEADDR)
#define G_BASEADDR(x) (((x) >> S_BASEADDR) & M_BASEADDR)

#define A_SGE_IMSG_CTXT_BADDR 0x1088
#define A_SGE_FLM_CACHE_BADDR 0x108c
#define A_SGE_FLM_CFG 0x1090

#define S_OPMODE    26
#define M_OPMODE    0x3fU
#define V_OPMODE(x) ((x) << S_OPMODE)
#define G_OPMODE(x) (((x) >> S_OPMODE) & M_OPMODE)

#define S_NOHDR    18
#define V_NOHDR(x) ((x) << S_NOHDR)
#define F_NOHDR    V_NOHDR(1U)

#define S_CACHEPTRCNT    16
#define M_CACHEPTRCNT    0x3U
#define V_CACHEPTRCNT(x) ((x) << S_CACHEPTRCNT)
#define G_CACHEPTRCNT(x) (((x) >> S_CACHEPTRCNT) & M_CACHEPTRCNT)

#define S_EDRAMPTRCNT    14
#define M_EDRAMPTRCNT    0x3U
#define V_EDRAMPTRCNT(x) ((x) << S_EDRAMPTRCNT)
#define G_EDRAMPTRCNT(x) (((x) >> S_EDRAMPTRCNT) & M_EDRAMPTRCNT)

#define S_HDRSTARTFLQ    11
#define M_HDRSTARTFLQ    0x7U
#define V_HDRSTARTFLQ(x) ((x) << S_HDRSTARTFLQ)
#define G_HDRSTARTFLQ(x) (((x) >> S_HDRSTARTFLQ) & M_HDRSTARTFLQ)

#define S_FETCHTHRESH    6
#define M_FETCHTHRESH    0x1fU
#define V_FETCHTHRESH(x) ((x) << S_FETCHTHRESH)
#define G_FETCHTHRESH(x) (((x) >> S_FETCHTHRESH) & M_FETCHTHRESH)

#define S_CREDITCNT    4
#define M_CREDITCNT    0x3U
#define V_CREDITCNT(x) ((x) << S_CREDITCNT)
#define G_CREDITCNT(x) (((x) >> S_CREDITCNT) & M_CREDITCNT)

#define S_NOEDRAM    0
#define V_NOEDRAM(x) ((x) << S_NOEDRAM)
#define F_NOEDRAM    V_NOEDRAM(1U)

#define S_CREDITCNTPACKING    2
#define M_CREDITCNTPACKING    0x3U
#define V_CREDITCNTPACKING(x) ((x) << S_CREDITCNTPACKING)
#define G_CREDITCNTPACKING(x) (((x) >> S_CREDITCNTPACKING) & M_CREDITCNTPACKING)

#define S_NULLPTR    20
#define M_NULLPTR    0xfU
#define V_NULLPTR(x) ((x) << S_NULLPTR)
#define G_NULLPTR(x) (((x) >> S_NULLPTR) & M_NULLPTR)

#define S_NULLPTREN    19
#define V_NULLPTREN(x) ((x) << S_NULLPTREN)
#define F_NULLPTREN    V_NULLPTREN(1U)

#define S_HDRSTARTFLQ4K    1
#define V_HDRSTARTFLQ4K(x) ((x) << S_HDRSTARTFLQ4K)
#define F_HDRSTARTFLQ4K    V_HDRSTARTFLQ4K(1U)

#define A_SGE_CONM_CTRL 0x1094

#define S_EGRTHRESHOLD    8
#define M_EGRTHRESHOLD    0x3fU
#define V_EGRTHRESHOLD(x) ((x) << S_EGRTHRESHOLD)
#define G_EGRTHRESHOLD(x) (((x) >> S_EGRTHRESHOLD) & M_EGRTHRESHOLD)

#define S_INGTHRESHOLD    2
#define M_INGTHRESHOLD    0x3fU
#define V_INGTHRESHOLD(x) ((x) << S_INGTHRESHOLD)
#define G_INGTHRESHOLD(x) (((x) >> S_INGTHRESHOLD) & M_INGTHRESHOLD)

#define S_MPS_ENABLE    1
#define V_MPS_ENABLE(x) ((x) << S_MPS_ENABLE)
#define F_MPS_ENABLE    V_MPS_ENABLE(1U)

#define S_TP_ENABLE    0
#define V_TP_ENABLE(x) ((x) << S_TP_ENABLE)
#define F_TP_ENABLE    V_TP_ENABLE(1U)

#define S_EGRTHRESHOLDPACKING    14
#define M_EGRTHRESHOLDPACKING    0x3fU
#define V_EGRTHRESHOLDPACKING(x) ((x) << S_EGRTHRESHOLDPACKING)
#define G_EGRTHRESHOLDPACKING(x) (((x) >> S_EGRTHRESHOLDPACKING) & M_EGRTHRESHOLDPACKING)

#define S_T6_EGRTHRESHOLDPACKING    16
#define M_T6_EGRTHRESHOLDPACKING    0xffU
#define V_T6_EGRTHRESHOLDPACKING(x) ((x) << S_T6_EGRTHRESHOLDPACKING)
#define G_T6_EGRTHRESHOLDPACKING(x) (((x) >> S_T6_EGRTHRESHOLDPACKING) & M_T6_EGRTHRESHOLDPACKING)

#define S_T6_EGRTHRESHOLD    8
#define M_T6_EGRTHRESHOLD    0xffU
#define V_T6_EGRTHRESHOLD(x) ((x) << S_T6_EGRTHRESHOLD)
#define G_T6_EGRTHRESHOLD(x) (((x) >> S_T6_EGRTHRESHOLD) & M_T6_EGRTHRESHOLD)

#define A_SGE_TIMESTAMP_LO 0x1098
#define A_SGE_TIMESTAMP_HI 0x109c

#define S_TSOP    28
#define M_TSOP    0x3U
#define V_TSOP(x) ((x) << S_TSOP)
#define G_TSOP(x) (((x) >> S_TSOP) & M_TSOP)

#define S_TSVAL    0
#define M_TSVAL    0xfffffffU
#define V_TSVAL(x) ((x) << S_TSVAL)
#define G_TSVAL(x) (((x) >> S_TSVAL) & M_TSVAL)

#define A_SGE_INGRESS_RX_THRESHOLD 0x10a0

#define S_THRESHOLD_0    24
#define M_THRESHOLD_0    0x3fU
#define V_THRESHOLD_0(x) ((x) << S_THRESHOLD_0)
#define G_THRESHOLD_0(x) (((x) >> S_THRESHOLD_0) & M_THRESHOLD_0)

#define S_THRESHOLD_1    16
#define M_THRESHOLD_1    0x3fU
#define V_THRESHOLD_1(x) ((x) << S_THRESHOLD_1)
#define G_THRESHOLD_1(x) (((x) >> S_THRESHOLD_1) & M_THRESHOLD_1)

#define S_THRESHOLD_2    8
#define M_THRESHOLD_2    0x3fU
#define V_THRESHOLD_2(x) ((x) << S_THRESHOLD_2)
#define G_THRESHOLD_2(x) (((x) >> S_THRESHOLD_2) & M_THRESHOLD_2)

#define S_THRESHOLD_3    0
#define M_THRESHOLD_3    0x3fU
#define V_THRESHOLD_3(x) ((x) << S_THRESHOLD_3)
#define G_THRESHOLD_3(x) (((x) >> S_THRESHOLD_3) & M_THRESHOLD_3)

#define A_SGE_DBFIFO_STATUS 0x10a4

#define S_HP_INT_THRESH    28
#define M_HP_INT_THRESH    0xfU
#define V_HP_INT_THRESH(x) ((x) << S_HP_INT_THRESH)
#define G_HP_INT_THRESH(x) (((x) >> S_HP_INT_THRESH) & M_HP_INT_THRESH)

#define S_HP_COUNT    16
#define M_HP_COUNT    0x7ffU
#define V_HP_COUNT(x) ((x) << S_HP_COUNT)
#define G_HP_COUNT(x) (((x) >> S_HP_COUNT) & M_HP_COUNT)

#define S_LP_INT_THRESH    12
#define M_LP_INT_THRESH    0xfU
#define V_LP_INT_THRESH(x) ((x) << S_LP_INT_THRESH)
#define G_LP_INT_THRESH(x) (((x) >> S_LP_INT_THRESH) & M_LP_INT_THRESH)

#define S_LP_COUNT    0
#define M_LP_COUNT    0x7ffU
#define V_LP_COUNT(x) ((x) << S_LP_COUNT)
#define G_LP_COUNT(x) (((x) >> S_LP_COUNT) & M_LP_COUNT)

#define S_BAR2VALID    31
#define V_BAR2VALID(x) ((x) << S_BAR2VALID)
#define F_BAR2VALID    V_BAR2VALID(1U)

#define S_BAR2FULL    30
#define V_BAR2FULL(x) ((x) << S_BAR2FULL)
#define F_BAR2FULL    V_BAR2FULL(1U)

#define S_LP_INT_THRESH_T5    18
#define M_LP_INT_THRESH_T5    0xfffU
#define V_LP_INT_THRESH_T5(x) ((x) << S_LP_INT_THRESH_T5)
#define G_LP_INT_THRESH_T5(x) (((x) >> S_LP_INT_THRESH_T5) & M_LP_INT_THRESH_T5)

#define S_LP_COUNT_T5    0
#define M_LP_COUNT_T5    0x3ffffU
#define V_LP_COUNT_T5(x) ((x) << S_LP_COUNT_T5)
#define G_LP_COUNT_T5(x) (((x) >> S_LP_COUNT_T5) & M_LP_COUNT_T5)

#define S_VFIFO_CNT    15
#define M_VFIFO_CNT    0x1ffffU
#define V_VFIFO_CNT(x) ((x) << S_VFIFO_CNT)
#define G_VFIFO_CNT(x) (((x) >> S_VFIFO_CNT) & M_VFIFO_CNT)

#define S_COAL_CTL_FIFO_CNT    8
#define M_COAL_CTL_FIFO_CNT    0x3fU
#define V_COAL_CTL_FIFO_CNT(x) ((x) << S_COAL_CTL_FIFO_CNT)
#define G_COAL_CTL_FIFO_CNT(x) (((x) >> S_COAL_CTL_FIFO_CNT) & M_COAL_CTL_FIFO_CNT)

#define S_MERGE_FIFO_CNT    0
#define M_MERGE_FIFO_CNT    0x3fU
#define V_MERGE_FIFO_CNT(x) ((x) << S_MERGE_FIFO_CNT)
#define G_MERGE_FIFO_CNT(x) (((x) >> S_MERGE_FIFO_CNT) & M_MERGE_FIFO_CNT)

#define A_SGE_DOORBELL_CONTROL 0x10a8

#define S_HINTDEPTHCTL    27
#define M_HINTDEPTHCTL    0x1fU
#define V_HINTDEPTHCTL(x) ((x) << S_HINTDEPTHCTL)
#define G_HINTDEPTHCTL(x) (((x) >> S_HINTDEPTHCTL) & M_HINTDEPTHCTL)

#define S_NOCOALESCE    26
#define V_NOCOALESCE(x) ((x) << S_NOCOALESCE)
#define F_NOCOALESCE    V_NOCOALESCE(1U)

#define S_HP_WEIGHT    24
#define M_HP_WEIGHT    0x3U
#define V_HP_WEIGHT(x) ((x) << S_HP_WEIGHT)
#define G_HP_WEIGHT(x) (((x) >> S_HP_WEIGHT) & M_HP_WEIGHT)

#define S_HP_DISABLE    23
#define V_HP_DISABLE(x) ((x) << S_HP_DISABLE)
#define F_HP_DISABLE    V_HP_DISABLE(1U)

#define S_FORCEUSERDBTOLP    22
#define V_FORCEUSERDBTOLP(x) ((x) << S_FORCEUSERDBTOLP)
#define F_FORCEUSERDBTOLP    V_FORCEUSERDBTOLP(1U)

#define S_FORCEVFPF0DBTOLP    21
#define V_FORCEVFPF0DBTOLP(x) ((x) << S_FORCEVFPF0DBTOLP)
#define F_FORCEVFPF0DBTOLP    V_FORCEVFPF0DBTOLP(1U)

#define S_FORCEVFPF1DBTOLP    20
#define V_FORCEVFPF1DBTOLP(x) ((x) << S_FORCEVFPF1DBTOLP)
#define F_FORCEVFPF1DBTOLP    V_FORCEVFPF1DBTOLP(1U)

#define S_FORCEVFPF2DBTOLP    19
#define V_FORCEVFPF2DBTOLP(x) ((x) << S_FORCEVFPF2DBTOLP)
#define F_FORCEVFPF2DBTOLP    V_FORCEVFPF2DBTOLP(1U)

#define S_FORCEVFPF3DBTOLP    18
#define V_FORCEVFPF3DBTOLP(x) ((x) << S_FORCEVFPF3DBTOLP)
#define F_FORCEVFPF3DBTOLP    V_FORCEVFPF3DBTOLP(1U)

#define S_FORCEVFPF4DBTOLP    17
#define V_FORCEVFPF4DBTOLP(x) ((x) << S_FORCEVFPF4DBTOLP)
#define F_FORCEVFPF4DBTOLP    V_FORCEVFPF4DBTOLP(1U)

#define S_FORCEVFPF5DBTOLP    16
#define V_FORCEVFPF5DBTOLP(x) ((x) << S_FORCEVFPF5DBTOLP)
#define F_FORCEVFPF5DBTOLP    V_FORCEVFPF5DBTOLP(1U)

#define S_FORCEVFPF6DBTOLP    15
#define V_FORCEVFPF6DBTOLP(x) ((x) << S_FORCEVFPF6DBTOLP)
#define F_FORCEVFPF6DBTOLP    V_FORCEVFPF6DBTOLP(1U)

#define S_FORCEVFPF7DBTOLP    14
#define V_FORCEVFPF7DBTOLP(x) ((x) << S_FORCEVFPF7DBTOLP)
#define F_FORCEVFPF7DBTOLP    V_FORCEVFPF7DBTOLP(1U)

#define S_ENABLE_DROP    13
#define V_ENABLE_DROP(x) ((x) << S_ENABLE_DROP)
#define F_ENABLE_DROP    V_ENABLE_DROP(1U)

#define S_DROP_TIMEOUT    1
#define M_DROP_TIMEOUT    0xfffU
#define V_DROP_TIMEOUT(x) ((x) << S_DROP_TIMEOUT)
#define G_DROP_TIMEOUT(x) (((x) >> S_DROP_TIMEOUT) & M_DROP_TIMEOUT)

#define S_DROPPED_DB    0
#define V_DROPPED_DB(x) ((x) << S_DROPPED_DB)
#define F_DROPPED_DB    V_DROPPED_DB(1U)

#define S_T6_DROP_TIMEOUT    7
#define M_T6_DROP_TIMEOUT    0x3fU
#define V_T6_DROP_TIMEOUT(x) ((x) << S_T6_DROP_TIMEOUT)
#define G_T6_DROP_TIMEOUT(x) (((x) >> S_T6_DROP_TIMEOUT) & M_T6_DROP_TIMEOUT)

#define S_INVONDBSYNC    6
#define V_INVONDBSYNC(x) ((x) << S_INVONDBSYNC)
#define F_INVONDBSYNC    V_INVONDBSYNC(1U)

#define S_INVONGTSSYNC    5
#define V_INVONGTSSYNC(x) ((x) << S_INVONGTSSYNC)
#define F_INVONGTSSYNC    V_INVONGTSSYNC(1U)

#define S_DB_DBG_EN    4
#define V_DB_DBG_EN(x) ((x) << S_DB_DBG_EN)
#define F_DB_DBG_EN    V_DB_DBG_EN(1U)

#define S_GTS_DBG_TIMER_REG    1
#define M_GTS_DBG_TIMER_REG    0x7U
#define V_GTS_DBG_TIMER_REG(x) ((x) << S_GTS_DBG_TIMER_REG)
#define G_GTS_DBG_TIMER_REG(x) (((x) >> S_GTS_DBG_TIMER_REG) & M_GTS_DBG_TIMER_REG)

#define S_GTS_DBG_EN    0
#define V_GTS_DBG_EN(x) ((x) << S_GTS_DBG_EN)
#define F_GTS_DBG_EN    V_GTS_DBG_EN(1U)

#define A_SGE_DROPPED_DOORBELL 0x10ac
#define A_SGE_DOORBELL_THROTTLE_CONTROL 0x10b0

#define S_THROTTLE_COUNT    1
#define M_THROTTLE_COUNT    0xfffU
#define V_THROTTLE_COUNT(x) ((x) << S_THROTTLE_COUNT)
#define G_THROTTLE_COUNT(x) (((x) >> S_THROTTLE_COUNT) & M_THROTTLE_COUNT)

#define S_THROTTLE_ENABLE    0
#define V_THROTTLE_ENABLE(x) ((x) << S_THROTTLE_ENABLE)
#define F_THROTTLE_ENABLE    V_THROTTLE_ENABLE(1U)

#define S_BAR2THROTTLECOUNT    16
#define M_BAR2THROTTLECOUNT    0xffU
#define V_BAR2THROTTLECOUNT(x) ((x) << S_BAR2THROTTLECOUNT)
#define G_BAR2THROTTLECOUNT(x) (((x) >> S_BAR2THROTTLECOUNT) & M_BAR2THROTTLECOUNT)

#define S_CLRCOALESCEDISABLE    15
#define V_CLRCOALESCEDISABLE(x) ((x) << S_CLRCOALESCEDISABLE)
#define F_CLRCOALESCEDISABLE    V_CLRCOALESCEDISABLE(1U)

#define S_OPENBAR2GATEONCE    14
#define V_OPENBAR2GATEONCE(x) ((x) << S_OPENBAR2GATEONCE)
#define F_OPENBAR2GATEONCE    V_OPENBAR2GATEONCE(1U)

#define S_FORCEOPENBAR2GATE    13
#define V_FORCEOPENBAR2GATE(x) ((x) << S_FORCEOPENBAR2GATE)
#define F_FORCEOPENBAR2GATE    V_FORCEOPENBAR2GATE(1U)

#define A_SGE_ITP_CONTROL 0x10b4

#define S_CRITICAL_TIME    10
#define M_CRITICAL_TIME    0x7fffU
#define V_CRITICAL_TIME(x) ((x) << S_CRITICAL_TIME)
#define G_CRITICAL_TIME(x) (((x) >> S_CRITICAL_TIME) & M_CRITICAL_TIME)

#define S_LL_EMPTY    4
#define M_LL_EMPTY    0x3fU
#define V_LL_EMPTY(x) ((x) << S_LL_EMPTY)
#define G_LL_EMPTY(x) (((x) >> S_LL_EMPTY) & M_LL_EMPTY)

#define S_LL_READ_WAIT_DISABLE    0
#define V_LL_READ_WAIT_DISABLE(x) ((x) << S_LL_READ_WAIT_DISABLE)
#define F_LL_READ_WAIT_DISABLE    V_LL_READ_WAIT_DISABLE(1U)

#define S_TSCALE    28
#define M_TSCALE    0xfU
#define V_TSCALE(x) ((x) << S_TSCALE)
#define G_TSCALE(x) (((x) >> S_TSCALE) & M_TSCALE)

#define A_SGE_TIMER_VALUE_0_AND_1 0x10b8

#define S_TIMERVALUE0    16
#define M_TIMERVALUE0    0xffffU
#define V_TIMERVALUE0(x) ((x) << S_TIMERVALUE0)
#define G_TIMERVALUE0(x) (((x) >> S_TIMERVALUE0) & M_TIMERVALUE0)

#define S_TIMERVALUE1    0
#define M_TIMERVALUE1    0xffffU
#define V_TIMERVALUE1(x) ((x) << S_TIMERVALUE1)
#define G_TIMERVALUE1(x) (((x) >> S_TIMERVALUE1) & M_TIMERVALUE1)

#define A_SGE_TIMER_VALUE_2_AND_3 0x10bc

#define S_TIMERVALUE2    16
#define M_TIMERVALUE2    0xffffU
#define V_TIMERVALUE2(x) ((x) << S_TIMERVALUE2)
#define G_TIMERVALUE2(x) (((x) >> S_TIMERVALUE2) & M_TIMERVALUE2)

#define S_TIMERVALUE3    0
#define M_TIMERVALUE3    0xffffU
#define V_TIMERVALUE3(x) ((x) << S_TIMERVALUE3)
#define G_TIMERVALUE3(x) (((x) >> S_TIMERVALUE3) & M_TIMERVALUE3)

#define A_SGE_TIMER_VALUE_4_AND_5 0x10c0

#define S_TIMERVALUE4    16
#define M_TIMERVALUE4    0xffffU
#define V_TIMERVALUE4(x) ((x) << S_TIMERVALUE4)
#define G_TIMERVALUE4(x) (((x) >> S_TIMERVALUE4) & M_TIMERVALUE4)

#define S_TIMERVALUE5    0
#define M_TIMERVALUE5    0xffffU
#define V_TIMERVALUE5(x) ((x) << S_TIMERVALUE5)
#define G_TIMERVALUE5(x) (((x) >> S_TIMERVALUE5) & M_TIMERVALUE5)

#define A_SGE_PD_RSP_CREDIT01 0x10c4

#define S_RSPCREDITEN0    31
#define V_RSPCREDITEN0(x) ((x) << S_RSPCREDITEN0)
#define F_RSPCREDITEN0    V_RSPCREDITEN0(1U)

#define S_MAXTAG0    24
#define M_MAXTAG0    0x7fU
#define V_MAXTAG0(x) ((x) << S_MAXTAG0)
#define G_MAXTAG0(x) (((x) >> S_MAXTAG0) & M_MAXTAG0)

#define S_MAXRSPCNT0    16
#define M_MAXRSPCNT0    0xffU
#define V_MAXRSPCNT0(x) ((x) << S_MAXRSPCNT0)
#define G_MAXRSPCNT0(x) (((x) >> S_MAXRSPCNT0) & M_MAXRSPCNT0)

#define S_RSPCREDITEN1    15
#define V_RSPCREDITEN1(x) ((x) << S_RSPCREDITEN1)
#define F_RSPCREDITEN1    V_RSPCREDITEN1(1U)

#define S_MAXTAG1    8
#define M_MAXTAG1    0x7fU
#define V_MAXTAG1(x) ((x) << S_MAXTAG1)
#define G_MAXTAG1(x) (((x) >> S_MAXTAG1) & M_MAXTAG1)

#define S_MAXRSPCNT1    0
#define M_MAXRSPCNT1    0xffU
#define V_MAXRSPCNT1(x) ((x) << S_MAXRSPCNT1)
#define G_MAXRSPCNT1(x) (((x) >> S_MAXRSPCNT1) & M_MAXRSPCNT1)

#define A_SGE_GK_CONTROL 0x10c4

#define S_EN_FLM_FIFTH    29
#define V_EN_FLM_FIFTH(x) ((x) << S_EN_FLM_FIFTH)
#define F_EN_FLM_FIFTH    V_EN_FLM_FIFTH(1U)

#define S_FL_PROG_THRESH    20
#define M_FL_PROG_THRESH    0x1ffU
#define V_FL_PROG_THRESH(x) ((x) << S_FL_PROG_THRESH)
#define G_FL_PROG_THRESH(x) (((x) >> S_FL_PROG_THRESH) & M_FL_PROG_THRESH)

#define S_COAL_ALL_THREAD    19
#define V_COAL_ALL_THREAD(x) ((x) << S_COAL_ALL_THREAD)
#define F_COAL_ALL_THREAD    V_COAL_ALL_THREAD(1U)

#define S_EN_PSHB    18
#define V_EN_PSHB(x) ((x) << S_EN_PSHB)
#define F_EN_PSHB    V_EN_PSHB(1U)

#define S_EN_DB_FIFTH    17
#define V_EN_DB_FIFTH(x) ((x) << S_EN_DB_FIFTH)
#define F_EN_DB_FIFTH    V_EN_DB_FIFTH(1U)

#define S_DB_PROG_THRESH    8
#define M_DB_PROG_THRESH    0x1ffU
#define V_DB_PROG_THRESH(x) ((x) << S_DB_PROG_THRESH)
#define G_DB_PROG_THRESH(x) (((x) >> S_DB_PROG_THRESH) & M_DB_PROG_THRESH)

#define S_100NS_TIMER    0
#define M_100NS_TIMER    0xffU
#define V_100NS_TIMER(x) ((x) << S_100NS_TIMER)
#define G_100NS_TIMER(x) (((x) >> S_100NS_TIMER) & M_100NS_TIMER)

#define A_SGE_PD_RSP_CREDIT23 0x10c8

#define S_RSPCREDITEN2    31
#define V_RSPCREDITEN2(x) ((x) << S_RSPCREDITEN2)
#define F_RSPCREDITEN2    V_RSPCREDITEN2(1U)

#define S_MAXTAG2    24
#define M_MAXTAG2    0x7fU
#define V_MAXTAG2(x) ((x) << S_MAXTAG2)
#define G_MAXTAG2(x) (((x) >> S_MAXTAG2) & M_MAXTAG2)

#define S_MAXRSPCNT2    16
#define M_MAXRSPCNT2    0xffU
#define V_MAXRSPCNT2(x) ((x) << S_MAXRSPCNT2)
#define G_MAXRSPCNT2(x) (((x) >> S_MAXRSPCNT2) & M_MAXRSPCNT2)

#define S_RSPCREDITEN3    15
#define V_RSPCREDITEN3(x) ((x) << S_RSPCREDITEN3)
#define F_RSPCREDITEN3    V_RSPCREDITEN3(1U)

#define S_MAXTAG3    8
#define M_MAXTAG3    0x7fU
#define V_MAXTAG3(x) ((x) << S_MAXTAG3)
#define G_MAXTAG3(x) (((x) >> S_MAXTAG3) & M_MAXTAG3)

#define S_MAXRSPCNT3    0
#define M_MAXRSPCNT3    0xffU
#define V_MAXRSPCNT3(x) ((x) << S_MAXRSPCNT3)
#define G_MAXRSPCNT3(x) (((x) >> S_MAXRSPCNT3) & M_MAXRSPCNT3)

#define A_SGE_GK_CONTROL2 0x10c8

#define S_DBQ_TIMER_TICK    16
#define M_DBQ_TIMER_TICK    0xffffU
#define V_DBQ_TIMER_TICK(x) ((x) << S_DBQ_TIMER_TICK)
#define G_DBQ_TIMER_TICK(x) (((x) >> S_DBQ_TIMER_TICK) & M_DBQ_TIMER_TICK)

#define S_FL_MERGE_CNT_THRESH    8
#define M_FL_MERGE_CNT_THRESH    0xfU
#define V_FL_MERGE_CNT_THRESH(x) ((x) << S_FL_MERGE_CNT_THRESH)
#define G_FL_MERGE_CNT_THRESH(x) (((x) >> S_FL_MERGE_CNT_THRESH) & M_FL_MERGE_CNT_THRESH)

#define S_MERGE_CNT_THRESH    0
#define M_MERGE_CNT_THRESH    0x3fU
#define V_MERGE_CNT_THRESH(x) ((x) << S_MERGE_CNT_THRESH)
#define G_MERGE_CNT_THRESH(x) (((x) >> S_MERGE_CNT_THRESH) & M_MERGE_CNT_THRESH)

#define A_SGE_DEBUG_INDEX 0x10cc
#define A_SGE_DEBUG_DATA_HIGH 0x10d0
#define A_SGE_DEBUG_DATA_LOW 0x10d4
#define A_SGE_REVISION 0x10d8
#define A_SGE_INT_CAUSE4 0x10dc

#define S_ERR_BAD_UPFL_INC_CREDIT3    8
#define V_ERR_BAD_UPFL_INC_CREDIT3(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT3)
#define F_ERR_BAD_UPFL_INC_CREDIT3    V_ERR_BAD_UPFL_INC_CREDIT3(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT2    7
#define V_ERR_BAD_UPFL_INC_CREDIT2(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT2)
#define F_ERR_BAD_UPFL_INC_CREDIT2    V_ERR_BAD_UPFL_INC_CREDIT2(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT1    6
#define V_ERR_BAD_UPFL_INC_CREDIT1(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT1)
#define F_ERR_BAD_UPFL_INC_CREDIT1    V_ERR_BAD_UPFL_INC_CREDIT1(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT0    5
#define V_ERR_BAD_UPFL_INC_CREDIT0(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT0)
#define F_ERR_BAD_UPFL_INC_CREDIT0    V_ERR_BAD_UPFL_INC_CREDIT0(1U)

#define S_ERR_PHYSADDR_LEN0_IDMA1    4
#define V_ERR_PHYSADDR_LEN0_IDMA1(x) ((x) << S_ERR_PHYSADDR_LEN0_IDMA1)
#define F_ERR_PHYSADDR_LEN0_IDMA1    V_ERR_PHYSADDR_LEN0_IDMA1(1U)

#define S_ERR_PHYSADDR_LEN0_IDMA0    3
#define V_ERR_PHYSADDR_LEN0_IDMA0(x) ((x) << S_ERR_PHYSADDR_LEN0_IDMA0)
#define F_ERR_PHYSADDR_LEN0_IDMA0    V_ERR_PHYSADDR_LEN0_IDMA0(1U)

#define S_ERR_FLM_INVALID_PKT_DROP1    2
#define V_ERR_FLM_INVALID_PKT_DROP1(x) ((x) << S_ERR_FLM_INVALID_PKT_DROP1)
#define F_ERR_FLM_INVALID_PKT_DROP1    V_ERR_FLM_INVALID_PKT_DROP1(1U)

#define S_ERR_FLM_INVALID_PKT_DROP0    1
#define V_ERR_FLM_INVALID_PKT_DROP0(x) ((x) << S_ERR_FLM_INVALID_PKT_DROP0)
#define F_ERR_FLM_INVALID_PKT_DROP0    V_ERR_FLM_INVALID_PKT_DROP0(1U)

#define S_ERR_UNEXPECTED_TIMER    0
#define V_ERR_UNEXPECTED_TIMER(x) ((x) << S_ERR_UNEXPECTED_TIMER)
#define F_ERR_UNEXPECTED_TIMER    V_ERR_UNEXPECTED_TIMER(1U)

#define S_BAR2_EGRESS_LEN_OR_ADDR_ERR    29
#define V_BAR2_EGRESS_LEN_OR_ADDR_ERR(x) ((x) << S_BAR2_EGRESS_LEN_OR_ADDR_ERR)
#define F_BAR2_EGRESS_LEN_OR_ADDR_ERR    V_BAR2_EGRESS_LEN_OR_ADDR_ERR(1U)

#define S_ERR_CPL_EXCEED_MAX_IQE_SIZE1    28
#define V_ERR_CPL_EXCEED_MAX_IQE_SIZE1(x) ((x) << S_ERR_CPL_EXCEED_MAX_IQE_SIZE1)
#define F_ERR_CPL_EXCEED_MAX_IQE_SIZE1    V_ERR_CPL_EXCEED_MAX_IQE_SIZE1(1U)

#define S_ERR_CPL_EXCEED_MAX_IQE_SIZE0    27
#define V_ERR_CPL_EXCEED_MAX_IQE_SIZE0(x) ((x) << S_ERR_CPL_EXCEED_MAX_IQE_SIZE0)
#define F_ERR_CPL_EXCEED_MAX_IQE_SIZE0    V_ERR_CPL_EXCEED_MAX_IQE_SIZE0(1U)

#define S_ERR_WR_LEN_TOO_LARGE3    26
#define V_ERR_WR_LEN_TOO_LARGE3(x) ((x) << S_ERR_WR_LEN_TOO_LARGE3)
#define F_ERR_WR_LEN_TOO_LARGE3    V_ERR_WR_LEN_TOO_LARGE3(1U)

#define S_ERR_WR_LEN_TOO_LARGE2    25
#define V_ERR_WR_LEN_TOO_LARGE2(x) ((x) << S_ERR_WR_LEN_TOO_LARGE2)
#define F_ERR_WR_LEN_TOO_LARGE2    V_ERR_WR_LEN_TOO_LARGE2(1U)

#define S_ERR_WR_LEN_TOO_LARGE1    24
#define V_ERR_WR_LEN_TOO_LARGE1(x) ((x) << S_ERR_WR_LEN_TOO_LARGE1)
#define F_ERR_WR_LEN_TOO_LARGE1    V_ERR_WR_LEN_TOO_LARGE1(1U)

#define S_ERR_WR_LEN_TOO_LARGE0    23
#define V_ERR_WR_LEN_TOO_LARGE0(x) ((x) << S_ERR_WR_LEN_TOO_LARGE0)
#define F_ERR_WR_LEN_TOO_LARGE0    V_ERR_WR_LEN_TOO_LARGE0(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL3    22
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL3(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL3)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL3    V_ERR_LARGE_MINFETCH_WITH_TXCOAL3(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL2    21
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL2(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL2)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL2    V_ERR_LARGE_MINFETCH_WITH_TXCOAL2(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL1    20
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL1(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL1)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL1    V_ERR_LARGE_MINFETCH_WITH_TXCOAL1(1U)

#define S_ERR_LARGE_MINFETCH_WITH_TXCOAL0    19
#define V_ERR_LARGE_MINFETCH_WITH_TXCOAL0(x) ((x) << S_ERR_LARGE_MINFETCH_WITH_TXCOAL0)
#define F_ERR_LARGE_MINFETCH_WITH_TXCOAL0    V_ERR_LARGE_MINFETCH_WITH_TXCOAL0(1U)

#define S_COAL_WITH_HP_DISABLE_ERR    18
#define V_COAL_WITH_HP_DISABLE_ERR(x) ((x) << S_COAL_WITH_HP_DISABLE_ERR)
#define F_COAL_WITH_HP_DISABLE_ERR    V_COAL_WITH_HP_DISABLE_ERR(1U)

#define S_BAR2_EGRESS_COAL0_ERR    17
#define V_BAR2_EGRESS_COAL0_ERR(x) ((x) << S_BAR2_EGRESS_COAL0_ERR)
#define F_BAR2_EGRESS_COAL0_ERR    V_BAR2_EGRESS_COAL0_ERR(1U)

#define S_BAR2_EGRESS_SIZE_ERR    16
#define V_BAR2_EGRESS_SIZE_ERR(x) ((x) << S_BAR2_EGRESS_SIZE_ERR)
#define F_BAR2_EGRESS_SIZE_ERR    V_BAR2_EGRESS_SIZE_ERR(1U)

#define S_FLM_PC_RSP_ERR    15
#define V_FLM_PC_RSP_ERR(x) ((x) << S_FLM_PC_RSP_ERR)
#define F_FLM_PC_RSP_ERR    V_FLM_PC_RSP_ERR(1U)

#define S_DBFIFO_HP_INT_LOW    14
#define V_DBFIFO_HP_INT_LOW(x) ((x) << S_DBFIFO_HP_INT_LOW)
#define F_DBFIFO_HP_INT_LOW    V_DBFIFO_HP_INT_LOW(1U)

#define S_DBFIFO_LP_INT_LOW    13
#define V_DBFIFO_LP_INT_LOW(x) ((x) << S_DBFIFO_LP_INT_LOW)
#define F_DBFIFO_LP_INT_LOW    V_DBFIFO_LP_INT_LOW(1U)

#define S_DBFIFO_FL_INT_LOW    12
#define V_DBFIFO_FL_INT_LOW(x) ((x) << S_DBFIFO_FL_INT_LOW)
#define F_DBFIFO_FL_INT_LOW    V_DBFIFO_FL_INT_LOW(1U)

#define S_DBFIFO_FL_INT    11
#define V_DBFIFO_FL_INT(x) ((x) << S_DBFIFO_FL_INT)
#define F_DBFIFO_FL_INT    V_DBFIFO_FL_INT(1U)

#define S_ERR_RX_CPL_PACKET_SIZE1    10
#define V_ERR_RX_CPL_PACKET_SIZE1(x) ((x) << S_ERR_RX_CPL_PACKET_SIZE1)
#define F_ERR_RX_CPL_PACKET_SIZE1    V_ERR_RX_CPL_PACKET_SIZE1(1U)

#define S_ERR_RX_CPL_PACKET_SIZE0    9
#define V_ERR_RX_CPL_PACKET_SIZE0(x) ((x) << S_ERR_RX_CPL_PACKET_SIZE0)
#define F_ERR_RX_CPL_PACKET_SIZE0    V_ERR_RX_CPL_PACKET_SIZE0(1U)

#define S_ERR_ISHIFT_UR1    31
#define V_ERR_ISHIFT_UR1(x) ((x) << S_ERR_ISHIFT_UR1)
#define F_ERR_ISHIFT_UR1    V_ERR_ISHIFT_UR1(1U)

#define S_ERR_ISHIFT_UR0    30
#define V_ERR_ISHIFT_UR0(x) ((x) << S_ERR_ISHIFT_UR0)
#define F_ERR_ISHIFT_UR0    V_ERR_ISHIFT_UR0(1U)

#define S_ERR_TH3_MAX_FETCH    14
#define V_ERR_TH3_MAX_FETCH(x) ((x) << S_ERR_TH3_MAX_FETCH)
#define F_ERR_TH3_MAX_FETCH    V_ERR_TH3_MAX_FETCH(1U)

#define S_ERR_TH2_MAX_FETCH    13
#define V_ERR_TH2_MAX_FETCH(x) ((x) << S_ERR_TH2_MAX_FETCH)
#define F_ERR_TH2_MAX_FETCH    V_ERR_TH2_MAX_FETCH(1U)

#define S_ERR_TH1_MAX_FETCH    12
#define V_ERR_TH1_MAX_FETCH(x) ((x) << S_ERR_TH1_MAX_FETCH)
#define F_ERR_TH1_MAX_FETCH    V_ERR_TH1_MAX_FETCH(1U)

#define S_ERR_TH0_MAX_FETCH    11
#define V_ERR_TH0_MAX_FETCH(x) ((x) << S_ERR_TH0_MAX_FETCH)
#define F_ERR_TH0_MAX_FETCH    V_ERR_TH0_MAX_FETCH(1U)

#define A_SGE_INT_ENABLE4 0x10e0
#define A_SGE_STAT_TOTAL 0x10e4
#define A_SGE_STAT_MATCH 0x10e8
#define A_SGE_STAT_CFG 0x10ec

#define S_ITPOPMODE    8
#define V_ITPOPMODE(x) ((x) << S_ITPOPMODE)
#define F_ITPOPMODE    V_ITPOPMODE(1U)

#define S_EGRCTXTOPMODE    6
#define M_EGRCTXTOPMODE    0x3U
#define V_EGRCTXTOPMODE(x) ((x) << S_EGRCTXTOPMODE)
#define G_EGRCTXTOPMODE(x) (((x) >> S_EGRCTXTOPMODE) & M_EGRCTXTOPMODE)

#define S_INGCTXTOPMODE    4
#define M_INGCTXTOPMODE    0x3U
#define V_INGCTXTOPMODE(x) ((x) << S_INGCTXTOPMODE)
#define G_INGCTXTOPMODE(x) (((x) >> S_INGCTXTOPMODE) & M_INGCTXTOPMODE)

#define S_STATMODE    2
#define M_STATMODE    0x3U
#define V_STATMODE(x) ((x) << S_STATMODE)
#define G_STATMODE(x) (((x) >> S_STATMODE) & M_STATMODE)

#define S_STATSOURCE    0
#define M_STATSOURCE    0x3U
#define V_STATSOURCE(x) ((x) << S_STATSOURCE)
#define G_STATSOURCE(x) (((x) >> S_STATSOURCE) & M_STATSOURCE)

#define S_STATSOURCE_T5    9
#define M_STATSOURCE_T5    0xfU
#define V_STATSOURCE_T5(x) ((x) << S_STATSOURCE_T5)
#define G_STATSOURCE_T5(x) (((x) >> S_STATSOURCE_T5) & M_STATSOURCE_T5)

#define S_T6_STATMODE    0
#define M_T6_STATMODE    0xfU
#define V_T6_STATMODE(x) ((x) << S_T6_STATMODE)
#define G_T6_STATMODE(x) (((x) >> S_T6_STATMODE) & M_T6_STATMODE)

#define A_SGE_HINT_CFG 0x10f0

#define S_HINTSALLOWEDNOHDR    6
#define M_HINTSALLOWEDNOHDR    0x3fU
#define V_HINTSALLOWEDNOHDR(x) ((x) << S_HINTSALLOWEDNOHDR)
#define G_HINTSALLOWEDNOHDR(x) (((x) >> S_HINTSALLOWEDNOHDR) & M_HINTSALLOWEDNOHDR)

#define S_HINTSALLOWEDHDR    0
#define M_HINTSALLOWEDHDR    0x3fU
#define V_HINTSALLOWEDHDR(x) ((x) << S_HINTSALLOWEDHDR)
#define G_HINTSALLOWEDHDR(x) (((x) >> S_HINTSALLOWEDHDR) & M_HINTSALLOWEDHDR)

#define S_UPCUTOFFTHRESHLP    12
#define M_UPCUTOFFTHRESHLP    0x7ffU
#define V_UPCUTOFFTHRESHLP(x) ((x) << S_UPCUTOFFTHRESHLP)
#define G_UPCUTOFFTHRESHLP(x) (((x) >> S_UPCUTOFFTHRESHLP) & M_UPCUTOFFTHRESHLP)

#define A_SGE_INGRESS_QUEUES_PER_PAGE_PF 0x10f4
#define A_SGE_INGRESS_QUEUES_PER_PAGE_VF 0x10f8
#define A_SGE_PD_WRR_CONFIG 0x10fc

#define S_EDMA_WEIGHT    0
#define M_EDMA_WEIGHT    0x3fU
#define V_EDMA_WEIGHT(x) ((x) << S_EDMA_WEIGHT)
#define G_EDMA_WEIGHT(x) (((x) >> S_EDMA_WEIGHT) & M_EDMA_WEIGHT)

#define A_SGE_ERROR_STATS 0x1100

#define S_UNCAPTURED_ERROR    18
#define V_UNCAPTURED_ERROR(x) ((x) << S_UNCAPTURED_ERROR)
#define F_UNCAPTURED_ERROR    V_UNCAPTURED_ERROR(1U)

#define S_ERROR_QID_VALID    17
#define V_ERROR_QID_VALID(x) ((x) << S_ERROR_QID_VALID)
#define F_ERROR_QID_VALID    V_ERROR_QID_VALID(1U)

#define S_ERROR_QID    0
#define M_ERROR_QID    0x1ffffU
#define V_ERROR_QID(x) ((x) << S_ERROR_QID)
#define G_ERROR_QID(x) (((x) >> S_ERROR_QID) & M_ERROR_QID)

#define S_CAUSE_REGISTER    24
#define M_CAUSE_REGISTER    0x7U
#define V_CAUSE_REGISTER(x) ((x) << S_CAUSE_REGISTER)
#define G_CAUSE_REGISTER(x) (((x) >> S_CAUSE_REGISTER) & M_CAUSE_REGISTER)

#define S_CAUSE_BIT    19
#define M_CAUSE_BIT    0x1fU
#define V_CAUSE_BIT(x) ((x) << S_CAUSE_BIT)
#define G_CAUSE_BIT(x) (((x) >> S_CAUSE_BIT) & M_CAUSE_BIT)

#define A_SGE_SHARED_TAG_CHAN_CFG 0x1104

#define S_MINTAG3    24
#define M_MINTAG3    0xffU
#define V_MINTAG3(x) ((x) << S_MINTAG3)
#define G_MINTAG3(x) (((x) >> S_MINTAG3) & M_MINTAG3)

#define S_MINTAG2    16
#define M_MINTAG2    0xffU
#define V_MINTAG2(x) ((x) << S_MINTAG2)
#define G_MINTAG2(x) (((x) >> S_MINTAG2) & M_MINTAG2)

#define S_MINTAG1    8
#define M_MINTAG1    0xffU
#define V_MINTAG1(x) ((x) << S_MINTAG1)
#define G_MINTAG1(x) (((x) >> S_MINTAG1) & M_MINTAG1)

#define S_MINTAG0    0
#define M_MINTAG0    0xffU
#define V_MINTAG0(x) ((x) << S_MINTAG0)
#define G_MINTAG0(x) (((x) >> S_MINTAG0) & M_MINTAG0)

#define A_SGE_IDMA0_DROP_CNT 0x1104
#define A_SGE_SHARED_TAG_POOL_CFG 0x1108

#define S_TAGPOOLTOTAL    0
#define M_TAGPOOLTOTAL    0xffU
#define V_TAGPOOLTOTAL(x) ((x) << S_TAGPOOLTOTAL)
#define G_TAGPOOLTOTAL(x) (((x) >> S_TAGPOOLTOTAL) & M_TAGPOOLTOTAL)

#define A_SGE_IDMA1_DROP_CNT 0x1108
#define A_SGE_INT_CAUSE5 0x110c

#define S_ERR_T_RXCRC    31
#define V_ERR_T_RXCRC(x) ((x) << S_ERR_T_RXCRC)
#define F_ERR_T_RXCRC    V_ERR_T_RXCRC(1U)

#define S_PERR_MC_RSPDATA    30
#define V_PERR_MC_RSPDATA(x) ((x) << S_PERR_MC_RSPDATA)
#define F_PERR_MC_RSPDATA    V_PERR_MC_RSPDATA(1U)

#define S_PERR_PC_RSPDATA    29
#define V_PERR_PC_RSPDATA(x) ((x) << S_PERR_PC_RSPDATA)
#define F_PERR_PC_RSPDATA    V_PERR_PC_RSPDATA(1U)

#define S_PERR_PD_RDRSPDATA    28
#define V_PERR_PD_RDRSPDATA(x) ((x) << S_PERR_PD_RDRSPDATA)
#define F_PERR_PD_RDRSPDATA    V_PERR_PD_RDRSPDATA(1U)

#define S_PERR_U_RXDATA    27
#define V_PERR_U_RXDATA(x) ((x) << S_PERR_U_RXDATA)
#define F_PERR_U_RXDATA    V_PERR_U_RXDATA(1U)

#define S_PERR_UD_RXDATA    26
#define V_PERR_UD_RXDATA(x) ((x) << S_PERR_UD_RXDATA)
#define F_PERR_UD_RXDATA    V_PERR_UD_RXDATA(1U)

#define S_PERR_UP_DATA    25
#define V_PERR_UP_DATA(x) ((x) << S_PERR_UP_DATA)
#define F_PERR_UP_DATA    V_PERR_UP_DATA(1U)

#define S_PERR_CIM2SGE_RXDATA    24
#define V_PERR_CIM2SGE_RXDATA(x) ((x) << S_PERR_CIM2SGE_RXDATA)
#define F_PERR_CIM2SGE_RXDATA    V_PERR_CIM2SGE_RXDATA(1U)

#define S_PERR_HINT_DELAY_FIFO1_T5    23
#define V_PERR_HINT_DELAY_FIFO1_T5(x) ((x) << S_PERR_HINT_DELAY_FIFO1_T5)
#define F_PERR_HINT_DELAY_FIFO1_T5    V_PERR_HINT_DELAY_FIFO1_T5(1U)

#define S_PERR_HINT_DELAY_FIFO0_T5    22
#define V_PERR_HINT_DELAY_FIFO0_T5(x) ((x) << S_PERR_HINT_DELAY_FIFO0_T5)
#define F_PERR_HINT_DELAY_FIFO0_T5    V_PERR_HINT_DELAY_FIFO0_T5(1U)

#define S_PERR_IMSG_PD_FIFO_T5    21
#define V_PERR_IMSG_PD_FIFO_T5(x) ((x) << S_PERR_IMSG_PD_FIFO_T5)
#define F_PERR_IMSG_PD_FIFO_T5    V_PERR_IMSG_PD_FIFO_T5(1U)

#define S_PERR_ULPTX_FIFO1_T5    20
#define V_PERR_ULPTX_FIFO1_T5(x) ((x) << S_PERR_ULPTX_FIFO1_T5)
#define F_PERR_ULPTX_FIFO1_T5    V_PERR_ULPTX_FIFO1_T5(1U)

#define S_PERR_ULPTX_FIFO0_T5    19
#define V_PERR_ULPTX_FIFO0_T5(x) ((x) << S_PERR_ULPTX_FIFO0_T5)
#define F_PERR_ULPTX_FIFO0_T5    V_PERR_ULPTX_FIFO0_T5(1U)

#define S_PERR_IDMA2IMSG_FIFO1_T5    18
#define V_PERR_IDMA2IMSG_FIFO1_T5(x) ((x) << S_PERR_IDMA2IMSG_FIFO1_T5)
#define F_PERR_IDMA2IMSG_FIFO1_T5    V_PERR_IDMA2IMSG_FIFO1_T5(1U)

#define S_PERR_IDMA2IMSG_FIFO0_T5    17
#define V_PERR_IDMA2IMSG_FIFO0_T5(x) ((x) << S_PERR_IDMA2IMSG_FIFO0_T5)
#define F_PERR_IDMA2IMSG_FIFO0_T5    V_PERR_IDMA2IMSG_FIFO0_T5(1U)

#define S_PERR_POINTER_DATA_FIFO0    16
#define V_PERR_POINTER_DATA_FIFO0(x) ((x) << S_PERR_POINTER_DATA_FIFO0)
#define F_PERR_POINTER_DATA_FIFO0    V_PERR_POINTER_DATA_FIFO0(1U)

#define S_PERR_POINTER_DATA_FIFO1    15
#define V_PERR_POINTER_DATA_FIFO1(x) ((x) << S_PERR_POINTER_DATA_FIFO1)
#define F_PERR_POINTER_DATA_FIFO1    V_PERR_POINTER_DATA_FIFO1(1U)

#define S_PERR_POINTER_HDR_FIFO0    14
#define V_PERR_POINTER_HDR_FIFO0(x) ((x) << S_PERR_POINTER_HDR_FIFO0)
#define F_PERR_POINTER_HDR_FIFO0    V_PERR_POINTER_HDR_FIFO0(1U)

#define S_PERR_POINTER_HDR_FIFO1    13
#define V_PERR_POINTER_HDR_FIFO1(x) ((x) << S_PERR_POINTER_HDR_FIFO1)
#define F_PERR_POINTER_HDR_FIFO1    V_PERR_POINTER_HDR_FIFO1(1U)

#define S_PERR_PAYLOAD_FIFO0    12
#define V_PERR_PAYLOAD_FIFO0(x) ((x) << S_PERR_PAYLOAD_FIFO0)
#define F_PERR_PAYLOAD_FIFO0    V_PERR_PAYLOAD_FIFO0(1U)

#define S_PERR_PAYLOAD_FIFO1    11
#define V_PERR_PAYLOAD_FIFO1(x) ((x) << S_PERR_PAYLOAD_FIFO1)
#define F_PERR_PAYLOAD_FIFO1    V_PERR_PAYLOAD_FIFO1(1U)

#define S_PERR_EDMA_INPUT_FIFO3    10
#define V_PERR_EDMA_INPUT_FIFO3(x) ((x) << S_PERR_EDMA_INPUT_FIFO3)
#define F_PERR_EDMA_INPUT_FIFO3    V_PERR_EDMA_INPUT_FIFO3(1U)

#define S_PERR_EDMA_INPUT_FIFO2    9
#define V_PERR_EDMA_INPUT_FIFO2(x) ((x) << S_PERR_EDMA_INPUT_FIFO2)
#define F_PERR_EDMA_INPUT_FIFO2    V_PERR_EDMA_INPUT_FIFO2(1U)

#define S_PERR_EDMA_INPUT_FIFO1    8
#define V_PERR_EDMA_INPUT_FIFO1(x) ((x) << S_PERR_EDMA_INPUT_FIFO1)
#define F_PERR_EDMA_INPUT_FIFO1    V_PERR_EDMA_INPUT_FIFO1(1U)

#define S_PERR_EDMA_INPUT_FIFO0    7
#define V_PERR_EDMA_INPUT_FIFO0(x) ((x) << S_PERR_EDMA_INPUT_FIFO0)
#define F_PERR_EDMA_INPUT_FIFO0    V_PERR_EDMA_INPUT_FIFO0(1U)

#define S_PERR_MGT_BAR2_FIFO    6
#define V_PERR_MGT_BAR2_FIFO(x) ((x) << S_PERR_MGT_BAR2_FIFO)
#define F_PERR_MGT_BAR2_FIFO    V_PERR_MGT_BAR2_FIFO(1U)

#define S_PERR_HEADERSPLIT_FIFO1_T5    5
#define V_PERR_HEADERSPLIT_FIFO1_T5(x) ((x) << S_PERR_HEADERSPLIT_FIFO1_T5)
#define F_PERR_HEADERSPLIT_FIFO1_T5    V_PERR_HEADERSPLIT_FIFO1_T5(1U)

#define S_PERR_HEADERSPLIT_FIFO0_T5    4
#define V_PERR_HEADERSPLIT_FIFO0_T5(x) ((x) << S_PERR_HEADERSPLIT_FIFO0_T5)
#define F_PERR_HEADERSPLIT_FIFO0_T5    V_PERR_HEADERSPLIT_FIFO0_T5(1U)

#define S_PERR_CIM_FIFO1    3
#define V_PERR_CIM_FIFO1(x) ((x) << S_PERR_CIM_FIFO1)
#define F_PERR_CIM_FIFO1    V_PERR_CIM_FIFO1(1U)

#define S_PERR_CIM_FIFO0    2
#define V_PERR_CIM_FIFO0(x) ((x) << S_PERR_CIM_FIFO0)
#define F_PERR_CIM_FIFO0    V_PERR_CIM_FIFO0(1U)

#define S_PERR_IDMA_SWITCH_OUTPUT_FIFO1    1
#define V_PERR_IDMA_SWITCH_OUTPUT_FIFO1(x) ((x) << S_PERR_IDMA_SWITCH_OUTPUT_FIFO1)
#define F_PERR_IDMA_SWITCH_OUTPUT_FIFO1    V_PERR_IDMA_SWITCH_OUTPUT_FIFO1(1U)

#define S_PERR_IDMA_SWITCH_OUTPUT_FIFO0    0
#define V_PERR_IDMA_SWITCH_OUTPUT_FIFO0(x) ((x) << S_PERR_IDMA_SWITCH_OUTPUT_FIFO0)
#define F_PERR_IDMA_SWITCH_OUTPUT_FIFO0    V_PERR_IDMA_SWITCH_OUTPUT_FIFO0(1U)

#define S_PERR_POINTER_HDR_FIFO3    10
#define V_PERR_POINTER_HDR_FIFO3(x) ((x) << S_PERR_POINTER_HDR_FIFO3)
#define F_PERR_POINTER_HDR_FIFO3    V_PERR_POINTER_HDR_FIFO3(1U)

#define S_PERR_POINTER_HDR_FIFO2    9
#define V_PERR_POINTER_HDR_FIFO2(x) ((x) << S_PERR_POINTER_HDR_FIFO2)
#define F_PERR_POINTER_HDR_FIFO2    V_PERR_POINTER_HDR_FIFO2(1U)

#define S_PERR_POINTER_DATA_FIFO3    8
#define V_PERR_POINTER_DATA_FIFO3(x) ((x) << S_PERR_POINTER_DATA_FIFO3)
#define F_PERR_POINTER_DATA_FIFO3    V_PERR_POINTER_DATA_FIFO3(1U)

#define S_PERR_POINTER_DATA_FIFO2    7
#define V_PERR_POINTER_DATA_FIFO2(x) ((x) << S_PERR_POINTER_DATA_FIFO2)
#define F_PERR_POINTER_DATA_FIFO2    V_PERR_POINTER_DATA_FIFO2(1U)

#define S_PERR_IDMA2IMSG_FIFO3    3
#define V_PERR_IDMA2IMSG_FIFO3(x) ((x) << S_PERR_IDMA2IMSG_FIFO3)
#define F_PERR_IDMA2IMSG_FIFO3    V_PERR_IDMA2IMSG_FIFO3(1U)

#define S_PERR_IDMA2IMSG_FIFO2    2
#define V_PERR_IDMA2IMSG_FIFO2(x) ((x) << S_PERR_IDMA2IMSG_FIFO2)
#define F_PERR_IDMA2IMSG_FIFO2    V_PERR_IDMA2IMSG_FIFO2(1U)

#define S_PERR_HINT_DELAY_FIFO    0
#define V_PERR_HINT_DELAY_FIFO(x) ((x) << S_PERR_HINT_DELAY_FIFO)
#define F_PERR_HINT_DELAY_FIFO    V_PERR_HINT_DELAY_FIFO(1U)

#define A_SGE_INT_ENABLE5 0x1110
#define A_SGE_PERR_ENABLE5 0x1114
#define A_SGE_DBFIFO_STATUS2 0x1118

#define S_FL_INT_THRESH    24
#define M_FL_INT_THRESH    0xfU
#define V_FL_INT_THRESH(x) ((x) << S_FL_INT_THRESH)
#define G_FL_INT_THRESH(x) (((x) >> S_FL_INT_THRESH) & M_FL_INT_THRESH)

#define S_FL_COUNT    14
#define M_FL_COUNT    0x3ffU
#define V_FL_COUNT(x) ((x) << S_FL_COUNT)
#define G_FL_COUNT(x) (((x) >> S_FL_COUNT) & M_FL_COUNT)

#define S_HP_INT_THRESH_T5    10
#define M_HP_INT_THRESH_T5    0xfU
#define V_HP_INT_THRESH_T5(x) ((x) << S_HP_INT_THRESH_T5)
#define G_HP_INT_THRESH_T5(x) (((x) >> S_HP_INT_THRESH_T5) & M_HP_INT_THRESH_T5)

#define S_HP_COUNT_T5    0
#define M_HP_COUNT_T5    0x3ffU
#define V_HP_COUNT_T5(x) ((x) << S_HP_COUNT_T5)
#define G_HP_COUNT_T5(x) (((x) >> S_HP_COUNT_T5) & M_HP_COUNT_T5)

#define A_SGE_FETCH_BURST_MAX_0_AND_1 0x111c

#define S_FETCHBURSTMAX0    16
#define M_FETCHBURSTMAX0    0x3ffU
#define V_FETCHBURSTMAX0(x) ((x) << S_FETCHBURSTMAX0)
#define G_FETCHBURSTMAX0(x) (((x) >> S_FETCHBURSTMAX0) & M_FETCHBURSTMAX0)

#define S_FETCHBURSTMAX1    0
#define M_FETCHBURSTMAX1    0x3ffU
#define V_FETCHBURSTMAX1(x) ((x) << S_FETCHBURSTMAX1)
#define G_FETCHBURSTMAX1(x) (((x) >> S_FETCHBURSTMAX1) & M_FETCHBURSTMAX1)

#define A_SGE_FETCH_BURST_MAX_2_AND_3 0x1120

#define S_FETCHBURSTMAX2    16
#define M_FETCHBURSTMAX2    0x3ffU
#define V_FETCHBURSTMAX2(x) ((x) << S_FETCHBURSTMAX2)
#define G_FETCHBURSTMAX2(x) (((x) >> S_FETCHBURSTMAX2) & M_FETCHBURSTMAX2)

#define S_FETCHBURSTMAX3    0
#define M_FETCHBURSTMAX3    0x3ffU
#define V_FETCHBURSTMAX3(x) ((x) << S_FETCHBURSTMAX3)
#define G_FETCHBURSTMAX3(x) (((x) >> S_FETCHBURSTMAX3) & M_FETCHBURSTMAX3)

#define A_SGE_CONTROL2 0x1124

#define S_UPFLCUTOFFDIS    21
#define V_UPFLCUTOFFDIS(x) ((x) << S_UPFLCUTOFFDIS)
#define F_UPFLCUTOFFDIS    V_UPFLCUTOFFDIS(1U)

#define S_RXCPLSIZEAUTOCORRECT    20
#define V_RXCPLSIZEAUTOCORRECT(x) ((x) << S_RXCPLSIZEAUTOCORRECT)
#define F_RXCPLSIZEAUTOCORRECT    V_RXCPLSIZEAUTOCORRECT(1U)

#define S_IDMAARBROUNDROBIN    19
#define V_IDMAARBROUNDROBIN(x) ((x) << S_IDMAARBROUNDROBIN)
#define F_IDMAARBROUNDROBIN    V_IDMAARBROUNDROBIN(1U)

#define S_INGPACKBOUNDARY    16
#define M_INGPACKBOUNDARY    0x7U
#define V_INGPACKBOUNDARY(x) ((x) << S_INGPACKBOUNDARY)
#define G_INGPACKBOUNDARY(x) (((x) >> S_INGPACKBOUNDARY) & M_INGPACKBOUNDARY)

#define S_CGEN_EGRESS_CONTEXT    15
#define V_CGEN_EGRESS_CONTEXT(x) ((x) << S_CGEN_EGRESS_CONTEXT)
#define F_CGEN_EGRESS_CONTEXT    V_CGEN_EGRESS_CONTEXT(1U)

#define S_CGEN_INGRESS_CONTEXT    14
#define V_CGEN_INGRESS_CONTEXT(x) ((x) << S_CGEN_INGRESS_CONTEXT)
#define F_CGEN_INGRESS_CONTEXT    V_CGEN_INGRESS_CONTEXT(1U)

#define S_CGEN_IDMA    13
#define V_CGEN_IDMA(x) ((x) << S_CGEN_IDMA)
#define F_CGEN_IDMA    V_CGEN_IDMA(1U)

#define S_CGEN_DBP    12
#define V_CGEN_DBP(x) ((x) << S_CGEN_DBP)
#define F_CGEN_DBP    V_CGEN_DBP(1U)

#define S_CGEN_EDMA    11
#define V_CGEN_EDMA(x) ((x) << S_CGEN_EDMA)
#define F_CGEN_EDMA    V_CGEN_EDMA(1U)

#define S_VFIFO_ENABLE    10
#define V_VFIFO_ENABLE(x) ((x) << S_VFIFO_ENABLE)
#define F_VFIFO_ENABLE    V_VFIFO_ENABLE(1U)

#define S_FLM_RESCHEDULE_MODE    9
#define V_FLM_RESCHEDULE_MODE(x) ((x) << S_FLM_RESCHEDULE_MODE)
#define F_FLM_RESCHEDULE_MODE    V_FLM_RESCHEDULE_MODE(1U)

#define S_HINTDEPTHCTLFL    4
#define M_HINTDEPTHCTLFL    0x1fU
#define V_HINTDEPTHCTLFL(x) ((x) << S_HINTDEPTHCTLFL)
#define G_HINTDEPTHCTLFL(x) (((x) >> S_HINTDEPTHCTLFL) & M_HINTDEPTHCTLFL)

#define S_FORCE_ORDERING    3
#define V_FORCE_ORDERING(x) ((x) << S_FORCE_ORDERING)
#define F_FORCE_ORDERING    V_FORCE_ORDERING(1U)

#define S_TX_COALESCE_SIZE    2
#define V_TX_COALESCE_SIZE(x) ((x) << S_TX_COALESCE_SIZE)
#define F_TX_COALESCE_SIZE    V_TX_COALESCE_SIZE(1U)

#define S_COAL_STRICT_CIM_PRI    1
#define V_COAL_STRICT_CIM_PRI(x) ((x) << S_COAL_STRICT_CIM_PRI)
#define F_COAL_STRICT_CIM_PRI    V_COAL_STRICT_CIM_PRI(1U)

#define S_TX_COALESCE_PRI    0
#define V_TX_COALESCE_PRI(x) ((x) << S_TX_COALESCE_PRI)
#define F_TX_COALESCE_PRI    V_TX_COALESCE_PRI(1U)

#define S_HINT_SGE_SEL    31
#define V_HINT_SGE_SEL(x) ((x) << S_HINT_SGE_SEL)
#define F_HINT_SGE_SEL    V_HINT_SGE_SEL(1U)

#define S_HINT_SEL    30
#define V_HINT_SEL(x) ((x) << S_HINT_SEL)
#define F_HINT_SEL    V_HINT_SEL(1U)

#define S_HINT_DISABLE    29
#define V_HINT_DISABLE(x) ((x) << S_HINT_DISABLE)
#define F_HINT_DISABLE    V_HINT_DISABLE(1U)

#define S_RXCPLMODE_ISCSI    28
#define V_RXCPLMODE_ISCSI(x) ((x) << S_RXCPLMODE_ISCSI)
#define F_RXCPLMODE_ISCSI    V_RXCPLMODE_ISCSI(1U)

#define S_RXCPLMODE_NVMT    27
#define V_RXCPLMODE_NVMT(x) ((x) << S_RXCPLMODE_NVMT)
#define F_RXCPLMODE_NVMT    V_RXCPLMODE_NVMT(1U)

#define S_WRE_REPLAY_INORDER    26
#define V_WRE_REPLAY_INORDER(x) ((x) << S_WRE_REPLAY_INORDER)
#define F_WRE_REPLAY_INORDER    V_WRE_REPLAY_INORDER(1U)

#define S_ETH2XEN    25
#define V_ETH2XEN(x) ((x) << S_ETH2XEN)
#define F_ETH2XEN    V_ETH2XEN(1U)

#define S_ARMDBENDDIS    24
#define V_ARMDBENDDIS(x) ((x) << S_ARMDBENDDIS)
#define F_ARMDBENDDIS    V_ARMDBENDDIS(1U)

#define S_PACKPADT7    23
#define V_PACKPADT7(x) ((x) << S_PACKPADT7)
#define F_PACKPADT7    V_PACKPADT7(1U)

#define S_WRE_UPFLCREDIT    22
#define V_WRE_UPFLCREDIT(x) ((x) << S_WRE_UPFLCREDIT)
#define F_WRE_UPFLCREDIT    V_WRE_UPFLCREDIT(1U)

#define A_SGE_DEEP_SLEEP 0x1128

#define S_IDMA1_SLEEP_STATUS    11
#define V_IDMA1_SLEEP_STATUS(x) ((x) << S_IDMA1_SLEEP_STATUS)
#define F_IDMA1_SLEEP_STATUS    V_IDMA1_SLEEP_STATUS(1U)

#define S_IDMA0_SLEEP_STATUS    10
#define V_IDMA0_SLEEP_STATUS(x) ((x) << S_IDMA0_SLEEP_STATUS)
#define F_IDMA0_SLEEP_STATUS    V_IDMA0_SLEEP_STATUS(1U)

#define S_IDMA1_SLEEP_REQ    9
#define V_IDMA1_SLEEP_REQ(x) ((x) << S_IDMA1_SLEEP_REQ)
#define F_IDMA1_SLEEP_REQ    V_IDMA1_SLEEP_REQ(1U)

#define S_IDMA0_SLEEP_REQ    8
#define V_IDMA0_SLEEP_REQ(x) ((x) << S_IDMA0_SLEEP_REQ)
#define F_IDMA0_SLEEP_REQ    V_IDMA0_SLEEP_REQ(1U)

#define S_EDMA3_SLEEP_STATUS    7
#define V_EDMA3_SLEEP_STATUS(x) ((x) << S_EDMA3_SLEEP_STATUS)
#define F_EDMA3_SLEEP_STATUS    V_EDMA3_SLEEP_STATUS(1U)

#define S_EDMA2_SLEEP_STATUS    6
#define V_EDMA2_SLEEP_STATUS(x) ((x) << S_EDMA2_SLEEP_STATUS)
#define F_EDMA2_SLEEP_STATUS    V_EDMA2_SLEEP_STATUS(1U)

#define S_EDMA1_SLEEP_STATUS    5
#define V_EDMA1_SLEEP_STATUS(x) ((x) << S_EDMA1_SLEEP_STATUS)
#define F_EDMA1_SLEEP_STATUS    V_EDMA1_SLEEP_STATUS(1U)

#define S_EDMA0_SLEEP_STATUS    4
#define V_EDMA0_SLEEP_STATUS(x) ((x) << S_EDMA0_SLEEP_STATUS)
#define F_EDMA0_SLEEP_STATUS    V_EDMA0_SLEEP_STATUS(1U)

#define S_EDMA3_SLEEP_REQ    3
#define V_EDMA3_SLEEP_REQ(x) ((x) << S_EDMA3_SLEEP_REQ)
#define F_EDMA3_SLEEP_REQ    V_EDMA3_SLEEP_REQ(1U)

#define S_EDMA2_SLEEP_REQ    2
#define V_EDMA2_SLEEP_REQ(x) ((x) << S_EDMA2_SLEEP_REQ)
#define F_EDMA2_SLEEP_REQ    V_EDMA2_SLEEP_REQ(1U)

#define S_EDMA1_SLEEP_REQ    1
#define V_EDMA1_SLEEP_REQ(x) ((x) << S_EDMA1_SLEEP_REQ)
#define F_EDMA1_SLEEP_REQ    V_EDMA1_SLEEP_REQ(1U)

#define S_EDMA0_SLEEP_REQ    0
#define V_EDMA0_SLEEP_REQ(x) ((x) << S_EDMA0_SLEEP_REQ)
#define F_EDMA0_SLEEP_REQ    V_EDMA0_SLEEP_REQ(1U)

#define A_SGE_INT_CAUSE6 0x1128

#define S_ERR_DB_SYNC    21
#define V_ERR_DB_SYNC(x) ((x) << S_ERR_DB_SYNC)
#define F_ERR_DB_SYNC    V_ERR_DB_SYNC(1U)

#define S_ERR_GTS_SYNC    20
#define V_ERR_GTS_SYNC(x) ((x) << S_ERR_GTS_SYNC)
#define F_ERR_GTS_SYNC    V_ERR_GTS_SYNC(1U)

#define S_FATAL_LARGE_COAL    19
#define V_FATAL_LARGE_COAL(x) ((x) << S_FATAL_LARGE_COAL)
#define F_FATAL_LARGE_COAL    V_FATAL_LARGE_COAL(1U)

#define S_PL_BAR2_FRM_ERR    18
#define V_PL_BAR2_FRM_ERR(x) ((x) << S_PL_BAR2_FRM_ERR)
#define F_PL_BAR2_FRM_ERR    V_PL_BAR2_FRM_ERR(1U)

#define S_SILENT_DROP_TX_COAL    17
#define V_SILENT_DROP_TX_COAL(x) ((x) << S_SILENT_DROP_TX_COAL)
#define F_SILENT_DROP_TX_COAL    V_SILENT_DROP_TX_COAL(1U)

#define S_ERR_INV_CTXT4    16
#define V_ERR_INV_CTXT4(x) ((x) << S_ERR_INV_CTXT4)
#define F_ERR_INV_CTXT4    V_ERR_INV_CTXT4(1U)

#define S_ERR_BAD_DB_PIDX4    15
#define V_ERR_BAD_DB_PIDX4(x) ((x) << S_ERR_BAD_DB_PIDX4)
#define F_ERR_BAD_DB_PIDX4    V_ERR_BAD_DB_PIDX4(1U)

#define S_ERR_BAD_UPFL_INC_CREDIT4    14
#define V_ERR_BAD_UPFL_INC_CREDIT4(x) ((x) << S_ERR_BAD_UPFL_INC_CREDIT4)
#define F_ERR_BAD_UPFL_INC_CREDIT4    V_ERR_BAD_UPFL_INC_CREDIT4(1U)

#define S_FATAL_TAG_MISMATCH    13
#define V_FATAL_TAG_MISMATCH(x) ((x) << S_FATAL_TAG_MISMATCH)
#define F_FATAL_TAG_MISMATCH    V_FATAL_TAG_MISMATCH(1U)

#define S_FATAL_ENQ_CTL_RDY    12
#define V_FATAL_ENQ_CTL_RDY(x) ((x) << S_FATAL_ENQ_CTL_RDY)
#define F_FATAL_ENQ_CTL_RDY    V_FATAL_ENQ_CTL_RDY(1U)

#define S_ERR_PC_RSP_LEN3    11
#define V_ERR_PC_RSP_LEN3(x) ((x) << S_ERR_PC_RSP_LEN3)
#define F_ERR_PC_RSP_LEN3    V_ERR_PC_RSP_LEN3(1U)

#define S_ERR_PC_RSP_LEN2    10
#define V_ERR_PC_RSP_LEN2(x) ((x) << S_ERR_PC_RSP_LEN2)
#define F_ERR_PC_RSP_LEN2    V_ERR_PC_RSP_LEN2(1U)

#define S_ERR_PC_RSP_LEN1    9
#define V_ERR_PC_RSP_LEN1(x) ((x) << S_ERR_PC_RSP_LEN1)
#define F_ERR_PC_RSP_LEN1    V_ERR_PC_RSP_LEN1(1U)

#define S_ERR_PC_RSP_LEN0    8
#define V_ERR_PC_RSP_LEN0(x) ((x) << S_ERR_PC_RSP_LEN0)
#define F_ERR_PC_RSP_LEN0    V_ERR_PC_RSP_LEN0(1U)

#define S_FATAL_ENQ2LL_VLD    7
#define V_FATAL_ENQ2LL_VLD(x) ((x) << S_FATAL_ENQ2LL_VLD)
#define F_FATAL_ENQ2LL_VLD    V_FATAL_ENQ2LL_VLD(1U)

#define S_FATAL_LL_EMPTY    6
#define V_FATAL_LL_EMPTY(x) ((x) << S_FATAL_LL_EMPTY)
#define F_FATAL_LL_EMPTY    V_FATAL_LL_EMPTY(1U)

#define S_FATAL_OFF_WDENQ    5
#define V_FATAL_OFF_WDENQ(x) ((x) << S_FATAL_OFF_WDENQ)
#define F_FATAL_OFF_WDENQ    V_FATAL_OFF_WDENQ(1U)

#define S_FATAL_DEQ_DRDY    3
#define M_FATAL_DEQ_DRDY    0x3U
#define V_FATAL_DEQ_DRDY(x) ((x) << S_FATAL_DEQ_DRDY)
#define G_FATAL_DEQ_DRDY(x) (((x) >> S_FATAL_DEQ_DRDY) & M_FATAL_DEQ_DRDY)

#define S_FATAL_OUTP_DRDY    1
#define M_FATAL_OUTP_DRDY    0x3U
#define V_FATAL_OUTP_DRDY(x) ((x) << S_FATAL_OUTP_DRDY)
#define G_FATAL_OUTP_DRDY(x) (((x) >> S_FATAL_OUTP_DRDY) & M_FATAL_OUTP_DRDY)

#define S_FATAL_DEQ    0
#define V_FATAL_DEQ(x) ((x) << S_FATAL_DEQ)
#define F_FATAL_DEQ    V_FATAL_DEQ(1U)

#define S_FATAL_DEQ0_DRDY    29
#define M_FATAL_DEQ0_DRDY    0x7U
#define V_FATAL_DEQ0_DRDY(x) ((x) << S_FATAL_DEQ0_DRDY)
#define G_FATAL_DEQ0_DRDY(x) (((x) >> S_FATAL_DEQ0_DRDY) & M_FATAL_DEQ0_DRDY)

#define S_FATAL_OUT0_DRDY    26
#define M_FATAL_OUT0_DRDY    0x7U
#define V_FATAL_OUT0_DRDY(x) ((x) << S_FATAL_OUT0_DRDY)
#define G_FATAL_OUT0_DRDY(x) (((x) >> S_FATAL_OUT0_DRDY) & M_FATAL_OUT0_DRDY)

#define S_IMSG_DBG3_STUCK    25
#define V_IMSG_DBG3_STUCK(x) ((x) << S_IMSG_DBG3_STUCK)
#define F_IMSG_DBG3_STUCK    V_IMSG_DBG3_STUCK(1U)

#define S_IMSG_DBG2_STUCK    24
#define V_IMSG_DBG2_STUCK(x) ((x) << S_IMSG_DBG2_STUCK)
#define F_IMSG_DBG2_STUCK    V_IMSG_DBG2_STUCK(1U)

#define S_IMSG_DBG1_STUCK    23
#define V_IMSG_DBG1_STUCK(x) ((x) << S_IMSG_DBG1_STUCK)
#define F_IMSG_DBG1_STUCK    V_IMSG_DBG1_STUCK(1U)

#define S_IMSG_DBG0_STUCK    22
#define V_IMSG_DBG0_STUCK(x) ((x) << S_IMSG_DBG0_STUCK)
#define F_IMSG_DBG0_STUCK    V_IMSG_DBG0_STUCK(1U)

#define S_FATAL_DEQ1_DRDY    3
#define M_FATAL_DEQ1_DRDY    0x3U
#define V_FATAL_DEQ1_DRDY(x) ((x) << S_FATAL_DEQ1_DRDY)
#define G_FATAL_DEQ1_DRDY(x) (((x) >> S_FATAL_DEQ1_DRDY) & M_FATAL_DEQ1_DRDY)

#define S_FATAL_OUT1_DRDY    1
#define M_FATAL_OUT1_DRDY    0x3U
#define V_FATAL_OUT1_DRDY(x) ((x) << S_FATAL_OUT1_DRDY)
#define G_FATAL_OUT1_DRDY(x) (((x) >> S_FATAL_OUT1_DRDY) & M_FATAL_OUT1_DRDY)

#define A_SGE_DOORBELL_THROTTLE_THRESHOLD 0x112c

#define S_THROTTLE_THRESHOLD_FL    16
#define M_THROTTLE_THRESHOLD_FL    0xfU
#define V_THROTTLE_THRESHOLD_FL(x) ((x) << S_THROTTLE_THRESHOLD_FL)
#define G_THROTTLE_THRESHOLD_FL(x) (((x) >> S_THROTTLE_THRESHOLD_FL) & M_THROTTLE_THRESHOLD_FL)

#define S_THROTTLE_THRESHOLD_HP    12
#define M_THROTTLE_THRESHOLD_HP    0xfU
#define V_THROTTLE_THRESHOLD_HP(x) ((x) << S_THROTTLE_THRESHOLD_HP)
#define G_THROTTLE_THRESHOLD_HP(x) (((x) >> S_THROTTLE_THRESHOLD_HP) & M_THROTTLE_THRESHOLD_HP)

#define S_THROTTLE_THRESHOLD_LP    0
#define M_THROTTLE_THRESHOLD_LP    0xfffU
#define V_THROTTLE_THRESHOLD_LP(x) ((x) << S_THROTTLE_THRESHOLD_LP)
#define G_THROTTLE_THRESHOLD_LP(x) (((x) >> S_THROTTLE_THRESHOLD_LP) & M_THROTTLE_THRESHOLD_LP)

#define A_SGE_INT_ENABLE6 0x112c
#define A_SGE_DBP_FETCH_THRESHOLD 0x1130

#define S_DBP_FETCH_THRESHOLD_FL    21
#define M_DBP_FETCH_THRESHOLD_FL    0xfU
#define V_DBP_FETCH_THRESHOLD_FL(x) ((x) << S_DBP_FETCH_THRESHOLD_FL)
#define G_DBP_FETCH_THRESHOLD_FL(x) (((x) >> S_DBP_FETCH_THRESHOLD_FL) & M_DBP_FETCH_THRESHOLD_FL)

#define S_DBP_FETCH_THRESHOLD_HP    17
#define M_DBP_FETCH_THRESHOLD_HP    0xfU
#define V_DBP_FETCH_THRESHOLD_HP(x) ((x) << S_DBP_FETCH_THRESHOLD_HP)
#define G_DBP_FETCH_THRESHOLD_HP(x) (((x) >> S_DBP_FETCH_THRESHOLD_HP) & M_DBP_FETCH_THRESHOLD_HP)

#define S_DBP_FETCH_THRESHOLD_LP    5
#define M_DBP_FETCH_THRESHOLD_LP    0xfffU
#define V_DBP_FETCH_THRESHOLD_LP(x) ((x) << S_DBP_FETCH_THRESHOLD_LP)
#define G_DBP_FETCH_THRESHOLD_LP(x) (((x) >> S_DBP_FETCH_THRESHOLD_LP) & M_DBP_FETCH_THRESHOLD_LP)

#define S_DBP_FETCH_THRESHOLD_MODE    4
#define V_DBP_FETCH_THRESHOLD_MODE(x) ((x) << S_DBP_FETCH_THRESHOLD_MODE)
#define F_DBP_FETCH_THRESHOLD_MODE    V_DBP_FETCH_THRESHOLD_MODE(1U)

#define S_DBP_FETCH_THRESHOLD_EN3    3
#define V_DBP_FETCH_THRESHOLD_EN3(x) ((x) << S_DBP_FETCH_THRESHOLD_EN3)
#define F_DBP_FETCH_THRESHOLD_EN3    V_DBP_FETCH_THRESHOLD_EN3(1U)

#define S_DBP_FETCH_THRESHOLD_EN2    2
#define V_DBP_FETCH_THRESHOLD_EN2(x) ((x) << S_DBP_FETCH_THRESHOLD_EN2)
#define F_DBP_FETCH_THRESHOLD_EN2    V_DBP_FETCH_THRESHOLD_EN2(1U)

#define S_DBP_FETCH_THRESHOLD_EN1    1
#define V_DBP_FETCH_THRESHOLD_EN1(x) ((x) << S_DBP_FETCH_THRESHOLD_EN1)
#define F_DBP_FETCH_THRESHOLD_EN1    V_DBP_FETCH_THRESHOLD_EN1(1U)

#define S_DBP_FETCH_THRESHOLD_EN0    0
#define V_DBP_FETCH_THRESHOLD_EN0(x) ((x) << S_DBP_FETCH_THRESHOLD_EN0)
#define F_DBP_FETCH_THRESHOLD_EN0    V_DBP_FETCH_THRESHOLD_EN0(1U)

#define A_SGE_DBP_FETCH_THRESHOLD_QUEUE 0x1134

#define S_DBP_FETCH_THRESHOLD_IQ1    16
#define M_DBP_FETCH_THRESHOLD_IQ1    0xffffU
#define V_DBP_FETCH_THRESHOLD_IQ1(x) ((x) << S_DBP_FETCH_THRESHOLD_IQ1)
#define G_DBP_FETCH_THRESHOLD_IQ1(x) (((x) >> S_DBP_FETCH_THRESHOLD_IQ1) & M_DBP_FETCH_THRESHOLD_IQ1)

#define S_DBP_FETCH_THRESHOLD_IQ0    0
#define M_DBP_FETCH_THRESHOLD_IQ0    0xffffU
#define V_DBP_FETCH_THRESHOLD_IQ0(x) ((x) << S_DBP_FETCH_THRESHOLD_IQ0)
#define G_DBP_FETCH_THRESHOLD_IQ0(x) (((x) >> S_DBP_FETCH_THRESHOLD_IQ0) & M_DBP_FETCH_THRESHOLD_IQ0)

#define A_SGE_DBVFIFO_BADDR 0x1138
#define A_SGE_DBVFIFO_SIZE 0x113c

#define S_DBVFIFO_SIZE    6
#define M_DBVFIFO_SIZE    0xfffU
#define V_DBVFIFO_SIZE(x) ((x) << S_DBVFIFO_SIZE)
#define G_DBVFIFO_SIZE(x) (((x) >> S_DBVFIFO_SIZE) & M_DBVFIFO_SIZE)

#define S_T6_DBVFIFO_SIZE    0
#define M_T6_DBVFIFO_SIZE    0x1fffU
#define V_T6_DBVFIFO_SIZE(x) ((x) << S_T6_DBVFIFO_SIZE)
#define G_T6_DBVFIFO_SIZE(x) (((x) >> S_T6_DBVFIFO_SIZE) & M_T6_DBVFIFO_SIZE)

#define A_SGE_DBFIFO_STATUS3 0x1140

#define S_LP_PTRS_EQUAL    21
#define V_LP_PTRS_EQUAL(x) ((x) << S_LP_PTRS_EQUAL)
#define F_LP_PTRS_EQUAL    V_LP_PTRS_EQUAL(1U)

#define S_LP_SNAPHOT    20
#define V_LP_SNAPHOT(x) ((x) << S_LP_SNAPHOT)
#define F_LP_SNAPHOT    V_LP_SNAPHOT(1U)

#define S_FL_INT_THRESH_LOW    16
#define M_FL_INT_THRESH_LOW    0xfU
#define V_FL_INT_THRESH_LOW(x) ((x) << S_FL_INT_THRESH_LOW)
#define G_FL_INT_THRESH_LOW(x) (((x) >> S_FL_INT_THRESH_LOW) & M_FL_INT_THRESH_LOW)

#define S_HP_INT_THRESH_LOW    12
#define M_HP_INT_THRESH_LOW    0xfU
#define V_HP_INT_THRESH_LOW(x) ((x) << S_HP_INT_THRESH_LOW)
#define G_HP_INT_THRESH_LOW(x) (((x) >> S_HP_INT_THRESH_LOW) & M_HP_INT_THRESH_LOW)

#define S_LP_INT_THRESH_LOW    0
#define M_LP_INT_THRESH_LOW    0xfffU
#define V_LP_INT_THRESH_LOW(x) ((x) << S_LP_INT_THRESH_LOW)
#define G_LP_INT_THRESH_LOW(x) (((x) >> S_LP_INT_THRESH_LOW) & M_LP_INT_THRESH_LOW)

#define A_SGE_CHANGESET 0x1144
#define A_SGE_PC_RSP_ERROR 0x1148
#define A_SGE_TBUF_CONTROL 0x114c

#define S_DBPTBUFRSV1    9
#define M_DBPTBUFRSV1    0x1ffU
#define V_DBPTBUFRSV1(x) ((x) << S_DBPTBUFRSV1)
#define G_DBPTBUFRSV1(x) (((x) >> S_DBPTBUFRSV1) & M_DBPTBUFRSV1)

#define S_DBPTBUFRSV0    0
#define M_DBPTBUFRSV0    0x1ffU
#define V_DBPTBUFRSV0(x) ((x) << S_DBPTBUFRSV0)
#define G_DBPTBUFRSV0(x) (((x) >> S_DBPTBUFRSV0) & M_DBPTBUFRSV0)

#define A_SGE_TBUF_CONTROL0 0x114c
#define A_SGE_TBUF_CONTROL1 0x1150

#define S_DBPTBUFRSV3    9
#define M_DBPTBUFRSV3    0x1ffU
#define V_DBPTBUFRSV3(x) ((x) << S_DBPTBUFRSV3)
#define G_DBPTBUFRSV3(x) (((x) >> S_DBPTBUFRSV3) & M_DBPTBUFRSV3)

#define S_DBPTBUFRSV2    0
#define M_DBPTBUFRSV2    0x1ffU
#define V_DBPTBUFRSV2(x) ((x) << S_DBPTBUFRSV2)
#define G_DBPTBUFRSV2(x) (((x) >> S_DBPTBUFRSV2) & M_DBPTBUFRSV2)

#define A_SGE_TBUF_CONTROL2 0x1154

#define S_DBPTBUFRSV5    9
#define M_DBPTBUFRSV5    0x1ffU
#define V_DBPTBUFRSV5(x) ((x) << S_DBPTBUFRSV5)
#define G_DBPTBUFRSV5(x) (((x) >> S_DBPTBUFRSV5) & M_DBPTBUFRSV5)

#define S_DBPTBUFRSV4    0
#define M_DBPTBUFRSV4    0x1ffU
#define V_DBPTBUFRSV4(x) ((x) << S_DBPTBUFRSV4)
#define G_DBPTBUFRSV4(x) (((x) >> S_DBPTBUFRSV4) & M_DBPTBUFRSV4)

#define A_SGE_TBUF_CONTROL3 0x1158

#define S_DBPTBUFRSV7    9
#define M_DBPTBUFRSV7    0x1ffU
#define V_DBPTBUFRSV7(x) ((x) << S_DBPTBUFRSV7)
#define G_DBPTBUFRSV7(x) (((x) >> S_DBPTBUFRSV7) & M_DBPTBUFRSV7)

#define S_DBPTBUFRSV6    0
#define M_DBPTBUFRSV6    0x1ffU
#define V_DBPTBUFRSV6(x) ((x) << S_DBPTBUFRSV6)
#define G_DBPTBUFRSV6(x) (((x) >> S_DBPTBUFRSV6) & M_DBPTBUFRSV6)

#define A_SGE_TBUF_CONTROL4 0x115c

#define S_DBPTBUFRSV9    9
#define M_DBPTBUFRSV9    0x1ffU
#define V_DBPTBUFRSV9(x) ((x) << S_DBPTBUFRSV9)
#define G_DBPTBUFRSV9(x) (((x) >> S_DBPTBUFRSV9) & M_DBPTBUFRSV9)

#define S_DBPTBUFRSV8    0
#define M_DBPTBUFRSV8    0x1ffU
#define V_DBPTBUFRSV8(x) ((x) << S_DBPTBUFRSV8)
#define G_DBPTBUFRSV8(x) (((x) >> S_DBPTBUFRSV8) & M_DBPTBUFRSV8)

#define A_SGE_PC0_REQ_BIST_CMD 0x1180
#define A_SGE_PC0_REQ_BIST_ERROR_CNT 0x1184
#define A_SGE_PC1_REQ_BIST_CMD 0x1190
#define A_SGE_PC1_REQ_BIST_ERROR_CNT 0x1194
#define A_SGE_PC0_RSP_BIST_CMD 0x11a0
#define A_SGE_PC0_RSP_BIST_ERROR_CNT 0x11a4
#define A_SGE_PC1_RSP_BIST_CMD 0x11b0
#define A_SGE_PC1_RSP_BIST_ERROR_CNT 0x11b4
#define A_SGE_DBQ_TIMER_THRESH0 0x11b8

#define S_TXTIMETH3    24
#define M_TXTIMETH3    0x3fU
#define V_TXTIMETH3(x) ((x) << S_TXTIMETH3)
#define G_TXTIMETH3(x) (((x) >> S_TXTIMETH3) & M_TXTIMETH3)

#define S_TXTIMETH2    16
#define M_TXTIMETH2    0x3fU
#define V_TXTIMETH2(x) ((x) << S_TXTIMETH2)
#define G_TXTIMETH2(x) (((x) >> S_TXTIMETH2) & M_TXTIMETH2)

#define S_TXTIMETH1    8
#define M_TXTIMETH1    0x3fU
#define V_TXTIMETH1(x) ((x) << S_TXTIMETH1)
#define G_TXTIMETH1(x) (((x) >> S_TXTIMETH1) & M_TXTIMETH1)

#define S_TXTIMETH0    0
#define M_TXTIMETH0    0x3fU
#define V_TXTIMETH0(x) ((x) << S_TXTIMETH0)
#define G_TXTIMETH0(x) (((x) >> S_TXTIMETH0) & M_TXTIMETH0)

#define A_SGE_DBQ_TIMER_THRESH1 0x11bc

#define S_TXTIMETH7    24
#define M_TXTIMETH7    0x3fU
#define V_TXTIMETH7(x) ((x) << S_TXTIMETH7)
#define G_TXTIMETH7(x) (((x) >> S_TXTIMETH7) & M_TXTIMETH7)

#define S_TXTIMETH6    16
#define M_TXTIMETH6    0x3fU
#define V_TXTIMETH6(x) ((x) << S_TXTIMETH6)
#define G_TXTIMETH6(x) (((x) >> S_TXTIMETH6) & M_TXTIMETH6)

#define S_TXTIMETH5    8
#define M_TXTIMETH5    0x3fU
#define V_TXTIMETH5(x) ((x) << S_TXTIMETH5)
#define G_TXTIMETH5(x) (((x) >> S_TXTIMETH5) & M_TXTIMETH5)

#define S_TXTIMETH4    0
#define M_TXTIMETH4    0x3fU
#define V_TXTIMETH4(x) ((x) << S_TXTIMETH4)
#define G_TXTIMETH4(x) (((x) >> S_TXTIMETH4) & M_TXTIMETH4)

#define A_SGE_DBQ_TIMER_CONFIG 0x11c0

#define S_DBQ_TIMER_OP    0
#define M_DBQ_TIMER_OP    0xffU
#define V_DBQ_TIMER_OP(x) ((x) << S_DBQ_TIMER_OP)
#define G_DBQ_TIMER_OP(x) (((x) >> S_DBQ_TIMER_OP) & M_DBQ_TIMER_OP)

#define A_SGE_DBQ_TIMER_DBG 0x11c4

#define S_DBQ_TIMER_CMD    31
#define V_DBQ_TIMER_CMD(x) ((x) << S_DBQ_TIMER_CMD)
#define F_DBQ_TIMER_CMD    V_DBQ_TIMER_CMD(1U)

#define S_DBQ_TIMER_INDEX    24
#define M_DBQ_TIMER_INDEX    0x3fU
#define V_DBQ_TIMER_INDEX(x) ((x) << S_DBQ_TIMER_INDEX)
#define G_DBQ_TIMER_INDEX(x) (((x) >> S_DBQ_TIMER_INDEX) & M_DBQ_TIMER_INDEX)

#define S_DBQ_TIMER_QCNT    0
#define M_DBQ_TIMER_QCNT    0x1ffffU
#define V_DBQ_TIMER_QCNT(x) ((x) << S_DBQ_TIMER_QCNT)
#define G_DBQ_TIMER_QCNT(x) (((x) >> S_DBQ_TIMER_QCNT) & M_DBQ_TIMER_QCNT)

#define A_SGE_INT_CAUSE8 0x11c8

#define S_TRACE_RXPERR    8
#define V_TRACE_RXPERR(x) ((x) << S_TRACE_RXPERR)
#define F_TRACE_RXPERR    V_TRACE_RXPERR(1U)

#define S_U3_RXPERR    7
#define V_U3_RXPERR(x) ((x) << S_U3_RXPERR)
#define F_U3_RXPERR    V_U3_RXPERR(1U)

#define S_U2_RXPERR    6
#define V_U2_RXPERR(x) ((x) << S_U2_RXPERR)
#define F_U2_RXPERR    V_U2_RXPERR(1U)

#define S_U1_RXPERR    5
#define V_U1_RXPERR(x) ((x) << S_U1_RXPERR)
#define F_U1_RXPERR    V_U1_RXPERR(1U)

#define S_U0_RXPERR    4
#define V_U0_RXPERR(x) ((x) << S_U0_RXPERR)
#define F_U0_RXPERR    V_U0_RXPERR(1U)

#define S_T3_RXPERR    3
#define V_T3_RXPERR(x) ((x) << S_T3_RXPERR)
#define F_T3_RXPERR    V_T3_RXPERR(1U)

#define S_T2_RXPERR    2
#define V_T2_RXPERR(x) ((x) << S_T2_RXPERR)
#define F_T2_RXPERR    V_T2_RXPERR(1U)

#define S_T1_RXPERR    1
#define V_T1_RXPERR(x) ((x) << S_T1_RXPERR)
#define F_T1_RXPERR    V_T1_RXPERR(1U)

#define S_T0_RXPERR    0
#define V_T0_RXPERR(x) ((x) << S_T0_RXPERR)
#define F_T0_RXPERR    V_T0_RXPERR(1U)

#define A_SGE_INT_ENABLE8 0x11cc
#define A_SGE_PERR_ENABLE8 0x11d0
#define A_SGE_CTXT_CMD 0x11fc

#define S_BUSY    31
#define V_BUSY(x) ((x) << S_BUSY)
#define F_BUSY    V_BUSY(1U)

#define S_CTXTOP    28
#define M_CTXTOP    0x3U
#define V_CTXTOP(x) ((x) << S_CTXTOP)
#define G_CTXTOP(x) (((x) >> S_CTXTOP) & M_CTXTOP)

#define S_CTXTTYPE    24
#define M_CTXTTYPE    0x3U
#define V_CTXTTYPE(x) ((x) << S_CTXTTYPE)
#define G_CTXTTYPE(x) (((x) >> S_CTXTTYPE) & M_CTXTTYPE)

#define S_CTXTQID    0
#define M_CTXTQID    0x1ffffU
#define V_CTXTQID(x) ((x) << S_CTXTQID)
#define G_CTXTQID(x) (((x) >> S_CTXTQID) & M_CTXTQID)

#define A_SGE_CTXT_DATA0 0x1200
#define A_SGE_CTXT_DATA1 0x1204
#define A_SGE_CTXT_DATA2 0x1208
#define A_SGE_CTXT_DATA3 0x120c
#define A_SGE_CTXT_DATA4 0x1210
#define A_SGE_CTXT_DATA5 0x1214
#define A_SGE_CTXT_DATA6 0x1218

#define S_DATA_UNUSED    7
#define M_DATA_UNUSED    0x1ffffffU
#define V_DATA_UNUSED(x) ((x) << S_DATA_UNUSED)
#define G_DATA_UNUSED(x) (((x) >> S_DATA_UNUSED) & M_DATA_UNUSED)

#define S_DATA6    0
#define M_DATA6    0x7fU
#define V_DATA6(x) ((x) << S_DATA6)
#define G_DATA6(x) (((x) >> S_DATA6) & M_DATA6)

#define A_SGE_CTXT_DATA7 0x121c
#define A_SGE_CTXT_MASK0 0x1220
#define A_SGE_CTXT_MASK1 0x1224
#define A_SGE_CTXT_MASK2 0x1228
#define A_SGE_CTXT_MASK3 0x122c
#define A_SGE_CTXT_MASK4 0x1230
#define A_SGE_CTXT_MASK5 0x1234
#define A_SGE_CTXT_MASK6 0x1238

#define S_MASK_UNUSED    7
#define M_MASK_UNUSED    0x1ffffffU
#define V_MASK_UNUSED(x) ((x) << S_MASK_UNUSED)
#define G_MASK_UNUSED(x) (((x) >> S_MASK_UNUSED) & M_MASK_UNUSED)

#define S_MASK    0
#define M_MASK    0x7fU
#define V_MASK(x) ((x) << S_MASK)
#define G_MASK(x) (((x) >> S_MASK) & M_MASK)

#define A_SGE_CTXT_MASK7 0x123c
#define A_SGE_QBASE_MAP0 0x1240

#define S_EGRESS0_SIZE    24
#define M_EGRESS0_SIZE    0x1fU
#define V_EGRESS0_SIZE(x) ((x) << S_EGRESS0_SIZE)
#define G_EGRESS0_SIZE(x) (((x) >> S_EGRESS0_SIZE) & M_EGRESS0_SIZE)

#define S_EGRESS1_SIZE    16
#define M_EGRESS1_SIZE    0x1fU
#define V_EGRESS1_SIZE(x) ((x) << S_EGRESS1_SIZE)
#define G_EGRESS1_SIZE(x) (((x) >> S_EGRESS1_SIZE) & M_EGRESS1_SIZE)

#define S_INGRESS0_SIZE    8
#define M_INGRESS0_SIZE    0x1fU
#define V_INGRESS0_SIZE(x) ((x) << S_INGRESS0_SIZE)
#define G_INGRESS0_SIZE(x) (((x) >> S_INGRESS0_SIZE) & M_INGRESS0_SIZE)

#define S_DESTINATION    31
#define V_DESTINATION(x) ((x) << S_DESTINATION)
#define F_DESTINATION    V_DESTINATION(1U)

#define A_SGE_QBASE_MAP1 0x1244

#define S_EGRESS0_BASE    0
#define M_EGRESS0_BASE    0x1ffffU
#define V_EGRESS0_BASE(x) ((x) << S_EGRESS0_BASE)
#define G_EGRESS0_BASE(x) (((x) >> S_EGRESS0_BASE) & M_EGRESS0_BASE)

#define A_SGE_QBASE_MAP2 0x1248

#define S_EGRESS1_BASE    0
#define M_EGRESS1_BASE    0x1ffffU
#define V_EGRESS1_BASE(x) ((x) << S_EGRESS1_BASE)
#define G_EGRESS1_BASE(x) (((x) >> S_EGRESS1_BASE) & M_EGRESS1_BASE)

#define A_SGE_QBASE_MAP3 0x124c

#define S_INGRESS1_BASE_256VF    16
#define M_INGRESS1_BASE_256VF    0xffffU
#define V_INGRESS1_BASE_256VF(x) ((x) << S_INGRESS1_BASE_256VF)
#define G_INGRESS1_BASE_256VF(x) (((x) >> S_INGRESS1_BASE_256VF) & M_INGRESS1_BASE_256VF)

#define S_INGRESS0_BASE    0
#define M_INGRESS0_BASE    0xffffU
#define V_INGRESS0_BASE(x) ((x) << S_INGRESS0_BASE)
#define G_INGRESS0_BASE(x) (((x) >> S_INGRESS0_BASE) & M_INGRESS0_BASE)

#define A_SGE_QBASE_INDEX 0x1250

#define S_QIDX    0
#define M_QIDX    0x1ffU
#define V_QIDX(x) ((x) << S_QIDX)
#define G_QIDX(x) (((x) >> S_QIDX) & M_QIDX)

#define A_SGE_CONM_CTRL2 0x1254

#define S_FLMTHRESHPACK    8
#define M_FLMTHRESHPACK    0x7fU
#define V_FLMTHRESHPACK(x) ((x) << S_FLMTHRESHPACK)
#define G_FLMTHRESHPACK(x) (((x) >> S_FLMTHRESHPACK) & M_FLMTHRESHPACK)

#define S_FLMTHRESH    0
#define M_FLMTHRESH    0x7fU
#define V_FLMTHRESH(x) ((x) << S_FLMTHRESH)
#define G_FLMTHRESH(x) (((x) >> S_FLMTHRESH) & M_FLMTHRESH)

#define S_CONENMIDDLE    7
#define V_CONENMIDDLE(x) ((x) << S_CONENMIDDLE)
#define F_CONENMIDDLE    V_CONENMIDDLE(1U)

#define A_SGE_DEBUG_CONM 0x1258

#define S_MPS_CH_CNG    16
#define M_MPS_CH_CNG    0xffffU
#define V_MPS_CH_CNG(x) ((x) << S_MPS_CH_CNG)
#define G_MPS_CH_CNG(x) (((x) >> S_MPS_CH_CNG) & M_MPS_CH_CNG)

#define S_TP_CH_CNG    14
#define M_TP_CH_CNG    0x3U
#define V_TP_CH_CNG(x) ((x) << S_TP_CH_CNG)
#define G_TP_CH_CNG(x) (((x) >> S_TP_CH_CNG) & M_TP_CH_CNG)

#define S_ST_CONG    12
#define M_ST_CONG    0x3U
#define V_ST_CONG(x) ((x) << S_ST_CONG)
#define G_ST_CONG(x) (((x) >> S_ST_CONG) & M_ST_CONG)

#define S_LAST_XOFF    10
#define V_LAST_XOFF(x) ((x) << S_LAST_XOFF)
#define F_LAST_XOFF    V_LAST_XOFF(1U)

#define S_LAST_QID    0
#define M_LAST_QID    0x3ffU
#define V_LAST_QID(x) ((x) << S_LAST_QID)
#define G_LAST_QID(x) (((x) >> S_LAST_QID) & M_LAST_QID)

#define S_CH_CNG    16
#define M_CH_CNG    0xffffU
#define V_CH_CNG(x) ((x) << S_CH_CNG)
#define G_CH_CNG(x) (((x) >> S_CH_CNG) & M_CH_CNG)

#define S_CH_SEL    14
#define M_CH_SEL    0x3U
#define V_CH_SEL(x) ((x) << S_CH_SEL)
#define G_CH_SEL(x) (((x) >> S_CH_SEL) & M_CH_SEL)

#define A_SGE_DBG_QUEUE_STAT0_CTRL 0x125c

#define S_IMSG_GTS_SEL    18
#define V_IMSG_GTS_SEL(x) ((x) << S_IMSG_GTS_SEL)
#define F_IMSG_GTS_SEL    V_IMSG_GTS_SEL(1U)

#define S_MGT_SEL    17
#define V_MGT_SEL(x) ((x) << S_MGT_SEL)
#define F_MGT_SEL    V_MGT_SEL(1U)

#define S_DB_GTS_QID    0
#define M_DB_GTS_QID    0x1ffffU
#define V_DB_GTS_QID(x) ((x) << S_DB_GTS_QID)
#define G_DB_GTS_QID(x) (((x) >> S_DB_GTS_QID) & M_DB_GTS_QID)

#define A_SGE_DBG_QUEUE_STAT1_CTRL 0x1260
#define A_SGE_DBG_QUEUE_STAT0 0x1264
#define A_SGE_DBG_QUEUE_STAT1 0x1268
#define A_SGE_DBG_BAR2_PKT_CNT 0x126c
#define A_SGE_DBG_DB_PKT_CNT 0x1270
#define A_SGE_DBG_GTS_PKT_CNT 0x1274
#define A_SGE_DEBUG_DATA_HIGH_INDEX_16 0x1278
#define A_SGE_DEBUG_DATA_HIGH_INDEX_0 0x1280

#define S_CIM_WM    24
#define M_CIM_WM    0x3U
#define V_CIM_WM(x) ((x) << S_CIM_WM)
#define G_CIM_WM(x) (((x) >> S_CIM_WM) & M_CIM_WM)

#define S_DEBUG_UP_SOP_CNT    20
#define M_DEBUG_UP_SOP_CNT    0xfU
#define V_DEBUG_UP_SOP_CNT(x) ((x) << S_DEBUG_UP_SOP_CNT)
#define G_DEBUG_UP_SOP_CNT(x) (((x) >> S_DEBUG_UP_SOP_CNT) & M_DEBUG_UP_SOP_CNT)

#define S_DEBUG_UP_EOP_CNT    16
#define M_DEBUG_UP_EOP_CNT    0xfU
#define V_DEBUG_UP_EOP_CNT(x) ((x) << S_DEBUG_UP_EOP_CNT)
#define G_DEBUG_UP_EOP_CNT(x) (((x) >> S_DEBUG_UP_EOP_CNT) & M_DEBUG_UP_EOP_CNT)

#define S_DEBUG_CIM_SOP1_CNT    12
#define M_DEBUG_CIM_SOP1_CNT    0xfU
#define V_DEBUG_CIM_SOP1_CNT(x) ((x) << S_DEBUG_CIM_SOP1_CNT)
#define G_DEBUG_CIM_SOP1_CNT(x) (((x) >> S_DEBUG_CIM_SOP1_CNT) & M_DEBUG_CIM_SOP1_CNT)

#define S_DEBUG_CIM_EOP1_CNT    8
#define M_DEBUG_CIM_EOP1_CNT    0xfU
#define V_DEBUG_CIM_EOP1_CNT(x) ((x) << S_DEBUG_CIM_EOP1_CNT)
#define G_DEBUG_CIM_EOP1_CNT(x) (((x) >> S_DEBUG_CIM_EOP1_CNT) & M_DEBUG_CIM_EOP1_CNT)

#define S_DEBUG_CIM_SOP0_CNT    4
#define M_DEBUG_CIM_SOP0_CNT    0xfU
#define V_DEBUG_CIM_SOP0_CNT(x) ((x) << S_DEBUG_CIM_SOP0_CNT)
#define G_DEBUG_CIM_SOP0_CNT(x) (((x) >> S_DEBUG_CIM_SOP0_CNT) & M_DEBUG_CIM_SOP0_CNT)

#define S_DEBUG_CIM_EOP0_CNT    0
#define M_DEBUG_CIM_EOP0_CNT    0xfU
#define V_DEBUG_CIM_EOP0_CNT(x) ((x) << S_DEBUG_CIM_EOP0_CNT)
#define G_DEBUG_CIM_EOP0_CNT(x) (((x) >> S_DEBUG_CIM_EOP0_CNT) & M_DEBUG_CIM_EOP0_CNT)

#define S_DEBUG_BAR2_SOP_CNT    28
#define M_DEBUG_BAR2_SOP_CNT    0xfU
#define V_DEBUG_BAR2_SOP_CNT(x) ((x) << S_DEBUG_BAR2_SOP_CNT)
#define G_DEBUG_BAR2_SOP_CNT(x) (((x) >> S_DEBUG_BAR2_SOP_CNT) & M_DEBUG_BAR2_SOP_CNT)

#define S_DEBUG_BAR2_EOP_CNT    24
#define M_DEBUG_BAR2_EOP_CNT    0xfU
#define V_DEBUG_BAR2_EOP_CNT(x) ((x) << S_DEBUG_BAR2_EOP_CNT)
#define G_DEBUG_BAR2_EOP_CNT(x) (((x) >> S_DEBUG_BAR2_EOP_CNT) & M_DEBUG_BAR2_EOP_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_1 0x1284

#define S_DEBUG_T_RX_SOP1_CNT    28
#define M_DEBUG_T_RX_SOP1_CNT    0xfU
#define V_DEBUG_T_RX_SOP1_CNT(x) ((x) << S_DEBUG_T_RX_SOP1_CNT)
#define G_DEBUG_T_RX_SOP1_CNT(x) (((x) >> S_DEBUG_T_RX_SOP1_CNT) & M_DEBUG_T_RX_SOP1_CNT)

#define S_DEBUG_T_RX_EOP1_CNT    24
#define M_DEBUG_T_RX_EOP1_CNT    0xfU
#define V_DEBUG_T_RX_EOP1_CNT(x) ((x) << S_DEBUG_T_RX_EOP1_CNT)
#define G_DEBUG_T_RX_EOP1_CNT(x) (((x) >> S_DEBUG_T_RX_EOP1_CNT) & M_DEBUG_T_RX_EOP1_CNT)

#define S_DEBUG_T_RX_SOP0_CNT    20
#define M_DEBUG_T_RX_SOP0_CNT    0xfU
#define V_DEBUG_T_RX_SOP0_CNT(x) ((x) << S_DEBUG_T_RX_SOP0_CNT)
#define G_DEBUG_T_RX_SOP0_CNT(x) (((x) >> S_DEBUG_T_RX_SOP0_CNT) & M_DEBUG_T_RX_SOP0_CNT)

#define S_DEBUG_T_RX_EOP0_CNT    16
#define M_DEBUG_T_RX_EOP0_CNT    0xfU
#define V_DEBUG_T_RX_EOP0_CNT(x) ((x) << S_DEBUG_T_RX_EOP0_CNT)
#define G_DEBUG_T_RX_EOP0_CNT(x) (((x) >> S_DEBUG_T_RX_EOP0_CNT) & M_DEBUG_T_RX_EOP0_CNT)

#define S_DEBUG_U_RX_SOP1_CNT    12
#define M_DEBUG_U_RX_SOP1_CNT    0xfU
#define V_DEBUG_U_RX_SOP1_CNT(x) ((x) << S_DEBUG_U_RX_SOP1_CNT)
#define G_DEBUG_U_RX_SOP1_CNT(x) (((x) >> S_DEBUG_U_RX_SOP1_CNT) & M_DEBUG_U_RX_SOP1_CNT)

#define S_DEBUG_U_RX_EOP1_CNT    8
#define M_DEBUG_U_RX_EOP1_CNT    0xfU
#define V_DEBUG_U_RX_EOP1_CNT(x) ((x) << S_DEBUG_U_RX_EOP1_CNT)
#define G_DEBUG_U_RX_EOP1_CNT(x) (((x) >> S_DEBUG_U_RX_EOP1_CNT) & M_DEBUG_U_RX_EOP1_CNT)

#define S_DEBUG_U_RX_SOP0_CNT    4
#define M_DEBUG_U_RX_SOP0_CNT    0xfU
#define V_DEBUG_U_RX_SOP0_CNT(x) ((x) << S_DEBUG_U_RX_SOP0_CNT)
#define G_DEBUG_U_RX_SOP0_CNT(x) (((x) >> S_DEBUG_U_RX_SOP0_CNT) & M_DEBUG_U_RX_SOP0_CNT)

#define S_DEBUG_U_RX_EOP0_CNT    0
#define M_DEBUG_U_RX_EOP0_CNT    0xfU
#define V_DEBUG_U_RX_EOP0_CNT(x) ((x) << S_DEBUG_U_RX_EOP0_CNT)
#define G_DEBUG_U_RX_EOP0_CNT(x) (((x) >> S_DEBUG_U_RX_EOP0_CNT) & M_DEBUG_U_RX_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_2 0x1288

#define S_DEBUG_UD_RX_SOP3_CNT    28
#define M_DEBUG_UD_RX_SOP3_CNT    0xfU
#define V_DEBUG_UD_RX_SOP3_CNT(x) ((x) << S_DEBUG_UD_RX_SOP3_CNT)
#define G_DEBUG_UD_RX_SOP3_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP3_CNT) & M_DEBUG_UD_RX_SOP3_CNT)

#define S_DEBUG_UD_RX_EOP3_CNT    24
#define M_DEBUG_UD_RX_EOP3_CNT    0xfU
#define V_DEBUG_UD_RX_EOP3_CNT(x) ((x) << S_DEBUG_UD_RX_EOP3_CNT)
#define G_DEBUG_UD_RX_EOP3_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP3_CNT) & M_DEBUG_UD_RX_EOP3_CNT)

#define S_DEBUG_UD_RX_SOP2_CNT    20
#define M_DEBUG_UD_RX_SOP2_CNT    0xfU
#define V_DEBUG_UD_RX_SOP2_CNT(x) ((x) << S_DEBUG_UD_RX_SOP2_CNT)
#define G_DEBUG_UD_RX_SOP2_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP2_CNT) & M_DEBUG_UD_RX_SOP2_CNT)

#define S_DEBUG_UD_RX_EOP2_CNT    16
#define M_DEBUG_UD_RX_EOP2_CNT    0xfU
#define V_DEBUG_UD_RX_EOP2_CNT(x) ((x) << S_DEBUG_UD_RX_EOP2_CNT)
#define G_DEBUG_UD_RX_EOP2_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP2_CNT) & M_DEBUG_UD_RX_EOP2_CNT)

#define S_DEBUG_UD_RX_SOP1_CNT    12
#define M_DEBUG_UD_RX_SOP1_CNT    0xfU
#define V_DEBUG_UD_RX_SOP1_CNT(x) ((x) << S_DEBUG_UD_RX_SOP1_CNT)
#define G_DEBUG_UD_RX_SOP1_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP1_CNT) & M_DEBUG_UD_RX_SOP1_CNT)

#define S_DEBUG_UD_RX_EOP1_CNT    8
#define M_DEBUG_UD_RX_EOP1_CNT    0xfU
#define V_DEBUG_UD_RX_EOP1_CNT(x) ((x) << S_DEBUG_UD_RX_EOP1_CNT)
#define G_DEBUG_UD_RX_EOP1_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP1_CNT) & M_DEBUG_UD_RX_EOP1_CNT)

#define S_DEBUG_UD_RX_SOP0_CNT    4
#define M_DEBUG_UD_RX_SOP0_CNT    0xfU
#define V_DEBUG_UD_RX_SOP0_CNT(x) ((x) << S_DEBUG_UD_RX_SOP0_CNT)
#define G_DEBUG_UD_RX_SOP0_CNT(x) (((x) >> S_DEBUG_UD_RX_SOP0_CNT) & M_DEBUG_UD_RX_SOP0_CNT)

#define S_DEBUG_UD_RX_EOP0_CNT    0
#define M_DEBUG_UD_RX_EOP0_CNT    0xfU
#define V_DEBUG_UD_RX_EOP0_CNT(x) ((x) << S_DEBUG_UD_RX_EOP0_CNT)
#define G_DEBUG_UD_RX_EOP0_CNT(x) (((x) >> S_DEBUG_UD_RX_EOP0_CNT) & M_DEBUG_UD_RX_EOP0_CNT)

#define S_DBG_TBUF_USED1    9
#define M_DBG_TBUF_USED1    0x1ffU
#define V_DBG_TBUF_USED1(x) ((x) << S_DBG_TBUF_USED1)
#define G_DBG_TBUF_USED1(x) (((x) >> S_DBG_TBUF_USED1) & M_DBG_TBUF_USED1)

#define S_DBG_TBUF_USED0    0
#define M_DBG_TBUF_USED0    0x1ffU
#define V_DBG_TBUF_USED0(x) ((x) << S_DBG_TBUF_USED0)
#define G_DBG_TBUF_USED0(x) (((x) >> S_DBG_TBUF_USED0) & M_DBG_TBUF_USED0)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_3 0x128c

#define S_DEBUG_U_TX_SOP3_CNT    28
#define M_DEBUG_U_TX_SOP3_CNT    0xfU
#define V_DEBUG_U_TX_SOP3_CNT(x) ((x) << S_DEBUG_U_TX_SOP3_CNT)
#define G_DEBUG_U_TX_SOP3_CNT(x) (((x) >> S_DEBUG_U_TX_SOP3_CNT) & M_DEBUG_U_TX_SOP3_CNT)

#define S_DEBUG_U_TX_EOP3_CNT    24
#define M_DEBUG_U_TX_EOP3_CNT    0xfU
#define V_DEBUG_U_TX_EOP3_CNT(x) ((x) << S_DEBUG_U_TX_EOP3_CNT)
#define G_DEBUG_U_TX_EOP3_CNT(x) (((x) >> S_DEBUG_U_TX_EOP3_CNT) & M_DEBUG_U_TX_EOP3_CNT)

#define S_DEBUG_U_TX_SOP2_CNT    20
#define M_DEBUG_U_TX_SOP2_CNT    0xfU
#define V_DEBUG_U_TX_SOP2_CNT(x) ((x) << S_DEBUG_U_TX_SOP2_CNT)
#define G_DEBUG_U_TX_SOP2_CNT(x) (((x) >> S_DEBUG_U_TX_SOP2_CNT) & M_DEBUG_U_TX_SOP2_CNT)

#define S_DEBUG_U_TX_EOP2_CNT    16
#define M_DEBUG_U_TX_EOP2_CNT    0xfU
#define V_DEBUG_U_TX_EOP2_CNT(x) ((x) << S_DEBUG_U_TX_EOP2_CNT)
#define G_DEBUG_U_TX_EOP2_CNT(x) (((x) >> S_DEBUG_U_TX_EOP2_CNT) & M_DEBUG_U_TX_EOP2_CNT)

#define S_DEBUG_U_TX_SOP1_CNT    12
#define M_DEBUG_U_TX_SOP1_CNT    0xfU
#define V_DEBUG_U_TX_SOP1_CNT(x) ((x) << S_DEBUG_U_TX_SOP1_CNT)
#define G_DEBUG_U_TX_SOP1_CNT(x) (((x) >> S_DEBUG_U_TX_SOP1_CNT) & M_DEBUG_U_TX_SOP1_CNT)

#define S_DEBUG_U_TX_EOP1_CNT    8
#define M_DEBUG_U_TX_EOP1_CNT    0xfU
#define V_DEBUG_U_TX_EOP1_CNT(x) ((x) << S_DEBUG_U_TX_EOP1_CNT)
#define G_DEBUG_U_TX_EOP1_CNT(x) (((x) >> S_DEBUG_U_TX_EOP1_CNT) & M_DEBUG_U_TX_EOP1_CNT)

#define S_DEBUG_U_TX_SOP0_CNT    4
#define M_DEBUG_U_TX_SOP0_CNT    0xfU
#define V_DEBUG_U_TX_SOP0_CNT(x) ((x) << S_DEBUG_U_TX_SOP0_CNT)
#define G_DEBUG_U_TX_SOP0_CNT(x) (((x) >> S_DEBUG_U_TX_SOP0_CNT) & M_DEBUG_U_TX_SOP0_CNT)

#define S_DEBUG_U_TX_EOP0_CNT    0
#define M_DEBUG_U_TX_EOP0_CNT    0xfU
#define V_DEBUG_U_TX_EOP0_CNT(x) ((x) << S_DEBUG_U_TX_EOP0_CNT)
#define G_DEBUG_U_TX_EOP0_CNT(x) (((x) >> S_DEBUG_U_TX_EOP0_CNT) & M_DEBUG_U_TX_EOP0_CNT)

#define A_SGE_DEBUG1_DBP_THREAD 0x128c

#define S_WR_DEQ_CNT    12
#define M_WR_DEQ_CNT    0xfU
#define V_WR_DEQ_CNT(x) ((x) << S_WR_DEQ_CNT)
#define G_WR_DEQ_CNT(x) (((x) >> S_WR_DEQ_CNT) & M_WR_DEQ_CNT)

#define S_WR_ENQ_CNT    8
#define M_WR_ENQ_CNT    0xfU
#define V_WR_ENQ_CNT(x) ((x) << S_WR_ENQ_CNT)
#define G_WR_ENQ_CNT(x) (((x) >> S_WR_ENQ_CNT) & M_WR_ENQ_CNT)

#define S_FL_DEQ_CNT    4
#define M_FL_DEQ_CNT    0xfU
#define V_FL_DEQ_CNT(x) ((x) << S_FL_DEQ_CNT)
#define G_FL_DEQ_CNT(x) (((x) >> S_FL_DEQ_CNT) & M_FL_DEQ_CNT)

#define S_FL_ENQ_CNT    0
#define M_FL_ENQ_CNT    0xfU
#define V_FL_ENQ_CNT(x) ((x) << S_FL_ENQ_CNT)
#define G_FL_ENQ_CNT(x) (((x) >> S_FL_ENQ_CNT) & M_FL_ENQ_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_4 0x1290

#define S_DEBUG_PC_RSP_SOP1_CNT    28
#define M_DEBUG_PC_RSP_SOP1_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP1_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP1_CNT)
#define G_DEBUG_PC_RSP_SOP1_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP1_CNT) & M_DEBUG_PC_RSP_SOP1_CNT)

#define S_DEBUG_PC_RSP_EOP1_CNT    24
#define M_DEBUG_PC_RSP_EOP1_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP1_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP1_CNT)
#define G_DEBUG_PC_RSP_EOP1_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP1_CNT) & M_DEBUG_PC_RSP_EOP1_CNT)

#define S_DEBUG_PC_RSP_SOP0_CNT    20
#define M_DEBUG_PC_RSP_SOP0_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP0_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP0_CNT)
#define G_DEBUG_PC_RSP_SOP0_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP0_CNT) & M_DEBUG_PC_RSP_SOP0_CNT)

#define S_DEBUG_PC_RSP_EOP0_CNT    16
#define M_DEBUG_PC_RSP_EOP0_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP0_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP0_CNT)
#define G_DEBUG_PC_RSP_EOP0_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP0_CNT) & M_DEBUG_PC_RSP_EOP0_CNT)

#define S_DEBUG_PC_REQ_SOP1_CNT    12
#define M_DEBUG_PC_REQ_SOP1_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP1_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP1_CNT)
#define G_DEBUG_PC_REQ_SOP1_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP1_CNT) & M_DEBUG_PC_REQ_SOP1_CNT)

#define S_DEBUG_PC_REQ_EOP1_CNT    8
#define M_DEBUG_PC_REQ_EOP1_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP1_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP1_CNT)
#define G_DEBUG_PC_REQ_EOP1_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP1_CNT) & M_DEBUG_PC_REQ_EOP1_CNT)

#define S_DEBUG_PC_REQ_SOP0_CNT    4
#define M_DEBUG_PC_REQ_SOP0_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP0_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP0_CNT)
#define G_DEBUG_PC_REQ_SOP0_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP0_CNT) & M_DEBUG_PC_REQ_SOP0_CNT)

#define S_DEBUG_PC_REQ_EOP0_CNT    0
#define M_DEBUG_PC_REQ_EOP0_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP0_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP0_CNT)
#define G_DEBUG_PC_REQ_EOP0_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP0_CNT) & M_DEBUG_PC_REQ_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_5 0x1294

#define S_DEBUG_PD_RDREQ_SOP3_CNT    28
#define M_DEBUG_PD_RDREQ_SOP3_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP3_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP3_CNT)
#define G_DEBUG_PD_RDREQ_SOP3_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP3_CNT) & M_DEBUG_PD_RDREQ_SOP3_CNT)

#define S_DEBUG_PD_RDREQ_EOP3_CNT    24
#define M_DEBUG_PD_RDREQ_EOP3_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP3_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP3_CNT)
#define G_DEBUG_PD_RDREQ_EOP3_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP3_CNT) & M_DEBUG_PD_RDREQ_EOP3_CNT)

#define S_DEBUG_PD_RDREQ_SOP2_CNT    20
#define M_DEBUG_PD_RDREQ_SOP2_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP2_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP2_CNT)
#define G_DEBUG_PD_RDREQ_SOP2_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP2_CNT) & M_DEBUG_PD_RDREQ_SOP2_CNT)

#define S_DEBUG_PD_RDREQ_EOP2_CNT    16
#define M_DEBUG_PD_RDREQ_EOP2_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP2_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP2_CNT)
#define G_DEBUG_PD_RDREQ_EOP2_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP2_CNT) & M_DEBUG_PD_RDREQ_EOP2_CNT)

#define S_DEBUG_PD_RDREQ_SOP1_CNT    12
#define M_DEBUG_PD_RDREQ_SOP1_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP1_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP1_CNT)
#define G_DEBUG_PD_RDREQ_SOP1_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP1_CNT) & M_DEBUG_PD_RDREQ_SOP1_CNT)

#define S_DEBUG_PD_RDREQ_EOP1_CNT    8
#define M_DEBUG_PD_RDREQ_EOP1_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP1_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP1_CNT)
#define G_DEBUG_PD_RDREQ_EOP1_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP1_CNT) & M_DEBUG_PD_RDREQ_EOP1_CNT)

#define S_DEBUG_PD_RDREQ_SOP0_CNT    4
#define M_DEBUG_PD_RDREQ_SOP0_CNT    0xfU
#define V_DEBUG_PD_RDREQ_SOP0_CNT(x) ((x) << S_DEBUG_PD_RDREQ_SOP0_CNT)
#define G_DEBUG_PD_RDREQ_SOP0_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_SOP0_CNT) & M_DEBUG_PD_RDREQ_SOP0_CNT)

#define S_DEBUG_PD_RDREQ_EOP0_CNT    0
#define M_DEBUG_PD_RDREQ_EOP0_CNT    0xfU
#define V_DEBUG_PD_RDREQ_EOP0_CNT(x) ((x) << S_DEBUG_PD_RDREQ_EOP0_CNT)
#define G_DEBUG_PD_RDREQ_EOP0_CNT(x) (((x) >> S_DEBUG_PD_RDREQ_EOP0_CNT) & M_DEBUG_PD_RDREQ_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_6 0x1298

#define S_DEBUG_PD_RDRSP_SOP3_CNT    28
#define M_DEBUG_PD_RDRSP_SOP3_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP3_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP3_CNT)
#define G_DEBUG_PD_RDRSP_SOP3_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP3_CNT) & M_DEBUG_PD_RDRSP_SOP3_CNT)

#define S_DEBUG_PD_RDRSP_EOP3_CNT    24
#define M_DEBUG_PD_RDRSP_EOP3_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP3_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP3_CNT)
#define G_DEBUG_PD_RDRSP_EOP3_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP3_CNT) & M_DEBUG_PD_RDRSP_EOP3_CNT)

#define S_DEBUG_PD_RDRSP_SOP2_CNT    20
#define M_DEBUG_PD_RDRSP_SOP2_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP2_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP2_CNT)
#define G_DEBUG_PD_RDRSP_SOP2_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP2_CNT) & M_DEBUG_PD_RDRSP_SOP2_CNT)

#define S_DEBUG_PD_RDRSP_EOP2_CNT    16
#define M_DEBUG_PD_RDRSP_EOP2_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP2_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP2_CNT)
#define G_DEBUG_PD_RDRSP_EOP2_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP2_CNT) & M_DEBUG_PD_RDRSP_EOP2_CNT)

#define S_DEBUG_PD_RDRSP_SOP1_CNT    12
#define M_DEBUG_PD_RDRSP_SOP1_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP1_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP1_CNT)
#define G_DEBUG_PD_RDRSP_SOP1_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP1_CNT) & M_DEBUG_PD_RDRSP_SOP1_CNT)

#define S_DEBUG_PD_RDRSP_EOP1_CNT    8
#define M_DEBUG_PD_RDRSP_EOP1_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP1_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP1_CNT)
#define G_DEBUG_PD_RDRSP_EOP1_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP1_CNT) & M_DEBUG_PD_RDRSP_EOP1_CNT)

#define S_DEBUG_PD_RDRSP_SOP0_CNT    4
#define M_DEBUG_PD_RDRSP_SOP0_CNT    0xfU
#define V_DEBUG_PD_RDRSP_SOP0_CNT(x) ((x) << S_DEBUG_PD_RDRSP_SOP0_CNT)
#define G_DEBUG_PD_RDRSP_SOP0_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_SOP0_CNT) & M_DEBUG_PD_RDRSP_SOP0_CNT)

#define S_DEBUG_PD_RDRSP_EOP0_CNT    0
#define M_DEBUG_PD_RDRSP_EOP0_CNT    0xfU
#define V_DEBUG_PD_RDRSP_EOP0_CNT(x) ((x) << S_DEBUG_PD_RDRSP_EOP0_CNT)
#define G_DEBUG_PD_RDRSP_EOP0_CNT(x) (((x) >> S_DEBUG_PD_RDRSP_EOP0_CNT) & M_DEBUG_PD_RDRSP_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_7 0x129c

#define S_DEBUG_PD_WRREQ_SOP3_CNT    28
#define M_DEBUG_PD_WRREQ_SOP3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP3_CNT)
#define G_DEBUG_PD_WRREQ_SOP3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP3_CNT) & M_DEBUG_PD_WRREQ_SOP3_CNT)

#define S_DEBUG_PD_WRREQ_EOP3_CNT    24
#define M_DEBUG_PD_WRREQ_EOP3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP3_CNT)
#define G_DEBUG_PD_WRREQ_EOP3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP3_CNT) & M_DEBUG_PD_WRREQ_EOP3_CNT)

#define S_DEBUG_PD_WRREQ_SOP2_CNT    20
#define M_DEBUG_PD_WRREQ_SOP2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP2_CNT)
#define G_DEBUG_PD_WRREQ_SOP2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP2_CNT) & M_DEBUG_PD_WRREQ_SOP2_CNT)

#define S_DEBUG_PD_WRREQ_EOP2_CNT    16
#define M_DEBUG_PD_WRREQ_EOP2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP2_CNT)
#define G_DEBUG_PD_WRREQ_EOP2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP2_CNT) & M_DEBUG_PD_WRREQ_EOP2_CNT)

#define S_DEBUG_PD_WRREQ_SOP1_CNT    12
#define M_DEBUG_PD_WRREQ_SOP1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP1_CNT)
#define G_DEBUG_PD_WRREQ_SOP1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP1_CNT) & M_DEBUG_PD_WRREQ_SOP1_CNT)

#define S_DEBUG_PD_WRREQ_EOP1_CNT    8
#define M_DEBUG_PD_WRREQ_EOP1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP1_CNT)
#define G_DEBUG_PD_WRREQ_EOP1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP1_CNT) & M_DEBUG_PD_WRREQ_EOP1_CNT)

#define S_DEBUG_PD_WRREQ_SOP0_CNT    4
#define M_DEBUG_PD_WRREQ_SOP0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_SOP0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_SOP0_CNT)
#define G_DEBUG_PD_WRREQ_SOP0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_SOP0_CNT) & M_DEBUG_PD_WRREQ_SOP0_CNT)

#define S_DEBUG_PD_WRREQ_EOP0_CNT    0
#define M_DEBUG_PD_WRREQ_EOP0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_EOP0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_EOP0_CNT)
#define G_DEBUG_PD_WRREQ_EOP0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_EOP0_CNT) & M_DEBUG_PD_WRREQ_EOP0_CNT)

#define S_DEBUG_PC_RSP_SOP_CNT    28
#define M_DEBUG_PC_RSP_SOP_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP_CNT)
#define G_DEBUG_PC_RSP_SOP_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP_CNT) & M_DEBUG_PC_RSP_SOP_CNT)

#define S_DEBUG_PC_RSP_EOP_CNT    24
#define M_DEBUG_PC_RSP_EOP_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP_CNT)
#define G_DEBUG_PC_RSP_EOP_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP_CNT) & M_DEBUG_PC_RSP_EOP_CNT)

#define S_DEBUG_PC_REQ_SOP_CNT    20
#define M_DEBUG_PC_REQ_SOP_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP_CNT)
#define G_DEBUG_PC_REQ_SOP_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP_CNT) & M_DEBUG_PC_REQ_SOP_CNT)

#define S_DEBUG_PC_REQ_EOP_CNT    16
#define M_DEBUG_PC_REQ_EOP_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP_CNT)
#define G_DEBUG_PC_REQ_EOP_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP_CNT) & M_DEBUG_PC_REQ_EOP_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_8 0x12a0

#define S_GLOBALENABLE_OFF    29
#define V_GLOBALENABLE_OFF(x) ((x) << S_GLOBALENABLE_OFF)
#define F_GLOBALENABLE_OFF    V_GLOBALENABLE_OFF(1U)

#define S_DEBUG_CIM2SGE_RXAFULL_D    27
#define M_DEBUG_CIM2SGE_RXAFULL_D    0x3U
#define V_DEBUG_CIM2SGE_RXAFULL_D(x) ((x) << S_DEBUG_CIM2SGE_RXAFULL_D)
#define G_DEBUG_CIM2SGE_RXAFULL_D(x) (((x) >> S_DEBUG_CIM2SGE_RXAFULL_D) & M_DEBUG_CIM2SGE_RXAFULL_D)

#define S_DEBUG_CPLSW_CIM_TXAFULL_D    25
#define M_DEBUG_CPLSW_CIM_TXAFULL_D    0x3U
#define V_DEBUG_CPLSW_CIM_TXAFULL_D(x) ((x) << S_DEBUG_CPLSW_CIM_TXAFULL_D)
#define G_DEBUG_CPLSW_CIM_TXAFULL_D(x) (((x) >> S_DEBUG_CPLSW_CIM_TXAFULL_D) & M_DEBUG_CPLSW_CIM_TXAFULL_D)

#define S_DEBUG_UP_FULL    24
#define V_DEBUG_UP_FULL(x) ((x) << S_DEBUG_UP_FULL)
#define F_DEBUG_UP_FULL    V_DEBUG_UP_FULL(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_PC    23
#define V_DEBUG_M_RD_REQ_OUTSTANDING_PC(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_PC)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_PC    V_DEBUG_M_RD_REQ_OUTSTANDING_PC(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO    22
#define V_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO    V_DEBUG_M_RD_REQ_OUTSTANDING_VFIFO(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_IMSG    21
#define V_DEBUG_M_RD_REQ_OUTSTANDING_IMSG(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_IMSG)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_IMSG    V_DEBUG_M_RD_REQ_OUTSTANDING_IMSG(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_CMARB    20
#define V_DEBUG_M_RD_REQ_OUTSTANDING_CMARB(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_CMARB)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_CMARB    V_DEBUG_M_RD_REQ_OUTSTANDING_CMARB(1U)

#define S_DEBUG_M_RD_REQ_OUTSTANDING_FLM    19
#define V_DEBUG_M_RD_REQ_OUTSTANDING_FLM(x) ((x) << S_DEBUG_M_RD_REQ_OUTSTANDING_FLM)
#define F_DEBUG_M_RD_REQ_OUTSTANDING_FLM    V_DEBUG_M_RD_REQ_OUTSTANDING_FLM(1U)

#define S_DEBUG_M_REQVLD    18
#define V_DEBUG_M_REQVLD(x) ((x) << S_DEBUG_M_REQVLD)
#define F_DEBUG_M_REQVLD    V_DEBUG_M_REQVLD(1U)

#define S_DEBUG_M_REQRDY    17
#define V_DEBUG_M_REQRDY(x) ((x) << S_DEBUG_M_REQRDY)
#define F_DEBUG_M_REQRDY    V_DEBUG_M_REQRDY(1U)

#define S_DEBUG_M_RSPVLD    16
#define V_DEBUG_M_RSPVLD(x) ((x) << S_DEBUG_M_RSPVLD)
#define F_DEBUG_M_RSPVLD    V_DEBUG_M_RSPVLD(1U)

#define S_DEBUG_PD_WRREQ_INT3_CNT    12
#define M_DEBUG_PD_WRREQ_INT3_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT3_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT3_CNT)
#define G_DEBUG_PD_WRREQ_INT3_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT3_CNT) & M_DEBUG_PD_WRREQ_INT3_CNT)

#define S_DEBUG_PD_WRREQ_INT2_CNT    8
#define M_DEBUG_PD_WRREQ_INT2_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT2_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT2_CNT)
#define G_DEBUG_PD_WRREQ_INT2_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT2_CNT) & M_DEBUG_PD_WRREQ_INT2_CNT)

#define S_DEBUG_PD_WRREQ_INT1_CNT    4
#define M_DEBUG_PD_WRREQ_INT1_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT1_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT1_CNT)
#define G_DEBUG_PD_WRREQ_INT1_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT1_CNT) & M_DEBUG_PD_WRREQ_INT1_CNT)

#define S_DEBUG_PD_WRREQ_INT0_CNT    0
#define M_DEBUG_PD_WRREQ_INT0_CNT    0xfU
#define V_DEBUG_PD_WRREQ_INT0_CNT(x) ((x) << S_DEBUG_PD_WRREQ_INT0_CNT)
#define G_DEBUG_PD_WRREQ_INT0_CNT(x) (((x) >> S_DEBUG_PD_WRREQ_INT0_CNT) & M_DEBUG_PD_WRREQ_INT0_CNT)

#define S_DEBUG_PL_BAR2_REQVLD    31
#define V_DEBUG_PL_BAR2_REQVLD(x) ((x) << S_DEBUG_PL_BAR2_REQVLD)
#define F_DEBUG_PL_BAR2_REQVLD    V_DEBUG_PL_BAR2_REQVLD(1U)

#define S_DEBUG_PL_BAR2_REQFULL    30
#define V_DEBUG_PL_BAR2_REQFULL(x) ((x) << S_DEBUG_PL_BAR2_REQFULL)
#define F_DEBUG_PL_BAR2_REQFULL    V_DEBUG_PL_BAR2_REQFULL(1U)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_9 0x12a4

#define S_DEBUG_CPLSW_TP_RX_SOP1_CNT    28
#define M_DEBUG_CPLSW_TP_RX_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_SOP1_CNT)
#define G_DEBUG_CPLSW_TP_RX_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_SOP1_CNT) & M_DEBUG_CPLSW_TP_RX_SOP1_CNT)

#define S_DEBUG_CPLSW_TP_RX_EOP1_CNT    24
#define M_DEBUG_CPLSW_TP_RX_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_EOP1_CNT)
#define G_DEBUG_CPLSW_TP_RX_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_EOP1_CNT) & M_DEBUG_CPLSW_TP_RX_EOP1_CNT)

#define S_DEBUG_CPLSW_TP_RX_SOP0_CNT    20
#define M_DEBUG_CPLSW_TP_RX_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_SOP0_CNT)
#define G_DEBUG_CPLSW_TP_RX_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_SOP0_CNT) & M_DEBUG_CPLSW_TP_RX_SOP0_CNT)

#define S_DEBUG_CPLSW_TP_RX_EOP0_CNT    16
#define M_DEBUG_CPLSW_TP_RX_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_TP_RX_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_TP_RX_EOP0_CNT)
#define G_DEBUG_CPLSW_TP_RX_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_TP_RX_EOP0_CNT) & M_DEBUG_CPLSW_TP_RX_EOP0_CNT)

#define S_DEBUG_CPLSW_CIM_SOP1_CNT    12
#define M_DEBUG_CPLSW_CIM_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_SOP1_CNT)
#define G_DEBUG_CPLSW_CIM_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_SOP1_CNT) & M_DEBUG_CPLSW_CIM_SOP1_CNT)

#define S_DEBUG_CPLSW_CIM_EOP1_CNT    8
#define M_DEBUG_CPLSW_CIM_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_EOP1_CNT)
#define G_DEBUG_CPLSW_CIM_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_EOP1_CNT) & M_DEBUG_CPLSW_CIM_EOP1_CNT)

#define S_DEBUG_CPLSW_CIM_SOP0_CNT    4
#define M_DEBUG_CPLSW_CIM_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_SOP0_CNT)
#define G_DEBUG_CPLSW_CIM_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_SOP0_CNT) & M_DEBUG_CPLSW_CIM_SOP0_CNT)

#define S_DEBUG_CPLSW_CIM_EOP0_CNT    0
#define M_DEBUG_CPLSW_CIM_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_CIM_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_CIM_EOP0_CNT)
#define G_DEBUG_CPLSW_CIM_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_CIM_EOP0_CNT) & M_DEBUG_CPLSW_CIM_EOP0_CNT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_10 0x12a8

#define S_DEBUG_T_RXAFULL_D    30
#define M_DEBUG_T_RXAFULL_D    0x3U
#define V_DEBUG_T_RXAFULL_D(x) ((x) << S_DEBUG_T_RXAFULL_D)
#define G_DEBUG_T_RXAFULL_D(x) (((x) >> S_DEBUG_T_RXAFULL_D) & M_DEBUG_T_RXAFULL_D)

#define S_DEBUG_PD_RDRSPAFULL_D    26
#define M_DEBUG_PD_RDRSPAFULL_D    0xfU
#define V_DEBUG_PD_RDRSPAFULL_D(x) ((x) << S_DEBUG_PD_RDRSPAFULL_D)
#define G_DEBUG_PD_RDRSPAFULL_D(x) (((x) >> S_DEBUG_PD_RDRSPAFULL_D) & M_DEBUG_PD_RDRSPAFULL_D)

#define S_DEBUG_PD_RDREQAFULL_D    22
#define M_DEBUG_PD_RDREQAFULL_D    0xfU
#define V_DEBUG_PD_RDREQAFULL_D(x) ((x) << S_DEBUG_PD_RDREQAFULL_D)
#define G_DEBUG_PD_RDREQAFULL_D(x) (((x) >> S_DEBUG_PD_RDREQAFULL_D) & M_DEBUG_PD_RDREQAFULL_D)

#define S_DEBUG_PD_WRREQAFULL_D    18
#define M_DEBUG_PD_WRREQAFULL_D    0xfU
#define V_DEBUG_PD_WRREQAFULL_D(x) ((x) << S_DEBUG_PD_WRREQAFULL_D)
#define G_DEBUG_PD_WRREQAFULL_D(x) (((x) >> S_DEBUG_PD_WRREQAFULL_D) & M_DEBUG_PD_WRREQAFULL_D)

#define S_DEBUG_PC_RSPAFULL_D    15
#define M_DEBUG_PC_RSPAFULL_D    0x7U
#define V_DEBUG_PC_RSPAFULL_D(x) ((x) << S_DEBUG_PC_RSPAFULL_D)
#define G_DEBUG_PC_RSPAFULL_D(x) (((x) >> S_DEBUG_PC_RSPAFULL_D) & M_DEBUG_PC_RSPAFULL_D)

#define S_DEBUG_PC_REQAFULL_D    12
#define M_DEBUG_PC_REQAFULL_D    0x7U
#define V_DEBUG_PC_REQAFULL_D(x) ((x) << S_DEBUG_PC_REQAFULL_D)
#define G_DEBUG_PC_REQAFULL_D(x) (((x) >> S_DEBUG_PC_REQAFULL_D) & M_DEBUG_PC_REQAFULL_D)

#define S_DEBUG_U_TXAFULL_D    8
#define M_DEBUG_U_TXAFULL_D    0xfU
#define V_DEBUG_U_TXAFULL_D(x) ((x) << S_DEBUG_U_TXAFULL_D)
#define G_DEBUG_U_TXAFULL_D(x) (((x) >> S_DEBUG_U_TXAFULL_D) & M_DEBUG_U_TXAFULL_D)

#define S_DEBUG_UD_RXAFULL_D    4
#define M_DEBUG_UD_RXAFULL_D    0xfU
#define V_DEBUG_UD_RXAFULL_D(x) ((x) << S_DEBUG_UD_RXAFULL_D)
#define G_DEBUG_UD_RXAFULL_D(x) (((x) >> S_DEBUG_UD_RXAFULL_D) & M_DEBUG_UD_RXAFULL_D)

#define S_DEBUG_U_RXAFULL_D    2
#define M_DEBUG_U_RXAFULL_D    0x3U
#define V_DEBUG_U_RXAFULL_D(x) ((x) << S_DEBUG_U_RXAFULL_D)
#define G_DEBUG_U_RXAFULL_D(x) (((x) >> S_DEBUG_U_RXAFULL_D) & M_DEBUG_U_RXAFULL_D)

#define S_DEBUG_CIM_AFULL_D    0
#define M_DEBUG_CIM_AFULL_D    0x3U
#define V_DEBUG_CIM_AFULL_D(x) ((x) << S_DEBUG_CIM_AFULL_D)
#define G_DEBUG_CIM_AFULL_D(x) (((x) >> S_DEBUG_CIM_AFULL_D) & M_DEBUG_CIM_AFULL_D)

#define S_DEBUG_IDMA1_S_CPL_FLIT_REMAINING    28
#define M_DEBUG_IDMA1_S_CPL_FLIT_REMAINING    0xfU
#define V_DEBUG_IDMA1_S_CPL_FLIT_REMAINING(x) ((x) << S_DEBUG_IDMA1_S_CPL_FLIT_REMAINING)
#define G_DEBUG_IDMA1_S_CPL_FLIT_REMAINING(x) (((x) >> S_DEBUG_IDMA1_S_CPL_FLIT_REMAINING) & M_DEBUG_IDMA1_S_CPL_FLIT_REMAINING)

#define S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_SRDY    27
#define V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_SRDY(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_SRDY)
#define F_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_SRDY    V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_SRDY(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_RSS    26
#define V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_RSS(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_RSS)
#define F_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_RSS    V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_RSS(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_NOCPL    25
#define V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_NOCPL(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_NOCPL)
#define F_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_NOCPL    V_DEBUG_IDMA1_IDMA2IMSG_CMP_OUT_NOCPL(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_FULL    24
#define V_DEBUG_IDMA1_IDMA2IMSG_FULL(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_FULL)
#define F_DEBUG_IDMA1_IDMA2IMSG_FULL    V_DEBUG_IDMA1_IDMA2IMSG_FULL(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_EOP    23
#define V_DEBUG_IDMA1_IDMA2IMSG_EOP(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_EOP)
#define F_DEBUG_IDMA1_IDMA2IMSG_EOP    V_DEBUG_IDMA1_IDMA2IMSG_EOP(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_FIFO_IN_DRDY    22
#define V_DEBUG_IDMA1_IDMA2IMSG_FIFO_IN_DRDY(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_FIFO_IN_DRDY)
#define F_DEBUG_IDMA1_IDMA2IMSG_FIFO_IN_DRDY    V_DEBUG_IDMA1_IDMA2IMSG_FIFO_IN_DRDY(1U)

#define S_DEBUG_IDMA1_IDMA2IMSG_CMP_IN_DRDY    21
#define V_DEBUG_IDMA1_IDMA2IMSG_CMP_IN_DRDY(x) ((x) << S_DEBUG_IDMA1_IDMA2IMSG_CMP_IN_DRDY)
#define F_DEBUG_IDMA1_IDMA2IMSG_CMP_IN_DRDY    V_DEBUG_IDMA1_IDMA2IMSG_CMP_IN_DRDY(1U)

#define S_DEBUG_IDMA0_S_CPL_FLIT_REMAINING    17
#define M_DEBUG_IDMA0_S_CPL_FLIT_REMAINING    0xfU
#define V_DEBUG_IDMA0_S_CPL_FLIT_REMAINING(x) ((x) << S_DEBUG_IDMA0_S_CPL_FLIT_REMAINING)
#define G_DEBUG_IDMA0_S_CPL_FLIT_REMAINING(x) (((x) >> S_DEBUG_IDMA0_S_CPL_FLIT_REMAINING) & M_DEBUG_IDMA0_S_CPL_FLIT_REMAINING)

#define S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_SRDY    16
#define V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_SRDY(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_SRDY)
#define F_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_SRDY    V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_SRDY(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_RSS    15
#define V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_RSS(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_RSS)
#define F_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_RSS    V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_RSS(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_NOCPL    14
#define V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_NOCPL(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_NOCPL)
#define F_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_NOCPL    V_DEBUG_IDMA0_IDMA2IMSG_CMP_OUT_NOCPL(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_FULL    13
#define V_DEBUG_IDMA0_IDMA2IMSG_FULL(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_FULL)
#define F_DEBUG_IDMA0_IDMA2IMSG_FULL    V_DEBUG_IDMA0_IDMA2IMSG_FULL(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_EOP    12
#define V_DEBUG_IDMA0_IDMA2IMSG_EOP(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_EOP)
#define F_DEBUG_IDMA0_IDMA2IMSG_EOP    V_DEBUG_IDMA0_IDMA2IMSG_EOP(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_CMP_IN_DRDY    11
#define V_DEBUG_IDMA0_IDMA2IMSG_CMP_IN_DRDY(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_CMP_IN_DRDY)
#define F_DEBUG_IDMA0_IDMA2IMSG_CMP_IN_DRDY    V_DEBUG_IDMA0_IDMA2IMSG_CMP_IN_DRDY(1U)

#define S_DEBUG_IDMA0_IDMA2IMSG_FIFO_IN_DRDY    10
#define V_DEBUG_IDMA0_IDMA2IMSG_FIFO_IN_DRDY(x) ((x) << S_DEBUG_IDMA0_IDMA2IMSG_FIFO_IN_DRDY)
#define F_DEBUG_IDMA0_IDMA2IMSG_FIFO_IN_DRDY    V_DEBUG_IDMA0_IDMA2IMSG_FIFO_IN_DRDY(1U)

#define S_T6_DEBUG_T_RXAFULL_D    8
#define M_T6_DEBUG_T_RXAFULL_D    0x3U
#define V_T6_DEBUG_T_RXAFULL_D(x) ((x) << S_T6_DEBUG_T_RXAFULL_D)
#define G_T6_DEBUG_T_RXAFULL_D(x) (((x) >> S_T6_DEBUG_T_RXAFULL_D) & M_T6_DEBUG_T_RXAFULL_D)

#define S_T6_DEBUG_PD_WRREQAFULL_D    6
#define M_T6_DEBUG_PD_WRREQAFULL_D    0x3U
#define V_T6_DEBUG_PD_WRREQAFULL_D(x) ((x) << S_T6_DEBUG_PD_WRREQAFULL_D)
#define G_T6_DEBUG_PD_WRREQAFULL_D(x) (((x) >> S_T6_DEBUG_PD_WRREQAFULL_D) & M_T6_DEBUG_PD_WRREQAFULL_D)

#define S_T6_DEBUG_PC_RSPAFULL_D    5
#define V_T6_DEBUG_PC_RSPAFULL_D(x) ((x) << S_T6_DEBUG_PC_RSPAFULL_D)
#define F_T6_DEBUG_PC_RSPAFULL_D    V_T6_DEBUG_PC_RSPAFULL_D(1U)

#define S_T6_DEBUG_PC_REQAFULL_D    4
#define V_T6_DEBUG_PC_REQAFULL_D(x) ((x) << S_T6_DEBUG_PC_REQAFULL_D)
#define F_T6_DEBUG_PC_REQAFULL_D    V_T6_DEBUG_PC_REQAFULL_D(1U)

#define S_T6_DEBUG_CIM_AFULL_D    0
#define V_T6_DEBUG_CIM_AFULL_D(x) ((x) << S_T6_DEBUG_CIM_AFULL_D)
#define F_T6_DEBUG_CIM_AFULL_D    V_T6_DEBUG_CIM_AFULL_D(1U)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_11 0x12ac

#define S_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE    24
#define V_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE    V_DEBUG_FLM_IDMA1_CACHE_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE    23
#define V_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE    V_DEBUG_FLM_IDMA1_CACHE_HDR_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE    22
#define V_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE    V_DEBUG_FLM_IDMA1_CTXT_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE    21
#define V_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE    V_DEBUG_FLM_IDMA1_CTXT_HDR_ACTIVE(1U)

#define S_DEBUG_ST_FLM_IDMA1_CACHE    19
#define M_DEBUG_ST_FLM_IDMA1_CACHE    0x3U
#define V_DEBUG_ST_FLM_IDMA1_CACHE(x) ((x) << S_DEBUG_ST_FLM_IDMA1_CACHE)
#define G_DEBUG_ST_FLM_IDMA1_CACHE(x) (((x) >> S_DEBUG_ST_FLM_IDMA1_CACHE) & M_DEBUG_ST_FLM_IDMA1_CACHE)

#define S_DEBUG_ST_FLM_IDMA1_CTXT    16
#define M_DEBUG_ST_FLM_IDMA1_CTXT    0x7U
#define V_DEBUG_ST_FLM_IDMA1_CTXT(x) ((x) << S_DEBUG_ST_FLM_IDMA1_CTXT)
#define G_DEBUG_ST_FLM_IDMA1_CTXT(x) (((x) >> S_DEBUG_ST_FLM_IDMA1_CTXT) & M_DEBUG_ST_FLM_IDMA1_CTXT)

#define S_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE    8
#define V_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE    V_DEBUG_FLM_IDMA0_CACHE_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE    7
#define V_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE    V_DEBUG_FLM_IDMA0_CACHE_HDR_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE    6
#define V_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE    V_DEBUG_FLM_IDMA0_CTXT_DATA_ACTIVE(1U)

#define S_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE    5
#define V_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE(x) ((x) << S_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE)
#define F_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE    V_DEBUG_FLM_IDMA0_CTXT_HDR_ACTIVE(1U)

#define S_DEBUG_ST_FLM_IDMA0_CACHE    3
#define M_DEBUG_ST_FLM_IDMA0_CACHE    0x3U
#define V_DEBUG_ST_FLM_IDMA0_CACHE(x) ((x) << S_DEBUG_ST_FLM_IDMA0_CACHE)
#define G_DEBUG_ST_FLM_IDMA0_CACHE(x) (((x) >> S_DEBUG_ST_FLM_IDMA0_CACHE) & M_DEBUG_ST_FLM_IDMA0_CACHE)

#define S_DEBUG_ST_FLM_IDMA0_CTXT    0
#define M_DEBUG_ST_FLM_IDMA0_CTXT    0x7U
#define V_DEBUG_ST_FLM_IDMA0_CTXT(x) ((x) << S_DEBUG_ST_FLM_IDMA0_CTXT)
#define G_DEBUG_ST_FLM_IDMA0_CTXT(x) (((x) >> S_DEBUG_ST_FLM_IDMA0_CTXT) & M_DEBUG_ST_FLM_IDMA0_CTXT)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_12 0x12b0

#define S_DEBUG_CPLSW_SOP1_CNT    28
#define M_DEBUG_CPLSW_SOP1_CNT    0xfU
#define V_DEBUG_CPLSW_SOP1_CNT(x) ((x) << S_DEBUG_CPLSW_SOP1_CNT)
#define G_DEBUG_CPLSW_SOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_SOP1_CNT) & M_DEBUG_CPLSW_SOP1_CNT)

#define S_DEBUG_CPLSW_EOP1_CNT    24
#define M_DEBUG_CPLSW_EOP1_CNT    0xfU
#define V_DEBUG_CPLSW_EOP1_CNT(x) ((x) << S_DEBUG_CPLSW_EOP1_CNT)
#define G_DEBUG_CPLSW_EOP1_CNT(x) (((x) >> S_DEBUG_CPLSW_EOP1_CNT) & M_DEBUG_CPLSW_EOP1_CNT)

#define S_DEBUG_CPLSW_SOP0_CNT    20
#define M_DEBUG_CPLSW_SOP0_CNT    0xfU
#define V_DEBUG_CPLSW_SOP0_CNT(x) ((x) << S_DEBUG_CPLSW_SOP0_CNT)
#define G_DEBUG_CPLSW_SOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_SOP0_CNT) & M_DEBUG_CPLSW_SOP0_CNT)

#define S_DEBUG_CPLSW_EOP0_CNT    16
#define M_DEBUG_CPLSW_EOP0_CNT    0xfU
#define V_DEBUG_CPLSW_EOP0_CNT(x) ((x) << S_DEBUG_CPLSW_EOP0_CNT)
#define G_DEBUG_CPLSW_EOP0_CNT(x) (((x) >> S_DEBUG_CPLSW_EOP0_CNT) & M_DEBUG_CPLSW_EOP0_CNT)

#define S_DEBUG_PC_RSP_SOP2_CNT    12
#define M_DEBUG_PC_RSP_SOP2_CNT    0xfU
#define V_DEBUG_PC_RSP_SOP2_CNT(x) ((x) << S_DEBUG_PC_RSP_SOP2_CNT)
#define G_DEBUG_PC_RSP_SOP2_CNT(x) (((x) >> S_DEBUG_PC_RSP_SOP2_CNT) & M_DEBUG_PC_RSP_SOP2_CNT)

#define S_DEBUG_PC_RSP_EOP2_CNT    8
#define M_DEBUG_PC_RSP_EOP2_CNT    0xfU
#define V_DEBUG_PC_RSP_EOP2_CNT(x) ((x) << S_DEBUG_PC_RSP_EOP2_CNT)
#define G_DEBUG_PC_RSP_EOP2_CNT(x) (((x) >> S_DEBUG_PC_RSP_EOP2_CNT) & M_DEBUG_PC_RSP_EOP2_CNT)

#define S_DEBUG_PC_REQ_SOP2_CNT    4
#define M_DEBUG_PC_REQ_SOP2_CNT    0xfU
#define V_DEBUG_PC_REQ_SOP2_CNT(x) ((x) << S_DEBUG_PC_REQ_SOP2_CNT)
#define G_DEBUG_PC_REQ_SOP2_CNT(x) (((x) >> S_DEBUG_PC_REQ_SOP2_CNT) & M_DEBUG_PC_REQ_SOP2_CNT)

#define S_DEBUG_PC_REQ_EOP2_CNT    0
#define M_DEBUG_PC_REQ_EOP2_CNT    0xfU
#define V_DEBUG_PC_REQ_EOP2_CNT(x) ((x) << S_DEBUG_PC_REQ_EOP2_CNT)
#define G_DEBUG_PC_REQ_EOP2_CNT(x) (((x) >> S_DEBUG_PC_REQ_EOP2_CNT) & M_DEBUG_PC_REQ_EOP2_CNT)

#define S_DEBUG_IDMA1_ISHIFT_TX_SIZE    8
#define M_DEBUG_IDMA1_ISHIFT_TX_SIZE    0x7fU
#define V_DEBUG_IDMA1_ISHIFT_TX_SIZE(x) ((x) << S_DEBUG_IDMA1_ISHIFT_TX_SIZE)
#define G_DEBUG_IDMA1_ISHIFT_TX_SIZE(x) (((x) >> S_DEBUG_IDMA1_ISHIFT_TX_SIZE) & M_DEBUG_IDMA1_ISHIFT_TX_SIZE)

#define S_DEBUG_IDMA0_ISHIFT_TX_SIZE    0
#define M_DEBUG_IDMA0_ISHIFT_TX_SIZE    0x7fU
#define V_DEBUG_IDMA0_ISHIFT_TX_SIZE(x) ((x) << S_DEBUG_IDMA0_ISHIFT_TX_SIZE)
#define G_DEBUG_IDMA0_ISHIFT_TX_SIZE(x) (((x) >> S_DEBUG_IDMA0_ISHIFT_TX_SIZE) & M_DEBUG_IDMA0_ISHIFT_TX_SIZE)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_13 0x12b4
#define A_SGE_DEBUG_DATA_HIGH_INDEX_14 0x12b8
#define A_SGE_DEBUG_DATA_HIGH_INDEX_15 0x12bc
#define A_SGE_DEBUG_DATA_LOW_INDEX_0 0x12c0

#define S_DEBUG_ST_IDMA1_FLM_REQ    29
#define M_DEBUG_ST_IDMA1_FLM_REQ    0x7U
#define V_DEBUG_ST_IDMA1_FLM_REQ(x) ((x) << S_DEBUG_ST_IDMA1_FLM_REQ)
#define G_DEBUG_ST_IDMA1_FLM_REQ(x) (((x) >> S_DEBUG_ST_IDMA1_FLM_REQ) & M_DEBUG_ST_IDMA1_FLM_REQ)

#define S_DEBUG_ST_IDMA0_FLM_REQ    26
#define M_DEBUG_ST_IDMA0_FLM_REQ    0x7U
#define V_DEBUG_ST_IDMA0_FLM_REQ(x) ((x) << S_DEBUG_ST_IDMA0_FLM_REQ)
#define G_DEBUG_ST_IDMA0_FLM_REQ(x) (((x) >> S_DEBUG_ST_IDMA0_FLM_REQ) & M_DEBUG_ST_IDMA0_FLM_REQ)

#define S_DEBUG_ST_IMSG_CTXT    23
#define M_DEBUG_ST_IMSG_CTXT    0x7U
#define V_DEBUG_ST_IMSG_CTXT(x) ((x) << S_DEBUG_ST_IMSG_CTXT)
#define G_DEBUG_ST_IMSG_CTXT(x) (((x) >> S_DEBUG_ST_IMSG_CTXT) & M_DEBUG_ST_IMSG_CTXT)

#define S_DEBUG_ST_IMSG    18
#define M_DEBUG_ST_IMSG    0x1fU
#define V_DEBUG_ST_IMSG(x) ((x) << S_DEBUG_ST_IMSG)
#define G_DEBUG_ST_IMSG(x) (((x) >> S_DEBUG_ST_IMSG) & M_DEBUG_ST_IMSG)

#define S_DEBUG_ST_IDMA1_IALN    16
#define M_DEBUG_ST_IDMA1_IALN    0x3U
#define V_DEBUG_ST_IDMA1_IALN(x) ((x) << S_DEBUG_ST_IDMA1_IALN)
#define G_DEBUG_ST_IDMA1_IALN(x) (((x) >> S_DEBUG_ST_IDMA1_IALN) & M_DEBUG_ST_IDMA1_IALN)

#define S_DEBUG_ST_IDMA1_IDMA_SM    9
#define M_DEBUG_ST_IDMA1_IDMA_SM    0x3fU
#define V_DEBUG_ST_IDMA1_IDMA_SM(x) ((x) << S_DEBUG_ST_IDMA1_IDMA_SM)
#define G_DEBUG_ST_IDMA1_IDMA_SM(x) (((x) >> S_DEBUG_ST_IDMA1_IDMA_SM) & M_DEBUG_ST_IDMA1_IDMA_SM)

#define S_DEBUG_ST_IDMA0_IALN    7
#define M_DEBUG_ST_IDMA0_IALN    0x3U
#define V_DEBUG_ST_IDMA0_IALN(x) ((x) << S_DEBUG_ST_IDMA0_IALN)
#define G_DEBUG_ST_IDMA0_IALN(x) (((x) >> S_DEBUG_ST_IDMA0_IALN) & M_DEBUG_ST_IDMA0_IALN)

#define S_DEBUG_ST_IDMA0_IDMA_SM    0
#define M_DEBUG_ST_IDMA0_IDMA_SM    0x3fU
#define V_DEBUG_ST_IDMA0_IDMA_SM(x) ((x) << S_DEBUG_ST_IDMA0_IDMA_SM)
#define G_DEBUG_ST_IDMA0_IDMA_SM(x) (((x) >> S_DEBUG_ST_IDMA0_IDMA_SM) & M_DEBUG_ST_IDMA0_IDMA_SM)

#define S_DEBUG_ST_IDMA1_IDMA2IMSG    15
#define V_DEBUG_ST_IDMA1_IDMA2IMSG(x) ((x) << S_DEBUG_ST_IDMA1_IDMA2IMSG)
#define F_DEBUG_ST_IDMA1_IDMA2IMSG    V_DEBUG_ST_IDMA1_IDMA2IMSG(1U)

#define S_DEBUG_ST_IDMA0_IDMA2IMSG    6
#define V_DEBUG_ST_IDMA0_IDMA2IMSG(x) ((x) << S_DEBUG_ST_IDMA0_IDMA2IMSG)
#define F_DEBUG_ST_IDMA0_IDMA2IMSG    V_DEBUG_ST_IDMA0_IDMA2IMSG(1U)

#define A_SGE_DEBUG_DATA_LOW_INDEX_1 0x12c4

#define S_DEBUG_ITP_EMPTY    12
#define M_DEBUG_ITP_EMPTY    0x3fU
#define V_DEBUG_ITP_EMPTY(x) ((x) << S_DEBUG_ITP_EMPTY)
#define G_DEBUG_ITP_EMPTY(x) (((x) >> S_DEBUG_ITP_EMPTY) & M_DEBUG_ITP_EMPTY)

#define S_DEBUG_ITP_EXPIRED    6
#define M_DEBUG_ITP_EXPIRED    0x3fU
#define V_DEBUG_ITP_EXPIRED(x) ((x) << S_DEBUG_ITP_EXPIRED)
#define G_DEBUG_ITP_EXPIRED(x) (((x) >> S_DEBUG_ITP_EXPIRED) & M_DEBUG_ITP_EXPIRED)

#define S_DEBUG_ITP_PAUSE    5
#define V_DEBUG_ITP_PAUSE(x) ((x) << S_DEBUG_ITP_PAUSE)
#define F_DEBUG_ITP_PAUSE    V_DEBUG_ITP_PAUSE(1U)

#define S_DEBUG_ITP_DEL_DONE    4
#define V_DEBUG_ITP_DEL_DONE(x) ((x) << S_DEBUG_ITP_DEL_DONE)
#define F_DEBUG_ITP_DEL_DONE    V_DEBUG_ITP_DEL_DONE(1U)

#define S_DEBUG_ITP_ADD_DONE    3
#define V_DEBUG_ITP_ADD_DONE(x) ((x) << S_DEBUG_ITP_ADD_DONE)
#define F_DEBUG_ITP_ADD_DONE    V_DEBUG_ITP_ADD_DONE(1U)

#define S_DEBUG_ITP_EVR_STATE    0
#define M_DEBUG_ITP_EVR_STATE    0x7U
#define V_DEBUG_ITP_EVR_STATE(x) ((x) << S_DEBUG_ITP_EVR_STATE)
#define G_DEBUG_ITP_EVR_STATE(x) (((x) >> S_DEBUG_ITP_EVR_STATE) & M_DEBUG_ITP_EVR_STATE)

#define A_SGE_DEBUG_DATA_LOW_INDEX_2 0x12c8

#define S_DEBUG_ST_DBP_THREAD2_CIMFL    25
#define M_DEBUG_ST_DBP_THREAD2_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD2_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD2_CIMFL)
#define G_DEBUG_ST_DBP_THREAD2_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD2_CIMFL) & M_DEBUG_ST_DBP_THREAD2_CIMFL)

#define S_DEBUG_ST_DBP_THREAD2_MAIN    20
#define M_DEBUG_ST_DBP_THREAD2_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD2_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD2_MAIN)
#define G_DEBUG_ST_DBP_THREAD2_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD2_MAIN) & M_DEBUG_ST_DBP_THREAD2_MAIN)

#define S_DEBUG_ST_DBP_THREAD1_CIMFL    15
#define M_DEBUG_ST_DBP_THREAD1_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD1_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD1_CIMFL)
#define G_DEBUG_ST_DBP_THREAD1_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD1_CIMFL) & M_DEBUG_ST_DBP_THREAD1_CIMFL)

#define S_DEBUG_ST_DBP_THREAD1_MAIN    10
#define M_DEBUG_ST_DBP_THREAD1_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD1_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD1_MAIN)
#define G_DEBUG_ST_DBP_THREAD1_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD1_MAIN) & M_DEBUG_ST_DBP_THREAD1_MAIN)

#define S_DEBUG_ST_DBP_THREAD0_CIMFL    5
#define M_DEBUG_ST_DBP_THREAD0_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD0_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD0_CIMFL)
#define G_DEBUG_ST_DBP_THREAD0_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD0_CIMFL) & M_DEBUG_ST_DBP_THREAD0_CIMFL)

#define S_DEBUG_ST_DBP_THREAD0_MAIN    0
#define M_DEBUG_ST_DBP_THREAD0_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD0_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD0_MAIN)
#define G_DEBUG_ST_DBP_THREAD0_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD0_MAIN) & M_DEBUG_ST_DBP_THREAD0_MAIN)

#define S_T6_DEBUG_ST_DBP_UPCP_MAIN    14
#define M_T6_DEBUG_ST_DBP_UPCP_MAIN    0x7U
#define V_T6_DEBUG_ST_DBP_UPCP_MAIN(x) ((x) << S_T6_DEBUG_ST_DBP_UPCP_MAIN)
#define G_T6_DEBUG_ST_DBP_UPCP_MAIN(x) (((x) >> S_T6_DEBUG_ST_DBP_UPCP_MAIN) & M_T6_DEBUG_ST_DBP_UPCP_MAIN)

#define A_SGE_DEBUG_DATA_LOW_INDEX_3 0x12cc

#define S_DEBUG_ST_DBP_UPCP_MAIN    14
#define M_DEBUG_ST_DBP_UPCP_MAIN    0x1fU
#define V_DEBUG_ST_DBP_UPCP_MAIN(x) ((x) << S_DEBUG_ST_DBP_UPCP_MAIN)
#define G_DEBUG_ST_DBP_UPCP_MAIN(x) (((x) >> S_DEBUG_ST_DBP_UPCP_MAIN) & M_DEBUG_ST_DBP_UPCP_MAIN)

#define S_DEBUG_ST_DBP_DBFIFO_MAIN    13
#define V_DEBUG_ST_DBP_DBFIFO_MAIN(x) ((x) << S_DEBUG_ST_DBP_DBFIFO_MAIN)
#define F_DEBUG_ST_DBP_DBFIFO_MAIN    V_DEBUG_ST_DBP_DBFIFO_MAIN(1U)

#define S_DEBUG_ST_DBP_CTXT    10
#define M_DEBUG_ST_DBP_CTXT    0x7U
#define V_DEBUG_ST_DBP_CTXT(x) ((x) << S_DEBUG_ST_DBP_CTXT)
#define G_DEBUG_ST_DBP_CTXT(x) (((x) >> S_DEBUG_ST_DBP_CTXT) & M_DEBUG_ST_DBP_CTXT)

#define S_DEBUG_ST_DBP_THREAD3_CIMFL    5
#define M_DEBUG_ST_DBP_THREAD3_CIMFL    0x1fU
#define V_DEBUG_ST_DBP_THREAD3_CIMFL(x) ((x) << S_DEBUG_ST_DBP_THREAD3_CIMFL)
#define G_DEBUG_ST_DBP_THREAD3_CIMFL(x) (((x) >> S_DEBUG_ST_DBP_THREAD3_CIMFL) & M_DEBUG_ST_DBP_THREAD3_CIMFL)

#define S_DEBUG_ST_DBP_THREAD3_MAIN    0
#define M_DEBUG_ST_DBP_THREAD3_MAIN    0x1fU
#define V_DEBUG_ST_DBP_THREAD3_MAIN(x) ((x) << S_DEBUG_ST_DBP_THREAD3_MAIN)
#define G_DEBUG_ST_DBP_THREAD3_MAIN(x) (((x) >> S_DEBUG_ST_DBP_THREAD3_MAIN) & M_DEBUG_ST_DBP_THREAD3_MAIN)

#define A_SGE_DEBUG_DATA_LOW_INDEX_4 0x12d0

#define S_DEBUG_ST_EDMA3_ALIGN_SUB    29
#define M_DEBUG_ST_EDMA3_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA3_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA3_ALIGN_SUB)
#define G_DEBUG_ST_EDMA3_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA3_ALIGN_SUB) & M_DEBUG_ST_EDMA3_ALIGN_SUB)

#define S_DEBUG_ST_EDMA3_ALIGN    27
#define M_DEBUG_ST_EDMA3_ALIGN    0x3U
#define V_DEBUG_ST_EDMA3_ALIGN(x) ((x) << S_DEBUG_ST_EDMA3_ALIGN)
#define G_DEBUG_ST_EDMA3_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA3_ALIGN) & M_DEBUG_ST_EDMA3_ALIGN)

#define S_DEBUG_ST_EDMA3_REQ    24
#define M_DEBUG_ST_EDMA3_REQ    0x7U
#define V_DEBUG_ST_EDMA3_REQ(x) ((x) << S_DEBUG_ST_EDMA3_REQ)
#define G_DEBUG_ST_EDMA3_REQ(x) (((x) >> S_DEBUG_ST_EDMA3_REQ) & M_DEBUG_ST_EDMA3_REQ)

#define S_DEBUG_ST_EDMA2_ALIGN_SUB    21
#define M_DEBUG_ST_EDMA2_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA2_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA2_ALIGN_SUB)
#define G_DEBUG_ST_EDMA2_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA2_ALIGN_SUB) & M_DEBUG_ST_EDMA2_ALIGN_SUB)

#define S_DEBUG_ST_EDMA2_ALIGN    19
#define M_DEBUG_ST_EDMA2_ALIGN    0x3U
#define V_DEBUG_ST_EDMA2_ALIGN(x) ((x) << S_DEBUG_ST_EDMA2_ALIGN)
#define G_DEBUG_ST_EDMA2_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA2_ALIGN) & M_DEBUG_ST_EDMA2_ALIGN)

#define S_DEBUG_ST_EDMA2_REQ    16
#define M_DEBUG_ST_EDMA2_REQ    0x7U
#define V_DEBUG_ST_EDMA2_REQ(x) ((x) << S_DEBUG_ST_EDMA2_REQ)
#define G_DEBUG_ST_EDMA2_REQ(x) (((x) >> S_DEBUG_ST_EDMA2_REQ) & M_DEBUG_ST_EDMA2_REQ)

#define S_DEBUG_ST_EDMA1_ALIGN_SUB    13
#define M_DEBUG_ST_EDMA1_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA1_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA1_ALIGN_SUB)
#define G_DEBUG_ST_EDMA1_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA1_ALIGN_SUB) & M_DEBUG_ST_EDMA1_ALIGN_SUB)

#define S_DEBUG_ST_EDMA1_ALIGN    11
#define M_DEBUG_ST_EDMA1_ALIGN    0x3U
#define V_DEBUG_ST_EDMA1_ALIGN(x) ((x) << S_DEBUG_ST_EDMA1_ALIGN)
#define G_DEBUG_ST_EDMA1_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA1_ALIGN) & M_DEBUG_ST_EDMA1_ALIGN)

#define S_DEBUG_ST_EDMA1_REQ    8
#define M_DEBUG_ST_EDMA1_REQ    0x7U
#define V_DEBUG_ST_EDMA1_REQ(x) ((x) << S_DEBUG_ST_EDMA1_REQ)
#define G_DEBUG_ST_EDMA1_REQ(x) (((x) >> S_DEBUG_ST_EDMA1_REQ) & M_DEBUG_ST_EDMA1_REQ)

#define S_DEBUG_ST_EDMA0_ALIGN_SUB    5
#define M_DEBUG_ST_EDMA0_ALIGN_SUB    0x7U
#define V_DEBUG_ST_EDMA0_ALIGN_SUB(x) ((x) << S_DEBUG_ST_EDMA0_ALIGN_SUB)
#define G_DEBUG_ST_EDMA0_ALIGN_SUB(x) (((x) >> S_DEBUG_ST_EDMA0_ALIGN_SUB) & M_DEBUG_ST_EDMA0_ALIGN_SUB)

#define S_DEBUG_ST_EDMA0_ALIGN    3
#define M_DEBUG_ST_EDMA0_ALIGN    0x3U
#define V_DEBUG_ST_EDMA0_ALIGN(x) ((x) << S_DEBUG_ST_EDMA0_ALIGN)
#define G_DEBUG_ST_EDMA0_ALIGN(x) (((x) >> S_DEBUG_ST_EDMA0_ALIGN) & M_DEBUG_ST_EDMA0_ALIGN)

#define S_DEBUG_ST_EDMA0_REQ    0
#define M_DEBUG_ST_EDMA0_REQ    0x7U
#define V_DEBUG_ST_EDMA0_REQ(x) ((x) << S_DEBUG_ST_EDMA0_REQ)
#define G_DEBUG_ST_EDMA0_REQ(x) (((x) >> S_DEBUG_ST_EDMA0_REQ) & M_DEBUG_ST_EDMA0_REQ)

#define A_SGE_DEBUG_DATA_LOW_INDEX_5 0x12d4

#define S_DEBUG_ST_FLM_DBPTR    30
#define M_DEBUG_ST_FLM_DBPTR    0x3U
#define V_DEBUG_ST_FLM_DBPTR(x) ((x) << S_DEBUG_ST_FLM_DBPTR)
#define G_DEBUG_ST_FLM_DBPTR(x) (((x) >> S_DEBUG_ST_FLM_DBPTR) & M_DEBUG_ST_FLM_DBPTR)

#define S_DEBUG_FLM_CACHE_LOCKED_COUNT    23
#define M_DEBUG_FLM_CACHE_LOCKED_COUNT    0x7fU
#define V_DEBUG_FLM_CACHE_LOCKED_COUNT(x) ((x) << S_DEBUG_FLM_CACHE_LOCKED_COUNT)
#define G_DEBUG_FLM_CACHE_LOCKED_COUNT(x) (((x) >> S_DEBUG_FLM_CACHE_LOCKED_COUNT) & M_DEBUG_FLM_CACHE_LOCKED_COUNT)

#define S_DEBUG_FLM_CACHE_AGENT    20
#define M_DEBUG_FLM_CACHE_AGENT    0x7U
#define V_DEBUG_FLM_CACHE_AGENT(x) ((x) << S_DEBUG_FLM_CACHE_AGENT)
#define G_DEBUG_FLM_CACHE_AGENT(x) (((x) >> S_DEBUG_FLM_CACHE_AGENT) & M_DEBUG_FLM_CACHE_AGENT)

#define S_DEBUG_ST_FLM_CACHE    16
#define M_DEBUG_ST_FLM_CACHE    0xfU
#define V_DEBUG_ST_FLM_CACHE(x) ((x) << S_DEBUG_ST_FLM_CACHE)
#define G_DEBUG_ST_FLM_CACHE(x) (((x) >> S_DEBUG_ST_FLM_CACHE) & M_DEBUG_ST_FLM_CACHE)

#define S_DEBUG_FLM_DBPTR_CIDX_STALL    12
#define V_DEBUG_FLM_DBPTR_CIDX_STALL(x) ((x) << S_DEBUG_FLM_DBPTR_CIDX_STALL)
#define F_DEBUG_FLM_DBPTR_CIDX_STALL    V_DEBUG_FLM_DBPTR_CIDX_STALL(1U)

#define S_DEBUG_FLM_DBPTR_QID    0
#define M_DEBUG_FLM_DBPTR_QID    0xfffU
#define V_DEBUG_FLM_DBPTR_QID(x) ((x) << S_DEBUG_FLM_DBPTR_QID)
#define G_DEBUG_FLM_DBPTR_QID(x) (((x) >> S_DEBUG_FLM_DBPTR_QID) & M_DEBUG_FLM_DBPTR_QID)

#define A_SGE_DEBUG0_DBP_THREAD 0x12d4

#define S_THREAD_ST_MAIN    25
#define M_THREAD_ST_MAIN    0x3fU
#define V_THREAD_ST_MAIN(x) ((x) << S_THREAD_ST_MAIN)
#define G_THREAD_ST_MAIN(x) (((x) >> S_THREAD_ST_MAIN) & M_THREAD_ST_MAIN)

#define S_THREAD_ST_CIMFL    21
#define M_THREAD_ST_CIMFL    0xfU
#define V_THREAD_ST_CIMFL(x) ((x) << S_THREAD_ST_CIMFL)
#define G_THREAD_ST_CIMFL(x) (((x) >> S_THREAD_ST_CIMFL) & M_THREAD_ST_CIMFL)

#define S_THREAD_CMDOP    17
#define M_THREAD_CMDOP    0xfU
#define V_THREAD_CMDOP(x) ((x) << S_THREAD_CMDOP)
#define G_THREAD_CMDOP(x) (((x) >> S_THREAD_CMDOP) & M_THREAD_CMDOP)

#define S_THREAD_QID    0
#define M_THREAD_QID    0x1ffffU
#define V_THREAD_QID(x) ((x) << S_THREAD_QID)
#define G_THREAD_QID(x) (((x) >> S_THREAD_QID) & M_THREAD_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_6 0x12d8

#define S_DEBUG_DBP_THREAD0_QID    0
#define M_DEBUG_DBP_THREAD0_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD0_QID(x) ((x) << S_DEBUG_DBP_THREAD0_QID)
#define G_DEBUG_DBP_THREAD0_QID(x) (((x) >> S_DEBUG_DBP_THREAD0_QID) & M_DEBUG_DBP_THREAD0_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_7 0x12dc

#define S_DEBUG_DBP_THREAD1_QID    0
#define M_DEBUG_DBP_THREAD1_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD1_QID(x) ((x) << S_DEBUG_DBP_THREAD1_QID)
#define G_DEBUG_DBP_THREAD1_QID(x) (((x) >> S_DEBUG_DBP_THREAD1_QID) & M_DEBUG_DBP_THREAD1_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_8 0x12e0

#define S_DEBUG_DBP_THREAD2_QID    0
#define M_DEBUG_DBP_THREAD2_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD2_QID(x) ((x) << S_DEBUG_DBP_THREAD2_QID)
#define G_DEBUG_DBP_THREAD2_QID(x) (((x) >> S_DEBUG_DBP_THREAD2_QID) & M_DEBUG_DBP_THREAD2_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_9 0x12e4

#define S_DEBUG_DBP_THREAD3_QID    0
#define M_DEBUG_DBP_THREAD3_QID    0x1ffffU
#define V_DEBUG_DBP_THREAD3_QID(x) ((x) << S_DEBUG_DBP_THREAD3_QID)
#define G_DEBUG_DBP_THREAD3_QID(x) (((x) >> S_DEBUG_DBP_THREAD3_QID) & M_DEBUG_DBP_THREAD3_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_10 0x12e8

#define S_DEBUG_IMSG_CPL    16
#define M_DEBUG_IMSG_CPL    0xffU
#define V_DEBUG_IMSG_CPL(x) ((x) << S_DEBUG_IMSG_CPL)
#define G_DEBUG_IMSG_CPL(x) (((x) >> S_DEBUG_IMSG_CPL) & M_DEBUG_IMSG_CPL)

#define S_DEBUG_IMSG_QID    0
#define M_DEBUG_IMSG_QID    0xffffU
#define V_DEBUG_IMSG_QID(x) ((x) << S_DEBUG_IMSG_QID)
#define G_DEBUG_IMSG_QID(x) (((x) >> S_DEBUG_IMSG_QID) & M_DEBUG_IMSG_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_11 0x12ec

#define S_DEBUG_IDMA1_QID    16
#define M_DEBUG_IDMA1_QID    0xffffU
#define V_DEBUG_IDMA1_QID(x) ((x) << S_DEBUG_IDMA1_QID)
#define G_DEBUG_IDMA1_QID(x) (((x) >> S_DEBUG_IDMA1_QID) & M_DEBUG_IDMA1_QID)

#define S_DEBUG_IDMA0_QID    0
#define M_DEBUG_IDMA0_QID    0xffffU
#define V_DEBUG_IDMA0_QID(x) ((x) << S_DEBUG_IDMA0_QID)
#define G_DEBUG_IDMA0_QID(x) (((x) >> S_DEBUG_IDMA0_QID) & M_DEBUG_IDMA0_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_12 0x12f0

#define S_DEBUG_IDMA1_FLM_REQ_QID    16
#define M_DEBUG_IDMA1_FLM_REQ_QID    0xffffU
#define V_DEBUG_IDMA1_FLM_REQ_QID(x) ((x) << S_DEBUG_IDMA1_FLM_REQ_QID)
#define G_DEBUG_IDMA1_FLM_REQ_QID(x) (((x) >> S_DEBUG_IDMA1_FLM_REQ_QID) & M_DEBUG_IDMA1_FLM_REQ_QID)

#define S_DEBUG_IDMA0_FLM_REQ_QID    0
#define M_DEBUG_IDMA0_FLM_REQ_QID    0xffffU
#define V_DEBUG_IDMA0_FLM_REQ_QID(x) ((x) << S_DEBUG_IDMA0_FLM_REQ_QID)
#define G_DEBUG_IDMA0_FLM_REQ_QID(x) (((x) >> S_DEBUG_IDMA0_FLM_REQ_QID) & M_DEBUG_IDMA0_FLM_REQ_QID)

#define A_SGE_DEBUG_DATA_LOW_INDEX_13 0x12f4
#define A_SGE_DEBUG_DATA_LOW_INDEX_14 0x12f8
#define A_SGE_DEBUG_DATA_LOW_INDEX_15 0x12fc
#define A_SGE_QUEUE_BASE_MAP_HIGH 0x1300

#define S_EGRESS_LOG2SIZE    27
#define M_EGRESS_LOG2SIZE    0x1fU
#define V_EGRESS_LOG2SIZE(x) ((x) << S_EGRESS_LOG2SIZE)
#define G_EGRESS_LOG2SIZE(x) (((x) >> S_EGRESS_LOG2SIZE) & M_EGRESS_LOG2SIZE)

#define S_EGRESS_BASE    10
#define M_EGRESS_BASE    0x1ffffU
#define V_EGRESS_BASE(x) ((x) << S_EGRESS_BASE)
#define G_EGRESS_BASE(x) (((x) >> S_EGRESS_BASE) & M_EGRESS_BASE)

#define S_INGRESS2_LOG2SIZE    5
#define M_INGRESS2_LOG2SIZE    0x1fU
#define V_INGRESS2_LOG2SIZE(x) ((x) << S_INGRESS2_LOG2SIZE)
#define G_INGRESS2_LOG2SIZE(x) (((x) >> S_INGRESS2_LOG2SIZE) & M_INGRESS2_LOG2SIZE)

#define S_INGRESS1_LOG2SIZE    0
#define M_INGRESS1_LOG2SIZE    0x1fU
#define V_INGRESS1_LOG2SIZE(x) ((x) << S_INGRESS1_LOG2SIZE)
#define G_INGRESS1_LOG2SIZE(x) (((x) >> S_INGRESS1_LOG2SIZE) & M_INGRESS1_LOG2SIZE)

#define S_EGRESS_SIZE    27
#define M_EGRESS_SIZE    0x1fU
#define V_EGRESS_SIZE(x) ((x) << S_EGRESS_SIZE)
#define G_EGRESS_SIZE(x) (((x) >> S_EGRESS_SIZE) & M_EGRESS_SIZE)

#define S_INGRESS2_SIZE    5
#define M_INGRESS2_SIZE    0x1fU
#define V_INGRESS2_SIZE(x) ((x) << S_INGRESS2_SIZE)
#define G_INGRESS2_SIZE(x) (((x) >> S_INGRESS2_SIZE) & M_INGRESS2_SIZE)

#define S_INGRESS1_SIZE    0
#define M_INGRESS1_SIZE    0x1fU
#define V_INGRESS1_SIZE(x) ((x) << S_INGRESS1_SIZE)
#define G_INGRESS1_SIZE(x) (((x) >> S_INGRESS1_SIZE) & M_INGRESS1_SIZE)

#define A_SGE_WC_EGRS_BAR2_OFF_PF 0x1300

#define S_PFIQSPERPAGE    28
#define M_PFIQSPERPAGE    0xfU
#define V_PFIQSPERPAGE(x) ((x) << S_PFIQSPERPAGE)
#define G_PFIQSPERPAGE(x) (((x) >> S_PFIQSPERPAGE) & M_PFIQSPERPAGE)

#define S_PFEQSPERPAGE    24
#define M_PFEQSPERPAGE    0xfU
#define V_PFEQSPERPAGE(x) ((x) << S_PFEQSPERPAGE)
#define G_PFEQSPERPAGE(x) (((x) >> S_PFEQSPERPAGE) & M_PFEQSPERPAGE)

#define S_PFWCQSPERPAGE    20
#define M_PFWCQSPERPAGE    0xfU
#define V_PFWCQSPERPAGE(x) ((x) << S_PFWCQSPERPAGE)
#define G_PFWCQSPERPAGE(x) (((x) >> S_PFWCQSPERPAGE) & M_PFWCQSPERPAGE)

#define S_PFWCOFFEN    19
#define V_PFWCOFFEN(x) ((x) << S_PFWCOFFEN)
#define F_PFWCOFFEN    V_PFWCOFFEN(1U)

#define S_PFMAXWCSIZE    17
#define M_PFMAXWCSIZE    0x3U
#define V_PFMAXWCSIZE(x) ((x) << S_PFMAXWCSIZE)
#define G_PFMAXWCSIZE(x) (((x) >> S_PFMAXWCSIZE) & M_PFMAXWCSIZE)

#define S_PFWCOFFSET    0
#define M_PFWCOFFSET    0x1ffffU
#define V_PFWCOFFSET(x) ((x) << S_PFWCOFFSET)
#define G_PFWCOFFSET(x) (((x) >> S_PFWCOFFSET) & M_PFWCOFFSET)

#define A_SGE_QUEUE_BASE_MAP_LOW 0x1304

#define S_INGRESS2_BASE    16
#define M_INGRESS2_BASE    0xffffU
#define V_INGRESS2_BASE(x) ((x) << S_INGRESS2_BASE)
#define G_INGRESS2_BASE(x) (((x) >> S_INGRESS2_BASE) & M_INGRESS2_BASE)

#define S_INGRESS1_BASE    0
#define M_INGRESS1_BASE    0xffffU
#define V_INGRESS1_BASE(x) ((x) << S_INGRESS1_BASE)
#define G_INGRESS1_BASE(x) (((x) >> S_INGRESS1_BASE) & M_INGRESS1_BASE)

#define A_SGE_WC_EGRS_BAR2_OFF_VF 0x1320

#define S_VFIQSPERPAGE    28
#define M_VFIQSPERPAGE    0xfU
#define V_VFIQSPERPAGE(x) ((x) << S_VFIQSPERPAGE)
#define G_VFIQSPERPAGE(x) (((x) >> S_VFIQSPERPAGE) & M_VFIQSPERPAGE)

#define S_VFEQSPERPAGE    24
#define M_VFEQSPERPAGE    0xfU
#define V_VFEQSPERPAGE(x) ((x) << S_VFEQSPERPAGE)
#define G_VFEQSPERPAGE(x) (((x) >> S_VFEQSPERPAGE) & M_VFEQSPERPAGE)

#define S_VFWCQSPERPAGE    20
#define M_VFWCQSPERPAGE    0xfU
#define V_VFWCQSPERPAGE(x) ((x) << S_VFWCQSPERPAGE)
#define G_VFWCQSPERPAGE(x) (((x) >> S_VFWCQSPERPAGE) & M_VFWCQSPERPAGE)

#define S_VFWCOFFEN    19
#define V_VFWCOFFEN(x) ((x) << S_VFWCOFFEN)
#define F_VFWCOFFEN    V_VFWCOFFEN(1U)

#define S_VFMAXWCSIZE    17
#define M_VFMAXWCSIZE    0x3U
#define V_VFMAXWCSIZE(x) ((x) << S_VFMAXWCSIZE)
#define G_VFMAXWCSIZE(x) (((x) >> S_VFMAXWCSIZE) & M_VFMAXWCSIZE)

#define S_VFWCOFFSET    0
#define M_VFWCOFFSET    0x1ffffU
#define V_VFWCOFFSET(x) ((x) << S_VFWCOFFSET)
#define G_VFWCOFFSET(x) (((x) >> S_VFWCOFFSET) & M_VFWCOFFSET)

#define A_SGE_DEBUG_DATA_HIGH_INDEX_17 0x1340
#define A_SGE_DEBUG_DATA_HIGH_INDEX_18 0x1344
#define A_SGE_DEBUG_DATA_HIGH_INDEX_19 0x1348
#define A_SGE_DEBUG_DATA_HIGH_INDEX_20 0x134c
#define A_SGE_DEBUG_DATA_HIGH_INDEX_21 0x1350
#define A_SGE_DEBUG_DATA_LOW_INDEX_16 0x1354
#define A_SGE_DEBUG_DATA_LOW_INDEX_17 0x1358
#define A_SGE_DEBUG_DATA_LOW_INDEX_18 0x135c
#define A_SGE_INT_CAUSE7 0x1360

#define S_HINT_FIFO_FULL    25
#define V_HINT_FIFO_FULL(x) ((x) << S_HINT_FIFO_FULL)
#define F_HINT_FIFO_FULL    V_HINT_FIFO_FULL(1U)

#define S_CERR_HINT_DELAY_FIFO    24
#define V_CERR_HINT_DELAY_FIFO(x) ((x) << S_CERR_HINT_DELAY_FIFO)
#define F_CERR_HINT_DELAY_FIFO    V_CERR_HINT_DELAY_FIFO(1U)

#define S_COAL_TIMER_FIFO_PERR    23
#define V_COAL_TIMER_FIFO_PERR(x) ((x) << S_COAL_TIMER_FIFO_PERR)
#define F_COAL_TIMER_FIFO_PERR    V_COAL_TIMER_FIFO_PERR(1U)

#define S_CMP_FIFO_PERR    22
#define V_CMP_FIFO_PERR(x) ((x) << S_CMP_FIFO_PERR)
#define F_CMP_FIFO_PERR    V_CMP_FIFO_PERR(1U)

#define S_SGE_IPP_FIFO_CERR    21
#define V_SGE_IPP_FIFO_CERR(x) ((x) << S_SGE_IPP_FIFO_CERR)
#define F_SGE_IPP_FIFO_CERR    V_SGE_IPP_FIFO_CERR(1U)

#define S_CERR_ING_CTXT_CACHE    20
#define V_CERR_ING_CTXT_CACHE(x) ((x) << S_CERR_ING_CTXT_CACHE)
#define F_CERR_ING_CTXT_CACHE    V_CERR_ING_CTXT_CACHE(1U)

#define S_IMSG_CNTX_PERR    19
#define V_IMSG_CNTX_PERR(x) ((x) << S_IMSG_CNTX_PERR)
#define F_IMSG_CNTX_PERR    V_IMSG_CNTX_PERR(1U)

#define S_PD_FIFO_PERR    18
#define V_PD_FIFO_PERR(x) ((x) << S_PD_FIFO_PERR)
#define F_PD_FIFO_PERR    V_PD_FIFO_PERR(1U)

#define S_IMSG_512_FIFO_PERR    17
#define V_IMSG_512_FIFO_PERR(x) ((x) << S_IMSG_512_FIFO_PERR)
#define F_IMSG_512_FIFO_PERR    V_IMSG_512_FIFO_PERR(1U)

#define S_CPLSW_FIFO_PERR    16
#define V_CPLSW_FIFO_PERR(x) ((x) << S_CPLSW_FIFO_PERR)
#define F_CPLSW_FIFO_PERR    V_CPLSW_FIFO_PERR(1U)

#define S_IMSG_FIFO_PERR    15
#define V_IMSG_FIFO_PERR(x) ((x) << S_IMSG_FIFO_PERR)
#define F_IMSG_FIFO_PERR    V_IMSG_FIFO_PERR(1U)

#define S_CERR_ITP_EVR    14
#define V_CERR_ITP_EVR(x) ((x) << S_CERR_ITP_EVR)
#define F_CERR_ITP_EVR    V_CERR_ITP_EVR(1U)

#define S_CERR_CONM_SRAM    13
#define V_CERR_CONM_SRAM(x) ((x) << S_CERR_CONM_SRAM)
#define F_CERR_CONM_SRAM    V_CERR_CONM_SRAM(1U)

#define S_CERR_EGR_CTXT_CACHE    12
#define V_CERR_EGR_CTXT_CACHE(x) ((x) << S_CERR_EGR_CTXT_CACHE)
#define F_CERR_EGR_CTXT_CACHE    V_CERR_EGR_CTXT_CACHE(1U)

#define S_CERR_FLM_CNTXMEM    11
#define V_CERR_FLM_CNTXMEM(x) ((x) << S_CERR_FLM_CNTXMEM)
#define F_CERR_FLM_CNTXMEM    V_CERR_FLM_CNTXMEM(1U)

#define S_CERR_FUNC_QBASE    10
#define V_CERR_FUNC_QBASE(x) ((x) << S_CERR_FUNC_QBASE)
#define F_CERR_FUNC_QBASE    V_CERR_FUNC_QBASE(1U)

#define S_IMSG_CNTX_CERR    9
#define V_IMSG_CNTX_CERR(x) ((x) << S_IMSG_CNTX_CERR)
#define F_IMSG_CNTX_CERR    V_IMSG_CNTX_CERR(1U)

#define S_PD_FIFO_CERR    8
#define V_PD_FIFO_CERR(x) ((x) << S_PD_FIFO_CERR)
#define F_PD_FIFO_CERR    V_PD_FIFO_CERR(1U)

#define S_IMSG_512_FIFO_CERR    7
#define V_IMSG_512_FIFO_CERR(x) ((x) << S_IMSG_512_FIFO_CERR)
#define F_IMSG_512_FIFO_CERR    V_IMSG_512_FIFO_CERR(1U)

#define S_CPLSW_FIFO_CERR    6
#define V_CPLSW_FIFO_CERR(x) ((x) << S_CPLSW_FIFO_CERR)
#define F_CPLSW_FIFO_CERR    V_CPLSW_FIFO_CERR(1U)

#define S_IMSG_FIFO_CERR    5
#define V_IMSG_FIFO_CERR(x) ((x) << S_IMSG_FIFO_CERR)
#define F_IMSG_FIFO_CERR    V_IMSG_FIFO_CERR(1U)

#define S_CERR_HEADERSPLIT_FIFO3    4
#define V_CERR_HEADERSPLIT_FIFO3(x) ((x) << S_CERR_HEADERSPLIT_FIFO3)
#define F_CERR_HEADERSPLIT_FIFO3    V_CERR_HEADERSPLIT_FIFO3(1U)

#define S_CERR_HEADERSPLIT_FIFO2    3
#define V_CERR_HEADERSPLIT_FIFO2(x) ((x) << S_CERR_HEADERSPLIT_FIFO2)
#define F_CERR_HEADERSPLIT_FIFO2    V_CERR_HEADERSPLIT_FIFO2(1U)

#define S_CERR_HEADERSPLIT_FIFO1    2
#define V_CERR_HEADERSPLIT_FIFO1(x) ((x) << S_CERR_HEADERSPLIT_FIFO1)
#define F_CERR_HEADERSPLIT_FIFO1    V_CERR_HEADERSPLIT_FIFO1(1U)

#define S_CERR_HEADERSPLIT_FIFO0    1
#define V_CERR_HEADERSPLIT_FIFO0(x) ((x) << S_CERR_HEADERSPLIT_FIFO0)
#define F_CERR_HEADERSPLIT_FIFO0    V_CERR_HEADERSPLIT_FIFO0(1U)

#define S_CERR_FLM_L1CACHE    0
#define V_CERR_FLM_L1CACHE(x) ((x) << S_CERR_FLM_L1CACHE)
#define F_CERR_FLM_L1CACHE    V_CERR_FLM_L1CACHE(1U)

#define A_SGE_INT_ENABLE7 0x1364
#define A_SGE_PERR_ENABLE7 0x1368
#define A_SGE_ING_COMP_COAL_CFG 0x1700

#define S_USE_PTP_TIMER    27
#define V_USE_PTP_TIMER(x) ((x) << S_USE_PTP_TIMER)
#define F_USE_PTP_TIMER    V_USE_PTP_TIMER(1U)

#define S_IMSG_SET_OFLOW_ALL_ENTRIES_43060    26
#define V_IMSG_SET_OFLOW_ALL_ENTRIES_43060(x) ((x) << S_IMSG_SET_OFLOW_ALL_ENTRIES_43060)
#define F_IMSG_SET_OFLOW_ALL_ENTRIES_43060    V_IMSG_SET_OFLOW_ALL_ENTRIES_43060(1U)

#define S_IMSG_STUCK_INDIRECT_QUEUE_42907    25
#define V_IMSG_STUCK_INDIRECT_QUEUE_42907(x) ((x) << S_IMSG_STUCK_INDIRECT_QUEUE_42907)
#define F_IMSG_STUCK_INDIRECT_QUEUE_42907    V_IMSG_STUCK_INDIRECT_QUEUE_42907(1U)

#define S_COMP_COAL_PIDX_INCR    24
#define V_COMP_COAL_PIDX_INCR(x) ((x) << S_COMP_COAL_PIDX_INCR)
#define F_COMP_COAL_PIDX_INCR    V_COMP_COAL_PIDX_INCR(1U)

#define S_COMP_COAL_TIMER_CNT    16
#define M_COMP_COAL_TIMER_CNT    0xffU
#define V_COMP_COAL_TIMER_CNT(x) ((x) << S_COMP_COAL_TIMER_CNT)
#define G_COMP_COAL_TIMER_CNT(x) (((x) >> S_COMP_COAL_TIMER_CNT) & M_COMP_COAL_TIMER_CNT)

#define S_COMP_COAL_CNTR_TH    8
#define M_COMP_COAL_CNTR_TH    0xffU
#define V_COMP_COAL_CNTR_TH(x) ((x) << S_COMP_COAL_CNTR_TH)
#define G_COMP_COAL_CNTR_TH(x) (((x) >> S_COMP_COAL_CNTR_TH) & M_COMP_COAL_CNTR_TH)

#define S_COMP_COAL_OPCODE    0
#define M_COMP_COAL_OPCODE    0xffU
#define V_COMP_COAL_OPCODE(x) ((x) << S_COMP_COAL_OPCODE)
#define G_COMP_COAL_OPCODE(x) (((x) >> S_COMP_COAL_OPCODE) & M_COMP_COAL_OPCODE)

#define A_SGE_ING_IMSG_DBG 0x1704

#define S_STUCK_CTR_TH    1
#define M_STUCK_CTR_TH    0xffU
#define V_STUCK_CTR_TH(x) ((x) << S_STUCK_CTR_TH)
#define G_STUCK_CTR_TH(x) (((x) >> S_STUCK_CTR_TH) & M_STUCK_CTR_TH)

#define S_STUCK_INT_EN    0
#define V_STUCK_INT_EN(x) ((x) << S_STUCK_INT_EN)
#define F_STUCK_INT_EN    V_STUCK_INT_EN(1U)

#define A_SGE_ING_IMSG_RSP0_DBG 0x1708

#define S_IDMA1_QID    16
#define M_IDMA1_QID    0xffffU
#define V_IDMA1_QID(x) ((x) << S_IDMA1_QID)
#define G_IDMA1_QID(x) (((x) >> S_IDMA1_QID) & M_IDMA1_QID)

#define S_IDMA0_QID    0
#define M_IDMA0_QID    0xffffU
#define V_IDMA0_QID(x) ((x) << S_IDMA0_QID)
#define G_IDMA0_QID(x) (((x) >> S_IDMA0_QID) & M_IDMA0_QID)

#define A_SGE_ING_IMSG_RSP1_DBG 0x170c

#define S_IDMA3_QID    16
#define M_IDMA3_QID    0xffffU
#define V_IDMA3_QID(x) ((x) << S_IDMA3_QID)
#define G_IDMA3_QID(x) (((x) >> S_IDMA3_QID) & M_IDMA3_QID)

#define S_IDMA2_QID    0
#define M_IDMA2_QID    0xffffU
#define V_IDMA2_QID(x) ((x) << S_IDMA2_QID)
#define G_IDMA2_QID(x) (((x) >> S_IDMA2_QID) & M_IDMA2_QID)

#define A_SGE_LB_MODE 0x1710

#define S_LB_MODE    0
#define M_LB_MODE    0x3U
#define V_LB_MODE(x) ((x) << S_LB_MODE)
#define G_LB_MODE(x) (((x) >> S_LB_MODE) & M_LB_MODE)

#define A_SGE_IMSG_QUESCENT 0x1714

#define S_IMSG_QUESCENT    0
#define V_IMSG_QUESCENT(x) ((x) << S_IMSG_QUESCENT)
#define F_IMSG_QUESCENT    V_IMSG_QUESCENT(1U)

#define A_SGE_LA_CTRL 0x1718

#define S_LA_GLOBAL_EN    8
#define V_LA_GLOBAL_EN(x) ((x) << S_LA_GLOBAL_EN)
#define F_LA_GLOBAL_EN    V_LA_GLOBAL_EN(1U)

#define S_PTP_TIMESTAMP_SEL    7
#define V_PTP_TIMESTAMP_SEL(x) ((x) << S_PTP_TIMESTAMP_SEL)
#define F_PTP_TIMESTAMP_SEL    V_PTP_TIMESTAMP_SEL(1U)

#define S_CIM2SGE_ID_CHK_VLD    6
#define V_CIM2SGE_ID_CHK_VLD(x) ((x) << S_CIM2SGE_ID_CHK_VLD)
#define F_CIM2SGE_ID_CHK_VLD    V_CIM2SGE_ID_CHK_VLD(1U)

#define S_CPLSW_ID_CHK_VLD    5
#define V_CPLSW_ID_CHK_VLD(x) ((x) << S_CPLSW_ID_CHK_VLD)
#define F_CPLSW_ID_CHK_VLD    V_CPLSW_ID_CHK_VLD(1U)

#define S_FLM_ID_CHK_VLD    4
#define V_FLM_ID_CHK_VLD(x) ((x) << S_FLM_ID_CHK_VLD)
#define F_FLM_ID_CHK_VLD    V_FLM_ID_CHK_VLD(1U)

#define S_IQ_DBP_ID_CHK_VLD    3
#define V_IQ_DBP_ID_CHK_VLD(x) ((x) << S_IQ_DBP_ID_CHK_VLD)
#define F_IQ_DBP_ID_CHK_VLD    V_IQ_DBP_ID_CHK_VLD(1U)

#define S_UP_OBQ_ID_CHK_VLD    2
#define V_UP_OBQ_ID_CHK_VLD(x) ((x) << S_UP_OBQ_ID_CHK_VLD)
#define F_UP_OBQ_ID_CHK_VLD    V_UP_OBQ_ID_CHK_VLD(1U)

#define S_CIM_ID_CHK_VLD    1
#define V_CIM_ID_CHK_VLD(x) ((x) << S_CIM_ID_CHK_VLD)
#define F_CIM_ID_CHK_VLD    V_CIM_ID_CHK_VLD(1U)

#define S_DBP_ID_CHK_VLD    0
#define V_DBP_ID_CHK_VLD(x) ((x) << S_DBP_ID_CHK_VLD)
#define F_DBP_ID_CHK_VLD    V_DBP_ID_CHK_VLD(1U)

#define A_SGE_LA_CTRL_EQID_LOW 0x171c

#define S_EQ_ID_CHK_LOW    0
#define M_EQ_ID_CHK_LOW    0x1ffffU
#define V_EQ_ID_CHK_LOW(x) ((x) << S_EQ_ID_CHK_LOW)
#define G_EQ_ID_CHK_LOW(x) (((x) >> S_EQ_ID_CHK_LOW) & M_EQ_ID_CHK_LOW)

#define A_SGE_LA_CTRL_EQID_HIGH 0x1720

#define S_EQ_ID_CHK_HIGH    0
#define M_EQ_ID_CHK_HIGH    0x1ffffU
#define V_EQ_ID_CHK_HIGH(x) ((x) << S_EQ_ID_CHK_HIGH)
#define G_EQ_ID_CHK_HIGH(x) (((x) >> S_EQ_ID_CHK_HIGH) & M_EQ_ID_CHK_HIGH)

#define A_SGE_LA_CTRL_IQID 0x1724

#define S_IQ_ID_CHK_HIGH    16
#define M_IQ_ID_CHK_HIGH    0xffffU
#define V_IQ_ID_CHK_HIGH(x) ((x) << S_IQ_ID_CHK_HIGH)
#define G_IQ_ID_CHK_HIGH(x) (((x) >> S_IQ_ID_CHK_HIGH) & M_IQ_ID_CHK_HIGH)

#define S_IQ_ID_CHK_LOW    0
#define M_IQ_ID_CHK_LOW    0xffffU
#define V_IQ_ID_CHK_LOW(x) ((x) << S_IQ_ID_CHK_LOW)
#define G_IQ_ID_CHK_LOW(x) (((x) >> S_IQ_ID_CHK_LOW) & M_IQ_ID_CHK_LOW)

#define A_SGE_LA_CTRL_TID_LOW 0x1728

#define S_TID_CHK_LOW    0
#define M_TID_CHK_LOW    0xffffffU
#define V_TID_CHK_LOW(x) ((x) << S_TID_CHK_LOW)
#define G_TID_CHK_LOW(x) (((x) >> S_TID_CHK_LOW) & M_TID_CHK_LOW)

#define A_SGE_LA_CTRL_TID_HIGH 0x172c

#define S_TID_CHK_HIGH    0
#define M_TID_CHK_HIGH    0xffffffU
#define V_TID_CHK_HIGH(x) ((x) << S_TID_CHK_HIGH)
#define G_TID_CHK_HIGH(x) (((x) >> S_TID_CHK_HIGH) & M_TID_CHK_HIGH)

#define A_SGE_CFG_TP_ERR 0x173c

#define S_TP_ERR_STATUS_CH3    30
#define M_TP_ERR_STATUS_CH3    0x3U
#define V_TP_ERR_STATUS_CH3(x) ((x) << S_TP_ERR_STATUS_CH3)
#define G_TP_ERR_STATUS_CH3(x) (((x) >> S_TP_ERR_STATUS_CH3) & M_TP_ERR_STATUS_CH3)

#define S_TP_ERR_STATUS_CH2    28
#define M_TP_ERR_STATUS_CH2    0x3U
#define V_TP_ERR_STATUS_CH2(x) ((x) << S_TP_ERR_STATUS_CH2)
#define G_TP_ERR_STATUS_CH2(x) (((x) >> S_TP_ERR_STATUS_CH2) & M_TP_ERR_STATUS_CH2)

#define S_TP_ERR_STATUS_CH1    26
#define M_TP_ERR_STATUS_CH1    0x3U
#define V_TP_ERR_STATUS_CH1(x) ((x) << S_TP_ERR_STATUS_CH1)
#define G_TP_ERR_STATUS_CH1(x) (((x) >> S_TP_ERR_STATUS_CH1) & M_TP_ERR_STATUS_CH1)

#define S_TP_ERR_STATUS_CH0    24
#define M_TP_ERR_STATUS_CH0    0x3U
#define V_TP_ERR_STATUS_CH0(x) ((x) << S_TP_ERR_STATUS_CH0)
#define G_TP_ERR_STATUS_CH0(x) (((x) >> S_TP_ERR_STATUS_CH0) & M_TP_ERR_STATUS_CH0)

#define S_CPL0_SIZE    16
#define M_CPL0_SIZE    0xffU
#define V_CPL0_SIZE(x) ((x) << S_CPL0_SIZE)
#define G_CPL0_SIZE(x) (((x) >> S_CPL0_SIZE) & M_CPL0_SIZE)

#define S_CPL1_SIZE    8
#define M_CPL1_SIZE    0xffU
#define V_CPL1_SIZE(x) ((x) << S_CPL1_SIZE)
#define G_CPL1_SIZE(x) (((x) >> S_CPL1_SIZE) & M_CPL1_SIZE)

#define S_SIZE_LATCH_CLR    3
#define V_SIZE_LATCH_CLR(x) ((x) << S_SIZE_LATCH_CLR)
#define F_SIZE_LATCH_CLR    V_SIZE_LATCH_CLR(1U)

#define S_EXT_LATCH_CLR    2
#define V_EXT_LATCH_CLR(x) ((x) << S_EXT_LATCH_CLR)
#define F_EXT_LATCH_CLR    V_EXT_LATCH_CLR(1U)

#define S_EXT_CHANGE_42875    1
#define V_EXT_CHANGE_42875(x) ((x) << S_EXT_CHANGE_42875)
#define F_EXT_CHANGE_42875    V_EXT_CHANGE_42875(1U)

#define S_SIZE_CHANGE_42913    0
#define V_SIZE_CHANGE_42913(x) ((x) << S_SIZE_CHANGE_42913)
#define F_SIZE_CHANGE_42913    V_SIZE_CHANGE_42913(1U)

#define A_SGE_CHNL0_CTX_ERROR_COUNT_PER_TID 0x1740
#define A_SGE_CHNL1_CTX_ERROR_COUNT_PER_TID 0x1744
#define A_SGE_CHNL2_CTX_ERROR_COUNT_PER_TID 0x1748
#define A_SGE_CHNL3_CTX_ERROR_COUNT_PER_TID 0x174c
#define A_SGE_CTX_ACC_CH0 0x1750

#define S_RDMA_INV_HANDLING    24
#define M_RDMA_INV_HANDLING    0x3U
#define V_RDMA_INV_HANDLING(x) ((x) << S_RDMA_INV_HANDLING)
#define G_RDMA_INV_HANDLING(x) (((x) >> S_RDMA_INV_HANDLING) & M_RDMA_INV_HANDLING)

#define S_T7_TERMINATE_STATUS_EN    23
#define V_T7_TERMINATE_STATUS_EN(x) ((x) << S_T7_TERMINATE_STATUS_EN)
#define F_T7_TERMINATE_STATUS_EN    V_T7_TERMINATE_STATUS_EN(1U)

#define S_T7_DISABLE    22
#define V_T7_DISABLE(x) ((x) << S_T7_DISABLE)
#define F_T7_DISABLE    V_T7_DISABLE(1U)

#define A_SGE_CTX_ACC_CH1 0x1754
#define A_SGE_CTX_ACC_CH2 0x1758
#define A_SGE_CTX_ACC_CH3 0x175c
#define A_SGE_CTX_BASE 0x1760
#define A_SGE_LA_RDPTR_0 0x1800
#define A_SGE_LA_RDDATA_0 0x1804
#define A_SGE_LA_WRPTR_0 0x1808
#define A_SGE_LA_RESERVED_0 0x180c
#define A_SGE_LA_RDPTR_1 0x1810
#define A_SGE_LA_RDDATA_1 0x1814
#define A_SGE_LA_WRPTR_1 0x1818
#define A_SGE_LA_RESERVED_1 0x181c
#define A_SGE_LA_RDPTR_2 0x1820
#define A_SGE_LA_RDDATA_2 0x1824
#define A_SGE_LA_WRPTR_2 0x1828
#define A_SGE_LA_RESERVED_2 0x182c
#define A_SGE_LA_RDPTR_3 0x1830
#define A_SGE_LA_RDDATA_3 0x1834
#define A_SGE_LA_WRPTR_3 0x1838
#define A_SGE_LA_RESERVED_3 0x183c
#define A_SGE_LA_RDPTR_4 0x1840
#define A_SGE_LA_RDDATA_4 0x1844
#define A_SGE_LA_WRPTR_4 0x1848
#define A_SGE_LA_RESERVED_4 0x184c
#define A_SGE_LA_RDPTR_5 0x1850
#define A_SGE_LA_RDDATA_5 0x1854
#define A_SGE_LA_WRPTR_5 0x1858
#define A_SGE_LA_RESERVED_5 0x185c
#define A_SGE_LA_RDPTR_6 0x1860
#define A_SGE_LA_RDDATA_6 0x1864
#define A_SGE_LA_WRPTR_6 0x1868
#define A_SGE_LA_RESERVED_6 0x186c
#define A_SGE_LA_RDPTR_7 0x1870
#define A_SGE_LA_RDDATA_7 0x1874
#define A_SGE_LA_WRPTR_7 0x1878
#define A_SGE_LA_RESERVED_7 0x187c
#define A_SGE_LA_RDPTR_8 0x1880
#define A_SGE_LA_RDDATA_8 0x1884
#define A_SGE_LA_WRPTR_8 0x1888
#define A_SGE_LA_RESERVED_8 0x188c
#define A_SGE_LA_RDPTR_9 0x1890
#define A_SGE_LA_RDDATA_9 0x1894
#define A_SGE_LA_WRPTR_9 0x1898
#define A_SGE_LA_RESERVED_9 0x189c
#define A_SGE_LA_RDPTR_10 0x18a0
#define A_SGE_LA_RDDATA_10 0x18a4
#define A_SGE_LA_WRPTR_10 0x18a8
#define A_SGE_LA_RESERVED_10 0x18ac
#define A_SGE_LA_RDPTR_11 0x18b0
#define A_SGE_LA_RDDATA_11 0x18b4
#define A_SGE_LA_WRPTR_11 0x18b8
#define A_SGE_LA_RESERVED_11 0x18bc
#define A_SGE_LA_RDPTR_12 0x18c0
#define A_SGE_LA_RDDATA_12 0x18c4
#define A_SGE_LA_WRPTR_12 0x18c8
#define A_SGE_LA_RESERVED_12 0x18cc
#define A_SGE_LA_RDPTR_13 0x18d0
#define A_SGE_LA_RDDATA_13 0x18d4
#define A_SGE_LA_WRPTR_13 0x18d8
#define A_SGE_LA_RESERVED_13 0x18dc
#define A_SGE_LA_RDPTR_14 0x18e0
#define A_SGE_LA_RDDATA_14 0x18e4
#define A_SGE_LA_WRPTR_14 0x18e8
#define A_SGE_LA_RESERVED_14 0x18ec
#define A_SGE_LA_RDPTR_15 0x18f0
#define A_SGE_LA_RDDATA_15 0x18f4
#define A_SGE_LA_WRPTR_15 0x18f8
#define A_SGE_LA_RESERVED_15 0x18fc

/* registers for module PCIE */
#define PCIE_BASE_ADDR 0x3000

#define A_PCIE_PF_CFG 0x40

#define S_INTXSTAT    16
#define V_INTXSTAT(x) ((x) << S_INTXSTAT)
#define F_INTXSTAT    V_INTXSTAT(1U)

#define S_AUXPWRPMEN    15
#define V_AUXPWRPMEN(x) ((x) << S_AUXPWRPMEN)
#define F_AUXPWRPMEN    V_AUXPWRPMEN(1U)

#define S_NOSOFTRESET    14
#define V_NOSOFTRESET(x) ((x) << S_NOSOFTRESET)
#define F_NOSOFTRESET    V_NOSOFTRESET(1U)

#define S_AIVEC    4
#define M_AIVEC    0x3ffU
#define V_AIVEC(x) ((x) << S_AIVEC)
#define G_AIVEC(x) (((x) >> S_AIVEC) & M_AIVEC)

#define S_INTXTYPE    2
#define M_INTXTYPE    0x3U
#define V_INTXTYPE(x) ((x) << S_INTXTYPE)
#define G_INTXTYPE(x) (((x) >> S_INTXTYPE) & M_INTXTYPE)

#define S_D3HOTEN    1
#define V_D3HOTEN(x) ((x) << S_D3HOTEN)
#define F_D3HOTEN    V_D3HOTEN(1U)

#define S_CLIDECEN    0
#define V_CLIDECEN(x) ((x) << S_CLIDECEN)
#define F_CLIDECEN    V_CLIDECEN(1U)

#define A_PCIE_PF_CLI 0x44
#define A_PCIE_PF_GEN_MSG 0x48

#define S_MSGTYPE    0
#define M_MSGTYPE    0xffU
#define V_MSGTYPE(x) ((x) << S_MSGTYPE)
#define G_MSGTYPE(x) (((x) >> S_MSGTYPE) & M_MSGTYPE)

#define A_PCIE_PF_EXPROM_OFST 0x4c

#define S_OFFSET    10
#define M_OFFSET    0x3fffU
#define V_OFFSET(x) ((x) << S_OFFSET)
#define G_OFFSET(x) (((x) >> S_OFFSET) & M_OFFSET)

#define A_PCIE_INT_ENABLE 0x3000

#define S_NONFATALERR    30
#define V_NONFATALERR(x) ((x) << S_NONFATALERR)
#define F_NONFATALERR    V_NONFATALERR(1U)

#define S_UNXSPLCPLERR    29
#define V_UNXSPLCPLERR(x) ((x) << S_UNXSPLCPLERR)
#define F_UNXSPLCPLERR    V_UNXSPLCPLERR(1U)

#define S_PCIEPINT    28
#define V_PCIEPINT(x) ((x) << S_PCIEPINT)
#define F_PCIEPINT    V_PCIEPINT(1U)

#define S_PCIESINT    27
#define V_PCIESINT(x) ((x) << S_PCIESINT)
#define F_PCIESINT    V_PCIESINT(1U)

#define S_RPLPERR    26
#define V_RPLPERR(x) ((x) << S_RPLPERR)
#define F_RPLPERR    V_RPLPERR(1U)

#define S_RXWRPERR    25
#define V_RXWRPERR(x) ((x) << S_RXWRPERR)
#define F_RXWRPERR    V_RXWRPERR(1U)

#define S_RXCPLPERR    24
#define V_RXCPLPERR(x) ((x) << S_RXCPLPERR)
#define F_RXCPLPERR    V_RXCPLPERR(1U)

#define S_PIOTAGPERR    23
#define V_PIOTAGPERR(x) ((x) << S_PIOTAGPERR)
#define F_PIOTAGPERR    V_PIOTAGPERR(1U)

#define S_MATAGPERR    22
#define V_MATAGPERR(x) ((x) << S_MATAGPERR)
#define F_MATAGPERR    V_MATAGPERR(1U)

#define S_INTXCLRPERR    21
#define V_INTXCLRPERR(x) ((x) << S_INTXCLRPERR)
#define F_INTXCLRPERR    V_INTXCLRPERR(1U)

#define S_FIDPERR    20
#define V_FIDPERR(x) ((x) << S_FIDPERR)
#define F_FIDPERR    V_FIDPERR(1U)

#define S_CFGSNPPERR    19
#define V_CFGSNPPERR(x) ((x) << S_CFGSNPPERR)
#define F_CFGSNPPERR    V_CFGSNPPERR(1U)

#define S_HRSPPERR    18
#define V_HRSPPERR(x) ((x) << S_HRSPPERR)
#define F_HRSPPERR    V_HRSPPERR(1U)

#define S_HREQPERR    17
#define V_HREQPERR(x) ((x) << S_HREQPERR)
#define F_HREQPERR    V_HREQPERR(1U)

#define S_HCNTPERR    16
#define V_HCNTPERR(x) ((x) << S_HCNTPERR)
#define F_HCNTPERR    V_HCNTPERR(1U)

#define S_DRSPPERR    15
#define V_DRSPPERR(x) ((x) << S_DRSPPERR)
#define F_DRSPPERR    V_DRSPPERR(1U)

#define S_DREQPERR    14
#define V_DREQPERR(x) ((x) << S_DREQPERR)
#define F_DREQPERR    V_DREQPERR(1U)

#define S_DCNTPERR    13
#define V_DCNTPERR(x) ((x) << S_DCNTPERR)
#define F_DCNTPERR    V_DCNTPERR(1U)

#define S_CRSPPERR    12
#define V_CRSPPERR(x) ((x) << S_CRSPPERR)
#define F_CRSPPERR    V_CRSPPERR(1U)

#define S_CREQPERR    11
#define V_CREQPERR(x) ((x) << S_CREQPERR)
#define F_CREQPERR    V_CREQPERR(1U)

#define S_CCNTPERR    10
#define V_CCNTPERR(x) ((x) << S_CCNTPERR)
#define F_CCNTPERR    V_CCNTPERR(1U)

#define S_TARTAGPERR    9
#define V_TARTAGPERR(x) ((x) << S_TARTAGPERR)
#define F_TARTAGPERR    V_TARTAGPERR(1U)

#define S_PIOREQPERR    8
#define V_PIOREQPERR(x) ((x) << S_PIOREQPERR)
#define F_PIOREQPERR    V_PIOREQPERR(1U)

#define S_PIOCPLPERR    7
#define V_PIOCPLPERR(x) ((x) << S_PIOCPLPERR)
#define F_PIOCPLPERR    V_PIOCPLPERR(1U)

#define S_MSIXDIPERR    6
#define V_MSIXDIPERR(x) ((x) << S_MSIXDIPERR)
#define F_MSIXDIPERR    V_MSIXDIPERR(1U)

#define S_MSIXDATAPERR    5
#define V_MSIXDATAPERR(x) ((x) << S_MSIXDATAPERR)
#define F_MSIXDATAPERR    V_MSIXDATAPERR(1U)

#define S_MSIXADDRHPERR    4
#define V_MSIXADDRHPERR(x) ((x) << S_MSIXADDRHPERR)
#define F_MSIXADDRHPERR    V_MSIXADDRHPERR(1U)

#define S_MSIXADDRLPERR    3
#define V_MSIXADDRLPERR(x) ((x) << S_MSIXADDRLPERR)
#define F_MSIXADDRLPERR    V_MSIXADDRLPERR(1U)

#define S_MSIDATAPERR    2
#define V_MSIDATAPERR(x) ((x) << S_MSIDATAPERR)
#define F_MSIDATAPERR    V_MSIDATAPERR(1U)

#define S_MSIADDRHPERR    1
#define V_MSIADDRHPERR(x) ((x) << S_MSIADDRHPERR)
#define F_MSIADDRHPERR    V_MSIADDRHPERR(1U)

#define S_MSIADDRLPERR    0
#define V_MSIADDRLPERR(x) ((x) << S_MSIADDRLPERR)
#define F_MSIADDRLPERR    V_MSIADDRLPERR(1U)

#define S_IPGRPPERR    31
#define V_IPGRPPERR(x) ((x) << S_IPGRPPERR)
#define F_IPGRPPERR    V_IPGRPPERR(1U)

#define S_READRSPERR    29
#define V_READRSPERR(x) ((x) << S_READRSPERR)
#define F_READRSPERR    V_READRSPERR(1U)

#define S_TRGT1GRPPERR    28
#define V_TRGT1GRPPERR(x) ((x) << S_TRGT1GRPPERR)
#define F_TRGT1GRPPERR    V_TRGT1GRPPERR(1U)

#define S_IPSOTPERR    27
#define V_IPSOTPERR(x) ((x) << S_IPSOTPERR)
#define F_IPSOTPERR    V_IPSOTPERR(1U)

#define S_IPRETRYPERR    26
#define V_IPRETRYPERR(x) ((x) << S_IPRETRYPERR)
#define F_IPRETRYPERR    V_IPRETRYPERR(1U)

#define S_IPRXDATAGRPPERR    25
#define V_IPRXDATAGRPPERR(x) ((x) << S_IPRXDATAGRPPERR)
#define F_IPRXDATAGRPPERR    V_IPRXDATAGRPPERR(1U)

#define S_IPRXHDRGRPPERR    24
#define V_IPRXHDRGRPPERR(x) ((x) << S_IPRXHDRGRPPERR)
#define F_IPRXHDRGRPPERR    V_IPRXHDRGRPPERR(1U)

#define S_PIOTAGQPERR    23
#define V_PIOTAGQPERR(x) ((x) << S_PIOTAGQPERR)
#define F_PIOTAGQPERR    V_PIOTAGQPERR(1U)

#define S_MAGRPPERR    22
#define V_MAGRPPERR(x) ((x) << S_MAGRPPERR)
#define F_MAGRPPERR    V_MAGRPPERR(1U)

#define S_VFIDPERR    21
#define V_VFIDPERR(x) ((x) << S_VFIDPERR)
#define F_VFIDPERR    V_VFIDPERR(1U)

#define S_HREQRDPERR    17
#define V_HREQRDPERR(x) ((x) << S_HREQRDPERR)
#define F_HREQRDPERR    V_HREQRDPERR(1U)

#define S_HREQWRPERR    16
#define V_HREQWRPERR(x) ((x) << S_HREQWRPERR)
#define F_HREQWRPERR    V_HREQWRPERR(1U)

#define S_DREQRDPERR    14
#define V_DREQRDPERR(x) ((x) << S_DREQRDPERR)
#define F_DREQRDPERR    V_DREQRDPERR(1U)

#define S_DREQWRPERR    13
#define V_DREQWRPERR(x) ((x) << S_DREQWRPERR)
#define F_DREQWRPERR    V_DREQWRPERR(1U)

#define S_CREQRDPERR    11
#define V_CREQRDPERR(x) ((x) << S_CREQRDPERR)
#define F_CREQRDPERR    V_CREQRDPERR(1U)

#define S_MSTTAGQPERR    10
#define V_MSTTAGQPERR(x) ((x) << S_MSTTAGQPERR)
#define F_MSTTAGQPERR    V_MSTTAGQPERR(1U)

#define S_TGTTAGQPERR    9
#define V_TGTTAGQPERR(x) ((x) << S_TGTTAGQPERR)
#define F_TGTTAGQPERR    V_TGTTAGQPERR(1U)

#define S_PIOREQGRPPERR    8
#define V_PIOREQGRPPERR(x) ((x) << S_PIOREQGRPPERR)
#define F_PIOREQGRPPERR    V_PIOREQGRPPERR(1U)

#define S_PIOCPLGRPPERR    7
#define V_PIOCPLGRPPERR(x) ((x) << S_PIOCPLGRPPERR)
#define F_PIOCPLGRPPERR    V_PIOCPLGRPPERR(1U)

#define S_MSIXSTIPERR    2
#define V_MSIXSTIPERR(x) ((x) << S_MSIXSTIPERR)
#define F_MSIXSTIPERR    V_MSIXSTIPERR(1U)

#define S_MSTTIMEOUTPERR    1
#define V_MSTTIMEOUTPERR(x) ((x) << S_MSTTIMEOUTPERR)
#define F_MSTTIMEOUTPERR    V_MSTTIMEOUTPERR(1U)

#define S_MSTGRPPERR    0
#define V_MSTGRPPERR(x) ((x) << S_MSTGRPPERR)
#define F_MSTGRPPERR    V_MSTGRPPERR(1U)

#define A_PCIE_INT_CAUSE 0x3004
#define A_PCIE_PERR_ENABLE 0x3008

#define S_TGTTAGQCLIENT1PERR    29
#define V_TGTTAGQCLIENT1PERR(x) ((x) << S_TGTTAGQCLIENT1PERR)
#define F_TGTTAGQCLIENT1PERR    V_TGTTAGQCLIENT1PERR(1U)

#define A_PCIE_PERR_INJECT 0x300c

#define S_IDE    0
#define V_IDE(x) ((x) << S_IDE)
#define F_IDE    V_IDE(1U)

#define S_MEMSEL_PCIE    1
#define M_MEMSEL_PCIE    0x1fU
#define V_MEMSEL_PCIE(x) ((x) << S_MEMSEL_PCIE)
#define G_MEMSEL_PCIE(x) (((x) >> S_MEMSEL_PCIE) & M_MEMSEL_PCIE)

#define A_PCIE_NONFAT_ERR 0x3010

#define S_RDRSPERR    9
#define V_RDRSPERR(x) ((x) << S_RDRSPERR)
#define F_RDRSPERR    V_RDRSPERR(1U)

#define S_VPDRSPERR    8
#define V_VPDRSPERR(x) ((x) << S_VPDRSPERR)
#define F_VPDRSPERR    V_VPDRSPERR(1U)

#define S_POPD    7
#define V_POPD(x) ((x) << S_POPD)
#define F_POPD    V_POPD(1U)

#define S_POPH    6
#define V_POPH(x) ((x) << S_POPH)
#define F_POPH    V_POPH(1U)

#define S_POPC    5
#define V_POPC(x) ((x) << S_POPC)
#define F_POPC    V_POPC(1U)

#define S_MEMREQ    4
#define V_MEMREQ(x) ((x) << S_MEMREQ)
#define F_MEMREQ    V_MEMREQ(1U)

#define S_PIOREQ    3
#define V_PIOREQ(x) ((x) << S_PIOREQ)
#define F_PIOREQ    V_PIOREQ(1U)

#define S_TAGDROP    2
#define V_TAGDROP(x) ((x) << S_TAGDROP)
#define F_TAGDROP    V_TAGDROP(1U)

#define S_TAGCPL    1
#define V_TAGCPL(x) ((x) << S_TAGCPL)
#define F_TAGCPL    V_TAGCPL(1U)

#define S_CFGSNP    0
#define V_CFGSNP(x) ((x) << S_CFGSNP)
#define F_CFGSNP    V_CFGSNP(1U)

#define S_MAREQTIMEOUT    29
#define V_MAREQTIMEOUT(x) ((x) << S_MAREQTIMEOUT)
#define F_MAREQTIMEOUT    V_MAREQTIMEOUT(1U)

#define S_TRGT1BARTYPEERR    28
#define V_TRGT1BARTYPEERR(x) ((x) << S_TRGT1BARTYPEERR)
#define F_TRGT1BARTYPEERR    V_TRGT1BARTYPEERR(1U)

#define S_MAEXTRARSPERR    27
#define V_MAEXTRARSPERR(x) ((x) << S_MAEXTRARSPERR)
#define F_MAEXTRARSPERR    V_MAEXTRARSPERR(1U)

#define S_MARSPTIMEOUT    26
#define V_MARSPTIMEOUT(x) ((x) << S_MARSPTIMEOUT)
#define F_MARSPTIMEOUT    V_MARSPTIMEOUT(1U)

#define S_INTVFALLMSIDISERR    25
#define V_INTVFALLMSIDISERR(x) ((x) << S_INTVFALLMSIDISERR)
#define F_INTVFALLMSIDISERR    V_INTVFALLMSIDISERR(1U)

#define S_INTVFRANGEERR    24
#define V_INTVFRANGEERR(x) ((x) << S_INTVFRANGEERR)
#define F_INTVFRANGEERR    V_INTVFRANGEERR(1U)

#define S_INTPLIRSPERR    23
#define V_INTPLIRSPERR(x) ((x) << S_INTPLIRSPERR)
#define F_INTPLIRSPERR    V_INTPLIRSPERR(1U)

#define S_MEMREQRDTAGERR    22
#define V_MEMREQRDTAGERR(x) ((x) << S_MEMREQRDTAGERR)
#define F_MEMREQRDTAGERR    V_MEMREQRDTAGERR(1U)

#define S_CFGINITDONEERR    21
#define V_CFGINITDONEERR(x) ((x) << S_CFGINITDONEERR)
#define F_CFGINITDONEERR    V_CFGINITDONEERR(1U)

#define S_BAR2TIMEOUT    20
#define V_BAR2TIMEOUT(x) ((x) << S_BAR2TIMEOUT)
#define F_BAR2TIMEOUT    V_BAR2TIMEOUT(1U)

#define S_VPDTIMEOUT    19
#define V_VPDTIMEOUT(x) ((x) << S_VPDTIMEOUT)
#define F_VPDTIMEOUT    V_VPDTIMEOUT(1U)

#define S_MEMRSPRDTAGERR    18
#define V_MEMRSPRDTAGERR(x) ((x) << S_MEMRSPRDTAGERR)
#define F_MEMRSPRDTAGERR    V_MEMRSPRDTAGERR(1U)

#define S_MEMRSPWRTAGERR    17
#define V_MEMRSPWRTAGERR(x) ((x) << S_MEMRSPWRTAGERR)
#define F_MEMRSPWRTAGERR    V_MEMRSPWRTAGERR(1U)

#define S_PIORSPRDTAGERR    16
#define V_PIORSPRDTAGERR(x) ((x) << S_PIORSPRDTAGERR)
#define F_PIORSPRDTAGERR    V_PIORSPRDTAGERR(1U)

#define S_PIORSPWRTAGERR    15
#define V_PIORSPWRTAGERR(x) ((x) << S_PIORSPWRTAGERR)
#define F_PIORSPWRTAGERR    V_PIORSPWRTAGERR(1U)

#define S_DBITIMEOUT    14
#define V_DBITIMEOUT(x) ((x) << S_DBITIMEOUT)
#define F_DBITIMEOUT    V_DBITIMEOUT(1U)

#define S_PIOUNALINDWR    13
#define V_PIOUNALINDWR(x) ((x) << S_PIOUNALINDWR)
#define F_PIOUNALINDWR    V_PIOUNALINDWR(1U)

#define S_BAR2RDERR    12
#define V_BAR2RDERR(x) ((x) << S_BAR2RDERR)
#define F_BAR2RDERR    V_BAR2RDERR(1U)

#define S_MAWREOPERR    11
#define V_MAWREOPERR(x) ((x) << S_MAWREOPERR)
#define F_MAWREOPERR    V_MAWREOPERR(1U)

#define S_MARDEOPERR    10
#define V_MARDEOPERR(x) ((x) << S_MARDEOPERR)
#define F_MARDEOPERR    V_MARDEOPERR(1U)

#define S_BAR2REQ    2
#define V_BAR2REQ(x) ((x) << S_BAR2REQ)
#define F_BAR2REQ    V_BAR2REQ(1U)

#define S_MARSPUE    30
#define V_MARSPUE(x) ((x) << S_MARSPUE)
#define F_MARSPUE    V_MARSPUE(1U)

#define S_KDBEOPERR    7
#define V_KDBEOPERR(x) ((x) << S_KDBEOPERR)
#define F_KDBEOPERR    V_KDBEOPERR(1U)

#define A_PCIE_CFG 0x3014

#define S_CFGDMAXPYLDSZRX    26
#define M_CFGDMAXPYLDSZRX    0x7U
#define V_CFGDMAXPYLDSZRX(x) ((x) << S_CFGDMAXPYLDSZRX)
#define G_CFGDMAXPYLDSZRX(x) (((x) >> S_CFGDMAXPYLDSZRX) & M_CFGDMAXPYLDSZRX)

#define S_CFGDMAXPYLDSZTX    23
#define M_CFGDMAXPYLDSZTX    0x7U
#define V_CFGDMAXPYLDSZTX(x) ((x) << S_CFGDMAXPYLDSZTX)
#define G_CFGDMAXPYLDSZTX(x) (((x) >> S_CFGDMAXPYLDSZTX) & M_CFGDMAXPYLDSZTX)

#define S_CFGDMAXRDREQSZ    20
#define M_CFGDMAXRDREQSZ    0x7U
#define V_CFGDMAXRDREQSZ(x) ((x) << S_CFGDMAXRDREQSZ)
#define G_CFGDMAXRDREQSZ(x) (((x) >> S_CFGDMAXRDREQSZ) & M_CFGDMAXRDREQSZ)

#define S_MASYNCEN    19
#define V_MASYNCEN(x) ((x) << S_MASYNCEN)
#define F_MASYNCEN    V_MASYNCEN(1U)

#define S_DCAENDMA    18
#define V_DCAENDMA(x) ((x) << S_DCAENDMA)
#define F_DCAENDMA    V_DCAENDMA(1U)

#define S_DCAENCMD    17
#define V_DCAENCMD(x) ((x) << S_DCAENCMD)
#define F_DCAENCMD    V_DCAENCMD(1U)

#define S_VFMSIPNDEN    16
#define V_VFMSIPNDEN(x) ((x) << S_VFMSIPNDEN)
#define F_VFMSIPNDEN    V_VFMSIPNDEN(1U)

#define S_FORCETXERROR    15
#define V_FORCETXERROR(x) ((x) << S_FORCETXERROR)
#define F_FORCETXERROR    V_FORCETXERROR(1U)

#define S_VPDREQPROTECT    14
#define V_VPDREQPROTECT(x) ((x) << S_VPDREQPROTECT)
#define F_VPDREQPROTECT    V_VPDREQPROTECT(1U)

#define S_FIDTABLEINVALID    13
#define V_FIDTABLEINVALID(x) ((x) << S_FIDTABLEINVALID)
#define F_FIDTABLEINVALID    V_FIDTABLEINVALID(1U)

#define S_BYPASSMSIXCACHE    12
#define V_BYPASSMSIXCACHE(x) ((x) << S_BYPASSMSIXCACHE)
#define F_BYPASSMSIXCACHE    V_BYPASSMSIXCACHE(1U)

#define S_BYPASSMSICACHE    11
#define V_BYPASSMSICACHE(x) ((x) << S_BYPASSMSICACHE)
#define F_BYPASSMSICACHE    V_BYPASSMSICACHE(1U)

#define S_SIMSPEED    10
#define V_SIMSPEED(x) ((x) << S_SIMSPEED)
#define F_SIMSPEED    V_SIMSPEED(1U)

#define S_TC0_STAMP    9
#define V_TC0_STAMP(x) ((x) << S_TC0_STAMP)
#define F_TC0_STAMP    V_TC0_STAMP(1U)

#define S_AI_TCVAL    6
#define M_AI_TCVAL    0x7U
#define V_AI_TCVAL(x) ((x) << S_AI_TCVAL)
#define G_AI_TCVAL(x) (((x) >> S_AI_TCVAL) & M_AI_TCVAL)

#define S_DMASTOPEN    5
#define V_DMASTOPEN(x) ((x) << S_DMASTOPEN)
#define F_DMASTOPEN    V_DMASTOPEN(1U)

#define S_DEVSTATERSTMODE    4
#define V_DEVSTATERSTMODE(x) ((x) << S_DEVSTATERSTMODE)
#define F_DEVSTATERSTMODE    V_DEVSTATERSTMODE(1U)

#define S_HOTRSTPCIECRSTMODE    3
#define V_HOTRSTPCIECRSTMODE(x) ((x) << S_HOTRSTPCIECRSTMODE)
#define F_HOTRSTPCIECRSTMODE    V_HOTRSTPCIECRSTMODE(1U)

#define S_DLDNPCIECRSTMODE    2
#define V_DLDNPCIECRSTMODE(x) ((x) << S_DLDNPCIECRSTMODE)
#define F_DLDNPCIECRSTMODE    V_DLDNPCIECRSTMODE(1U)

#define S_DLDNPCIEPRECRSTMODE    1
#define V_DLDNPCIEPRECRSTMODE(x) ((x) << S_DLDNPCIEPRECRSTMODE)
#define F_DLDNPCIEPRECRSTMODE    V_DLDNPCIEPRECRSTMODE(1U)

#define S_LINKDNRSTEN    0
#define V_LINKDNRSTEN(x) ((x) << S_LINKDNRSTEN)
#define F_LINKDNRSTEN    V_LINKDNRSTEN(1U)

#define S_T5_PIOSTOPEN    31
#define V_T5_PIOSTOPEN(x) ((x) << S_T5_PIOSTOPEN)
#define F_T5_PIOSTOPEN    V_T5_PIOSTOPEN(1U)

#define S_DIAGCTRLBUS    28
#define M_DIAGCTRLBUS    0x7U
#define V_DIAGCTRLBUS(x) ((x) << S_DIAGCTRLBUS)
#define G_DIAGCTRLBUS(x) (((x) >> S_DIAGCTRLBUS) & M_DIAGCTRLBUS)

#define S_IPPERREN    27
#define V_IPPERREN(x) ((x) << S_IPPERREN)
#define F_IPPERREN    V_IPPERREN(1U)

#define S_CFGDEXTTAGEN    26
#define V_CFGDEXTTAGEN(x) ((x) << S_CFGDEXTTAGEN)
#define F_CFGDEXTTAGEN    V_CFGDEXTTAGEN(1U)

#define S_CFGDMAXPYLDSZ    23
#define M_CFGDMAXPYLDSZ    0x7U
#define V_CFGDMAXPYLDSZ(x) ((x) << S_CFGDMAXPYLDSZ)
#define G_CFGDMAXPYLDSZ(x) (((x) >> S_CFGDMAXPYLDSZ) & M_CFGDMAXPYLDSZ)

#define S_DCAEN    17
#define V_DCAEN(x) ((x) << S_DCAEN)
#define F_DCAEN    V_DCAEN(1U)

#define S_T5CMDREQPRIORITY    16
#define V_T5CMDREQPRIORITY(x) ((x) << S_T5CMDREQPRIORITY)
#define F_T5CMDREQPRIORITY    V_T5CMDREQPRIORITY(1U)

#define S_T5VPDREQPROTECT    14
#define M_T5VPDREQPROTECT    0x3U
#define V_T5VPDREQPROTECT(x) ((x) << S_T5VPDREQPROTECT)
#define G_T5VPDREQPROTECT(x) (((x) >> S_T5VPDREQPROTECT) & M_T5VPDREQPROTECT)

#define S_DROPPEDRDRSPDATA    12
#define V_DROPPEDRDRSPDATA(x) ((x) << S_DROPPEDRDRSPDATA)
#define F_DROPPEDRDRSPDATA    V_DROPPEDRDRSPDATA(1U)

#define S_AI_INTX_REASSERTEN    11
#define V_AI_INTX_REASSERTEN(x) ((x) << S_AI_INTX_REASSERTEN)
#define F_AI_INTX_REASSERTEN    V_AI_INTX_REASSERTEN(1U)

#define S_AUTOTXNDISABLE    10
#define V_AUTOTXNDISABLE(x) ((x) << S_AUTOTXNDISABLE)
#define F_AUTOTXNDISABLE    V_AUTOTXNDISABLE(1U)

#define S_LINKREQRSTPCIECRSTMODE    3
#define V_LINKREQRSTPCIECRSTMODE(x) ((x) << S_LINKREQRSTPCIECRSTMODE)
#define F_LINKREQRSTPCIECRSTMODE    V_LINKREQRSTPCIECRSTMODE(1U)

#define A_PCIE_DMA_CTRL 0x3018

#define S_LITTLEENDIAN    7
#define V_LITTLEENDIAN(x) ((x) << S_LITTLEENDIAN)
#define F_LITTLEENDIAN    V_LITTLEENDIAN(1U)

#define A_PCIE_CFG2 0x3018

#define S_VPDTIMER    16
#define M_VPDTIMER    0xffffU
#define V_VPDTIMER(x) ((x) << S_VPDTIMER)
#define G_VPDTIMER(x) (((x) >> S_VPDTIMER) & M_VPDTIMER)

#define S_BAR2TIMER    4
#define M_BAR2TIMER    0xfffU
#define V_BAR2TIMER(x) ((x) << S_BAR2TIMER)
#define G_BAR2TIMER(x) (((x) >> S_BAR2TIMER) & M_BAR2TIMER)

#define S_MSTREQRDRRASIMPLE    3
#define V_MSTREQRDRRASIMPLE(x) ((x) << S_MSTREQRDRRASIMPLE)
#define F_MSTREQRDRRASIMPLE    V_MSTREQRDRRASIMPLE(1U)

#define S_TOTMAXTAG    0
#define M_TOTMAXTAG    0x3U
#define V_TOTMAXTAG(x) ((x) << S_TOTMAXTAG)
#define G_TOTMAXTAG(x) (((x) >> S_TOTMAXTAG) & M_TOTMAXTAG)

#define S_T6_TOTMAXTAG    0
#define M_T6_TOTMAXTAG    0x7U
#define V_T6_TOTMAXTAG(x) ((x) << S_T6_TOTMAXTAG)
#define G_T6_TOTMAXTAG(x) (((x) >> S_T6_TOTMAXTAG) & M_T6_TOTMAXTAG)

#define S_REG_VDM_ONLY    17
#define V_REG_VDM_ONLY(x) ((x) << S_REG_VDM_ONLY)
#define F_REG_VDM_ONLY    V_REG_VDM_ONLY(1U)

#define S_MULT_REQID_SUP    16
#define V_MULT_REQID_SUP(x) ((x) << S_MULT_REQID_SUP)
#define F_MULT_REQID_SUP    V_MULT_REQID_SUP(1U)

#define A_PCIE_DMA_CFG 0x301c

#define S_MAXPYLDSIZE    28
#define M_MAXPYLDSIZE    0x7U
#define V_MAXPYLDSIZE(x) ((x) << S_MAXPYLDSIZE)
#define G_MAXPYLDSIZE(x) (((x) >> S_MAXPYLDSIZE) & M_MAXPYLDSIZE)

#define S_MAXRDREQSIZE    25
#define M_MAXRDREQSIZE    0x7U
#define V_MAXRDREQSIZE(x) ((x) << S_MAXRDREQSIZE)
#define G_MAXRDREQSIZE(x) (((x) >> S_MAXRDREQSIZE) & M_MAXRDREQSIZE)

#define S_DMA_MAXRSPCNT    16
#define M_DMA_MAXRSPCNT    0x1ffU
#define V_DMA_MAXRSPCNT(x) ((x) << S_DMA_MAXRSPCNT)
#define G_DMA_MAXRSPCNT(x) (((x) >> S_DMA_MAXRSPCNT) & M_DMA_MAXRSPCNT)

#define S_DMA_MAXREQCNT    8
#define M_DMA_MAXREQCNT    0xffU
#define V_DMA_MAXREQCNT(x) ((x) << S_DMA_MAXREQCNT)
#define G_DMA_MAXREQCNT(x) (((x) >> S_DMA_MAXREQCNT) & M_DMA_MAXREQCNT)

#define S_MAXTAG    0
#define M_MAXTAG    0x7fU
#define V_MAXTAG(x) ((x) << S_MAXTAG)
#define G_MAXTAG(x) (((x) >> S_MAXTAG) & M_MAXTAG)

#define A_PCIE_CFG3 0x301c

#define S_AUTOPIOCOOKIEMATCH    6
#define V_AUTOPIOCOOKIEMATCH(x) ((x) << S_AUTOPIOCOOKIEMATCH)
#define F_AUTOPIOCOOKIEMATCH    V_AUTOPIOCOOKIEMATCH(1U)

#define S_FLRPNDCPLMODE    4
#define M_FLRPNDCPLMODE    0x3U
#define V_FLRPNDCPLMODE(x) ((x) << S_FLRPNDCPLMODE)
#define G_FLRPNDCPLMODE(x) (((x) >> S_FLRPNDCPLMODE) & M_FLRPNDCPLMODE)

#define S_HMADCASTFIRSTONLY    2
#define V_HMADCASTFIRSTONLY(x) ((x) << S_HMADCASTFIRSTONLY)
#define F_HMADCASTFIRSTONLY    V_HMADCASTFIRSTONLY(1U)

#define S_CMDDCASTFIRSTONLY    1
#define V_CMDDCASTFIRSTONLY(x) ((x) << S_CMDDCASTFIRSTONLY)
#define F_CMDDCASTFIRSTONLY    V_CMDDCASTFIRSTONLY(1U)

#define S_DMADCASTFIRSTONLY    0
#define V_DMADCASTFIRSTONLY(x) ((x) << S_DMADCASTFIRSTONLY)
#define F_DMADCASTFIRSTONLY    V_DMADCASTFIRSTONLY(1U)

#define S_ARMDCASTFIRSTONLY    7
#define V_ARMDCASTFIRSTONLY(x) ((x) << S_ARMDCASTFIRSTONLY)
#define F_ARMDCASTFIRSTONLY    V_ARMDCASTFIRSTONLY(1U)

#define A_PCIE_DMA_STAT 0x3020

#define S_STATEREQ    28
#define M_STATEREQ    0xfU
#define V_STATEREQ(x) ((x) << S_STATEREQ)
#define G_STATEREQ(x) (((x) >> S_STATEREQ) & M_STATEREQ)

#define S_DMA_RSPCNT    16
#define M_DMA_RSPCNT    0xfffU
#define V_DMA_RSPCNT(x) ((x) << S_DMA_RSPCNT)
#define G_DMA_RSPCNT(x) (((x) >> S_DMA_RSPCNT) & M_DMA_RSPCNT)

#define S_STATEAREQ    13
#define M_STATEAREQ    0x7U
#define V_STATEAREQ(x) ((x) << S_STATEAREQ)
#define G_STATEAREQ(x) (((x) >> S_STATEAREQ) & M_STATEAREQ)

#define S_TAGFREE    12
#define V_TAGFREE(x) ((x) << S_TAGFREE)
#define F_TAGFREE    V_TAGFREE(1U)

#define S_DMA_REQCNT    0
#define M_DMA_REQCNT    0x7ffU
#define V_DMA_REQCNT(x) ((x) << S_DMA_REQCNT)
#define G_DMA_REQCNT(x) (((x) >> S_DMA_REQCNT) & M_DMA_REQCNT)

#define A_PCIE_CFG4 0x3020

#define S_L1CLKREMOVALEN    17
#define V_L1CLKREMOVALEN(x) ((x) << S_L1CLKREMOVALEN)
#define F_L1CLKREMOVALEN    V_L1CLKREMOVALEN(1U)

#define S_READYENTERL23    16
#define V_READYENTERL23(x) ((x) << S_READYENTERL23)
#define F_READYENTERL23    V_READYENTERL23(1U)

#define S_EXITL1    12
#define V_EXITL1(x) ((x) << S_EXITL1)
#define F_EXITL1    V_EXITL1(1U)

#define S_ENTERL1    8
#define V_ENTERL1(x) ((x) << S_ENTERL1)
#define F_ENTERL1    V_ENTERL1(1U)

#define S_GENPME    0
#define M_GENPME    0xffU
#define V_GENPME(x) ((x) << S_GENPME)
#define G_GENPME(x) (((x) >> S_GENPME) & M_GENPME)

#define A_PCIE_CFG5 0x3024

#define S_ENABLESKPPARITYFIX    2
#define V_ENABLESKPPARITYFIX(x) ((x) << S_ENABLESKPPARITYFIX)
#define F_ENABLESKPPARITYFIX    V_ENABLESKPPARITYFIX(1U)

#define S_ENABLEL2ENTRYINL1    1
#define V_ENABLEL2ENTRYINL1(x) ((x) << S_ENABLEL2ENTRYINL1)
#define F_ENABLEL2ENTRYINL1    V_ENABLEL2ENTRYINL1(1U)

#define S_HOLDCPLENTERINGL1    0
#define V_HOLDCPLENTERINGL1(x) ((x) << S_HOLDCPLENTERINGL1)
#define F_HOLDCPLENTERINGL1    V_HOLDCPLENTERINGL1(1U)

#define A_PCIE_CFG6 0x3028

#define S_PERSTTIMERCOUNT    12
#define M_PERSTTIMERCOUNT    0x3fffU
#define V_PERSTTIMERCOUNT(x) ((x) << S_PERSTTIMERCOUNT)
#define G_PERSTTIMERCOUNT(x) (((x) >> S_PERSTTIMERCOUNT) & M_PERSTTIMERCOUNT)

#define S_PERSTTIMEOUT    8
#define V_PERSTTIMEOUT(x) ((x) << S_PERSTTIMEOUT)
#define F_PERSTTIMEOUT    V_PERSTTIMEOUT(1U)

#define S_PERSTTIMER    0
#define M_PERSTTIMER    0xfU
#define V_PERSTTIMER(x) ((x) << S_PERSTTIMER)
#define G_PERSTTIMER(x) (((x) >> S_PERSTTIMER) & M_PERSTTIMER)

#define A_PCIE_CFG7 0x302c
#define A_PCIE_INT_ENABLE_EXT 0x3030

#define S_TCAMRSPERR    31
#define V_TCAMRSPERR(x) ((x) << S_TCAMRSPERR)
#define F_TCAMRSPERR    V_TCAMRSPERR(1U)

#define S_IPFORMQPERR    30
#define V_IPFORMQPERR(x) ((x) << S_IPFORMQPERR)
#define F_IPFORMQPERR    V_IPFORMQPERR(1U)

#define S_IPFORMQCERR    29
#define V_IPFORMQCERR(x) ((x) << S_IPFORMQCERR)
#define F_IPFORMQCERR    V_IPFORMQCERR(1U)

#define S_TRGT1GRPCERR    28
#define V_TRGT1GRPCERR(x) ((x) << S_TRGT1GRPCERR)
#define F_TRGT1GRPCERR    V_TRGT1GRPCERR(1U)

#define S_IPSOTCERR    27
#define V_IPSOTCERR(x) ((x) << S_IPSOTCERR)
#define F_IPSOTCERR    V_IPSOTCERR(1U)

#define S_IPRETRYCERR    26
#define V_IPRETRYCERR(x) ((x) << S_IPRETRYCERR)
#define F_IPRETRYCERR    V_IPRETRYCERR(1U)

#define S_IPRXDATAGRPCERR    25
#define V_IPRXDATAGRPCERR(x) ((x) << S_IPRXDATAGRPCERR)
#define F_IPRXDATAGRPCERR    V_IPRXDATAGRPCERR(1U)

#define S_IPRXHDRGRPCERR    24
#define V_IPRXHDRGRPCERR(x) ((x) << S_IPRXHDRGRPCERR)
#define F_IPRXHDRGRPCERR    V_IPRXHDRGRPCERR(1U)

#define S_A0ARBRSPORDFIFOPERR    19
#define V_A0ARBRSPORDFIFOPERR(x) ((x) << S_A0ARBRSPORDFIFOPERR)
#define F_A0ARBRSPORDFIFOPERR    V_A0ARBRSPORDFIFOPERR(1U)

#define S_HRSPCERR    18
#define V_HRSPCERR(x) ((x) << S_HRSPCERR)
#define F_HRSPCERR    V_HRSPCERR(1U)

#define S_HREQRDCERR    17
#define V_HREQRDCERR(x) ((x) << S_HREQRDCERR)
#define F_HREQRDCERR    V_HREQRDCERR(1U)

#define S_HREQWRCERR    16
#define V_HREQWRCERR(x) ((x) << S_HREQWRCERR)
#define F_HREQWRCERR    V_HREQWRCERR(1U)

#define S_DRSPCERR    15
#define V_DRSPCERR(x) ((x) << S_DRSPCERR)
#define F_DRSPCERR    V_DRSPCERR(1U)

#define S_DREQRDCERR    14
#define V_DREQRDCERR(x) ((x) << S_DREQRDCERR)
#define F_DREQRDCERR    V_DREQRDCERR(1U)

#define S_DREQWRCERR    13
#define V_DREQWRCERR(x) ((x) << S_DREQWRCERR)
#define F_DREQWRCERR    V_DREQWRCERR(1U)

#define S_CRSPCERR    12
#define V_CRSPCERR(x) ((x) << S_CRSPCERR)
#define F_CRSPCERR    V_CRSPCERR(1U)

#define S_ARSPPERR    11
#define V_ARSPPERR(x) ((x) << S_ARSPPERR)
#define F_ARSPPERR    V_ARSPPERR(1U)

#define S_AREQRDPERR    10
#define V_AREQRDPERR(x) ((x) << S_AREQRDPERR)
#define F_AREQRDPERR    V_AREQRDPERR(1U)

#define S_AREQWRPERR    9
#define V_AREQWRPERR(x) ((x) << S_AREQWRPERR)
#define F_AREQWRPERR    V_AREQWRPERR(1U)

#define S_PIOREQGRPCERR    8
#define V_PIOREQGRPCERR(x) ((x) << S_PIOREQGRPCERR)
#define F_PIOREQGRPCERR    V_PIOREQGRPCERR(1U)

#define S_ARSPCERR    7
#define V_ARSPCERR(x) ((x) << S_ARSPCERR)
#define F_ARSPCERR    V_ARSPCERR(1U)

#define S_AREQRDCERR    6
#define V_AREQRDCERR(x) ((x) << S_AREQRDCERR)
#define F_AREQRDCERR    V_AREQRDCERR(1U)

#define S_AREQWRCERR    5
#define V_AREQWRCERR(x) ((x) << S_AREQWRCERR)
#define F_AREQWRCERR    V_AREQWRCERR(1U)

#define S_MARSPPERR    4
#define V_MARSPPERR(x) ((x) << S_MARSPPERR)
#define F_MARSPPERR    V_MARSPPERR(1U)

#define S_INICMAWDATAORDPERR    3
#define V_INICMAWDATAORDPERR(x) ((x) << S_INICMAWDATAORDPERR)
#define F_INICMAWDATAORDPERR    V_INICMAWDATAORDPERR(1U)

#define S_EMUPERR    2
#define V_EMUPERR(x) ((x) << S_EMUPERR)
#define F_EMUPERR    V_EMUPERR(1U)

#define S_ERRSPPERR    1
#define V_ERRSPPERR(x) ((x) << S_ERRSPPERR)
#define F_ERRSPPERR    V_ERRSPPERR(1U)

#define S_MSTGRPCERR    0
#define V_MSTGRPCERR(x) ((x) << S_MSTGRPCERR)
#define F_MSTGRPCERR    V_MSTGRPCERR(1U)

#define A_PCIE_INT_ENABLE_X8 0x3034

#define S_X8TGTGRPPERR    23
#define V_X8TGTGRPPERR(x) ((x) << S_X8TGTGRPPERR)
#define F_X8TGTGRPPERR    V_X8TGTGRPPERR(1U)

#define S_X8IPSOTPERR    22
#define V_X8IPSOTPERR(x) ((x) << S_X8IPSOTPERR)
#define F_X8IPSOTPERR    V_X8IPSOTPERR(1U)

#define S_X8IPRETRYPERR    21
#define V_X8IPRETRYPERR(x) ((x) << S_X8IPRETRYPERR)
#define F_X8IPRETRYPERR    V_X8IPRETRYPERR(1U)

#define S_X8IPRXDATAGRPPERR    20
#define V_X8IPRXDATAGRPPERR(x) ((x) << S_X8IPRXDATAGRPPERR)
#define F_X8IPRXDATAGRPPERR    V_X8IPRXDATAGRPPERR(1U)

#define S_X8IPRXHDRGRPPERR    19
#define V_X8IPRXHDRGRPPERR(x) ((x) << S_X8IPRXHDRGRPPERR)
#define F_X8IPRXHDRGRPPERR    V_X8IPRXHDRGRPPERR(1U)

#define S_X8IPCORECERR    3
#define V_X8IPCORECERR(x) ((x) << S_X8IPCORECERR)
#define F_X8IPCORECERR    V_X8IPCORECERR(1U)

#define S_X8MSTGRPPERR    2
#define V_X8MSTGRPPERR(x) ((x) << S_X8MSTGRPPERR)
#define F_X8MSTGRPPERR    V_X8MSTGRPPERR(1U)

#define S_X8MSTGRPCERR    1
#define V_X8MSTGRPCERR(x) ((x) << S_X8MSTGRPCERR)
#define F_X8MSTGRPCERR    V_X8MSTGRPCERR(1U)

#define A_PCIE_INT_CAUSE_EXT 0x3038
#define A_PCIE_CMD_CTRL 0x303c
#define A_PCIE_INT_CAUSE_X8 0x303c
#define A_PCIE_CMD_CFG 0x3040

#define S_MAXRSPCNT    16
#define M_MAXRSPCNT    0xfU
#define V_MAXRSPCNT(x) ((x) << S_MAXRSPCNT)
#define G_MAXRSPCNT(x) (((x) >> S_MAXRSPCNT) & M_MAXRSPCNT)

#define S_MAXREQCNT    8
#define M_MAXREQCNT    0x1fU
#define V_MAXREQCNT(x) ((x) << S_MAXREQCNT)
#define G_MAXREQCNT(x) (((x) >> S_MAXREQCNT) & M_MAXREQCNT)

#define A_PCIE_PERR_ENABLE_EXT 0x3040

#define S_T7_ARSPPERR    18
#define V_T7_ARSPPERR(x) ((x) << S_T7_ARSPPERR)
#define F_T7_ARSPPERR    V_T7_ARSPPERR(1U)

#define S_T7_AREQRDPERR    17
#define V_T7_AREQRDPERR(x) ((x) << S_T7_AREQRDPERR)
#define F_T7_AREQRDPERR    V_T7_AREQRDPERR(1U)

#define S_T7_AREQWRPERR    16
#define V_T7_AREQWRPERR(x) ((x) << S_T7_AREQWRPERR)
#define F_T7_AREQWRPERR    V_T7_AREQWRPERR(1U)

#define S_T7_A0ARBRSPORDFIFOPERR    15
#define V_T7_A0ARBRSPORDFIFOPERR(x) ((x) << S_T7_A0ARBRSPORDFIFOPERR)
#define F_T7_A0ARBRSPORDFIFOPERR    V_T7_A0ARBRSPORDFIFOPERR(1U)

#define S_T7_MARSPPERR    14
#define V_T7_MARSPPERR(x) ((x) << S_T7_MARSPPERR)
#define F_T7_MARSPPERR    V_T7_MARSPPERR(1U)

#define S_T7_INICMAWDATAORDPERR    13
#define V_T7_INICMAWDATAORDPERR(x) ((x) << S_T7_INICMAWDATAORDPERR)
#define F_T7_INICMAWDATAORDPERR    V_T7_INICMAWDATAORDPERR(1U)

#define S_T7_EMUPERR    12
#define V_T7_EMUPERR(x) ((x) << S_T7_EMUPERR)
#define F_T7_EMUPERR    V_T7_EMUPERR(1U)

#define S_T7_ERRSPPERR    11
#define V_T7_ERRSPPERR(x) ((x) << S_T7_ERRSPPERR)
#define F_T7_ERRSPPERR    V_T7_ERRSPPERR(1U)

#define A_PCIE_CMD_STAT 0x3044

#define S_RSPCNT    16
#define M_RSPCNT    0x7fU
#define V_RSPCNT(x) ((x) << S_RSPCNT)
#define G_RSPCNT(x) (((x) >> S_RSPCNT) & M_RSPCNT)

#define S_REQCNT    0
#define M_REQCNT    0xffU
#define V_REQCNT(x) ((x) << S_REQCNT)
#define G_REQCNT(x) (((x) >> S_REQCNT) & M_REQCNT)

#define A_PCIE_PERR_ENABLE_X8 0x3044

#define S_T7_X8TGTGRPPERR    28
#define V_T7_X8TGTGRPPERR(x) ((x) << S_T7_X8TGTGRPPERR)
#define F_T7_X8TGTGRPPERR    V_T7_X8TGTGRPPERR(1U)

#define S_T7_X8IPSOTPERR    27
#define V_T7_X8IPSOTPERR(x) ((x) << S_T7_X8IPSOTPERR)
#define F_T7_X8IPSOTPERR    V_T7_X8IPSOTPERR(1U)

#define S_T7_X8IPRETRYPERR    26
#define V_T7_X8IPRETRYPERR(x) ((x) << S_T7_X8IPRETRYPERR)
#define F_T7_X8IPRETRYPERR    V_T7_X8IPRETRYPERR(1U)

#define S_T7_X8IPRXDATAGRPPERR    25
#define V_T7_X8IPRXDATAGRPPERR(x) ((x) << S_T7_X8IPRXDATAGRPPERR)
#define F_T7_X8IPRXDATAGRPPERR    V_T7_X8IPRXDATAGRPPERR(1U)

#define S_T7_X8IPRXHDRGRPPERR    24
#define V_T7_X8IPRXHDRGRPPERR(x) ((x) << S_T7_X8IPRXHDRGRPPERR)
#define F_T7_X8IPRXHDRGRPPERR    V_T7_X8IPRXHDRGRPPERR(1U)

#define S_T7_X8MSTGRPPERR    0
#define V_T7_X8MSTGRPPERR(x) ((x) << S_T7_X8MSTGRPPERR)
#define F_T7_X8MSTGRPPERR    V_T7_X8MSTGRPPERR(1U)

#define A_PCIE_HMA_CTRL 0x3050

#define S_IPLTSSM    12
#define M_IPLTSSM    0xfU
#define V_IPLTSSM(x) ((x) << S_IPLTSSM)
#define G_IPLTSSM(x) (((x) >> S_IPLTSSM) & M_IPLTSSM)

#define S_IPCONFIGDOWN    8
#define M_IPCONFIGDOWN    0x7U
#define V_IPCONFIGDOWN(x) ((x) << S_IPCONFIGDOWN)
#define G_IPCONFIGDOWN(x) (((x) >> S_IPCONFIGDOWN) & M_IPCONFIGDOWN)

#define A_PCIE_HMA_CFG 0x3054

#define S_HMA_MAXRSPCNT    16
#define M_HMA_MAXRSPCNT    0x1fU
#define V_HMA_MAXRSPCNT(x) ((x) << S_HMA_MAXRSPCNT)
#define G_HMA_MAXRSPCNT(x) (((x) >> S_HMA_MAXRSPCNT) & M_HMA_MAXRSPCNT)

#define A_PCIE_HMA_STAT 0x3058

#define S_HMA_RSPCNT    16
#define M_HMA_RSPCNT    0xffU
#define V_HMA_RSPCNT(x) ((x) << S_HMA_RSPCNT)
#define G_HMA_RSPCNT(x) (((x) >> S_HMA_RSPCNT) & M_HMA_RSPCNT)

#define A_PCIE_PIO_FIFO_CFG 0x305c

#define S_CPLCONFIG    16
#define M_CPLCONFIG    0xffffU
#define V_CPLCONFIG(x) ((x) << S_CPLCONFIG)
#define G_CPLCONFIG(x) (((x) >> S_CPLCONFIG) & M_CPLCONFIG)

#define S_PIOSTOPEN    12
#define V_PIOSTOPEN(x) ((x) << S_PIOSTOPEN)
#define F_PIOSTOPEN    V_PIOSTOPEN(1U)

#define S_IPLANESWAP    11
#define V_IPLANESWAP(x) ((x) << S_IPLANESWAP)
#define F_IPLANESWAP    V_IPLANESWAP(1U)

#define S_FORCESTRICTTS1    10
#define V_FORCESTRICTTS1(x) ((x) << S_FORCESTRICTTS1)
#define F_FORCESTRICTTS1    V_FORCESTRICTTS1(1U)

#define S_FORCEPROGRESSCNT    0
#define M_FORCEPROGRESSCNT    0x3ffU
#define V_FORCEPROGRESSCNT(x) ((x) << S_FORCEPROGRESSCNT)
#define G_FORCEPROGRESSCNT(x) (((x) >> S_FORCEPROGRESSCNT) & M_FORCEPROGRESSCNT)

#define A_PCIE_CFG_SPACE_REQ 0x3060

#define S_ENABLE    30
#define V_ENABLE(x) ((x) << S_ENABLE)
#define F_ENABLE    V_ENABLE(1U)

#define S_AI    29
#define V_AI(x) ((x) << S_AI)
#define F_AI    V_AI(1U)

#define S_LOCALCFG    28
#define V_LOCALCFG(x) ((x) << S_LOCALCFG)
#define F_LOCALCFG    V_LOCALCFG(1U)

#define S_BUS    20
#define M_BUS    0xffU
#define V_BUS(x) ((x) << S_BUS)
#define G_BUS(x) (((x) >> S_BUS) & M_BUS)

#define S_DEVICE    15
#define M_DEVICE    0x1fU
#define V_DEVICE(x) ((x) << S_DEVICE)
#define G_DEVICE(x) (((x) >> S_DEVICE) & M_DEVICE)

#define S_FUNCTION    12
#define M_FUNCTION    0x7U
#define V_FUNCTION(x) ((x) << S_FUNCTION)
#define G_FUNCTION(x) (((x) >> S_FUNCTION) & M_FUNCTION)

#define S_EXTREGISTER    8
#define M_EXTREGISTER    0xfU
#define V_EXTREGISTER(x) ((x) << S_EXTREGISTER)
#define G_EXTREGISTER(x) (((x) >> S_EXTREGISTER) & M_EXTREGISTER)

#define S_REGISTER    0
#define M_REGISTER    0xffU
#define V_REGISTER(x) ((x) << S_REGISTER)
#define G_REGISTER(x) (((x) >> S_REGISTER) & M_REGISTER)

#define S_CS2    28
#define V_CS2(x) ((x) << S_CS2)
#define F_CS2    V_CS2(1U)

#define S_WRBE    24
#define M_WRBE    0xfU
#define V_WRBE(x) ((x) << S_WRBE)
#define G_WRBE(x) (((x) >> S_WRBE) & M_WRBE)

#define S_CFG_SPACE_VFVLD    23
#define V_CFG_SPACE_VFVLD(x) ((x) << S_CFG_SPACE_VFVLD)
#define F_CFG_SPACE_VFVLD    V_CFG_SPACE_VFVLD(1U)

#define S_CFG_SPACE_RVF    16
#define M_CFG_SPACE_RVF    0x7fU
#define V_CFG_SPACE_RVF(x) ((x) << S_CFG_SPACE_RVF)
#define G_CFG_SPACE_RVF(x) (((x) >> S_CFG_SPACE_RVF) & M_CFG_SPACE_RVF)

#define S_CFG_SPACE_PF    12
#define M_CFG_SPACE_PF    0x7U
#define V_CFG_SPACE_PF(x) ((x) << S_CFG_SPACE_PF)
#define G_CFG_SPACE_PF(x) (((x) >> S_CFG_SPACE_PF) & M_CFG_SPACE_PF)

#define S_T6_ENABLE    31
#define V_T6_ENABLE(x) ((x) << S_T6_ENABLE)
#define F_T6_ENABLE    V_T6_ENABLE(1U)

#define S_T6_1_AI    30
#define V_T6_1_AI(x) ((x) << S_T6_1_AI)
#define F_T6_1_AI    V_T6_1_AI(1U)

#define S_T6_CS2    29
#define V_T6_CS2(x) ((x) << S_T6_CS2)
#define F_T6_CS2    V_T6_CS2(1U)

#define S_T6_WRBE    25
#define M_T6_WRBE    0xfU
#define V_T6_WRBE(x) ((x) << S_T6_WRBE)
#define G_T6_WRBE(x) (((x) >> S_T6_WRBE) & M_T6_WRBE)

#define S_T6_CFG_SPACE_VFVLD    24
#define V_T6_CFG_SPACE_VFVLD(x) ((x) << S_T6_CFG_SPACE_VFVLD)
#define F_T6_CFG_SPACE_VFVLD    V_T6_CFG_SPACE_VFVLD(1U)

#define S_T6_CFG_SPACE_RVF    16
#define M_T6_CFG_SPACE_RVF    0xffU
#define V_T6_CFG_SPACE_RVF(x) ((x) << S_T6_CFG_SPACE_RVF)
#define G_T6_CFG_SPACE_RVF(x) (((x) >> S_T6_CFG_SPACE_RVF) & M_T6_CFG_SPACE_RVF)

#define A_PCIE_CFG_SPACE_DATA 0x3064
#define A_PCIE_MEM_ACCESS_BASE_WIN 0x3068

#define S_PCIEOFST    10
#define M_PCIEOFST    0x3fffffU
#define V_PCIEOFST(x) ((x) << S_PCIEOFST)
#define G_PCIEOFST(x) (((x) >> S_PCIEOFST) & M_PCIEOFST)

#define S_BIR    8
#define M_BIR    0x3U
#define V_BIR(x) ((x) << S_BIR)
#define G_BIR(x) (((x) >> S_BIR) & M_BIR)

#define S_WINDOW    0
#define M_WINDOW    0xffU
#define V_WINDOW(x) ((x) << S_WINDOW)
#define G_WINDOW(x) (((x) >> S_WINDOW) & M_WINDOW)

#define A_PCIE_MEM_ACCESS_OFFSET 0x306c

#define S_MEMOFST    7
#define M_MEMOFST    0x1ffffffU
#define V_MEMOFST(x) ((x) << S_MEMOFST)
#define G_MEMOFST(x) (((x) >> S_MEMOFST) & M_MEMOFST)

#define A_T7_PCIE_MAILBOX_BASE_WIN 0x30a4
#define A_PCIE_MAILBOX_BASE_WIN 0x30a8

#define S_MBOXPCIEOFST    6
#define M_MBOXPCIEOFST    0x3ffffffU
#define V_MBOXPCIEOFST(x) ((x) << S_MBOXPCIEOFST)
#define G_MBOXPCIEOFST(x) (((x) >> S_MBOXPCIEOFST) & M_MBOXPCIEOFST)

#define S_MBOXBIR    4
#define M_MBOXBIR    0x3U
#define V_MBOXBIR(x) ((x) << S_MBOXBIR)
#define G_MBOXBIR(x) (((x) >> S_MBOXBIR) & M_MBOXBIR)

#define S_MBOXWIN    0
#define M_MBOXWIN    0x3U
#define V_MBOXWIN(x) ((x) << S_MBOXWIN)
#define G_MBOXWIN(x) (((x) >> S_MBOXWIN) & M_MBOXWIN)

#define A_PCIE_MAILBOX_OFFSET0 0x30a8

#define S_MEMOFST0    3
#define M_MEMOFST0    0x1fffffffU
#define V_MEMOFST0(x) ((x) << S_MEMOFST0)
#define G_MEMOFST0(x) (((x) >> S_MEMOFST0) & M_MEMOFST0)

#define A_PCIE_MAILBOX_OFFSET 0x30ac
#define A_PCIE_MAILBOX_OFFSET1 0x30ac

#define S_MEMOFST1    0
#define M_MEMOFST1    0xfU
#define V_MEMOFST1(x) ((x) << S_MEMOFST1)
#define G_MEMOFST1(x) (((x) >> S_MEMOFST1) & M_MEMOFST1)

#define A_PCIE_MA_CTRL 0x30b0

#define S_MA_TAGFREE    29
#define V_MA_TAGFREE(x) ((x) << S_MA_TAGFREE)
#define F_MA_TAGFREE    V_MA_TAGFREE(1U)

#define S_MA_MAXRSPCNT    24
#define M_MA_MAXRSPCNT    0x1fU
#define V_MA_MAXRSPCNT(x) ((x) << S_MA_MAXRSPCNT)
#define G_MA_MAXRSPCNT(x) (((x) >> S_MA_MAXRSPCNT) & M_MA_MAXRSPCNT)

#define S_MA_MAXREQCNT    16
#define M_MA_MAXREQCNT    0x1fU
#define V_MA_MAXREQCNT(x) ((x) << S_MA_MAXREQCNT)
#define G_MA_MAXREQCNT(x) (((x) >> S_MA_MAXREQCNT) & M_MA_MAXREQCNT)

#define S_MA_LE    15
#define V_MA_LE(x) ((x) << S_MA_LE)
#define F_MA_LE    V_MA_LE(1U)

#define S_MA_MAXPYLDSIZE    12
#define M_MA_MAXPYLDSIZE    0x7U
#define V_MA_MAXPYLDSIZE(x) ((x) << S_MA_MAXPYLDSIZE)
#define G_MA_MAXPYLDSIZE(x) (((x) >> S_MA_MAXPYLDSIZE) & M_MA_MAXPYLDSIZE)

#define S_MA_MAXRDREQSIZE    8
#define M_MA_MAXRDREQSIZE    0x7U
#define V_MA_MAXRDREQSIZE(x) ((x) << S_MA_MAXRDREQSIZE)
#define G_MA_MAXRDREQSIZE(x) (((x) >> S_MA_MAXRDREQSIZE) & M_MA_MAXRDREQSIZE)

#define S_MA_MAXTAG    0
#define M_MA_MAXTAG    0x1fU
#define V_MA_MAXTAG(x) ((x) << S_MA_MAXTAG)
#define G_MA_MAXTAG(x) (((x) >> S_MA_MAXTAG) & M_MA_MAXTAG)

#define S_T5_MA_MAXREQCNT    16
#define M_T5_MA_MAXREQCNT    0x7fU
#define V_T5_MA_MAXREQCNT(x) ((x) << S_T5_MA_MAXREQCNT)
#define G_T5_MA_MAXREQCNT(x) (((x) >> S_T5_MA_MAXREQCNT) & M_T5_MA_MAXREQCNT)

#define S_MA_MAXREQSIZE    8
#define M_MA_MAXREQSIZE    0x7U
#define V_MA_MAXREQSIZE(x) ((x) << S_MA_MAXREQSIZE)
#define G_MA_MAXREQSIZE(x) (((x) >> S_MA_MAXREQSIZE) & M_MA_MAXREQSIZE)

#define A_PCIE_MA_SYNC 0x30b4
#define A_PCIE_FW 0x30b8
#define A_PCIE_FW_PF 0x30bc
#define A_PCIE_PIO_PAUSE 0x30dc

#define S_PIOPAUSEDONE    31
#define V_PIOPAUSEDONE(x) ((x) << S_PIOPAUSEDONE)
#define F_PIOPAUSEDONE    V_PIOPAUSEDONE(1U)

#define S_PIOPAUSETIME    4
#define M_PIOPAUSETIME    0xffffffU
#define V_PIOPAUSETIME(x) ((x) << S_PIOPAUSETIME)
#define G_PIOPAUSETIME(x) (((x) >> S_PIOPAUSETIME) & M_PIOPAUSETIME)

#define S_PIOPAUSE    0
#define V_PIOPAUSE(x) ((x) << S_PIOPAUSE)
#define F_PIOPAUSE    V_PIOPAUSE(1U)

#define S_MSTPAUSEDONE    30
#define V_MSTPAUSEDONE(x) ((x) << S_MSTPAUSEDONE)
#define F_MSTPAUSEDONE    V_MSTPAUSEDONE(1U)

#define S_MSTPAUSE    1
#define V_MSTPAUSE(x) ((x) << S_MSTPAUSE)
#define F_MSTPAUSE    V_MSTPAUSE(1U)

#define A_PCIE_SYS_CFG_READY 0x30e0
#define A_PCIE_MA_STAT 0x30e0
#define A_PCIE_STATIC_CFG1 0x30e4

#define S_LINKDOWN_RESET_EN    26
#define V_LINKDOWN_RESET_EN(x) ((x) << S_LINKDOWN_RESET_EN)
#define F_LINKDOWN_RESET_EN    V_LINKDOWN_RESET_EN(1U)

#define S_IN_WR_DISCONTIG    25
#define V_IN_WR_DISCONTIG(x) ((x) << S_IN_WR_DISCONTIG)
#define F_IN_WR_DISCONTIG    V_IN_WR_DISCONTIG(1U)

#define S_IN_RD_CPLSIZE    22
#define M_IN_RD_CPLSIZE    0x7U
#define V_IN_RD_CPLSIZE(x) ((x) << S_IN_RD_CPLSIZE)
#define G_IN_RD_CPLSIZE(x) (((x) >> S_IN_RD_CPLSIZE) & M_IN_RD_CPLSIZE)

#define S_IN_RD_BUFMODE    20
#define M_IN_RD_BUFMODE    0x3U
#define V_IN_RD_BUFMODE(x) ((x) << S_IN_RD_BUFMODE)
#define G_IN_RD_BUFMODE(x) (((x) >> S_IN_RD_BUFMODE) & M_IN_RD_BUFMODE)

#define S_GBIF_NPTRANS_TOT    18
#define M_GBIF_NPTRANS_TOT    0x3U
#define V_GBIF_NPTRANS_TOT(x) ((x) << S_GBIF_NPTRANS_TOT)
#define G_GBIF_NPTRANS_TOT(x) (((x) >> S_GBIF_NPTRANS_TOT) & M_GBIF_NPTRANS_TOT)

#define S_IN_PDAT_TOT    15
#define M_IN_PDAT_TOT    0x7U
#define V_IN_PDAT_TOT(x) ((x) << S_IN_PDAT_TOT)
#define G_IN_PDAT_TOT(x) (((x) >> S_IN_PDAT_TOT) & M_IN_PDAT_TOT)

#define S_PCIE_NPTRANS_TOT    12
#define M_PCIE_NPTRANS_TOT    0x7U
#define V_PCIE_NPTRANS_TOT(x) ((x) << S_PCIE_NPTRANS_TOT)
#define G_PCIE_NPTRANS_TOT(x) (((x) >> S_PCIE_NPTRANS_TOT) & M_PCIE_NPTRANS_TOT)

#define S_OUT_PDAT_TOT    9
#define M_OUT_PDAT_TOT    0x7U
#define V_OUT_PDAT_TOT(x) ((x) << S_OUT_PDAT_TOT)
#define G_OUT_PDAT_TOT(x) (((x) >> S_OUT_PDAT_TOT) & M_OUT_PDAT_TOT)

#define S_GBIF_MAX_WRSIZE    6
#define M_GBIF_MAX_WRSIZE    0x7U
#define V_GBIF_MAX_WRSIZE(x) ((x) << S_GBIF_MAX_WRSIZE)
#define G_GBIF_MAX_WRSIZE(x) (((x) >> S_GBIF_MAX_WRSIZE) & M_GBIF_MAX_WRSIZE)

#define S_GBIF_MAX_RDSIZE    3
#define M_GBIF_MAX_RDSIZE    0x7U
#define V_GBIF_MAX_RDSIZE(x) ((x) << S_GBIF_MAX_RDSIZE)
#define G_GBIF_MAX_RDSIZE(x) (((x) >> S_GBIF_MAX_RDSIZE) & M_GBIF_MAX_RDSIZE)

#define S_PCIE_MAX_RDSIZE    0
#define M_PCIE_MAX_RDSIZE    0x7U
#define V_PCIE_MAX_RDSIZE(x) ((x) << S_PCIE_MAX_RDSIZE)
#define G_PCIE_MAX_RDSIZE(x) (((x) >> S_PCIE_MAX_RDSIZE) & M_PCIE_MAX_RDSIZE)

#define S_AUXPOWER_DETECTED    27
#define V_AUXPOWER_DETECTED(x) ((x) << S_AUXPOWER_DETECTED)
#define F_AUXPOWER_DETECTED    V_AUXPOWER_DETECTED(1U)

#define A_PCIE_STATIC_CFG2 0x30e8

#define S_PL_CONTROL    16
#define M_PL_CONTROL    0xffffU
#define V_PL_CONTROL(x) ((x) << S_PL_CONTROL)
#define G_PL_CONTROL(x) (((x) >> S_PL_CONTROL) & M_PL_CONTROL)

#define S_STATIC_SPARE3    0
#define M_STATIC_SPARE3    0x3fffU
#define V_STATIC_SPARE3(x) ((x) << S_STATIC_SPARE3)
#define G_STATIC_SPARE3(x) (((x) >> S_STATIC_SPARE3) & M_STATIC_SPARE3)

#define S_T7_STATIC_SPARE3    0
#define M_T7_STATIC_SPARE3    0x7fffU
#define V_T7_STATIC_SPARE3(x) ((x) << S_T7_STATIC_SPARE3)
#define G_T7_STATIC_SPARE3(x) (((x) >> S_T7_STATIC_SPARE3) & M_T7_STATIC_SPARE3)

#define A_PCIE_DBG_INDIR_REQ 0x30ec

#define S_DBGENABLE    31
#define V_DBGENABLE(x) ((x) << S_DBGENABLE)
#define F_DBGENABLE    V_DBGENABLE(1U)

#define S_DBGAUTOINC    30
#define V_DBGAUTOINC(x) ((x) << S_DBGAUTOINC)
#define F_DBGAUTOINC    V_DBGAUTOINC(1U)

#define S_POINTER    8
#define M_POINTER    0xffffU
#define V_POINTER(x) ((x) << S_POINTER)
#define G_POINTER(x) (((x) >> S_POINTER) & M_POINTER)

#define S_SELECT    0
#define M_SELECT    0xfU
#define V_SELECT(x) ((x) << S_SELECT)
#define G_SELECT(x) (((x) >> S_SELECT) & M_SELECT)

#define A_PCIE_DBG_INDIR_DATA_0 0x30f0
#define A_PCIE_DBG_INDIR_DATA_1 0x30f4
#define A_PCIE_DBG_INDIR_DATA_2 0x30f8
#define A_PCIE_DBG_INDIR_DATA_3 0x30fc
#define A_PCIE_FUNC_INT_CFG 0x3100

#define S_PBAOFST    28
#define M_PBAOFST    0xfU
#define V_PBAOFST(x) ((x) << S_PBAOFST)
#define G_PBAOFST(x) (((x) >> S_PBAOFST) & M_PBAOFST)

#define S_TABOFST    24
#define M_TABOFST    0xfU
#define V_TABOFST(x) ((x) << S_TABOFST)
#define G_TABOFST(x) (((x) >> S_TABOFST) & M_TABOFST)

#define S_VECNUM    12
#define M_VECNUM    0x3ffU
#define V_VECNUM(x) ((x) << S_VECNUM)
#define G_VECNUM(x) (((x) >> S_VECNUM) & M_VECNUM)

#define S_VECBASE    0
#define M_VECBASE    0x7ffU
#define V_VECBASE(x) ((x) << S_VECBASE)
#define G_VECBASE(x) (((x) >> S_VECBASE) & M_VECBASE)

#define A_PCIE_FUNC_CTL_STAT 0x3104

#define S_SENDFLRRSP    31
#define V_SENDFLRRSP(x) ((x) << S_SENDFLRRSP)
#define F_SENDFLRRSP    V_SENDFLRRSP(1U)

#define S_IMMFLRRSP    24
#define V_IMMFLRRSP(x) ((x) << S_IMMFLRRSP)
#define F_IMMFLRRSP    V_IMMFLRRSP(1U)

#define S_TXNDISABLE    20
#define V_TXNDISABLE(x) ((x) << S_TXNDISABLE)
#define F_TXNDISABLE    V_TXNDISABLE(1U)

#define S_PNDTXNS    8
#define M_PNDTXNS    0x3ffU
#define V_PNDTXNS(x) ((x) << S_PNDTXNS)
#define G_PNDTXNS(x) (((x) >> S_PNDTXNS) & M_PNDTXNS)

#define S_VFVLD    3
#define V_VFVLD(x) ((x) << S_VFVLD)
#define F_VFVLD    V_VFVLD(1U)

#define S_PFNUM    0
#define M_PFNUM    0x7U
#define V_PFNUM(x) ((x) << S_PFNUM)
#define G_PFNUM(x) (((x) >> S_PFNUM) & M_PFNUM)

#define A_PCIE_PF_INT_CFG 0x3140

#define S_T7_PF_INT_VECNUM    12
#define M_T7_PF_INT_VECNUM    0x7ffU
#define V_T7_PF_INT_VECNUM(x) ((x) << S_T7_PF_INT_VECNUM)
#define G_T7_PF_INT_VECNUM(x) (((x) >> S_T7_PF_INT_VECNUM) & M_T7_PF_INT_VECNUM)

#define S_T7_PF_INT_VECBASE    0
#define M_T7_PF_INT_VECBASE    0xfffU
#define V_T7_PF_INT_VECBASE(x) ((x) << S_T7_PF_INT_VECBASE)
#define G_T7_PF_INT_VECBASE(x) (((x) >> S_T7_PF_INT_VECBASE) & M_T7_PF_INT_VECBASE)

#define A_PCIE_PF_INT_CFG2 0x3144
#define A_PCIE_VF_INT_CFG 0x3180
#define A_PCIE_VF_INT_CFG2 0x3184
#define A_PCIE_PF_MSI_EN 0x35a8

#define S_PFMSIEN_7_0    0
#define M_PFMSIEN_7_0    0xffU
#define V_PFMSIEN_7_0(x) ((x) << S_PFMSIEN_7_0)
#define G_PFMSIEN_7_0(x) (((x) >> S_PFMSIEN_7_0) & M_PFMSIEN_7_0)

#define A_PCIE_VF_MSI_EN_0 0x35ac
#define A_PCIE_VF_MSI_EN_1 0x35b0
#define A_PCIE_VF_MSI_EN_2 0x35b4
#define A_PCIE_VF_MSI_EN_3 0x35b8
#define A_PCIE_PF_MSIX_EN 0x35bc

#define S_PFMSIXEN_7_0    0
#define M_PFMSIXEN_7_0    0xffU
#define V_PFMSIXEN_7_0(x) ((x) << S_PFMSIXEN_7_0)
#define G_PFMSIXEN_7_0(x) (((x) >> S_PFMSIXEN_7_0) & M_PFMSIXEN_7_0)

#define A_PCIE_VF_MSIX_EN_0 0x35c0
#define A_PCIE_VF_MSIX_EN_1 0x35c4
#define A_PCIE_VF_MSIX_EN_2 0x35c8
#define A_PCIE_VF_MSIX_EN_3 0x35cc
#define A_PCIE_FID_PASID 0x35e0
#define A_PCIE_FID_VFID_CTL 0x35e4

#define S_T7_WRITE    0
#define V_T7_WRITE(x) ((x) << S_T7_WRITE)
#define F_T7_WRITE    V_T7_WRITE(1U)

#define A_T7_PCIE_FID_VFID_SEL 0x35e8

#define S_T7_ADDR    2
#define M_T7_ADDR    0x1fffU
#define V_T7_ADDR(x) ((x) << S_T7_ADDR)
#define G_T7_ADDR(x) (((x) >> S_T7_ADDR) & M_T7_ADDR)

#define A_PCIE_FID_VFID_SEL 0x35ec

#define S_FID_VFID_SEL_SELECT    0
#define M_FID_VFID_SEL_SELECT    0x3U
#define V_FID_VFID_SEL_SELECT(x) ((x) << S_FID_VFID_SEL_SELECT)
#define G_FID_VFID_SEL_SELECT(x) (((x) >> S_FID_VFID_SEL_SELECT) & M_FID_VFID_SEL_SELECT)

#define A_T7_PCIE_FID_VFID 0x35ec

#define S_FID_VFID_NVMEGROUPEN    29
#define V_FID_VFID_NVMEGROUPEN(x) ((x) << S_FID_VFID_NVMEGROUPEN)
#define F_FID_VFID_NVMEGROUPEN    V_FID_VFID_NVMEGROUPEN(1U)

#define S_FID_VFID_GROUPSEL    25
#define M_FID_VFID_GROUPSEL    0xfU
#define V_FID_VFID_GROUPSEL(x) ((x) << S_FID_VFID_GROUPSEL)
#define G_FID_VFID_GROUPSEL(x) (((x) >> S_FID_VFID_GROUPSEL) & M_FID_VFID_GROUPSEL)

#define A_PCIE_FID_VFID 0x3600

#define S_FID_VFID_SELECT    30
#define M_FID_VFID_SELECT    0x3U
#define V_FID_VFID_SELECT(x) ((x) << S_FID_VFID_SELECT)
#define G_FID_VFID_SELECT(x) (((x) >> S_FID_VFID_SELECT) & M_FID_VFID_SELECT)

#define S_IDO    24
#define V_IDO(x) ((x) << S_IDO)
#define F_IDO    V_IDO(1U)

#define S_FID_VFID_VFID    16
#define M_FID_VFID_VFID    0xffU
#define V_FID_VFID_VFID(x) ((x) << S_FID_VFID_VFID)
#define G_FID_VFID_VFID(x) (((x) >> S_FID_VFID_VFID) & M_FID_VFID_VFID)

#define S_FID_VFID_TC    11
#define M_FID_VFID_TC    0x7U
#define V_FID_VFID_TC(x) ((x) << S_FID_VFID_TC)
#define G_FID_VFID_TC(x) (((x) >> S_FID_VFID_TC) & M_FID_VFID_TC)

#define S_FID_VFID_VFVLD    10
#define V_FID_VFID_VFVLD(x) ((x) << S_FID_VFID_VFVLD)
#define F_FID_VFID_VFVLD    V_FID_VFID_VFVLD(1U)

#define S_FID_VFID_PF    7
#define M_FID_VFID_PF    0x7U
#define V_FID_VFID_PF(x) ((x) << S_FID_VFID_PF)
#define G_FID_VFID_PF(x) (((x) >> S_FID_VFID_PF) & M_FID_VFID_PF)

#define S_FID_VFID_RVF    0
#define M_FID_VFID_RVF    0x7fU
#define V_FID_VFID_RVF(x) ((x) << S_FID_VFID_RVF)
#define G_FID_VFID_RVF(x) (((x) >> S_FID_VFID_RVF) & M_FID_VFID_RVF)

#define S_T6_FID_VFID_VFID    15
#define M_T6_FID_VFID_VFID    0x1ffU
#define V_T6_FID_VFID_VFID(x) ((x) << S_T6_FID_VFID_VFID)
#define G_T6_FID_VFID_VFID(x) (((x) >> S_T6_FID_VFID_VFID) & M_T6_FID_VFID_VFID)

#define S_T6_FID_VFID_TC    12
#define M_T6_FID_VFID_TC    0x7U
#define V_T6_FID_VFID_TC(x) ((x) << S_T6_FID_VFID_TC)
#define G_T6_FID_VFID_TC(x) (((x) >> S_T6_FID_VFID_TC) & M_T6_FID_VFID_TC)

#define S_T6_FID_VFID_VFVLD    11
#define V_T6_FID_VFID_VFVLD(x) ((x) << S_T6_FID_VFID_VFVLD)
#define F_T6_FID_VFID_VFVLD    V_T6_FID_VFID_VFVLD(1U)

#define S_T6_FID_VFID_PF    8
#define M_T6_FID_VFID_PF    0x7U
#define V_T6_FID_VFID_PF(x) ((x) << S_T6_FID_VFID_PF)
#define G_T6_FID_VFID_PF(x) (((x) >> S_T6_FID_VFID_PF) & M_T6_FID_VFID_PF)

#define S_T6_FID_VFID_RVF    0
#define M_T6_FID_VFID_RVF    0xffU
#define V_T6_FID_VFID_RVF(x) ((x) << S_T6_FID_VFID_RVF)
#define G_T6_FID_VFID_RVF(x) (((x) >> S_T6_FID_VFID_RVF) & M_T6_FID_VFID_RVF)

#define A_PCIE_JBOF_NVME_HIGH_DW_START_ADDR 0x3600
#define A_PCIE_JBOF_NVME_LOW_DW_START_ADDR 0x3604
#define A_PCIE_JBOF_NVME_LENGTH 0x3608

#define S_NVMEDISABLE    31
#define V_NVMEDISABLE(x) ((x) << S_NVMEDISABLE)
#define F_NVMEDISABLE    V_NVMEDISABLE(1U)

#define S_NVMELENGTH    0
#define M_NVMELENGTH    0x3fffffffU
#define V_NVMELENGTH(x) ((x) << S_NVMELENGTH)
#define G_NVMELENGTH(x) (((x) >> S_NVMELENGTH) & M_NVMELENGTH)

#define A_PCIE_JBOF_NVME_GROUP 0x360c

#define S_NVMEGROUPSEL    0
#define M_NVMEGROUPSEL    0xfU
#define V_NVMEGROUPSEL(x) ((x) << S_NVMEGROUPSEL)
#define G_NVMEGROUPSEL(x) (((x) >> S_NVMEGROUPSEL) & M_NVMEGROUPSEL)

#define A_T7_PCIE_MEM_ACCESS_BASE_WIN 0x3700
#define A_PCIE_MEM_ACCESS_BASE_WIN1 0x3704

#define S_PCIEOFST1    0
#define M_PCIEOFST1    0xffU
#define V_PCIEOFST1(x) ((x) << S_PCIEOFST1)
#define G_PCIEOFST1(x) (((x) >> S_PCIEOFST1) & M_PCIEOFST1)

#define A_PCIE_MEM_ACCESS_OFFSET0 0x3708
#define A_PCIE_MEM_ACCESS_OFFSET1 0x370c
#define A_PCIE_PTM_EP_EXT_STROBE 0x3804

#define S_PTM_AUTO_UPDATE    1
#define V_PTM_AUTO_UPDATE(x) ((x) << S_PTM_AUTO_UPDATE)
#define F_PTM_AUTO_UPDATE    V_PTM_AUTO_UPDATE(1U)

#define S_PTM_EXT_STROBE    0
#define V_PTM_EXT_STROBE(x) ((x) << S_PTM_EXT_STROBE)
#define F_PTM_EXT_STROBE    V_PTM_EXT_STROBE(1U)

#define A_PCIE_PTM_EP_EXT_TIME0 0x3808
#define A_PCIE_PTM_EP_EXT_TIME1 0x380c
#define A_PCIE_PTM_MAN_UPD_PULSE 0x3810

#define S_PTM_MAN_UPD_PULSE    0
#define V_PTM_MAN_UPD_PULSE(x) ((x) << S_PTM_MAN_UPD_PULSE)
#define F_PTM_MAN_UPD_PULSE    V_PTM_MAN_UPD_PULSE(1U)

#define A_PCIE_SWAP_DATA_B2L_X16 0x3814
#define A_PCIE_PCIE_RC_RST 0x3818

#define S_PERST    0
#define V_PERST(x) ((x) << S_PERST)
#define F_PERST    V_PERST(1U)

#define A_PCIE_PCIE_LN_CLKSEL 0x3880

#define S_DS8_SEL    30
#define M_DS8_SEL    0x3U
#define V_DS8_SEL(x) ((x) << S_DS8_SEL)
#define G_DS8_SEL(x) (((x) >> S_DS8_SEL) & M_DS8_SEL)

#define S_DS7_SEL    28
#define M_DS7_SEL    0x3U
#define V_DS7_SEL(x) ((x) << S_DS7_SEL)
#define G_DS7_SEL(x) (((x) >> S_DS7_SEL) & M_DS7_SEL)

#define S_DS6_SEL    26
#define M_DS6_SEL    0x3U
#define V_DS6_SEL(x) ((x) << S_DS6_SEL)
#define G_DS6_SEL(x) (((x) >> S_DS6_SEL) & M_DS6_SEL)

#define S_DS5_SEL    24
#define M_DS5_SEL    0x3U
#define V_DS5_SEL(x) ((x) << S_DS5_SEL)
#define G_DS5_SEL(x) (((x) >> S_DS5_SEL) & M_DS5_SEL)

#define S_DS4_SEL    22
#define M_DS4_SEL    0x3U
#define V_DS4_SEL(x) ((x) << S_DS4_SEL)
#define G_DS4_SEL(x) (((x) >> S_DS4_SEL) & M_DS4_SEL)

#define S_DS3_SEL    20
#define M_DS3_SEL    0x3U
#define V_DS3_SEL(x) ((x) << S_DS3_SEL)
#define G_DS3_SEL(x) (((x) >> S_DS3_SEL) & M_DS3_SEL)

#define S_DS2_SEL    18
#define M_DS2_SEL    0x3U
#define V_DS2_SEL(x) ((x) << S_DS2_SEL)
#define G_DS2_SEL(x) (((x) >> S_DS2_SEL) & M_DS2_SEL)

#define S_DS1_SEL    16
#define M_DS1_SEL    0x3U
#define V_DS1_SEL(x) ((x) << S_DS1_SEL)
#define G_DS1_SEL(x) (((x) >> S_DS1_SEL) & M_DS1_SEL)

#define S_LN14_SEL    14
#define M_LN14_SEL    0x3U
#define V_LN14_SEL(x) ((x) << S_LN14_SEL)
#define G_LN14_SEL(x) (((x) >> S_LN14_SEL) & M_LN14_SEL)

#define S_LN12_SEL    12
#define M_LN12_SEL    0x3U
#define V_LN12_SEL(x) ((x) << S_LN12_SEL)
#define G_LN12_SEL(x) (((x) >> S_LN12_SEL) & M_LN12_SEL)

#define S_LN10_SEL    10
#define M_LN10_SEL    0x3U
#define V_LN10_SEL(x) ((x) << S_LN10_SEL)
#define G_LN10_SEL(x) (((x) >> S_LN10_SEL) & M_LN10_SEL)

#define S_LN8_SEL    8
#define M_LN8_SEL    0x3U
#define V_LN8_SEL(x) ((x) << S_LN8_SEL)
#define G_LN8_SEL(x) (((x) >> S_LN8_SEL) & M_LN8_SEL)

#define S_LN6_SEL    6
#define M_LN6_SEL    0x3U
#define V_LN6_SEL(x) ((x) << S_LN6_SEL)
#define G_LN6_SEL(x) (((x) >> S_LN6_SEL) & M_LN6_SEL)

#define S_LN4_SEL    4
#define M_LN4_SEL    0x3U
#define V_LN4_SEL(x) ((x) << S_LN4_SEL)
#define G_LN4_SEL(x) (((x) >> S_LN4_SEL) & M_LN4_SEL)

#define S_LN2_SEL    2
#define M_LN2_SEL    0x3U
#define V_LN2_SEL(x) ((x) << S_LN2_SEL)
#define G_LN2_SEL(x) (((x) >> S_LN2_SEL) & M_LN2_SEL)

#define S_LN0_SEL    0
#define M_LN0_SEL    0x3U
#define V_LN0_SEL(x) ((x) << S_LN0_SEL)
#define G_LN0_SEL(x) (((x) >> S_LN0_SEL) & M_LN0_SEL)

#define A_PCIE_PCIE_MSIX_EN 0x3884

#define S_MSIX_ENABLE    0
#define M_MSIX_ENABLE    0xffU
#define V_MSIX_ENABLE(x) ((x) << S_MSIX_ENABLE)
#define G_MSIX_ENABLE(x) (((x) >> S_MSIX_ENABLE) & M_MSIX_ENABLE)

#define A_PCIE_LFSR_WRCTRL 0x3888

#define S_WR_LFSR_CMP_DATA    16
#define M_WR_LFSR_CMP_DATA    0xffffU
#define V_WR_LFSR_CMP_DATA(x) ((x) << S_WR_LFSR_CMP_DATA)
#define G_WR_LFSR_CMP_DATA(x) (((x) >> S_WR_LFSR_CMP_DATA) & M_WR_LFSR_CMP_DATA)

#define S_WR_LFSR_RSVD    2
#define M_WR_LFSR_RSVD    0x3fffU
#define V_WR_LFSR_RSVD(x) ((x) << S_WR_LFSR_RSVD)
#define G_WR_LFSR_RSVD(x) (((x) >> S_WR_LFSR_RSVD) & M_WR_LFSR_RSVD)

#define S_WR_LFSR_EN    1
#define V_WR_LFSR_EN(x) ((x) << S_WR_LFSR_EN)
#define F_WR_LFSR_EN    V_WR_LFSR_EN(1U)

#define S_WR_LFSR_START    0
#define V_WR_LFSR_START(x) ((x) << S_WR_LFSR_START)
#define F_WR_LFSR_START    V_WR_LFSR_START(1U)

#define A_PCIE_LFSR_RDCTRL 0x388c

#define S_CMD_LFSR_CMP_DATA    24
#define M_CMD_LFSR_CMP_DATA    0xffU
#define V_CMD_LFSR_CMP_DATA(x) ((x) << S_CMD_LFSR_CMP_DATA)
#define G_CMD_LFSR_CMP_DATA(x) (((x) >> S_CMD_LFSR_CMP_DATA) & M_CMD_LFSR_CMP_DATA)

#define S_RD_LFSR_CMD_DATA    16
#define M_RD_LFSR_CMD_DATA    0xffU
#define V_RD_LFSR_CMD_DATA(x) ((x) << S_RD_LFSR_CMD_DATA)
#define G_RD_LFSR_CMD_DATA(x) (((x) >> S_RD_LFSR_CMD_DATA) & M_RD_LFSR_CMD_DATA)

#define S_RD_LFSR_RSVD    10
#define M_RD_LFSR_RSVD    0x3fU
#define V_RD_LFSR_RSVD(x) ((x) << S_RD_LFSR_RSVD)
#define G_RD_LFSR_RSVD(x) (((x) >> S_RD_LFSR_RSVD) & M_RD_LFSR_RSVD)

#define S_RD3_LFSR_EN    9
#define V_RD3_LFSR_EN(x) ((x) << S_RD3_LFSR_EN)
#define F_RD3_LFSR_EN    V_RD3_LFSR_EN(1U)

#define S_RD3_LFSR_START    8
#define V_RD3_LFSR_START(x) ((x) << S_RD3_LFSR_START)
#define F_RD3_LFSR_START    V_RD3_LFSR_START(1U)

#define S_RD2_LFSR_EN    7
#define V_RD2_LFSR_EN(x) ((x) << S_RD2_LFSR_EN)
#define F_RD2_LFSR_EN    V_RD2_LFSR_EN(1U)

#define S_RD2_LFSR_START    6
#define V_RD2_LFSR_START(x) ((x) << S_RD2_LFSR_START)
#define F_RD2_LFSR_START    V_RD2_LFSR_START(1U)

#define S_RD1_LFSR_EN    5
#define V_RD1_LFSR_EN(x) ((x) << S_RD1_LFSR_EN)
#define F_RD1_LFSR_EN    V_RD1_LFSR_EN(1U)

#define S_RD1_LFSR_START    4
#define V_RD1_LFSR_START(x) ((x) << S_RD1_LFSR_START)
#define F_RD1_LFSR_START    V_RD1_LFSR_START(1U)

#define S_RD0_LFSR_EN    3
#define V_RD0_LFSR_EN(x) ((x) << S_RD0_LFSR_EN)
#define F_RD0_LFSR_EN    V_RD0_LFSR_EN(1U)

#define S_RD0_LFSR_START    2
#define V_RD0_LFSR_START(x) ((x) << S_RD0_LFSR_START)
#define F_RD0_LFSR_START    V_RD0_LFSR_START(1U)

#define S_CMD_LFSR_EN    1
#define V_CMD_LFSR_EN(x) ((x) << S_CMD_LFSR_EN)
#define F_CMD_LFSR_EN    V_CMD_LFSR_EN(1U)

#define S_CMD_LFSR_START    0
#define V_CMD_LFSR_START(x) ((x) << S_CMD_LFSR_START)
#define F_CMD_LFSR_START    V_CMD_LFSR_START(1U)

#define A_PCIE_FID 0x3900

#define S_PAD    11
#define V_PAD(x) ((x) << S_PAD)
#define F_PAD    V_PAD(1U)

#define S_TC    8
#define M_TC    0x7U
#define V_TC(x) ((x) << S_TC)
#define G_TC(x) (((x) >> S_TC) & M_TC)

#define S_FUNC    0
#define M_FUNC    0xffU
#define V_FUNC(x) ((x) << S_FUNC)
#define G_FUNC(x) (((x) >> S_FUNC) & M_FUNC)

#define A_PCIE_EMU_ADDR 0x3900

#define S_EMU_ADDR    0
#define M_EMU_ADDR    0x1ffU
#define V_EMU_ADDR(x) ((x) << S_EMU_ADDR)
#define G_EMU_ADDR(x) (((x) >> S_EMU_ADDR) & M_EMU_ADDR)

#define A_PCIE_EMU_CFG 0x3904

#define S_EMUENABLE    16
#define V_EMUENABLE(x) ((x) << S_EMUENABLE)
#define F_EMUENABLE    V_EMUENABLE(1U)

#define S_EMUTYPE    14
#define M_EMUTYPE    0x3U
#define V_EMUTYPE(x) ((x) << S_EMUTYPE)
#define G_EMUTYPE(x) (((x) >> S_EMUTYPE) & M_EMUTYPE)

#define S_BAR0TARGET    12
#define M_BAR0TARGET    0x3U
#define V_BAR0TARGET(x) ((x) << S_BAR0TARGET)
#define G_BAR0TARGET(x) (((x) >> S_BAR0TARGET) & M_BAR0TARGET)

#define S_BAR2TARGET    10
#define M_BAR2TARGET    0x3U
#define V_BAR2TARGET(x) ((x) << S_BAR2TARGET)
#define G_BAR2TARGET(x) (((x) >> S_BAR2TARGET) & M_BAR2TARGET)

#define S_BAR4TARGET    8
#define M_BAR4TARGET    0x3U
#define V_BAR4TARGET(x) ((x) << S_BAR4TARGET)
#define G_BAR4TARGET(x) (((x) >> S_BAR4TARGET) & M_BAR4TARGET)

#define S_RELEATIVEEMUID    0
#define M_RELEATIVEEMUID    0xffU
#define V_RELEATIVEEMUID(x) ((x) << S_RELEATIVEEMUID)
#define G_RELEATIVEEMUID(x) (((x) >> S_RELEATIVEEMUID) & M_RELEATIVEEMUID)

#define A_PCIE_EMUADRRMAP_MEM_OFFSET0_BAR0 0x3910

#define S_T7_MEMOFST0    0
#define M_T7_MEMOFST0    0xfffffffU
#define V_T7_MEMOFST0(x) ((x) << S_T7_MEMOFST0)
#define G_T7_MEMOFST0(x) (((x) >> S_T7_MEMOFST0) & M_T7_MEMOFST0)

#define A_PCIE_EMUADRRMAP_MEM_CFG0_BAR0 0x3914

#define S_SIZE0    0
#define M_SIZE0    0x1fU
#define V_SIZE0(x) ((x) << S_SIZE0)
#define G_SIZE0(x) (((x) >> S_SIZE0) & M_SIZE0)

#define A_PCIE_EMUADRRMAP_MEM_OFFSET1_BAR0 0x3918

#define S_T7_MEMOFST1    0
#define M_T7_MEMOFST1    0xfffffffU
#define V_T7_MEMOFST1(x) ((x) << S_T7_MEMOFST1)
#define G_T7_MEMOFST1(x) (((x) >> S_T7_MEMOFST1) & M_T7_MEMOFST1)

#define A_PCIE_EMUADRRMAP_MEM_CFG1_BAR0 0x391c

#define S_SIZE1    0
#define M_SIZE1    0x1fU
#define V_SIZE1(x) ((x) << S_SIZE1)
#define G_SIZE1(x) (((x) >> S_SIZE1) & M_SIZE1)

#define A_PCIE_EMUADRRMAP_MEM_OFFSET2_BAR0 0x3920

#define S_MEMOFST2    0
#define M_MEMOFST2    0xfffffffU
#define V_MEMOFST2(x) ((x) << S_MEMOFST2)
#define G_MEMOFST2(x) (((x) >> S_MEMOFST2) & M_MEMOFST2)

#define A_PCIE_EMUADRRMAP_MEM_CFG2_BAR0 0x3924

#define S_SIZE2    0
#define M_SIZE2    0x1fU
#define V_SIZE2(x) ((x) << S_SIZE2)
#define G_SIZE2(x) (((x) >> S_SIZE2) & M_SIZE2)

#define A_PCIE_EMUADRRMAP_MEM_OFFSET3_BAR0 0x3928

#define S_MEMOFST3    0
#define M_MEMOFST3    0xfffffffU
#define V_MEMOFST3(x) ((x) << S_MEMOFST3)
#define G_MEMOFST3(x) (((x) >> S_MEMOFST3) & M_MEMOFST3)

#define A_PCIE_EMUADRRMAP_MEM_CFG3_BAR0 0x392c

#define S_SIZE3    0
#define M_SIZE3    0x1fU
#define V_SIZE3(x) ((x) << S_SIZE3)
#define G_SIZE3(x) (((x) >> S_SIZE3) & M_SIZE3)

#define A_PCIE_TCAM_DATA 0x3970
#define A_PCIE_TCAM_CTL 0x3974

#define S_TCAMADDR    8
#define M_TCAMADDR    0x3ffU
#define V_TCAMADDR(x) ((x) << S_TCAMADDR)
#define G_TCAMADDR(x) (((x) >> S_TCAMADDR) & M_TCAMADDR)

#define S_CAMEN    0
#define V_CAMEN(x) ((x) << S_CAMEN)
#define F_CAMEN    V_CAMEN(1U)

#define A_PCIE_TCAM_DBG 0x3978

#define S_CBPASS    24
#define V_CBPASS(x) ((x) << S_CBPASS)
#define F_CBPASS    V_CBPASS(1U)

#define S_CBBUSY    20
#define V_CBBUSY(x) ((x) << S_CBBUSY)
#define F_CBBUSY    V_CBBUSY(1U)

#define S_CBSTART    17
#define V_CBSTART(x) ((x) << S_CBSTART)
#define F_CBSTART    V_CBSTART(1U)

#define S_RSTCB    16
#define V_RSTCB(x) ((x) << S_RSTCB)
#define F_RSTCB    V_RSTCB(1U)

#define S_TCAM_DBG_DATA    0
#define M_TCAM_DBG_DATA    0xffffU
#define V_TCAM_DBG_DATA(x) ((x) << S_TCAM_DBG_DATA)
#define G_TCAM_DBG_DATA(x) (((x) >> S_TCAM_DBG_DATA) & M_TCAM_DBG_DATA)

#define A_PCIE_TEST_CTRL0 0x3980
#define A_PCIE_TEST_CTRL1 0x3984
#define A_PCIE_TEST_CTRL2 0x3988
#define A_PCIE_TEST_CTRL3 0x398c
#define A_PCIE_TEST_STS0 0x3990
#define A_PCIE_TEST_STS1 0x3994
#define A_PCIE_TEST_STS2 0x3998
#define A_PCIE_TEST_STS3 0x399c
#define A_PCIE_X8_CORE_ACK_LATENCY_TIMER_REPLAY_TIMER 0x4700
#define A_PCIE_X8_CORE_VENDOR_SPECIFIC_DLLP 0x4704
#define A_PCIE_X8_CORE_PORT_FORCE_LINK 0x4708
#define A_PCIE_X8_CORE_ACK_FREQUENCY_L0L1_ASPM_CONTROL 0x470c
#define A_PCIE_X8_CORE_PORT_LINK_CONTROL 0x4710
#define A_PCIE_X8_CORE_LANE_SKEW 0x4714
#define A_PCIE_X8_CORE_SYMBOL_NUMBER 0x4718
#define A_PCIE_X8_CORE_SYMBOL_TIMER_FILTER_MASK1 0x471c
#define A_PCIE_X8_CORE_FILTER_MASK2 0x4720
#define A_PCIE_X8_CORE_DEBUG_0 0x4728
#define A_PCIE_X8_CORE_DEBUG_1 0x472c
#define A_PCIE_X8_CORE_TRANSMIT_POSTED_FC_CREDIT_STATUS 0x4730
#define A_PCIE_X8_CORE_TRANSMIT_NONPOSTED_FC_CREDIT_STATUS 0x4734
#define A_PCIE_X8_CORE_TRANSMIT_COMPLETION_FC_CREDIT_STATUS 0x4738
#define A_PCIE_X8_CORE_QUEUE_STATUS 0x473c
#define A_PCIE_X8_CORE_VC_TRANSMIT_ARBITRATION_1 0x4740
#define A_PCIE_X8_CORE_VC_TRANSMIT_ARBITRATION_2 0x4744
#define A_PCIE_X8_CORE_VC0_POSTED_RECEIVE_QUEUE_CONTROL 0x4748
#define A_PCIE_X8_CORE_VC0_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x474c
#define A_PCIE_X8_CORE_VC0_COMPLETION_RECEIVE_QUEUE_CONTROL 0x4750
#define A_PCIE_X8_CORE_VC1_POSTED_RECEIVE_QUEUE_CONTROL 0x4754
#define A_PCIE_X8_CORE_VC1_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x4758
#define A_PCIE_X8_CORE_VC1_COMPLETION_RECEIVE_QUEUE_CONTROL 0x475c
#define A_PCIE_X8_CORE_LINK_WIDTH_SPEED_CHANGE 0x480c
#define A_PCIE_X8_CORE_PHY_STATUS 0x4810
#define A_PCIE_X8_CORE_PHY_CONTROL 0x4814
#define A_PCIE_X8_CORE_GEN3_CONTROL 0x4890
#define A_PCIE_X8_CORE_GEN3_EQ_FS_LF 0x4894
#define A_PCIE_X8_CORE_GEN3_EQ_PRESET_COEFF 0x4898
#define A_PCIE_X8_CORE_GEN3_EQ_PRESET_INDEX 0x489c
#define A_PCIE_X8_CORE_GEN3_EQ_STATUS 0x48a4
#define A_PCIE_X8_CORE_GEN3_EQ_CONTROL 0x48a8
#define A_PCIE_X8_CORE_GEN3_EQ_DIRCHANGE_FEEDBACK 0x48ac
#define A_PCIE_X8_CORE_PIPE_CONTROL 0x48b8
#define A_PCIE_X8_CORE_DBI_RO_WE 0x48bc
#define A_PCIE_X8_CFG_SPACE_REQ 0x48c0
#define A_PCIE_X8_CFG_SPACE_DATA 0x48c4
#define A_PCIE_X8_CFG_MPS_MRS 0x4900

#define S_MRS    3
#define M_MRS    0x7U
#define V_MRS(x) ((x) << S_MRS)
#define G_MRS(x) (((x) >> S_MRS) & M_MRS)

#define S_T7_MPS    0
#define M_T7_MPS    0x7U
#define V_T7_MPS(x) ((x) << S_T7_MPS)
#define G_T7_MPS(x) (((x) >> S_T7_MPS) & M_T7_MPS)

#define A_PCIE_X8_CFG_ATTRIBUTES 0x4904

#define S_T7_DCAEN    2
#define V_T7_DCAEN(x) ((x) << S_T7_DCAEN)
#define F_T7_DCAEN    V_T7_DCAEN(1U)

#define S_DCASTFITTRAONLEN    1
#define V_DCASTFITTRAONLEN(x) ((x) << S_DCASTFITTRAONLEN)
#define F_DCASTFITTRAONLEN    V_DCASTFITTRAONLEN(1U)

#define S_REQCTLDYNSTCLKEN    0
#define V_REQCTLDYNSTCLKEN(x) ((x) << S_REQCTLDYNSTCLKEN)
#define F_REQCTLDYNSTCLKEN    V_REQCTLDYNSTCLKEN(1U)

#define A_PCIE_X8_CFG_LTSSM 0x4908

#define S_APP_LTSSM_ENABLE    0
#define V_APP_LTSSM_ENABLE(x) ((x) << S_APP_LTSSM_ENABLE)
#define F_APP_LTSSM_ENABLE    V_APP_LTSSM_ENABLE(1U)

#define A_PCIE_ARM_REQUESTER_ID_X8 0x490c

#define S_A1_RSVD1    24
#define M_A1_RSVD1    0xffU
#define V_A1_RSVD1(x) ((x) << S_A1_RSVD1)
#define G_A1_RSVD1(x) (((x) >> S_A1_RSVD1) & M_A1_RSVD1)

#define S_A1_PRIMBUSNUMBER    16
#define M_A1_PRIMBUSNUMBER    0xffU
#define V_A1_PRIMBUSNUMBER(x) ((x) << S_A1_PRIMBUSNUMBER)
#define G_A1_PRIMBUSNUMBER(x) (((x) >> S_A1_PRIMBUSNUMBER) & M_A1_PRIMBUSNUMBER)

#define S_A1_REQUESTERID    0
#define M_A1_REQUESTERID    0xffffU
#define V_A1_REQUESTERID(x) ((x) << S_A1_REQUESTERID)
#define G_A1_REQUESTERID(x) (((x) >> S_A1_REQUESTERID) & M_A1_REQUESTERID)

#define A_PCIE_SWAP_DATA_B2L_X8 0x4910

#define S_CFGRD_SWAP_EN    1
#define V_CFGRD_SWAP_EN(x) ((x) << S_CFGRD_SWAP_EN)
#define F_CFGRD_SWAP_EN    V_CFGRD_SWAP_EN(1U)

#define S_CFGWR_SWAP_EN    0
#define V_CFGWR_SWAP_EN(x) ((x) << S_CFGWR_SWAP_EN)
#define F_CFGWR_SWAP_EN    V_CFGWR_SWAP_EN(1U)

#define A_PCIE_PDEBUG_DATA0_X8 0x4914
#define A_PCIE_PDEBUG_DATA1_X8 0x4918
#define A_PCIE_PDEBUG_DATA2_X8 0x491c
#define A_PCIE_PDEBUG_CTRL_X8 0x4920
#define A_PCIE_PDEBUG_DATA_X8 0x4924
#define A_PCIE_SPARE_REGISTER_SPACES_X8 0x4ffc
#define A_PCIE_PIPE_LANE0_REG0 0x5500
#define A_PCIE_PIPE_LANE0_REG1 0x5504
#define A_PCIE_PIPE_LANE0_REG2 0x5508
#define A_PCIE_PIPE_LANE0_REG3 0x550c
#define A_PCIE_PIPE_LANE1_REG0 0x5510
#define A_PCIE_PIPE_LANE1_REG1 0x5514
#define A_PCIE_PIPE_LANE1_REG2 0x5518
#define A_PCIE_PIPE_LANE1_REG3 0x551c
#define A_PCIE_PIPE_LANE2_REG0 0x5520
#define A_PCIE_PIPE_LANE2_REG1 0x5524
#define A_PCIE_PIPE_LANE2_REG2 0x5528
#define A_PCIE_PIPE_LANE2_REG3 0x552c
#define A_PCIE_PIPE_LANE3_REG0 0x5530
#define A_PCIE_PIPE_LANE3_REG1 0x5534
#define A_PCIE_PIPE_LANE3_REG2 0x5538
#define A_PCIE_PIPE_LANE3_REG3 0x553c
#define A_PCIE_PIPE_LANE4_REG0 0x5540
#define A_PCIE_PIPE_LANE4_REG1 0x5544
#define A_PCIE_PIPE_LANE4_REG2 0x5548
#define A_PCIE_PIPE_LANE4_REG3 0x554c
#define A_PCIE_PIPE_LANE5_REG0 0x5550
#define A_PCIE_PIPE_LANE5_REG1 0x5554
#define A_PCIE_PIPE_LANE5_REG2 0x5558
#define A_PCIE_PIPE_LANE5_REG3 0x555c
#define A_PCIE_PIPE_LANE6_REG0 0x5560
#define A_PCIE_PIPE_LANE6_REG1 0x5564
#define A_PCIE_PIPE_LANE6_REG2 0x5568
#define A_PCIE_PIPE_LANE6_REG3 0x556c
#define A_PCIE_PIPE_LANE7_REG0 0x5570
#define A_PCIE_PIPE_LANE7_REG1 0x5574
#define A_PCIE_PIPE_LANE7_REG2 0x5578
#define A_PCIE_PIPE_LANE7_REG3 0x557c
#define A_PCIE_PIPE_LANE8_REG0 0x5580
#define A_PCIE_PIPE_LANE8_REG1 0x5584
#define A_PCIE_PIPE_LANE8_REG2 0x5588
#define A_PCIE_PIPE_LANE8_REG3 0x558c
#define A_PCIE_PIPE_LANE9_REG0 0x5590
#define A_PCIE_PIPE_LANE9_REG1 0x5594
#define A_PCIE_PIPE_LANE9_REG2 0x5598
#define A_PCIE_PIPE_LANE9_REG3 0x559c
#define A_PCIE_PIPE_LANE10_REG0 0x55a0
#define A_PCIE_PIPE_LANE10_REG1 0x55a4
#define A_PCIE_PIPE_LANE10_REG2 0x55a8
#define A_PCIE_PIPE_LANE10_REG3 0x55ac
#define A_PCIE_PIPE_LANE11_REG0 0x55b0
#define A_PCIE_PIPE_LANE11_REG1 0x55b4
#define A_PCIE_PIPE_LANE11_REG2 0x55b8
#define A_PCIE_PIPE_LANE11_REG3 0x55bc
#define A_PCIE_PIPE_LANE12_REG0 0x55c0
#define A_PCIE_PIPE_LANE12_REG1 0x55c4
#define A_PCIE_PIPE_LANE12_REG2 0x55c8
#define A_PCIE_PIPE_LANE12_REG3 0x55cc
#define A_PCIE_PIPE_LANE13_REG0 0x55d0
#define A_PCIE_PIPE_LANE13_REG1 0x55d4
#define A_PCIE_PIPE_LANE13_REG2 0x55d8
#define A_PCIE_PIPE_LANE13_REG3 0x55dc
#define A_PCIE_PIPE_LANE14_REG0 0x55e0
#define A_PCIE_PIPE_LANE14_REG1 0x55e4
#define A_PCIE_PIPE_LANE14_REG2 0x55e8
#define A_PCIE_PIPE_LANE14_REG3 0x55ec
#define A_PCIE_PIPE_LANE15_REG0 0x55f0
#define A_PCIE_PIPE_LANE15_REG1 0x55f4
#define A_PCIE_PIPE_LANE15_REG2 0x55f8
#define A_PCIE_PIPE_LANE15_REG3 0x55fc
#define A_PCIE_COOKIE_STAT 0x5600

#define S_COOKIEB    16
#define M_COOKIEB    0x3ffU
#define V_COOKIEB(x) ((x) << S_COOKIEB)
#define G_COOKIEB(x) (((x) >> S_COOKIEB) & M_COOKIEB)

#define S_COOKIEA    0
#define M_COOKIEA    0x3ffU
#define V_COOKIEA(x) ((x) << S_COOKIEA)
#define G_COOKIEA(x) (((x) >> S_COOKIEA) & M_COOKIEA)

#define A_PCIE_FLR_PIO 0x5620

#define S_RCVDBAR2COOKIE    24
#define M_RCVDBAR2COOKIE    0xffU
#define V_RCVDBAR2COOKIE(x) ((x) << S_RCVDBAR2COOKIE)
#define G_RCVDBAR2COOKIE(x) (((x) >> S_RCVDBAR2COOKIE) & M_RCVDBAR2COOKIE)

#define S_RCVDMARSPCOOKIE    16
#define M_RCVDMARSPCOOKIE    0xffU
#define V_RCVDMARSPCOOKIE(x) ((x) << S_RCVDMARSPCOOKIE)
#define G_RCVDMARSPCOOKIE(x) (((x) >> S_RCVDMARSPCOOKIE) & M_RCVDMARSPCOOKIE)

#define S_RCVDPIORSPCOOKIE    8
#define M_RCVDPIORSPCOOKIE    0xffU
#define V_RCVDPIORSPCOOKIE(x) ((x) << S_RCVDPIORSPCOOKIE)
#define G_RCVDPIORSPCOOKIE(x) (((x) >> S_RCVDPIORSPCOOKIE) & M_RCVDPIORSPCOOKIE)

#define S_EXPDCOOKIE    0
#define M_EXPDCOOKIE    0xffU
#define V_EXPDCOOKIE(x) ((x) << S_EXPDCOOKIE)
#define G_EXPDCOOKIE(x) (((x) >> S_EXPDCOOKIE) & M_EXPDCOOKIE)

#define A_PCIE_FLR_PIO2 0x5624

#define S_RCVDMAREQCOOKIE    16
#define M_RCVDMAREQCOOKIE    0xffU
#define V_RCVDMAREQCOOKIE(x) ((x) << S_RCVDMAREQCOOKIE)
#define G_RCVDMAREQCOOKIE(x) (((x) >> S_RCVDMAREQCOOKIE) & M_RCVDMAREQCOOKIE)

#define S_RCVDPIOREQCOOKIE    8
#define M_RCVDPIOREQCOOKIE    0xffU
#define V_RCVDPIOREQCOOKIE(x) ((x) << S_RCVDPIOREQCOOKIE)
#define G_RCVDPIOREQCOOKIE(x) (((x) >> S_RCVDPIOREQCOOKIE) & M_RCVDPIOREQCOOKIE)

#define S_RCVDVDMRXCOOKIE    24
#define M_RCVDVDMRXCOOKIE    0xffU
#define V_RCVDVDMRXCOOKIE(x) ((x) << S_RCVDVDMRXCOOKIE)
#define G_RCVDVDMRXCOOKIE(x) (((x) >> S_RCVDVDMRXCOOKIE) & M_RCVDVDMRXCOOKIE)

#define S_RCVDVDMTXCOOKIE    16
#define M_RCVDVDMTXCOOKIE    0xffU
#define V_RCVDVDMTXCOOKIE(x) ((x) << S_RCVDVDMTXCOOKIE)
#define G_RCVDVDMTXCOOKIE(x) (((x) >> S_RCVDVDMTXCOOKIE) & M_RCVDVDMTXCOOKIE)

#define S_T6_RCVDMAREQCOOKIE    8
#define M_T6_RCVDMAREQCOOKIE    0xffU
#define V_T6_RCVDMAREQCOOKIE(x) ((x) << S_T6_RCVDMAREQCOOKIE)
#define G_T6_RCVDMAREQCOOKIE(x) (((x) >> S_T6_RCVDMAREQCOOKIE) & M_T6_RCVDMAREQCOOKIE)

#define S_T6_RCVDPIOREQCOOKIE    0
#define M_T6_RCVDPIOREQCOOKIE    0xffU
#define V_T6_RCVDPIOREQCOOKIE(x) ((x) << S_T6_RCVDPIOREQCOOKIE)
#define G_T6_RCVDPIOREQCOOKIE(x) (((x) >> S_T6_RCVDPIOREQCOOKIE) & M_T6_RCVDPIOREQCOOKIE)

#define A_T7_PCIE_VC0_CDTS0 0x56c4

#define S_T7_CPLD0    16
#define M_T7_CPLD0    0xffffU
#define V_T7_CPLD0(x) ((x) << S_T7_CPLD0)
#define G_T7_CPLD0(x) (((x) >> S_T7_CPLD0) & M_T7_CPLD0)

#define S_T7_CPLH0    0
#define M_T7_CPLH0    0xfffU
#define V_T7_CPLH0(x) ((x) << S_T7_CPLH0)
#define G_T7_CPLH0(x) (((x) >> S_T7_CPLH0) & M_T7_CPLH0)

#define A_T7_PCIE_VC0_CDTS1 0x56c8

#define S_T7_PD0    16
#define M_T7_PD0    0xffffU
#define V_T7_PD0(x) ((x) << S_T7_PD0)
#define G_T7_PD0(x) (((x) >> S_T7_PD0) & M_T7_PD0)

#define S_T7_PH0    0
#define M_T7_PH0    0xfffU
#define V_T7_PH0(x) ((x) << S_T7_PH0)
#define G_T7_PH0(x) (((x) >> S_T7_PH0) & M_T7_PH0)

#define A_PCIE_VC0_CDTS0 0x56cc

#define S_CPLD0    20
#define M_CPLD0    0xfffU
#define V_CPLD0(x) ((x) << S_CPLD0)
#define G_CPLD0(x) (((x) >> S_CPLD0) & M_CPLD0)

#define S_PH0    12
#define M_PH0    0xffU
#define V_PH0(x) ((x) << S_PH0)
#define G_PH0(x) (((x) >> S_PH0) & M_PH0)

#define S_PD0    0
#define M_PD0    0xfffU
#define V_PD0(x) ((x) << S_PD0)
#define G_PD0(x) (((x) >> S_PD0) & M_PD0)

#define A_PCIE_VC0_CDTS2 0x56cc

#define S_T7_NPD0    16
#define M_T7_NPD0    0xffffU
#define V_T7_NPD0(x) ((x) << S_T7_NPD0)
#define G_T7_NPD0(x) (((x) >> S_T7_NPD0) & M_T7_NPD0)

#define S_T7_NPH0    0
#define M_T7_NPH0    0xfffU
#define V_T7_NPH0(x) ((x) << S_T7_NPH0)
#define G_T7_NPH0(x) (((x) >> S_T7_NPH0) & M_T7_NPH0)

#define A_PCIE_VC0_CDTS1 0x56d0

#define S_CPLH0    20
#define M_CPLH0    0xffU
#define V_CPLH0(x) ((x) << S_CPLH0)
#define G_CPLH0(x) (((x) >> S_CPLH0) & M_CPLH0)

#define S_NPH0    12
#define M_NPH0    0xffU
#define V_NPH0(x) ((x) << S_NPH0)
#define G_NPH0(x) (((x) >> S_NPH0) & M_NPH0)

#define S_NPD0    0
#define M_NPD0    0xfffU
#define V_NPD0(x) ((x) << S_NPD0)
#define G_NPD0(x) (((x) >> S_NPD0) & M_NPD0)

#define A_T7_PCIE_VC1_CDTS0 0x56d0
#define A_PCIE_VC1_CDTS0 0x56d4

#define S_CPLD1    20
#define M_CPLD1    0xfffU
#define V_CPLD1(x) ((x) << S_CPLD1)
#define G_CPLD1(x) (((x) >> S_CPLD1) & M_CPLD1)

#define S_PH1    12
#define M_PH1    0xffU
#define V_PH1(x) ((x) << S_PH1)
#define G_PH1(x) (((x) >> S_PH1) & M_PH1)

#define S_PD1    0
#define M_PD1    0xfffU
#define V_PD1(x) ((x) << S_PD1)
#define G_PD1(x) (((x) >> S_PD1) & M_PD1)

#define A_T7_PCIE_VC1_CDTS1 0x56d4
#define A_PCIE_VC1_CDTS1 0x56d8

#define S_CPLH1    20
#define M_CPLH1    0xffU
#define V_CPLH1(x) ((x) << S_CPLH1)
#define G_CPLH1(x) (((x) >> S_CPLH1) & M_CPLH1)

#define S_NPH1    12
#define M_NPH1    0xffU
#define V_NPH1(x) ((x) << S_NPH1)
#define G_NPH1(x) (((x) >> S_NPH1) & M_NPH1)

#define S_NPD1    0
#define M_NPD1    0xfffU
#define V_NPD1(x) ((x) << S_NPD1)
#define G_NPD1(x) (((x) >> S_NPD1) & M_NPD1)

#define A_PCIE_VC1_CDTS2 0x56d8
#define A_PCIE_FLR_PF_STATUS 0x56dc
#define A_PCIE_FLR_VF0_STATUS 0x56e0
#define A_PCIE_FLR_VF1_STATUS 0x56e4
#define A_PCIE_FLR_VF2_STATUS 0x56e8
#define A_PCIE_FLR_VF3_STATUS 0x56ec
#define A_PCIE_STAT 0x56f4

#define S_PM_STATUS    24
#define M_PM_STATUS    0xffU
#define V_PM_STATUS(x) ((x) << S_PM_STATUS)
#define G_PM_STATUS(x) (((x) >> S_PM_STATUS) & M_PM_STATUS)

#define S_PM_CURRENTSTATE    20
#define M_PM_CURRENTSTATE    0x7U
#define V_PM_CURRENTSTATE(x) ((x) << S_PM_CURRENTSTATE)
#define G_PM_CURRENTSTATE(x) (((x) >> S_PM_CURRENTSTATE) & M_PM_CURRENTSTATE)

#define S_LTSSMENABLE    12
#define V_LTSSMENABLE(x) ((x) << S_LTSSMENABLE)
#define F_LTSSMENABLE    V_LTSSMENABLE(1U)

#define S_STATECFGINITF    4
#define M_STATECFGINITF    0x7fU
#define V_STATECFGINITF(x) ((x) << S_STATECFGINITF)
#define G_STATECFGINITF(x) (((x) >> S_STATECFGINITF) & M_STATECFGINITF)

#define S_STATECFGINIT    0
#define M_STATECFGINIT    0xfU
#define V_STATECFGINIT(x) ((x) << S_STATECFGINIT)
#define G_STATECFGINIT(x) (((x) >> S_STATECFGINIT) & M_STATECFGINIT)

#define S_LTSSMENABLE_PCIE    12
#define V_LTSSMENABLE_PCIE(x) ((x) << S_LTSSMENABLE_PCIE)
#define F_LTSSMENABLE_PCIE    V_LTSSMENABLE_PCIE(1U)

#define S_STATECFGINITF_PCIE    4
#define M_STATECFGINITF_PCIE    0xffU
#define V_STATECFGINITF_PCIE(x) ((x) << S_STATECFGINITF_PCIE)
#define G_STATECFGINITF_PCIE(x) (((x) >> S_STATECFGINITF_PCIE) & M_STATECFGINITF_PCIE)

#define S_STATECFGINIT_PCIE    0
#define M_STATECFGINIT_PCIE    0xfU
#define V_STATECFGINIT_PCIE(x) ((x) << S_STATECFGINIT_PCIE)
#define G_STATECFGINIT_PCIE(x) (((x) >> S_STATECFGINIT_PCIE) & M_STATECFGINIT_PCIE)

#define A_PCIE_CRS 0x56f8

#define S_CRS_ENABLE    0
#define V_CRS_ENABLE(x) ((x) << S_CRS_ENABLE)
#define F_CRS_ENABLE    V_CRS_ENABLE(1U)

#define A_PCIE_LTSSM 0x56fc

#define S_LTSSM_ENABLE    0
#define V_LTSSM_ENABLE(x) ((x) << S_LTSSM_ENABLE)
#define F_LTSSM_ENABLE    V_LTSSM_ENABLE(1U)

#define S_LTSSM_STALL_DISABLE    1
#define V_LTSSM_STALL_DISABLE(x) ((x) << S_LTSSM_STALL_DISABLE)
#define F_LTSSM_STALL_DISABLE    V_LTSSM_STALL_DISABLE(1U)

#define A_PCIE_CORE_ACK_LATENCY_TIMER_REPLAY_TIMER 0x5700

#define S_REPLAY_TIME_LIMIT    16
#define M_REPLAY_TIME_LIMIT    0xffffU
#define V_REPLAY_TIME_LIMIT(x) ((x) << S_REPLAY_TIME_LIMIT)
#define G_REPLAY_TIME_LIMIT(x) (((x) >> S_REPLAY_TIME_LIMIT) & M_REPLAY_TIME_LIMIT)

#define S_ACK_LATENCY_TIMER_LIMIT    0
#define M_ACK_LATENCY_TIMER_LIMIT    0xffffU
#define V_ACK_LATENCY_TIMER_LIMIT(x) ((x) << S_ACK_LATENCY_TIMER_LIMIT)
#define G_ACK_LATENCY_TIMER_LIMIT(x) (((x) >> S_ACK_LATENCY_TIMER_LIMIT) & M_ACK_LATENCY_TIMER_LIMIT)

#define A_PCIE_CORE_VENDOR_SPECIFIC_DLLP 0x5704
#define A_PCIE_CORE_PORT_FORCE_LINK 0x5708

#define S_LOW_POWER_ENTRANCE_COUNT    24
#define M_LOW_POWER_ENTRANCE_COUNT    0xffU
#define V_LOW_POWER_ENTRANCE_COUNT(x) ((x) << S_LOW_POWER_ENTRANCE_COUNT)
#define G_LOW_POWER_ENTRANCE_COUNT(x) (((x) >> S_LOW_POWER_ENTRANCE_COUNT) & M_LOW_POWER_ENTRANCE_COUNT)

#define S_LINK_STATE    16
#define M_LINK_STATE    0x3fU
#define V_LINK_STATE(x) ((x) << S_LINK_STATE)
#define G_LINK_STATE(x) (((x) >> S_LINK_STATE) & M_LINK_STATE)

#define S_FORCE_LINK    15
#define V_FORCE_LINK(x) ((x) << S_FORCE_LINK)
#define F_FORCE_LINK    V_FORCE_LINK(1U)

#define S_LINK_NUMBER    0
#define M_LINK_NUMBER    0xffU
#define V_LINK_NUMBER(x) ((x) << S_LINK_NUMBER)
#define G_LINK_NUMBER(x) (((x) >> S_LINK_NUMBER) & M_LINK_NUMBER)

#define A_PCIE_CORE_ACK_FREQUENCY_L0L1_ASPM_CONTROL 0x570c

#define S_ENTER_ASPM_L1_WO_L0S    30
#define V_ENTER_ASPM_L1_WO_L0S(x) ((x) << S_ENTER_ASPM_L1_WO_L0S)
#define F_ENTER_ASPM_L1_WO_L0S    V_ENTER_ASPM_L1_WO_L0S(1U)

#define S_L1_ENTRANCE_LATENCY    27
#define M_L1_ENTRANCE_LATENCY    0x7U
#define V_L1_ENTRANCE_LATENCY(x) ((x) << S_L1_ENTRANCE_LATENCY)
#define G_L1_ENTRANCE_LATENCY(x) (((x) >> S_L1_ENTRANCE_LATENCY) & M_L1_ENTRANCE_LATENCY)

#define S_L0S_ENTRANCE_LATENCY    24
#define M_L0S_ENTRANCE_LATENCY    0x7U
#define V_L0S_ENTRANCE_LATENCY(x) ((x) << S_L0S_ENTRANCE_LATENCY)
#define G_L0S_ENTRANCE_LATENCY(x) (((x) >> S_L0S_ENTRANCE_LATENCY) & M_L0S_ENTRANCE_LATENCY)

#define S_COMMON_CLOCK_N_FTS    16
#define M_COMMON_CLOCK_N_FTS    0xffU
#define V_COMMON_CLOCK_N_FTS(x) ((x) << S_COMMON_CLOCK_N_FTS)
#define G_COMMON_CLOCK_N_FTS(x) (((x) >> S_COMMON_CLOCK_N_FTS) & M_COMMON_CLOCK_N_FTS)

#define S_N_FTS    8
#define M_N_FTS    0xffU
#define V_N_FTS(x) ((x) << S_N_FTS)
#define G_N_FTS(x) (((x) >> S_N_FTS) & M_N_FTS)

#define S_ACK_FREQUENCY    0
#define M_ACK_FREQUENCY    0xffU
#define V_ACK_FREQUENCY(x) ((x) << S_ACK_FREQUENCY)
#define G_ACK_FREQUENCY(x) (((x) >> S_ACK_FREQUENCY) & M_ACK_FREQUENCY)

#define A_PCIE_CORE_PORT_LINK_CONTROL 0x5710

#define S_CROSSLINK_ACTIVE    23
#define V_CROSSLINK_ACTIVE(x) ((x) << S_CROSSLINK_ACTIVE)
#define F_CROSSLINK_ACTIVE    V_CROSSLINK_ACTIVE(1U)

#define S_CROSSLINK_ENABLE    22
#define V_CROSSLINK_ENABLE(x) ((x) << S_CROSSLINK_ENABLE)
#define F_CROSSLINK_ENABLE    V_CROSSLINK_ENABLE(1U)

#define S_LINK_MODE_ENABLE    16
#define M_LINK_MODE_ENABLE    0x3fU
#define V_LINK_MODE_ENABLE(x) ((x) << S_LINK_MODE_ENABLE)
#define G_LINK_MODE_ENABLE(x) (((x) >> S_LINK_MODE_ENABLE) & M_LINK_MODE_ENABLE)

#define S_FAST_LINK_MODE    7
#define V_FAST_LINK_MODE(x) ((x) << S_FAST_LINK_MODE)
#define F_FAST_LINK_MODE    V_FAST_LINK_MODE(1U)

#define S_DLL_LINK_ENABLE    5
#define V_DLL_LINK_ENABLE(x) ((x) << S_DLL_LINK_ENABLE)
#define F_DLL_LINK_ENABLE    V_DLL_LINK_ENABLE(1U)

#define S_RESET_ASSERT    3
#define V_RESET_ASSERT(x) ((x) << S_RESET_ASSERT)
#define F_RESET_ASSERT    V_RESET_ASSERT(1U)

#define S_LOOPBACK_ENABLE    2
#define V_LOOPBACK_ENABLE(x) ((x) << S_LOOPBACK_ENABLE)
#define F_LOOPBACK_ENABLE    V_LOOPBACK_ENABLE(1U)

#define S_SCRAMBLE_DISABLE    1
#define V_SCRAMBLE_DISABLE(x) ((x) << S_SCRAMBLE_DISABLE)
#define F_SCRAMBLE_DISABLE    V_SCRAMBLE_DISABLE(1U)

#define S_VENDOR_SPECIFIC_DLLP_REQUEST    0
#define V_VENDOR_SPECIFIC_DLLP_REQUEST(x) ((x) << S_VENDOR_SPECIFIC_DLLP_REQUEST)
#define F_VENDOR_SPECIFIC_DLLP_REQUEST    V_VENDOR_SPECIFIC_DLLP_REQUEST(1U)

#define A_PCIE_CORE_LANE_SKEW 0x5714

#define S_DISABLE_DESKEW    31
#define V_DISABLE_DESKEW(x) ((x) << S_DISABLE_DESKEW)
#define F_DISABLE_DESKEW    V_DISABLE_DESKEW(1U)

#define S_ACK_NAK_DISABLE    25
#define V_ACK_NAK_DISABLE(x) ((x) << S_ACK_NAK_DISABLE)
#define F_ACK_NAK_DISABLE    V_ACK_NAK_DISABLE(1U)

#define S_FLOW_CONTROL_DISABLE    24
#define V_FLOW_CONTROL_DISABLE(x) ((x) << S_FLOW_CONTROL_DISABLE)
#define F_FLOW_CONTROL_DISABLE    V_FLOW_CONTROL_DISABLE(1U)

#define S_INSERT_TXSKEW    0
#define M_INSERT_TXSKEW    0xffffffU
#define V_INSERT_TXSKEW(x) ((x) << S_INSERT_TXSKEW)
#define G_INSERT_TXSKEW(x) (((x) >> S_INSERT_TXSKEW) & M_INSERT_TXSKEW)

#define A_PCIE_CORE_SYMBOL_NUMBER 0x5718

#define S_FLOW_CONTROL_TIMER_MODIFIER    24
#define M_FLOW_CONTROL_TIMER_MODIFIER    0x1fU
#define V_FLOW_CONTROL_TIMER_MODIFIER(x) ((x) << S_FLOW_CONTROL_TIMER_MODIFIER)
#define G_FLOW_CONTROL_TIMER_MODIFIER(x) (((x) >> S_FLOW_CONTROL_TIMER_MODIFIER) & M_FLOW_CONTROL_TIMER_MODIFIER)

#define S_ACK_NAK_TIMER_MODIFIER    19
#define M_ACK_NAK_TIMER_MODIFIER    0x1fU
#define V_ACK_NAK_TIMER_MODIFIER(x) ((x) << S_ACK_NAK_TIMER_MODIFIER)
#define G_ACK_NAK_TIMER_MODIFIER(x) (((x) >> S_ACK_NAK_TIMER_MODIFIER) & M_ACK_NAK_TIMER_MODIFIER)

#define S_REPLAY_TIMER_MODIFIER    14
#define M_REPLAY_TIMER_MODIFIER    0x1fU
#define V_REPLAY_TIMER_MODIFIER(x) ((x) << S_REPLAY_TIMER_MODIFIER)
#define G_REPLAY_TIMER_MODIFIER(x) (((x) >> S_REPLAY_TIMER_MODIFIER) & M_REPLAY_TIMER_MODIFIER)

#define S_MAXFUNC    0
#define M_MAXFUNC    0x7U
#define V_MAXFUNC(x) ((x) << S_MAXFUNC)
#define G_MAXFUNC(x) (((x) >> S_MAXFUNC) & M_MAXFUNC)

#define A_PCIE_CORE_SYMBOL_TIMER_FILTER_MASK1 0x571c

#define S_MASK_RADM_FILTER    16
#define M_MASK_RADM_FILTER    0xffffU
#define V_MASK_RADM_FILTER(x) ((x) << S_MASK_RADM_FILTER)
#define G_MASK_RADM_FILTER(x) (((x) >> S_MASK_RADM_FILTER) & M_MASK_RADM_FILTER)

#define S_DISABLE_FC_WATCHDOG    15
#define V_DISABLE_FC_WATCHDOG(x) ((x) << S_DISABLE_FC_WATCHDOG)
#define F_DISABLE_FC_WATCHDOG    V_DISABLE_FC_WATCHDOG(1U)

#define S_SKP_INTERVAL    0
#define M_SKP_INTERVAL    0x7ffU
#define V_SKP_INTERVAL(x) ((x) << S_SKP_INTERVAL)
#define G_SKP_INTERVAL(x) (((x) >> S_SKP_INTERVAL) & M_SKP_INTERVAL)

#define A_PCIE_CORE_FILTER_MASK2 0x5720
#define A_PCIE_CORE_DEBUG_0 0x5728
#define A_PCIE_CORE_DEBUG_1 0x572c
#define A_PCIE_CORE_TRANSMIT_POSTED_FC_CREDIT_STATUS 0x5730

#define S_TXPH_FC    12
#define M_TXPH_FC    0xffU
#define V_TXPH_FC(x) ((x) << S_TXPH_FC)
#define G_TXPH_FC(x) (((x) >> S_TXPH_FC) & M_TXPH_FC)

#define S_TXPD_FC    0
#define M_TXPD_FC    0xfffU
#define V_TXPD_FC(x) ((x) << S_TXPD_FC)
#define G_TXPD_FC(x) (((x) >> S_TXPD_FC) & M_TXPD_FC)

#define A_PCIE_CORE_TRANSMIT_NONPOSTED_FC_CREDIT_STATUS 0x5734

#define S_TXNPH_FC    12
#define M_TXNPH_FC    0xffU
#define V_TXNPH_FC(x) ((x) << S_TXNPH_FC)
#define G_TXNPH_FC(x) (((x) >> S_TXNPH_FC) & M_TXNPH_FC)

#define S_TXNPD_FC    0
#define M_TXNPD_FC    0xfffU
#define V_TXNPD_FC(x) ((x) << S_TXNPD_FC)
#define G_TXNPD_FC(x) (((x) >> S_TXNPD_FC) & M_TXNPD_FC)

#define A_PCIE_CORE_TRANSMIT_COMPLETION_FC_CREDIT_STATUS 0x5738

#define S_TXCPLH_FC    12
#define M_TXCPLH_FC    0xffU
#define V_TXCPLH_FC(x) ((x) << S_TXCPLH_FC)
#define G_TXCPLH_FC(x) (((x) >> S_TXCPLH_FC) & M_TXCPLH_FC)

#define S_TXCPLD_FC    0
#define M_TXCPLD_FC    0xfffU
#define V_TXCPLD_FC(x) ((x) << S_TXCPLD_FC)
#define G_TXCPLD_FC(x) (((x) >> S_TXCPLD_FC) & M_TXCPLD_FC)

#define A_PCIE_CORE_QUEUE_STATUS 0x573c

#define S_RXQUEUE_NOT_EMPTY    2
#define V_RXQUEUE_NOT_EMPTY(x) ((x) << S_RXQUEUE_NOT_EMPTY)
#define F_RXQUEUE_NOT_EMPTY    V_RXQUEUE_NOT_EMPTY(1U)

#define S_TXRETRYBUF_NOT_EMPTY    1
#define V_TXRETRYBUF_NOT_EMPTY(x) ((x) << S_TXRETRYBUF_NOT_EMPTY)
#define F_TXRETRYBUF_NOT_EMPTY    V_TXRETRYBUF_NOT_EMPTY(1U)

#define S_RXTLP_FC_NOT_RETURNED    0
#define V_RXTLP_FC_NOT_RETURNED(x) ((x) << S_RXTLP_FC_NOT_RETURNED)
#define F_RXTLP_FC_NOT_RETURNED    V_RXTLP_FC_NOT_RETURNED(1U)

#define A_PCIE_CORE_VC_TRANSMIT_ARBITRATION_1 0x5740

#define S_VC3_WRR    24
#define M_VC3_WRR    0xffU
#define V_VC3_WRR(x) ((x) << S_VC3_WRR)
#define G_VC3_WRR(x) (((x) >> S_VC3_WRR) & M_VC3_WRR)

#define S_VC2_WRR    16
#define M_VC2_WRR    0xffU
#define V_VC2_WRR(x) ((x) << S_VC2_WRR)
#define G_VC2_WRR(x) (((x) >> S_VC2_WRR) & M_VC2_WRR)

#define S_VC1_WRR    8
#define M_VC1_WRR    0xffU
#define V_VC1_WRR(x) ((x) << S_VC1_WRR)
#define G_VC1_WRR(x) (((x) >> S_VC1_WRR) & M_VC1_WRR)

#define S_VC0_WRR    0
#define M_VC0_WRR    0xffU
#define V_VC0_WRR(x) ((x) << S_VC0_WRR)
#define G_VC0_WRR(x) (((x) >> S_VC0_WRR) & M_VC0_WRR)

#define A_PCIE_CORE_VC_TRANSMIT_ARBITRATION_2 0x5744

#define S_VC7_WRR    24
#define M_VC7_WRR    0xffU
#define V_VC7_WRR(x) ((x) << S_VC7_WRR)
#define G_VC7_WRR(x) (((x) >> S_VC7_WRR) & M_VC7_WRR)

#define S_VC6_WRR    16
#define M_VC6_WRR    0xffU
#define V_VC6_WRR(x) ((x) << S_VC6_WRR)
#define G_VC6_WRR(x) (((x) >> S_VC6_WRR) & M_VC6_WRR)

#define S_VC5_WRR    8
#define M_VC5_WRR    0xffU
#define V_VC5_WRR(x) ((x) << S_VC5_WRR)
#define G_VC5_WRR(x) (((x) >> S_VC5_WRR) & M_VC5_WRR)

#define S_VC4_WRR    0
#define M_VC4_WRR    0xffU
#define V_VC4_WRR(x) ((x) << S_VC4_WRR)
#define G_VC4_WRR(x) (((x) >> S_VC4_WRR) & M_VC4_WRR)

#define A_PCIE_CORE_VC0_POSTED_RECEIVE_QUEUE_CONTROL 0x5748

#define S_VC0_RX_ORDERING    31
#define V_VC0_RX_ORDERING(x) ((x) << S_VC0_RX_ORDERING)
#define F_VC0_RX_ORDERING    V_VC0_RX_ORDERING(1U)

#define S_VC0_TLP_ORDERING    30
#define V_VC0_TLP_ORDERING(x) ((x) << S_VC0_TLP_ORDERING)
#define F_VC0_TLP_ORDERING    V_VC0_TLP_ORDERING(1U)

#define S_VC0_PTLP_QUEUE_MODE    21
#define M_VC0_PTLP_QUEUE_MODE    0x7U
#define V_VC0_PTLP_QUEUE_MODE(x) ((x) << S_VC0_PTLP_QUEUE_MODE)
#define G_VC0_PTLP_QUEUE_MODE(x) (((x) >> S_VC0_PTLP_QUEUE_MODE) & M_VC0_PTLP_QUEUE_MODE)

#define S_VC0_PH_CREDITS    12
#define M_VC0_PH_CREDITS    0xffU
#define V_VC0_PH_CREDITS(x) ((x) << S_VC0_PH_CREDITS)
#define G_VC0_PH_CREDITS(x) (((x) >> S_VC0_PH_CREDITS) & M_VC0_PH_CREDITS)

#define S_VC0_PD_CREDITS    0
#define M_VC0_PD_CREDITS    0xfffU
#define V_VC0_PD_CREDITS(x) ((x) << S_VC0_PD_CREDITS)
#define G_VC0_PD_CREDITS(x) (((x) >> S_VC0_PD_CREDITS) & M_VC0_PD_CREDITS)

#define A_PCIE_CORE_VC0_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x574c

#define S_VC0_NPTLP_QUEUE_MODE    21
#define M_VC0_NPTLP_QUEUE_MODE    0x7U
#define V_VC0_NPTLP_QUEUE_MODE(x) ((x) << S_VC0_NPTLP_QUEUE_MODE)
#define G_VC0_NPTLP_QUEUE_MODE(x) (((x) >> S_VC0_NPTLP_QUEUE_MODE) & M_VC0_NPTLP_QUEUE_MODE)

#define S_VC0_NPH_CREDITS    12
#define M_VC0_NPH_CREDITS    0xffU
#define V_VC0_NPH_CREDITS(x) ((x) << S_VC0_NPH_CREDITS)
#define G_VC0_NPH_CREDITS(x) (((x) >> S_VC0_NPH_CREDITS) & M_VC0_NPH_CREDITS)

#define S_VC0_NPD_CREDITS    0
#define M_VC0_NPD_CREDITS    0xfffU
#define V_VC0_NPD_CREDITS(x) ((x) << S_VC0_NPD_CREDITS)
#define G_VC0_NPD_CREDITS(x) (((x) >> S_VC0_NPD_CREDITS) & M_VC0_NPD_CREDITS)

#define A_PCIE_CORE_VC0_COMPLETION_RECEIVE_QUEUE_CONTROL 0x5750

#define S_VC0_CPLTLP_QUEUE_MODE    21
#define M_VC0_CPLTLP_QUEUE_MODE    0x7U
#define V_VC0_CPLTLP_QUEUE_MODE(x) ((x) << S_VC0_CPLTLP_QUEUE_MODE)
#define G_VC0_CPLTLP_QUEUE_MODE(x) (((x) >> S_VC0_CPLTLP_QUEUE_MODE) & M_VC0_CPLTLP_QUEUE_MODE)

#define S_VC0_CPLH_CREDITS    12
#define M_VC0_CPLH_CREDITS    0xffU
#define V_VC0_CPLH_CREDITS(x) ((x) << S_VC0_CPLH_CREDITS)
#define G_VC0_CPLH_CREDITS(x) (((x) >> S_VC0_CPLH_CREDITS) & M_VC0_CPLH_CREDITS)

#define S_VC0_CPLD_CREDITS    0
#define M_VC0_CPLD_CREDITS    0xfffU
#define V_VC0_CPLD_CREDITS(x) ((x) << S_VC0_CPLD_CREDITS)
#define G_VC0_CPLD_CREDITS(x) (((x) >> S_VC0_CPLD_CREDITS) & M_VC0_CPLD_CREDITS)

#define A_PCIE_CORE_VC1_POSTED_RECEIVE_QUEUE_CONTROL 0x5754

#define S_VC1_TLP_ORDERING    30
#define V_VC1_TLP_ORDERING(x) ((x) << S_VC1_TLP_ORDERING)
#define F_VC1_TLP_ORDERING    V_VC1_TLP_ORDERING(1U)

#define S_VC1_PTLP_QUEUE_MODE    21
#define M_VC1_PTLP_QUEUE_MODE    0x7U
#define V_VC1_PTLP_QUEUE_MODE(x) ((x) << S_VC1_PTLP_QUEUE_MODE)
#define G_VC1_PTLP_QUEUE_MODE(x) (((x) >> S_VC1_PTLP_QUEUE_MODE) & M_VC1_PTLP_QUEUE_MODE)

#define S_VC1_PH_CREDITS    12
#define M_VC1_PH_CREDITS    0xffU
#define V_VC1_PH_CREDITS(x) ((x) << S_VC1_PH_CREDITS)
#define G_VC1_PH_CREDITS(x) (((x) >> S_VC1_PH_CREDITS) & M_VC1_PH_CREDITS)

#define S_VC1_PD_CREDITS    0
#define M_VC1_PD_CREDITS    0xfffU
#define V_VC1_PD_CREDITS(x) ((x) << S_VC1_PD_CREDITS)
#define G_VC1_PD_CREDITS(x) (((x) >> S_VC1_PD_CREDITS) & M_VC1_PD_CREDITS)

#define A_PCIE_CORE_VC1_NONPOSTED_RECEIVE_QUEUE_CONTROL 0x5758

#define S_VC1_NPTLP_QUEUE_MODE    21
#define M_VC1_NPTLP_QUEUE_MODE    0x7U
#define V_VC1_NPTLP_QUEUE_MODE(x) ((x) << S_VC1_NPTLP_QUEUE_MODE)
#define G_VC1_NPTLP_QUEUE_MODE(x) (((x) >> S_VC1_NPTLP_QUEUE_MODE) & M_VC1_NPTLP_QUEUE_MODE)

#define S_VC1_NPH_CREDITS    12
#define M_VC1_NPH_CREDITS    0xffU
#define V_VC1_NPH_CREDITS(x) ((x) << S_VC1_NPH_CREDITS)
#define G_VC1_NPH_CREDITS(x) (((x) >> S_VC1_NPH_CREDITS) & M_VC1_NPH_CREDITS)

#define S_VC1_NPD_CREDITS    0
#define M_VC1_NPD_CREDITS    0xfffU
#define V_VC1_NPD_CREDITS(x) ((x) << S_VC1_NPD_CREDITS)
#define G_VC1_NPD_CREDITS(x) (((x) >> S_VC1_NPD_CREDITS) & M_VC1_NPD_CREDITS)

#define A_PCIE_CORE_VC1_COMPLETION_RECEIVE_QUEUE_CONTROL 0x575c

#define S_VC1_CPLTLP_QUEUE_MODE    21
#define M_VC1_CPLTLP_QUEUE_MODE    0x7U
#define V_VC1_CPLTLP_QUEUE_MODE(x) ((x) << S_VC1_CPLTLP_QUEUE_MODE)
#define G_VC1_CPLTLP_QUEUE_MODE(x) (((x) >> S_VC1_CPLTLP_QUEUE_MODE) & M_VC1_CPLTLP_QUEUE_MODE)

#define S_VC1_CPLH_CREDITS    12
#define M_VC1_CPLH_CREDITS    0xffU
#define V_VC1_CPLH_CREDITS(x) ((x) << S_VC1_CPLH_CREDITS)
#define G_VC1_CPLH_CREDITS(x) (((x) >> S_VC1_CPLH_CREDITS) & M_VC1_CPLH_CREDITS)

#define S_VC1_CPLD_CREDITS    0
#define M_VC1_CPLD_CREDITS    0xfffU
#define V_VC1_CPLD_CREDITS(x) ((x) << S_VC1_CPLD_CREDITS)
#define G_VC1_CPLD_CREDITS(x) (((x) >> S_VC1_CPLD_CREDITS) & M_VC1_CPLD_CREDITS)

#define A_PCIE_CORE_LINK_WIDTH_SPEED_CHANGE 0x580c

#define S_SEL_DEEMPHASIS    20
#define V_SEL_DEEMPHASIS(x) ((x) << S_SEL_DEEMPHASIS)
#define F_SEL_DEEMPHASIS    V_SEL_DEEMPHASIS(1U)

#define S_TXCMPLRCV    19
#define V_TXCMPLRCV(x) ((x) << S_TXCMPLRCV)
#define F_TXCMPLRCV    V_TXCMPLRCV(1U)

#define S_PHYTXSWING    18
#define V_PHYTXSWING(x) ((x) << S_PHYTXSWING)
#define F_PHYTXSWING    V_PHYTXSWING(1U)

#define S_DIRSPDCHANGE    17
#define V_DIRSPDCHANGE(x) ((x) << S_DIRSPDCHANGE)
#define F_DIRSPDCHANGE    V_DIRSPDCHANGE(1U)

#define S_NUM_LANES    8
#define M_NUM_LANES    0x1ffU
#define V_NUM_LANES(x) ((x) << S_NUM_LANES)
#define G_NUM_LANES(x) (((x) >> S_NUM_LANES) & M_NUM_LANES)

#define S_NFTS_GEN2_3    0
#define M_NFTS_GEN2_3    0xffU
#define V_NFTS_GEN2_3(x) ((x) << S_NFTS_GEN2_3)
#define G_NFTS_GEN2_3(x) (((x) >> S_NFTS_GEN2_3) & M_NFTS_GEN2_3)

#define S_AUTO_LANE_FLIP_CTRL_EN    16
#define V_AUTO_LANE_FLIP_CTRL_EN(x) ((x) << S_AUTO_LANE_FLIP_CTRL_EN)
#define F_AUTO_LANE_FLIP_CTRL_EN    V_AUTO_LANE_FLIP_CTRL_EN(1U)

#define S_T6_NUM_LANES    8
#define M_T6_NUM_LANES    0x1fU
#define V_T6_NUM_LANES(x) ((x) << S_T6_NUM_LANES)
#define G_T6_NUM_LANES(x) (((x) >> S_T6_NUM_LANES) & M_T6_NUM_LANES)

#define A_PCIE_CORE_PHY_STATUS 0x5810
#define A_PCIE_CORE_PHY_CONTROL 0x5814
#define A_PCIE_CORE_GEN3_CONTROL 0x5890

#define S_DC_BALANCE_DISABLE    18
#define V_DC_BALANCE_DISABLE(x) ((x) << S_DC_BALANCE_DISABLE)
#define F_DC_BALANCE_DISABLE    V_DC_BALANCE_DISABLE(1U)

#define S_DLLP_DELAY_DISABLE    17
#define V_DLLP_DELAY_DISABLE(x) ((x) << S_DLLP_DELAY_DISABLE)
#define F_DLLP_DELAY_DISABLE    V_DLLP_DELAY_DISABLE(1U)

#define S_EQL_DISABLE    16
#define V_EQL_DISABLE(x) ((x) << S_EQL_DISABLE)
#define F_EQL_DISABLE    V_EQL_DISABLE(1U)

#define S_EQL_REDO_DISABLE    11
#define V_EQL_REDO_DISABLE(x) ((x) << S_EQL_REDO_DISABLE)
#define F_EQL_REDO_DISABLE    V_EQL_REDO_DISABLE(1U)

#define S_EQL_EIEOS_CNTRST_DISABLE    10
#define V_EQL_EIEOS_CNTRST_DISABLE(x) ((x) << S_EQL_EIEOS_CNTRST_DISABLE)
#define F_EQL_EIEOS_CNTRST_DISABLE    V_EQL_EIEOS_CNTRST_DISABLE(1U)

#define S_EQL_PH2_PH3_DISABLE    9
#define V_EQL_PH2_PH3_DISABLE(x) ((x) << S_EQL_PH2_PH3_DISABLE)
#define F_EQL_PH2_PH3_DISABLE    V_EQL_PH2_PH3_DISABLE(1U)

#define S_DISABLE_SCRAMBLER    8
#define V_DISABLE_SCRAMBLER(x) ((x) << S_DISABLE_SCRAMBLER)
#define F_DISABLE_SCRAMBLER    V_DISABLE_SCRAMBLER(1U)

#define S_RATE_SHADOW_SEL    24
#define M_RATE_SHADOW_SEL    0x3U
#define V_RATE_SHADOW_SEL(x) ((x) << S_RATE_SHADOW_SEL)
#define G_RATE_SHADOW_SEL(x) (((x) >> S_RATE_SHADOW_SEL) & M_RATE_SHADOW_SEL)

#define A_PCIE_CORE_GEN3_EQ_FS_LF 0x5894

#define S_FULL_SWING    6
#define M_FULL_SWING    0x3fU
#define V_FULL_SWING(x) ((x) << S_FULL_SWING)
#define G_FULL_SWING(x) (((x) >> S_FULL_SWING) & M_FULL_SWING)

#define S_LOW_FREQUENCY    0
#define M_LOW_FREQUENCY    0x3fU
#define V_LOW_FREQUENCY(x) ((x) << S_LOW_FREQUENCY)
#define G_LOW_FREQUENCY(x) (((x) >> S_LOW_FREQUENCY) & M_LOW_FREQUENCY)

#define A_PCIE_CORE_GEN3_EQ_PRESET_COEFF 0x5898

#define S_POSTCURSOR    12
#define M_POSTCURSOR    0x3fU
#define V_POSTCURSOR(x) ((x) << S_POSTCURSOR)
#define G_POSTCURSOR(x) (((x) >> S_POSTCURSOR) & M_POSTCURSOR)

#define S_CURSOR    6
#define M_CURSOR    0x3fU
#define V_CURSOR(x) ((x) << S_CURSOR)
#define G_CURSOR(x) (((x) >> S_CURSOR) & M_CURSOR)

#define S_PRECURSOR    0
#define M_PRECURSOR    0x3fU
#define V_PRECURSOR(x) ((x) << S_PRECURSOR)
#define G_PRECURSOR(x) (((x) >> S_PRECURSOR) & M_PRECURSOR)

#define A_PCIE_CORE_GEN3_EQ_PRESET_INDEX 0x589c

#define S_INDEX    0
#define M_INDEX    0xfU
#define V_INDEX(x) ((x) << S_INDEX)
#define G_INDEX(x) (((x) >> S_INDEX) & M_INDEX)

#define A_PCIE_CORE_GEN3_EQ_STATUS 0x58a4

#define S_LEGALITY_STATUS    0
#define V_LEGALITY_STATUS(x) ((x) << S_LEGALITY_STATUS)
#define F_LEGALITY_STATUS    V_LEGALITY_STATUS(1U)

#define A_PCIE_CORE_GEN3_EQ_CONTROL 0x58a8

#define S_INCLUDE_INITIAL_FOM    24
#define V_INCLUDE_INITIAL_FOM(x) ((x) << S_INCLUDE_INITIAL_FOM)
#define F_INCLUDE_INITIAL_FOM    V_INCLUDE_INITIAL_FOM(1U)

#define S_PRESET_REQUEST_VECTOR    8
#define M_PRESET_REQUEST_VECTOR    0xffffU
#define V_PRESET_REQUEST_VECTOR(x) ((x) << S_PRESET_REQUEST_VECTOR)
#define G_PRESET_REQUEST_VECTOR(x) (((x) >> S_PRESET_REQUEST_VECTOR) & M_PRESET_REQUEST_VECTOR)

#define S_PHASE23_2MS_TIMEOUT_DISABLE    5
#define V_PHASE23_2MS_TIMEOUT_DISABLE(x) ((x) << S_PHASE23_2MS_TIMEOUT_DISABLE)
#define F_PHASE23_2MS_TIMEOUT_DISABLE    V_PHASE23_2MS_TIMEOUT_DISABLE(1U)

#define S_AFTER24MS    4
#define V_AFTER24MS(x) ((x) << S_AFTER24MS)
#define F_AFTER24MS    V_AFTER24MS(1U)

#define S_FEEDBACK_MODE    0
#define M_FEEDBACK_MODE    0xfU
#define V_FEEDBACK_MODE(x) ((x) << S_FEEDBACK_MODE)
#define G_FEEDBACK_MODE(x) (((x) >> S_FEEDBACK_MODE) & M_FEEDBACK_MODE)

#define A_PCIE_CORE_GEN3_EQ_DIRCHANGE_FEEDBACK 0x58ac

#define S_WINAPERTURE_CPLUS1    14
#define M_WINAPERTURE_CPLUS1    0xfU
#define V_WINAPERTURE_CPLUS1(x) ((x) << S_WINAPERTURE_CPLUS1)
#define G_WINAPERTURE_CPLUS1(x) (((x) >> S_WINAPERTURE_CPLUS1) & M_WINAPERTURE_CPLUS1)

#define S_WINAPERTURE_CMINS1    10
#define M_WINAPERTURE_CMINS1    0xfU
#define V_WINAPERTURE_CMINS1(x) ((x) << S_WINAPERTURE_CMINS1)
#define G_WINAPERTURE_CMINS1(x) (((x) >> S_WINAPERTURE_CMINS1) & M_WINAPERTURE_CMINS1)

#define S_CONVERGENCE_WINDEPTH    5
#define M_CONVERGENCE_WINDEPTH    0x1fU
#define V_CONVERGENCE_WINDEPTH(x) ((x) << S_CONVERGENCE_WINDEPTH)
#define G_CONVERGENCE_WINDEPTH(x) (((x) >> S_CONVERGENCE_WINDEPTH) & M_CONVERGENCE_WINDEPTH)

#define S_EQMASTERPHASE_MINTIME    0
#define M_EQMASTERPHASE_MINTIME    0x1fU
#define V_EQMASTERPHASE_MINTIME(x) ((x) << S_EQMASTERPHASE_MINTIME)
#define G_EQMASTERPHASE_MINTIME(x) (((x) >> S_EQMASTERPHASE_MINTIME) & M_EQMASTERPHASE_MINTIME)

#define A_PCIE_CORE_PIPE_CONTROL 0x58b8

#define S_PIPE_LOOPBACK_EN    0
#define V_PIPE_LOOPBACK_EN(x) ((x) << S_PIPE_LOOPBACK_EN)
#define F_PIPE_LOOPBACK_EN    V_PIPE_LOOPBACK_EN(1U)

#define S_T6_PIPE_LOOPBACK_EN    31
#define V_T6_PIPE_LOOPBACK_EN(x) ((x) << S_T6_PIPE_LOOPBACK_EN)
#define F_T6_PIPE_LOOPBACK_EN    V_T6_PIPE_LOOPBACK_EN(1U)

#define A_PCIE_CORE_DBI_RO_WE 0x58bc

#define S_READONLY_WRITEEN    0
#define V_READONLY_WRITEEN(x) ((x) << S_READONLY_WRITEEN)
#define F_READONLY_WRITEEN    V_READONLY_WRITEEN(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_CONTROL 0x5900

#define S_SMTD    27
#define V_SMTD(x) ((x) << S_SMTD)
#define F_SMTD    V_SMTD(1U)

#define S_SSTD    26
#define V_SSTD(x) ((x) << S_SSTD)
#define F_SSTD    V_SSTD(1U)

#define S_SWD0    23
#define V_SWD0(x) ((x) << S_SWD0)
#define F_SWD0    V_SWD0(1U)

#define S_SWD1    22
#define V_SWD1(x) ((x) << S_SWD1)
#define F_SWD1    V_SWD1(1U)

#define S_SWD2    21
#define V_SWD2(x) ((x) << S_SWD2)
#define F_SWD2    V_SWD2(1U)

#define S_SWD3    20
#define V_SWD3(x) ((x) << S_SWD3)
#define F_SWD3    V_SWD3(1U)

#define S_SWD4    19
#define V_SWD4(x) ((x) << S_SWD4)
#define F_SWD4    V_SWD4(1U)

#define S_SWD5    18
#define V_SWD5(x) ((x) << S_SWD5)
#define F_SWD5    V_SWD5(1U)

#define S_SWD6    17
#define V_SWD6(x) ((x) << S_SWD6)
#define F_SWD6    V_SWD6(1U)

#define S_SWD7    16
#define V_SWD7(x) ((x) << S_SWD7)
#define F_SWD7    V_SWD7(1U)

#define S_SWD8    15
#define V_SWD8(x) ((x) << S_SWD8)
#define F_SWD8    V_SWD8(1U)

#define S_SRD0    13
#define V_SRD0(x) ((x) << S_SRD0)
#define F_SRD0    V_SRD0(1U)

#define S_SRD1    12
#define V_SRD1(x) ((x) << S_SRD1)
#define F_SRD1    V_SRD1(1U)

#define S_SRD2    11
#define V_SRD2(x) ((x) << S_SRD2)
#define F_SRD2    V_SRD2(1U)

#define S_SRD3    10
#define V_SRD3(x) ((x) << S_SRD3)
#define F_SRD3    V_SRD3(1U)

#define S_SRD4    9
#define V_SRD4(x) ((x) << S_SRD4)
#define F_SRD4    V_SRD4(1U)

#define S_SRD5    8
#define V_SRD5(x) ((x) << S_SRD5)
#define F_SRD5    V_SRD5(1U)

#define S_SRD6    7
#define V_SRD6(x) ((x) << S_SRD6)
#define F_SRD6    V_SRD6(1U)

#define S_SRD7    6
#define V_SRD7(x) ((x) << S_SRD7)
#define F_SRD7    V_SRD7(1U)

#define S_SRD8    5
#define V_SRD8(x) ((x) << S_SRD8)
#define F_SRD8    V_SRD8(1U)

#define S_CRRE    3
#define V_CRRE(x) ((x) << S_CRRE)
#define F_CRRE    V_CRRE(1U)

#define S_CRMC    0
#define M_CRMC    0x7U
#define V_CRMC(x) ((x) << S_CRMC)
#define G_CRMC(x) (((x) >> S_CRMC) & M_CRMC)

#define A_PCIE_CORE_UTL_STATUS 0x5904

#define S_USBP    31
#define V_USBP(x) ((x) << S_USBP)
#define F_USBP    V_USBP(1U)

#define S_UPEP    30
#define V_UPEP(x) ((x) << S_UPEP)
#define F_UPEP    V_UPEP(1U)

#define S_RCEP    29
#define V_RCEP(x) ((x) << S_RCEP)
#define F_RCEP    V_RCEP(1U)

#define S_EPEP    28
#define V_EPEP(x) ((x) << S_EPEP)
#define F_EPEP    V_EPEP(1U)

#define S_USBS    27
#define V_USBS(x) ((x) << S_USBS)
#define F_USBS    V_USBS(1U)

#define S_UPES    26
#define V_UPES(x) ((x) << S_UPES)
#define F_UPES    V_UPES(1U)

#define S_RCES    25
#define V_RCES(x) ((x) << S_RCES)
#define F_RCES    V_RCES(1U)

#define S_EPES    24
#define V_EPES(x) ((x) << S_EPES)
#define F_EPES    V_EPES(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_STATUS 0x5908

#define S_RNPP    31
#define V_RNPP(x) ((x) << S_RNPP)
#define F_RNPP    V_RNPP(1U)

#define S_RPCP    29
#define V_RPCP(x) ((x) << S_RPCP)
#define F_RPCP    V_RPCP(1U)

#define S_RCIP    27
#define V_RCIP(x) ((x) << S_RCIP)
#define F_RCIP    V_RCIP(1U)

#define S_RCCP    26
#define V_RCCP(x) ((x) << S_RCCP)
#define F_RCCP    V_RCCP(1U)

#define S_RFTP    23
#define V_RFTP(x) ((x) << S_RFTP)
#define F_RFTP    V_RFTP(1U)

#define S_PTRP    20
#define V_PTRP(x) ((x) << S_PTRP)
#define F_PTRP    V_PTRP(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_ERROR_SEVERITY 0x590c

#define S_RNPS    31
#define V_RNPS(x) ((x) << S_RNPS)
#define F_RNPS    V_RNPS(1U)

#define S_RPCS    29
#define V_RPCS(x) ((x) << S_RPCS)
#define F_RPCS    V_RPCS(1U)

#define S_RCIS    27
#define V_RCIS(x) ((x) << S_RCIS)
#define F_RCIS    V_RCIS(1U)

#define S_RCCS    26
#define V_RCCS(x) ((x) << S_RCCS)
#define F_RCCS    V_RCCS(1U)

#define S_RFTS    23
#define V_RFTS(x) ((x) << S_RFTS)
#define F_RFTS    V_RFTS(1U)

#define A_PCIE_CORE_UTL_SYSTEM_BUS_AGENT_INTERRUPT_ENABLE 0x5910

#define S_RNPI    31
#define V_RNPI(x) ((x) << S_RNPI)
#define F_RNPI    V_RNPI(1U)

#define S_RPCI    29
#define V_RPCI(x) ((x) << S_RPCI)
#define F_RPCI    V_RPCI(1U)

#define S_RCII    27
#define V_RCII(x) ((x) << S_RCII)
#define F_RCII    V_RCII(1U)

#define S_RCCI    26
#define V_RCCI(x) ((x) << S_RCCI)
#define F_RCCI    V_RCCI(1U)

#define S_RFTI    23
#define V_RFTI(x) ((x) << S_RFTI)
#define F_RFTI    V_RFTI(1U)

#define A_PCIE_CORE_SYSTEM_BUS_BURST_SIZE_CONFIGURATION 0x5920

#define S_SBRS    28
#define M_SBRS    0x7U
#define V_SBRS(x) ((x) << S_SBRS)
#define G_SBRS(x) (((x) >> S_SBRS) & M_SBRS)

#define S_OTWS    20
#define M_OTWS    0x7U
#define V_OTWS(x) ((x) << S_OTWS)
#define G_OTWS(x) (((x) >> S_OTWS) & M_OTWS)

#define A_PCIE_CORE_REVISION_ID 0x5924

#define S_RVID    20
#define M_RVID    0xfffU
#define V_RVID(x) ((x) << S_RVID)
#define G_RVID(x) (((x) >> S_RVID) & M_RVID)

#define S_BRVN    12
#define M_BRVN    0xffU
#define V_BRVN(x) ((x) << S_BRVN)
#define G_BRVN(x) (((x) >> S_BRVN) & M_BRVN)

#define A_PCIE_T5_DMA_CFG 0x5940

#define S_T5_DMA_MAXREQCNT    20
#define M_T5_DMA_MAXREQCNT    0xffU
#define V_T5_DMA_MAXREQCNT(x) ((x) << S_T5_DMA_MAXREQCNT)
#define G_T5_DMA_MAXREQCNT(x) (((x) >> S_T5_DMA_MAXREQCNT) & M_T5_DMA_MAXREQCNT)

#define S_T5_DMA_MAXRDREQSIZE    17
#define M_T5_DMA_MAXRDREQSIZE    0x7U
#define V_T5_DMA_MAXRDREQSIZE(x) ((x) << S_T5_DMA_MAXRDREQSIZE)
#define G_T5_DMA_MAXRDREQSIZE(x) (((x) >> S_T5_DMA_MAXRDREQSIZE) & M_T5_DMA_MAXRDREQSIZE)

#define S_T5_DMA_MAXRSPCNT    8
#define M_T5_DMA_MAXRSPCNT    0x1ffU
#define V_T5_DMA_MAXRSPCNT(x) ((x) << S_T5_DMA_MAXRSPCNT)
#define G_T5_DMA_MAXRSPCNT(x) (((x) >> S_T5_DMA_MAXRSPCNT) & M_T5_DMA_MAXRSPCNT)

#define S_SEQCHKDIS    7
#define V_SEQCHKDIS(x) ((x) << S_SEQCHKDIS)
#define F_SEQCHKDIS    V_SEQCHKDIS(1U)

#define S_MINTAG    0
#define M_MINTAG    0x7fU
#define V_MINTAG(x) ((x) << S_MINTAG)
#define G_MINTAG(x) (((x) >> S_MINTAG) & M_MINTAG)

#define S_T6_T5_DMA_MAXREQCNT    20
#define M_T6_T5_DMA_MAXREQCNT    0x7fU
#define V_T6_T5_DMA_MAXREQCNT(x) ((x) << S_T6_T5_DMA_MAXREQCNT)
#define G_T6_T5_DMA_MAXREQCNT(x) (((x) >> S_T6_T5_DMA_MAXREQCNT) & M_T6_T5_DMA_MAXREQCNT)

#define S_T6_T5_DMA_MAXRSPCNT    9
#define M_T6_T5_DMA_MAXRSPCNT    0xffU
#define V_T6_T5_DMA_MAXRSPCNT(x) ((x) << S_T6_T5_DMA_MAXRSPCNT)
#define G_T6_T5_DMA_MAXRSPCNT(x) (((x) >> S_T6_T5_DMA_MAXRSPCNT) & M_T6_T5_DMA_MAXRSPCNT)

#define S_T6_SEQCHKDIS    8
#define V_T6_SEQCHKDIS(x) ((x) << S_T6_SEQCHKDIS)
#define F_T6_SEQCHKDIS    V_T6_SEQCHKDIS(1U)

#define S_T6_MINTAG    0
#define M_T6_MINTAG    0xffU
#define V_T6_MINTAG(x) ((x) << S_T6_MINTAG)
#define G_T6_MINTAG(x) (((x) >> S_T6_MINTAG) & M_T6_MINTAG)

#define A_PCIE_T5_DMA_STAT 0x5944

#define S_DMA_RESPCNT    20
#define M_DMA_RESPCNT    0xfffU
#define V_DMA_RESPCNT(x) ((x) << S_DMA_RESPCNT)
#define G_DMA_RESPCNT(x) (((x) >> S_DMA_RESPCNT) & M_DMA_RESPCNT)

#define S_DMA_RDREQCNT    12
#define M_DMA_RDREQCNT    0xffU
#define V_DMA_RDREQCNT(x) ((x) << S_DMA_RDREQCNT)
#define G_DMA_RDREQCNT(x) (((x) >> S_DMA_RDREQCNT) & M_DMA_RDREQCNT)

#define S_DMA_WRREQCNT    0
#define M_DMA_WRREQCNT    0x7ffU
#define V_DMA_WRREQCNT(x) ((x) << S_DMA_WRREQCNT)
#define G_DMA_WRREQCNT(x) (((x) >> S_DMA_WRREQCNT) & M_DMA_WRREQCNT)

#define S_T6_DMA_RESPCNT    20
#define M_T6_DMA_RESPCNT    0x3ffU
#define V_T6_DMA_RESPCNT(x) ((x) << S_T6_DMA_RESPCNT)
#define G_T6_DMA_RESPCNT(x) (((x) >> S_T6_DMA_RESPCNT) & M_T6_DMA_RESPCNT)

#define S_T6_DMA_RDREQCNT    12
#define M_T6_DMA_RDREQCNT    0x3fU
#define V_T6_DMA_RDREQCNT(x) ((x) << S_T6_DMA_RDREQCNT)
#define G_T6_DMA_RDREQCNT(x) (((x) >> S_T6_DMA_RDREQCNT) & M_T6_DMA_RDREQCNT)

#define S_T6_DMA_WRREQCNT    0
#define M_T6_DMA_WRREQCNT    0x1ffU
#define V_T6_DMA_WRREQCNT(x) ((x) << S_T6_DMA_WRREQCNT)
#define G_T6_DMA_WRREQCNT(x) (((x) >> S_T6_DMA_WRREQCNT) & M_T6_DMA_WRREQCNT)

#define A_PCIE_T5_DMA_STAT2 0x5948

#define S_COOKIECNT    24
#define M_COOKIECNT    0xfU
#define V_COOKIECNT(x) ((x) << S_COOKIECNT)
#define G_COOKIECNT(x) (((x) >> S_COOKIECNT) & M_COOKIECNT)

#define S_RDSEQNUMUPDCNT    20
#define M_RDSEQNUMUPDCNT    0xfU
#define V_RDSEQNUMUPDCNT(x) ((x) << S_RDSEQNUMUPDCNT)
#define G_RDSEQNUMUPDCNT(x) (((x) >> S_RDSEQNUMUPDCNT) & M_RDSEQNUMUPDCNT)

#define S_SIREQCNT    16
#define M_SIREQCNT    0xfU
#define V_SIREQCNT(x) ((x) << S_SIREQCNT)
#define G_SIREQCNT(x) (((x) >> S_SIREQCNT) & M_SIREQCNT)

#define S_WREOPMATCHSOP    12
#define V_WREOPMATCHSOP(x) ((x) << S_WREOPMATCHSOP)
#define F_WREOPMATCHSOP    V_WREOPMATCHSOP(1U)

#define S_WRSOPCNT    8
#define M_WRSOPCNT    0xfU
#define V_WRSOPCNT(x) ((x) << S_WRSOPCNT)
#define G_WRSOPCNT(x) (((x) >> S_WRSOPCNT) & M_WRSOPCNT)

#define S_RDSOPCNT    0
#define M_RDSOPCNT    0xffU
#define V_RDSOPCNT(x) ((x) << S_RDSOPCNT)
#define G_RDSOPCNT(x) (((x) >> S_RDSOPCNT) & M_RDSOPCNT)

#define S_DMA_COOKIECNT    24
#define M_DMA_COOKIECNT    0xfU
#define V_DMA_COOKIECNT(x) ((x) << S_DMA_COOKIECNT)
#define G_DMA_COOKIECNT(x) (((x) >> S_DMA_COOKIECNT) & M_DMA_COOKIECNT)

#define S_DMA_RDSEQNUMUPDCNT    20
#define M_DMA_RDSEQNUMUPDCNT    0xfU
#define V_DMA_RDSEQNUMUPDCNT(x) ((x) << S_DMA_RDSEQNUMUPDCNT)
#define G_DMA_RDSEQNUMUPDCNT(x) (((x) >> S_DMA_RDSEQNUMUPDCNT) & M_DMA_RDSEQNUMUPDCNT)

#define S_DMA_SIREQCNT    16
#define M_DMA_SIREQCNT    0xfU
#define V_DMA_SIREQCNT(x) ((x) << S_DMA_SIREQCNT)
#define G_DMA_SIREQCNT(x) (((x) >> S_DMA_SIREQCNT) & M_DMA_SIREQCNT)

#define S_DMA_WREOPMATCHSOP    12
#define V_DMA_WREOPMATCHSOP(x) ((x) << S_DMA_WREOPMATCHSOP)
#define F_DMA_WREOPMATCHSOP    V_DMA_WREOPMATCHSOP(1U)

#define S_DMA_WRSOPCNT    8
#define M_DMA_WRSOPCNT    0xfU
#define V_DMA_WRSOPCNT(x) ((x) << S_DMA_WRSOPCNT)
#define G_DMA_WRSOPCNT(x) (((x) >> S_DMA_WRSOPCNT) & M_DMA_WRSOPCNT)

#define S_DMA_RDSOPCNT    0
#define M_DMA_RDSOPCNT    0xffU
#define V_DMA_RDSOPCNT(x) ((x) << S_DMA_RDSOPCNT)
#define G_DMA_RDSOPCNT(x) (((x) >> S_DMA_RDSOPCNT) & M_DMA_RDSOPCNT)

#define A_PCIE_T5_DMA_STAT3 0x594c

#define S_ATMREQSOPCNT    24
#define M_ATMREQSOPCNT    0xffU
#define V_ATMREQSOPCNT(x) ((x) << S_ATMREQSOPCNT)
#define G_ATMREQSOPCNT(x) (((x) >> S_ATMREQSOPCNT) & M_ATMREQSOPCNT)

#define S_ATMEOPMATCHSOP    17
#define V_ATMEOPMATCHSOP(x) ((x) << S_ATMEOPMATCHSOP)
#define F_ATMEOPMATCHSOP    V_ATMEOPMATCHSOP(1U)

#define S_RSPEOPMATCHSOP    16
#define V_RSPEOPMATCHSOP(x) ((x) << S_RSPEOPMATCHSOP)
#define F_RSPEOPMATCHSOP    V_RSPEOPMATCHSOP(1U)

#define S_RSPERRCNT    8
#define M_RSPERRCNT    0xffU
#define V_RSPERRCNT(x) ((x) << S_RSPERRCNT)
#define G_RSPERRCNT(x) (((x) >> S_RSPERRCNT) & M_RSPERRCNT)

#define S_RSPSOPCNT    0
#define M_RSPSOPCNT    0xffU
#define V_RSPSOPCNT(x) ((x) << S_RSPSOPCNT)
#define G_RSPSOPCNT(x) (((x) >> S_RSPSOPCNT) & M_RSPSOPCNT)

#define S_DMA_ATMREQSOPCNT    24
#define M_DMA_ATMREQSOPCNT    0xffU
#define V_DMA_ATMREQSOPCNT(x) ((x) << S_DMA_ATMREQSOPCNT)
#define G_DMA_ATMREQSOPCNT(x) (((x) >> S_DMA_ATMREQSOPCNT) & M_DMA_ATMREQSOPCNT)

#define S_DMA_ATMEOPMATCHSOP    17
#define V_DMA_ATMEOPMATCHSOP(x) ((x) << S_DMA_ATMEOPMATCHSOP)
#define F_DMA_ATMEOPMATCHSOP    V_DMA_ATMEOPMATCHSOP(1U)

#define S_DMA_RSPEOPMATCHSOP    16
#define V_DMA_RSPEOPMATCHSOP(x) ((x) << S_DMA_RSPEOPMATCHSOP)
#define F_DMA_RSPEOPMATCHSOP    V_DMA_RSPEOPMATCHSOP(1U)

#define S_DMA_RSPERRCNT    8
#define M_DMA_RSPERRCNT    0xffU
#define V_DMA_RSPERRCNT(x) ((x) << S_DMA_RSPERRCNT)
#define G_DMA_RSPERRCNT(x) (((x) >> S_DMA_RSPERRCNT) & M_DMA_RSPERRCNT)

#define S_DMA_RSPSOPCNT    0
#define M_DMA_RSPSOPCNT    0xffU
#define V_DMA_RSPSOPCNT(x) ((x) << S_DMA_RSPSOPCNT)
#define G_DMA_RSPSOPCNT(x) (((x) >> S_DMA_RSPSOPCNT) & M_DMA_RSPSOPCNT)

#define A_PCIE_CORE_OUTBOUND_POSTED_HEADER_BUFFER_ALLOCATION 0x5960

#define S_OP0H    24
#define M_OP0H    0xfU
#define V_OP0H(x) ((x) << S_OP0H)
#define G_OP0H(x) (((x) >> S_OP0H) & M_OP0H)

#define S_OP1H    16
#define M_OP1H    0xfU
#define V_OP1H(x) ((x) << S_OP1H)
#define G_OP1H(x) (((x) >> S_OP1H) & M_OP1H)

#define S_OP2H    8
#define M_OP2H    0xfU
#define V_OP2H(x) ((x) << S_OP2H)
#define G_OP2H(x) (((x) >> S_OP2H) & M_OP2H)

#define S_OP3H    0
#define M_OP3H    0xfU
#define V_OP3H(x) ((x) << S_OP3H)
#define G_OP3H(x) (((x) >> S_OP3H) & M_OP3H)

#define A_PCIE_CORE_OUTBOUND_POSTED_DATA_BUFFER_ALLOCATION 0x5968

#define S_OP0D    24
#define M_OP0D    0x7fU
#define V_OP0D(x) ((x) << S_OP0D)
#define G_OP0D(x) (((x) >> S_OP0D) & M_OP0D)

#define S_OP1D    16
#define M_OP1D    0x7fU
#define V_OP1D(x) ((x) << S_OP1D)
#define G_OP1D(x) (((x) >> S_OP1D) & M_OP1D)

#define S_OP2D    8
#define M_OP2D    0x7fU
#define V_OP2D(x) ((x) << S_OP2D)
#define G_OP2D(x) (((x) >> S_OP2D) & M_OP2D)

#define S_OP3D    0
#define M_OP3D    0x7fU
#define V_OP3D(x) ((x) << S_OP3D)
#define G_OP3D(x) (((x) >> S_OP3D) & M_OP3D)

#define A_PCIE_CORE_INBOUND_POSTED_HEADER_BUFFER_ALLOCATION 0x5970

#define S_IP0H    24
#define M_IP0H    0x3fU
#define V_IP0H(x) ((x) << S_IP0H)
#define G_IP0H(x) (((x) >> S_IP0H) & M_IP0H)

#define S_IP1H    16
#define M_IP1H    0x3fU
#define V_IP1H(x) ((x) << S_IP1H)
#define G_IP1H(x) (((x) >> S_IP1H) & M_IP1H)

#define S_IP2H    8
#define M_IP2H    0x3fU
#define V_IP2H(x) ((x) << S_IP2H)
#define G_IP2H(x) (((x) >> S_IP2H) & M_IP2H)

#define S_IP3H    0
#define M_IP3H    0x3fU
#define V_IP3H(x) ((x) << S_IP3H)
#define G_IP3H(x) (((x) >> S_IP3H) & M_IP3H)

#define A_PCIE_CORE_INBOUND_POSTED_DATA_BUFFER_ALLOCATION 0x5978

#define S_IP0D    24
#define M_IP0D    0xffU
#define V_IP0D(x) ((x) << S_IP0D)
#define G_IP0D(x) (((x) >> S_IP0D) & M_IP0D)

#define S_IP1D    16
#define M_IP1D    0xffU
#define V_IP1D(x) ((x) << S_IP1D)
#define G_IP1D(x) (((x) >> S_IP1D) & M_IP1D)

#define S_IP2D    8
#define M_IP2D    0xffU
#define V_IP2D(x) ((x) << S_IP2D)
#define G_IP2D(x) (((x) >> S_IP2D) & M_IP2D)

#define S_IP3D    0
#define M_IP3D    0xffU
#define V_IP3D(x) ((x) << S_IP3D)
#define G_IP3D(x) (((x) >> S_IP3D) & M_IP3D)

#define A_PCIE_CORE_OUTBOUND_NON_POSTED_BUFFER_ALLOCATION 0x5980

#define S_ON0H    24
#define M_ON0H    0xfU
#define V_ON0H(x) ((x) << S_ON0H)
#define G_ON0H(x) (((x) >> S_ON0H) & M_ON0H)

#define S_ON1H    16
#define M_ON1H    0xfU
#define V_ON1H(x) ((x) << S_ON1H)
#define G_ON1H(x) (((x) >> S_ON1H) & M_ON1H)

#define S_ON2H    8
#define M_ON2H    0xfU
#define V_ON2H(x) ((x) << S_ON2H)
#define G_ON2H(x) (((x) >> S_ON2H) & M_ON2H)

#define S_ON3H    0
#define M_ON3H    0xfU
#define V_ON3H(x) ((x) << S_ON3H)
#define G_ON3H(x) (((x) >> S_ON3H) & M_ON3H)

#define A_PCIE_T5_CMD_CFG 0x5980

#define S_T5_CMD_MAXRDREQSIZE    17
#define M_T5_CMD_MAXRDREQSIZE    0x7U
#define V_T5_CMD_MAXRDREQSIZE(x) ((x) << S_T5_CMD_MAXRDREQSIZE)
#define G_T5_CMD_MAXRDREQSIZE(x) (((x) >> S_T5_CMD_MAXRDREQSIZE) & M_T5_CMD_MAXRDREQSIZE)

#define S_T5_CMD_MAXRSPCNT    8
#define M_T5_CMD_MAXRSPCNT    0xffU
#define V_T5_CMD_MAXRSPCNT(x) ((x) << S_T5_CMD_MAXRSPCNT)
#define G_T5_CMD_MAXRSPCNT(x) (((x) >> S_T5_CMD_MAXRSPCNT) & M_T5_CMD_MAXRSPCNT)

#define S_USECMDPOOL    7
#define V_USECMDPOOL(x) ((x) << S_USECMDPOOL)
#define F_USECMDPOOL    V_USECMDPOOL(1U)

#define S_T6_T5_CMD_MAXRSPCNT    9
#define M_T6_T5_CMD_MAXRSPCNT    0x3fU
#define V_T6_T5_CMD_MAXRSPCNT(x) ((x) << S_T6_T5_CMD_MAXRSPCNT)
#define G_T6_T5_CMD_MAXRSPCNT(x) (((x) >> S_T6_T5_CMD_MAXRSPCNT) & M_T6_T5_CMD_MAXRSPCNT)

#define S_T6_USECMDPOOL    8
#define V_T6_USECMDPOOL(x) ((x) << S_T6_USECMDPOOL)
#define F_T6_USECMDPOOL    V_T6_USECMDPOOL(1U)

#define A_PCIE_T5_CMD_STAT 0x5984

#define S_T5_STAT_RSPCNT    20
#define M_T5_STAT_RSPCNT    0x7ffU
#define V_T5_STAT_RSPCNT(x) ((x) << S_T5_STAT_RSPCNT)
#define G_T5_STAT_RSPCNT(x) (((x) >> S_T5_STAT_RSPCNT) & M_T5_STAT_RSPCNT)

#define S_RDREQCNT    12
#define M_RDREQCNT    0x1fU
#define V_RDREQCNT(x) ((x) << S_RDREQCNT)
#define G_RDREQCNT(x) (((x) >> S_RDREQCNT) & M_RDREQCNT)

#define S_T6_T5_STAT_RSPCNT    20
#define M_T6_T5_STAT_RSPCNT    0xffU
#define V_T6_T5_STAT_RSPCNT(x) ((x) << S_T6_T5_STAT_RSPCNT)
#define G_T6_T5_STAT_RSPCNT(x) (((x) >> S_T6_T5_STAT_RSPCNT) & M_T6_T5_STAT_RSPCNT)

#define S_T6_RDREQCNT    12
#define M_T6_RDREQCNT    0xfU
#define V_T6_RDREQCNT(x) ((x) << S_T6_RDREQCNT)
#define G_T6_RDREQCNT(x) (((x) >> S_T6_RDREQCNT) & M_T6_RDREQCNT)

#define A_PCIE_CORE_INBOUND_NON_POSTED_REQUESTS_BUFFER_ALLOCATION 0x5988

#define S_IN0H    24
#define M_IN0H    0x3fU
#define V_IN0H(x) ((x) << S_IN0H)
#define G_IN0H(x) (((x) >> S_IN0H) & M_IN0H)

#define S_IN1H    16
#define M_IN1H    0x3fU
#define V_IN1H(x) ((x) << S_IN1H)
#define G_IN1H(x) (((x) >> S_IN1H) & M_IN1H)

#define S_IN2H    8
#define M_IN2H    0x3fU
#define V_IN2H(x) ((x) << S_IN2H)
#define G_IN2H(x) (((x) >> S_IN2H) & M_IN2H)

#define S_IN3H    0
#define M_IN3H    0x3fU
#define V_IN3H(x) ((x) << S_IN3H)
#define G_IN3H(x) (((x) >> S_IN3H) & M_IN3H)

#define A_PCIE_T5_CMD_STAT2 0x5988
#define A_PCIE_T5_CMD_STAT3 0x598c

#define S_CMD_RSPEOPMATCHSOP    16
#define V_CMD_RSPEOPMATCHSOP(x) ((x) << S_CMD_RSPEOPMATCHSOP)
#define F_CMD_RSPEOPMATCHSOP    V_CMD_RSPEOPMATCHSOP(1U)

#define S_CMD_RSPERRCNT    8
#define M_CMD_RSPERRCNT    0xffU
#define V_CMD_RSPERRCNT(x) ((x) << S_CMD_RSPERRCNT)
#define G_CMD_RSPERRCNT(x) (((x) >> S_CMD_RSPERRCNT) & M_CMD_RSPERRCNT)

#define S_CMD_RSPSOPCNT    0
#define M_CMD_RSPSOPCNT    0xffU
#define V_CMD_RSPSOPCNT(x) ((x) << S_CMD_RSPSOPCNT)
#define G_CMD_RSPSOPCNT(x) (((x) >> S_CMD_RSPSOPCNT) & M_CMD_RSPSOPCNT)

#define A_PCIE_CORE_PCI_EXPRESS_TAGS_ALLOCATION 0x5990

#define S_OC0T    24
#define M_OC0T    0xffU
#define V_OC0T(x) ((x) << S_OC0T)
#define G_OC0T(x) (((x) >> S_OC0T) & M_OC0T)

#define S_OC1T    16
#define M_OC1T    0xffU
#define V_OC1T(x) ((x) << S_OC1T)
#define G_OC1T(x) (((x) >> S_OC1T) & M_OC1T)

#define S_OC2T    8
#define M_OC2T    0xffU
#define V_OC2T(x) ((x) << S_OC2T)
#define G_OC2T(x) (((x) >> S_OC2T) & M_OC2T)

#define S_OC3T    0
#define M_OC3T    0xffU
#define V_OC3T(x) ((x) << S_OC3T)
#define G_OC3T(x) (((x) >> S_OC3T) & M_OC3T)

#define A_PCIE_CORE_GBIF_READ_TAGS_ALLOCATION 0x5998

#define S_IC0T    24
#define M_IC0T    0x3fU
#define V_IC0T(x) ((x) << S_IC0T)
#define G_IC0T(x) (((x) >> S_IC0T) & M_IC0T)

#define S_IC1T    16
#define M_IC1T    0x3fU
#define V_IC1T(x) ((x) << S_IC1T)
#define G_IC1T(x) (((x) >> S_IC1T) & M_IC1T)

#define S_IC2T    8
#define M_IC2T    0x3fU
#define V_IC2T(x) ((x) << S_IC2T)
#define G_IC2T(x) (((x) >> S_IC2T) & M_IC2T)

#define S_IC3T    0
#define M_IC3T    0x3fU
#define V_IC3T(x) ((x) << S_IC3T)
#define G_IC3T(x) (((x) >> S_IC3T) & M_IC3T)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_CONTROL 0x59a0

#define S_VRB0    31
#define V_VRB0(x) ((x) << S_VRB0)
#define F_VRB0    V_VRB0(1U)

#define S_VRB1    30
#define V_VRB1(x) ((x) << S_VRB1)
#define F_VRB1    V_VRB1(1U)

#define S_VRB2    29
#define V_VRB2(x) ((x) << S_VRB2)
#define F_VRB2    V_VRB2(1U)

#define S_VRB3    28
#define V_VRB3(x) ((x) << S_VRB3)
#define F_VRB3    V_VRB3(1U)

#define S_PSFE    26
#define V_PSFE(x) ((x) << S_PSFE)
#define F_PSFE    V_PSFE(1U)

#define S_RVDE    25
#define V_RVDE(x) ((x) << S_RVDE)
#define F_RVDE    V_RVDE(1U)

#define S_TXE0    23
#define V_TXE0(x) ((x) << S_TXE0)
#define F_TXE0    V_TXE0(1U)

#define S_TXE1    22
#define V_TXE1(x) ((x) << S_TXE1)
#define F_TXE1    V_TXE1(1U)

#define S_TXE2    21
#define V_TXE2(x) ((x) << S_TXE2)
#define F_TXE2    V_TXE2(1U)

#define S_TXE3    20
#define V_TXE3(x) ((x) << S_TXE3)
#define F_TXE3    V_TXE3(1U)

#define S_RPAM    13
#define V_RPAM(x) ((x) << S_RPAM)
#define F_RPAM    V_RPAM(1U)

#define S_RTOS    4
#define M_RTOS    0xfU
#define V_RTOS(x) ((x) << S_RTOS)
#define G_RTOS(x) (((x) >> S_RTOS) & M_RTOS)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_STATUS 0x59a4

#define S_TPCP    30
#define V_TPCP(x) ((x) << S_TPCP)
#define F_TPCP    V_TPCP(1U)

#define S_TNPP    29
#define V_TNPP(x) ((x) << S_TNPP)
#define F_TNPP    V_TNPP(1U)

#define S_TFTP    28
#define V_TFTP(x) ((x) << S_TFTP)
#define F_TFTP    V_TFTP(1U)

#define S_TCAP    27
#define V_TCAP(x) ((x) << S_TCAP)
#define F_TCAP    V_TCAP(1U)

#define S_TCIP    26
#define V_TCIP(x) ((x) << S_TCIP)
#define F_TCIP    V_TCIP(1U)

#define S_RCAP    25
#define V_RCAP(x) ((x) << S_RCAP)
#define F_RCAP    V_RCAP(1U)

#define S_PLUP    23
#define V_PLUP(x) ((x) << S_PLUP)
#define F_PLUP    V_PLUP(1U)

#define S_PLDN    22
#define V_PLDN(x) ((x) << S_PLDN)
#define F_PLDN    V_PLDN(1U)

#define S_OTDD    21
#define V_OTDD(x) ((x) << S_OTDD)
#define F_OTDD    V_OTDD(1U)

#define S_GTRP    20
#define V_GTRP(x) ((x) << S_GTRP)
#define F_GTRP    V_GTRP(1U)

#define S_RDPE    18
#define V_RDPE(x) ((x) << S_RDPE)
#define F_RDPE    V_RDPE(1U)

#define S_TDCE    17
#define V_TDCE(x) ((x) << S_TDCE)
#define F_TDCE    V_TDCE(1U)

#define S_TDUE    16
#define V_TDUE(x) ((x) << S_TDUE)
#define F_TDUE    V_TDUE(1U)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_ERROR_SEVERITY 0x59a8

#define S_TPCS    30
#define V_TPCS(x) ((x) << S_TPCS)
#define F_TPCS    V_TPCS(1U)

#define S_TNPS    29
#define V_TNPS(x) ((x) << S_TNPS)
#define F_TNPS    V_TNPS(1U)

#define S_TFTS    28
#define V_TFTS(x) ((x) << S_TFTS)
#define F_TFTS    V_TFTS(1U)

#define S_TCAS    27
#define V_TCAS(x) ((x) << S_TCAS)
#define F_TCAS    V_TCAS(1U)

#define S_TCIS    26
#define V_TCIS(x) ((x) << S_TCIS)
#define F_TCIS    V_TCIS(1U)

#define S_RCAS    25
#define V_RCAS(x) ((x) << S_RCAS)
#define F_RCAS    V_RCAS(1U)

#define S_PLUS    23
#define V_PLUS(x) ((x) << S_PLUS)
#define F_PLUS    V_PLUS(1U)

#define S_PLDS    22
#define V_PLDS(x) ((x) << S_PLDS)
#define F_PLDS    V_PLDS(1U)

#define S_OTDS    21
#define V_OTDS(x) ((x) << S_OTDS)
#define F_OTDS    V_OTDS(1U)

#define S_RDPS    18
#define V_RDPS(x) ((x) << S_RDPS)
#define F_RDPS    V_RDPS(1U)

#define S_TDCS    17
#define V_TDCS(x) ((x) << S_TDCS)
#define F_TDCS    V_TDCS(1U)

#define S_TDUS    16
#define V_TDUS(x) ((x) << S_TDUS)
#define F_TDUS    V_TDUS(1U)

#define A_PCIE_CORE_UTL_PCI_EXPRESS_PORT_INTERRUPT_ENABLE 0x59ac

#define S_TPCI    30
#define V_TPCI(x) ((x) << S_TPCI)
#define F_TPCI    V_TPCI(1U)

#define S_TNPI    29
#define V_TNPI(x) ((x) << S_TNPI)
#define F_TNPI    V_TNPI(1U)

#define S_TFTI    28
#define V_TFTI(x) ((x) << S_TFTI)
#define F_TFTI    V_TFTI(1U)

#define S_TCAI    27
#define V_TCAI(x) ((x) << S_TCAI)
#define F_TCAI    V_TCAI(1U)

#define S_TCII    26
#define V_TCII(x) ((x) << S_TCII)
#define F_TCII    V_TCII(1U)

#define S_RCAI    25
#define V_RCAI(x) ((x) << S_RCAI)
#define F_RCAI    V_RCAI(1U)

#define S_PLUI    23
#define V_PLUI(x) ((x) << S_PLUI)
#define F_PLUI    V_PLUI(1U)

#define S_PLDI    22
#define V_PLDI(x) ((x) << S_PLDI)
#define F_PLDI    V_PLDI(1U)

#define S_OTDI    21
#define V_OTDI(x) ((x) << S_OTDI)
#define F_OTDI    V_OTDI(1U)

#define A_PCIE_CORE_ROOT_COMPLEX_STATUS 0x59b0

#define S_RLCE    31
#define V_RLCE(x) ((x) << S_RLCE)
#define F_RLCE    V_RLCE(1U)

#define S_RLNE    30
#define V_RLNE(x) ((x) << S_RLNE)
#define F_RLNE    V_RLNE(1U)

#define S_RLFE    29
#define V_RLFE(x) ((x) << S_RLFE)
#define F_RLFE    V_RLFE(1U)

#define S_RCPE    25
#define V_RCPE(x) ((x) << S_RCPE)
#define F_RCPE    V_RCPE(1U)

#define S_RCTO    24
#define V_RCTO(x) ((x) << S_RCTO)
#define F_RCTO    V_RCTO(1U)

#define S_PINA    23
#define V_PINA(x) ((x) << S_PINA)
#define F_PINA    V_PINA(1U)

#define S_PINB    22
#define V_PINB(x) ((x) << S_PINB)
#define F_PINB    V_PINB(1U)

#define S_PINC    21
#define V_PINC(x) ((x) << S_PINC)
#define F_PINC    V_PINC(1U)

#define S_PIND    20
#define V_PIND(x) ((x) << S_PIND)
#define F_PIND    V_PIND(1U)

#define S_ALER    19
#define V_ALER(x) ((x) << S_ALER)
#define F_ALER    V_ALER(1U)

#define S_CRSE    18
#define V_CRSE(x) ((x) << S_CRSE)
#define F_CRSE    V_CRSE(1U)

#define A_PCIE_T5_HMA_CFG 0x59b0

#define S_HMA_MAXREQCNT    20
#define M_HMA_MAXREQCNT    0x1fU
#define V_HMA_MAXREQCNT(x) ((x) << S_HMA_MAXREQCNT)
#define G_HMA_MAXREQCNT(x) (((x) >> S_HMA_MAXREQCNT) & M_HMA_MAXREQCNT)

#define S_T5_HMA_MAXRDREQSIZE    17
#define M_T5_HMA_MAXRDREQSIZE    0x7U
#define V_T5_HMA_MAXRDREQSIZE(x) ((x) << S_T5_HMA_MAXRDREQSIZE)
#define G_T5_HMA_MAXRDREQSIZE(x) (((x) >> S_T5_HMA_MAXRDREQSIZE) & M_T5_HMA_MAXRDREQSIZE)

#define S_T5_HMA_MAXRSPCNT    8
#define M_T5_HMA_MAXRSPCNT    0x1fU
#define V_T5_HMA_MAXRSPCNT(x) ((x) << S_T5_HMA_MAXRSPCNT)
#define G_T5_HMA_MAXRSPCNT(x) (((x) >> S_T5_HMA_MAXRSPCNT) & M_T5_HMA_MAXRSPCNT)

#define S_T6_HMA_MAXREQCNT    20
#define M_T6_HMA_MAXREQCNT    0x7fU
#define V_T6_HMA_MAXREQCNT(x) ((x) << S_T6_HMA_MAXREQCNT)
#define G_T6_HMA_MAXREQCNT(x) (((x) >> S_T6_HMA_MAXREQCNT) & M_T6_HMA_MAXREQCNT)

#define S_T6_T5_HMA_MAXRSPCNT    9
#define M_T6_T5_HMA_MAXRSPCNT    0xffU
#define V_T6_T5_HMA_MAXRSPCNT(x) ((x) << S_T6_T5_HMA_MAXRSPCNT)
#define G_T6_T5_HMA_MAXRSPCNT(x) (((x) >> S_T6_T5_HMA_MAXRSPCNT) & M_T6_T5_HMA_MAXRSPCNT)

#define S_T5_HMA_SEQCHKDIS    8
#define V_T5_HMA_SEQCHKDIS(x) ((x) << S_T5_HMA_SEQCHKDIS)
#define F_T5_HMA_SEQCHKDIS    V_T5_HMA_SEQCHKDIS(1U)

#define S_T5_MINTAG    0
#define M_T5_MINTAG    0xffU
#define V_T5_MINTAG(x) ((x) << S_T5_MINTAG)
#define G_T5_MINTAG(x) (((x) >> S_T5_MINTAG) & M_T5_MINTAG)

#define A_PCIE_CORE_ROOT_COMPLEX_ERROR_SEVERITY 0x59b4

#define S_RLCS    31
#define V_RLCS(x) ((x) << S_RLCS)
#define F_RLCS    V_RLCS(1U)

#define S_RLNS    30
#define V_RLNS(x) ((x) << S_RLNS)
#define F_RLNS    V_RLNS(1U)

#define S_RLFS    29
#define V_RLFS(x) ((x) << S_RLFS)
#define F_RLFS    V_RLFS(1U)

#define S_RCPS    25
#define V_RCPS(x) ((x) << S_RCPS)
#define F_RCPS    V_RCPS(1U)

#define S_RCTS    24
#define V_RCTS(x) ((x) << S_RCTS)
#define F_RCTS    V_RCTS(1U)

#define S_PAAS    23
#define V_PAAS(x) ((x) << S_PAAS)
#define F_PAAS    V_PAAS(1U)

#define S_PABS    22
#define V_PABS(x) ((x) << S_PABS)
#define F_PABS    V_PABS(1U)

#define S_PACS    21
#define V_PACS(x) ((x) << S_PACS)
#define F_PACS    V_PACS(1U)

#define S_PADS    20
#define V_PADS(x) ((x) << S_PADS)
#define F_PADS    V_PADS(1U)

#define S_ALES    19
#define V_ALES(x) ((x) << S_ALES)
#define F_ALES    V_ALES(1U)

#define S_CRSS    18
#define V_CRSS(x) ((x) << S_CRSS)
#define F_CRSS    V_CRSS(1U)

#define A_PCIE_T5_HMA_STAT 0x59b4

#define S_HMA_RESPCNT    20
#define M_HMA_RESPCNT    0x1ffU
#define V_HMA_RESPCNT(x) ((x) << S_HMA_RESPCNT)
#define G_HMA_RESPCNT(x) (((x) >> S_HMA_RESPCNT) & M_HMA_RESPCNT)

#define S_HMA_RDREQCNT    12
#define M_HMA_RDREQCNT    0x3fU
#define V_HMA_RDREQCNT(x) ((x) << S_HMA_RDREQCNT)
#define G_HMA_RDREQCNT(x) (((x) >> S_HMA_RDREQCNT) & M_HMA_RDREQCNT)

#define S_HMA_WRREQCNT    0
#define M_HMA_WRREQCNT    0x1ffU
#define V_HMA_WRREQCNT(x) ((x) << S_HMA_WRREQCNT)
#define G_HMA_WRREQCNT(x) (((x) >> S_HMA_WRREQCNT) & M_HMA_WRREQCNT)

#define S_T6_HMA_RESPCNT    20
#define M_T6_HMA_RESPCNT    0x3ffU
#define V_T6_HMA_RESPCNT(x) ((x) << S_T6_HMA_RESPCNT)
#define G_T6_HMA_RESPCNT(x) (((x) >> S_T6_HMA_RESPCNT) & M_T6_HMA_RESPCNT)

#define A_PCIE_CORE_ROOT_COMPLEX_INTERRUPT_ENABLE 0x59b8

#define S_RLCI    31
#define V_RLCI(x) ((x) << S_RLCI)
#define F_RLCI    V_RLCI(1U)

#define S_RLNI    30
#define V_RLNI(x) ((x) << S_RLNI)
#define F_RLNI    V_RLNI(1U)

#define S_RLFI    29
#define V_RLFI(x) ((x) << S_RLFI)
#define F_RLFI    V_RLFI(1U)

#define S_RCPI    25
#define V_RCPI(x) ((x) << S_RCPI)
#define F_RCPI    V_RCPI(1U)

#define S_RCTI    24
#define V_RCTI(x) ((x) << S_RCTI)
#define F_RCTI    V_RCTI(1U)

#define S_PAAI    23
#define V_PAAI(x) ((x) << S_PAAI)
#define F_PAAI    V_PAAI(1U)

#define S_PABI    22
#define V_PABI(x) ((x) << S_PABI)
#define F_PABI    V_PABI(1U)

#define S_PACI    21
#define V_PACI(x) ((x) << S_PACI)
#define F_PACI    V_PACI(1U)

#define S_PADI    20
#define V_PADI(x) ((x) << S_PADI)
#define F_PADI    V_PADI(1U)

#define S_ALEI    19
#define V_ALEI(x) ((x) << S_ALEI)
#define F_ALEI    V_ALEI(1U)

#define S_CRSI    18
#define V_CRSI(x) ((x) << S_CRSI)
#define F_CRSI    V_CRSI(1U)

#define A_PCIE_T5_HMA_STAT2 0x59b8

#define S_HMA_COOKIECNT    24
#define M_HMA_COOKIECNT    0xfU
#define V_HMA_COOKIECNT(x) ((x) << S_HMA_COOKIECNT)
#define G_HMA_COOKIECNT(x) (((x) >> S_HMA_COOKIECNT) & M_HMA_COOKIECNT)

#define S_HMA_RDSEQNUMUPDCNT    20
#define M_HMA_RDSEQNUMUPDCNT    0xfU
#define V_HMA_RDSEQNUMUPDCNT(x) ((x) << S_HMA_RDSEQNUMUPDCNT)
#define G_HMA_RDSEQNUMUPDCNT(x) (((x) >> S_HMA_RDSEQNUMUPDCNT) & M_HMA_RDSEQNUMUPDCNT)

#define S_HMA_WREOPMATCHSOP    12
#define V_HMA_WREOPMATCHSOP(x) ((x) << S_HMA_WREOPMATCHSOP)
#define F_HMA_WREOPMATCHSOP    V_HMA_WREOPMATCHSOP(1U)

#define S_HMA_WRSOPCNT    8
#define M_HMA_WRSOPCNT    0xfU
#define V_HMA_WRSOPCNT(x) ((x) << S_HMA_WRSOPCNT)
#define G_HMA_WRSOPCNT(x) (((x) >> S_HMA_WRSOPCNT) & M_HMA_WRSOPCNT)

#define S_HMA_RDSOPCNT    0
#define M_HMA_RDSOPCNT    0xffU
#define V_HMA_RDSOPCNT(x) ((x) << S_HMA_RDSOPCNT)
#define G_HMA_RDSOPCNT(x) (((x) >> S_HMA_RDSOPCNT) & M_HMA_RDSOPCNT)

#define A_PCIE_CORE_ENDPOINT_STATUS 0x59bc

#define S_PTOM    31
#define V_PTOM(x) ((x) << S_PTOM)
#define F_PTOM    V_PTOM(1U)

#define S_ALEA    29
#define V_ALEA(x) ((x) << S_ALEA)
#define F_ALEA    V_ALEA(1U)

#define S_PMC0    23
#define V_PMC0(x) ((x) << S_PMC0)
#define F_PMC0    V_PMC0(1U)

#define S_PMC1    22
#define V_PMC1(x) ((x) << S_PMC1)
#define F_PMC1    V_PMC1(1U)

#define S_PMC2    21
#define V_PMC2(x) ((x) << S_PMC2)
#define F_PMC2    V_PMC2(1U)

#define S_PMC3    20
#define V_PMC3(x) ((x) << S_PMC3)
#define F_PMC3    V_PMC3(1U)

#define S_PMC4    19
#define V_PMC4(x) ((x) << S_PMC4)
#define F_PMC4    V_PMC4(1U)

#define S_PMC5    18
#define V_PMC5(x) ((x) << S_PMC5)
#define F_PMC5    V_PMC5(1U)

#define S_PMC6    17
#define V_PMC6(x) ((x) << S_PMC6)
#define F_PMC6    V_PMC6(1U)

#define S_PMC7    16
#define V_PMC7(x) ((x) << S_PMC7)
#define F_PMC7    V_PMC7(1U)

#define A_PCIE_T5_HMA_STAT3 0x59bc

#define S_HMA_RSPEOPMATCHSOP    16
#define V_HMA_RSPEOPMATCHSOP(x) ((x) << S_HMA_RSPEOPMATCHSOP)
#define F_HMA_RSPEOPMATCHSOP    V_HMA_RSPEOPMATCHSOP(1U)

#define S_HMA_RSPERRCNT    8
#define M_HMA_RSPERRCNT    0xffU
#define V_HMA_RSPERRCNT(x) ((x) << S_HMA_RSPERRCNT)
#define G_HMA_RSPERRCNT(x) (((x) >> S_HMA_RSPERRCNT) & M_HMA_RSPERRCNT)

#define S_HMA_RSPSOPCNT    0
#define M_HMA_RSPSOPCNT    0xffU
#define V_HMA_RSPSOPCNT(x) ((x) << S_HMA_RSPSOPCNT)
#define G_HMA_RSPSOPCNT(x) (((x) >> S_HMA_RSPSOPCNT) & M_HMA_RSPSOPCNT)

#define A_PCIE_CORE_ENDPOINT_ERROR_SEVERITY 0x59c0

#define S_PTOS    31
#define V_PTOS(x) ((x) << S_PTOS)
#define F_PTOS    V_PTOS(1U)

#define S_AENS    29
#define V_AENS(x) ((x) << S_AENS)
#define F_AENS    V_AENS(1U)

#define S_PC0S    23
#define V_PC0S(x) ((x) << S_PC0S)
#define F_PC0S    V_PC0S(1U)

#define S_PC1S    22
#define V_PC1S(x) ((x) << S_PC1S)
#define F_PC1S    V_PC1S(1U)

#define S_PC2S    21
#define V_PC2S(x) ((x) << S_PC2S)
#define F_PC2S    V_PC2S(1U)

#define S_PC3S    20
#define V_PC3S(x) ((x) << S_PC3S)
#define F_PC3S    V_PC3S(1U)

#define S_PC4S    19
#define V_PC4S(x) ((x) << S_PC4S)
#define F_PC4S    V_PC4S(1U)

#define S_PC5S    18
#define V_PC5S(x) ((x) << S_PC5S)
#define F_PC5S    V_PC5S(1U)

#define S_PC6S    17
#define V_PC6S(x) ((x) << S_PC6S)
#define F_PC6S    V_PC6S(1U)

#define S_PC7S    16
#define V_PC7S(x) ((x) << S_PC7S)
#define F_PC7S    V_PC7S(1U)

#define S_PME0    15
#define V_PME0(x) ((x) << S_PME0)
#define F_PME0    V_PME0(1U)

#define S_PME1    14
#define V_PME1(x) ((x) << S_PME1)
#define F_PME1    V_PME1(1U)

#define S_PME2    13
#define V_PME2(x) ((x) << S_PME2)
#define F_PME2    V_PME2(1U)

#define S_PME3    12
#define V_PME3(x) ((x) << S_PME3)
#define F_PME3    V_PME3(1U)

#define S_PME4    11
#define V_PME4(x) ((x) << S_PME4)
#define F_PME4    V_PME4(1U)

#define S_PME5    10
#define V_PME5(x) ((x) << S_PME5)
#define F_PME5    V_PME5(1U)

#define S_PME6    9
#define V_PME6(x) ((x) << S_PME6)
#define F_PME6    V_PME6(1U)

#define S_PME7    8
#define V_PME7(x) ((x) << S_PME7)
#define F_PME7    V_PME7(1U)

#define A_PCIE_CGEN 0x59c0

#define S_VPD_DYNAMIC_CGEN    26
#define V_VPD_DYNAMIC_CGEN(x) ((x) << S_VPD_DYNAMIC_CGEN)
#define F_VPD_DYNAMIC_CGEN    V_VPD_DYNAMIC_CGEN(1U)

#define S_MA_DYNAMIC_CGEN    25
#define V_MA_DYNAMIC_CGEN(x) ((x) << S_MA_DYNAMIC_CGEN)
#define F_MA_DYNAMIC_CGEN    V_MA_DYNAMIC_CGEN(1U)

#define S_TAGQ_DYNAMIC_CGEN    24
#define V_TAGQ_DYNAMIC_CGEN(x) ((x) << S_TAGQ_DYNAMIC_CGEN)
#define F_TAGQ_DYNAMIC_CGEN    V_TAGQ_DYNAMIC_CGEN(1U)

#define S_REQCTL_DYNAMIC_CGEN    23
#define V_REQCTL_DYNAMIC_CGEN(x) ((x) << S_REQCTL_DYNAMIC_CGEN)
#define F_REQCTL_DYNAMIC_CGEN    V_REQCTL_DYNAMIC_CGEN(1U)

#define S_RSPDATAPROC_DYNAMIC_CGEN    22
#define V_RSPDATAPROC_DYNAMIC_CGEN(x) ((x) << S_RSPDATAPROC_DYNAMIC_CGEN)
#define F_RSPDATAPROC_DYNAMIC_CGEN    V_RSPDATAPROC_DYNAMIC_CGEN(1U)

#define S_RSPRDQ_DYNAMIC_CGEN    21
#define V_RSPRDQ_DYNAMIC_CGEN(x) ((x) << S_RSPRDQ_DYNAMIC_CGEN)
#define F_RSPRDQ_DYNAMIC_CGEN    V_RSPRDQ_DYNAMIC_CGEN(1U)

#define S_RSPIPIF_DYNAMIC_CGEN    20
#define V_RSPIPIF_DYNAMIC_CGEN(x) ((x) << S_RSPIPIF_DYNAMIC_CGEN)
#define F_RSPIPIF_DYNAMIC_CGEN    V_RSPIPIF_DYNAMIC_CGEN(1U)

#define S_HMA_STATIC_CGEN    19
#define V_HMA_STATIC_CGEN(x) ((x) << S_HMA_STATIC_CGEN)
#define F_HMA_STATIC_CGEN    V_HMA_STATIC_CGEN(1U)

#define S_HMA_DYNAMIC_CGEN    18
#define V_HMA_DYNAMIC_CGEN(x) ((x) << S_HMA_DYNAMIC_CGEN)
#define F_HMA_DYNAMIC_CGEN    V_HMA_DYNAMIC_CGEN(1U)

#define S_CMD_STATIC_CGEN    16
#define V_CMD_STATIC_CGEN(x) ((x) << S_CMD_STATIC_CGEN)
#define F_CMD_STATIC_CGEN    V_CMD_STATIC_CGEN(1U)

#define S_CMD_DYNAMIC_CGEN    15
#define V_CMD_DYNAMIC_CGEN(x) ((x) << S_CMD_DYNAMIC_CGEN)
#define F_CMD_DYNAMIC_CGEN    V_CMD_DYNAMIC_CGEN(1U)

#define S_DMA_STATIC_CGEN    13
#define V_DMA_STATIC_CGEN(x) ((x) << S_DMA_STATIC_CGEN)
#define F_DMA_STATIC_CGEN    V_DMA_STATIC_CGEN(1U)

#define S_DMA_DYNAMIC_CGEN    12
#define V_DMA_DYNAMIC_CGEN(x) ((x) << S_DMA_DYNAMIC_CGEN)
#define F_DMA_DYNAMIC_CGEN    V_DMA_DYNAMIC_CGEN(1U)

#define S_VFID_SLEEPSTATUS    10
#define V_VFID_SLEEPSTATUS(x) ((x) << S_VFID_SLEEPSTATUS)
#define F_VFID_SLEEPSTATUS    V_VFID_SLEEPSTATUS(1U)

#define S_VC1_SLEEPSTATUS    9
#define V_VC1_SLEEPSTATUS(x) ((x) << S_VC1_SLEEPSTATUS)
#define F_VC1_SLEEPSTATUS    V_VC1_SLEEPSTATUS(1U)

#define S_STI_SLEEPSTATUS    8
#define V_STI_SLEEPSTATUS(x) ((x) << S_STI_SLEEPSTATUS)
#define F_STI_SLEEPSTATUS    V_STI_SLEEPSTATUS(1U)

#define S_VFID_SLEEPREQ    2
#define V_VFID_SLEEPREQ(x) ((x) << S_VFID_SLEEPREQ)
#define F_VFID_SLEEPREQ    V_VFID_SLEEPREQ(1U)

#define S_VC1_SLEEPREQ    1
#define V_VC1_SLEEPREQ(x) ((x) << S_VC1_SLEEPREQ)
#define F_VC1_SLEEPREQ    V_VC1_SLEEPREQ(1U)

#define S_STI_SLEEPREQ    0
#define V_STI_SLEEPREQ(x) ((x) << S_STI_SLEEPREQ)
#define F_STI_SLEEPREQ    V_STI_SLEEPREQ(1U)

#define S_ARM_STATIC_CGEN    28
#define V_ARM_STATIC_CGEN(x) ((x) << S_ARM_STATIC_CGEN)
#define F_ARM_STATIC_CGEN    V_ARM_STATIC_CGEN(1U)

#define S_ARM_DYNAMIC_CGEN    27
#define V_ARM_DYNAMIC_CGEN(x) ((x) << S_ARM_DYNAMIC_CGEN)
#define F_ARM_DYNAMIC_CGEN    V_ARM_DYNAMIC_CGEN(1U)

#define A_PCIE_CORE_ENDPOINT_INTERRUPT_ENABLE 0x59c4

#define S_PTOI    31
#define V_PTOI(x) ((x) << S_PTOI)
#define F_PTOI    V_PTOI(1U)

#define S_AENI    29
#define V_AENI(x) ((x) << S_AENI)
#define F_AENI    V_AENI(1U)

#define S_PC0I    23
#define V_PC0I(x) ((x) << S_PC0I)
#define F_PC0I    V_PC0I(1U)

#define S_PC1I    22
#define V_PC1I(x) ((x) << S_PC1I)
#define F_PC1I    V_PC1I(1U)

#define S_PC2I    21
#define V_PC2I(x) ((x) << S_PC2I)
#define F_PC2I    V_PC2I(1U)

#define S_PC3I    20
#define V_PC3I(x) ((x) << S_PC3I)
#define F_PC3I    V_PC3I(1U)

#define S_PC4I    19
#define V_PC4I(x) ((x) << S_PC4I)
#define F_PC4I    V_PC4I(1U)

#define S_PC5I    18
#define V_PC5I(x) ((x) << S_PC5I)
#define F_PC5I    V_PC5I(1U)

#define S_PC6I    17
#define V_PC6I(x) ((x) << S_PC6I)
#define F_PC6I    V_PC6I(1U)

#define S_PC7I    16
#define V_PC7I(x) ((x) << S_PC7I)
#define F_PC7I    V_PC7I(1U)

#define A_PCIE_MA_RSP 0x59c4

#define S_TIMERVALUE    8
#define M_TIMERVALUE    0xffffffU
#define V_TIMERVALUE(x) ((x) << S_TIMERVALUE)
#define G_TIMERVALUE(x) (((x) >> S_TIMERVALUE) & M_TIMERVALUE)

#define S_MAREQTIMEREN    1
#define V_MAREQTIMEREN(x) ((x) << S_MAREQTIMEREN)
#define F_MAREQTIMEREN    V_MAREQTIMEREN(1U)

#define S_MARSPTIMEREN    0
#define V_MARSPTIMEREN(x) ((x) << S_MARSPTIMEREN)
#define F_MARSPTIMEREN    V_MARSPTIMEREN(1U)

#define A_PCIE_CORE_PCI_POWER_MANAGEMENT_CONTROL_1 0x59c8

#define S_TOAK    31
#define V_TOAK(x) ((x) << S_TOAK)
#define F_TOAK    V_TOAK(1U)

#define S_L1RS    23
#define V_L1RS(x) ((x) << S_L1RS)
#define F_L1RS    V_L1RS(1U)

#define S_L23S    22
#define V_L23S(x) ((x) << S_L23S)
#define F_L23S    V_L23S(1U)

#define S_AL1S    21
#define V_AL1S(x) ((x) << S_AL1S)
#define F_AL1S    V_AL1S(1U)

#define S_ALET    19
#define V_ALET(x) ((x) << S_ALET)
#define F_ALET    V_ALET(1U)

#define A_PCIE_HPRD 0x59c8

#define S_NPH_CREDITSAVAILVC0    19
#define M_NPH_CREDITSAVAILVC0    0x3U
#define V_NPH_CREDITSAVAILVC0(x) ((x) << S_NPH_CREDITSAVAILVC0)
#define G_NPH_CREDITSAVAILVC0(x) (((x) >> S_NPH_CREDITSAVAILVC0) & M_NPH_CREDITSAVAILVC0)

#define S_NPD_CREDITSAVAILVC0    17
#define M_NPD_CREDITSAVAILVC0    0x3U
#define V_NPD_CREDITSAVAILVC0(x) ((x) << S_NPD_CREDITSAVAILVC0)
#define G_NPD_CREDITSAVAILVC0(x) (((x) >> S_NPD_CREDITSAVAILVC0) & M_NPD_CREDITSAVAILVC0)

#define S_NPH_CREDITSAVAILVC1    15
#define M_NPH_CREDITSAVAILVC1    0x3U
#define V_NPH_CREDITSAVAILVC1(x) ((x) << S_NPH_CREDITSAVAILVC1)
#define G_NPH_CREDITSAVAILVC1(x) (((x) >> S_NPH_CREDITSAVAILVC1) & M_NPH_CREDITSAVAILVC1)

#define S_NPD_CREDITSAVAILVC1    13
#define M_NPD_CREDITSAVAILVC1    0x3U
#define V_NPD_CREDITSAVAILVC1(x) ((x) << S_NPD_CREDITSAVAILVC1)
#define G_NPD_CREDITSAVAILVC1(x) (((x) >> S_NPD_CREDITSAVAILVC1) & M_NPD_CREDITSAVAILVC1)

#define S_NPH_CREDITSREQUIRED    11
#define M_NPH_CREDITSREQUIRED    0x3U
#define V_NPH_CREDITSREQUIRED(x) ((x) << S_NPH_CREDITSREQUIRED)
#define G_NPH_CREDITSREQUIRED(x) (((x) >> S_NPH_CREDITSREQUIRED) & M_NPH_CREDITSREQUIRED)

#define S_NPD_CREDITSREQUIRED    9
#define M_NPD_CREDITSREQUIRED    0x3U
#define V_NPD_CREDITSREQUIRED(x) ((x) << S_NPD_CREDITSREQUIRED)
#define G_NPD_CREDITSREQUIRED(x) (((x) >> S_NPD_CREDITSREQUIRED) & M_NPD_CREDITSREQUIRED)

#define S_REQBURSTCOUNT    5
#define M_REQBURSTCOUNT    0xfU
#define V_REQBURSTCOUNT(x) ((x) << S_REQBURSTCOUNT)
#define G_REQBURSTCOUNT(x) (((x) >> S_REQBURSTCOUNT) & M_REQBURSTCOUNT)

#define S_REQBURSTFREQUENCY    1
#define M_REQBURSTFREQUENCY    0xfU
#define V_REQBURSTFREQUENCY(x) ((x) << S_REQBURSTFREQUENCY)
#define G_REQBURSTFREQUENCY(x) (((x) >> S_REQBURSTFREQUENCY) & M_REQBURSTFREQUENCY)

#define S_ENABLEVC1    0
#define V_ENABLEVC1(x) ((x) << S_ENABLEVC1)
#define F_ENABLEVC1    V_ENABLEVC1(1U)

#define A_PCIE_CORE_PCI_POWER_MANAGEMENT_CONTROL_2 0x59cc

#define S_CPM0    30
#define M_CPM0    0x3U
#define V_CPM0(x) ((x) << S_CPM0)
#define G_CPM0(x) (((x) >> S_CPM0) & M_CPM0)

#define S_CPM1    28
#define M_CPM1    0x3U
#define V_CPM1(x) ((x) << S_CPM1)
#define G_CPM1(x) (((x) >> S_CPM1) & M_CPM1)

#define S_CPM2    26
#define M_CPM2    0x3U
#define V_CPM2(x) ((x) << S_CPM2)
#define G_CPM2(x) (((x) >> S_CPM2) & M_CPM2)

#define S_CPM3    24
#define M_CPM3    0x3U
#define V_CPM3(x) ((x) << S_CPM3)
#define G_CPM3(x) (((x) >> S_CPM3) & M_CPM3)

#define S_CPM4    22
#define M_CPM4    0x3U
#define V_CPM4(x) ((x) << S_CPM4)
#define G_CPM4(x) (((x) >> S_CPM4) & M_CPM4)

#define S_CPM5    20
#define M_CPM5    0x3U
#define V_CPM5(x) ((x) << S_CPM5)
#define G_CPM5(x) (((x) >> S_CPM5) & M_CPM5)

#define S_CPM6    18
#define M_CPM6    0x3U
#define V_CPM6(x) ((x) << S_CPM6)
#define G_CPM6(x) (((x) >> S_CPM6) & M_CPM6)

#define S_CPM7    16
#define M_CPM7    0x3U
#define V_CPM7(x) ((x) << S_CPM7)
#define G_CPM7(x) (((x) >> S_CPM7) & M_CPM7)

#define S_OPM0    14
#define M_OPM0    0x3U
#define V_OPM0(x) ((x) << S_OPM0)
#define G_OPM0(x) (((x) >> S_OPM0) & M_OPM0)

#define S_OPM1    12
#define M_OPM1    0x3U
#define V_OPM1(x) ((x) << S_OPM1)
#define G_OPM1(x) (((x) >> S_OPM1) & M_OPM1)

#define S_OPM2    10
#define M_OPM2    0x3U
#define V_OPM2(x) ((x) << S_OPM2)
#define G_OPM2(x) (((x) >> S_OPM2) & M_OPM2)

#define S_OPM3    8
#define M_OPM3    0x3U
#define V_OPM3(x) ((x) << S_OPM3)
#define G_OPM3(x) (((x) >> S_OPM3) & M_OPM3)

#define S_OPM4    6
#define M_OPM4    0x3U
#define V_OPM4(x) ((x) << S_OPM4)
#define G_OPM4(x) (((x) >> S_OPM4) & M_OPM4)

#define S_OPM5    4
#define M_OPM5    0x3U
#define V_OPM5(x) ((x) << S_OPM5)
#define G_OPM5(x) (((x) >> S_OPM5) & M_OPM5)

#define S_OPM6    2
#define M_OPM6    0x3U
#define V_OPM6(x) ((x) << S_OPM6)
#define G_OPM6(x) (((x) >> S_OPM6) & M_OPM6)

#define S_OPM7    0
#define M_OPM7    0x3U
#define V_OPM7(x) ((x) << S_OPM7)
#define G_OPM7(x) (((x) >> S_OPM7) & M_OPM7)

#define A_PCIE_CORE_GENERAL_PURPOSE_CONTROL_1 0x59d0
#define A_PCIE_PERR_GROUP 0x59d0

#define S_MST_DATAPATHPERR    25
#define V_MST_DATAPATHPERR(x) ((x) << S_MST_DATAPATHPERR)
#define F_MST_DATAPATHPERR    V_MST_DATAPATHPERR(1U)

#define S_MST_RSPRDQPERR    24
#define V_MST_RSPRDQPERR(x) ((x) << S_MST_RSPRDQPERR)
#define F_MST_RSPRDQPERR    V_MST_RSPRDQPERR(1U)

#define S_IP_RXPERR    23
#define V_IP_RXPERR(x) ((x) << S_IP_RXPERR)
#define F_IP_RXPERR    V_IP_RXPERR(1U)

#define S_IP_BACKTXPERR    22
#define V_IP_BACKTXPERR(x) ((x) << S_IP_BACKTXPERR)
#define F_IP_BACKTXPERR    V_IP_BACKTXPERR(1U)

#define S_IP_FRONTTXPERR    21
#define V_IP_FRONTTXPERR(x) ((x) << S_IP_FRONTTXPERR)
#define F_IP_FRONTTXPERR    V_IP_FRONTTXPERR(1U)

#define S_TRGT1_FIDLKUPHDRPERR    20
#define V_TRGT1_FIDLKUPHDRPERR(x) ((x) << S_TRGT1_FIDLKUPHDRPERR)
#define F_TRGT1_FIDLKUPHDRPERR    V_TRGT1_FIDLKUPHDRPERR(1U)

#define S_TRGT1_ALINDDATAPERR    19
#define V_TRGT1_ALINDDATAPERR(x) ((x) << S_TRGT1_ALINDDATAPERR)
#define F_TRGT1_ALINDDATAPERR    V_TRGT1_ALINDDATAPERR(1U)

#define S_TRGT1_UNALINDATAPERR    18
#define V_TRGT1_UNALINDATAPERR(x) ((x) << S_TRGT1_UNALINDATAPERR)
#define F_TRGT1_UNALINDATAPERR    V_TRGT1_UNALINDATAPERR(1U)

#define S_TRGT1_REQDATAPERR    17
#define V_TRGT1_REQDATAPERR(x) ((x) << S_TRGT1_REQDATAPERR)
#define F_TRGT1_REQDATAPERR    V_TRGT1_REQDATAPERR(1U)

#define S_TRGT1_REQHDRPERR    16
#define V_TRGT1_REQHDRPERR(x) ((x) << S_TRGT1_REQHDRPERR)
#define F_TRGT1_REQHDRPERR    V_TRGT1_REQHDRPERR(1U)

#define S_IPRXDATA_VC1PERR    15
#define V_IPRXDATA_VC1PERR(x) ((x) << S_IPRXDATA_VC1PERR)
#define F_IPRXDATA_VC1PERR    V_IPRXDATA_VC1PERR(1U)

#define S_IPRXDATA_VC0PERR    14
#define V_IPRXDATA_VC0PERR(x) ((x) << S_IPRXDATA_VC0PERR)
#define F_IPRXDATA_VC0PERR    V_IPRXDATA_VC0PERR(1U)

#define S_IPRXHDR_VC1PERR    13
#define V_IPRXHDR_VC1PERR(x) ((x) << S_IPRXHDR_VC1PERR)
#define F_IPRXHDR_VC1PERR    V_IPRXHDR_VC1PERR(1U)

#define S_IPRXHDR_VC0PERR    12
#define V_IPRXHDR_VC0PERR(x) ((x) << S_IPRXHDR_VC0PERR)
#define F_IPRXHDR_VC0PERR    V_IPRXHDR_VC0PERR(1U)

#define S_MA_RSPDATAPERR    11
#define V_MA_RSPDATAPERR(x) ((x) << S_MA_RSPDATAPERR)
#define F_MA_RSPDATAPERR    V_MA_RSPDATAPERR(1U)

#define S_MA_CPLTAGQPERR    10
#define V_MA_CPLTAGQPERR(x) ((x) << S_MA_CPLTAGQPERR)
#define F_MA_CPLTAGQPERR    V_MA_CPLTAGQPERR(1U)

#define S_MA_REQTAGQPERR    9
#define V_MA_REQTAGQPERR(x) ((x) << S_MA_REQTAGQPERR)
#define F_MA_REQTAGQPERR    V_MA_REQTAGQPERR(1U)

#define S_PIOREQ_BAR2CTLPERR    8
#define V_PIOREQ_BAR2CTLPERR(x) ((x) << S_PIOREQ_BAR2CTLPERR)
#define F_PIOREQ_BAR2CTLPERR    V_PIOREQ_BAR2CTLPERR(1U)

#define S_PIOREQ_MEMCTLPERR    7
#define V_PIOREQ_MEMCTLPERR(x) ((x) << S_PIOREQ_MEMCTLPERR)
#define F_PIOREQ_MEMCTLPERR    V_PIOREQ_MEMCTLPERR(1U)

#define S_PIOREQ_PLMCTLPERR    6
#define V_PIOREQ_PLMCTLPERR(x) ((x) << S_PIOREQ_PLMCTLPERR)
#define F_PIOREQ_PLMCTLPERR    V_PIOREQ_PLMCTLPERR(1U)

#define S_PIOREQ_BAR2DATAPERR    5
#define V_PIOREQ_BAR2DATAPERR(x) ((x) << S_PIOREQ_BAR2DATAPERR)
#define F_PIOREQ_BAR2DATAPERR    V_PIOREQ_BAR2DATAPERR(1U)

#define S_PIOREQ_MEMDATAPERR    4
#define V_PIOREQ_MEMDATAPERR(x) ((x) << S_PIOREQ_MEMDATAPERR)
#define F_PIOREQ_MEMDATAPERR    V_PIOREQ_MEMDATAPERR(1U)

#define S_PIOREQ_PLMDATAPERR    3
#define V_PIOREQ_PLMDATAPERR(x) ((x) << S_PIOREQ_PLMDATAPERR)
#define F_PIOREQ_PLMDATAPERR    V_PIOREQ_PLMDATAPERR(1U)

#define S_PIOCPL_CTLPERR    2
#define V_PIOCPL_CTLPERR(x) ((x) << S_PIOCPL_CTLPERR)
#define F_PIOCPL_CTLPERR    V_PIOCPL_CTLPERR(1U)

#define S_PIOCPL_DATAPERR    1
#define V_PIOCPL_DATAPERR(x) ((x) << S_PIOCPL_DATAPERR)
#define F_PIOCPL_DATAPERR    V_PIOCPL_DATAPERR(1U)

#define S_PIOCPL_PLMRSPPERR    0
#define V_PIOCPL_PLMRSPPERR(x) ((x) << S_PIOCPL_PLMRSPPERR)
#define F_PIOCPL_PLMRSPPERR    V_PIOCPL_PLMRSPPERR(1U)

#define S_MA_RSPCTLPERR    26
#define V_MA_RSPCTLPERR(x) ((x) << S_MA_RSPCTLPERR)
#define F_MA_RSPCTLPERR    V_MA_RSPCTLPERR(1U)

#define S_T6_IPRXDATA_VC0PERR    15
#define V_T6_IPRXDATA_VC0PERR(x) ((x) << S_T6_IPRXDATA_VC0PERR)
#define F_T6_IPRXDATA_VC0PERR    V_T6_IPRXDATA_VC0PERR(1U)

#define S_T6_IPRXHDR_VC0PERR    14
#define V_T6_IPRXHDR_VC0PERR(x) ((x) << S_T6_IPRXHDR_VC0PERR)
#define F_T6_IPRXHDR_VC0PERR    V_T6_IPRXHDR_VC0PERR(1U)

#define S_PIOCPL_VDMTXCTLPERR    13
#define V_PIOCPL_VDMTXCTLPERR(x) ((x) << S_PIOCPL_VDMTXCTLPERR)
#define F_PIOCPL_VDMTXCTLPERR    V_PIOCPL_VDMTXCTLPERR(1U)

#define S_PIOCPL_VDMTXDATAPERR    12
#define V_PIOCPL_VDMTXDATAPERR(x) ((x) << S_PIOCPL_VDMTXDATAPERR)
#define F_PIOCPL_VDMTXDATAPERR    V_PIOCPL_VDMTXDATAPERR(1U)

#define S_TGT1_MEM_PERR    28
#define V_TGT1_MEM_PERR(x) ((x) << S_TGT1_MEM_PERR)
#define F_TGT1_MEM_PERR    V_TGT1_MEM_PERR(1U)

#define S_TGT2_MEM_PERR    27
#define V_TGT2_MEM_PERR(x) ((x) << S_TGT2_MEM_PERR)
#define F_TGT2_MEM_PERR    V_TGT2_MEM_PERR(1U)

#define A_PCIE_CORE_GENERAL_PURPOSE_CONTROL_2 0x59d4
#define A_PCIE_RSP_ERR_INT_LOG_EN 0x59d4

#define S_CPLSTATUSINTEN    12
#define V_CPLSTATUSINTEN(x) ((x) << S_CPLSTATUSINTEN)
#define F_CPLSTATUSINTEN    V_CPLSTATUSINTEN(1U)

#define S_REQTIMEOUTINTEN    11
#define V_REQTIMEOUTINTEN(x) ((x) << S_REQTIMEOUTINTEN)
#define F_REQTIMEOUTINTEN    V_REQTIMEOUTINTEN(1U)

#define S_DISABLEDINTEN    10
#define V_DISABLEDINTEN(x) ((x) << S_DISABLEDINTEN)
#define F_DISABLEDINTEN    V_DISABLEDINTEN(1U)

#define S_RSPDROPFLRINTEN    9
#define V_RSPDROPFLRINTEN(x) ((x) << S_RSPDROPFLRINTEN)
#define F_RSPDROPFLRINTEN    V_RSPDROPFLRINTEN(1U)

#define S_REQUNDERFLRINTEN    8
#define V_REQUNDERFLRINTEN(x) ((x) << S_REQUNDERFLRINTEN)
#define F_REQUNDERFLRINTEN    V_REQUNDERFLRINTEN(1U)

#define S_CPLSTATUSLOGEN    4
#define V_CPLSTATUSLOGEN(x) ((x) << S_CPLSTATUSLOGEN)
#define F_CPLSTATUSLOGEN    V_CPLSTATUSLOGEN(1U)

#define S_TIMEOUTLOGEN    3
#define V_TIMEOUTLOGEN(x) ((x) << S_TIMEOUTLOGEN)
#define F_TIMEOUTLOGEN    V_TIMEOUTLOGEN(1U)

#define S_DISABLEDLOGEN    2
#define V_DISABLEDLOGEN(x) ((x) << S_DISABLEDLOGEN)
#define F_DISABLEDLOGEN    V_DISABLEDLOGEN(1U)

#define S_RSPDROPFLRLOGEN    1
#define V_RSPDROPFLRLOGEN(x) ((x) << S_RSPDROPFLRLOGEN)
#define F_RSPDROPFLRLOGEN    V_RSPDROPFLRLOGEN(1U)

#define S_REQUNDERFLRLOGEN    0
#define V_REQUNDERFLRLOGEN(x) ((x) << S_REQUNDERFLRLOGEN)
#define F_REQUNDERFLRLOGEN    V_REQUNDERFLRLOGEN(1U)

#define A_PCIE_RSP_ERR_LOG1 0x59d8

#define S_REQTAG    25
#define M_REQTAG    0x7fU
#define V_REQTAG(x) ((x) << S_REQTAG)
#define G_REQTAG(x) (((x) >> S_REQTAG) & M_REQTAG)

#define S_CID    22
#define M_CID    0x7U
#define V_CID(x) ((x) << S_CID)
#define G_CID(x) (((x) >> S_CID) & M_CID)

#define S_CHNUM    19
#define M_CHNUM    0x7U
#define V_CHNUM(x) ((x) << S_CHNUM)
#define G_CHNUM(x) (((x) >> S_CHNUM) & M_CHNUM)

#define S_BYTELEN    6
#define M_BYTELEN    0x1fffU
#define V_BYTELEN(x) ((x) << S_BYTELEN)
#define G_BYTELEN(x) (((x) >> S_BYTELEN) & M_BYTELEN)

#define S_REASON    3
#define M_REASON    0x7U
#define V_REASON(x) ((x) << S_REASON)
#define G_REASON(x) (((x) >> S_REASON) & M_REASON)

#define S_CPLSTATUS    0
#define M_CPLSTATUS    0x7U
#define V_CPLSTATUS(x) ((x) << S_CPLSTATUS)
#define G_CPLSTATUS(x) (((x) >> S_CPLSTATUS) & M_CPLSTATUS)

#define A_PCIE_RSP_ERR_LOG2 0x59dc

#define S_LOGVALID    31
#define V_LOGVALID(x) ((x) << S_LOGVALID)
#define F_LOGVALID    V_LOGVALID(1U)

#define S_ADDR10B    8
#define M_ADDR10B    0x3ffU
#define V_ADDR10B(x) ((x) << S_ADDR10B)
#define G_ADDR10B(x) (((x) >> S_ADDR10B) & M_ADDR10B)

#define S_REQVFID    0
#define M_REQVFID    0xffU
#define V_REQVFID(x) ((x) << S_REQVFID)
#define G_REQVFID(x) (((x) >> S_REQVFID) & M_REQVFID)

#define S_T6_ADDR10B    9
#define M_T6_ADDR10B    0x3ffU
#define V_T6_ADDR10B(x) ((x) << S_T6_ADDR10B)
#define G_T6_ADDR10B(x) (((x) >> S_T6_ADDR10B) & M_T6_ADDR10B)

#define S_T6_REQVFID    0
#define M_T6_REQVFID    0x1ffU
#define V_T6_REQVFID(x) ((x) << S_T6_REQVFID)
#define G_T6_REQVFID(x) (((x) >> S_T6_REQVFID) & M_T6_REQVFID)

#define S_LOGADDR10B    9
#define M_LOGADDR10B    0x3ffU
#define V_LOGADDR10B(x) ((x) << S_LOGADDR10B)
#define G_LOGADDR10B(x) (((x) >> S_LOGADDR10B) & M_LOGADDR10B)

#define S_LOGREQVFID    0
#define M_LOGREQVFID    0x1ffU
#define V_LOGREQVFID(x) ((x) << S_LOGREQVFID)
#define G_LOGREQVFID(x) (((x) >> S_LOGREQVFID) & M_LOGREQVFID)

#define A_PCIE_CHANGESET 0x59fc
#define A_PCIE_REVISION 0x5a00
#define A_PCIE_PDEBUG_INDEX 0x5a04

#define S_PDEBUGSELH    16
#define M_PDEBUGSELH    0x3fU
#define V_PDEBUGSELH(x) ((x) << S_PDEBUGSELH)
#define G_PDEBUGSELH(x) (((x) >> S_PDEBUGSELH) & M_PDEBUGSELH)

#define S_PDEBUGSELL    0
#define M_PDEBUGSELL    0x3fU
#define V_PDEBUGSELL(x) ((x) << S_PDEBUGSELL)
#define G_PDEBUGSELL(x) (((x) >> S_PDEBUGSELL) & M_PDEBUGSELL)

#define S_T6_PDEBUGSELH    16
#define M_T6_PDEBUGSELH    0x7fU
#define V_T6_PDEBUGSELH(x) ((x) << S_T6_PDEBUGSELH)
#define G_T6_PDEBUGSELH(x) (((x) >> S_T6_PDEBUGSELH) & M_T6_PDEBUGSELH)

#define S_T6_PDEBUGSELL    0
#define M_T6_PDEBUGSELL    0x7fU
#define V_T6_PDEBUGSELL(x) ((x) << S_T6_PDEBUGSELL)
#define G_T6_PDEBUGSELL(x) (((x) >> S_T6_PDEBUGSELL) & M_T6_PDEBUGSELL)

#define S_T7_1_PDEBUGSELH    16
#define M_T7_1_PDEBUGSELH    0xffU
#define V_T7_1_PDEBUGSELH(x) ((x) << S_T7_1_PDEBUGSELH)
#define G_T7_1_PDEBUGSELH(x) (((x) >> S_T7_1_PDEBUGSELH) & M_T7_1_PDEBUGSELH)

#define S_T7_1_PDEBUGSELL    0
#define M_T7_1_PDEBUGSELL    0xffU
#define V_T7_1_PDEBUGSELL(x) ((x) << S_T7_1_PDEBUGSELL)
#define G_T7_1_PDEBUGSELL(x) (((x) >> S_T7_1_PDEBUGSELL) & M_T7_1_PDEBUGSELL)

#define A_PCIE_PDEBUG_DATA_HIGH 0x5a08
#define A_PCIE_PDEBUG_DATA_LOW 0x5a0c
#define A_PCIE_CDEBUG_INDEX 0x5a10

#define S_CDEBUGSELH    16
#define M_CDEBUGSELH    0xffU
#define V_CDEBUGSELH(x) ((x) << S_CDEBUGSELH)
#define G_CDEBUGSELH(x) (((x) >> S_CDEBUGSELH) & M_CDEBUGSELH)

#define S_CDEBUGSELL    0
#define M_CDEBUGSELL    0xffU
#define V_CDEBUGSELL(x) ((x) << S_CDEBUGSELL)
#define G_CDEBUGSELL(x) (((x) >> S_CDEBUGSELL) & M_CDEBUGSELL)

#define A_PCIE_CDEBUG_DATA_HIGH 0x5a14
#define A_PCIE_CDEBUG_DATA_LOW 0x5a18
#define A_PCIE_DMAW_SOP_CNT 0x5a1c

#define S_CH3    24
#define M_CH3    0xffU
#define V_CH3(x) ((x) << S_CH3)
#define G_CH3(x) (((x) >> S_CH3) & M_CH3)

#define S_CH2    16
#define M_CH2    0xffU
#define V_CH2(x) ((x) << S_CH2)
#define G_CH2(x) (((x) >> S_CH2) & M_CH2)

#define S_CH1    8
#define M_CH1    0xffU
#define V_CH1(x) ((x) << S_CH1)
#define G_CH1(x) (((x) >> S_CH1) & M_CH1)

#define S_CH0    0
#define M_CH0    0xffU
#define V_CH0(x) ((x) << S_CH0)
#define G_CH0(x) (((x) >> S_CH0) & M_CH0)

#define A_PCIE_DMAW_EOP_CNT 0x5a20
#define A_PCIE_DMAR_REQ_CNT 0x5a24
#define A_PCIE_DMAR_RSP_SOP_CNT 0x5a28
#define A_PCIE_DMAR_RSP_EOP_CNT 0x5a2c
#define A_PCIE_DMAR_RSP_ERR_CNT 0x5a30
#define A_PCIE_DMAI_CNT 0x5a34
#define A_PCIE_CMDW_CNT 0x5a38

#define S_CH1_EOP    24
#define M_CH1_EOP    0xffU
#define V_CH1_EOP(x) ((x) << S_CH1_EOP)
#define G_CH1_EOP(x) (((x) >> S_CH1_EOP) & M_CH1_EOP)

#define S_CH1_SOP    16
#define M_CH1_SOP    0xffU
#define V_CH1_SOP(x) ((x) << S_CH1_SOP)
#define G_CH1_SOP(x) (((x) >> S_CH1_SOP) & M_CH1_SOP)

#define S_CH0_EOP    8
#define M_CH0_EOP    0xffU
#define V_CH0_EOP(x) ((x) << S_CH0_EOP)
#define G_CH0_EOP(x) (((x) >> S_CH0_EOP) & M_CH0_EOP)

#define S_CH0_SOP    0
#define M_CH0_SOP    0xffU
#define V_CH0_SOP(x) ((x) << S_CH0_SOP)
#define G_CH0_SOP(x) (((x) >> S_CH0_SOP) & M_CH0_SOP)

#define A_PCIE_CMDR_REQ_CNT 0x5a3c
#define A_PCIE_CMDR_RSP_CNT 0x5a40
#define A_PCIE_CMDR_RSP_ERR_CNT 0x5a44
#define A_PCIE_HMA_REQ_CNT 0x5a48

#define S_CH0_READ    16
#define M_CH0_READ    0xffU
#define V_CH0_READ(x) ((x) << S_CH0_READ)
#define G_CH0_READ(x) (((x) >> S_CH0_READ) & M_CH0_READ)

#define S_CH0_WEOP    8
#define M_CH0_WEOP    0xffU
#define V_CH0_WEOP(x) ((x) << S_CH0_WEOP)
#define G_CH0_WEOP(x) (((x) >> S_CH0_WEOP) & M_CH0_WEOP)

#define S_CH0_WSOP    0
#define M_CH0_WSOP    0xffU
#define V_CH0_WSOP(x) ((x) << S_CH0_WSOP)
#define G_CH0_WSOP(x) (((x) >> S_CH0_WSOP) & M_CH0_WSOP)

#define A_PCIE_HMA_RSP_CNT 0x5a4c
#define A_PCIE_DMA10_RSP_FREE 0x5a50

#define S_CH1_RSP_FREE    16
#define M_CH1_RSP_FREE    0xfffU
#define V_CH1_RSP_FREE(x) ((x) << S_CH1_RSP_FREE)
#define G_CH1_RSP_FREE(x) (((x) >> S_CH1_RSP_FREE) & M_CH1_RSP_FREE)

#define S_CH0_RSP_FREE    0
#define M_CH0_RSP_FREE    0xfffU
#define V_CH0_RSP_FREE(x) ((x) << S_CH0_RSP_FREE)
#define G_CH0_RSP_FREE(x) (((x) >> S_CH0_RSP_FREE) & M_CH0_RSP_FREE)

#define A_PCIE_DMA32_RSP_FREE 0x5a54

#define S_CH3_RSP_FREE    16
#define M_CH3_RSP_FREE    0xfffU
#define V_CH3_RSP_FREE(x) ((x) << S_CH3_RSP_FREE)
#define G_CH3_RSP_FREE(x) (((x) >> S_CH3_RSP_FREE) & M_CH3_RSP_FREE)

#define S_CH2_RSP_FREE    0
#define M_CH2_RSP_FREE    0xfffU
#define V_CH2_RSP_FREE(x) ((x) << S_CH2_RSP_FREE)
#define G_CH2_RSP_FREE(x) (((x) >> S_CH2_RSP_FREE) & M_CH2_RSP_FREE)

#define A_PCIE_CMD_RSP_FREE 0x5a58

#define S_CMD_CH1_RSP_FREE    16
#define M_CMD_CH1_RSP_FREE    0x7fU
#define V_CMD_CH1_RSP_FREE(x) ((x) << S_CMD_CH1_RSP_FREE)
#define G_CMD_CH1_RSP_FREE(x) (((x) >> S_CMD_CH1_RSP_FREE) & M_CMD_CH1_RSP_FREE)

#define S_CMD_CH0_RSP_FREE    0
#define M_CMD_CH0_RSP_FREE    0x7fU
#define V_CMD_CH0_RSP_FREE(x) ((x) << S_CMD_CH0_RSP_FREE)
#define G_CMD_CH0_RSP_FREE(x) (((x) >> S_CMD_CH0_RSP_FREE) & M_CMD_CH0_RSP_FREE)

#define A_PCIE_HMA_RSP_FREE 0x5a5c
#define A_PCIE_BUS_MST_STAT_0 0x5a60
#define A_PCIE_BUS_MST_STAT_1 0x5a64
#define A_PCIE_BUS_MST_STAT_2 0x5a68
#define A_PCIE_BUS_MST_STAT_3 0x5a6c
#define A_PCIE_BUS_MST_STAT_4 0x5a70

#define S_BUSMST_135_128    0
#define M_BUSMST_135_128    0xffU
#define V_BUSMST_135_128(x) ((x) << S_BUSMST_135_128)
#define G_BUSMST_135_128(x) (((x) >> S_BUSMST_135_128) & M_BUSMST_135_128)

#define A_PCIE_BUS_MST_STAT_5 0x5a74
#define A_PCIE_BUS_MST_STAT_6 0x5a78
#define A_PCIE_BUS_MST_STAT_7 0x5a7c
#define A_PCIE_RSP_ERR_STAT_0 0x5a80
#define A_PCIE_RSP_ERR_STAT_1 0x5a84
#define A_PCIE_RSP_ERR_STAT_2 0x5a88
#define A_PCIE_RSP_ERR_STAT_3 0x5a8c
#define A_PCIE_RSP_ERR_STAT_4 0x5a90

#define S_RSPERR_135_128    0
#define M_RSPERR_135_128    0xffU
#define V_RSPERR_135_128(x) ((x) << S_RSPERR_135_128)
#define G_RSPERR_135_128(x) (((x) >> S_RSPERR_135_128) & M_RSPERR_135_128)

#define A_PCIE_RSP_ERR_STAT_5 0x5a94
#define A_PCIE_DBI_TIMEOUT_CTL 0x5a94

#define S_DBI_TIMER    0
#define M_DBI_TIMER    0xffffU
#define V_DBI_TIMER(x) ((x) << S_DBI_TIMER)
#define G_DBI_TIMER(x) (((x) >> S_DBI_TIMER) & M_DBI_TIMER)

#define A_PCIE_RSP_ERR_STAT_6 0x5a98
#define A_PCIE_DBI_TIMEOUT_STATUS0 0x5a98
#define A_PCIE_RSP_ERR_STAT_7 0x5a9c
#define A_PCIE_DBI_TIMEOUT_STATUS1 0x5a9c

#define S_SOURCE    16
#define M_SOURCE    0x3U
#define V_SOURCE(x) ((x) << S_SOURCE)
#define G_SOURCE(x) (((x) >> S_SOURCE) & M_SOURCE)

#define S_DBI_WRITE    12
#define M_DBI_WRITE    0xfU
#define V_DBI_WRITE(x) ((x) << S_DBI_WRITE)
#define G_DBI_WRITE(x) (((x) >> S_DBI_WRITE) & M_DBI_WRITE)

#define S_DBI_CS2    11
#define V_DBI_CS2(x) ((x) << S_DBI_CS2)
#define F_DBI_CS2    V_DBI_CS2(1U)

#define S_DBI_PF    8
#define M_DBI_PF    0x7U
#define V_DBI_PF(x) ((x) << S_DBI_PF)
#define G_DBI_PF(x) (((x) >> S_DBI_PF) & M_DBI_PF)

#define S_PL_TOVFVLD    7
#define V_PL_TOVFVLD(x) ((x) << S_PL_TOVFVLD)
#define F_PL_TOVFVLD    V_PL_TOVFVLD(1U)

#define S_PL_TOVF    0
#define M_PL_TOVF    0x7fU
#define V_PL_TOVF(x) ((x) << S_PL_TOVF)
#define G_PL_TOVF(x) (((x) >> S_PL_TOVF) & M_PL_TOVF)

#define S_T6_SOURCE    17
#define M_T6_SOURCE    0x3U
#define V_T6_SOURCE(x) ((x) << S_T6_SOURCE)
#define G_T6_SOURCE(x) (((x) >> S_T6_SOURCE) & M_T6_SOURCE)

#define S_T6_DBI_WRITE    13
#define M_T6_DBI_WRITE    0xfU
#define V_T6_DBI_WRITE(x) ((x) << S_T6_DBI_WRITE)
#define G_T6_DBI_WRITE(x) (((x) >> S_T6_DBI_WRITE) & M_T6_DBI_WRITE)

#define S_T6_DBI_CS2    12
#define V_T6_DBI_CS2(x) ((x) << S_T6_DBI_CS2)
#define F_T6_DBI_CS2    V_T6_DBI_CS2(1U)

#define S_T6_DBI_PF    9
#define M_T6_DBI_PF    0x7U
#define V_T6_DBI_PF(x) ((x) << S_T6_DBI_PF)
#define G_T6_DBI_PF(x) (((x) >> S_T6_DBI_PF) & M_T6_DBI_PF)

#define S_T6_PL_TOVFVLD    8
#define V_T6_PL_TOVFVLD(x) ((x) << S_T6_PL_TOVFVLD)
#define F_T6_PL_TOVFVLD    V_T6_PL_TOVFVLD(1U)

#define S_T6_PL_TOVF    0
#define M_T6_PL_TOVF    0xffU
#define V_T6_PL_TOVF(x) ((x) << S_T6_PL_TOVF)
#define G_T6_PL_TOVF(x) (((x) >> S_T6_PL_TOVF) & M_T6_PL_TOVF)

#define A_PCIE_MSI_EN_0 0x5aa0
#define A_PCIE_MSI_EN_1 0x5aa4
#define A_PCIE_MSI_EN_2 0x5aa8
#define A_PCIE_MSI_EN_3 0x5aac
#define A_PCIE_MSI_EN_4 0x5ab0
#define A_PCIE_MSI_EN_5 0x5ab4
#define A_PCIE_MSI_EN_6 0x5ab8
#define A_PCIE_MSI_EN_7 0x5abc
#define A_PCIE_MSIX_EN_0 0x5ac0
#define A_PCIE_MSIX_EN_1 0x5ac4
#define A_PCIE_MSIX_EN_2 0x5ac8
#define A_PCIE_MSIX_EN_3 0x5acc
#define A_PCIE_MSIX_EN_4 0x5ad0
#define A_PCIE_MSIX_EN_5 0x5ad4
#define A_PCIE_MSIX_EN_6 0x5ad8
#define A_PCIE_MSIX_EN_7 0x5adc
#define A_PCIE_DMA_BUF_CTL 0x5ae0

#define S_BUFRDCNT    18
#define M_BUFRDCNT    0x3fffU
#define V_BUFRDCNT(x) ((x) << S_BUFRDCNT)
#define G_BUFRDCNT(x) (((x) >> S_BUFRDCNT) & M_BUFRDCNT)

#define S_BUFWRCNT    9
#define M_BUFWRCNT    0x1ffU
#define V_BUFWRCNT(x) ((x) << S_BUFWRCNT)
#define G_BUFWRCNT(x) (((x) >> S_BUFWRCNT) & M_BUFWRCNT)

#define S_MAXBUFWRREQ    0
#define M_MAXBUFWRREQ    0x1ffU
#define V_MAXBUFWRREQ(x) ((x) << S_MAXBUFWRREQ)
#define G_MAXBUFWRREQ(x) (((x) >> S_MAXBUFWRREQ) & M_MAXBUFWRREQ)

#define A_PCIE_PB_CTL 0x5b94

#define S_PB_SEL    16
#define M_PB_SEL    0xffU
#define V_PB_SEL(x) ((x) << S_PB_SEL)
#define G_PB_SEL(x) (((x) >> S_PB_SEL) & M_PB_SEL)

#define S_PB_SELREG    8
#define M_PB_SELREG    0xffU
#define V_PB_SELREG(x) ((x) << S_PB_SELREG)
#define G_PB_SELREG(x) (((x) >> S_PB_SELREG) & M_PB_SELREG)

#define S_PB_FUNC    0
#define M_PB_FUNC    0x7U
#define V_PB_FUNC(x) ((x) << S_PB_FUNC)
#define G_PB_FUNC(x) (((x) >> S_PB_FUNC) & M_PB_FUNC)

#define A_PCIE_PB_DATA 0x5b98
#define A_PCIE_CUR_LINK 0x5b9c

#define S_CFGINITCOEFFDONESEEN    22
#define V_CFGINITCOEFFDONESEEN(x) ((x) << S_CFGINITCOEFFDONESEEN)
#define F_CFGINITCOEFFDONESEEN    V_CFGINITCOEFFDONESEEN(1U)

#define S_CFGINITCOEFFDONE    21
#define V_CFGINITCOEFFDONE(x) ((x) << S_CFGINITCOEFFDONE)
#define F_CFGINITCOEFFDONE    V_CFGINITCOEFFDONE(1U)

#define S_XMLH_LINK_UP    20
#define V_XMLH_LINK_UP(x) ((x) << S_XMLH_LINK_UP)
#define F_XMLH_LINK_UP    V_XMLH_LINK_UP(1U)

#define S_PM_LINKST_IN_L0S    19
#define V_PM_LINKST_IN_L0S(x) ((x) << S_PM_LINKST_IN_L0S)
#define F_PM_LINKST_IN_L0S    V_PM_LINKST_IN_L0S(1U)

#define S_PM_LINKST_IN_L1    18
#define V_PM_LINKST_IN_L1(x) ((x) << S_PM_LINKST_IN_L1)
#define F_PM_LINKST_IN_L1    V_PM_LINKST_IN_L1(1U)

#define S_PM_LINKST_IN_L2    17
#define V_PM_LINKST_IN_L2(x) ((x) << S_PM_LINKST_IN_L2)
#define F_PM_LINKST_IN_L2    V_PM_LINKST_IN_L2(1U)

#define S_PM_LINKST_L2_EXIT    16
#define V_PM_LINKST_L2_EXIT(x) ((x) << S_PM_LINKST_L2_EXIT)
#define F_PM_LINKST_L2_EXIT    V_PM_LINKST_L2_EXIT(1U)

#define S_XMLH_IN_RL0S    15
#define V_XMLH_IN_RL0S(x) ((x) << S_XMLH_IN_RL0S)
#define F_XMLH_IN_RL0S    V_XMLH_IN_RL0S(1U)

#define S_XMLH_LTSSM_STATE_RCVRY_EQ    14
#define V_XMLH_LTSSM_STATE_RCVRY_EQ(x) ((x) << S_XMLH_LTSSM_STATE_RCVRY_EQ)
#define F_XMLH_LTSSM_STATE_RCVRY_EQ    V_XMLH_LTSSM_STATE_RCVRY_EQ(1U)

#define S_NEGOTIATEDWIDTH    8
#define M_NEGOTIATEDWIDTH    0x3fU
#define V_NEGOTIATEDWIDTH(x) ((x) << S_NEGOTIATEDWIDTH)
#define G_NEGOTIATEDWIDTH(x) (((x) >> S_NEGOTIATEDWIDTH) & M_NEGOTIATEDWIDTH)

#define S_ACTIVELANES    0
#define M_ACTIVELANES    0xffU
#define V_ACTIVELANES(x) ((x) << S_ACTIVELANES)
#define G_ACTIVELANES(x) (((x) >> S_ACTIVELANES) & M_ACTIVELANES)

#define A_PCIE_PHY_REQRXPWR 0x5ba0

#define S_LNH_RXSTATEDONE    31
#define V_LNH_RXSTATEDONE(x) ((x) << S_LNH_RXSTATEDONE)
#define F_LNH_RXSTATEDONE    V_LNH_RXSTATEDONE(1U)

#define S_LNH_RXSTATEREQ    30
#define V_LNH_RXSTATEREQ(x) ((x) << S_LNH_RXSTATEREQ)
#define F_LNH_RXSTATEREQ    V_LNH_RXSTATEREQ(1U)

#define S_LNH_RXPWRSTATE    28
#define M_LNH_RXPWRSTATE    0x3U
#define V_LNH_RXPWRSTATE(x) ((x) << S_LNH_RXPWRSTATE)
#define G_LNH_RXPWRSTATE(x) (((x) >> S_LNH_RXPWRSTATE) & M_LNH_RXPWRSTATE)

#define S_LNG_RXSTATEDONE    27
#define V_LNG_RXSTATEDONE(x) ((x) << S_LNG_RXSTATEDONE)
#define F_LNG_RXSTATEDONE    V_LNG_RXSTATEDONE(1U)

#define S_LNG_RXSTATEREQ    26
#define V_LNG_RXSTATEREQ(x) ((x) << S_LNG_RXSTATEREQ)
#define F_LNG_RXSTATEREQ    V_LNG_RXSTATEREQ(1U)

#define S_LNG_RXPWRSTATE    24
#define M_LNG_RXPWRSTATE    0x3U
#define V_LNG_RXPWRSTATE(x) ((x) << S_LNG_RXPWRSTATE)
#define G_LNG_RXPWRSTATE(x) (((x) >> S_LNG_RXPWRSTATE) & M_LNG_RXPWRSTATE)

#define S_LNF_RXSTATEDONE    23
#define V_LNF_RXSTATEDONE(x) ((x) << S_LNF_RXSTATEDONE)
#define F_LNF_RXSTATEDONE    V_LNF_RXSTATEDONE(1U)

#define S_LNF_RXSTATEREQ    22
#define V_LNF_RXSTATEREQ(x) ((x) << S_LNF_RXSTATEREQ)
#define F_LNF_RXSTATEREQ    V_LNF_RXSTATEREQ(1U)

#define S_LNF_RXPWRSTATE    20
#define M_LNF_RXPWRSTATE    0x3U
#define V_LNF_RXPWRSTATE(x) ((x) << S_LNF_RXPWRSTATE)
#define G_LNF_RXPWRSTATE(x) (((x) >> S_LNF_RXPWRSTATE) & M_LNF_RXPWRSTATE)

#define S_LNE_RXSTATEDONE    19
#define V_LNE_RXSTATEDONE(x) ((x) << S_LNE_RXSTATEDONE)
#define F_LNE_RXSTATEDONE    V_LNE_RXSTATEDONE(1U)

#define S_LNE_RXSTATEREQ    18
#define V_LNE_RXSTATEREQ(x) ((x) << S_LNE_RXSTATEREQ)
#define F_LNE_RXSTATEREQ    V_LNE_RXSTATEREQ(1U)

#define S_LNE_RXPWRSTATE    16
#define M_LNE_RXPWRSTATE    0x3U
#define V_LNE_RXPWRSTATE(x) ((x) << S_LNE_RXPWRSTATE)
#define G_LNE_RXPWRSTATE(x) (((x) >> S_LNE_RXPWRSTATE) & M_LNE_RXPWRSTATE)

#define S_LND_RXSTATEDONE    15
#define V_LND_RXSTATEDONE(x) ((x) << S_LND_RXSTATEDONE)
#define F_LND_RXSTATEDONE    V_LND_RXSTATEDONE(1U)

#define S_LND_RXSTATEREQ    14
#define V_LND_RXSTATEREQ(x) ((x) << S_LND_RXSTATEREQ)
#define F_LND_RXSTATEREQ    V_LND_RXSTATEREQ(1U)

#define S_LND_RXPWRSTATE    12
#define M_LND_RXPWRSTATE    0x3U
#define V_LND_RXPWRSTATE(x) ((x) << S_LND_RXPWRSTATE)
#define G_LND_RXPWRSTATE(x) (((x) >> S_LND_RXPWRSTATE) & M_LND_RXPWRSTATE)

#define S_LNC_RXSTATEDONE    11
#define V_LNC_RXSTATEDONE(x) ((x) << S_LNC_RXSTATEDONE)
#define F_LNC_RXSTATEDONE    V_LNC_RXSTATEDONE(1U)

#define S_LNC_RXSTATEREQ    10
#define V_LNC_RXSTATEREQ(x) ((x) << S_LNC_RXSTATEREQ)
#define F_LNC_RXSTATEREQ    V_LNC_RXSTATEREQ(1U)

#define S_LNC_RXPWRSTATE    8
#define M_LNC_RXPWRSTATE    0x3U
#define V_LNC_RXPWRSTATE(x) ((x) << S_LNC_RXPWRSTATE)
#define G_LNC_RXPWRSTATE(x) (((x) >> S_LNC_RXPWRSTATE) & M_LNC_RXPWRSTATE)

#define S_LNB_RXSTATEDONE    7
#define V_LNB_RXSTATEDONE(x) ((x) << S_LNB_RXSTATEDONE)
#define F_LNB_RXSTATEDONE    V_LNB_RXSTATEDONE(1U)

#define S_LNB_RXSTATEREQ    6
#define V_LNB_RXSTATEREQ(x) ((x) << S_LNB_RXSTATEREQ)
#define F_LNB_RXSTATEREQ    V_LNB_RXSTATEREQ(1U)

#define S_LNB_RXPWRSTATE    4
#define M_LNB_RXPWRSTATE    0x3U
#define V_LNB_RXPWRSTATE(x) ((x) << S_LNB_RXPWRSTATE)
#define G_LNB_RXPWRSTATE(x) (((x) >> S_LNB_RXPWRSTATE) & M_LNB_RXPWRSTATE)

#define S_LNA_RXSTATEDONE    3
#define V_LNA_RXSTATEDONE(x) ((x) << S_LNA_RXSTATEDONE)
#define F_LNA_RXSTATEDONE    V_LNA_RXSTATEDONE(1U)

#define S_LNA_RXSTATEREQ    2
#define V_LNA_RXSTATEREQ(x) ((x) << S_LNA_RXSTATEREQ)
#define F_LNA_RXSTATEREQ    V_LNA_RXSTATEREQ(1U)

#define S_LNA_RXPWRSTATE    0
#define M_LNA_RXPWRSTATE    0x3U
#define V_LNA_RXPWRSTATE(x) ((x) << S_LNA_RXPWRSTATE)
#define G_LNA_RXPWRSTATE(x) (((x) >> S_LNA_RXPWRSTATE) & M_LNA_RXPWRSTATE)

#define S_REQ_LNH_RXSTATEDONE    31
#define V_REQ_LNH_RXSTATEDONE(x) ((x) << S_REQ_LNH_RXSTATEDONE)
#define F_REQ_LNH_RXSTATEDONE    V_REQ_LNH_RXSTATEDONE(1U)

#define S_REQ_LNH_RXSTATEREQ    30
#define V_REQ_LNH_RXSTATEREQ(x) ((x) << S_REQ_LNH_RXSTATEREQ)
#define F_REQ_LNH_RXSTATEREQ    V_REQ_LNH_RXSTATEREQ(1U)

#define S_REQ_LNH_RXPWRSTATE    28
#define M_REQ_LNH_RXPWRSTATE    0x3U
#define V_REQ_LNH_RXPWRSTATE(x) ((x) << S_REQ_LNH_RXPWRSTATE)
#define G_REQ_LNH_RXPWRSTATE(x) (((x) >> S_REQ_LNH_RXPWRSTATE) & M_REQ_LNH_RXPWRSTATE)

#define S_REQ_LNG_RXSTATEDONE    27
#define V_REQ_LNG_RXSTATEDONE(x) ((x) << S_REQ_LNG_RXSTATEDONE)
#define F_REQ_LNG_RXSTATEDONE    V_REQ_LNG_RXSTATEDONE(1U)

#define S_REQ_LNG_RXSTATEREQ    26
#define V_REQ_LNG_RXSTATEREQ(x) ((x) << S_REQ_LNG_RXSTATEREQ)
#define F_REQ_LNG_RXSTATEREQ    V_REQ_LNG_RXSTATEREQ(1U)

#define S_REQ_LNG_RXPWRSTATE    24
#define M_REQ_LNG_RXPWRSTATE    0x3U
#define V_REQ_LNG_RXPWRSTATE(x) ((x) << S_REQ_LNG_RXPWRSTATE)
#define G_REQ_LNG_RXPWRSTATE(x) (((x) >> S_REQ_LNG_RXPWRSTATE) & M_REQ_LNG_RXPWRSTATE)

#define S_REQ_LNF_RXSTATEDONE    23
#define V_REQ_LNF_RXSTATEDONE(x) ((x) << S_REQ_LNF_RXSTATEDONE)
#define F_REQ_LNF_RXSTATEDONE    V_REQ_LNF_RXSTATEDONE(1U)

#define S_REQ_LNF_RXSTATEREQ    22
#define V_REQ_LNF_RXSTATEREQ(x) ((x) << S_REQ_LNF_RXSTATEREQ)
#define F_REQ_LNF_RXSTATEREQ    V_REQ_LNF_RXSTATEREQ(1U)

#define S_REQ_LNF_RXPWRSTATE    20
#define M_REQ_LNF_RXPWRSTATE    0x3U
#define V_REQ_LNF_RXPWRSTATE(x) ((x) << S_REQ_LNF_RXPWRSTATE)
#define G_REQ_LNF_RXPWRSTATE(x) (((x) >> S_REQ_LNF_RXPWRSTATE) & M_REQ_LNF_RXPWRSTATE)

#define S_REQ_LNE_RXSTATEDONE    19
#define V_REQ_LNE_RXSTATEDONE(x) ((x) << S_REQ_LNE_RXSTATEDONE)
#define F_REQ_LNE_RXSTATEDONE    V_REQ_LNE_RXSTATEDONE(1U)

#define S_REQ_LNE_RXSTATEREQ    18
#define V_REQ_LNE_RXSTATEREQ(x) ((x) << S_REQ_LNE_RXSTATEREQ)
#define F_REQ_LNE_RXSTATEREQ    V_REQ_LNE_RXSTATEREQ(1U)

#define S_REQ_LNE_RXPWRSTATE    16
#define M_REQ_LNE_RXPWRSTATE    0x3U
#define V_REQ_LNE_RXPWRSTATE(x) ((x) << S_REQ_LNE_RXPWRSTATE)
#define G_REQ_LNE_RXPWRSTATE(x) (((x) >> S_REQ_LNE_RXPWRSTATE) & M_REQ_LNE_RXPWRSTATE)

#define S_REQ_LND_RXSTATEDONE    15
#define V_REQ_LND_RXSTATEDONE(x) ((x) << S_REQ_LND_RXSTATEDONE)
#define F_REQ_LND_RXSTATEDONE    V_REQ_LND_RXSTATEDONE(1U)

#define S_REQ_LND_RXSTATEREQ    14
#define V_REQ_LND_RXSTATEREQ(x) ((x) << S_REQ_LND_RXSTATEREQ)
#define F_REQ_LND_RXSTATEREQ    V_REQ_LND_RXSTATEREQ(1U)

#define S_REQ_LND_RXPWRSTATE    12
#define M_REQ_LND_RXPWRSTATE    0x3U
#define V_REQ_LND_RXPWRSTATE(x) ((x) << S_REQ_LND_RXPWRSTATE)
#define G_REQ_LND_RXPWRSTATE(x) (((x) >> S_REQ_LND_RXPWRSTATE) & M_REQ_LND_RXPWRSTATE)

#define S_REQ_LNC_RXSTATEDONE    11
#define V_REQ_LNC_RXSTATEDONE(x) ((x) << S_REQ_LNC_RXSTATEDONE)
#define F_REQ_LNC_RXSTATEDONE    V_REQ_LNC_RXSTATEDONE(1U)

#define S_REQ_LNC_RXSTATEREQ    10
#define V_REQ_LNC_RXSTATEREQ(x) ((x) << S_REQ_LNC_RXSTATEREQ)
#define F_REQ_LNC_RXSTATEREQ    V_REQ_LNC_RXSTATEREQ(1U)

#define S_REQ_LNC_RXPWRSTATE    8
#define M_REQ_LNC_RXPWRSTATE    0x3U
#define V_REQ_LNC_RXPWRSTATE(x) ((x) << S_REQ_LNC_RXPWRSTATE)
#define G_REQ_LNC_RXPWRSTATE(x) (((x) >> S_REQ_LNC_RXPWRSTATE) & M_REQ_LNC_RXPWRSTATE)

#define S_REQ_LNB_RXSTATEDONE    7
#define V_REQ_LNB_RXSTATEDONE(x) ((x) << S_REQ_LNB_RXSTATEDONE)
#define F_REQ_LNB_RXSTATEDONE    V_REQ_LNB_RXSTATEDONE(1U)

#define S_REQ_LNB_RXSTATEREQ    6
#define V_REQ_LNB_RXSTATEREQ(x) ((x) << S_REQ_LNB_RXSTATEREQ)
#define F_REQ_LNB_RXSTATEREQ    V_REQ_LNB_RXSTATEREQ(1U)

#define S_REQ_LNB_RXPWRSTATE    4
#define M_REQ_LNB_RXPWRSTATE    0x3U
#define V_REQ_LNB_RXPWRSTATE(x) ((x) << S_REQ_LNB_RXPWRSTATE)
#define G_REQ_LNB_RXPWRSTATE(x) (((x) >> S_REQ_LNB_RXPWRSTATE) & M_REQ_LNB_RXPWRSTATE)

#define S_REQ_LNA_RXSTATEDONE    3
#define V_REQ_LNA_RXSTATEDONE(x) ((x) << S_REQ_LNA_RXSTATEDONE)
#define F_REQ_LNA_RXSTATEDONE    V_REQ_LNA_RXSTATEDONE(1U)

#define S_REQ_LNA_RXSTATEREQ    2
#define V_REQ_LNA_RXSTATEREQ(x) ((x) << S_REQ_LNA_RXSTATEREQ)
#define F_REQ_LNA_RXSTATEREQ    V_REQ_LNA_RXSTATEREQ(1U)

#define S_REQ_LNA_RXPWRSTATE    0
#define M_REQ_LNA_RXPWRSTATE    0x3U
#define V_REQ_LNA_RXPWRSTATE(x) ((x) << S_REQ_LNA_RXPWRSTATE)
#define G_REQ_LNA_RXPWRSTATE(x) (((x) >> S_REQ_LNA_RXPWRSTATE) & M_REQ_LNA_RXPWRSTATE)

#define A_PCIE_PHY_CURRXPWR 0x5ba4

#define S_T5_LNH_RXPWRSTATE    28
#define M_T5_LNH_RXPWRSTATE    0x7U
#define V_T5_LNH_RXPWRSTATE(x) ((x) << S_T5_LNH_RXPWRSTATE)
#define G_T5_LNH_RXPWRSTATE(x) (((x) >> S_T5_LNH_RXPWRSTATE) & M_T5_LNH_RXPWRSTATE)

#define S_T5_LNG_RXPWRSTATE    24
#define M_T5_LNG_RXPWRSTATE    0x7U
#define V_T5_LNG_RXPWRSTATE(x) ((x) << S_T5_LNG_RXPWRSTATE)
#define G_T5_LNG_RXPWRSTATE(x) (((x) >> S_T5_LNG_RXPWRSTATE) & M_T5_LNG_RXPWRSTATE)

#define S_T5_LNF_RXPWRSTATE    20
#define M_T5_LNF_RXPWRSTATE    0x7U
#define V_T5_LNF_RXPWRSTATE(x) ((x) << S_T5_LNF_RXPWRSTATE)
#define G_T5_LNF_RXPWRSTATE(x) (((x) >> S_T5_LNF_RXPWRSTATE) & M_T5_LNF_RXPWRSTATE)

#define S_T5_LNE_RXPWRSTATE    16
#define M_T5_LNE_RXPWRSTATE    0x7U
#define V_T5_LNE_RXPWRSTATE(x) ((x) << S_T5_LNE_RXPWRSTATE)
#define G_T5_LNE_RXPWRSTATE(x) (((x) >> S_T5_LNE_RXPWRSTATE) & M_T5_LNE_RXPWRSTATE)

#define S_T5_LND_RXPWRSTATE    12
#define M_T5_LND_RXPWRSTATE    0x7U
#define V_T5_LND_RXPWRSTATE(x) ((x) << S_T5_LND_RXPWRSTATE)
#define G_T5_LND_RXPWRSTATE(x) (((x) >> S_T5_LND_RXPWRSTATE) & M_T5_LND_RXPWRSTATE)

#define S_T5_LNC_RXPWRSTATE    8
#define M_T5_LNC_RXPWRSTATE    0x7U
#define V_T5_LNC_RXPWRSTATE(x) ((x) << S_T5_LNC_RXPWRSTATE)
#define G_T5_LNC_RXPWRSTATE(x) (((x) >> S_T5_LNC_RXPWRSTATE) & M_T5_LNC_RXPWRSTATE)

#define S_T5_LNB_RXPWRSTATE    4
#define M_T5_LNB_RXPWRSTATE    0x7U
#define V_T5_LNB_RXPWRSTATE(x) ((x) << S_T5_LNB_RXPWRSTATE)
#define G_T5_LNB_RXPWRSTATE(x) (((x) >> S_T5_LNB_RXPWRSTATE) & M_T5_LNB_RXPWRSTATE)

#define S_T5_LNA_RXPWRSTATE    0
#define M_T5_LNA_RXPWRSTATE    0x7U
#define V_T5_LNA_RXPWRSTATE(x) ((x) << S_T5_LNA_RXPWRSTATE)
#define G_T5_LNA_RXPWRSTATE(x) (((x) >> S_T5_LNA_RXPWRSTATE) & M_T5_LNA_RXPWRSTATE)

#define S_CUR_LNH_RXPWRSTATE    28
#define M_CUR_LNH_RXPWRSTATE    0x7U
#define V_CUR_LNH_RXPWRSTATE(x) ((x) << S_CUR_LNH_RXPWRSTATE)
#define G_CUR_LNH_RXPWRSTATE(x) (((x) >> S_CUR_LNH_RXPWRSTATE) & M_CUR_LNH_RXPWRSTATE)

#define S_CUR_LNG_RXPWRSTATE    24
#define M_CUR_LNG_RXPWRSTATE    0x7U
#define V_CUR_LNG_RXPWRSTATE(x) ((x) << S_CUR_LNG_RXPWRSTATE)
#define G_CUR_LNG_RXPWRSTATE(x) (((x) >> S_CUR_LNG_RXPWRSTATE) & M_CUR_LNG_RXPWRSTATE)

#define S_CUR_LNF_RXPWRSTATE    20
#define M_CUR_LNF_RXPWRSTATE    0x7U
#define V_CUR_LNF_RXPWRSTATE(x) ((x) << S_CUR_LNF_RXPWRSTATE)
#define G_CUR_LNF_RXPWRSTATE(x) (((x) >> S_CUR_LNF_RXPWRSTATE) & M_CUR_LNF_RXPWRSTATE)

#define S_CUR_LNE_RXPWRSTATE    16
#define M_CUR_LNE_RXPWRSTATE    0x7U
#define V_CUR_LNE_RXPWRSTATE(x) ((x) << S_CUR_LNE_RXPWRSTATE)
#define G_CUR_LNE_RXPWRSTATE(x) (((x) >> S_CUR_LNE_RXPWRSTATE) & M_CUR_LNE_RXPWRSTATE)

#define S_CUR_LND_RXPWRSTATE    12
#define M_CUR_LND_RXPWRSTATE    0x7U
#define V_CUR_LND_RXPWRSTATE(x) ((x) << S_CUR_LND_RXPWRSTATE)
#define G_CUR_LND_RXPWRSTATE(x) (((x) >> S_CUR_LND_RXPWRSTATE) & M_CUR_LND_RXPWRSTATE)

#define S_CUR_LNC_RXPWRSTATE    8
#define M_CUR_LNC_RXPWRSTATE    0x7U
#define V_CUR_LNC_RXPWRSTATE(x) ((x) << S_CUR_LNC_RXPWRSTATE)
#define G_CUR_LNC_RXPWRSTATE(x) (((x) >> S_CUR_LNC_RXPWRSTATE) & M_CUR_LNC_RXPWRSTATE)

#define S_CUR_LNB_RXPWRSTATE    4
#define M_CUR_LNB_RXPWRSTATE    0x7U
#define V_CUR_LNB_RXPWRSTATE(x) ((x) << S_CUR_LNB_RXPWRSTATE)
#define G_CUR_LNB_RXPWRSTATE(x) (((x) >> S_CUR_LNB_RXPWRSTATE) & M_CUR_LNB_RXPWRSTATE)

#define S_CUR_LNA_RXPWRSTATE    0
#define M_CUR_LNA_RXPWRSTATE    0x7U
#define V_CUR_LNA_RXPWRSTATE(x) ((x) << S_CUR_LNA_RXPWRSTATE)
#define G_CUR_LNA_RXPWRSTATE(x) (((x) >> S_CUR_LNA_RXPWRSTATE) & M_CUR_LNA_RXPWRSTATE)

#define A_PCIE_PHY_GEN3_AE0 0x5ba8

#define S_LND_STAT    28
#define M_LND_STAT    0x7U
#define V_LND_STAT(x) ((x) << S_LND_STAT)
#define G_LND_STAT(x) (((x) >> S_LND_STAT) & M_LND_STAT)

#define S_LND_CMD    24
#define M_LND_CMD    0x7U
#define V_LND_CMD(x) ((x) << S_LND_CMD)
#define G_LND_CMD(x) (((x) >> S_LND_CMD) & M_LND_CMD)

#define S_LNC_STAT    20
#define M_LNC_STAT    0x7U
#define V_LNC_STAT(x) ((x) << S_LNC_STAT)
#define G_LNC_STAT(x) (((x) >> S_LNC_STAT) & M_LNC_STAT)

#define S_LNC_CMD    16
#define M_LNC_CMD    0x7U
#define V_LNC_CMD(x) ((x) << S_LNC_CMD)
#define G_LNC_CMD(x) (((x) >> S_LNC_CMD) & M_LNC_CMD)

#define S_LNB_STAT    12
#define M_LNB_STAT    0x7U
#define V_LNB_STAT(x) ((x) << S_LNB_STAT)
#define G_LNB_STAT(x) (((x) >> S_LNB_STAT) & M_LNB_STAT)

#define S_LNB_CMD    8
#define M_LNB_CMD    0x7U
#define V_LNB_CMD(x) ((x) << S_LNB_CMD)
#define G_LNB_CMD(x) (((x) >> S_LNB_CMD) & M_LNB_CMD)

#define S_LNA_STAT    4
#define M_LNA_STAT    0x7U
#define V_LNA_STAT(x) ((x) << S_LNA_STAT)
#define G_LNA_STAT(x) (((x) >> S_LNA_STAT) & M_LNA_STAT)

#define S_LNA_CMD    0
#define M_LNA_CMD    0x7U
#define V_LNA_CMD(x) ((x) << S_LNA_CMD)
#define G_LNA_CMD(x) (((x) >> S_LNA_CMD) & M_LNA_CMD)

#define A_PCIE_PHY_GEN3_AE1 0x5bac

#define S_LNH_STAT    28
#define M_LNH_STAT    0x7U
#define V_LNH_STAT(x) ((x) << S_LNH_STAT)
#define G_LNH_STAT(x) (((x) >> S_LNH_STAT) & M_LNH_STAT)

#define S_LNH_CMD    24
#define M_LNH_CMD    0x7U
#define V_LNH_CMD(x) ((x) << S_LNH_CMD)
#define G_LNH_CMD(x) (((x) >> S_LNH_CMD) & M_LNH_CMD)

#define S_LNG_STAT    20
#define M_LNG_STAT    0x7U
#define V_LNG_STAT(x) ((x) << S_LNG_STAT)
#define G_LNG_STAT(x) (((x) >> S_LNG_STAT) & M_LNG_STAT)

#define S_LNG_CMD    16
#define M_LNG_CMD    0x7U
#define V_LNG_CMD(x) ((x) << S_LNG_CMD)
#define G_LNG_CMD(x) (((x) >> S_LNG_CMD) & M_LNG_CMD)

#define S_LNF_STAT    12
#define M_LNF_STAT    0x7U
#define V_LNF_STAT(x) ((x) << S_LNF_STAT)
#define G_LNF_STAT(x) (((x) >> S_LNF_STAT) & M_LNF_STAT)

#define S_LNF_CMD    8
#define M_LNF_CMD    0x7U
#define V_LNF_CMD(x) ((x) << S_LNF_CMD)
#define G_LNF_CMD(x) (((x) >> S_LNF_CMD) & M_LNF_CMD)

#define S_LNE_STAT    4
#define M_LNE_STAT    0x7U
#define V_LNE_STAT(x) ((x) << S_LNE_STAT)
#define G_LNE_STAT(x) (((x) >> S_LNE_STAT) & M_LNE_STAT)

#define S_LNE_CMD    0
#define M_LNE_CMD    0x7U
#define V_LNE_CMD(x) ((x) << S_LNE_CMD)
#define G_LNE_CMD(x) (((x) >> S_LNE_CMD) & M_LNE_CMD)

#define A_PCIE_PHY_FS_LF0 0x5bb0

#define S_LANE1LF    24
#define M_LANE1LF    0x3fU
#define V_LANE1LF(x) ((x) << S_LANE1LF)
#define G_LANE1LF(x) (((x) >> S_LANE1LF) & M_LANE1LF)

#define S_LANE1FS    16
#define M_LANE1FS    0x3fU
#define V_LANE1FS(x) ((x) << S_LANE1FS)
#define G_LANE1FS(x) (((x) >> S_LANE1FS) & M_LANE1FS)

#define S_LANE0LF    8
#define M_LANE0LF    0x3fU
#define V_LANE0LF(x) ((x) << S_LANE0LF)
#define G_LANE0LF(x) (((x) >> S_LANE0LF) & M_LANE0LF)

#define S_LANE0FS    0
#define M_LANE0FS    0x3fU
#define V_LANE0FS(x) ((x) << S_LANE0FS)
#define G_LANE0FS(x) (((x) >> S_LANE0FS) & M_LANE0FS)

#define A_PCIE_PHY_FS_LF1 0x5bb4

#define S_LANE3LF    24
#define M_LANE3LF    0x3fU
#define V_LANE3LF(x) ((x) << S_LANE3LF)
#define G_LANE3LF(x) (((x) >> S_LANE3LF) & M_LANE3LF)

#define S_LANE3FS    16
#define M_LANE3FS    0x3fU
#define V_LANE3FS(x) ((x) << S_LANE3FS)
#define G_LANE3FS(x) (((x) >> S_LANE3FS) & M_LANE3FS)

#define S_LANE2LF    8
#define M_LANE2LF    0x3fU
#define V_LANE2LF(x) ((x) << S_LANE2LF)
#define G_LANE2LF(x) (((x) >> S_LANE2LF) & M_LANE2LF)

#define S_LANE2FS    0
#define M_LANE2FS    0x3fU
#define V_LANE2FS(x) ((x) << S_LANE2FS)
#define G_LANE2FS(x) (((x) >> S_LANE2FS) & M_LANE2FS)

#define A_PCIE_PHY_FS_LF2 0x5bb8

#define S_LANE5LF    24
#define M_LANE5LF    0x3fU
#define V_LANE5LF(x) ((x) << S_LANE5LF)
#define G_LANE5LF(x) (((x) >> S_LANE5LF) & M_LANE5LF)

#define S_LANE5FS    16
#define M_LANE5FS    0x3fU
#define V_LANE5FS(x) ((x) << S_LANE5FS)
#define G_LANE5FS(x) (((x) >> S_LANE5FS) & M_LANE5FS)

#define S_LANE4LF    8
#define M_LANE4LF    0x3fU
#define V_LANE4LF(x) ((x) << S_LANE4LF)
#define G_LANE4LF(x) (((x) >> S_LANE4LF) & M_LANE4LF)

#define S_LANE4FS    0
#define M_LANE4FS    0x3fU
#define V_LANE4FS(x) ((x) << S_LANE4FS)
#define G_LANE4FS(x) (((x) >> S_LANE4FS) & M_LANE4FS)

#define A_PCIE_PHY_FS_LF3 0x5bbc

#define S_LANE7LF    24
#define M_LANE7LF    0x3fU
#define V_LANE7LF(x) ((x) << S_LANE7LF)
#define G_LANE7LF(x) (((x) >> S_LANE7LF) & M_LANE7LF)

#define S_LANE7FS    16
#define M_LANE7FS    0x3fU
#define V_LANE7FS(x) ((x) << S_LANE7FS)
#define G_LANE7FS(x) (((x) >> S_LANE7FS) & M_LANE7FS)

#define S_LANE6LF    8
#define M_LANE6LF    0x3fU
#define V_LANE6LF(x) ((x) << S_LANE6LF)
#define G_LANE6LF(x) (((x) >> S_LANE6LF) & M_LANE6LF)

#define S_LANE6FS    0
#define M_LANE6FS    0x3fU
#define V_LANE6FS(x) ((x) << S_LANE6FS)
#define G_LANE6FS(x) (((x) >> S_LANE6FS) & M_LANE6FS)

#define A_PCIE_PHY_PRESET_REQ 0x5bc0

#define S_COEFFDONE    16
#define V_COEFFDONE(x) ((x) << S_COEFFDONE)
#define F_COEFFDONE    V_COEFFDONE(1U)

#define S_COEFFLANE    8
#define M_COEFFLANE    0x7U
#define V_COEFFLANE(x) ((x) << S_COEFFLANE)
#define G_COEFFLANE(x) (((x) >> S_COEFFLANE) & M_COEFFLANE)

#define S_COEFFSTART    0
#define V_COEFFSTART(x) ((x) << S_COEFFSTART)
#define F_COEFFSTART    V_COEFFSTART(1U)

#define S_T6_COEFFLANE    8
#define M_T6_COEFFLANE    0xfU
#define V_T6_COEFFLANE(x) ((x) << S_T6_COEFFLANE)
#define G_T6_COEFFLANE(x) (((x) >> S_T6_COEFFLANE) & M_T6_COEFFLANE)

#define A_PCIE_PHY_PRESET_COEFF 0x5bc4

#define S_COEFF    0
#define M_COEFF    0x3ffffU
#define V_COEFF(x) ((x) << S_COEFF)
#define G_COEFF(x) (((x) >> S_COEFF) & M_COEFF)

#define A_PCIE_PHY_INDIR_REQ 0x5bf0

#define S_PHYENABLE    31
#define V_PHYENABLE(x) ((x) << S_PHYENABLE)
#define F_PHYENABLE    V_PHYENABLE(1U)

#define S_PCIE_PHY_REGADDR    0
#define M_PCIE_PHY_REGADDR    0xffffU
#define V_PCIE_PHY_REGADDR(x) ((x) << S_PCIE_PHY_REGADDR)
#define G_PCIE_PHY_REGADDR(x) (((x) >> S_PCIE_PHY_REGADDR) & M_PCIE_PHY_REGADDR)

#define A_PCIE_PHY_INDIR_DATA 0x5bf4
#define A_PCIE_STATIC_SPARE1 0x5bf8
#define A_PCIE_STATIC_SPARE2 0x5bfc

#define S_X8_SW_EN    30
#define V_X8_SW_EN(x) ((x) << S_X8_SW_EN)
#define F_X8_SW_EN    V_X8_SW_EN(1U)

#define S_SWITCHCFG    28
#define M_SWITCHCFG    0x3U
#define V_SWITCHCFG(x) ((x) << S_SWITCHCFG)
#define G_SWITCHCFG(x) (((x) >> S_SWITCHCFG) & M_SWITCHCFG)

#define S_STATIC_SPARE2    0
#define M_STATIC_SPARE2    0xfffffffU
#define V_STATIC_SPARE2(x) ((x) << S_STATIC_SPARE2)
#define G_STATIC_SPARE2(x) (((x) >> S_STATIC_SPARE2) & M_STATIC_SPARE2)

#define A_PCIE_KDOORBELL_GTS_PF_BASE_LEN 0x5c10

#define S_KDB_PF_LEN    24
#define M_KDB_PF_LEN    0x1fU
#define V_KDB_PF_LEN(x) ((x) << S_KDB_PF_LEN)
#define G_KDB_PF_LEN(x) (((x) >> S_KDB_PF_LEN) & M_KDB_PF_LEN)

#define S_KDB_PF_BASEADDR    0
#define M_KDB_PF_BASEADDR    0xfffffU
#define V_KDB_PF_BASEADDR(x) ((x) << S_KDB_PF_BASEADDR)
#define G_KDB_PF_BASEADDR(x) (((x) >> S_KDB_PF_BASEADDR) & M_KDB_PF_BASEADDR)

#define A_PCIE_KDOORBELL_GTS_VF_BASE_LEN 0x5c14

#define S_KDB_VF_LEN    24
#define M_KDB_VF_LEN    0x1fU
#define V_KDB_VF_LEN(x) ((x) << S_KDB_VF_LEN)
#define G_KDB_VF_LEN(x) (((x) >> S_KDB_VF_LEN) & M_KDB_VF_LEN)

#define S_KDB_VF_BASEADDR    0
#define M_KDB_VF_BASEADDR    0xfffffU
#define V_KDB_VF_BASEADDR(x) ((x) << S_KDB_VF_BASEADDR)
#define G_KDB_VF_BASEADDR(x) (((x) >> S_KDB_VF_BASEADDR) & M_KDB_VF_BASEADDR)

#define A_PCIE_KDOORBELL_GTS_VF_OFFSET 0x5c18

#define S_KDB_VF_MODOFST    0
#define M_KDB_VF_MODOFST    0xfffU
#define V_KDB_VF_MODOFST(x) ((x) << S_KDB_VF_MODOFST)
#define G_KDB_VF_MODOFST(x) (((x) >> S_KDB_VF_MODOFST) & M_KDB_VF_MODOFST)

#define A_PCIE_PHY_REQRXPWR1 0x5c1c

#define S_REQ_LNP_RXSTATEDONE    31
#define V_REQ_LNP_RXSTATEDONE(x) ((x) << S_REQ_LNP_RXSTATEDONE)
#define F_REQ_LNP_RXSTATEDONE    V_REQ_LNP_RXSTATEDONE(1U)

#define S_REQ_LNP_RXSTATEREQ    30
#define V_REQ_LNP_RXSTATEREQ(x) ((x) << S_REQ_LNP_RXSTATEREQ)
#define F_REQ_LNP_RXSTATEREQ    V_REQ_LNP_RXSTATEREQ(1U)

#define S_REQ_LNP_RXPWRSTATE    28
#define M_REQ_LNP_RXPWRSTATE    0x3U
#define V_REQ_LNP_RXPWRSTATE(x) ((x) << S_REQ_LNP_RXPWRSTATE)
#define G_REQ_LNP_RXPWRSTATE(x) (((x) >> S_REQ_LNP_RXPWRSTATE) & M_REQ_LNP_RXPWRSTATE)

#define S_REQ_LNO_RXSTATEDONE    27
#define V_REQ_LNO_RXSTATEDONE(x) ((x) << S_REQ_LNO_RXSTATEDONE)
#define F_REQ_LNO_RXSTATEDONE    V_REQ_LNO_RXSTATEDONE(1U)

#define S_REQ_LNO_RXSTATEREQ    26
#define V_REQ_LNO_RXSTATEREQ(x) ((x) << S_REQ_LNO_RXSTATEREQ)
#define F_REQ_LNO_RXSTATEREQ    V_REQ_LNO_RXSTATEREQ(1U)

#define S_REQ_LNO_RXPWRSTATE    24
#define M_REQ_LNO_RXPWRSTATE    0x3U
#define V_REQ_LNO_RXPWRSTATE(x) ((x) << S_REQ_LNO_RXPWRSTATE)
#define G_REQ_LNO_RXPWRSTATE(x) (((x) >> S_REQ_LNO_RXPWRSTATE) & M_REQ_LNO_RXPWRSTATE)

#define S_REQ_LNN_RXSTATEDONE    23
#define V_REQ_LNN_RXSTATEDONE(x) ((x) << S_REQ_LNN_RXSTATEDONE)
#define F_REQ_LNN_RXSTATEDONE    V_REQ_LNN_RXSTATEDONE(1U)

#define S_REQ_LNN_RXSTATEREQ    22
#define V_REQ_LNN_RXSTATEREQ(x) ((x) << S_REQ_LNN_RXSTATEREQ)
#define F_REQ_LNN_RXSTATEREQ    V_REQ_LNN_RXSTATEREQ(1U)

#define S_REQ_LNN_RXPWRSTATE    20
#define M_REQ_LNN_RXPWRSTATE    0x3U
#define V_REQ_LNN_RXPWRSTATE(x) ((x) << S_REQ_LNN_RXPWRSTATE)
#define G_REQ_LNN_RXPWRSTATE(x) (((x) >> S_REQ_LNN_RXPWRSTATE) & M_REQ_LNN_RXPWRSTATE)

#define S_REQ_LNM_RXSTATEDONE    19
#define V_REQ_LNM_RXSTATEDONE(x) ((x) << S_REQ_LNM_RXSTATEDONE)
#define F_REQ_LNM_RXSTATEDONE    V_REQ_LNM_RXSTATEDONE(1U)

#define S_REQ_LNM_RXSTATEREQ    18
#define V_REQ_LNM_RXSTATEREQ(x) ((x) << S_REQ_LNM_RXSTATEREQ)
#define F_REQ_LNM_RXSTATEREQ    V_REQ_LNM_RXSTATEREQ(1U)

#define S_REQ_LNM_RXPWRSTATE    16
#define M_REQ_LNM_RXPWRSTATE    0x3U
#define V_REQ_LNM_RXPWRSTATE(x) ((x) << S_REQ_LNM_RXPWRSTATE)
#define G_REQ_LNM_RXPWRSTATE(x) (((x) >> S_REQ_LNM_RXPWRSTATE) & M_REQ_LNM_RXPWRSTATE)

#define S_REQ_LNL_RXSTATEDONE    15
#define V_REQ_LNL_RXSTATEDONE(x) ((x) << S_REQ_LNL_RXSTATEDONE)
#define F_REQ_LNL_RXSTATEDONE    V_REQ_LNL_RXSTATEDONE(1U)

#define S_REQ_LNL_RXSTATEREQ    14
#define V_REQ_LNL_RXSTATEREQ(x) ((x) << S_REQ_LNL_RXSTATEREQ)
#define F_REQ_LNL_RXSTATEREQ    V_REQ_LNL_RXSTATEREQ(1U)

#define S_REQ_LNL_RXPWRSTATE    12
#define M_REQ_LNL_RXPWRSTATE    0x3U
#define V_REQ_LNL_RXPWRSTATE(x) ((x) << S_REQ_LNL_RXPWRSTATE)
#define G_REQ_LNL_RXPWRSTATE(x) (((x) >> S_REQ_LNL_RXPWRSTATE) & M_REQ_LNL_RXPWRSTATE)

#define S_REQ_LNK_RXSTATEDONE    11
#define V_REQ_LNK_RXSTATEDONE(x) ((x) << S_REQ_LNK_RXSTATEDONE)
#define F_REQ_LNK_RXSTATEDONE    V_REQ_LNK_RXSTATEDONE(1U)

#define S_REQ_LNK_RXSTATEREQ    10
#define V_REQ_LNK_RXSTATEREQ(x) ((x) << S_REQ_LNK_RXSTATEREQ)
#define F_REQ_LNK_RXSTATEREQ    V_REQ_LNK_RXSTATEREQ(1U)

#define S_REQ_LNK_RXPWRSTATE    8
#define M_REQ_LNK_RXPWRSTATE    0x3U
#define V_REQ_LNK_RXPWRSTATE(x) ((x) << S_REQ_LNK_RXPWRSTATE)
#define G_REQ_LNK_RXPWRSTATE(x) (((x) >> S_REQ_LNK_RXPWRSTATE) & M_REQ_LNK_RXPWRSTATE)

#define S_REQ_LNJ_RXSTATEDONE    7
#define V_REQ_LNJ_RXSTATEDONE(x) ((x) << S_REQ_LNJ_RXSTATEDONE)
#define F_REQ_LNJ_RXSTATEDONE    V_REQ_LNJ_RXSTATEDONE(1U)

#define S_REQ_LNJ_RXSTATEREQ    6
#define V_REQ_LNJ_RXSTATEREQ(x) ((x) << S_REQ_LNJ_RXSTATEREQ)
#define F_REQ_LNJ_RXSTATEREQ    V_REQ_LNJ_RXSTATEREQ(1U)

#define S_REQ_LNJ_RXPWRSTATE    4
#define M_REQ_LNJ_RXPWRSTATE    0x3U
#define V_REQ_LNJ_RXPWRSTATE(x) ((x) << S_REQ_LNJ_RXPWRSTATE)
#define G_REQ_LNJ_RXPWRSTATE(x) (((x) >> S_REQ_LNJ_RXPWRSTATE) & M_REQ_LNJ_RXPWRSTATE)

#define S_REQ_LNI_RXSTATEDONE    3
#define V_REQ_LNI_RXSTATEDONE(x) ((x) << S_REQ_LNI_RXSTATEDONE)
#define F_REQ_LNI_RXSTATEDONE    V_REQ_LNI_RXSTATEDONE(1U)

#define S_REQ_LNI_RXSTATEREQ    2
#define V_REQ_LNI_RXSTATEREQ(x) ((x) << S_REQ_LNI_RXSTATEREQ)
#define F_REQ_LNI_RXSTATEREQ    V_REQ_LNI_RXSTATEREQ(1U)

#define S_REQ_LNI_RXPWRSTATE    0
#define M_REQ_LNI_RXPWRSTATE    0x3U
#define V_REQ_LNI_RXPWRSTATE(x) ((x) << S_REQ_LNI_RXPWRSTATE)
#define G_REQ_LNI_RXPWRSTATE(x) (((x) >> S_REQ_LNI_RXPWRSTATE) & M_REQ_LNI_RXPWRSTATE)

#define A_PCIE_PHY_CURRXPWR1 0x5c20

#define S_CUR_LNP_RXPWRSTATE    28
#define M_CUR_LNP_RXPWRSTATE    0x7U
#define V_CUR_LNP_RXPWRSTATE(x) ((x) << S_CUR_LNP_RXPWRSTATE)
#define G_CUR_LNP_RXPWRSTATE(x) (((x) >> S_CUR_LNP_RXPWRSTATE) & M_CUR_LNP_RXPWRSTATE)

#define S_CUR_LNO_RXPWRSTATE    24
#define M_CUR_LNO_RXPWRSTATE    0x7U
#define V_CUR_LNO_RXPWRSTATE(x) ((x) << S_CUR_LNO_RXPWRSTATE)
#define G_CUR_LNO_RXPWRSTATE(x) (((x) >> S_CUR_LNO_RXPWRSTATE) & M_CUR_LNO_RXPWRSTATE)

#define S_CUR_LNN_RXPWRSTATE    20
#define M_CUR_LNN_RXPWRSTATE    0x7U
#define V_CUR_LNN_RXPWRSTATE(x) ((x) << S_CUR_LNN_RXPWRSTATE)
#define G_CUR_LNN_RXPWRSTATE(x) (((x) >> S_CUR_LNN_RXPWRSTATE) & M_CUR_LNN_RXPWRSTATE)

#define S_CUR_LNM_RXPWRSTATE    16
#define M_CUR_LNM_RXPWRSTATE    0x7U
#define V_CUR_LNM_RXPWRSTATE(x) ((x) << S_CUR_LNM_RXPWRSTATE)
#define G_CUR_LNM_RXPWRSTATE(x) (((x) >> S_CUR_LNM_RXPWRSTATE) & M_CUR_LNM_RXPWRSTATE)

#define S_CUR_LNL_RXPWRSTATE    12
#define M_CUR_LNL_RXPWRSTATE    0x7U
#define V_CUR_LNL_RXPWRSTATE(x) ((x) << S_CUR_LNL_RXPWRSTATE)
#define G_CUR_LNL_RXPWRSTATE(x) (((x) >> S_CUR_LNL_RXPWRSTATE) & M_CUR_LNL_RXPWRSTATE)

#define S_CUR_LNK_RXPWRSTATE    8
#define M_CUR_LNK_RXPWRSTATE    0x7U
#define V_CUR_LNK_RXPWRSTATE(x) ((x) << S_CUR_LNK_RXPWRSTATE)
#define G_CUR_LNK_RXPWRSTATE(x) (((x) >> S_CUR_LNK_RXPWRSTATE) & M_CUR_LNK_RXPWRSTATE)

#define S_CUR_LNJ_RXPWRSTATE    4
#define M_CUR_LNJ_RXPWRSTATE    0x7U
#define V_CUR_LNJ_RXPWRSTATE(x) ((x) << S_CUR_LNJ_RXPWRSTATE)
#define G_CUR_LNJ_RXPWRSTATE(x) (((x) >> S_CUR_LNJ_RXPWRSTATE) & M_CUR_LNJ_RXPWRSTATE)

#define S_CUR_LNI_RXPWRSTATE    0
#define M_CUR_LNI_RXPWRSTATE    0x7U
#define V_CUR_LNI_RXPWRSTATE(x) ((x) << S_CUR_LNI_RXPWRSTATE)
#define G_CUR_LNI_RXPWRSTATE(x) (((x) >> S_CUR_LNI_RXPWRSTATE) & M_CUR_LNI_RXPWRSTATE)

#define A_PCIE_PHY_GEN3_AE2 0x5c24

#define S_LNL_STAT    28
#define M_LNL_STAT    0x7U
#define V_LNL_STAT(x) ((x) << S_LNL_STAT)
#define G_LNL_STAT(x) (((x) >> S_LNL_STAT) & M_LNL_STAT)

#define S_LNL_CMD    24
#define M_LNL_CMD    0x7U
#define V_LNL_CMD(x) ((x) << S_LNL_CMD)
#define G_LNL_CMD(x) (((x) >> S_LNL_CMD) & M_LNL_CMD)

#define S_LNK_STAT    20
#define M_LNK_STAT    0x7U
#define V_LNK_STAT(x) ((x) << S_LNK_STAT)
#define G_LNK_STAT(x) (((x) >> S_LNK_STAT) & M_LNK_STAT)

#define S_LNK_CMD    16
#define M_LNK_CMD    0x7U
#define V_LNK_CMD(x) ((x) << S_LNK_CMD)
#define G_LNK_CMD(x) (((x) >> S_LNK_CMD) & M_LNK_CMD)

#define S_LNJ_STAT    12
#define M_LNJ_STAT    0x7U
#define V_LNJ_STAT(x) ((x) << S_LNJ_STAT)
#define G_LNJ_STAT(x) (((x) >> S_LNJ_STAT) & M_LNJ_STAT)

#define S_LNJ_CMD    8
#define M_LNJ_CMD    0x7U
#define V_LNJ_CMD(x) ((x) << S_LNJ_CMD)
#define G_LNJ_CMD(x) (((x) >> S_LNJ_CMD) & M_LNJ_CMD)

#define S_LNI_STAT    4
#define M_LNI_STAT    0x7U
#define V_LNI_STAT(x) ((x) << S_LNI_STAT)
#define G_LNI_STAT(x) (((x) >> S_LNI_STAT) & M_LNI_STAT)

#define S_LNI_CMD    0
#define M_LNI_CMD    0x7U
#define V_LNI_CMD(x) ((x) << S_LNI_CMD)
#define G_LNI_CMD(x) (((x) >> S_LNI_CMD) & M_LNI_CMD)

#define A_PCIE_PHY_GEN3_AE3 0x5c28

#define S_LNP_STAT    28
#define M_LNP_STAT    0x7U
#define V_LNP_STAT(x) ((x) << S_LNP_STAT)
#define G_LNP_STAT(x) (((x) >> S_LNP_STAT) & M_LNP_STAT)

#define S_LNP_CMD    24
#define M_LNP_CMD    0x7U
#define V_LNP_CMD(x) ((x) << S_LNP_CMD)
#define G_LNP_CMD(x) (((x) >> S_LNP_CMD) & M_LNP_CMD)

#define S_LNO_STAT    20
#define M_LNO_STAT    0x7U
#define V_LNO_STAT(x) ((x) << S_LNO_STAT)
#define G_LNO_STAT(x) (((x) >> S_LNO_STAT) & M_LNO_STAT)

#define S_LNO_CMD    16
#define M_LNO_CMD    0x7U
#define V_LNO_CMD(x) ((x) << S_LNO_CMD)
#define G_LNO_CMD(x) (((x) >> S_LNO_CMD) & M_LNO_CMD)

#define S_LNN_STAT    12
#define M_LNN_STAT    0x7U
#define V_LNN_STAT(x) ((x) << S_LNN_STAT)
#define G_LNN_STAT(x) (((x) >> S_LNN_STAT) & M_LNN_STAT)

#define S_LNN_CMD    8
#define M_LNN_CMD    0x7U
#define V_LNN_CMD(x) ((x) << S_LNN_CMD)
#define G_LNN_CMD(x) (((x) >> S_LNN_CMD) & M_LNN_CMD)

#define S_LNM_STAT    4
#define M_LNM_STAT    0x7U
#define V_LNM_STAT(x) ((x) << S_LNM_STAT)
#define G_LNM_STAT(x) (((x) >> S_LNM_STAT) & M_LNM_STAT)

#define S_LNM_CMD    0
#define M_LNM_CMD    0x7U
#define V_LNM_CMD(x) ((x) << S_LNM_CMD)
#define G_LNM_CMD(x) (((x) >> S_LNM_CMD) & M_LNM_CMD)

#define A_PCIE_PHY_FS_LF4 0x5c2c

#define S_LANE9LF    24
#define M_LANE9LF    0x3fU
#define V_LANE9LF(x) ((x) << S_LANE9LF)
#define G_LANE9LF(x) (((x) >> S_LANE9LF) & M_LANE9LF)

#define S_LANE9FS    16
#define M_LANE9FS    0x3fU
#define V_LANE9FS(x) ((x) << S_LANE9FS)
#define G_LANE9FS(x) (((x) >> S_LANE9FS) & M_LANE9FS)

#define S_LANE8LF    8
#define M_LANE8LF    0x3fU
#define V_LANE8LF(x) ((x) << S_LANE8LF)
#define G_LANE8LF(x) (((x) >> S_LANE8LF) & M_LANE8LF)

#define S_LANE8FS    0
#define M_LANE8FS    0x3fU
#define V_LANE8FS(x) ((x) << S_LANE8FS)
#define G_LANE8FS(x) (((x) >> S_LANE8FS) & M_LANE8FS)

#define A_PCIE_PHY_FS_LF5 0x5c30

#define S_LANE11LF    24
#define M_LANE11LF    0x3fU
#define V_LANE11LF(x) ((x) << S_LANE11LF)
#define G_LANE11LF(x) (((x) >> S_LANE11LF) & M_LANE11LF)

#define S_LANE11FS    16
#define M_LANE11FS    0x3fU
#define V_LANE11FS(x) ((x) << S_LANE11FS)
#define G_LANE11FS(x) (((x) >> S_LANE11FS) & M_LANE11FS)

#define S_LANE10LF    8
#define M_LANE10LF    0x3fU
#define V_LANE10LF(x) ((x) << S_LANE10LF)
#define G_LANE10LF(x) (((x) >> S_LANE10LF) & M_LANE10LF)

#define S_LANE10FS    0
#define M_LANE10FS    0x3fU
#define V_LANE10FS(x) ((x) << S_LANE10FS)
#define G_LANE10FS(x) (((x) >> S_LANE10FS) & M_LANE10FS)

#define A_PCIE_PHY_FS_LF6 0x5c34

#define S_LANE13LF    24
#define M_LANE13LF    0x3fU
#define V_LANE13LF(x) ((x) << S_LANE13LF)
#define G_LANE13LF(x) (((x) >> S_LANE13LF) & M_LANE13LF)

#define S_LANE13FS    16
#define M_LANE13FS    0x3fU
#define V_LANE13FS(x) ((x) << S_LANE13FS)
#define G_LANE13FS(x) (((x) >> S_LANE13FS) & M_LANE13FS)

#define S_LANE12LF    8
#define M_LANE12LF    0x3fU
#define V_LANE12LF(x) ((x) << S_LANE12LF)
#define G_LANE12LF(x) (((x) >> S_LANE12LF) & M_LANE12LF)

#define S_LANE12FS    0
#define M_LANE12FS    0x3fU
#define V_LANE12FS(x) ((x) << S_LANE12FS)
#define G_LANE12FS(x) (((x) >> S_LANE12FS) & M_LANE12FS)

#define A_PCIE_PHY_FS_LF7 0x5c38

#define S_LANE15LF    24
#define M_LANE15LF    0x3fU
#define V_LANE15LF(x) ((x) << S_LANE15LF)
#define G_LANE15LF(x) (((x) >> S_LANE15LF) & M_LANE15LF)

#define S_LANE15FS    16
#define M_LANE15FS    0x3fU
#define V_LANE15FS(x) ((x) << S_LANE15FS)
#define G_LANE15FS(x) (((x) >> S_LANE15FS) & M_LANE15FS)

#define S_LANE14LF    8
#define M_LANE14LF    0x3fU
#define V_LANE14LF(x) ((x) << S_LANE14LF)
#define G_LANE14LF(x) (((x) >> S_LANE14LF) & M_LANE14LF)

#define S_LANE14FS    0
#define M_LANE14FS    0x3fU
#define V_LANE14FS(x) ((x) << S_LANE14FS)
#define G_LANE14FS(x) (((x) >> S_LANE14FS) & M_LANE14FS)

#define A_PCIE_MULTI_PHY_INDIR_REQ 0x5c3c

#define S_PHY_REG_ENABLE    31
#define V_PHY_REG_ENABLE(x) ((x) << S_PHY_REG_ENABLE)
#define F_PHY_REG_ENABLE    V_PHY_REG_ENABLE(1U)

#define S_PHY_REG_SELECT    22
#define M_PHY_REG_SELECT    0x3U
#define V_PHY_REG_SELECT(x) ((x) << S_PHY_REG_SELECT)
#define G_PHY_REG_SELECT(x) (((x) >> S_PHY_REG_SELECT) & M_PHY_REG_SELECT)

#define S_PHY_REG_REGADDR    0
#define M_PHY_REG_REGADDR    0xffffU
#define V_PHY_REG_REGADDR(x) ((x) << S_PHY_REG_REGADDR)
#define G_PHY_REG_REGADDR(x) (((x) >> S_PHY_REG_REGADDR) & M_PHY_REG_REGADDR)

#define A_PCIE_MULTI_PHY_INDIR_DATA 0x5c40

#define S_PHY_REG_DATA    0
#define M_PHY_REG_DATA    0xffffU
#define V_PHY_REG_DATA(x) ((x) << S_PHY_REG_DATA)
#define G_PHY_REG_DATA(x) (((x) >> S_PHY_REG_DATA) & M_PHY_REG_DATA)

#define A_PCIE_VF_INT_INDIR_REQ 0x5c44

#define S_ENABLE_VF    24
#define V_ENABLE_VF(x) ((x) << S_ENABLE_VF)
#define F_ENABLE_VF    V_ENABLE_VF(1U)

#define S_AI_VF    23
#define V_AI_VF(x) ((x) << S_AI_VF)
#define F_AI_VF    V_AI_VF(1U)

#define S_VFID_PCIE    0
#define M_VFID_PCIE    0x3ffU
#define V_VFID_PCIE(x) ((x) << S_VFID_PCIE)
#define G_VFID_PCIE(x) (((x) >> S_VFID_PCIE) & M_VFID_PCIE)

#define A_PCIE_VF_INT_INDIR_DATA 0x5c48

#define S_T7_VECBASE    0
#define M_T7_VECBASE    0xfffU
#define V_T7_VECBASE(x) ((x) << S_T7_VECBASE)
#define G_T7_VECBASE(x) (((x) >> S_T7_VECBASE) & M_T7_VECBASE)

#define A_PCIE_VF_256_INT_CFG2 0x5c4c
#define A_PCIE_VF_MSI_EN_4 0x5e50
#define A_PCIE_VF_MSI_EN_5 0x5e54
#define A_PCIE_VF_MSI_EN_6 0x5e58
#define A_PCIE_VF_MSI_EN_7 0x5e5c
#define A_PCIE_VF_MSIX_EN_4 0x5e60
#define A_PCIE_VF_MSIX_EN_5 0x5e64
#define A_PCIE_VF_MSIX_EN_6 0x5e68
#define A_PCIE_VF_MSIX_EN_7 0x5e6c
#define A_PCIE_FLR_VF4_STATUS 0x5e70
#define A_PCIE_FLR_VF5_STATUS 0x5e74
#define A_PCIE_FLR_VF6_STATUS 0x5e78
#define A_PCIE_FLR_VF7_STATUS 0x5e7c
#define A_T6_PCIE_BUS_MST_STAT_4 0x5e80
#define A_T7_PCIE_BUS_MST_STAT_4 0x5e80
#define A_T6_PCIE_BUS_MST_STAT_5 0x5e84
#define A_T7_PCIE_BUS_MST_STAT_5 0x5e84
#define A_T6_PCIE_BUS_MST_STAT_6 0x5e88
#define A_T7_PCIE_BUS_MST_STAT_6 0x5e88
#define A_T6_PCIE_BUS_MST_STAT_7 0x5e8c
#define A_T7_PCIE_BUS_MST_STAT_7 0x5e8c
#define A_PCIE_BUS_MST_STAT_8 0x5e90

#define S_BUSMST_263_256    0
#define M_BUSMST_263_256    0xffU
#define V_BUSMST_263_256(x) ((x) << S_BUSMST_263_256)
#define G_BUSMST_263_256(x) (((x) >> S_BUSMST_263_256) & M_BUSMST_263_256)

#define A_PCIE_TGT_SKID_FIFO 0x5e94

#define S_HDRFREECNT    16
#define M_HDRFREECNT    0xfffU
#define V_HDRFREECNT(x) ((x) << S_HDRFREECNT)
#define G_HDRFREECNT(x) (((x) >> S_HDRFREECNT) & M_HDRFREECNT)

#define S_DATAFREECNT    0
#define M_DATAFREECNT    0xfffU
#define V_DATAFREECNT(x) ((x) << S_DATAFREECNT)
#define G_DATAFREECNT(x) (((x) >> S_DATAFREECNT) & M_DATAFREECNT)

#define A_T6_PCIE_RSP_ERR_STAT_4 0x5ea0
#define A_T7_PCIE_RSP_ERR_STAT_4 0x5ea0
#define A_T6_PCIE_RSP_ERR_STAT_5 0x5ea4
#define A_T7_PCIE_RSP_ERR_STAT_5 0x5ea4
#define A_T6_PCIE_RSP_ERR_STAT_6 0x5ea8
#define A_T7_PCIE_RSP_ERR_STAT_6 0x5ea8
#define A_T6_PCIE_RSP_ERR_STAT_7 0x5eac
#define A_T7_PCIE_RSP_ERR_STAT_7 0x5eac
#define A_PCIE_RSP_ERR_STAT_8 0x5eb0

#define S_RSPERR_263_256    0
#define M_RSPERR_263_256    0xffU
#define V_RSPERR_263_256(x) ((x) << S_RSPERR_263_256)
#define G_RSPERR_263_256(x) (((x) >> S_RSPERR_263_256) & M_RSPERR_263_256)

#define A_PCIE_PHY_STAT1 0x5ec0

#define S_PHY0_RTUNE_ACK    31
#define V_PHY0_RTUNE_ACK(x) ((x) << S_PHY0_RTUNE_ACK)
#define F_PHY0_RTUNE_ACK    V_PHY0_RTUNE_ACK(1U)

#define S_PHY1_RTUNE_ACK    30
#define V_PHY1_RTUNE_ACK(x) ((x) << S_PHY1_RTUNE_ACK)
#define F_PHY1_RTUNE_ACK    V_PHY1_RTUNE_ACK(1U)

#define A_PCIE_PHY_CTRL1 0x5ec4

#define S_PHY0_RTUNE_REQ    31
#define V_PHY0_RTUNE_REQ(x) ((x) << S_PHY0_RTUNE_REQ)
#define F_PHY0_RTUNE_REQ    V_PHY0_RTUNE_REQ(1U)

#define S_PHY1_RTUNE_REQ    30
#define V_PHY1_RTUNE_REQ(x) ((x) << S_PHY1_RTUNE_REQ)
#define F_PHY1_RTUNE_REQ    V_PHY1_RTUNE_REQ(1U)

#define S_TXDEEMPH_GEN1    16
#define M_TXDEEMPH_GEN1    0xffU
#define V_TXDEEMPH_GEN1(x) ((x) << S_TXDEEMPH_GEN1)
#define G_TXDEEMPH_GEN1(x) (((x) >> S_TXDEEMPH_GEN1) & M_TXDEEMPH_GEN1)

#define S_TXDEEMPH_GEN2_3P5DB    8
#define M_TXDEEMPH_GEN2_3P5DB    0xffU
#define V_TXDEEMPH_GEN2_3P5DB(x) ((x) << S_TXDEEMPH_GEN2_3P5DB)
#define G_TXDEEMPH_GEN2_3P5DB(x) (((x) >> S_TXDEEMPH_GEN2_3P5DB) & M_TXDEEMPH_GEN2_3P5DB)

#define S_TXDEEMPH_GEN2_6DB    0
#define M_TXDEEMPH_GEN2_6DB    0xffU
#define V_TXDEEMPH_GEN2_6DB(x) ((x) << S_TXDEEMPH_GEN2_6DB)
#define G_TXDEEMPH_GEN2_6DB(x) (((x) >> S_TXDEEMPH_GEN2_6DB) & M_TXDEEMPH_GEN2_6DB)

#define A_PCIE_PCIE_SPARE0 0x5ec8
#define A_PCIE_RESET_STAT 0x5ecc

#define S_PON_RST_STATE_FLAG    11
#define V_PON_RST_STATE_FLAG(x) ((x) << S_PON_RST_STATE_FLAG)
#define F_PON_RST_STATE_FLAG    V_PON_RST_STATE_FLAG(1U)

#define S_BUS_RST_STATE_FLAG    10
#define V_BUS_RST_STATE_FLAG(x) ((x) << S_BUS_RST_STATE_FLAG)
#define F_BUS_RST_STATE_FLAG    V_BUS_RST_STATE_FLAG(1U)

#define S_DL_DOWN_PCIECRST_MODE0_STATE_FLAG    9
#define V_DL_DOWN_PCIECRST_MODE0_STATE_FLAG(x) ((x) << S_DL_DOWN_PCIECRST_MODE0_STATE_FLAG)
#define F_DL_DOWN_PCIECRST_MODE0_STATE_FLAG    V_DL_DOWN_PCIECRST_MODE0_STATE_FLAG(1U)

#define S_DL_DOWN_PCIECRST_MODE1_STATE_FLAG    8
#define V_DL_DOWN_PCIECRST_MODE1_STATE_FLAG(x) ((x) << S_DL_DOWN_PCIECRST_MODE1_STATE_FLAG)
#define F_DL_DOWN_PCIECRST_MODE1_STATE_FLAG    V_DL_DOWN_PCIECRST_MODE1_STATE_FLAG(1U)

#define S_PCIE_WARM_RST_MODE0_STATE_FLAG    7
#define V_PCIE_WARM_RST_MODE0_STATE_FLAG(x) ((x) << S_PCIE_WARM_RST_MODE0_STATE_FLAG)
#define F_PCIE_WARM_RST_MODE0_STATE_FLAG    V_PCIE_WARM_RST_MODE0_STATE_FLAG(1U)

#define S_PCIE_WARM_RST_MODE1_STATE_FLAG    6
#define V_PCIE_WARM_RST_MODE1_STATE_FLAG(x) ((x) << S_PCIE_WARM_RST_MODE1_STATE_FLAG)
#define F_PCIE_WARM_RST_MODE1_STATE_FLAG    V_PCIE_WARM_RST_MODE1_STATE_FLAG(1U)

#define S_PIO_WARM_RST_MODE0_STATE_FLAG    5
#define V_PIO_WARM_RST_MODE0_STATE_FLAG(x) ((x) << S_PIO_WARM_RST_MODE0_STATE_FLAG)
#define F_PIO_WARM_RST_MODE0_STATE_FLAG    V_PIO_WARM_RST_MODE0_STATE_FLAG(1U)

#define S_PIO_WARM_RST_MODE1_STATE_FLAG    4
#define V_PIO_WARM_RST_MODE1_STATE_FLAG(x) ((x) << S_PIO_WARM_RST_MODE1_STATE_FLAG)
#define F_PIO_WARM_RST_MODE1_STATE_FLAG    V_PIO_WARM_RST_MODE1_STATE_FLAG(1U)

#define S_LASTRESETSTATE    0
#define M_LASTRESETSTATE    0x7U
#define V_LASTRESETSTATE(x) ((x) << S_LASTRESETSTATE)
#define G_LASTRESETSTATE(x) (((x) >> S_LASTRESETSTATE) & M_LASTRESETSTATE)

#define A_PCIE_FUNC_DSTATE 0x5ed0

#define S_PF7_DSTATE    21
#define M_PF7_DSTATE    0x7U
#define V_PF7_DSTATE(x) ((x) << S_PF7_DSTATE)
#define G_PF7_DSTATE(x) (((x) >> S_PF7_DSTATE) & M_PF7_DSTATE)

#define S_PF6_DSTATE    18
#define M_PF6_DSTATE    0x7U
#define V_PF6_DSTATE(x) ((x) << S_PF6_DSTATE)
#define G_PF6_DSTATE(x) (((x) >> S_PF6_DSTATE) & M_PF6_DSTATE)

#define S_PF5_DSTATE    15
#define M_PF5_DSTATE    0x7U
#define V_PF5_DSTATE(x) ((x) << S_PF5_DSTATE)
#define G_PF5_DSTATE(x) (((x) >> S_PF5_DSTATE) & M_PF5_DSTATE)

#define S_PF4_DSTATE    12
#define M_PF4_DSTATE    0x7U
#define V_PF4_DSTATE(x) ((x) << S_PF4_DSTATE)
#define G_PF4_DSTATE(x) (((x) >> S_PF4_DSTATE) & M_PF4_DSTATE)

#define S_PF3_DSTATE    9
#define M_PF3_DSTATE    0x7U
#define V_PF3_DSTATE(x) ((x) << S_PF3_DSTATE)
#define G_PF3_DSTATE(x) (((x) >> S_PF3_DSTATE) & M_PF3_DSTATE)

#define S_PF2_DSTATE    6
#define M_PF2_DSTATE    0x7U
#define V_PF2_DSTATE(x) ((x) << S_PF2_DSTATE)
#define G_PF2_DSTATE(x) (((x) >> S_PF2_DSTATE) & M_PF2_DSTATE)

#define S_PF1_DSTATE    3
#define M_PF1_DSTATE    0x7U
#define V_PF1_DSTATE(x) ((x) << S_PF1_DSTATE)
#define G_PF1_DSTATE(x) (((x) >> S_PF1_DSTATE) & M_PF1_DSTATE)

#define S_PF0_DSTATE    0
#define M_PF0_DSTATE    0x7U
#define V_PF0_DSTATE(x) ((x) << S_PF0_DSTATE)
#define G_PF0_DSTATE(x) (((x) >> S_PF0_DSTATE) & M_PF0_DSTATE)

#define A_PCIE_DEBUG_ADDR_RANGE1 0x5ee0
#define A_PCIE_DEBUG_ADDR_RANGE2 0x5ef0
#define A_PCIE_DEBUG_ADDR_RANGE_CNT 0x5f00
#define A_PCIE_PHY_PGM_LOAD_CTRL 0x5f04

#define S_HSS_PMLD_ACC_EN    31
#define V_HSS_PMLD_ACC_EN(x) ((x) << S_HSS_PMLD_ACC_EN)
#define F_HSS_PMLD_ACC_EN    V_HSS_PMLD_ACC_EN(1U)

#define S_HSS_PMRDWR_ADDR    0
#define M_HSS_PMRDWR_ADDR    0x3ffffU
#define V_HSS_PMRDWR_ADDR(x) ((x) << S_HSS_PMRDWR_ADDR)
#define G_HSS_PMRDWR_ADDR(x) (((x) >> S_HSS_PMRDWR_ADDR) & M_HSS_PMRDWR_ADDR)

#define A_PCIE_PHY_PGM_LOAD_DATA 0x5f08
#define A_PCIE_HSS_CFG 0x5f0c

#define S_HSS_PCS_AGGREGATION_MODE    30
#define M_HSS_PCS_AGGREGATION_MODE    0x3U
#define V_HSS_PCS_AGGREGATION_MODE(x) ((x) << S_HSS_PCS_AGGREGATION_MODE)
#define G_HSS_PCS_AGGREGATION_MODE(x) (((x) >> S_HSS_PCS_AGGREGATION_MODE) & M_HSS_PCS_AGGREGATION_MODE)

#define S_HSS_PCS_FURCATE_MODE    28
#define M_HSS_PCS_FURCATE_MODE    0x3U
#define V_HSS_PCS_FURCATE_MODE(x) ((x) << S_HSS_PCS_FURCATE_MODE)
#define G_HSS_PCS_FURCATE_MODE(x) (((x) >> S_HSS_PCS_FURCATE_MODE) & M_HSS_PCS_FURCATE_MODE)

#define S_HSS_PCS_PCLK_ON_IN_P2    27
#define V_HSS_PCS_PCLK_ON_IN_P2(x) ((x) << S_HSS_PCS_PCLK_ON_IN_P2)
#define F_HSS_PCS_PCLK_ON_IN_P2    V_HSS_PCS_PCLK_ON_IN_P2(1U)

#define S_HSS0_PHY_CTRL_REFCLK    17
#define M_HSS0_PHY_CTRL_REFCLK    0x1fU
#define V_HSS0_PHY_CTRL_REFCLK(x) ((x) << S_HSS0_PHY_CTRL_REFCLK)
#define G_HSS0_PHY_CTRL_REFCLK(x) (((x) >> S_HSS0_PHY_CTRL_REFCLK) & M_HSS0_PHY_CTRL_REFCLK)

#define S_HSS1_PHY_CTRL_REFCLK    12
#define M_HSS1_PHY_CTRL_REFCLK    0x1fU
#define V_HSS1_PHY_CTRL_REFCLK(x) ((x) << S_HSS1_PHY_CTRL_REFCLK)
#define G_HSS1_PHY_CTRL_REFCLK(x) (((x) >> S_HSS1_PHY_CTRL_REFCLK) & M_HSS1_PHY_CTRL_REFCLK)

#define S_HSS0_PHY_REXT_MASTER    11
#define V_HSS0_PHY_REXT_MASTER(x) ((x) << S_HSS0_PHY_REXT_MASTER)
#define F_HSS0_PHY_REXT_MASTER    V_HSS0_PHY_REXT_MASTER(1U)

#define S_HSS1_PHY_REXT_MASTER    10
#define V_HSS1_PHY_REXT_MASTER(x) ((x) << S_HSS1_PHY_REXT_MASTER)
#define F_HSS1_PHY_REXT_MASTER    V_HSS1_PHY_REXT_MASTER(1U)

#define S_HSS0_PHY_CTRL_VDDA_SEL    9
#define V_HSS0_PHY_CTRL_VDDA_SEL(x) ((x) << S_HSS0_PHY_CTRL_VDDA_SEL)
#define F_HSS0_PHY_CTRL_VDDA_SEL    V_HSS0_PHY_CTRL_VDDA_SEL(1U)

#define S_HSS0_PHY_CTRL_VDDHA_SEL    8
#define V_HSS0_PHY_CTRL_VDDHA_SEL(x) ((x) << S_HSS0_PHY_CTRL_VDDHA_SEL)
#define F_HSS0_PHY_CTRL_VDDHA_SEL    V_HSS0_PHY_CTRL_VDDHA_SEL(1U)

#define S_HSS1_PHY_CTRL_VDDA_SEL    7
#define V_HSS1_PHY_CTRL_VDDA_SEL(x) ((x) << S_HSS1_PHY_CTRL_VDDA_SEL)
#define F_HSS1_PHY_CTRL_VDDA_SEL    V_HSS1_PHY_CTRL_VDDA_SEL(1U)

#define S_HSS1_PHY_CTRL_VDDHA_SEL    6
#define V_HSS1_PHY_CTRL_VDDHA_SEL(x) ((x) << S_HSS1_PHY_CTRL_VDDHA_SEL)
#define F_HSS1_PHY_CTRL_VDDHA_SEL    V_HSS1_PHY_CTRL_VDDHA_SEL(1U)

#define S_HSS1_CPU_MEMPSACK    5
#define V_HSS1_CPU_MEMPSACK(x) ((x) << S_HSS1_CPU_MEMPSACK)
#define F_HSS1_CPU_MEMPSACK    V_HSS1_CPU_MEMPSACK(1U)

#define S_HSS0_CPU_MEMPSACK    3
#define V_HSS0_CPU_MEMPSACK(x) ((x) << S_HSS0_CPU_MEMPSACK)
#define F_HSS0_CPU_MEMPSACK    V_HSS0_CPU_MEMPSACK(1U)

#define S_HSS1_CPU_MEMACK    4
#define V_HSS1_CPU_MEMACK(x) ((x) << S_HSS1_CPU_MEMACK)
#define F_HSS1_CPU_MEMACK    V_HSS1_CPU_MEMACK(1U)

#define S_HSS0_CPU_MEMACK    2
#define V_HSS0_CPU_MEMACK(x) ((x) << S_HSS0_CPU_MEMACK)
#define F_HSS0_CPU_MEMACK    V_HSS0_CPU_MEMACK(1U)

#define S_HSS_PM_IS_ROM    1
#define V_HSS_PM_IS_ROM(x) ((x) << S_HSS_PM_IS_ROM)
#define F_HSS_PM_IS_ROM    V_HSS_PM_IS_ROM(1U)

#define A_PCIE_HSS_RST 0x5f10

#define S_HSS_RST_CTRL_BY_FW    31
#define V_HSS_RST_CTRL_BY_FW(x) ((x) << S_HSS_RST_CTRL_BY_FW)
#define F_HSS_RST_CTRL_BY_FW    V_HSS_RST_CTRL_BY_FW(1U)

#define S_HSS_PIPE0_RESET_N    30
#define V_HSS_PIPE0_RESET_N(x) ((x) << S_HSS_PIPE0_RESET_N)
#define F_HSS_PIPE0_RESET_N    V_HSS_PIPE0_RESET_N(1U)

#define S_HSS0_POR_N    29
#define V_HSS0_POR_N(x) ((x) << S_HSS0_POR_N)
#define F_HSS0_POR_N    V_HSS0_POR_N(1U)

#define S_HSS1_POR_N    28
#define V_HSS1_POR_N(x) ((x) << S_HSS1_POR_N)
#define F_HSS1_POR_N    V_HSS1_POR_N(1U)

#define S_HSS0_CPU_RESET    27
#define V_HSS0_CPU_RESET(x) ((x) << S_HSS0_CPU_RESET)
#define F_HSS0_CPU_RESET    V_HSS0_CPU_RESET(1U)

#define S_HSS1_CPU_RESET    26
#define V_HSS1_CPU_RESET(x) ((x) << S_HSS1_CPU_RESET)
#define F_HSS1_CPU_RESET    V_HSS1_CPU_RESET(1U)

#define S_HSS_PCS_POR_N    25
#define V_HSS_PCS_POR_N(x) ((x) << S_HSS_PCS_POR_N)
#define F_HSS_PCS_POR_N    V_HSS_PCS_POR_N(1U)

#define S_SW_CRST_    24
#define V_SW_CRST_(x) ((x) << S_SW_CRST_)
#define F_SW_CRST_    V_SW_CRST_(1U)

#define S_SW_PCIECRST_    23
#define V_SW_PCIECRST_(x) ((x) << S_SW_PCIECRST_)
#define F_SW_PCIECRST_    V_SW_PCIECRST_(1U)

#define S_SW_PCIEPIPERST_    22
#define V_SW_PCIEPIPERST_(x) ((x) << S_SW_PCIEPIPERST_)
#define F_SW_PCIEPIPERST_    V_SW_PCIEPIPERST_(1U)

#define S_SW_PCIEPHYRST_    21
#define V_SW_PCIEPHYRST_(x) ((x) << S_SW_PCIEPHYRST_)
#define F_SW_PCIEPHYRST_    V_SW_PCIEPHYRST_(1U)

#define S_HSS1_ERR_O    3
#define V_HSS1_ERR_O(x) ((x) << S_HSS1_ERR_O)
#define F_HSS1_ERR_O    V_HSS1_ERR_O(1U)

#define S_HSS0_ERR_O    2
#define V_HSS0_ERR_O(x) ((x) << S_HSS0_ERR_O)
#define F_HSS0_ERR_O    V_HSS0_ERR_O(1U)

#define S_HSS1_PLL_LOCK    1
#define V_HSS1_PLL_LOCK(x) ((x) << S_HSS1_PLL_LOCK)
#define F_HSS1_PLL_LOCK    V_HSS1_PLL_LOCK(1U)

#define S_HSS0_PLL_LOCK    0
#define V_HSS0_PLL_LOCK(x) ((x) << S_HSS0_PLL_LOCK)
#define F_HSS0_PLL_LOCK    V_HSS0_PLL_LOCK(1U)

#define A_PCIE_T5_ARM_CFG 0x5f20

#define S_T5_ARM_MAXREQCNT    20
#define M_T5_ARM_MAXREQCNT    0x7fU
#define V_T5_ARM_MAXREQCNT(x) ((x) << S_T5_ARM_MAXREQCNT)
#define G_T5_ARM_MAXREQCNT(x) (((x) >> S_T5_ARM_MAXREQCNT) & M_T5_ARM_MAXREQCNT)

#define S_T5_ARM_MAXRDREQSIZE    17
#define M_T5_ARM_MAXRDREQSIZE    0x7U
#define V_T5_ARM_MAXRDREQSIZE(x) ((x) << S_T5_ARM_MAXRDREQSIZE)
#define G_T5_ARM_MAXRDREQSIZE(x) (((x) >> S_T5_ARM_MAXRDREQSIZE) & M_T5_ARM_MAXRDREQSIZE)

#define S_T5_ARM_MAXRSPCNT    9
#define M_T5_ARM_MAXRSPCNT    0xffU
#define V_T5_ARM_MAXRSPCNT(x) ((x) << S_T5_ARM_MAXRSPCNT)
#define G_T5_ARM_MAXRSPCNT(x) (((x) >> S_T5_ARM_MAXRSPCNT) & M_T5_ARM_MAXRSPCNT)

#define A_PCIE_T5_ARM_STAT 0x5f24

#define S_ARM_RESPCNT    20
#define M_ARM_RESPCNT    0x1ffU
#define V_ARM_RESPCNT(x) ((x) << S_ARM_RESPCNT)
#define G_ARM_RESPCNT(x) (((x) >> S_ARM_RESPCNT) & M_ARM_RESPCNT)

#define S_ARM_RDREQCNT    12
#define M_ARM_RDREQCNT    0x3fU
#define V_ARM_RDREQCNT(x) ((x) << S_ARM_RDREQCNT)
#define G_ARM_RDREQCNT(x) (((x) >> S_ARM_RDREQCNT) & M_ARM_RDREQCNT)

#define S_ARM_WRREQCNT    0
#define M_ARM_WRREQCNT    0x1ffU
#define V_ARM_WRREQCNT(x) ((x) << S_ARM_WRREQCNT)
#define G_ARM_WRREQCNT(x) (((x) >> S_ARM_WRREQCNT) & M_ARM_WRREQCNT)

#define A_PCIE_T5_ARM_STAT2 0x5f28

#define S_ARM_COOKIECNT    24
#define M_ARM_COOKIECNT    0xfU
#define V_ARM_COOKIECNT(x) ((x) << S_ARM_COOKIECNT)
#define G_ARM_COOKIECNT(x) (((x) >> S_ARM_COOKIECNT) & M_ARM_COOKIECNT)

#define S_ARM_RDSEQNUMUPDCNT    20
#define M_ARM_RDSEQNUMUPDCNT    0xfU
#define V_ARM_RDSEQNUMUPDCNT(x) ((x) << S_ARM_RDSEQNUMUPDCNT)
#define G_ARM_RDSEQNUMUPDCNT(x) (((x) >> S_ARM_RDSEQNUMUPDCNT) & M_ARM_RDSEQNUMUPDCNT)

#define S_ARM_SIREQCNT    16
#define M_ARM_SIREQCNT    0xfU
#define V_ARM_SIREQCNT(x) ((x) << S_ARM_SIREQCNT)
#define G_ARM_SIREQCNT(x) (((x) >> S_ARM_SIREQCNT) & M_ARM_SIREQCNT)

#define S_ARM_WREOPMATCHSOP    12
#define V_ARM_WREOPMATCHSOP(x) ((x) << S_ARM_WREOPMATCHSOP)
#define F_ARM_WREOPMATCHSOP    V_ARM_WREOPMATCHSOP(1U)

#define S_ARM_WRSOPCNT    8
#define M_ARM_WRSOPCNT    0xfU
#define V_ARM_WRSOPCNT(x) ((x) << S_ARM_WRSOPCNT)
#define G_ARM_WRSOPCNT(x) (((x) >> S_ARM_WRSOPCNT) & M_ARM_WRSOPCNT)

#define S_ARM_RDSOPCNT    0
#define M_ARM_RDSOPCNT    0xffU
#define V_ARM_RDSOPCNT(x) ((x) << S_ARM_RDSOPCNT)
#define G_ARM_RDSOPCNT(x) (((x) >> S_ARM_RDSOPCNT) & M_ARM_RDSOPCNT)

#define A_PCIE_T5_ARM_STAT3 0x5f2c

#define S_ARM_ATMREQSOPCNT    24
#define M_ARM_ATMREQSOPCNT    0xffU
#define V_ARM_ATMREQSOPCNT(x) ((x) << S_ARM_ATMREQSOPCNT)
#define G_ARM_ATMREQSOPCNT(x) (((x) >> S_ARM_ATMREQSOPCNT) & M_ARM_ATMREQSOPCNT)

#define S_ARM_ATMEOPMATCHSOP    17
#define V_ARM_ATMEOPMATCHSOP(x) ((x) << S_ARM_ATMEOPMATCHSOP)
#define F_ARM_ATMEOPMATCHSOP    V_ARM_ATMEOPMATCHSOP(1U)

#define S_ARM_RSPEOPMATCHSOP    16
#define V_ARM_RSPEOPMATCHSOP(x) ((x) << S_ARM_RSPEOPMATCHSOP)
#define F_ARM_RSPEOPMATCHSOP    V_ARM_RSPEOPMATCHSOP(1U)

#define S_ARM_RSPERRCNT    8
#define M_ARM_RSPERRCNT    0xffU
#define V_ARM_RSPERRCNT(x) ((x) << S_ARM_RSPERRCNT)
#define G_ARM_RSPERRCNT(x) (((x) >> S_ARM_RSPERRCNT) & M_ARM_RSPERRCNT)

#define S_ARM_RSPSOPCNT    0
#define M_ARM_RSPSOPCNT    0xffU
#define V_ARM_RSPSOPCNT(x) ((x) << S_ARM_RSPSOPCNT)
#define G_ARM_RSPSOPCNT(x) (((x) >> S_ARM_RSPSOPCNT) & M_ARM_RSPSOPCNT)

#define A_PCIE_ARM_REQUESTER_ID 0x5f30

#define S_A0_RSVD1    24
#define M_A0_RSVD1    0xffU
#define V_A0_RSVD1(x) ((x) << S_A0_RSVD1)
#define G_A0_RSVD1(x) (((x) >> S_A0_RSVD1) & M_A0_RSVD1)

#define S_A0_PRIMBUSNUMBER    16
#define M_A0_PRIMBUSNUMBER    0xffU
#define V_A0_PRIMBUSNUMBER(x) ((x) << S_A0_PRIMBUSNUMBER)
#define G_A0_PRIMBUSNUMBER(x) (((x) >> S_A0_PRIMBUSNUMBER) & M_A0_PRIMBUSNUMBER)

#define S_A0_REQUESTERID    0
#define M_A0_REQUESTERID    0xffffU
#define V_A0_REQUESTERID(x) ((x) << S_A0_REQUESTERID)
#define G_A0_REQUESTERID(x) (((x) >> S_A0_REQUESTERID) & M_A0_REQUESTERID)

#define A_PCIE_SWITCH_CFG_SPACE_REQ0 0x5f34

#define S_REQ0ENABLE    31
#define V_REQ0ENABLE(x) ((x) << S_REQ0ENABLE)
#define F_REQ0ENABLE    V_REQ0ENABLE(1U)

#define S_RDREQ0TYPE    19
#define V_RDREQ0TYPE(x) ((x) << S_RDREQ0TYPE)
#define F_RDREQ0TYPE    V_RDREQ0TYPE(1U)

#define S_BYTEENABLE0    15
#define M_BYTEENABLE0    0xfU
#define V_BYTEENABLE0(x) ((x) << S_BYTEENABLE0)
#define G_BYTEENABLE0(x) (((x) >> S_BYTEENABLE0) & M_BYTEENABLE0)

#define S_REGADDR0    0
#define M_REGADDR0    0x7fffU
#define V_REGADDR0(x) ((x) << S_REGADDR0)
#define G_REGADDR0(x) (((x) >> S_REGADDR0) & M_REGADDR0)

#define A_PCIE_SWITCH_CFG_SPACE_DATA0 0x5f38
#define A_PCIE_SWITCH_CFG_SPACE_REQ1 0x5f3c

#define S_REQ1ENABLE    31
#define V_REQ1ENABLE(x) ((x) << S_REQ1ENABLE)
#define F_REQ1ENABLE    V_REQ1ENABLE(1U)

#define S_RDREQ1TYPE    26
#define M_RDREQ1TYPE    0xfU
#define V_RDREQ1TYPE(x) ((x) << S_RDREQ1TYPE)
#define G_RDREQ1TYPE(x) (((x) >> S_RDREQ1TYPE) & M_RDREQ1TYPE)

#define S_BYTEENABLE1    15
#define M_BYTEENABLE1    0x7ffU
#define V_BYTEENABLE1(x) ((x) << S_BYTEENABLE1)
#define G_BYTEENABLE1(x) (((x) >> S_BYTEENABLE1) & M_BYTEENABLE1)

#define S_REGADDR1    0
#define M_REGADDR1    0x7fffU
#define V_REGADDR1(x) ((x) << S_REGADDR1)
#define G_REGADDR1(x) (((x) >> S_REGADDR1) & M_REGADDR1)

#define A_PCIE_SWITCH_CFG_SPACE_DATA1 0x5f40
#define A_PCIE_SWITCH_CFG_SPACE_REQ2 0x5f44

#define S_REQ2ENABLE    31
#define V_REQ2ENABLE(x) ((x) << S_REQ2ENABLE)
#define F_REQ2ENABLE    V_REQ2ENABLE(1U)

#define S_RDREQ2TYPE    26
#define M_RDREQ2TYPE    0xfU
#define V_RDREQ2TYPE(x) ((x) << S_RDREQ2TYPE)
#define G_RDREQ2TYPE(x) (((x) >> S_RDREQ2TYPE) & M_RDREQ2TYPE)

#define S_BYTEENABLE2    15
#define M_BYTEENABLE2    0x7ffU
#define V_BYTEENABLE2(x) ((x) << S_BYTEENABLE2)
#define G_BYTEENABLE2(x) (((x) >> S_BYTEENABLE2) & M_BYTEENABLE2)

#define S_REGADDR2    0
#define M_REGADDR2    0x7fffU
#define V_REGADDR2(x) ((x) << S_REGADDR2)
#define G_REGADDR2(x) (((x) >> S_REGADDR2) & M_REGADDR2)

#define A_PCIE_SWITCH_CFG_SPACE_DATA2 0x5f48
#define A_PCIE_SWITCH_CFG_SPACE_REQ3 0x5f4c

#define S_REQ3ENABLE    31
#define V_REQ3ENABLE(x) ((x) << S_REQ3ENABLE)
#define F_REQ3ENABLE    V_REQ3ENABLE(1U)

#define S_RDREQ3TYPE    26
#define M_RDREQ3TYPE    0xfU
#define V_RDREQ3TYPE(x) ((x) << S_RDREQ3TYPE)
#define G_RDREQ3TYPE(x) (((x) >> S_RDREQ3TYPE) & M_RDREQ3TYPE)

#define S_BYTEENABLE3    15
#define M_BYTEENABLE3    0x7ffU
#define V_BYTEENABLE3(x) ((x) << S_BYTEENABLE3)
#define G_BYTEENABLE3(x) (((x) >> S_BYTEENABLE3) & M_BYTEENABLE3)

#define S_REGADDR3    0
#define M_REGADDR3    0x7fffU
#define V_REGADDR3(x) ((x) << S_REGADDR3)
#define G_REGADDR3(x) (((x) >> S_REGADDR3) & M_REGADDR3)

#define A_PCIE_SWITCH_CFG_SPACE_DATA3 0x5f50
#define A_PCIE_SWITCH_CFG_SPACE_REQ4 0x5f54

#define S_REQ4ENABLE    31
#define V_REQ4ENABLE(x) ((x) << S_REQ4ENABLE)
#define F_REQ4ENABLE    V_REQ4ENABLE(1U)

#define S_RDREQ4TYPE    26
#define M_RDREQ4TYPE    0xfU
#define V_RDREQ4TYPE(x) ((x) << S_RDREQ4TYPE)
#define G_RDREQ4TYPE(x) (((x) >> S_RDREQ4TYPE) & M_RDREQ4TYPE)

#define S_BYTEENABLE4    15
#define M_BYTEENABLE4    0x7ffU
#define V_BYTEENABLE4(x) ((x) << S_BYTEENABLE4)
#define G_BYTEENABLE4(x) (((x) >> S_BYTEENABLE4) & M_BYTEENABLE4)

#define S_REGADDR4    0
#define M_REGADDR4    0x7fffU
#define V_REGADDR4(x) ((x) << S_REGADDR4)
#define G_REGADDR4(x) (((x) >> S_REGADDR4) & M_REGADDR4)

#define A_PCIE_SWITCH_CFG_SPACE_DATA4 0x5f58
#define A_PCIE_SWITCH_CFG_SPACE_REQ5 0x5f5c

#define S_REQ5ENABLE    31
#define V_REQ5ENABLE(x) ((x) << S_REQ5ENABLE)
#define F_REQ5ENABLE    V_REQ5ENABLE(1U)

#define S_RDREQ5TYPE    26
#define M_RDREQ5TYPE    0xfU
#define V_RDREQ5TYPE(x) ((x) << S_RDREQ5TYPE)
#define G_RDREQ5TYPE(x) (((x) >> S_RDREQ5TYPE) & M_RDREQ5TYPE)

#define S_BYTEENABLE5    15
#define M_BYTEENABLE5    0x7ffU
#define V_BYTEENABLE5(x) ((x) << S_BYTEENABLE5)
#define G_BYTEENABLE5(x) (((x) >> S_BYTEENABLE5) & M_BYTEENABLE5)

#define S_REGADDR5    0
#define M_REGADDR5    0x7fffU
#define V_REGADDR5(x) ((x) << S_REGADDR5)
#define G_REGADDR5(x) (((x) >> S_REGADDR5) & M_REGADDR5)

#define A_PCIE_SWITCH_CFG_SPACE_DATA5 0x5f60
#define A_PCIE_SWITCH_CFG_SPACE_REQ6 0x5f64

#define S_REQ6ENABLE    31
#define V_REQ6ENABLE(x) ((x) << S_REQ6ENABLE)
#define F_REQ6ENABLE    V_REQ6ENABLE(1U)

#define S_RDREQ6TYPE    26
#define M_RDREQ6TYPE    0xfU
#define V_RDREQ6TYPE(x) ((x) << S_RDREQ6TYPE)
#define G_RDREQ6TYPE(x) (((x) >> S_RDREQ6TYPE) & M_RDREQ6TYPE)

#define S_BYTEENABLE6    15
#define M_BYTEENABLE6    0x7ffU
#define V_BYTEENABLE6(x) ((x) << S_BYTEENABLE6)
#define G_BYTEENABLE6(x) (((x) >> S_BYTEENABLE6) & M_BYTEENABLE6)

#define S_REGADDR6    0
#define M_REGADDR6    0x7fffU
#define V_REGADDR6(x) ((x) << S_REGADDR6)
#define G_REGADDR6(x) (((x) >> S_REGADDR6) & M_REGADDR6)

#define A_PCIE_SWITCH_CFG_SPACE_DATA6 0x5f68
#define A_PCIE_SWITCH_CFG_SPACE_REQ7 0x5f6c

#define S_REQ7ENABLE    31
#define V_REQ7ENABLE(x) ((x) << S_REQ7ENABLE)
#define F_REQ7ENABLE    V_REQ7ENABLE(1U)

#define S_RDREQ7TYPE    26
#define M_RDREQ7TYPE    0xfU
#define V_RDREQ7TYPE(x) ((x) << S_RDREQ7TYPE)
#define G_RDREQ7TYPE(x) (((x) >> S_RDREQ7TYPE) & M_RDREQ7TYPE)

#define S_BYTEENABLE7    15
#define M_BYTEENABLE7    0x7ffU
#define V_BYTEENABLE7(x) ((x) << S_BYTEENABLE7)
#define G_BYTEENABLE7(x) (((x) >> S_BYTEENABLE7) & M_BYTEENABLE7)

#define S_REGADDR7    0
#define M_REGADDR7    0x7fffU
#define V_REGADDR7(x) ((x) << S_REGADDR7)
#define G_REGADDR7(x) (((x) >> S_REGADDR7) & M_REGADDR7)

#define A_PCIE_SWITCH_CFG_SPACE_DATA7 0x5f70
#define A_PCIE_SWITCH_CFG_SPACE_REQ8 0x5f74

#define S_REQ8ENABLE    31
#define V_REQ8ENABLE(x) ((x) << S_REQ8ENABLE)
#define F_REQ8ENABLE    V_REQ8ENABLE(1U)

#define S_RDREQ8TYPE    26
#define M_RDREQ8TYPE    0xfU
#define V_RDREQ8TYPE(x) ((x) << S_RDREQ8TYPE)
#define G_RDREQ8TYPE(x) (((x) >> S_RDREQ8TYPE) & M_RDREQ8TYPE)

#define S_BYTEENABLE8    15
#define M_BYTEENABLE8    0x7ffU
#define V_BYTEENABLE8(x) ((x) << S_BYTEENABLE8)
#define G_BYTEENABLE8(x) (((x) >> S_BYTEENABLE8) & M_BYTEENABLE8)

#define S_REGADDR8    0
#define M_REGADDR8    0x7fffU
#define V_REGADDR8(x) ((x) << S_REGADDR8)
#define G_REGADDR8(x) (((x) >> S_REGADDR8) & M_REGADDR8)

#define A_PCIE_SWITCH_CFG_SPACE_DATA8 0x5f78
#define A_PCIE_SNPS_G5_PHY_CR_REQ 0x5f7c

#define S_REGSEL    31
#define V_REGSEL(x) ((x) << S_REGSEL)
#define F_REGSEL    V_REGSEL(1U)

#define S_RDENABLE    30
#define V_RDENABLE(x) ((x) << S_RDENABLE)
#define F_RDENABLE    V_RDENABLE(1U)

#define S_WRENABLE    29
#define V_WRENABLE(x) ((x) << S_WRENABLE)
#define F_WRENABLE    V_WRENABLE(1U)

#define S_AUTOINCRVAL    21
#define M_AUTOINCRVAL    0x3U
#define V_AUTOINCRVAL(x) ((x) << S_AUTOINCRVAL)
#define G_AUTOINCRVAL(x) (((x) >> S_AUTOINCRVAL) & M_AUTOINCRVAL)

#define S_AUTOINCR    20
#define V_AUTOINCR(x) ((x) << S_AUTOINCR)
#define F_AUTOINCR    V_AUTOINCR(1U)

#define S_PHYSEL    16
#define M_PHYSEL    0xfU
#define V_PHYSEL(x) ((x) << S_PHYSEL)
#define G_PHYSEL(x) (((x) >> S_PHYSEL) & M_PHYSEL)

#define S_T7_REGADDR    0
#define M_T7_REGADDR    0xffffU
#define V_T7_REGADDR(x) ((x) << S_T7_REGADDR)
#define G_T7_REGADDR(x) (((x) >> S_T7_REGADDR) & M_T7_REGADDR)

#define A_PCIE_SNPS_G5_PHY_CR_DATA 0x5f80
#define A_PCIE_SNPS_G5_PHY_SRAM_CFG 0x5f84

#define S_PHY3_SRAM_BOOTLOAD_BYPASS    27
#define V_PHY3_SRAM_BOOTLOAD_BYPASS(x) ((x) << S_PHY3_SRAM_BOOTLOAD_BYPASS)
#define F_PHY3_SRAM_BOOTLOAD_BYPASS    V_PHY3_SRAM_BOOTLOAD_BYPASS(1U)

#define S_PHY3_SRAM_BYPASS    26
#define V_PHY3_SRAM_BYPASS(x) ((x) << S_PHY3_SRAM_BYPASS)
#define F_PHY3_SRAM_BYPASS    V_PHY3_SRAM_BYPASS(1U)

#define S_PHY3_SRAM_ECC_EN    25
#define V_PHY3_SRAM_ECC_EN(x) ((x) << S_PHY3_SRAM_ECC_EN)
#define F_PHY3_SRAM_ECC_EN    V_PHY3_SRAM_ECC_EN(1U)

#define S_PHY3_SRAM_EXT_LD_DONE    24
#define V_PHY3_SRAM_EXT_LD_DONE(x) ((x) << S_PHY3_SRAM_EXT_LD_DONE)
#define F_PHY3_SRAM_EXT_LD_DONE    V_PHY3_SRAM_EXT_LD_DONE(1U)

#define S_PHY2_SRAM_BOOTLOAD_BYPASS    19
#define V_PHY2_SRAM_BOOTLOAD_BYPASS(x) ((x) << S_PHY2_SRAM_BOOTLOAD_BYPASS)
#define F_PHY2_SRAM_BOOTLOAD_BYPASS    V_PHY2_SRAM_BOOTLOAD_BYPASS(1U)

#define S_PHY2_SRAM_BYPASS    18
#define V_PHY2_SRAM_BYPASS(x) ((x) << S_PHY2_SRAM_BYPASS)
#define F_PHY2_SRAM_BYPASS    V_PHY2_SRAM_BYPASS(1U)

#define S_PHY2_SRAM_ECC_EN    17
#define V_PHY2_SRAM_ECC_EN(x) ((x) << S_PHY2_SRAM_ECC_EN)
#define F_PHY2_SRAM_ECC_EN    V_PHY2_SRAM_ECC_EN(1U)

#define S_PHY2_SRAM_EXT_LD_DONE    16
#define V_PHY2_SRAM_EXT_LD_DONE(x) ((x) << S_PHY2_SRAM_EXT_LD_DONE)
#define F_PHY2_SRAM_EXT_LD_DONE    V_PHY2_SRAM_EXT_LD_DONE(1U)

#define S_PHY1_SRAM_BOOTLOAD_BYPASS    11
#define V_PHY1_SRAM_BOOTLOAD_BYPASS(x) ((x) << S_PHY1_SRAM_BOOTLOAD_BYPASS)
#define F_PHY1_SRAM_BOOTLOAD_BYPASS    V_PHY1_SRAM_BOOTLOAD_BYPASS(1U)

#define S_PHY1_SRAM_BYPASS    10
#define V_PHY1_SRAM_BYPASS(x) ((x) << S_PHY1_SRAM_BYPASS)
#define F_PHY1_SRAM_BYPASS    V_PHY1_SRAM_BYPASS(1U)

#define S_PHY1_SRAM_ECC_EN    9
#define V_PHY1_SRAM_ECC_EN(x) ((x) << S_PHY1_SRAM_ECC_EN)
#define F_PHY1_SRAM_ECC_EN    V_PHY1_SRAM_ECC_EN(1U)

#define S_PHY1_SRAM_EXT_LD_DONE    8
#define V_PHY1_SRAM_EXT_LD_DONE(x) ((x) << S_PHY1_SRAM_EXT_LD_DONE)
#define F_PHY1_SRAM_EXT_LD_DONE    V_PHY1_SRAM_EXT_LD_DONE(1U)

#define S_PHY_CR_PARA_SEL    4
#define M_PHY_CR_PARA_SEL    0xfU
#define V_PHY_CR_PARA_SEL(x) ((x) << S_PHY_CR_PARA_SEL)
#define G_PHY_CR_PARA_SEL(x) (((x) >> S_PHY_CR_PARA_SEL) & M_PHY_CR_PARA_SEL)

#define S_PHY0_SRAM_BOOTLOAD_BYPASS    3
#define V_PHY0_SRAM_BOOTLOAD_BYPASS(x) ((x) << S_PHY0_SRAM_BOOTLOAD_BYPASS)
#define F_PHY0_SRAM_BOOTLOAD_BYPASS    V_PHY0_SRAM_BOOTLOAD_BYPASS(1U)

#define S_PHY0_SRAM_BYPASS    2
#define V_PHY0_SRAM_BYPASS(x) ((x) << S_PHY0_SRAM_BYPASS)
#define F_PHY0_SRAM_BYPASS    V_PHY0_SRAM_BYPASS(1U)

#define S_PHY0_SRAM_ECC_EN    1
#define V_PHY0_SRAM_ECC_EN(x) ((x) << S_PHY0_SRAM_ECC_EN)
#define F_PHY0_SRAM_ECC_EN    V_PHY0_SRAM_ECC_EN(1U)

#define S_PHY0_SRAM_EXT_LD_DONE    0
#define V_PHY0_SRAM_EXT_LD_DONE(x) ((x) << S_PHY0_SRAM_EXT_LD_DONE)
#define F_PHY0_SRAM_EXT_LD_DONE    V_PHY0_SRAM_EXT_LD_DONE(1U)

#define A_PCIE_SNPS_G5_PHY_SRAM_STS 0x5f88

#define S_PHY3_SRAM_INIT_DONE    3
#define V_PHY3_SRAM_INIT_DONE(x) ((x) << S_PHY3_SRAM_INIT_DONE)
#define F_PHY3_SRAM_INIT_DONE    V_PHY3_SRAM_INIT_DONE(1U)

#define S_PHY2_SRAM_INIT_DONE    2
#define V_PHY2_SRAM_INIT_DONE(x) ((x) << S_PHY2_SRAM_INIT_DONE)
#define F_PHY2_SRAM_INIT_DONE    V_PHY2_SRAM_INIT_DONE(1U)

#define S_PHY1_SRAM_INIT_DONE    1
#define V_PHY1_SRAM_INIT_DONE(x) ((x) << S_PHY1_SRAM_INIT_DONE)
#define F_PHY1_SRAM_INIT_DONE    V_PHY1_SRAM_INIT_DONE(1U)

#define S_PHY0_SRAM_INIT_DONE    0
#define V_PHY0_SRAM_INIT_DONE(x) ((x) << S_PHY0_SRAM_INIT_DONE)
#define F_PHY0_SRAM_INIT_DONE    V_PHY0_SRAM_INIT_DONE(1U)

#define A_PCIE_SNPS_G5_PHY_CTRL_PHY_0_TO_3 0x5f90
#define A_PCIE_SNPS_G5_PHY_CTRL_PHY_0_DATA 0x5f94
#define A_PCIE_SNPS_G5_PHY_CTRL_PHY_1_DATA 0x5f98
#define A_PCIE_SNPS_G5_PHY_CTRL_PHY_2_DATA 0x5f9c
#define A_PCIE_SNPS_G5_PHY_CTRL_PHY_3_DATA 0x5fa0
#define A_PCIE_SNPS_G5_PHY_DEFAULTS 0x5fa4
#define A_PCIE_SNPS_G5_PHY_0_VALUES 0x5fa8

#define S_RX_TERM_OFFSET    28
#define V_RX_TERM_OFFSET(x) ((x) << S_RX_TERM_OFFSET)
#define F_RX_TERM_OFFSET    V_RX_TERM_OFFSET(1U)

#define S_REFB_RAW_CLK_DIV2_EN    27
#define V_REFB_RAW_CLK_DIV2_EN(x) ((x) << S_REFB_RAW_CLK_DIV2_EN)
#define F_REFB_RAW_CLK_DIV2_EN    V_REFB_RAW_CLK_DIV2_EN(1U)

#define S_REFB_RANGE    23
#define M_REFB_RANGE    0xfU
#define V_REFB_RANGE(x) ((x) << S_REFB_RANGE)
#define G_REFB_RANGE(x) (((x) >> S_REFB_RANGE) & M_REFB_RANGE)

#define S_REFB_LANE_CLK_EN    22
#define V_REFB_LANE_CLK_EN(x) ((x) << S_REFB_LANE_CLK_EN)
#define F_REFB_LANE_CLK_EN    V_REFB_LANE_CLK_EN(1U)

#define S_REFB_CLK_DIV2_EN    21
#define V_REFB_CLK_DIV2_EN(x) ((x) << S_REFB_CLK_DIV2_EN)
#define F_REFB_CLK_DIV2_EN    V_REFB_CLK_DIV2_EN(1U)

#define S_REFA_RAW_CLK_DIV2_EN    20
#define V_REFA_RAW_CLK_DIV2_EN(x) ((x) << S_REFA_RAW_CLK_DIV2_EN)
#define F_REFA_RAW_CLK_DIV2_EN    V_REFA_RAW_CLK_DIV2_EN(1U)

#define S_REFA_RANGE    16
#define M_REFA_RANGE    0xfU
#define V_REFA_RANGE(x) ((x) << S_REFA_RANGE)
#define G_REFA_RANGE(x) (((x) >> S_REFA_RANGE) & M_REFA_RANGE)

#define S_REFA_LANE_CLK_EN    15
#define V_REFA_LANE_CLK_EN(x) ((x) << S_REFA_LANE_CLK_EN)
#define F_REFA_LANE_CLK_EN    V_REFA_LANE_CLK_EN(1U)

#define S_REFA_CLK_DIV2_EN    14
#define V_REFA_CLK_DIV2_EN(x) ((x) << S_REFA_CLK_DIV2_EN)
#define F_REFA_CLK_DIV2_EN    V_REFA_CLK_DIV2_EN(1U)

#define S_NOMINAL_VPH_SEL    10
#define M_NOMINAL_VPH_SEL    0x3U
#define V_NOMINAL_VPH_SEL(x) ((x) << S_NOMINAL_VPH_SEL)
#define G_NOMINAL_VPH_SEL(x) (((x) >> S_NOMINAL_VPH_SEL) & M_NOMINAL_VPH_SEL)

#define S_NOMINAL_VP_SEL    8
#define M_NOMINAL_VP_SEL    0x3U
#define V_NOMINAL_VP_SEL(x) ((x) << S_NOMINAL_VP_SEL)
#define G_NOMINAL_VP_SEL(x) (((x) >> S_NOMINAL_VP_SEL) & M_NOMINAL_VP_SEL)

#define S_MPLLB_WORD_CLK_EN    7
#define V_MPLLB_WORD_CLK_EN(x) ((x) << S_MPLLB_WORD_CLK_EN)
#define F_MPLLB_WORD_CLK_EN    V_MPLLB_WORD_CLK_EN(1U)

#define S_MPLLB_SSC_EN    6
#define V_MPLLB_SSC_EN(x) ((x) << S_MPLLB_SSC_EN)
#define F_MPLLB_SSC_EN    V_MPLLB_SSC_EN(1U)

#define S_MPLLB_SHORT_LOCK_EN    5
#define V_MPLLB_SHORT_LOCK_EN(x) ((x) << S_MPLLB_SHORT_LOCK_EN)
#define F_MPLLB_SHORT_LOCK_EN    V_MPLLB_SHORT_LOCK_EN(1U)

#define S_MPLLB_FORCE_EN    4
#define V_MPLLB_FORCE_EN(x) ((x) << S_MPLLB_FORCE_EN)
#define F_MPLLB_FORCE_EN    V_MPLLB_FORCE_EN(1U)

#define S_MPLLA_WORD_CLK_EN    3
#define V_MPLLA_WORD_CLK_EN(x) ((x) << S_MPLLA_WORD_CLK_EN)
#define F_MPLLA_WORD_CLK_EN    V_MPLLA_WORD_CLK_EN(1U)

#define S_MPLLA_SSC_EN    2
#define V_MPLLA_SSC_EN(x) ((x) << S_MPLLA_SSC_EN)
#define F_MPLLA_SSC_EN    V_MPLLA_SSC_EN(1U)

#define S_MPLLA_SHORT_LOCK_EN    1
#define V_MPLLA_SHORT_LOCK_EN(x) ((x) << S_MPLLA_SHORT_LOCK_EN)
#define F_MPLLA_SHORT_LOCK_EN    V_MPLLA_SHORT_LOCK_EN(1U)

#define S_MPLLA_FORCE_EN    0
#define V_MPLLA_FORCE_EN(x) ((x) << S_MPLLA_FORCE_EN)
#define F_MPLLA_FORCE_EN    V_MPLLA_FORCE_EN(1U)

#define A_PCIE_SNPS_G5_PHY_1_VALUES 0x5fac

#define S_REF_ALT1_CLK_M    13
#define V_REF_ALT1_CLK_M(x) ((x) << S_REF_ALT1_CLK_M)
#define F_REF_ALT1_CLK_M    V_REF_ALT1_CLK_M(1U)

#define S_REF_ALT1_CLK_P    12
#define V_REF_ALT1_CLK_P(x) ((x) << S_REF_ALT1_CLK_P)
#define F_REF_ALT1_CLK_P    V_REF_ALT1_CLK_P(1U)

#define A_PCIE_SNPS_G5_PHY_2_VALUES 0x5fb0
#define A_PCIE_SNPS_G5_PHY_3_VALUES 0x5fb4
#define A_PCIE_SNPS_G5_PHY_0_RX_LANEPLL_BYPASS_MODE 0x5fb8

#define S_T7_LANE3    15
#define M_T7_LANE3    0x1fU
#define V_T7_LANE3(x) ((x) << S_T7_LANE3)
#define G_T7_LANE3(x) (((x) >> S_T7_LANE3) & M_T7_LANE3)

#define S_T7_LANE2    10
#define M_T7_LANE2    0x1fU
#define V_T7_LANE2(x) ((x) << S_T7_LANE2)
#define G_T7_LANE2(x) (((x) >> S_T7_LANE2) & M_T7_LANE2)

#define S_T7_LANE1    5
#define M_T7_LANE1    0x1fU
#define V_T7_LANE1(x) ((x) << S_T7_LANE1)
#define G_T7_LANE1(x) (((x) >> S_T7_LANE1) & M_T7_LANE1)

#define S_T7_LANE0    0
#define M_T7_LANE0    0x1fU
#define V_T7_LANE0(x) ((x) << S_T7_LANE0)
#define G_T7_LANE0(x) (((x) >> S_T7_LANE0) & M_T7_LANE0)

#define A_PCIE_SNPS_G5_PHY_1_RX_LANEPLL_BYPASS_MODE 0x5fbc
#define A_PCIE_SNPS_G5_PHY_2_RX_LANEPLL_BYPASS_MODE 0x5fc0
#define A_PCIE_SNPS_G5_PHY_3_RX_LANEPLL_BYPASS_MODE 0x5fc4
#define A_PCIE_SNPS_G5_PHY_0_1_RX_LANEPLL_SRC_SEL 0x5fc8

#define S_LANE7_LANEPLL_SRC_SEL    28
#define M_LANE7_LANEPLL_SRC_SEL    0xfU
#define V_LANE7_LANEPLL_SRC_SEL(x) ((x) << S_LANE7_LANEPLL_SRC_SEL)
#define G_LANE7_LANEPLL_SRC_SEL(x) (((x) >> S_LANE7_LANEPLL_SRC_SEL) & M_LANE7_LANEPLL_SRC_SEL)

#define S_LANE6_LANEPLL_SRC_SEL    24
#define M_LANE6_LANEPLL_SRC_SEL    0xfU
#define V_LANE6_LANEPLL_SRC_SEL(x) ((x) << S_LANE6_LANEPLL_SRC_SEL)
#define G_LANE6_LANEPLL_SRC_SEL(x) (((x) >> S_LANE6_LANEPLL_SRC_SEL) & M_LANE6_LANEPLL_SRC_SEL)

#define S_LANE5_LANEPLL_SRC_SEL    20
#define M_LANE5_LANEPLL_SRC_SEL    0xfU
#define V_LANE5_LANEPLL_SRC_SEL(x) ((x) << S_LANE5_LANEPLL_SRC_SEL)
#define G_LANE5_LANEPLL_SRC_SEL(x) (((x) >> S_LANE5_LANEPLL_SRC_SEL) & M_LANE5_LANEPLL_SRC_SEL)

#define S_LANE4_LANEPLL_SRC_SEL    16
#define M_LANE4_LANEPLL_SRC_SEL    0xfU
#define V_LANE4_LANEPLL_SRC_SEL(x) ((x) << S_LANE4_LANEPLL_SRC_SEL)
#define G_LANE4_LANEPLL_SRC_SEL(x) (((x) >> S_LANE4_LANEPLL_SRC_SEL) & M_LANE4_LANEPLL_SRC_SEL)

#define S_LANE3_LANEPLL_SRC_SEL    12
#define M_LANE3_LANEPLL_SRC_SEL    0xfU
#define V_LANE3_LANEPLL_SRC_SEL(x) ((x) << S_LANE3_LANEPLL_SRC_SEL)
#define G_LANE3_LANEPLL_SRC_SEL(x) (((x) >> S_LANE3_LANEPLL_SRC_SEL) & M_LANE3_LANEPLL_SRC_SEL)

#define S_LANE2_LANEPLL_SRC_SEL    8
#define M_LANE2_LANEPLL_SRC_SEL    0xfU
#define V_LANE2_LANEPLL_SRC_SEL(x) ((x) << S_LANE2_LANEPLL_SRC_SEL)
#define G_LANE2_LANEPLL_SRC_SEL(x) (((x) >> S_LANE2_LANEPLL_SRC_SEL) & M_LANE2_LANEPLL_SRC_SEL)

#define S_LANE1_LANEPLL_SRC_SEL    4
#define M_LANE1_LANEPLL_SRC_SEL    0xfU
#define V_LANE1_LANEPLL_SRC_SEL(x) ((x) << S_LANE1_LANEPLL_SRC_SEL)
#define G_LANE1_LANEPLL_SRC_SEL(x) (((x) >> S_LANE1_LANEPLL_SRC_SEL) & M_LANE1_LANEPLL_SRC_SEL)

#define S_LANE0_LANEPLL_SRC_SEL    0
#define M_LANE0_LANEPLL_SRC_SEL    0xfU
#define V_LANE0_LANEPLL_SRC_SEL(x) ((x) << S_LANE0_LANEPLL_SRC_SEL)
#define G_LANE0_LANEPLL_SRC_SEL(x) (((x) >> S_LANE0_LANEPLL_SRC_SEL) & M_LANE0_LANEPLL_SRC_SEL)

#define A_PCIE_SNPS_G5_PHY_2_3_RX_LANEPLL_SRC_SEL 0x5fcc
#define A_PCIE_SNPS_G5_PHY_RX_DECERR 0x5fd0

#define S_LANE15_REC_OVRD_8B10B_DECERR    30
#define M_LANE15_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE15_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE15_REC_OVRD_8B10B_DECERR)
#define G_LANE15_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE15_REC_OVRD_8B10B_DECERR) & M_LANE15_REC_OVRD_8B10B_DECERR)

#define S_LANE14_REC_OVRD_8B10B_DECERR    28
#define M_LANE14_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE14_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE14_REC_OVRD_8B10B_DECERR)
#define G_LANE14_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE14_REC_OVRD_8B10B_DECERR) & M_LANE14_REC_OVRD_8B10B_DECERR)

#define S_LANE13_REC_OVRD_8B10B_DECERR    26
#define M_LANE13_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE13_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE13_REC_OVRD_8B10B_DECERR)
#define G_LANE13_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE13_REC_OVRD_8B10B_DECERR) & M_LANE13_REC_OVRD_8B10B_DECERR)

#define S_LANE12_REC_OVRD_8B10B_DECERR    24
#define M_LANE12_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE12_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE12_REC_OVRD_8B10B_DECERR)
#define G_LANE12_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE12_REC_OVRD_8B10B_DECERR) & M_LANE12_REC_OVRD_8B10B_DECERR)

#define S_LANE11_REC_OVRD_8B10B_DECERR    22
#define M_LANE11_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE11_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE11_REC_OVRD_8B10B_DECERR)
#define G_LANE11_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE11_REC_OVRD_8B10B_DECERR) & M_LANE11_REC_OVRD_8B10B_DECERR)

#define S_LANE10_REC_OVRD_8B10B_DECERR    20
#define M_LANE10_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE10_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE10_REC_OVRD_8B10B_DECERR)
#define G_LANE10_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE10_REC_OVRD_8B10B_DECERR) & M_LANE10_REC_OVRD_8B10B_DECERR)

#define S_LANE9_REC_OVRD_8B10B_DECERR    18
#define M_LANE9_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE9_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE9_REC_OVRD_8B10B_DECERR)
#define G_LANE9_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE9_REC_OVRD_8B10B_DECERR) & M_LANE9_REC_OVRD_8B10B_DECERR)

#define S_LANE8_REC_OVRD_8B10B_DECERR    16
#define M_LANE8_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE8_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE8_REC_OVRD_8B10B_DECERR)
#define G_LANE8_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE8_REC_OVRD_8B10B_DECERR) & M_LANE8_REC_OVRD_8B10B_DECERR)

#define S_LANE7_REC_OVRD_8B10B_DECERR    14
#define M_LANE7_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE7_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE7_REC_OVRD_8B10B_DECERR)
#define G_LANE7_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE7_REC_OVRD_8B10B_DECERR) & M_LANE7_REC_OVRD_8B10B_DECERR)

#define S_LANE6_REC_OVRD_8B10B_DECERR    12
#define M_LANE6_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE6_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE6_REC_OVRD_8B10B_DECERR)
#define G_LANE6_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE6_REC_OVRD_8B10B_DECERR) & M_LANE6_REC_OVRD_8B10B_DECERR)

#define S_LANE5_REC_OVRD_8B10B_DECERR    10
#define M_LANE5_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE5_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE5_REC_OVRD_8B10B_DECERR)
#define G_LANE5_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE5_REC_OVRD_8B10B_DECERR) & M_LANE5_REC_OVRD_8B10B_DECERR)

#define S_LANE4_REC_OVRD_8B10B_DECERR    8
#define M_LANE4_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE4_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE4_REC_OVRD_8B10B_DECERR)
#define G_LANE4_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE4_REC_OVRD_8B10B_DECERR) & M_LANE4_REC_OVRD_8B10B_DECERR)

#define S_LANE3_REC_OVRD_8B10B_DECERR    6
#define M_LANE3_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE3_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE3_REC_OVRD_8B10B_DECERR)
#define G_LANE3_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE3_REC_OVRD_8B10B_DECERR) & M_LANE3_REC_OVRD_8B10B_DECERR)

#define S_LANE2_REC_OVRD_8B10B_DECERR    4
#define M_LANE2_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE2_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE2_REC_OVRD_8B10B_DECERR)
#define G_LANE2_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE2_REC_OVRD_8B10B_DECERR) & M_LANE2_REC_OVRD_8B10B_DECERR)

#define S_LANE1_REC_OVRD_8B10B_DECERR    2
#define M_LANE1_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE1_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE1_REC_OVRD_8B10B_DECERR)
#define G_LANE1_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE1_REC_OVRD_8B10B_DECERR) & M_LANE1_REC_OVRD_8B10B_DECERR)

#define S_LANE0_REC_OVRD_8B10B_DECERR    0
#define M_LANE0_REC_OVRD_8B10B_DECERR    0x3U
#define V_LANE0_REC_OVRD_8B10B_DECERR(x) ((x) << S_LANE0_REC_OVRD_8B10B_DECERR)
#define G_LANE0_REC_OVRD_8B10B_DECERR(x) (((x) >> S_LANE0_REC_OVRD_8B10B_DECERR) & M_LANE0_REC_OVRD_8B10B_DECERR)

#define A_PCIE_SNPS_G5_PHY_TX2RX_LOOPBK_REC_OVRD_EN 0x5fd4

#define S_LANE15_REC_OVRD_EN    31
#define V_LANE15_REC_OVRD_EN(x) ((x) << S_LANE15_REC_OVRD_EN)
#define F_LANE15_REC_OVRD_EN    V_LANE15_REC_OVRD_EN(1U)

#define S_LANE14_REC_OVRD_EN    30
#define V_LANE14_REC_OVRD_EN(x) ((x) << S_LANE14_REC_OVRD_EN)
#define F_LANE14_REC_OVRD_EN    V_LANE14_REC_OVRD_EN(1U)

#define S_LANE13_REC_OVRD_EN    29
#define V_LANE13_REC_OVRD_EN(x) ((x) << S_LANE13_REC_OVRD_EN)
#define F_LANE13_REC_OVRD_EN    V_LANE13_REC_OVRD_EN(1U)

#define S_LANE11_REC_OVRD_EN    27
#define V_LANE11_REC_OVRD_EN(x) ((x) << S_LANE11_REC_OVRD_EN)
#define F_LANE11_REC_OVRD_EN    V_LANE11_REC_OVRD_EN(1U)

#define S_LANE12_REC_OVRD_EN    28
#define V_LANE12_REC_OVRD_EN(x) ((x) << S_LANE12_REC_OVRD_EN)
#define F_LANE12_REC_OVRD_EN    V_LANE12_REC_OVRD_EN(1U)

#define S_LANE10_REC_OVRD_EN    26
#define V_LANE10_REC_OVRD_EN(x) ((x) << S_LANE10_REC_OVRD_EN)
#define F_LANE10_REC_OVRD_EN    V_LANE10_REC_OVRD_EN(1U)

#define S_LANE9_REC_OVRD_EN    25
#define V_LANE9_REC_OVRD_EN(x) ((x) << S_LANE9_REC_OVRD_EN)
#define F_LANE9_REC_OVRD_EN    V_LANE9_REC_OVRD_EN(1U)

#define S_LANE8_REC_OVRD_EN    24
#define V_LANE8_REC_OVRD_EN(x) ((x) << S_LANE8_REC_OVRD_EN)
#define F_LANE8_REC_OVRD_EN    V_LANE8_REC_OVRD_EN(1U)

#define S_LANE7_REC_OVRD_EN    23
#define V_LANE7_REC_OVRD_EN(x) ((x) << S_LANE7_REC_OVRD_EN)
#define F_LANE7_REC_OVRD_EN    V_LANE7_REC_OVRD_EN(1U)

#define S_LANE6_REC_OVRD_EN    22
#define V_LANE6_REC_OVRD_EN(x) ((x) << S_LANE6_REC_OVRD_EN)
#define F_LANE6_REC_OVRD_EN    V_LANE6_REC_OVRD_EN(1U)

#define S_LANE5_REC_OVRD_EN    21
#define V_LANE5_REC_OVRD_EN(x) ((x) << S_LANE5_REC_OVRD_EN)
#define F_LANE5_REC_OVRD_EN    V_LANE5_REC_OVRD_EN(1U)

#define S_LANE4_REC_OVRD_EN    20
#define V_LANE4_REC_OVRD_EN(x) ((x) << S_LANE4_REC_OVRD_EN)
#define F_LANE4_REC_OVRD_EN    V_LANE4_REC_OVRD_EN(1U)

#define S_LANE3_REC_OVRD_EN    19
#define V_LANE3_REC_OVRD_EN(x) ((x) << S_LANE3_REC_OVRD_EN)
#define F_LANE3_REC_OVRD_EN    V_LANE3_REC_OVRD_EN(1U)

#define S_LANE2_REC_OVRD_EN    18
#define V_LANE2_REC_OVRD_EN(x) ((x) << S_LANE2_REC_OVRD_EN)
#define F_LANE2_REC_OVRD_EN    V_LANE2_REC_OVRD_EN(1U)

#define S_LANE1_REC_OVRD_EN    17
#define V_LANE1_REC_OVRD_EN(x) ((x) << S_LANE1_REC_OVRD_EN)
#define F_LANE1_REC_OVRD_EN    V_LANE1_REC_OVRD_EN(1U)

#define S_LANE0_REC_OVRD_EN    16
#define V_LANE0_REC_OVRD_EN(x) ((x) << S_LANE0_REC_OVRD_EN)
#define F_LANE0_REC_OVRD_EN    V_LANE0_REC_OVRD_EN(1U)

#define S_LANE15_TX2RX_LOOPBK    15
#define V_LANE15_TX2RX_LOOPBK(x) ((x) << S_LANE15_TX2RX_LOOPBK)
#define F_LANE15_TX2RX_LOOPBK    V_LANE15_TX2RX_LOOPBK(1U)

#define S_LANE14_TX2RX_LOOPBK    14
#define V_LANE14_TX2RX_LOOPBK(x) ((x) << S_LANE14_TX2RX_LOOPBK)
#define F_LANE14_TX2RX_LOOPBK    V_LANE14_TX2RX_LOOPBK(1U)

#define S_LANE13_TX2RX_LOOPBK    13
#define V_LANE13_TX2RX_LOOPBK(x) ((x) << S_LANE13_TX2RX_LOOPBK)
#define F_LANE13_TX2RX_LOOPBK    V_LANE13_TX2RX_LOOPBK(1U)

#define S_LANE12_TX2RX_LOOPBK    12
#define V_LANE12_TX2RX_LOOPBK(x) ((x) << S_LANE12_TX2RX_LOOPBK)
#define F_LANE12_TX2RX_LOOPBK    V_LANE12_TX2RX_LOOPBK(1U)

#define S_LANE11_TX2RX_LOOPBK    11
#define V_LANE11_TX2RX_LOOPBK(x) ((x) << S_LANE11_TX2RX_LOOPBK)
#define F_LANE11_TX2RX_LOOPBK    V_LANE11_TX2RX_LOOPBK(1U)

#define S_LANE10_TX2RX_LOOPBK    10
#define V_LANE10_TX2RX_LOOPBK(x) ((x) << S_LANE10_TX2RX_LOOPBK)
#define F_LANE10_TX2RX_LOOPBK    V_LANE10_TX2RX_LOOPBK(1U)

#define S_LANE9_TX2RX_LOOPBK    9
#define V_LANE9_TX2RX_LOOPBK(x) ((x) << S_LANE9_TX2RX_LOOPBK)
#define F_LANE9_TX2RX_LOOPBK    V_LANE9_TX2RX_LOOPBK(1U)

#define S_LANE8_TX2RX_LOOPBK    8
#define V_LANE8_TX2RX_LOOPBK(x) ((x) << S_LANE8_TX2RX_LOOPBK)
#define F_LANE8_TX2RX_LOOPBK    V_LANE8_TX2RX_LOOPBK(1U)

#define S_LANE7_TX2RX_LOOPBK    7
#define V_LANE7_TX2RX_LOOPBK(x) ((x) << S_LANE7_TX2RX_LOOPBK)
#define F_LANE7_TX2RX_LOOPBK    V_LANE7_TX2RX_LOOPBK(1U)

#define S_LANE6_TX2RX_LOOPBK    6
#define V_LANE6_TX2RX_LOOPBK(x) ((x) << S_LANE6_TX2RX_LOOPBK)
#define F_LANE6_TX2RX_LOOPBK    V_LANE6_TX2RX_LOOPBK(1U)

#define S_LANE5_TX2RX_LOOPBK    5
#define V_LANE5_TX2RX_LOOPBK(x) ((x) << S_LANE5_TX2RX_LOOPBK)
#define F_LANE5_TX2RX_LOOPBK    V_LANE5_TX2RX_LOOPBK(1U)

#define S_LANE4_TX2RX_LOOPBK    4
#define V_LANE4_TX2RX_LOOPBK(x) ((x) << S_LANE4_TX2RX_LOOPBK)
#define F_LANE4_TX2RX_LOOPBK    V_LANE4_TX2RX_LOOPBK(1U)

#define S_LANE3_TX2RX_LOOPBK    3
#define V_LANE3_TX2RX_LOOPBK(x) ((x) << S_LANE3_TX2RX_LOOPBK)
#define F_LANE3_TX2RX_LOOPBK    V_LANE3_TX2RX_LOOPBK(1U)

#define S_LANE2_TX2RX_LOOPBK    2
#define V_LANE2_TX2RX_LOOPBK(x) ((x) << S_LANE2_TX2RX_LOOPBK)
#define F_LANE2_TX2RX_LOOPBK    V_LANE2_TX2RX_LOOPBK(1U)

#define S_LANE1_TX2RX_LOOPBK    1
#define V_LANE1_TX2RX_LOOPBK(x) ((x) << S_LANE1_TX2RX_LOOPBK)
#define F_LANE1_TX2RX_LOOPBK    V_LANE1_TX2RX_LOOPBK(1U)

#define S_LANE0_TX2RX_LOOPBK    0
#define V_LANE0_TX2RX_LOOPBK(x) ((x) << S_LANE0_TX2RX_LOOPBK)
#define F_LANE0_TX2RX_LOOPBK    V_LANE0_TX2RX_LOOPBK(1U)

#define A_PCIE_PHY_TX_DISABLE_UPCS_PIPE_CONFIG 0x5fd8

#define S_UPCS_PIPE_CONFIG    16
#define M_UPCS_PIPE_CONFIG    0xffffU
#define V_UPCS_PIPE_CONFIG(x) ((x) << S_UPCS_PIPE_CONFIG)
#define G_UPCS_PIPE_CONFIG(x) (((x) >> S_UPCS_PIPE_CONFIG) & M_UPCS_PIPE_CONFIG)

#define S_TX15_DISABLE    15
#define V_TX15_DISABLE(x) ((x) << S_TX15_DISABLE)
#define F_TX15_DISABLE    V_TX15_DISABLE(1U)

#define S_TX14_DISABLE    14
#define V_TX14_DISABLE(x) ((x) << S_TX14_DISABLE)
#define F_TX14_DISABLE    V_TX14_DISABLE(1U)

#define S_TX13_DISABLE    13
#define V_TX13_DISABLE(x) ((x) << S_TX13_DISABLE)
#define F_TX13_DISABLE    V_TX13_DISABLE(1U)

#define S_TX12_DISABLE    12
#define V_TX12_DISABLE(x) ((x) << S_TX12_DISABLE)
#define F_TX12_DISABLE    V_TX12_DISABLE(1U)

#define S_TX11_DISABLE    11
#define V_TX11_DISABLE(x) ((x) << S_TX11_DISABLE)
#define F_TX11_DISABLE    V_TX11_DISABLE(1U)

#define S_TX10_DISABLE    10
#define V_TX10_DISABLE(x) ((x) << S_TX10_DISABLE)
#define F_TX10_DISABLE    V_TX10_DISABLE(1U)

#define S_TX9_DISABLE    9
#define V_TX9_DISABLE(x) ((x) << S_TX9_DISABLE)
#define F_TX9_DISABLE    V_TX9_DISABLE(1U)

#define S_TX8_DISABLE    8
#define V_TX8_DISABLE(x) ((x) << S_TX8_DISABLE)
#define F_TX8_DISABLE    V_TX8_DISABLE(1U)

#define S_TX7_DISABLE    7
#define V_TX7_DISABLE(x) ((x) << S_TX7_DISABLE)
#define F_TX7_DISABLE    V_TX7_DISABLE(1U)

#define S_TX6_DISABLE    6
#define V_TX6_DISABLE(x) ((x) << S_TX6_DISABLE)
#define F_TX6_DISABLE    V_TX6_DISABLE(1U)

#define S_TX5_DISABLE    5
#define V_TX5_DISABLE(x) ((x) << S_TX5_DISABLE)
#define F_TX5_DISABLE    V_TX5_DISABLE(1U)

#define S_TX4_DISABLE    4
#define V_TX4_DISABLE(x) ((x) << S_TX4_DISABLE)
#define F_TX4_DISABLE    V_TX4_DISABLE(1U)

#define S_TX3_DISABLE    3
#define V_TX3_DISABLE(x) ((x) << S_TX3_DISABLE)
#define F_TX3_DISABLE    V_TX3_DISABLE(1U)

#define S_TX2_DISABLE    2
#define V_TX2_DISABLE(x) ((x) << S_TX2_DISABLE)
#define F_TX2_DISABLE    V_TX2_DISABLE(1U)

#define S_TX1_DISABLE    1
#define V_TX1_DISABLE(x) ((x) << S_TX1_DISABLE)
#define F_TX1_DISABLE    V_TX1_DISABLE(1U)

#define S_TX0_DISABLE    0
#define V_TX0_DISABLE(x) ((x) << S_TX0_DISABLE)
#define F_TX0_DISABLE    V_TX0_DISABLE(1U)

#define A_PCIE_PDEBUG_REG_0X0 0x0
#define A_PCIE_PDEBUG_REG_0X1 0x1
#define A_PCIE_PDEBUG_REG_0X2 0x2

#define S_TAGQ_CH0_TAGS_USED    11
#define M_TAGQ_CH0_TAGS_USED    0xffU
#define V_TAGQ_CH0_TAGS_USED(x) ((x) << S_TAGQ_CH0_TAGS_USED)
#define G_TAGQ_CH0_TAGS_USED(x) (((x) >> S_TAGQ_CH0_TAGS_USED) & M_TAGQ_CH0_TAGS_USED)

#define S_REQ_CH0_DATA_EMPTY    10
#define V_REQ_CH0_DATA_EMPTY(x) ((x) << S_REQ_CH0_DATA_EMPTY)
#define F_REQ_CH0_DATA_EMPTY    V_REQ_CH0_DATA_EMPTY(1U)

#define S_RDQ_CH0_REQ_EMPTY    9
#define V_RDQ_CH0_REQ_EMPTY(x) ((x) << S_RDQ_CH0_REQ_EMPTY)
#define F_RDQ_CH0_REQ_EMPTY    V_RDQ_CH0_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH0_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH0_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH0_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_CMD    V_REQ_CTL_RD_CH0_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH0_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH0_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH0_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH0_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH0_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH0_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH0_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH0_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH0_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH0_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH0_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH0_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH0_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH0_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH0_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH0_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH0_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH0_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH0_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH0_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH0_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X3 0x3

#define S_TAGQ_CH1_TAGS_USED    11
#define M_TAGQ_CH1_TAGS_USED    0xffU
#define V_TAGQ_CH1_TAGS_USED(x) ((x) << S_TAGQ_CH1_TAGS_USED)
#define G_TAGQ_CH1_TAGS_USED(x) (((x) >> S_TAGQ_CH1_TAGS_USED) & M_TAGQ_CH1_TAGS_USED)

#define S_REQ_CH1_DATA_EMPTY    10
#define V_REQ_CH1_DATA_EMPTY(x) ((x) << S_REQ_CH1_DATA_EMPTY)
#define F_REQ_CH1_DATA_EMPTY    V_REQ_CH1_DATA_EMPTY(1U)

#define S_RDQ_CH1_REQ_EMPTY    9
#define V_RDQ_CH1_REQ_EMPTY(x) ((x) << S_RDQ_CH1_REQ_EMPTY)
#define F_RDQ_CH1_REQ_EMPTY    V_RDQ_CH1_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH1_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH1_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH1_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_CMD    V_REQ_CTL_RD_CH1_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH1_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH1_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH1_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH1_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH1_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH1_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH1_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH1_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH1_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH1_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH1_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH1_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH1_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH1_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH1_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH1_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH1_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH1_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH1_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH1_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH1_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X4 0x4

#define S_TAGQ_CH2_TAGS_USED    11
#define M_TAGQ_CH2_TAGS_USED    0xffU
#define V_TAGQ_CH2_TAGS_USED(x) ((x) << S_TAGQ_CH2_TAGS_USED)
#define G_TAGQ_CH2_TAGS_USED(x) (((x) >> S_TAGQ_CH2_TAGS_USED) & M_TAGQ_CH2_TAGS_USED)

#define S_REQ_CH2_DATA_EMPTY    10
#define V_REQ_CH2_DATA_EMPTY(x) ((x) << S_REQ_CH2_DATA_EMPTY)
#define F_REQ_CH2_DATA_EMPTY    V_REQ_CH2_DATA_EMPTY(1U)

#define S_RDQ_CH2_REQ_EMPTY    9
#define V_RDQ_CH2_REQ_EMPTY(x) ((x) << S_RDQ_CH2_REQ_EMPTY)
#define F_RDQ_CH2_REQ_EMPTY    V_RDQ_CH2_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH2_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH2_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH2_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_CMD    V_REQ_CTL_RD_CH2_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH2_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH2_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH2_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH2_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH2_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH2_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH2_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH2_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH2_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH2_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH2_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH2_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH2_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH2_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH2_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH2_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH2_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH2_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH2_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH2_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH2_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X5 0x5

#define S_TAGQ_CH3_TAGS_USED    11
#define M_TAGQ_CH3_TAGS_USED    0xffU
#define V_TAGQ_CH3_TAGS_USED(x) ((x) << S_TAGQ_CH3_TAGS_USED)
#define G_TAGQ_CH3_TAGS_USED(x) (((x) >> S_TAGQ_CH3_TAGS_USED) & M_TAGQ_CH3_TAGS_USED)

#define S_REQ_CH3_DATA_EMPTY    10
#define V_REQ_CH3_DATA_EMPTY(x) ((x) << S_REQ_CH3_DATA_EMPTY)
#define F_REQ_CH3_DATA_EMPTY    V_REQ_CH3_DATA_EMPTY(1U)

#define S_RDQ_CH3_REQ_EMPTY    9
#define V_RDQ_CH3_REQ_EMPTY(x) ((x) << S_RDQ_CH3_REQ_EMPTY)
#define F_RDQ_CH3_REQ_EMPTY    V_RDQ_CH3_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH3_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH3_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH3_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_CMD    V_REQ_CTL_RD_CH3_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH3_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH3_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH3_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH3_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH3_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH3_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH3_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH3_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH3_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH3_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH3_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH3_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH3_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH3_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH3_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH3_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH3_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH3_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH3_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH3_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH3_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X6 0x6

#define S_TAGQ_CH4_TAGS_USED    11
#define M_TAGQ_CH4_TAGS_USED    0xffU
#define V_TAGQ_CH4_TAGS_USED(x) ((x) << S_TAGQ_CH4_TAGS_USED)
#define G_TAGQ_CH4_TAGS_USED(x) (((x) >> S_TAGQ_CH4_TAGS_USED) & M_TAGQ_CH4_TAGS_USED)

#define S_REQ_CH4_DATA_EMPTY    10
#define V_REQ_CH4_DATA_EMPTY(x) ((x) << S_REQ_CH4_DATA_EMPTY)
#define F_REQ_CH4_DATA_EMPTY    V_REQ_CH4_DATA_EMPTY(1U)

#define S_RDQ_CH4_REQ_EMPTY    9
#define V_RDQ_CH4_REQ_EMPTY(x) ((x) << S_RDQ_CH4_REQ_EMPTY)
#define F_RDQ_CH4_REQ_EMPTY    V_RDQ_CH4_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH4_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH4_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH4_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_CMD    V_REQ_CTL_RD_CH4_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH4_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH4_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH4_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH4_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH4_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH4_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH4_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH4_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH4_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH4_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH4_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH4_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH4_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH4_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH4_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH4_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH4_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH4_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH4_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH4_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH4_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X7 0x7

#define S_TAGQ_CH5_TAGS_USED    11
#define M_TAGQ_CH5_TAGS_USED    0xffU
#define V_TAGQ_CH5_TAGS_USED(x) ((x) << S_TAGQ_CH5_TAGS_USED)
#define G_TAGQ_CH5_TAGS_USED(x) (((x) >> S_TAGQ_CH5_TAGS_USED) & M_TAGQ_CH5_TAGS_USED)

#define S_REQ_CH5_DATA_EMPTY    10
#define V_REQ_CH5_DATA_EMPTY(x) ((x) << S_REQ_CH5_DATA_EMPTY)
#define F_REQ_CH5_DATA_EMPTY    V_REQ_CH5_DATA_EMPTY(1U)

#define S_RDQ_CH5_REQ_EMPTY    9
#define V_RDQ_CH5_REQ_EMPTY(x) ((x) << S_RDQ_CH5_REQ_EMPTY)
#define F_RDQ_CH5_REQ_EMPTY    V_RDQ_CH5_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH5_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH5_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH5_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_CMD    V_REQ_CTL_RD_CH5_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH5_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH5_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH5_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH5_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH5_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH5_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH5_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH5_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH5_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH5_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH5_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH5_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH5_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH5_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH5_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH5_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH5_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH5_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH5_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH5_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH5_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH5_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH5_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X8 0x8

#define S_TAGQ_CH6_TAGS_USED    11
#define M_TAGQ_CH6_TAGS_USED    0xffU
#define V_TAGQ_CH6_TAGS_USED(x) ((x) << S_TAGQ_CH6_TAGS_USED)
#define G_TAGQ_CH6_TAGS_USED(x) (((x) >> S_TAGQ_CH6_TAGS_USED) & M_TAGQ_CH6_TAGS_USED)

#define S_REQ_CH6_DATA_EMPTY    10
#define V_REQ_CH6_DATA_EMPTY(x) ((x) << S_REQ_CH6_DATA_EMPTY)
#define F_REQ_CH6_DATA_EMPTY    V_REQ_CH6_DATA_EMPTY(1U)

#define S_RDQ_CH6_REQ_EMPTY    9
#define V_RDQ_CH6_REQ_EMPTY(x) ((x) << S_RDQ_CH6_REQ_EMPTY)
#define F_RDQ_CH6_REQ_EMPTY    V_RDQ_CH6_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH6_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH6_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH6_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_CMD    V_REQ_CTL_RD_CH6_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH6_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH6_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH6_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH6_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH6_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH6_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH6_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH6_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH6_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH6_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH6_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH6_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH6_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH6_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH6_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH6_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH6_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH6_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH6_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH6_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH6_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH6_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH6_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0X9 0x9

#define S_TAGQ_CH7_TAGS_USED    11
#define M_TAGQ_CH7_TAGS_USED    0xffU
#define V_TAGQ_CH7_TAGS_USED(x) ((x) << S_TAGQ_CH7_TAGS_USED)
#define G_TAGQ_CH7_TAGS_USED(x) (((x) >> S_TAGQ_CH7_TAGS_USED) & M_TAGQ_CH7_TAGS_USED)

#define S_REQ_CH7_DATA_EMPTY    10
#define V_REQ_CH7_DATA_EMPTY(x) ((x) << S_REQ_CH7_DATA_EMPTY)
#define F_REQ_CH7_DATA_EMPTY    V_REQ_CH7_DATA_EMPTY(1U)

#define S_RDQ_CH7_REQ_EMPTY    9
#define V_RDQ_CH7_REQ_EMPTY(x) ((x) << S_RDQ_CH7_REQ_EMPTY)
#define F_RDQ_CH7_REQ_EMPTY    V_RDQ_CH7_REQ_EMPTY(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_TAGTQ    8
#define V_REQ_CTL_RD_CH7_WAIT_FOR_TAGTQ(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_TAGTQ)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_TAGTQ    V_REQ_CTL_RD_CH7_WAIT_FOR_TAGTQ(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_CMD    7
#define V_REQ_CTL_RD_CH7_WAIT_FOR_CMD(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_CMD)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_CMD    V_REQ_CTL_RD_CH7_WAIT_FOR_CMD(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_DATA_MEM    6
#define V_REQ_CTL_RD_CH7_WAIT_FOR_DATA_MEM(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_DATA_MEM)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_DATA_MEM    V_REQ_CTL_RD_CH7_WAIT_FOR_DATA_MEM(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_RDQ    5
#define V_REQ_CTL_RD_CH7_WAIT_FOR_RDQ(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_RDQ)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_RDQ    V_REQ_CTL_RD_CH7_WAIT_FOR_RDQ(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_TXN_DISABLE_FIFO    4
#define V_REQ_CTL_RD_CH7_WAIT_FOR_TXN_DISABLE_FIFO(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_TXN_DISABLE_FIFO)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_TXN_DISABLE_FIFO    V_REQ_CTL_RD_CH7_WAIT_FOR_TXN_DISABLE_FIFO(1U)

#define S_REQ_CTL_RD_CH7_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_RD_CH7_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH7_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_RD_CH7_EXIT_BOT_VLD_STARTED    V_REQ_CTL_RD_CH7_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH7_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_RD_CH7_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_RD_CH7_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_RD_CH7_EXIT_TOP_VLD_STARTED    V_REQ_CTL_RD_CH7_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_RD_CH7_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_PAUSE)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_PAUSE    V_REQ_CTL_RD_CH7_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_RD_CH7_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_RD_CH7_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_RD_CH7_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_RD_CH7_WAIT_FOR_FIFO_DATA    V_REQ_CTL_RD_CH7_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XA 0xa

#define S_REQ_CTL_RD_CH0_WAIT_FOR_SEQNUM    27
#define V_REQ_CTL_RD_CH0_WAIT_FOR_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH0_WAIT_FOR_SEQNUM)
#define F_REQ_CTL_RD_CH0_WAIT_FOR_SEQNUM    V_REQ_CTL_RD_CH0_WAIT_FOR_SEQNUM(1U)

#define S_REQ_CTL_WR_CH0_SEQNUM    19
#define M_REQ_CTL_WR_CH0_SEQNUM    0xffU
#define V_REQ_CTL_WR_CH0_SEQNUM(x) ((x) << S_REQ_CTL_WR_CH0_SEQNUM)
#define G_REQ_CTL_WR_CH0_SEQNUM(x) (((x) >> S_REQ_CTL_WR_CH0_SEQNUM) & M_REQ_CTL_WR_CH0_SEQNUM)

#define S_REQ_CTL_RD_CH0_SEQNUM    11
#define M_REQ_CTL_RD_CH0_SEQNUM    0xffU
#define V_REQ_CTL_RD_CH0_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH0_SEQNUM)
#define G_REQ_CTL_RD_CH0_SEQNUM(x) (((x) >> S_REQ_CTL_RD_CH0_SEQNUM) & M_REQ_CTL_RD_CH0_SEQNUM)

#define S_REQ_CTL_WR_CH0_WAIT_FOR_SI_FIFO    4
#define V_REQ_CTL_WR_CH0_WAIT_FOR_SI_FIFO(x) ((x) << S_REQ_CTL_WR_CH0_WAIT_FOR_SI_FIFO)
#define F_REQ_CTL_WR_CH0_WAIT_FOR_SI_FIFO    V_REQ_CTL_WR_CH0_WAIT_FOR_SI_FIFO(1U)

#define S_REQ_CTL_WR_CH0_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_WR_CH0_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH0_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_WR_CH0_EXIT_BOT_VLD_STARTED    V_REQ_CTL_WR_CH0_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH0_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_WR_CH0_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH0_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_WR_CH0_EXIT_TOP_VLD_STARTED    V_REQ_CTL_WR_CH0_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH0_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_WR_CH0_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_WR_CH0_WAIT_FOR_PAUSE)
#define F_REQ_CTL_WR_CH0_WAIT_FOR_PAUSE    V_REQ_CTL_WR_CH0_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_WR_CH0_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_WR_CH0_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_WR_CH0_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_WR_CH0_WAIT_FOR_FIFO_DATA    V_REQ_CTL_WR_CH0_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XB 0xb

#define S_REQ_CTL_RD_CH1_WAIT_FOR_SEQNUM    27
#define V_REQ_CTL_RD_CH1_WAIT_FOR_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH1_WAIT_FOR_SEQNUM)
#define F_REQ_CTL_RD_CH1_WAIT_FOR_SEQNUM    V_REQ_CTL_RD_CH1_WAIT_FOR_SEQNUM(1U)

#define S_REQ_CTL_WR_CH1_SEQNUM    19
#define M_REQ_CTL_WR_CH1_SEQNUM    0xffU
#define V_REQ_CTL_WR_CH1_SEQNUM(x) ((x) << S_REQ_CTL_WR_CH1_SEQNUM)
#define G_REQ_CTL_WR_CH1_SEQNUM(x) (((x) >> S_REQ_CTL_WR_CH1_SEQNUM) & M_REQ_CTL_WR_CH1_SEQNUM)

#define S_REQ_CTL_RD_CH1_SEQNUM    11
#define M_REQ_CTL_RD_CH1_SEQNUM    0xffU
#define V_REQ_CTL_RD_CH1_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH1_SEQNUM)
#define G_REQ_CTL_RD_CH1_SEQNUM(x) (((x) >> S_REQ_CTL_RD_CH1_SEQNUM) & M_REQ_CTL_RD_CH1_SEQNUM)

#define S_REQ_CTL_WR_CH1_WAIT_FOR_SI_FIFO    4
#define V_REQ_CTL_WR_CH1_WAIT_FOR_SI_FIFO(x) ((x) << S_REQ_CTL_WR_CH1_WAIT_FOR_SI_FIFO)
#define F_REQ_CTL_WR_CH1_WAIT_FOR_SI_FIFO    V_REQ_CTL_WR_CH1_WAIT_FOR_SI_FIFO(1U)

#define S_REQ_CTL_WR_CH1_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_WR_CH1_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH1_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_WR_CH1_EXIT_BOT_VLD_STARTED    V_REQ_CTL_WR_CH1_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH1_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_WR_CH1_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH1_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_WR_CH1_EXIT_TOP_VLD_STARTED    V_REQ_CTL_WR_CH1_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH1_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_WR_CH1_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_WR_CH1_WAIT_FOR_PAUSE)
#define F_REQ_CTL_WR_CH1_WAIT_FOR_PAUSE    V_REQ_CTL_WR_CH1_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_WR_CH1_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_WR_CH1_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_WR_CH1_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_WR_CH1_WAIT_FOR_FIFO_DATA    V_REQ_CTL_WR_CH1_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XC 0xc

#define S_REQ_CTL_RD_CH2_WAIT_FOR_SEQNUM    27
#define V_REQ_CTL_RD_CH2_WAIT_FOR_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH2_WAIT_FOR_SEQNUM)
#define F_REQ_CTL_RD_CH2_WAIT_FOR_SEQNUM    V_REQ_CTL_RD_CH2_WAIT_FOR_SEQNUM(1U)

#define S_REQ_CTL_WR_CH2_SEQNUM    19
#define M_REQ_CTL_WR_CH2_SEQNUM    0xffU
#define V_REQ_CTL_WR_CH2_SEQNUM(x) ((x) << S_REQ_CTL_WR_CH2_SEQNUM)
#define G_REQ_CTL_WR_CH2_SEQNUM(x) (((x) >> S_REQ_CTL_WR_CH2_SEQNUM) & M_REQ_CTL_WR_CH2_SEQNUM)

#define S_REQ_CTL_RD_CH2_SEQNUM    11
#define M_REQ_CTL_RD_CH2_SEQNUM    0xffU
#define V_REQ_CTL_RD_CH2_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH2_SEQNUM)
#define G_REQ_CTL_RD_CH2_SEQNUM(x) (((x) >> S_REQ_CTL_RD_CH2_SEQNUM) & M_REQ_CTL_RD_CH2_SEQNUM)

#define S_REQ_CTL_WR_CH2_WAIT_FOR_SI_FIFO    4
#define V_REQ_CTL_WR_CH2_WAIT_FOR_SI_FIFO(x) ((x) << S_REQ_CTL_WR_CH2_WAIT_FOR_SI_FIFO)
#define F_REQ_CTL_WR_CH2_WAIT_FOR_SI_FIFO    V_REQ_CTL_WR_CH2_WAIT_FOR_SI_FIFO(1U)

#define S_REQ_CTL_WR_CH2_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_WR_CH2_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH2_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_WR_CH2_EXIT_BOT_VLD_STARTED    V_REQ_CTL_WR_CH2_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH2_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_WR_CH2_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH2_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_WR_CH2_EXIT_TOP_VLD_STARTED    V_REQ_CTL_WR_CH2_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH2_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_WR_CH2_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_WR_CH2_WAIT_FOR_PAUSE)
#define F_REQ_CTL_WR_CH2_WAIT_FOR_PAUSE    V_REQ_CTL_WR_CH2_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_WR_CH2_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_WR_CH2_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_WR_CH2_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_WR_CH2_WAIT_FOR_FIFO_DATA    V_REQ_CTL_WR_CH2_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XD 0xd

#define S_REQ_CTL_RD_CH3_WAIT_FOR_SEQNUM    27
#define V_REQ_CTL_RD_CH3_WAIT_FOR_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH3_WAIT_FOR_SEQNUM)
#define F_REQ_CTL_RD_CH3_WAIT_FOR_SEQNUM    V_REQ_CTL_RD_CH3_WAIT_FOR_SEQNUM(1U)

#define S_REQ_CTL_WR_CH3_SEQNUM    19
#define M_REQ_CTL_WR_CH3_SEQNUM    0xffU
#define V_REQ_CTL_WR_CH3_SEQNUM(x) ((x) << S_REQ_CTL_WR_CH3_SEQNUM)
#define G_REQ_CTL_WR_CH3_SEQNUM(x) (((x) >> S_REQ_CTL_WR_CH3_SEQNUM) & M_REQ_CTL_WR_CH3_SEQNUM)

#define S_REQ_CTL_RD_CH3_SEQNUM    11
#define M_REQ_CTL_RD_CH3_SEQNUM    0xffU
#define V_REQ_CTL_RD_CH3_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH3_SEQNUM)
#define G_REQ_CTL_RD_CH3_SEQNUM(x) (((x) >> S_REQ_CTL_RD_CH3_SEQNUM) & M_REQ_CTL_RD_CH3_SEQNUM)

#define S_REQ_CTL_WR_CH3_WAIT_FOR_SI_FIFO    4
#define V_REQ_CTL_WR_CH3_WAIT_FOR_SI_FIFO(x) ((x) << S_REQ_CTL_WR_CH3_WAIT_FOR_SI_FIFO)
#define F_REQ_CTL_WR_CH3_WAIT_FOR_SI_FIFO    V_REQ_CTL_WR_CH3_WAIT_FOR_SI_FIFO(1U)

#define S_REQ_CTL_WR_CH3_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_WR_CH3_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH3_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_WR_CH3_EXIT_BOT_VLD_STARTED    V_REQ_CTL_WR_CH3_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH3_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_WR_CH3_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH3_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_WR_CH3_EXIT_TOP_VLD_STARTED    V_REQ_CTL_WR_CH3_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH3_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_WR_CH3_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_WR_CH3_WAIT_FOR_PAUSE)
#define F_REQ_CTL_WR_CH3_WAIT_FOR_PAUSE    V_REQ_CTL_WR_CH3_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_WR_CH3_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_WR_CH3_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_WR_CH3_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_WR_CH3_WAIT_FOR_FIFO_DATA    V_REQ_CTL_WR_CH3_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XE 0xe

#define S_REQ_CTL_RD_CH4_WAIT_FOR_SEQNUM    27
#define V_REQ_CTL_RD_CH4_WAIT_FOR_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH4_WAIT_FOR_SEQNUM)
#define F_REQ_CTL_RD_CH4_WAIT_FOR_SEQNUM    V_REQ_CTL_RD_CH4_WAIT_FOR_SEQNUM(1U)

#define S_REQ_CTL_WR_CH4_SEQNUM    19
#define M_REQ_CTL_WR_CH4_SEQNUM    0xffU
#define V_REQ_CTL_WR_CH4_SEQNUM(x) ((x) << S_REQ_CTL_WR_CH4_SEQNUM)
#define G_REQ_CTL_WR_CH4_SEQNUM(x) (((x) >> S_REQ_CTL_WR_CH4_SEQNUM) & M_REQ_CTL_WR_CH4_SEQNUM)

#define S_REQ_CTL_RD_CH4_SEQNUM    11
#define M_REQ_CTL_RD_CH4_SEQNUM    0xffU
#define V_REQ_CTL_RD_CH4_SEQNUM(x) ((x) << S_REQ_CTL_RD_CH4_SEQNUM)
#define G_REQ_CTL_RD_CH4_SEQNUM(x) (((x) >> S_REQ_CTL_RD_CH4_SEQNUM) & M_REQ_CTL_RD_CH4_SEQNUM)

#define S_REQ_CTL_WR_CH4_WAIT_FOR_SI_FIFO    4
#define V_REQ_CTL_WR_CH4_WAIT_FOR_SI_FIFO(x) ((x) << S_REQ_CTL_WR_CH4_WAIT_FOR_SI_FIFO)
#define F_REQ_CTL_WR_CH4_WAIT_FOR_SI_FIFO    V_REQ_CTL_WR_CH4_WAIT_FOR_SI_FIFO(1U)

#define S_REQ_CTL_WR_CH4_EXIT_BOT_VLD_STARTED    3
#define V_REQ_CTL_WR_CH4_EXIT_BOT_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH4_EXIT_BOT_VLD_STARTED)
#define F_REQ_CTL_WR_CH4_EXIT_BOT_VLD_STARTED    V_REQ_CTL_WR_CH4_EXIT_BOT_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH4_EXIT_TOP_VLD_STARTED    2
#define V_REQ_CTL_WR_CH4_EXIT_TOP_VLD_STARTED(x) ((x) << S_REQ_CTL_WR_CH4_EXIT_TOP_VLD_STARTED)
#define F_REQ_CTL_WR_CH4_EXIT_TOP_VLD_STARTED    V_REQ_CTL_WR_CH4_EXIT_TOP_VLD_STARTED(1U)

#define S_REQ_CTL_WR_CH4_WAIT_FOR_PAUSE    1
#define V_REQ_CTL_WR_CH4_WAIT_FOR_PAUSE(x) ((x) << S_REQ_CTL_WR_CH4_WAIT_FOR_PAUSE)
#define F_REQ_CTL_WR_CH4_WAIT_FOR_PAUSE    V_REQ_CTL_WR_CH4_WAIT_FOR_PAUSE(1U)

#define S_REQ_CTL_WR_CH4_WAIT_FOR_FIFO_DATA    0
#define V_REQ_CTL_WR_CH4_WAIT_FOR_FIFO_DATA(x) ((x) << S_REQ_CTL_WR_CH4_WAIT_FOR_FIFO_DATA)
#define F_REQ_CTL_WR_CH4_WAIT_FOR_FIFO_DATA    V_REQ_CTL_WR_CH4_WAIT_FOR_FIFO_DATA(1U)

#define A_PCIE_PDEBUG_REG_0XF 0xf
#define A_PCIE_PDEBUG_REG_0X10 0x10

#define S_PIPE0_TX3_DATAK_0    31
#define V_PIPE0_TX3_DATAK_0(x) ((x) << S_PIPE0_TX3_DATAK_0)
#define F_PIPE0_TX3_DATAK_0    V_PIPE0_TX3_DATAK_0(1U)

#define S_PIPE0_TX3_DATA_6_0    24
#define M_PIPE0_TX3_DATA_6_0    0x7fU
#define V_PIPE0_TX3_DATA_6_0(x) ((x) << S_PIPE0_TX3_DATA_6_0)
#define G_PIPE0_TX3_DATA_6_0(x) (((x) >> S_PIPE0_TX3_DATA_6_0) & M_PIPE0_TX3_DATA_6_0)

#define S_PIPE0_TX2_DATA_7_0    16
#define M_PIPE0_TX2_DATA_7_0    0xffU
#define V_PIPE0_TX2_DATA_7_0(x) ((x) << S_PIPE0_TX2_DATA_7_0)
#define G_PIPE0_TX2_DATA_7_0(x) (((x) >> S_PIPE0_TX2_DATA_7_0) & M_PIPE0_TX2_DATA_7_0)

#define S_PIPE0_TX1_DATA_7_0    8
#define M_PIPE0_TX1_DATA_7_0    0xffU
#define V_PIPE0_TX1_DATA_7_0(x) ((x) << S_PIPE0_TX1_DATA_7_0)
#define G_PIPE0_TX1_DATA_7_0(x) (((x) >> S_PIPE0_TX1_DATA_7_0) & M_PIPE0_TX1_DATA_7_0)

#define S_PIPE0_TX0_DATAK_0    7
#define V_PIPE0_TX0_DATAK_0(x) ((x) << S_PIPE0_TX0_DATAK_0)
#define F_PIPE0_TX0_DATAK_0    V_PIPE0_TX0_DATAK_0(1U)

#define S_PIPE0_TX0_DATA_6_0    0
#define M_PIPE0_TX0_DATA_6_0    0x7fU
#define V_PIPE0_TX0_DATA_6_0(x) ((x) << S_PIPE0_TX0_DATA_6_0)
#define G_PIPE0_TX0_DATA_6_0(x) (((x) >> S_PIPE0_TX0_DATA_6_0) & M_PIPE0_TX0_DATA_6_0)

#define A_PCIE_PDEBUG_REG_0X11 0x11

#define S_PIPE0_TX3_DATAK_1    31
#define V_PIPE0_TX3_DATAK_1(x) ((x) << S_PIPE0_TX3_DATAK_1)
#define F_PIPE0_TX3_DATAK_1    V_PIPE0_TX3_DATAK_1(1U)

#define S_PIPE0_TX3_DATA_14_8    24
#define M_PIPE0_TX3_DATA_14_8    0x7fU
#define V_PIPE0_TX3_DATA_14_8(x) ((x) << S_PIPE0_TX3_DATA_14_8)
#define G_PIPE0_TX3_DATA_14_8(x) (((x) >> S_PIPE0_TX3_DATA_14_8) & M_PIPE0_TX3_DATA_14_8)

#define S_PIPE0_TX2_DATA_15_8    16
#define M_PIPE0_TX2_DATA_15_8    0xffU
#define V_PIPE0_TX2_DATA_15_8(x) ((x) << S_PIPE0_TX2_DATA_15_8)
#define G_PIPE0_TX2_DATA_15_8(x) (((x) >> S_PIPE0_TX2_DATA_15_8) & M_PIPE0_TX2_DATA_15_8)

#define S_PIPE0_TX1_DATA_15_8    8
#define M_PIPE0_TX1_DATA_15_8    0xffU
#define V_PIPE0_TX1_DATA_15_8(x) ((x) << S_PIPE0_TX1_DATA_15_8)
#define G_PIPE0_TX1_DATA_15_8(x) (((x) >> S_PIPE0_TX1_DATA_15_8) & M_PIPE0_TX1_DATA_15_8)

#define S_PIPE0_TX0_DATAK_1    7
#define V_PIPE0_TX0_DATAK_1(x) ((x) << S_PIPE0_TX0_DATAK_1)
#define F_PIPE0_TX0_DATAK_1    V_PIPE0_TX0_DATAK_1(1U)

#define S_PIPE0_TX0_DATA_14_8    0
#define M_PIPE0_TX0_DATA_14_8    0x7fU
#define V_PIPE0_TX0_DATA_14_8(x) ((x) << S_PIPE0_TX0_DATA_14_8)
#define G_PIPE0_TX0_DATA_14_8(x) (((x) >> S_PIPE0_TX0_DATA_14_8) & M_PIPE0_TX0_DATA_14_8)

#define A_PCIE_PDEBUG_REG_0X12 0x12

#define S_PIPE0_TX7_DATAK_0    31
#define V_PIPE0_TX7_DATAK_0(x) ((x) << S_PIPE0_TX7_DATAK_0)
#define F_PIPE0_TX7_DATAK_0    V_PIPE0_TX7_DATAK_0(1U)

#define S_PIPE0_TX7_DATA_6_0    24
#define M_PIPE0_TX7_DATA_6_0    0x7fU
#define V_PIPE0_TX7_DATA_6_0(x) ((x) << S_PIPE0_TX7_DATA_6_0)
#define G_PIPE0_TX7_DATA_6_0(x) (((x) >> S_PIPE0_TX7_DATA_6_0) & M_PIPE0_TX7_DATA_6_0)

#define S_PIPE0_TX6_DATA_7_0    16
#define M_PIPE0_TX6_DATA_7_0    0xffU
#define V_PIPE0_TX6_DATA_7_0(x) ((x) << S_PIPE0_TX6_DATA_7_0)
#define G_PIPE0_TX6_DATA_7_0(x) (((x) >> S_PIPE0_TX6_DATA_7_0) & M_PIPE0_TX6_DATA_7_0)

#define S_PIPE0_TX5_DATA_7_0    8
#define M_PIPE0_TX5_DATA_7_0    0xffU
#define V_PIPE0_TX5_DATA_7_0(x) ((x) << S_PIPE0_TX5_DATA_7_0)
#define G_PIPE0_TX5_DATA_7_0(x) (((x) >> S_PIPE0_TX5_DATA_7_0) & M_PIPE0_TX5_DATA_7_0)

#define S_PIPE0_TX4_DATAK_0    7
#define V_PIPE0_TX4_DATAK_0(x) ((x) << S_PIPE0_TX4_DATAK_0)
#define F_PIPE0_TX4_DATAK_0    V_PIPE0_TX4_DATAK_0(1U)

#define S_PIPE0_TX4_DATA_6_0    0
#define M_PIPE0_TX4_DATA_6_0    0x7fU
#define V_PIPE0_TX4_DATA_6_0(x) ((x) << S_PIPE0_TX4_DATA_6_0)
#define G_PIPE0_TX4_DATA_6_0(x) (((x) >> S_PIPE0_TX4_DATA_6_0) & M_PIPE0_TX4_DATA_6_0)

#define A_PCIE_PDEBUG_REG_0X13 0x13

#define S_PIPE0_TX7_DATAK_1    31
#define V_PIPE0_TX7_DATAK_1(x) ((x) << S_PIPE0_TX7_DATAK_1)
#define F_PIPE0_TX7_DATAK_1    V_PIPE0_TX7_DATAK_1(1U)

#define S_PIPE0_TX7_DATA_14_8    24
#define M_PIPE0_TX7_DATA_14_8    0x7fU
#define V_PIPE0_TX7_DATA_14_8(x) ((x) << S_PIPE0_TX7_DATA_14_8)
#define G_PIPE0_TX7_DATA_14_8(x) (((x) >> S_PIPE0_TX7_DATA_14_8) & M_PIPE0_TX7_DATA_14_8)

#define S_PIPE0_TX6_DATA_15_8    16
#define M_PIPE0_TX6_DATA_15_8    0xffU
#define V_PIPE0_TX6_DATA_15_8(x) ((x) << S_PIPE0_TX6_DATA_15_8)
#define G_PIPE0_TX6_DATA_15_8(x) (((x) >> S_PIPE0_TX6_DATA_15_8) & M_PIPE0_TX6_DATA_15_8)

#define S_PIPE0_TX5_DATA_15_8    8
#define M_PIPE0_TX5_DATA_15_8    0xffU
#define V_PIPE0_TX5_DATA_15_8(x) ((x) << S_PIPE0_TX5_DATA_15_8)
#define G_PIPE0_TX5_DATA_15_8(x) (((x) >> S_PIPE0_TX5_DATA_15_8) & M_PIPE0_TX5_DATA_15_8)

#define S_PIPE0_TX4_DATAK_1    7
#define V_PIPE0_TX4_DATAK_1(x) ((x) << S_PIPE0_TX4_DATAK_1)
#define F_PIPE0_TX4_DATAK_1    V_PIPE0_TX4_DATAK_1(1U)

#define S_PIPE0_TX4_DATA_14_8    0
#define M_PIPE0_TX4_DATA_14_8    0x7fU
#define V_PIPE0_TX4_DATA_14_8(x) ((x) << S_PIPE0_TX4_DATA_14_8)
#define G_PIPE0_TX4_DATA_14_8(x) (((x) >> S_PIPE0_TX4_DATA_14_8) & M_PIPE0_TX4_DATA_14_8)

#define A_PCIE_PDEBUG_REG_0X14 0x14

#define S_PIPE0_RX3_VALID_14    31
#define V_PIPE0_RX3_VALID_14(x) ((x) << S_PIPE0_RX3_VALID_14)
#define F_PIPE0_RX3_VALID_14    V_PIPE0_RX3_VALID_14(1U)

#define S_PIPE0_RX3_VALID2_14    24
#define M_PIPE0_RX3_VALID2_14    0x7fU
#define V_PIPE0_RX3_VALID2_14(x) ((x) << S_PIPE0_RX3_VALID2_14)
#define G_PIPE0_RX3_VALID2_14(x) (((x) >> S_PIPE0_RX3_VALID2_14) & M_PIPE0_RX3_VALID2_14)

#define S_PIPE0_RX2_VALID_14    16
#define M_PIPE0_RX2_VALID_14    0xffU
#define V_PIPE0_RX2_VALID_14(x) ((x) << S_PIPE0_RX2_VALID_14)
#define G_PIPE0_RX2_VALID_14(x) (((x) >> S_PIPE0_RX2_VALID_14) & M_PIPE0_RX2_VALID_14)

#define S_PIPE0_RX1_VALID_14    8
#define M_PIPE0_RX1_VALID_14    0xffU
#define V_PIPE0_RX1_VALID_14(x) ((x) << S_PIPE0_RX1_VALID_14)
#define G_PIPE0_RX1_VALID_14(x) (((x) >> S_PIPE0_RX1_VALID_14) & M_PIPE0_RX1_VALID_14)

#define S_PIPE0_RX0_VALID_14    7
#define V_PIPE0_RX0_VALID_14(x) ((x) << S_PIPE0_RX0_VALID_14)
#define F_PIPE0_RX0_VALID_14    V_PIPE0_RX0_VALID_14(1U)

#define S_PIPE0_RX0_VALID2_14    0
#define M_PIPE0_RX0_VALID2_14    0x7fU
#define V_PIPE0_RX0_VALID2_14(x) ((x) << S_PIPE0_RX0_VALID2_14)
#define G_PIPE0_RX0_VALID2_14(x) (((x) >> S_PIPE0_RX0_VALID2_14) & M_PIPE0_RX0_VALID2_14)

#define A_PCIE_PDEBUG_REG_0X15 0x15

#define S_PIPE0_RX3_VALID_15    31
#define V_PIPE0_RX3_VALID_15(x) ((x) << S_PIPE0_RX3_VALID_15)
#define F_PIPE0_RX3_VALID_15    V_PIPE0_RX3_VALID_15(1U)

#define S_PIPE0_RX3_VALID2_15    24
#define M_PIPE0_RX3_VALID2_15    0x7fU
#define V_PIPE0_RX3_VALID2_15(x) ((x) << S_PIPE0_RX3_VALID2_15)
#define G_PIPE0_RX3_VALID2_15(x) (((x) >> S_PIPE0_RX3_VALID2_15) & M_PIPE0_RX3_VALID2_15)

#define S_PIPE0_RX2_VALID_15    16
#define M_PIPE0_RX2_VALID_15    0xffU
#define V_PIPE0_RX2_VALID_15(x) ((x) << S_PIPE0_RX2_VALID_15)
#define G_PIPE0_RX2_VALID_15(x) (((x) >> S_PIPE0_RX2_VALID_15) & M_PIPE0_RX2_VALID_15)

#define S_PIPE0_RX1_VALID_15    8
#define M_PIPE0_RX1_VALID_15    0xffU
#define V_PIPE0_RX1_VALID_15(x) ((x) << S_PIPE0_RX1_VALID_15)
#define G_PIPE0_RX1_VALID_15(x) (((x) >> S_PIPE0_RX1_VALID_15) & M_PIPE0_RX1_VALID_15)

#define S_PIPE0_RX0_VALID_15    7
#define V_PIPE0_RX0_VALID_15(x) ((x) << S_PIPE0_RX0_VALID_15)
#define F_PIPE0_RX0_VALID_15    V_PIPE0_RX0_VALID_15(1U)

#define S_PIPE0_RX0_VALID2_15    0
#define M_PIPE0_RX0_VALID2_15    0x7fU
#define V_PIPE0_RX0_VALID2_15(x) ((x) << S_PIPE0_RX0_VALID2_15)
#define G_PIPE0_RX0_VALID2_15(x) (((x) >> S_PIPE0_RX0_VALID2_15) & M_PIPE0_RX0_VALID2_15)

#define A_PCIE_PDEBUG_REG_0X16 0x16

#define S_PIPE0_RX7_VALID_16    31
#define V_PIPE0_RX7_VALID_16(x) ((x) << S_PIPE0_RX7_VALID_16)
#define F_PIPE0_RX7_VALID_16    V_PIPE0_RX7_VALID_16(1U)

#define S_PIPE0_RX7_VALID2_16    24
#define M_PIPE0_RX7_VALID2_16    0x7fU
#define V_PIPE0_RX7_VALID2_16(x) ((x) << S_PIPE0_RX7_VALID2_16)
#define G_PIPE0_RX7_VALID2_16(x) (((x) >> S_PIPE0_RX7_VALID2_16) & M_PIPE0_RX7_VALID2_16)

#define S_PIPE0_RX6_VALID_16    16
#define M_PIPE0_RX6_VALID_16    0xffU
#define V_PIPE0_RX6_VALID_16(x) ((x) << S_PIPE0_RX6_VALID_16)
#define G_PIPE0_RX6_VALID_16(x) (((x) >> S_PIPE0_RX6_VALID_16) & M_PIPE0_RX6_VALID_16)

#define S_PIPE0_RX5_VALID_16    8
#define M_PIPE0_RX5_VALID_16    0xffU
#define V_PIPE0_RX5_VALID_16(x) ((x) << S_PIPE0_RX5_VALID_16)
#define G_PIPE0_RX5_VALID_16(x) (((x) >> S_PIPE0_RX5_VALID_16) & M_PIPE0_RX5_VALID_16)

#define S_PIPE0_RX4_VALID_16    7
#define V_PIPE0_RX4_VALID_16(x) ((x) << S_PIPE0_RX4_VALID_16)
#define F_PIPE0_RX4_VALID_16    V_PIPE0_RX4_VALID_16(1U)

#define S_PIPE0_RX4_VALID2_16    0
#define M_PIPE0_RX4_VALID2_16    0x7fU
#define V_PIPE0_RX4_VALID2_16(x) ((x) << S_PIPE0_RX4_VALID2_16)
#define G_PIPE0_RX4_VALID2_16(x) (((x) >> S_PIPE0_RX4_VALID2_16) & M_PIPE0_RX4_VALID2_16)

#define A_PCIE_PDEBUG_REG_0X17 0x17

#define S_PIPE0_RX7_VALID_17    31
#define V_PIPE0_RX7_VALID_17(x) ((x) << S_PIPE0_RX7_VALID_17)
#define F_PIPE0_RX7_VALID_17    V_PIPE0_RX7_VALID_17(1U)

#define S_PIPE0_RX7_VALID2_17    24
#define M_PIPE0_RX7_VALID2_17    0x7fU
#define V_PIPE0_RX7_VALID2_17(x) ((x) << S_PIPE0_RX7_VALID2_17)
#define G_PIPE0_RX7_VALID2_17(x) (((x) >> S_PIPE0_RX7_VALID2_17) & M_PIPE0_RX7_VALID2_17)

#define S_PIPE0_RX6_VALID_17    16
#define M_PIPE0_RX6_VALID_17    0xffU
#define V_PIPE0_RX6_VALID_17(x) ((x) << S_PIPE0_RX6_VALID_17)
#define G_PIPE0_RX6_VALID_17(x) (((x) >> S_PIPE0_RX6_VALID_17) & M_PIPE0_RX6_VALID_17)

#define S_PIPE0_RX5_VALID_17    8
#define M_PIPE0_RX5_VALID_17    0xffU
#define V_PIPE0_RX5_VALID_17(x) ((x) << S_PIPE0_RX5_VALID_17)
#define G_PIPE0_RX5_VALID_17(x) (((x) >> S_PIPE0_RX5_VALID_17) & M_PIPE0_RX5_VALID_17)

#define S_PIPE0_RX4_VALID_17    7
#define V_PIPE0_RX4_VALID_17(x) ((x) << S_PIPE0_RX4_VALID_17)
#define F_PIPE0_RX4_VALID_17    V_PIPE0_RX4_VALID_17(1U)

#define S_PIPE0_RX4_VALID2_17    0
#define M_PIPE0_RX4_VALID2_17    0x7fU
#define V_PIPE0_RX4_VALID2_17(x) ((x) << S_PIPE0_RX4_VALID2_17)
#define G_PIPE0_RX4_VALID2_17(x) (((x) >> S_PIPE0_RX4_VALID2_17) & M_PIPE0_RX4_VALID2_17)

#define A_PCIE_PDEBUG_REG_0X18 0x18

#define S_PIPE0_RX7_POLARITY    31
#define V_PIPE0_RX7_POLARITY(x) ((x) << S_PIPE0_RX7_POLARITY)
#define F_PIPE0_RX7_POLARITY    V_PIPE0_RX7_POLARITY(1U)

#define S_PIPE0_RX7_STATUS    28
#define M_PIPE0_RX7_STATUS    0x7U
#define V_PIPE0_RX7_STATUS(x) ((x) << S_PIPE0_RX7_STATUS)
#define G_PIPE0_RX7_STATUS(x) (((x) >> S_PIPE0_RX7_STATUS) & M_PIPE0_RX7_STATUS)

#define S_PIPE0_RX6_POLARITY    27
#define V_PIPE0_RX6_POLARITY(x) ((x) << S_PIPE0_RX6_POLARITY)
#define F_PIPE0_RX6_POLARITY    V_PIPE0_RX6_POLARITY(1U)

#define S_PIPE0_RX6_STATUS    24
#define M_PIPE0_RX6_STATUS    0x7U
#define V_PIPE0_RX6_STATUS(x) ((x) << S_PIPE0_RX6_STATUS)
#define G_PIPE0_RX6_STATUS(x) (((x) >> S_PIPE0_RX6_STATUS) & M_PIPE0_RX6_STATUS)

#define S_PIPE0_RX5_POLARITY    23
#define V_PIPE0_RX5_POLARITY(x) ((x) << S_PIPE0_RX5_POLARITY)
#define F_PIPE0_RX5_POLARITY    V_PIPE0_RX5_POLARITY(1U)

#define S_PIPE0_RX5_STATUS    20
#define M_PIPE0_RX5_STATUS    0x7U
#define V_PIPE0_RX5_STATUS(x) ((x) << S_PIPE0_RX5_STATUS)
#define G_PIPE0_RX5_STATUS(x) (((x) >> S_PIPE0_RX5_STATUS) & M_PIPE0_RX5_STATUS)

#define S_PIPE0_RX4_POLARITY    19
#define V_PIPE0_RX4_POLARITY(x) ((x) << S_PIPE0_RX4_POLARITY)
#define F_PIPE0_RX4_POLARITY    V_PIPE0_RX4_POLARITY(1U)

#define S_PIPE0_RX4_STATUS    16
#define M_PIPE0_RX4_STATUS    0x7U
#define V_PIPE0_RX4_STATUS(x) ((x) << S_PIPE0_RX4_STATUS)
#define G_PIPE0_RX4_STATUS(x) (((x) >> S_PIPE0_RX4_STATUS) & M_PIPE0_RX4_STATUS)

#define S_PIPE0_RX3_POLARITY    15
#define V_PIPE0_RX3_POLARITY(x) ((x) << S_PIPE0_RX3_POLARITY)
#define F_PIPE0_RX3_POLARITY    V_PIPE0_RX3_POLARITY(1U)

#define S_PIPE0_RX3_STATUS    12
#define M_PIPE0_RX3_STATUS    0x7U
#define V_PIPE0_RX3_STATUS(x) ((x) << S_PIPE0_RX3_STATUS)
#define G_PIPE0_RX3_STATUS(x) (((x) >> S_PIPE0_RX3_STATUS) & M_PIPE0_RX3_STATUS)

#define S_PIPE0_RX2_POLARITY    11
#define V_PIPE0_RX2_POLARITY(x) ((x) << S_PIPE0_RX2_POLARITY)
#define F_PIPE0_RX2_POLARITY    V_PIPE0_RX2_POLARITY(1U)

#define S_PIPE0_RX2_STATUS    8
#define M_PIPE0_RX2_STATUS    0x7U
#define V_PIPE0_RX2_STATUS(x) ((x) << S_PIPE0_RX2_STATUS)
#define G_PIPE0_RX2_STATUS(x) (((x) >> S_PIPE0_RX2_STATUS) & M_PIPE0_RX2_STATUS)

#define S_PIPE0_RX1_POLARITY    7
#define V_PIPE0_RX1_POLARITY(x) ((x) << S_PIPE0_RX1_POLARITY)
#define F_PIPE0_RX1_POLARITY    V_PIPE0_RX1_POLARITY(1U)

#define S_PIPE0_RX1_STATUS    4
#define M_PIPE0_RX1_STATUS    0x7U
#define V_PIPE0_RX1_STATUS(x) ((x) << S_PIPE0_RX1_STATUS)
#define G_PIPE0_RX1_STATUS(x) (((x) >> S_PIPE0_RX1_STATUS) & M_PIPE0_RX1_STATUS)

#define S_PIPE0_RX0_POLARITY    3
#define V_PIPE0_RX0_POLARITY(x) ((x) << S_PIPE0_RX0_POLARITY)
#define F_PIPE0_RX0_POLARITY    V_PIPE0_RX0_POLARITY(1U)

#define S_PIPE0_RX0_STATUS    0
#define M_PIPE0_RX0_STATUS    0x7U
#define V_PIPE0_RX0_STATUS(x) ((x) << S_PIPE0_RX0_STATUS)
#define G_PIPE0_RX0_STATUS(x) (((x) >> S_PIPE0_RX0_STATUS) & M_PIPE0_RX0_STATUS)

#define A_PCIE_PDEBUG_REG_0X19 0x19

#define S_PIPE0_TX7_COMPLIANCE    31
#define V_PIPE0_TX7_COMPLIANCE(x) ((x) << S_PIPE0_TX7_COMPLIANCE)
#define F_PIPE0_TX7_COMPLIANCE    V_PIPE0_TX7_COMPLIANCE(1U)

#define S_PIPE0_TX6_COMPLIANCE    30
#define V_PIPE0_TX6_COMPLIANCE(x) ((x) << S_PIPE0_TX6_COMPLIANCE)
#define F_PIPE0_TX6_COMPLIANCE    V_PIPE0_TX6_COMPLIANCE(1U)

#define S_PIPE0_TX5_COMPLIANCE    29
#define V_PIPE0_TX5_COMPLIANCE(x) ((x) << S_PIPE0_TX5_COMPLIANCE)
#define F_PIPE0_TX5_COMPLIANCE    V_PIPE0_TX5_COMPLIANCE(1U)

#define S_PIPE0_TX4_COMPLIANCE    28
#define V_PIPE0_TX4_COMPLIANCE(x) ((x) << S_PIPE0_TX4_COMPLIANCE)
#define F_PIPE0_TX4_COMPLIANCE    V_PIPE0_TX4_COMPLIANCE(1U)

#define S_PIPE0_TX3_COMPLIANCE    27
#define V_PIPE0_TX3_COMPLIANCE(x) ((x) << S_PIPE0_TX3_COMPLIANCE)
#define F_PIPE0_TX3_COMPLIANCE    V_PIPE0_TX3_COMPLIANCE(1U)

#define S_PIPE0_TX2_COMPLIANCE    26
#define V_PIPE0_TX2_COMPLIANCE(x) ((x) << S_PIPE0_TX2_COMPLIANCE)
#define F_PIPE0_TX2_COMPLIANCE    V_PIPE0_TX2_COMPLIANCE(1U)

#define S_PIPE0_TX1_COMPLIANCE    25
#define V_PIPE0_TX1_COMPLIANCE(x) ((x) << S_PIPE0_TX1_COMPLIANCE)
#define F_PIPE0_TX1_COMPLIANCE    V_PIPE0_TX1_COMPLIANCE(1U)

#define S_PIPE0_TX0_COMPLIANCE    24
#define V_PIPE0_TX0_COMPLIANCE(x) ((x) << S_PIPE0_TX0_COMPLIANCE)
#define F_PIPE0_TX0_COMPLIANCE    V_PIPE0_TX0_COMPLIANCE(1U)

#define S_PIPE0_TX7_ELECIDLE    23
#define V_PIPE0_TX7_ELECIDLE(x) ((x) << S_PIPE0_TX7_ELECIDLE)
#define F_PIPE0_TX7_ELECIDLE    V_PIPE0_TX7_ELECIDLE(1U)

#define S_PIPE0_TX6_ELECIDLE    22
#define V_PIPE0_TX6_ELECIDLE(x) ((x) << S_PIPE0_TX6_ELECIDLE)
#define F_PIPE0_TX6_ELECIDLE    V_PIPE0_TX6_ELECIDLE(1U)

#define S_PIPE0_TX5_ELECIDLE    21
#define V_PIPE0_TX5_ELECIDLE(x) ((x) << S_PIPE0_TX5_ELECIDLE)
#define F_PIPE0_TX5_ELECIDLE    V_PIPE0_TX5_ELECIDLE(1U)

#define S_PIPE0_TX4_ELECIDLE    20
#define V_PIPE0_TX4_ELECIDLE(x) ((x) << S_PIPE0_TX4_ELECIDLE)
#define F_PIPE0_TX4_ELECIDLE    V_PIPE0_TX4_ELECIDLE(1U)

#define S_PIPE0_TX3_ELECIDLE    19
#define V_PIPE0_TX3_ELECIDLE(x) ((x) << S_PIPE0_TX3_ELECIDLE)
#define F_PIPE0_TX3_ELECIDLE    V_PIPE0_TX3_ELECIDLE(1U)

#define S_PIPE0_TX2_ELECIDLE    18
#define V_PIPE0_TX2_ELECIDLE(x) ((x) << S_PIPE0_TX2_ELECIDLE)
#define F_PIPE0_TX2_ELECIDLE    V_PIPE0_TX2_ELECIDLE(1U)

#define S_PIPE0_TX1_ELECIDLE    17
#define V_PIPE0_TX1_ELECIDLE(x) ((x) << S_PIPE0_TX1_ELECIDLE)
#define F_PIPE0_TX1_ELECIDLE    V_PIPE0_TX1_ELECIDLE(1U)

#define S_PIPE0_TX0_ELECIDLE    16
#define V_PIPE0_TX0_ELECIDLE(x) ((x) << S_PIPE0_TX0_ELECIDLE)
#define F_PIPE0_TX0_ELECIDLE    V_PIPE0_TX0_ELECIDLE(1U)

#define S_PIPE0_RX7_POLARITY_19    15
#define V_PIPE0_RX7_POLARITY_19(x) ((x) << S_PIPE0_RX7_POLARITY_19)
#define F_PIPE0_RX7_POLARITY_19    V_PIPE0_RX7_POLARITY_19(1U)

#define S_PIPE0_RX6_POLARITY_19    14
#define V_PIPE0_RX6_POLARITY_19(x) ((x) << S_PIPE0_RX6_POLARITY_19)
#define F_PIPE0_RX6_POLARITY_19    V_PIPE0_RX6_POLARITY_19(1U)

#define S_PIPE0_RX5_POLARITY_19    13
#define V_PIPE0_RX5_POLARITY_19(x) ((x) << S_PIPE0_RX5_POLARITY_19)
#define F_PIPE0_RX5_POLARITY_19    V_PIPE0_RX5_POLARITY_19(1U)

#define S_PIPE0_RX4_POLARITY_19    12
#define V_PIPE0_RX4_POLARITY_19(x) ((x) << S_PIPE0_RX4_POLARITY_19)
#define F_PIPE0_RX4_POLARITY_19    V_PIPE0_RX4_POLARITY_19(1U)

#define S_PIPE0_RX3_POLARITY_19    11
#define V_PIPE0_RX3_POLARITY_19(x) ((x) << S_PIPE0_RX3_POLARITY_19)
#define F_PIPE0_RX3_POLARITY_19    V_PIPE0_RX3_POLARITY_19(1U)

#define S_PIPE0_RX2_POLARITY_19    10
#define V_PIPE0_RX2_POLARITY_19(x) ((x) << S_PIPE0_RX2_POLARITY_19)
#define F_PIPE0_RX2_POLARITY_19    V_PIPE0_RX2_POLARITY_19(1U)

#define S_PIPE0_RX1_POLARITY_19    9
#define V_PIPE0_RX1_POLARITY_19(x) ((x) << S_PIPE0_RX1_POLARITY_19)
#define F_PIPE0_RX1_POLARITY_19    V_PIPE0_RX1_POLARITY_19(1U)

#define S_PIPE0_RX0_POLARITY_19    8
#define V_PIPE0_RX0_POLARITY_19(x) ((x) << S_PIPE0_RX0_POLARITY_19)
#define F_PIPE0_RX0_POLARITY_19    V_PIPE0_RX0_POLARITY_19(1U)

#define S_PIPE0_RX7_ELECIDLE    7
#define V_PIPE0_RX7_ELECIDLE(x) ((x) << S_PIPE0_RX7_ELECIDLE)
#define F_PIPE0_RX7_ELECIDLE    V_PIPE0_RX7_ELECIDLE(1U)

#define S_PIPE0_RX6_ELECIDLE    6
#define V_PIPE0_RX6_ELECIDLE(x) ((x) << S_PIPE0_RX6_ELECIDLE)
#define F_PIPE0_RX6_ELECIDLE    V_PIPE0_RX6_ELECIDLE(1U)

#define S_PIPE0_RX5_ELECIDLE    5
#define V_PIPE0_RX5_ELECIDLE(x) ((x) << S_PIPE0_RX5_ELECIDLE)
#define F_PIPE0_RX5_ELECIDLE    V_PIPE0_RX5_ELECIDLE(1U)

#define S_PIPE0_RX4_ELECIDLE    4
#define V_PIPE0_RX4_ELECIDLE(x) ((x) << S_PIPE0_RX4_ELECIDLE)
#define F_PIPE0_RX4_ELECIDLE    V_PIPE0_RX4_ELECIDLE(1U)

#define S_PIPE0_RX3_ELECIDLE    3
#define V_PIPE0_RX3_ELECIDLE(x) ((x) << S_PIPE0_RX3_ELECIDLE)
#define F_PIPE0_RX3_ELECIDLE    V_PIPE0_RX3_ELECIDLE(1U)

#define S_PIPE0_RX2_ELECIDLE    2
#define V_PIPE0_RX2_ELECIDLE(x) ((x) << S_PIPE0_RX2_ELECIDLE)
#define F_PIPE0_RX2_ELECIDLE    V_PIPE0_RX2_ELECIDLE(1U)

#define S_PIPE0_RX1_ELECIDLE    1
#define V_PIPE0_RX1_ELECIDLE(x) ((x) << S_PIPE0_RX1_ELECIDLE)
#define F_PIPE0_RX1_ELECIDLE    V_PIPE0_RX1_ELECIDLE(1U)

#define S_PIPE0_RX0_ELECIDLE    0
#define V_PIPE0_RX0_ELECIDLE(x) ((x) << S_PIPE0_RX0_ELECIDLE)
#define F_PIPE0_RX0_ELECIDLE    V_PIPE0_RX0_ELECIDLE(1U)

#define A_PCIE_PDEBUG_REG_0X1A 0x1a

#define S_PIPE0_RESET_N    21
#define V_PIPE0_RESET_N(x) ((x) << S_PIPE0_RESET_N)
#define F_PIPE0_RESET_N    V_PIPE0_RESET_N(1U)

#define S_PCS_COMMON_CLOCKS    20
#define V_PCS_COMMON_CLOCKS(x) ((x) << S_PCS_COMMON_CLOCKS)
#define F_PCS_COMMON_CLOCKS    V_PCS_COMMON_CLOCKS(1U)

#define S_PCS_CLK_REQ    19
#define V_PCS_CLK_REQ(x) ((x) << S_PCS_CLK_REQ)
#define F_PCS_CLK_REQ    V_PCS_CLK_REQ(1U)

#define S_PIPE_CLKREQ_N    18
#define V_PIPE_CLKREQ_N(x) ((x) << S_PIPE_CLKREQ_N)
#define F_PIPE_CLKREQ_N    V_PIPE_CLKREQ_N(1U)

#define S_MAC_CLKREQ_N_TO_MUX    17
#define V_MAC_CLKREQ_N_TO_MUX(x) ((x) << S_MAC_CLKREQ_N_TO_MUX)
#define F_MAC_CLKREQ_N_TO_MUX    V_MAC_CLKREQ_N_TO_MUX(1U)

#define S_PIPE0_TX2RX_LOOPBK    16
#define V_PIPE0_TX2RX_LOOPBK(x) ((x) << S_PIPE0_TX2RX_LOOPBK)
#define F_PIPE0_TX2RX_LOOPBK    V_PIPE0_TX2RX_LOOPBK(1U)

#define S_PIPE0_TX_SWING    15
#define V_PIPE0_TX_SWING(x) ((x) << S_PIPE0_TX_SWING)
#define F_PIPE0_TX_SWING    V_PIPE0_TX_SWING(1U)

#define S_PIPE0_TX_MARGIN    12
#define M_PIPE0_TX_MARGIN    0x7U
#define V_PIPE0_TX_MARGIN(x) ((x) << S_PIPE0_TX_MARGIN)
#define G_PIPE0_TX_MARGIN(x) (((x) >> S_PIPE0_TX_MARGIN) & M_PIPE0_TX_MARGIN)

#define S_PIPE0_TX_DEEMPH    11
#define V_PIPE0_TX_DEEMPH(x) ((x) << S_PIPE0_TX_DEEMPH)
#define F_PIPE0_TX_DEEMPH    V_PIPE0_TX_DEEMPH(1U)

#define S_PIPE0_TX_DETECTRX    10
#define V_PIPE0_TX_DETECTRX(x) ((x) << S_PIPE0_TX_DETECTRX)
#define F_PIPE0_TX_DETECTRX    V_PIPE0_TX_DETECTRX(1U)

#define S_PIPE0_POWERDOWN    8
#define M_PIPE0_POWERDOWN    0x3U
#define V_PIPE0_POWERDOWN(x) ((x) << S_PIPE0_POWERDOWN)
#define G_PIPE0_POWERDOWN(x) (((x) >> S_PIPE0_POWERDOWN) & M_PIPE0_POWERDOWN)

#define S_PHY_MAC_PHYSTATUS    0
#define M_PHY_MAC_PHYSTATUS    0xffU
#define V_PHY_MAC_PHYSTATUS(x) ((x) << S_PHY_MAC_PHYSTATUS)
#define G_PHY_MAC_PHYSTATUS(x) (((x) >> S_PHY_MAC_PHYSTATUS) & M_PHY_MAC_PHYSTATUS)

#define A_PCIE_PDEBUG_REG_0X1B 0x1b

#define S_PIPE0_RX7_EQ_IN_PROG    31
#define V_PIPE0_RX7_EQ_IN_PROG(x) ((x) << S_PIPE0_RX7_EQ_IN_PROG)
#define F_PIPE0_RX7_EQ_IN_PROG    V_PIPE0_RX7_EQ_IN_PROG(1U)

#define S_PIPE0_RX7_EQ_INVLD_REQ    30
#define V_PIPE0_RX7_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX7_EQ_INVLD_REQ)
#define F_PIPE0_RX7_EQ_INVLD_REQ    V_PIPE0_RX7_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX7_SYNCHEADER    28
#define M_PIPE0_RX7_SYNCHEADER    0x3U
#define V_PIPE0_RX7_SYNCHEADER(x) ((x) << S_PIPE0_RX7_SYNCHEADER)
#define G_PIPE0_RX7_SYNCHEADER(x) (((x) >> S_PIPE0_RX7_SYNCHEADER) & M_PIPE0_RX7_SYNCHEADER)

#define S_PIPE0_RX6_EQ_IN_PROG    27
#define V_PIPE0_RX6_EQ_IN_PROG(x) ((x) << S_PIPE0_RX6_EQ_IN_PROG)
#define F_PIPE0_RX6_EQ_IN_PROG    V_PIPE0_RX6_EQ_IN_PROG(1U)

#define S_PIPE0_RX6_EQ_INVLD_REQ    26
#define V_PIPE0_RX6_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX6_EQ_INVLD_REQ)
#define F_PIPE0_RX6_EQ_INVLD_REQ    V_PIPE0_RX6_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX6_SYNCHEADER    24
#define M_PIPE0_RX6_SYNCHEADER    0x3U
#define V_PIPE0_RX6_SYNCHEADER(x) ((x) << S_PIPE0_RX6_SYNCHEADER)
#define G_PIPE0_RX6_SYNCHEADER(x) (((x) >> S_PIPE0_RX6_SYNCHEADER) & M_PIPE0_RX6_SYNCHEADER)

#define S_PIPE0_RX5_EQ_IN_PROG    23
#define V_PIPE0_RX5_EQ_IN_PROG(x) ((x) << S_PIPE0_RX5_EQ_IN_PROG)
#define F_PIPE0_RX5_EQ_IN_PROG    V_PIPE0_RX5_EQ_IN_PROG(1U)

#define S_PIPE0_RX5_EQ_INVLD_REQ    22
#define V_PIPE0_RX5_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX5_EQ_INVLD_REQ)
#define F_PIPE0_RX5_EQ_INVLD_REQ    V_PIPE0_RX5_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX5_SYNCHEADER    20
#define M_PIPE0_RX5_SYNCHEADER    0x3U
#define V_PIPE0_RX5_SYNCHEADER(x) ((x) << S_PIPE0_RX5_SYNCHEADER)
#define G_PIPE0_RX5_SYNCHEADER(x) (((x) >> S_PIPE0_RX5_SYNCHEADER) & M_PIPE0_RX5_SYNCHEADER)

#define S_PIPE0_RX4_EQ_IN_PROG    19
#define V_PIPE0_RX4_EQ_IN_PROG(x) ((x) << S_PIPE0_RX4_EQ_IN_PROG)
#define F_PIPE0_RX4_EQ_IN_PROG    V_PIPE0_RX4_EQ_IN_PROG(1U)

#define S_PIPE0_RX4_EQ_INVLD_REQ    18
#define V_PIPE0_RX4_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX4_EQ_INVLD_REQ)
#define F_PIPE0_RX4_EQ_INVLD_REQ    V_PIPE0_RX4_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX4_SYNCHEADER    16
#define M_PIPE0_RX4_SYNCHEADER    0x3U
#define V_PIPE0_RX4_SYNCHEADER(x) ((x) << S_PIPE0_RX4_SYNCHEADER)
#define G_PIPE0_RX4_SYNCHEADER(x) (((x) >> S_PIPE0_RX4_SYNCHEADER) & M_PIPE0_RX4_SYNCHEADER)

#define S_PIPE0_RX3_EQ_IN_PROG    15
#define V_PIPE0_RX3_EQ_IN_PROG(x) ((x) << S_PIPE0_RX3_EQ_IN_PROG)
#define F_PIPE0_RX3_EQ_IN_PROG    V_PIPE0_RX3_EQ_IN_PROG(1U)

#define S_PIPE0_RX3_EQ_INVLD_REQ    14
#define V_PIPE0_RX3_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX3_EQ_INVLD_REQ)
#define F_PIPE0_RX3_EQ_INVLD_REQ    V_PIPE0_RX3_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX3_SYNCHEADER    12
#define M_PIPE0_RX3_SYNCHEADER    0x3U
#define V_PIPE0_RX3_SYNCHEADER(x) ((x) << S_PIPE0_RX3_SYNCHEADER)
#define G_PIPE0_RX3_SYNCHEADER(x) (((x) >> S_PIPE0_RX3_SYNCHEADER) & M_PIPE0_RX3_SYNCHEADER)

#define S_PIPE0_RX2_EQ_IN_PROG    11
#define V_PIPE0_RX2_EQ_IN_PROG(x) ((x) << S_PIPE0_RX2_EQ_IN_PROG)
#define F_PIPE0_RX2_EQ_IN_PROG    V_PIPE0_RX2_EQ_IN_PROG(1U)

#define S_PIPE0_RX2_EQ_INVLD_REQ    10
#define V_PIPE0_RX2_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX2_EQ_INVLD_REQ)
#define F_PIPE0_RX2_EQ_INVLD_REQ    V_PIPE0_RX2_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX2_SYNCHEADER    8
#define M_PIPE0_RX2_SYNCHEADER    0x3U
#define V_PIPE0_RX2_SYNCHEADER(x) ((x) << S_PIPE0_RX2_SYNCHEADER)
#define G_PIPE0_RX2_SYNCHEADER(x) (((x) >> S_PIPE0_RX2_SYNCHEADER) & M_PIPE0_RX2_SYNCHEADER)

#define S_PIPE0_RX1_EQ_IN_PROG    7
#define V_PIPE0_RX1_EQ_IN_PROG(x) ((x) << S_PIPE0_RX1_EQ_IN_PROG)
#define F_PIPE0_RX1_EQ_IN_PROG    V_PIPE0_RX1_EQ_IN_PROG(1U)

#define S_PIPE0_RX1_EQ_INVLD_REQ    6
#define V_PIPE0_RX1_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX1_EQ_INVLD_REQ)
#define F_PIPE0_RX1_EQ_INVLD_REQ    V_PIPE0_RX1_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX1_SYNCHEADER    4
#define M_PIPE0_RX1_SYNCHEADER    0x3U
#define V_PIPE0_RX1_SYNCHEADER(x) ((x) << S_PIPE0_RX1_SYNCHEADER)
#define G_PIPE0_RX1_SYNCHEADER(x) (((x) >> S_PIPE0_RX1_SYNCHEADER) & M_PIPE0_RX1_SYNCHEADER)

#define S_PIPE0_RX0_EQ_IN_PROG    3
#define V_PIPE0_RX0_EQ_IN_PROG(x) ((x) << S_PIPE0_RX0_EQ_IN_PROG)
#define F_PIPE0_RX0_EQ_IN_PROG    V_PIPE0_RX0_EQ_IN_PROG(1U)

#define S_PIPE0_RX0_EQ_INVLD_REQ    2
#define V_PIPE0_RX0_EQ_INVLD_REQ(x) ((x) << S_PIPE0_RX0_EQ_INVLD_REQ)
#define F_PIPE0_RX0_EQ_INVLD_REQ    V_PIPE0_RX0_EQ_INVLD_REQ(1U)

#define S_PIPE0_RX0_SYNCHEADER    0
#define M_PIPE0_RX0_SYNCHEADER    0x3U
#define V_PIPE0_RX0_SYNCHEADER(x) ((x) << S_PIPE0_RX0_SYNCHEADER)
#define G_PIPE0_RX0_SYNCHEADER(x) (((x) >> S_PIPE0_RX0_SYNCHEADER) & M_PIPE0_RX0_SYNCHEADER)

#define A_PCIE_PDEBUG_REG_0X1C 0x1c

#define S_SI_REQVFID    24
#define M_SI_REQVFID    0xffU
#define V_SI_REQVFID(x) ((x) << S_SI_REQVFID)
#define G_SI_REQVFID(x) (((x) >> S_SI_REQVFID) & M_SI_REQVFID)

#define S_SI_REQVEC    13
#define M_SI_REQVEC    0x7ffU
#define V_SI_REQVEC(x) ((x) << S_SI_REQVEC)
#define G_SI_REQVEC(x) (((x) >> S_SI_REQVEC) & M_SI_REQVEC)

#define S_SI_REQTCVAL    10
#define M_SI_REQTCVAL    0x7U
#define V_SI_REQTCVAL(x) ((x) << S_SI_REQTCVAL)
#define G_SI_REQTCVAL(x) (((x) >> S_SI_REQTCVAL) & M_SI_REQTCVAL)

#define S_SI_REQRDY    9
#define V_SI_REQRDY(x) ((x) << S_SI_REQRDY)
#define F_SI_REQRDY    V_SI_REQRDY(1U)

#define S_SI_REQVLD    8
#define V_SI_REQVLD(x) ((x) << S_SI_REQVLD)
#define F_SI_REQVLD    V_SI_REQVLD(1U)

#define S_T5_AI    0
#define M_T5_AI    0xffU
#define V_T5_AI(x) ((x) << S_T5_AI)
#define G_T5_AI(x) (((x) >> S_T5_AI) & M_T5_AI)

#define A_PCIE_PDEBUG_REG_0X1D 0x1d

#define S_GNTSI    31
#define V_GNTSI(x) ((x) << S_GNTSI)
#define F_GNTSI    V_GNTSI(1U)

#define S_DROPINTFORFLR    30
#define V_DROPINTFORFLR(x) ((x) << S_DROPINTFORFLR)
#define F_DROPINTFORFLR    V_DROPINTFORFLR(1U)

#define S_SMARB    27
#define M_SMARB    0x7U
#define V_SMARB(x) ((x) << S_SMARB)
#define G_SMARB(x) (((x) >> S_SMARB) & M_SMARB)

#define S_SMDEFR    24
#define M_SMDEFR    0x7U
#define V_SMDEFR(x) ((x) << S_SMDEFR)
#define G_SMDEFR(x) (((x) >> S_SMDEFR) & M_SMDEFR)

#define S_SYS_INT    16
#define M_SYS_INT    0xffU
#define V_SYS_INT(x) ((x) << S_SYS_INT)
#define G_SYS_INT(x) (((x) >> S_SYS_INT) & M_SYS_INT)

#define S_CFG_INTXCLR    8
#define M_CFG_INTXCLR    0xffU
#define V_CFG_INTXCLR(x) ((x) << S_CFG_INTXCLR)
#define G_CFG_INTXCLR(x) (((x) >> S_CFG_INTXCLR) & M_CFG_INTXCLR)

#define S_PIO_INTXCLR    0
#define M_PIO_INTXCLR    0xffU
#define V_PIO_INTXCLR(x) ((x) << S_PIO_INTXCLR)
#define G_PIO_INTXCLR(x) (((x) >> S_PIO_INTXCLR) & M_PIO_INTXCLR)

#define A_PCIE_PDEBUG_REG_0X1E 0x1e

#define S_PLI_TABDATWREN    31
#define V_PLI_TABDATWREN(x) ((x) << S_PLI_TABDATWREN)
#define F_PLI_TABDATWREN    V_PLI_TABDATWREN(1U)

#define S_TAB_RDENA    30
#define V_TAB_RDENA(x) ((x) << S_TAB_RDENA)
#define F_TAB_RDENA    V_TAB_RDENA(1U)

#define S_TAB_RDENA2    19
#define M_TAB_RDENA2    0x7ffU
#define V_TAB_RDENA2(x) ((x) << S_TAB_RDENA2)
#define G_TAB_RDENA2(x) (((x) >> S_TAB_RDENA2) & M_TAB_RDENA2)

#define S_PLI_REQADDR    10
#define M_PLI_REQADDR    0x1ffU
#define V_PLI_REQADDR(x) ((x) << S_PLI_REQADDR)
#define G_PLI_REQADDR(x) (((x) >> S_PLI_REQADDR) & M_PLI_REQADDR)

#define S_PLI_REQVFID    2
#define M_PLI_REQVFID    0xffU
#define V_PLI_REQVFID(x) ((x) << S_PLI_REQVFID)
#define G_PLI_REQVFID(x) (((x) >> S_PLI_REQVFID) & M_PLI_REQVFID)

#define S_PLI_REQTABHIT    1
#define V_PLI_REQTABHIT(x) ((x) << S_PLI_REQTABHIT)
#define F_PLI_REQTABHIT    V_PLI_REQTABHIT(1U)

#define S_PLI_REQRDVLD    0
#define V_PLI_REQRDVLD(x) ((x) << S_PLI_REQRDVLD)
#define F_PLI_REQRDVLD    V_PLI_REQRDVLD(1U)

#define A_PCIE_PDEBUG_REG_0X1F 0x1f
#define A_PCIE_PDEBUG_REG_0X20 0x20
#define A_PCIE_PDEBUG_REG_0X21 0x21

#define S_PLI_REQPBASTART    20
#define M_PLI_REQPBASTART    0xfffU
#define V_PLI_REQPBASTART(x) ((x) << S_PLI_REQPBASTART)
#define G_PLI_REQPBASTART(x) (((x) >> S_PLI_REQPBASTART) & M_PLI_REQPBASTART)

#define S_PLI_REQPBAEND    9
#define M_PLI_REQPBAEND    0x7ffU
#define V_PLI_REQPBAEND(x) ((x) << S_PLI_REQPBAEND)
#define G_PLI_REQPBAEND(x) (((x) >> S_PLI_REQPBAEND) & M_PLI_REQPBAEND)

#define S_T5_PLI_REQVFID    2
#define M_T5_PLI_REQVFID    0x7fU
#define V_T5_PLI_REQVFID(x) ((x) << S_T5_PLI_REQVFID)
#define G_T5_PLI_REQVFID(x) (((x) >> S_T5_PLI_REQVFID) & M_T5_PLI_REQVFID)

#define S_PLI_REQPBAHIT    1
#define V_PLI_REQPBAHIT(x) ((x) << S_PLI_REQPBAHIT)
#define F_PLI_REQPBAHIT    V_PLI_REQPBAHIT(1U)

#define A_PCIE_PDEBUG_REG_0X22 0x22

#define S_GNTSI1    31
#define V_GNTSI1(x) ((x) << S_GNTSI1)
#define F_GNTSI1    V_GNTSI1(1U)

#define S_GNTSI2    30
#define V_GNTSI2(x) ((x) << S_GNTSI2)
#define F_GNTSI2    V_GNTSI2(1U)

#define S_GNTSI3    27
#define M_GNTSI3    0x7U
#define V_GNTSI3(x) ((x) << S_GNTSI3)
#define G_GNTSI3(x) (((x) >> S_GNTSI3) & M_GNTSI3)

#define S_GNTSI4    16
#define M_GNTSI4    0x7ffU
#define V_GNTSI4(x) ((x) << S_GNTSI4)
#define G_GNTSI4(x) (((x) >> S_GNTSI4) & M_GNTSI4)

#define S_GNTSI5    8
#define M_GNTSI5    0xffU
#define V_GNTSI5(x) ((x) << S_GNTSI5)
#define G_GNTSI5(x) (((x) >> S_GNTSI5) & M_GNTSI5)

#define S_GNTSI6    7
#define V_GNTSI6(x) ((x) << S_GNTSI6)
#define F_GNTSI6    V_GNTSI6(1U)

#define S_GNTSI7    6
#define V_GNTSI7(x) ((x) << S_GNTSI7)
#define F_GNTSI7    V_GNTSI7(1U)

#define S_GNTSI8    5
#define V_GNTSI8(x) ((x) << S_GNTSI8)
#define F_GNTSI8    V_GNTSI8(1U)

#define S_GNTSI9    4
#define V_GNTSI9(x) ((x) << S_GNTSI9)
#define F_GNTSI9    V_GNTSI9(1U)

#define S_GNTSIA    3
#define V_GNTSIA(x) ((x) << S_GNTSIA)
#define F_GNTSIA    V_GNTSIA(1U)

#define S_GNTAI    2
#define V_GNTAI(x) ((x) << S_GNTAI)
#define F_GNTAI    V_GNTAI(1U)

#define S_GNTDB    1
#define V_GNTDB(x) ((x) << S_GNTDB)
#define F_GNTDB    V_GNTDB(1U)

#define S_GNTDI    0
#define V_GNTDI(x) ((x) << S_GNTDI)
#define F_GNTDI    V_GNTDI(1U)

#define A_PCIE_PDEBUG_REG_0X23 0x23

#define S_DI_REQVLD    31
#define V_DI_REQVLD(x) ((x) << S_DI_REQVLD)
#define F_DI_REQVLD    V_DI_REQVLD(1U)

#define S_DI_REQRDY    30
#define V_DI_REQRDY(x) ((x) << S_DI_REQRDY)
#define F_DI_REQRDY    V_DI_REQRDY(1U)

#define S_DI_REQWREN    19
#define M_DI_REQWREN    0x7ffU
#define V_DI_REQWREN(x) ((x) << S_DI_REQWREN)
#define G_DI_REQWREN(x) (((x) >> S_DI_REQWREN) & M_DI_REQWREN)

#define S_DI_REQMSIEN    18
#define V_DI_REQMSIEN(x) ((x) << S_DI_REQMSIEN)
#define F_DI_REQMSIEN    V_DI_REQMSIEN(1U)

#define S_DI_REQMSXEN    17
#define V_DI_REQMSXEN(x) ((x) << S_DI_REQMSXEN)
#define F_DI_REQMSXEN    V_DI_REQMSXEN(1U)

#define S_DI_REQMSXVFIDMSK    16
#define V_DI_REQMSXVFIDMSK(x) ((x) << S_DI_REQMSXVFIDMSK)
#define F_DI_REQMSXVFIDMSK    V_DI_REQMSXVFIDMSK(1U)

#define S_DI_REQWREN2    2
#define M_DI_REQWREN2    0x3fffU
#define V_DI_REQWREN2(x) ((x) << S_DI_REQWREN2)
#define G_DI_REQWREN2(x) (((x) >> S_DI_REQWREN2) & M_DI_REQWREN2)

#define S_DI_REQRDEN    1
#define V_DI_REQRDEN(x) ((x) << S_DI_REQRDEN)
#define F_DI_REQRDEN    V_DI_REQRDEN(1U)

#define S_DI_REQWREN3    0
#define V_DI_REQWREN3(x) ((x) << S_DI_REQWREN3)
#define F_DI_REQWREN3    V_DI_REQWREN3(1U)

#define A_PCIE_PDEBUG_REG_0X24 0x24
#define A_PCIE_PDEBUG_REG_0X25 0x25
#define A_PCIE_PDEBUG_REG_0X26 0x26
#define A_PCIE_PDEBUG_REG_0X27 0x27

#define S_FID_STI_RSPVLD    31
#define V_FID_STI_RSPVLD(x) ((x) << S_FID_STI_RSPVLD)
#define F_FID_STI_RSPVLD    V_FID_STI_RSPVLD(1U)

#define S_TAB_STIRDENA    30
#define V_TAB_STIRDENA(x) ((x) << S_TAB_STIRDENA)
#define F_TAB_STIRDENA    V_TAB_STIRDENA(1U)

#define S_TAB_STIWRENA    29
#define V_TAB_STIWRENA(x) ((x) << S_TAB_STIWRENA)
#define F_TAB_STIWRENA    V_TAB_STIWRENA(1U)

#define S_TAB_STIRDENA2    18
#define M_TAB_STIRDENA2    0x7ffU
#define V_TAB_STIRDENA2(x) ((x) << S_TAB_STIRDENA2)
#define G_TAB_STIRDENA2(x) (((x) >> S_TAB_STIRDENA2) & M_TAB_STIRDENA2)

#define S_T5_PLI_REQTABHIT    7
#define M_T5_PLI_REQTABHIT    0x7ffU
#define V_T5_PLI_REQTABHIT(x) ((x) << S_T5_PLI_REQTABHIT)
#define G_T5_PLI_REQTABHIT(x) (((x) >> S_T5_PLI_REQTABHIT) & M_T5_PLI_REQTABHIT)

#define S_T5_GNTSI    0
#define M_T5_GNTSI    0x7fU
#define V_T5_GNTSI(x) ((x) << S_T5_GNTSI)
#define G_T5_GNTSI(x) (((x) >> S_T5_GNTSI) & M_T5_GNTSI)

#define A_PCIE_PDEBUG_REG_0X28 0x28

#define S_PLI_REQWRVLD    31
#define V_PLI_REQWRVLD(x) ((x) << S_PLI_REQWRVLD)
#define F_PLI_REQWRVLD    V_PLI_REQWRVLD(1U)

#define S_T5_PLI_REQPBAHIT    30
#define V_T5_PLI_REQPBAHIT(x) ((x) << S_T5_PLI_REQPBAHIT)
#define F_T5_PLI_REQPBAHIT    V_T5_PLI_REQPBAHIT(1U)

#define S_PLI_TABADDRLWREN    29
#define V_PLI_TABADDRLWREN(x) ((x) << S_PLI_TABADDRLWREN)
#define F_PLI_TABADDRLWREN    V_PLI_TABADDRLWREN(1U)

#define S_PLI_TABADDRHWREN    28
#define V_PLI_TABADDRHWREN(x) ((x) << S_PLI_TABADDRHWREN)
#define F_PLI_TABADDRHWREN    V_PLI_TABADDRHWREN(1U)

#define S_T5_PLI_TABDATWREN    27
#define V_T5_PLI_TABDATWREN(x) ((x) << S_T5_PLI_TABDATWREN)
#define F_T5_PLI_TABDATWREN    V_T5_PLI_TABDATWREN(1U)

#define S_PLI_TABMSKWREN    26
#define V_PLI_TABMSKWREN(x) ((x) << S_PLI_TABMSKWREN)
#define F_PLI_TABMSKWREN    V_PLI_TABMSKWREN(1U)

#define S_AI_REQVLD    23
#define M_AI_REQVLD    0x7U
#define V_AI_REQVLD(x) ((x) << S_AI_REQVLD)
#define G_AI_REQVLD(x) (((x) >> S_AI_REQVLD) & M_AI_REQVLD)

#define S_AI_REQVLD2    22
#define V_AI_REQVLD2(x) ((x) << S_AI_REQVLD2)
#define F_AI_REQVLD2    V_AI_REQVLD2(1U)

#define S_AI_REQRDY    21
#define V_AI_REQRDY(x) ((x) << S_AI_REQRDY)
#define F_AI_REQRDY    V_AI_REQRDY(1U)

#define S_VEN_MSI_REQ_28    18
#define M_VEN_MSI_REQ_28    0x7U
#define V_VEN_MSI_REQ_28(x) ((x) << S_VEN_MSI_REQ_28)
#define G_VEN_MSI_REQ_28(x) (((x) >> S_VEN_MSI_REQ_28) & M_VEN_MSI_REQ_28)

#define S_VEN_MSI_REQ2    11
#define M_VEN_MSI_REQ2    0x7fU
#define V_VEN_MSI_REQ2(x) ((x) << S_VEN_MSI_REQ2)
#define G_VEN_MSI_REQ2(x) (((x) >> S_VEN_MSI_REQ2) & M_VEN_MSI_REQ2)

#define S_VEN_MSI_REQ3    6
#define M_VEN_MSI_REQ3    0x1fU
#define V_VEN_MSI_REQ3(x) ((x) << S_VEN_MSI_REQ3)
#define G_VEN_MSI_REQ3(x) (((x) >> S_VEN_MSI_REQ3) & M_VEN_MSI_REQ3)

#define S_VEN_MSI_REQ4    3
#define M_VEN_MSI_REQ4    0x7U
#define V_VEN_MSI_REQ4(x) ((x) << S_VEN_MSI_REQ4)
#define G_VEN_MSI_REQ4(x) (((x) >> S_VEN_MSI_REQ4) & M_VEN_MSI_REQ4)

#define S_VEN_MSI_REQ5    2
#define V_VEN_MSI_REQ5(x) ((x) << S_VEN_MSI_REQ5)
#define F_VEN_MSI_REQ5    V_VEN_MSI_REQ5(1U)

#define S_VEN_MSI_GRANT    1
#define V_VEN_MSI_GRANT(x) ((x) << S_VEN_MSI_GRANT)
#define F_VEN_MSI_GRANT    V_VEN_MSI_GRANT(1U)

#define S_VEN_MSI_REQ6    0
#define V_VEN_MSI_REQ6(x) ((x) << S_VEN_MSI_REQ6)
#define F_VEN_MSI_REQ6    V_VEN_MSI_REQ6(1U)

#define A_PCIE_PDEBUG_REG_0X29 0x29

#define S_TRGT1_REQDATAVLD    16
#define M_TRGT1_REQDATAVLD    0xffffU
#define V_TRGT1_REQDATAVLD(x) ((x) << S_TRGT1_REQDATAVLD)
#define G_TRGT1_REQDATAVLD(x) (((x) >> S_TRGT1_REQDATAVLD) & M_TRGT1_REQDATAVLD)

#define S_TRGT1_REQDATAVLD2    12
#define M_TRGT1_REQDATAVLD2    0xfU
#define V_TRGT1_REQDATAVLD2(x) ((x) << S_TRGT1_REQDATAVLD2)
#define G_TRGT1_REQDATAVLD2(x) (((x) >> S_TRGT1_REQDATAVLD2) & M_TRGT1_REQDATAVLD2)

#define S_TRGT1_REQDATAVLD3    11
#define V_TRGT1_REQDATAVLD3(x) ((x) << S_TRGT1_REQDATAVLD3)
#define F_TRGT1_REQDATAVLD3    V_TRGT1_REQDATAVLD3(1U)

#define S_TRGT1_REQDATAVLD4    10
#define V_TRGT1_REQDATAVLD4(x) ((x) << S_TRGT1_REQDATAVLD4)
#define F_TRGT1_REQDATAVLD4    V_TRGT1_REQDATAVLD4(1U)

#define S_TRGT1_REQDATAVLD5    9
#define V_TRGT1_REQDATAVLD5(x) ((x) << S_TRGT1_REQDATAVLD5)
#define F_TRGT1_REQDATAVLD5    V_TRGT1_REQDATAVLD5(1U)

#define S_TRGT1_REQDATAVLD6    8
#define V_TRGT1_REQDATAVLD6(x) ((x) << S_TRGT1_REQDATAVLD6)
#define F_TRGT1_REQDATAVLD6    V_TRGT1_REQDATAVLD6(1U)

#define S_TRGT1_REQDATAVLD7    4
#define M_TRGT1_REQDATAVLD7    0xfU
#define V_TRGT1_REQDATAVLD7(x) ((x) << S_TRGT1_REQDATAVLD7)
#define G_TRGT1_REQDATAVLD7(x) (((x) >> S_TRGT1_REQDATAVLD7) & M_TRGT1_REQDATAVLD7)

#define S_TRGT1_REQDATAVLD8    2
#define M_TRGT1_REQDATAVLD8    0x3U
#define V_TRGT1_REQDATAVLD8(x) ((x) << S_TRGT1_REQDATAVLD8)
#define G_TRGT1_REQDATAVLD8(x) (((x) >> S_TRGT1_REQDATAVLD8) & M_TRGT1_REQDATAVLD8)

#define S_TRGT1_REQDATARDY    1
#define V_TRGT1_REQDATARDY(x) ((x) << S_TRGT1_REQDATARDY)
#define F_TRGT1_REQDATARDY    V_TRGT1_REQDATARDY(1U)

#define S_TRGT1_REQDATAVLD0    0
#define V_TRGT1_REQDATAVLD0(x) ((x) << S_TRGT1_REQDATAVLD0)
#define F_TRGT1_REQDATAVLD0    V_TRGT1_REQDATAVLD0(1U)

#define A_PCIE_PDEBUG_REG_0X2A 0x2a
#define A_PCIE_PDEBUG_REG_0X2B 0x2b

#define S_RADM_TRGT1_ADDR    20
#define M_RADM_TRGT1_ADDR    0xfffU
#define V_RADM_TRGT1_ADDR(x) ((x) << S_RADM_TRGT1_ADDR)
#define G_RADM_TRGT1_ADDR(x) (((x) >> S_RADM_TRGT1_ADDR) & M_RADM_TRGT1_ADDR)

#define S_RADM_TRGT1_DWEN    16
#define M_RADM_TRGT1_DWEN    0xfU
#define V_RADM_TRGT1_DWEN(x) ((x) << S_RADM_TRGT1_DWEN)
#define G_RADM_TRGT1_DWEN(x) (((x) >> S_RADM_TRGT1_DWEN) & M_RADM_TRGT1_DWEN)

#define S_RADM_TRGT1_FMT    14
#define M_RADM_TRGT1_FMT    0x3U
#define V_RADM_TRGT1_FMT(x) ((x) << S_RADM_TRGT1_FMT)
#define G_RADM_TRGT1_FMT(x) (((x) >> S_RADM_TRGT1_FMT) & M_RADM_TRGT1_FMT)

#define S_RADM_TRGT1_TYPE    9
#define M_RADM_TRGT1_TYPE    0x1fU
#define V_RADM_TRGT1_TYPE(x) ((x) << S_RADM_TRGT1_TYPE)
#define G_RADM_TRGT1_TYPE(x) (((x) >> S_RADM_TRGT1_TYPE) & M_RADM_TRGT1_TYPE)

#define S_RADM_TRGT1_IN_MEMBAR_RANGE    6
#define M_RADM_TRGT1_IN_MEMBAR_RANGE    0x7U
#define V_RADM_TRGT1_IN_MEMBAR_RANGE(x) ((x) << S_RADM_TRGT1_IN_MEMBAR_RANGE)
#define G_RADM_TRGT1_IN_MEMBAR_RANGE(x) (((x) >> S_RADM_TRGT1_IN_MEMBAR_RANGE) & M_RADM_TRGT1_IN_MEMBAR_RANGE)

#define S_RADM_TRGT1_ECRC_ERR    5
#define V_RADM_TRGT1_ECRC_ERR(x) ((x) << S_RADM_TRGT1_ECRC_ERR)
#define F_RADM_TRGT1_ECRC_ERR    V_RADM_TRGT1_ECRC_ERR(1U)

#define S_RADM_TRGT1_DLLP_ABORT    4
#define V_RADM_TRGT1_DLLP_ABORT(x) ((x) << S_RADM_TRGT1_DLLP_ABORT)
#define F_RADM_TRGT1_DLLP_ABORT    V_RADM_TRGT1_DLLP_ABORT(1U)

#define S_RADM_TRGT1_TLP_ABORT    3
#define V_RADM_TRGT1_TLP_ABORT(x) ((x) << S_RADM_TRGT1_TLP_ABORT)
#define F_RADM_TRGT1_TLP_ABORT    V_RADM_TRGT1_TLP_ABORT(1U)

#define S_RADM_TRGT1_EOT    2
#define V_RADM_TRGT1_EOT(x) ((x) << S_RADM_TRGT1_EOT)
#define F_RADM_TRGT1_EOT    V_RADM_TRGT1_EOT(1U)

#define S_RADM_TRGT1_DV_2B    1
#define V_RADM_TRGT1_DV_2B(x) ((x) << S_RADM_TRGT1_DV_2B)
#define F_RADM_TRGT1_DV_2B    V_RADM_TRGT1_DV_2B(1U)

#define S_RADM_TRGT1_HV_2B    0
#define V_RADM_TRGT1_HV_2B(x) ((x) << S_RADM_TRGT1_HV_2B)
#define F_RADM_TRGT1_HV_2B    V_RADM_TRGT1_HV_2B(1U)

#define A_PCIE_PDEBUG_REG_0X2C 0x2c

#define S_STATEMPIO    29
#define M_STATEMPIO    0x7U
#define V_STATEMPIO(x) ((x) << S_STATEMPIO)
#define G_STATEMPIO(x) (((x) >> S_STATEMPIO) & M_STATEMPIO)

#define S_STATECPL    25
#define M_STATECPL    0xfU
#define V_STATECPL(x) ((x) << S_STATECPL)
#define G_STATECPL(x) (((x) >> S_STATECPL) & M_STATECPL)

#define S_STATEALIN    22
#define M_STATEALIN    0x7U
#define V_STATEALIN(x) ((x) << S_STATEALIN)
#define G_STATEALIN(x) (((x) >> S_STATEALIN) & M_STATEALIN)

#define S_STATEPL    19
#define M_STATEPL    0x7U
#define V_STATEPL(x) ((x) << S_STATEPL)
#define G_STATEPL(x) (((x) >> S_STATEPL) & M_STATEPL)

#define S_STATEMARSP    18
#define V_STATEMARSP(x) ((x) << S_STATEMARSP)
#define F_STATEMARSP    V_STATEMARSP(1U)

#define S_MA_TAGSINUSE    11
#define M_MA_TAGSINUSE    0x7fU
#define V_MA_TAGSINUSE(x) ((x) << S_MA_TAGSINUSE)
#define G_MA_TAGSINUSE(x) (((x) >> S_MA_TAGSINUSE) & M_MA_TAGSINUSE)

#define S_RADM_TRGT1_HSRDY    10
#define V_RADM_TRGT1_HSRDY(x) ((x) << S_RADM_TRGT1_HSRDY)
#define F_RADM_TRGT1_HSRDY    V_RADM_TRGT1_HSRDY(1U)

#define S_RADM_TRGT1_DSRDY    9
#define V_RADM_TRGT1_DSRDY(x) ((x) << S_RADM_TRGT1_DSRDY)
#define F_RADM_TRGT1_DSRDY    V_RADM_TRGT1_DSRDY(1U)

#define S_ALIND_REQWRDATAVLD    8
#define V_ALIND_REQWRDATAVLD(x) ((x) << S_ALIND_REQWRDATAVLD)
#define F_ALIND_REQWRDATAVLD    V_ALIND_REQWRDATAVLD(1U)

#define S_FID_LKUPWRHDRVLD    7
#define V_FID_LKUPWRHDRVLD(x) ((x) << S_FID_LKUPWRHDRVLD)
#define F_FID_LKUPWRHDRVLD    V_FID_LKUPWRHDRVLD(1U)

#define S_MPIO_WRVLD    6
#define V_MPIO_WRVLD(x) ((x) << S_MPIO_WRVLD)
#define F_MPIO_WRVLD    V_MPIO_WRVLD(1U)

#define S_TRGT1_RADM_HALT    5
#define V_TRGT1_RADM_HALT(x) ((x) << S_TRGT1_RADM_HALT)
#define F_TRGT1_RADM_HALT    V_TRGT1_RADM_HALT(1U)

#define S_RADM_TRGT1_DV_2C    4
#define V_RADM_TRGT1_DV_2C(x) ((x) << S_RADM_TRGT1_DV_2C)
#define F_RADM_TRGT1_DV_2C    V_RADM_TRGT1_DV_2C(1U)

#define S_RADM_TRGT1_DV_2C_2    3
#define V_RADM_TRGT1_DV_2C_2(x) ((x) << S_RADM_TRGT1_DV_2C_2)
#define F_RADM_TRGT1_DV_2C_2    V_RADM_TRGT1_DV_2C_2(1U)

#define S_RADM_TRGT1_TLP_ABORT_2C    2
#define V_RADM_TRGT1_TLP_ABORT_2C(x) ((x) << S_RADM_TRGT1_TLP_ABORT_2C)
#define F_RADM_TRGT1_TLP_ABORT_2C    V_RADM_TRGT1_TLP_ABORT_2C(1U)

#define S_RADM_TRGT1_DLLP_ABORT_2C    1
#define V_RADM_TRGT1_DLLP_ABORT_2C(x) ((x) << S_RADM_TRGT1_DLLP_ABORT_2C)
#define F_RADM_TRGT1_DLLP_ABORT_2C    V_RADM_TRGT1_DLLP_ABORT_2C(1U)

#define S_RADM_TRGT1_ECRC_ERR_2C    0
#define V_RADM_TRGT1_ECRC_ERR_2C(x) ((x) << S_RADM_TRGT1_ECRC_ERR_2C)
#define F_RADM_TRGT1_ECRC_ERR_2C    V_RADM_TRGT1_ECRC_ERR_2C(1U)

#define A_PCIE_PDEBUG_REG_0X2D 0x2d

#define S_RADM_TRGT1_HV_2D    31
#define V_RADM_TRGT1_HV_2D(x) ((x) << S_RADM_TRGT1_HV_2D)
#define F_RADM_TRGT1_HV_2D    V_RADM_TRGT1_HV_2D(1U)

#define S_RADM_TRGT1_DV_2D    30
#define V_RADM_TRGT1_DV_2D(x) ((x) << S_RADM_TRGT1_DV_2D)
#define F_RADM_TRGT1_DV_2D    V_RADM_TRGT1_DV_2D(1U)

#define S_RADM_TRGT1_HV2    23
#define M_RADM_TRGT1_HV2    0x7fU
#define V_RADM_TRGT1_HV2(x) ((x) << S_RADM_TRGT1_HV2)
#define G_RADM_TRGT1_HV2(x) (((x) >> S_RADM_TRGT1_HV2) & M_RADM_TRGT1_HV2)

#define S_RADM_TRGT1_HV3    20
#define M_RADM_TRGT1_HV3    0x7U
#define V_RADM_TRGT1_HV3(x) ((x) << S_RADM_TRGT1_HV3)
#define G_RADM_TRGT1_HV3(x) (((x) >> S_RADM_TRGT1_HV3) & M_RADM_TRGT1_HV3)

#define S_RADM_TRGT1_HV4    16
#define M_RADM_TRGT1_HV4    0xfU
#define V_RADM_TRGT1_HV4(x) ((x) << S_RADM_TRGT1_HV4)
#define G_RADM_TRGT1_HV4(x) (((x) >> S_RADM_TRGT1_HV4) & M_RADM_TRGT1_HV4)

#define S_RADM_TRGT1_HV5    12
#define M_RADM_TRGT1_HV5    0xfU
#define V_RADM_TRGT1_HV5(x) ((x) << S_RADM_TRGT1_HV5)
#define G_RADM_TRGT1_HV5(x) (((x) >> S_RADM_TRGT1_HV5) & M_RADM_TRGT1_HV5)

#define S_RADM_TRGT1_HV6    11
#define V_RADM_TRGT1_HV6(x) ((x) << S_RADM_TRGT1_HV6)
#define F_RADM_TRGT1_HV6    V_RADM_TRGT1_HV6(1U)

#define S_RADM_TRGT1_HV7    10
#define V_RADM_TRGT1_HV7(x) ((x) << S_RADM_TRGT1_HV7)
#define F_RADM_TRGT1_HV7    V_RADM_TRGT1_HV7(1U)

#define S_RADM_TRGT1_HV8    7
#define M_RADM_TRGT1_HV8    0x7U
#define V_RADM_TRGT1_HV8(x) ((x) << S_RADM_TRGT1_HV8)
#define G_RADM_TRGT1_HV8(x) (((x) >> S_RADM_TRGT1_HV8) & M_RADM_TRGT1_HV8)

#define S_RADM_TRGT1_HV9    6
#define V_RADM_TRGT1_HV9(x) ((x) << S_RADM_TRGT1_HV9)
#define F_RADM_TRGT1_HV9    V_RADM_TRGT1_HV9(1U)

#define S_RADM_TRGT1_HVA    5
#define V_RADM_TRGT1_HVA(x) ((x) << S_RADM_TRGT1_HVA)
#define F_RADM_TRGT1_HVA    V_RADM_TRGT1_HVA(1U)

#define S_RADM_TRGT1_DSRDY_2D    4
#define V_RADM_TRGT1_DSRDY_2D(x) ((x) << S_RADM_TRGT1_DSRDY_2D)
#define F_RADM_TRGT1_DSRDY_2D    V_RADM_TRGT1_DSRDY_2D(1U)

#define S_RADM_TRGT1_WRCNT    0
#define M_RADM_TRGT1_WRCNT    0xfU
#define V_RADM_TRGT1_WRCNT(x) ((x) << S_RADM_TRGT1_WRCNT)
#define G_RADM_TRGT1_WRCNT(x) (((x) >> S_RADM_TRGT1_WRCNT) & M_RADM_TRGT1_WRCNT)

#define A_PCIE_PDEBUG_REG_0X2E 0x2e

#define S_RADM_TRGT1_HV_2E    30
#define M_RADM_TRGT1_HV_2E    0x3U
#define V_RADM_TRGT1_HV_2E(x) ((x) << S_RADM_TRGT1_HV_2E)
#define G_RADM_TRGT1_HV_2E(x) (((x) >> S_RADM_TRGT1_HV_2E) & M_RADM_TRGT1_HV_2E)

#define S_RADM_TRGT1_HV_2E_2    20
#define M_RADM_TRGT1_HV_2E_2    0x3ffU
#define V_RADM_TRGT1_HV_2E_2(x) ((x) << S_RADM_TRGT1_HV_2E_2)
#define G_RADM_TRGT1_HV_2E_2(x) (((x) >> S_RADM_TRGT1_HV_2E_2) & M_RADM_TRGT1_HV_2E_2)

#define S_RADM_TRGT1_HV_WE_3    12
#define M_RADM_TRGT1_HV_WE_3    0xffU
#define V_RADM_TRGT1_HV_WE_3(x) ((x) << S_RADM_TRGT1_HV_WE_3)
#define G_RADM_TRGT1_HV_WE_3(x) (((x) >> S_RADM_TRGT1_HV_WE_3) & M_RADM_TRGT1_HV_WE_3)

#define S_ALIN_REQDATAVLD4    8
#define M_ALIN_REQDATAVLD4    0xfU
#define V_ALIN_REQDATAVLD4(x) ((x) << S_ALIN_REQDATAVLD4)
#define G_ALIN_REQDATAVLD4(x) (((x) >> S_ALIN_REQDATAVLD4) & M_ALIN_REQDATAVLD4)

#define S_ALIN_REQDATAVLD5    7
#define V_ALIN_REQDATAVLD5(x) ((x) << S_ALIN_REQDATAVLD5)
#define F_ALIN_REQDATAVLD5    V_ALIN_REQDATAVLD5(1U)

#define S_ALIN_REQDATAVLD6    6
#define V_ALIN_REQDATAVLD6(x) ((x) << S_ALIN_REQDATAVLD6)
#define F_ALIN_REQDATAVLD6    V_ALIN_REQDATAVLD6(1U)

#define S_ALIN_REQDATAVLD7    4
#define M_ALIN_REQDATAVLD7    0x3U
#define V_ALIN_REQDATAVLD7(x) ((x) << S_ALIN_REQDATAVLD7)
#define G_ALIN_REQDATAVLD7(x) (((x) >> S_ALIN_REQDATAVLD7) & M_ALIN_REQDATAVLD7)

#define S_ALIN_REQDATAVLD8    3
#define V_ALIN_REQDATAVLD8(x) ((x) << S_ALIN_REQDATAVLD8)
#define F_ALIN_REQDATAVLD8    V_ALIN_REQDATAVLD8(1U)

#define S_ALIN_REQDATAVLD9    2
#define V_ALIN_REQDATAVLD9(x) ((x) << S_ALIN_REQDATAVLD9)
#define F_ALIN_REQDATAVLD9    V_ALIN_REQDATAVLD9(1U)

#define S_ALIN_REQDATARDY    1
#define V_ALIN_REQDATARDY(x) ((x) << S_ALIN_REQDATARDY)
#define F_ALIN_REQDATARDY    V_ALIN_REQDATARDY(1U)

#define S_ALIN_REQDATAVLDA    0
#define V_ALIN_REQDATAVLDA(x) ((x) << S_ALIN_REQDATAVLDA)
#define F_ALIN_REQDATAVLDA    V_ALIN_REQDATAVLDA(1U)

#define A_PCIE_PDEBUG_REG_0X2F 0x2f
#define A_PCIE_PDEBUG_REG_0X30 0x30

#define S_RADM_TRGT1_HV_30    25
#define M_RADM_TRGT1_HV_30    0x7fU
#define V_RADM_TRGT1_HV_30(x) ((x) << S_RADM_TRGT1_HV_30)
#define G_RADM_TRGT1_HV_30(x) (((x) >> S_RADM_TRGT1_HV_30) & M_RADM_TRGT1_HV_30)

#define S_PIO_WRCNT    15
#define M_PIO_WRCNT    0x3ffU
#define V_PIO_WRCNT(x) ((x) << S_PIO_WRCNT)
#define G_PIO_WRCNT(x) (((x) >> S_PIO_WRCNT) & M_PIO_WRCNT)

#define S_ALIND_REQWRCNT    12
#define M_ALIND_REQWRCNT    0x7U
#define V_ALIND_REQWRCNT(x) ((x) << S_ALIND_REQWRCNT)
#define G_ALIND_REQWRCNT(x) (((x) >> S_ALIND_REQWRCNT) & M_ALIND_REQWRCNT)

#define S_FID_LKUPWRCNT    9
#define M_FID_LKUPWRCNT    0x7U
#define V_FID_LKUPWRCNT(x) ((x) << S_FID_LKUPWRCNT)
#define G_FID_LKUPWRCNT(x) (((x) >> S_FID_LKUPWRCNT) & M_FID_LKUPWRCNT)

#define S_ALIND_REQRDDATAVLD    8
#define V_ALIND_REQRDDATAVLD(x) ((x) << S_ALIND_REQRDDATAVLD)
#define F_ALIND_REQRDDATAVLD    V_ALIND_REQRDDATAVLD(1U)

#define S_ALIND_REQRDDATARDY    7
#define V_ALIND_REQRDDATARDY(x) ((x) << S_ALIND_REQRDDATARDY)
#define F_ALIND_REQRDDATARDY    V_ALIND_REQRDDATARDY(1U)

#define S_ALIND_REQRDDATAVLD2    6
#define V_ALIND_REQRDDATAVLD2(x) ((x) << S_ALIND_REQRDDATAVLD2)
#define F_ALIND_REQRDDATAVLD2    V_ALIND_REQRDDATAVLD2(1U)

#define S_ALIND_REQWRDATAVLD3    3
#define M_ALIND_REQWRDATAVLD3    0x7U
#define V_ALIND_REQWRDATAVLD3(x) ((x) << S_ALIND_REQWRDATAVLD3)
#define G_ALIND_REQWRDATAVLD3(x) (((x) >> S_ALIND_REQWRDATAVLD3) & M_ALIND_REQWRDATAVLD3)

#define S_ALIND_REQWRDATAVLD4    2
#define V_ALIND_REQWRDATAVLD4(x) ((x) << S_ALIND_REQWRDATAVLD4)
#define F_ALIND_REQWRDATAVLD4    V_ALIND_REQWRDATAVLD4(1U)

#define S_ALIND_REQWRDATARDYOPEN    1
#define V_ALIND_REQWRDATARDYOPEN(x) ((x) << S_ALIND_REQWRDATARDYOPEN)
#define F_ALIND_REQWRDATARDYOPEN    V_ALIND_REQWRDATARDYOPEN(1U)

#define S_ALIND_REQWRDATAVLD5    0
#define V_ALIND_REQWRDATAVLD5(x) ((x) << S_ALIND_REQWRDATAVLD5)
#define F_ALIND_REQWRDATAVLD5    V_ALIND_REQWRDATAVLD5(1U)

#define A_PCIE_PDEBUG_REG_0X31 0x31
#define A_PCIE_PDEBUG_REG_0X32 0x32
#define A_PCIE_PDEBUG_REG_0X33 0x33
#define A_PCIE_PDEBUG_REG_0X34 0x34
#define A_PCIE_PDEBUG_REG_0X35 0x35

#define S_T5_MPIO_WRVLD    19
#define M_T5_MPIO_WRVLD    0x1fffU
#define V_T5_MPIO_WRVLD(x) ((x) << S_T5_MPIO_WRVLD)
#define G_T5_MPIO_WRVLD(x) (((x) >> S_T5_MPIO_WRVLD) & M_T5_MPIO_WRVLD)

#define S_FID_LKUPRDHDRVLD    18
#define V_FID_LKUPRDHDRVLD(x) ((x) << S_FID_LKUPRDHDRVLD)
#define F_FID_LKUPRDHDRVLD    V_FID_LKUPRDHDRVLD(1U)

#define S_FID_LKUPRDHDRVLD2    17
#define V_FID_LKUPRDHDRVLD2(x) ((x) << S_FID_LKUPRDHDRVLD2)
#define F_FID_LKUPRDHDRVLD2    V_FID_LKUPRDHDRVLD2(1U)

#define S_FID_LKUPRDHDRVLD3    16
#define V_FID_LKUPRDHDRVLD3(x) ((x) << S_FID_LKUPRDHDRVLD3)
#define F_FID_LKUPRDHDRVLD3    V_FID_LKUPRDHDRVLD3(1U)

#define S_FID_LKUPRDHDRVLD4    15
#define V_FID_LKUPRDHDRVLD4(x) ((x) << S_FID_LKUPRDHDRVLD4)
#define F_FID_LKUPRDHDRVLD4    V_FID_LKUPRDHDRVLD4(1U)

#define S_FID_LKUPRDHDRVLD5    14
#define V_FID_LKUPRDHDRVLD5(x) ((x) << S_FID_LKUPRDHDRVLD5)
#define F_FID_LKUPRDHDRVLD5    V_FID_LKUPRDHDRVLD5(1U)

#define S_FID_LKUPRDHDRVLD6    13
#define V_FID_LKUPRDHDRVLD6(x) ((x) << S_FID_LKUPRDHDRVLD6)
#define F_FID_LKUPRDHDRVLD6    V_FID_LKUPRDHDRVLD6(1U)

#define S_FID_LKUPRDHDRVLD7    12
#define V_FID_LKUPRDHDRVLD7(x) ((x) << S_FID_LKUPRDHDRVLD7)
#define F_FID_LKUPRDHDRVLD7    V_FID_LKUPRDHDRVLD7(1U)

#define S_FID_LKUPRDHDRVLD8    11
#define V_FID_LKUPRDHDRVLD8(x) ((x) << S_FID_LKUPRDHDRVLD8)
#define F_FID_LKUPRDHDRVLD8    V_FID_LKUPRDHDRVLD8(1U)

#define S_FID_LKUPRDHDRVLD9    10
#define V_FID_LKUPRDHDRVLD9(x) ((x) << S_FID_LKUPRDHDRVLD9)
#define F_FID_LKUPRDHDRVLD9    V_FID_LKUPRDHDRVLD9(1U)

#define S_FID_LKUPRDHDRVLDA    9
#define V_FID_LKUPRDHDRVLDA(x) ((x) << S_FID_LKUPRDHDRVLDA)
#define F_FID_LKUPRDHDRVLDA    V_FID_LKUPRDHDRVLDA(1U)

#define S_FID_LKUPRDHDRVLDB    8
#define V_FID_LKUPRDHDRVLDB(x) ((x) << S_FID_LKUPRDHDRVLDB)
#define F_FID_LKUPRDHDRVLDB    V_FID_LKUPRDHDRVLDB(1U)

#define S_FID_LKUPRDHDRVLDC    7
#define V_FID_LKUPRDHDRVLDC(x) ((x) << S_FID_LKUPRDHDRVLDC)
#define F_FID_LKUPRDHDRVLDC    V_FID_LKUPRDHDRVLDC(1U)

#define S_MPIO_WRVLD1    6
#define V_MPIO_WRVLD1(x) ((x) << S_MPIO_WRVLD1)
#define F_MPIO_WRVLD1    V_MPIO_WRVLD1(1U)

#define S_MPIO_WRVLD2    5
#define V_MPIO_WRVLD2(x) ((x) << S_MPIO_WRVLD2)
#define F_MPIO_WRVLD2    V_MPIO_WRVLD2(1U)

#define S_MPIO_WRVLD3    4
#define V_MPIO_WRVLD3(x) ((x) << S_MPIO_WRVLD3)
#define F_MPIO_WRVLD3    V_MPIO_WRVLD3(1U)

#define S_MPIO_WRVLD4    0
#define M_MPIO_WRVLD4    0xfU
#define V_MPIO_WRVLD4(x) ((x) << S_MPIO_WRVLD4)
#define G_MPIO_WRVLD4(x) (((x) >> S_MPIO_WRVLD4) & M_MPIO_WRVLD4)

#define A_PCIE_PDEBUG_REG_0X36 0x36
#define A_PCIE_PDEBUG_REG_0X37 0x37
#define A_PCIE_PDEBUG_REG_0X38 0x38
#define A_PCIE_PDEBUG_REG_0X39 0x39
#define A_PCIE_PDEBUG_REG_0X3A 0x3a

#define S_CLIENT0_TLP_VFUNC_ACTIVE    31
#define V_CLIENT0_TLP_VFUNC_ACTIVE(x) ((x) << S_CLIENT0_TLP_VFUNC_ACTIVE)
#define F_CLIENT0_TLP_VFUNC_ACTIVE    V_CLIENT0_TLP_VFUNC_ACTIVE(1U)

#define S_CLIENT0_TLP_VFUNC_NUM    24
#define M_CLIENT0_TLP_VFUNC_NUM    0x7fU
#define V_CLIENT0_TLP_VFUNC_NUM(x) ((x) << S_CLIENT0_TLP_VFUNC_NUM)
#define G_CLIENT0_TLP_VFUNC_NUM(x) (((x) >> S_CLIENT0_TLP_VFUNC_NUM) & M_CLIENT0_TLP_VFUNC_NUM)

#define S_CLIENT0_TLP_FUNC_NUM    21
#define M_CLIENT0_TLP_FUNC_NUM    0x7U
#define V_CLIENT0_TLP_FUNC_NUM(x) ((x) << S_CLIENT0_TLP_FUNC_NUM)
#define G_CLIENT0_TLP_FUNC_NUM(x) (((x) >> S_CLIENT0_TLP_FUNC_NUM) & M_CLIENT0_TLP_FUNC_NUM)

#define S_CLIENT0_TLP_BYTE_EN    13
#define M_CLIENT0_TLP_BYTE_EN    0xffU
#define V_CLIENT0_TLP_BYTE_EN(x) ((x) << S_CLIENT0_TLP_BYTE_EN)
#define G_CLIENT0_TLP_BYTE_EN(x) (((x) >> S_CLIENT0_TLP_BYTE_EN) & M_CLIENT0_TLP_BYTE_EN)

#define S_CLIENT0_TLP_BYTE_LEN    0
#define M_CLIENT0_TLP_BYTE_LEN    0x1fffU
#define V_CLIENT0_TLP_BYTE_LEN(x) ((x) << S_CLIENT0_TLP_BYTE_LEN)
#define G_CLIENT0_TLP_BYTE_LEN(x) (((x) >> S_CLIENT0_TLP_BYTE_LEN) & M_CLIENT0_TLP_BYTE_LEN)

#define A_PCIE_PDEBUG_REG_0X3B 0x3b

#define S_XADM_CLIENT0_HALT    31
#define V_XADM_CLIENT0_HALT(x) ((x) << S_XADM_CLIENT0_HALT)
#define F_XADM_CLIENT0_HALT    V_XADM_CLIENT0_HALT(1U)

#define S_CLIENT0_TLP_DV    30
#define V_CLIENT0_TLP_DV(x) ((x) << S_CLIENT0_TLP_DV)
#define F_CLIENT0_TLP_DV    V_CLIENT0_TLP_DV(1U)

#define S_CLIENT0_ADDR_ALIGN_EN    29
#define V_CLIENT0_ADDR_ALIGN_EN(x) ((x) << S_CLIENT0_ADDR_ALIGN_EN)
#define F_CLIENT0_ADDR_ALIGN_EN    V_CLIENT0_ADDR_ALIGN_EN(1U)

#define S_CLIENT0_CPL_BCM    28
#define V_CLIENT0_CPL_BCM(x) ((x) << S_CLIENT0_CPL_BCM)
#define F_CLIENT0_CPL_BCM    V_CLIENT0_CPL_BCM(1U)

#define S_CLIENT0_TLP_EP    27
#define V_CLIENT0_TLP_EP(x) ((x) << S_CLIENT0_TLP_EP)
#define F_CLIENT0_TLP_EP    V_CLIENT0_TLP_EP(1U)

#define S_CLIENT0_CPL_STATUS    24
#define M_CLIENT0_CPL_STATUS    0x7U
#define V_CLIENT0_CPL_STATUS(x) ((x) << S_CLIENT0_CPL_STATUS)
#define G_CLIENT0_CPL_STATUS(x) (((x) >> S_CLIENT0_CPL_STATUS) & M_CLIENT0_CPL_STATUS)

#define S_CLIENT0_TLP_TD    23
#define V_CLIENT0_TLP_TD(x) ((x) << S_CLIENT0_TLP_TD)
#define F_CLIENT0_TLP_TD    V_CLIENT0_TLP_TD(1U)

#define S_CLIENT0_TLP_TYPE    18
#define M_CLIENT0_TLP_TYPE    0x1fU
#define V_CLIENT0_TLP_TYPE(x) ((x) << S_CLIENT0_TLP_TYPE)
#define G_CLIENT0_TLP_TYPE(x) (((x) >> S_CLIENT0_TLP_TYPE) & M_CLIENT0_TLP_TYPE)

#define S_CLIENT0_TLP_FMT    16
#define M_CLIENT0_TLP_FMT    0x3U
#define V_CLIENT0_TLP_FMT(x) ((x) << S_CLIENT0_TLP_FMT)
#define G_CLIENT0_TLP_FMT(x) (((x) >> S_CLIENT0_TLP_FMT) & M_CLIENT0_TLP_FMT)

#define S_CLIENT0_TLP_BAD_EOT    15
#define V_CLIENT0_TLP_BAD_EOT(x) ((x) << S_CLIENT0_TLP_BAD_EOT)
#define F_CLIENT0_TLP_BAD_EOT    V_CLIENT0_TLP_BAD_EOT(1U)

#define S_CLIENT0_TLP_EOT    14
#define V_CLIENT0_TLP_EOT(x) ((x) << S_CLIENT0_TLP_EOT)
#define F_CLIENT0_TLP_EOT    V_CLIENT0_TLP_EOT(1U)

#define S_CLIENT0_TLP_ATTR    11
#define M_CLIENT0_TLP_ATTR    0x7U
#define V_CLIENT0_TLP_ATTR(x) ((x) << S_CLIENT0_TLP_ATTR)
#define G_CLIENT0_TLP_ATTR(x) (((x) >> S_CLIENT0_TLP_ATTR) & M_CLIENT0_TLP_ATTR)

#define S_CLIENT0_TLP_TC    8
#define M_CLIENT0_TLP_TC    0x7U
#define V_CLIENT0_TLP_TC(x) ((x) << S_CLIENT0_TLP_TC)
#define G_CLIENT0_TLP_TC(x) (((x) >> S_CLIENT0_TLP_TC) & M_CLIENT0_TLP_TC)

#define S_CLIENT0_TLP_TID    0
#define M_CLIENT0_TLP_TID    0xffU
#define V_CLIENT0_TLP_TID(x) ((x) << S_CLIENT0_TLP_TID)
#define G_CLIENT0_TLP_TID(x) (((x) >> S_CLIENT0_TLP_TID) & M_CLIENT0_TLP_TID)

#define A_PCIE_PDEBUG_REG_0X3C 0x3c

#define S_MEM_RSPRRAVLD    31
#define V_MEM_RSPRRAVLD(x) ((x) << S_MEM_RSPRRAVLD)
#define F_MEM_RSPRRAVLD    V_MEM_RSPRRAVLD(1U)

#define S_MEM_RSPRRARDY    30
#define V_MEM_RSPRRARDY(x) ((x) << S_MEM_RSPRRARDY)
#define F_MEM_RSPRRARDY    V_MEM_RSPRRARDY(1U)

#define S_PIO_RSPRRAVLD    29
#define V_PIO_RSPRRAVLD(x) ((x) << S_PIO_RSPRRAVLD)
#define F_PIO_RSPRRAVLD    V_PIO_RSPRRAVLD(1U)

#define S_PIO_RSPRRARDY    28
#define V_PIO_RSPRRARDY(x) ((x) << S_PIO_RSPRRARDY)
#define F_PIO_RSPRRARDY    V_PIO_RSPRRARDY(1U)

#define S_MEM_RSPRDVLD    27
#define V_MEM_RSPRDVLD(x) ((x) << S_MEM_RSPRDVLD)
#define F_MEM_RSPRDVLD    V_MEM_RSPRDVLD(1U)

#define S_MEM_RSPRDRRARDY    26
#define V_MEM_RSPRDRRARDY(x) ((x) << S_MEM_RSPRDRRARDY)
#define F_MEM_RSPRDRRARDY    V_MEM_RSPRDRRARDY(1U)

#define S_PIO_RSPRDVLD    25
#define V_PIO_RSPRDVLD(x) ((x) << S_PIO_RSPRDVLD)
#define F_PIO_RSPRDVLD    V_PIO_RSPRDVLD(1U)

#define S_PIO_RSPRDRRARDY    24
#define V_PIO_RSPRDRRARDY(x) ((x) << S_PIO_RSPRDRRARDY)
#define F_PIO_RSPRDRRARDY    V_PIO_RSPRDRRARDY(1U)

#define S_TGT_TAGQ_RDVLD    16
#define M_TGT_TAGQ_RDVLD    0xffU
#define V_TGT_TAGQ_RDVLD(x) ((x) << S_TGT_TAGQ_RDVLD)
#define G_TGT_TAGQ_RDVLD(x) (((x) >> S_TGT_TAGQ_RDVLD) & M_TGT_TAGQ_RDVLD)

#define S_CPLTXNDISABLE    8
#define M_CPLTXNDISABLE    0xffU
#define V_CPLTXNDISABLE(x) ((x) << S_CPLTXNDISABLE)
#define G_CPLTXNDISABLE(x) (((x) >> S_CPLTXNDISABLE) & M_CPLTXNDISABLE)

#define S_CPLTXNDISABLE2    7
#define V_CPLTXNDISABLE2(x) ((x) << S_CPLTXNDISABLE2)
#define F_CPLTXNDISABLE2    V_CPLTXNDISABLE2(1U)

#define S_CLIENT0_TLP_HV    0
#define M_CLIENT0_TLP_HV    0x7fU
#define V_CLIENT0_TLP_HV(x) ((x) << S_CLIENT0_TLP_HV)
#define G_CLIENT0_TLP_HV(x) (((x) >> S_CLIENT0_TLP_HV) & M_CLIENT0_TLP_HV)

#define A_PCIE_PDEBUG_REG_0X3D 0x3d
#define A_PCIE_PDEBUG_REG_0X3E 0x3e
#define A_PCIE_PDEBUG_REG_0X3F 0x3f
#define A_PCIE_PDEBUG_REG_0X40 0x40
#define A_PCIE_PDEBUG_REG_0X41 0x41
#define A_PCIE_PDEBUG_REG_0X42 0x42
#define A_PCIE_PDEBUG_REG_0X43 0x43
#define A_PCIE_PDEBUG_REG_0X44 0x44
#define A_PCIE_PDEBUG_REG_0X45 0x45
#define A_PCIE_PDEBUG_REG_0X46 0x46
#define A_PCIE_PDEBUG_REG_0X47 0x47
#define A_PCIE_PDEBUG_REG_0X48 0x48
#define A_PCIE_PDEBUG_REG_0X49 0x49
#define A_PCIE_PDEBUG_REG_0X4A 0x4a
#define A_PCIE_PDEBUG_REG_0X4B 0x4b
#define A_PCIE_PDEBUG_REG_0X4C 0x4c
#define A_PCIE_PDEBUG_REG_0X4D 0x4d
#define A_PCIE_PDEBUG_REG_0X4E 0x4e
#define A_PCIE_PDEBUG_REG_0X4F 0x4f
#define A_PCIE_PDEBUG_REG_0X50 0x50
#define A_PCIE_CDEBUG_REG_0X0 0x0
#define A_PCIE_CDEBUG_REG_0X1 0x1
#define A_PCIE_CDEBUG_REG_0X2 0x2

#define S_FLR_REQVLD    31
#define V_FLR_REQVLD(x) ((x) << S_FLR_REQVLD)
#define F_FLR_REQVLD    V_FLR_REQVLD(1U)

#define S_D_RSPVLD    28
#define M_D_RSPVLD    0x7U
#define V_D_RSPVLD(x) ((x) << S_D_RSPVLD)
#define G_D_RSPVLD(x) (((x) >> S_D_RSPVLD) & M_D_RSPVLD)

#define S_D_RSPVLD2    27
#define V_D_RSPVLD2(x) ((x) << S_D_RSPVLD2)
#define F_D_RSPVLD2    V_D_RSPVLD2(1U)

#define S_D_RSPVLD3    26
#define V_D_RSPVLD3(x) ((x) << S_D_RSPVLD3)
#define F_D_RSPVLD3    V_D_RSPVLD3(1U)

#define S_D_RSPVLD4    25
#define V_D_RSPVLD4(x) ((x) << S_D_RSPVLD4)
#define F_D_RSPVLD4    V_D_RSPVLD4(1U)

#define S_D_RSPVLD5    24
#define V_D_RSPVLD5(x) ((x) << S_D_RSPVLD5)
#define F_D_RSPVLD5    V_D_RSPVLD5(1U)

#define S_D_RSPVLD6    20
#define M_D_RSPVLD6    0xfU
#define V_D_RSPVLD6(x) ((x) << S_D_RSPVLD6)
#define G_D_RSPVLD6(x) (((x) >> S_D_RSPVLD6) & M_D_RSPVLD6)

#define S_D_RSPAFULL    16
#define M_D_RSPAFULL    0xfU
#define V_D_RSPAFULL(x) ((x) << S_D_RSPAFULL)
#define G_D_RSPAFULL(x) (((x) >> S_D_RSPAFULL) & M_D_RSPAFULL)

#define S_D_RDREQVLD    12
#define M_D_RDREQVLD    0xfU
#define V_D_RDREQVLD(x) ((x) << S_D_RDREQVLD)
#define G_D_RDREQVLD(x) (((x) >> S_D_RDREQVLD) & M_D_RDREQVLD)

#define S_D_RDREQAFULL    8
#define M_D_RDREQAFULL    0xfU
#define V_D_RDREQAFULL(x) ((x) << S_D_RDREQAFULL)
#define G_D_RDREQAFULL(x) (((x) >> S_D_RDREQAFULL) & M_D_RDREQAFULL)

#define S_D_WRREQVLD    4
#define M_D_WRREQVLD    0xfU
#define V_D_WRREQVLD(x) ((x) << S_D_WRREQVLD)
#define G_D_WRREQVLD(x) (((x) >> S_D_WRREQVLD) & M_D_WRREQVLD)

#define S_D_WRREQAFULL    0
#define M_D_WRREQAFULL    0xfU
#define V_D_WRREQAFULL(x) ((x) << S_D_WRREQAFULL)
#define G_D_WRREQAFULL(x) (((x) >> S_D_WRREQAFULL) & M_D_WRREQAFULL)

#define A_PCIE_CDEBUG_REG_0X3 0x3

#define S_C_REQVLD    19
#define M_C_REQVLD    0x1fffU
#define V_C_REQVLD(x) ((x) << S_C_REQVLD)
#define G_C_REQVLD(x) (((x) >> S_C_REQVLD) & M_C_REQVLD)

#define S_C_RSPVLD2    16
#define M_C_RSPVLD2    0x7U
#define V_C_RSPVLD2(x) ((x) << S_C_RSPVLD2)
#define G_C_RSPVLD2(x) (((x) >> S_C_RSPVLD2) & M_C_RSPVLD2)

#define S_C_RSPVLD3    15
#define V_C_RSPVLD3(x) ((x) << S_C_RSPVLD3)
#define F_C_RSPVLD3    V_C_RSPVLD3(1U)

#define S_C_RSPVLD4    14
#define V_C_RSPVLD4(x) ((x) << S_C_RSPVLD4)
#define F_C_RSPVLD4    V_C_RSPVLD4(1U)

#define S_C_RSPVLD5    13
#define V_C_RSPVLD5(x) ((x) << S_C_RSPVLD5)
#define F_C_RSPVLD5    V_C_RSPVLD5(1U)

#define S_C_RSPVLD6    12
#define V_C_RSPVLD6(x) ((x) << S_C_RSPVLD6)
#define F_C_RSPVLD6    V_C_RSPVLD6(1U)

#define S_C_RSPVLD7    9
#define M_C_RSPVLD7    0x7U
#define V_C_RSPVLD7(x) ((x) << S_C_RSPVLD7)
#define G_C_RSPVLD7(x) (((x) >> S_C_RSPVLD7) & M_C_RSPVLD7)

#define S_C_RSPAFULL    6
#define M_C_RSPAFULL    0x7U
#define V_C_RSPAFULL(x) ((x) << S_C_RSPAFULL)
#define G_C_RSPAFULL(x) (((x) >> S_C_RSPAFULL) & M_C_RSPAFULL)

#define S_C_REQVLD8    3
#define M_C_REQVLD8    0x7U
#define V_C_REQVLD8(x) ((x) << S_C_REQVLD8)
#define G_C_REQVLD8(x) (((x) >> S_C_REQVLD8) & M_C_REQVLD8)

#define S_C_REQAFULL    0
#define M_C_REQAFULL    0x7U
#define V_C_REQAFULL(x) ((x) << S_C_REQAFULL)
#define G_C_REQAFULL(x) (((x) >> S_C_REQAFULL) & M_C_REQAFULL)

#define A_PCIE_CDEBUG_REG_0X4 0x4

#define S_H_REQVLD    7
#define M_H_REQVLD    0x1ffffffU
#define V_H_REQVLD(x) ((x) << S_H_REQVLD)
#define G_H_REQVLD(x) (((x) >> S_H_REQVLD) & M_H_REQVLD)

#define S_H_RSPVLD    6
#define V_H_RSPVLD(x) ((x) << S_H_RSPVLD)
#define F_H_RSPVLD    V_H_RSPVLD(1U)

#define S_H_RSPVLD2    5
#define V_H_RSPVLD2(x) ((x) << S_H_RSPVLD2)
#define F_H_RSPVLD2    V_H_RSPVLD2(1U)

#define S_H_RSPVLD3    4
#define V_H_RSPVLD3(x) ((x) << S_H_RSPVLD3)
#define F_H_RSPVLD3    V_H_RSPVLD3(1U)

#define S_H_RSPVLD4    3
#define V_H_RSPVLD4(x) ((x) << S_H_RSPVLD4)
#define F_H_RSPVLD4    V_H_RSPVLD4(1U)

#define S_H_RSPAFULL    2
#define V_H_RSPAFULL(x) ((x) << S_H_RSPAFULL)
#define F_H_RSPAFULL    V_H_RSPAFULL(1U)

#define S_H_REQVLD2    1
#define V_H_REQVLD2(x) ((x) << S_H_REQVLD2)
#define F_H_REQVLD2    V_H_REQVLD2(1U)

#define S_H_REQAFULL    0
#define V_H_REQAFULL(x) ((x) << S_H_REQAFULL)
#define F_H_REQAFULL    V_H_REQAFULL(1U)

#define A_PCIE_CDEBUG_REG_0X5 0x5

#define S_ER_RSPVLD    16
#define M_ER_RSPVLD    0xffffU
#define V_ER_RSPVLD(x) ((x) << S_ER_RSPVLD)
#define G_ER_RSPVLD(x) (((x) >> S_ER_RSPVLD) & M_ER_RSPVLD)

#define S_ER_REQVLD2    5
#define M_ER_REQVLD2    0x7ffU
#define V_ER_REQVLD2(x) ((x) << S_ER_REQVLD2)
#define G_ER_REQVLD2(x) (((x) >> S_ER_REQVLD2) & M_ER_REQVLD2)

#define S_ER_REQVLD3    2
#define M_ER_REQVLD3    0x7U
#define V_ER_REQVLD3(x) ((x) << S_ER_REQVLD3)
#define G_ER_REQVLD3(x) (((x) >> S_ER_REQVLD3) & M_ER_REQVLD3)

#define S_ER_RSPVLD4    1
#define V_ER_RSPVLD4(x) ((x) << S_ER_RSPVLD4)
#define F_ER_RSPVLD4    V_ER_RSPVLD4(1U)

#define S_ER_REQVLD5    0
#define V_ER_REQVLD5(x) ((x) << S_ER_REQVLD5)
#define F_ER_REQVLD5    V_ER_REQVLD5(1U)

#define A_PCIE_CDEBUG_REG_0X6 0x6

#define S_PL_BAR2_REQVLD    4
#define M_PL_BAR2_REQVLD    0xfffffffU
#define V_PL_BAR2_REQVLD(x) ((x) << S_PL_BAR2_REQVLD)
#define G_PL_BAR2_REQVLD(x) (((x) >> S_PL_BAR2_REQVLD) & M_PL_BAR2_REQVLD)

#define S_PL_BAR2_REQVLD2    3
#define V_PL_BAR2_REQVLD2(x) ((x) << S_PL_BAR2_REQVLD2)
#define F_PL_BAR2_REQVLD2    V_PL_BAR2_REQVLD2(1U)

#define S_PL_BAR2_REQVLDE    2
#define V_PL_BAR2_REQVLDE(x) ((x) << S_PL_BAR2_REQVLDE)
#define F_PL_BAR2_REQVLDE    V_PL_BAR2_REQVLDE(1U)

#define S_PL_BAR2_REQFULL    1
#define V_PL_BAR2_REQFULL(x) ((x) << S_PL_BAR2_REQFULL)
#define F_PL_BAR2_REQFULL    V_PL_BAR2_REQFULL(1U)

#define S_PL_BAR2_REQVLD4    0
#define V_PL_BAR2_REQVLD4(x) ((x) << S_PL_BAR2_REQVLD4)
#define F_PL_BAR2_REQVLD4    V_PL_BAR2_REQVLD4(1U)

#define A_PCIE_CDEBUG_REG_0X7 0x7
#define A_PCIE_CDEBUG_REG_0X8 0x8
#define A_PCIE_CDEBUG_REG_0X9 0x9
#define A_PCIE_CDEBUG_REG_0XA 0xa

#define S_VPD_RSPVLD    20
#define M_VPD_RSPVLD    0xfffU
#define V_VPD_RSPVLD(x) ((x) << S_VPD_RSPVLD)
#define G_VPD_RSPVLD(x) (((x) >> S_VPD_RSPVLD) & M_VPD_RSPVLD)

#define S_VPD_REQVLD2    9
#define M_VPD_REQVLD2    0x7ffU
#define V_VPD_REQVLD2(x) ((x) << S_VPD_REQVLD2)
#define G_VPD_REQVLD2(x) (((x) >> S_VPD_REQVLD2) & M_VPD_REQVLD2)

#define S_VPD_REQVLD3    6
#define M_VPD_REQVLD3    0x7U
#define V_VPD_REQVLD3(x) ((x) << S_VPD_REQVLD3)
#define G_VPD_REQVLD3(x) (((x) >> S_VPD_REQVLD3) & M_VPD_REQVLD3)

#define S_VPD_REQVLD4    5
#define V_VPD_REQVLD4(x) ((x) << S_VPD_REQVLD4)
#define F_VPD_REQVLD4    V_VPD_REQVLD4(1U)

#define S_VPD_REQVLD5    3
#define M_VPD_REQVLD5    0x3U
#define V_VPD_REQVLD5(x) ((x) << S_VPD_REQVLD5)
#define G_VPD_REQVLD5(x) (((x) >> S_VPD_REQVLD5) & M_VPD_REQVLD5)

#define S_VPD_RSPVLD2    2
#define V_VPD_RSPVLD2(x) ((x) << S_VPD_RSPVLD2)
#define F_VPD_RSPVLD2    V_VPD_RSPVLD2(1U)

#define S_VPD_RSPVLD3    1
#define V_VPD_RSPVLD3(x) ((x) << S_VPD_RSPVLD3)
#define F_VPD_RSPVLD3    V_VPD_RSPVLD3(1U)

#define S_VPD_REQVLD6    0
#define V_VPD_REQVLD6(x) ((x) << S_VPD_REQVLD6)
#define F_VPD_REQVLD6    V_VPD_REQVLD6(1U)

#define A_PCIE_CDEBUG_REG_0XB 0xb

#define S_MA_REQDATAVLD    28
#define M_MA_REQDATAVLD    0xfU
#define V_MA_REQDATAVLD(x) ((x) << S_MA_REQDATAVLD)
#define G_MA_REQDATAVLD(x) (((x) >> S_MA_REQDATAVLD) & M_MA_REQDATAVLD)

#define S_MA_REQADDRVLD    27
#define V_MA_REQADDRVLD(x) ((x) << S_MA_REQADDRVLD)
#define F_MA_REQADDRVLD    V_MA_REQADDRVLD(1U)

#define S_MA_REQADDRVLD2    26
#define V_MA_REQADDRVLD2(x) ((x) << S_MA_REQADDRVLD2)
#define F_MA_REQADDRVLD2    V_MA_REQADDRVLD2(1U)

#define S_MA_RSPDATAVLD2    22
#define M_MA_RSPDATAVLD2    0xfU
#define V_MA_RSPDATAVLD2(x) ((x) << S_MA_RSPDATAVLD2)
#define G_MA_RSPDATAVLD2(x) (((x) >> S_MA_RSPDATAVLD2) & M_MA_RSPDATAVLD2)

#define S_MA_REQADDRVLD3    20
#define M_MA_REQADDRVLD3    0x3U
#define V_MA_REQADDRVLD3(x) ((x) << S_MA_REQADDRVLD3)
#define G_MA_REQADDRVLD3(x) (((x) >> S_MA_REQADDRVLD3) & M_MA_REQADDRVLD3)

#define S_MA_REQADDRVLD4    4
#define M_MA_REQADDRVLD4    0xffffU
#define V_MA_REQADDRVLD4(x) ((x) << S_MA_REQADDRVLD4)
#define G_MA_REQADDRVLD4(x) (((x) >> S_MA_REQADDRVLD4) & M_MA_REQADDRVLD4)

#define S_MA_REQADDRVLD5    3
#define V_MA_REQADDRVLD5(x) ((x) << S_MA_REQADDRVLD5)
#define F_MA_REQADDRVLD5    V_MA_REQADDRVLD5(1U)

#define S_MA_REQADDRVLD6    2
#define V_MA_REQADDRVLD6(x) ((x) << S_MA_REQADDRVLD6)
#define F_MA_REQADDRVLD6    V_MA_REQADDRVLD6(1U)

#define S_MA_REQADDRRDY    1
#define V_MA_REQADDRRDY(x) ((x) << S_MA_REQADDRRDY)
#define F_MA_REQADDRRDY    V_MA_REQADDRRDY(1U)

#define S_MA_REQADDRVLD7    0
#define V_MA_REQADDRVLD7(x) ((x) << S_MA_REQADDRVLD7)
#define F_MA_REQADDRVLD7    V_MA_REQADDRVLD7(1U)

#define A_PCIE_CDEBUG_REG_0XC 0xc
#define A_PCIE_CDEBUG_REG_0XD 0xd
#define A_PCIE_CDEBUG_REG_0XE 0xe
#define A_PCIE_CDEBUG_REG_0XF 0xf
#define A_PCIE_CDEBUG_REG_0X10 0x10
#define A_PCIE_CDEBUG_REG_0X11 0x11
#define A_PCIE_CDEBUG_REG_0X12 0x12
#define A_PCIE_CDEBUG_REG_0X13 0x13
#define A_PCIE_CDEBUG_REG_0X14 0x14
#define A_PCIE_CDEBUG_REG_0X15 0x15

#define S_PLM_REQVLD    19
#define M_PLM_REQVLD    0x1fffU
#define V_PLM_REQVLD(x) ((x) << S_PLM_REQVLD)
#define G_PLM_REQVLD(x) (((x) >> S_PLM_REQVLD) & M_PLM_REQVLD)

#define S_PLM_REQVLD2    18
#define V_PLM_REQVLD2(x) ((x) << S_PLM_REQVLD2)
#define F_PLM_REQVLD2    V_PLM_REQVLD2(1U)

#define S_PLM_RSPVLD3    17
#define V_PLM_RSPVLD3(x) ((x) << S_PLM_RSPVLD3)
#define F_PLM_RSPVLD3    V_PLM_RSPVLD3(1U)

#define S_PLM_REQVLD4    16
#define V_PLM_REQVLD4(x) ((x) << S_PLM_REQVLD4)
#define F_PLM_REQVLD4    V_PLM_REQVLD4(1U)

#define S_PLM_REQVLD5    15
#define V_PLM_REQVLD5(x) ((x) << S_PLM_REQVLD5)
#define F_PLM_REQVLD5    V_PLM_REQVLD5(1U)

#define S_PLM_REQVLD6    14
#define V_PLM_REQVLD6(x) ((x) << S_PLM_REQVLD6)
#define F_PLM_REQVLD6    V_PLM_REQVLD6(1U)

#define S_PLM_REQVLD7    13
#define V_PLM_REQVLD7(x) ((x) << S_PLM_REQVLD7)
#define F_PLM_REQVLD7    V_PLM_REQVLD7(1U)

#define S_PLM_REQVLD8    12
#define V_PLM_REQVLD8(x) ((x) << S_PLM_REQVLD8)
#define F_PLM_REQVLD8    V_PLM_REQVLD8(1U)

#define S_PLM_REQVLD9    4
#define M_PLM_REQVLD9    0xffU
#define V_PLM_REQVLD9(x) ((x) << S_PLM_REQVLD9)
#define G_PLM_REQVLD9(x) (((x) >> S_PLM_REQVLD9) & M_PLM_REQVLD9)

#define S_PLM_REQVLDA    1
#define M_PLM_REQVLDA    0x7U
#define V_PLM_REQVLDA(x) ((x) << S_PLM_REQVLDA)
#define G_PLM_REQVLDA(x) (((x) >> S_PLM_REQVLDA) & M_PLM_REQVLDA)

#define S_PLM_REQVLDB    0
#define V_PLM_REQVLDB(x) ((x) << S_PLM_REQVLDB)
#define F_PLM_REQVLDB    V_PLM_REQVLDB(1U)

#define A_PCIE_CDEBUG_REG_0X16 0x16
#define A_PCIE_CDEBUG_REG_0X17 0x17
#define A_PCIE_CDEBUG_REG_0X18 0x18
#define A_PCIE_CDEBUG_REG_0X19 0x19
#define A_PCIE_CDEBUG_REG_0X1A 0x1a
#define A_PCIE_CDEBUG_REG_0X1B 0x1b
#define A_PCIE_CDEBUG_REG_0X1C 0x1c
#define A_PCIE_CDEBUG_REG_0X1D 0x1d
#define A_PCIE_CDEBUG_REG_0X1E 0x1e
#define A_PCIE_CDEBUG_REG_0X1F 0x1f
#define A_PCIE_CDEBUG_REG_0X20 0x20
#define A_PCIE_CDEBUG_REG_0X21 0x21
#define A_PCIE_CDEBUG_REG_0X22 0x22
#define A_PCIE_CDEBUG_REG_0X23 0x23
#define A_PCIE_CDEBUG_REG_0X24 0x24
#define A_PCIE_CDEBUG_REG_0X25 0x25
#define A_PCIE_CDEBUG_REG_0X26 0x26
#define A_PCIE_CDEBUG_REG_0X27 0x27
#define A_PCIE_CDEBUG_REG_0X28 0x28
#define A_PCIE_CDEBUG_REG_0X29 0x29
#define A_PCIE_CDEBUG_REG_0X2A 0x2a
#define A_PCIE_CDEBUG_REG_0X2B 0x2b
#define A_PCIE_CDEBUG_REG_0X2C 0x2c
#define A_PCIE_CDEBUG_REG_0X2D 0x2d
#define A_PCIE_CDEBUG_REG_0X2E 0x2e
#define A_PCIE_CDEBUG_REG_0X2F 0x2f
#define A_PCIE_CDEBUG_REG_0X30 0x30
#define A_PCIE_CDEBUG_REG_0X31 0x31
#define A_PCIE_CDEBUG_REG_0X32 0x32
#define A_PCIE_CDEBUG_REG_0X33 0x33
#define A_PCIE_CDEBUG_REG_0X34 0x34
#define A_PCIE_CDEBUG_REG_0X35 0x35
#define A_PCIE_CDEBUG_REG_0X36 0x36
#define A_PCIE_CDEBUG_REG_0X37 0x37

/* registers for module DBG */
#define DBG_BASE_ADDR 0x6000

#define A_DBG_DBG0_CFG 0x6000

#define S_MODULESELECT    12
#define M_MODULESELECT    0xffU
#define V_MODULESELECT(x) ((x) << S_MODULESELECT)
#define G_MODULESELECT(x) (((x) >> S_MODULESELECT) & M_MODULESELECT)

#define S_REGSELECT    4
#define M_REGSELECT    0xffU
#define V_REGSELECT(x) ((x) << S_REGSELECT)
#define G_REGSELECT(x) (((x) >> S_REGSELECT) & M_REGSELECT)

#define S_CLKSELECT    0
#define M_CLKSELECT    0xfU
#define V_CLKSELECT(x) ((x) << S_CLKSELECT)
#define G_CLKSELECT(x) (((x) >> S_CLKSELECT) & M_CLKSELECT)

#define A_DBG_DBG0_EN 0x6004

#define S_PORTEN_PONR    16
#define V_PORTEN_PONR(x) ((x) << S_PORTEN_PONR)
#define F_PORTEN_PONR    V_PORTEN_PONR(1U)

#define S_PORTEN_POND    12
#define V_PORTEN_POND(x) ((x) << S_PORTEN_POND)
#define F_PORTEN_POND    V_PORTEN_POND(1U)

#define S_SDRHALFWORD0    8
#define V_SDRHALFWORD0(x) ((x) << S_SDRHALFWORD0)
#define F_SDRHALFWORD0    V_SDRHALFWORD0(1U)

#define S_DDREN    4
#define V_DDREN(x) ((x) << S_DDREN)
#define F_DDREN    V_DDREN(1U)

#define S_DBG_PORTEN    0
#define V_DBG_PORTEN(x) ((x) << S_DBG_PORTEN)
#define F_DBG_PORTEN    V_DBG_PORTEN(1U)

#define A_DBG_DBG1_CFG 0x6008
#define A_DBG_DBG1_EN 0x600c

#define S_CLK_EN_ON_DBG1    20
#define V_CLK_EN_ON_DBG1(x) ((x) << S_CLK_EN_ON_DBG1)
#define F_CLK_EN_ON_DBG1    V_CLK_EN_ON_DBG1(1U)

#define A_DBG_GPIO_EN 0x6010

#define S_GPIO15_OEN    31
#define V_GPIO15_OEN(x) ((x) << S_GPIO15_OEN)
#define F_GPIO15_OEN    V_GPIO15_OEN(1U)

#define S_GPIO14_OEN    30
#define V_GPIO14_OEN(x) ((x) << S_GPIO14_OEN)
#define F_GPIO14_OEN    V_GPIO14_OEN(1U)

#define S_GPIO13_OEN    29
#define V_GPIO13_OEN(x) ((x) << S_GPIO13_OEN)
#define F_GPIO13_OEN    V_GPIO13_OEN(1U)

#define S_GPIO12_OEN    28
#define V_GPIO12_OEN(x) ((x) << S_GPIO12_OEN)
#define F_GPIO12_OEN    V_GPIO12_OEN(1U)

#define S_GPIO11_OEN    27
#define V_GPIO11_OEN(x) ((x) << S_GPIO11_OEN)
#define F_GPIO11_OEN    V_GPIO11_OEN(1U)

#define S_GPIO10_OEN    26
#define V_GPIO10_OEN(x) ((x) << S_GPIO10_OEN)
#define F_GPIO10_OEN    V_GPIO10_OEN(1U)

#define S_GPIO9_OEN    25
#define V_GPIO9_OEN(x) ((x) << S_GPIO9_OEN)
#define F_GPIO9_OEN    V_GPIO9_OEN(1U)

#define S_GPIO8_OEN    24
#define V_GPIO8_OEN(x) ((x) << S_GPIO8_OEN)
#define F_GPIO8_OEN    V_GPIO8_OEN(1U)

#define S_GPIO7_OEN    23
#define V_GPIO7_OEN(x) ((x) << S_GPIO7_OEN)
#define F_GPIO7_OEN    V_GPIO7_OEN(1U)

#define S_GPIO6_OEN    22
#define V_GPIO6_OEN(x) ((x) << S_GPIO6_OEN)
#define F_GPIO6_OEN    V_GPIO6_OEN(1U)

#define S_GPIO5_OEN    21
#define V_GPIO5_OEN(x) ((x) << S_GPIO5_OEN)
#define F_GPIO5_OEN    V_GPIO5_OEN(1U)

#define S_GPIO4_OEN    20
#define V_GPIO4_OEN(x) ((x) << S_GPIO4_OEN)
#define F_GPIO4_OEN    V_GPIO4_OEN(1U)

#define S_GPIO3_OEN    19
#define V_GPIO3_OEN(x) ((x) << S_GPIO3_OEN)
#define F_GPIO3_OEN    V_GPIO3_OEN(1U)

#define S_GPIO2_OEN    18
#define V_GPIO2_OEN(x) ((x) << S_GPIO2_OEN)
#define F_GPIO2_OEN    V_GPIO2_OEN(1U)

#define S_GPIO1_OEN    17
#define V_GPIO1_OEN(x) ((x) << S_GPIO1_OEN)
#define F_GPIO1_OEN    V_GPIO1_OEN(1U)

#define S_GPIO0_OEN    16
#define V_GPIO0_OEN(x) ((x) << S_GPIO0_OEN)
#define F_GPIO0_OEN    V_GPIO0_OEN(1U)

#define S_GPIO15_OUT_VAL    15
#define V_GPIO15_OUT_VAL(x) ((x) << S_GPIO15_OUT_VAL)
#define F_GPIO15_OUT_VAL    V_GPIO15_OUT_VAL(1U)

#define S_GPIO14_OUT_VAL    14
#define V_GPIO14_OUT_VAL(x) ((x) << S_GPIO14_OUT_VAL)
#define F_GPIO14_OUT_VAL    V_GPIO14_OUT_VAL(1U)

#define S_GPIO13_OUT_VAL    13
#define V_GPIO13_OUT_VAL(x) ((x) << S_GPIO13_OUT_VAL)
#define F_GPIO13_OUT_VAL    V_GPIO13_OUT_VAL(1U)

#define S_GPIO12_OUT_VAL    12
#define V_GPIO12_OUT_VAL(x) ((x) << S_GPIO12_OUT_VAL)
#define F_GPIO12_OUT_VAL    V_GPIO12_OUT_VAL(1U)

#define S_GPIO11_OUT_VAL    11
#define V_GPIO11_OUT_VAL(x) ((x) << S_GPIO11_OUT_VAL)
#define F_GPIO11_OUT_VAL    V_GPIO11_OUT_VAL(1U)

#define S_GPIO10_OUT_VAL    10
#define V_GPIO10_OUT_VAL(x) ((x) << S_GPIO10_OUT_VAL)
#define F_GPIO10_OUT_VAL    V_GPIO10_OUT_VAL(1U)

#define S_GPIO9_OUT_VAL    9
#define V_GPIO9_OUT_VAL(x) ((x) << S_GPIO9_OUT_VAL)
#define F_GPIO9_OUT_VAL    V_GPIO9_OUT_VAL(1U)

#define S_GPIO8_OUT_VAL    8
#define V_GPIO8_OUT_VAL(x) ((x) << S_GPIO8_OUT_VAL)
#define F_GPIO8_OUT_VAL    V_GPIO8_OUT_VAL(1U)

#define S_GPIO7_OUT_VAL    7
#define V_GPIO7_OUT_VAL(x) ((x) << S_GPIO7_OUT_VAL)
#define F_GPIO7_OUT_VAL    V_GPIO7_OUT_VAL(1U)

#define S_GPIO6_OUT_VAL    6
#define V_GPIO6_OUT_VAL(x) ((x) << S_GPIO6_OUT_VAL)
#define F_GPIO6_OUT_VAL    V_GPIO6_OUT_VAL(1U)

#define S_GPIO5_OUT_VAL    5
#define V_GPIO5_OUT_VAL(x) ((x) << S_GPIO5_OUT_VAL)
#define F_GPIO5_OUT_VAL    V_GPIO5_OUT_VAL(1U)

#define S_GPIO4_OUT_VAL    4
#define V_GPIO4_OUT_VAL(x) ((x) << S_GPIO4_OUT_VAL)
#define F_GPIO4_OUT_VAL    V_GPIO4_OUT_VAL(1U)

#define S_GPIO3_OUT_VAL    3
#define V_GPIO3_OUT_VAL(x) ((x) << S_GPIO3_OUT_VAL)
#define F_GPIO3_OUT_VAL    V_GPIO3_OUT_VAL(1U)

#define S_GPIO2_OUT_VAL    2
#define V_GPIO2_OUT_VAL(x) ((x) << S_GPIO2_OUT_VAL)
#define F_GPIO2_OUT_VAL    V_GPIO2_OUT_VAL(1U)

#define S_GPIO1_OUT_VAL    1
#define V_GPIO1_OUT_VAL(x) ((x) << S_GPIO1_OUT_VAL)
#define F_GPIO1_OUT_VAL    V_GPIO1_OUT_VAL(1U)

#define S_GPIO0_OUT_VAL    0
#define V_GPIO0_OUT_VAL(x) ((x) << S_GPIO0_OUT_VAL)
#define F_GPIO0_OUT_VAL    V_GPIO0_OUT_VAL(1U)

#define A_DBG_GPIO_OUT 0x6010

#define S_GPIO23_OUT_VAL    23
#define V_GPIO23_OUT_VAL(x) ((x) << S_GPIO23_OUT_VAL)
#define F_GPIO23_OUT_VAL    V_GPIO23_OUT_VAL(1U)

#define S_GPIO22_OUT_VAL    22
#define V_GPIO22_OUT_VAL(x) ((x) << S_GPIO22_OUT_VAL)
#define F_GPIO22_OUT_VAL    V_GPIO22_OUT_VAL(1U)

#define S_GPIO21_OUT_VAL    21
#define V_GPIO21_OUT_VAL(x) ((x) << S_GPIO21_OUT_VAL)
#define F_GPIO21_OUT_VAL    V_GPIO21_OUT_VAL(1U)

#define S_GPIO20_OUT_VAL    20
#define V_GPIO20_OUT_VAL(x) ((x) << S_GPIO20_OUT_VAL)
#define F_GPIO20_OUT_VAL    V_GPIO20_OUT_VAL(1U)

#define S_T7_GPIO19_OUT_VAL    19
#define V_T7_GPIO19_OUT_VAL(x) ((x) << S_T7_GPIO19_OUT_VAL)
#define F_T7_GPIO19_OUT_VAL    V_T7_GPIO19_OUT_VAL(1U)

#define S_T7_GPIO18_OUT_VAL    18
#define V_T7_GPIO18_OUT_VAL(x) ((x) << S_T7_GPIO18_OUT_VAL)
#define F_T7_GPIO18_OUT_VAL    V_T7_GPIO18_OUT_VAL(1U)

#define S_T7_GPIO17_OUT_VAL    17
#define V_T7_GPIO17_OUT_VAL(x) ((x) << S_T7_GPIO17_OUT_VAL)
#define F_T7_GPIO17_OUT_VAL    V_T7_GPIO17_OUT_VAL(1U)

#define S_T7_GPIO16_OUT_VAL    16
#define V_T7_GPIO16_OUT_VAL(x) ((x) << S_T7_GPIO16_OUT_VAL)
#define F_T7_GPIO16_OUT_VAL    V_T7_GPIO16_OUT_VAL(1U)

#define A_DBG_GPIO_IN 0x6014

#define S_GPIO15_CHG_DET    31
#define V_GPIO15_CHG_DET(x) ((x) << S_GPIO15_CHG_DET)
#define F_GPIO15_CHG_DET    V_GPIO15_CHG_DET(1U)

#define S_GPIO14_CHG_DET    30
#define V_GPIO14_CHG_DET(x) ((x) << S_GPIO14_CHG_DET)
#define F_GPIO14_CHG_DET    V_GPIO14_CHG_DET(1U)

#define S_GPIO13_CHG_DET    29
#define V_GPIO13_CHG_DET(x) ((x) << S_GPIO13_CHG_DET)
#define F_GPIO13_CHG_DET    V_GPIO13_CHG_DET(1U)

#define S_GPIO12_CHG_DET    28
#define V_GPIO12_CHG_DET(x) ((x) << S_GPIO12_CHG_DET)
#define F_GPIO12_CHG_DET    V_GPIO12_CHG_DET(1U)

#define S_GPIO11_CHG_DET    27
#define V_GPIO11_CHG_DET(x) ((x) << S_GPIO11_CHG_DET)
#define F_GPIO11_CHG_DET    V_GPIO11_CHG_DET(1U)

#define S_GPIO10_CHG_DET    26
#define V_GPIO10_CHG_DET(x) ((x) << S_GPIO10_CHG_DET)
#define F_GPIO10_CHG_DET    V_GPIO10_CHG_DET(1U)

#define S_GPIO9_CHG_DET    25
#define V_GPIO9_CHG_DET(x) ((x) << S_GPIO9_CHG_DET)
#define F_GPIO9_CHG_DET    V_GPIO9_CHG_DET(1U)

#define S_GPIO8_CHG_DET    24
#define V_GPIO8_CHG_DET(x) ((x) << S_GPIO8_CHG_DET)
#define F_GPIO8_CHG_DET    V_GPIO8_CHG_DET(1U)

#define S_GPIO7_CHG_DET    23
#define V_GPIO7_CHG_DET(x) ((x) << S_GPIO7_CHG_DET)
#define F_GPIO7_CHG_DET    V_GPIO7_CHG_DET(1U)

#define S_GPIO6_CHG_DET    22
#define V_GPIO6_CHG_DET(x) ((x) << S_GPIO6_CHG_DET)
#define F_GPIO6_CHG_DET    V_GPIO6_CHG_DET(1U)

#define S_GPIO5_CHG_DET    21
#define V_GPIO5_CHG_DET(x) ((x) << S_GPIO5_CHG_DET)
#define F_GPIO5_CHG_DET    V_GPIO5_CHG_DET(1U)

#define S_GPIO4_CHG_DET    20
#define V_GPIO4_CHG_DET(x) ((x) << S_GPIO4_CHG_DET)
#define F_GPIO4_CHG_DET    V_GPIO4_CHG_DET(1U)

#define S_GPIO3_CHG_DET    19
#define V_GPIO3_CHG_DET(x) ((x) << S_GPIO3_CHG_DET)
#define F_GPIO3_CHG_DET    V_GPIO3_CHG_DET(1U)

#define S_GPIO2_CHG_DET    18
#define V_GPIO2_CHG_DET(x) ((x) << S_GPIO2_CHG_DET)
#define F_GPIO2_CHG_DET    V_GPIO2_CHG_DET(1U)

#define S_GPIO1_CHG_DET    17
#define V_GPIO1_CHG_DET(x) ((x) << S_GPIO1_CHG_DET)
#define F_GPIO1_CHG_DET    V_GPIO1_CHG_DET(1U)

#define S_GPIO0_CHG_DET    16
#define V_GPIO0_CHG_DET(x) ((x) << S_GPIO0_CHG_DET)
#define F_GPIO0_CHG_DET    V_GPIO0_CHG_DET(1U)

#define S_GPIO15_IN    15
#define V_GPIO15_IN(x) ((x) << S_GPIO15_IN)
#define F_GPIO15_IN    V_GPIO15_IN(1U)

#define S_GPIO14_IN    14
#define V_GPIO14_IN(x) ((x) << S_GPIO14_IN)
#define F_GPIO14_IN    V_GPIO14_IN(1U)

#define S_GPIO13_IN    13
#define V_GPIO13_IN(x) ((x) << S_GPIO13_IN)
#define F_GPIO13_IN    V_GPIO13_IN(1U)

#define S_GPIO12_IN    12
#define V_GPIO12_IN(x) ((x) << S_GPIO12_IN)
#define F_GPIO12_IN    V_GPIO12_IN(1U)

#define S_GPIO11_IN    11
#define V_GPIO11_IN(x) ((x) << S_GPIO11_IN)
#define F_GPIO11_IN    V_GPIO11_IN(1U)

#define S_GPIO10_IN    10
#define V_GPIO10_IN(x) ((x) << S_GPIO10_IN)
#define F_GPIO10_IN    V_GPIO10_IN(1U)

#define S_GPIO9_IN    9
#define V_GPIO9_IN(x) ((x) << S_GPIO9_IN)
#define F_GPIO9_IN    V_GPIO9_IN(1U)

#define S_GPIO8_IN    8
#define V_GPIO8_IN(x) ((x) << S_GPIO8_IN)
#define F_GPIO8_IN    V_GPIO8_IN(1U)

#define S_GPIO7_IN    7
#define V_GPIO7_IN(x) ((x) << S_GPIO7_IN)
#define F_GPIO7_IN    V_GPIO7_IN(1U)

#define S_GPIO6_IN    6
#define V_GPIO6_IN(x) ((x) << S_GPIO6_IN)
#define F_GPIO6_IN    V_GPIO6_IN(1U)

#define S_GPIO5_IN    5
#define V_GPIO5_IN(x) ((x) << S_GPIO5_IN)
#define F_GPIO5_IN    V_GPIO5_IN(1U)

#define S_GPIO4_IN    4
#define V_GPIO4_IN(x) ((x) << S_GPIO4_IN)
#define F_GPIO4_IN    V_GPIO4_IN(1U)

#define S_GPIO3_IN    3
#define V_GPIO3_IN(x) ((x) << S_GPIO3_IN)
#define F_GPIO3_IN    V_GPIO3_IN(1U)

#define S_GPIO2_IN    2
#define V_GPIO2_IN(x) ((x) << S_GPIO2_IN)
#define F_GPIO2_IN    V_GPIO2_IN(1U)

#define S_GPIO1_IN    1
#define V_GPIO1_IN(x) ((x) << S_GPIO1_IN)
#define F_GPIO1_IN    V_GPIO1_IN(1U)

#define S_GPIO0_IN    0
#define V_GPIO0_IN(x) ((x) << S_GPIO0_IN)
#define F_GPIO0_IN    V_GPIO0_IN(1U)

#define S_GPIO23_IN    23
#define V_GPIO23_IN(x) ((x) << S_GPIO23_IN)
#define F_GPIO23_IN    V_GPIO23_IN(1U)

#define S_GPIO22_IN    22
#define V_GPIO22_IN(x) ((x) << S_GPIO22_IN)
#define F_GPIO22_IN    V_GPIO22_IN(1U)

#define S_GPIO21_IN    21
#define V_GPIO21_IN(x) ((x) << S_GPIO21_IN)
#define F_GPIO21_IN    V_GPIO21_IN(1U)

#define S_GPIO20_IN    20
#define V_GPIO20_IN(x) ((x) << S_GPIO20_IN)
#define F_GPIO20_IN    V_GPIO20_IN(1U)

#define S_T7_GPIO19_IN    19
#define V_T7_GPIO19_IN(x) ((x) << S_T7_GPIO19_IN)
#define F_T7_GPIO19_IN    V_T7_GPIO19_IN(1U)

#define S_T7_GPIO18_IN    18
#define V_T7_GPIO18_IN(x) ((x) << S_T7_GPIO18_IN)
#define F_T7_GPIO18_IN    V_T7_GPIO18_IN(1U)

#define S_T7_GPIO17_IN    17
#define V_T7_GPIO17_IN(x) ((x) << S_T7_GPIO17_IN)
#define F_T7_GPIO17_IN    V_T7_GPIO17_IN(1U)

#define S_T7_GPIO16_IN    16
#define V_T7_GPIO16_IN(x) ((x) << S_T7_GPIO16_IN)
#define F_T7_GPIO16_IN    V_T7_GPIO16_IN(1U)

#define A_DBG_INT_ENABLE 0x6018

#define S_IBM_FDL_FAIL_INT_ENBL    25
#define V_IBM_FDL_FAIL_INT_ENBL(x) ((x) << S_IBM_FDL_FAIL_INT_ENBL)
#define F_IBM_FDL_FAIL_INT_ENBL    V_IBM_FDL_FAIL_INT_ENBL(1U)

#define S_ARM_FAIL_INT_ENBL    24
#define V_ARM_FAIL_INT_ENBL(x) ((x) << S_ARM_FAIL_INT_ENBL)
#define F_ARM_FAIL_INT_ENBL    V_ARM_FAIL_INT_ENBL(1U)

#define S_ARM_ERROR_OUT_INT_ENBL    23
#define V_ARM_ERROR_OUT_INT_ENBL(x) ((x) << S_ARM_ERROR_OUT_INT_ENBL)
#define F_ARM_ERROR_OUT_INT_ENBL    V_ARM_ERROR_OUT_INT_ENBL(1U)

#define S_PLL_LOCK_LOST_INT_ENBL    22
#define V_PLL_LOCK_LOST_INT_ENBL(x) ((x) << S_PLL_LOCK_LOST_INT_ENBL)
#define F_PLL_LOCK_LOST_INT_ENBL    V_PLL_LOCK_LOST_INT_ENBL(1U)

#define S_C_LOCK    21
#define V_C_LOCK(x) ((x) << S_C_LOCK)
#define F_C_LOCK    V_C_LOCK(1U)

#define S_M_LOCK    20
#define V_M_LOCK(x) ((x) << S_M_LOCK)
#define F_M_LOCK    V_M_LOCK(1U)

#define S_U_LOCK    19
#define V_U_LOCK(x) ((x) << S_U_LOCK)
#define F_U_LOCK    V_U_LOCK(1U)

#define S_PCIE_LOCK    18
#define V_PCIE_LOCK(x) ((x) << S_PCIE_LOCK)
#define F_PCIE_LOCK    V_PCIE_LOCK(1U)

#define S_KX_LOCK    17
#define V_KX_LOCK(x) ((x) << S_KX_LOCK)
#define F_KX_LOCK    V_KX_LOCK(1U)

#define S_KR_LOCK    16
#define V_KR_LOCK(x) ((x) << S_KR_LOCK)
#define F_KR_LOCK    V_KR_LOCK(1U)

#define S_GPIO15    15
#define V_GPIO15(x) ((x) << S_GPIO15)
#define F_GPIO15    V_GPIO15(1U)

#define S_GPIO14    14
#define V_GPIO14(x) ((x) << S_GPIO14)
#define F_GPIO14    V_GPIO14(1U)

#define S_GPIO13    13
#define V_GPIO13(x) ((x) << S_GPIO13)
#define F_GPIO13    V_GPIO13(1U)

#define S_GPIO12    12
#define V_GPIO12(x) ((x) << S_GPIO12)
#define F_GPIO12    V_GPIO12(1U)

#define S_GPIO11    11
#define V_GPIO11(x) ((x) << S_GPIO11)
#define F_GPIO11    V_GPIO11(1U)

#define S_GPIO10    10
#define V_GPIO10(x) ((x) << S_GPIO10)
#define F_GPIO10    V_GPIO10(1U)

#define S_GPIO9    9
#define V_GPIO9(x) ((x) << S_GPIO9)
#define F_GPIO9    V_GPIO9(1U)

#define S_GPIO8    8
#define V_GPIO8(x) ((x) << S_GPIO8)
#define F_GPIO8    V_GPIO8(1U)

#define S_GPIO7    7
#define V_GPIO7(x) ((x) << S_GPIO7)
#define F_GPIO7    V_GPIO7(1U)

#define S_GPIO6    6
#define V_GPIO6(x) ((x) << S_GPIO6)
#define F_GPIO6    V_GPIO6(1U)

#define S_GPIO5    5
#define V_GPIO5(x) ((x) << S_GPIO5)
#define F_GPIO5    V_GPIO5(1U)

#define S_GPIO4    4
#define V_GPIO4(x) ((x) << S_GPIO4)
#define F_GPIO4    V_GPIO4(1U)

#define S_GPIO3    3
#define V_GPIO3(x) ((x) << S_GPIO3)
#define F_GPIO3    V_GPIO3(1U)

#define S_GPIO2    2
#define V_GPIO2(x) ((x) << S_GPIO2)
#define F_GPIO2    V_GPIO2(1U)

#define S_GPIO1    1
#define V_GPIO1(x) ((x) << S_GPIO1)
#define F_GPIO1    V_GPIO1(1U)

#define S_GPIO0    0
#define V_GPIO0(x) ((x) << S_GPIO0)
#define F_GPIO0    V_GPIO0(1U)

#define S_GPIO19    29
#define V_GPIO19(x) ((x) << S_GPIO19)
#define F_GPIO19    V_GPIO19(1U)

#define S_GPIO18    28
#define V_GPIO18(x) ((x) << S_GPIO18)
#define F_GPIO18    V_GPIO18(1U)

#define S_GPIO17    27
#define V_GPIO17(x) ((x) << S_GPIO17)
#define F_GPIO17    V_GPIO17(1U)

#define S_GPIO16    26
#define V_GPIO16(x) ((x) << S_GPIO16)
#define F_GPIO16    V_GPIO16(1U)

#define S_USBFIFOPARERR    12
#define V_USBFIFOPARERR(x) ((x) << S_USBFIFOPARERR)
#define F_USBFIFOPARERR    V_USBFIFOPARERR(1U)

#define S_T7_IBM_FDL_FAIL_INT_ENBL    11
#define V_T7_IBM_FDL_FAIL_INT_ENBL(x) ((x) << S_T7_IBM_FDL_FAIL_INT_ENBL)
#define F_T7_IBM_FDL_FAIL_INT_ENBL    V_T7_IBM_FDL_FAIL_INT_ENBL(1U)

#define S_T7_PLL_LOCK_LOST_INT_ENBL    10
#define V_T7_PLL_LOCK_LOST_INT_ENBL(x) ((x) << S_T7_PLL_LOCK_LOST_INT_ENBL)
#define F_T7_PLL_LOCK_LOST_INT_ENBL    V_T7_PLL_LOCK_LOST_INT_ENBL(1U)

#define S_M1_LOCK    9
#define V_M1_LOCK(x) ((x) << S_M1_LOCK)
#define F_M1_LOCK    V_M1_LOCK(1U)

#define S_T7_PCIE_LOCK    8
#define V_T7_PCIE_LOCK(x) ((x) << S_T7_PCIE_LOCK)
#define F_T7_PCIE_LOCK    V_T7_PCIE_LOCK(1U)

#define S_T7_U_LOCK    7
#define V_T7_U_LOCK(x) ((x) << S_T7_U_LOCK)
#define F_T7_U_LOCK    V_T7_U_LOCK(1U)

#define S_MAC_LOCK    6
#define V_MAC_LOCK(x) ((x) << S_MAC_LOCK)
#define F_MAC_LOCK    V_MAC_LOCK(1U)

#define S_ARM_LOCK    5
#define V_ARM_LOCK(x) ((x) << S_ARM_LOCK)
#define F_ARM_LOCK    V_ARM_LOCK(1U)

#define S_M0_LOCK    4
#define V_M0_LOCK(x) ((x) << S_M0_LOCK)
#define F_M0_LOCK    V_M0_LOCK(1U)

#define S_XGPBUS_LOCK    3
#define V_XGPBUS_LOCK(x) ((x) << S_XGPBUS_LOCK)
#define F_XGPBUS_LOCK    V_XGPBUS_LOCK(1U)

#define S_XGPHY_LOCK    2
#define V_XGPHY_LOCK(x) ((x) << S_XGPHY_LOCK)
#define F_XGPHY_LOCK    V_XGPHY_LOCK(1U)

#define S_USB_LOCK    1
#define V_USB_LOCK(x) ((x) << S_USB_LOCK)
#define F_USB_LOCK    V_USB_LOCK(1U)

#define S_T7_C_LOCK    0
#define V_T7_C_LOCK(x) ((x) << S_T7_C_LOCK)
#define F_T7_C_LOCK    V_T7_C_LOCK(1U)

#define A_DBG_INT_CAUSE 0x601c

#define S_IBM_FDL_FAIL_INT_CAUSE    25
#define V_IBM_FDL_FAIL_INT_CAUSE(x) ((x) << S_IBM_FDL_FAIL_INT_CAUSE)
#define F_IBM_FDL_FAIL_INT_CAUSE    V_IBM_FDL_FAIL_INT_CAUSE(1U)

#define S_ARM_FAIL_INT_CAUSE    24
#define V_ARM_FAIL_INT_CAUSE(x) ((x) << S_ARM_FAIL_INT_CAUSE)
#define F_ARM_FAIL_INT_CAUSE    V_ARM_FAIL_INT_CAUSE(1U)

#define S_ARM_ERROR_OUT_INT_CAUSE    23
#define V_ARM_ERROR_OUT_INT_CAUSE(x) ((x) << S_ARM_ERROR_OUT_INT_CAUSE)
#define F_ARM_ERROR_OUT_INT_CAUSE    V_ARM_ERROR_OUT_INT_CAUSE(1U)

#define S_PLL_LOCK_LOST_INT_CAUSE    22
#define V_PLL_LOCK_LOST_INT_CAUSE(x) ((x) << S_PLL_LOCK_LOST_INT_CAUSE)
#define F_PLL_LOCK_LOST_INT_CAUSE    V_PLL_LOCK_LOST_INT_CAUSE(1U)

#define S_T7_IBM_FDL_FAIL_INT_CAUSE    11
#define V_T7_IBM_FDL_FAIL_INT_CAUSE(x) ((x) << S_T7_IBM_FDL_FAIL_INT_CAUSE)
#define F_T7_IBM_FDL_FAIL_INT_CAUSE    V_T7_IBM_FDL_FAIL_INT_CAUSE(1U)

#define S_T7_PLL_LOCK_LOST_INT_CAUSE    10
#define V_T7_PLL_LOCK_LOST_INT_CAUSE(x) ((x) << S_T7_PLL_LOCK_LOST_INT_CAUSE)
#define F_T7_PLL_LOCK_LOST_INT_CAUSE    V_T7_PLL_LOCK_LOST_INT_CAUSE(1U)

#define A_DBG_DBG0_RST_VALUE 0x6020

#define S_DEBUGDATA    0
#define M_DEBUGDATA    0xffffU
#define V_DEBUGDATA(x) ((x) << S_DEBUGDATA)
#define G_DEBUGDATA(x) (((x) >> S_DEBUGDATA) & M_DEBUGDATA)

#define A_DBG_OVERWRSERCFG_EN 0x6024

#define S_OVERWRSERCFG_EN    0
#define V_OVERWRSERCFG_EN(x) ((x) << S_OVERWRSERCFG_EN)
#define F_OVERWRSERCFG_EN    V_OVERWRSERCFG_EN(1U)

#define A_DBG_PLL_OCLK_PAD_EN 0x6028

#define S_PCIE_OCLK_EN    20
#define V_PCIE_OCLK_EN(x) ((x) << S_PCIE_OCLK_EN)
#define F_PCIE_OCLK_EN    V_PCIE_OCLK_EN(1U)

#define S_KX_OCLK_EN    16
#define V_KX_OCLK_EN(x) ((x) << S_KX_OCLK_EN)
#define F_KX_OCLK_EN    V_KX_OCLK_EN(1U)

#define S_U_OCLK_EN    12
#define V_U_OCLK_EN(x) ((x) << S_U_OCLK_EN)
#define F_U_OCLK_EN    V_U_OCLK_EN(1U)

#define S_KR_OCLK_EN    8
#define V_KR_OCLK_EN(x) ((x) << S_KR_OCLK_EN)
#define F_KR_OCLK_EN    V_KR_OCLK_EN(1U)

#define S_M_OCLK_EN    4
#define V_M_OCLK_EN(x) ((x) << S_M_OCLK_EN)
#define F_M_OCLK_EN    V_M_OCLK_EN(1U)

#define S_C_OCLK_EN    0
#define V_C_OCLK_EN(x) ((x) << S_C_OCLK_EN)
#define F_C_OCLK_EN    V_C_OCLK_EN(1U)

#define S_INIC_MODE_EN    0
#define V_INIC_MODE_EN(x) ((x) << S_INIC_MODE_EN)
#define F_INIC_MODE_EN    V_INIC_MODE_EN(1U)

#define A_DBG_PLL_LOCK 0x602c

#define S_PLL_P_LOCK    20
#define V_PLL_P_LOCK(x) ((x) << S_PLL_P_LOCK)
#define F_PLL_P_LOCK    V_PLL_P_LOCK(1U)

#define S_PLL_KX_LOCK    16
#define V_PLL_KX_LOCK(x) ((x) << S_PLL_KX_LOCK)
#define F_PLL_KX_LOCK    V_PLL_KX_LOCK(1U)

#define S_PLL_U_LOCK    12
#define V_PLL_U_LOCK(x) ((x) << S_PLL_U_LOCK)
#define F_PLL_U_LOCK    V_PLL_U_LOCK(1U)

#define S_PLL_KR_LOCK    8
#define V_PLL_KR_LOCK(x) ((x) << S_PLL_KR_LOCK)
#define F_PLL_KR_LOCK    V_PLL_KR_LOCK(1U)

#define S_PLL_M_LOCK    4
#define V_PLL_M_LOCK(x) ((x) << S_PLL_M_LOCK)
#define F_PLL_M_LOCK    V_PLL_M_LOCK(1U)

#define S_PLL_C_LOCK    0
#define V_PLL_C_LOCK(x) ((x) << S_PLL_C_LOCK)
#define F_PLL_C_LOCK    V_PLL_C_LOCK(1U)

#define S_T7_PLL_M_LOCK    9
#define V_T7_PLL_M_LOCK(x) ((x) << S_T7_PLL_M_LOCK)
#define F_T7_PLL_M_LOCK    V_T7_PLL_M_LOCK(1U)

#define S_PLL_PCIE_LOCK    8
#define V_PLL_PCIE_LOCK(x) ((x) << S_PLL_PCIE_LOCK)
#define F_PLL_PCIE_LOCK    V_PLL_PCIE_LOCK(1U)

#define S_T7_PLL_U_LOCK    7
#define V_T7_PLL_U_LOCK(x) ((x) << S_T7_PLL_U_LOCK)
#define F_T7_PLL_U_LOCK    V_T7_PLL_U_LOCK(1U)

#define S_PLL_MAC_LOCK    6
#define V_PLL_MAC_LOCK(x) ((x) << S_PLL_MAC_LOCK)
#define F_PLL_MAC_LOCK    V_PLL_MAC_LOCK(1U)

#define S_PLL_ARM_LOCK    5
#define V_PLL_ARM_LOCK(x) ((x) << S_PLL_ARM_LOCK)
#define F_PLL_ARM_LOCK    V_PLL_ARM_LOCK(1U)

#define S_PLL_XGPBUS_LOCK    3
#define V_PLL_XGPBUS_LOCK(x) ((x) << S_PLL_XGPBUS_LOCK)
#define F_PLL_XGPBUS_LOCK    V_PLL_XGPBUS_LOCK(1U)

#define S_PLL_XGPHY_LOCK    2
#define V_PLL_XGPHY_LOCK(x) ((x) << S_PLL_XGPHY_LOCK)
#define F_PLL_XGPHY_LOCK    V_PLL_XGPHY_LOCK(1U)

#define S_PLL_USB_LOCK    1
#define V_PLL_USB_LOCK(x) ((x) << S_PLL_USB_LOCK)
#define F_PLL_USB_LOCK    V_PLL_USB_LOCK(1U)

#define A_DBG_GPIO_ACT_LOW 0x6030

#define S_P_LOCK_ACT_LOW    21
#define V_P_LOCK_ACT_LOW(x) ((x) << S_P_LOCK_ACT_LOW)
#define F_P_LOCK_ACT_LOW    V_P_LOCK_ACT_LOW(1U)

#define S_C_LOCK_ACT_LOW    20
#define V_C_LOCK_ACT_LOW(x) ((x) << S_C_LOCK_ACT_LOW)
#define F_C_LOCK_ACT_LOW    V_C_LOCK_ACT_LOW(1U)

#define S_M_LOCK_ACT_LOW    19
#define V_M_LOCK_ACT_LOW(x) ((x) << S_M_LOCK_ACT_LOW)
#define F_M_LOCK_ACT_LOW    V_M_LOCK_ACT_LOW(1U)

#define S_U_LOCK_ACT_LOW    18
#define V_U_LOCK_ACT_LOW(x) ((x) << S_U_LOCK_ACT_LOW)
#define F_U_LOCK_ACT_LOW    V_U_LOCK_ACT_LOW(1U)

#define S_KR_LOCK_ACT_LOW    17
#define V_KR_LOCK_ACT_LOW(x) ((x) << S_KR_LOCK_ACT_LOW)
#define F_KR_LOCK_ACT_LOW    V_KR_LOCK_ACT_LOW(1U)

#define S_KX_LOCK_ACT_LOW    16
#define V_KX_LOCK_ACT_LOW(x) ((x) << S_KX_LOCK_ACT_LOW)
#define F_KX_LOCK_ACT_LOW    V_KX_LOCK_ACT_LOW(1U)

#define S_GPIO15_ACT_LOW    15
#define V_GPIO15_ACT_LOW(x) ((x) << S_GPIO15_ACT_LOW)
#define F_GPIO15_ACT_LOW    V_GPIO15_ACT_LOW(1U)

#define S_GPIO14_ACT_LOW    14
#define V_GPIO14_ACT_LOW(x) ((x) << S_GPIO14_ACT_LOW)
#define F_GPIO14_ACT_LOW    V_GPIO14_ACT_LOW(1U)

#define S_GPIO13_ACT_LOW    13
#define V_GPIO13_ACT_LOW(x) ((x) << S_GPIO13_ACT_LOW)
#define F_GPIO13_ACT_LOW    V_GPIO13_ACT_LOW(1U)

#define S_GPIO12_ACT_LOW    12
#define V_GPIO12_ACT_LOW(x) ((x) << S_GPIO12_ACT_LOW)
#define F_GPIO12_ACT_LOW    V_GPIO12_ACT_LOW(1U)

#define S_GPIO11_ACT_LOW    11
#define V_GPIO11_ACT_LOW(x) ((x) << S_GPIO11_ACT_LOW)
#define F_GPIO11_ACT_LOW    V_GPIO11_ACT_LOW(1U)

#define S_GPIO10_ACT_LOW    10
#define V_GPIO10_ACT_LOW(x) ((x) << S_GPIO10_ACT_LOW)
#define F_GPIO10_ACT_LOW    V_GPIO10_ACT_LOW(1U)

#define S_GPIO9_ACT_LOW    9
#define V_GPIO9_ACT_LOW(x) ((x) << S_GPIO9_ACT_LOW)
#define F_GPIO9_ACT_LOW    V_GPIO9_ACT_LOW(1U)

#define S_GPIO8_ACT_LOW    8
#define V_GPIO8_ACT_LOW(x) ((x) << S_GPIO8_ACT_LOW)
#define F_GPIO8_ACT_LOW    V_GPIO8_ACT_LOW(1U)

#define S_GPIO7_ACT_LOW    7
#define V_GPIO7_ACT_LOW(x) ((x) << S_GPIO7_ACT_LOW)
#define F_GPIO7_ACT_LOW    V_GPIO7_ACT_LOW(1U)

#define S_GPIO6_ACT_LOW    6
#define V_GPIO6_ACT_LOW(x) ((x) << S_GPIO6_ACT_LOW)
#define F_GPIO6_ACT_LOW    V_GPIO6_ACT_LOW(1U)

#define S_GPIO5_ACT_LOW    5
#define V_GPIO5_ACT_LOW(x) ((x) << S_GPIO5_ACT_LOW)
#define F_GPIO5_ACT_LOW    V_GPIO5_ACT_LOW(1U)

#define S_GPIO4_ACT_LOW    4
#define V_GPIO4_ACT_LOW(x) ((x) << S_GPIO4_ACT_LOW)
#define F_GPIO4_ACT_LOW    V_GPIO4_ACT_LOW(1U)

#define S_GPIO3_ACT_LOW    3
#define V_GPIO3_ACT_LOW(x) ((x) << S_GPIO3_ACT_LOW)
#define F_GPIO3_ACT_LOW    V_GPIO3_ACT_LOW(1U)

#define S_GPIO2_ACT_LOW    2
#define V_GPIO2_ACT_LOW(x) ((x) << S_GPIO2_ACT_LOW)
#define F_GPIO2_ACT_LOW    V_GPIO2_ACT_LOW(1U)

#define S_GPIO1_ACT_LOW    1
#define V_GPIO1_ACT_LOW(x) ((x) << S_GPIO1_ACT_LOW)
#define F_GPIO1_ACT_LOW    V_GPIO1_ACT_LOW(1U)

#define S_GPIO0_ACT_LOW    0
#define V_GPIO0_ACT_LOW(x) ((x) << S_GPIO0_ACT_LOW)
#define F_GPIO0_ACT_LOW    V_GPIO0_ACT_LOW(1U)

#define S_GPIO19_ACT_LOW    25
#define V_GPIO19_ACT_LOW(x) ((x) << S_GPIO19_ACT_LOW)
#define F_GPIO19_ACT_LOW    V_GPIO19_ACT_LOW(1U)

#define S_GPIO18_ACT_LOW    24
#define V_GPIO18_ACT_LOW(x) ((x) << S_GPIO18_ACT_LOW)
#define F_GPIO18_ACT_LOW    V_GPIO18_ACT_LOW(1U)

#define S_GPIO17_ACT_LOW    23
#define V_GPIO17_ACT_LOW(x) ((x) << S_GPIO17_ACT_LOW)
#define F_GPIO17_ACT_LOW    V_GPIO17_ACT_LOW(1U)

#define S_GPIO16_ACT_LOW    22
#define V_GPIO16_ACT_LOW(x) ((x) << S_GPIO16_ACT_LOW)
#define F_GPIO16_ACT_LOW    V_GPIO16_ACT_LOW(1U)

#define A_DBG_PLL_LOCK_ACT_LOW 0x6030

#define S_M1_LOCK_ACT_LOW    9
#define V_M1_LOCK_ACT_LOW(x) ((x) << S_M1_LOCK_ACT_LOW)
#define F_M1_LOCK_ACT_LOW    V_M1_LOCK_ACT_LOW(1U)

#define S_PCIE_LOCK_ACT_LOW    8
#define V_PCIE_LOCK_ACT_LOW(x) ((x) << S_PCIE_LOCK_ACT_LOW)
#define F_PCIE_LOCK_ACT_LOW    V_PCIE_LOCK_ACT_LOW(1U)

#define S_T7_U_LOCK_ACT_LOW    7
#define V_T7_U_LOCK_ACT_LOW(x) ((x) << S_T7_U_LOCK_ACT_LOW)
#define F_T7_U_LOCK_ACT_LOW    V_T7_U_LOCK_ACT_LOW(1U)

#define S_MAC_LOCK_ACT_LOW    6
#define V_MAC_LOCK_ACT_LOW(x) ((x) << S_MAC_LOCK_ACT_LOW)
#define F_MAC_LOCK_ACT_LOW    V_MAC_LOCK_ACT_LOW(1U)

#define S_ARM_LOCK_ACT_LOW    5
#define V_ARM_LOCK_ACT_LOW(x) ((x) << S_ARM_LOCK_ACT_LOW)
#define F_ARM_LOCK_ACT_LOW    V_ARM_LOCK_ACT_LOW(1U)

#define S_M0_LOCK_ACT_LOW    4
#define V_M0_LOCK_ACT_LOW(x) ((x) << S_M0_LOCK_ACT_LOW)
#define F_M0_LOCK_ACT_LOW    V_M0_LOCK_ACT_LOW(1U)

#define S_XGPBUS_LOCK_ACT_LOW    3
#define V_XGPBUS_LOCK_ACT_LOW(x) ((x) << S_XGPBUS_LOCK_ACT_LOW)
#define F_XGPBUS_LOCK_ACT_LOW    V_XGPBUS_LOCK_ACT_LOW(1U)

#define S_XGPHY_LOCK_ACT_LOW    2
#define V_XGPHY_LOCK_ACT_LOW(x) ((x) << S_XGPHY_LOCK_ACT_LOW)
#define F_XGPHY_LOCK_ACT_LOW    V_XGPHY_LOCK_ACT_LOW(1U)

#define S_USB_LOCK_ACT_LOW    1
#define V_USB_LOCK_ACT_LOW(x) ((x) << S_USB_LOCK_ACT_LOW)
#define F_USB_LOCK_ACT_LOW    V_USB_LOCK_ACT_LOW(1U)

#define S_T7_C_LOCK_ACT_LOW    0
#define V_T7_C_LOCK_ACT_LOW(x) ((x) << S_T7_C_LOCK_ACT_LOW)
#define F_T7_C_LOCK_ACT_LOW    V_T7_C_LOCK_ACT_LOW(1U)

#define A_DBG_EFUSE_BYTE0_3 0x6034
#define A_DBG_EFUSE_BYTE4_7 0x6038
#define A_DBG_EFUSE_BYTE8_11 0x603c
#define A_DBG_EFUSE_BYTE12_15 0x6040
#define A_DBG_STATIC_U_PLL_CONF 0x6044

#define S_STATIC_U_PLL_MULT    23
#define M_STATIC_U_PLL_MULT    0x1ffU
#define V_STATIC_U_PLL_MULT(x) ((x) << S_STATIC_U_PLL_MULT)
#define G_STATIC_U_PLL_MULT(x) (((x) >> S_STATIC_U_PLL_MULT) & M_STATIC_U_PLL_MULT)

#define S_STATIC_U_PLL_PREDIV    18
#define M_STATIC_U_PLL_PREDIV    0x1fU
#define V_STATIC_U_PLL_PREDIV(x) ((x) << S_STATIC_U_PLL_PREDIV)
#define G_STATIC_U_PLL_PREDIV(x) (((x) >> S_STATIC_U_PLL_PREDIV) & M_STATIC_U_PLL_PREDIV)

#define S_STATIC_U_PLL_RANGEA    14
#define M_STATIC_U_PLL_RANGEA    0xfU
#define V_STATIC_U_PLL_RANGEA(x) ((x) << S_STATIC_U_PLL_RANGEA)
#define G_STATIC_U_PLL_RANGEA(x) (((x) >> S_STATIC_U_PLL_RANGEA) & M_STATIC_U_PLL_RANGEA)

#define S_STATIC_U_PLL_RANGEB    10
#define M_STATIC_U_PLL_RANGEB    0xfU
#define V_STATIC_U_PLL_RANGEB(x) ((x) << S_STATIC_U_PLL_RANGEB)
#define G_STATIC_U_PLL_RANGEB(x) (((x) >> S_STATIC_U_PLL_RANGEB) & M_STATIC_U_PLL_RANGEB)

#define S_STATIC_U_PLL_TUNE    0
#define M_STATIC_U_PLL_TUNE    0x3ffU
#define V_STATIC_U_PLL_TUNE(x) ((x) << S_STATIC_U_PLL_TUNE)
#define G_STATIC_U_PLL_TUNE(x) (((x) >> S_STATIC_U_PLL_TUNE) & M_STATIC_U_PLL_TUNE)

#define A_T7_DBG_STATIC_U_PLL_CONF1 0x6044

#define S_STATIC_U_PLL_RANGE    22
#define M_STATIC_U_PLL_RANGE    0x7U
#define V_STATIC_U_PLL_RANGE(x) ((x) << S_STATIC_U_PLL_RANGE)
#define G_STATIC_U_PLL_RANGE(x) (((x) >> S_STATIC_U_PLL_RANGE) & M_STATIC_U_PLL_RANGE)

#define S_STATIC_U_PLL_DIVQ    17
#define M_STATIC_U_PLL_DIVQ    0x1fU
#define V_STATIC_U_PLL_DIVQ(x) ((x) << S_STATIC_U_PLL_DIVQ)
#define G_STATIC_U_PLL_DIVQ(x) (((x) >> S_STATIC_U_PLL_DIVQ) & M_STATIC_U_PLL_DIVQ)

#define S_STATIC_U_PLL_DIVFI    8
#define M_STATIC_U_PLL_DIVFI    0x1ffU
#define V_STATIC_U_PLL_DIVFI(x) ((x) << S_STATIC_U_PLL_DIVFI)
#define G_STATIC_U_PLL_DIVFI(x) (((x) >> S_STATIC_U_PLL_DIVFI) & M_STATIC_U_PLL_DIVFI)

#define S_STATIC_U_PLL_DIVR    2
#define M_STATIC_U_PLL_DIVR    0x3fU
#define V_STATIC_U_PLL_DIVR(x) ((x) << S_STATIC_U_PLL_DIVR)
#define G_STATIC_U_PLL_DIVR(x) (((x) >> S_STATIC_U_PLL_DIVR) & M_STATIC_U_PLL_DIVR)

#define S_T7_1_STATIC_U_PLL_BYPASS    1
#define V_T7_1_STATIC_U_PLL_BYPASS(x) ((x) << S_T7_1_STATIC_U_PLL_BYPASS)
#define F_T7_1_STATIC_U_PLL_BYPASS    V_T7_1_STATIC_U_PLL_BYPASS(1U)

#define A_DBG_STATIC_C_PLL_CONF 0x6048

#define S_STATIC_C_PLL_MULT    23
#define M_STATIC_C_PLL_MULT    0x1ffU
#define V_STATIC_C_PLL_MULT(x) ((x) << S_STATIC_C_PLL_MULT)
#define G_STATIC_C_PLL_MULT(x) (((x) >> S_STATIC_C_PLL_MULT) & M_STATIC_C_PLL_MULT)

#define S_STATIC_C_PLL_PREDIV    18
#define M_STATIC_C_PLL_PREDIV    0x1fU
#define V_STATIC_C_PLL_PREDIV(x) ((x) << S_STATIC_C_PLL_PREDIV)
#define G_STATIC_C_PLL_PREDIV(x) (((x) >> S_STATIC_C_PLL_PREDIV) & M_STATIC_C_PLL_PREDIV)

#define S_STATIC_C_PLL_RANGEA    14
#define M_STATIC_C_PLL_RANGEA    0xfU
#define V_STATIC_C_PLL_RANGEA(x) ((x) << S_STATIC_C_PLL_RANGEA)
#define G_STATIC_C_PLL_RANGEA(x) (((x) >> S_STATIC_C_PLL_RANGEA) & M_STATIC_C_PLL_RANGEA)

#define S_STATIC_C_PLL_RANGEB    10
#define M_STATIC_C_PLL_RANGEB    0xfU
#define V_STATIC_C_PLL_RANGEB(x) ((x) << S_STATIC_C_PLL_RANGEB)
#define G_STATIC_C_PLL_RANGEB(x) (((x) >> S_STATIC_C_PLL_RANGEB) & M_STATIC_C_PLL_RANGEB)

#define S_STATIC_C_PLL_TUNE    0
#define M_STATIC_C_PLL_TUNE    0x3ffU
#define V_STATIC_C_PLL_TUNE(x) ((x) << S_STATIC_C_PLL_TUNE)
#define G_STATIC_C_PLL_TUNE(x) (((x) >> S_STATIC_C_PLL_TUNE) & M_STATIC_C_PLL_TUNE)

#define A_T7_DBG_STATIC_U_PLL_CONF2 0x6048

#define S_STATIC_U_PLL_SSMF    5
#define M_STATIC_U_PLL_SSMF    0xfU
#define V_STATIC_U_PLL_SSMF(x) ((x) << S_STATIC_U_PLL_SSMF)
#define G_STATIC_U_PLL_SSMF(x) (((x) >> S_STATIC_U_PLL_SSMF) & M_STATIC_U_PLL_SSMF)

#define S_STATIC_U_PLL_SSMD    2
#define M_STATIC_U_PLL_SSMD    0x7U
#define V_STATIC_U_PLL_SSMD(x) ((x) << S_STATIC_U_PLL_SSMD)
#define G_STATIC_U_PLL_SSMD(x) (((x) >> S_STATIC_U_PLL_SSMD) & M_STATIC_U_PLL_SSMD)

#define S_STATIC_U_PLL_SSDS    1
#define V_STATIC_U_PLL_SSDS(x) ((x) << S_STATIC_U_PLL_SSDS)
#define F_STATIC_U_PLL_SSDS    V_STATIC_U_PLL_SSDS(1U)

#define S_STATIC_U_PLL_SSE    0
#define V_STATIC_U_PLL_SSE(x) ((x) << S_STATIC_U_PLL_SSE)
#define F_STATIC_U_PLL_SSE    V_STATIC_U_PLL_SSE(1U)

#define A_DBG_STATIC_M_PLL_CONF 0x604c

#define S_STATIC_M_PLL_MULT    23
#define M_STATIC_M_PLL_MULT    0x1ffU
#define V_STATIC_M_PLL_MULT(x) ((x) << S_STATIC_M_PLL_MULT)
#define G_STATIC_M_PLL_MULT(x) (((x) >> S_STATIC_M_PLL_MULT) & M_STATIC_M_PLL_MULT)

#define S_STATIC_M_PLL_PREDIV    18
#define M_STATIC_M_PLL_PREDIV    0x1fU
#define V_STATIC_M_PLL_PREDIV(x) ((x) << S_STATIC_M_PLL_PREDIV)
#define G_STATIC_M_PLL_PREDIV(x) (((x) >> S_STATIC_M_PLL_PREDIV) & M_STATIC_M_PLL_PREDIV)

#define S_STATIC_M_PLL_RANGEA    14
#define M_STATIC_M_PLL_RANGEA    0xfU
#define V_STATIC_M_PLL_RANGEA(x) ((x) << S_STATIC_M_PLL_RANGEA)
#define G_STATIC_M_PLL_RANGEA(x) (((x) >> S_STATIC_M_PLL_RANGEA) & M_STATIC_M_PLL_RANGEA)

#define S_STATIC_M_PLL_RANGEB    10
#define M_STATIC_M_PLL_RANGEB    0xfU
#define V_STATIC_M_PLL_RANGEB(x) ((x) << S_STATIC_M_PLL_RANGEB)
#define G_STATIC_M_PLL_RANGEB(x) (((x) >> S_STATIC_M_PLL_RANGEB) & M_STATIC_M_PLL_RANGEB)

#define S_STATIC_M_PLL_TUNE    0
#define M_STATIC_M_PLL_TUNE    0x3ffU
#define V_STATIC_M_PLL_TUNE(x) ((x) << S_STATIC_M_PLL_TUNE)
#define G_STATIC_M_PLL_TUNE(x) (((x) >> S_STATIC_M_PLL_TUNE) & M_STATIC_M_PLL_TUNE)

#define A_T7_DBG_STATIC_C_PLL_CONF1 0x604c

#define S_STATIC_C_PLL_RANGE    22
#define M_STATIC_C_PLL_RANGE    0x7U
#define V_STATIC_C_PLL_RANGE(x) ((x) << S_STATIC_C_PLL_RANGE)
#define G_STATIC_C_PLL_RANGE(x) (((x) >> S_STATIC_C_PLL_RANGE) & M_STATIC_C_PLL_RANGE)

#define S_STATIC_C_PLL_DIVQ    17
#define M_STATIC_C_PLL_DIVQ    0x1fU
#define V_STATIC_C_PLL_DIVQ(x) ((x) << S_STATIC_C_PLL_DIVQ)
#define G_STATIC_C_PLL_DIVQ(x) (((x) >> S_STATIC_C_PLL_DIVQ) & M_STATIC_C_PLL_DIVQ)

#define S_STATIC_C_PLL_DIVFI    8
#define M_STATIC_C_PLL_DIVFI    0x1ffU
#define V_STATIC_C_PLL_DIVFI(x) ((x) << S_STATIC_C_PLL_DIVFI)
#define G_STATIC_C_PLL_DIVFI(x) (((x) >> S_STATIC_C_PLL_DIVFI) & M_STATIC_C_PLL_DIVFI)

#define S_STATIC_C_PLL_DIVR    2
#define M_STATIC_C_PLL_DIVR    0x3fU
#define V_STATIC_C_PLL_DIVR(x) ((x) << S_STATIC_C_PLL_DIVR)
#define G_STATIC_C_PLL_DIVR(x) (((x) >> S_STATIC_C_PLL_DIVR) & M_STATIC_C_PLL_DIVR)

#define S_T7_1_STATIC_C_PLL_BYPASS    1
#define V_T7_1_STATIC_C_PLL_BYPASS(x) ((x) << S_T7_1_STATIC_C_PLL_BYPASS)
#define F_T7_1_STATIC_C_PLL_BYPASS    V_T7_1_STATIC_C_PLL_BYPASS(1U)

#define A_DBG_STATIC_KX_PLL_CONF 0x6050

#define S_STATIC_KX_PLL_C    21
#define M_STATIC_KX_PLL_C    0xffU
#define V_STATIC_KX_PLL_C(x) ((x) << S_STATIC_KX_PLL_C)
#define G_STATIC_KX_PLL_C(x) (((x) >> S_STATIC_KX_PLL_C) & M_STATIC_KX_PLL_C)

#define S_STATIC_KX_PLL_M    15
#define M_STATIC_KX_PLL_M    0x3fU
#define V_STATIC_KX_PLL_M(x) ((x) << S_STATIC_KX_PLL_M)
#define G_STATIC_KX_PLL_M(x) (((x) >> S_STATIC_KX_PLL_M) & M_STATIC_KX_PLL_M)

#define S_STATIC_KX_PLL_N1    11
#define M_STATIC_KX_PLL_N1    0xfU
#define V_STATIC_KX_PLL_N1(x) ((x) << S_STATIC_KX_PLL_N1)
#define G_STATIC_KX_PLL_N1(x) (((x) >> S_STATIC_KX_PLL_N1) & M_STATIC_KX_PLL_N1)

#define S_STATIC_KX_PLL_N2    7
#define M_STATIC_KX_PLL_N2    0xfU
#define V_STATIC_KX_PLL_N2(x) ((x) << S_STATIC_KX_PLL_N2)
#define G_STATIC_KX_PLL_N2(x) (((x) >> S_STATIC_KX_PLL_N2) & M_STATIC_KX_PLL_N2)

#define S_STATIC_KX_PLL_N3    3
#define M_STATIC_KX_PLL_N3    0xfU
#define V_STATIC_KX_PLL_N3(x) ((x) << S_STATIC_KX_PLL_N3)
#define G_STATIC_KX_PLL_N3(x) (((x) >> S_STATIC_KX_PLL_N3) & M_STATIC_KX_PLL_N3)

#define S_STATIC_KX_PLL_P    0
#define M_STATIC_KX_PLL_P    0x7U
#define V_STATIC_KX_PLL_P(x) ((x) << S_STATIC_KX_PLL_P)
#define G_STATIC_KX_PLL_P(x) (((x) >> S_STATIC_KX_PLL_P) & M_STATIC_KX_PLL_P)

#define A_T7_DBG_STATIC_C_PLL_CONF2 0x6050

#define S_STATIC_C_PLL_SSMF    5
#define M_STATIC_C_PLL_SSMF    0xfU
#define V_STATIC_C_PLL_SSMF(x) ((x) << S_STATIC_C_PLL_SSMF)
#define G_STATIC_C_PLL_SSMF(x) (((x) >> S_STATIC_C_PLL_SSMF) & M_STATIC_C_PLL_SSMF)

#define S_STATIC_C_PLL_SSMD    2
#define M_STATIC_C_PLL_SSMD    0x7U
#define V_STATIC_C_PLL_SSMD(x) ((x) << S_STATIC_C_PLL_SSMD)
#define G_STATIC_C_PLL_SSMD(x) (((x) >> S_STATIC_C_PLL_SSMD) & M_STATIC_C_PLL_SSMD)

#define S_STATIC_C_PLL_SSDS    1
#define V_STATIC_C_PLL_SSDS(x) ((x) << S_STATIC_C_PLL_SSDS)
#define F_STATIC_C_PLL_SSDS    V_STATIC_C_PLL_SSDS(1U)

#define S_STATIC_C_PLL_SSE    0
#define V_STATIC_C_PLL_SSE(x) ((x) << S_STATIC_C_PLL_SSE)
#define F_STATIC_C_PLL_SSE    V_STATIC_C_PLL_SSE(1U)

#define A_DBG_STATIC_KR_PLL_CONF 0x6054

#define S_STATIC_KR_PLL_C    21
#define M_STATIC_KR_PLL_C    0xffU
#define V_STATIC_KR_PLL_C(x) ((x) << S_STATIC_KR_PLL_C)
#define G_STATIC_KR_PLL_C(x) (((x) >> S_STATIC_KR_PLL_C) & M_STATIC_KR_PLL_C)

#define S_STATIC_KR_PLL_M    15
#define M_STATIC_KR_PLL_M    0x3fU
#define V_STATIC_KR_PLL_M(x) ((x) << S_STATIC_KR_PLL_M)
#define G_STATIC_KR_PLL_M(x) (((x) >> S_STATIC_KR_PLL_M) & M_STATIC_KR_PLL_M)

#define S_STATIC_KR_PLL_N1    11
#define M_STATIC_KR_PLL_N1    0xfU
#define V_STATIC_KR_PLL_N1(x) ((x) << S_STATIC_KR_PLL_N1)
#define G_STATIC_KR_PLL_N1(x) (((x) >> S_STATIC_KR_PLL_N1) & M_STATIC_KR_PLL_N1)

#define S_STATIC_KR_PLL_N2    7
#define M_STATIC_KR_PLL_N2    0xfU
#define V_STATIC_KR_PLL_N2(x) ((x) << S_STATIC_KR_PLL_N2)
#define G_STATIC_KR_PLL_N2(x) (((x) >> S_STATIC_KR_PLL_N2) & M_STATIC_KR_PLL_N2)

#define S_STATIC_KR_PLL_N3    3
#define M_STATIC_KR_PLL_N3    0xfU
#define V_STATIC_KR_PLL_N3(x) ((x) << S_STATIC_KR_PLL_N3)
#define G_STATIC_KR_PLL_N3(x) (((x) >> S_STATIC_KR_PLL_N3) & M_STATIC_KR_PLL_N3)

#define S_STATIC_KR_PLL_P    0
#define M_STATIC_KR_PLL_P    0x7U
#define V_STATIC_KR_PLL_P(x) ((x) << S_STATIC_KR_PLL_P)
#define G_STATIC_KR_PLL_P(x) (((x) >> S_STATIC_KR_PLL_P) & M_STATIC_KR_PLL_P)

#define A_DBG_STATIC_PLL_DFS_CONF 0x6054

#define S_STATIC_U_DFS_ACK    23
#define V_STATIC_U_DFS_ACK(x) ((x) << S_STATIC_U_DFS_ACK)
#define F_STATIC_U_DFS_ACK    V_STATIC_U_DFS_ACK(1U)

#define S_STATIC_C_DFS_ACK    22
#define V_STATIC_C_DFS_ACK(x) ((x) << S_STATIC_C_DFS_ACK)
#define F_STATIC_C_DFS_ACK    V_STATIC_C_DFS_ACK(1U)

#define S_STATIC_U_DFS_DIVFI    13
#define M_STATIC_U_DFS_DIVFI    0x1ffU
#define V_STATIC_U_DFS_DIVFI(x) ((x) << S_STATIC_U_DFS_DIVFI)
#define G_STATIC_U_DFS_DIVFI(x) (((x) >> S_STATIC_U_DFS_DIVFI) & M_STATIC_U_DFS_DIVFI)

#define S_STATIC_U_DFS_NEWDIV    12
#define V_STATIC_U_DFS_NEWDIV(x) ((x) << S_STATIC_U_DFS_NEWDIV)
#define F_STATIC_U_DFS_NEWDIV    V_STATIC_U_DFS_NEWDIV(1U)

#define S_T7_STATIC_U_DFS_ENABLE    11
#define V_T7_STATIC_U_DFS_ENABLE(x) ((x) << S_T7_STATIC_U_DFS_ENABLE)
#define F_T7_STATIC_U_DFS_ENABLE    V_T7_STATIC_U_DFS_ENABLE(1U)

#define S_STATIC_C_DFS_DIVFI    2
#define M_STATIC_C_DFS_DIVFI    0x1ffU
#define V_STATIC_C_DFS_DIVFI(x) ((x) << S_STATIC_C_DFS_DIVFI)
#define G_STATIC_C_DFS_DIVFI(x) (((x) >> S_STATIC_C_DFS_DIVFI) & M_STATIC_C_DFS_DIVFI)

#define S_STATIC_C_DFS_NEWDIV    1
#define V_STATIC_C_DFS_NEWDIV(x) ((x) << S_STATIC_C_DFS_NEWDIV)
#define F_STATIC_C_DFS_NEWDIV    V_STATIC_C_DFS_NEWDIV(1U)

#define A_DBG_EXTRA_STATIC_BITS_CONF 0x6058

#define S_STATIC_M_PLL_RESET    30
#define V_STATIC_M_PLL_RESET(x) ((x) << S_STATIC_M_PLL_RESET)
#define F_STATIC_M_PLL_RESET    V_STATIC_M_PLL_RESET(1U)

#define S_STATIC_M_PLL_SLEEP    29
#define V_STATIC_M_PLL_SLEEP(x) ((x) << S_STATIC_M_PLL_SLEEP)
#define F_STATIC_M_PLL_SLEEP    V_STATIC_M_PLL_SLEEP(1U)

#define S_STATIC_M_PLL_BYPASS    28
#define V_STATIC_M_PLL_BYPASS(x) ((x) << S_STATIC_M_PLL_BYPASS)
#define F_STATIC_M_PLL_BYPASS    V_STATIC_M_PLL_BYPASS(1U)

#define S_STATIC_MPLL_CLK_SEL    27
#define V_STATIC_MPLL_CLK_SEL(x) ((x) << S_STATIC_MPLL_CLK_SEL)
#define F_STATIC_MPLL_CLK_SEL    V_STATIC_MPLL_CLK_SEL(1U)

#define S_STATIC_U_PLL_SLEEP    26
#define V_STATIC_U_PLL_SLEEP(x) ((x) << S_STATIC_U_PLL_SLEEP)
#define F_STATIC_U_PLL_SLEEP    V_STATIC_U_PLL_SLEEP(1U)

#define S_STATIC_C_PLL_SLEEP    25
#define V_STATIC_C_PLL_SLEEP(x) ((x) << S_STATIC_C_PLL_SLEEP)
#define F_STATIC_C_PLL_SLEEP    V_STATIC_C_PLL_SLEEP(1U)

#define S_STATIC_LVDS_CLKOUT_SEL    23
#define M_STATIC_LVDS_CLKOUT_SEL    0x3U
#define V_STATIC_LVDS_CLKOUT_SEL(x) ((x) << S_STATIC_LVDS_CLKOUT_SEL)
#define G_STATIC_LVDS_CLKOUT_SEL(x) (((x) >> S_STATIC_LVDS_CLKOUT_SEL) & M_STATIC_LVDS_CLKOUT_SEL)

#define S_STATIC_LVDS_CLKOUT_EN    22
#define V_STATIC_LVDS_CLKOUT_EN(x) ((x) << S_STATIC_LVDS_CLKOUT_EN)
#define F_STATIC_LVDS_CLKOUT_EN    V_STATIC_LVDS_CLKOUT_EN(1U)

#define S_STATIC_CCLK_FREQ_SEL    20
#define M_STATIC_CCLK_FREQ_SEL    0x3U
#define V_STATIC_CCLK_FREQ_SEL(x) ((x) << S_STATIC_CCLK_FREQ_SEL)
#define G_STATIC_CCLK_FREQ_SEL(x) (((x) >> S_STATIC_CCLK_FREQ_SEL) & M_STATIC_CCLK_FREQ_SEL)

#define S_STATIC_UCLK_FREQ_SEL    18
#define M_STATIC_UCLK_FREQ_SEL    0x3U
#define V_STATIC_UCLK_FREQ_SEL(x) ((x) << S_STATIC_UCLK_FREQ_SEL)
#define G_STATIC_UCLK_FREQ_SEL(x) (((x) >> S_STATIC_UCLK_FREQ_SEL) & M_STATIC_UCLK_FREQ_SEL)

#define S_EXPHYCLK_SEL_EN    17
#define V_EXPHYCLK_SEL_EN(x) ((x) << S_EXPHYCLK_SEL_EN)
#define F_EXPHYCLK_SEL_EN    V_EXPHYCLK_SEL_EN(1U)

#define S_EXPHYCLK_SEL    15
#define M_EXPHYCLK_SEL    0x3U
#define V_EXPHYCLK_SEL(x) ((x) << S_EXPHYCLK_SEL)
#define G_EXPHYCLK_SEL(x) (((x) >> S_EXPHYCLK_SEL) & M_EXPHYCLK_SEL)

#define S_STATIC_U_PLL_BYPASS    14
#define V_STATIC_U_PLL_BYPASS(x) ((x) << S_STATIC_U_PLL_BYPASS)
#define F_STATIC_U_PLL_BYPASS    V_STATIC_U_PLL_BYPASS(1U)

#define S_STATIC_C_PLL_BYPASS    13
#define V_STATIC_C_PLL_BYPASS(x) ((x) << S_STATIC_C_PLL_BYPASS)
#define F_STATIC_C_PLL_BYPASS    V_STATIC_C_PLL_BYPASS(1U)

#define S_STATIC_KR_PLL_BYPASS    12
#define V_STATIC_KR_PLL_BYPASS(x) ((x) << S_STATIC_KR_PLL_BYPASS)
#define F_STATIC_KR_PLL_BYPASS    V_STATIC_KR_PLL_BYPASS(1U)

#define S_STATIC_KX_PLL_BYPASS    11
#define V_STATIC_KX_PLL_BYPASS(x) ((x) << S_STATIC_KX_PLL_BYPASS)
#define F_STATIC_KX_PLL_BYPASS    V_STATIC_KX_PLL_BYPASS(1U)

#define S_STATIC_KX_PLL_V    7
#define M_STATIC_KX_PLL_V    0xfU
#define V_STATIC_KX_PLL_V(x) ((x) << S_STATIC_KX_PLL_V)
#define G_STATIC_KX_PLL_V(x) (((x) >> S_STATIC_KX_PLL_V) & M_STATIC_KX_PLL_V)

#define S_STATIC_KR_PLL_V    3
#define M_STATIC_KR_PLL_V    0xfU
#define V_STATIC_KR_PLL_V(x) ((x) << S_STATIC_KR_PLL_V)
#define G_STATIC_KR_PLL_V(x) (((x) >> S_STATIC_KR_PLL_V) & M_STATIC_KR_PLL_V)

#define S_PSRO_SEL    0
#define M_PSRO_SEL    0x7U
#define V_PSRO_SEL(x) ((x) << S_PSRO_SEL)
#define G_PSRO_SEL(x) (((x) >> S_PSRO_SEL) & M_PSRO_SEL)

#define S_T7_STATIC_LVDS_CLKOUT_EN    21
#define V_T7_STATIC_LVDS_CLKOUT_EN(x) ((x) << S_T7_STATIC_LVDS_CLKOUT_EN)
#define F_T7_STATIC_LVDS_CLKOUT_EN    V_T7_STATIC_LVDS_CLKOUT_EN(1U)

#define S_T7_EXPHYCLK_SEL_EN    16
#define V_T7_EXPHYCLK_SEL_EN(x) ((x) << S_T7_EXPHYCLK_SEL_EN)
#define F_T7_EXPHYCLK_SEL_EN    V_T7_EXPHYCLK_SEL_EN(1U)

#define A_DBG_STATIC_OCLK_MUXSEL_CONF 0x605c

#define S_M_OCLK_MUXSEL    12
#define V_M_OCLK_MUXSEL(x) ((x) << S_M_OCLK_MUXSEL)
#define F_M_OCLK_MUXSEL    V_M_OCLK_MUXSEL(1U)

#define S_C_OCLK_MUXSEL    10
#define M_C_OCLK_MUXSEL    0x3U
#define V_C_OCLK_MUXSEL(x) ((x) << S_C_OCLK_MUXSEL)
#define G_C_OCLK_MUXSEL(x) (((x) >> S_C_OCLK_MUXSEL) & M_C_OCLK_MUXSEL)

#define S_U_OCLK_MUXSEL    8
#define M_U_OCLK_MUXSEL    0x3U
#define V_U_OCLK_MUXSEL(x) ((x) << S_U_OCLK_MUXSEL)
#define G_U_OCLK_MUXSEL(x) (((x) >> S_U_OCLK_MUXSEL) & M_U_OCLK_MUXSEL)

#define S_P_OCLK_MUXSEL    6
#define M_P_OCLK_MUXSEL    0x3U
#define V_P_OCLK_MUXSEL(x) ((x) << S_P_OCLK_MUXSEL)
#define G_P_OCLK_MUXSEL(x) (((x) >> S_P_OCLK_MUXSEL) & M_P_OCLK_MUXSEL)

#define S_KX_OCLK_MUXSEL    3
#define M_KX_OCLK_MUXSEL    0x7U
#define V_KX_OCLK_MUXSEL(x) ((x) << S_KX_OCLK_MUXSEL)
#define G_KX_OCLK_MUXSEL(x) (((x) >> S_KX_OCLK_MUXSEL) & M_KX_OCLK_MUXSEL)

#define S_KR_OCLK_MUXSEL    0
#define M_KR_OCLK_MUXSEL    0x7U
#define V_KR_OCLK_MUXSEL(x) ((x) << S_KR_OCLK_MUXSEL)
#define G_KR_OCLK_MUXSEL(x) (((x) >> S_KR_OCLK_MUXSEL) & M_KR_OCLK_MUXSEL)

#define S_T5_P_OCLK_MUXSEL    13
#define M_T5_P_OCLK_MUXSEL    0xfU
#define V_T5_P_OCLK_MUXSEL(x) ((x) << S_T5_P_OCLK_MUXSEL)
#define G_T5_P_OCLK_MUXSEL(x) (((x) >> S_T5_P_OCLK_MUXSEL) & M_T5_P_OCLK_MUXSEL)

#define S_T6_P_OCLK_MUXSEL    13
#define M_T6_P_OCLK_MUXSEL    0xfU
#define V_T6_P_OCLK_MUXSEL(x) ((x) << S_T6_P_OCLK_MUXSEL)
#define G_T6_P_OCLK_MUXSEL(x) (((x) >> S_T6_P_OCLK_MUXSEL) & M_T6_P_OCLK_MUXSEL)

#define A_DBG_TRACE0_CONF_COMPREG0 0x6060
#define A_DBG_TRACE0_CONF_COMPREG1 0x6064
#define A_DBG_TRACE1_CONF_COMPREG0 0x6068
#define A_DBG_TRACE1_CONF_COMPREG1 0x606c
#define A_DBG_TRACE0_CONF_MASKREG0 0x6070
#define A_DBG_TRACE0_CONF_MASKREG1 0x6074
#define A_DBG_TRACE1_CONF_MASKREG0 0x6078
#define A_DBG_TRACE1_CONF_MASKREG1 0x607c
#define A_DBG_TRACE_COUNTER 0x6080

#define S_COUNTER1    16
#define M_COUNTER1    0xffffU
#define V_COUNTER1(x) ((x) << S_COUNTER1)
#define G_COUNTER1(x) (((x) >> S_COUNTER1) & M_COUNTER1)

#define S_COUNTER0    0
#define M_COUNTER0    0xffffU
#define V_COUNTER0(x) ((x) << S_COUNTER0)
#define G_COUNTER0(x) (((x) >> S_COUNTER0) & M_COUNTER0)

#define A_DBG_STATIC_REFCLK_PERIOD 0x6084

#define S_STATIC_REFCLK_PERIOD    0
#define M_STATIC_REFCLK_PERIOD    0xffffU
#define V_STATIC_REFCLK_PERIOD(x) ((x) << S_STATIC_REFCLK_PERIOD)
#define G_STATIC_REFCLK_PERIOD(x) (((x) >> S_STATIC_REFCLK_PERIOD) & M_STATIC_REFCLK_PERIOD)

#define A_DBG_TRACE_CONF 0x6088

#define S_DBG_TRACE_OPERATE_WITH_TRG    5
#define V_DBG_TRACE_OPERATE_WITH_TRG(x) ((x) << S_DBG_TRACE_OPERATE_WITH_TRG)
#define F_DBG_TRACE_OPERATE_WITH_TRG    V_DBG_TRACE_OPERATE_WITH_TRG(1U)

#define S_DBG_TRACE_OPERATE_EN    4
#define V_DBG_TRACE_OPERATE_EN(x) ((x) << S_DBG_TRACE_OPERATE_EN)
#define F_DBG_TRACE_OPERATE_EN    V_DBG_TRACE_OPERATE_EN(1U)

#define S_DBG_OPERATE_INDV_COMBINED    3
#define V_DBG_OPERATE_INDV_COMBINED(x) ((x) << S_DBG_OPERATE_INDV_COMBINED)
#define F_DBG_OPERATE_INDV_COMBINED    V_DBG_OPERATE_INDV_COMBINED(1U)

#define S_DBG_OPERATE_ORDER_OF_TRIGGER    2
#define V_DBG_OPERATE_ORDER_OF_TRIGGER(x) ((x) << S_DBG_OPERATE_ORDER_OF_TRIGGER)
#define F_DBG_OPERATE_ORDER_OF_TRIGGER    V_DBG_OPERATE_ORDER_OF_TRIGGER(1U)

#define S_DBG_OPERATE_SGL_DBL_TRIGGER    1
#define V_DBG_OPERATE_SGL_DBL_TRIGGER(x) ((x) << S_DBG_OPERATE_SGL_DBL_TRIGGER)
#define F_DBG_OPERATE_SGL_DBL_TRIGGER    V_DBG_OPERATE_SGL_DBL_TRIGGER(1U)

#define S_DBG_OPERATE0_OR_1    0
#define V_DBG_OPERATE0_OR_1(x) ((x) << S_DBG_OPERATE0_OR_1)
#define F_DBG_OPERATE0_OR_1    V_DBG_OPERATE0_OR_1(1U)

#define A_DBG_TRACE_RDEN 0x608c

#define S_RD_ADDR1    10
#define M_RD_ADDR1    0xffU
#define V_RD_ADDR1(x) ((x) << S_RD_ADDR1)
#define G_RD_ADDR1(x) (((x) >> S_RD_ADDR1) & M_RD_ADDR1)

#define S_RD_ADDR0    2
#define M_RD_ADDR0    0xffU
#define V_RD_ADDR0(x) ((x) << S_RD_ADDR0)
#define G_RD_ADDR0(x) (((x) >> S_RD_ADDR0) & M_RD_ADDR0)

#define S_RD_EN1    1
#define V_RD_EN1(x) ((x) << S_RD_EN1)
#define F_RD_EN1    V_RD_EN1(1U)

#define S_RD_EN0    0
#define V_RD_EN0(x) ((x) << S_RD_EN0)
#define F_RD_EN0    V_RD_EN0(1U)

#define S_T5_RD_ADDR1    11
#define M_T5_RD_ADDR1    0x1ffU
#define V_T5_RD_ADDR1(x) ((x) << S_T5_RD_ADDR1)
#define G_T5_RD_ADDR1(x) (((x) >> S_T5_RD_ADDR1) & M_T5_RD_ADDR1)

#define S_T5_RD_ADDR0    2
#define M_T5_RD_ADDR0    0x1ffU
#define V_T5_RD_ADDR0(x) ((x) << S_T5_RD_ADDR0)
#define G_T5_RD_ADDR0(x) (((x) >> S_T5_RD_ADDR0) & M_T5_RD_ADDR0)

#define A_DBG_TRACE_WRADDR 0x6090

#define S_WR_POINTER_ADDR1    16
#define M_WR_POINTER_ADDR1    0xffU
#define V_WR_POINTER_ADDR1(x) ((x) << S_WR_POINTER_ADDR1)
#define G_WR_POINTER_ADDR1(x) (((x) >> S_WR_POINTER_ADDR1) & M_WR_POINTER_ADDR1)

#define S_WR_POINTER_ADDR0    0
#define M_WR_POINTER_ADDR0    0xffU
#define V_WR_POINTER_ADDR0(x) ((x) << S_WR_POINTER_ADDR0)
#define G_WR_POINTER_ADDR0(x) (((x) >> S_WR_POINTER_ADDR0) & M_WR_POINTER_ADDR0)

#define S_T5_WR_POINTER_ADDR1    16
#define M_T5_WR_POINTER_ADDR1    0x1ffU
#define V_T5_WR_POINTER_ADDR1(x) ((x) << S_T5_WR_POINTER_ADDR1)
#define G_T5_WR_POINTER_ADDR1(x) (((x) >> S_T5_WR_POINTER_ADDR1) & M_T5_WR_POINTER_ADDR1)

#define S_T5_WR_POINTER_ADDR0    0
#define M_T5_WR_POINTER_ADDR0    0x1ffU
#define V_T5_WR_POINTER_ADDR0(x) ((x) << S_T5_WR_POINTER_ADDR0)
#define G_T5_WR_POINTER_ADDR0(x) (((x) >> S_T5_WR_POINTER_ADDR0) & M_T5_WR_POINTER_ADDR0)

#define A_DBG_TRACE0_DATA_OUT 0x6094
#define A_DBG_TRACE1_DATA_OUT 0x6098
#define A_DBG_FUSE_SENSE_DONE 0x609c

#define S_STATIC_JTAG_VERSIONNR    5
#define M_STATIC_JTAG_VERSIONNR    0xfU
#define V_STATIC_JTAG_VERSIONNR(x) ((x) << S_STATIC_JTAG_VERSIONNR)
#define G_STATIC_JTAG_VERSIONNR(x) (((x) >> S_STATIC_JTAG_VERSIONNR) & M_STATIC_JTAG_VERSIONNR)

#define S_UNQ0    1
#define M_UNQ0    0xfU
#define V_UNQ0(x) ((x) << S_UNQ0)
#define G_UNQ0(x) (((x) >> S_UNQ0) & M_UNQ0)

#define S_FUSE_DONE_SENSE    0
#define V_FUSE_DONE_SENSE(x) ((x) << S_FUSE_DONE_SENSE)
#define F_FUSE_DONE_SENSE    V_FUSE_DONE_SENSE(1U)

#define A_DBG_TVSENSE_EN 0x60a8

#define S_MCIMPED1_OUT    29
#define V_MCIMPED1_OUT(x) ((x) << S_MCIMPED1_OUT)
#define F_MCIMPED1_OUT    V_MCIMPED1_OUT(1U)

#define S_MCIMPED2_OUT    28
#define V_MCIMPED2_OUT(x) ((x) << S_MCIMPED2_OUT)
#define F_MCIMPED2_OUT    V_MCIMPED2_OUT(1U)

#define S_TVSENSE_SNSOUT    17
#define M_TVSENSE_SNSOUT    0x1ffU
#define V_TVSENSE_SNSOUT(x) ((x) << S_TVSENSE_SNSOUT)
#define G_TVSENSE_SNSOUT(x) (((x) >> S_TVSENSE_SNSOUT) & M_TVSENSE_SNSOUT)

#define S_TVSENSE_OUTPUTVALID    16
#define V_TVSENSE_OUTPUTVALID(x) ((x) << S_TVSENSE_OUTPUTVALID)
#define F_TVSENSE_OUTPUTVALID    V_TVSENSE_OUTPUTVALID(1U)

#define S_TVSENSE_SLEEP    10
#define V_TVSENSE_SLEEP(x) ((x) << S_TVSENSE_SLEEP)
#define F_TVSENSE_SLEEP    V_TVSENSE_SLEEP(1U)

#define S_TVSENSE_SENSV    9
#define V_TVSENSE_SENSV(x) ((x) << S_TVSENSE_SENSV)
#define F_TVSENSE_SENSV    V_TVSENSE_SENSV(1U)

#define S_TVSENSE_RST    8
#define V_TVSENSE_RST(x) ((x) << S_TVSENSE_RST)
#define F_TVSENSE_RST    V_TVSENSE_RST(1U)

#define S_TVSENSE_RATIO    0
#define M_TVSENSE_RATIO    0xffU
#define V_TVSENSE_RATIO(x) ((x) << S_TVSENSE_RATIO)
#define G_TVSENSE_RATIO(x) (((x) >> S_TVSENSE_RATIO) & M_TVSENSE_RATIO)

#define S_T6_TVSENSE_SLEEP    11
#define V_T6_TVSENSE_SLEEP(x) ((x) << S_T6_TVSENSE_SLEEP)
#define F_T6_TVSENSE_SLEEP    V_T6_TVSENSE_SLEEP(1U)

#define S_T6_TVSENSE_SENSV    10
#define V_T6_TVSENSE_SENSV(x) ((x) << S_T6_TVSENSE_SENSV)
#define F_T6_TVSENSE_SENSV    V_T6_TVSENSE_SENSV(1U)

#define S_T6_TVSENSE_RST    9
#define V_T6_TVSENSE_RST(x) ((x) << S_T6_TVSENSE_RST)
#define F_T6_TVSENSE_RST    V_T6_TVSENSE_RST(1U)

#define A_DBG_PVT_EN1 0x60a8

#define S_PVT_TRIMO    18
#define M_PVT_TRIMO    0x3fU
#define V_PVT_TRIMO(x) ((x) << S_PVT_TRIMO)
#define G_PVT_TRIMO(x) (((x) >> S_PVT_TRIMO) & M_PVT_TRIMO)

#define S_PVT_TRIMG    13
#define M_PVT_TRIMG    0x1fU
#define V_PVT_TRIMG(x) ((x) << S_PVT_TRIMG)
#define G_PVT_TRIMG(x) (((x) >> S_PVT_TRIMG) & M_PVT_TRIMG)

#define S_PVT_VSAMPLE    12
#define V_PVT_VSAMPLE(x) ((x) << S_PVT_VSAMPLE)
#define F_PVT_VSAMPLE    V_PVT_VSAMPLE(1U)

#define S_PVT_PSAMPLE    10
#define M_PVT_PSAMPLE    0x3U
#define V_PVT_PSAMPLE(x) ((x) << S_PVT_PSAMPLE)
#define G_PVT_PSAMPLE(x) (((x) >> S_PVT_PSAMPLE) & M_PVT_PSAMPLE)

#define S_PVT_ENA    9
#define V_PVT_ENA(x) ((x) << S_PVT_ENA)
#define F_PVT_ENA    V_PVT_ENA(1U)

#define S_PVT_RESET    8
#define V_PVT_RESET(x) ((x) << S_PVT_RESET)
#define F_PVT_RESET    V_PVT_RESET(1U)

#define S_PVT_DIV    0
#define M_PVT_DIV    0xffU
#define V_PVT_DIV(x) ((x) << S_PVT_DIV)
#define G_PVT_DIV(x) (((x) >> S_PVT_DIV) & M_PVT_DIV)

#define A_DBG_CUST_EFUSE_OUT_EN 0x60ac
#define A_DBG_PVT_EN2 0x60ac

#define S_PVT_DATA_OUT    1
#define M_PVT_DATA_OUT    0x3ffU
#define V_PVT_DATA_OUT(x) ((x) << S_PVT_DATA_OUT)
#define G_PVT_DATA_OUT(x) (((x) >> S_PVT_DATA_OUT) & M_PVT_DATA_OUT)

#define S_PVT_DATA_VALID    0
#define V_PVT_DATA_VALID(x) ((x) << S_PVT_DATA_VALID)
#define F_PVT_DATA_VALID    V_PVT_DATA_VALID(1U)

#define A_DBG_CUST_EFUSE_SEL1_EN 0x60b0
#define A_DBG_CUST_EFUSE_SEL2_EN 0x60b4

#define S_DBG_FEENABLE    29
#define V_DBG_FEENABLE(x) ((x) << S_DBG_FEENABLE)
#define F_DBG_FEENABLE    V_DBG_FEENABLE(1U)

#define S_DBG_FEF    23
#define M_DBG_FEF    0x3fU
#define V_DBG_FEF(x) ((x) << S_DBG_FEF)
#define G_DBG_FEF(x) (((x) >> S_DBG_FEF) & M_DBG_FEF)

#define S_DBG_FEMIMICN    22
#define V_DBG_FEMIMICN(x) ((x) << S_DBG_FEMIMICN)
#define F_DBG_FEMIMICN    V_DBG_FEMIMICN(1U)

#define S_DBG_FEGATEC    21
#define V_DBG_FEGATEC(x) ((x) << S_DBG_FEGATEC)
#define F_DBG_FEGATEC    V_DBG_FEGATEC(1U)

#define S_DBG_FEPROGP    20
#define V_DBG_FEPROGP(x) ((x) << S_DBG_FEPROGP)
#define F_DBG_FEPROGP    V_DBG_FEPROGP(1U)

#define S_DBG_FEREADCLK    19
#define V_DBG_FEREADCLK(x) ((x) << S_DBG_FEREADCLK)
#define F_DBG_FEREADCLK    V_DBG_FEREADCLK(1U)

#define S_DBG_FERSEL    3
#define M_DBG_FERSEL    0xffffU
#define V_DBG_FERSEL(x) ((x) << S_DBG_FERSEL)
#define G_DBG_FERSEL(x) (((x) >> S_DBG_FERSEL) & M_DBG_FERSEL)

#define S_DBG_FETIME    0
#define M_DBG_FETIME    0x7U
#define V_DBG_FETIME(x) ((x) << S_DBG_FETIME)
#define G_DBG_FETIME(x) (((x) >> S_DBG_FETIME) & M_DBG_FETIME)

#define A_DBG_T5_STATIC_M_PLL_CONF1 0x60b8

#define S_T5_STATIC_M_PLL_MULTFRAC    8
#define M_T5_STATIC_M_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_M_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_M_PLL_MULTFRAC)
#define G_T5_STATIC_M_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_M_PLL_MULTFRAC) & M_T5_STATIC_M_PLL_MULTFRAC)

#define S_T5_STATIC_M_PLL_FFSLEWRATE    0
#define M_T5_STATIC_M_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_M_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_M_PLL_FFSLEWRATE)
#define G_T5_STATIC_M_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_M_PLL_FFSLEWRATE) & M_T5_STATIC_M_PLL_FFSLEWRATE)

#define A_DBG_STATIC_M_PLL_CONF1 0x60b8

#define S_STATIC_M_PLL_MULTFRAC    8
#define M_STATIC_M_PLL_MULTFRAC    0xffffffU
#define V_STATIC_M_PLL_MULTFRAC(x) ((x) << S_STATIC_M_PLL_MULTFRAC)
#define G_STATIC_M_PLL_MULTFRAC(x) (((x) >> S_STATIC_M_PLL_MULTFRAC) & M_STATIC_M_PLL_MULTFRAC)

#define S_STATIC_M_PLL_FFSLEWRATE    0
#define M_STATIC_M_PLL_FFSLEWRATE    0xffU
#define V_STATIC_M_PLL_FFSLEWRATE(x) ((x) << S_STATIC_M_PLL_FFSLEWRATE)
#define G_STATIC_M_PLL_FFSLEWRATE(x) (((x) >> S_STATIC_M_PLL_FFSLEWRATE) & M_STATIC_M_PLL_FFSLEWRATE)

#define A_DBG_STATIC_M0_PLL_CONF1 0x60b8

#define S_STATIC_M0_PLL_RANGE    22
#define M_STATIC_M0_PLL_RANGE    0x7U
#define V_STATIC_M0_PLL_RANGE(x) ((x) << S_STATIC_M0_PLL_RANGE)
#define G_STATIC_M0_PLL_RANGE(x) (((x) >> S_STATIC_M0_PLL_RANGE) & M_STATIC_M0_PLL_RANGE)

#define S_STATIC_M0_PLL_DIVQ    17
#define M_STATIC_M0_PLL_DIVQ    0x1fU
#define V_STATIC_M0_PLL_DIVQ(x) ((x) << S_STATIC_M0_PLL_DIVQ)
#define G_STATIC_M0_PLL_DIVQ(x) (((x) >> S_STATIC_M0_PLL_DIVQ) & M_STATIC_M0_PLL_DIVQ)

#define S_STATIC_M0_PLL_DIVFI    8
#define M_STATIC_M0_PLL_DIVFI    0x1ffU
#define V_STATIC_M0_PLL_DIVFI(x) ((x) << S_STATIC_M0_PLL_DIVFI)
#define G_STATIC_M0_PLL_DIVFI(x) (((x) >> S_STATIC_M0_PLL_DIVFI) & M_STATIC_M0_PLL_DIVFI)

#define S_STATIC_M0_PLL_DIVR    2
#define M_STATIC_M0_PLL_DIVR    0x3fU
#define V_STATIC_M0_PLL_DIVR(x) ((x) << S_STATIC_M0_PLL_DIVR)
#define G_STATIC_M0_PLL_DIVR(x) (((x) >> S_STATIC_M0_PLL_DIVR) & M_STATIC_M0_PLL_DIVR)

#define S_STATIC_M0_PLL_BYPASS    1
#define V_STATIC_M0_PLL_BYPASS(x) ((x) << S_STATIC_M0_PLL_BYPASS)
#define F_STATIC_M0_PLL_BYPASS    V_STATIC_M0_PLL_BYPASS(1U)

#define S_STATIC_M0_PLL_RESET    0
#define V_STATIC_M0_PLL_RESET(x) ((x) << S_STATIC_M0_PLL_RESET)
#define F_STATIC_M0_PLL_RESET    V_STATIC_M0_PLL_RESET(1U)

#define A_DBG_T5_STATIC_M_PLL_CONF2 0x60bc

#define S_T5_STATIC_M_PLL_DCO_BYPASS    23
#define V_T5_STATIC_M_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_M_PLL_DCO_BYPASS)
#define F_T5_STATIC_M_PLL_DCO_BYPASS    V_T5_STATIC_M_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_M_PLL_SDORDER    21
#define M_T5_STATIC_M_PLL_SDORDER    0x3U
#define V_T5_STATIC_M_PLL_SDORDER(x) ((x) << S_T5_STATIC_M_PLL_SDORDER)
#define G_T5_STATIC_M_PLL_SDORDER(x) (((x) >> S_T5_STATIC_M_PLL_SDORDER) & M_T5_STATIC_M_PLL_SDORDER)

#define S_T5_STATIC_M_PLL_FFENABLE    20
#define V_T5_STATIC_M_PLL_FFENABLE(x) ((x) << S_T5_STATIC_M_PLL_FFENABLE)
#define F_T5_STATIC_M_PLL_FFENABLE    V_T5_STATIC_M_PLL_FFENABLE(1U)

#define S_T5_STATIC_M_PLL_STOPCLKB    19
#define V_T5_STATIC_M_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_M_PLL_STOPCLKB)
#define F_T5_STATIC_M_PLL_STOPCLKB    V_T5_STATIC_M_PLL_STOPCLKB(1U)

#define S_T5_STATIC_M_PLL_STOPCLKA    18
#define V_T5_STATIC_M_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_M_PLL_STOPCLKA)
#define F_T5_STATIC_M_PLL_STOPCLKA    V_T5_STATIC_M_PLL_STOPCLKA(1U)

#define S_T5_STATIC_M_PLL_SLEEP    17
#define V_T5_STATIC_M_PLL_SLEEP(x) ((x) << S_T5_STATIC_M_PLL_SLEEP)
#define F_T5_STATIC_M_PLL_SLEEP    V_T5_STATIC_M_PLL_SLEEP(1U)

#define S_T5_STATIC_M_PLL_BYPASS    16
#define V_T5_STATIC_M_PLL_BYPASS(x) ((x) << S_T5_STATIC_M_PLL_BYPASS)
#define F_T5_STATIC_M_PLL_BYPASS    V_T5_STATIC_M_PLL_BYPASS(1U)

#define S_T5_STATIC_M_PLL_LOCKTUNE    0
#define M_T5_STATIC_M_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_M_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_M_PLL_LOCKTUNE)
#define G_T5_STATIC_M_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_M_PLL_LOCKTUNE) & M_T5_STATIC_M_PLL_LOCKTUNE)

#define A_DBG_STATIC_M_PLL_CONF2 0x60bc

#define S_T6_STATIC_M_PLL_PREDIV    24
#define M_T6_STATIC_M_PLL_PREDIV    0x3fU
#define V_T6_STATIC_M_PLL_PREDIV(x) ((x) << S_T6_STATIC_M_PLL_PREDIV)
#define G_T6_STATIC_M_PLL_PREDIV(x) (((x) >> S_T6_STATIC_M_PLL_PREDIV) & M_T6_STATIC_M_PLL_PREDIV)

#define S_STATIC_M_PLL_DCO_BYPASS    23
#define V_STATIC_M_PLL_DCO_BYPASS(x) ((x) << S_STATIC_M_PLL_DCO_BYPASS)
#define F_STATIC_M_PLL_DCO_BYPASS    V_STATIC_M_PLL_DCO_BYPASS(1U)

#define S_STATIC_M_PLL_SDORDER    21
#define M_STATIC_M_PLL_SDORDER    0x3U
#define V_STATIC_M_PLL_SDORDER(x) ((x) << S_STATIC_M_PLL_SDORDER)
#define G_STATIC_M_PLL_SDORDER(x) (((x) >> S_STATIC_M_PLL_SDORDER) & M_STATIC_M_PLL_SDORDER)

#define S_STATIC_M_PLL_FFENABLE    20
#define V_STATIC_M_PLL_FFENABLE(x) ((x) << S_STATIC_M_PLL_FFENABLE)
#define F_STATIC_M_PLL_FFENABLE    V_STATIC_M_PLL_FFENABLE(1U)

#define S_STATIC_M_PLL_STOPCLKB    19
#define V_STATIC_M_PLL_STOPCLKB(x) ((x) << S_STATIC_M_PLL_STOPCLKB)
#define F_STATIC_M_PLL_STOPCLKB    V_STATIC_M_PLL_STOPCLKB(1U)

#define S_STATIC_M_PLL_STOPCLKA    18
#define V_STATIC_M_PLL_STOPCLKA(x) ((x) << S_STATIC_M_PLL_STOPCLKA)
#define F_STATIC_M_PLL_STOPCLKA    V_STATIC_M_PLL_STOPCLKA(1U)

#define S_T6_STATIC_M_PLL_SLEEP    17
#define V_T6_STATIC_M_PLL_SLEEP(x) ((x) << S_T6_STATIC_M_PLL_SLEEP)
#define F_T6_STATIC_M_PLL_SLEEP    V_T6_STATIC_M_PLL_SLEEP(1U)

#define S_T6_STATIC_M_PLL_BYPASS    16
#define V_T6_STATIC_M_PLL_BYPASS(x) ((x) << S_T6_STATIC_M_PLL_BYPASS)
#define F_T6_STATIC_M_PLL_BYPASS    V_T6_STATIC_M_PLL_BYPASS(1U)

#define S_STATIC_M_PLL_LOCKTUNE    0
#define M_STATIC_M_PLL_LOCKTUNE    0x1fU
#define V_STATIC_M_PLL_LOCKTUNE(x) ((x) << S_STATIC_M_PLL_LOCKTUNE)
#define G_STATIC_M_PLL_LOCKTUNE(x) (((x) >> S_STATIC_M_PLL_LOCKTUNE) & M_STATIC_M_PLL_LOCKTUNE)

#define A_DBG_STATIC_M0_PLL_CONF2 0x60bc

#define S_T7_STATIC_SWMC1RST_    14
#define V_T7_STATIC_SWMC1RST_(x) ((x) << S_T7_STATIC_SWMC1RST_)
#define F_T7_STATIC_SWMC1RST_    V_T7_STATIC_SWMC1RST_(1U)

#define S_T7_STATIC_SWMC1CFGRST_    13
#define V_T7_STATIC_SWMC1CFGRST_(x) ((x) << S_T7_STATIC_SWMC1CFGRST_)
#define F_T7_STATIC_SWMC1CFGRST_    V_T7_STATIC_SWMC1CFGRST_(1U)

#define S_T7_STATIC_PHY0RECRST_    12
#define V_T7_STATIC_PHY0RECRST_(x) ((x) << S_T7_STATIC_PHY0RECRST_)
#define F_T7_STATIC_PHY0RECRST_    V_T7_STATIC_PHY0RECRST_(1U)

#define S_T7_STATIC_PHY1RECRST_    11
#define V_T7_STATIC_PHY1RECRST_(x) ((x) << S_T7_STATIC_PHY1RECRST_)
#define F_T7_STATIC_PHY1RECRST_    V_T7_STATIC_PHY1RECRST_(1U)

#define S_T7_STATIC_SWMC0RST_    10
#define V_T7_STATIC_SWMC0RST_(x) ((x) << S_T7_STATIC_SWMC0RST_)
#define F_T7_STATIC_SWMC0RST_    V_T7_STATIC_SWMC0RST_(1U)

#define S_T7_STATIC_SWMC0CFGRST_    9
#define V_T7_STATIC_SWMC0CFGRST_(x) ((x) << S_T7_STATIC_SWMC0CFGRST_)
#define F_T7_STATIC_SWMC0CFGRST_    V_T7_STATIC_SWMC0CFGRST_(1U)

#define S_STATIC_M0_PLL_SSMF    5
#define M_STATIC_M0_PLL_SSMF    0xfU
#define V_STATIC_M0_PLL_SSMF(x) ((x) << S_STATIC_M0_PLL_SSMF)
#define G_STATIC_M0_PLL_SSMF(x) (((x) >> S_STATIC_M0_PLL_SSMF) & M_STATIC_M0_PLL_SSMF)

#define S_STATIC_M0_PLL_SSMD    2
#define M_STATIC_M0_PLL_SSMD    0x7U
#define V_STATIC_M0_PLL_SSMD(x) ((x) << S_STATIC_M0_PLL_SSMD)
#define G_STATIC_M0_PLL_SSMD(x) (((x) >> S_STATIC_M0_PLL_SSMD) & M_STATIC_M0_PLL_SSMD)

#define S_STATIC_M0_PLL_SSDS    1
#define V_STATIC_M0_PLL_SSDS(x) ((x) << S_STATIC_M0_PLL_SSDS)
#define F_STATIC_M0_PLL_SSDS    V_STATIC_M0_PLL_SSDS(1U)

#define S_STATIC_M0_PLL_SSE    0
#define V_STATIC_M0_PLL_SSE(x) ((x) << S_STATIC_M0_PLL_SSE)
#define F_STATIC_M0_PLL_SSE    V_STATIC_M0_PLL_SSE(1U)

#define A_DBG_T5_STATIC_M_PLL_CONF3 0x60c0

#define S_T5_STATIC_M_PLL_MULTPRE    30
#define M_T5_STATIC_M_PLL_MULTPRE    0x3U
#define V_T5_STATIC_M_PLL_MULTPRE(x) ((x) << S_T5_STATIC_M_PLL_MULTPRE)
#define G_T5_STATIC_M_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_M_PLL_MULTPRE) & M_T5_STATIC_M_PLL_MULTPRE)

#define S_T5_STATIC_M_PLL_LOCKSEL    28
#define M_T5_STATIC_M_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_M_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_M_PLL_LOCKSEL)
#define G_T5_STATIC_M_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_M_PLL_LOCKSEL) & M_T5_STATIC_M_PLL_LOCKSEL)

#define S_T5_STATIC_M_PLL_FFTUNE    12
#define M_T5_STATIC_M_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_M_PLL_FFTUNE(x) ((x) << S_T5_STATIC_M_PLL_FFTUNE)
#define G_T5_STATIC_M_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_M_PLL_FFTUNE) & M_T5_STATIC_M_PLL_FFTUNE)

#define S_T5_STATIC_M_PLL_RANGEPRE    10
#define M_T5_STATIC_M_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_M_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_M_PLL_RANGEPRE)
#define G_T5_STATIC_M_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_M_PLL_RANGEPRE) & M_T5_STATIC_M_PLL_RANGEPRE)

#define S_T5_STATIC_M_PLL_RANGEB    5
#define M_T5_STATIC_M_PLL_RANGEB    0x1fU
#define V_T5_STATIC_M_PLL_RANGEB(x) ((x) << S_T5_STATIC_M_PLL_RANGEB)
#define G_T5_STATIC_M_PLL_RANGEB(x) (((x) >> S_T5_STATIC_M_PLL_RANGEB) & M_T5_STATIC_M_PLL_RANGEB)

#define S_T5_STATIC_M_PLL_RANGEA    0
#define M_T5_STATIC_M_PLL_RANGEA    0x1fU
#define V_T5_STATIC_M_PLL_RANGEA(x) ((x) << S_T5_STATIC_M_PLL_RANGEA)
#define G_T5_STATIC_M_PLL_RANGEA(x) (((x) >> S_T5_STATIC_M_PLL_RANGEA) & M_T5_STATIC_M_PLL_RANGEA)

#define A_DBG_STATIC_M_PLL_CONF3 0x60c0

#define S_STATIC_M_PLL_MULTPRE    30
#define M_STATIC_M_PLL_MULTPRE    0x3U
#define V_STATIC_M_PLL_MULTPRE(x) ((x) << S_STATIC_M_PLL_MULTPRE)
#define G_STATIC_M_PLL_MULTPRE(x) (((x) >> S_STATIC_M_PLL_MULTPRE) & M_STATIC_M_PLL_MULTPRE)

#define S_STATIC_M_PLL_LOCKSEL    28
#define V_STATIC_M_PLL_LOCKSEL(x) ((x) << S_STATIC_M_PLL_LOCKSEL)
#define F_STATIC_M_PLL_LOCKSEL    V_STATIC_M_PLL_LOCKSEL(1U)

#define S_STATIC_M_PLL_FFTUNE    12
#define M_STATIC_M_PLL_FFTUNE    0xffffU
#define V_STATIC_M_PLL_FFTUNE(x) ((x) << S_STATIC_M_PLL_FFTUNE)
#define G_STATIC_M_PLL_FFTUNE(x) (((x) >> S_STATIC_M_PLL_FFTUNE) & M_STATIC_M_PLL_FFTUNE)

#define S_STATIC_M_PLL_RANGEPRE    10
#define M_STATIC_M_PLL_RANGEPRE    0x3U
#define V_STATIC_M_PLL_RANGEPRE(x) ((x) << S_STATIC_M_PLL_RANGEPRE)
#define G_STATIC_M_PLL_RANGEPRE(x) (((x) >> S_STATIC_M_PLL_RANGEPRE) & M_STATIC_M_PLL_RANGEPRE)

#define S_T6_STATIC_M_PLL_RANGEB    5
#define M_T6_STATIC_M_PLL_RANGEB    0x1fU
#define V_T6_STATIC_M_PLL_RANGEB(x) ((x) << S_T6_STATIC_M_PLL_RANGEB)
#define G_T6_STATIC_M_PLL_RANGEB(x) (((x) >> S_T6_STATIC_M_PLL_RANGEB) & M_T6_STATIC_M_PLL_RANGEB)

#define S_T6_STATIC_M_PLL_RANGEA    0
#define M_T6_STATIC_M_PLL_RANGEA    0x1fU
#define V_T6_STATIC_M_PLL_RANGEA(x) ((x) << S_T6_STATIC_M_PLL_RANGEA)
#define G_T6_STATIC_M_PLL_RANGEA(x) (((x) >> S_T6_STATIC_M_PLL_RANGEA) & M_T6_STATIC_M_PLL_RANGEA)

#define A_DBG_STATIC_MAC_PLL_CONF1 0x60c0

#define S_STATIC_MAC_PLL_RANGE    22
#define M_STATIC_MAC_PLL_RANGE    0x7U
#define V_STATIC_MAC_PLL_RANGE(x) ((x) << S_STATIC_MAC_PLL_RANGE)
#define G_STATIC_MAC_PLL_RANGE(x) (((x) >> S_STATIC_MAC_PLL_RANGE) & M_STATIC_MAC_PLL_RANGE)

#define S_STATIC_MAC_PLL_DIVQ    17
#define M_STATIC_MAC_PLL_DIVQ    0x1fU
#define V_STATIC_MAC_PLL_DIVQ(x) ((x) << S_STATIC_MAC_PLL_DIVQ)
#define G_STATIC_MAC_PLL_DIVQ(x) (((x) >> S_STATIC_MAC_PLL_DIVQ) & M_STATIC_MAC_PLL_DIVQ)

#define S_STATIC_MAC_PLL_DIVFI    8
#define M_STATIC_MAC_PLL_DIVFI    0x1ffU
#define V_STATIC_MAC_PLL_DIVFI(x) ((x) << S_STATIC_MAC_PLL_DIVFI)
#define G_STATIC_MAC_PLL_DIVFI(x) (((x) >> S_STATIC_MAC_PLL_DIVFI) & M_STATIC_MAC_PLL_DIVFI)

#define S_STATIC_MAC_PLL_DIVR    2
#define M_STATIC_MAC_PLL_DIVR    0x3fU
#define V_STATIC_MAC_PLL_DIVR(x) ((x) << S_STATIC_MAC_PLL_DIVR)
#define G_STATIC_MAC_PLL_DIVR(x) (((x) >> S_STATIC_MAC_PLL_DIVR) & M_STATIC_MAC_PLL_DIVR)

#define S_STATIC_MAC_PLL_BYPASS    1
#define V_STATIC_MAC_PLL_BYPASS(x) ((x) << S_STATIC_MAC_PLL_BYPASS)
#define F_STATIC_MAC_PLL_BYPASS    V_STATIC_MAC_PLL_BYPASS(1U)

#define S_STATIC_MAC_PLL_RESET    0
#define V_STATIC_MAC_PLL_RESET(x) ((x) << S_STATIC_MAC_PLL_RESET)
#define F_STATIC_MAC_PLL_RESET    V_STATIC_MAC_PLL_RESET(1U)

#define A_DBG_T5_STATIC_M_PLL_CONF4 0x60c4
#define A_DBG_STATIC_M_PLL_CONF4 0x60c4
#define A_DBG_STATIC_MAC_PLL_CONF2 0x60c4

#define S_STATIC_MAC_PLL_SSMF    5
#define M_STATIC_MAC_PLL_SSMF    0xfU
#define V_STATIC_MAC_PLL_SSMF(x) ((x) << S_STATIC_MAC_PLL_SSMF)
#define G_STATIC_MAC_PLL_SSMF(x) (((x) >> S_STATIC_MAC_PLL_SSMF) & M_STATIC_MAC_PLL_SSMF)

#define S_STATIC_MAC_PLL_SSMD    2
#define M_STATIC_MAC_PLL_SSMD    0x7U
#define V_STATIC_MAC_PLL_SSMD(x) ((x) << S_STATIC_MAC_PLL_SSMD)
#define G_STATIC_MAC_PLL_SSMD(x) (((x) >> S_STATIC_MAC_PLL_SSMD) & M_STATIC_MAC_PLL_SSMD)

#define S_STATIC_MAC_PLL_SSDS    1
#define V_STATIC_MAC_PLL_SSDS(x) ((x) << S_STATIC_MAC_PLL_SSDS)
#define F_STATIC_MAC_PLL_SSDS    V_STATIC_MAC_PLL_SSDS(1U)

#define S_STATIC_MAC_PLL_SSE    0
#define V_STATIC_MAC_PLL_SSE(x) ((x) << S_STATIC_MAC_PLL_SSE)
#define F_STATIC_MAC_PLL_SSE    V_STATIC_MAC_PLL_SSE(1U)

#define A_DBG_T5_STATIC_M_PLL_CONF5 0x60c8

#define S_T5_STATIC_M_PLL_VCVTUNE    24
#define M_T5_STATIC_M_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_M_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_M_PLL_VCVTUNE)
#define G_T5_STATIC_M_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_M_PLL_VCVTUNE) & M_T5_STATIC_M_PLL_VCVTUNE)

#define S_T5_STATIC_M_PLL_RESET    23
#define V_T5_STATIC_M_PLL_RESET(x) ((x) << S_T5_STATIC_M_PLL_RESET)
#define F_T5_STATIC_M_PLL_RESET    V_T5_STATIC_M_PLL_RESET(1U)

#define S_T5_STATIC_MPLL_REFCLK_SEL    22
#define V_T5_STATIC_MPLL_REFCLK_SEL(x) ((x) << S_T5_STATIC_MPLL_REFCLK_SEL)
#define F_T5_STATIC_MPLL_REFCLK_SEL    V_T5_STATIC_MPLL_REFCLK_SEL(1U)

#define S_T5_STATIC_M_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_M_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_M_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_M_PLL_LFTUNE_32_40)
#define G_T5_STATIC_M_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_M_PLL_LFTUNE_32_40) & M_T5_STATIC_M_PLL_LFTUNE_32_40)

#define S_T5_STATIC_M_PLL_PREDIV    8
#define M_T5_STATIC_M_PLL_PREDIV    0x1fU
#define V_T5_STATIC_M_PLL_PREDIV(x) ((x) << S_T5_STATIC_M_PLL_PREDIV)
#define G_T5_STATIC_M_PLL_PREDIV(x) (((x) >> S_T5_STATIC_M_PLL_PREDIV) & M_T5_STATIC_M_PLL_PREDIV)

#define S_T5_STATIC_M_PLL_MULT    0
#define M_T5_STATIC_M_PLL_MULT    0xffU
#define V_T5_STATIC_M_PLL_MULT(x) ((x) << S_T5_STATIC_M_PLL_MULT)
#define G_T5_STATIC_M_PLL_MULT(x) (((x) >> S_T5_STATIC_M_PLL_MULT) & M_T5_STATIC_M_PLL_MULT)

#define A_DBG_STATIC_M_PLL_CONF5 0x60c8

#define S_STATIC_M_PLL_VCVTUNE    24
#define M_STATIC_M_PLL_VCVTUNE    0x7U
#define V_STATIC_M_PLL_VCVTUNE(x) ((x) << S_STATIC_M_PLL_VCVTUNE)
#define G_STATIC_M_PLL_VCVTUNE(x) (((x) >> S_STATIC_M_PLL_VCVTUNE) & M_STATIC_M_PLL_VCVTUNE)

#define S_T6_STATIC_M_PLL_RESET    23
#define V_T6_STATIC_M_PLL_RESET(x) ((x) << S_T6_STATIC_M_PLL_RESET)
#define F_T6_STATIC_M_PLL_RESET    V_T6_STATIC_M_PLL_RESET(1U)

#define S_STATIC_MPLL_REFCLK_SEL    22
#define V_STATIC_MPLL_REFCLK_SEL(x) ((x) << S_STATIC_MPLL_REFCLK_SEL)
#define F_STATIC_MPLL_REFCLK_SEL    V_STATIC_MPLL_REFCLK_SEL(1U)

#define S_STATIC_M_PLL_LFTUNE_32_40    13
#define M_STATIC_M_PLL_LFTUNE_32_40    0x1ffU
#define V_STATIC_M_PLL_LFTUNE_32_40(x) ((x) << S_STATIC_M_PLL_LFTUNE_32_40)
#define G_STATIC_M_PLL_LFTUNE_32_40(x) (((x) >> S_STATIC_M_PLL_LFTUNE_32_40) & M_STATIC_M_PLL_LFTUNE_32_40)

#define S_T6_STATIC_M_PLL_MULT    0
#define M_T6_STATIC_M_PLL_MULT    0xffU
#define V_T6_STATIC_M_PLL_MULT(x) ((x) << S_T6_STATIC_M_PLL_MULT)
#define G_T6_STATIC_M_PLL_MULT(x) (((x) >> S_T6_STATIC_M_PLL_MULT) & M_T6_STATIC_M_PLL_MULT)

#define A_DBG_STATIC_ARM_PLL_CONF1 0x60c8

#define S_STATIC_ARM_PLL_RANGE    22
#define M_STATIC_ARM_PLL_RANGE    0x7U
#define V_STATIC_ARM_PLL_RANGE(x) ((x) << S_STATIC_ARM_PLL_RANGE)
#define G_STATIC_ARM_PLL_RANGE(x) (((x) >> S_STATIC_ARM_PLL_RANGE) & M_STATIC_ARM_PLL_RANGE)

#define S_STATIC_ARM_PLL_DIVQ    17
#define M_STATIC_ARM_PLL_DIVQ    0x1fU
#define V_STATIC_ARM_PLL_DIVQ(x) ((x) << S_STATIC_ARM_PLL_DIVQ)
#define G_STATIC_ARM_PLL_DIVQ(x) (((x) >> S_STATIC_ARM_PLL_DIVQ) & M_STATIC_ARM_PLL_DIVQ)

#define S_STATIC_ARM_PLL_DIVFI    8
#define M_STATIC_ARM_PLL_DIVFI    0x1ffU
#define V_STATIC_ARM_PLL_DIVFI(x) ((x) << S_STATIC_ARM_PLL_DIVFI)
#define G_STATIC_ARM_PLL_DIVFI(x) (((x) >> S_STATIC_ARM_PLL_DIVFI) & M_STATIC_ARM_PLL_DIVFI)

#define S_STATIC_ARM_PLL_DIVR    2
#define M_STATIC_ARM_PLL_DIVR    0x3fU
#define V_STATIC_ARM_PLL_DIVR(x) ((x) << S_STATIC_ARM_PLL_DIVR)
#define G_STATIC_ARM_PLL_DIVR(x) (((x) >> S_STATIC_ARM_PLL_DIVR) & M_STATIC_ARM_PLL_DIVR)

#define S_STATIC_ARM_PLL_BYPASS    1
#define V_STATIC_ARM_PLL_BYPASS(x) ((x) << S_STATIC_ARM_PLL_BYPASS)
#define F_STATIC_ARM_PLL_BYPASS    V_STATIC_ARM_PLL_BYPASS(1U)

#define S_STATIC_ARM_PLL_RESET    0
#define V_STATIC_ARM_PLL_RESET(x) ((x) << S_STATIC_ARM_PLL_RESET)
#define F_STATIC_ARM_PLL_RESET    V_STATIC_ARM_PLL_RESET(1U)

#define A_DBG_T5_STATIC_M_PLL_CONF6 0x60cc

#define S_T5_STATIC_PHY0RECRST_    5
#define V_T5_STATIC_PHY0RECRST_(x) ((x) << S_T5_STATIC_PHY0RECRST_)
#define F_T5_STATIC_PHY0RECRST_    V_T5_STATIC_PHY0RECRST_(1U)

#define S_T5_STATIC_PHY1RECRST_    4
#define V_T5_STATIC_PHY1RECRST_(x) ((x) << S_T5_STATIC_PHY1RECRST_)
#define F_T5_STATIC_PHY1RECRST_    V_T5_STATIC_PHY1RECRST_(1U)

#define S_T5_STATIC_SWMC0RST_    3
#define V_T5_STATIC_SWMC0RST_(x) ((x) << S_T5_STATIC_SWMC0RST_)
#define F_T5_STATIC_SWMC0RST_    V_T5_STATIC_SWMC0RST_(1U)

#define S_T5_STATIC_SWMC0CFGRST_    2
#define V_T5_STATIC_SWMC0CFGRST_(x) ((x) << S_T5_STATIC_SWMC0CFGRST_)
#define F_T5_STATIC_SWMC0CFGRST_    V_T5_STATIC_SWMC0CFGRST_(1U)

#define S_T5_STATIC_SWMC1RST_    1
#define V_T5_STATIC_SWMC1RST_(x) ((x) << S_T5_STATIC_SWMC1RST_)
#define F_T5_STATIC_SWMC1RST_    V_T5_STATIC_SWMC1RST_(1U)

#define S_T5_STATIC_SWMC1CFGRST_    0
#define V_T5_STATIC_SWMC1CFGRST_(x) ((x) << S_T5_STATIC_SWMC1CFGRST_)
#define F_T5_STATIC_SWMC1CFGRST_    V_T5_STATIC_SWMC1CFGRST_(1U)

#define A_DBG_STATIC_M_PLL_CONF6 0x60cc

#define S_STATIC_M_PLL_DIVCHANGE    30
#define V_STATIC_M_PLL_DIVCHANGE(x) ((x) << S_STATIC_M_PLL_DIVCHANGE)
#define F_STATIC_M_PLL_DIVCHANGE    V_STATIC_M_PLL_DIVCHANGE(1U)

#define S_STATIC_M_PLL_FRAMESTOP    29
#define V_STATIC_M_PLL_FRAMESTOP(x) ((x) << S_STATIC_M_PLL_FRAMESTOP)
#define F_STATIC_M_PLL_FRAMESTOP    V_STATIC_M_PLL_FRAMESTOP(1U)

#define S_STATIC_M_PLL_FASTSTOP    28
#define V_STATIC_M_PLL_FASTSTOP(x) ((x) << S_STATIC_M_PLL_FASTSTOP)
#define F_STATIC_M_PLL_FASTSTOP    V_STATIC_M_PLL_FASTSTOP(1U)

#define S_STATIC_M_PLL_FFBYPASS    27
#define V_STATIC_M_PLL_FFBYPASS(x) ((x) << S_STATIC_M_PLL_FFBYPASS)
#define F_STATIC_M_PLL_FFBYPASS    V_STATIC_M_PLL_FFBYPASS(1U)

#define S_STATIC_M_PLL_STARTUP    25
#define M_STATIC_M_PLL_STARTUP    0x3U
#define V_STATIC_M_PLL_STARTUP(x) ((x) << S_STATIC_M_PLL_STARTUP)
#define G_STATIC_M_PLL_STARTUP(x) (((x) >> S_STATIC_M_PLL_STARTUP) & M_STATIC_M_PLL_STARTUP)

#define S_STATIC_M_PLL_VREGTUNE    6
#define M_STATIC_M_PLL_VREGTUNE    0x7ffffU
#define V_STATIC_M_PLL_VREGTUNE(x) ((x) << S_STATIC_M_PLL_VREGTUNE)
#define G_STATIC_M_PLL_VREGTUNE(x) (((x) >> S_STATIC_M_PLL_VREGTUNE) & M_STATIC_M_PLL_VREGTUNE)

#define S_STATIC_PHY0RECRST_    5
#define V_STATIC_PHY0RECRST_(x) ((x) << S_STATIC_PHY0RECRST_)
#define F_STATIC_PHY0RECRST_    V_STATIC_PHY0RECRST_(1U)

#define S_STATIC_PHY1RECRST_    4
#define V_STATIC_PHY1RECRST_(x) ((x) << S_STATIC_PHY1RECRST_)
#define F_STATIC_PHY1RECRST_    V_STATIC_PHY1RECRST_(1U)

#define S_STATIC_SWMC0RST_    3
#define V_STATIC_SWMC0RST_(x) ((x) << S_STATIC_SWMC0RST_)
#define F_STATIC_SWMC0RST_    V_STATIC_SWMC0RST_(1U)

#define S_STATIC_SWMC0CFGRST_    2
#define V_STATIC_SWMC0CFGRST_(x) ((x) << S_STATIC_SWMC0CFGRST_)
#define F_STATIC_SWMC0CFGRST_    V_STATIC_SWMC0CFGRST_(1U)

#define S_STATIC_SWMC1RST_    1
#define V_STATIC_SWMC1RST_(x) ((x) << S_STATIC_SWMC1RST_)
#define F_STATIC_SWMC1RST_    V_STATIC_SWMC1RST_(1U)

#define S_STATIC_SWMC1CFGRST_    0
#define V_STATIC_SWMC1CFGRST_(x) ((x) << S_STATIC_SWMC1CFGRST_)
#define F_STATIC_SWMC1CFGRST_    V_STATIC_SWMC1CFGRST_(1U)

#define A_DBG_STATIC_ARM_PLL_CONF2 0x60cc

#define S_STATIC_ARM_PLL_SSMF    5
#define M_STATIC_ARM_PLL_SSMF    0xfU
#define V_STATIC_ARM_PLL_SSMF(x) ((x) << S_STATIC_ARM_PLL_SSMF)
#define G_STATIC_ARM_PLL_SSMF(x) (((x) >> S_STATIC_ARM_PLL_SSMF) & M_STATIC_ARM_PLL_SSMF)

#define S_STATIC_ARM_PLL_SSMD    2
#define M_STATIC_ARM_PLL_SSMD    0x7U
#define V_STATIC_ARM_PLL_SSMD(x) ((x) << S_STATIC_ARM_PLL_SSMD)
#define G_STATIC_ARM_PLL_SSMD(x) (((x) >> S_STATIC_ARM_PLL_SSMD) & M_STATIC_ARM_PLL_SSMD)

#define S_STATIC_ARM_PLL_SSDS    1
#define V_STATIC_ARM_PLL_SSDS(x) ((x) << S_STATIC_ARM_PLL_SSDS)
#define F_STATIC_ARM_PLL_SSDS    V_STATIC_ARM_PLL_SSDS(1U)

#define S_STATIC_ARM_PLL_SSE    0
#define V_STATIC_ARM_PLL_SSE(x) ((x) << S_STATIC_ARM_PLL_SSE)
#define F_STATIC_ARM_PLL_SSE    V_STATIC_ARM_PLL_SSE(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF1 0x60d0

#define S_T5_STATIC_C_PLL_MULTFRAC    8
#define M_T5_STATIC_C_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_C_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_C_PLL_MULTFRAC)
#define G_T5_STATIC_C_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_C_PLL_MULTFRAC) & M_T5_STATIC_C_PLL_MULTFRAC)

#define S_T5_STATIC_C_PLL_FFSLEWRATE    0
#define M_T5_STATIC_C_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_C_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_C_PLL_FFSLEWRATE)
#define G_T5_STATIC_C_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_C_PLL_FFSLEWRATE) & M_T5_STATIC_C_PLL_FFSLEWRATE)

#define A_DBG_STATIC_C_PLL_CONF1 0x60d0

#define S_STATIC_C_PLL_MULTFRAC    8
#define M_STATIC_C_PLL_MULTFRAC    0xffffffU
#define V_STATIC_C_PLL_MULTFRAC(x) ((x) << S_STATIC_C_PLL_MULTFRAC)
#define G_STATIC_C_PLL_MULTFRAC(x) (((x) >> S_STATIC_C_PLL_MULTFRAC) & M_STATIC_C_PLL_MULTFRAC)

#define S_STATIC_C_PLL_FFSLEWRATE    0
#define M_STATIC_C_PLL_FFSLEWRATE    0xffU
#define V_STATIC_C_PLL_FFSLEWRATE(x) ((x) << S_STATIC_C_PLL_FFSLEWRATE)
#define G_STATIC_C_PLL_FFSLEWRATE(x) (((x) >> S_STATIC_C_PLL_FFSLEWRATE) & M_STATIC_C_PLL_FFSLEWRATE)

#define A_DBG_STATIC_USB_PLL_CONF1 0x60d0

#define S_STATIC_USB_PLL_RANGE    22
#define M_STATIC_USB_PLL_RANGE    0x7U
#define V_STATIC_USB_PLL_RANGE(x) ((x) << S_STATIC_USB_PLL_RANGE)
#define G_STATIC_USB_PLL_RANGE(x) (((x) >> S_STATIC_USB_PLL_RANGE) & M_STATIC_USB_PLL_RANGE)

#define S_STATIC_USB_PLL_DIVQ    17
#define M_STATIC_USB_PLL_DIVQ    0x1fU
#define V_STATIC_USB_PLL_DIVQ(x) ((x) << S_STATIC_USB_PLL_DIVQ)
#define G_STATIC_USB_PLL_DIVQ(x) (((x) >> S_STATIC_USB_PLL_DIVQ) & M_STATIC_USB_PLL_DIVQ)

#define S_STATIC_USB_PLL_DIVFI    8
#define M_STATIC_USB_PLL_DIVFI    0x1ffU
#define V_STATIC_USB_PLL_DIVFI(x) ((x) << S_STATIC_USB_PLL_DIVFI)
#define G_STATIC_USB_PLL_DIVFI(x) (((x) >> S_STATIC_USB_PLL_DIVFI) & M_STATIC_USB_PLL_DIVFI)

#define S_STATIC_USB_PLL_DIVR    2
#define M_STATIC_USB_PLL_DIVR    0x3fU
#define V_STATIC_USB_PLL_DIVR(x) ((x) << S_STATIC_USB_PLL_DIVR)
#define G_STATIC_USB_PLL_DIVR(x) (((x) >> S_STATIC_USB_PLL_DIVR) & M_STATIC_USB_PLL_DIVR)

#define S_STATIC_USB_PLL_BYPASS    1
#define V_STATIC_USB_PLL_BYPASS(x) ((x) << S_STATIC_USB_PLL_BYPASS)
#define F_STATIC_USB_PLL_BYPASS    V_STATIC_USB_PLL_BYPASS(1U)

#define S_STATIC_USB_PLL_RESET    0
#define V_STATIC_USB_PLL_RESET(x) ((x) << S_STATIC_USB_PLL_RESET)
#define F_STATIC_USB_PLL_RESET    V_STATIC_USB_PLL_RESET(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF2 0x60d4

#define S_T5_STATIC_C_PLL_DCO_BYPASS    23
#define V_T5_STATIC_C_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_C_PLL_DCO_BYPASS)
#define F_T5_STATIC_C_PLL_DCO_BYPASS    V_T5_STATIC_C_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_C_PLL_SDORDER    21
#define M_T5_STATIC_C_PLL_SDORDER    0x3U
#define V_T5_STATIC_C_PLL_SDORDER(x) ((x) << S_T5_STATIC_C_PLL_SDORDER)
#define G_T5_STATIC_C_PLL_SDORDER(x) (((x) >> S_T5_STATIC_C_PLL_SDORDER) & M_T5_STATIC_C_PLL_SDORDER)

#define S_T5_STATIC_C_PLL_FFENABLE    20
#define V_T5_STATIC_C_PLL_FFENABLE(x) ((x) << S_T5_STATIC_C_PLL_FFENABLE)
#define F_T5_STATIC_C_PLL_FFENABLE    V_T5_STATIC_C_PLL_FFENABLE(1U)

#define S_T5_STATIC_C_PLL_STOPCLKB    19
#define V_T5_STATIC_C_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_C_PLL_STOPCLKB)
#define F_T5_STATIC_C_PLL_STOPCLKB    V_T5_STATIC_C_PLL_STOPCLKB(1U)

#define S_T5_STATIC_C_PLL_STOPCLKA    18
#define V_T5_STATIC_C_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_C_PLL_STOPCLKA)
#define F_T5_STATIC_C_PLL_STOPCLKA    V_T5_STATIC_C_PLL_STOPCLKA(1U)

#define S_T5_STATIC_C_PLL_SLEEP    17
#define V_T5_STATIC_C_PLL_SLEEP(x) ((x) << S_T5_STATIC_C_PLL_SLEEP)
#define F_T5_STATIC_C_PLL_SLEEP    V_T5_STATIC_C_PLL_SLEEP(1U)

#define S_T5_STATIC_C_PLL_BYPASS    16
#define V_T5_STATIC_C_PLL_BYPASS(x) ((x) << S_T5_STATIC_C_PLL_BYPASS)
#define F_T5_STATIC_C_PLL_BYPASS    V_T5_STATIC_C_PLL_BYPASS(1U)

#define S_T5_STATIC_C_PLL_LOCKTUNE    0
#define M_T5_STATIC_C_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_C_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_C_PLL_LOCKTUNE)
#define G_T5_STATIC_C_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_C_PLL_LOCKTUNE) & M_T5_STATIC_C_PLL_LOCKTUNE)

#define A_DBG_STATIC_C_PLL_CONF2 0x60d4

#define S_T6_STATIC_C_PLL_PREDIV    26
#define M_T6_STATIC_C_PLL_PREDIV    0x3fU
#define V_T6_STATIC_C_PLL_PREDIV(x) ((x) << S_T6_STATIC_C_PLL_PREDIV)
#define G_T6_STATIC_C_PLL_PREDIV(x) (((x) >> S_T6_STATIC_C_PLL_PREDIV) & M_T6_STATIC_C_PLL_PREDIV)

#define S_STATIC_C_PLL_STARTUP    24
#define M_STATIC_C_PLL_STARTUP    0x3U
#define V_STATIC_C_PLL_STARTUP(x) ((x) << S_STATIC_C_PLL_STARTUP)
#define G_STATIC_C_PLL_STARTUP(x) (((x) >> S_STATIC_C_PLL_STARTUP) & M_STATIC_C_PLL_STARTUP)

#define S_STATIC_C_PLL_DCO_BYPASS    23
#define V_STATIC_C_PLL_DCO_BYPASS(x) ((x) << S_STATIC_C_PLL_DCO_BYPASS)
#define F_STATIC_C_PLL_DCO_BYPASS    V_STATIC_C_PLL_DCO_BYPASS(1U)

#define S_STATIC_C_PLL_SDORDER    21
#define M_STATIC_C_PLL_SDORDER    0x3U
#define V_STATIC_C_PLL_SDORDER(x) ((x) << S_STATIC_C_PLL_SDORDER)
#define G_STATIC_C_PLL_SDORDER(x) (((x) >> S_STATIC_C_PLL_SDORDER) & M_STATIC_C_PLL_SDORDER)

#define S_STATIC_C_PLL_DIVCHANGE    20
#define V_STATIC_C_PLL_DIVCHANGE(x) ((x) << S_STATIC_C_PLL_DIVCHANGE)
#define F_STATIC_C_PLL_DIVCHANGE    V_STATIC_C_PLL_DIVCHANGE(1U)

#define S_STATIC_C_PLL_STOPCLKB    19
#define V_STATIC_C_PLL_STOPCLKB(x) ((x) << S_STATIC_C_PLL_STOPCLKB)
#define F_STATIC_C_PLL_STOPCLKB    V_STATIC_C_PLL_STOPCLKB(1U)

#define S_STATIC_C_PLL_STOPCLKA    18
#define V_STATIC_C_PLL_STOPCLKA(x) ((x) << S_STATIC_C_PLL_STOPCLKA)
#define F_STATIC_C_PLL_STOPCLKA    V_STATIC_C_PLL_STOPCLKA(1U)

#define S_T6_STATIC_C_PLL_SLEEP    17
#define V_T6_STATIC_C_PLL_SLEEP(x) ((x) << S_T6_STATIC_C_PLL_SLEEP)
#define F_T6_STATIC_C_PLL_SLEEP    V_T6_STATIC_C_PLL_SLEEP(1U)

#define S_T6_STATIC_C_PLL_BYPASS    16
#define V_T6_STATIC_C_PLL_BYPASS(x) ((x) << S_T6_STATIC_C_PLL_BYPASS)
#define F_T6_STATIC_C_PLL_BYPASS    V_T6_STATIC_C_PLL_BYPASS(1U)

#define S_STATIC_C_PLL_LOCKTUNE    0
#define M_STATIC_C_PLL_LOCKTUNE    0x1fU
#define V_STATIC_C_PLL_LOCKTUNE(x) ((x) << S_STATIC_C_PLL_LOCKTUNE)
#define G_STATIC_C_PLL_LOCKTUNE(x) (((x) >> S_STATIC_C_PLL_LOCKTUNE) & M_STATIC_C_PLL_LOCKTUNE)

#define A_DBG_STATIC_USB_PLL_CONF2 0x60d4

#define S_STATIC_USB_PLL_SSMF    5
#define M_STATIC_USB_PLL_SSMF    0xfU
#define V_STATIC_USB_PLL_SSMF(x) ((x) << S_STATIC_USB_PLL_SSMF)
#define G_STATIC_USB_PLL_SSMF(x) (((x) >> S_STATIC_USB_PLL_SSMF) & M_STATIC_USB_PLL_SSMF)

#define S_STATIC_USB_PLL_SSMD    2
#define M_STATIC_USB_PLL_SSMD    0x7U
#define V_STATIC_USB_PLL_SSMD(x) ((x) << S_STATIC_USB_PLL_SSMD)
#define G_STATIC_USB_PLL_SSMD(x) (((x) >> S_STATIC_USB_PLL_SSMD) & M_STATIC_USB_PLL_SSMD)

#define S_STATIC_USB_PLL_SSDS    1
#define V_STATIC_USB_PLL_SSDS(x) ((x) << S_STATIC_USB_PLL_SSDS)
#define F_STATIC_USB_PLL_SSDS    V_STATIC_USB_PLL_SSDS(1U)

#define S_STATIC_USB_PLL_SSE    0
#define V_STATIC_USB_PLL_SSE(x) ((x) << S_STATIC_USB_PLL_SSE)
#define F_STATIC_USB_PLL_SSE    V_STATIC_USB_PLL_SSE(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF3 0x60d8

#define S_T5_STATIC_C_PLL_MULTPRE    30
#define M_T5_STATIC_C_PLL_MULTPRE    0x3U
#define V_T5_STATIC_C_PLL_MULTPRE(x) ((x) << S_T5_STATIC_C_PLL_MULTPRE)
#define G_T5_STATIC_C_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_C_PLL_MULTPRE) & M_T5_STATIC_C_PLL_MULTPRE)

#define S_T5_STATIC_C_PLL_LOCKSEL    28
#define M_T5_STATIC_C_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_C_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_C_PLL_LOCKSEL)
#define G_T5_STATIC_C_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_C_PLL_LOCKSEL) & M_T5_STATIC_C_PLL_LOCKSEL)

#define S_T5_STATIC_C_PLL_FFTUNE    12
#define M_T5_STATIC_C_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_C_PLL_FFTUNE(x) ((x) << S_T5_STATIC_C_PLL_FFTUNE)
#define G_T5_STATIC_C_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_C_PLL_FFTUNE) & M_T5_STATIC_C_PLL_FFTUNE)

#define S_T5_STATIC_C_PLL_RANGEPRE    10
#define M_T5_STATIC_C_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_C_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_C_PLL_RANGEPRE)
#define G_T5_STATIC_C_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_C_PLL_RANGEPRE) & M_T5_STATIC_C_PLL_RANGEPRE)

#define S_T5_STATIC_C_PLL_RANGEB    5
#define M_T5_STATIC_C_PLL_RANGEB    0x1fU
#define V_T5_STATIC_C_PLL_RANGEB(x) ((x) << S_T5_STATIC_C_PLL_RANGEB)
#define G_T5_STATIC_C_PLL_RANGEB(x) (((x) >> S_T5_STATIC_C_PLL_RANGEB) & M_T5_STATIC_C_PLL_RANGEB)

#define S_T5_STATIC_C_PLL_RANGEA    0
#define M_T5_STATIC_C_PLL_RANGEA    0x1fU
#define V_T5_STATIC_C_PLL_RANGEA(x) ((x) << S_T5_STATIC_C_PLL_RANGEA)
#define G_T5_STATIC_C_PLL_RANGEA(x) (((x) >> S_T5_STATIC_C_PLL_RANGEA) & M_T5_STATIC_C_PLL_RANGEA)

#define A_DBG_STATIC_C_PLL_CONF3 0x60d8

#define S_STATIC_C_PLL_MULTPRE    30
#define M_STATIC_C_PLL_MULTPRE    0x3U
#define V_STATIC_C_PLL_MULTPRE(x) ((x) << S_STATIC_C_PLL_MULTPRE)
#define G_STATIC_C_PLL_MULTPRE(x) (((x) >> S_STATIC_C_PLL_MULTPRE) & M_STATIC_C_PLL_MULTPRE)

#define S_STATIC_C_PLL_LOCKSEL    28
#define V_STATIC_C_PLL_LOCKSEL(x) ((x) << S_STATIC_C_PLL_LOCKSEL)
#define F_STATIC_C_PLL_LOCKSEL    V_STATIC_C_PLL_LOCKSEL(1U)

#define S_STATIC_C_PLL_FFTUNE    12
#define M_STATIC_C_PLL_FFTUNE    0xffffU
#define V_STATIC_C_PLL_FFTUNE(x) ((x) << S_STATIC_C_PLL_FFTUNE)
#define G_STATIC_C_PLL_FFTUNE(x) (((x) >> S_STATIC_C_PLL_FFTUNE) & M_STATIC_C_PLL_FFTUNE)

#define S_STATIC_C_PLL_RANGEPRE    10
#define M_STATIC_C_PLL_RANGEPRE    0x3U
#define V_STATIC_C_PLL_RANGEPRE(x) ((x) << S_STATIC_C_PLL_RANGEPRE)
#define G_STATIC_C_PLL_RANGEPRE(x) (((x) >> S_STATIC_C_PLL_RANGEPRE) & M_STATIC_C_PLL_RANGEPRE)

#define S_T6_STATIC_C_PLL_RANGEB    5
#define M_T6_STATIC_C_PLL_RANGEB    0x1fU
#define V_T6_STATIC_C_PLL_RANGEB(x) ((x) << S_T6_STATIC_C_PLL_RANGEB)
#define G_T6_STATIC_C_PLL_RANGEB(x) (((x) >> S_T6_STATIC_C_PLL_RANGEB) & M_T6_STATIC_C_PLL_RANGEB)

#define S_T6_STATIC_C_PLL_RANGEA    0
#define M_T6_STATIC_C_PLL_RANGEA    0x1fU
#define V_T6_STATIC_C_PLL_RANGEA(x) ((x) << S_T6_STATIC_C_PLL_RANGEA)
#define G_T6_STATIC_C_PLL_RANGEA(x) (((x) >> S_T6_STATIC_C_PLL_RANGEA) & M_T6_STATIC_C_PLL_RANGEA)

#define A_DBG_STATIC_XGPHY_PLL_CONF1 0x60d8

#define S_STATIC_XGPHY_PLL_RANGE    22
#define M_STATIC_XGPHY_PLL_RANGE    0x7U
#define V_STATIC_XGPHY_PLL_RANGE(x) ((x) << S_STATIC_XGPHY_PLL_RANGE)
#define G_STATIC_XGPHY_PLL_RANGE(x) (((x) >> S_STATIC_XGPHY_PLL_RANGE) & M_STATIC_XGPHY_PLL_RANGE)

#define S_STATIC_XGPHY_PLL_DIVQ    17
#define M_STATIC_XGPHY_PLL_DIVQ    0x1fU
#define V_STATIC_XGPHY_PLL_DIVQ(x) ((x) << S_STATIC_XGPHY_PLL_DIVQ)
#define G_STATIC_XGPHY_PLL_DIVQ(x) (((x) >> S_STATIC_XGPHY_PLL_DIVQ) & M_STATIC_XGPHY_PLL_DIVQ)

#define S_STATIC_XGPHY_PLL_DIVFI    8
#define M_STATIC_XGPHY_PLL_DIVFI    0x1ffU
#define V_STATIC_XGPHY_PLL_DIVFI(x) ((x) << S_STATIC_XGPHY_PLL_DIVFI)
#define G_STATIC_XGPHY_PLL_DIVFI(x) (((x) >> S_STATIC_XGPHY_PLL_DIVFI) & M_STATIC_XGPHY_PLL_DIVFI)

#define S_STATIC_XGPHY_PLL_DIVR    2
#define M_STATIC_XGPHY_PLL_DIVR    0x3fU
#define V_STATIC_XGPHY_PLL_DIVR(x) ((x) << S_STATIC_XGPHY_PLL_DIVR)
#define G_STATIC_XGPHY_PLL_DIVR(x) (((x) >> S_STATIC_XGPHY_PLL_DIVR) & M_STATIC_XGPHY_PLL_DIVR)

#define S_STATIC_XGPHY_PLL_BYPASS    1
#define V_STATIC_XGPHY_PLL_BYPASS(x) ((x) << S_STATIC_XGPHY_PLL_BYPASS)
#define F_STATIC_XGPHY_PLL_BYPASS    V_STATIC_XGPHY_PLL_BYPASS(1U)

#define S_STATIC_XGPHY_PLL_RESET    0
#define V_STATIC_XGPHY_PLL_RESET(x) ((x) << S_STATIC_XGPHY_PLL_RESET)
#define F_STATIC_XGPHY_PLL_RESET    V_STATIC_XGPHY_PLL_RESET(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF4 0x60dc
#define A_DBG_STATIC_C_PLL_CONF4 0x60dc
#define A_DBG_STATIC_XGPHY_PLL_CONF2 0x60dc

#define S_STATIC_XGPHY_PLL_SSMF    5
#define M_STATIC_XGPHY_PLL_SSMF    0xfU
#define V_STATIC_XGPHY_PLL_SSMF(x) ((x) << S_STATIC_XGPHY_PLL_SSMF)
#define G_STATIC_XGPHY_PLL_SSMF(x) (((x) >> S_STATIC_XGPHY_PLL_SSMF) & M_STATIC_XGPHY_PLL_SSMF)

#define S_STATIC_XGPHY_PLL_SSMD    2
#define M_STATIC_XGPHY_PLL_SSMD    0x7U
#define V_STATIC_XGPHY_PLL_SSMD(x) ((x) << S_STATIC_XGPHY_PLL_SSMD)
#define G_STATIC_XGPHY_PLL_SSMD(x) (((x) >> S_STATIC_XGPHY_PLL_SSMD) & M_STATIC_XGPHY_PLL_SSMD)

#define S_STATIC_XGPHY_PLL_SSDS    1
#define V_STATIC_XGPHY_PLL_SSDS(x) ((x) << S_STATIC_XGPHY_PLL_SSDS)
#define F_STATIC_XGPHY_PLL_SSDS    V_STATIC_XGPHY_PLL_SSDS(1U)

#define S_STATIC_XGPHY_PLL_SSE    0
#define V_STATIC_XGPHY_PLL_SSE(x) ((x) << S_STATIC_XGPHY_PLL_SSE)
#define F_STATIC_XGPHY_PLL_SSE    V_STATIC_XGPHY_PLL_SSE(1U)

#define A_DBG_T5_STATIC_C_PLL_CONF5 0x60e0

#define S_T5_STATIC_C_PLL_VCVTUNE    22
#define M_T5_STATIC_C_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_C_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_C_PLL_VCVTUNE)
#define G_T5_STATIC_C_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_C_PLL_VCVTUNE) & M_T5_STATIC_C_PLL_VCVTUNE)

#define S_T5_STATIC_C_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_C_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_C_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_C_PLL_LFTUNE_32_40)
#define G_T5_STATIC_C_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_C_PLL_LFTUNE_32_40) & M_T5_STATIC_C_PLL_LFTUNE_32_40)

#define S_T5_STATIC_C_PLL_PREDIV    8
#define M_T5_STATIC_C_PLL_PREDIV    0x1fU
#define V_T5_STATIC_C_PLL_PREDIV(x) ((x) << S_T5_STATIC_C_PLL_PREDIV)
#define G_T5_STATIC_C_PLL_PREDIV(x) (((x) >> S_T5_STATIC_C_PLL_PREDIV) & M_T5_STATIC_C_PLL_PREDIV)

#define S_T5_STATIC_C_PLL_MULT    0
#define M_T5_STATIC_C_PLL_MULT    0xffU
#define V_T5_STATIC_C_PLL_MULT(x) ((x) << S_T5_STATIC_C_PLL_MULT)
#define G_T5_STATIC_C_PLL_MULT(x) (((x) >> S_T5_STATIC_C_PLL_MULT) & M_T5_STATIC_C_PLL_MULT)

#define A_DBG_STATIC_C_PLL_CONF5 0x60e0

#define S_STATIC_C_PLL_FFBYPASS    27
#define V_STATIC_C_PLL_FFBYPASS(x) ((x) << S_STATIC_C_PLL_FFBYPASS)
#define F_STATIC_C_PLL_FFBYPASS    V_STATIC_C_PLL_FFBYPASS(1U)

#define S_STATIC_C_PLL_FASTSTOP    26
#define V_STATIC_C_PLL_FASTSTOP(x) ((x) << S_STATIC_C_PLL_FASTSTOP)
#define F_STATIC_C_PLL_FASTSTOP    V_STATIC_C_PLL_FASTSTOP(1U)

#define S_STATIC_C_PLL_FRAMESTOP    25
#define V_STATIC_C_PLL_FRAMESTOP(x) ((x) << S_STATIC_C_PLL_FRAMESTOP)
#define F_STATIC_C_PLL_FRAMESTOP    V_STATIC_C_PLL_FRAMESTOP(1U)

#define S_STATIC_C_PLL_VCVTUNE    22
#define M_STATIC_C_PLL_VCVTUNE    0x7U
#define V_STATIC_C_PLL_VCVTUNE(x) ((x) << S_STATIC_C_PLL_VCVTUNE)
#define G_STATIC_C_PLL_VCVTUNE(x) (((x) >> S_STATIC_C_PLL_VCVTUNE) & M_STATIC_C_PLL_VCVTUNE)

#define S_STATIC_C_PLL_LFTUNE_32_40    13
#define M_STATIC_C_PLL_LFTUNE_32_40    0x1ffU
#define V_STATIC_C_PLL_LFTUNE_32_40(x) ((x) << S_STATIC_C_PLL_LFTUNE_32_40)
#define G_STATIC_C_PLL_LFTUNE_32_40(x) (((x) >> S_STATIC_C_PLL_LFTUNE_32_40) & M_STATIC_C_PLL_LFTUNE_32_40)

#define S_STATIC_C_PLL_PREDIV_CNF5    8
#define M_STATIC_C_PLL_PREDIV_CNF5    0x1fU
#define V_STATIC_C_PLL_PREDIV_CNF5(x) ((x) << S_STATIC_C_PLL_PREDIV_CNF5)
#define G_STATIC_C_PLL_PREDIV_CNF5(x) (((x) >> S_STATIC_C_PLL_PREDIV_CNF5) & M_STATIC_C_PLL_PREDIV_CNF5)

#define S_T6_STATIC_C_PLL_MULT    0
#define M_T6_STATIC_C_PLL_MULT    0xffU
#define V_T6_STATIC_C_PLL_MULT(x) ((x) << S_T6_STATIC_C_PLL_MULT)
#define G_T6_STATIC_C_PLL_MULT(x) (((x) >> S_T6_STATIC_C_PLL_MULT) & M_T6_STATIC_C_PLL_MULT)

#define A_DBG_STATIC_XGPBUS_PLL_CONF1 0x60e0

#define S_STATIC_XGPBUS_SWRST_    25
#define V_STATIC_XGPBUS_SWRST_(x) ((x) << S_STATIC_XGPBUS_SWRST_)
#define F_STATIC_XGPBUS_SWRST_    V_STATIC_XGPBUS_SWRST_(1U)

#define S_STATIC_XGPBUS_PLL_RANGE    22
#define M_STATIC_XGPBUS_PLL_RANGE    0x7U
#define V_STATIC_XGPBUS_PLL_RANGE(x) ((x) << S_STATIC_XGPBUS_PLL_RANGE)
#define G_STATIC_XGPBUS_PLL_RANGE(x) (((x) >> S_STATIC_XGPBUS_PLL_RANGE) & M_STATIC_XGPBUS_PLL_RANGE)

#define S_STATIC_XGPBUS_PLL_DIVQ    17
#define M_STATIC_XGPBUS_PLL_DIVQ    0x1fU
#define V_STATIC_XGPBUS_PLL_DIVQ(x) ((x) << S_STATIC_XGPBUS_PLL_DIVQ)
#define G_STATIC_XGPBUS_PLL_DIVQ(x) (((x) >> S_STATIC_XGPBUS_PLL_DIVQ) & M_STATIC_XGPBUS_PLL_DIVQ)

#define S_STATIC_XGPBUS_PLL_DIVFI    8
#define M_STATIC_XGPBUS_PLL_DIVFI    0x1ffU
#define V_STATIC_XGPBUS_PLL_DIVFI(x) ((x) << S_STATIC_XGPBUS_PLL_DIVFI)
#define G_STATIC_XGPBUS_PLL_DIVFI(x) (((x) >> S_STATIC_XGPBUS_PLL_DIVFI) & M_STATIC_XGPBUS_PLL_DIVFI)

#define S_STATIC_XGPBUS_PLL_DIVR    2
#define M_STATIC_XGPBUS_PLL_DIVR    0x3fU
#define V_STATIC_XGPBUS_PLL_DIVR(x) ((x) << S_STATIC_XGPBUS_PLL_DIVR)
#define G_STATIC_XGPBUS_PLL_DIVR(x) (((x) >> S_STATIC_XGPBUS_PLL_DIVR) & M_STATIC_XGPBUS_PLL_DIVR)

#define S_STATIC_XGPBUS_PLL_BYPASS    1
#define V_STATIC_XGPBUS_PLL_BYPASS(x) ((x) << S_STATIC_XGPBUS_PLL_BYPASS)
#define F_STATIC_XGPBUS_PLL_BYPASS    V_STATIC_XGPBUS_PLL_BYPASS(1U)

#define S_STATIC_XGPBUS_PLL_RESET    0
#define V_STATIC_XGPBUS_PLL_RESET(x) ((x) << S_STATIC_XGPBUS_PLL_RESET)
#define F_STATIC_XGPBUS_PLL_RESET    V_STATIC_XGPBUS_PLL_RESET(1U)

#define A_DBG_T5_STATIC_U_PLL_CONF1 0x60e4

#define S_T5_STATIC_U_PLL_MULTFRAC    8
#define M_T5_STATIC_U_PLL_MULTFRAC    0xffffffU
#define V_T5_STATIC_U_PLL_MULTFRAC(x) ((x) << S_T5_STATIC_U_PLL_MULTFRAC)
#define G_T5_STATIC_U_PLL_MULTFRAC(x) (((x) >> S_T5_STATIC_U_PLL_MULTFRAC) & M_T5_STATIC_U_PLL_MULTFRAC)

#define S_T5_STATIC_U_PLL_FFSLEWRATE    0
#define M_T5_STATIC_U_PLL_FFSLEWRATE    0xffU
#define V_T5_STATIC_U_PLL_FFSLEWRATE(x) ((x) << S_T5_STATIC_U_PLL_FFSLEWRATE)
#define G_T5_STATIC_U_PLL_FFSLEWRATE(x) (((x) >> S_T5_STATIC_U_PLL_FFSLEWRATE) & M_T5_STATIC_U_PLL_FFSLEWRATE)

#define A_DBG_STATIC_U_PLL_CONF1 0x60e4

#define S_STATIC_U_PLL_MULTFRAC    8
#define M_STATIC_U_PLL_MULTFRAC    0xffffffU
#define V_STATIC_U_PLL_MULTFRAC(x) ((x) << S_STATIC_U_PLL_MULTFRAC)
#define G_STATIC_U_PLL_MULTFRAC(x) (((x) >> S_STATIC_U_PLL_MULTFRAC) & M_STATIC_U_PLL_MULTFRAC)

#define S_STATIC_U_PLL_FFSLEWRATE    0
#define M_STATIC_U_PLL_FFSLEWRATE    0xffU
#define V_STATIC_U_PLL_FFSLEWRATE(x) ((x) << S_STATIC_U_PLL_FFSLEWRATE)
#define G_STATIC_U_PLL_FFSLEWRATE(x) (((x) >> S_STATIC_U_PLL_FFSLEWRATE) & M_STATIC_U_PLL_FFSLEWRATE)

#define A_DBG_STATIC_XGPBUS_PLL_CONF2 0x60e4

#define S_STATIC_XGPBUS_PLL_SSMF    5
#define M_STATIC_XGPBUS_PLL_SSMF    0xfU
#define V_STATIC_XGPBUS_PLL_SSMF(x) ((x) << S_STATIC_XGPBUS_PLL_SSMF)
#define G_STATIC_XGPBUS_PLL_SSMF(x) (((x) >> S_STATIC_XGPBUS_PLL_SSMF) & M_STATIC_XGPBUS_PLL_SSMF)

#define S_STATIC_XGPBUS_PLL_SSMD    2
#define M_STATIC_XGPBUS_PLL_SSMD    0x7U
#define V_STATIC_XGPBUS_PLL_SSMD(x) ((x) << S_STATIC_XGPBUS_PLL_SSMD)
#define G_STATIC_XGPBUS_PLL_SSMD(x) (((x) >> S_STATIC_XGPBUS_PLL_SSMD) & M_STATIC_XGPBUS_PLL_SSMD)

#define S_STATIC_XGPBUS_PLL_SSDS    1
#define V_STATIC_XGPBUS_PLL_SSDS(x) ((x) << S_STATIC_XGPBUS_PLL_SSDS)
#define F_STATIC_XGPBUS_PLL_SSDS    V_STATIC_XGPBUS_PLL_SSDS(1U)

#define S_STATIC_XGPBUS_PLL_SSE    0
#define V_STATIC_XGPBUS_PLL_SSE(x) ((x) << S_STATIC_XGPBUS_PLL_SSE)
#define F_STATIC_XGPBUS_PLL_SSE    V_STATIC_XGPBUS_PLL_SSE(1U)

#define A_DBG_T5_STATIC_U_PLL_CONF2 0x60e8

#define S_T5_STATIC_U_PLL_DCO_BYPASS    23
#define V_T5_STATIC_U_PLL_DCO_BYPASS(x) ((x) << S_T5_STATIC_U_PLL_DCO_BYPASS)
#define F_T5_STATIC_U_PLL_DCO_BYPASS    V_T5_STATIC_U_PLL_DCO_BYPASS(1U)

#define S_T5_STATIC_U_PLL_SDORDER    21
#define M_T5_STATIC_U_PLL_SDORDER    0x3U
#define V_T5_STATIC_U_PLL_SDORDER(x) ((x) << S_T5_STATIC_U_PLL_SDORDER)
#define G_T5_STATIC_U_PLL_SDORDER(x) (((x) >> S_T5_STATIC_U_PLL_SDORDER) & M_T5_STATIC_U_PLL_SDORDER)

#define S_T5_STATIC_U_PLL_FFENABLE    20
#define V_T5_STATIC_U_PLL_FFENABLE(x) ((x) << S_T5_STATIC_U_PLL_FFENABLE)
#define F_T5_STATIC_U_PLL_FFENABLE    V_T5_STATIC_U_PLL_FFENABLE(1U)

#define S_T5_STATIC_U_PLL_STOPCLKB    19
#define V_T5_STATIC_U_PLL_STOPCLKB(x) ((x) << S_T5_STATIC_U_PLL_STOPCLKB)
#define F_T5_STATIC_U_PLL_STOPCLKB    V_T5_STATIC_U_PLL_STOPCLKB(1U)

#define S_T5_STATIC_U_PLL_STOPCLKA    18
#define V_T5_STATIC_U_PLL_STOPCLKA(x) ((x) << S_T5_STATIC_U_PLL_STOPCLKA)
#define F_T5_STATIC_U_PLL_STOPCLKA    V_T5_STATIC_U_PLL_STOPCLKA(1U)

#define S_T5_STATIC_U_PLL_SLEEP    17
#define V_T5_STATIC_U_PLL_SLEEP(x) ((x) << S_T5_STATIC_U_PLL_SLEEP)
#define F_T5_STATIC_U_PLL_SLEEP    V_T5_STATIC_U_PLL_SLEEP(1U)

#define S_T5_STATIC_U_PLL_BYPASS    16
#define V_T5_STATIC_U_PLL_BYPASS(x) ((x) << S_T5_STATIC_U_PLL_BYPASS)
#define F_T5_STATIC_U_PLL_BYPASS    V_T5_STATIC_U_PLL_BYPASS(1U)

#define S_T5_STATIC_U_PLL_LOCKTUNE    0
#define M_T5_STATIC_U_PLL_LOCKTUNE    0xffffU
#define V_T5_STATIC_U_PLL_LOCKTUNE(x) ((x) << S_T5_STATIC_U_PLL_LOCKTUNE)
#define G_T5_STATIC_U_PLL_LOCKTUNE(x) (((x) >> S_T5_STATIC_U_PLL_LOCKTUNE) & M_T5_STATIC_U_PLL_LOCKTUNE)

#define A_DBG_STATIC_U_PLL_CONF2 0x60e8

#define S_T6_STATIC_U_PLL_PREDIV    26
#define M_T6_STATIC_U_PLL_PREDIV    0x3fU
#define V_T6_STATIC_U_PLL_PREDIV(x) ((x) << S_T6_STATIC_U_PLL_PREDIV)
#define G_T6_STATIC_U_PLL_PREDIV(x) (((x) >> S_T6_STATIC_U_PLL_PREDIV) & M_T6_STATIC_U_PLL_PREDIV)

#define S_STATIC_U_PLL_STARTUP    24
#define M_STATIC_U_PLL_STARTUP    0x3U
#define V_STATIC_U_PLL_STARTUP(x) ((x) << S_STATIC_U_PLL_STARTUP)
#define G_STATIC_U_PLL_STARTUP(x) (((x) >> S_STATIC_U_PLL_STARTUP) & M_STATIC_U_PLL_STARTUP)

#define S_STATIC_U_PLL_DCO_BYPASS    23
#define V_STATIC_U_PLL_DCO_BYPASS(x) ((x) << S_STATIC_U_PLL_DCO_BYPASS)
#define F_STATIC_U_PLL_DCO_BYPASS    V_STATIC_U_PLL_DCO_BYPASS(1U)

#define S_STATIC_U_PLL_SDORDER    21
#define M_STATIC_U_PLL_SDORDER    0x3U
#define V_STATIC_U_PLL_SDORDER(x) ((x) << S_STATIC_U_PLL_SDORDER)
#define G_STATIC_U_PLL_SDORDER(x) (((x) >> S_STATIC_U_PLL_SDORDER) & M_STATIC_U_PLL_SDORDER)

#define S_STATIC_U_PLL_DIVCHANGE    20
#define V_STATIC_U_PLL_DIVCHANGE(x) ((x) << S_STATIC_U_PLL_DIVCHANGE)
#define F_STATIC_U_PLL_DIVCHANGE    V_STATIC_U_PLL_DIVCHANGE(1U)

#define S_STATIC_U_PLL_STOPCLKB    19
#define V_STATIC_U_PLL_STOPCLKB(x) ((x) << S_STATIC_U_PLL_STOPCLKB)
#define F_STATIC_U_PLL_STOPCLKB    V_STATIC_U_PLL_STOPCLKB(1U)

#define S_STATIC_U_PLL_STOPCLKA    18
#define V_STATIC_U_PLL_STOPCLKA(x) ((x) << S_STATIC_U_PLL_STOPCLKA)
#define F_STATIC_U_PLL_STOPCLKA    V_STATIC_U_PLL_STOPCLKA(1U)

#define S_T6_STATIC_U_PLL_SLEEP    17
#define V_T6_STATIC_U_PLL_SLEEP(x) ((x) << S_T6_STATIC_U_PLL_SLEEP)
#define F_T6_STATIC_U_PLL_SLEEP    V_T6_STATIC_U_PLL_SLEEP(1U)

#define S_T6_STATIC_U_PLL_BYPASS    16
#define V_T6_STATIC_U_PLL_BYPASS(x) ((x) << S_T6_STATIC_U_PLL_BYPASS)
#define F_T6_STATIC_U_PLL_BYPASS    V_T6_STATIC_U_PLL_BYPASS(1U)

#define S_STATIC_U_PLL_LOCKTUNE    0
#define M_STATIC_U_PLL_LOCKTUNE    0x1fU
#define V_STATIC_U_PLL_LOCKTUNE(x) ((x) << S_STATIC_U_PLL_LOCKTUNE)
#define G_STATIC_U_PLL_LOCKTUNE(x) (((x) >> S_STATIC_U_PLL_LOCKTUNE) & M_STATIC_U_PLL_LOCKTUNE)

#define A_DBG_STATIC_M1_PLL_CONF1 0x60e8

#define S_STATIC_M1_PLL_RANGE    22
#define M_STATIC_M1_PLL_RANGE    0x7U
#define V_STATIC_M1_PLL_RANGE(x) ((x) << S_STATIC_M1_PLL_RANGE)
#define G_STATIC_M1_PLL_RANGE(x) (((x) >> S_STATIC_M1_PLL_RANGE) & M_STATIC_M1_PLL_RANGE)

#define S_STATIC_M1_PLL_DIVQ    17
#define M_STATIC_M1_PLL_DIVQ    0x1fU
#define V_STATIC_M1_PLL_DIVQ(x) ((x) << S_STATIC_M1_PLL_DIVQ)
#define G_STATIC_M1_PLL_DIVQ(x) (((x) >> S_STATIC_M1_PLL_DIVQ) & M_STATIC_M1_PLL_DIVQ)

#define S_STATIC_M1_PLL_DIVFI    8
#define M_STATIC_M1_PLL_DIVFI    0x1ffU
#define V_STATIC_M1_PLL_DIVFI(x) ((x) << S_STATIC_M1_PLL_DIVFI)
#define G_STATIC_M1_PLL_DIVFI(x) (((x) >> S_STATIC_M1_PLL_DIVFI) & M_STATIC_M1_PLL_DIVFI)

#define S_STATIC_M1_PLL_DIVR    2
#define M_STATIC_M1_PLL_DIVR    0x3fU
#define V_STATIC_M1_PLL_DIVR(x) ((x) << S_STATIC_M1_PLL_DIVR)
#define G_STATIC_M1_PLL_DIVR(x) (((x) >> S_STATIC_M1_PLL_DIVR) & M_STATIC_M1_PLL_DIVR)

#define S_STATIC_M1_PLL_BYPASS    1
#define V_STATIC_M1_PLL_BYPASS(x) ((x) << S_STATIC_M1_PLL_BYPASS)
#define F_STATIC_M1_PLL_BYPASS    V_STATIC_M1_PLL_BYPASS(1U)

#define S_STATIC_M1_PLL_RESET    0
#define V_STATIC_M1_PLL_RESET(x) ((x) << S_STATIC_M1_PLL_RESET)
#define F_STATIC_M1_PLL_RESET    V_STATIC_M1_PLL_RESET(1U)

#define A_DBG_T5_STATIC_U_PLL_CONF3 0x60ec

#define S_T5_STATIC_U_PLL_MULTPRE    30
#define M_T5_STATIC_U_PLL_MULTPRE    0x3U
#define V_T5_STATIC_U_PLL_MULTPRE(x) ((x) << S_T5_STATIC_U_PLL_MULTPRE)
#define G_T5_STATIC_U_PLL_MULTPRE(x) (((x) >> S_T5_STATIC_U_PLL_MULTPRE) & M_T5_STATIC_U_PLL_MULTPRE)

#define S_T5_STATIC_U_PLL_LOCKSEL    28
#define M_T5_STATIC_U_PLL_LOCKSEL    0x3U
#define V_T5_STATIC_U_PLL_LOCKSEL(x) ((x) << S_T5_STATIC_U_PLL_LOCKSEL)
#define G_T5_STATIC_U_PLL_LOCKSEL(x) (((x) >> S_T5_STATIC_U_PLL_LOCKSEL) & M_T5_STATIC_U_PLL_LOCKSEL)

#define S_T5_STATIC_U_PLL_FFTUNE    12
#define M_T5_STATIC_U_PLL_FFTUNE    0xffffU
#define V_T5_STATIC_U_PLL_FFTUNE(x) ((x) << S_T5_STATIC_U_PLL_FFTUNE)
#define G_T5_STATIC_U_PLL_FFTUNE(x) (((x) >> S_T5_STATIC_U_PLL_FFTUNE) & M_T5_STATIC_U_PLL_FFTUNE)

#define S_T5_STATIC_U_PLL_RANGEPRE    10
#define M_T5_STATIC_U_PLL_RANGEPRE    0x3U
#define V_T5_STATIC_U_PLL_RANGEPRE(x) ((x) << S_T5_STATIC_U_PLL_RANGEPRE)
#define G_T5_STATIC_U_PLL_RANGEPRE(x) (((x) >> S_T5_STATIC_U_PLL_RANGEPRE) & M_T5_STATIC_U_PLL_RANGEPRE)

#define S_T5_STATIC_U_PLL_RANGEB    5
#define M_T5_STATIC_U_PLL_RANGEB    0x1fU
#define V_T5_STATIC_U_PLL_RANGEB(x) ((x) << S_T5_STATIC_U_PLL_RANGEB)
#define G_T5_STATIC_U_PLL_RANGEB(x) (((x) >> S_T5_STATIC_U_PLL_RANGEB) & M_T5_STATIC_U_PLL_RANGEB)

#define S_T5_STATIC_U_PLL_RANGEA    0
#define M_T5_STATIC_U_PLL_RANGEA    0x1fU
#define V_T5_STATIC_U_PLL_RANGEA(x) ((x) << S_T5_STATIC_U_PLL_RANGEA)
#define G_T5_STATIC_U_PLL_RANGEA(x) (((x) >> S_T5_STATIC_U_PLL_RANGEA) & M_T5_STATIC_U_PLL_RANGEA)

#define A_DBG_STATIC_U_PLL_CONF3 0x60ec

#define S_STATIC_U_PLL_MULTPRE    30
#define M_STATIC_U_PLL_MULTPRE    0x3U
#define V_STATIC_U_PLL_MULTPRE(x) ((x) << S_STATIC_U_PLL_MULTPRE)
#define G_STATIC_U_PLL_MULTPRE(x) (((x) >> S_STATIC_U_PLL_MULTPRE) & M_STATIC_U_PLL_MULTPRE)

#define S_STATIC_U_PLL_LOCKSEL    28
#define V_STATIC_U_PLL_LOCKSEL(x) ((x) << S_STATIC_U_PLL_LOCKSEL)
#define F_STATIC_U_PLL_LOCKSEL    V_STATIC_U_PLL_LOCKSEL(1U)

#define S_STATIC_U_PLL_FFTUNE    12
#define M_STATIC_U_PLL_FFTUNE    0xffffU
#define V_STATIC_U_PLL_FFTUNE(x) ((x) << S_STATIC_U_PLL_FFTUNE)
#define G_STATIC_U_PLL_FFTUNE(x) (((x) >> S_STATIC_U_PLL_FFTUNE) & M_STATIC_U_PLL_FFTUNE)

#define S_STATIC_U_PLL_RANGEPRE    10
#define M_STATIC_U_PLL_RANGEPRE    0x3U
#define V_STATIC_U_PLL_RANGEPRE(x) ((x) << S_STATIC_U_PLL_RANGEPRE)
#define G_STATIC_U_PLL_RANGEPRE(x) (((x) >> S_STATIC_U_PLL_RANGEPRE) & M_STATIC_U_PLL_RANGEPRE)

#define S_T6_STATIC_U_PLL_RANGEB    5
#define M_T6_STATIC_U_PLL_RANGEB    0x1fU
#define V_T6_STATIC_U_PLL_RANGEB(x) ((x) << S_T6_STATIC_U_PLL_RANGEB)
#define G_T6_STATIC_U_PLL_RANGEB(x) (((x) >> S_T6_STATIC_U_PLL_RANGEB) & M_T6_STATIC_U_PLL_RANGEB)

#define S_T6_STATIC_U_PLL_RANGEA    0
#define M_T6_STATIC_U_PLL_RANGEA    0x1fU
#define V_T6_STATIC_U_PLL_RANGEA(x) ((x) << S_T6_STATIC_U_PLL_RANGEA)
#define G_T6_STATIC_U_PLL_RANGEA(x) (((x) >> S_T6_STATIC_U_PLL_RANGEA) & M_T6_STATIC_U_PLL_RANGEA)

#define A_DBG_STATIC_M1_PLL_CONF2 0x60ec

#define S_STATIC_M1_PLL_SSMF    5
#define M_STATIC_M1_PLL_SSMF    0xfU
#define V_STATIC_M1_PLL_SSMF(x) ((x) << S_STATIC_M1_PLL_SSMF)
#define G_STATIC_M1_PLL_SSMF(x) (((x) >> S_STATIC_M1_PLL_SSMF) & M_STATIC_M1_PLL_SSMF)

#define S_STATIC_M1_PLL_SSMD    2
#define M_STATIC_M1_PLL_SSMD    0x7U
#define V_STATIC_M1_PLL_SSMD(x) ((x) << S_STATIC_M1_PLL_SSMD)
#define G_STATIC_M1_PLL_SSMD(x) (((x) >> S_STATIC_M1_PLL_SSMD) & M_STATIC_M1_PLL_SSMD)

#define S_STATIC_M1_PLL_SSDS    1
#define V_STATIC_M1_PLL_SSDS(x) ((x) << S_STATIC_M1_PLL_SSDS)
#define F_STATIC_M1_PLL_SSDS    V_STATIC_M1_PLL_SSDS(1U)

#define S_STATIC_M1_PLL_SSE    0
#define V_STATIC_M1_PLL_SSE(x) ((x) << S_STATIC_M1_PLL_SSE)
#define F_STATIC_M1_PLL_SSE    V_STATIC_M1_PLL_SSE(1U)

#define A_DBG_T5_STATIC_U_PLL_CONF4 0x60f0
#define A_DBG_STATIC_U_PLL_CONF4 0x60f0
#define A_DBG_T5_STATIC_U_PLL_CONF5 0x60f4

#define S_T5_STATIC_U_PLL_VCVTUNE    22
#define M_T5_STATIC_U_PLL_VCVTUNE    0x7U
#define V_T5_STATIC_U_PLL_VCVTUNE(x) ((x) << S_T5_STATIC_U_PLL_VCVTUNE)
#define G_T5_STATIC_U_PLL_VCVTUNE(x) (((x) >> S_T5_STATIC_U_PLL_VCVTUNE) & M_T5_STATIC_U_PLL_VCVTUNE)

#define S_T5_STATIC_U_PLL_LFTUNE_32_40    13
#define M_T5_STATIC_U_PLL_LFTUNE_32_40    0x1ffU
#define V_T5_STATIC_U_PLL_LFTUNE_32_40(x) ((x) << S_T5_STATIC_U_PLL_LFTUNE_32_40)
#define G_T5_STATIC_U_PLL_LFTUNE_32_40(x) (((x) >> S_T5_STATIC_U_PLL_LFTUNE_32_40) & M_T5_STATIC_U_PLL_LFTUNE_32_40)

#define S_T5_STATIC_U_PLL_PREDIV    8
#define M_T5_STATIC_U_PLL_PREDIV    0x1fU
#define V_T5_STATIC_U_PLL_PREDIV(x) ((x) << S_T5_STATIC_U_PLL_PREDIV)
#define G_T5_STATIC_U_PLL_PREDIV(x) (((x) >> S_T5_STATIC_U_PLL_PREDIV) & M_T5_STATIC_U_PLL_PREDIV)

#define S_T5_STATIC_U_PLL_MULT    0
#define M_T5_STATIC_U_PLL_MULT    0xffU
#define V_T5_STATIC_U_PLL_MULT(x) ((x) << S_T5_STATIC_U_PLL_MULT)
#define G_T5_STATIC_U_PLL_MULT(x) (((x) >> S_T5_STATIC_U_PLL_MULT) & M_T5_STATIC_U_PLL_MULT)

#define A_DBG_STATIC_U_PLL_CONF5 0x60f4

#define S_STATIC_U_PLL_FFBYPASS    27
#define V_STATIC_U_PLL_FFBYPASS(x) ((x) << S_STATIC_U_PLL_FFBYPASS)
#define F_STATIC_U_PLL_FFBYPASS    V_STATIC_U_PLL_FFBYPASS(1U)

#define S_STATIC_U_PLL_FASTSTOP    26
#define V_STATIC_U_PLL_FASTSTOP(x) ((x) << S_STATIC_U_PLL_FASTSTOP)
#define F_STATIC_U_PLL_FASTSTOP    V_STATIC_U_PLL_FASTSTOP(1U)

#define S_STATIC_U_PLL_FRAMESTOP    25
#define V_STATIC_U_PLL_FRAMESTOP(x) ((x) << S_STATIC_U_PLL_FRAMESTOP)
#define F_STATIC_U_PLL_FRAMESTOP    V_STATIC_U_PLL_FRAMESTOP(1U)

#define S_STATIC_U_PLL_VCVTUNE    22
#define M_STATIC_U_PLL_VCVTUNE    0x7U
#define V_STATIC_U_PLL_VCVTUNE(x) ((x) << S_STATIC_U_PLL_VCVTUNE)
#define G_STATIC_U_PLL_VCVTUNE(x) (((x) >> S_STATIC_U_PLL_VCVTUNE) & M_STATIC_U_PLL_VCVTUNE)

#define S_STATIC_U_PLL_LFTUNE_32_40    13
#define M_STATIC_U_PLL_LFTUNE_32_40    0x1ffU
#define V_STATIC_U_PLL_LFTUNE_32_40(x) ((x) << S_STATIC_U_PLL_LFTUNE_32_40)
#define G_STATIC_U_PLL_LFTUNE_32_40(x) (((x) >> S_STATIC_U_PLL_LFTUNE_32_40) & M_STATIC_U_PLL_LFTUNE_32_40)

#define S_STATIC_U_PLL_PREDIV_CNF5    8
#define M_STATIC_U_PLL_PREDIV_CNF5    0x1fU
#define V_STATIC_U_PLL_PREDIV_CNF5(x) ((x) << S_STATIC_U_PLL_PREDIV_CNF5)
#define G_STATIC_U_PLL_PREDIV_CNF5(x) (((x) >> S_STATIC_U_PLL_PREDIV_CNF5) & M_STATIC_U_PLL_PREDIV_CNF5)

#define S_T6_STATIC_U_PLL_MULT    0
#define M_T6_STATIC_U_PLL_MULT    0xffU
#define V_T6_STATIC_U_PLL_MULT(x) ((x) << S_T6_STATIC_U_PLL_MULT)
#define G_T6_STATIC_U_PLL_MULT(x) (((x) >> S_T6_STATIC_U_PLL_MULT) & M_T6_STATIC_U_PLL_MULT)

#define A_DBG_T5_STATIC_KR_PLL_CONF1 0x60f8

#define S_T5_STATIC_KR_PLL_BYPASS    30
#define V_T5_STATIC_KR_PLL_BYPASS(x) ((x) << S_T5_STATIC_KR_PLL_BYPASS)
#define F_T5_STATIC_KR_PLL_BYPASS    V_T5_STATIC_KR_PLL_BYPASS(1U)

#define S_T5_STATIC_KR_PLL_VBOOSTDIV    27
#define M_T5_STATIC_KR_PLL_VBOOSTDIV    0x7U
#define V_T5_STATIC_KR_PLL_VBOOSTDIV(x) ((x) << S_T5_STATIC_KR_PLL_VBOOSTDIV)
#define G_T5_STATIC_KR_PLL_VBOOSTDIV(x) (((x) >> S_T5_STATIC_KR_PLL_VBOOSTDIV) & M_T5_STATIC_KR_PLL_VBOOSTDIV)

#define S_T5_STATIC_KR_PLL_CPISEL    24
#define M_T5_STATIC_KR_PLL_CPISEL    0x7U
#define V_T5_STATIC_KR_PLL_CPISEL(x) ((x) << S_T5_STATIC_KR_PLL_CPISEL)
#define G_T5_STATIC_KR_PLL_CPISEL(x) (((x) >> S_T5_STATIC_KR_PLL_CPISEL) & M_T5_STATIC_KR_PLL_CPISEL)

#define S_T5_STATIC_KR_PLL_CCALMETHOD    23
#define V_T5_STATIC_KR_PLL_CCALMETHOD(x) ((x) << S_T5_STATIC_KR_PLL_CCALMETHOD)
#define F_T5_STATIC_KR_PLL_CCALMETHOD    V_T5_STATIC_KR_PLL_CCALMETHOD(1U)

#define S_T5_STATIC_KR_PLL_CCALLOAD    22
#define V_T5_STATIC_KR_PLL_CCALLOAD(x) ((x) << S_T5_STATIC_KR_PLL_CCALLOAD)
#define F_T5_STATIC_KR_PLL_CCALLOAD    V_T5_STATIC_KR_PLL_CCALLOAD(1U)

#define S_T5_STATIC_KR_PLL_CCALFMIN    21
#define V_T5_STATIC_KR_PLL_CCALFMIN(x) ((x) << S_T5_STATIC_KR_PLL_CCALFMIN)
#define F_T5_STATIC_KR_PLL_CCALFMIN    V_T5_STATIC_KR_PLL_CCALFMIN(1U)

#define S_T5_STATIC_KR_PLL_CCALFMAX    20
#define V_T5_STATIC_KR_PLL_CCALFMAX(x) ((x) << S_T5_STATIC_KR_PLL_CCALFMAX)
#define F_T5_STATIC_KR_PLL_CCALFMAX    V_T5_STATIC_KR_PLL_CCALFMAX(1U)

#define S_T5_STATIC_KR_PLL_CCALCVHOLD    19
#define V_T5_STATIC_KR_PLL_CCALCVHOLD(x) ((x) << S_T5_STATIC_KR_PLL_CCALCVHOLD)
#define F_T5_STATIC_KR_PLL_CCALCVHOLD    V_T5_STATIC_KR_PLL_CCALCVHOLD(1U)

#define S_T5_STATIC_KR_PLL_CCALBANDSEL    15
#define M_T5_STATIC_KR_PLL_CCALBANDSEL    0xfU
#define V_T5_STATIC_KR_PLL_CCALBANDSEL(x) ((x) << S_T5_STATIC_KR_PLL_CCALBANDSEL)
#define G_T5_STATIC_KR_PLL_CCALBANDSEL(x) (((x) >> S_T5_STATIC_KR_PLL_CCALBANDSEL) & M_T5_STATIC_KR_PLL_CCALBANDSEL)

#define S_T5_STATIC_KR_PLL_BGOFFSET    11
#define M_T5_STATIC_KR_PLL_BGOFFSET    0xfU
#define V_T5_STATIC_KR_PLL_BGOFFSET(x) ((x) << S_T5_STATIC_KR_PLL_BGOFFSET)
#define G_T5_STATIC_KR_PLL_BGOFFSET(x) (((x) >> S_T5_STATIC_KR_PLL_BGOFFSET) & M_T5_STATIC_KR_PLL_BGOFFSET)

#define S_T5_STATIC_KR_PLL_P    8
#define M_T5_STATIC_KR_PLL_P    0x7U
#define V_T5_STATIC_KR_PLL_P(x) ((x) << S_T5_STATIC_KR_PLL_P)
#define G_T5_STATIC_KR_PLL_P(x) (((x) >> S_T5_STATIC_KR_PLL_P) & M_T5_STATIC_KR_PLL_P)

#define S_T5_STATIC_KR_PLL_N2    4
#define M_T5_STATIC_KR_PLL_N2    0xfU
#define V_T5_STATIC_KR_PLL_N2(x) ((x) << S_T5_STATIC_KR_PLL_N2)
#define G_T5_STATIC_KR_PLL_N2(x) (((x) >> S_T5_STATIC_KR_PLL_N2) & M_T5_STATIC_KR_PLL_N2)

#define S_T5_STATIC_KR_PLL_N1    0
#define M_T5_STATIC_KR_PLL_N1    0xfU
#define V_T5_STATIC_KR_PLL_N1(x) ((x) << S_T5_STATIC_KR_PLL_N1)
#define G_T5_STATIC_KR_PLL_N1(x) (((x) >> S_T5_STATIC_KR_PLL_N1) & M_T5_STATIC_KR_PLL_N1)

#define A_DBG_STATIC_KR_PLL_CONF1 0x60f8

#define S_T6_STATIC_KR_PLL_BYPASS    30
#define V_T6_STATIC_KR_PLL_BYPASS(x) ((x) << S_T6_STATIC_KR_PLL_BYPASS)
#define F_T6_STATIC_KR_PLL_BYPASS    V_T6_STATIC_KR_PLL_BYPASS(1U)

#define S_STATIC_KR_PLL_VBOOSTDIV    27
#define M_STATIC_KR_PLL_VBOOSTDIV    0x7U
#define V_STATIC_KR_PLL_VBOOSTDIV(x) ((x) << S_STATIC_KR_PLL_VBOOSTDIV)
#define G_STATIC_KR_PLL_VBOOSTDIV(x) (((x) >> S_STATIC_KR_PLL_VBOOSTDIV) & M_STATIC_KR_PLL_VBOOSTDIV)

#define S_STATIC_KR_PLL_CPISEL    24
#define M_STATIC_KR_PLL_CPISEL    0x7U
#define V_STATIC_KR_PLL_CPISEL(x) ((x) << S_STATIC_KR_PLL_CPISEL)
#define G_STATIC_KR_PLL_CPISEL(x) (((x) >> S_STATIC_KR_PLL_CPISEL) & M_STATIC_KR_PLL_CPISEL)

#define S_STATIC_KR_PLL_CCALMETHOD    23
#define V_STATIC_KR_PLL_CCALMETHOD(x) ((x) << S_STATIC_KR_PLL_CCALMETHOD)
#define F_STATIC_KR_PLL_CCALMETHOD    V_STATIC_KR_PLL_CCALMETHOD(1U)

#define S_STATIC_KR_PLL_CCALLOAD    22
#define V_STATIC_KR_PLL_CCALLOAD(x) ((x) << S_STATIC_KR_PLL_CCALLOAD)
#define F_STATIC_KR_PLL_CCALLOAD    V_STATIC_KR_PLL_CCALLOAD(1U)

#define S_STATIC_KR_PLL_CCALFMIN    21
#define V_STATIC_KR_PLL_CCALFMIN(x) ((x) << S_STATIC_KR_PLL_CCALFMIN)
#define F_STATIC_KR_PLL_CCALFMIN    V_STATIC_KR_PLL_CCALFMIN(1U)

#define S_STATIC_KR_PLL_CCALFMAX    20
#define V_STATIC_KR_PLL_CCALFMAX(x) ((x) << S_STATIC_KR_PLL_CCALFMAX)
#define F_STATIC_KR_PLL_CCALFMAX    V_STATIC_KR_PLL_CCALFMAX(1U)

#define S_STATIC_KR_PLL_CCALCVHOLD    19
#define V_STATIC_KR_PLL_CCALCVHOLD(x) ((x) << S_STATIC_KR_PLL_CCALCVHOLD)
#define F_STATIC_KR_PLL_CCALCVHOLD    V_STATIC_KR_PLL_CCALCVHOLD(1U)

#define S_STATIC_KR_PLL_CCALBANDSEL    15
#define M_STATIC_KR_PLL_CCALBANDSEL    0xfU
#define V_STATIC_KR_PLL_CCALBANDSEL(x) ((x) << S_STATIC_KR_PLL_CCALBANDSEL)
#define G_STATIC_KR_PLL_CCALBANDSEL(x) (((x) >> S_STATIC_KR_PLL_CCALBANDSEL) & M_STATIC_KR_PLL_CCALBANDSEL)

#define S_STATIC_KR_PLL_BGOFFSET    11
#define M_STATIC_KR_PLL_BGOFFSET    0xfU
#define V_STATIC_KR_PLL_BGOFFSET(x) ((x) << S_STATIC_KR_PLL_BGOFFSET)
#define G_STATIC_KR_PLL_BGOFFSET(x) (((x) >> S_STATIC_KR_PLL_BGOFFSET) & M_STATIC_KR_PLL_BGOFFSET)

#define S_T6_STATIC_KR_PLL_P    8
#define M_T6_STATIC_KR_PLL_P    0x7U
#define V_T6_STATIC_KR_PLL_P(x) ((x) << S_T6_STATIC_KR_PLL_P)
#define G_T6_STATIC_KR_PLL_P(x) (((x) >> S_T6_STATIC_KR_PLL_P) & M_T6_STATIC_KR_PLL_P)

#define S_T6_STATIC_KR_PLL_N2    4
#define M_T6_STATIC_KR_PLL_N2    0xfU
#define V_T6_STATIC_KR_PLL_N2(x) ((x) << S_T6_STATIC_KR_PLL_N2)
#define G_T6_STATIC_KR_PLL_N2(x) (((x) >> S_T6_STATIC_KR_PLL_N2) & M_T6_STATIC_KR_PLL_N2)

#define S_T6_STATIC_KR_PLL_N1    0
#define M_T6_STATIC_KR_PLL_N1    0xfU
#define V_T6_STATIC_KR_PLL_N1(x) ((x) << S_T6_STATIC_KR_PLL_N1)
#define G_T6_STATIC_KR_PLL_N1(x) (((x) >> S_T6_STATIC_KR_PLL_N1) & M_T6_STATIC_KR_PLL_N1)

#define A_DBG_T5_STATIC_KR_PLL_CONF2 0x60fc

#define S_T5_STATIC_KR_PLL_M    11
#define M_T5_STATIC_KR_PLL_M    0x1ffU
#define V_T5_STATIC_KR_PLL_M(x) ((x) << S_T5_STATIC_KR_PLL_M)
#define G_T5_STATIC_KR_PLL_M(x) (((x) >> S_T5_STATIC_KR_PLL_M) & M_T5_STATIC_KR_PLL_M)

#define S_T5_STATIC_KR_PLL_ANALOGTUNE    0
#define M_T5_STATIC_KR_PLL_ANALOGTUNE    0x7ffU
#define V_T5_STATIC_KR_PLL_ANALOGTUNE(x) ((x) << S_T5_STATIC_KR_PLL_ANALOGTUNE)
#define G_T5_STATIC_KR_PLL_ANALOGTUNE(x) (((x) >> S_T5_STATIC_KR_PLL_ANALOGTUNE) & M_T5_STATIC_KR_PLL_ANALOGTUNE)

#define A_DBG_STATIC_KR_PLL_CONF2 0x60fc

#define S_T6_STATIC_KR_PLL_M    11
#define M_T6_STATIC_KR_PLL_M    0x1ffU
#define V_T6_STATIC_KR_PLL_M(x) ((x) << S_T6_STATIC_KR_PLL_M)
#define G_T6_STATIC_KR_PLL_M(x) (((x) >> S_T6_STATIC_KR_PLL_M) & M_T6_STATIC_KR_PLL_M)

#define S_STATIC_KR_PLL_ANALOGTUNE    0
#define M_STATIC_KR_PLL_ANALOGTUNE    0x7ffU
#define V_STATIC_KR_PLL_ANALOGTUNE(x) ((x) << S_STATIC_KR_PLL_ANALOGTUNE)
#define G_STATIC_KR_PLL_ANALOGTUNE(x) (((x) >> S_STATIC_KR_PLL_ANALOGTUNE) & M_STATIC_KR_PLL_ANALOGTUNE)

#define A_DBG_PVT_REG_CALIBRATE_CTL 0x6100

#define S_HALT_CALIBRATE    1
#define V_HALT_CALIBRATE(x) ((x) << S_HALT_CALIBRATE)
#define F_HALT_CALIBRATE    V_HALT_CALIBRATE(1U)

#define S_RESET_CALIBRATE    0
#define V_RESET_CALIBRATE(x) ((x) << S_RESET_CALIBRATE)
#define F_RESET_CALIBRATE    V_RESET_CALIBRATE(1U)

#define A_DBG_GPIO_EN_NEW 0x6100

#define S_GPIO16_OEN    7
#define V_GPIO16_OEN(x) ((x) << S_GPIO16_OEN)
#define F_GPIO16_OEN    V_GPIO16_OEN(1U)

#define S_GPIO17_OEN    6
#define V_GPIO17_OEN(x) ((x) << S_GPIO17_OEN)
#define F_GPIO17_OEN    V_GPIO17_OEN(1U)

#define S_GPIO18_OEN    5
#define V_GPIO18_OEN(x) ((x) << S_GPIO18_OEN)
#define F_GPIO18_OEN    V_GPIO18_OEN(1U)

#define S_GPIO19_OEN    4
#define V_GPIO19_OEN(x) ((x) << S_GPIO19_OEN)
#define F_GPIO19_OEN    V_GPIO19_OEN(1U)

#define S_GPIO16_OUT_VAL    3
#define V_GPIO16_OUT_VAL(x) ((x) << S_GPIO16_OUT_VAL)
#define F_GPIO16_OUT_VAL    V_GPIO16_OUT_VAL(1U)

#define S_GPIO17_OUT_VAL    2
#define V_GPIO17_OUT_VAL(x) ((x) << S_GPIO17_OUT_VAL)
#define F_GPIO17_OUT_VAL    V_GPIO17_OUT_VAL(1U)

#define S_GPIO18_OUT_VAL    1
#define V_GPIO18_OUT_VAL(x) ((x) << S_GPIO18_OUT_VAL)
#define F_GPIO18_OUT_VAL    V_GPIO18_OUT_VAL(1U)

#define S_GPIO19_OUT_VAL    0
#define V_GPIO19_OUT_VAL(x) ((x) << S_GPIO19_OUT_VAL)
#define F_GPIO19_OUT_VAL    V_GPIO19_OUT_VAL(1U)

#define A_DBG_GPIO_OEN 0x6100

#define S_GPIO23_OEN    23
#define V_GPIO23_OEN(x) ((x) << S_GPIO23_OEN)
#define F_GPIO23_OEN    V_GPIO23_OEN(1U)

#define S_GPIO22_OEN    22
#define V_GPIO22_OEN(x) ((x) << S_GPIO22_OEN)
#define F_GPIO22_OEN    V_GPIO22_OEN(1U)

#define S_GPIO21_OEN    21
#define V_GPIO21_OEN(x) ((x) << S_GPIO21_OEN)
#define F_GPIO21_OEN    V_GPIO21_OEN(1U)

#define S_GPIO20_OEN    20
#define V_GPIO20_OEN(x) ((x) << S_GPIO20_OEN)
#define F_GPIO20_OEN    V_GPIO20_OEN(1U)

#define S_T7_GPIO19_OEN    19
#define V_T7_GPIO19_OEN(x) ((x) << S_T7_GPIO19_OEN)
#define F_T7_GPIO19_OEN    V_T7_GPIO19_OEN(1U)

#define S_T7_GPIO18_OEN    18
#define V_T7_GPIO18_OEN(x) ((x) << S_T7_GPIO18_OEN)
#define F_T7_GPIO18_OEN    V_T7_GPIO18_OEN(1U)

#define S_T7_GPIO17_OEN    17
#define V_T7_GPIO17_OEN(x) ((x) << S_T7_GPIO17_OEN)
#define F_T7_GPIO17_OEN    V_T7_GPIO17_OEN(1U)

#define S_T7_GPIO16_OEN    16
#define V_T7_GPIO16_OEN(x) ((x) << S_T7_GPIO16_OEN)
#define F_T7_GPIO16_OEN    V_T7_GPIO16_OEN(1U)

#define S_T7_GPIO15_OEN    15
#define V_T7_GPIO15_OEN(x) ((x) << S_T7_GPIO15_OEN)
#define F_T7_GPIO15_OEN    V_T7_GPIO15_OEN(1U)

#define S_T7_GPIO14_OEN    14
#define V_T7_GPIO14_OEN(x) ((x) << S_T7_GPIO14_OEN)
#define F_T7_GPIO14_OEN    V_T7_GPIO14_OEN(1U)

#define S_T7_GPIO13_OEN    13
#define V_T7_GPIO13_OEN(x) ((x) << S_T7_GPIO13_OEN)
#define F_T7_GPIO13_OEN    V_T7_GPIO13_OEN(1U)

#define S_T7_GPIO12_OEN    12
#define V_T7_GPIO12_OEN(x) ((x) << S_T7_GPIO12_OEN)
#define F_T7_GPIO12_OEN    V_T7_GPIO12_OEN(1U)

#define S_T7_GPIO11_OEN    11
#define V_T7_GPIO11_OEN(x) ((x) << S_T7_GPIO11_OEN)
#define F_T7_GPIO11_OEN    V_T7_GPIO11_OEN(1U)

#define S_T7_GPIO10_OEN    10
#define V_T7_GPIO10_OEN(x) ((x) << S_T7_GPIO10_OEN)
#define F_T7_GPIO10_OEN    V_T7_GPIO10_OEN(1U)

#define S_T7_GPIO9_OEN    9
#define V_T7_GPIO9_OEN(x) ((x) << S_T7_GPIO9_OEN)
#define F_T7_GPIO9_OEN    V_T7_GPIO9_OEN(1U)

#define S_T7_GPIO8_OEN    8
#define V_T7_GPIO8_OEN(x) ((x) << S_T7_GPIO8_OEN)
#define F_T7_GPIO8_OEN    V_T7_GPIO8_OEN(1U)

#define S_T7_GPIO7_OEN    7
#define V_T7_GPIO7_OEN(x) ((x) << S_T7_GPIO7_OEN)
#define F_T7_GPIO7_OEN    V_T7_GPIO7_OEN(1U)

#define S_T7_GPIO6_OEN    6
#define V_T7_GPIO6_OEN(x) ((x) << S_T7_GPIO6_OEN)
#define F_T7_GPIO6_OEN    V_T7_GPIO6_OEN(1U)

#define S_T7_GPIO5_OEN    5
#define V_T7_GPIO5_OEN(x) ((x) << S_T7_GPIO5_OEN)
#define F_T7_GPIO5_OEN    V_T7_GPIO5_OEN(1U)

#define S_T7_GPIO4_OEN    4
#define V_T7_GPIO4_OEN(x) ((x) << S_T7_GPIO4_OEN)
#define F_T7_GPIO4_OEN    V_T7_GPIO4_OEN(1U)

#define S_T7_GPIO3_OEN    3
#define V_T7_GPIO3_OEN(x) ((x) << S_T7_GPIO3_OEN)
#define F_T7_GPIO3_OEN    V_T7_GPIO3_OEN(1U)

#define S_T7_GPIO2_OEN    2
#define V_T7_GPIO2_OEN(x) ((x) << S_T7_GPIO2_OEN)
#define F_T7_GPIO2_OEN    V_T7_GPIO2_OEN(1U)

#define S_T7_GPIO1_OEN    1
#define V_T7_GPIO1_OEN(x) ((x) << S_T7_GPIO1_OEN)
#define F_T7_GPIO1_OEN    V_T7_GPIO1_OEN(1U)

#define S_T7_GPIO0_OEN    0
#define V_T7_GPIO0_OEN(x) ((x) << S_T7_GPIO0_OEN)
#define F_T7_GPIO0_OEN    V_T7_GPIO0_OEN(1U)

#define A_DBG_PVT_REG_UPDATE_CTL 0x6104

#define S_FAST_UPDATE    8
#define V_FAST_UPDATE(x) ((x) << S_FAST_UPDATE)
#define F_FAST_UPDATE    V_FAST_UPDATE(1U)

#define S_FORCE_REG_IN_VALUE    2
#define V_FORCE_REG_IN_VALUE(x) ((x) << S_FORCE_REG_IN_VALUE)
#define F_FORCE_REG_IN_VALUE    V_FORCE_REG_IN_VALUE(1U)

#define S_HALT_UPDATE    1
#define V_HALT_UPDATE(x) ((x) << S_HALT_UPDATE)
#define F_HALT_UPDATE    V_HALT_UPDATE(1U)

#define A_DBG_GPIO_IN_NEW 0x6104

#define S_GPIO16_CHG_DET    7
#define V_GPIO16_CHG_DET(x) ((x) << S_GPIO16_CHG_DET)
#define F_GPIO16_CHG_DET    V_GPIO16_CHG_DET(1U)

#define S_GPIO17_CHG_DET    6
#define V_GPIO17_CHG_DET(x) ((x) << S_GPIO17_CHG_DET)
#define F_GPIO17_CHG_DET    V_GPIO17_CHG_DET(1U)

#define S_GPIO18_CHG_DET    5
#define V_GPIO18_CHG_DET(x) ((x) << S_GPIO18_CHG_DET)
#define F_GPIO18_CHG_DET    V_GPIO18_CHG_DET(1U)

#define S_GPIO19_CHG_DET    4
#define V_GPIO19_CHG_DET(x) ((x) << S_GPIO19_CHG_DET)
#define F_GPIO19_CHG_DET    V_GPIO19_CHG_DET(1U)

#define S_GPIO19_IN    3
#define V_GPIO19_IN(x) ((x) << S_GPIO19_IN)
#define F_GPIO19_IN    V_GPIO19_IN(1U)

#define S_GPIO18_IN    2
#define V_GPIO18_IN(x) ((x) << S_GPIO18_IN)
#define F_GPIO18_IN    V_GPIO18_IN(1U)

#define S_GPIO17_IN    1
#define V_GPIO17_IN(x) ((x) << S_GPIO17_IN)
#define F_GPIO17_IN    V_GPIO17_IN(1U)

#define S_GPIO16_IN    0
#define V_GPIO16_IN(x) ((x) << S_GPIO16_IN)
#define F_GPIO16_IN    V_GPIO16_IN(1U)

#define A_DBG_GPIO_CHG_DET 0x6104

#define S_GPIO23_CHG_DET    23
#define V_GPIO23_CHG_DET(x) ((x) << S_GPIO23_CHG_DET)
#define F_GPIO23_CHG_DET    V_GPIO23_CHG_DET(1U)

#define S_GPIO22_CHG_DET    22
#define V_GPIO22_CHG_DET(x) ((x) << S_GPIO22_CHG_DET)
#define F_GPIO22_CHG_DET    V_GPIO22_CHG_DET(1U)

#define S_GPIO21_CHG_DET    21
#define V_GPIO21_CHG_DET(x) ((x) << S_GPIO21_CHG_DET)
#define F_GPIO21_CHG_DET    V_GPIO21_CHG_DET(1U)

#define S_GPIO20_CHG_DET    20
#define V_GPIO20_CHG_DET(x) ((x) << S_GPIO20_CHG_DET)
#define F_GPIO20_CHG_DET    V_GPIO20_CHG_DET(1U)

#define S_T7_GPIO19_CHG_DET    19
#define V_T7_GPIO19_CHG_DET(x) ((x) << S_T7_GPIO19_CHG_DET)
#define F_T7_GPIO19_CHG_DET    V_T7_GPIO19_CHG_DET(1U)

#define S_T7_GPIO18_CHG_DET    18
#define V_T7_GPIO18_CHG_DET(x) ((x) << S_T7_GPIO18_CHG_DET)
#define F_T7_GPIO18_CHG_DET    V_T7_GPIO18_CHG_DET(1U)

#define S_T7_GPIO17_CHG_DET    17
#define V_T7_GPIO17_CHG_DET(x) ((x) << S_T7_GPIO17_CHG_DET)
#define F_T7_GPIO17_CHG_DET    V_T7_GPIO17_CHG_DET(1U)

#define S_T7_GPIO16_CHG_DET    16
#define V_T7_GPIO16_CHG_DET(x) ((x) << S_T7_GPIO16_CHG_DET)
#define F_T7_GPIO16_CHG_DET    V_T7_GPIO16_CHG_DET(1U)

#define S_T7_GPIO15_CHG_DET    15
#define V_T7_GPIO15_CHG_DET(x) ((x) << S_T7_GPIO15_CHG_DET)
#define F_T7_GPIO15_CHG_DET    V_T7_GPIO15_CHG_DET(1U)

#define S_T7_GPIO14_CHG_DET    14
#define V_T7_GPIO14_CHG_DET(x) ((x) << S_T7_GPIO14_CHG_DET)
#define F_T7_GPIO14_CHG_DET    V_T7_GPIO14_CHG_DET(1U)

#define S_T7_GPIO13_CHG_DET    13
#define V_T7_GPIO13_CHG_DET(x) ((x) << S_T7_GPIO13_CHG_DET)
#define F_T7_GPIO13_CHG_DET    V_T7_GPIO13_CHG_DET(1U)

#define S_T7_GPIO12_CHG_DET    12
#define V_T7_GPIO12_CHG_DET(x) ((x) << S_T7_GPIO12_CHG_DET)
#define F_T7_GPIO12_CHG_DET    V_T7_GPIO12_CHG_DET(1U)

#define S_T7_GPIO11_CHG_DET    11
#define V_T7_GPIO11_CHG_DET(x) ((x) << S_T7_GPIO11_CHG_DET)
#define F_T7_GPIO11_CHG_DET    V_T7_GPIO11_CHG_DET(1U)

#define S_T7_GPIO10_CHG_DET    10
#define V_T7_GPIO10_CHG_DET(x) ((x) << S_T7_GPIO10_CHG_DET)
#define F_T7_GPIO10_CHG_DET    V_T7_GPIO10_CHG_DET(1U)

#define S_T7_GPIO9_CHG_DET    9
#define V_T7_GPIO9_CHG_DET(x) ((x) << S_T7_GPIO9_CHG_DET)
#define F_T7_GPIO9_CHG_DET    V_T7_GPIO9_CHG_DET(1U)

#define S_T7_GPIO8_CHG_DET    8
#define V_T7_GPIO8_CHG_DET(x) ((x) << S_T7_GPIO8_CHG_DET)
#define F_T7_GPIO8_CHG_DET    V_T7_GPIO8_CHG_DET(1U)

#define S_T7_GPIO7_CHG_DET    7
#define V_T7_GPIO7_CHG_DET(x) ((x) << S_T7_GPIO7_CHG_DET)
#define F_T7_GPIO7_CHG_DET    V_T7_GPIO7_CHG_DET(1U)

#define S_T7_GPIO6_CHG_DET    6
#define V_T7_GPIO6_CHG_DET(x) ((x) << S_T7_GPIO6_CHG_DET)
#define F_T7_GPIO6_CHG_DET    V_T7_GPIO6_CHG_DET(1U)

#define S_T7_GPIO5_CHG_DET    5
#define V_T7_GPIO5_CHG_DET(x) ((x) << S_T7_GPIO5_CHG_DET)
#define F_T7_GPIO5_CHG_DET    V_T7_GPIO5_CHG_DET(1U)

#define S_T7_GPIO4_CHG_DET    4
#define V_T7_GPIO4_CHG_DET(x) ((x) << S_T7_GPIO4_CHG_DET)
#define F_T7_GPIO4_CHG_DET    V_T7_GPIO4_CHG_DET(1U)

#define S_T7_GPIO3_CHG_DET    3
#define V_T7_GPIO3_CHG_DET(x) ((x) << S_T7_GPIO3_CHG_DET)
#define F_T7_GPIO3_CHG_DET    V_T7_GPIO3_CHG_DET(1U)

#define S_T7_GPIO2_CHG_DET    2
#define V_T7_GPIO2_CHG_DET(x) ((x) << S_T7_GPIO2_CHG_DET)
#define F_T7_GPIO2_CHG_DET    V_T7_GPIO2_CHG_DET(1U)

#define S_T7_GPIO1_CHG_DET    1
#define V_T7_GPIO1_CHG_DET(x) ((x) << S_T7_GPIO1_CHG_DET)
#define F_T7_GPIO1_CHG_DET    V_T7_GPIO1_CHG_DET(1U)

#define S_T7_GPIO0_CHG_DET    0
#define V_T7_GPIO0_CHG_DET(x) ((x) << S_T7_GPIO0_CHG_DET)
#define F_T7_GPIO0_CHG_DET    V_T7_GPIO0_CHG_DET(1U)

#define A_DBG_PVT_REG_LAST_MEASUREMENT 0x6108

#define S_LAST_MEASUREMENT_SELECT    8
#define M_LAST_MEASUREMENT_SELECT    0x3U
#define V_LAST_MEASUREMENT_SELECT(x) ((x) << S_LAST_MEASUREMENT_SELECT)
#define G_LAST_MEASUREMENT_SELECT(x) (((x) >> S_LAST_MEASUREMENT_SELECT) & M_LAST_MEASUREMENT_SELECT)

#define S_LAST_MEASUREMENT_RESULT_BANK_B    4
#define M_LAST_MEASUREMENT_RESULT_BANK_B    0xfU
#define V_LAST_MEASUREMENT_RESULT_BANK_B(x) ((x) << S_LAST_MEASUREMENT_RESULT_BANK_B)
#define G_LAST_MEASUREMENT_RESULT_BANK_B(x) (((x) >> S_LAST_MEASUREMENT_RESULT_BANK_B) & M_LAST_MEASUREMENT_RESULT_BANK_B)

#define S_LAST_MEASUREMENT_RESULT_BANK_A    0
#define M_LAST_MEASUREMENT_RESULT_BANK_A    0xfU
#define V_LAST_MEASUREMENT_RESULT_BANK_A(x) ((x) << S_LAST_MEASUREMENT_RESULT_BANK_A)
#define G_LAST_MEASUREMENT_RESULT_BANK_A(x) (((x) >> S_LAST_MEASUREMENT_RESULT_BANK_A) & M_LAST_MEASUREMENT_RESULT_BANK_A)

#define A_DBG_T5_STATIC_KX_PLL_CONF1 0x6108

#define S_T5_STATIC_KX_PLL_BYPASS    30
#define V_T5_STATIC_KX_PLL_BYPASS(x) ((x) << S_T5_STATIC_KX_PLL_BYPASS)
#define F_T5_STATIC_KX_PLL_BYPASS    V_T5_STATIC_KX_PLL_BYPASS(1U)

#define S_T5_STATIC_KX_PLL_VBOOSTDIV    27
#define M_T5_STATIC_KX_PLL_VBOOSTDIV    0x7U
#define V_T5_STATIC_KX_PLL_VBOOSTDIV(x) ((x) << S_T5_STATIC_KX_PLL_VBOOSTDIV)
#define G_T5_STATIC_KX_PLL_VBOOSTDIV(x) (((x) >> S_T5_STATIC_KX_PLL_VBOOSTDIV) & M_T5_STATIC_KX_PLL_VBOOSTDIV)

#define S_T5_STATIC_KX_PLL_CPISEL    24
#define M_T5_STATIC_KX_PLL_CPISEL    0x7U
#define V_T5_STATIC_KX_PLL_CPISEL(x) ((x) << S_T5_STATIC_KX_PLL_CPISEL)
#define G_T5_STATIC_KX_PLL_CPISEL(x) (((x) >> S_T5_STATIC_KX_PLL_CPISEL) & M_T5_STATIC_KX_PLL_CPISEL)

#define S_T5_STATIC_KX_PLL_CCALMETHOD    23
#define V_T5_STATIC_KX_PLL_CCALMETHOD(x) ((x) << S_T5_STATIC_KX_PLL_CCALMETHOD)
#define F_T5_STATIC_KX_PLL_CCALMETHOD    V_T5_STATIC_KX_PLL_CCALMETHOD(1U)

#define S_T5_STATIC_KX_PLL_CCALLOAD    22
#define V_T5_STATIC_KX_PLL_CCALLOAD(x) ((x) << S_T5_STATIC_KX_PLL_CCALLOAD)
#define F_T5_STATIC_KX_PLL_CCALLOAD    V_T5_STATIC_KX_PLL_CCALLOAD(1U)

#define S_T5_STATIC_KX_PLL_CCALFMIN    21
#define V_T5_STATIC_KX_PLL_CCALFMIN(x) ((x) << S_T5_STATIC_KX_PLL_CCALFMIN)
#define F_T5_STATIC_KX_PLL_CCALFMIN    V_T5_STATIC_KX_PLL_CCALFMIN(1U)

#define S_T5_STATIC_KX_PLL_CCALFMAX    20
#define V_T5_STATIC_KX_PLL_CCALFMAX(x) ((x) << S_T5_STATIC_KX_PLL_CCALFMAX)
#define F_T5_STATIC_KX_PLL_CCALFMAX    V_T5_STATIC_KX_PLL_CCALFMAX(1U)

#define S_T5_STATIC_KX_PLL_CCALCVHOLD    19
#define V_T5_STATIC_KX_PLL_CCALCVHOLD(x) ((x) << S_T5_STATIC_KX_PLL_CCALCVHOLD)
#define F_T5_STATIC_KX_PLL_CCALCVHOLD    V_T5_STATIC_KX_PLL_CCALCVHOLD(1U)

#define S_T5_STATIC_KX_PLL_CCALBANDSEL    15
#define M_T5_STATIC_KX_PLL_CCALBANDSEL    0xfU
#define V_T5_STATIC_KX_PLL_CCALBANDSEL(x) ((x) << S_T5_STATIC_KX_PLL_CCALBANDSEL)
#define G_T5_STATIC_KX_PLL_CCALBANDSEL(x) (((x) >> S_T5_STATIC_KX_PLL_CCALBANDSEL) & M_T5_STATIC_KX_PLL_CCALBANDSEL)

#define S_T5_STATIC_KX_PLL_BGOFFSET    11
#define M_T5_STATIC_KX_PLL_BGOFFSET    0xfU
#define V_T5_STATIC_KX_PLL_BGOFFSET(x) ((x) << S_T5_STATIC_KX_PLL_BGOFFSET)
#define G_T5_STATIC_KX_PLL_BGOFFSET(x) (((x) >> S_T5_STATIC_KX_PLL_BGOFFSET) & M_T5_STATIC_KX_PLL_BGOFFSET)

#define S_T5_STATIC_KX_PLL_P    8
#define M_T5_STATIC_KX_PLL_P    0x7U
#define V_T5_STATIC_KX_PLL_P(x) ((x) << S_T5_STATIC_KX_PLL_P)
#define G_T5_STATIC_KX_PLL_P(x) (((x) >> S_T5_STATIC_KX_PLL_P) & M_T5_STATIC_KX_PLL_P)

#define S_T5_STATIC_KX_PLL_N2    4
#define M_T5_STATIC_KX_PLL_N2    0xfU
#define V_T5_STATIC_KX_PLL_N2(x) ((x) << S_T5_STATIC_KX_PLL_N2)
#define G_T5_STATIC_KX_PLL_N2(x) (((x) >> S_T5_STATIC_KX_PLL_N2) & M_T5_STATIC_KX_PLL_N2)

#define S_T5_STATIC_KX_PLL_N1    0
#define M_T5_STATIC_KX_PLL_N1    0xfU
#define V_T5_STATIC_KX_PLL_N1(x) ((x) << S_T5_STATIC_KX_PLL_N1)
#define G_T5_STATIC_KX_PLL_N1(x) (((x) >> S_T5_STATIC_KX_PLL_N1) & M_T5_STATIC_KX_PLL_N1)

#define A_DBG_STATIC_KX_PLL_CONF1 0x6108

#define S_T6_STATIC_KX_PLL_BYPASS    30
#define V_T6_STATIC_KX_PLL_BYPASS(x) ((x) << S_T6_STATIC_KX_PLL_BYPASS)
#define F_T6_STATIC_KX_PLL_BYPASS    V_T6_STATIC_KX_PLL_BYPASS(1U)

#define S_STATIC_KX_PLL_VBOOSTDIV    27
#define M_STATIC_KX_PLL_VBOOSTDIV    0x7U
#define V_STATIC_KX_PLL_VBOOSTDIV(x) ((x) << S_STATIC_KX_PLL_VBOOSTDIV)
#define G_STATIC_KX_PLL_VBOOSTDIV(x) (((x) >> S_STATIC_KX_PLL_VBOOSTDIV) & M_STATIC_KX_PLL_VBOOSTDIV)

#define S_STATIC_KX_PLL_CPISEL    24
#define M_STATIC_KX_PLL_CPISEL    0x7U
#define V_STATIC_KX_PLL_CPISEL(x) ((x) << S_STATIC_KX_PLL_CPISEL)
#define G_STATIC_KX_PLL_CPISEL(x) (((x) >> S_STATIC_KX_PLL_CPISEL) & M_STATIC_KX_PLL_CPISEL)

#define S_STATIC_KX_PLL_CCALMETHOD    23
#define V_STATIC_KX_PLL_CCALMETHOD(x) ((x) << S_STATIC_KX_PLL_CCALMETHOD)
#define F_STATIC_KX_PLL_CCALMETHOD    V_STATIC_KX_PLL_CCALMETHOD(1U)

#define S_STATIC_KX_PLL_CCALLOAD    22
#define V_STATIC_KX_PLL_CCALLOAD(x) ((x) << S_STATIC_KX_PLL_CCALLOAD)
#define F_STATIC_KX_PLL_CCALLOAD    V_STATIC_KX_PLL_CCALLOAD(1U)

#define S_STATIC_KX_PLL_CCALFMIN    21
#define V_STATIC_KX_PLL_CCALFMIN(x) ((x) << S_STATIC_KX_PLL_CCALFMIN)
#define F_STATIC_KX_PLL_CCALFMIN    V_STATIC_KX_PLL_CCALFMIN(1U)

#define S_STATIC_KX_PLL_CCALFMAX    20
#define V_STATIC_KX_PLL_CCALFMAX(x) ((x) << S_STATIC_KX_PLL_CCALFMAX)
#define F_STATIC_KX_PLL_CCALFMAX    V_STATIC_KX_PLL_CCALFMAX(1U)

#define S_STATIC_KX_PLL_CCALCVHOLD    19
#define V_STATIC_KX_PLL_CCALCVHOLD(x) ((x) << S_STATIC_KX_PLL_CCALCVHOLD)
#define F_STATIC_KX_PLL_CCALCVHOLD    V_STATIC_KX_PLL_CCALCVHOLD(1U)

#define S_STATIC_KX_PLL_CCALBANDSEL    15
#define M_STATIC_KX_PLL_CCALBANDSEL    0xfU
#define V_STATIC_KX_PLL_CCALBANDSEL(x) ((x) << S_STATIC_KX_PLL_CCALBANDSEL)
#define G_STATIC_KX_PLL_CCALBANDSEL(x) (((x) >> S_STATIC_KX_PLL_CCALBANDSEL) & M_STATIC_KX_PLL_CCALBANDSEL)

#define S_STATIC_KX_PLL_BGOFFSET    11
#define M_STATIC_KX_PLL_BGOFFSET    0xfU
#define V_STATIC_KX_PLL_BGOFFSET(x) ((x) << S_STATIC_KX_PLL_BGOFFSET)
#define G_STATIC_KX_PLL_BGOFFSET(x) (((x) >> S_STATIC_KX_PLL_BGOFFSET) & M_STATIC_KX_PLL_BGOFFSET)

#define S_T6_STATIC_KX_PLL_P    8
#define M_T6_STATIC_KX_PLL_P    0x7U
#define V_T6_STATIC_KX_PLL_P(x) ((x) << S_T6_STATIC_KX_PLL_P)
#define G_T6_STATIC_KX_PLL_P(x) (((x) >> S_T6_STATIC_KX_PLL_P) & M_T6_STATIC_KX_PLL_P)

#define S_T6_STATIC_KX_PLL_N2    4
#define M_T6_STATIC_KX_PLL_N2    0xfU
#define V_T6_STATIC_KX_PLL_N2(x) ((x) << S_T6_STATIC_KX_PLL_N2)
#define G_T6_STATIC_KX_PLL_N2(x) (((x) >> S_T6_STATIC_KX_PLL_N2) & M_T6_STATIC_KX_PLL_N2)

#define S_T6_STATIC_KX_PLL_N1    0
#define M_T6_STATIC_KX_PLL_N1    0xfU
#define V_T6_STATIC_KX_PLL_N1(x) ((x) << S_T6_STATIC_KX_PLL_N1)
#define G_T6_STATIC_KX_PLL_N1(x) (((x) >> S_T6_STATIC_KX_PLL_N1) & M_T6_STATIC_KX_PLL_N1)

#define A_DBG_PVT_REG_DRVN 0x610c

#define S_PVT_REG_DRVN_EN    8
#define V_PVT_REG_DRVN_EN(x) ((x) << S_PVT_REG_DRVN_EN)
#define F_PVT_REG_DRVN_EN    V_PVT_REG_DRVN_EN(1U)

#define S_PVT_REG_DRVN_B    4
#define M_PVT_REG_DRVN_B    0xfU
#define V_PVT_REG_DRVN_B(x) ((x) << S_PVT_REG_DRVN_B)
#define G_PVT_REG_DRVN_B(x) (((x) >> S_PVT_REG_DRVN_B) & M_PVT_REG_DRVN_B)

#define S_PVT_REG_DRVN_A    0
#define M_PVT_REG_DRVN_A    0xfU
#define V_PVT_REG_DRVN_A(x) ((x) << S_PVT_REG_DRVN_A)
#define G_PVT_REG_DRVN_A(x) (((x) >> S_PVT_REG_DRVN_A) & M_PVT_REG_DRVN_A)

#define A_DBG_T5_STATIC_KX_PLL_CONF2 0x610c

#define S_T5_STATIC_KX_PLL_M    11
#define M_T5_STATIC_KX_PLL_M    0x1ffU
#define V_T5_STATIC_KX_PLL_M(x) ((x) << S_T5_STATIC_KX_PLL_M)
#define G_T5_STATIC_KX_PLL_M(x) (((x) >> S_T5_STATIC_KX_PLL_M) & M_T5_STATIC_KX_PLL_M)

#define S_T5_STATIC_KX_PLL_ANALOGTUNE    0
#define M_T5_STATIC_KX_PLL_ANALOGTUNE    0x7ffU
#define V_T5_STATIC_KX_PLL_ANALOGTUNE(x) ((x) << S_T5_STATIC_KX_PLL_ANALOGTUNE)
#define G_T5_STATIC_KX_PLL_ANALOGTUNE(x) (((x) >> S_T5_STATIC_KX_PLL_ANALOGTUNE) & M_T5_STATIC_KX_PLL_ANALOGTUNE)

#define A_DBG_STATIC_KX_PLL_CONF2 0x610c

#define S_T6_STATIC_KX_PLL_M    11
#define M_T6_STATIC_KX_PLL_M    0x1ffU
#define V_T6_STATIC_KX_PLL_M(x) ((x) << S_T6_STATIC_KX_PLL_M)
#define G_T6_STATIC_KX_PLL_M(x) (((x) >> S_T6_STATIC_KX_PLL_M) & M_T6_STATIC_KX_PLL_M)

#define S_STATIC_KX_PLL_ANALOGTUNE    0
#define M_STATIC_KX_PLL_ANALOGTUNE    0x7ffU
#define V_STATIC_KX_PLL_ANALOGTUNE(x) ((x) << S_STATIC_KX_PLL_ANALOGTUNE)
#define G_STATIC_KX_PLL_ANALOGTUNE(x) (((x) >> S_STATIC_KX_PLL_ANALOGTUNE) & M_STATIC_KX_PLL_ANALOGTUNE)

#define A_DBG_PVT_REG_DRVP 0x6110

#define S_PVT_REG_DRVP_EN    8
#define V_PVT_REG_DRVP_EN(x) ((x) << S_PVT_REG_DRVP_EN)
#define F_PVT_REG_DRVP_EN    V_PVT_REG_DRVP_EN(1U)

#define S_PVT_REG_DRVP_B    4
#define M_PVT_REG_DRVP_B    0xfU
#define V_PVT_REG_DRVP_B(x) ((x) << S_PVT_REG_DRVP_B)
#define G_PVT_REG_DRVP_B(x) (((x) >> S_PVT_REG_DRVP_B) & M_PVT_REG_DRVP_B)

#define S_PVT_REG_DRVP_A    0
#define M_PVT_REG_DRVP_A    0xfU
#define V_PVT_REG_DRVP_A(x) ((x) << S_PVT_REG_DRVP_A)
#define G_PVT_REG_DRVP_A(x) (((x) >> S_PVT_REG_DRVP_A) & M_PVT_REG_DRVP_A)

#define A_DBG_T5_STATIC_C_DFS_CONF 0x6110

#define S_STATIC_C_DFS_RANGEA    8
#define M_STATIC_C_DFS_RANGEA    0x1fU
#define V_STATIC_C_DFS_RANGEA(x) ((x) << S_STATIC_C_DFS_RANGEA)
#define G_STATIC_C_DFS_RANGEA(x) (((x) >> S_STATIC_C_DFS_RANGEA) & M_STATIC_C_DFS_RANGEA)

#define S_STATIC_C_DFS_RANGEB    3
#define M_STATIC_C_DFS_RANGEB    0x1fU
#define V_STATIC_C_DFS_RANGEB(x) ((x) << S_STATIC_C_DFS_RANGEB)
#define G_STATIC_C_DFS_RANGEB(x) (((x) >> S_STATIC_C_DFS_RANGEB) & M_STATIC_C_DFS_RANGEB)

#define S_STATIC_C_DFS_FFTUNE4    2
#define V_STATIC_C_DFS_FFTUNE4(x) ((x) << S_STATIC_C_DFS_FFTUNE4)
#define F_STATIC_C_DFS_FFTUNE4    V_STATIC_C_DFS_FFTUNE4(1U)

#define S_STATIC_C_DFS_FFTUNE5    1
#define V_STATIC_C_DFS_FFTUNE5(x) ((x) << S_STATIC_C_DFS_FFTUNE5)
#define F_STATIC_C_DFS_FFTUNE5    V_STATIC_C_DFS_FFTUNE5(1U)

#define S_STATIC_C_DFS_ENABLE    0
#define V_STATIC_C_DFS_ENABLE(x) ((x) << S_STATIC_C_DFS_ENABLE)
#define F_STATIC_C_DFS_ENABLE    V_STATIC_C_DFS_ENABLE(1U)

#define A_DBG_STATIC_C_DFS_CONF 0x6110
#define A_DBG_PVT_REG_TERMN 0x6114

#define S_PVT_REG_TERMN_EN    8
#define V_PVT_REG_TERMN_EN(x) ((x) << S_PVT_REG_TERMN_EN)
#define F_PVT_REG_TERMN_EN    V_PVT_REG_TERMN_EN(1U)

#define S_PVT_REG_TERMN_B    4
#define M_PVT_REG_TERMN_B    0xfU
#define V_PVT_REG_TERMN_B(x) ((x) << S_PVT_REG_TERMN_B)
#define G_PVT_REG_TERMN_B(x) (((x) >> S_PVT_REG_TERMN_B) & M_PVT_REG_TERMN_B)

#define S_PVT_REG_TERMN_A    0
#define M_PVT_REG_TERMN_A    0xfU
#define V_PVT_REG_TERMN_A(x) ((x) << S_PVT_REG_TERMN_A)
#define G_PVT_REG_TERMN_A(x) (((x) >> S_PVT_REG_TERMN_A) & M_PVT_REG_TERMN_A)

#define A_DBG_T5_STATIC_U_DFS_CONF 0x6114

#define S_STATIC_U_DFS_RANGEA    8
#define M_STATIC_U_DFS_RANGEA    0x1fU
#define V_STATIC_U_DFS_RANGEA(x) ((x) << S_STATIC_U_DFS_RANGEA)
#define G_STATIC_U_DFS_RANGEA(x) (((x) >> S_STATIC_U_DFS_RANGEA) & M_STATIC_U_DFS_RANGEA)

#define S_STATIC_U_DFS_RANGEB    3
#define M_STATIC_U_DFS_RANGEB    0x1fU
#define V_STATIC_U_DFS_RANGEB(x) ((x) << S_STATIC_U_DFS_RANGEB)
#define G_STATIC_U_DFS_RANGEB(x) (((x) >> S_STATIC_U_DFS_RANGEB) & M_STATIC_U_DFS_RANGEB)

#define S_STATIC_U_DFS_FFTUNE4    2
#define V_STATIC_U_DFS_FFTUNE4(x) ((x) << S_STATIC_U_DFS_FFTUNE4)
#define F_STATIC_U_DFS_FFTUNE4    V_STATIC_U_DFS_FFTUNE4(1U)

#define S_STATIC_U_DFS_FFTUNE5    1
#define V_STATIC_U_DFS_FFTUNE5(x) ((x) << S_STATIC_U_DFS_FFTUNE5)
#define F_STATIC_U_DFS_FFTUNE5    V_STATIC_U_DFS_FFTUNE5(1U)

#define S_STATIC_U_DFS_ENABLE    0
#define V_STATIC_U_DFS_ENABLE(x) ((x) << S_STATIC_U_DFS_ENABLE)
#define F_STATIC_U_DFS_ENABLE    V_STATIC_U_DFS_ENABLE(1U)

#define A_DBG_STATIC_U_DFS_CONF 0x6114
#define A_DBG_PVT_REG_TERMP 0x6118

#define S_PVT_REG_TERMP_EN    8
#define V_PVT_REG_TERMP_EN(x) ((x) << S_PVT_REG_TERMP_EN)
#define F_PVT_REG_TERMP_EN    V_PVT_REG_TERMP_EN(1U)

#define S_PVT_REG_TERMP_B    4
#define M_PVT_REG_TERMP_B    0xfU
#define V_PVT_REG_TERMP_B(x) ((x) << S_PVT_REG_TERMP_B)
#define G_PVT_REG_TERMP_B(x) (((x) >> S_PVT_REG_TERMP_B) & M_PVT_REG_TERMP_B)

#define S_PVT_REG_TERMP_A    0
#define M_PVT_REG_TERMP_A    0xfU
#define V_PVT_REG_TERMP_A(x) ((x) << S_PVT_REG_TERMP_A)
#define G_PVT_REG_TERMP_A(x) (((x) >> S_PVT_REG_TERMP_A) & M_PVT_REG_TERMP_A)

#define A_DBG_GPIO_PE_EN 0x6118

#define S_GPIO19_PE_EN    19
#define V_GPIO19_PE_EN(x) ((x) << S_GPIO19_PE_EN)
#define F_GPIO19_PE_EN    V_GPIO19_PE_EN(1U)

#define S_GPIO18_PE_EN    18
#define V_GPIO18_PE_EN(x) ((x) << S_GPIO18_PE_EN)
#define F_GPIO18_PE_EN    V_GPIO18_PE_EN(1U)

#define S_GPIO17_PE_EN    17
#define V_GPIO17_PE_EN(x) ((x) << S_GPIO17_PE_EN)
#define F_GPIO17_PE_EN    V_GPIO17_PE_EN(1U)

#define S_GPIO16_PE_EN    16
#define V_GPIO16_PE_EN(x) ((x) << S_GPIO16_PE_EN)
#define F_GPIO16_PE_EN    V_GPIO16_PE_EN(1U)

#define S_GPIO15_PE_EN    15
#define V_GPIO15_PE_EN(x) ((x) << S_GPIO15_PE_EN)
#define F_GPIO15_PE_EN    V_GPIO15_PE_EN(1U)

#define S_GPIO14_PE_EN    14
#define V_GPIO14_PE_EN(x) ((x) << S_GPIO14_PE_EN)
#define F_GPIO14_PE_EN    V_GPIO14_PE_EN(1U)

#define S_GPIO13_PE_EN    13
#define V_GPIO13_PE_EN(x) ((x) << S_GPIO13_PE_EN)
#define F_GPIO13_PE_EN    V_GPIO13_PE_EN(1U)

#define S_GPIO12_PE_EN    12
#define V_GPIO12_PE_EN(x) ((x) << S_GPIO12_PE_EN)
#define F_GPIO12_PE_EN    V_GPIO12_PE_EN(1U)

#define S_GPIO11_PE_EN    11
#define V_GPIO11_PE_EN(x) ((x) << S_GPIO11_PE_EN)
#define F_GPIO11_PE_EN    V_GPIO11_PE_EN(1U)

#define S_GPIO10_PE_EN    10
#define V_GPIO10_PE_EN(x) ((x) << S_GPIO10_PE_EN)
#define F_GPIO10_PE_EN    V_GPIO10_PE_EN(1U)

#define S_GPIO9_PE_EN    9
#define V_GPIO9_PE_EN(x) ((x) << S_GPIO9_PE_EN)
#define F_GPIO9_PE_EN    V_GPIO9_PE_EN(1U)

#define S_GPIO8_PE_EN    8
#define V_GPIO8_PE_EN(x) ((x) << S_GPIO8_PE_EN)
#define F_GPIO8_PE_EN    V_GPIO8_PE_EN(1U)

#define S_GPIO7_PE_EN    7
#define V_GPIO7_PE_EN(x) ((x) << S_GPIO7_PE_EN)
#define F_GPIO7_PE_EN    V_GPIO7_PE_EN(1U)

#define S_GPIO6_PE_EN    6
#define V_GPIO6_PE_EN(x) ((x) << S_GPIO6_PE_EN)
#define F_GPIO6_PE_EN    V_GPIO6_PE_EN(1U)

#define S_GPIO5_PE_EN    5
#define V_GPIO5_PE_EN(x) ((x) << S_GPIO5_PE_EN)
#define F_GPIO5_PE_EN    V_GPIO5_PE_EN(1U)

#define S_GPIO4_PE_EN    4
#define V_GPIO4_PE_EN(x) ((x) << S_GPIO4_PE_EN)
#define F_GPIO4_PE_EN    V_GPIO4_PE_EN(1U)

#define S_GPIO3_PE_EN    3
#define V_GPIO3_PE_EN(x) ((x) << S_GPIO3_PE_EN)
#define F_GPIO3_PE_EN    V_GPIO3_PE_EN(1U)

#define S_GPIO2_PE_EN    2
#define V_GPIO2_PE_EN(x) ((x) << S_GPIO2_PE_EN)
#define F_GPIO2_PE_EN    V_GPIO2_PE_EN(1U)

#define S_GPIO1_PE_EN    1
#define V_GPIO1_PE_EN(x) ((x) << S_GPIO1_PE_EN)
#define F_GPIO1_PE_EN    V_GPIO1_PE_EN(1U)

#define S_GPIO0_PE_EN    0
#define V_GPIO0_PE_EN(x) ((x) << S_GPIO0_PE_EN)
#define F_GPIO0_PE_EN    V_GPIO0_PE_EN(1U)

#define S_GPIO23_PE_EN    23
#define V_GPIO23_PE_EN(x) ((x) << S_GPIO23_PE_EN)
#define F_GPIO23_PE_EN    V_GPIO23_PE_EN(1U)

#define S_GPIO22_PE_EN    22
#define V_GPIO22_PE_EN(x) ((x) << S_GPIO22_PE_EN)
#define F_GPIO22_PE_EN    V_GPIO22_PE_EN(1U)

#define S_GPIO21_PE_EN    21
#define V_GPIO21_PE_EN(x) ((x) << S_GPIO21_PE_EN)
#define F_GPIO21_PE_EN    V_GPIO21_PE_EN(1U)

#define S_GPIO20_PE_EN    20
#define V_GPIO20_PE_EN(x) ((x) << S_GPIO20_PE_EN)
#define F_GPIO20_PE_EN    V_GPIO20_PE_EN(1U)

#define S_T7_GPIO19_PE_EN    19
#define V_T7_GPIO19_PE_EN(x) ((x) << S_T7_GPIO19_PE_EN)
#define F_T7_GPIO19_PE_EN    V_T7_GPIO19_PE_EN(1U)

#define S_T7_GPIO18_PE_EN    18
#define V_T7_GPIO18_PE_EN(x) ((x) << S_T7_GPIO18_PE_EN)
#define F_T7_GPIO18_PE_EN    V_T7_GPIO18_PE_EN(1U)

#define S_T7_GPIO17_PE_EN    17
#define V_T7_GPIO17_PE_EN(x) ((x) << S_T7_GPIO17_PE_EN)
#define F_T7_GPIO17_PE_EN    V_T7_GPIO17_PE_EN(1U)

#define S_T7_GPIO16_PE_EN    16
#define V_T7_GPIO16_PE_EN(x) ((x) << S_T7_GPIO16_PE_EN)
#define F_T7_GPIO16_PE_EN    V_T7_GPIO16_PE_EN(1U)

#define A_DBG_PVT_REG_THRESHOLD 0x611c

#define S_PVT_CALIBRATION_DONE    8
#define V_PVT_CALIBRATION_DONE(x) ((x) << S_PVT_CALIBRATION_DONE)
#define F_PVT_CALIBRATION_DONE    V_PVT_CALIBRATION_DONE(1U)

#define S_THRESHOLD_TERMP_MAX_SYNC    7
#define V_THRESHOLD_TERMP_MAX_SYNC(x) ((x) << S_THRESHOLD_TERMP_MAX_SYNC)
#define F_THRESHOLD_TERMP_MAX_SYNC    V_THRESHOLD_TERMP_MAX_SYNC(1U)

#define S_THRESHOLD_TERMP_MIN_SYNC    6
#define V_THRESHOLD_TERMP_MIN_SYNC(x) ((x) << S_THRESHOLD_TERMP_MIN_SYNC)
#define F_THRESHOLD_TERMP_MIN_SYNC    V_THRESHOLD_TERMP_MIN_SYNC(1U)

#define S_THRESHOLD_TERMN_MAX_SYNC    5
#define V_THRESHOLD_TERMN_MAX_SYNC(x) ((x) << S_THRESHOLD_TERMN_MAX_SYNC)
#define F_THRESHOLD_TERMN_MAX_SYNC    V_THRESHOLD_TERMN_MAX_SYNC(1U)

#define S_THRESHOLD_TERMN_MIN_SYNC    4
#define V_THRESHOLD_TERMN_MIN_SYNC(x) ((x) << S_THRESHOLD_TERMN_MIN_SYNC)
#define F_THRESHOLD_TERMN_MIN_SYNC    V_THRESHOLD_TERMN_MIN_SYNC(1U)

#define S_THRESHOLD_DRVP_MAX_SYNC    3
#define V_THRESHOLD_DRVP_MAX_SYNC(x) ((x) << S_THRESHOLD_DRVP_MAX_SYNC)
#define F_THRESHOLD_DRVP_MAX_SYNC    V_THRESHOLD_DRVP_MAX_SYNC(1U)

#define S_THRESHOLD_DRVP_MIN_SYNC    2
#define V_THRESHOLD_DRVP_MIN_SYNC(x) ((x) << S_THRESHOLD_DRVP_MIN_SYNC)
#define F_THRESHOLD_DRVP_MIN_SYNC    V_THRESHOLD_DRVP_MIN_SYNC(1U)

#define S_THRESHOLD_DRVN_MAX_SYNC    1
#define V_THRESHOLD_DRVN_MAX_SYNC(x) ((x) << S_THRESHOLD_DRVN_MAX_SYNC)
#define F_THRESHOLD_DRVN_MAX_SYNC    V_THRESHOLD_DRVN_MAX_SYNC(1U)

#define S_THRESHOLD_DRVN_MIN_SYNC    0
#define V_THRESHOLD_DRVN_MIN_SYNC(x) ((x) << S_THRESHOLD_DRVN_MIN_SYNC)
#define F_THRESHOLD_DRVN_MIN_SYNC    V_THRESHOLD_DRVN_MIN_SYNC(1U)

#define A_DBG_GPIO_PS_EN 0x611c

#define S_GPIO19_PS_EN    19
#define V_GPIO19_PS_EN(x) ((x) << S_GPIO19_PS_EN)
#define F_GPIO19_PS_EN    V_GPIO19_PS_EN(1U)

#define S_GPIO18_PS_EN    18
#define V_GPIO18_PS_EN(x) ((x) << S_GPIO18_PS_EN)
#define F_GPIO18_PS_EN    V_GPIO18_PS_EN(1U)

#define S_GPIO17_PS_EN    17
#define V_GPIO17_PS_EN(x) ((x) << S_GPIO17_PS_EN)
#define F_GPIO17_PS_EN    V_GPIO17_PS_EN(1U)

#define S_GPIO16_PS_EN    16
#define V_GPIO16_PS_EN(x) ((x) << S_GPIO16_PS_EN)
#define F_GPIO16_PS_EN    V_GPIO16_PS_EN(1U)

#define S_GPIO15_PS_EN    15
#define V_GPIO15_PS_EN(x) ((x) << S_GPIO15_PS_EN)
#define F_GPIO15_PS_EN    V_GPIO15_PS_EN(1U)

#define S_GPIO14_PS_EN    14
#define V_GPIO14_PS_EN(x) ((x) << S_GPIO14_PS_EN)
#define F_GPIO14_PS_EN    V_GPIO14_PS_EN(1U)

#define S_GPIO13_PS_EN    13
#define V_GPIO13_PS_EN(x) ((x) << S_GPIO13_PS_EN)
#define F_GPIO13_PS_EN    V_GPIO13_PS_EN(1U)

#define S_GPIO12_PS_EN    12
#define V_GPIO12_PS_EN(x) ((x) << S_GPIO12_PS_EN)
#define F_GPIO12_PS_EN    V_GPIO12_PS_EN(1U)

#define S_GPIO11_PS_EN    11
#define V_GPIO11_PS_EN(x) ((x) << S_GPIO11_PS_EN)
#define F_GPIO11_PS_EN    V_GPIO11_PS_EN(1U)

#define S_GPIO10_PS_EN    10
#define V_GPIO10_PS_EN(x) ((x) << S_GPIO10_PS_EN)
#define F_GPIO10_PS_EN    V_GPIO10_PS_EN(1U)

#define S_GPIO9_PS_EN    9
#define V_GPIO9_PS_EN(x) ((x) << S_GPIO9_PS_EN)
#define F_GPIO9_PS_EN    V_GPIO9_PS_EN(1U)

#define S_GPIO8_PS_EN    8
#define V_GPIO8_PS_EN(x) ((x) << S_GPIO8_PS_EN)
#define F_GPIO8_PS_EN    V_GPIO8_PS_EN(1U)

#define S_GPIO7_PS_EN    7
#define V_GPIO7_PS_EN(x) ((x) << S_GPIO7_PS_EN)
#define F_GPIO7_PS_EN    V_GPIO7_PS_EN(1U)

#define S_GPIO6_PS_EN    6
#define V_GPIO6_PS_EN(x) ((x) << S_GPIO6_PS_EN)
#define F_GPIO6_PS_EN    V_GPIO6_PS_EN(1U)

#define S_GPIO5_PS_EN    5
#define V_GPIO5_PS_EN(x) ((x) << S_GPIO5_PS_EN)
#define F_GPIO5_PS_EN    V_GPIO5_PS_EN(1U)

#define S_GPIO4_PS_EN    4
#define V_GPIO4_PS_EN(x) ((x) << S_GPIO4_PS_EN)
#define F_GPIO4_PS_EN    V_GPIO4_PS_EN(1U)

#define S_GPIO3_PS_EN    3
#define V_GPIO3_PS_EN(x) ((x) << S_GPIO3_PS_EN)
#define F_GPIO3_PS_EN    V_GPIO3_PS_EN(1U)

#define S_GPIO2_PS_EN    2
#define V_GPIO2_PS_EN(x) ((x) << S_GPIO2_PS_EN)
#define F_GPIO2_PS_EN    V_GPIO2_PS_EN(1U)

#define S_GPIO1_PS_EN    1
#define V_GPIO1_PS_EN(x) ((x) << S_GPIO1_PS_EN)
#define F_GPIO1_PS_EN    V_GPIO1_PS_EN(1U)

#define S_GPIO0_PS_EN    0
#define V_GPIO0_PS_EN(x) ((x) << S_GPIO0_PS_EN)
#define F_GPIO0_PS_EN    V_GPIO0_PS_EN(1U)

#define S_GPIO23_PS_EN    23
#define V_GPIO23_PS_EN(x) ((x) << S_GPIO23_PS_EN)
#define F_GPIO23_PS_EN    V_GPIO23_PS_EN(1U)

#define S_GPIO22_PS_EN    22
#define V_GPIO22_PS_EN(x) ((x) << S_GPIO22_PS_EN)
#define F_GPIO22_PS_EN    V_GPIO22_PS_EN(1U)

#define S_GPIO21_PS_EN    21
#define V_GPIO21_PS_EN(x) ((x) << S_GPIO21_PS_EN)
#define F_GPIO21_PS_EN    V_GPIO21_PS_EN(1U)

#define S_GPIO20_PS_EN    20
#define V_GPIO20_PS_EN(x) ((x) << S_GPIO20_PS_EN)
#define F_GPIO20_PS_EN    V_GPIO20_PS_EN(1U)

#define S_T7_GPIO19_PS_EN    19
#define V_T7_GPIO19_PS_EN(x) ((x) << S_T7_GPIO19_PS_EN)
#define F_T7_GPIO19_PS_EN    V_T7_GPIO19_PS_EN(1U)

#define S_T7_GPIO18_PS_EN    18
#define V_T7_GPIO18_PS_EN(x) ((x) << S_T7_GPIO18_PS_EN)
#define F_T7_GPIO18_PS_EN    V_T7_GPIO18_PS_EN(1U)

#define S_T7_GPIO17_PS_EN    17
#define V_T7_GPIO17_PS_EN(x) ((x) << S_T7_GPIO17_PS_EN)
#define F_T7_GPIO17_PS_EN    V_T7_GPIO17_PS_EN(1U)

#define S_T7_GPIO16_PS_EN    16
#define V_T7_GPIO16_PS_EN(x) ((x) << S_T7_GPIO16_PS_EN)
#define F_T7_GPIO16_PS_EN    V_T7_GPIO16_PS_EN(1U)

#define A_DBG_PVT_REG_IN_TERMP 0x6120

#define S_REG_IN_TERMP_B    4
#define M_REG_IN_TERMP_B    0xfU
#define V_REG_IN_TERMP_B(x) ((x) << S_REG_IN_TERMP_B)
#define G_REG_IN_TERMP_B(x) (((x) >> S_REG_IN_TERMP_B) & M_REG_IN_TERMP_B)

#define S_REG_IN_TERMP_A    0
#define M_REG_IN_TERMP_A    0xfU
#define V_REG_IN_TERMP_A(x) ((x) << S_REG_IN_TERMP_A)
#define G_REG_IN_TERMP_A(x) (((x) >> S_REG_IN_TERMP_A) & M_REG_IN_TERMP_A)

#define A_DBG_EFUSE_BYTE16_19 0x6120
#define A_DBG_PVT_REG_IN_TERMN 0x6124

#define S_REG_IN_TERMN_B    4
#define M_REG_IN_TERMN_B    0xfU
#define V_REG_IN_TERMN_B(x) ((x) << S_REG_IN_TERMN_B)
#define G_REG_IN_TERMN_B(x) (((x) >> S_REG_IN_TERMN_B) & M_REG_IN_TERMN_B)

#define S_REG_IN_TERMN_A    0
#define M_REG_IN_TERMN_A    0xfU
#define V_REG_IN_TERMN_A(x) ((x) << S_REG_IN_TERMN_A)
#define G_REG_IN_TERMN_A(x) (((x) >> S_REG_IN_TERMN_A) & M_REG_IN_TERMN_A)

#define A_DBG_EFUSE_BYTE20_23 0x6124
#define A_DBG_PVT_REG_IN_DRVP 0x6128

#define S_REG_IN_DRVP_B    4
#define M_REG_IN_DRVP_B    0xfU
#define V_REG_IN_DRVP_B(x) ((x) << S_REG_IN_DRVP_B)
#define G_REG_IN_DRVP_B(x) (((x) >> S_REG_IN_DRVP_B) & M_REG_IN_DRVP_B)

#define S_REG_IN_DRVP_A    0
#define M_REG_IN_DRVP_A    0xfU
#define V_REG_IN_DRVP_A(x) ((x) << S_REG_IN_DRVP_A)
#define G_REG_IN_DRVP_A(x) (((x) >> S_REG_IN_DRVP_A) & M_REG_IN_DRVP_A)

#define A_DBG_EFUSE_BYTE24_27 0x6128
#define A_DBG_PVT_REG_IN_DRVN 0x612c

#define S_REG_IN_DRVN_B    4
#define M_REG_IN_DRVN_B    0xfU
#define V_REG_IN_DRVN_B(x) ((x) << S_REG_IN_DRVN_B)
#define G_REG_IN_DRVN_B(x) (((x) >> S_REG_IN_DRVN_B) & M_REG_IN_DRVN_B)

#define S_REG_IN_DRVN_A    0
#define M_REG_IN_DRVN_A    0xfU
#define V_REG_IN_DRVN_A(x) ((x) << S_REG_IN_DRVN_A)
#define G_REG_IN_DRVN_A(x) (((x) >> S_REG_IN_DRVN_A) & M_REG_IN_DRVN_A)

#define A_DBG_EFUSE_BYTE28_31 0x612c
#define A_DBG_PVT_REG_OUT_TERMP 0x6130

#define S_REG_OUT_TERMP_B    4
#define M_REG_OUT_TERMP_B    0xfU
#define V_REG_OUT_TERMP_B(x) ((x) << S_REG_OUT_TERMP_B)
#define G_REG_OUT_TERMP_B(x) (((x) >> S_REG_OUT_TERMP_B) & M_REG_OUT_TERMP_B)

#define S_REG_OUT_TERMP_A    0
#define M_REG_OUT_TERMP_A    0xfU
#define V_REG_OUT_TERMP_A(x) ((x) << S_REG_OUT_TERMP_A)
#define G_REG_OUT_TERMP_A(x) (((x) >> S_REG_OUT_TERMP_A) & M_REG_OUT_TERMP_A)

#define A_DBG_EFUSE_BYTE32_35 0x6130
#define A_DBG_PVT_REG_OUT_TERMN 0x6134

#define S_REG_OUT_TERMN_B    4
#define M_REG_OUT_TERMN_B    0xfU
#define V_REG_OUT_TERMN_B(x) ((x) << S_REG_OUT_TERMN_B)
#define G_REG_OUT_TERMN_B(x) (((x) >> S_REG_OUT_TERMN_B) & M_REG_OUT_TERMN_B)

#define S_REG_OUT_TERMN_A    0
#define M_REG_OUT_TERMN_A    0xfU
#define V_REG_OUT_TERMN_A(x) ((x) << S_REG_OUT_TERMN_A)
#define G_REG_OUT_TERMN_A(x) (((x) >> S_REG_OUT_TERMN_A) & M_REG_OUT_TERMN_A)

#define A_DBG_EFUSE_BYTE36_39 0x6134
#define A_DBG_PVT_REG_OUT_DRVP 0x6138

#define S_REG_OUT_DRVP_B    4
#define M_REG_OUT_DRVP_B    0xfU
#define V_REG_OUT_DRVP_B(x) ((x) << S_REG_OUT_DRVP_B)
#define G_REG_OUT_DRVP_B(x) (((x) >> S_REG_OUT_DRVP_B) & M_REG_OUT_DRVP_B)

#define S_REG_OUT_DRVP_A    0
#define M_REG_OUT_DRVP_A    0xfU
#define V_REG_OUT_DRVP_A(x) ((x) << S_REG_OUT_DRVP_A)
#define G_REG_OUT_DRVP_A(x) (((x) >> S_REG_OUT_DRVP_A) & M_REG_OUT_DRVP_A)

#define A_DBG_EFUSE_BYTE40_43 0x6138
#define A_DBG_PVT_REG_OUT_DRVN 0x613c

#define S_REG_OUT_DRVN_B    4
#define M_REG_OUT_DRVN_B    0xfU
#define V_REG_OUT_DRVN_B(x) ((x) << S_REG_OUT_DRVN_B)
#define G_REG_OUT_DRVN_B(x) (((x) >> S_REG_OUT_DRVN_B) & M_REG_OUT_DRVN_B)

#define S_REG_OUT_DRVN_A    0
#define M_REG_OUT_DRVN_A    0xfU
#define V_REG_OUT_DRVN_A(x) ((x) << S_REG_OUT_DRVN_A)
#define G_REG_OUT_DRVN_A(x) (((x) >> S_REG_OUT_DRVN_A) & M_REG_OUT_DRVN_A)

#define A_DBG_EFUSE_BYTE44_47 0x613c
#define A_DBG_PVT_REG_HISTORY_TERMP 0x6140

#define S_TERMP_B_HISTORY    4
#define M_TERMP_B_HISTORY    0xfU
#define V_TERMP_B_HISTORY(x) ((x) << S_TERMP_B_HISTORY)
#define G_TERMP_B_HISTORY(x) (((x) >> S_TERMP_B_HISTORY) & M_TERMP_B_HISTORY)

#define S_TERMP_A_HISTORY    0
#define M_TERMP_A_HISTORY    0xfU
#define V_TERMP_A_HISTORY(x) ((x) << S_TERMP_A_HISTORY)
#define G_TERMP_A_HISTORY(x) (((x) >> S_TERMP_A_HISTORY) & M_TERMP_A_HISTORY)

#define A_DBG_EFUSE_BYTE48_51 0x6140
#define A_DBG_PVT_REG_HISTORY_TERMN 0x6144

#define S_TERMN_B_HISTORY    4
#define M_TERMN_B_HISTORY    0xfU
#define V_TERMN_B_HISTORY(x) ((x) << S_TERMN_B_HISTORY)
#define G_TERMN_B_HISTORY(x) (((x) >> S_TERMN_B_HISTORY) & M_TERMN_B_HISTORY)

#define S_TERMN_A_HISTORY    0
#define M_TERMN_A_HISTORY    0xfU
#define V_TERMN_A_HISTORY(x) ((x) << S_TERMN_A_HISTORY)
#define G_TERMN_A_HISTORY(x) (((x) >> S_TERMN_A_HISTORY) & M_TERMN_A_HISTORY)

#define A_DBG_EFUSE_BYTE52_55 0x6144
#define A_DBG_PVT_REG_HISTORY_DRVP 0x6148

#define S_DRVP_B_HISTORY    4
#define M_DRVP_B_HISTORY    0xfU
#define V_DRVP_B_HISTORY(x) ((x) << S_DRVP_B_HISTORY)
#define G_DRVP_B_HISTORY(x) (((x) >> S_DRVP_B_HISTORY) & M_DRVP_B_HISTORY)

#define S_DRVP_A_HISTORY    0
#define M_DRVP_A_HISTORY    0xfU
#define V_DRVP_A_HISTORY(x) ((x) << S_DRVP_A_HISTORY)
#define G_DRVP_A_HISTORY(x) (((x) >> S_DRVP_A_HISTORY) & M_DRVP_A_HISTORY)

#define A_DBG_EFUSE_BYTE56_59 0x6148
#define A_DBG_PVT_REG_HISTORY_DRVN 0x614c

#define S_DRVN_B_HISTORY    4
#define M_DRVN_B_HISTORY    0xfU
#define V_DRVN_B_HISTORY(x) ((x) << S_DRVN_B_HISTORY)
#define G_DRVN_B_HISTORY(x) (((x) >> S_DRVN_B_HISTORY) & M_DRVN_B_HISTORY)

#define S_DRVN_A_HISTORY    0
#define M_DRVN_A_HISTORY    0xfU
#define V_DRVN_A_HISTORY(x) ((x) << S_DRVN_A_HISTORY)
#define G_DRVN_A_HISTORY(x) (((x) >> S_DRVN_A_HISTORY) & M_DRVN_A_HISTORY)

#define A_DBG_EFUSE_BYTE60_63 0x614c
#define A_DBG_PVT_REG_SAMPLE_WAIT_CLKS 0x6150

#define S_SAMPLE_WAIT_CLKS    0
#define M_SAMPLE_WAIT_CLKS    0x1fU
#define V_SAMPLE_WAIT_CLKS(x) ((x) << S_SAMPLE_WAIT_CLKS)
#define G_SAMPLE_WAIT_CLKS(x) (((x) >> S_SAMPLE_WAIT_CLKS) & M_SAMPLE_WAIT_CLKS)

#define A_DBG_STATIC_U_PLL_CONF6 0x6150

#define S_STATIC_U_PLL_VREGTUNE    0
#define M_STATIC_U_PLL_VREGTUNE    0x7ffffU
#define V_STATIC_U_PLL_VREGTUNE(x) ((x) << S_STATIC_U_PLL_VREGTUNE)
#define G_STATIC_U_PLL_VREGTUNE(x) (((x) >> S_STATIC_U_PLL_VREGTUNE) & M_STATIC_U_PLL_VREGTUNE)

#define A_DBG_STATIC_PLL_LOCK_WAIT_CONF 0x6150

#define S_STATIC_WAIT_LOCK    24
#define V_STATIC_WAIT_LOCK(x) ((x) << S_STATIC_WAIT_LOCK)
#define F_STATIC_WAIT_LOCK    V_STATIC_WAIT_LOCK(1U)

#define S_STATIC_LOCK_WAIT_TIME    0
#define M_STATIC_LOCK_WAIT_TIME    0xffffffU
#define V_STATIC_LOCK_WAIT_TIME(x) ((x) << S_STATIC_LOCK_WAIT_TIME)
#define G_STATIC_LOCK_WAIT_TIME(x) (((x) >> S_STATIC_LOCK_WAIT_TIME) & M_STATIC_LOCK_WAIT_TIME)

#define A_DBG_STATIC_C_PLL_CONF6 0x6154

#define S_STATIC_C_PLL_VREGTUNE    0
#define M_STATIC_C_PLL_VREGTUNE    0x7ffffU
#define V_STATIC_C_PLL_VREGTUNE(x) ((x) << S_STATIC_C_PLL_VREGTUNE)
#define G_STATIC_C_PLL_VREGTUNE(x) (((x) >> S_STATIC_C_PLL_VREGTUNE) & M_STATIC_C_PLL_VREGTUNE)

#define A_DBG_CUST_EFUSE_PROGRAM 0x6158

#define S_EFUSE_PROG_PERIOD    16
#define M_EFUSE_PROG_PERIOD    0xffffU
#define V_EFUSE_PROG_PERIOD(x) ((x) << S_EFUSE_PROG_PERIOD)
#define G_EFUSE_PROG_PERIOD(x) (((x) >> S_EFUSE_PROG_PERIOD) & M_EFUSE_PROG_PERIOD)

#define S_EFUSE_OPER_TYP    14
#define M_EFUSE_OPER_TYP    0x3U
#define V_EFUSE_OPER_TYP(x) ((x) << S_EFUSE_OPER_TYP)
#define G_EFUSE_OPER_TYP(x) (((x) >> S_EFUSE_OPER_TYP) & M_EFUSE_OPER_TYP)

#define S_EFUSE_ADDR    8
#define M_EFUSE_ADDR    0x3fU
#define V_EFUSE_ADDR(x) ((x) << S_EFUSE_ADDR)
#define G_EFUSE_ADDR(x) (((x) >> S_EFUSE_ADDR) & M_EFUSE_ADDR)

#define S_EFUSE_DIN    0
#define M_EFUSE_DIN    0xffU
#define V_EFUSE_DIN(x) ((x) << S_EFUSE_DIN)
#define G_EFUSE_DIN(x) (((x) >> S_EFUSE_DIN) & M_EFUSE_DIN)

#define A_DBG_CUST_EFUSE_OUT 0x615c

#define S_EFUSE_OPER_DONE    8
#define V_EFUSE_OPER_DONE(x) ((x) << S_EFUSE_OPER_DONE)
#define F_EFUSE_OPER_DONE    V_EFUSE_OPER_DONE(1U)

#define S_EFUSE_DOUT    0
#define M_EFUSE_DOUT    0xffU
#define V_EFUSE_DOUT(x) ((x) << S_EFUSE_DOUT)
#define G_EFUSE_DOUT(x) (((x) >> S_EFUSE_DOUT) & M_EFUSE_DOUT)

#define A_DBG_CUST_EFUSE_BYTE0_3 0x6160
#define A_DBG_CUST_EFUSE_BYTE4_7 0x6164
#define A_DBG_CUST_EFUSE_BYTE8_11 0x6168
#define A_DBG_CUST_EFUSE_BYTE12_15 0x616c
#define A_DBG_CUST_EFUSE_BYTE16_19 0x6170
#define A_DBG_CUST_EFUSE_BYTE20_23 0x6174
#define A_DBG_CUST_EFUSE_BYTE24_27 0x6178
#define A_DBG_CUST_EFUSE_BYTE28_31 0x617c
#define A_DBG_CUST_EFUSE_BYTE32_35 0x6180
#define A_DBG_GPIO_INT_ENABLE 0x6180

#define S_GPIO23    23
#define V_GPIO23(x) ((x) << S_GPIO23)
#define F_GPIO23    V_GPIO23(1U)

#define S_GPIO22    22
#define V_GPIO22(x) ((x) << S_GPIO22)
#define F_GPIO22    V_GPIO22(1U)

#define S_GPIO21    21
#define V_GPIO21(x) ((x) << S_GPIO21)
#define F_GPIO21    V_GPIO21(1U)

#define S_GPIO20    20
#define V_GPIO20(x) ((x) << S_GPIO20)
#define F_GPIO20    V_GPIO20(1U)

#define S_T7_GPIO19    19
#define V_T7_GPIO19(x) ((x) << S_T7_GPIO19)
#define F_T7_GPIO19    V_T7_GPIO19(1U)

#define S_T7_GPIO18    18
#define V_T7_GPIO18(x) ((x) << S_T7_GPIO18)
#define F_T7_GPIO18    V_T7_GPIO18(1U)

#define S_T7_GPIO17    17
#define V_T7_GPIO17(x) ((x) << S_T7_GPIO17)
#define F_T7_GPIO17    V_T7_GPIO17(1U)

#define S_T7_GPIO16    16
#define V_T7_GPIO16(x) ((x) << S_T7_GPIO16)
#define F_T7_GPIO16    V_T7_GPIO16(1U)

#define A_DBG_CUST_EFUSE_BYTE36_39 0x6184
#define A_DBG_GPIO_INT_CAUSE 0x6184
#define A_DBG_CUST_EFUSE_BYTE40_43 0x6188
#define A_T7_DBG_GPIO_ACT_LOW 0x6188

#define S_GPIO23_ACT_LOW    23
#define V_GPIO23_ACT_LOW(x) ((x) << S_GPIO23_ACT_LOW)
#define F_GPIO23_ACT_LOW    V_GPIO23_ACT_LOW(1U)

#define S_GPIO22_ACT_LOW    22
#define V_GPIO22_ACT_LOW(x) ((x) << S_GPIO22_ACT_LOW)
#define F_GPIO22_ACT_LOW    V_GPIO22_ACT_LOW(1U)

#define S_GPIO21_ACT_LOW    21
#define V_GPIO21_ACT_LOW(x) ((x) << S_GPIO21_ACT_LOW)
#define F_GPIO21_ACT_LOW    V_GPIO21_ACT_LOW(1U)

#define S_GPIO20_ACT_LOW    20
#define V_GPIO20_ACT_LOW(x) ((x) << S_GPIO20_ACT_LOW)
#define F_GPIO20_ACT_LOW    V_GPIO20_ACT_LOW(1U)

#define S_T7_GPIO19_ACT_LOW    19
#define V_T7_GPIO19_ACT_LOW(x) ((x) << S_T7_GPIO19_ACT_LOW)
#define F_T7_GPIO19_ACT_LOW    V_T7_GPIO19_ACT_LOW(1U)

#define S_T7_GPIO18_ACT_LOW    18
#define V_T7_GPIO18_ACT_LOW(x) ((x) << S_T7_GPIO18_ACT_LOW)
#define F_T7_GPIO18_ACT_LOW    V_T7_GPIO18_ACT_LOW(1U)

#define S_T7_GPIO17_ACT_LOW    17
#define V_T7_GPIO17_ACT_LOW(x) ((x) << S_T7_GPIO17_ACT_LOW)
#define F_T7_GPIO17_ACT_LOW    V_T7_GPIO17_ACT_LOW(1U)

#define S_T7_GPIO16_ACT_LOW    16
#define V_T7_GPIO16_ACT_LOW(x) ((x) << S_T7_GPIO16_ACT_LOW)
#define F_T7_GPIO16_ACT_LOW    V_T7_GPIO16_ACT_LOW(1U)

#define A_DBG_CUST_EFUSE_BYTE44_47 0x618c
#define A_DBG_DDR_CAL 0x618c

#define S_CAL_ENDC    9
#define V_CAL_ENDC(x) ((x) << S_CAL_ENDC)
#define F_CAL_ENDC    V_CAL_ENDC(1U)

#define S_CAL_MODE    8
#define V_CAL_MODE(x) ((x) << S_CAL_MODE)
#define F_CAL_MODE    V_CAL_MODE(1U)

#define S_CAL_REFSEL    7
#define V_CAL_REFSEL(x) ((x) << S_CAL_REFSEL)
#define F_CAL_REFSEL    V_CAL_REFSEL(1U)

#define S_PD    6
#define V_PD(x) ((x) << S_PD)
#define F_PD    V_PD(1U)

#define S_CAL_RST    5
#define V_CAL_RST(x) ((x) << S_CAL_RST)
#define F_CAL_RST    V_CAL_RST(1U)

#define S_CAL_READ    4
#define V_CAL_READ(x) ((x) << S_CAL_READ)
#define F_CAL_READ    V_CAL_READ(1U)

#define S_CAL_SC    3
#define V_CAL_SC(x) ((x) << S_CAL_SC)
#define F_CAL_SC    V_CAL_SC(1U)

#define S_CAL_LC    2
#define V_CAL_LC(x) ((x) << S_CAL_LC)
#define F_CAL_LC    V_CAL_LC(1U)

#define S_CAL_CCAL    1
#define V_CAL_CCAL(x) ((x) << S_CAL_CCAL)
#define F_CAL_CCAL    V_CAL_CCAL(1U)

#define S_CAL_RES    0
#define V_CAL_RES(x) ((x) << S_CAL_RES)
#define F_CAL_RES    V_CAL_RES(1U)

#define A_DBG_CUST_EFUSE_BYTE48_51 0x6190
#define A_DBG_EFUSE_CTL_0 0x6190

#define S_EFUSE_CSB    31
#define V_EFUSE_CSB(x) ((x) << S_EFUSE_CSB)
#define F_EFUSE_CSB    V_EFUSE_CSB(1U)

#define S_EFUSE_STROBE    30
#define V_EFUSE_STROBE(x) ((x) << S_EFUSE_STROBE)
#define F_EFUSE_STROBE    V_EFUSE_STROBE(1U)

#define S_EFUSE_LOAD    29
#define V_EFUSE_LOAD(x) ((x) << S_EFUSE_LOAD)
#define F_EFUSE_LOAD    V_EFUSE_LOAD(1U)

#define S_EFUSE_PGENB    28
#define V_EFUSE_PGENB(x) ((x) << S_EFUSE_PGENB)
#define F_EFUSE_PGENB    V_EFUSE_PGENB(1U)

#define S_EFUSE_PS    27
#define V_EFUSE_PS(x) ((x) << S_EFUSE_PS)
#define F_EFUSE_PS    V_EFUSE_PS(1U)

#define S_EFUSE_MR    26
#define V_EFUSE_MR(x) ((x) << S_EFUSE_MR)
#define F_EFUSE_MR    V_EFUSE_MR(1U)

#define S_EFUSE_PD    25
#define V_EFUSE_PD(x) ((x) << S_EFUSE_PD)
#define F_EFUSE_PD    V_EFUSE_PD(1U)

#define S_EFUSE_RWL    24
#define V_EFUSE_RWL(x) ((x) << S_EFUSE_RWL)
#define F_EFUSE_RWL    V_EFUSE_RWL(1U)

#define S_EFUSE_RSB    23
#define V_EFUSE_RSB(x) ((x) << S_EFUSE_RSB)
#define F_EFUSE_RSB    V_EFUSE_RSB(1U)

#define S_EFUSE_TRCS    22
#define V_EFUSE_TRCS(x) ((x) << S_EFUSE_TRCS)
#define F_EFUSE_TRCS    V_EFUSE_TRCS(1U)

#define S_EFUSE_AT    20
#define M_EFUSE_AT    0x3U
#define V_EFUSE_AT(x) ((x) << S_EFUSE_AT)
#define G_EFUSE_AT(x) (((x) >> S_EFUSE_AT) & M_EFUSE_AT)

#define S_EFUSE_RD_STATE    16
#define M_EFUSE_RD_STATE    0xfU
#define V_EFUSE_RD_STATE(x) ((x) << S_EFUSE_RD_STATE)
#define G_EFUSE_RD_STATE(x) (((x) >> S_EFUSE_RD_STATE) & M_EFUSE_RD_STATE)

#define S_EFUSE_BUSY    15
#define V_EFUSE_BUSY(x) ((x) << S_EFUSE_BUSY)
#define F_EFUSE_BUSY    V_EFUSE_BUSY(1U)

#define S_EFUSE_WR_RD    13
#define M_EFUSE_WR_RD    0x3U
#define V_EFUSE_WR_RD(x) ((x) << S_EFUSE_WR_RD)
#define G_EFUSE_WR_RD(x) (((x) >> S_EFUSE_WR_RD) & M_EFUSE_WR_RD)

#define S_EFUSE_A    0
#define M_EFUSE_A    0x7ffU
#define V_EFUSE_A(x) ((x) << S_EFUSE_A)
#define G_EFUSE_A(x) (((x) >> S_EFUSE_A) & M_EFUSE_A)

#define A_DBG_CUST_EFUSE_BYTE52_55 0x6194
#define A_DBG_EFUSE_CTL_1 0x6194
#define A_DBG_CUST_EFUSE_BYTE56_59 0x6198
#define A_DBG_EFUSE_RD_CTL 0x6198

#define S_EFUSE_RD_ID    6
#define M_EFUSE_RD_ID    0x3U
#define V_EFUSE_RD_ID(x) ((x) << S_EFUSE_RD_ID)
#define G_EFUSE_RD_ID(x) (((x) >> S_EFUSE_RD_ID) & M_EFUSE_RD_ID)

#define S_EFUSE_RD_ADDR    0
#define M_EFUSE_RD_ADDR    0x3fU
#define V_EFUSE_RD_ADDR(x) ((x) << S_EFUSE_RD_ADDR)
#define G_EFUSE_RD_ADDR(x) (((x) >> S_EFUSE_RD_ADDR) & M_EFUSE_RD_ADDR)

#define A_DBG_CUST_EFUSE_BYTE60_63 0x619c
#define A_DBG_EFUSE_RD_DATA 0x619c
#define A_DBG_EFUSE_TIME_0 0x61a0

#define S_EFUSE_TIME_1    16
#define M_EFUSE_TIME_1    0xffffU
#define V_EFUSE_TIME_1(x) ((x) << S_EFUSE_TIME_1)
#define G_EFUSE_TIME_1(x) (((x) >> S_EFUSE_TIME_1) & M_EFUSE_TIME_1)

#define S_EFUSE_TIME_0    0
#define M_EFUSE_TIME_0    0xffffU
#define V_EFUSE_TIME_0(x) ((x) << S_EFUSE_TIME_0)
#define G_EFUSE_TIME_0(x) (((x) >> S_EFUSE_TIME_0) & M_EFUSE_TIME_0)

#define A_DBG_EFUSE_TIME_1 0x61a4

#define S_EFUSE_TIME_3    16
#define M_EFUSE_TIME_3    0xffffU
#define V_EFUSE_TIME_3(x) ((x) << S_EFUSE_TIME_3)
#define G_EFUSE_TIME_3(x) (((x) >> S_EFUSE_TIME_3) & M_EFUSE_TIME_3)

#define S_EFUSE_TIME_2    0
#define M_EFUSE_TIME_2    0xffffU
#define V_EFUSE_TIME_2(x) ((x) << S_EFUSE_TIME_2)
#define G_EFUSE_TIME_2(x) (((x) >> S_EFUSE_TIME_2) & M_EFUSE_TIME_2)

#define A_DBG_EFUSE_TIME_2 0x61a8

#define S_EFUSE_TIME_5    16
#define M_EFUSE_TIME_5    0xffffU
#define V_EFUSE_TIME_5(x) ((x) << S_EFUSE_TIME_5)
#define G_EFUSE_TIME_5(x) (((x) >> S_EFUSE_TIME_5) & M_EFUSE_TIME_5)

#define S_EFUSE_TIME_4    0
#define M_EFUSE_TIME_4    0xffffU
#define V_EFUSE_TIME_4(x) ((x) << S_EFUSE_TIME_4)
#define G_EFUSE_TIME_4(x) (((x) >> S_EFUSE_TIME_4) & M_EFUSE_TIME_4)

#define A_DBG_EFUSE_TIME_3 0x61ac

#define S_EFUSE_TIME_7    16
#define M_EFUSE_TIME_7    0xffffU
#define V_EFUSE_TIME_7(x) ((x) << S_EFUSE_TIME_7)
#define G_EFUSE_TIME_7(x) (((x) >> S_EFUSE_TIME_7) & M_EFUSE_TIME_7)

#define S_EFUSE_TIME_6    0
#define M_EFUSE_TIME_6    0xffffU
#define V_EFUSE_TIME_6(x) ((x) << S_EFUSE_TIME_6)
#define G_EFUSE_TIME_6(x) (((x) >> S_EFUSE_TIME_6) & M_EFUSE_TIME_6)

#define A_DBG_VREF_CTL 0x61b0

#define S_VREF_SEL_1    15
#define V_VREF_SEL_1(x) ((x) << S_VREF_SEL_1)
#define F_VREF_SEL_1    V_VREF_SEL_1(1U)

#define S_VREF_R_1    8
#define M_VREF_R_1    0x7fU
#define V_VREF_R_1(x) ((x) << S_VREF_R_1)
#define G_VREF_R_1(x) (((x) >> S_VREF_R_1) & M_VREF_R_1)

#define S_VREF_SEL_0    7
#define V_VREF_SEL_0(x) ((x) << S_VREF_SEL_0)
#define F_VREF_SEL_0    V_VREF_SEL_0(1U)

#define S_VREF_R_0    0
#define M_VREF_R_0    0x7fU
#define V_VREF_R_0(x) ((x) << S_VREF_R_0)
#define G_VREF_R_0(x) (((x) >> S_VREF_R_0) & M_VREF_R_0)

#define A_DBG_FPGA_EFUSE_CTL 0x61b4
#define A_DBG_FPGA_EFUSE_DATA 0x61b8

/* registers for module MC */
#define MC_BASE_ADDR 0x6200

#define A_MC_PCTL_SCFG 0x6200

#define S_RKINF_EN    5
#define V_RKINF_EN(x) ((x) << S_RKINF_EN)
#define F_RKINF_EN    V_RKINF_EN(1U)

#define S_DUAL_PCTL_EN    4
#define V_DUAL_PCTL_EN(x) ((x) << S_DUAL_PCTL_EN)
#define F_DUAL_PCTL_EN    V_DUAL_PCTL_EN(1U)

#define S_SLAVE_MODE    3
#define V_SLAVE_MODE(x) ((x) << S_SLAVE_MODE)
#define F_SLAVE_MODE    V_SLAVE_MODE(1U)

#define S_LOOPBACK_EN    1
#define V_LOOPBACK_EN(x) ((x) << S_LOOPBACK_EN)
#define F_LOOPBACK_EN    V_LOOPBACK_EN(1U)

#define S_HW_LOW_POWER_EN    0
#define V_HW_LOW_POWER_EN(x) ((x) << S_HW_LOW_POWER_EN)
#define F_HW_LOW_POWER_EN    V_HW_LOW_POWER_EN(1U)

#define A_MC_PCTL_SCTL 0x6204

#define S_STATE_CMD    0
#define M_STATE_CMD    0x7U
#define V_STATE_CMD(x) ((x) << S_STATE_CMD)
#define G_STATE_CMD(x) (((x) >> S_STATE_CMD) & M_STATE_CMD)

#define A_MC_PCTL_STAT 0x6208

#define S_CTL_STAT    0
#define M_CTL_STAT    0x7U
#define V_CTL_STAT(x) ((x) << S_CTL_STAT)
#define G_CTL_STAT(x) (((x) >> S_CTL_STAT) & M_CTL_STAT)

#define A_MC_PCTL_MCMD 0x6240

#define S_START_CMD    31
#define V_START_CMD(x) ((x) << S_START_CMD)
#define F_START_CMD    V_START_CMD(1U)

#define S_CMD_ADD_DEL    24
#define M_CMD_ADD_DEL    0xfU
#define V_CMD_ADD_DEL(x) ((x) << S_CMD_ADD_DEL)
#define G_CMD_ADD_DEL(x) (((x) >> S_CMD_ADD_DEL) & M_CMD_ADD_DEL)

#define S_RANK_SEL    20
#define M_RANK_SEL    0xfU
#define V_RANK_SEL(x) ((x) << S_RANK_SEL)
#define G_RANK_SEL(x) (((x) >> S_RANK_SEL) & M_RANK_SEL)

#define S_BANK_ADDR    17
#define M_BANK_ADDR    0x7U
#define V_BANK_ADDR(x) ((x) << S_BANK_ADDR)
#define G_BANK_ADDR(x) (((x) >> S_BANK_ADDR) & M_BANK_ADDR)

#define S_CMD_ADDR    4
#define M_CMD_ADDR    0x1fffU
#define V_CMD_ADDR(x) ((x) << S_CMD_ADDR)
#define G_CMD_ADDR(x) (((x) >> S_CMD_ADDR) & M_CMD_ADDR)

#define S_CMD_OPCODE    0
#define M_CMD_OPCODE    0x7U
#define V_CMD_OPCODE(x) ((x) << S_CMD_OPCODE)
#define G_CMD_OPCODE(x) (((x) >> S_CMD_OPCODE) & M_CMD_OPCODE)

#define A_MC_PCTL_POWCTL 0x6244

#define S_POWER_UP_START    0
#define V_POWER_UP_START(x) ((x) << S_POWER_UP_START)
#define F_POWER_UP_START    V_POWER_UP_START(1U)

#define A_MC_PCTL_POWSTAT 0x6248

#define S_PHY_CALIBDONE    1
#define V_PHY_CALIBDONE(x) ((x) << S_PHY_CALIBDONE)
#define F_PHY_CALIBDONE    V_PHY_CALIBDONE(1U)

#define S_POWER_UP_DONE    0
#define V_POWER_UP_DONE(x) ((x) << S_POWER_UP_DONE)
#define F_POWER_UP_DONE    V_POWER_UP_DONE(1U)

#define A_MC_PCTL_MCFG 0x6280

#define S_TFAW_CFG    18
#define M_TFAW_CFG    0x3U
#define V_TFAW_CFG(x) ((x) << S_TFAW_CFG)
#define G_TFAW_CFG(x) (((x) >> S_TFAW_CFG) & M_TFAW_CFG)

#define S_PD_EXIT_MODE    17
#define V_PD_EXIT_MODE(x) ((x) << S_PD_EXIT_MODE)
#define F_PD_EXIT_MODE    V_PD_EXIT_MODE(1U)

#define S_PD_TYPE    16
#define V_PD_TYPE(x) ((x) << S_PD_TYPE)
#define F_PD_TYPE    V_PD_TYPE(1U)

#define S_PD_IDLE    8
#define M_PD_IDLE    0xffU
#define V_PD_IDLE(x) ((x) << S_PD_IDLE)
#define G_PD_IDLE(x) (((x) >> S_PD_IDLE) & M_PD_IDLE)

#define S_PAGE_POLICY    6
#define M_PAGE_POLICY    0x3U
#define V_PAGE_POLICY(x) ((x) << S_PAGE_POLICY)
#define G_PAGE_POLICY(x) (((x) >> S_PAGE_POLICY) & M_PAGE_POLICY)

#define S_DDR3_EN    5
#define V_DDR3_EN(x) ((x) << S_DDR3_EN)
#define F_DDR3_EN    V_DDR3_EN(1U)

#define S_TWO_T_EN    3
#define V_TWO_T_EN(x) ((x) << S_TWO_T_EN)
#define F_TWO_T_EN    V_TWO_T_EN(1U)

#define S_BL8INT_EN    2
#define V_BL8INT_EN(x) ((x) << S_BL8INT_EN)
#define F_BL8INT_EN    V_BL8INT_EN(1U)

#define S_MEM_BL    0
#define V_MEM_BL(x) ((x) << S_MEM_BL)
#define F_MEM_BL    V_MEM_BL(1U)

#define A_MC_PCTL_PPCFG 0x6284

#define S_RPMEM_DIS    1
#define M_RPMEM_DIS    0xffU
#define V_RPMEM_DIS(x) ((x) << S_RPMEM_DIS)
#define G_RPMEM_DIS(x) (((x) >> S_RPMEM_DIS) & M_RPMEM_DIS)

#define S_PPMEM_EN    0
#define V_PPMEM_EN(x) ((x) << S_PPMEM_EN)
#define F_PPMEM_EN    V_PPMEM_EN(1U)

#define A_MC_PCTL_MSTAT 0x6288

#define S_POWER_DOWN    0
#define V_POWER_DOWN(x) ((x) << S_POWER_DOWN)
#define F_POWER_DOWN    V_POWER_DOWN(1U)

#define A_MC_PCTL_ODTCFG 0x628c

#define S_RANK3_ODT_DEFAULT    28
#define V_RANK3_ODT_DEFAULT(x) ((x) << S_RANK3_ODT_DEFAULT)
#define F_RANK3_ODT_DEFAULT    V_RANK3_ODT_DEFAULT(1U)

#define S_RANK3_ODT_WRITE_SEL    27
#define V_RANK3_ODT_WRITE_SEL(x) ((x) << S_RANK3_ODT_WRITE_SEL)
#define F_RANK3_ODT_WRITE_SEL    V_RANK3_ODT_WRITE_SEL(1U)

#define S_RANK3_ODT_WRITE_NSE    26
#define V_RANK3_ODT_WRITE_NSE(x) ((x) << S_RANK3_ODT_WRITE_NSE)
#define F_RANK3_ODT_WRITE_NSE    V_RANK3_ODT_WRITE_NSE(1U)

#define S_RANK3_ODT_READ_SEL    25
#define V_RANK3_ODT_READ_SEL(x) ((x) << S_RANK3_ODT_READ_SEL)
#define F_RANK3_ODT_READ_SEL    V_RANK3_ODT_READ_SEL(1U)

#define S_RANK3_ODT_READ_NSEL    24
#define V_RANK3_ODT_READ_NSEL(x) ((x) << S_RANK3_ODT_READ_NSEL)
#define F_RANK3_ODT_READ_NSEL    V_RANK3_ODT_READ_NSEL(1U)

#define S_RANK2_ODT_DEFAULT    20
#define V_RANK2_ODT_DEFAULT(x) ((x) << S_RANK2_ODT_DEFAULT)
#define F_RANK2_ODT_DEFAULT    V_RANK2_ODT_DEFAULT(1U)

#define S_RANK2_ODT_WRITE_SEL    19
#define V_RANK2_ODT_WRITE_SEL(x) ((x) << S_RANK2_ODT_WRITE_SEL)
#define F_RANK2_ODT_WRITE_SEL    V_RANK2_ODT_WRITE_SEL(1U)

#define S_RANK2_ODT_WRITE_NSEL    18
#define V_RANK2_ODT_WRITE_NSEL(x) ((x) << S_RANK2_ODT_WRITE_NSEL)
#define F_RANK2_ODT_WRITE_NSEL    V_RANK2_ODT_WRITE_NSEL(1U)

#define S_RANK2_ODT_READ_SEL    17
#define V_RANK2_ODT_READ_SEL(x) ((x) << S_RANK2_ODT_READ_SEL)
#define F_RANK2_ODT_READ_SEL    V_RANK2_ODT_READ_SEL(1U)

#define S_RANK2_ODT_READ_NSEL    16
#define V_RANK2_ODT_READ_NSEL(x) ((x) << S_RANK2_ODT_READ_NSEL)
#define F_RANK2_ODT_READ_NSEL    V_RANK2_ODT_READ_NSEL(1U)

#define S_RANK1_ODT_DEFAULT    12
#define V_RANK1_ODT_DEFAULT(x) ((x) << S_RANK1_ODT_DEFAULT)
#define F_RANK1_ODT_DEFAULT    V_RANK1_ODT_DEFAULT(1U)

#define S_RANK1_ODT_WRITE_SEL    11
#define V_RANK1_ODT_WRITE_SEL(x) ((x) << S_RANK1_ODT_WRITE_SEL)
#define F_RANK1_ODT_WRITE_SEL    V_RANK1_ODT_WRITE_SEL(1U)

#define S_RANK1_ODT_WRITE_NSEL    10
#define V_RANK1_ODT_WRITE_NSEL(x) ((x) << S_RANK1_ODT_WRITE_NSEL)
#define F_RANK1_ODT_WRITE_NSEL    V_RANK1_ODT_WRITE_NSEL(1U)

#define S_RANK1_ODT_READ_SEL    9
#define V_RANK1_ODT_READ_SEL(x) ((x) << S_RANK1_ODT_READ_SEL)
#define F_RANK1_ODT_READ_SEL    V_RANK1_ODT_READ_SEL(1U)

#define S_RANK1_ODT_READ_NSEL    8
#define V_RANK1_ODT_READ_NSEL(x) ((x) << S_RANK1_ODT_READ_NSEL)
#define F_RANK1_ODT_READ_NSEL    V_RANK1_ODT_READ_NSEL(1U)

#define S_RANK0_ODT_DEFAULT    4
#define V_RANK0_ODT_DEFAULT(x) ((x) << S_RANK0_ODT_DEFAULT)
#define F_RANK0_ODT_DEFAULT    V_RANK0_ODT_DEFAULT(1U)

#define S_RANK0_ODT_WRITE_SEL    3
#define V_RANK0_ODT_WRITE_SEL(x) ((x) << S_RANK0_ODT_WRITE_SEL)
#define F_RANK0_ODT_WRITE_SEL    V_RANK0_ODT_WRITE_SEL(1U)

#define S_RANK0_ODT_WRITE_NSEL    2
#define V_RANK0_ODT_WRITE_NSEL(x) ((x) << S_RANK0_ODT_WRITE_NSEL)
#define F_RANK0_ODT_WRITE_NSEL    V_RANK0_ODT_WRITE_NSEL(1U)

#define S_RANK0_ODT_READ_SEL    1
#define V_RANK0_ODT_READ_SEL(x) ((x) << S_RANK0_ODT_READ_SEL)
#define F_RANK0_ODT_READ_SEL    V_RANK0_ODT_READ_SEL(1U)

#define S_RANK0_ODT_READ_NSEL    0
#define V_RANK0_ODT_READ_NSEL(x) ((x) << S_RANK0_ODT_READ_NSEL)
#define F_RANK0_ODT_READ_NSEL    V_RANK0_ODT_READ_NSEL(1U)

#define A_MC_PCTL_DQSECFG 0x6290

#define S_DV_ALAT    20
#define M_DV_ALAT    0xfU
#define V_DV_ALAT(x) ((x) << S_DV_ALAT)
#define G_DV_ALAT(x) (((x) >> S_DV_ALAT) & M_DV_ALAT)

#define S_DV_ALEN    16
#define M_DV_ALEN    0x3U
#define V_DV_ALEN(x) ((x) << S_DV_ALEN)
#define G_DV_ALEN(x) (((x) >> S_DV_ALEN) & M_DV_ALEN)

#define S_DSE_ALAT    12
#define M_DSE_ALAT    0xfU
#define V_DSE_ALAT(x) ((x) << S_DSE_ALAT)
#define G_DSE_ALAT(x) (((x) >> S_DSE_ALAT) & M_DSE_ALAT)

#define S_DSE_ALEN    8
#define M_DSE_ALEN    0x3U
#define V_DSE_ALEN(x) ((x) << S_DSE_ALEN)
#define G_DSE_ALEN(x) (((x) >> S_DSE_ALEN) & M_DSE_ALEN)

#define S_QSE_ALAT    4
#define M_QSE_ALAT    0xfU
#define V_QSE_ALAT(x) ((x) << S_QSE_ALAT)
#define G_QSE_ALAT(x) (((x) >> S_QSE_ALAT) & M_QSE_ALAT)

#define S_QSE_ALEN    0
#define M_QSE_ALEN    0x3U
#define V_QSE_ALEN(x) ((x) << S_QSE_ALEN)
#define G_QSE_ALEN(x) (((x) >> S_QSE_ALEN) & M_QSE_ALEN)

#define A_MC_PCTL_DTUPDES 0x6294

#define S_DTU_RD_MISSING    13
#define V_DTU_RD_MISSING(x) ((x) << S_DTU_RD_MISSING)
#define F_DTU_RD_MISSING    V_DTU_RD_MISSING(1U)

#define S_DTU_EAFFL    9
#define M_DTU_EAFFL    0xfU
#define V_DTU_EAFFL(x) ((x) << S_DTU_EAFFL)
#define G_DTU_EAFFL(x) (((x) >> S_DTU_EAFFL) & M_DTU_EAFFL)

#define S_DTU_RANDOM_ERROR    8
#define V_DTU_RANDOM_ERROR(x) ((x) << S_DTU_RANDOM_ERROR)
#define F_DTU_RANDOM_ERROR    V_DTU_RANDOM_ERROR(1U)

#define S_DTU_ERROR_B7    7
#define V_DTU_ERROR_B7(x) ((x) << S_DTU_ERROR_B7)
#define F_DTU_ERROR_B7    V_DTU_ERROR_B7(1U)

#define S_DTU_ERR_B6    6
#define V_DTU_ERR_B6(x) ((x) << S_DTU_ERR_B6)
#define F_DTU_ERR_B6    V_DTU_ERR_B6(1U)

#define S_DTU_ERR_B5    5
#define V_DTU_ERR_B5(x) ((x) << S_DTU_ERR_B5)
#define F_DTU_ERR_B5    V_DTU_ERR_B5(1U)

#define S_DTU_ERR_B4    4
#define V_DTU_ERR_B4(x) ((x) << S_DTU_ERR_B4)
#define F_DTU_ERR_B4    V_DTU_ERR_B4(1U)

#define S_DTU_ERR_B3    3
#define V_DTU_ERR_B3(x) ((x) << S_DTU_ERR_B3)
#define F_DTU_ERR_B3    V_DTU_ERR_B3(1U)

#define S_DTU_ERR_B2    2
#define V_DTU_ERR_B2(x) ((x) << S_DTU_ERR_B2)
#define F_DTU_ERR_B2    V_DTU_ERR_B2(1U)

#define S_DTU_ERR_B1    1
#define V_DTU_ERR_B1(x) ((x) << S_DTU_ERR_B1)
#define F_DTU_ERR_B1    V_DTU_ERR_B1(1U)

#define S_DTU_ERR_B0    0
#define V_DTU_ERR_B0(x) ((x) << S_DTU_ERR_B0)
#define F_DTU_ERR_B0    V_DTU_ERR_B0(1U)

#define A_MC_PCTL_DTUNA 0x6298
#define A_MC_PCTL_DTUNE 0x629c
#define A_MC_PCTL_DTUPRDO 0x62a0

#define S_DTU_ALLBITS_1    16
#define M_DTU_ALLBITS_1    0xffffU
#define V_DTU_ALLBITS_1(x) ((x) << S_DTU_ALLBITS_1)
#define G_DTU_ALLBITS_1(x) (((x) >> S_DTU_ALLBITS_1) & M_DTU_ALLBITS_1)

#define S_DTU_ALLBITS_0    0
#define M_DTU_ALLBITS_0    0xffffU
#define V_DTU_ALLBITS_0(x) ((x) << S_DTU_ALLBITS_0)
#define G_DTU_ALLBITS_0(x) (((x) >> S_DTU_ALLBITS_0) & M_DTU_ALLBITS_0)

#define A_MC_PCTL_DTUPRD1 0x62a4

#define S_DTU_ALLBITS_3    16
#define M_DTU_ALLBITS_3    0xffffU
#define V_DTU_ALLBITS_3(x) ((x) << S_DTU_ALLBITS_3)
#define G_DTU_ALLBITS_3(x) (((x) >> S_DTU_ALLBITS_3) & M_DTU_ALLBITS_3)

#define S_DTU_ALLBITS_2    0
#define M_DTU_ALLBITS_2    0xffffU
#define V_DTU_ALLBITS_2(x) ((x) << S_DTU_ALLBITS_2)
#define G_DTU_ALLBITS_2(x) (((x) >> S_DTU_ALLBITS_2) & M_DTU_ALLBITS_2)

#define A_MC_PCTL_DTUPRD2 0x62a8

#define S_DTU_ALLBITS_5    16
#define M_DTU_ALLBITS_5    0xffffU
#define V_DTU_ALLBITS_5(x) ((x) << S_DTU_ALLBITS_5)
#define G_DTU_ALLBITS_5(x) (((x) >> S_DTU_ALLBITS_5) & M_DTU_ALLBITS_5)

#define S_DTU_ALLBITS_4    0
#define M_DTU_ALLBITS_4    0xffffU
#define V_DTU_ALLBITS_4(x) ((x) << S_DTU_ALLBITS_4)
#define G_DTU_ALLBITS_4(x) (((x) >> S_DTU_ALLBITS_4) & M_DTU_ALLBITS_4)

#define A_MC_PCTL_DTUPRD3 0x62ac

#define S_DTU_ALLBITS_7    16
#define M_DTU_ALLBITS_7    0xffffU
#define V_DTU_ALLBITS_7(x) ((x) << S_DTU_ALLBITS_7)
#define G_DTU_ALLBITS_7(x) (((x) >> S_DTU_ALLBITS_7) & M_DTU_ALLBITS_7)

#define S_DTU_ALLBITS_6    0
#define M_DTU_ALLBITS_6    0xffffU
#define V_DTU_ALLBITS_6(x) ((x) << S_DTU_ALLBITS_6)
#define G_DTU_ALLBITS_6(x) (((x) >> S_DTU_ALLBITS_6) & M_DTU_ALLBITS_6)

#define A_MC_PCTL_DTUAWDT 0x62b0

#define S_NUMBER_RANKS    9
#define M_NUMBER_RANKS    0x3U
#define V_NUMBER_RANKS(x) ((x) << S_NUMBER_RANKS)
#define G_NUMBER_RANKS(x) (((x) >> S_NUMBER_RANKS) & M_NUMBER_RANKS)

#define S_ROW_ADDR_WIDTH    6
#define M_ROW_ADDR_WIDTH    0x3U
#define V_ROW_ADDR_WIDTH(x) ((x) << S_ROW_ADDR_WIDTH)
#define G_ROW_ADDR_WIDTH(x) (((x) >> S_ROW_ADDR_WIDTH) & M_ROW_ADDR_WIDTH)

#define S_BANK_ADDR_WIDTH    3
#define M_BANK_ADDR_WIDTH    0x3U
#define V_BANK_ADDR_WIDTH(x) ((x) << S_BANK_ADDR_WIDTH)
#define G_BANK_ADDR_WIDTH(x) (((x) >> S_BANK_ADDR_WIDTH) & M_BANK_ADDR_WIDTH)

#define S_COLUMN_ADDR_WIDTH    0
#define M_COLUMN_ADDR_WIDTH    0x3U
#define V_COLUMN_ADDR_WIDTH(x) ((x) << S_COLUMN_ADDR_WIDTH)
#define G_COLUMN_ADDR_WIDTH(x) (((x) >> S_COLUMN_ADDR_WIDTH) & M_COLUMN_ADDR_WIDTH)

#define A_MC_PCTL_TOGCNT1U 0x62c0

#define S_TOGGLE_COUNTER_1U    0
#define M_TOGGLE_COUNTER_1U    0x3ffU
#define V_TOGGLE_COUNTER_1U(x) ((x) << S_TOGGLE_COUNTER_1U)
#define G_TOGGLE_COUNTER_1U(x) (((x) >> S_TOGGLE_COUNTER_1U) & M_TOGGLE_COUNTER_1U)

#define A_MC_PCTL_TINIT 0x62c4

#define S_T_INIT    0
#define M_T_INIT    0x1ffU
#define V_T_INIT(x) ((x) << S_T_INIT)
#define G_T_INIT(x) (((x) >> S_T_INIT) & M_T_INIT)

#define A_MC_PCTL_TRSTH 0x62c8

#define S_T_RSTH    0
#define M_T_RSTH    0x3ffU
#define V_T_RSTH(x) ((x) << S_T_RSTH)
#define G_T_RSTH(x) (((x) >> S_T_RSTH) & M_T_RSTH)

#define A_MC_PCTL_TOGCNT100N 0x62cc

#define S_TOGGLE_COUNTER_100N    0
#define M_TOGGLE_COUNTER_100N    0x7fU
#define V_TOGGLE_COUNTER_100N(x) ((x) << S_TOGGLE_COUNTER_100N)
#define G_TOGGLE_COUNTER_100N(x) (((x) >> S_TOGGLE_COUNTER_100N) & M_TOGGLE_COUNTER_100N)

#define A_MC_PCTL_TREFI 0x62d0

#define S_T_REFI    0
#define M_T_REFI    0xffU
#define V_T_REFI(x) ((x) << S_T_REFI)
#define G_T_REFI(x) (((x) >> S_T_REFI) & M_T_REFI)

#define A_MC_PCTL_TMRD 0x62d4

#define S_T_MRD    0
#define M_T_MRD    0x7U
#define V_T_MRD(x) ((x) << S_T_MRD)
#define G_T_MRD(x) (((x) >> S_T_MRD) & M_T_MRD)

#define A_MC_PCTL_TRFC 0x62d8

#define S_T_RFC    0
#define M_T_RFC    0xffU
#define V_T_RFC(x) ((x) << S_T_RFC)
#define G_T_RFC(x) (((x) >> S_T_RFC) & M_T_RFC)

#define A_MC_PCTL_TRP 0x62dc

#define S_T_RP    0
#define M_T_RP    0xfU
#define V_T_RP(x) ((x) << S_T_RP)
#define G_T_RP(x) (((x) >> S_T_RP) & M_T_RP)

#define A_MC_PCTL_TRTW 0x62e0

#define S_T_RTW    0
#define M_T_RTW    0x7U
#define V_T_RTW(x) ((x) << S_T_RTW)
#define G_T_RTW(x) (((x) >> S_T_RTW) & M_T_RTW)

#define A_MC_PCTL_TAL 0x62e4

#define S_T_AL    0
#define M_T_AL    0xfU
#define V_T_AL(x) ((x) << S_T_AL)
#define G_T_AL(x) (((x) >> S_T_AL) & M_T_AL)

#define A_MC_PCTL_TCL 0x62e8

#define S_T_CL    0
#define M_T_CL    0xfU
#define V_T_CL(x) ((x) << S_T_CL)
#define G_T_CL(x) (((x) >> S_T_CL) & M_T_CL)

#define A_MC_PCTL_TCWL 0x62ec

#define S_T_CWL    0
#define M_T_CWL    0xfU
#define V_T_CWL(x) ((x) << S_T_CWL)
#define G_T_CWL(x) (((x) >> S_T_CWL) & M_T_CWL)

#define A_MC_PCTL_TRAS 0x62f0

#define S_T_RAS    0
#define M_T_RAS    0x3fU
#define V_T_RAS(x) ((x) << S_T_RAS)
#define G_T_RAS(x) (((x) >> S_T_RAS) & M_T_RAS)

#define A_MC_PCTL_TRC 0x62f4

#define S_T_RC    0
#define M_T_RC    0x3fU
#define V_T_RC(x) ((x) << S_T_RC)
#define G_T_RC(x) (((x) >> S_T_RC) & M_T_RC)

#define A_MC_PCTL_TRCD 0x62f8

#define S_T_RCD    0
#define M_T_RCD    0xfU
#define V_T_RCD(x) ((x) << S_T_RCD)
#define G_T_RCD(x) (((x) >> S_T_RCD) & M_T_RCD)

#define A_MC_PCTL_TRRD 0x62fc

#define S_T_RRD    0
#define M_T_RRD    0xfU
#define V_T_RRD(x) ((x) << S_T_RRD)
#define G_T_RRD(x) (((x) >> S_T_RRD) & M_T_RRD)

#define A_MC_PCTL_TRTP 0x6300

#define S_T_RTP    0
#define M_T_RTP    0x7U
#define V_T_RTP(x) ((x) << S_T_RTP)
#define G_T_RTP(x) (((x) >> S_T_RTP) & M_T_RTP)

#define A_MC_PCTL_TWR 0x6304

#define S_T_WR    0
#define M_T_WR    0x7U
#define V_T_WR(x) ((x) << S_T_WR)
#define G_T_WR(x) (((x) >> S_T_WR) & M_T_WR)

#define A_MC_PCTL_TWTR 0x6308

#define S_T_WTR    0
#define M_T_WTR    0x7U
#define V_T_WTR(x) ((x) << S_T_WTR)
#define G_T_WTR(x) (((x) >> S_T_WTR) & M_T_WTR)

#define A_MC_PCTL_TEXSR 0x630c

#define S_T_EXSR    0
#define M_T_EXSR    0x3ffU
#define V_T_EXSR(x) ((x) << S_T_EXSR)
#define G_T_EXSR(x) (((x) >> S_T_EXSR) & M_T_EXSR)

#define A_MC_PCTL_TXP 0x6310

#define S_T_XP    0
#define M_T_XP    0x7U
#define V_T_XP(x) ((x) << S_T_XP)
#define G_T_XP(x) (((x) >> S_T_XP) & M_T_XP)

#define A_MC_PCTL_TXPDLL 0x6314

#define S_T_XPDLL    0
#define M_T_XPDLL    0x3fU
#define V_T_XPDLL(x) ((x) << S_T_XPDLL)
#define G_T_XPDLL(x) (((x) >> S_T_XPDLL) & M_T_XPDLL)

#define A_MC_PCTL_TZQCS 0x6318

#define S_T_ZQCS    0
#define M_T_ZQCS    0x7fU
#define V_T_ZQCS(x) ((x) << S_T_ZQCS)
#define G_T_ZQCS(x) (((x) >> S_T_ZQCS) & M_T_ZQCS)

#define A_MC_PCTL_TZQCSI 0x631c

#define S_T_ZQCSI    0
#define M_T_ZQCSI    0xfffU
#define V_T_ZQCSI(x) ((x) << S_T_ZQCSI)
#define G_T_ZQCSI(x) (((x) >> S_T_ZQCSI) & M_T_ZQCSI)

#define A_MC_PCTL_TDQS 0x6320

#define S_T_DQS    0
#define M_T_DQS    0x7U
#define V_T_DQS(x) ((x) << S_T_DQS)
#define G_T_DQS(x) (((x) >> S_T_DQS) & M_T_DQS)

#define A_MC_PCTL_TCKSRE 0x6324

#define S_T_CKSRE    0
#define M_T_CKSRE    0xfU
#define V_T_CKSRE(x) ((x) << S_T_CKSRE)
#define G_T_CKSRE(x) (((x) >> S_T_CKSRE) & M_T_CKSRE)

#define A_MC_PCTL_TCKSRX 0x6328

#define S_T_CKSRX    0
#define M_T_CKSRX    0xfU
#define V_T_CKSRX(x) ((x) << S_T_CKSRX)
#define G_T_CKSRX(x) (((x) >> S_T_CKSRX) & M_T_CKSRX)

#define A_MC_PCTL_TCKE 0x632c

#define S_T_CKE    0
#define M_T_CKE    0x7U
#define V_T_CKE(x) ((x) << S_T_CKE)
#define G_T_CKE(x) (((x) >> S_T_CKE) & M_T_CKE)

#define A_MC_PCTL_TMOD 0x6330

#define S_T_MOD    0
#define M_T_MOD    0xfU
#define V_T_MOD(x) ((x) << S_T_MOD)
#define G_T_MOD(x) (((x) >> S_T_MOD) & M_T_MOD)

#define A_MC_PCTL_TRSTL 0x6334

#define S_RSTHOLD    0
#define M_RSTHOLD    0x7fU
#define V_RSTHOLD(x) ((x) << S_RSTHOLD)
#define G_RSTHOLD(x) (((x) >> S_RSTHOLD) & M_RSTHOLD)

#define A_MC_PCTL_TZQCL 0x6338

#define S_T_ZQCL    0
#define M_T_ZQCL    0x3ffU
#define V_T_ZQCL(x) ((x) << S_T_ZQCL)
#define G_T_ZQCL(x) (((x) >> S_T_ZQCL) & M_T_ZQCL)

#define A_MC_PCTL_DWLCFG0 0x6370

#define S_T_ADWL_VEC    0
#define M_T_ADWL_VEC    0x1ffU
#define V_T_ADWL_VEC(x) ((x) << S_T_ADWL_VEC)
#define G_T_ADWL_VEC(x) (((x) >> S_T_ADWL_VEC) & M_T_ADWL_VEC)

#define A_MC_PCTL_DWLCFG1 0x6374
#define A_MC_PCTL_DWLCFG2 0x6378
#define A_MC_PCTL_DWLCFG3 0x637c
#define A_MC_PCTL_ECCCFG 0x6380

#define S_INLINE_SYN_EN    4
#define V_INLINE_SYN_EN(x) ((x) << S_INLINE_SYN_EN)
#define F_INLINE_SYN_EN    V_INLINE_SYN_EN(1U)

#define S_ECC_EN    3
#define V_ECC_EN(x) ((x) << S_ECC_EN)
#define F_ECC_EN    V_ECC_EN(1U)

#define S_ECC_INTR_EN    2
#define V_ECC_INTR_EN(x) ((x) << S_ECC_INTR_EN)
#define F_ECC_INTR_EN    V_ECC_INTR_EN(1U)

#define A_MC_PCTL_ECCTST 0x6384

#define S_ECC_TEST_MASK    0
#define M_ECC_TEST_MASK    0xffU
#define V_ECC_TEST_MASK(x) ((x) << S_ECC_TEST_MASK)
#define G_ECC_TEST_MASK(x) (((x) >> S_ECC_TEST_MASK) & M_ECC_TEST_MASK)

#define A_MC_PCTL_ECCCLR 0x6388

#define S_CLR_ECC_LOG    1
#define V_CLR_ECC_LOG(x) ((x) << S_CLR_ECC_LOG)
#define F_CLR_ECC_LOG    V_CLR_ECC_LOG(1U)

#define S_CLR_ECC_INTR    0
#define V_CLR_ECC_INTR(x) ((x) << S_CLR_ECC_INTR)
#define F_CLR_ECC_INTR    V_CLR_ECC_INTR(1U)

#define A_MC_PCTL_ECCLOG 0x638c
#define A_MC_PCTL_DTUWACTL 0x6400

#define S_DTU_WR_RANK    30
#define M_DTU_WR_RANK    0x3U
#define V_DTU_WR_RANK(x) ((x) << S_DTU_WR_RANK)
#define G_DTU_WR_RANK(x) (((x) >> S_DTU_WR_RANK) & M_DTU_WR_RANK)

#define S_DTU_WR_ROW    13
#define M_DTU_WR_ROW    0x1ffffU
#define V_DTU_WR_ROW(x) ((x) << S_DTU_WR_ROW)
#define G_DTU_WR_ROW(x) (((x) >> S_DTU_WR_ROW) & M_DTU_WR_ROW)

#define S_DTU_WR_BANK    10
#define M_DTU_WR_BANK    0x7U
#define V_DTU_WR_BANK(x) ((x) << S_DTU_WR_BANK)
#define G_DTU_WR_BANK(x) (((x) >> S_DTU_WR_BANK) & M_DTU_WR_BANK)

#define S_DTU_WR_COL    0
#define M_DTU_WR_COL    0x3ffU
#define V_DTU_WR_COL(x) ((x) << S_DTU_WR_COL)
#define G_DTU_WR_COL(x) (((x) >> S_DTU_WR_COL) & M_DTU_WR_COL)

#define A_MC_PCTL_DTURACTL 0x6404

#define S_DTU_RD_RANK    30
#define M_DTU_RD_RANK    0x3U
#define V_DTU_RD_RANK(x) ((x) << S_DTU_RD_RANK)
#define G_DTU_RD_RANK(x) (((x) >> S_DTU_RD_RANK) & M_DTU_RD_RANK)

#define S_DTU_RD_ROW    13
#define M_DTU_RD_ROW    0x1ffffU
#define V_DTU_RD_ROW(x) ((x) << S_DTU_RD_ROW)
#define G_DTU_RD_ROW(x) (((x) >> S_DTU_RD_ROW) & M_DTU_RD_ROW)

#define S_DTU_RD_BANK    10
#define M_DTU_RD_BANK    0x7U
#define V_DTU_RD_BANK(x) ((x) << S_DTU_RD_BANK)
#define G_DTU_RD_BANK(x) (((x) >> S_DTU_RD_BANK) & M_DTU_RD_BANK)

#define S_DTU_RD_COL    0
#define M_DTU_RD_COL    0x3ffU
#define V_DTU_RD_COL(x) ((x) << S_DTU_RD_COL)
#define G_DTU_RD_COL(x) (((x) >> S_DTU_RD_COL) & M_DTU_RD_COL)

#define A_MC_PCTL_DTUCFG 0x6408

#define S_DTU_ROW_INCREMENTS    16
#define M_DTU_ROW_INCREMENTS    0x7fU
#define V_DTU_ROW_INCREMENTS(x) ((x) << S_DTU_ROW_INCREMENTS)
#define G_DTU_ROW_INCREMENTS(x) (((x) >> S_DTU_ROW_INCREMENTS) & M_DTU_ROW_INCREMENTS)

#define S_DTU_WR_MULTI_RD    15
#define V_DTU_WR_MULTI_RD(x) ((x) << S_DTU_WR_MULTI_RD)
#define F_DTU_WR_MULTI_RD    V_DTU_WR_MULTI_RD(1U)

#define S_DTU_DATA_MASK_EN    14
#define V_DTU_DATA_MASK_EN(x) ((x) << S_DTU_DATA_MASK_EN)
#define F_DTU_DATA_MASK_EN    V_DTU_DATA_MASK_EN(1U)

#define S_DTU_TARGET_LANE    10
#define M_DTU_TARGET_LANE    0xfU
#define V_DTU_TARGET_LANE(x) ((x) << S_DTU_TARGET_LANE)
#define G_DTU_TARGET_LANE(x) (((x) >> S_DTU_TARGET_LANE) & M_DTU_TARGET_LANE)

#define S_DTU_GENERATE_RANDOM    9
#define V_DTU_GENERATE_RANDOM(x) ((x) << S_DTU_GENERATE_RANDOM)
#define F_DTU_GENERATE_RANDOM    V_DTU_GENERATE_RANDOM(1U)

#define S_DTU_INCR_BANKS    8
#define V_DTU_INCR_BANKS(x) ((x) << S_DTU_INCR_BANKS)
#define F_DTU_INCR_BANKS    V_DTU_INCR_BANKS(1U)

#define S_DTU_INCR_COLS    7
#define V_DTU_INCR_COLS(x) ((x) << S_DTU_INCR_COLS)
#define F_DTU_INCR_COLS    V_DTU_INCR_COLS(1U)

#define S_DTU_NALEN    1
#define M_DTU_NALEN    0x3fU
#define V_DTU_NALEN(x) ((x) << S_DTU_NALEN)
#define G_DTU_NALEN(x) (((x) >> S_DTU_NALEN) & M_DTU_NALEN)

#define S_DTU_ENABLE    0
#define V_DTU_ENABLE(x) ((x) << S_DTU_ENABLE)
#define F_DTU_ENABLE    V_DTU_ENABLE(1U)

#define A_MC_PCTL_DTUECTL 0x640c

#define S_WR_MULTI_RD_RST    2
#define V_WR_MULTI_RD_RST(x) ((x) << S_WR_MULTI_RD_RST)
#define F_WR_MULTI_RD_RST    V_WR_MULTI_RD_RST(1U)

#define S_RUN_ERROR_REPORTS    1
#define V_RUN_ERROR_REPORTS(x) ((x) << S_RUN_ERROR_REPORTS)
#define F_RUN_ERROR_REPORTS    V_RUN_ERROR_REPORTS(1U)

#define S_RUN_DTU    0
#define V_RUN_DTU(x) ((x) << S_RUN_DTU)
#define F_RUN_DTU    V_RUN_DTU(1U)

#define A_MC_PCTL_DTUWD0 0x6410

#define S_DTU_WR_BYTE3    24
#define M_DTU_WR_BYTE3    0xffU
#define V_DTU_WR_BYTE3(x) ((x) << S_DTU_WR_BYTE3)
#define G_DTU_WR_BYTE3(x) (((x) >> S_DTU_WR_BYTE3) & M_DTU_WR_BYTE3)

#define S_DTU_WR_BYTE2    16
#define M_DTU_WR_BYTE2    0xffU
#define V_DTU_WR_BYTE2(x) ((x) << S_DTU_WR_BYTE2)
#define G_DTU_WR_BYTE2(x) (((x) >> S_DTU_WR_BYTE2) & M_DTU_WR_BYTE2)

#define S_DTU_WR_BYTE1    8
#define M_DTU_WR_BYTE1    0xffU
#define V_DTU_WR_BYTE1(x) ((x) << S_DTU_WR_BYTE1)
#define G_DTU_WR_BYTE1(x) (((x) >> S_DTU_WR_BYTE1) & M_DTU_WR_BYTE1)

#define S_DTU_WR_BYTE0    0
#define M_DTU_WR_BYTE0    0xffU
#define V_DTU_WR_BYTE0(x) ((x) << S_DTU_WR_BYTE0)
#define G_DTU_WR_BYTE0(x) (((x) >> S_DTU_WR_BYTE0) & M_DTU_WR_BYTE0)

#define A_MC_PCTL_DTUWD1 0x6414

#define S_DTU_WR_BYTE7    24
#define M_DTU_WR_BYTE7    0xffU
#define V_DTU_WR_BYTE7(x) ((x) << S_DTU_WR_BYTE7)
#define G_DTU_WR_BYTE7(x) (((x) >> S_DTU_WR_BYTE7) & M_DTU_WR_BYTE7)

#define S_DTU_WR_BYTE6    16
#define M_DTU_WR_BYTE6    0xffU
#define V_DTU_WR_BYTE6(x) ((x) << S_DTU_WR_BYTE6)
#define G_DTU_WR_BYTE6(x) (((x) >> S_DTU_WR_BYTE6) & M_DTU_WR_BYTE6)

#define S_DTU_WR_BYTE5    8
#define M_DTU_WR_BYTE5    0xffU
#define V_DTU_WR_BYTE5(x) ((x) << S_DTU_WR_BYTE5)
#define G_DTU_WR_BYTE5(x) (((x) >> S_DTU_WR_BYTE5) & M_DTU_WR_BYTE5)

#define S_DTU_WR_BYTE4    0
#define M_DTU_WR_BYTE4    0xffU
#define V_DTU_WR_BYTE4(x) ((x) << S_DTU_WR_BYTE4)
#define G_DTU_WR_BYTE4(x) (((x) >> S_DTU_WR_BYTE4) & M_DTU_WR_BYTE4)

#define A_MC_PCTL_DTUWD2 0x6418

#define S_DTU_WR_BYTE11    24
#define M_DTU_WR_BYTE11    0xffU
#define V_DTU_WR_BYTE11(x) ((x) << S_DTU_WR_BYTE11)
#define G_DTU_WR_BYTE11(x) (((x) >> S_DTU_WR_BYTE11) & M_DTU_WR_BYTE11)

#define S_DTU_WR_BYTE10    16
#define M_DTU_WR_BYTE10    0xffU
#define V_DTU_WR_BYTE10(x) ((x) << S_DTU_WR_BYTE10)
#define G_DTU_WR_BYTE10(x) (((x) >> S_DTU_WR_BYTE10) & M_DTU_WR_BYTE10)

#define S_DTU_WR_BYTE9    8
#define M_DTU_WR_BYTE9    0xffU
#define V_DTU_WR_BYTE9(x) ((x) << S_DTU_WR_BYTE9)
#define G_DTU_WR_BYTE9(x) (((x) >> S_DTU_WR_BYTE9) & M_DTU_WR_BYTE9)

#define S_DTU_WR_BYTE8    0
#define M_DTU_WR_BYTE8    0xffU
#define V_DTU_WR_BYTE8(x) ((x) << S_DTU_WR_BYTE8)
#define G_DTU_WR_BYTE8(x) (((x) >> S_DTU_WR_BYTE8) & M_DTU_WR_BYTE8)

#define A_MC_PCTL_DTUWD3 0x641c

#define S_DTU_WR_BYTE15    24
#define M_DTU_WR_BYTE15    0xffU
#define V_DTU_WR_BYTE15(x) ((x) << S_DTU_WR_BYTE15)
#define G_DTU_WR_BYTE15(x) (((x) >> S_DTU_WR_BYTE15) & M_DTU_WR_BYTE15)

#define S_DTU_WR_BYTE14    16
#define M_DTU_WR_BYTE14    0xffU
#define V_DTU_WR_BYTE14(x) ((x) << S_DTU_WR_BYTE14)
#define G_DTU_WR_BYTE14(x) (((x) >> S_DTU_WR_BYTE14) & M_DTU_WR_BYTE14)

#define S_DTU_WR_BYTE13    8
#define M_DTU_WR_BYTE13    0xffU
#define V_DTU_WR_BYTE13(x) ((x) << S_DTU_WR_BYTE13)
#define G_DTU_WR_BYTE13(x) (((x) >> S_DTU_WR_BYTE13) & M_DTU_WR_BYTE13)

#define S_DTU_WR_BYTE12    0
#define M_DTU_WR_BYTE12    0xffU
#define V_DTU_WR_BYTE12(x) ((x) << S_DTU_WR_BYTE12)
#define G_DTU_WR_BYTE12(x) (((x) >> S_DTU_WR_BYTE12) & M_DTU_WR_BYTE12)

#define A_MC_PCTL_DTUWDM 0x6420

#define S_DM_WR_BYTE0    0
#define M_DM_WR_BYTE0    0xffffU
#define V_DM_WR_BYTE0(x) ((x) << S_DM_WR_BYTE0)
#define G_DM_WR_BYTE0(x) (((x) >> S_DM_WR_BYTE0) & M_DM_WR_BYTE0)

#define A_MC_PCTL_DTURD0 0x6424

#define S_DTU_RD_BYTE3    24
#define M_DTU_RD_BYTE3    0xffU
#define V_DTU_RD_BYTE3(x) ((x) << S_DTU_RD_BYTE3)
#define G_DTU_RD_BYTE3(x) (((x) >> S_DTU_RD_BYTE3) & M_DTU_RD_BYTE3)

#define S_DTU_RD_BYTE2    16
#define M_DTU_RD_BYTE2    0xffU
#define V_DTU_RD_BYTE2(x) ((x) << S_DTU_RD_BYTE2)
#define G_DTU_RD_BYTE2(x) (((x) >> S_DTU_RD_BYTE2) & M_DTU_RD_BYTE2)

#define S_DTU_RD_BYTE1    8
#define M_DTU_RD_BYTE1    0xffU
#define V_DTU_RD_BYTE1(x) ((x) << S_DTU_RD_BYTE1)
#define G_DTU_RD_BYTE1(x) (((x) >> S_DTU_RD_BYTE1) & M_DTU_RD_BYTE1)

#define S_DTU_RD_BYTE0    0
#define M_DTU_RD_BYTE0    0xffU
#define V_DTU_RD_BYTE0(x) ((x) << S_DTU_RD_BYTE0)
#define G_DTU_RD_BYTE0(x) (((x) >> S_DTU_RD_BYTE0) & M_DTU_RD_BYTE0)

#define A_MC_PCTL_DTURD1 0x6428

#define S_DTU_RD_BYTE7    24
#define M_DTU_RD_BYTE7    0xffU
#define V_DTU_RD_BYTE7(x) ((x) << S_DTU_RD_BYTE7)
#define G_DTU_RD_BYTE7(x) (((x) >> S_DTU_RD_BYTE7) & M_DTU_RD_BYTE7)

#define S_DTU_RD_BYTE6    16
#define M_DTU_RD_BYTE6    0xffU
#define V_DTU_RD_BYTE6(x) ((x) << S_DTU_RD_BYTE6)
#define G_DTU_RD_BYTE6(x) (((x) >> S_DTU_RD_BYTE6) & M_DTU_RD_BYTE6)

#define S_DTU_RD_BYTE5    8
#define M_DTU_RD_BYTE5    0xffU
#define V_DTU_RD_BYTE5(x) ((x) << S_DTU_RD_BYTE5)
#define G_DTU_RD_BYTE5(x) (((x) >> S_DTU_RD_BYTE5) & M_DTU_RD_BYTE5)

#define S_DTU_RD_BYTE4    0
#define M_DTU_RD_BYTE4    0xffU
#define V_DTU_RD_BYTE4(x) ((x) << S_DTU_RD_BYTE4)
#define G_DTU_RD_BYTE4(x) (((x) >> S_DTU_RD_BYTE4) & M_DTU_RD_BYTE4)

#define A_MC_PCTL_DTURD2 0x642c

#define S_DTU_RD_BYTE11    24
#define M_DTU_RD_BYTE11    0xffU
#define V_DTU_RD_BYTE11(x) ((x) << S_DTU_RD_BYTE11)
#define G_DTU_RD_BYTE11(x) (((x) >> S_DTU_RD_BYTE11) & M_DTU_RD_BYTE11)

#define S_DTU_RD_BYTE10    16
#define M_DTU_RD_BYTE10    0xffU
#define V_DTU_RD_BYTE10(x) ((x) << S_DTU_RD_BYTE10)
#define G_DTU_RD_BYTE10(x) (((x) >> S_DTU_RD_BYTE10) & M_DTU_RD_BYTE10)

#define S_DTU_RD_BYTE9    8
#define M_DTU_RD_BYTE9    0xffU
#define V_DTU_RD_BYTE9(x) ((x) << S_DTU_RD_BYTE9)
#define G_DTU_RD_BYTE9(x) (((x) >> S_DTU_RD_BYTE9) & M_DTU_RD_BYTE9)

#define S_DTU_RD_BYTE8    0
#define M_DTU_RD_BYTE8    0xffU
#define V_DTU_RD_BYTE8(x) ((x) << S_DTU_RD_BYTE8)
#define G_DTU_RD_BYTE8(x) (((x) >> S_DTU_RD_BYTE8) & M_DTU_RD_BYTE8)

#define A_MC_PCTL_DTURD3 0x6430

#define S_DTU_RD_BYTE15    24
#define M_DTU_RD_BYTE15    0xffU
#define V_DTU_RD_BYTE15(x) ((x) << S_DTU_RD_BYTE15)
#define G_DTU_RD_BYTE15(x) (((x) >> S_DTU_RD_BYTE15) & M_DTU_RD_BYTE15)

#define S_DTU_RD_BYTE14    16
#define M_DTU_RD_BYTE14    0xffU
#define V_DTU_RD_BYTE14(x) ((x) << S_DTU_RD_BYTE14)
#define G_DTU_RD_BYTE14(x) (((x) >> S_DTU_RD_BYTE14) & M_DTU_RD_BYTE14)

#define S_DTU_RD_BYTE13    8
#define M_DTU_RD_BYTE13    0xffU
#define V_DTU_RD_BYTE13(x) ((x) << S_DTU_RD_BYTE13)
#define G_DTU_RD_BYTE13(x) (((x) >> S_DTU_RD_BYTE13) & M_DTU_RD_BYTE13)

#define S_DTU_RD_BYTE12    0
#define M_DTU_RD_BYTE12    0xffU
#define V_DTU_RD_BYTE12(x) ((x) << S_DTU_RD_BYTE12)
#define G_DTU_RD_BYTE12(x) (((x) >> S_DTU_RD_BYTE12) & M_DTU_RD_BYTE12)

#define A_MC_DTULFSRWD 0x6434
#define A_MC_PCTL_DTULFSRRD 0x6438
#define A_MC_PCTL_DTUEAF 0x643c

#define S_EA_RANK    30
#define M_EA_RANK    0x3U
#define V_EA_RANK(x) ((x) << S_EA_RANK)
#define G_EA_RANK(x) (((x) >> S_EA_RANK) & M_EA_RANK)

#define S_EA_ROW    13
#define M_EA_ROW    0x1ffffU
#define V_EA_ROW(x) ((x) << S_EA_ROW)
#define G_EA_ROW(x) (((x) >> S_EA_ROW) & M_EA_ROW)

#define S_EA_BANK    10
#define M_EA_BANK    0x7U
#define V_EA_BANK(x) ((x) << S_EA_BANK)
#define G_EA_BANK(x) (((x) >> S_EA_BANK) & M_EA_BANK)

#define S_EA_COLUMN    0
#define M_EA_COLUMN    0x3ffU
#define V_EA_COLUMN(x) ((x) << S_EA_COLUMN)
#define G_EA_COLUMN(x) (((x) >> S_EA_COLUMN) & M_EA_COLUMN)

#define A_MC_PCTL_PHYPVTCFG 0x6500

#define S_PVT_UPD_REQ_EN    15
#define V_PVT_UPD_REQ_EN(x) ((x) << S_PVT_UPD_REQ_EN)
#define F_PVT_UPD_REQ_EN    V_PVT_UPD_REQ_EN(1U)

#define S_PVT_UPD_TRIG_POL    14
#define V_PVT_UPD_TRIG_POL(x) ((x) << S_PVT_UPD_TRIG_POL)
#define F_PVT_UPD_TRIG_POL    V_PVT_UPD_TRIG_POL(1U)

#define S_PVT_UPD_TRIG_TYPE    12
#define V_PVT_UPD_TRIG_TYPE(x) ((x) << S_PVT_UPD_TRIG_TYPE)
#define F_PVT_UPD_TRIG_TYPE    V_PVT_UPD_TRIG_TYPE(1U)

#define S_PVT_UPD_DONE_POL    10
#define V_PVT_UPD_DONE_POL(x) ((x) << S_PVT_UPD_DONE_POL)
#define F_PVT_UPD_DONE_POL    V_PVT_UPD_DONE_POL(1U)

#define S_PVT_UPD_DONE_TYPE    8
#define M_PVT_UPD_DONE_TYPE    0x3U
#define V_PVT_UPD_DONE_TYPE(x) ((x) << S_PVT_UPD_DONE_TYPE)
#define G_PVT_UPD_DONE_TYPE(x) (((x) >> S_PVT_UPD_DONE_TYPE) & M_PVT_UPD_DONE_TYPE)

#define S_PHY_UPD_REQ_EN    7
#define V_PHY_UPD_REQ_EN(x) ((x) << S_PHY_UPD_REQ_EN)
#define F_PHY_UPD_REQ_EN    V_PHY_UPD_REQ_EN(1U)

#define S_PHY_UPD_TRIG_POL    6
#define V_PHY_UPD_TRIG_POL(x) ((x) << S_PHY_UPD_TRIG_POL)
#define F_PHY_UPD_TRIG_POL    V_PHY_UPD_TRIG_POL(1U)

#define S_PHY_UPD_TRIG_TYPE    4
#define V_PHY_UPD_TRIG_TYPE(x) ((x) << S_PHY_UPD_TRIG_TYPE)
#define F_PHY_UPD_TRIG_TYPE    V_PHY_UPD_TRIG_TYPE(1U)

#define S_PHY_UPD_DONE_POL    2
#define V_PHY_UPD_DONE_POL(x) ((x) << S_PHY_UPD_DONE_POL)
#define F_PHY_UPD_DONE_POL    V_PHY_UPD_DONE_POL(1U)

#define S_PHY_UPD_DONE_TYPE    0
#define M_PHY_UPD_DONE_TYPE    0x3U
#define V_PHY_UPD_DONE_TYPE(x) ((x) << S_PHY_UPD_DONE_TYPE)
#define G_PHY_UPD_DONE_TYPE(x) (((x) >> S_PHY_UPD_DONE_TYPE) & M_PHY_UPD_DONE_TYPE)

#define A_MC_PCTL_PHYPVTSTAT 0x6504

#define S_I_PVT_UPD_TRIG    5
#define V_I_PVT_UPD_TRIG(x) ((x) << S_I_PVT_UPD_TRIG)
#define F_I_PVT_UPD_TRIG    V_I_PVT_UPD_TRIG(1U)

#define S_I_PVT_UPD_DONE    4
#define V_I_PVT_UPD_DONE(x) ((x) << S_I_PVT_UPD_DONE)
#define F_I_PVT_UPD_DONE    V_I_PVT_UPD_DONE(1U)

#define S_I_PHY_UPD_TRIG    1
#define V_I_PHY_UPD_TRIG(x) ((x) << S_I_PHY_UPD_TRIG)
#define F_I_PHY_UPD_TRIG    V_I_PHY_UPD_TRIG(1U)

#define S_I_PHY_UPD_DONE    0
#define V_I_PHY_UPD_DONE(x) ((x) << S_I_PHY_UPD_DONE)
#define F_I_PHY_UPD_DONE    V_I_PHY_UPD_DONE(1U)

#define A_MC_PCTL_PHYTUPDON 0x6508

#define S_PHY_T_UPDON    0
#define M_PHY_T_UPDON    0xffU
#define V_PHY_T_UPDON(x) ((x) << S_PHY_T_UPDON)
#define G_PHY_T_UPDON(x) (((x) >> S_PHY_T_UPDON) & M_PHY_T_UPDON)

#define A_MC_PCTL_PHYTUPDDLY 0x650c

#define S_PHY_T_UPDDLY    0
#define M_PHY_T_UPDDLY    0xfU
#define V_PHY_T_UPDDLY(x) ((x) << S_PHY_T_UPDDLY)
#define G_PHY_T_UPDDLY(x) (((x) >> S_PHY_T_UPDDLY) & M_PHY_T_UPDDLY)

#define A_MC_PCTL_PVTTUPON 0x6510

#define S_PVT_T_UPDON    0
#define M_PVT_T_UPDON    0xffU
#define V_PVT_T_UPDON(x) ((x) << S_PVT_T_UPDON)
#define G_PVT_T_UPDON(x) (((x) >> S_PVT_T_UPDON) & M_PVT_T_UPDON)

#define A_MC_PCTL_PVTTUPDDLY 0x6514

#define S_PVT_T_UPDDLY    0
#define M_PVT_T_UPDDLY    0xfU
#define V_PVT_T_UPDDLY(x) ((x) << S_PVT_T_UPDDLY)
#define G_PVT_T_UPDDLY(x) (((x) >> S_PVT_T_UPDDLY) & M_PVT_T_UPDDLY)

#define A_MC_PCTL_PHYPVTUPDI 0x6518

#define S_PHYPVT_T_UPDI    0
#define M_PHYPVT_T_UPDI    0xffU
#define V_PHYPVT_T_UPDI(x) ((x) << S_PHYPVT_T_UPDI)
#define G_PHYPVT_T_UPDI(x) (((x) >> S_PHYPVT_T_UPDI) & M_PHYPVT_T_UPDI)

#define A_MC_PCTL_PHYIOCRV1 0x651c

#define S_BYTE_OE_CTL    16
#define M_BYTE_OE_CTL    0x3U
#define V_BYTE_OE_CTL(x) ((x) << S_BYTE_OE_CTL)
#define G_BYTE_OE_CTL(x) (((x) >> S_BYTE_OE_CTL) & M_BYTE_OE_CTL)

#define S_DYN_SOC_ODT_ALAT    12
#define M_DYN_SOC_ODT_ALAT    0xfU
#define V_DYN_SOC_ODT_ALAT(x) ((x) << S_DYN_SOC_ODT_ALAT)
#define G_DYN_SOC_ODT_ALAT(x) (((x) >> S_DYN_SOC_ODT_ALAT) & M_DYN_SOC_ODT_ALAT)

#define S_DYN_SOC_ODT_ATEN    8
#define M_DYN_SOC_ODT_ATEN    0x3U
#define V_DYN_SOC_ODT_ATEN(x) ((x) << S_DYN_SOC_ODT_ATEN)
#define G_DYN_SOC_ODT_ATEN(x) (((x) >> S_DYN_SOC_ODT_ATEN) & M_DYN_SOC_ODT_ATEN)

#define S_DYN_SOC_ODT    2
#define V_DYN_SOC_ODT(x) ((x) << S_DYN_SOC_ODT)
#define F_DYN_SOC_ODT    V_DYN_SOC_ODT(1U)

#define S_SOC_ODT_EN    0
#define V_SOC_ODT_EN(x) ((x) << S_SOC_ODT_EN)
#define F_SOC_ODT_EN    V_SOC_ODT_EN(1U)

#define A_MC_PCTL_PHYTUPDWAIT 0x6520

#define S_PHY_T_UPDWAIT    0
#define M_PHY_T_UPDWAIT    0x3fU
#define V_PHY_T_UPDWAIT(x) ((x) << S_PHY_T_UPDWAIT)
#define G_PHY_T_UPDWAIT(x) (((x) >> S_PHY_T_UPDWAIT) & M_PHY_T_UPDWAIT)

#define A_MC_PCTL_PVTTUPDWAIT 0x6524

#define S_PVT_T_UPDWAIT    0
#define M_PVT_T_UPDWAIT    0x3fU
#define V_PVT_T_UPDWAIT(x) ((x) << S_PVT_T_UPDWAIT)
#define G_PVT_T_UPDWAIT(x) (((x) >> S_PVT_T_UPDWAIT) & M_PVT_T_UPDWAIT)

#define A_MC_DDR3PHYAC_GCR 0x6a00

#define S_WLRANK    8
#define M_WLRANK    0x3U
#define V_WLRANK(x) ((x) << S_WLRANK)
#define G_WLRANK(x) (((x) >> S_WLRANK) & M_WLRANK)

#define S_FDEPTH    6
#define M_FDEPTH    0x3U
#define V_FDEPTH(x) ((x) << S_FDEPTH)
#define G_FDEPTH(x) (((x) >> S_FDEPTH) & M_FDEPTH)

#define S_LPFDEPTH    4
#define M_LPFDEPTH    0x3U
#define V_LPFDEPTH(x) ((x) << S_LPFDEPTH)
#define G_LPFDEPTH(x) (((x) >> S_LPFDEPTH) & M_LPFDEPTH)

#define S_LPFEN    3
#define V_LPFEN(x) ((x) << S_LPFEN)
#define F_LPFEN    V_LPFEN(1U)

#define S_WL    2
#define V_WL(x) ((x) << S_WL)
#define F_WL    V_WL(1U)

#define S_CAL    1
#define V_CAL(x) ((x) << S_CAL)
#define F_CAL    V_CAL(1U)

#define S_MDLEN    0
#define V_MDLEN(x) ((x) << S_MDLEN)
#define F_MDLEN    V_MDLEN(1U)

#define A_MC_DDR3PHYAC_RCR0 0x6a04

#define S_OCPONR    8
#define V_OCPONR(x) ((x) << S_OCPONR)
#define F_OCPONR    V_OCPONR(1U)

#define S_OCPOND    7
#define V_OCPOND(x) ((x) << S_OCPOND)
#define F_OCPOND    V_OCPOND(1U)

#define S_OCOEN    6
#define V_OCOEN(x) ((x) << S_OCOEN)
#define F_OCOEN    V_OCOEN(1U)

#define S_CKEPONR    5
#define V_CKEPONR(x) ((x) << S_CKEPONR)
#define F_CKEPONR    V_CKEPONR(1U)

#define S_CKEPOND    4
#define V_CKEPOND(x) ((x) << S_CKEPOND)
#define F_CKEPOND    V_CKEPOND(1U)

#define S_CKEOEN    3
#define V_CKEOEN(x) ((x) << S_CKEOEN)
#define F_CKEOEN    V_CKEOEN(1U)

#define S_CKPONR    2
#define V_CKPONR(x) ((x) << S_CKPONR)
#define F_CKPONR    V_CKPONR(1U)

#define S_CKPOND    1
#define V_CKPOND(x) ((x) << S_CKPOND)
#define F_CKPOND    V_CKPOND(1U)

#define S_CKOEN    0
#define V_CKOEN(x) ((x) << S_CKOEN)
#define F_CKOEN    V_CKOEN(1U)

#define A_MC_DDR3PHYAC_ACCR 0x6a14

#define S_ACPONR    8
#define V_ACPONR(x) ((x) << S_ACPONR)
#define F_ACPONR    V_ACPONR(1U)

#define S_ACPOND    7
#define V_ACPOND(x) ((x) << S_ACPOND)
#define F_ACPOND    V_ACPOND(1U)

#define S_ACOEN    6
#define V_ACOEN(x) ((x) << S_ACOEN)
#define F_ACOEN    V_ACOEN(1U)

#define S_CK5PONR    5
#define V_CK5PONR(x) ((x) << S_CK5PONR)
#define F_CK5PONR    V_CK5PONR(1U)

#define S_CK5POND    4
#define V_CK5POND(x) ((x) << S_CK5POND)
#define F_CK5POND    V_CK5POND(1U)

#define S_CK5OEN    3
#define V_CK5OEN(x) ((x) << S_CK5OEN)
#define F_CK5OEN    V_CK5OEN(1U)

#define S_CK4PONR    2
#define V_CK4PONR(x) ((x) << S_CK4PONR)
#define F_CK4PONR    V_CK4PONR(1U)

#define S_CK4POND    1
#define V_CK4POND(x) ((x) << S_CK4POND)
#define F_CK4POND    V_CK4POND(1U)

#define S_CK4OEN    0
#define V_CK4OEN(x) ((x) << S_CK4OEN)
#define F_CK4OEN    V_CK4OEN(1U)

#define A_MC_DDR3PHYAC_GSR 0x6a18

#define S_WLERR    4
#define V_WLERR(x) ((x) << S_WLERR)
#define F_WLERR    V_WLERR(1U)

#define S_INIT    3
#define V_INIT(x) ((x) << S_INIT)
#define F_INIT    V_INIT(1U)

#define S_ACCAL    0
#define V_ACCAL(x) ((x) << S_ACCAL)
#define F_ACCAL    V_ACCAL(1U)

#define A_MC_DDR3PHYAC_ECSR 0x6a1c

#define S_WLDEC    1
#define V_WLDEC(x) ((x) << S_WLDEC)
#define F_WLDEC    V_WLDEC(1U)

#define S_WLINC    0
#define V_WLINC(x) ((x) << S_WLINC)
#define F_WLINC    V_WLINC(1U)

#define A_MC_DDR3PHYAC_OCSR 0x6a20
#define A_MC_DDR3PHYAC_MDIPR 0x6a24

#define S_PRD    0
#define M_PRD    0x3ffU
#define V_PRD(x) ((x) << S_PRD)
#define G_PRD(x) (((x) >> S_PRD) & M_PRD)

#define A_MC_DDR3PHYAC_MDTPR 0x6a28
#define A_MC_DDR3PHYAC_MDPPR0 0x6a2c
#define A_MC_DDR3PHYAC_MDPPR1 0x6a30
#define A_MC_DDR3PHYAC_PMBDR0 0x6a34

#define S_DFLTDLY    0
#define M_DFLTDLY    0x7fU
#define V_DFLTDLY(x) ((x) << S_DFLTDLY)
#define G_DFLTDLY(x) (((x) >> S_DFLTDLY) & M_DFLTDLY)

#define A_MC_DDR3PHYAC_PMBDR1 0x6a38
#define A_MC_DDR3PHYAC_ACR 0x6a60

#define S_TSEL    9
#define V_TSEL(x) ((x) << S_TSEL)
#define F_TSEL    V_TSEL(1U)

#define S_ISEL    7
#define M_ISEL    0x3U
#define V_ISEL(x) ((x) << S_ISEL)
#define G_ISEL(x) (((x) >> S_ISEL) & M_ISEL)

#define S_CALBYP    2
#define V_CALBYP(x) ((x) << S_CALBYP)
#define F_CALBYP    V_CALBYP(1U)

#define S_SDRSELINV    1
#define V_SDRSELINV(x) ((x) << S_SDRSELINV)
#define F_SDRSELINV    V_SDRSELINV(1U)

#define S_CKINV    0
#define V_CKINV(x) ((x) << S_CKINV)
#define F_CKINV    V_CKINV(1U)

#define A_MC_DDR3PHYAC_PSCR 0x6a64

#define S_PSCALE    0
#define M_PSCALE    0x3ffU
#define V_PSCALE(x) ((x) << S_PSCALE)
#define G_PSCALE(x) (((x) >> S_PSCALE) & M_PSCALE)

#define A_MC_DDR3PHYAC_PRCR 0x6a68

#define S_PHYINIT    9
#define V_PHYINIT(x) ((x) << S_PHYINIT)
#define F_PHYINIT    V_PHYINIT(1U)

#define S_PHYHRST    7
#define V_PHYHRST(x) ((x) << S_PHYHRST)
#define F_PHYHRST    V_PHYHRST(1U)

#define S_RSTCLKS    3
#define M_RSTCLKS    0xfU
#define V_RSTCLKS(x) ((x) << S_RSTCLKS)
#define G_RSTCLKS(x) (((x) >> S_RSTCLKS) & M_RSTCLKS)

#define S_PLLPD    2
#define V_PLLPD(x) ((x) << S_PLLPD)
#define F_PLLPD    V_PLLPD(1U)

#define S_PLLRST    1
#define V_PLLRST(x) ((x) << S_PLLRST)
#define F_PLLRST    V_PLLRST(1U)

#define S_PHYRST    0
#define V_PHYRST(x) ((x) << S_PHYRST)
#define F_PHYRST    V_PHYRST(1U)

#define A_MC_DDR3PHYAC_PLLCR0 0x6a6c

#define S_RSTCXKS    4
#define M_RSTCXKS    0x1fU
#define V_RSTCXKS(x) ((x) << S_RSTCXKS)
#define G_RSTCXKS(x) (((x) >> S_RSTCXKS) & M_RSTCXKS)

#define S_ICPSEL    3
#define V_ICPSEL(x) ((x) << S_ICPSEL)
#define F_ICPSEL    V_ICPSEL(1U)

#define S_TESTA    0
#define M_TESTA    0x7U
#define V_TESTA(x) ((x) << S_TESTA)
#define G_TESTA(x) (((x) >> S_TESTA) & M_TESTA)

#define A_MC_DDR3PHYAC_PLLCR1 0x6a70

#define S_BYPASS    9
#define V_BYPASS(x) ((x) << S_BYPASS)
#define F_BYPASS    V_BYPASS(1U)

#define S_BDIV    3
#define M_BDIV    0x3U
#define V_BDIV(x) ((x) << S_BDIV)
#define G_BDIV(x) (((x) >> S_BDIV) & M_BDIV)

#define S_TESTD    0
#define M_TESTD    0x7U
#define V_TESTD(x) ((x) << S_TESTD)
#define G_TESTD(x) (((x) >> S_TESTD) & M_TESTD)

#define A_MC_DDR3PHYAC_CLKENR 0x6a78

#define S_CKCLKEN    3
#define M_CKCLKEN    0x3fU
#define V_CKCLKEN(x) ((x) << S_CKCLKEN)
#define G_CKCLKEN(x) (((x) >> S_CKCLKEN) & M_CKCLKEN)

#define S_HDRCLKEN    2
#define V_HDRCLKEN(x) ((x) << S_HDRCLKEN)
#define F_HDRCLKEN    V_HDRCLKEN(1U)

#define S_SDRCLKEN    1
#define V_SDRCLKEN(x) ((x) << S_SDRCLKEN)
#define F_SDRCLKEN    V_SDRCLKEN(1U)

#define S_DDRCLKEN    0
#define V_DDRCLKEN(x) ((x) << S_DDRCLKEN)
#define F_DDRCLKEN    V_DDRCLKEN(1U)

#define A_MC_DDR3PHYDATX8_GCR 0x6b00

#define S_PONR    6
#define V_PONR(x) ((x) << S_PONR)
#define F_PONR    V_PONR(1U)

#define S_POND    5
#define V_POND(x) ((x) << S_POND)
#define F_POND    V_POND(1U)

#define S_RDBDVT    4
#define V_RDBDVT(x) ((x) << S_RDBDVT)
#define F_RDBDVT    V_RDBDVT(1U)

#define S_WDBDVT    3
#define V_WDBDVT(x) ((x) << S_WDBDVT)
#define F_WDBDVT    V_WDBDVT(1U)

#define S_RDSDVT    2
#define V_RDSDVT(x) ((x) << S_RDSDVT)
#define F_RDSDVT    V_RDSDVT(1U)

#define S_WDSDVT    1
#define V_WDSDVT(x) ((x) << S_WDSDVT)
#define F_WDSDVT    V_WDSDVT(1U)

#define S_WLSDVT    0
#define V_WLSDVT(x) ((x) << S_WLSDVT)
#define F_WLSDVT    V_WLSDVT(1U)

#define A_MC_DDR3PHYDATX8_WDSDR 0x6b04

#define S_WDSDR_DLY    0
#define M_WDSDR_DLY    0x3ffU
#define V_WDSDR_DLY(x) ((x) << S_WDSDR_DLY)
#define G_WDSDR_DLY(x) (((x) >> S_WDSDR_DLY) & M_WDSDR_DLY)

#define A_MC_DDR3PHYDATX8_WLDPR 0x6b08
#define A_MC_DDR3PHYDATX8_WLDR 0x6b0c

#define S_WL_DLY    0
#define M_WL_DLY    0x3ffU
#define V_WL_DLY(x) ((x) << S_WL_DLY)
#define G_WL_DLY(x) (((x) >> S_WL_DLY) & M_WL_DLY)

#define A_MC_DDR3PHYDATX8_WDBDR0 0x6b1c

#define S_DLY    0
#define M_DLY    0x7fU
#define V_DLY(x) ((x) << S_DLY)
#define G_DLY(x) (((x) >> S_DLY) & M_DLY)

#define A_MC_DDR3PHYDATX8_WDBDR1 0x6b20
#define A_MC_DDR3PHYDATX8_WDBDR2 0x6b24
#define A_MC_DDR3PHYDATX8_WDBDR3 0x6b28
#define A_MC_DDR3PHYDATX8_WDBDR4 0x6b2c
#define A_MC_DDR3PHYDATX8_WDBDR5 0x6b30
#define A_MC_DDR3PHYDATX8_WDBDR6 0x6b34
#define A_MC_DDR3PHYDATX8_WDBDR7 0x6b38
#define A_MC_DDR3PHYDATX8_WDBDR8 0x6b3c
#define A_MC_DDR3PHYDATX8_WDBDMR 0x6b40

#define S_MAXDLY    0
#define M_MAXDLY    0x7fU
#define V_MAXDLY(x) ((x) << S_MAXDLY)
#define G_MAXDLY(x) (((x) >> S_MAXDLY) & M_MAXDLY)

#define A_MC_DDR3PHYDATX8_RDSDR 0x6b44

#define S_RDSDR_DLY    0
#define M_RDSDR_DLY    0x3ffU
#define V_RDSDR_DLY(x) ((x) << S_RDSDR_DLY)
#define G_RDSDR_DLY(x) (((x) >> S_RDSDR_DLY) & M_RDSDR_DLY)

#define A_MC_DDR3PHYDATX8_RDBDR0 0x6b48
#define A_MC_DDR3PHYDATX8_RDBDR1 0x6b4c
#define A_MC_DDR3PHYDATX8_RDBDR2 0x6b50
#define A_MC_DDR3PHYDATX8_RDBDR3 0x6b54
#define A_MC_DDR3PHYDATX8_RDBDR4 0x6b58
#define A_MC_DDR3PHYDATX8_RDBDR5 0x6b5c
#define A_MC_DDR3PHYDATX8_RDBDR6 0x6b60
#define A_MC_DDR3PHYDATX8_RDBDR7 0x6b64
#define A_MC_DDR3PHYDATX8_RDBDMR 0x6b68
#define A_MC_DDR3PHYDATX8_PMBDR0 0x6b6c
#define A_MC_DDR3PHYDATX8_PMBDR1 0x6b70
#define A_MC_DDR3PHYDATX8_PMBDR2 0x6b74
#define A_MC_DDR3PHYDATX8_PMBDR3 0x6b78
#define A_MC_DDR3PHYDATX8_WDBDPR 0x6b7c

#define S_DP_DLY    0
#define M_DP_DLY    0x1ffU
#define V_DP_DLY(x) ((x) << S_DP_DLY)
#define G_DP_DLY(x) (((x) >> S_DP_DLY) & M_DP_DLY)

#define A_MC_DDR3PHYDATX8_RDBDPR 0x6b80
#define A_MC_DDR3PHYDATX8_GSR 0x6b84

#define S_WLDONE    3
#define V_WLDONE(x) ((x) << S_WLDONE)
#define F_WLDONE    V_WLDONE(1U)

#define S_WLCAL    2
#define V_WLCAL(x) ((x) << S_WLCAL)
#define F_WLCAL    V_WLCAL(1U)

#define S_READ    1
#define V_READ(x) ((x) << S_READ)
#define F_READ    V_READ(1U)

#define S_RDQSCAL    0
#define V_RDQSCAL(x) ((x) << S_RDQSCAL)
#define F_RDQSCAL    V_RDQSCAL(1U)

#define A_MC_DDR3PHYDATX8_ACR 0x6bf0

#define S_PHYHSRST    9
#define V_PHYHSRST(x) ((x) << S_PHYHSRST)
#define F_PHYHSRST    V_PHYHSRST(1U)

#define S_WLSTEP    8
#define V_WLSTEP(x) ((x) << S_WLSTEP)
#define F_WLSTEP    V_WLSTEP(1U)

#define S_SDR_SEL_INV    2
#define V_SDR_SEL_INV(x) ((x) << S_SDR_SEL_INV)
#define F_SDR_SEL_INV    V_SDR_SEL_INV(1U)

#define S_DDRSELINV    1
#define V_DDRSELINV(x) ((x) << S_DDRSELINV)
#define F_DDRSELINV    V_DDRSELINV(1U)

#define S_DSINV    0
#define V_DSINV(x) ((x) << S_DSINV)
#define F_DSINV    V_DSINV(1U)

#define A_MC_DDR3PHYDATX8_RSR 0x6bf4

#define S_WLRANKSEL    9
#define V_WLRANKSEL(x) ((x) << S_WLRANKSEL)
#define F_WLRANKSEL    V_WLRANKSEL(1U)

#define S_RANK    0
#define M_RANK    0x3U
#define V_RANK(x) ((x) << S_RANK)
#define G_RANK(x) (((x) >> S_RANK) & M_RANK)

#define A_MC_DDR3PHYDATX8_CLKENR 0x6bf8

#define S_DTOSEL    8
#define M_DTOSEL    0x3U
#define V_DTOSEL(x) ((x) << S_DTOSEL)
#define G_DTOSEL(x) (((x) >> S_DTOSEL) & M_DTOSEL)

#define A_MC_PVT_REG_CALIBRATE_CTL 0x7400
#define A_MC_PVT_REG_UPDATE_CTL 0x7404
#define A_MC_PVT_REG_LAST_MEASUREMENT 0x7408
#define A_MC_PVT_REG_DRVN 0x740c
#define A_MC_PVT_REG_DRVP 0x7410
#define A_MC_PVT_REG_TERMN 0x7414
#define A_MC_PVT_REG_TERMP 0x7418
#define A_MC_PVT_REG_THRESHOLD 0x741c
#define A_MC_PVT_REG_IN_TERMP 0x7420
#define A_MC_PVT_REG_IN_TERMN 0x7424
#define A_MC_PVT_REG_IN_DRVP 0x7428
#define A_MC_PVT_REG_IN_DRVN 0x742c
#define A_MC_PVT_REG_OUT_TERMP 0x7430
#define A_MC_PVT_REG_OUT_TERMN 0x7434
#define A_MC_PVT_REG_OUT_DRVP 0x7438
#define A_MC_PVT_REG_OUT_DRVN 0x743c
#define A_MC_PVT_REG_HISTORY_TERMP 0x7440
#define A_MC_PVT_REG_HISTORY_TERMN 0x7444
#define A_MC_PVT_REG_HISTORY_DRVP 0x7448
#define A_MC_PVT_REG_HISTORY_DRVN 0x744c
#define A_MC_PVT_REG_SAMPLE_WAIT_CLKS 0x7450
#define A_MC_DDRPHY_RST_CTRL 0x7500

#define S_DDRIO_ENABLE    1
#define V_DDRIO_ENABLE(x) ((x) << S_DDRIO_ENABLE)
#define F_DDRIO_ENABLE    V_DDRIO_ENABLE(1U)

#define S_PHY_RST_N    0
#define V_PHY_RST_N(x) ((x) << S_PHY_RST_N)
#define F_PHY_RST_N    V_PHY_RST_N(1U)

#define A_MC_PERFORMANCE_CTRL 0x7504

#define S_STALL_CHK_BIT    2
#define V_STALL_CHK_BIT(x) ((x) << S_STALL_CHK_BIT)
#define F_STALL_CHK_BIT    V_STALL_CHK_BIT(1U)

#define S_DDR3_BRC_MODE    1
#define V_DDR3_BRC_MODE(x) ((x) << S_DDR3_BRC_MODE)
#define F_DDR3_BRC_MODE    V_DDR3_BRC_MODE(1U)

#define S_RMW_PERF_CTRL    0
#define V_RMW_PERF_CTRL(x) ((x) << S_RMW_PERF_CTRL)
#define F_RMW_PERF_CTRL    V_RMW_PERF_CTRL(1U)

#define A_MC_ECC_CTRL 0x7508

#define S_ECC_BYPASS_BIST    1
#define V_ECC_BYPASS_BIST(x) ((x) << S_ECC_BYPASS_BIST)
#define F_ECC_BYPASS_BIST    V_ECC_BYPASS_BIST(1U)

#define S_ECC_DISABLE    0
#define V_ECC_DISABLE(x) ((x) << S_ECC_DISABLE)
#define F_ECC_DISABLE    V_ECC_DISABLE(1U)

#define A_MC_PAR_ENABLE 0x750c

#define S_ECC_UE_PAR_ENABLE    3
#define V_ECC_UE_PAR_ENABLE(x) ((x) << S_ECC_UE_PAR_ENABLE)
#define F_ECC_UE_PAR_ENABLE    V_ECC_UE_PAR_ENABLE(1U)

#define S_ECC_CE_PAR_ENABLE    2
#define V_ECC_CE_PAR_ENABLE(x) ((x) << S_ECC_CE_PAR_ENABLE)
#define F_ECC_CE_PAR_ENABLE    V_ECC_CE_PAR_ENABLE(1U)

#define S_PERR_REG_INT_ENABLE    1
#define V_PERR_REG_INT_ENABLE(x) ((x) << S_PERR_REG_INT_ENABLE)
#define F_PERR_REG_INT_ENABLE    V_PERR_REG_INT_ENABLE(1U)

#define S_PERR_BLK_INT_ENABLE    0
#define V_PERR_BLK_INT_ENABLE(x) ((x) << S_PERR_BLK_INT_ENABLE)
#define F_PERR_BLK_INT_ENABLE    V_PERR_BLK_INT_ENABLE(1U)

#define A_MC_PAR_CAUSE 0x7510

#define S_ECC_UE_PAR_CAUSE    3
#define V_ECC_UE_PAR_CAUSE(x) ((x) << S_ECC_UE_PAR_CAUSE)
#define F_ECC_UE_PAR_CAUSE    V_ECC_UE_PAR_CAUSE(1U)

#define S_ECC_CE_PAR_CAUSE    2
#define V_ECC_CE_PAR_CAUSE(x) ((x) << S_ECC_CE_PAR_CAUSE)
#define F_ECC_CE_PAR_CAUSE    V_ECC_CE_PAR_CAUSE(1U)

#define S_FIFOR_PAR_CAUSE    1
#define V_FIFOR_PAR_CAUSE(x) ((x) << S_FIFOR_PAR_CAUSE)
#define F_FIFOR_PAR_CAUSE    V_FIFOR_PAR_CAUSE(1U)

#define S_RDATA_FIFOR_PAR_CAUSE    0
#define V_RDATA_FIFOR_PAR_CAUSE(x) ((x) << S_RDATA_FIFOR_PAR_CAUSE)
#define F_RDATA_FIFOR_PAR_CAUSE    V_RDATA_FIFOR_PAR_CAUSE(1U)

#define A_MC_INT_ENABLE 0x7514

#define S_ECC_UE_INT_ENABLE    2
#define V_ECC_UE_INT_ENABLE(x) ((x) << S_ECC_UE_INT_ENABLE)
#define F_ECC_UE_INT_ENABLE    V_ECC_UE_INT_ENABLE(1U)

#define S_ECC_CE_INT_ENABLE    1
#define V_ECC_CE_INT_ENABLE(x) ((x) << S_ECC_CE_INT_ENABLE)
#define F_ECC_CE_INT_ENABLE    V_ECC_CE_INT_ENABLE(1U)

#define S_PERR_INT_ENABLE    0
#define V_PERR_INT_ENABLE(x) ((x) << S_PERR_INT_ENABLE)
#define F_PERR_INT_ENABLE    V_PERR_INT_ENABLE(1U)

#define A_MC_INT_CAUSE 0x7518

#define S_ECC_UE_INT_CAUSE    2
#define V_ECC_UE_INT_CAUSE(x) ((x) << S_ECC_UE_INT_CAUSE)
#define F_ECC_UE_INT_CAUSE    V_ECC_UE_INT_CAUSE(1U)

#define S_ECC_CE_INT_CAUSE    1
#define V_ECC_CE_INT_CAUSE(x) ((x) << S_ECC_CE_INT_CAUSE)
#define F_ECC_CE_INT_CAUSE    V_ECC_CE_INT_CAUSE(1U)

#define S_PERR_INT_CAUSE    0
#define V_PERR_INT_CAUSE(x) ((x) << S_PERR_INT_CAUSE)
#define F_PERR_INT_CAUSE    V_PERR_INT_CAUSE(1U)

#define A_MC_ECC_STATUS 0x751c

#define S_ECC_CECNT    16
#define M_ECC_CECNT    0xffffU
#define V_ECC_CECNT(x) ((x) << S_ECC_CECNT)
#define G_ECC_CECNT(x) (((x) >> S_ECC_CECNT) & M_ECC_CECNT)

#define S_ECC_UECNT    0
#define M_ECC_UECNT    0xffffU
#define V_ECC_UECNT(x) ((x) << S_ECC_UECNT)
#define G_ECC_UECNT(x) (((x) >> S_ECC_UECNT) & M_ECC_UECNT)

#define A_MC_PHY_CTRL 0x7520

#define S_CTLPHYRR    0
#define V_CTLPHYRR(x) ((x) << S_CTLPHYRR)
#define F_CTLPHYRR    V_CTLPHYRR(1U)

#define A_MC_STATIC_CFG_STATUS 0x7524

#define S_STATIC_MODE    9
#define V_STATIC_MODE(x) ((x) << S_STATIC_MODE)
#define F_STATIC_MODE    V_STATIC_MODE(1U)

#define S_STATIC_DEN    6
#define M_STATIC_DEN    0x7U
#define V_STATIC_DEN(x) ((x) << S_STATIC_DEN)
#define G_STATIC_DEN(x) (((x) >> S_STATIC_DEN) & M_STATIC_DEN)

#define S_STATIC_ORG    5
#define V_STATIC_ORG(x) ((x) << S_STATIC_ORG)
#define F_STATIC_ORG    V_STATIC_ORG(1U)

#define S_STATIC_RKS    4
#define V_STATIC_RKS(x) ((x) << S_STATIC_RKS)
#define F_STATIC_RKS    V_STATIC_RKS(1U)

#define S_STATIC_WIDTH    1
#define M_STATIC_WIDTH    0x7U
#define V_STATIC_WIDTH(x) ((x) << S_STATIC_WIDTH)
#define G_STATIC_WIDTH(x) (((x) >> S_STATIC_WIDTH) & M_STATIC_WIDTH)

#define S_STATIC_SLOW    0
#define V_STATIC_SLOW(x) ((x) << S_STATIC_SLOW)
#define F_STATIC_SLOW    V_STATIC_SLOW(1U)

#define A_MC_CORE_PCTL_STAT 0x7528

#define S_PCTL_ACCESS_STAT    0
#define M_PCTL_ACCESS_STAT    0x7U
#define V_PCTL_ACCESS_STAT(x) ((x) << S_PCTL_ACCESS_STAT)
#define G_PCTL_ACCESS_STAT(x) (((x) >> S_PCTL_ACCESS_STAT) & M_PCTL_ACCESS_STAT)

#define A_MC_DEBUG_CNT 0x752c

#define S_WDATA_OCNT    8
#define M_WDATA_OCNT    0x1fU
#define V_WDATA_OCNT(x) ((x) << S_WDATA_OCNT)
#define G_WDATA_OCNT(x) (((x) >> S_WDATA_OCNT) & M_WDATA_OCNT)

#define S_RDATA_OCNT    0
#define M_RDATA_OCNT    0x1fU
#define V_RDATA_OCNT(x) ((x) << S_RDATA_OCNT)
#define G_RDATA_OCNT(x) (((x) >> S_RDATA_OCNT) & M_RDATA_OCNT)

#define A_MC_BONUS 0x7530
#define A_MC_BIST_CMD 0x7600

#define S_START_BIST    31
#define V_START_BIST(x) ((x) << S_START_BIST)
#define F_START_BIST    V_START_BIST(1U)

#define S_BIST_CMD_GAP    8
#define M_BIST_CMD_GAP    0xffU
#define V_BIST_CMD_GAP(x) ((x) << S_BIST_CMD_GAP)
#define G_BIST_CMD_GAP(x) (((x) >> S_BIST_CMD_GAP) & M_BIST_CMD_GAP)

#define S_BIST_OPCODE    0
#define M_BIST_OPCODE    0x3U
#define V_BIST_OPCODE(x) ((x) << S_BIST_OPCODE)
#define G_BIST_OPCODE(x) (((x) >> S_BIST_OPCODE) & M_BIST_OPCODE)

#define A_MC_BIST_CMD_ADDR 0x7604
#define A_MC_BIST_CMD_LEN 0x7608
#define A_MC_BIST_DATA_PATTERN 0x760c

#define S_BIST_DATA_TYPE    0
#define M_BIST_DATA_TYPE    0xfU
#define V_BIST_DATA_TYPE(x) ((x) << S_BIST_DATA_TYPE)
#define G_BIST_DATA_TYPE(x) (((x) >> S_BIST_DATA_TYPE) & M_BIST_DATA_TYPE)

#define A_MC_BIST_USER_WDATA0 0x7614
#define A_MC_BIST_USER_WDATA1 0x7618
#define A_MC_BIST_USER_WDATA2 0x761c

#define S_USER_DATA2    0
#define M_USER_DATA2    0xffU
#define V_USER_DATA2(x) ((x) << S_USER_DATA2)
#define G_USER_DATA2(x) (((x) >> S_USER_DATA2) & M_USER_DATA2)

#define A_MC_BIST_NUM_ERR 0x7680
#define A_MC_BIST_ERR_FIRST_ADDR 0x7684
#define A_MC_BIST_STATUS_RDATA 0x7688

/* registers for module MA */
#define MA_BASE_ADDR 0x7700

#define A_MA_CLIENT0_RD_LATENCY_THRESHOLD 0x7700

#define S_THRESHOLD1    17
#define M_THRESHOLD1    0x7fffU
#define V_THRESHOLD1(x) ((x) << S_THRESHOLD1)
#define G_THRESHOLD1(x) (((x) >> S_THRESHOLD1) & M_THRESHOLD1)

#define S_THRESHOLD1_EN    16
#define V_THRESHOLD1_EN(x) ((x) << S_THRESHOLD1_EN)
#define F_THRESHOLD1_EN    V_THRESHOLD1_EN(1U)

#define S_THRESHOLD0    1
#define M_THRESHOLD0    0x7fffU
#define V_THRESHOLD0(x) ((x) << S_THRESHOLD0)
#define G_THRESHOLD0(x) (((x) >> S_THRESHOLD0) & M_THRESHOLD0)

#define S_THRESHOLD0_EN    0
#define V_THRESHOLD0_EN(x) ((x) << S_THRESHOLD0_EN)
#define F_THRESHOLD0_EN    V_THRESHOLD0_EN(1U)

#define A_MA_CLIENT0_PR_THRESHOLD 0x7700

#define S_T7_THRESHOLD1_EN    31
#define V_T7_THRESHOLD1_EN(x) ((x) << S_T7_THRESHOLD1_EN)
#define F_T7_THRESHOLD1_EN    V_T7_THRESHOLD1_EN(1U)

#define S_T7_THRESHOLD1    16
#define M_T7_THRESHOLD1    0x7fffU
#define V_T7_THRESHOLD1(x) ((x) << S_T7_THRESHOLD1)
#define G_T7_THRESHOLD1(x) (((x) >> S_T7_THRESHOLD1) & M_T7_THRESHOLD1)

#define S_T7_THRESHOLD0_EN    15
#define V_T7_THRESHOLD0_EN(x) ((x) << S_T7_THRESHOLD0_EN)
#define F_T7_THRESHOLD0_EN    V_T7_THRESHOLD0_EN(1U)

#define S_T7_THRESHOLD0    0
#define M_T7_THRESHOLD0    0x7fffU
#define V_T7_THRESHOLD0(x) ((x) << S_T7_THRESHOLD0)
#define G_T7_THRESHOLD0(x) (((x) >> S_T7_THRESHOLD0) & M_T7_THRESHOLD0)

#define A_MA_CLIENT0_WR_LATENCY_THRESHOLD 0x7704
#define A_MA_CLIENT0_CR_THRESHOLD 0x7704

#define S_CREDITSHAPER_EN    31
#define V_CREDITSHAPER_EN(x) ((x) << S_CREDITSHAPER_EN)
#define F_CREDITSHAPER_EN    V_CREDITSHAPER_EN(1U)

#define S_CREDIT_MAX    16
#define M_CREDIT_MAX    0xfffU
#define V_CREDIT_MAX(x) ((x) << S_CREDIT_MAX)
#define G_CREDIT_MAX(x) (((x) >> S_CREDIT_MAX) & M_CREDIT_MAX)

#define S_CREDIT_VAL    0
#define M_CREDIT_VAL    0xfffU
#define V_CREDIT_VAL(x) ((x) << S_CREDIT_VAL)
#define G_CREDIT_VAL(x) (((x) >> S_CREDIT_VAL) & M_CREDIT_VAL)

#define A_MA_CLIENT1_RD_LATENCY_THRESHOLD 0x7708
#define A_MA_CLIENT1_PR_THRESHOLD 0x7708
#define A_MA_CLIENT1_WR_LATENCY_THRESHOLD 0x770c
#define A_MA_CLIENT1_CR_THRESHOLD 0x770c
#define A_MA_CLIENT2_RD_LATENCY_THRESHOLD 0x7710
#define A_MA_CLIENT2_PR_THRESHOLD 0x7710
#define A_MA_CLIENT2_WR_LATENCY_THRESHOLD 0x7714
#define A_MA_CLIENT2_CR_THRESHOLD 0x7714
#define A_MA_CLIENT3_RD_LATENCY_THRESHOLD 0x7718
#define A_MA_CLIENT3_PR_THRESHOLD 0x7718
#define A_MA_CLIENT3_WR_LATENCY_THRESHOLD 0x771c
#define A_MA_CLIENT3_CR_THRESHOLD 0x771c
#define A_MA_CLIENT4_RD_LATENCY_THRESHOLD 0x7720
#define A_MA_CLIENT4_PR_THRESHOLD 0x7720
#define A_MA_CLIENT4_WR_LATENCY_THRESHOLD 0x7724
#define A_MA_CLIENT4_CR_THRESHOLD 0x7724
#define A_MA_CLIENT5_RD_LATENCY_THRESHOLD 0x7728
#define A_MA_CLIENT5_PR_THRESHOLD 0x7728
#define A_MA_CLIENT5_WR_LATENCY_THRESHOLD 0x772c
#define A_MA_CLIENT5_CR_THRESHOLD 0x772c
#define A_MA_CLIENT6_RD_LATENCY_THRESHOLD 0x7730
#define A_MA_CLIENT6_PR_THRESHOLD 0x7730
#define A_MA_CLIENT6_WR_LATENCY_THRESHOLD 0x7734
#define A_MA_CLIENT6_CR_THRESHOLD 0x7734
#define A_MA_CLIENT7_RD_LATENCY_THRESHOLD 0x7738
#define A_MA_CLIENT7_PR_THRESHOLD 0x7738
#define A_MA_CLIENT7_WR_LATENCY_THRESHOLD 0x773c
#define A_MA_CLIENT7_CR_THRESHOLD 0x773c
#define A_MA_CLIENT8_RD_LATENCY_THRESHOLD 0x7740
#define A_MA_CLIENT8_PR_THRESHOLD 0x7740
#define A_MA_CLIENT8_WR_LATENCY_THRESHOLD 0x7744
#define A_MA_CLIENT8_CR_THRESHOLD 0x7744
#define A_MA_CLIENT9_RD_LATENCY_THRESHOLD 0x7748
#define A_MA_CLIENT9_PR_THRESHOLD 0x7748
#define A_MA_CLIENT9_WR_LATENCY_THRESHOLD 0x774c
#define A_MA_CLIENT9_CR_THRESHOLD 0x774c
#define A_MA_CLIENT10_RD_LATENCY_THRESHOLD 0x7750
#define A_MA_CLIENT10_PR_THRESHOLD 0x7750
#define A_MA_CLIENT10_WR_LATENCY_THRESHOLD 0x7754
#define A_MA_CLIENT10_CR_THRESHOLD 0x7754
#define A_MA_CLIENT11_RD_LATENCY_THRESHOLD 0x7758
#define A_MA_CLIENT11_PR_THRESHOLD 0x7758
#define A_MA_CLIENT11_WR_LATENCY_THRESHOLD 0x775c
#define A_MA_CLIENT11_CR_THRESHOLD 0x775c
#define A_MA_CLIENT12_RD_LATENCY_THRESHOLD 0x7760
#define A_MA_CLIENT12_PR_THRESHOLD 0x7760
#define A_MA_CLIENT12_WR_LATENCY_THRESHOLD 0x7764
#define A_MA_CLIENT12_CR_THRESHOLD 0x7764
#define A_MA_SGE_TH0_DEBUG_CNT 0x7768

#define S_DBG_READ_DATA_CNT    24
#define M_DBG_READ_DATA_CNT    0xffU
#define V_DBG_READ_DATA_CNT(x) ((x) << S_DBG_READ_DATA_CNT)
#define G_DBG_READ_DATA_CNT(x) (((x) >> S_DBG_READ_DATA_CNT) & M_DBG_READ_DATA_CNT)

#define S_DBG_READ_REQ_CNT    16
#define M_DBG_READ_REQ_CNT    0xffU
#define V_DBG_READ_REQ_CNT(x) ((x) << S_DBG_READ_REQ_CNT)
#define G_DBG_READ_REQ_CNT(x) (((x) >> S_DBG_READ_REQ_CNT) & M_DBG_READ_REQ_CNT)

#define S_DBG_WRITE_DATA_CNT    8
#define M_DBG_WRITE_DATA_CNT    0xffU
#define V_DBG_WRITE_DATA_CNT(x) ((x) << S_DBG_WRITE_DATA_CNT)
#define G_DBG_WRITE_DATA_CNT(x) (((x) >> S_DBG_WRITE_DATA_CNT) & M_DBG_WRITE_DATA_CNT)

#define S_DBG_WRITE_REQ_CNT    0
#define M_DBG_WRITE_REQ_CNT    0xffU
#define V_DBG_WRITE_REQ_CNT(x) ((x) << S_DBG_WRITE_REQ_CNT)
#define G_DBG_WRITE_REQ_CNT(x) (((x) >> S_DBG_WRITE_REQ_CNT) & M_DBG_WRITE_REQ_CNT)

#define A_MA_SGE_TH1_DEBUG_CNT 0x776c
#define A_MA_ULPTX_DEBUG_CNT 0x7770
#define A_MA_ULPRX_DEBUG_CNT 0x7774
#define A_MA_ULPTXRX_DEBUG_CNT 0x7778
#define A_MA_TP_TH0_DEBUG_CNT 0x777c
#define A_MA_TP_TH1_DEBUG_CNT 0x7780
#define A_MA_LE_DEBUG_CNT 0x7784
#define A_MA_CIM_DEBUG_CNT 0x7788
#define A_MA_CIM_TH0_DEBUG_CNT 0x7788
#define A_MA_PCIE_DEBUG_CNT 0x778c
#define A_MA_PMTX_DEBUG_CNT 0x7790
#define A_MA_PMRX_DEBUG_CNT 0x7794
#define A_MA_HMA_DEBUG_CNT 0x7798
#define A_MA_COR_ERROR_ENABLE1 0x779c

#define S_ARB4_COR_WRQUEUE_ERROR_EN    9
#define V_ARB4_COR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB4_COR_WRQUEUE_ERROR_EN)
#define F_ARB4_COR_WRQUEUE_ERROR_EN    V_ARB4_COR_WRQUEUE_ERROR_EN(1U)

#define S_ARB3_COR_WRQUEUE_ERROR_EN    8
#define V_ARB3_COR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB3_COR_WRQUEUE_ERROR_EN)
#define F_ARB3_COR_WRQUEUE_ERROR_EN    V_ARB3_COR_WRQUEUE_ERROR_EN(1U)

#define S_ARB2_COR_WRQUEUE_ERROR_EN    7
#define V_ARB2_COR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB2_COR_WRQUEUE_ERROR_EN)
#define F_ARB2_COR_WRQUEUE_ERROR_EN    V_ARB2_COR_WRQUEUE_ERROR_EN(1U)

#define S_ARB1_COR_WRQUEUE_ERROR_EN    6
#define V_ARB1_COR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB1_COR_WRQUEUE_ERROR_EN)
#define F_ARB1_COR_WRQUEUE_ERROR_EN    V_ARB1_COR_WRQUEUE_ERROR_EN(1U)

#define S_ARB0_COR_WRQUEUE_ERROR_EN    5
#define V_ARB0_COR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB0_COR_WRQUEUE_ERROR_EN)
#define F_ARB0_COR_WRQUEUE_ERROR_EN    V_ARB0_COR_WRQUEUE_ERROR_EN(1U)

#define S_ARB4_COR_RDQUEUE_ERROR_EN    4
#define V_ARB4_COR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB4_COR_RDQUEUE_ERROR_EN)
#define F_ARB4_COR_RDQUEUE_ERROR_EN    V_ARB4_COR_RDQUEUE_ERROR_EN(1U)

#define S_ARB3_COR_RDQUEUE_ERROR_EN    3
#define V_ARB3_COR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB3_COR_RDQUEUE_ERROR_EN)
#define F_ARB3_COR_RDQUEUE_ERROR_EN    V_ARB3_COR_RDQUEUE_ERROR_EN(1U)

#define S_ARB2_COR_RDQUEUE_ERROR_EN    2
#define V_ARB2_COR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB2_COR_RDQUEUE_ERROR_EN)
#define F_ARB2_COR_RDQUEUE_ERROR_EN    V_ARB2_COR_RDQUEUE_ERROR_EN(1U)

#define S_ARB1_COR_RDQUEUE_ERROR_EN    1
#define V_ARB1_COR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB1_COR_RDQUEUE_ERROR_EN)
#define F_ARB1_COR_RDQUEUE_ERROR_EN    V_ARB1_COR_RDQUEUE_ERROR_EN(1U)

#define S_ARB0_COR_RDQUEUE_ERROR_EN    0
#define V_ARB0_COR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB0_COR_RDQUEUE_ERROR_EN)
#define F_ARB0_COR_RDQUEUE_ERROR_EN    V_ARB0_COR_RDQUEUE_ERROR_EN(1U)

#define A_MA_COR_ERROR_STATUS1 0x77a0

#define S_ARB4_COR_WRQUEUE_ERROR    9
#define V_ARB4_COR_WRQUEUE_ERROR(x) ((x) << S_ARB4_COR_WRQUEUE_ERROR)
#define F_ARB4_COR_WRQUEUE_ERROR    V_ARB4_COR_WRQUEUE_ERROR(1U)

#define S_ARB3_COR_WRQUEUE_ERROR    8
#define V_ARB3_COR_WRQUEUE_ERROR(x) ((x) << S_ARB3_COR_WRQUEUE_ERROR)
#define F_ARB3_COR_WRQUEUE_ERROR    V_ARB3_COR_WRQUEUE_ERROR(1U)

#define S_ARB2_COR_WRQUEUE_ERROR    7
#define V_ARB2_COR_WRQUEUE_ERROR(x) ((x) << S_ARB2_COR_WRQUEUE_ERROR)
#define F_ARB2_COR_WRQUEUE_ERROR    V_ARB2_COR_WRQUEUE_ERROR(1U)

#define S_ARB1_COR_WRQUEUE_ERROR    6
#define V_ARB1_COR_WRQUEUE_ERROR(x) ((x) << S_ARB1_COR_WRQUEUE_ERROR)
#define F_ARB1_COR_WRQUEUE_ERROR    V_ARB1_COR_WRQUEUE_ERROR(1U)

#define S_ARB0_COR_WRQUEUE_ERROR    5
#define V_ARB0_COR_WRQUEUE_ERROR(x) ((x) << S_ARB0_COR_WRQUEUE_ERROR)
#define F_ARB0_COR_WRQUEUE_ERROR    V_ARB0_COR_WRQUEUE_ERROR(1U)

#define S_ARB4_COR_RDQUEUE_ERROR    4
#define V_ARB4_COR_RDQUEUE_ERROR(x) ((x) << S_ARB4_COR_RDQUEUE_ERROR)
#define F_ARB4_COR_RDQUEUE_ERROR    V_ARB4_COR_RDQUEUE_ERROR(1U)

#define S_ARB3_COR_RDQUEUE_ERROR    3
#define V_ARB3_COR_RDQUEUE_ERROR(x) ((x) << S_ARB3_COR_RDQUEUE_ERROR)
#define F_ARB3_COR_RDQUEUE_ERROR    V_ARB3_COR_RDQUEUE_ERROR(1U)

#define S_ARB2_COR_RDQUEUE_ERROR    2
#define V_ARB2_COR_RDQUEUE_ERROR(x) ((x) << S_ARB2_COR_RDQUEUE_ERROR)
#define F_ARB2_COR_RDQUEUE_ERROR    V_ARB2_COR_RDQUEUE_ERROR(1U)

#define S_ARB1_COR_RDQUEUE_ERROR    1
#define V_ARB1_COR_RDQUEUE_ERROR(x) ((x) << S_ARB1_COR_RDQUEUE_ERROR)
#define F_ARB1_COR_RDQUEUE_ERROR    V_ARB1_COR_RDQUEUE_ERROR(1U)

#define S_ARB0_COR_RDQUEUE_ERROR    0
#define V_ARB0_COR_RDQUEUE_ERROR(x) ((x) << S_ARB0_COR_RDQUEUE_ERROR)
#define F_ARB0_COR_RDQUEUE_ERROR    V_ARB0_COR_RDQUEUE_ERROR(1U)

#define A_MA_DBG_CTL 0x77a4

#define S_DATAH_SEL    20
#define V_DATAH_SEL(x) ((x) << S_DATAH_SEL)
#define F_DATAH_SEL    V_DATAH_SEL(1U)

#define S_EN_DBG    16
#define V_EN_DBG(x) ((x) << S_EN_DBG)
#define F_EN_DBG    V_EN_DBG(1U)

#define S_T7_SEL    0
#define M_T7_SEL    0xffU
#define V_T7_SEL(x) ((x) << S_T7_SEL)
#define G_T7_SEL(x) (((x) >> S_T7_SEL) & M_T7_SEL)

#define A_MA_DBG_DATA 0x77a8
#define A_MA_COR_ERROR_ENABLE2 0x77b0

#define S_CL14_COR_WRQUEUE_ERROR_EN    14
#define V_CL14_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL14_COR_WRQUEUE_ERROR_EN)
#define F_CL14_COR_WRQUEUE_ERROR_EN    V_CL14_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL13_COR_WRQUEUE_ERROR_EN    13
#define V_CL13_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL13_COR_WRQUEUE_ERROR_EN)
#define F_CL13_COR_WRQUEUE_ERROR_EN    V_CL13_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL12_COR_WRQUEUE_ERROR_EN    12
#define V_CL12_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL12_COR_WRQUEUE_ERROR_EN)
#define F_CL12_COR_WRQUEUE_ERROR_EN    V_CL12_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL11_COR_WRQUEUE_ERROR_EN    11
#define V_CL11_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL11_COR_WRQUEUE_ERROR_EN)
#define F_CL11_COR_WRQUEUE_ERROR_EN    V_CL11_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL10_COR_WRQUEUE_ERROR_EN    10
#define V_CL10_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL10_COR_WRQUEUE_ERROR_EN)
#define F_CL10_COR_WRQUEUE_ERROR_EN    V_CL10_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL9_COR_WRQUEUE_ERROR_EN    9
#define V_CL9_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL9_COR_WRQUEUE_ERROR_EN)
#define F_CL9_COR_WRQUEUE_ERROR_EN    V_CL9_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL8_COR_WRQUEUE_ERROR_EN    8
#define V_CL8_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL8_COR_WRQUEUE_ERROR_EN)
#define F_CL8_COR_WRQUEUE_ERROR_EN    V_CL8_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL7_COR_WRQUEUE_ERROR_EN    7
#define V_CL7_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL7_COR_WRQUEUE_ERROR_EN)
#define F_CL7_COR_WRQUEUE_ERROR_EN    V_CL7_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL6_COR_WRQUEUE_ERROR_EN    6
#define V_CL6_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL6_COR_WRQUEUE_ERROR_EN)
#define F_CL6_COR_WRQUEUE_ERROR_EN    V_CL6_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL5_COR_WRQUEUE_ERROR_EN    5
#define V_CL5_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL5_COR_WRQUEUE_ERROR_EN)
#define F_CL5_COR_WRQUEUE_ERROR_EN    V_CL5_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL4_COR_WRQUEUE_ERROR_EN    4
#define V_CL4_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL4_COR_WRQUEUE_ERROR_EN)
#define F_CL4_COR_WRQUEUE_ERROR_EN    V_CL4_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL3_COR_WRQUEUE_ERROR_EN    3
#define V_CL3_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL3_COR_WRQUEUE_ERROR_EN)
#define F_CL3_COR_WRQUEUE_ERROR_EN    V_CL3_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL2_COR_WRQUEUE_ERROR_EN    2
#define V_CL2_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL2_COR_WRQUEUE_ERROR_EN)
#define F_CL2_COR_WRQUEUE_ERROR_EN    V_CL2_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL1_COR_WRQUEUE_ERROR_EN    1
#define V_CL1_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL1_COR_WRQUEUE_ERROR_EN)
#define F_CL1_COR_WRQUEUE_ERROR_EN    V_CL1_COR_WRQUEUE_ERROR_EN(1U)

#define S_CL0_COR_WRQUEUE_ERROR_EN    0
#define V_CL0_COR_WRQUEUE_ERROR_EN(x) ((x) << S_CL0_COR_WRQUEUE_ERROR_EN)
#define F_CL0_COR_WRQUEUE_ERROR_EN    V_CL0_COR_WRQUEUE_ERROR_EN(1U)

#define A_MA_COR_ERROR_STATUS2 0x77b4

#define S_CL14_COR_WRQUEUE_ERROR    14
#define V_CL14_COR_WRQUEUE_ERROR(x) ((x) << S_CL14_COR_WRQUEUE_ERROR)
#define F_CL14_COR_WRQUEUE_ERROR    V_CL14_COR_WRQUEUE_ERROR(1U)

#define S_CL13_COR_WRQUEUE_ERROR    13
#define V_CL13_COR_WRQUEUE_ERROR(x) ((x) << S_CL13_COR_WRQUEUE_ERROR)
#define F_CL13_COR_WRQUEUE_ERROR    V_CL13_COR_WRQUEUE_ERROR(1U)

#define S_CL12_COR_WRQUEUE_ERROR    12
#define V_CL12_COR_WRQUEUE_ERROR(x) ((x) << S_CL12_COR_WRQUEUE_ERROR)
#define F_CL12_COR_WRQUEUE_ERROR    V_CL12_COR_WRQUEUE_ERROR(1U)

#define S_CL11_COR_WRQUEUE_ERROR    11
#define V_CL11_COR_WRQUEUE_ERROR(x) ((x) << S_CL11_COR_WRQUEUE_ERROR)
#define F_CL11_COR_WRQUEUE_ERROR    V_CL11_COR_WRQUEUE_ERROR(1U)

#define S_CL10_COR_WRQUEUE_ERROR    10
#define V_CL10_COR_WRQUEUE_ERROR(x) ((x) << S_CL10_COR_WRQUEUE_ERROR)
#define F_CL10_COR_WRQUEUE_ERROR    V_CL10_COR_WRQUEUE_ERROR(1U)

#define S_CL9_COR_WRQUEUE_ERROR    9
#define V_CL9_COR_WRQUEUE_ERROR(x) ((x) << S_CL9_COR_WRQUEUE_ERROR)
#define F_CL9_COR_WRQUEUE_ERROR    V_CL9_COR_WRQUEUE_ERROR(1U)

#define S_CL8_COR_WRQUEUE_ERROR    8
#define V_CL8_COR_WRQUEUE_ERROR(x) ((x) << S_CL8_COR_WRQUEUE_ERROR)
#define F_CL8_COR_WRQUEUE_ERROR    V_CL8_COR_WRQUEUE_ERROR(1U)

#define S_CL7_COR_WRQUEUE_ERROR    7
#define V_CL7_COR_WRQUEUE_ERROR(x) ((x) << S_CL7_COR_WRQUEUE_ERROR)
#define F_CL7_COR_WRQUEUE_ERROR    V_CL7_COR_WRQUEUE_ERROR(1U)

#define S_CL6_COR_WRQUEUE_ERROR    6
#define V_CL6_COR_WRQUEUE_ERROR(x) ((x) << S_CL6_COR_WRQUEUE_ERROR)
#define F_CL6_COR_WRQUEUE_ERROR    V_CL6_COR_WRQUEUE_ERROR(1U)

#define S_CL5_COR_WRQUEUE_ERROR    5
#define V_CL5_COR_WRQUEUE_ERROR(x) ((x) << S_CL5_COR_WRQUEUE_ERROR)
#define F_CL5_COR_WRQUEUE_ERROR    V_CL5_COR_WRQUEUE_ERROR(1U)

#define S_CL4_COR_WRQUEUE_ERROR    4
#define V_CL4_COR_WRQUEUE_ERROR(x) ((x) << S_CL4_COR_WRQUEUE_ERROR)
#define F_CL4_COR_WRQUEUE_ERROR    V_CL4_COR_WRQUEUE_ERROR(1U)

#define S_CL3_COR_WRQUEUE_ERROR    3
#define V_CL3_COR_WRQUEUE_ERROR(x) ((x) << S_CL3_COR_WRQUEUE_ERROR)
#define F_CL3_COR_WRQUEUE_ERROR    V_CL3_COR_WRQUEUE_ERROR(1U)

#define S_CL2_COR_WRQUEUE_ERROR    2
#define V_CL2_COR_WRQUEUE_ERROR(x) ((x) << S_CL2_COR_WRQUEUE_ERROR)
#define F_CL2_COR_WRQUEUE_ERROR    V_CL2_COR_WRQUEUE_ERROR(1U)

#define S_CL1_COR_WRQUEUE_ERROR    1
#define V_CL1_COR_WRQUEUE_ERROR(x) ((x) << S_CL1_COR_WRQUEUE_ERROR)
#define F_CL1_COR_WRQUEUE_ERROR    V_CL1_COR_WRQUEUE_ERROR(1U)

#define S_CL0_COR_WRQUEUE_ERROR    0
#define V_CL0_COR_WRQUEUE_ERROR(x) ((x) << S_CL0_COR_WRQUEUE_ERROR)
#define F_CL0_COR_WRQUEUE_ERROR    V_CL0_COR_WRQUEUE_ERROR(1U)

#define A_MA_COR_ERROR_ENABLE3 0x77b8

#define S_CL14_COR_RDQUEUE_ERROR_EN    14
#define V_CL14_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL14_COR_RDQUEUE_ERROR_EN)
#define F_CL14_COR_RDQUEUE_ERROR_EN    V_CL14_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL13_COR_RDQUEUE_ERROR_EN    13
#define V_CL13_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL13_COR_RDQUEUE_ERROR_EN)
#define F_CL13_COR_RDQUEUE_ERROR_EN    V_CL13_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL12_COR_RDQUEUE_ERROR_EN    12
#define V_CL12_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL12_COR_RDQUEUE_ERROR_EN)
#define F_CL12_COR_RDQUEUE_ERROR_EN    V_CL12_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL11_COR_RDQUEUE_ERROR_EN    11
#define V_CL11_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL11_COR_RDQUEUE_ERROR_EN)
#define F_CL11_COR_RDQUEUE_ERROR_EN    V_CL11_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL10_COR_RDQUEUE_ERROR_EN    10
#define V_CL10_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL10_COR_RDQUEUE_ERROR_EN)
#define F_CL10_COR_RDQUEUE_ERROR_EN    V_CL10_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL9_COR_RDQUEUE_ERROR_EN    9
#define V_CL9_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL9_COR_RDQUEUE_ERROR_EN)
#define F_CL9_COR_RDQUEUE_ERROR_EN    V_CL9_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL8_COR_RDQUEUE_ERROR_EN    8
#define V_CL8_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL8_COR_RDQUEUE_ERROR_EN)
#define F_CL8_COR_RDQUEUE_ERROR_EN    V_CL8_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL7_COR_RDQUEUE_ERROR_EN    7
#define V_CL7_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL7_COR_RDQUEUE_ERROR_EN)
#define F_CL7_COR_RDQUEUE_ERROR_EN    V_CL7_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL6_COR_RDQUEUE_ERROR_EN    6
#define V_CL6_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL6_COR_RDQUEUE_ERROR_EN)
#define F_CL6_COR_RDQUEUE_ERROR_EN    V_CL6_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL5_COR_RDQUEUE_ERROR_EN    5
#define V_CL5_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL5_COR_RDQUEUE_ERROR_EN)
#define F_CL5_COR_RDQUEUE_ERROR_EN    V_CL5_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL4_COR_RDQUEUE_ERROR_EN    4
#define V_CL4_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL4_COR_RDQUEUE_ERROR_EN)
#define F_CL4_COR_RDQUEUE_ERROR_EN    V_CL4_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL3_COR_RDQUEUE_ERROR_EN    3
#define V_CL3_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL3_COR_RDQUEUE_ERROR_EN)
#define F_CL3_COR_RDQUEUE_ERROR_EN    V_CL3_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL2_COR_RDQUEUE_ERROR_EN    2
#define V_CL2_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL2_COR_RDQUEUE_ERROR_EN)
#define F_CL2_COR_RDQUEUE_ERROR_EN    V_CL2_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL1_COR_RDQUEUE_ERROR_EN    1
#define V_CL1_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL1_COR_RDQUEUE_ERROR_EN)
#define F_CL1_COR_RDQUEUE_ERROR_EN    V_CL1_COR_RDQUEUE_ERROR_EN(1U)

#define S_CL0_COR_RDQUEUE_ERROR_EN    0
#define V_CL0_COR_RDQUEUE_ERROR_EN(x) ((x) << S_CL0_COR_RDQUEUE_ERROR_EN)
#define F_CL0_COR_RDQUEUE_ERROR_EN    V_CL0_COR_RDQUEUE_ERROR_EN(1U)

#define A_MA_COR_ERROR_STATUS3 0x77bc

#define S_CL14_COR_RDQUEUE_ERROR    14
#define V_CL14_COR_RDQUEUE_ERROR(x) ((x) << S_CL14_COR_RDQUEUE_ERROR)
#define F_CL14_COR_RDQUEUE_ERROR    V_CL14_COR_RDQUEUE_ERROR(1U)

#define S_CL13_COR_RDQUEUE_ERROR    13
#define V_CL13_COR_RDQUEUE_ERROR(x) ((x) << S_CL13_COR_RDQUEUE_ERROR)
#define F_CL13_COR_RDQUEUE_ERROR    V_CL13_COR_RDQUEUE_ERROR(1U)

#define S_CL12_COR_RDQUEUE_ERROR    12
#define V_CL12_COR_RDQUEUE_ERROR(x) ((x) << S_CL12_COR_RDQUEUE_ERROR)
#define F_CL12_COR_RDQUEUE_ERROR    V_CL12_COR_RDQUEUE_ERROR(1U)

#define S_CL11_COR_RDQUEUE_ERROR    11
#define V_CL11_COR_RDQUEUE_ERROR(x) ((x) << S_CL11_COR_RDQUEUE_ERROR)
#define F_CL11_COR_RDQUEUE_ERROR    V_CL11_COR_RDQUEUE_ERROR(1U)

#define S_CL10_COR_RDQUEUE_ERROR    10
#define V_CL10_COR_RDQUEUE_ERROR(x) ((x) << S_CL10_COR_RDQUEUE_ERROR)
#define F_CL10_COR_RDQUEUE_ERROR    V_CL10_COR_RDQUEUE_ERROR(1U)

#define S_CL9_COR_RDQUEUE_ERROR    9
#define V_CL9_COR_RDQUEUE_ERROR(x) ((x) << S_CL9_COR_RDQUEUE_ERROR)
#define F_CL9_COR_RDQUEUE_ERROR    V_CL9_COR_RDQUEUE_ERROR(1U)

#define S_CL8_COR_RDQUEUE_ERROR    8
#define V_CL8_COR_RDQUEUE_ERROR(x) ((x) << S_CL8_COR_RDQUEUE_ERROR)
#define F_CL8_COR_RDQUEUE_ERROR    V_CL8_COR_RDQUEUE_ERROR(1U)

#define S_CL7_COR_RDQUEUE_ERROR    7
#define V_CL7_COR_RDQUEUE_ERROR(x) ((x) << S_CL7_COR_RDQUEUE_ERROR)
#define F_CL7_COR_RDQUEUE_ERROR    V_CL7_COR_RDQUEUE_ERROR(1U)

#define S_CL6_COR_RDQUEUE_ERROR    6
#define V_CL6_COR_RDQUEUE_ERROR(x) ((x) << S_CL6_COR_RDQUEUE_ERROR)
#define F_CL6_COR_RDQUEUE_ERROR    V_CL6_COR_RDQUEUE_ERROR(1U)

#define S_CL5_COR_RDQUEUE_ERROR    5
#define V_CL5_COR_RDQUEUE_ERROR(x) ((x) << S_CL5_COR_RDQUEUE_ERROR)
#define F_CL5_COR_RDQUEUE_ERROR    V_CL5_COR_RDQUEUE_ERROR(1U)

#define S_CL4_COR_RDQUEUE_ERROR    4
#define V_CL4_COR_RDQUEUE_ERROR(x) ((x) << S_CL4_COR_RDQUEUE_ERROR)
#define F_CL4_COR_RDQUEUE_ERROR    V_CL4_COR_RDQUEUE_ERROR(1U)

#define S_CL3_COR_RDQUEUE_ERROR    3
#define V_CL3_COR_RDQUEUE_ERROR(x) ((x) << S_CL3_COR_RDQUEUE_ERROR)
#define F_CL3_COR_RDQUEUE_ERROR    V_CL3_COR_RDQUEUE_ERROR(1U)

#define S_CL2_COR_RDQUEUE_ERROR    2
#define V_CL2_COR_RDQUEUE_ERROR(x) ((x) << S_CL2_COR_RDQUEUE_ERROR)
#define F_CL2_COR_RDQUEUE_ERROR    V_CL2_COR_RDQUEUE_ERROR(1U)

#define S_CL1_COR_RDQUEUE_ERROR    1
#define V_CL1_COR_RDQUEUE_ERROR(x) ((x) << S_CL1_COR_RDQUEUE_ERROR)
#define F_CL1_COR_RDQUEUE_ERROR    V_CL1_COR_RDQUEUE_ERROR(1U)

#define S_CL0_COR_RDQUEUE_ERROR    0
#define V_CL0_COR_RDQUEUE_ERROR(x) ((x) << S_CL0_COR_RDQUEUE_ERROR)
#define F_CL0_COR_RDQUEUE_ERROR    V_CL0_COR_RDQUEUE_ERROR(1U)

#define A_MA_EDRAM0_BAR 0x77c0

#define S_EDRAM0_BASE    16
#define M_EDRAM0_BASE    0xfffU
#define V_EDRAM0_BASE(x) ((x) << S_EDRAM0_BASE)
#define G_EDRAM0_BASE(x) (((x) >> S_EDRAM0_BASE) & M_EDRAM0_BASE)

#define S_EDRAM0_SIZE    0
#define M_EDRAM0_SIZE    0xfffU
#define V_EDRAM0_SIZE(x) ((x) << S_EDRAM0_SIZE)
#define G_EDRAM0_SIZE(x) (((x) >> S_EDRAM0_SIZE) & M_EDRAM0_SIZE)

#define S_T7_EDRAM0_BASE    16
#define M_T7_EDRAM0_BASE    0xffffU
#define V_T7_EDRAM0_BASE(x) ((x) << S_T7_EDRAM0_BASE)
#define G_T7_EDRAM0_BASE(x) (((x) >> S_T7_EDRAM0_BASE) & M_T7_EDRAM0_BASE)

#define S_T7_EDRAM0_SIZE    0
#define M_T7_EDRAM0_SIZE    0xffffU
#define V_T7_EDRAM0_SIZE(x) ((x) << S_T7_EDRAM0_SIZE)
#define G_T7_EDRAM0_SIZE(x) (((x) >> S_T7_EDRAM0_SIZE) & M_T7_EDRAM0_SIZE)

#define A_MA_EDRAM1_BAR 0x77c4

#define S_EDRAM1_BASE    16
#define M_EDRAM1_BASE    0xfffU
#define V_EDRAM1_BASE(x) ((x) << S_EDRAM1_BASE)
#define G_EDRAM1_BASE(x) (((x) >> S_EDRAM1_BASE) & M_EDRAM1_BASE)

#define S_EDRAM1_SIZE    0
#define M_EDRAM1_SIZE    0xfffU
#define V_EDRAM1_SIZE(x) ((x) << S_EDRAM1_SIZE)
#define G_EDRAM1_SIZE(x) (((x) >> S_EDRAM1_SIZE) & M_EDRAM1_SIZE)

#define S_T7_EDRAM1_BASE    16
#define M_T7_EDRAM1_BASE    0xffffU
#define V_T7_EDRAM1_BASE(x) ((x) << S_T7_EDRAM1_BASE)
#define G_T7_EDRAM1_BASE(x) (((x) >> S_T7_EDRAM1_BASE) & M_T7_EDRAM1_BASE)

#define S_T7_EDRAM1_SIZE    0
#define M_T7_EDRAM1_SIZE    0xffffU
#define V_T7_EDRAM1_SIZE(x) ((x) << S_T7_EDRAM1_SIZE)
#define G_T7_EDRAM1_SIZE(x) (((x) >> S_T7_EDRAM1_SIZE) & M_T7_EDRAM1_SIZE)

#define A_MA_EXT_MEMORY_BAR 0x77c8

#define S_EXT_MEM_BASE    16
#define M_EXT_MEM_BASE    0xfffU
#define V_EXT_MEM_BASE(x) ((x) << S_EXT_MEM_BASE)
#define G_EXT_MEM_BASE(x) (((x) >> S_EXT_MEM_BASE) & M_EXT_MEM_BASE)

#define S_EXT_MEM_SIZE    0
#define M_EXT_MEM_SIZE    0xfffU
#define V_EXT_MEM_SIZE(x) ((x) << S_EXT_MEM_SIZE)
#define G_EXT_MEM_SIZE(x) (((x) >> S_EXT_MEM_SIZE) & M_EXT_MEM_SIZE)

#define A_MA_EXT_MEMORY0_BAR 0x77c8

#define S_EXT_MEM0_BASE    16
#define M_EXT_MEM0_BASE    0xfffU
#define V_EXT_MEM0_BASE(x) ((x) << S_EXT_MEM0_BASE)
#define G_EXT_MEM0_BASE(x) (((x) >> S_EXT_MEM0_BASE) & M_EXT_MEM0_BASE)

#define S_EXT_MEM0_SIZE    0
#define M_EXT_MEM0_SIZE    0xfffU
#define V_EXT_MEM0_SIZE(x) ((x) << S_EXT_MEM0_SIZE)
#define G_EXT_MEM0_SIZE(x) (((x) >> S_EXT_MEM0_SIZE) & M_EXT_MEM0_SIZE)

#define S_T7_EXT_MEM0_BASE    16
#define M_T7_EXT_MEM0_BASE    0xffffU
#define V_T7_EXT_MEM0_BASE(x) ((x) << S_T7_EXT_MEM0_BASE)
#define G_T7_EXT_MEM0_BASE(x) (((x) >> S_T7_EXT_MEM0_BASE) & M_T7_EXT_MEM0_BASE)

#define S_T7_EXT_MEM0_SIZE    0
#define M_T7_EXT_MEM0_SIZE    0xffffU
#define V_T7_EXT_MEM0_SIZE(x) ((x) << S_T7_EXT_MEM0_SIZE)
#define G_T7_EXT_MEM0_SIZE(x) (((x) >> S_T7_EXT_MEM0_SIZE) & M_T7_EXT_MEM0_SIZE)

#define A_MA_HOST_MEMORY_BAR 0x77cc

#define S_HMA_BASE    16
#define M_HMA_BASE    0xfffU
#define V_HMA_BASE(x) ((x) << S_HMA_BASE)
#define G_HMA_BASE(x) (((x) >> S_HMA_BASE) & M_HMA_BASE)

#define S_HMA_SIZE    0
#define M_HMA_SIZE    0xfffU
#define V_HMA_SIZE(x) ((x) << S_HMA_SIZE)
#define G_HMA_SIZE(x) (((x) >> S_HMA_SIZE) & M_HMA_SIZE)

#define S_HMATARGETBASE    16
#define M_HMATARGETBASE    0xffffU
#define V_HMATARGETBASE(x) ((x) << S_HMATARGETBASE)
#define G_HMATARGETBASE(x) (((x) >> S_HMATARGETBASE) & M_HMATARGETBASE)

#define S_T7_HMA_SIZE    0
#define M_T7_HMA_SIZE    0xffffU
#define V_T7_HMA_SIZE(x) ((x) << S_T7_HMA_SIZE)
#define G_T7_HMA_SIZE(x) (((x) >> S_T7_HMA_SIZE) & M_T7_HMA_SIZE)

#define A_MA_EXT_MEM_PAGE_SIZE 0x77d0

#define S_BRC_MODE    2
#define V_BRC_MODE(x) ((x) << S_BRC_MODE)
#define F_BRC_MODE    V_BRC_MODE(1U)

#define S_EXT_MEM_PAGE_SIZE    0
#define M_EXT_MEM_PAGE_SIZE    0x3U
#define V_EXT_MEM_PAGE_SIZE(x) ((x) << S_EXT_MEM_PAGE_SIZE)
#define G_EXT_MEM_PAGE_SIZE(x) (((x) >> S_EXT_MEM_PAGE_SIZE) & M_EXT_MEM_PAGE_SIZE)

#define S_BRC_MODE1    6
#define V_BRC_MODE1(x) ((x) << S_BRC_MODE1)
#define F_BRC_MODE1    V_BRC_MODE1(1U)

#define S_EXT_MEM_PAGE_SIZE1    4
#define M_EXT_MEM_PAGE_SIZE1    0x3U
#define V_EXT_MEM_PAGE_SIZE1(x) ((x) << S_EXT_MEM_PAGE_SIZE1)
#define G_EXT_MEM_PAGE_SIZE1(x) (((x) >> S_EXT_MEM_PAGE_SIZE1) & M_EXT_MEM_PAGE_SIZE1)

#define S_BRBC_MODE    4
#define V_BRBC_MODE(x) ((x) << S_BRBC_MODE)
#define F_BRBC_MODE    V_BRBC_MODE(1U)

#define S_T6_BRC_MODE    3
#define V_T6_BRC_MODE(x) ((x) << S_T6_BRC_MODE)
#define F_T6_BRC_MODE    V_T6_BRC_MODE(1U)

#define S_T6_EXT_MEM_PAGE_SIZE    0
#define M_T6_EXT_MEM_PAGE_SIZE    0x7U
#define V_T6_EXT_MEM_PAGE_SIZE(x) ((x) << S_T6_EXT_MEM_PAGE_SIZE)
#define G_T6_EXT_MEM_PAGE_SIZE(x) (((x) >> S_T6_EXT_MEM_PAGE_SIZE) & M_T6_EXT_MEM_PAGE_SIZE)

#define A_MA_ARB_CTRL 0x77d4

#define S_DIS_PAGE_HINT    1
#define V_DIS_PAGE_HINT(x) ((x) << S_DIS_PAGE_HINT)
#define F_DIS_PAGE_HINT    V_DIS_PAGE_HINT(1U)

#define S_DIS_ADV_ARB    0
#define V_DIS_ADV_ARB(x) ((x) << S_DIS_ADV_ARB)
#define F_DIS_ADV_ARB    V_DIS_ADV_ARB(1U)

#define S_DIS_BANK_FAIR    2
#define V_DIS_BANK_FAIR(x) ((x) << S_DIS_BANK_FAIR)
#define F_DIS_BANK_FAIR    V_DIS_BANK_FAIR(1U)

#define S_HMA_WRT_EN    26
#define V_HMA_WRT_EN(x) ((x) << S_HMA_WRT_EN)
#define F_HMA_WRT_EN    V_HMA_WRT_EN(1U)

#define S_HMA_NUM_PG_128B_FDBK    21
#define M_HMA_NUM_PG_128B_FDBK    0x1fU
#define V_HMA_NUM_PG_128B_FDBK(x) ((x) << S_HMA_NUM_PG_128B_FDBK)
#define G_HMA_NUM_PG_128B_FDBK(x) (((x) >> S_HMA_NUM_PG_128B_FDBK) & M_HMA_NUM_PG_128B_FDBK)

#define S_HMA_DIS_128B_PG_CNT_FDBK    20
#define V_HMA_DIS_128B_PG_CNT_FDBK(x) ((x) << S_HMA_DIS_128B_PG_CNT_FDBK)
#define F_HMA_DIS_128B_PG_CNT_FDBK    V_HMA_DIS_128B_PG_CNT_FDBK(1U)

#define S_HMA_DIS_BG_ARB    19
#define V_HMA_DIS_BG_ARB(x) ((x) << S_HMA_DIS_BG_ARB)
#define F_HMA_DIS_BG_ARB    V_HMA_DIS_BG_ARB(1U)

#define S_HMA_DIS_BANK_FAIR    18
#define V_HMA_DIS_BANK_FAIR(x) ((x) << S_HMA_DIS_BANK_FAIR)
#define F_HMA_DIS_BANK_FAIR    V_HMA_DIS_BANK_FAIR(1U)

#define S_HMA_DIS_PAGE_HINT    17
#define V_HMA_DIS_PAGE_HINT(x) ((x) << S_HMA_DIS_PAGE_HINT)
#define F_HMA_DIS_PAGE_HINT    V_HMA_DIS_PAGE_HINT(1U)

#define S_HMA_DIS_ADV_ARB    16
#define V_HMA_DIS_ADV_ARB(x) ((x) << S_HMA_DIS_ADV_ARB)
#define F_HMA_DIS_ADV_ARB    V_HMA_DIS_ADV_ARB(1U)

#define S_NUM_PG_128B_FDBK    5
#define M_NUM_PG_128B_FDBK    0x1fU
#define V_NUM_PG_128B_FDBK(x) ((x) << S_NUM_PG_128B_FDBK)
#define G_NUM_PG_128B_FDBK(x) (((x) >> S_NUM_PG_128B_FDBK) & M_NUM_PG_128B_FDBK)

#define S_DIS_128B_PG_CNT_FDBK    4
#define V_DIS_128B_PG_CNT_FDBK(x) ((x) << S_DIS_128B_PG_CNT_FDBK)
#define F_DIS_128B_PG_CNT_FDBK    V_DIS_128B_PG_CNT_FDBK(1U)

#define S_DIS_BG_ARB    3
#define V_DIS_BG_ARB(x) ((x) << S_DIS_BG_ARB)
#define F_DIS_BG_ARB    V_DIS_BG_ARB(1U)

#define A_MA_TARGET_MEM_ENABLE 0x77d8

#define S_HMA_ENABLE    3
#define V_HMA_ENABLE(x) ((x) << S_HMA_ENABLE)
#define F_HMA_ENABLE    V_HMA_ENABLE(1U)

#define S_EXT_MEM_ENABLE    2
#define V_EXT_MEM_ENABLE(x) ((x) << S_EXT_MEM_ENABLE)
#define F_EXT_MEM_ENABLE    V_EXT_MEM_ENABLE(1U)

#define S_EDRAM1_ENABLE    1
#define V_EDRAM1_ENABLE(x) ((x) << S_EDRAM1_ENABLE)
#define F_EDRAM1_ENABLE    V_EDRAM1_ENABLE(1U)

#define S_EDRAM0_ENABLE    0
#define V_EDRAM0_ENABLE(x) ((x) << S_EDRAM0_ENABLE)
#define F_EDRAM0_ENABLE    V_EDRAM0_ENABLE(1U)

#define S_HMA_MUX    5
#define V_HMA_MUX(x) ((x) << S_HMA_MUX)
#define F_HMA_MUX    V_HMA_MUX(1U)

#define S_EXT_MEM1_ENABLE    4
#define V_EXT_MEM1_ENABLE(x) ((x) << S_EXT_MEM1_ENABLE)
#define F_EXT_MEM1_ENABLE    V_EXT_MEM1_ENABLE(1U)

#define S_EXT_MEM0_ENABLE    2
#define V_EXT_MEM0_ENABLE(x) ((x) << S_EXT_MEM0_ENABLE)
#define F_EXT_MEM0_ENABLE    V_EXT_MEM0_ENABLE(1U)

#define S_MC_SPLIT    6
#define V_MC_SPLIT(x) ((x) << S_MC_SPLIT)
#define F_MC_SPLIT    V_MC_SPLIT(1U)

#define S_EDC512    8
#define V_EDC512(x) ((x) << S_EDC512)
#define F_EDC512    V_EDC512(1U)

#define S_MC_SPLIT_BOUNDARY    7
#define V_MC_SPLIT_BOUNDARY(x) ((x) << S_MC_SPLIT_BOUNDARY)
#define F_MC_SPLIT_BOUNDARY    V_MC_SPLIT_BOUNDARY(1U)

#define A_MA_INT_ENABLE 0x77dc

#define S_MEM_PERR_INT_ENABLE    1
#define V_MEM_PERR_INT_ENABLE(x) ((x) << S_MEM_PERR_INT_ENABLE)
#define F_MEM_PERR_INT_ENABLE    V_MEM_PERR_INT_ENABLE(1U)

#define S_MEM_WRAP_INT_ENABLE    0
#define V_MEM_WRAP_INT_ENABLE(x) ((x) << S_MEM_WRAP_INT_ENABLE)
#define F_MEM_WRAP_INT_ENABLE    V_MEM_WRAP_INT_ENABLE(1U)

#define S_MEM_TO_INT_ENABLE    2
#define V_MEM_TO_INT_ENABLE(x) ((x) << S_MEM_TO_INT_ENABLE)
#define F_MEM_TO_INT_ENABLE    V_MEM_TO_INT_ENABLE(1U)

#define A_MA_INT_CAUSE 0x77e0

#define S_MEM_PERR_INT_CAUSE    1
#define V_MEM_PERR_INT_CAUSE(x) ((x) << S_MEM_PERR_INT_CAUSE)
#define F_MEM_PERR_INT_CAUSE    V_MEM_PERR_INT_CAUSE(1U)

#define S_MEM_WRAP_INT_CAUSE    0
#define V_MEM_WRAP_INT_CAUSE(x) ((x) << S_MEM_WRAP_INT_CAUSE)
#define F_MEM_WRAP_INT_CAUSE    V_MEM_WRAP_INT_CAUSE(1U)

#define S_MEM_TO_INT_CAUSE    2
#define V_MEM_TO_INT_CAUSE(x) ((x) << S_MEM_TO_INT_CAUSE)
#define F_MEM_TO_INT_CAUSE    V_MEM_TO_INT_CAUSE(1U)

#define A_MA_INT_WRAP_STATUS 0x77e4

#define S_MEM_WRAP_ADDRESS    4
#define M_MEM_WRAP_ADDRESS    0xfffffffU
#define V_MEM_WRAP_ADDRESS(x) ((x) << S_MEM_WRAP_ADDRESS)
#define G_MEM_WRAP_ADDRESS(x) (((x) >> S_MEM_WRAP_ADDRESS) & M_MEM_WRAP_ADDRESS)

#define S_MEM_WRAP_CLIENT_NUM    0
#define M_MEM_WRAP_CLIENT_NUM    0xfU
#define V_MEM_WRAP_CLIENT_NUM(x) ((x) << S_MEM_WRAP_CLIENT_NUM)
#define G_MEM_WRAP_CLIENT_NUM(x) (((x) >> S_MEM_WRAP_CLIENT_NUM) & M_MEM_WRAP_CLIENT_NUM)

#define A_MA_TP_THREAD1_MAPPER 0x77e8

#define S_TP_THREAD1_EN    0
#define M_TP_THREAD1_EN    0xffU
#define V_TP_THREAD1_EN(x) ((x) << S_TP_THREAD1_EN)
#define G_TP_THREAD1_EN(x) (((x) >> S_TP_THREAD1_EN) & M_TP_THREAD1_EN)

#define A_MA_SGE_THREAD1_MAPPER 0x77ec

#define S_SGE_THREAD1_EN    0
#define M_SGE_THREAD1_EN    0xffU
#define V_SGE_THREAD1_EN(x) ((x) << S_SGE_THREAD1_EN)
#define G_SGE_THREAD1_EN(x) (((x) >> S_SGE_THREAD1_EN) & M_SGE_THREAD1_EN)

#define A_MA_PARITY_ERROR_ENABLE 0x77f0

#define S_TP_DMARBT_PAR_ERROR_EN    31
#define V_TP_DMARBT_PAR_ERROR_EN(x) ((x) << S_TP_DMARBT_PAR_ERROR_EN)
#define F_TP_DMARBT_PAR_ERROR_EN    V_TP_DMARBT_PAR_ERROR_EN(1U)

#define S_LOGIC_FIFO_PAR_ERROR_EN    30
#define V_LOGIC_FIFO_PAR_ERROR_EN(x) ((x) << S_LOGIC_FIFO_PAR_ERROR_EN)
#define F_LOGIC_FIFO_PAR_ERROR_EN    V_LOGIC_FIFO_PAR_ERROR_EN(1U)

#define S_ARB3_PAR_WRQUEUE_ERROR_EN    29
#define V_ARB3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB3_PAR_WRQUEUE_ERROR_EN)
#define F_ARB3_PAR_WRQUEUE_ERROR_EN    V_ARB3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB2_PAR_WRQUEUE_ERROR_EN    28
#define V_ARB2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB2_PAR_WRQUEUE_ERROR_EN)
#define F_ARB2_PAR_WRQUEUE_ERROR_EN    V_ARB2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB1_PAR_WRQUEUE_ERROR_EN    27
#define V_ARB1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB1_PAR_WRQUEUE_ERROR_EN)
#define F_ARB1_PAR_WRQUEUE_ERROR_EN    V_ARB1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB0_PAR_WRQUEUE_ERROR_EN    26
#define V_ARB0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB0_PAR_WRQUEUE_ERROR_EN)
#define F_ARB0_PAR_WRQUEUE_ERROR_EN    V_ARB0_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB3_PAR_RDQUEUE_ERROR_EN    25
#define V_ARB3_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB3_PAR_RDQUEUE_ERROR_EN)
#define F_ARB3_PAR_RDQUEUE_ERROR_EN    V_ARB3_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB2_PAR_RDQUEUE_ERROR_EN    24
#define V_ARB2_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB2_PAR_RDQUEUE_ERROR_EN)
#define F_ARB2_PAR_RDQUEUE_ERROR_EN    V_ARB2_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB1_PAR_RDQUEUE_ERROR_EN    23
#define V_ARB1_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB1_PAR_RDQUEUE_ERROR_EN)
#define F_ARB1_PAR_RDQUEUE_ERROR_EN    V_ARB1_PAR_RDQUEUE_ERROR_EN(1U)

#define S_ARB0_PAR_RDQUEUE_ERROR_EN    22
#define V_ARB0_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB0_PAR_RDQUEUE_ERROR_EN)
#define F_ARB0_PAR_RDQUEUE_ERROR_EN    V_ARB0_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL10_PAR_WRQUEUE_ERROR_EN    21
#define V_CL10_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL10_PAR_WRQUEUE_ERROR_EN)
#define F_CL10_PAR_WRQUEUE_ERROR_EN    V_CL10_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL9_PAR_WRQUEUE_ERROR_EN    20
#define V_CL9_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL9_PAR_WRQUEUE_ERROR_EN)
#define F_CL9_PAR_WRQUEUE_ERROR_EN    V_CL9_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL8_PAR_WRQUEUE_ERROR_EN    19
#define V_CL8_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL8_PAR_WRQUEUE_ERROR_EN)
#define F_CL8_PAR_WRQUEUE_ERROR_EN    V_CL8_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL7_PAR_WRQUEUE_ERROR_EN    18
#define V_CL7_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL7_PAR_WRQUEUE_ERROR_EN)
#define F_CL7_PAR_WRQUEUE_ERROR_EN    V_CL7_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL6_PAR_WRQUEUE_ERROR_EN    17
#define V_CL6_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL6_PAR_WRQUEUE_ERROR_EN)
#define F_CL6_PAR_WRQUEUE_ERROR_EN    V_CL6_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL5_PAR_WRQUEUE_ERROR_EN    16
#define V_CL5_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL5_PAR_WRQUEUE_ERROR_EN)
#define F_CL5_PAR_WRQUEUE_ERROR_EN    V_CL5_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL4_PAR_WRQUEUE_ERROR_EN    15
#define V_CL4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL4_PAR_WRQUEUE_ERROR_EN)
#define F_CL4_PAR_WRQUEUE_ERROR_EN    V_CL4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL3_PAR_WRQUEUE_ERROR_EN    14
#define V_CL3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL3_PAR_WRQUEUE_ERROR_EN)
#define F_CL3_PAR_WRQUEUE_ERROR_EN    V_CL3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL2_PAR_WRQUEUE_ERROR_EN    13
#define V_CL2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL2_PAR_WRQUEUE_ERROR_EN)
#define F_CL2_PAR_WRQUEUE_ERROR_EN    V_CL2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL1_PAR_WRQUEUE_ERROR_EN    12
#define V_CL1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL1_PAR_WRQUEUE_ERROR_EN)
#define F_CL1_PAR_WRQUEUE_ERROR_EN    V_CL1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL0_PAR_WRQUEUE_ERROR_EN    11
#define V_CL0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL0_PAR_WRQUEUE_ERROR_EN)
#define F_CL0_PAR_WRQUEUE_ERROR_EN    V_CL0_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL10_PAR_RDQUEUE_ERROR_EN    10
#define V_CL10_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL10_PAR_RDQUEUE_ERROR_EN)
#define F_CL10_PAR_RDQUEUE_ERROR_EN    V_CL10_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL9_PAR_RDQUEUE_ERROR_EN    9
#define V_CL9_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL9_PAR_RDQUEUE_ERROR_EN)
#define F_CL9_PAR_RDQUEUE_ERROR_EN    V_CL9_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL8_PAR_RDQUEUE_ERROR_EN    8
#define V_CL8_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL8_PAR_RDQUEUE_ERROR_EN)
#define F_CL8_PAR_RDQUEUE_ERROR_EN    V_CL8_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL7_PAR_RDQUEUE_ERROR_EN    7
#define V_CL7_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL7_PAR_RDQUEUE_ERROR_EN)
#define F_CL7_PAR_RDQUEUE_ERROR_EN    V_CL7_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL6_PAR_RDQUEUE_ERROR_EN    6
#define V_CL6_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL6_PAR_RDQUEUE_ERROR_EN)
#define F_CL6_PAR_RDQUEUE_ERROR_EN    V_CL6_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL5_PAR_RDQUEUE_ERROR_EN    5
#define V_CL5_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL5_PAR_RDQUEUE_ERROR_EN)
#define F_CL5_PAR_RDQUEUE_ERROR_EN    V_CL5_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL4_PAR_RDQUEUE_ERROR_EN    4
#define V_CL4_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL4_PAR_RDQUEUE_ERROR_EN)
#define F_CL4_PAR_RDQUEUE_ERROR_EN    V_CL4_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL3_PAR_RDQUEUE_ERROR_EN    3
#define V_CL3_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL3_PAR_RDQUEUE_ERROR_EN)
#define F_CL3_PAR_RDQUEUE_ERROR_EN    V_CL3_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL2_PAR_RDQUEUE_ERROR_EN    2
#define V_CL2_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL2_PAR_RDQUEUE_ERROR_EN)
#define F_CL2_PAR_RDQUEUE_ERROR_EN    V_CL2_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL1_PAR_RDQUEUE_ERROR_EN    1
#define V_CL1_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL1_PAR_RDQUEUE_ERROR_EN)
#define F_CL1_PAR_RDQUEUE_ERROR_EN    V_CL1_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL0_PAR_RDQUEUE_ERROR_EN    0
#define V_CL0_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL0_PAR_RDQUEUE_ERROR_EN)
#define F_CL0_PAR_RDQUEUE_ERROR_EN    V_CL0_PAR_RDQUEUE_ERROR_EN(1U)

#define A_MA_PARITY_ERROR_ENABLE1 0x77f0

#define S_T7_ARB4_PAR_WRQUEUE_ERROR_EN    11
#define V_T7_ARB4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_ARB4_PAR_WRQUEUE_ERROR_EN)
#define F_T7_ARB4_PAR_WRQUEUE_ERROR_EN    V_T7_ARB4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_ARB3_PAR_WRQUEUE_ERROR_EN    10
#define V_T7_ARB3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_ARB3_PAR_WRQUEUE_ERROR_EN)
#define F_T7_ARB3_PAR_WRQUEUE_ERROR_EN    V_T7_ARB3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_ARB2_PAR_WRQUEUE_ERROR_EN    9
#define V_T7_ARB2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_ARB2_PAR_WRQUEUE_ERROR_EN)
#define F_T7_ARB2_PAR_WRQUEUE_ERROR_EN    V_T7_ARB2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_ARB1_PAR_WRQUEUE_ERROR_EN    8
#define V_T7_ARB1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_ARB1_PAR_WRQUEUE_ERROR_EN)
#define F_T7_ARB1_PAR_WRQUEUE_ERROR_EN    V_T7_ARB1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_ARB0_PAR_WRQUEUE_ERROR_EN    7
#define V_T7_ARB0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_ARB0_PAR_WRQUEUE_ERROR_EN)
#define F_T7_ARB0_PAR_WRQUEUE_ERROR_EN    V_T7_ARB0_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_ARB4_PAR_RDQUEUE_ERROR_EN    6
#define V_T7_ARB4_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_T7_ARB4_PAR_RDQUEUE_ERROR_EN)
#define F_T7_ARB4_PAR_RDQUEUE_ERROR_EN    V_T7_ARB4_PAR_RDQUEUE_ERROR_EN(1U)

#define S_T7_ARB3_PAR_RDQUEUE_ERROR_EN    5
#define V_T7_ARB3_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_T7_ARB3_PAR_RDQUEUE_ERROR_EN)
#define F_T7_ARB3_PAR_RDQUEUE_ERROR_EN    V_T7_ARB3_PAR_RDQUEUE_ERROR_EN(1U)

#define S_T7_ARB2_PAR_RDQUEUE_ERROR_EN    4
#define V_T7_ARB2_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_T7_ARB2_PAR_RDQUEUE_ERROR_EN)
#define F_T7_ARB2_PAR_RDQUEUE_ERROR_EN    V_T7_ARB2_PAR_RDQUEUE_ERROR_EN(1U)

#define S_T7_ARB1_PAR_RDQUEUE_ERROR_EN    3
#define V_T7_ARB1_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_T7_ARB1_PAR_RDQUEUE_ERROR_EN)
#define F_T7_ARB1_PAR_RDQUEUE_ERROR_EN    V_T7_ARB1_PAR_RDQUEUE_ERROR_EN(1U)

#define S_T7_ARB0_PAR_RDQUEUE_ERROR_EN    2
#define V_T7_ARB0_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_T7_ARB0_PAR_RDQUEUE_ERROR_EN)
#define F_T7_ARB0_PAR_RDQUEUE_ERROR_EN    V_T7_ARB0_PAR_RDQUEUE_ERROR_EN(1U)

#define S_T7_TP_DMARBT_PAR_ERROR_EN    1
#define V_T7_TP_DMARBT_PAR_ERROR_EN(x) ((x) << S_T7_TP_DMARBT_PAR_ERROR_EN)
#define F_T7_TP_DMARBT_PAR_ERROR_EN    V_T7_TP_DMARBT_PAR_ERROR_EN(1U)

#define S_T7_LOGIC_FIFO_PAR_ERROR_EN    0
#define V_T7_LOGIC_FIFO_PAR_ERROR_EN(x) ((x) << S_T7_LOGIC_FIFO_PAR_ERROR_EN)
#define F_T7_LOGIC_FIFO_PAR_ERROR_EN    V_T7_LOGIC_FIFO_PAR_ERROR_EN(1U)

#define A_MA_PARITY_ERROR_STATUS 0x77f4

#define S_TP_DMARBT_PAR_ERROR    31
#define V_TP_DMARBT_PAR_ERROR(x) ((x) << S_TP_DMARBT_PAR_ERROR)
#define F_TP_DMARBT_PAR_ERROR    V_TP_DMARBT_PAR_ERROR(1U)

#define S_LOGIC_FIFO_PAR_ERROR    30
#define V_LOGIC_FIFO_PAR_ERROR(x) ((x) << S_LOGIC_FIFO_PAR_ERROR)
#define F_LOGIC_FIFO_PAR_ERROR    V_LOGIC_FIFO_PAR_ERROR(1U)

#define S_ARB3_PAR_WRQUEUE_ERROR    29
#define V_ARB3_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB3_PAR_WRQUEUE_ERROR)
#define F_ARB3_PAR_WRQUEUE_ERROR    V_ARB3_PAR_WRQUEUE_ERROR(1U)

#define S_ARB2_PAR_WRQUEUE_ERROR    28
#define V_ARB2_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB2_PAR_WRQUEUE_ERROR)
#define F_ARB2_PAR_WRQUEUE_ERROR    V_ARB2_PAR_WRQUEUE_ERROR(1U)

#define S_ARB1_PAR_WRQUEUE_ERROR    27
#define V_ARB1_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB1_PAR_WRQUEUE_ERROR)
#define F_ARB1_PAR_WRQUEUE_ERROR    V_ARB1_PAR_WRQUEUE_ERROR(1U)

#define S_ARB0_PAR_WRQUEUE_ERROR    26
#define V_ARB0_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB0_PAR_WRQUEUE_ERROR)
#define F_ARB0_PAR_WRQUEUE_ERROR    V_ARB0_PAR_WRQUEUE_ERROR(1U)

#define S_ARB3_PAR_RDQUEUE_ERROR    25
#define V_ARB3_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB3_PAR_RDQUEUE_ERROR)
#define F_ARB3_PAR_RDQUEUE_ERROR    V_ARB3_PAR_RDQUEUE_ERROR(1U)

#define S_ARB2_PAR_RDQUEUE_ERROR    24
#define V_ARB2_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB2_PAR_RDQUEUE_ERROR)
#define F_ARB2_PAR_RDQUEUE_ERROR    V_ARB2_PAR_RDQUEUE_ERROR(1U)

#define S_ARB1_PAR_RDQUEUE_ERROR    23
#define V_ARB1_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB1_PAR_RDQUEUE_ERROR)
#define F_ARB1_PAR_RDQUEUE_ERROR    V_ARB1_PAR_RDQUEUE_ERROR(1U)

#define S_ARB0_PAR_RDQUEUE_ERROR    22
#define V_ARB0_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB0_PAR_RDQUEUE_ERROR)
#define F_ARB0_PAR_RDQUEUE_ERROR    V_ARB0_PAR_RDQUEUE_ERROR(1U)

#define S_CL10_PAR_WRQUEUE_ERROR    21
#define V_CL10_PAR_WRQUEUE_ERROR(x) ((x) << S_CL10_PAR_WRQUEUE_ERROR)
#define F_CL10_PAR_WRQUEUE_ERROR    V_CL10_PAR_WRQUEUE_ERROR(1U)

#define S_CL9_PAR_WRQUEUE_ERROR    20
#define V_CL9_PAR_WRQUEUE_ERROR(x) ((x) << S_CL9_PAR_WRQUEUE_ERROR)
#define F_CL9_PAR_WRQUEUE_ERROR    V_CL9_PAR_WRQUEUE_ERROR(1U)

#define S_CL8_PAR_WRQUEUE_ERROR    19
#define V_CL8_PAR_WRQUEUE_ERROR(x) ((x) << S_CL8_PAR_WRQUEUE_ERROR)
#define F_CL8_PAR_WRQUEUE_ERROR    V_CL8_PAR_WRQUEUE_ERROR(1U)

#define S_CL7_PAR_WRQUEUE_ERROR    18
#define V_CL7_PAR_WRQUEUE_ERROR(x) ((x) << S_CL7_PAR_WRQUEUE_ERROR)
#define F_CL7_PAR_WRQUEUE_ERROR    V_CL7_PAR_WRQUEUE_ERROR(1U)

#define S_CL6_PAR_WRQUEUE_ERROR    17
#define V_CL6_PAR_WRQUEUE_ERROR(x) ((x) << S_CL6_PAR_WRQUEUE_ERROR)
#define F_CL6_PAR_WRQUEUE_ERROR    V_CL6_PAR_WRQUEUE_ERROR(1U)

#define S_CL5_PAR_WRQUEUE_ERROR    16
#define V_CL5_PAR_WRQUEUE_ERROR(x) ((x) << S_CL5_PAR_WRQUEUE_ERROR)
#define F_CL5_PAR_WRQUEUE_ERROR    V_CL5_PAR_WRQUEUE_ERROR(1U)

#define S_CL4_PAR_WRQUEUE_ERROR    15
#define V_CL4_PAR_WRQUEUE_ERROR(x) ((x) << S_CL4_PAR_WRQUEUE_ERROR)
#define F_CL4_PAR_WRQUEUE_ERROR    V_CL4_PAR_WRQUEUE_ERROR(1U)

#define S_CL3_PAR_WRQUEUE_ERROR    14
#define V_CL3_PAR_WRQUEUE_ERROR(x) ((x) << S_CL3_PAR_WRQUEUE_ERROR)
#define F_CL3_PAR_WRQUEUE_ERROR    V_CL3_PAR_WRQUEUE_ERROR(1U)

#define S_CL2_PAR_WRQUEUE_ERROR    13
#define V_CL2_PAR_WRQUEUE_ERROR(x) ((x) << S_CL2_PAR_WRQUEUE_ERROR)
#define F_CL2_PAR_WRQUEUE_ERROR    V_CL2_PAR_WRQUEUE_ERROR(1U)

#define S_CL1_PAR_WRQUEUE_ERROR    12
#define V_CL1_PAR_WRQUEUE_ERROR(x) ((x) << S_CL1_PAR_WRQUEUE_ERROR)
#define F_CL1_PAR_WRQUEUE_ERROR    V_CL1_PAR_WRQUEUE_ERROR(1U)

#define S_CL0_PAR_WRQUEUE_ERROR    11
#define V_CL0_PAR_WRQUEUE_ERROR(x) ((x) << S_CL0_PAR_WRQUEUE_ERROR)
#define F_CL0_PAR_WRQUEUE_ERROR    V_CL0_PAR_WRQUEUE_ERROR(1U)

#define S_CL10_PAR_RDQUEUE_ERROR    10
#define V_CL10_PAR_RDQUEUE_ERROR(x) ((x) << S_CL10_PAR_RDQUEUE_ERROR)
#define F_CL10_PAR_RDQUEUE_ERROR    V_CL10_PAR_RDQUEUE_ERROR(1U)

#define S_CL9_PAR_RDQUEUE_ERROR    9
#define V_CL9_PAR_RDQUEUE_ERROR(x) ((x) << S_CL9_PAR_RDQUEUE_ERROR)
#define F_CL9_PAR_RDQUEUE_ERROR    V_CL9_PAR_RDQUEUE_ERROR(1U)

#define S_CL8_PAR_RDQUEUE_ERROR    8
#define V_CL8_PAR_RDQUEUE_ERROR(x) ((x) << S_CL8_PAR_RDQUEUE_ERROR)
#define F_CL8_PAR_RDQUEUE_ERROR    V_CL8_PAR_RDQUEUE_ERROR(1U)

#define S_CL7_PAR_RDQUEUE_ERROR    7
#define V_CL7_PAR_RDQUEUE_ERROR(x) ((x) << S_CL7_PAR_RDQUEUE_ERROR)
#define F_CL7_PAR_RDQUEUE_ERROR    V_CL7_PAR_RDQUEUE_ERROR(1U)

#define S_CL6_PAR_RDQUEUE_ERROR    6
#define V_CL6_PAR_RDQUEUE_ERROR(x) ((x) << S_CL6_PAR_RDQUEUE_ERROR)
#define F_CL6_PAR_RDQUEUE_ERROR    V_CL6_PAR_RDQUEUE_ERROR(1U)

#define S_CL5_PAR_RDQUEUE_ERROR    5
#define V_CL5_PAR_RDQUEUE_ERROR(x) ((x) << S_CL5_PAR_RDQUEUE_ERROR)
#define F_CL5_PAR_RDQUEUE_ERROR    V_CL5_PAR_RDQUEUE_ERROR(1U)

#define S_CL4_PAR_RDQUEUE_ERROR    4
#define V_CL4_PAR_RDQUEUE_ERROR(x) ((x) << S_CL4_PAR_RDQUEUE_ERROR)
#define F_CL4_PAR_RDQUEUE_ERROR    V_CL4_PAR_RDQUEUE_ERROR(1U)

#define S_CL3_PAR_RDQUEUE_ERROR    3
#define V_CL3_PAR_RDQUEUE_ERROR(x) ((x) << S_CL3_PAR_RDQUEUE_ERROR)
#define F_CL3_PAR_RDQUEUE_ERROR    V_CL3_PAR_RDQUEUE_ERROR(1U)

#define S_CL2_PAR_RDQUEUE_ERROR    2
#define V_CL2_PAR_RDQUEUE_ERROR(x) ((x) << S_CL2_PAR_RDQUEUE_ERROR)
#define F_CL2_PAR_RDQUEUE_ERROR    V_CL2_PAR_RDQUEUE_ERROR(1U)

#define S_CL1_PAR_RDQUEUE_ERROR    1
#define V_CL1_PAR_RDQUEUE_ERROR(x) ((x) << S_CL1_PAR_RDQUEUE_ERROR)
#define F_CL1_PAR_RDQUEUE_ERROR    V_CL1_PAR_RDQUEUE_ERROR(1U)

#define S_CL0_PAR_RDQUEUE_ERROR    0
#define V_CL0_PAR_RDQUEUE_ERROR(x) ((x) << S_CL0_PAR_RDQUEUE_ERROR)
#define F_CL0_PAR_RDQUEUE_ERROR    V_CL0_PAR_RDQUEUE_ERROR(1U)

#define A_MA_PARITY_ERROR_STATUS1 0x77f4

#define S_T7_ARB4_PAR_WRQUEUE_ERROR    11
#define V_T7_ARB4_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_ARB4_PAR_WRQUEUE_ERROR)
#define F_T7_ARB4_PAR_WRQUEUE_ERROR    V_T7_ARB4_PAR_WRQUEUE_ERROR(1U)

#define S_T7_ARB3_PAR_WRQUEUE_ERROR    10
#define V_T7_ARB3_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_ARB3_PAR_WRQUEUE_ERROR)
#define F_T7_ARB3_PAR_WRQUEUE_ERROR    V_T7_ARB3_PAR_WRQUEUE_ERROR(1U)

#define S_T7_ARB2_PAR_WRQUEUE_ERROR    9
#define V_T7_ARB2_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_ARB2_PAR_WRQUEUE_ERROR)
#define F_T7_ARB2_PAR_WRQUEUE_ERROR    V_T7_ARB2_PAR_WRQUEUE_ERROR(1U)

#define S_T7_ARB1_PAR_WRQUEUE_ERROR    8
#define V_T7_ARB1_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_ARB1_PAR_WRQUEUE_ERROR)
#define F_T7_ARB1_PAR_WRQUEUE_ERROR    V_T7_ARB1_PAR_WRQUEUE_ERROR(1U)

#define S_T7_ARB0_PAR_WRQUEUE_ERROR    7
#define V_T7_ARB0_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_ARB0_PAR_WRQUEUE_ERROR)
#define F_T7_ARB0_PAR_WRQUEUE_ERROR    V_T7_ARB0_PAR_WRQUEUE_ERROR(1U)

#define S_T7_ARB4_PAR_RDQUEUE_ERROR    6
#define V_T7_ARB4_PAR_RDQUEUE_ERROR(x) ((x) << S_T7_ARB4_PAR_RDQUEUE_ERROR)
#define F_T7_ARB4_PAR_RDQUEUE_ERROR    V_T7_ARB4_PAR_RDQUEUE_ERROR(1U)

#define S_T7_ARB3_PAR_RDQUEUE_ERROR    5
#define V_T7_ARB3_PAR_RDQUEUE_ERROR(x) ((x) << S_T7_ARB3_PAR_RDQUEUE_ERROR)
#define F_T7_ARB3_PAR_RDQUEUE_ERROR    V_T7_ARB3_PAR_RDQUEUE_ERROR(1U)

#define S_T7_ARB2_PAR_RDQUEUE_ERROR    4
#define V_T7_ARB2_PAR_RDQUEUE_ERROR(x) ((x) << S_T7_ARB2_PAR_RDQUEUE_ERROR)
#define F_T7_ARB2_PAR_RDQUEUE_ERROR    V_T7_ARB2_PAR_RDQUEUE_ERROR(1U)

#define S_T7_ARB1_PAR_RDQUEUE_ERROR    3
#define V_T7_ARB1_PAR_RDQUEUE_ERROR(x) ((x) << S_T7_ARB1_PAR_RDQUEUE_ERROR)
#define F_T7_ARB1_PAR_RDQUEUE_ERROR    V_T7_ARB1_PAR_RDQUEUE_ERROR(1U)

#define S_T7_ARB0_PAR_RDQUEUE_ERROR    2
#define V_T7_ARB0_PAR_RDQUEUE_ERROR(x) ((x) << S_T7_ARB0_PAR_RDQUEUE_ERROR)
#define F_T7_ARB0_PAR_RDQUEUE_ERROR    V_T7_ARB0_PAR_RDQUEUE_ERROR(1U)

#define S_T7_TP_DMARBT_PAR_ERROR    1
#define V_T7_TP_DMARBT_PAR_ERROR(x) ((x) << S_T7_TP_DMARBT_PAR_ERROR)
#define F_T7_TP_DMARBT_PAR_ERROR    V_T7_TP_DMARBT_PAR_ERROR(1U)

#define S_T7_LOGIC_FIFO_PAR_ERROR    0
#define V_T7_LOGIC_FIFO_PAR_ERROR(x) ((x) << S_T7_LOGIC_FIFO_PAR_ERROR)
#define F_T7_LOGIC_FIFO_PAR_ERROR    V_T7_LOGIC_FIFO_PAR_ERROR(1U)

#define A_MA_SGE_PCIE_COHERANCY_CTRL 0x77f8

#define S_BONUS_REG    6
#define M_BONUS_REG    0x3ffffffU
#define V_BONUS_REG(x) ((x) << S_BONUS_REG)
#define G_BONUS_REG(x) (((x) >> S_BONUS_REG) & M_BONUS_REG)

#define S_COHERANCY_CMD_TYPE    4
#define M_COHERANCY_CMD_TYPE    0x3U
#define V_COHERANCY_CMD_TYPE(x) ((x) << S_COHERANCY_CMD_TYPE)
#define G_COHERANCY_CMD_TYPE(x) (((x) >> S_COHERANCY_CMD_TYPE) & M_COHERANCY_CMD_TYPE)

#define S_COHERANCY_THREAD_NUM    1
#define M_COHERANCY_THREAD_NUM    0x7U
#define V_COHERANCY_THREAD_NUM(x) ((x) << S_COHERANCY_THREAD_NUM)
#define G_COHERANCY_THREAD_NUM(x) (((x) >> S_COHERANCY_THREAD_NUM) & M_COHERANCY_THREAD_NUM)

#define S_COHERANCY_ENABLE    0
#define V_COHERANCY_ENABLE(x) ((x) << S_COHERANCY_ENABLE)
#define F_COHERANCY_ENABLE    V_COHERANCY_ENABLE(1U)

#define A_MA_ERROR_ENABLE 0x77fc

#define S_UE_ENABLE    0
#define V_UE_ENABLE(x) ((x) << S_UE_ENABLE)
#define F_UE_ENABLE    V_UE_ENABLE(1U)

#define S_FUTURE_EXPANSION    1
#define M_FUTURE_EXPANSION    0x7fffffffU
#define V_FUTURE_EXPANSION(x) ((x) << S_FUTURE_EXPANSION)
#define G_FUTURE_EXPANSION(x) (((x) >> S_FUTURE_EXPANSION) & M_FUTURE_EXPANSION)

#define S_FUTURE_EXPANSION_EE    1
#define M_FUTURE_EXPANSION_EE    0x7fffffffU
#define V_FUTURE_EXPANSION_EE(x) ((x) << S_FUTURE_EXPANSION_EE)
#define G_FUTURE_EXPANSION_EE(x) (((x) >> S_FUTURE_EXPANSION_EE) & M_FUTURE_EXPANSION_EE)

#define A_MA_PARITY_ERROR_ENABLE2 0x7800

#define S_ARB4_PAR_WRQUEUE_ERROR_EN    1
#define V_ARB4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_ARB4_PAR_WRQUEUE_ERROR_EN)
#define F_ARB4_PAR_WRQUEUE_ERROR_EN    V_ARB4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_ARB4_PAR_RDQUEUE_ERROR_EN    0
#define V_ARB4_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_ARB4_PAR_RDQUEUE_ERROR_EN)
#define F_ARB4_PAR_RDQUEUE_ERROR_EN    V_ARB4_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL14_PAR_WRQUEUE_ERROR_EN    14
#define V_CL14_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL14_PAR_WRQUEUE_ERROR_EN)
#define F_CL14_PAR_WRQUEUE_ERROR_EN    V_CL14_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL13_PAR_WRQUEUE_ERROR_EN    13
#define V_CL13_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL13_PAR_WRQUEUE_ERROR_EN)
#define F_CL13_PAR_WRQUEUE_ERROR_EN    V_CL13_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL12_PAR_WRQUEUE_ERROR_EN    12
#define V_CL12_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL12_PAR_WRQUEUE_ERROR_EN)
#define F_CL12_PAR_WRQUEUE_ERROR_EN    V_CL12_PAR_WRQUEUE_ERROR_EN(1U)

#define S_CL11_PAR_WRQUEUE_ERROR_EN    11
#define V_CL11_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_CL11_PAR_WRQUEUE_ERROR_EN)
#define F_CL11_PAR_WRQUEUE_ERROR_EN    V_CL11_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL10_PAR_WRQUEUE_ERROR_EN    10
#define V_T7_CL10_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL10_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL10_PAR_WRQUEUE_ERROR_EN    V_T7_CL10_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL9_PAR_WRQUEUE_ERROR_EN    9
#define V_T7_CL9_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL9_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL9_PAR_WRQUEUE_ERROR_EN    V_T7_CL9_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL8_PAR_WRQUEUE_ERROR_EN    8
#define V_T7_CL8_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL8_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL8_PAR_WRQUEUE_ERROR_EN    V_T7_CL8_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL7_PAR_WRQUEUE_ERROR_EN    7
#define V_T7_CL7_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL7_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL7_PAR_WRQUEUE_ERROR_EN    V_T7_CL7_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL6_PAR_WRQUEUE_ERROR_EN    6
#define V_T7_CL6_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL6_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL6_PAR_WRQUEUE_ERROR_EN    V_T7_CL6_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL5_PAR_WRQUEUE_ERROR_EN    5
#define V_T7_CL5_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL5_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL5_PAR_WRQUEUE_ERROR_EN    V_T7_CL5_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL4_PAR_WRQUEUE_ERROR_EN    4
#define V_T7_CL4_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL4_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL4_PAR_WRQUEUE_ERROR_EN    V_T7_CL4_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL3_PAR_WRQUEUE_ERROR_EN    3
#define V_T7_CL3_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL3_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL3_PAR_WRQUEUE_ERROR_EN    V_T7_CL3_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL2_PAR_WRQUEUE_ERROR_EN    2
#define V_T7_CL2_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL2_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL2_PAR_WRQUEUE_ERROR_EN    V_T7_CL2_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL1_PAR_WRQUEUE_ERROR_EN    1
#define V_T7_CL1_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL1_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL1_PAR_WRQUEUE_ERROR_EN    V_T7_CL1_PAR_WRQUEUE_ERROR_EN(1U)

#define S_T7_CL0_PAR_WRQUEUE_ERROR_EN    0
#define V_T7_CL0_PAR_WRQUEUE_ERROR_EN(x) ((x) << S_T7_CL0_PAR_WRQUEUE_ERROR_EN)
#define F_T7_CL0_PAR_WRQUEUE_ERROR_EN    V_T7_CL0_PAR_WRQUEUE_ERROR_EN(1U)

#define A_MA_PARITY_ERROR_STATUS2 0x7804

#define S_ARB4_PAR_WRQUEUE_ERROR    1
#define V_ARB4_PAR_WRQUEUE_ERROR(x) ((x) << S_ARB4_PAR_WRQUEUE_ERROR)
#define F_ARB4_PAR_WRQUEUE_ERROR    V_ARB4_PAR_WRQUEUE_ERROR(1U)

#define S_ARB4_PAR_RDQUEUE_ERROR    0
#define V_ARB4_PAR_RDQUEUE_ERROR(x) ((x) << S_ARB4_PAR_RDQUEUE_ERROR)
#define F_ARB4_PAR_RDQUEUE_ERROR    V_ARB4_PAR_RDQUEUE_ERROR(1U)

#define S_CL14_PAR_WRQUEUE_ERROR    14
#define V_CL14_PAR_WRQUEUE_ERROR(x) ((x) << S_CL14_PAR_WRQUEUE_ERROR)
#define F_CL14_PAR_WRQUEUE_ERROR    V_CL14_PAR_WRQUEUE_ERROR(1U)

#define S_CL13_PAR_WRQUEUE_ERROR    13
#define V_CL13_PAR_WRQUEUE_ERROR(x) ((x) << S_CL13_PAR_WRQUEUE_ERROR)
#define F_CL13_PAR_WRQUEUE_ERROR    V_CL13_PAR_WRQUEUE_ERROR(1U)

#define S_CL12_PAR_WRQUEUE_ERROR    12
#define V_CL12_PAR_WRQUEUE_ERROR(x) ((x) << S_CL12_PAR_WRQUEUE_ERROR)
#define F_CL12_PAR_WRQUEUE_ERROR    V_CL12_PAR_WRQUEUE_ERROR(1U)

#define S_CL11_PAR_WRQUEUE_ERROR    11
#define V_CL11_PAR_WRQUEUE_ERROR(x) ((x) << S_CL11_PAR_WRQUEUE_ERROR)
#define F_CL11_PAR_WRQUEUE_ERROR    V_CL11_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL10_PAR_WRQUEUE_ERROR    10
#define V_T7_CL10_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL10_PAR_WRQUEUE_ERROR)
#define F_T7_CL10_PAR_WRQUEUE_ERROR    V_T7_CL10_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL9_PAR_WRQUEUE_ERROR    9
#define V_T7_CL9_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL9_PAR_WRQUEUE_ERROR)
#define F_T7_CL9_PAR_WRQUEUE_ERROR    V_T7_CL9_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL8_PAR_WRQUEUE_ERROR    8
#define V_T7_CL8_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL8_PAR_WRQUEUE_ERROR)
#define F_T7_CL8_PAR_WRQUEUE_ERROR    V_T7_CL8_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL7_PAR_WRQUEUE_ERROR    7
#define V_T7_CL7_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL7_PAR_WRQUEUE_ERROR)
#define F_T7_CL7_PAR_WRQUEUE_ERROR    V_T7_CL7_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL6_PAR_WRQUEUE_ERROR    6
#define V_T7_CL6_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL6_PAR_WRQUEUE_ERROR)
#define F_T7_CL6_PAR_WRQUEUE_ERROR    V_T7_CL6_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL5_PAR_WRQUEUE_ERROR    5
#define V_T7_CL5_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL5_PAR_WRQUEUE_ERROR)
#define F_T7_CL5_PAR_WRQUEUE_ERROR    V_T7_CL5_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL4_PAR_WRQUEUE_ERROR    4
#define V_T7_CL4_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL4_PAR_WRQUEUE_ERROR)
#define F_T7_CL4_PAR_WRQUEUE_ERROR    V_T7_CL4_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL3_PAR_WRQUEUE_ERROR    3
#define V_T7_CL3_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL3_PAR_WRQUEUE_ERROR)
#define F_T7_CL3_PAR_WRQUEUE_ERROR    V_T7_CL3_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL2_PAR_WRQUEUE_ERROR    2
#define V_T7_CL2_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL2_PAR_WRQUEUE_ERROR)
#define F_T7_CL2_PAR_WRQUEUE_ERROR    V_T7_CL2_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL1_PAR_WRQUEUE_ERROR    1
#define V_T7_CL1_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL1_PAR_WRQUEUE_ERROR)
#define F_T7_CL1_PAR_WRQUEUE_ERROR    V_T7_CL1_PAR_WRQUEUE_ERROR(1U)

#define S_T7_CL0_PAR_WRQUEUE_ERROR    0
#define V_T7_CL0_PAR_WRQUEUE_ERROR(x) ((x) << S_T7_CL0_PAR_WRQUEUE_ERROR)
#define F_T7_CL0_PAR_WRQUEUE_ERROR    V_T7_CL0_PAR_WRQUEUE_ERROR(1U)

#define A_MA_EXT_MEMORY1_BAR 0x7808

#define S_EXT_MEM1_BASE    16
#define M_EXT_MEM1_BASE    0xfffU
#define V_EXT_MEM1_BASE(x) ((x) << S_EXT_MEM1_BASE)
#define G_EXT_MEM1_BASE(x) (((x) >> S_EXT_MEM1_BASE) & M_EXT_MEM1_BASE)

#define S_EXT_MEM1_SIZE    0
#define M_EXT_MEM1_SIZE    0xfffU
#define V_EXT_MEM1_SIZE(x) ((x) << S_EXT_MEM1_SIZE)
#define G_EXT_MEM1_SIZE(x) (((x) >> S_EXT_MEM1_SIZE) & M_EXT_MEM1_SIZE)

#define S_T7_EXT_MEM1_BASE    16
#define M_T7_EXT_MEM1_BASE    0xffffU
#define V_T7_EXT_MEM1_BASE(x) ((x) << S_T7_EXT_MEM1_BASE)
#define G_T7_EXT_MEM1_BASE(x) (((x) >> S_T7_EXT_MEM1_BASE) & M_T7_EXT_MEM1_BASE)

#define S_T7_EXT_MEM1_SIZE    0
#define M_T7_EXT_MEM1_SIZE    0xffffU
#define V_T7_EXT_MEM1_SIZE(x) ((x) << S_T7_EXT_MEM1_SIZE)
#define G_T7_EXT_MEM1_SIZE(x) (((x) >> S_T7_EXT_MEM1_SIZE) & M_T7_EXT_MEM1_SIZE)

#define A_MA_PMTX_THROTTLE 0x780c

#define S_FL_ENABLE    31
#define V_FL_ENABLE(x) ((x) << S_FL_ENABLE)
#define F_FL_ENABLE    V_FL_ENABLE(1U)

#define S_FL_LIMIT    0
#define M_FL_LIMIT    0xffU
#define V_FL_LIMIT(x) ((x) << S_FL_LIMIT)
#define G_FL_LIMIT(x) (((x) >> S_FL_LIMIT) & M_FL_LIMIT)

#define A_MA_PMRX_THROTTLE 0x7810
#define A_MA_SGE_TH0_WRDATA_CNT 0x7814
#define A_MA_SGE_TH1_WRDATA_CNT 0x7818
#define A_MA_ULPTX_WRDATA_CNT 0x781c
#define A_MA_ULPRX_WRDATA_CNT 0x7820
#define A_MA_ULPTXRX_WRDATA_CNT 0x7824
#define A_MA_TP_TH0_WRDATA_CNT 0x7828
#define A_MA_TP_TH1_WRDATA_CNT 0x782c
#define A_MA_LE_WRDATA_CNT 0x7830
#define A_MA_CIM_WRDATA_CNT 0x7834
#define A_MA_CIM_TH0_WRDATA_CNT 0x7834
#define A_MA_PCIE_WRDATA_CNT 0x7838
#define A_MA_PMTX_WRDATA_CNT 0x783c
#define A_MA_PMRX_WRDATA_CNT 0x7840
#define A_MA_HMA_WRDATA_CNT 0x7844
#define A_MA_SGE_TH0_RDDATA_CNT 0x7848
#define A_MA_SGE_TH1_RDDATA_CNT 0x784c
#define A_MA_ULPTX_RDDATA_CNT 0x7850
#define A_MA_ULPRX_RDDATA_CNT 0x7854
#define A_MA_ULPTXRX_RDDATA_CNT 0x7858
#define A_MA_TP_TH0_RDDATA_CNT 0x785c
#define A_MA_TP_TH1_RDDATA_CNT 0x7860
#define A_MA_LE_RDDATA_CNT 0x7864
#define A_MA_CIM_RDDATA_CNT 0x7868
#define A_MA_CIM_TH0_RDDATA_CNT 0x7868
#define A_MA_PCIE_RDDATA_CNT 0x786c
#define A_MA_PMTX_RDDATA_CNT 0x7870
#define A_MA_PMRX_RDDATA_CNT 0x7874
#define A_MA_HMA_RDDATA_CNT 0x7878
#define A_MA_EDRAM0_WRDATA_CNT1 0x787c
#define A_MA_EXIT_ADDR_FAULT 0x787c

#define S_EXIT_ADDR_FAULT    0
#define V_EXIT_ADDR_FAULT(x) ((x) << S_EXIT_ADDR_FAULT)
#define F_EXIT_ADDR_FAULT    V_EXIT_ADDR_FAULT(1U)

#define A_MA_EDRAM0_WRDATA_CNT0 0x7880
#define A_MA_DDR_DEVICE_CFG 0x7880

#define S_MEM_WIDTH    1
#define M_MEM_WIDTH    0x7U
#define V_MEM_WIDTH(x) ((x) << S_MEM_WIDTH)
#define G_MEM_WIDTH(x) (((x) >> S_MEM_WIDTH) & M_MEM_WIDTH)

#define S_DDR_MODE    0
#define V_DDR_MODE(x) ((x) << S_DDR_MODE)
#define F_DDR_MODE    V_DDR_MODE(1U)

#define A_MA_EDRAM1_WRDATA_CNT1 0x7884
#define A_MA_PARITY_ERROR_ENABLE3 0x7884

#define S_CL14_PAR_RDQUEUE_ERROR_EN    14
#define V_CL14_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL14_PAR_RDQUEUE_ERROR_EN)
#define F_CL14_PAR_RDQUEUE_ERROR_EN    V_CL14_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL13_PAR_RDQUEUE_ERROR_EN    13
#define V_CL13_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL13_PAR_RDQUEUE_ERROR_EN)
#define F_CL13_PAR_RDQUEUE_ERROR_EN    V_CL13_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL12_PAR_RDQUEUE_ERROR_EN    12
#define V_CL12_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL12_PAR_RDQUEUE_ERROR_EN)
#define F_CL12_PAR_RDQUEUE_ERROR_EN    V_CL12_PAR_RDQUEUE_ERROR_EN(1U)

#define S_CL11_PAR_RDQUEUE_ERROR_EN    11
#define V_CL11_PAR_RDQUEUE_ERROR_EN(x) ((x) << S_CL11_PAR_RDQUEUE_ERROR_EN)
#define F_CL11_PAR_RDQUEUE_ERROR_EN    V_CL11_PAR_RDQUEUE_ERROR_EN(1U)

#define A_MA_EDRAM1_WRDATA_CNT0 0x7888
#define A_MA_PARITY_ERROR_STATUS3 0x7888

#define S_CL14_PAR_RDQUEUE_ERROR    14
#define V_CL14_PAR_RDQUEUE_ERROR(x) ((x) << S_CL14_PAR_RDQUEUE_ERROR)
#define F_CL14_PAR_RDQUEUE_ERROR    V_CL14_PAR_RDQUEUE_ERROR(1U)

#define S_CL13_PAR_RDQUEUE_ERROR    13
#define V_CL13_PAR_RDQUEUE_ERROR(x) ((x) << S_CL13_PAR_RDQUEUE_ERROR)
#define F_CL13_PAR_RDQUEUE_ERROR    V_CL13_PAR_RDQUEUE_ERROR(1U)

#define S_CL12_PAR_RDQUEUE_ERROR    12
#define V_CL12_PAR_RDQUEUE_ERROR(x) ((x) << S_CL12_PAR_RDQUEUE_ERROR)
#define F_CL12_PAR_RDQUEUE_ERROR    V_CL12_PAR_RDQUEUE_ERROR(1U)

#define S_CL11_PAR_RDQUEUE_ERROR    11
#define V_CL11_PAR_RDQUEUE_ERROR(x) ((x) << S_CL11_PAR_RDQUEUE_ERROR)
#define F_CL11_PAR_RDQUEUE_ERROR    V_CL11_PAR_RDQUEUE_ERROR(1U)

#define A_MA_EXT_MEMORY0_WRDATA_CNT1 0x788c
#define A_MA_EXT_MEMORY0_WRDATA_CNT0 0x7890
#define A_MA_HOST_MEMORY_WRDATA_CNT1 0x7894
#define A_MA_HOST_MEMORY_WRDATA_CNT0 0x7898
#define A_MA_EXT_MEMORY1_WRDATA_CNT1 0x789c
#define A_MA_EXT_MEMORY1_WRDATA_CNT0 0x78a0
#define A_MA_EDRAM0_RDDATA_CNT1 0x78a4
#define A_MA_EDRAM0_RDDATA_CNT0 0x78a8
#define A_MA_EDRAM1_RDDATA_CNT1 0x78ac
#define A_MA_EDRAM1_RDDATA_CNT0 0x78b0
#define A_MA_EXT_MEMORY0_RDDATA_CNT1 0x78b4
#define A_MA_EXT_MEMORY0_RDDATA_CNT0 0x78b8
#define A_MA_HOST_MEMORY_RDDATA_CNT1 0x78bc
#define A_MA_HOST_MEMORY_RDDATA_CNT0 0x78c0
#define A_MA_EXT_MEMORY1_RDDATA_CNT1 0x78c4
#define A_MA_EXT_MEMORY1_RDDATA_CNT0 0x78c8
#define A_MA_TIMEOUT_CFG 0x78cc

#define S_CLR    31
#define V_CLR(x) ((x) << S_CLR)
#define F_CLR    V_CLR(1U)

#define S_CNT_LOCK    30
#define V_CNT_LOCK(x) ((x) << S_CNT_LOCK)
#define F_CNT_LOCK    V_CNT_LOCK(1U)

#define S_WRN    24
#define V_WRN(x) ((x) << S_WRN)
#define F_WRN    V_WRN(1U)

#define S_DIR    23
#define V_DIR(x) ((x) << S_DIR)
#define F_DIR    V_DIR(1U)

#define S_TO_BUS    22
#define V_TO_BUS(x) ((x) << S_TO_BUS)
#define F_TO_BUS    V_TO_BUS(1U)

#define S_CLIENT    16
#define M_CLIENT    0xfU
#define V_CLIENT(x) ((x) << S_CLIENT)
#define G_CLIENT(x) (((x) >> S_CLIENT) & M_CLIENT)

#define S_DELAY    0
#define M_DELAY    0xffffU
#define V_DELAY(x) ((x) << S_DELAY)
#define G_DELAY(x) (((x) >> S_DELAY) & M_DELAY)

#define A_MA_TIMEOUT_CNT 0x78d0

#define S_CNT_VAL    0
#define M_CNT_VAL    0xffffU
#define V_CNT_VAL(x) ((x) << S_CNT_VAL)
#define G_CNT_VAL(x) (((x) >> S_CNT_VAL) & M_CNT_VAL)

#define A_MA_WRITE_TIMEOUT_ERROR_ENABLE 0x78d4

#define S_FUTURE_CEXPANSION    29
#define M_FUTURE_CEXPANSION    0x7U
#define V_FUTURE_CEXPANSION(x) ((x) << S_FUTURE_CEXPANSION)
#define G_FUTURE_CEXPANSION(x) (((x) >> S_FUTURE_CEXPANSION) & M_FUTURE_CEXPANSION)

#define S_CL12_WR_CMD_TO_EN    28
#define V_CL12_WR_CMD_TO_EN(x) ((x) << S_CL12_WR_CMD_TO_EN)
#define F_CL12_WR_CMD_TO_EN    V_CL12_WR_CMD_TO_EN(1U)

#define S_CL11_WR_CMD_TO_EN    27
#define V_CL11_WR_CMD_TO_EN(x) ((x) << S_CL11_WR_CMD_TO_EN)
#define F_CL11_WR_CMD_TO_EN    V_CL11_WR_CMD_TO_EN(1U)

#define S_CL10_WR_CMD_TO_EN    26
#define V_CL10_WR_CMD_TO_EN(x) ((x) << S_CL10_WR_CMD_TO_EN)
#define F_CL10_WR_CMD_TO_EN    V_CL10_WR_CMD_TO_EN(1U)

#define S_CL9_WR_CMD_TO_EN    25
#define V_CL9_WR_CMD_TO_EN(x) ((x) << S_CL9_WR_CMD_TO_EN)
#define F_CL9_WR_CMD_TO_EN    V_CL9_WR_CMD_TO_EN(1U)

#define S_CL8_WR_CMD_TO_EN    24
#define V_CL8_WR_CMD_TO_EN(x) ((x) << S_CL8_WR_CMD_TO_EN)
#define F_CL8_WR_CMD_TO_EN    V_CL8_WR_CMD_TO_EN(1U)

#define S_CL7_WR_CMD_TO_EN    23
#define V_CL7_WR_CMD_TO_EN(x) ((x) << S_CL7_WR_CMD_TO_EN)
#define F_CL7_WR_CMD_TO_EN    V_CL7_WR_CMD_TO_EN(1U)

#define S_CL6_WR_CMD_TO_EN    22
#define V_CL6_WR_CMD_TO_EN(x) ((x) << S_CL6_WR_CMD_TO_EN)
#define F_CL6_WR_CMD_TO_EN    V_CL6_WR_CMD_TO_EN(1U)

#define S_CL5_WR_CMD_TO_EN    21
#define V_CL5_WR_CMD_TO_EN(x) ((x) << S_CL5_WR_CMD_TO_EN)
#define F_CL5_WR_CMD_TO_EN    V_CL5_WR_CMD_TO_EN(1U)

#define S_CL4_WR_CMD_TO_EN    20
#define V_CL4_WR_CMD_TO_EN(x) ((x) << S_CL4_WR_CMD_TO_EN)
#define F_CL4_WR_CMD_TO_EN    V_CL4_WR_CMD_TO_EN(1U)

#define S_CL3_WR_CMD_TO_EN    19
#define V_CL3_WR_CMD_TO_EN(x) ((x) << S_CL3_WR_CMD_TO_EN)
#define F_CL3_WR_CMD_TO_EN    V_CL3_WR_CMD_TO_EN(1U)

#define S_CL2_WR_CMD_TO_EN    18
#define V_CL2_WR_CMD_TO_EN(x) ((x) << S_CL2_WR_CMD_TO_EN)
#define F_CL2_WR_CMD_TO_EN    V_CL2_WR_CMD_TO_EN(1U)

#define S_CL1_WR_CMD_TO_EN    17
#define V_CL1_WR_CMD_TO_EN(x) ((x) << S_CL1_WR_CMD_TO_EN)
#define F_CL1_WR_CMD_TO_EN    V_CL1_WR_CMD_TO_EN(1U)

#define S_CL0_WR_CMD_TO_EN    16
#define V_CL0_WR_CMD_TO_EN(x) ((x) << S_CL0_WR_CMD_TO_EN)
#define F_CL0_WR_CMD_TO_EN    V_CL0_WR_CMD_TO_EN(1U)

#define S_FUTURE_DEXPANSION    13
#define M_FUTURE_DEXPANSION    0x7U
#define V_FUTURE_DEXPANSION(x) ((x) << S_FUTURE_DEXPANSION)
#define G_FUTURE_DEXPANSION(x) (((x) >> S_FUTURE_DEXPANSION) & M_FUTURE_DEXPANSION)

#define S_CL12_WR_DATA_TO_EN    12
#define V_CL12_WR_DATA_TO_EN(x) ((x) << S_CL12_WR_DATA_TO_EN)
#define F_CL12_WR_DATA_TO_EN    V_CL12_WR_DATA_TO_EN(1U)

#define S_CL11_WR_DATA_TO_EN    11
#define V_CL11_WR_DATA_TO_EN(x) ((x) << S_CL11_WR_DATA_TO_EN)
#define F_CL11_WR_DATA_TO_EN    V_CL11_WR_DATA_TO_EN(1U)

#define S_CL10_WR_DATA_TO_EN    10
#define V_CL10_WR_DATA_TO_EN(x) ((x) << S_CL10_WR_DATA_TO_EN)
#define F_CL10_WR_DATA_TO_EN    V_CL10_WR_DATA_TO_EN(1U)

#define S_CL9_WR_DATA_TO_EN    9
#define V_CL9_WR_DATA_TO_EN(x) ((x) << S_CL9_WR_DATA_TO_EN)
#define F_CL9_WR_DATA_TO_EN    V_CL9_WR_DATA_TO_EN(1U)

#define S_CL8_WR_DATA_TO_EN    8
#define V_CL8_WR_DATA_TO_EN(x) ((x) << S_CL8_WR_DATA_TO_EN)
#define F_CL8_WR_DATA_TO_EN    V_CL8_WR_DATA_TO_EN(1U)

#define S_CL7_WR_DATA_TO_EN    7
#define V_CL7_WR_DATA_TO_EN(x) ((x) << S_CL7_WR_DATA_TO_EN)
#define F_CL7_WR_DATA_TO_EN    V_CL7_WR_DATA_TO_EN(1U)

#define S_CL6_WR_DATA_TO_EN    6
#define V_CL6_WR_DATA_TO_EN(x) ((x) << S_CL6_WR_DATA_TO_EN)
#define F_CL6_WR_DATA_TO_EN    V_CL6_WR_DATA_TO_EN(1U)

#define S_CL5_WR_DATA_TO_EN    5
#define V_CL5_WR_DATA_TO_EN(x) ((x) << S_CL5_WR_DATA_TO_EN)
#define F_CL5_WR_DATA_TO_EN    V_CL5_WR_DATA_TO_EN(1U)

#define S_CL4_WR_DATA_TO_EN    4
#define V_CL4_WR_DATA_TO_EN(x) ((x) << S_CL4_WR_DATA_TO_EN)
#define F_CL4_WR_DATA_TO_EN    V_CL4_WR_DATA_TO_EN(1U)

#define S_CL3_WR_DATA_TO_EN    3
#define V_CL3_WR_DATA_TO_EN(x) ((x) << S_CL3_WR_DATA_TO_EN)
#define F_CL3_WR_DATA_TO_EN    V_CL3_WR_DATA_TO_EN(1U)

#define S_CL2_WR_DATA_TO_EN    2
#define V_CL2_WR_DATA_TO_EN(x) ((x) << S_CL2_WR_DATA_TO_EN)
#define F_CL2_WR_DATA_TO_EN    V_CL2_WR_DATA_TO_EN(1U)

#define S_CL1_WR_DATA_TO_EN    1
#define V_CL1_WR_DATA_TO_EN(x) ((x) << S_CL1_WR_DATA_TO_EN)
#define F_CL1_WR_DATA_TO_EN    V_CL1_WR_DATA_TO_EN(1U)

#define S_CL0_WR_DATA_TO_EN    0
#define V_CL0_WR_DATA_TO_EN(x) ((x) << S_CL0_WR_DATA_TO_EN)
#define F_CL0_WR_DATA_TO_EN    V_CL0_WR_DATA_TO_EN(1U)

#define S_FUTURE_CEXPANSION_WTE    29
#define M_FUTURE_CEXPANSION_WTE    0x7U
#define V_FUTURE_CEXPANSION_WTE(x) ((x) << S_FUTURE_CEXPANSION_WTE)
#define G_FUTURE_CEXPANSION_WTE(x) (((x) >> S_FUTURE_CEXPANSION_WTE) & M_FUTURE_CEXPANSION_WTE)

#define S_FUTURE_DEXPANSION_WTE    13
#define M_FUTURE_DEXPANSION_WTE    0x7U
#define V_FUTURE_DEXPANSION_WTE(x) ((x) << S_FUTURE_DEXPANSION_WTE)
#define G_FUTURE_DEXPANSION_WTE(x) (((x) >> S_FUTURE_DEXPANSION_WTE) & M_FUTURE_DEXPANSION_WTE)

#define S_T7_FUTURE_CEXPANSION_WTE    31
#define V_T7_FUTURE_CEXPANSION_WTE(x) ((x) << S_T7_FUTURE_CEXPANSION_WTE)
#define F_T7_FUTURE_CEXPANSION_WTE    V_T7_FUTURE_CEXPANSION_WTE(1U)

#define S_CL14_WR_CMD_TO_EN    30
#define V_CL14_WR_CMD_TO_EN(x) ((x) << S_CL14_WR_CMD_TO_EN)
#define F_CL14_WR_CMD_TO_EN    V_CL14_WR_CMD_TO_EN(1U)

#define S_CL13_WR_CMD_TO_EN    29
#define V_CL13_WR_CMD_TO_EN(x) ((x) << S_CL13_WR_CMD_TO_EN)
#define F_CL13_WR_CMD_TO_EN    V_CL13_WR_CMD_TO_EN(1U)

#define S_T7_FUTURE_DEXPANSION_WTE    15
#define V_T7_FUTURE_DEXPANSION_WTE(x) ((x) << S_T7_FUTURE_DEXPANSION_WTE)
#define F_T7_FUTURE_DEXPANSION_WTE    V_T7_FUTURE_DEXPANSION_WTE(1U)

#define S_CL14_WR_DATA_TO_EN    14
#define V_CL14_WR_DATA_TO_EN(x) ((x) << S_CL14_WR_DATA_TO_EN)
#define F_CL14_WR_DATA_TO_EN    V_CL14_WR_DATA_TO_EN(1U)

#define S_CL13_WR_DATA_TO_EN    13
#define V_CL13_WR_DATA_TO_EN(x) ((x) << S_CL13_WR_DATA_TO_EN)
#define F_CL13_WR_DATA_TO_EN    V_CL13_WR_DATA_TO_EN(1U)

#define A_MA_WRITE_TIMEOUT_ERROR_STATUS 0x78d8

#define S_CL12_WR_CMD_TO_ERROR    28
#define V_CL12_WR_CMD_TO_ERROR(x) ((x) << S_CL12_WR_CMD_TO_ERROR)
#define F_CL12_WR_CMD_TO_ERROR    V_CL12_WR_CMD_TO_ERROR(1U)

#define S_CL11_WR_CMD_TO_ERROR    27
#define V_CL11_WR_CMD_TO_ERROR(x) ((x) << S_CL11_WR_CMD_TO_ERROR)
#define F_CL11_WR_CMD_TO_ERROR    V_CL11_WR_CMD_TO_ERROR(1U)

#define S_CL10_WR_CMD_TO_ERROR    26
#define V_CL10_WR_CMD_TO_ERROR(x) ((x) << S_CL10_WR_CMD_TO_ERROR)
#define F_CL10_WR_CMD_TO_ERROR    V_CL10_WR_CMD_TO_ERROR(1U)

#define S_CL9_WR_CMD_TO_ERROR    25
#define V_CL9_WR_CMD_TO_ERROR(x) ((x) << S_CL9_WR_CMD_TO_ERROR)
#define F_CL9_WR_CMD_TO_ERROR    V_CL9_WR_CMD_TO_ERROR(1U)

#define S_CL8_WR_CMD_TO_ERROR    24
#define V_CL8_WR_CMD_TO_ERROR(x) ((x) << S_CL8_WR_CMD_TO_ERROR)
#define F_CL8_WR_CMD_TO_ERROR    V_CL8_WR_CMD_TO_ERROR(1U)

#define S_CL7_WR_CMD_TO_ERROR    23
#define V_CL7_WR_CMD_TO_ERROR(x) ((x) << S_CL7_WR_CMD_TO_ERROR)
#define F_CL7_WR_CMD_TO_ERROR    V_CL7_WR_CMD_TO_ERROR(1U)

#define S_CL6_WR_CMD_TO_ERROR    22
#define V_CL6_WR_CMD_TO_ERROR(x) ((x) << S_CL6_WR_CMD_TO_ERROR)
#define F_CL6_WR_CMD_TO_ERROR    V_CL6_WR_CMD_TO_ERROR(1U)

#define S_CL5_WR_CMD_TO_ERROR    21
#define V_CL5_WR_CMD_TO_ERROR(x) ((x) << S_CL5_WR_CMD_TO_ERROR)
#define F_CL5_WR_CMD_TO_ERROR    V_CL5_WR_CMD_TO_ERROR(1U)

#define S_CL4_WR_CMD_TO_ERROR    20
#define V_CL4_WR_CMD_TO_ERROR(x) ((x) << S_CL4_WR_CMD_TO_ERROR)
#define F_CL4_WR_CMD_TO_ERROR    V_CL4_WR_CMD_TO_ERROR(1U)

#define S_CL3_WR_CMD_TO_ERROR    19
#define V_CL3_WR_CMD_TO_ERROR(x) ((x) << S_CL3_WR_CMD_TO_ERROR)
#define F_CL3_WR_CMD_TO_ERROR    V_CL3_WR_CMD_TO_ERROR(1U)

#define S_CL2_WR_CMD_TO_ERROR    18
#define V_CL2_WR_CMD_TO_ERROR(x) ((x) << S_CL2_WR_CMD_TO_ERROR)
#define F_CL2_WR_CMD_TO_ERROR    V_CL2_WR_CMD_TO_ERROR(1U)

#define S_CL1_WR_CMD_TO_ERROR    17
#define V_CL1_WR_CMD_TO_ERROR(x) ((x) << S_CL1_WR_CMD_TO_ERROR)
#define F_CL1_WR_CMD_TO_ERROR    V_CL1_WR_CMD_TO_ERROR(1U)

#define S_CL0_WR_CMD_TO_ERROR    16
#define V_CL0_WR_CMD_TO_ERROR(x) ((x) << S_CL0_WR_CMD_TO_ERROR)
#define F_CL0_WR_CMD_TO_ERROR    V_CL0_WR_CMD_TO_ERROR(1U)

#define S_CL12_WR_DATA_TO_ERROR    12
#define V_CL12_WR_DATA_TO_ERROR(x) ((x) << S_CL12_WR_DATA_TO_ERROR)
#define F_CL12_WR_DATA_TO_ERROR    V_CL12_WR_DATA_TO_ERROR(1U)

#define S_CL11_WR_DATA_TO_ERROR    11
#define V_CL11_WR_DATA_TO_ERROR(x) ((x) << S_CL11_WR_DATA_TO_ERROR)
#define F_CL11_WR_DATA_TO_ERROR    V_CL11_WR_DATA_TO_ERROR(1U)

#define S_CL10_WR_DATA_TO_ERROR    10
#define V_CL10_WR_DATA_TO_ERROR(x) ((x) << S_CL10_WR_DATA_TO_ERROR)
#define F_CL10_WR_DATA_TO_ERROR    V_CL10_WR_DATA_TO_ERROR(1U)

#define S_CL9_WR_DATA_TO_ERROR    9
#define V_CL9_WR_DATA_TO_ERROR(x) ((x) << S_CL9_WR_DATA_TO_ERROR)
#define F_CL9_WR_DATA_TO_ERROR    V_CL9_WR_DATA_TO_ERROR(1U)

#define S_CL8_WR_DATA_TO_ERROR    8
#define V_CL8_WR_DATA_TO_ERROR(x) ((x) << S_CL8_WR_DATA_TO_ERROR)
#define F_CL8_WR_DATA_TO_ERROR    V_CL8_WR_DATA_TO_ERROR(1U)

#define S_CL7_WR_DATA_TO_ERROR    7
#define V_CL7_WR_DATA_TO_ERROR(x) ((x) << S_CL7_WR_DATA_TO_ERROR)
#define F_CL7_WR_DATA_TO_ERROR    V_CL7_WR_DATA_TO_ERROR(1U)

#define S_CL6_WR_DATA_TO_ERROR    6
#define V_CL6_WR_DATA_TO_ERROR(x) ((x) << S_CL6_WR_DATA_TO_ERROR)
#define F_CL6_WR_DATA_TO_ERROR    V_CL6_WR_DATA_TO_ERROR(1U)

#define S_CL5_WR_DATA_TO_ERROR    5
#define V_CL5_WR_DATA_TO_ERROR(x) ((x) << S_CL5_WR_DATA_TO_ERROR)
#define F_CL5_WR_DATA_TO_ERROR    V_CL5_WR_DATA_TO_ERROR(1U)

#define S_CL4_WR_DATA_TO_ERROR    4
#define V_CL4_WR_DATA_TO_ERROR(x) ((x) << S_CL4_WR_DATA_TO_ERROR)
#define F_CL4_WR_DATA_TO_ERROR    V_CL4_WR_DATA_TO_ERROR(1U)

#define S_CL3_WR_DATA_TO_ERROR    3
#define V_CL3_WR_DATA_TO_ERROR(x) ((x) << S_CL3_WR_DATA_TO_ERROR)
#define F_CL3_WR_DATA_TO_ERROR    V_CL3_WR_DATA_TO_ERROR(1U)

#define S_CL2_WR_DATA_TO_ERROR    2
#define V_CL2_WR_DATA_TO_ERROR(x) ((x) << S_CL2_WR_DATA_TO_ERROR)
#define F_CL2_WR_DATA_TO_ERROR    V_CL2_WR_DATA_TO_ERROR(1U)

#define S_CL1_WR_DATA_TO_ERROR    1
#define V_CL1_WR_DATA_TO_ERROR(x) ((x) << S_CL1_WR_DATA_TO_ERROR)
#define F_CL1_WR_DATA_TO_ERROR    V_CL1_WR_DATA_TO_ERROR(1U)

#define S_CL0_WR_DATA_TO_ERROR    0
#define V_CL0_WR_DATA_TO_ERROR(x) ((x) << S_CL0_WR_DATA_TO_ERROR)
#define F_CL0_WR_DATA_TO_ERROR    V_CL0_WR_DATA_TO_ERROR(1U)

#define S_FUTURE_CEXPANSION_WTS    29
#define M_FUTURE_CEXPANSION_WTS    0x7U
#define V_FUTURE_CEXPANSION_WTS(x) ((x) << S_FUTURE_CEXPANSION_WTS)
#define G_FUTURE_CEXPANSION_WTS(x) (((x) >> S_FUTURE_CEXPANSION_WTS) & M_FUTURE_CEXPANSION_WTS)

#define S_FUTURE_DEXPANSION_WTS    13
#define M_FUTURE_DEXPANSION_WTS    0x7U
#define V_FUTURE_DEXPANSION_WTS(x) ((x) << S_FUTURE_DEXPANSION_WTS)
#define G_FUTURE_DEXPANSION_WTS(x) (((x) >> S_FUTURE_DEXPANSION_WTS) & M_FUTURE_DEXPANSION_WTS)

#define S_CL14_WR_CMD_TO_ERROR    30
#define V_CL14_WR_CMD_TO_ERROR(x) ((x) << S_CL14_WR_CMD_TO_ERROR)
#define F_CL14_WR_CMD_TO_ERROR    V_CL14_WR_CMD_TO_ERROR(1U)

#define S_CL13_WR_CMD_TO_ERROR    29
#define V_CL13_WR_CMD_TO_ERROR(x) ((x) << S_CL13_WR_CMD_TO_ERROR)
#define F_CL13_WR_CMD_TO_ERROR    V_CL13_WR_CMD_TO_ERROR(1U)

#define S_CL14_WR_DATA_TO_ERROR    14
#define V_CL14_WR_DATA_TO_ERROR(x) ((x) << S_CL14_WR_DATA_TO_ERROR)
#define F_CL14_WR_DATA_TO_ERROR    V_CL14_WR_DATA_TO_ERROR(1U)

#define S_CL13_WR_DATA_TO_ERROR    13
#define V_CL13_WR_DATA_TO_ERROR(x) ((x) << S_CL13_WR_DATA_TO_ERROR)
#define F_CL13_WR_DATA_TO_ERROR    V_CL13_WR_DATA_TO_ERROR(1U)

#define A_MA_READ_TIMEOUT_ERROR_ENABLE 0x78dc

#define S_CL12_RD_CMD_TO_EN    28
#define V_CL12_RD_CMD_TO_EN(x) ((x) << S_CL12_RD_CMD_TO_EN)
#define F_CL12_RD_CMD_TO_EN    V_CL12_RD_CMD_TO_EN(1U)

#define S_CL11_RD_CMD_TO_EN    27
#define V_CL11_RD_CMD_TO_EN(x) ((x) << S_CL11_RD_CMD_TO_EN)
#define F_CL11_RD_CMD_TO_EN    V_CL11_RD_CMD_TO_EN(1U)

#define S_CL10_RD_CMD_TO_EN    26
#define V_CL10_RD_CMD_TO_EN(x) ((x) << S_CL10_RD_CMD_TO_EN)
#define F_CL10_RD_CMD_TO_EN    V_CL10_RD_CMD_TO_EN(1U)

#define S_CL9_RD_CMD_TO_EN    25
#define V_CL9_RD_CMD_TO_EN(x) ((x) << S_CL9_RD_CMD_TO_EN)
#define F_CL9_RD_CMD_TO_EN    V_CL9_RD_CMD_TO_EN(1U)

#define S_CL8_RD_CMD_TO_EN    24
#define V_CL8_RD_CMD_TO_EN(x) ((x) << S_CL8_RD_CMD_TO_EN)
#define F_CL8_RD_CMD_TO_EN    V_CL8_RD_CMD_TO_EN(1U)

#define S_CL7_RD_CMD_TO_EN    23
#define V_CL7_RD_CMD_TO_EN(x) ((x) << S_CL7_RD_CMD_TO_EN)
#define F_CL7_RD_CMD_TO_EN    V_CL7_RD_CMD_TO_EN(1U)

#define S_CL6_RD_CMD_TO_EN    22
#define V_CL6_RD_CMD_TO_EN(x) ((x) << S_CL6_RD_CMD_TO_EN)
#define F_CL6_RD_CMD_TO_EN    V_CL6_RD_CMD_TO_EN(1U)

#define S_CL5_RD_CMD_TO_EN    21
#define V_CL5_RD_CMD_TO_EN(x) ((x) << S_CL5_RD_CMD_TO_EN)
#define F_CL5_RD_CMD_TO_EN    V_CL5_RD_CMD_TO_EN(1U)

#define S_CL4_RD_CMD_TO_EN    20
#define V_CL4_RD_CMD_TO_EN(x) ((x) << S_CL4_RD_CMD_TO_EN)
#define F_CL4_RD_CMD_TO_EN    V_CL4_RD_CMD_TO_EN(1U)

#define S_CL3_RD_CMD_TO_EN    19
#define V_CL3_RD_CMD_TO_EN(x) ((x) << S_CL3_RD_CMD_TO_EN)
#define F_CL3_RD_CMD_TO_EN    V_CL3_RD_CMD_TO_EN(1U)

#define S_CL2_RD_CMD_TO_EN    18
#define V_CL2_RD_CMD_TO_EN(x) ((x) << S_CL2_RD_CMD_TO_EN)
#define F_CL2_RD_CMD_TO_EN    V_CL2_RD_CMD_TO_EN(1U)

#define S_CL1_RD_CMD_TO_EN    17
#define V_CL1_RD_CMD_TO_EN(x) ((x) << S_CL1_RD_CMD_TO_EN)
#define F_CL1_RD_CMD_TO_EN    V_CL1_RD_CMD_TO_EN(1U)

#define S_CL0_RD_CMD_TO_EN    16
#define V_CL0_RD_CMD_TO_EN(x) ((x) << S_CL0_RD_CMD_TO_EN)
#define F_CL0_RD_CMD_TO_EN    V_CL0_RD_CMD_TO_EN(1U)

#define S_CL12_RD_DATA_TO_EN    12
#define V_CL12_RD_DATA_TO_EN(x) ((x) << S_CL12_RD_DATA_TO_EN)
#define F_CL12_RD_DATA_TO_EN    V_CL12_RD_DATA_TO_EN(1U)

#define S_CL11_RD_DATA_TO_EN    11
#define V_CL11_RD_DATA_TO_EN(x) ((x) << S_CL11_RD_DATA_TO_EN)
#define F_CL11_RD_DATA_TO_EN    V_CL11_RD_DATA_TO_EN(1U)

#define S_CL10_RD_DATA_TO_EN    10
#define V_CL10_RD_DATA_TO_EN(x) ((x) << S_CL10_RD_DATA_TO_EN)
#define F_CL10_RD_DATA_TO_EN    V_CL10_RD_DATA_TO_EN(1U)

#define S_CL9_RD_DATA_TO_EN    9
#define V_CL9_RD_DATA_TO_EN(x) ((x) << S_CL9_RD_DATA_TO_EN)
#define F_CL9_RD_DATA_TO_EN    V_CL9_RD_DATA_TO_EN(1U)

#define S_CL8_RD_DATA_TO_EN    8
#define V_CL8_RD_DATA_TO_EN(x) ((x) << S_CL8_RD_DATA_TO_EN)
#define F_CL8_RD_DATA_TO_EN    V_CL8_RD_DATA_TO_EN(1U)

#define S_CL7_RD_DATA_TO_EN    7
#define V_CL7_RD_DATA_TO_EN(x) ((x) << S_CL7_RD_DATA_TO_EN)
#define F_CL7_RD_DATA_TO_EN    V_CL7_RD_DATA_TO_EN(1U)

#define S_CL6_RD_DATA_TO_EN    6
#define V_CL6_RD_DATA_TO_EN(x) ((x) << S_CL6_RD_DATA_TO_EN)
#define F_CL6_RD_DATA_TO_EN    V_CL6_RD_DATA_TO_EN(1U)

#define S_CL5_RD_DATA_TO_EN    5
#define V_CL5_RD_DATA_TO_EN(x) ((x) << S_CL5_RD_DATA_TO_EN)
#define F_CL5_RD_DATA_TO_EN    V_CL5_RD_DATA_TO_EN(1U)

#define S_CL4_RD_DATA_TO_EN    4
#define V_CL4_RD_DATA_TO_EN(x) ((x) << S_CL4_RD_DATA_TO_EN)
#define F_CL4_RD_DATA_TO_EN    V_CL4_RD_DATA_TO_EN(1U)

#define S_CL3_RD_DATA_TO_EN    3
#define V_CL3_RD_DATA_TO_EN(x) ((x) << S_CL3_RD_DATA_TO_EN)
#define F_CL3_RD_DATA_TO_EN    V_CL3_RD_DATA_TO_EN(1U)

#define S_CL2_RD_DATA_TO_EN    2
#define V_CL2_RD_DATA_TO_EN(x) ((x) << S_CL2_RD_DATA_TO_EN)
#define F_CL2_RD_DATA_TO_EN    V_CL2_RD_DATA_TO_EN(1U)

#define S_CL1_RD_DATA_TO_EN    1
#define V_CL1_RD_DATA_TO_EN(x) ((x) << S_CL1_RD_DATA_TO_EN)
#define F_CL1_RD_DATA_TO_EN    V_CL1_RD_DATA_TO_EN(1U)

#define S_CL0_RD_DATA_TO_EN    0
#define V_CL0_RD_DATA_TO_EN(x) ((x) << S_CL0_RD_DATA_TO_EN)
#define F_CL0_RD_DATA_TO_EN    V_CL0_RD_DATA_TO_EN(1U)

#define S_FUTURE_CEXPANSION_RTE    29
#define M_FUTURE_CEXPANSION_RTE    0x7U
#define V_FUTURE_CEXPANSION_RTE(x) ((x) << S_FUTURE_CEXPANSION_RTE)
#define G_FUTURE_CEXPANSION_RTE(x) (((x) >> S_FUTURE_CEXPANSION_RTE) & M_FUTURE_CEXPANSION_RTE)

#define S_FUTURE_DEXPANSION_RTE    13
#define M_FUTURE_DEXPANSION_RTE    0x7U
#define V_FUTURE_DEXPANSION_RTE(x) ((x) << S_FUTURE_DEXPANSION_RTE)
#define G_FUTURE_DEXPANSION_RTE(x) (((x) >> S_FUTURE_DEXPANSION_RTE) & M_FUTURE_DEXPANSION_RTE)

#define S_CL14_RD_CMD_TO_EN    30
#define V_CL14_RD_CMD_TO_EN(x) ((x) << S_CL14_RD_CMD_TO_EN)
#define F_CL14_RD_CMD_TO_EN    V_CL14_RD_CMD_TO_EN(1U)

#define S_CL13_RD_CMD_TO_EN    29
#define V_CL13_RD_CMD_TO_EN(x) ((x) << S_CL13_RD_CMD_TO_EN)
#define F_CL13_RD_CMD_TO_EN    V_CL13_RD_CMD_TO_EN(1U)

#define S_CL14_RD_DATA_TO_EN    14
#define V_CL14_RD_DATA_TO_EN(x) ((x) << S_CL14_RD_DATA_TO_EN)
#define F_CL14_RD_DATA_TO_EN    V_CL14_RD_DATA_TO_EN(1U)

#define S_CL13_RD_DATA_TO_EN    13
#define V_CL13_RD_DATA_TO_EN(x) ((x) << S_CL13_RD_DATA_TO_EN)
#define F_CL13_RD_DATA_TO_EN    V_CL13_RD_DATA_TO_EN(1U)

#define A_MA_READ_TIMEOUT_ERROR_STATUS 0x78e0

#define S_CL12_RD_CMD_TO_ERROR    28
#define V_CL12_RD_CMD_TO_ERROR(x) ((x) << S_CL12_RD_CMD_TO_ERROR)
#define F_CL12_RD_CMD_TO_ERROR    V_CL12_RD_CMD_TO_ERROR(1U)

#define S_CL11_RD_CMD_TO_ERROR    27
#define V_CL11_RD_CMD_TO_ERROR(x) ((x) << S_CL11_RD_CMD_TO_ERROR)
#define F_CL11_RD_CMD_TO_ERROR    V_CL11_RD_CMD_TO_ERROR(1U)

#define S_CL10_RD_CMD_TO_ERROR    26
#define V_CL10_RD_CMD_TO_ERROR(x) ((x) << S_CL10_RD_CMD_TO_ERROR)
#define F_CL10_RD_CMD_TO_ERROR    V_CL10_RD_CMD_TO_ERROR(1U)

#define S_CL9_RD_CMD_TO_ERROR    25
#define V_CL9_RD_CMD_TO_ERROR(x) ((x) << S_CL9_RD_CMD_TO_ERROR)
#define F_CL9_RD_CMD_TO_ERROR    V_CL9_RD_CMD_TO_ERROR(1U)

#define S_CL8_RD_CMD_TO_ERROR    24
#define V_CL8_RD_CMD_TO_ERROR(x) ((x) << S_CL8_RD_CMD_TO_ERROR)
#define F_CL8_RD_CMD_TO_ERROR    V_CL8_RD_CMD_TO_ERROR(1U)

#define S_CL7_RD_CMD_TO_ERROR    23
#define V_CL7_RD_CMD_TO_ERROR(x) ((x) << S_CL7_RD_CMD_TO_ERROR)
#define F_CL7_RD_CMD_TO_ERROR    V_CL7_RD_CMD_TO_ERROR(1U)

#define S_CL6_RD_CMD_TO_ERROR    22
#define V_CL6_RD_CMD_TO_ERROR(x) ((x) << S_CL6_RD_CMD_TO_ERROR)
#define F_CL6_RD_CMD_TO_ERROR    V_CL6_RD_CMD_TO_ERROR(1U)

#define S_CL5_RD_CMD_TO_ERROR    21
#define V_CL5_RD_CMD_TO_ERROR(x) ((x) << S_CL5_RD_CMD_TO_ERROR)
#define F_CL5_RD_CMD_TO_ERROR    V_CL5_RD_CMD_TO_ERROR(1U)

#define S_CL4_RD_CMD_TO_ERROR    20
#define V_CL4_RD_CMD_TO_ERROR(x) ((x) << S_CL4_RD_CMD_TO_ERROR)
#define F_CL4_RD_CMD_TO_ERROR    V_CL4_RD_CMD_TO_ERROR(1U)

#define S_CL3_RD_CMD_TO_ERROR    19
#define V_CL3_RD_CMD_TO_ERROR(x) ((x) << S_CL3_RD_CMD_TO_ERROR)
#define F_CL3_RD_CMD_TO_ERROR    V_CL3_RD_CMD_TO_ERROR(1U)

#define S_CL2_RD_CMD_TO_ERROR    18
#define V_CL2_RD_CMD_TO_ERROR(x) ((x) << S_CL2_RD_CMD_TO_ERROR)
#define F_CL2_RD_CMD_TO_ERROR    V_CL2_RD_CMD_TO_ERROR(1U)

#define S_CL1_RD_CMD_TO_ERROR    17
#define V_CL1_RD_CMD_TO_ERROR(x) ((x) << S_CL1_RD_CMD_TO_ERROR)
#define F_CL1_RD_CMD_TO_ERROR    V_CL1_RD_CMD_TO_ERROR(1U)

#define S_CL0_RD_CMD_TO_ERROR    16
#define V_CL0_RD_CMD_TO_ERROR(x) ((x) << S_CL0_RD_CMD_TO_ERROR)
#define F_CL0_RD_CMD_TO_ERROR    V_CL0_RD_CMD_TO_ERROR(1U)

#define S_CL12_RD_DATA_TO_ERROR    12
#define V_CL12_RD_DATA_TO_ERROR(x) ((x) << S_CL12_RD_DATA_TO_ERROR)
#define F_CL12_RD_DATA_TO_ERROR    V_CL12_RD_DATA_TO_ERROR(1U)

#define S_CL11_RD_DATA_TO_ERROR    11
#define V_CL11_RD_DATA_TO_ERROR(x) ((x) << S_CL11_RD_DATA_TO_ERROR)
#define F_CL11_RD_DATA_TO_ERROR    V_CL11_RD_DATA_TO_ERROR(1U)

#define S_CL10_RD_DATA_TO_ERROR    10
#define V_CL10_RD_DATA_TO_ERROR(x) ((x) << S_CL10_RD_DATA_TO_ERROR)
#define F_CL10_RD_DATA_TO_ERROR    V_CL10_RD_DATA_TO_ERROR(1U)

#define S_CL9_RD_DATA_TO_ERROR    9
#define V_CL9_RD_DATA_TO_ERROR(x) ((x) << S_CL9_RD_DATA_TO_ERROR)
#define F_CL9_RD_DATA_TO_ERROR    V_CL9_RD_DATA_TO_ERROR(1U)

#define S_CL8_RD_DATA_TO_ERROR    8
#define V_CL8_RD_DATA_TO_ERROR(x) ((x) << S_CL8_RD_DATA_TO_ERROR)
#define F_CL8_RD_DATA_TO_ERROR    V_CL8_RD_DATA_TO_ERROR(1U)

#define S_CL7_RD_DATA_TO_ERROR    7
#define V_CL7_RD_DATA_TO_ERROR(x) ((x) << S_CL7_RD_DATA_TO_ERROR)
#define F_CL7_RD_DATA_TO_ERROR    V_CL7_RD_DATA_TO_ERROR(1U)

#define S_CL6_RD_DATA_TO_ERROR    6
#define V_CL6_RD_DATA_TO_ERROR(x) ((x) << S_CL6_RD_DATA_TO_ERROR)
#define F_CL6_RD_DATA_TO_ERROR    V_CL6_RD_DATA_TO_ERROR(1U)

#define S_CL5_RD_DATA_TO_ERROR    5
#define V_CL5_RD_DATA_TO_ERROR(x) ((x) << S_CL5_RD_DATA_TO_ERROR)
#define F_CL5_RD_DATA_TO_ERROR    V_CL5_RD_DATA_TO_ERROR(1U)

#define S_CL4_RD_DATA_TO_ERROR    4
#define V_CL4_RD_DATA_TO_ERROR(x) ((x) << S_CL4_RD_DATA_TO_ERROR)
#define F_CL4_RD_DATA_TO_ERROR    V_CL4_RD_DATA_TO_ERROR(1U)

#define S_CL3_RD_DATA_TO_ERROR    3
#define V_CL3_RD_DATA_TO_ERROR(x) ((x) << S_CL3_RD_DATA_TO_ERROR)
#define F_CL3_RD_DATA_TO_ERROR    V_CL3_RD_DATA_TO_ERROR(1U)

#define S_CL2_RD_DATA_TO_ERROR    2
#define V_CL2_RD_DATA_TO_ERROR(x) ((x) << S_CL2_RD_DATA_TO_ERROR)
#define F_CL2_RD_DATA_TO_ERROR    V_CL2_RD_DATA_TO_ERROR(1U)

#define S_CL1_RD_DATA_TO_ERROR    1
#define V_CL1_RD_DATA_TO_ERROR(x) ((x) << S_CL1_RD_DATA_TO_ERROR)
#define F_CL1_RD_DATA_TO_ERROR    V_CL1_RD_DATA_TO_ERROR(1U)

#define S_CL0_RD_DATA_TO_ERROR    0
#define V_CL0_RD_DATA_TO_ERROR(x) ((x) << S_CL0_RD_DATA_TO_ERROR)
#define F_CL0_RD_DATA_TO_ERROR    V_CL0_RD_DATA_TO_ERROR(1U)

#define S_FUTURE_CEXPANSION_RTS    29
#define M_FUTURE_CEXPANSION_RTS    0x7U
#define V_FUTURE_CEXPANSION_RTS(x) ((x) << S_FUTURE_CEXPANSION_RTS)
#define G_FUTURE_CEXPANSION_RTS(x) (((x) >> S_FUTURE_CEXPANSION_RTS) & M_FUTURE_CEXPANSION_RTS)

#define S_FUTURE_DEXPANSION_RTS    13
#define M_FUTURE_DEXPANSION_RTS    0x7U
#define V_FUTURE_DEXPANSION_RTS(x) ((x) << S_FUTURE_DEXPANSION_RTS)
#define G_FUTURE_DEXPANSION_RTS(x) (((x) >> S_FUTURE_DEXPANSION_RTS) & M_FUTURE_DEXPANSION_RTS)

#define S_CL14_RD_CMD_TO_ERROR    30
#define V_CL14_RD_CMD_TO_ERROR(x) ((x) << S_CL14_RD_CMD_TO_ERROR)
#define F_CL14_RD_CMD_TO_ERROR    V_CL14_RD_CMD_TO_ERROR(1U)

#define S_CL13_RD_CMD_TO_ERROR    29
#define V_CL13_RD_CMD_TO_ERROR(x) ((x) << S_CL13_RD_CMD_TO_ERROR)
#define F_CL13_RD_CMD_TO_ERROR    V_CL13_RD_CMD_TO_ERROR(1U)

#define S_CL14_RD_DATA_TO_ERROR    14
#define V_CL14_RD_DATA_TO_ERROR(x) ((x) << S_CL14_RD_DATA_TO_ERROR)
#define F_CL14_RD_DATA_TO_ERROR    V_CL14_RD_DATA_TO_ERROR(1U)

#define S_CL13_RD_DATA_TO_ERROR    13
#define V_CL13_RD_DATA_TO_ERROR(x) ((x) << S_CL13_RD_DATA_TO_ERROR)
#define F_CL13_RD_DATA_TO_ERROR    V_CL13_RD_DATA_TO_ERROR(1U)

#define A_MA_BKP_CNT_SEL 0x78e4

#define S_BKP_CNT_TYPE    30
#define M_BKP_CNT_TYPE    0x3U
#define V_BKP_CNT_TYPE(x) ((x) << S_BKP_CNT_TYPE)
#define G_BKP_CNT_TYPE(x) (((x) >> S_BKP_CNT_TYPE) & M_BKP_CNT_TYPE)

#define S_BKP_CLIENT    24
#define M_BKP_CLIENT    0xfU
#define V_BKP_CLIENT(x) ((x) << S_BKP_CLIENT)
#define G_BKP_CLIENT(x) (((x) >> S_BKP_CLIENT) & M_BKP_CLIENT)

#define A_MA_BKP_CNT 0x78e8
#define A_MA_WRT_ARB 0x78ec

#define S_WRT_EN    31
#define V_WRT_EN(x) ((x) << S_WRT_EN)
#define F_WRT_EN    V_WRT_EN(1U)

#define S_WR_TIM    16
#define M_WR_TIM    0xffU
#define V_WR_TIM(x) ((x) << S_WR_TIM)
#define G_WR_TIM(x) (((x) >> S_WR_TIM) & M_WR_TIM)

#define S_RD_WIN    8
#define M_RD_WIN    0xffU
#define V_RD_WIN(x) ((x) << S_RD_WIN)
#define G_RD_WIN(x) (((x) >> S_RD_WIN) & M_RD_WIN)

#define S_WR_WIN    0
#define M_WR_WIN    0xffU
#define V_WR_WIN(x) ((x) << S_WR_WIN)
#define G_WR_WIN(x) (((x) >> S_WR_WIN) & M_WR_WIN)

#define A_MA_IF_PARITY_ERROR_ENABLE 0x78f0

#define S_T5_FUTURE_DEXPANSION    13
#define M_T5_FUTURE_DEXPANSION    0x7ffffU
#define V_T5_FUTURE_DEXPANSION(x) ((x) << S_T5_FUTURE_DEXPANSION)
#define G_T5_FUTURE_DEXPANSION(x) (((x) >> S_T5_FUTURE_DEXPANSION) & M_T5_FUTURE_DEXPANSION)

#define S_CL12_IF_PAR_EN    12
#define V_CL12_IF_PAR_EN(x) ((x) << S_CL12_IF_PAR_EN)
#define F_CL12_IF_PAR_EN    V_CL12_IF_PAR_EN(1U)

#define S_CL11_IF_PAR_EN    11
#define V_CL11_IF_PAR_EN(x) ((x) << S_CL11_IF_PAR_EN)
#define F_CL11_IF_PAR_EN    V_CL11_IF_PAR_EN(1U)

#define S_CL10_IF_PAR_EN    10
#define V_CL10_IF_PAR_EN(x) ((x) << S_CL10_IF_PAR_EN)
#define F_CL10_IF_PAR_EN    V_CL10_IF_PAR_EN(1U)

#define S_CL9_IF_PAR_EN    9
#define V_CL9_IF_PAR_EN(x) ((x) << S_CL9_IF_PAR_EN)
#define F_CL9_IF_PAR_EN    V_CL9_IF_PAR_EN(1U)

#define S_CL8_IF_PAR_EN    8
#define V_CL8_IF_PAR_EN(x) ((x) << S_CL8_IF_PAR_EN)
#define F_CL8_IF_PAR_EN    V_CL8_IF_PAR_EN(1U)

#define S_CL7_IF_PAR_EN    7
#define V_CL7_IF_PAR_EN(x) ((x) << S_CL7_IF_PAR_EN)
#define F_CL7_IF_PAR_EN    V_CL7_IF_PAR_EN(1U)

#define S_CL6_IF_PAR_EN    6
#define V_CL6_IF_PAR_EN(x) ((x) << S_CL6_IF_PAR_EN)
#define F_CL6_IF_PAR_EN    V_CL6_IF_PAR_EN(1U)

#define S_CL5_IF_PAR_EN    5
#define V_CL5_IF_PAR_EN(x) ((x) << S_CL5_IF_PAR_EN)
#define F_CL5_IF_PAR_EN    V_CL5_IF_PAR_EN(1U)

#define S_CL4_IF_PAR_EN    4
#define V_CL4_IF_PAR_EN(x) ((x) << S_CL4_IF_PAR_EN)
#define F_CL4_IF_PAR_EN    V_CL4_IF_PAR_EN(1U)

#define S_CL3_IF_PAR_EN    3
#define V_CL3_IF_PAR_EN(x) ((x) << S_CL3_IF_PAR_EN)
#define F_CL3_IF_PAR_EN    V_CL3_IF_PAR_EN(1U)

#define S_CL2_IF_PAR_EN    2
#define V_CL2_IF_PAR_EN(x) ((x) << S_CL2_IF_PAR_EN)
#define F_CL2_IF_PAR_EN    V_CL2_IF_PAR_EN(1U)

#define S_CL1_IF_PAR_EN    1
#define V_CL1_IF_PAR_EN(x) ((x) << S_CL1_IF_PAR_EN)
#define F_CL1_IF_PAR_EN    V_CL1_IF_PAR_EN(1U)

#define S_CL0_IF_PAR_EN    0
#define V_CL0_IF_PAR_EN(x) ((x) << S_CL0_IF_PAR_EN)
#define F_CL0_IF_PAR_EN    V_CL0_IF_PAR_EN(1U)

#define S_FUTURE_DEXPANSION_IPE    13
#define M_FUTURE_DEXPANSION_IPE    0x7ffffU
#define V_FUTURE_DEXPANSION_IPE(x) ((x) << S_FUTURE_DEXPANSION_IPE)
#define G_FUTURE_DEXPANSION_IPE(x) (((x) >> S_FUTURE_DEXPANSION_IPE) & M_FUTURE_DEXPANSION_IPE)

#define S_CL14_IF_PAR_EN    14
#define V_CL14_IF_PAR_EN(x) ((x) << S_CL14_IF_PAR_EN)
#define F_CL14_IF_PAR_EN    V_CL14_IF_PAR_EN(1U)

#define S_CL13_IF_PAR_EN    13
#define V_CL13_IF_PAR_EN(x) ((x) << S_CL13_IF_PAR_EN)
#define F_CL13_IF_PAR_EN    V_CL13_IF_PAR_EN(1U)

#define A_MA_IF_PARITY_ERROR_STATUS 0x78f4

#define S_CL12_IF_PAR_ERROR    12
#define V_CL12_IF_PAR_ERROR(x) ((x) << S_CL12_IF_PAR_ERROR)
#define F_CL12_IF_PAR_ERROR    V_CL12_IF_PAR_ERROR(1U)

#define S_CL11_IF_PAR_ERROR    11
#define V_CL11_IF_PAR_ERROR(x) ((x) << S_CL11_IF_PAR_ERROR)
#define F_CL11_IF_PAR_ERROR    V_CL11_IF_PAR_ERROR(1U)

#define S_CL10_IF_PAR_ERROR    10
#define V_CL10_IF_PAR_ERROR(x) ((x) << S_CL10_IF_PAR_ERROR)
#define F_CL10_IF_PAR_ERROR    V_CL10_IF_PAR_ERROR(1U)

#define S_CL9_IF_PAR_ERROR    9
#define V_CL9_IF_PAR_ERROR(x) ((x) << S_CL9_IF_PAR_ERROR)
#define F_CL9_IF_PAR_ERROR    V_CL9_IF_PAR_ERROR(1U)

#define S_CL8_IF_PAR_ERROR    8
#define V_CL8_IF_PAR_ERROR(x) ((x) << S_CL8_IF_PAR_ERROR)
#define F_CL8_IF_PAR_ERROR    V_CL8_IF_PAR_ERROR(1U)

#define S_CL7_IF_PAR_ERROR    7
#define V_CL7_IF_PAR_ERROR(x) ((x) << S_CL7_IF_PAR_ERROR)
#define F_CL7_IF_PAR_ERROR    V_CL7_IF_PAR_ERROR(1U)

#define S_CL6_IF_PAR_ERROR    6
#define V_CL6_IF_PAR_ERROR(x) ((x) << S_CL6_IF_PAR_ERROR)
#define F_CL6_IF_PAR_ERROR    V_CL6_IF_PAR_ERROR(1U)

#define S_CL5_IF_PAR_ERROR    5
#define V_CL5_IF_PAR_ERROR(x) ((x) << S_CL5_IF_PAR_ERROR)
#define F_CL5_IF_PAR_ERROR    V_CL5_IF_PAR_ERROR(1U)

#define S_CL4_IF_PAR_ERROR    4
#define V_CL4_IF_PAR_ERROR(x) ((x) << S_CL4_IF_PAR_ERROR)
#define F_CL4_IF_PAR_ERROR    V_CL4_IF_PAR_ERROR(1U)

#define S_CL3_IF_PAR_ERROR    3
#define V_CL3_IF_PAR_ERROR(x) ((x) << S_CL3_IF_PAR_ERROR)
#define F_CL3_IF_PAR_ERROR    V_CL3_IF_PAR_ERROR(1U)

#define S_CL2_IF_PAR_ERROR    2
#define V_CL2_IF_PAR_ERROR(x) ((x) << S_CL2_IF_PAR_ERROR)
#define F_CL2_IF_PAR_ERROR    V_CL2_IF_PAR_ERROR(1U)

#define S_CL1_IF_PAR_ERROR    1
#define V_CL1_IF_PAR_ERROR(x) ((x) << S_CL1_IF_PAR_ERROR)
#define F_CL1_IF_PAR_ERROR    V_CL1_IF_PAR_ERROR(1U)

#define S_CL0_IF_PAR_ERROR    0
#define V_CL0_IF_PAR_ERROR(x) ((x) << S_CL0_IF_PAR_ERROR)
#define F_CL0_IF_PAR_ERROR    V_CL0_IF_PAR_ERROR(1U)

#define S_FUTURE_DEXPANSION_IPS    13
#define M_FUTURE_DEXPANSION_IPS    0x7ffffU
#define V_FUTURE_DEXPANSION_IPS(x) ((x) << S_FUTURE_DEXPANSION_IPS)
#define G_FUTURE_DEXPANSION_IPS(x) (((x) >> S_FUTURE_DEXPANSION_IPS) & M_FUTURE_DEXPANSION_IPS)

#define S_CL14_IF_PAR_ERROR    14
#define V_CL14_IF_PAR_ERROR(x) ((x) << S_CL14_IF_PAR_ERROR)
#define F_CL14_IF_PAR_ERROR    V_CL14_IF_PAR_ERROR(1U)

#define S_CL13_IF_PAR_ERROR    13
#define V_CL13_IF_PAR_ERROR(x) ((x) << S_CL13_IF_PAR_ERROR)
#define F_CL13_IF_PAR_ERROR    V_CL13_IF_PAR_ERROR(1U)

#define A_MA_LOCAL_DEBUG_CFG 0x78f8

#define S_DEBUG_OR    15
#define V_DEBUG_OR(x) ((x) << S_DEBUG_OR)
#define F_DEBUG_OR    V_DEBUG_OR(1U)

#define S_DEBUG_HI    14
#define V_DEBUG_HI(x) ((x) << S_DEBUG_HI)
#define F_DEBUG_HI    V_DEBUG_HI(1U)

#define S_DEBUG_RPT    13
#define V_DEBUG_RPT(x) ((x) << S_DEBUG_RPT)
#define F_DEBUG_RPT    V_DEBUG_RPT(1U)

#define S_DEBUGPAGE    10
#define M_DEBUGPAGE    0x7U
#define V_DEBUGPAGE(x) ((x) << S_DEBUGPAGE)
#define G_DEBUGPAGE(x) (((x) >> S_DEBUGPAGE) & M_DEBUGPAGE)

#define A_MA_LOCAL_DEBUG_RPT 0x78fc
#define A_MA_CLIENT13_PR_THRESHOLD 0x7900
#define A_MA_CLIENT13_CR_THRESHOLD 0x7904
#define A_MA_CRYPTO_DEBUG_CNT 0x7908
#define A_MA_CRYPTO_WRDATA_CNT 0x790c
#define A_MA_CRYPTO_RDDATA_CNT 0x7910
#define A_MA_LOCAL_DEBUG_PERF_CFG 0x7914
#define A_MA_LOCAL_DEBUG_PERF_RPT 0x7918
#define A_MA_PCIE_THROTTLE 0x791c
#define A_MA_CLIENT14_PR_THRESHOLD 0x7920
#define A_MA_CLIENT14_CR_THRESHOLD 0x7924
#define A_MA_CIM_TH1_DEBUG_CNT 0x7928
#define A_MA_CIM_TH1_WRDATA_CNT 0x792c
#define A_MA_CIM_TH1_RDDATA_CNT 0x7930
#define A_MA_CIM_THREAD1_MAPPER 0x7934

#define S_CIM_THREAD1_EN    0
#define M_CIM_THREAD1_EN    0xffU
#define V_CIM_THREAD1_EN(x) ((x) << S_CIM_THREAD1_EN)
#define G_CIM_THREAD1_EN(x) (((x) >> S_CIM_THREAD1_EN) & M_CIM_THREAD1_EN)

#define A_MA_PIO_CI_SGE_TH0_BASE 0x7938

#define S_SGE_TH0_BASE    0
#define M_SGE_TH0_BASE    0xffffU
#define V_SGE_TH0_BASE(x) ((x) << S_SGE_TH0_BASE)
#define G_SGE_TH0_BASE(x) (((x) >> S_SGE_TH0_BASE) & M_SGE_TH0_BASE)

#define A_MA_PIO_CI_SGE_TH1_BASE 0x793c

#define S_SGE_TH1_BASE    0
#define M_SGE_TH1_BASE    0xffffU
#define V_SGE_TH1_BASE(x) ((x) << S_SGE_TH1_BASE)
#define G_SGE_TH1_BASE(x) (((x) >> S_SGE_TH1_BASE) & M_SGE_TH1_BASE)

#define A_MA_PIO_CI_ULPTX_BASE 0x7940

#define S_ULPTX_BASE    0
#define M_ULPTX_BASE    0xffffU
#define V_ULPTX_BASE(x) ((x) << S_ULPTX_BASE)
#define G_ULPTX_BASE(x) (((x) >> S_ULPTX_BASE) & M_ULPTX_BASE)

#define A_MA_PIO_CI_ULPRX_BASE 0x7944

#define S_ULPRX_BASE    0
#define M_ULPRX_BASE    0xffffU
#define V_ULPRX_BASE(x) ((x) << S_ULPRX_BASE)
#define G_ULPRX_BASE(x) (((x) >> S_ULPRX_BASE) & M_ULPRX_BASE)

#define A_MA_PIO_CI_ULPTXRX_BASE 0x7948

#define S_ULPTXRX_BASE    0
#define M_ULPTXRX_BASE    0xffffU
#define V_ULPTXRX_BASE(x) ((x) << S_ULPTXRX_BASE)
#define G_ULPTXRX_BASE(x) (((x) >> S_ULPTXRX_BASE) & M_ULPTXRX_BASE)

#define A_MA_PIO_CI_TP_TH0_BASE 0x794c

#define S_TP_TH0_BASE    0
#define M_TP_TH0_BASE    0xffffU
#define V_TP_TH0_BASE(x) ((x) << S_TP_TH0_BASE)
#define G_TP_TH0_BASE(x) (((x) >> S_TP_TH0_BASE) & M_TP_TH0_BASE)

#define A_MA_PIO_CI_TP_TH1_BASE 0x7950

#define S_TP_TH1_BASE    0
#define M_TP_TH1_BASE    0xffffU
#define V_TP_TH1_BASE(x) ((x) << S_TP_TH1_BASE)
#define G_TP_TH1_BASE(x) (((x) >> S_TP_TH1_BASE) & M_TP_TH1_BASE)

#define A_MA_PIO_CI_LE_BASE 0x7954

#define S_LE_BASE    0
#define M_LE_BASE    0xffffU
#define V_LE_BASE(x) ((x) << S_LE_BASE)
#define G_LE_BASE(x) (((x) >> S_LE_BASE) & M_LE_BASE)

#define A_MA_PIO_CI_CIM_TH0_BASE 0x7958

#define S_CIM_TH0_BASE    0
#define M_CIM_TH0_BASE    0xffffU
#define V_CIM_TH0_BASE(x) ((x) << S_CIM_TH0_BASE)
#define G_CIM_TH0_BASE(x) (((x) >> S_CIM_TH0_BASE) & M_CIM_TH0_BASE)

#define A_MA_PIO_CI_PCIE_BASE 0x795c

#define S_PCIE_BASE    0
#define M_PCIE_BASE    0xffffU
#define V_PCIE_BASE(x) ((x) << S_PCIE_BASE)
#define G_PCIE_BASE(x) (((x) >> S_PCIE_BASE) & M_PCIE_BASE)

#define A_MA_PIO_CI_PMTX_BASE 0x7960

#define S_PMTX_BASE    0
#define M_PMTX_BASE    0xffffU
#define V_PMTX_BASE(x) ((x) << S_PMTX_BASE)
#define G_PMTX_BASE(x) (((x) >> S_PMTX_BASE) & M_PMTX_BASE)

#define A_MA_PIO_CI_PMRX_BASE 0x7964

#define S_PMRX_BASE    0
#define M_PMRX_BASE    0xffffU
#define V_PMRX_BASE(x) ((x) << S_PMRX_BASE)
#define G_PMRX_BASE(x) (((x) >> S_PMRX_BASE) & M_PMRX_BASE)

#define A_MA_PIO_CI_HMA_BASE 0x7968

#define S_HMACLIENTBASE    0
#define M_HMACLIENTBASE    0xffffU
#define V_HMACLIENTBASE(x) ((x) << S_HMACLIENTBASE)
#define G_HMACLIENTBASE(x) (((x) >> S_HMACLIENTBASE) & M_HMACLIENTBASE)

#define A_MA_PIO_CI_CRYPTO_BASE 0x796c

#define S_CRYPTO_BASE    0
#define M_CRYPTO_BASE    0xffffU
#define V_CRYPTO_BASE(x) ((x) << S_CRYPTO_BASE)
#define G_CRYPTO_BASE(x) (((x) >> S_CRYPTO_BASE) & M_CRYPTO_BASE)

#define A_MA_PIO_CI_CIM_TH1_BASE 0x7970

#define S_CIM_TH1_BASE    0
#define M_CIM_TH1_BASE    0xffffU
#define V_CIM_TH1_BASE(x) ((x) << S_CIM_TH1_BASE)
#define G_CIM_TH1_BASE(x) (((x) >> S_CIM_TH1_BASE) & M_CIM_TH1_BASE)

#define A_MA_SGE_THREAD_0_CLIENT_INTERFACE_EXTERNAL 0xa000

#define S_CMDVLD0    31
#define V_CMDVLD0(x) ((x) << S_CMDVLD0)
#define F_CMDVLD0    V_CMDVLD0(1U)

#define S_CMDRDY0    30
#define V_CMDRDY0(x) ((x) << S_CMDRDY0)
#define F_CMDRDY0    V_CMDRDY0(1U)

#define S_CMDTYPE0    29
#define V_CMDTYPE0(x) ((x) << S_CMDTYPE0)
#define F_CMDTYPE0    V_CMDTYPE0(1U)

#define S_CMDLEN0    21
#define M_CMDLEN0    0xffU
#define V_CMDLEN0(x) ((x) << S_CMDLEN0)
#define G_CMDLEN0(x) (((x) >> S_CMDLEN0) & M_CMDLEN0)

#define S_CMDADDR0    8
#define M_CMDADDR0    0x1fffU
#define V_CMDADDR0(x) ((x) << S_CMDADDR0)
#define G_CMDADDR0(x) (((x) >> S_CMDADDR0) & M_CMDADDR0)

#define S_WRDATAVLD0    7
#define V_WRDATAVLD0(x) ((x) << S_WRDATAVLD0)
#define F_WRDATAVLD0    V_WRDATAVLD0(1U)

#define S_WRDATARDY0    6
#define V_WRDATARDY0(x) ((x) << S_WRDATARDY0)
#define F_WRDATARDY0    V_WRDATARDY0(1U)

#define S_RDDATARDY0    5
#define V_RDDATARDY0(x) ((x) << S_RDDATARDY0)
#define F_RDDATARDY0    V_RDDATARDY0(1U)

#define S_RDDATAVLD0    4
#define V_RDDATAVLD0(x) ((x) << S_RDDATAVLD0)
#define F_RDDATAVLD0    V_RDDATAVLD0(1U)

#define S_RDDATA0    0
#define M_RDDATA0    0xfU
#define V_RDDATA0(x) ((x) << S_RDDATA0)
#define G_RDDATA0(x) (((x) >> S_RDDATA0) & M_RDDATA0)

#define A_MA_SGE_THREAD_1_CLIENT_INTERFACE_EXTERNAL 0xa001

#define S_CMDVLD1    31
#define V_CMDVLD1(x) ((x) << S_CMDVLD1)
#define F_CMDVLD1    V_CMDVLD1(1U)

#define S_CMDRDY1    30
#define V_CMDRDY1(x) ((x) << S_CMDRDY1)
#define F_CMDRDY1    V_CMDRDY1(1U)

#define S_CMDTYPE1    29
#define V_CMDTYPE1(x) ((x) << S_CMDTYPE1)
#define F_CMDTYPE1    V_CMDTYPE1(1U)

#define S_CMDLEN1    21
#define M_CMDLEN1    0xffU
#define V_CMDLEN1(x) ((x) << S_CMDLEN1)
#define G_CMDLEN1(x) (((x) >> S_CMDLEN1) & M_CMDLEN1)

#define S_CMDADDR1    8
#define M_CMDADDR1    0x1fffU
#define V_CMDADDR1(x) ((x) << S_CMDADDR1)
#define G_CMDADDR1(x) (((x) >> S_CMDADDR1) & M_CMDADDR1)

#define S_WRDATAVLD1    7
#define V_WRDATAVLD1(x) ((x) << S_WRDATAVLD1)
#define F_WRDATAVLD1    V_WRDATAVLD1(1U)

#define S_WRDATARDY1    6
#define V_WRDATARDY1(x) ((x) << S_WRDATARDY1)
#define F_WRDATARDY1    V_WRDATARDY1(1U)

#define S_RDDATARDY1    5
#define V_RDDATARDY1(x) ((x) << S_RDDATARDY1)
#define F_RDDATARDY1    V_RDDATARDY1(1U)

#define S_RDDATAVLD1    4
#define V_RDDATAVLD1(x) ((x) << S_RDDATAVLD1)
#define F_RDDATAVLD1    V_RDDATAVLD1(1U)

#define S_RDDATA1    0
#define M_RDDATA1    0xfU
#define V_RDDATA1(x) ((x) << S_RDDATA1)
#define G_RDDATA1(x) (((x) >> S_RDDATA1) & M_RDDATA1)

#define A_MA_ULP_TX_CLIENT_INTERFACE_EXTERNAL 0xa002

#define S_CMDVLD2    31
#define V_CMDVLD2(x) ((x) << S_CMDVLD2)
#define F_CMDVLD2    V_CMDVLD2(1U)

#define S_CMDRDY2    30
#define V_CMDRDY2(x) ((x) << S_CMDRDY2)
#define F_CMDRDY2    V_CMDRDY2(1U)

#define S_CMDTYPE2    29
#define V_CMDTYPE2(x) ((x) << S_CMDTYPE2)
#define F_CMDTYPE2    V_CMDTYPE2(1U)

#define S_CMDLEN2    21
#define M_CMDLEN2    0xffU
#define V_CMDLEN2(x) ((x) << S_CMDLEN2)
#define G_CMDLEN2(x) (((x) >> S_CMDLEN2) & M_CMDLEN2)

#define S_CMDADDR2    8
#define M_CMDADDR2    0x1fffU
#define V_CMDADDR2(x) ((x) << S_CMDADDR2)
#define G_CMDADDR2(x) (((x) >> S_CMDADDR2) & M_CMDADDR2)

#define S_WRDATAVLD2    7
#define V_WRDATAVLD2(x) ((x) << S_WRDATAVLD2)
#define F_WRDATAVLD2    V_WRDATAVLD2(1U)

#define S_WRDATARDY2    6
#define V_WRDATARDY2(x) ((x) << S_WRDATARDY2)
#define F_WRDATARDY2    V_WRDATARDY2(1U)

#define S_RDDATARDY2    5
#define V_RDDATARDY2(x) ((x) << S_RDDATARDY2)
#define F_RDDATARDY2    V_RDDATARDY2(1U)

#define S_RDDATAVLD2    4
#define V_RDDATAVLD2(x) ((x) << S_RDDATAVLD2)
#define F_RDDATAVLD2    V_RDDATAVLD2(1U)

#define S_RDDATA2    0
#define M_RDDATA2    0xfU
#define V_RDDATA2(x) ((x) << S_RDDATA2)
#define G_RDDATA2(x) (((x) >> S_RDDATA2) & M_RDDATA2)

#define A_MA_ULP_RX_CLIENT_INTERFACE_EXTERNAL 0xa003

#define S_CMDVLD3    31
#define V_CMDVLD3(x) ((x) << S_CMDVLD3)
#define F_CMDVLD3    V_CMDVLD3(1U)

#define S_CMDRDY3    30
#define V_CMDRDY3(x) ((x) << S_CMDRDY3)
#define F_CMDRDY3    V_CMDRDY3(1U)

#define S_CMDTYPE3    29
#define V_CMDTYPE3(x) ((x) << S_CMDTYPE3)
#define F_CMDTYPE3    V_CMDTYPE3(1U)

#define S_CMDLEN3    21
#define M_CMDLEN3    0xffU
#define V_CMDLEN3(x) ((x) << S_CMDLEN3)
#define G_CMDLEN3(x) (((x) >> S_CMDLEN3) & M_CMDLEN3)

#define S_CMDADDR3    8
#define M_CMDADDR3    0x1fffU
#define V_CMDADDR3(x) ((x) << S_CMDADDR3)
#define G_CMDADDR3(x) (((x) >> S_CMDADDR3) & M_CMDADDR3)

#define S_WRDATAVLD3    7
#define V_WRDATAVLD3(x) ((x) << S_WRDATAVLD3)
#define F_WRDATAVLD3    V_WRDATAVLD3(1U)

#define S_WRDATARDY3    6
#define V_WRDATARDY3(x) ((x) << S_WRDATARDY3)
#define F_WRDATARDY3    V_WRDATARDY3(1U)

#define S_RDDATARDY3    5
#define V_RDDATARDY3(x) ((x) << S_RDDATARDY3)
#define F_RDDATARDY3    V_RDDATARDY3(1U)

#define S_RDDATAVLD3    4
#define V_RDDATAVLD3(x) ((x) << S_RDDATAVLD3)
#define F_RDDATAVLD3    V_RDDATAVLD3(1U)

#define S_RDDATA3    0
#define M_RDDATA3    0xfU
#define V_RDDATA3(x) ((x) << S_RDDATA3)
#define G_RDDATA3(x) (((x) >> S_RDDATA3) & M_RDDATA3)

#define A_MA_ULP_TX_RX_CLIENT_INTERFACE_EXTERNAL 0xa004

#define S_CMDVLD4    31
#define V_CMDVLD4(x) ((x) << S_CMDVLD4)
#define F_CMDVLD4    V_CMDVLD4(1U)

#define S_CMDRDY4    30
#define V_CMDRDY4(x) ((x) << S_CMDRDY4)
#define F_CMDRDY4    V_CMDRDY4(1U)

#define S_CMDTYPE4    29
#define V_CMDTYPE4(x) ((x) << S_CMDTYPE4)
#define F_CMDTYPE4    V_CMDTYPE4(1U)

#define S_CMDLEN4    21
#define M_CMDLEN4    0xffU
#define V_CMDLEN4(x) ((x) << S_CMDLEN4)
#define G_CMDLEN4(x) (((x) >> S_CMDLEN4) & M_CMDLEN4)

#define S_CMDADDR4    8
#define M_CMDADDR4    0x1fffU
#define V_CMDADDR4(x) ((x) << S_CMDADDR4)
#define G_CMDADDR4(x) (((x) >> S_CMDADDR4) & M_CMDADDR4)

#define S_WRDATAVLD4    7
#define V_WRDATAVLD4(x) ((x) << S_WRDATAVLD4)
#define F_WRDATAVLD4    V_WRDATAVLD4(1U)

#define S_WRDATARDY4    6
#define V_WRDATARDY4(x) ((x) << S_WRDATARDY4)
#define F_WRDATARDY4    V_WRDATARDY4(1U)

#define S_RDDATARDY4    5
#define V_RDDATARDY4(x) ((x) << S_RDDATARDY4)
#define F_RDDATARDY4    V_RDDATARDY4(1U)

#define S_RDDATAVLD4    4
#define V_RDDATAVLD4(x) ((x) << S_RDDATAVLD4)
#define F_RDDATAVLD4    V_RDDATAVLD4(1U)

#define S_RDDATA4    0
#define M_RDDATA4    0xfU
#define V_RDDATA4(x) ((x) << S_RDDATA4)
#define G_RDDATA4(x) (((x) >> S_RDDATA4) & M_RDDATA4)

#define A_MA_TP_THREAD_0_CLIENT_INTERFACE_EXTERNAL 0xa005

#define S_CMDVLD5    31
#define V_CMDVLD5(x) ((x) << S_CMDVLD5)
#define F_CMDVLD5    V_CMDVLD5(1U)

#define S_CMDRDY5    30
#define V_CMDRDY5(x) ((x) << S_CMDRDY5)
#define F_CMDRDY5    V_CMDRDY5(1U)

#define S_CMDTYPE5    29
#define V_CMDTYPE5(x) ((x) << S_CMDTYPE5)
#define F_CMDTYPE5    V_CMDTYPE5(1U)

#define S_CMDLEN5    21
#define M_CMDLEN5    0xffU
#define V_CMDLEN5(x) ((x) << S_CMDLEN5)
#define G_CMDLEN5(x) (((x) >> S_CMDLEN5) & M_CMDLEN5)

#define S_CMDADDR5    8
#define M_CMDADDR5    0x1fffU
#define V_CMDADDR5(x) ((x) << S_CMDADDR5)
#define G_CMDADDR5(x) (((x) >> S_CMDADDR5) & M_CMDADDR5)

#define S_WRDATAVLD5    7
#define V_WRDATAVLD5(x) ((x) << S_WRDATAVLD5)
#define F_WRDATAVLD5    V_WRDATAVLD5(1U)

#define S_WRDATARDY5    6
#define V_WRDATARDY5(x) ((x) << S_WRDATARDY5)
#define F_WRDATARDY5    V_WRDATARDY5(1U)

#define S_RDDATARDY5    5
#define V_RDDATARDY5(x) ((x) << S_RDDATARDY5)
#define F_RDDATARDY5    V_RDDATARDY5(1U)

#define S_RDDATAVLD5    4
#define V_RDDATAVLD5(x) ((x) << S_RDDATAVLD5)
#define F_RDDATAVLD5    V_RDDATAVLD5(1U)

#define S_RDDATA5    0
#define M_RDDATA5    0xfU
#define V_RDDATA5(x) ((x) << S_RDDATA5)
#define G_RDDATA5(x) (((x) >> S_RDDATA5) & M_RDDATA5)

#define A_MA_TP_THREAD_1_CLIENT_INTERFACE_EXTERNAL 0xa006

#define S_CMDVLD6    31
#define V_CMDVLD6(x) ((x) << S_CMDVLD6)
#define F_CMDVLD6    V_CMDVLD6(1U)

#define S_CMDRDY6    30
#define V_CMDRDY6(x) ((x) << S_CMDRDY6)
#define F_CMDRDY6    V_CMDRDY6(1U)

#define S_CMDTYPE6    29
#define V_CMDTYPE6(x) ((x) << S_CMDTYPE6)
#define F_CMDTYPE6    V_CMDTYPE6(1U)

#define S_CMDLEN6    21
#define M_CMDLEN6    0xffU
#define V_CMDLEN6(x) ((x) << S_CMDLEN6)
#define G_CMDLEN6(x) (((x) >> S_CMDLEN6) & M_CMDLEN6)

#define S_CMDADDR6    8
#define M_CMDADDR6    0x1fffU
#define V_CMDADDR6(x) ((x) << S_CMDADDR6)
#define G_CMDADDR6(x) (((x) >> S_CMDADDR6) & M_CMDADDR6)

#define S_WRDATAVLD6    7
#define V_WRDATAVLD6(x) ((x) << S_WRDATAVLD6)
#define F_WRDATAVLD6    V_WRDATAVLD6(1U)

#define S_WRDATARDY6    6
#define V_WRDATARDY6(x) ((x) << S_WRDATARDY6)
#define F_WRDATARDY6    V_WRDATARDY6(1U)

#define S_RDDATARDY6    5
#define V_RDDATARDY6(x) ((x) << S_RDDATARDY6)
#define F_RDDATARDY6    V_RDDATARDY6(1U)

#define S_RDDATAVLD6    4
#define V_RDDATAVLD6(x) ((x) << S_RDDATAVLD6)
#define F_RDDATAVLD6    V_RDDATAVLD6(1U)

#define S_RDDATA6    0
#define M_RDDATA6    0xfU
#define V_RDDATA6(x) ((x) << S_RDDATA6)
#define G_RDDATA6(x) (((x) >> S_RDDATA6) & M_RDDATA6)

#define A_MA_LE_CLIENT_INTERFACE_EXTERNAL 0xa007

#define S_CMDVLD7    31
#define V_CMDVLD7(x) ((x) << S_CMDVLD7)
#define F_CMDVLD7    V_CMDVLD7(1U)

#define S_CMDRDY7    30
#define V_CMDRDY7(x) ((x) << S_CMDRDY7)
#define F_CMDRDY7    V_CMDRDY7(1U)

#define S_CMDTYPE7    29
#define V_CMDTYPE7(x) ((x) << S_CMDTYPE7)
#define F_CMDTYPE7    V_CMDTYPE7(1U)

#define S_CMDLEN7    21
#define M_CMDLEN7    0xffU
#define V_CMDLEN7(x) ((x) << S_CMDLEN7)
#define G_CMDLEN7(x) (((x) >> S_CMDLEN7) & M_CMDLEN7)

#define S_CMDADDR7    8
#define M_CMDADDR7    0x1fffU
#define V_CMDADDR7(x) ((x) << S_CMDADDR7)
#define G_CMDADDR7(x) (((x) >> S_CMDADDR7) & M_CMDADDR7)

#define S_WRDATAVLD7    7
#define V_WRDATAVLD7(x) ((x) << S_WRDATAVLD7)
#define F_WRDATAVLD7    V_WRDATAVLD7(1U)

#define S_WRDATARDY7    6
#define V_WRDATARDY7(x) ((x) << S_WRDATARDY7)
#define F_WRDATARDY7    V_WRDATARDY7(1U)

#define S_RDDATARDY7    5
#define V_RDDATARDY7(x) ((x) << S_RDDATARDY7)
#define F_RDDATARDY7    V_RDDATARDY7(1U)

#define S_RDDATAVLD7    4
#define V_RDDATAVLD7(x) ((x) << S_RDDATAVLD7)
#define F_RDDATAVLD7    V_RDDATAVLD7(1U)

#define S_RDDATA7    0
#define M_RDDATA7    0xfU
#define V_RDDATA7(x) ((x) << S_RDDATA7)
#define G_RDDATA7(x) (((x) >> S_RDDATA7) & M_RDDATA7)

#define A_MA_CIM_CLIENT_INTERFACE_EXTERNAL 0xa008

#define S_CMDVLD8    31
#define V_CMDVLD8(x) ((x) << S_CMDVLD8)
#define F_CMDVLD8    V_CMDVLD8(1U)

#define S_CMDRDY8    30
#define V_CMDRDY8(x) ((x) << S_CMDRDY8)
#define F_CMDRDY8    V_CMDRDY8(1U)

#define S_CMDTYPE8    29
#define V_CMDTYPE8(x) ((x) << S_CMDTYPE8)
#define F_CMDTYPE8    V_CMDTYPE8(1U)

#define S_CMDLEN8    21
#define M_CMDLEN8    0xffU
#define V_CMDLEN8(x) ((x) << S_CMDLEN8)
#define G_CMDLEN8(x) (((x) >> S_CMDLEN8) & M_CMDLEN8)

#define S_CMDADDR8    8
#define M_CMDADDR8    0x1fffU
#define V_CMDADDR8(x) ((x) << S_CMDADDR8)
#define G_CMDADDR8(x) (((x) >> S_CMDADDR8) & M_CMDADDR8)

#define S_WRDATAVLD8    7
#define V_WRDATAVLD8(x) ((x) << S_WRDATAVLD8)
#define F_WRDATAVLD8    V_WRDATAVLD8(1U)

#define S_WRDATARDY8    6
#define V_WRDATARDY8(x) ((x) << S_WRDATARDY8)
#define F_WRDATARDY8    V_WRDATARDY8(1U)

#define S_RDDATARDY8    5
#define V_RDDATARDY8(x) ((x) << S_RDDATARDY8)
#define F_RDDATARDY8    V_RDDATARDY8(1U)

#define S_RDDATAVLD8    4
#define V_RDDATAVLD8(x) ((x) << S_RDDATAVLD8)
#define F_RDDATAVLD8    V_RDDATAVLD8(1U)

#define S_RDDATA8    0
#define M_RDDATA8    0xfU
#define V_RDDATA8(x) ((x) << S_RDDATA8)
#define G_RDDATA8(x) (((x) >> S_RDDATA8) & M_RDDATA8)

#define A_MA_PCIE_CLIENT_INTERFACE_EXTERNAL 0xa009

#define S_CMDVLD9    31
#define V_CMDVLD9(x) ((x) << S_CMDVLD9)
#define F_CMDVLD9    V_CMDVLD9(1U)

#define S_CMDRDY9    30
#define V_CMDRDY9(x) ((x) << S_CMDRDY9)
#define F_CMDRDY9    V_CMDRDY9(1U)

#define S_CMDTYPE9    29
#define V_CMDTYPE9(x) ((x) << S_CMDTYPE9)
#define F_CMDTYPE9    V_CMDTYPE9(1U)

#define S_CMDLEN9    21
#define M_CMDLEN9    0xffU
#define V_CMDLEN9(x) ((x) << S_CMDLEN9)
#define G_CMDLEN9(x) (((x) >> S_CMDLEN9) & M_CMDLEN9)

#define S_CMDADDR9    8
#define M_CMDADDR9    0x1fffU
#define V_CMDADDR9(x) ((x) << S_CMDADDR9)
#define G_CMDADDR9(x) (((x) >> S_CMDADDR9) & M_CMDADDR9)

#define S_WRDATAVLD9    7
#define V_WRDATAVLD9(x) ((x) << S_WRDATAVLD9)
#define F_WRDATAVLD9    V_WRDATAVLD9(1U)

#define S_WRDATARDY9    6
#define V_WRDATARDY9(x) ((x) << S_WRDATARDY9)
#define F_WRDATARDY9    V_WRDATARDY9(1U)

#define S_RDDATARDY9    5
#define V_RDDATARDY9(x) ((x) << S_RDDATARDY9)
#define F_RDDATARDY9    V_RDDATARDY9(1U)

#define S_RDDATAVLD9    4
#define V_RDDATAVLD9(x) ((x) << S_RDDATAVLD9)
#define F_RDDATAVLD9    V_RDDATAVLD9(1U)

#define S_RDDATA9    0
#define M_RDDATA9    0xfU
#define V_RDDATA9(x) ((x) << S_RDDATA9)
#define G_RDDATA9(x) (((x) >> S_RDDATA9) & M_RDDATA9)

#define A_MA_PM_TX_CLIENT_INTERFACE_EXTERNAL 0xa00a

#define S_CMDVLD10    31
#define V_CMDVLD10(x) ((x) << S_CMDVLD10)
#define F_CMDVLD10    V_CMDVLD10(1U)

#define S_CMDRDY10    30
#define V_CMDRDY10(x) ((x) << S_CMDRDY10)
#define F_CMDRDY10    V_CMDRDY10(1U)

#define S_CMDTYPE10    29
#define V_CMDTYPE10(x) ((x) << S_CMDTYPE10)
#define F_CMDTYPE10    V_CMDTYPE10(1U)

#define S_CMDLEN10    21
#define M_CMDLEN10    0xffU
#define V_CMDLEN10(x) ((x) << S_CMDLEN10)
#define G_CMDLEN10(x) (((x) >> S_CMDLEN10) & M_CMDLEN10)

#define S_CMDADDR10    8
#define M_CMDADDR10    0x1fffU
#define V_CMDADDR10(x) ((x) << S_CMDADDR10)
#define G_CMDADDR10(x) (((x) >> S_CMDADDR10) & M_CMDADDR10)

#define S_WRDATAVLD10    7
#define V_WRDATAVLD10(x) ((x) << S_WRDATAVLD10)
#define F_WRDATAVLD10    V_WRDATAVLD10(1U)

#define S_WRDATARDY10    6
#define V_WRDATARDY10(x) ((x) << S_WRDATARDY10)
#define F_WRDATARDY10    V_WRDATARDY10(1U)

#define S_RDDATARDY10    5
#define V_RDDATARDY10(x) ((x) << S_RDDATARDY10)
#define F_RDDATARDY10    V_RDDATARDY10(1U)

#define S_RDDATAVLD10    4
#define V_RDDATAVLD10(x) ((x) << S_RDDATAVLD10)
#define F_RDDATAVLD10    V_RDDATAVLD10(1U)

#define S_RDDATA10    0
#define M_RDDATA10    0xfU
#define V_RDDATA10(x) ((x) << S_RDDATA10)
#define G_RDDATA10(x) (((x) >> S_RDDATA10) & M_RDDATA10)

#define A_MA_PM_RX_CLIENT_INTERFACE_EXTERNAL 0xa00b

#define S_CMDVLD11    31
#define V_CMDVLD11(x) ((x) << S_CMDVLD11)
#define F_CMDVLD11    V_CMDVLD11(1U)

#define S_CMDRDY11    30
#define V_CMDRDY11(x) ((x) << S_CMDRDY11)
#define F_CMDRDY11    V_CMDRDY11(1U)

#define S_CMDTYPE11    29
#define V_CMDTYPE11(x) ((x) << S_CMDTYPE11)
#define F_CMDTYPE11    V_CMDTYPE11(1U)

#define S_CMDLEN11    21
#define M_CMDLEN11    0xffU
#define V_CMDLEN11(x) ((x) << S_CMDLEN11)
#define G_CMDLEN11(x) (((x) >> S_CMDLEN11) & M_CMDLEN11)

#define S_CMDADDR11    8
#define M_CMDADDR11    0x1fffU
#define V_CMDADDR11(x) ((x) << S_CMDADDR11)
#define G_CMDADDR11(x) (((x) >> S_CMDADDR11) & M_CMDADDR11)

#define S_WRDATAVLD11    7
#define V_WRDATAVLD11(x) ((x) << S_WRDATAVLD11)
#define F_WRDATAVLD11    V_WRDATAVLD11(1U)

#define S_WRDATARDY11    6
#define V_WRDATARDY11(x) ((x) << S_WRDATARDY11)
#define F_WRDATARDY11    V_WRDATARDY11(1U)

#define S_RDDATARDY11    5
#define V_RDDATARDY11(x) ((x) << S_RDDATARDY11)
#define F_RDDATARDY11    V_RDDATARDY11(1U)

#define S_RDDATAVLD11    4
#define V_RDDATAVLD11(x) ((x) << S_RDDATAVLD11)
#define F_RDDATAVLD11    V_RDDATAVLD11(1U)

#define S_RDDATA11    0
#define M_RDDATA11    0xfU
#define V_RDDATA11(x) ((x) << S_RDDATA11)
#define G_RDDATA11(x) (((x) >> S_RDDATA11) & M_RDDATA11)

#define A_MA_HMA_CLIENT_INTERFACE_EXTERNAL 0xa00c

#define S_CMDVLD12    31
#define V_CMDVLD12(x) ((x) << S_CMDVLD12)
#define F_CMDVLD12    V_CMDVLD12(1U)

#define S_CMDRDY12    30
#define V_CMDRDY12(x) ((x) << S_CMDRDY12)
#define F_CMDRDY12    V_CMDRDY12(1U)

#define S_CMDTYPE12    29
#define V_CMDTYPE12(x) ((x) << S_CMDTYPE12)
#define F_CMDTYPE12    V_CMDTYPE12(1U)

#define S_CMDLEN12    21
#define M_CMDLEN12    0xffU
#define V_CMDLEN12(x) ((x) << S_CMDLEN12)
#define G_CMDLEN12(x) (((x) >> S_CMDLEN12) & M_CMDLEN12)

#define S_CMDADDR12    8
#define M_CMDADDR12    0x1fffU
#define V_CMDADDR12(x) ((x) << S_CMDADDR12)
#define G_CMDADDR12(x) (((x) >> S_CMDADDR12) & M_CMDADDR12)

#define S_WRDATAVLD12    7
#define V_WRDATAVLD12(x) ((x) << S_WRDATAVLD12)
#define F_WRDATAVLD12    V_WRDATAVLD12(1U)

#define S_WRDATARDY12    6
#define V_WRDATARDY12(x) ((x) << S_WRDATARDY12)
#define F_WRDATARDY12    V_WRDATARDY12(1U)

#define S_RDDATARDY12    5
#define V_RDDATARDY12(x) ((x) << S_RDDATARDY12)
#define F_RDDATARDY12    V_RDDATARDY12(1U)

#define S_RDDATAVLD12    4
#define V_RDDATAVLD12(x) ((x) << S_RDDATAVLD12)
#define F_RDDATAVLD12    V_RDDATAVLD12(1U)

#define S_RDDATA12    0
#define M_RDDATA12    0xfU
#define V_RDDATA12(x) ((x) << S_RDDATA12)
#define G_RDDATA12(x) (((x) >> S_RDDATA12) & M_RDDATA12)

#define A_MA_TARGET_0_ARBITER_INTERFACE_EXTERNAL_REG0 0xa00d

#define S_CI0_ARB0_REQ    31
#define V_CI0_ARB0_REQ(x) ((x) << S_CI0_ARB0_REQ)
#define F_CI0_ARB0_REQ    V_CI0_ARB0_REQ(1U)

#define S_ARB0_CI0_GNT    30
#define V_ARB0_CI0_GNT(x) ((x) << S_ARB0_CI0_GNT)
#define F_ARB0_CI0_GNT    V_ARB0_CI0_GNT(1U)

#define S_CI0_DM0_WDATA_VLD    29
#define V_CI0_DM0_WDATA_VLD(x) ((x) << S_CI0_DM0_WDATA_VLD)
#define F_CI0_DM0_WDATA_VLD    V_CI0_DM0_WDATA_VLD(1U)

#define S_DM0_CI0_RDATA_VLD    28
#define V_DM0_CI0_RDATA_VLD(x) ((x) << S_DM0_CI0_RDATA_VLD)
#define F_DM0_CI0_RDATA_VLD    V_DM0_CI0_RDATA_VLD(1U)

#define S_CI1_ARB0_REQ    27
#define V_CI1_ARB0_REQ(x) ((x) << S_CI1_ARB0_REQ)
#define F_CI1_ARB0_REQ    V_CI1_ARB0_REQ(1U)

#define S_ARB0_CI1_GNT    26
#define V_ARB0_CI1_GNT(x) ((x) << S_ARB0_CI1_GNT)
#define F_ARB0_CI1_GNT    V_ARB0_CI1_GNT(1U)

#define S_CI1_DM0_WDATA_VLD    25
#define V_CI1_DM0_WDATA_VLD(x) ((x) << S_CI1_DM0_WDATA_VLD)
#define F_CI1_DM0_WDATA_VLD    V_CI1_DM0_WDATA_VLD(1U)

#define S_DM0_CI1_RDATA_VLD    24
#define V_DM0_CI1_RDATA_VLD(x) ((x) << S_DM0_CI1_RDATA_VLD)
#define F_DM0_CI1_RDATA_VLD    V_DM0_CI1_RDATA_VLD(1U)

#define S_CI2_ARB0_REQ    23
#define V_CI2_ARB0_REQ(x) ((x) << S_CI2_ARB0_REQ)
#define F_CI2_ARB0_REQ    V_CI2_ARB0_REQ(1U)

#define S_ARB0_CI2_GNT    22
#define V_ARB0_CI2_GNT(x) ((x) << S_ARB0_CI2_GNT)
#define F_ARB0_CI2_GNT    V_ARB0_CI2_GNT(1U)

#define S_CI2_DM0_WDATA_VLD    21
#define V_CI2_DM0_WDATA_VLD(x) ((x) << S_CI2_DM0_WDATA_VLD)
#define F_CI2_DM0_WDATA_VLD    V_CI2_DM0_WDATA_VLD(1U)

#define S_DM0_CI2_RDATA_VLD    20
#define V_DM0_CI2_RDATA_VLD(x) ((x) << S_DM0_CI2_RDATA_VLD)
#define F_DM0_CI2_RDATA_VLD    V_DM0_CI2_RDATA_VLD(1U)

#define S_CI3_ARB0_REQ    19
#define V_CI3_ARB0_REQ(x) ((x) << S_CI3_ARB0_REQ)
#define F_CI3_ARB0_REQ    V_CI3_ARB0_REQ(1U)

#define S_ARB0_CI3_GNT    18
#define V_ARB0_CI3_GNT(x) ((x) << S_ARB0_CI3_GNT)
#define F_ARB0_CI3_GNT    V_ARB0_CI3_GNT(1U)

#define S_CI3_DM0_WDATA_VLD    17
#define V_CI3_DM0_WDATA_VLD(x) ((x) << S_CI3_DM0_WDATA_VLD)
#define F_CI3_DM0_WDATA_VLD    V_CI3_DM0_WDATA_VLD(1U)

#define S_DM0_CI3_RDATA_VLD    16
#define V_DM0_CI3_RDATA_VLD(x) ((x) << S_DM0_CI3_RDATA_VLD)
#define F_DM0_CI3_RDATA_VLD    V_DM0_CI3_RDATA_VLD(1U)

#define S_CI4_ARB0_REQ    15
#define V_CI4_ARB0_REQ(x) ((x) << S_CI4_ARB0_REQ)
#define F_CI4_ARB0_REQ    V_CI4_ARB0_REQ(1U)

#define S_ARB0_CI4_GNT    14
#define V_ARB0_CI4_GNT(x) ((x) << S_ARB0_CI4_GNT)
#define F_ARB0_CI4_GNT    V_ARB0_CI4_GNT(1U)

#define S_CI4_DM0_WDATA_VLD    13
#define V_CI4_DM0_WDATA_VLD(x) ((x) << S_CI4_DM0_WDATA_VLD)
#define F_CI4_DM0_WDATA_VLD    V_CI4_DM0_WDATA_VLD(1U)

#define S_DM0_CI4_RDATA_VLD    12
#define V_DM0_CI4_RDATA_VLD(x) ((x) << S_DM0_CI4_RDATA_VLD)
#define F_DM0_CI4_RDATA_VLD    V_DM0_CI4_RDATA_VLD(1U)

#define S_CI5_ARB0_REQ    11
#define V_CI5_ARB0_REQ(x) ((x) << S_CI5_ARB0_REQ)
#define F_CI5_ARB0_REQ    V_CI5_ARB0_REQ(1U)

#define S_ARB0_CI5_GNT    10
#define V_ARB0_CI5_GNT(x) ((x) << S_ARB0_CI5_GNT)
#define F_ARB0_CI5_GNT    V_ARB0_CI5_GNT(1U)

#define S_CI5_DM0_WDATA_VLD    9
#define V_CI5_DM0_WDATA_VLD(x) ((x) << S_CI5_DM0_WDATA_VLD)
#define F_CI5_DM0_WDATA_VLD    V_CI5_DM0_WDATA_VLD(1U)

#define S_DM0_CI5_RDATA_VLD    8
#define V_DM0_CI5_RDATA_VLD(x) ((x) << S_DM0_CI5_RDATA_VLD)
#define F_DM0_CI5_RDATA_VLD    V_DM0_CI5_RDATA_VLD(1U)

#define S_CI6_ARB0_REQ    7
#define V_CI6_ARB0_REQ(x) ((x) << S_CI6_ARB0_REQ)
#define F_CI6_ARB0_REQ    V_CI6_ARB0_REQ(1U)

#define S_ARB0_CI6_GNT    6
#define V_ARB0_CI6_GNT(x) ((x) << S_ARB0_CI6_GNT)
#define F_ARB0_CI6_GNT    V_ARB0_CI6_GNT(1U)

#define S_CI6_DM0_WDATA_VLD    5
#define V_CI6_DM0_WDATA_VLD(x) ((x) << S_CI6_DM0_WDATA_VLD)
#define F_CI6_DM0_WDATA_VLD    V_CI6_DM0_WDATA_VLD(1U)

#define S_DM0_CI6_RDATA_VLD    4
#define V_DM0_CI6_RDATA_VLD(x) ((x) << S_DM0_CI6_RDATA_VLD)
#define F_DM0_CI6_RDATA_VLD    V_DM0_CI6_RDATA_VLD(1U)

#define S_CI7_ARB0_REQ    3
#define V_CI7_ARB0_REQ(x) ((x) << S_CI7_ARB0_REQ)
#define F_CI7_ARB0_REQ    V_CI7_ARB0_REQ(1U)

#define S_ARB0_CI7_GNT    2
#define V_ARB0_CI7_GNT(x) ((x) << S_ARB0_CI7_GNT)
#define F_ARB0_CI7_GNT    V_ARB0_CI7_GNT(1U)

#define S_CI7_DM0_WDATA_VLD    1
#define V_CI7_DM0_WDATA_VLD(x) ((x) << S_CI7_DM0_WDATA_VLD)
#define F_CI7_DM0_WDATA_VLD    V_CI7_DM0_WDATA_VLD(1U)

#define S_DM0_CI7_RDATA_VLD    0
#define V_DM0_CI7_RDATA_VLD(x) ((x) << S_DM0_CI7_RDATA_VLD)
#define F_DM0_CI7_RDATA_VLD    V_DM0_CI7_RDATA_VLD(1U)

#define A_MA_TARGET_1_ARBITER_INTERFACE_EXTERNAL_REG0 0xa00e

#define S_CI0_ARB1_REQ    31
#define V_CI0_ARB1_REQ(x) ((x) << S_CI0_ARB1_REQ)
#define F_CI0_ARB1_REQ    V_CI0_ARB1_REQ(1U)

#define S_ARB1_CI0_GNT    30
#define V_ARB1_CI0_GNT(x) ((x) << S_ARB1_CI0_GNT)
#define F_ARB1_CI0_GNT    V_ARB1_CI0_GNT(1U)

#define S_CI0_DM1_WDATA_VLD    29
#define V_CI0_DM1_WDATA_VLD(x) ((x) << S_CI0_DM1_WDATA_VLD)
#define F_CI0_DM1_WDATA_VLD    V_CI0_DM1_WDATA_VLD(1U)

#define S_DM1_CI0_RDATA_VLD    28
#define V_DM1_CI0_RDATA_VLD(x) ((x) << S_DM1_CI0_RDATA_VLD)
#define F_DM1_CI0_RDATA_VLD    V_DM1_CI0_RDATA_VLD(1U)

#define S_CI1_ARB1_REQ    27
#define V_CI1_ARB1_REQ(x) ((x) << S_CI1_ARB1_REQ)
#define F_CI1_ARB1_REQ    V_CI1_ARB1_REQ(1U)

#define S_ARB1_CI1_GNT    26
#define V_ARB1_CI1_GNT(x) ((x) << S_ARB1_CI1_GNT)
#define F_ARB1_CI1_GNT    V_ARB1_CI1_GNT(1U)

#define S_CI1_DM1_WDATA_VLD    25
#define V_CI1_DM1_WDATA_VLD(x) ((x) << S_CI1_DM1_WDATA_VLD)
#define F_CI1_DM1_WDATA_VLD    V_CI1_DM1_WDATA_VLD(1U)

#define S_DM1_CI1_RDATA_VLD    24
#define V_DM1_CI1_RDATA_VLD(x) ((x) << S_DM1_CI1_RDATA_VLD)
#define F_DM1_CI1_RDATA_VLD    V_DM1_CI1_RDATA_VLD(1U)

#define S_CI2_ARB1_REQ    23
#define V_CI2_ARB1_REQ(x) ((x) << S_CI2_ARB1_REQ)
#define F_CI2_ARB1_REQ    V_CI2_ARB1_REQ(1U)

#define S_ARB1_CI2_GNT    22
#define V_ARB1_CI2_GNT(x) ((x) << S_ARB1_CI2_GNT)
#define F_ARB1_CI2_GNT    V_ARB1_CI2_GNT(1U)

#define S_CI2_DM1_WDATA_VLD    21
#define V_CI2_DM1_WDATA_VLD(x) ((x) << S_CI2_DM1_WDATA_VLD)
#define F_CI2_DM1_WDATA_VLD    V_CI2_DM1_WDATA_VLD(1U)

#define S_DM1_CI2_RDATA_VLD    20
#define V_DM1_CI2_RDATA_VLD(x) ((x) << S_DM1_CI2_RDATA_VLD)
#define F_DM1_CI2_RDATA_VLD    V_DM1_CI2_RDATA_VLD(1U)

#define S_CI3_ARB1_REQ    19
#define V_CI3_ARB1_REQ(x) ((x) << S_CI3_ARB1_REQ)
#define F_CI3_ARB1_REQ    V_CI3_ARB1_REQ(1U)

#define S_ARB1_CI3_GNT    18
#define V_ARB1_CI3_GNT(x) ((x) << S_ARB1_CI3_GNT)
#define F_ARB1_CI3_GNT    V_ARB1_CI3_GNT(1U)

#define S_CI3_DM1_WDATA_VLD    17
#define V_CI3_DM1_WDATA_VLD(x) ((x) << S_CI3_DM1_WDATA_VLD)
#define F_CI3_DM1_WDATA_VLD    V_CI3_DM1_WDATA_VLD(1U)

#define S_DM1_CI3_RDATA_VLD    16
#define V_DM1_CI3_RDATA_VLD(x) ((x) << S_DM1_CI3_RDATA_VLD)
#define F_DM1_CI3_RDATA_VLD    V_DM1_CI3_RDATA_VLD(1U)

#define S_CI4_ARB1_REQ    15
#define V_CI4_ARB1_REQ(x) ((x) << S_CI4_ARB1_REQ)
#define F_CI4_ARB1_REQ    V_CI4_ARB1_REQ(1U)

#define S_ARB1_CI4_GNT    14
#define V_ARB1_CI4_GNT(x) ((x) << S_ARB1_CI4_GNT)
#define F_ARB1_CI4_GNT    V_ARB1_CI4_GNT(1U)

#define S_CI4_DM1_WDATA_VLD    13
#define V_CI4_DM1_WDATA_VLD(x) ((x) << S_CI4_DM1_WDATA_VLD)
#define F_CI4_DM1_WDATA_VLD    V_CI4_DM1_WDATA_VLD(1U)

#define S_DM1_CI4_RDATA_VLD    12
#define V_DM1_CI4_RDATA_VLD(x) ((x) << S_DM1_CI4_RDATA_VLD)
#define F_DM1_CI4_RDATA_VLD    V_DM1_CI4_RDATA_VLD(1U)

#define S_CI5_ARB1_REQ    11
#define V_CI5_ARB1_REQ(x) ((x) << S_CI5_ARB1_REQ)
#define F_CI5_ARB1_REQ    V_CI5_ARB1_REQ(1U)

#define S_ARB1_CI5_GNT    10
#define V_ARB1_CI5_GNT(x) ((x) << S_ARB1_CI5_GNT)
#define F_ARB1_CI5_GNT    V_ARB1_CI5_GNT(1U)

#define S_CI5_DM1_WDATA_VLD    9
#define V_CI5_DM1_WDATA_VLD(x) ((x) << S_CI5_DM1_WDATA_VLD)
#define F_CI5_DM1_WDATA_VLD    V_CI5_DM1_WDATA_VLD(1U)

#define S_DM1_CI5_RDATA_VLD    8
#define V_DM1_CI5_RDATA_VLD(x) ((x) << S_DM1_CI5_RDATA_VLD)
#define F_DM1_CI5_RDATA_VLD    V_DM1_CI5_RDATA_VLD(1U)

#define S_CI6_ARB1_REQ    7
#define V_CI6_ARB1_REQ(x) ((x) << S_CI6_ARB1_REQ)
#define F_CI6_ARB1_REQ    V_CI6_ARB1_REQ(1U)

#define S_ARB1_CI6_GNT    6
#define V_ARB1_CI6_GNT(x) ((x) << S_ARB1_CI6_GNT)
#define F_ARB1_CI6_GNT    V_ARB1_CI6_GNT(1U)

#define S_CI6_DM1_WDATA_VLD    5
#define V_CI6_DM1_WDATA_VLD(x) ((x) << S_CI6_DM1_WDATA_VLD)
#define F_CI6_DM1_WDATA_VLD    V_CI6_DM1_WDATA_VLD(1U)

#define S_DM1_CI6_RDATA_VLD    4
#define V_DM1_CI6_RDATA_VLD(x) ((x) << S_DM1_CI6_RDATA_VLD)
#define F_DM1_CI6_RDATA_VLD    V_DM1_CI6_RDATA_VLD(1U)

#define S_CI7_ARB1_REQ    3
#define V_CI7_ARB1_REQ(x) ((x) << S_CI7_ARB1_REQ)
#define F_CI7_ARB1_REQ    V_CI7_ARB1_REQ(1U)

#define S_ARB1_CI7_GNT    2
#define V_ARB1_CI7_GNT(x) ((x) << S_ARB1_CI7_GNT)
#define F_ARB1_CI7_GNT    V_ARB1_CI7_GNT(1U)

#define S_CI7_DM1_WDATA_VLD    1
#define V_CI7_DM1_WDATA_VLD(x) ((x) << S_CI7_DM1_WDATA_VLD)
#define F_CI7_DM1_WDATA_VLD    V_CI7_DM1_WDATA_VLD(1U)

#define S_DM1_CI7_RDATA_VLD    0
#define V_DM1_CI7_RDATA_VLD(x) ((x) << S_DM1_CI7_RDATA_VLD)
#define F_DM1_CI7_RDATA_VLD    V_DM1_CI7_RDATA_VLD(1U)

#define A_MA_TARGET_2_ARBITER_INTERFACE_EXTERNAL_REG0 0xa00f

#define S_CI0_ARB2_REQ    31
#define V_CI0_ARB2_REQ(x) ((x) << S_CI0_ARB2_REQ)
#define F_CI0_ARB2_REQ    V_CI0_ARB2_REQ(1U)

#define S_ARB2_CI0_GNT    30
#define V_ARB2_CI0_GNT(x) ((x) << S_ARB2_CI0_GNT)
#define F_ARB2_CI0_GNT    V_ARB2_CI0_GNT(1U)

#define S_CI0_DM2_WDATA_VLD    29
#define V_CI0_DM2_WDATA_VLD(x) ((x) << S_CI0_DM2_WDATA_VLD)
#define F_CI0_DM2_WDATA_VLD    V_CI0_DM2_WDATA_VLD(1U)

#define S_DM2_CI0_RDATA_VLD    28
#define V_DM2_CI0_RDATA_VLD(x) ((x) << S_DM2_CI0_RDATA_VLD)
#define F_DM2_CI0_RDATA_VLD    V_DM2_CI0_RDATA_VLD(1U)

#define S_CI1_ARB2_REQ    27
#define V_CI1_ARB2_REQ(x) ((x) << S_CI1_ARB2_REQ)
#define F_CI1_ARB2_REQ    V_CI1_ARB2_REQ(1U)

#define S_ARB2_CI1_GNT    26
#define V_ARB2_CI1_GNT(x) ((x) << S_ARB2_CI1_GNT)
#define F_ARB2_CI1_GNT    V_ARB2_CI1_GNT(1U)

#define S_CI1_DM2_WDATA_VLD    25
#define V_CI1_DM2_WDATA_VLD(x) ((x) << S_CI1_DM2_WDATA_VLD)
#define F_CI1_DM2_WDATA_VLD    V_CI1_DM2_WDATA_VLD(1U)

#define S_DM2_CI1_RDATA_VLD    24
#define V_DM2_CI1_RDATA_VLD(x) ((x) << S_DM2_CI1_RDATA_VLD)
#define F_DM2_CI1_RDATA_VLD    V_DM2_CI1_RDATA_VLD(1U)

#define S_CI2_ARB2_REQ    23
#define V_CI2_ARB2_REQ(x) ((x) << S_CI2_ARB2_REQ)
#define F_CI2_ARB2_REQ    V_CI2_ARB2_REQ(1U)

#define S_ARB2_CI2_GNT    22
#define V_ARB2_CI2_GNT(x) ((x) << S_ARB2_CI2_GNT)
#define F_ARB2_CI2_GNT    V_ARB2_CI2_GNT(1U)

#define S_CI2_DM2_WDATA_VLD    21
#define V_CI2_DM2_WDATA_VLD(x) ((x) << S_CI2_DM2_WDATA_VLD)
#define F_CI2_DM2_WDATA_VLD    V_CI2_DM2_WDATA_VLD(1U)

#define S_DM2_CI2_RDATA_VLD    20
#define V_DM2_CI2_RDATA_VLD(x) ((x) << S_DM2_CI2_RDATA_VLD)
#define F_DM2_CI2_RDATA_VLD    V_DM2_CI2_RDATA_VLD(1U)

#define S_CI3_ARB2_REQ    19
#define V_CI3_ARB2_REQ(x) ((x) << S_CI3_ARB2_REQ)
#define F_CI3_ARB2_REQ    V_CI3_ARB2_REQ(1U)

#define S_ARB2_CI3_GNT    18
#define V_ARB2_CI3_GNT(x) ((x) << S_ARB2_CI3_GNT)
#define F_ARB2_CI3_GNT    V_ARB2_CI3_GNT(1U)

#define S_CI3_DM2_WDATA_VLD    17
#define V_CI3_DM2_WDATA_VLD(x) ((x) << S_CI3_DM2_WDATA_VLD)
#define F_CI3_DM2_WDATA_VLD    V_CI3_DM2_WDATA_VLD(1U)

#define S_DM2_CI3_RDATA_VLD    16
#define V_DM2_CI3_RDATA_VLD(x) ((x) << S_DM2_CI3_RDATA_VLD)
#define F_DM2_CI3_RDATA_VLD    V_DM2_CI3_RDATA_VLD(1U)

#define S_CI4_ARB2_REQ    15
#define V_CI4_ARB2_REQ(x) ((x) << S_CI4_ARB2_REQ)
#define F_CI4_ARB2_REQ    V_CI4_ARB2_REQ(1U)

#define S_ARB2_CI4_GNT    14
#define V_ARB2_CI4_GNT(x) ((x) << S_ARB2_CI4_GNT)
#define F_ARB2_CI4_GNT    V_ARB2_CI4_GNT(1U)

#define S_CI4_DM2_WDATA_VLD    13
#define V_CI4_DM2_WDATA_VLD(x) ((x) << S_CI4_DM2_WDATA_VLD)
#define F_CI4_DM2_WDATA_VLD    V_CI4_DM2_WDATA_VLD(1U)

#define S_DM2_CI4_RDATA_VLD    12
#define V_DM2_CI4_RDATA_VLD(x) ((x) << S_DM2_CI4_RDATA_VLD)
#define F_DM2_CI4_RDATA_VLD    V_DM2_CI4_RDATA_VLD(1U)

#define S_CI5_ARB2_REQ    11
#define V_CI5_ARB2_REQ(x) ((x) << S_CI5_ARB2_REQ)
#define F_CI5_ARB2_REQ    V_CI5_ARB2_REQ(1U)

#define S_ARB2_CI5_GNT    10
#define V_ARB2_CI5_GNT(x) ((x) << S_ARB2_CI5_GNT)
#define F_ARB2_CI5_GNT    V_ARB2_CI5_GNT(1U)

#define S_CI5_DM2_WDATA_VLD    9
#define V_CI5_DM2_WDATA_VLD(x) ((x) << S_CI5_DM2_WDATA_VLD)
#define F_CI5_DM2_WDATA_VLD    V_CI5_DM2_WDATA_VLD(1U)

#define S_DM2_CI5_RDATA_VLD    8
#define V_DM2_CI5_RDATA_VLD(x) ((x) << S_DM2_CI5_RDATA_VLD)
#define F_DM2_CI5_RDATA_VLD    V_DM2_CI5_RDATA_VLD(1U)

#define S_CI6_ARB2_REQ    7
#define V_CI6_ARB2_REQ(x) ((x) << S_CI6_ARB2_REQ)
#define F_CI6_ARB2_REQ    V_CI6_ARB2_REQ(1U)

#define S_ARB2_CI6_GNT    6
#define V_ARB2_CI6_GNT(x) ((x) << S_ARB2_CI6_GNT)
#define F_ARB2_CI6_GNT    V_ARB2_CI6_GNT(1U)

#define S_CI6_DM2_WDATA_VLD    5
#define V_CI6_DM2_WDATA_VLD(x) ((x) << S_CI6_DM2_WDATA_VLD)
#define F_CI6_DM2_WDATA_VLD    V_CI6_DM2_WDATA_VLD(1U)

#define S_DM2_CI6_RDATA_VLD    4
#define V_DM2_CI6_RDATA_VLD(x) ((x) << S_DM2_CI6_RDATA_VLD)
#define F_DM2_CI6_RDATA_VLD    V_DM2_CI6_RDATA_VLD(1U)

#define S_CI7_ARB2_REQ    3
#define V_CI7_ARB2_REQ(x) ((x) << S_CI7_ARB2_REQ)
#define F_CI7_ARB2_REQ    V_CI7_ARB2_REQ(1U)

#define S_ARB2_CI7_GNT    2
#define V_ARB2_CI7_GNT(x) ((x) << S_ARB2_CI7_GNT)
#define F_ARB2_CI7_GNT    V_ARB2_CI7_GNT(1U)

#define S_CI7_DM2_WDATA_VLD    1
#define V_CI7_DM2_WDATA_VLD(x) ((x) << S_CI7_DM2_WDATA_VLD)
#define F_CI7_DM2_WDATA_VLD    V_CI7_DM2_WDATA_VLD(1U)

#define S_DM2_CI7_RDATA_VLD    0
#define V_DM2_CI7_RDATA_VLD(x) ((x) << S_DM2_CI7_RDATA_VLD)
#define F_DM2_CI7_RDATA_VLD    V_DM2_CI7_RDATA_VLD(1U)

#define A_MA_TARGET_3_ARBITER_INTERFACE_EXTERNAL_REG0 0xa010

#define S_CI0_ARB3_REQ    31
#define V_CI0_ARB3_REQ(x) ((x) << S_CI0_ARB3_REQ)
#define F_CI0_ARB3_REQ    V_CI0_ARB3_REQ(1U)

#define S_ARB3_CI0_GNT    30
#define V_ARB3_CI0_GNT(x) ((x) << S_ARB3_CI0_GNT)
#define F_ARB3_CI0_GNT    V_ARB3_CI0_GNT(1U)

#define S_CI0_DM3_WDATA_VLD    29
#define V_CI0_DM3_WDATA_VLD(x) ((x) << S_CI0_DM3_WDATA_VLD)
#define F_CI0_DM3_WDATA_VLD    V_CI0_DM3_WDATA_VLD(1U)

#define S_DM3_CI0_RDATA_VLD    28
#define V_DM3_CI0_RDATA_VLD(x) ((x) << S_DM3_CI0_RDATA_VLD)
#define F_DM3_CI0_RDATA_VLD    V_DM3_CI0_RDATA_VLD(1U)

#define S_CI1_ARB3_REQ    27
#define V_CI1_ARB3_REQ(x) ((x) << S_CI1_ARB3_REQ)
#define F_CI1_ARB3_REQ    V_CI1_ARB3_REQ(1U)

#define S_ARB3_CI1_GNT    26
#define V_ARB3_CI1_GNT(x) ((x) << S_ARB3_CI1_GNT)
#define F_ARB3_CI1_GNT    V_ARB3_CI1_GNT(1U)

#define S_CI1_DM3_WDATA_VLD    25
#define V_CI1_DM3_WDATA_VLD(x) ((x) << S_CI1_DM3_WDATA_VLD)
#define F_CI1_DM3_WDATA_VLD    V_CI1_DM3_WDATA_VLD(1U)

#define S_DM3_CI1_RDATA_VLD    24
#define V_DM3_CI1_RDATA_VLD(x) ((x) << S_DM3_CI1_RDATA_VLD)
#define F_DM3_CI1_RDATA_VLD    V_DM3_CI1_RDATA_VLD(1U)

#define S_CI2_ARB3_REQ    23
#define V_CI2_ARB3_REQ(x) ((x) << S_CI2_ARB3_REQ)
#define F_CI2_ARB3_REQ    V_CI2_ARB3_REQ(1U)

#define S_ARB3_CI2_GNT    22
#define V_ARB3_CI2_GNT(x) ((x) << S_ARB3_CI2_GNT)
#define F_ARB3_CI2_GNT    V_ARB3_CI2_GNT(1U)

#define S_CI2_DM3_WDATA_VLD    21
#define V_CI2_DM3_WDATA_VLD(x) ((x) << S_CI2_DM3_WDATA_VLD)
#define F_CI2_DM3_WDATA_VLD    V_CI2_DM3_WDATA_VLD(1U)

#define S_DM3_CI2_RDATA_VLD    20
#define V_DM3_CI2_RDATA_VLD(x) ((x) << S_DM3_CI2_RDATA_VLD)
#define F_DM3_CI2_RDATA_VLD    V_DM3_CI2_RDATA_VLD(1U)

#define S_CI3_ARB3_REQ    19
#define V_CI3_ARB3_REQ(x) ((x) << S_CI3_ARB3_REQ)
#define F_CI3_ARB3_REQ    V_CI3_ARB3_REQ(1U)

#define S_ARB3_CI3_GNT    18
#define V_ARB3_CI3_GNT(x) ((x) << S_ARB3_CI3_GNT)
#define F_ARB3_CI3_GNT    V_ARB3_CI3_GNT(1U)

#define S_CI3_DM3_WDATA_VLD    17
#define V_CI3_DM3_WDATA_VLD(x) ((x) << S_CI3_DM3_WDATA_VLD)
#define F_CI3_DM3_WDATA_VLD    V_CI3_DM3_WDATA_VLD(1U)

#define S_DM3_CI3_RDATA_VLD    16
#define V_DM3_CI3_RDATA_VLD(x) ((x) << S_DM3_CI3_RDATA_VLD)
#define F_DM3_CI3_RDATA_VLD    V_DM3_CI3_RDATA_VLD(1U)

#define S_CI4_ARB3_REQ    15
#define V_CI4_ARB3_REQ(x) ((x) << S_CI4_ARB3_REQ)
#define F_CI4_ARB3_REQ    V_CI4_ARB3_REQ(1U)

#define S_ARB3_CI4_GNT    14
#define V_ARB3_CI4_GNT(x) ((x) << S_ARB3_CI4_GNT)
#define F_ARB3_CI4_GNT    V_ARB3_CI4_GNT(1U)

#define S_CI4_DM3_WDATA_VLD    13
#define V_CI4_DM3_WDATA_VLD(x) ((x) << S_CI4_DM3_WDATA_VLD)
#define F_CI4_DM3_WDATA_VLD    V_CI4_DM3_WDATA_VLD(1U)

#define S_DM3_CI4_RDATA_VLD    12
#define V_DM3_CI4_RDATA_VLD(x) ((x) << S_DM3_CI4_RDATA_VLD)
#define F_DM3_CI4_RDATA_VLD    V_DM3_CI4_RDATA_VLD(1U)

#define S_CI5_ARB3_REQ    11
#define V_CI5_ARB3_REQ(x) ((x) << S_CI5_ARB3_REQ)
#define F_CI5_ARB3_REQ    V_CI5_ARB3_REQ(1U)

#define S_ARB3_CI5_GNT    10
#define V_ARB3_CI5_GNT(x) ((x) << S_ARB3_CI5_GNT)
#define F_ARB3_CI5_GNT    V_ARB3_CI5_GNT(1U)

#define S_CI5_DM3_WDATA_VLD    9
#define V_CI5_DM3_WDATA_VLD(x) ((x) << S_CI5_DM3_WDATA_VLD)
#define F_CI5_DM3_WDATA_VLD    V_CI5_DM3_WDATA_VLD(1U)

#define S_DM3_CI5_RDATA_VLD    8
#define V_DM3_CI5_RDATA_VLD(x) ((x) << S_DM3_CI5_RDATA_VLD)
#define F_DM3_CI5_RDATA_VLD    V_DM3_CI5_RDATA_VLD(1U)

#define S_CI6_ARB3_REQ    7
#define V_CI6_ARB3_REQ(x) ((x) << S_CI6_ARB3_REQ)
#define F_CI6_ARB3_REQ    V_CI6_ARB3_REQ(1U)

#define S_ARB3_CI6_GNT    6
#define V_ARB3_CI6_GNT(x) ((x) << S_ARB3_CI6_GNT)
#define F_ARB3_CI6_GNT    V_ARB3_CI6_GNT(1U)

#define S_CI6_DM3_WDATA_VLD    5
#define V_CI6_DM3_WDATA_VLD(x) ((x) << S_CI6_DM3_WDATA_VLD)
#define F_CI6_DM3_WDATA_VLD    V_CI6_DM3_WDATA_VLD(1U)

#define S_DM3_CI6_RDATA_VLD    4
#define V_DM3_CI6_RDATA_VLD(x) ((x) << S_DM3_CI6_RDATA_VLD)
#define F_DM3_CI6_RDATA_VLD    V_DM3_CI6_RDATA_VLD(1U)

#define S_CI7_ARB3_REQ    3
#define V_CI7_ARB3_REQ(x) ((x) << S_CI7_ARB3_REQ)
#define F_CI7_ARB3_REQ    V_CI7_ARB3_REQ(1U)

#define S_ARB3_CI7_GNT    2
#define V_ARB3_CI7_GNT(x) ((x) << S_ARB3_CI7_GNT)
#define F_ARB3_CI7_GNT    V_ARB3_CI7_GNT(1U)

#define S_CI7_DM3_WDATA_VLD    1
#define V_CI7_DM3_WDATA_VLD(x) ((x) << S_CI7_DM3_WDATA_VLD)
#define F_CI7_DM3_WDATA_VLD    V_CI7_DM3_WDATA_VLD(1U)

#define S_DM3_CI7_RDATA_VLD    0
#define V_DM3_CI7_RDATA_VLD(x) ((x) << S_DM3_CI7_RDATA_VLD)
#define F_DM3_CI7_RDATA_VLD    V_DM3_CI7_RDATA_VLD(1U)

#define A_MA_MA_DEBUG_SIGNATURE_LTL_END 0xa011
#define A_MA_MA_DEBUG_SIGNATURE_BIG_END_INVERSE 0xa012
#define A_MA_TARGET_0_ARBITER_INTERFACE_EXTERNAL_REG1 0xa013

#define S_CI8_ARB0_REQ    31
#define V_CI8_ARB0_REQ(x) ((x) << S_CI8_ARB0_REQ)
#define F_CI8_ARB0_REQ    V_CI8_ARB0_REQ(1U)

#define S_ARB0_CI8_GNT    30
#define V_ARB0_CI8_GNT(x) ((x) << S_ARB0_CI8_GNT)
#define F_ARB0_CI8_GNT    V_ARB0_CI8_GNT(1U)

#define S_CI8_DM0_WDATA_VLD    29
#define V_CI8_DM0_WDATA_VLD(x) ((x) << S_CI8_DM0_WDATA_VLD)
#define F_CI8_DM0_WDATA_VLD    V_CI8_DM0_WDATA_VLD(1U)

#define S_DM0_CI8_RDATA_VLD    28
#define V_DM0_CI8_RDATA_VLD(x) ((x) << S_DM0_CI8_RDATA_VLD)
#define F_DM0_CI8_RDATA_VLD    V_DM0_CI8_RDATA_VLD(1U)

#define S_CI9_ARB0_REQ    27
#define V_CI9_ARB0_REQ(x) ((x) << S_CI9_ARB0_REQ)
#define F_CI9_ARB0_REQ    V_CI9_ARB0_REQ(1U)

#define S_ARB0_CI9_GNT    26
#define V_ARB0_CI9_GNT(x) ((x) << S_ARB0_CI9_GNT)
#define F_ARB0_CI9_GNT    V_ARB0_CI9_GNT(1U)

#define S_CI9_DM0_WDATA_VLD    25
#define V_CI9_DM0_WDATA_VLD(x) ((x) << S_CI9_DM0_WDATA_VLD)
#define F_CI9_DM0_WDATA_VLD    V_CI9_DM0_WDATA_VLD(1U)

#define S_DM0_CI9_RDATA_VLD    24
#define V_DM0_CI9_RDATA_VLD(x) ((x) << S_DM0_CI9_RDATA_VLD)
#define F_DM0_CI9_RDATA_VLD    V_DM0_CI9_RDATA_VLD(1U)

#define S_CI10_ARB0_REQ    23
#define V_CI10_ARB0_REQ(x) ((x) << S_CI10_ARB0_REQ)
#define F_CI10_ARB0_REQ    V_CI10_ARB0_REQ(1U)

#define S_ARB0_CI10_GNT    22
#define V_ARB0_CI10_GNT(x) ((x) << S_ARB0_CI10_GNT)
#define F_ARB0_CI10_GNT    V_ARB0_CI10_GNT(1U)

#define S_CI10_DM0_WDATA_VLD    21
#define V_CI10_DM0_WDATA_VLD(x) ((x) << S_CI10_DM0_WDATA_VLD)
#define F_CI10_DM0_WDATA_VLD    V_CI10_DM0_WDATA_VLD(1U)

#define S_DM0_CI10_RDATA_VLD    20
#define V_DM0_CI10_RDATA_VLD(x) ((x) << S_DM0_CI10_RDATA_VLD)
#define F_DM0_CI10_RDATA_VLD    V_DM0_CI10_RDATA_VLD(1U)

#define S_CI11_ARB0_REQ    19
#define V_CI11_ARB0_REQ(x) ((x) << S_CI11_ARB0_REQ)
#define F_CI11_ARB0_REQ    V_CI11_ARB0_REQ(1U)

#define S_ARB0_CI11_GNT    18
#define V_ARB0_CI11_GNT(x) ((x) << S_ARB0_CI11_GNT)
#define F_ARB0_CI11_GNT    V_ARB0_CI11_GNT(1U)

#define S_CI11_DM0_WDATA_VLD    17
#define V_CI11_DM0_WDATA_VLD(x) ((x) << S_CI11_DM0_WDATA_VLD)
#define F_CI11_DM0_WDATA_VLD    V_CI11_DM0_WDATA_VLD(1U)

#define S_DM0_CI11_RDATA_VLD    16
#define V_DM0_CI11_RDATA_VLD(x) ((x) << S_DM0_CI11_RDATA_VLD)
#define F_DM0_CI11_RDATA_VLD    V_DM0_CI11_RDATA_VLD(1U)

#define S_CI12_ARB0_REQ    15
#define V_CI12_ARB0_REQ(x) ((x) << S_CI12_ARB0_REQ)
#define F_CI12_ARB0_REQ    V_CI12_ARB0_REQ(1U)

#define S_ARB0_CI12_GNT    14
#define V_ARB0_CI12_GNT(x) ((x) << S_ARB0_CI12_GNT)
#define F_ARB0_CI12_GNT    V_ARB0_CI12_GNT(1U)

#define S_CI12_DM0_WDATA_VLD    13
#define V_CI12_DM0_WDATA_VLD(x) ((x) << S_CI12_DM0_WDATA_VLD)
#define F_CI12_DM0_WDATA_VLD    V_CI12_DM0_WDATA_VLD(1U)

#define S_DM0_CI12_RDATA_VLD    12
#define V_DM0_CI12_RDATA_VLD(x) ((x) << S_DM0_CI12_RDATA_VLD)
#define F_DM0_CI12_RDATA_VLD    V_DM0_CI12_RDATA_VLD(1U)

#define A_MA_TARGET_1_ARBITER_INTERFACE_EXTERNAL_REG1 0xa014

#define S_CI8_ARB1_REQ    31
#define V_CI8_ARB1_REQ(x) ((x) << S_CI8_ARB1_REQ)
#define F_CI8_ARB1_REQ    V_CI8_ARB1_REQ(1U)

#define S_ARB1_CI8_GNT    30
#define V_ARB1_CI8_GNT(x) ((x) << S_ARB1_CI8_GNT)
#define F_ARB1_CI8_GNT    V_ARB1_CI8_GNT(1U)

#define S_CI8_DM1_WDATA_VLD    29
#define V_CI8_DM1_WDATA_VLD(x) ((x) << S_CI8_DM1_WDATA_VLD)
#define F_CI8_DM1_WDATA_VLD    V_CI8_DM1_WDATA_VLD(1U)

#define S_DM1_CI8_RDATA_VLD    28
#define V_DM1_CI8_RDATA_VLD(x) ((x) << S_DM1_CI8_RDATA_VLD)
#define F_DM1_CI8_RDATA_VLD    V_DM1_CI8_RDATA_VLD(1U)

#define S_CI9_ARB1_REQ    27
#define V_CI9_ARB1_REQ(x) ((x) << S_CI9_ARB1_REQ)
#define F_CI9_ARB1_REQ    V_CI9_ARB1_REQ(1U)

#define S_ARB1_CI9_GNT    26
#define V_ARB1_CI9_GNT(x) ((x) << S_ARB1_CI9_GNT)
#define F_ARB1_CI9_GNT    V_ARB1_CI9_GNT(1U)

#define S_CI9_DM1_WDATA_VLD    25
#define V_CI9_DM1_WDATA_VLD(x) ((x) << S_CI9_DM1_WDATA_VLD)
#define F_CI9_DM1_WDATA_VLD    V_CI9_DM1_WDATA_VLD(1U)

#define S_DM1_CI9_RDATA_VLD    24
#define V_DM1_CI9_RDATA_VLD(x) ((x) << S_DM1_CI9_RDATA_VLD)
#define F_DM1_CI9_RDATA_VLD    V_DM1_CI9_RDATA_VLD(1U)

#define S_CI10_ARB1_REQ    23
#define V_CI10_ARB1_REQ(x) ((x) << S_CI10_ARB1_REQ)
#define F_CI10_ARB1_REQ    V_CI10_ARB1_REQ(1U)

#define S_ARB1_CI10_GNT    22
#define V_ARB1_CI10_GNT(x) ((x) << S_ARB1_CI10_GNT)
#define F_ARB1_CI10_GNT    V_ARB1_CI10_GNT(1U)

#define S_CI10_DM1_WDATA_VLD    21
#define V_CI10_DM1_WDATA_VLD(x) ((x) << S_CI10_DM1_WDATA_VLD)
#define F_CI10_DM1_WDATA_VLD    V_CI10_DM1_WDATA_VLD(1U)

#define S_DM1_CI10_RDATA_VLD    20
#define V_DM1_CI10_RDATA_VLD(x) ((x) << S_DM1_CI10_RDATA_VLD)
#define F_DM1_CI10_RDATA_VLD    V_DM1_CI10_RDATA_VLD(1U)

#define S_CI11_ARB1_REQ    19
#define V_CI11_ARB1_REQ(x) ((x) << S_CI11_ARB1_REQ)
#define F_CI11_ARB1_REQ    V_CI11_ARB1_REQ(1U)

#define S_ARB1_CI11_GNT    18
#define V_ARB1_CI11_GNT(x) ((x) << S_ARB1_CI11_GNT)
#define F_ARB1_CI11_GNT    V_ARB1_CI11_GNT(1U)

#define S_CI11_DM1_WDATA_VLD    17
#define V_CI11_DM1_WDATA_VLD(x) ((x) << S_CI11_DM1_WDATA_VLD)
#define F_CI11_DM1_WDATA_VLD    V_CI11_DM1_WDATA_VLD(1U)

#define S_DM1_CI11_RDATA_VLD    16
#define V_DM1_CI11_RDATA_VLD(x) ((x) << S_DM1_CI11_RDATA_VLD)
#define F_DM1_CI11_RDATA_VLD    V_DM1_CI11_RDATA_VLD(1U)

#define S_CI12_ARB1_REQ    15
#define V_CI12_ARB1_REQ(x) ((x) << S_CI12_ARB1_REQ)
#define F_CI12_ARB1_REQ    V_CI12_ARB1_REQ(1U)

#define S_ARB1_CI12_GNT    14
#define V_ARB1_CI12_GNT(x) ((x) << S_ARB1_CI12_GNT)
#define F_ARB1_CI12_GNT    V_ARB1_CI12_GNT(1U)

#define S_CI12_DM1_WDATA_VLD    13
#define V_CI12_DM1_WDATA_VLD(x) ((x) << S_CI12_DM1_WDATA_VLD)
#define F_CI12_DM1_WDATA_VLD    V_CI12_DM1_WDATA_VLD(1U)

#define S_DM1_CI12_RDATA_VLD    12
#define V_DM1_CI12_RDATA_VLD(x) ((x) << S_DM1_CI12_RDATA_VLD)
#define F_DM1_CI12_RDATA_VLD    V_DM1_CI12_RDATA_VLD(1U)

#define A_MA_TARGET_2_ARBITER_INTERFACE_EXTERNAL_REG1 0xa015

#define S_CI8_ARB2_REQ    31
#define V_CI8_ARB2_REQ(x) ((x) << S_CI8_ARB2_REQ)
#define F_CI8_ARB2_REQ    V_CI8_ARB2_REQ(1U)

#define S_ARB2_CI8_GNT    30
#define V_ARB2_CI8_GNT(x) ((x) << S_ARB2_CI8_GNT)
#define F_ARB2_CI8_GNT    V_ARB2_CI8_GNT(1U)

#define S_CI8_DM2_WDATA_VLD    29
#define V_CI8_DM2_WDATA_VLD(x) ((x) << S_CI8_DM2_WDATA_VLD)
#define F_CI8_DM2_WDATA_VLD    V_CI8_DM2_WDATA_VLD(1U)

#define S_DM2_CI8_RDATA_VLD    28
#define V_DM2_CI8_RDATA_VLD(x) ((x) << S_DM2_CI8_RDATA_VLD)
#define F_DM2_CI8_RDATA_VLD    V_DM2_CI8_RDATA_VLD(1U)

#define S_CI9_ARB2_REQ    27
#define V_CI9_ARB2_REQ(x) ((x) << S_CI9_ARB2_REQ)
#define F_CI9_ARB2_REQ    V_CI9_ARB2_REQ(1U)

#define S_ARB2_CI9_GNT    26
#define V_ARB2_CI9_GNT(x) ((x) << S_ARB2_CI9_GNT)
#define F_ARB2_CI9_GNT    V_ARB2_CI9_GNT(1U)

#define S_CI9_DM2_WDATA_VLD    25
#define V_CI9_DM2_WDATA_VLD(x) ((x) << S_CI9_DM2_WDATA_VLD)
#define F_CI9_DM2_WDATA_VLD    V_CI9_DM2_WDATA_VLD(1U)

#define S_DM2_CI9_RDATA_VLD    24
#define V_DM2_CI9_RDATA_VLD(x) ((x) << S_DM2_CI9_RDATA_VLD)
#define F_DM2_CI9_RDATA_VLD    V_DM2_CI9_RDATA_VLD(1U)

#define S_CI10_ARB2_REQ    23
#define V_CI10_ARB2_REQ(x) ((x) << S_CI10_ARB2_REQ)
#define F_CI10_ARB2_REQ    V_CI10_ARB2_REQ(1U)

#define S_ARB2_CI10_GNT    22
#define V_ARB2_CI10_GNT(x) ((x) << S_ARB2_CI10_GNT)
#define F_ARB2_CI10_GNT    V_ARB2_CI10_GNT(1U)

#define S_CI10_DM2_WDATA_VLD    21
#define V_CI10_DM2_WDATA_VLD(x) ((x) << S_CI10_DM2_WDATA_VLD)
#define F_CI10_DM2_WDATA_VLD    V_CI10_DM2_WDATA_VLD(1U)

#define S_DM2_CI10_RDATA_VLD    20
#define V_DM2_CI10_RDATA_VLD(x) ((x) << S_DM2_CI10_RDATA_VLD)
#define F_DM2_CI10_RDATA_VLD    V_DM2_CI10_RDATA_VLD(1U)

#define S_CI11_ARB2_REQ    19
#define V_CI11_ARB2_REQ(x) ((x) << S_CI11_ARB2_REQ)
#define F_CI11_ARB2_REQ    V_CI11_ARB2_REQ(1U)

#define S_ARB2_CI11_GNT    18
#define V_ARB2_CI11_GNT(x) ((x) << S_ARB2_CI11_GNT)
#define F_ARB2_CI11_GNT    V_ARB2_CI11_GNT(1U)

#define S_CI11_DM2_WDATA_VLD    17
#define V_CI11_DM2_WDATA_VLD(x) ((x) << S_CI11_DM2_WDATA_VLD)
#define F_CI11_DM2_WDATA_VLD    V_CI11_DM2_WDATA_VLD(1U)

#define S_DM2_CI11_RDATA_VLD    16
#define V_DM2_CI11_RDATA_VLD(x) ((x) << S_DM2_CI11_RDATA_VLD)
#define F_DM2_CI11_RDATA_VLD    V_DM2_CI11_RDATA_VLD(1U)

#define S_CI12_ARB2_REQ    15
#define V_CI12_ARB2_REQ(x) ((x) << S_CI12_ARB2_REQ)
#define F_CI12_ARB2_REQ    V_CI12_ARB2_REQ(1U)

#define S_ARB2_CI12_GNT    14
#define V_ARB2_CI12_GNT(x) ((x) << S_ARB2_CI12_GNT)
#define F_ARB2_CI12_GNT    V_ARB2_CI12_GNT(1U)

#define S_CI12_DM2_WDATA_VLD    13
#define V_CI12_DM2_WDATA_VLD(x) ((x) << S_CI12_DM2_WDATA_VLD)
#define F_CI12_DM2_WDATA_VLD    V_CI12_DM2_WDATA_VLD(1U)

#define S_DM2_CI12_RDATA_VLD    12
#define V_DM2_CI12_RDATA_VLD(x) ((x) << S_DM2_CI12_RDATA_VLD)
#define F_DM2_CI12_RDATA_VLD    V_DM2_CI12_RDATA_VLD(1U)

#define A_MA_TARGET_3_ARBITER_INTERFACE_EXTERNAL_REG1 0xa016

#define S_CI8_ARB3_REQ    31
#define V_CI8_ARB3_REQ(x) ((x) << S_CI8_ARB3_REQ)
#define F_CI8_ARB3_REQ    V_CI8_ARB3_REQ(1U)

#define S_ARB3_CI8_GNT    30
#define V_ARB3_CI8_GNT(x) ((x) << S_ARB3_CI8_GNT)
#define F_ARB3_CI8_GNT    V_ARB3_CI8_GNT(1U)

#define S_CI8_DM3_WDATA_VLD    29
#define V_CI8_DM3_WDATA_VLD(x) ((x) << S_CI8_DM3_WDATA_VLD)
#define F_CI8_DM3_WDATA_VLD    V_CI8_DM3_WDATA_VLD(1U)

#define S_DM3_CI8_RDATA_VLD    28
#define V_DM3_CI8_RDATA_VLD(x) ((x) << S_DM3_CI8_RDATA_VLD)
#define F_DM3_CI8_RDATA_VLD    V_DM3_CI8_RDATA_VLD(1U)

#define S_CI9_ARB3_REQ    27
#define V_CI9_ARB3_REQ(x) ((x) << S_CI9_ARB3_REQ)
#define F_CI9_ARB3_REQ    V_CI9_ARB3_REQ(1U)

#define S_ARB3_CI9_GNT    26
#define V_ARB3_CI9_GNT(x) ((x) << S_ARB3_CI9_GNT)
#define F_ARB3_CI9_GNT    V_ARB3_CI9_GNT(1U)

#define S_CI9_DM3_WDATA_VLD    25
#define V_CI9_DM3_WDATA_VLD(x) ((x) << S_CI9_DM3_WDATA_VLD)
#define F_CI9_DM3_WDATA_VLD    V_CI9_DM3_WDATA_VLD(1U)

#define S_DM3_CI9_RDATA_VLD    24
#define V_DM3_CI9_RDATA_VLD(x) ((x) << S_DM3_CI9_RDATA_VLD)
#define F_DM3_CI9_RDATA_VLD    V_DM3_CI9_RDATA_VLD(1U)

#define S_CI10_ARB3_REQ    23
#define V_CI10_ARB3_REQ(x) ((x) << S_CI10_ARB3_REQ)
#define F_CI10_ARB3_REQ    V_CI10_ARB3_REQ(1U)

#define S_ARB3_CI10_GNT    22
#define V_ARB3_CI10_GNT(x) ((x) << S_ARB3_CI10_GNT)
#define F_ARB3_CI10_GNT    V_ARB3_CI10_GNT(1U)

#define S_CI10_DM3_WDATA_VLD    21
#define V_CI10_DM3_WDATA_VLD(x) ((x) << S_CI10_DM3_WDATA_VLD)
#define F_CI10_DM3_WDATA_VLD    V_CI10_DM3_WDATA_VLD(1U)

#define S_DM3_CI10_RDATA_VLD    20
#define V_DM3_CI10_RDATA_VLD(x) ((x) << S_DM3_CI10_RDATA_VLD)
#define F_DM3_CI10_RDATA_VLD    V_DM3_CI10_RDATA_VLD(1U)

#define S_CI11_ARB3_REQ    19
#define V_CI11_ARB3_REQ(x) ((x) << S_CI11_ARB3_REQ)
#define F_CI11_ARB3_REQ    V_CI11_ARB3_REQ(1U)

#define S_ARB3_CI11_GNT    18
#define V_ARB3_CI11_GNT(x) ((x) << S_ARB3_CI11_GNT)
#define F_ARB3_CI11_GNT    V_ARB3_CI11_GNT(1U)

#define S_CI11_DM3_WDATA_VLD    17
#define V_CI11_DM3_WDATA_VLD(x) ((x) << S_CI11_DM3_WDATA_VLD)
#define F_CI11_DM3_WDATA_VLD    V_CI11_DM3_WDATA_VLD(1U)

#define S_DM3_CI11_RDATA_VLD    16
#define V_DM3_CI11_RDATA_VLD(x) ((x) << S_DM3_CI11_RDATA_VLD)
#define F_DM3_CI11_RDATA_VLD    V_DM3_CI11_RDATA_VLD(1U)

#define S_CI12_ARB3_REQ    15
#define V_CI12_ARB3_REQ(x) ((x) << S_CI12_ARB3_REQ)
#define F_CI12_ARB3_REQ    V_CI12_ARB3_REQ(1U)

#define S_ARB3_CI12_GNT    14
#define V_ARB3_CI12_GNT(x) ((x) << S_ARB3_CI12_GNT)
#define F_ARB3_CI12_GNT    V_ARB3_CI12_GNT(1U)

#define S_CI12_DM3_WDATA_VLD    13
#define V_CI12_DM3_WDATA_VLD(x) ((x) << S_CI12_DM3_WDATA_VLD)
#define F_CI12_DM3_WDATA_VLD    V_CI12_DM3_WDATA_VLD(1U)

#define S_DM3_CI12_RDATA_VLD    12
#define V_DM3_CI12_RDATA_VLD(x) ((x) << S_DM3_CI12_RDATA_VLD)
#define F_DM3_CI12_RDATA_VLD    V_DM3_CI12_RDATA_VLD(1U)

#define A_MA_SGE_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG0 0xa400

#define S_CMD_IN_FIFO_CNT0    30
#define M_CMD_IN_FIFO_CNT0    0x3U
#define V_CMD_IN_FIFO_CNT0(x) ((x) << S_CMD_IN_FIFO_CNT0)
#define G_CMD_IN_FIFO_CNT0(x) (((x) >> S_CMD_IN_FIFO_CNT0) & M_CMD_IN_FIFO_CNT0)

#define S_CMD_SPLIT_FIFO_CNT0    28
#define M_CMD_SPLIT_FIFO_CNT0    0x3U
#define V_CMD_SPLIT_FIFO_CNT0(x) ((x) << S_CMD_SPLIT_FIFO_CNT0)
#define G_CMD_SPLIT_FIFO_CNT0(x) (((x) >> S_CMD_SPLIT_FIFO_CNT0) & M_CMD_SPLIT_FIFO_CNT0)

#define S_CMD_THROTTLE_FIFO_CNT0    22
#define M_CMD_THROTTLE_FIFO_CNT0    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT0(x) ((x) << S_CMD_THROTTLE_FIFO_CNT0)
#define G_CMD_THROTTLE_FIFO_CNT0(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT0) & M_CMD_THROTTLE_FIFO_CNT0)

#define S_RD_CHNL_FIFO_CNT0    15
#define M_RD_CHNL_FIFO_CNT0    0x7fU
#define V_RD_CHNL_FIFO_CNT0(x) ((x) << S_RD_CHNL_FIFO_CNT0)
#define G_RD_CHNL_FIFO_CNT0(x) (((x) >> S_RD_CHNL_FIFO_CNT0) & M_RD_CHNL_FIFO_CNT0)

#define S_RD_DATA_EXT_FIFO_CNT0    13
#define M_RD_DATA_EXT_FIFO_CNT0    0x3U
#define V_RD_DATA_EXT_FIFO_CNT0(x) ((x) << S_RD_DATA_EXT_FIFO_CNT0)
#define G_RD_DATA_EXT_FIFO_CNT0(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT0) & M_RD_DATA_EXT_FIFO_CNT0)

#define S_RD_DATA_512B_FIFO_CNT0    5
#define M_RD_DATA_512B_FIFO_CNT0    0xffU
#define V_RD_DATA_512B_FIFO_CNT0(x) ((x) << S_RD_DATA_512B_FIFO_CNT0)
#define G_RD_DATA_512B_FIFO_CNT0(x) (((x) >> S_RD_DATA_512B_FIFO_CNT0) & M_RD_DATA_512B_FIFO_CNT0)

#define S_RD_REQ_TAG_FIFO_CNT0    1
#define M_RD_REQ_TAG_FIFO_CNT0    0xfU
#define V_RD_REQ_TAG_FIFO_CNT0(x) ((x) << S_RD_REQ_TAG_FIFO_CNT0)
#define G_RD_REQ_TAG_FIFO_CNT0(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT0) & M_RD_REQ_TAG_FIFO_CNT0)

#define A_MA_SGE_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG0 0xa401

#define S_CMD_IN_FIFO_CNT1    30
#define M_CMD_IN_FIFO_CNT1    0x3U
#define V_CMD_IN_FIFO_CNT1(x) ((x) << S_CMD_IN_FIFO_CNT1)
#define G_CMD_IN_FIFO_CNT1(x) (((x) >> S_CMD_IN_FIFO_CNT1) & M_CMD_IN_FIFO_CNT1)

#define S_CMD_SPLIT_FIFO_CNT1    28
#define M_CMD_SPLIT_FIFO_CNT1    0x3U
#define V_CMD_SPLIT_FIFO_CNT1(x) ((x) << S_CMD_SPLIT_FIFO_CNT1)
#define G_CMD_SPLIT_FIFO_CNT1(x) (((x) >> S_CMD_SPLIT_FIFO_CNT1) & M_CMD_SPLIT_FIFO_CNT1)

#define S_CMD_THROTTLE_FIFO_CNT1    22
#define M_CMD_THROTTLE_FIFO_CNT1    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT1(x) ((x) << S_CMD_THROTTLE_FIFO_CNT1)
#define G_CMD_THROTTLE_FIFO_CNT1(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT1) & M_CMD_THROTTLE_FIFO_CNT1)

#define S_RD_CHNL_FIFO_CNT1    15
#define M_RD_CHNL_FIFO_CNT1    0x7fU
#define V_RD_CHNL_FIFO_CNT1(x) ((x) << S_RD_CHNL_FIFO_CNT1)
#define G_RD_CHNL_FIFO_CNT1(x) (((x) >> S_RD_CHNL_FIFO_CNT1) & M_RD_CHNL_FIFO_CNT1)

#define S_RD_DATA_EXT_FIFO_CNT1    13
#define M_RD_DATA_EXT_FIFO_CNT1    0x3U
#define V_RD_DATA_EXT_FIFO_CNT1(x) ((x) << S_RD_DATA_EXT_FIFO_CNT1)
#define G_RD_DATA_EXT_FIFO_CNT1(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT1) & M_RD_DATA_EXT_FIFO_CNT1)

#define S_RD_DATA_512B_FIFO_CNT1    5
#define M_RD_DATA_512B_FIFO_CNT1    0xffU
#define V_RD_DATA_512B_FIFO_CNT1(x) ((x) << S_RD_DATA_512B_FIFO_CNT1)
#define G_RD_DATA_512B_FIFO_CNT1(x) (((x) >> S_RD_DATA_512B_FIFO_CNT1) & M_RD_DATA_512B_FIFO_CNT1)

#define S_RD_REQ_TAG_FIFO_CNT1    1
#define M_RD_REQ_TAG_FIFO_CNT1    0xfU
#define V_RD_REQ_TAG_FIFO_CNT1(x) ((x) << S_RD_REQ_TAG_FIFO_CNT1)
#define G_RD_REQ_TAG_FIFO_CNT1(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT1) & M_RD_REQ_TAG_FIFO_CNT1)

#define A_MA_ULP_TX_CLIENT_INTERFACE_INTERNAL_REG0 0xa402

#define S_CMD_IN_FIFO_CNT2    30
#define M_CMD_IN_FIFO_CNT2    0x3U
#define V_CMD_IN_FIFO_CNT2(x) ((x) << S_CMD_IN_FIFO_CNT2)
#define G_CMD_IN_FIFO_CNT2(x) (((x) >> S_CMD_IN_FIFO_CNT2) & M_CMD_IN_FIFO_CNT2)

#define S_CMD_SPLIT_FIFO_CNT2    28
#define M_CMD_SPLIT_FIFO_CNT2    0x3U
#define V_CMD_SPLIT_FIFO_CNT2(x) ((x) << S_CMD_SPLIT_FIFO_CNT2)
#define G_CMD_SPLIT_FIFO_CNT2(x) (((x) >> S_CMD_SPLIT_FIFO_CNT2) & M_CMD_SPLIT_FIFO_CNT2)

#define S_CMD_THROTTLE_FIFO_CNT2    22
#define M_CMD_THROTTLE_FIFO_CNT2    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT2(x) ((x) << S_CMD_THROTTLE_FIFO_CNT2)
#define G_CMD_THROTTLE_FIFO_CNT2(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT2) & M_CMD_THROTTLE_FIFO_CNT2)

#define S_RD_CHNL_FIFO_CNT2    15
#define M_RD_CHNL_FIFO_CNT2    0x7fU
#define V_RD_CHNL_FIFO_CNT2(x) ((x) << S_RD_CHNL_FIFO_CNT2)
#define G_RD_CHNL_FIFO_CNT2(x) (((x) >> S_RD_CHNL_FIFO_CNT2) & M_RD_CHNL_FIFO_CNT2)

#define S_RD_DATA_EXT_FIFO_CNT2    13
#define M_RD_DATA_EXT_FIFO_CNT2    0x3U
#define V_RD_DATA_EXT_FIFO_CNT2(x) ((x) << S_RD_DATA_EXT_FIFO_CNT2)
#define G_RD_DATA_EXT_FIFO_CNT2(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT2) & M_RD_DATA_EXT_FIFO_CNT2)

#define S_RD_DATA_512B_FIFO_CNT2    5
#define M_RD_DATA_512B_FIFO_CNT2    0xffU
#define V_RD_DATA_512B_FIFO_CNT2(x) ((x) << S_RD_DATA_512B_FIFO_CNT2)
#define G_RD_DATA_512B_FIFO_CNT2(x) (((x) >> S_RD_DATA_512B_FIFO_CNT2) & M_RD_DATA_512B_FIFO_CNT2)

#define S_RD_REQ_TAG_FIFO_CNT2    1
#define M_RD_REQ_TAG_FIFO_CNT2    0xfU
#define V_RD_REQ_TAG_FIFO_CNT2(x) ((x) << S_RD_REQ_TAG_FIFO_CNT2)
#define G_RD_REQ_TAG_FIFO_CNT2(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT2) & M_RD_REQ_TAG_FIFO_CNT2)

#define A_MA_ULP_RX_CLIENT_INTERFACE_INTERNAL_REG0 0xa403

#define S_CMD_IN_FIFO_CNT3    30
#define M_CMD_IN_FIFO_CNT3    0x3U
#define V_CMD_IN_FIFO_CNT3(x) ((x) << S_CMD_IN_FIFO_CNT3)
#define G_CMD_IN_FIFO_CNT3(x) (((x) >> S_CMD_IN_FIFO_CNT3) & M_CMD_IN_FIFO_CNT3)

#define S_CMD_SPLIT_FIFO_CNT3    28
#define M_CMD_SPLIT_FIFO_CNT3    0x3U
#define V_CMD_SPLIT_FIFO_CNT3(x) ((x) << S_CMD_SPLIT_FIFO_CNT3)
#define G_CMD_SPLIT_FIFO_CNT3(x) (((x) >> S_CMD_SPLIT_FIFO_CNT3) & M_CMD_SPLIT_FIFO_CNT3)

#define S_CMD_THROTTLE_FIFO_CNT3    22
#define M_CMD_THROTTLE_FIFO_CNT3    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT3(x) ((x) << S_CMD_THROTTLE_FIFO_CNT3)
#define G_CMD_THROTTLE_FIFO_CNT3(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT3) & M_CMD_THROTTLE_FIFO_CNT3)

#define S_RD_CHNL_FIFO_CNT3    15
#define M_RD_CHNL_FIFO_CNT3    0x7fU
#define V_RD_CHNL_FIFO_CNT3(x) ((x) << S_RD_CHNL_FIFO_CNT3)
#define G_RD_CHNL_FIFO_CNT3(x) (((x) >> S_RD_CHNL_FIFO_CNT3) & M_RD_CHNL_FIFO_CNT3)

#define S_RD_DATA_EXT_FIFO_CNT3    13
#define M_RD_DATA_EXT_FIFO_CNT3    0x3U
#define V_RD_DATA_EXT_FIFO_CNT3(x) ((x) << S_RD_DATA_EXT_FIFO_CNT3)
#define G_RD_DATA_EXT_FIFO_CNT3(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT3) & M_RD_DATA_EXT_FIFO_CNT3)

#define S_RD_DATA_512B_FIFO_CNT3    5
#define M_RD_DATA_512B_FIFO_CNT3    0xffU
#define V_RD_DATA_512B_FIFO_CNT3(x) ((x) << S_RD_DATA_512B_FIFO_CNT3)
#define G_RD_DATA_512B_FIFO_CNT3(x) (((x) >> S_RD_DATA_512B_FIFO_CNT3) & M_RD_DATA_512B_FIFO_CNT3)

#define S_RD_REQ_TAG_FIFO_CNT3    1
#define M_RD_REQ_TAG_FIFO_CNT3    0xfU
#define V_RD_REQ_TAG_FIFO_CNT3(x) ((x) << S_RD_REQ_TAG_FIFO_CNT3)
#define G_RD_REQ_TAG_FIFO_CNT3(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT3) & M_RD_REQ_TAG_FIFO_CNT3)

#define A_MA_ULP_TX_RX_CLIENT_INTERFACE_INTERNAL_REG0 0xa404

#define S_CMD_IN_FIFO_CNT4    30
#define M_CMD_IN_FIFO_CNT4    0x3U
#define V_CMD_IN_FIFO_CNT4(x) ((x) << S_CMD_IN_FIFO_CNT4)
#define G_CMD_IN_FIFO_CNT4(x) (((x) >> S_CMD_IN_FIFO_CNT4) & M_CMD_IN_FIFO_CNT4)

#define S_CMD_SPLIT_FIFO_CNT4    28
#define M_CMD_SPLIT_FIFO_CNT4    0x3U
#define V_CMD_SPLIT_FIFO_CNT4(x) ((x) << S_CMD_SPLIT_FIFO_CNT4)
#define G_CMD_SPLIT_FIFO_CNT4(x) (((x) >> S_CMD_SPLIT_FIFO_CNT4) & M_CMD_SPLIT_FIFO_CNT4)

#define S_CMD_THROTTLE_FIFO_CNT4    22
#define M_CMD_THROTTLE_FIFO_CNT4    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT4(x) ((x) << S_CMD_THROTTLE_FIFO_CNT4)
#define G_CMD_THROTTLE_FIFO_CNT4(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT4) & M_CMD_THROTTLE_FIFO_CNT4)

#define S_RD_CHNL_FIFO_CNT4    15
#define M_RD_CHNL_FIFO_CNT4    0x7fU
#define V_RD_CHNL_FIFO_CNT4(x) ((x) << S_RD_CHNL_FIFO_CNT4)
#define G_RD_CHNL_FIFO_CNT4(x) (((x) >> S_RD_CHNL_FIFO_CNT4) & M_RD_CHNL_FIFO_CNT4)

#define S_RD_DATA_EXT_FIFO_CNT4    13
#define M_RD_DATA_EXT_FIFO_CNT4    0x3U
#define V_RD_DATA_EXT_FIFO_CNT4(x) ((x) << S_RD_DATA_EXT_FIFO_CNT4)
#define G_RD_DATA_EXT_FIFO_CNT4(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT4) & M_RD_DATA_EXT_FIFO_CNT4)

#define S_RD_DATA_512B_FIFO_CNT4    5
#define M_RD_DATA_512B_FIFO_CNT4    0xffU
#define V_RD_DATA_512B_FIFO_CNT4(x) ((x) << S_RD_DATA_512B_FIFO_CNT4)
#define G_RD_DATA_512B_FIFO_CNT4(x) (((x) >> S_RD_DATA_512B_FIFO_CNT4) & M_RD_DATA_512B_FIFO_CNT4)

#define S_RD_REQ_TAG_FIFO_CNT4    1
#define M_RD_REQ_TAG_FIFO_CNT4    0xfU
#define V_RD_REQ_TAG_FIFO_CNT4(x) ((x) << S_RD_REQ_TAG_FIFO_CNT4)
#define G_RD_REQ_TAG_FIFO_CNT4(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT4) & M_RD_REQ_TAG_FIFO_CNT4)

#define A_MA_TP_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG0 0xa405

#define S_CMD_IN_FIFO_CNT5    30
#define M_CMD_IN_FIFO_CNT5    0x3U
#define V_CMD_IN_FIFO_CNT5(x) ((x) << S_CMD_IN_FIFO_CNT5)
#define G_CMD_IN_FIFO_CNT5(x) (((x) >> S_CMD_IN_FIFO_CNT5) & M_CMD_IN_FIFO_CNT5)

#define S_CMD_SPLIT_FIFO_CNT5    28
#define M_CMD_SPLIT_FIFO_CNT5    0x3U
#define V_CMD_SPLIT_FIFO_CNT5(x) ((x) << S_CMD_SPLIT_FIFO_CNT5)
#define G_CMD_SPLIT_FIFO_CNT5(x) (((x) >> S_CMD_SPLIT_FIFO_CNT5) & M_CMD_SPLIT_FIFO_CNT5)

#define S_CMD_THROTTLE_FIFO_CNT5    22
#define M_CMD_THROTTLE_FIFO_CNT5    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT5(x) ((x) << S_CMD_THROTTLE_FIFO_CNT5)
#define G_CMD_THROTTLE_FIFO_CNT5(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT5) & M_CMD_THROTTLE_FIFO_CNT5)

#define S_RD_CHNL_FIFO_CNT5    15
#define M_RD_CHNL_FIFO_CNT5    0x7fU
#define V_RD_CHNL_FIFO_CNT5(x) ((x) << S_RD_CHNL_FIFO_CNT5)
#define G_RD_CHNL_FIFO_CNT5(x) (((x) >> S_RD_CHNL_FIFO_CNT5) & M_RD_CHNL_FIFO_CNT5)

#define S_RD_DATA_EXT_FIFO_CNT5    13
#define M_RD_DATA_EXT_FIFO_CNT5    0x3U
#define V_RD_DATA_EXT_FIFO_CNT5(x) ((x) << S_RD_DATA_EXT_FIFO_CNT5)
#define G_RD_DATA_EXT_FIFO_CNT5(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT5) & M_RD_DATA_EXT_FIFO_CNT5)

#define S_RD_DATA_512B_FIFO_CNT5    5
#define M_RD_DATA_512B_FIFO_CNT5    0xffU
#define V_RD_DATA_512B_FIFO_CNT5(x) ((x) << S_RD_DATA_512B_FIFO_CNT5)
#define G_RD_DATA_512B_FIFO_CNT5(x) (((x) >> S_RD_DATA_512B_FIFO_CNT5) & M_RD_DATA_512B_FIFO_CNT5)

#define S_RD_REQ_TAG_FIFO_CNT5    1
#define M_RD_REQ_TAG_FIFO_CNT5    0xfU
#define V_RD_REQ_TAG_FIFO_CNT5(x) ((x) << S_RD_REQ_TAG_FIFO_CNT5)
#define G_RD_REQ_TAG_FIFO_CNT5(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT5) & M_RD_REQ_TAG_FIFO_CNT5)

#define A_MA_TP_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG0 0xa406

#define S_CMD_IN_FIFO_CNT6    30
#define M_CMD_IN_FIFO_CNT6    0x3U
#define V_CMD_IN_FIFO_CNT6(x) ((x) << S_CMD_IN_FIFO_CNT6)
#define G_CMD_IN_FIFO_CNT6(x) (((x) >> S_CMD_IN_FIFO_CNT6) & M_CMD_IN_FIFO_CNT6)

#define S_CMD_SPLIT_FIFO_CNT6    28
#define M_CMD_SPLIT_FIFO_CNT6    0x3U
#define V_CMD_SPLIT_FIFO_CNT6(x) ((x) << S_CMD_SPLIT_FIFO_CNT6)
#define G_CMD_SPLIT_FIFO_CNT6(x) (((x) >> S_CMD_SPLIT_FIFO_CNT6) & M_CMD_SPLIT_FIFO_CNT6)

#define S_CMD_THROTTLE_FIFO_CNT6    22
#define M_CMD_THROTTLE_FIFO_CNT6    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT6(x) ((x) << S_CMD_THROTTLE_FIFO_CNT6)
#define G_CMD_THROTTLE_FIFO_CNT6(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT6) & M_CMD_THROTTLE_FIFO_CNT6)

#define S_RD_CHNL_FIFO_CNT6    15
#define M_RD_CHNL_FIFO_CNT6    0x7fU
#define V_RD_CHNL_FIFO_CNT6(x) ((x) << S_RD_CHNL_FIFO_CNT6)
#define G_RD_CHNL_FIFO_CNT6(x) (((x) >> S_RD_CHNL_FIFO_CNT6) & M_RD_CHNL_FIFO_CNT6)

#define S_RD_DATA_EXT_FIFO_CNT6    13
#define M_RD_DATA_EXT_FIFO_CNT6    0x3U
#define V_RD_DATA_EXT_FIFO_CNT6(x) ((x) << S_RD_DATA_EXT_FIFO_CNT6)
#define G_RD_DATA_EXT_FIFO_CNT6(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT6) & M_RD_DATA_EXT_FIFO_CNT6)

#define S_RD_DATA_512B_FIFO_CNT6    5
#define M_RD_DATA_512B_FIFO_CNT6    0xffU
#define V_RD_DATA_512B_FIFO_CNT6(x) ((x) << S_RD_DATA_512B_FIFO_CNT6)
#define G_RD_DATA_512B_FIFO_CNT6(x) (((x) >> S_RD_DATA_512B_FIFO_CNT6) & M_RD_DATA_512B_FIFO_CNT6)

#define S_RD_REQ_TAG_FIFO_CNT6    1
#define M_RD_REQ_TAG_FIFO_CNT6    0xfU
#define V_RD_REQ_TAG_FIFO_CNT6(x) ((x) << S_RD_REQ_TAG_FIFO_CNT6)
#define G_RD_REQ_TAG_FIFO_CNT6(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT6) & M_RD_REQ_TAG_FIFO_CNT6)

#define A_MA_LE_CLIENT_INTERFACE_INTERNAL_REG0 0xa407

#define S_CMD_IN_FIFO_CNT7    30
#define M_CMD_IN_FIFO_CNT7    0x3U
#define V_CMD_IN_FIFO_CNT7(x) ((x) << S_CMD_IN_FIFO_CNT7)
#define G_CMD_IN_FIFO_CNT7(x) (((x) >> S_CMD_IN_FIFO_CNT7) & M_CMD_IN_FIFO_CNT7)

#define S_CMD_SPLIT_FIFO_CNT7    28
#define M_CMD_SPLIT_FIFO_CNT7    0x3U
#define V_CMD_SPLIT_FIFO_CNT7(x) ((x) << S_CMD_SPLIT_FIFO_CNT7)
#define G_CMD_SPLIT_FIFO_CNT7(x) (((x) >> S_CMD_SPLIT_FIFO_CNT7) & M_CMD_SPLIT_FIFO_CNT7)

#define S_CMD_THROTTLE_FIFO_CNT7    22
#define M_CMD_THROTTLE_FIFO_CNT7    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT7(x) ((x) << S_CMD_THROTTLE_FIFO_CNT7)
#define G_CMD_THROTTLE_FIFO_CNT7(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT7) & M_CMD_THROTTLE_FIFO_CNT7)

#define S_RD_CHNL_FIFO_CNT7    15
#define M_RD_CHNL_FIFO_CNT7    0x7fU
#define V_RD_CHNL_FIFO_CNT7(x) ((x) << S_RD_CHNL_FIFO_CNT7)
#define G_RD_CHNL_FIFO_CNT7(x) (((x) >> S_RD_CHNL_FIFO_CNT7) & M_RD_CHNL_FIFO_CNT7)

#define S_RD_DATA_EXT_FIFO_CNT7    13
#define M_RD_DATA_EXT_FIFO_CNT7    0x3U
#define V_RD_DATA_EXT_FIFO_CNT7(x) ((x) << S_RD_DATA_EXT_FIFO_CNT7)
#define G_RD_DATA_EXT_FIFO_CNT7(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT7) & M_RD_DATA_EXT_FIFO_CNT7)

#define S_RD_DATA_512B_FIFO_CNT7    5
#define M_RD_DATA_512B_FIFO_CNT7    0xffU
#define V_RD_DATA_512B_FIFO_CNT7(x) ((x) << S_RD_DATA_512B_FIFO_CNT7)
#define G_RD_DATA_512B_FIFO_CNT7(x) (((x) >> S_RD_DATA_512B_FIFO_CNT7) & M_RD_DATA_512B_FIFO_CNT7)

#define S_RD_REQ_TAG_FIFO_CNT7    1
#define M_RD_REQ_TAG_FIFO_CNT7    0xfU
#define V_RD_REQ_TAG_FIFO_CNT7(x) ((x) << S_RD_REQ_TAG_FIFO_CNT7)
#define G_RD_REQ_TAG_FIFO_CNT7(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT7) & M_RD_REQ_TAG_FIFO_CNT7)

#define A_MA_CIM_CLIENT_INTERFACE_INTERNAL_REG0 0xa408

#define S_CMD_IN_FIFO_CNT8    30
#define M_CMD_IN_FIFO_CNT8    0x3U
#define V_CMD_IN_FIFO_CNT8(x) ((x) << S_CMD_IN_FIFO_CNT8)
#define G_CMD_IN_FIFO_CNT8(x) (((x) >> S_CMD_IN_FIFO_CNT8) & M_CMD_IN_FIFO_CNT8)

#define S_CMD_SPLIT_FIFO_CNT8    28
#define M_CMD_SPLIT_FIFO_CNT8    0x3U
#define V_CMD_SPLIT_FIFO_CNT8(x) ((x) << S_CMD_SPLIT_FIFO_CNT8)
#define G_CMD_SPLIT_FIFO_CNT8(x) (((x) >> S_CMD_SPLIT_FIFO_CNT8) & M_CMD_SPLIT_FIFO_CNT8)

#define S_CMD_THROTTLE_FIFO_CNT8    22
#define M_CMD_THROTTLE_FIFO_CNT8    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT8(x) ((x) << S_CMD_THROTTLE_FIFO_CNT8)
#define G_CMD_THROTTLE_FIFO_CNT8(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT8) & M_CMD_THROTTLE_FIFO_CNT8)

#define S_RD_CHNL_FIFO_CNT8    15
#define M_RD_CHNL_FIFO_CNT8    0x7fU
#define V_RD_CHNL_FIFO_CNT8(x) ((x) << S_RD_CHNL_FIFO_CNT8)
#define G_RD_CHNL_FIFO_CNT8(x) (((x) >> S_RD_CHNL_FIFO_CNT8) & M_RD_CHNL_FIFO_CNT8)

#define S_RD_DATA_EXT_FIFO_CNT8    13
#define M_RD_DATA_EXT_FIFO_CNT8    0x3U
#define V_RD_DATA_EXT_FIFO_CNT8(x) ((x) << S_RD_DATA_EXT_FIFO_CNT8)
#define G_RD_DATA_EXT_FIFO_CNT8(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT8) & M_RD_DATA_EXT_FIFO_CNT8)

#define S_RD_DATA_512B_FIFO_CNT8    5
#define M_RD_DATA_512B_FIFO_CNT8    0xffU
#define V_RD_DATA_512B_FIFO_CNT8(x) ((x) << S_RD_DATA_512B_FIFO_CNT8)
#define G_RD_DATA_512B_FIFO_CNT8(x) (((x) >> S_RD_DATA_512B_FIFO_CNT8) & M_RD_DATA_512B_FIFO_CNT8)

#define S_RD_REQ_TAG_FIFO_CNT8    1
#define M_RD_REQ_TAG_FIFO_CNT8    0xfU
#define V_RD_REQ_TAG_FIFO_CNT8(x) ((x) << S_RD_REQ_TAG_FIFO_CNT8)
#define G_RD_REQ_TAG_FIFO_CNT8(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT8) & M_RD_REQ_TAG_FIFO_CNT8)

#define A_MA_PCIE_CLIENT_INTERFACE_INTERNAL_REG0 0xa409

#define S_CMD_IN_FIFO_CNT9    30
#define M_CMD_IN_FIFO_CNT9    0x3U
#define V_CMD_IN_FIFO_CNT9(x) ((x) << S_CMD_IN_FIFO_CNT9)
#define G_CMD_IN_FIFO_CNT9(x) (((x) >> S_CMD_IN_FIFO_CNT9) & M_CMD_IN_FIFO_CNT9)

#define S_CMD_SPLIT_FIFO_CNT9    28
#define M_CMD_SPLIT_FIFO_CNT9    0x3U
#define V_CMD_SPLIT_FIFO_CNT9(x) ((x) << S_CMD_SPLIT_FIFO_CNT9)
#define G_CMD_SPLIT_FIFO_CNT9(x) (((x) >> S_CMD_SPLIT_FIFO_CNT9) & M_CMD_SPLIT_FIFO_CNT9)

#define S_CMD_THROTTLE_FIFO_CNT9    22
#define M_CMD_THROTTLE_FIFO_CNT9    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT9(x) ((x) << S_CMD_THROTTLE_FIFO_CNT9)
#define G_CMD_THROTTLE_FIFO_CNT9(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT9) & M_CMD_THROTTLE_FIFO_CNT9)

#define S_RD_CHNL_FIFO_CNT9    15
#define M_RD_CHNL_FIFO_CNT9    0x7fU
#define V_RD_CHNL_FIFO_CNT9(x) ((x) << S_RD_CHNL_FIFO_CNT9)
#define G_RD_CHNL_FIFO_CNT9(x) (((x) >> S_RD_CHNL_FIFO_CNT9) & M_RD_CHNL_FIFO_CNT9)

#define S_RD_DATA_EXT_FIFO_CNT9    13
#define M_RD_DATA_EXT_FIFO_CNT9    0x3U
#define V_RD_DATA_EXT_FIFO_CNT9(x) ((x) << S_RD_DATA_EXT_FIFO_CNT9)
#define G_RD_DATA_EXT_FIFO_CNT9(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT9) & M_RD_DATA_EXT_FIFO_CNT9)

#define S_RD_DATA_512B_FIFO_CNT9    5
#define M_RD_DATA_512B_FIFO_CNT9    0xffU
#define V_RD_DATA_512B_FIFO_CNT9(x) ((x) << S_RD_DATA_512B_FIFO_CNT9)
#define G_RD_DATA_512B_FIFO_CNT9(x) (((x) >> S_RD_DATA_512B_FIFO_CNT9) & M_RD_DATA_512B_FIFO_CNT9)

#define S_RD_REQ_TAG_FIFO_CNT9    1
#define M_RD_REQ_TAG_FIFO_CNT9    0xfU
#define V_RD_REQ_TAG_FIFO_CNT9(x) ((x) << S_RD_REQ_TAG_FIFO_CNT9)
#define G_RD_REQ_TAG_FIFO_CNT9(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT9) & M_RD_REQ_TAG_FIFO_CNT9)

#define A_MA_PM_TX_CLIENT_INTERFACE_INTERNAL_REG0 0xa40a

#define S_CMD_IN_FIFO_CNT10    30
#define M_CMD_IN_FIFO_CNT10    0x3U
#define V_CMD_IN_FIFO_CNT10(x) ((x) << S_CMD_IN_FIFO_CNT10)
#define G_CMD_IN_FIFO_CNT10(x) (((x) >> S_CMD_IN_FIFO_CNT10) & M_CMD_IN_FIFO_CNT10)

#define S_CMD_SPLIT_FIFO_CNT10    28
#define M_CMD_SPLIT_FIFO_CNT10    0x3U
#define V_CMD_SPLIT_FIFO_CNT10(x) ((x) << S_CMD_SPLIT_FIFO_CNT10)
#define G_CMD_SPLIT_FIFO_CNT10(x) (((x) >> S_CMD_SPLIT_FIFO_CNT10) & M_CMD_SPLIT_FIFO_CNT10)

#define S_CMD_THROTTLE_FIFO_CNT10    22
#define M_CMD_THROTTLE_FIFO_CNT10    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT10(x) ((x) << S_CMD_THROTTLE_FIFO_CNT10)
#define G_CMD_THROTTLE_FIFO_CNT10(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT10) & M_CMD_THROTTLE_FIFO_CNT10)

#define S_RD_CHNL_FIFO_CNT10    15
#define M_RD_CHNL_FIFO_CNT10    0x7fU
#define V_RD_CHNL_FIFO_CNT10(x) ((x) << S_RD_CHNL_FIFO_CNT10)
#define G_RD_CHNL_FIFO_CNT10(x) (((x) >> S_RD_CHNL_FIFO_CNT10) & M_RD_CHNL_FIFO_CNT10)

#define S_RD_DATA_EXT_FIFO_CNT10    13
#define M_RD_DATA_EXT_FIFO_CNT10    0x3U
#define V_RD_DATA_EXT_FIFO_CNT10(x) ((x) << S_RD_DATA_EXT_FIFO_CNT10)
#define G_RD_DATA_EXT_FIFO_CNT10(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT10) & M_RD_DATA_EXT_FIFO_CNT10)

#define S_RD_DATA_512B_FIFO_CNT10    5
#define M_RD_DATA_512B_FIFO_CNT10    0xffU
#define V_RD_DATA_512B_FIFO_CNT10(x) ((x) << S_RD_DATA_512B_FIFO_CNT10)
#define G_RD_DATA_512B_FIFO_CNT10(x) (((x) >> S_RD_DATA_512B_FIFO_CNT10) & M_RD_DATA_512B_FIFO_CNT10)

#define S_RD_REQ_TAG_FIFO_CNT10    1
#define M_RD_REQ_TAG_FIFO_CNT10    0xfU
#define V_RD_REQ_TAG_FIFO_CNT10(x) ((x) << S_RD_REQ_TAG_FIFO_CNT10)
#define G_RD_REQ_TAG_FIFO_CNT10(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT10) & M_RD_REQ_TAG_FIFO_CNT10)

#define A_MA_PM_RX_CLIENT_INTERFACE_INTERNAL_REG0 0xa40b

#define S_CMD_IN_FIFO_CNT11    30
#define M_CMD_IN_FIFO_CNT11    0x3U
#define V_CMD_IN_FIFO_CNT11(x) ((x) << S_CMD_IN_FIFO_CNT11)
#define G_CMD_IN_FIFO_CNT11(x) (((x) >> S_CMD_IN_FIFO_CNT11) & M_CMD_IN_FIFO_CNT11)

#define S_CMD_SPLIT_FIFO_CNT11    28
#define M_CMD_SPLIT_FIFO_CNT11    0x3U
#define V_CMD_SPLIT_FIFO_CNT11(x) ((x) << S_CMD_SPLIT_FIFO_CNT11)
#define G_CMD_SPLIT_FIFO_CNT11(x) (((x) >> S_CMD_SPLIT_FIFO_CNT11) & M_CMD_SPLIT_FIFO_CNT11)

#define S_CMD_THROTTLE_FIFO_CNT11    22
#define M_CMD_THROTTLE_FIFO_CNT11    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT11(x) ((x) << S_CMD_THROTTLE_FIFO_CNT11)
#define G_CMD_THROTTLE_FIFO_CNT11(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT11) & M_CMD_THROTTLE_FIFO_CNT11)

#define S_RD_CHNL_FIFO_CNT11    15
#define M_RD_CHNL_FIFO_CNT11    0x7fU
#define V_RD_CHNL_FIFO_CNT11(x) ((x) << S_RD_CHNL_FIFO_CNT11)
#define G_RD_CHNL_FIFO_CNT11(x) (((x) >> S_RD_CHNL_FIFO_CNT11) & M_RD_CHNL_FIFO_CNT11)

#define S_RD_DATA_EXT_FIFO_CNT11    13
#define M_RD_DATA_EXT_FIFO_CNT11    0x3U
#define V_RD_DATA_EXT_FIFO_CNT11(x) ((x) << S_RD_DATA_EXT_FIFO_CNT11)
#define G_RD_DATA_EXT_FIFO_CNT11(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT11) & M_RD_DATA_EXT_FIFO_CNT11)

#define S_RD_DATA_512B_FIFO_CNT11    5
#define M_RD_DATA_512B_FIFO_CNT11    0xffU
#define V_RD_DATA_512B_FIFO_CNT11(x) ((x) << S_RD_DATA_512B_FIFO_CNT11)
#define G_RD_DATA_512B_FIFO_CNT11(x) (((x) >> S_RD_DATA_512B_FIFO_CNT11) & M_RD_DATA_512B_FIFO_CNT11)

#define S_RD_REQ_TAG_FIFO_CNT11    1
#define M_RD_REQ_TAG_FIFO_CNT11    0xfU
#define V_RD_REQ_TAG_FIFO_CNT11(x) ((x) << S_RD_REQ_TAG_FIFO_CNT11)
#define G_RD_REQ_TAG_FIFO_CNT11(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT11) & M_RD_REQ_TAG_FIFO_CNT11)

#define A_MA_HMA_CLIENT_INTERFACE_INTERNAL_REG0 0xa40c

#define S_CMD_IN_FIFO_CNT12    30
#define M_CMD_IN_FIFO_CNT12    0x3U
#define V_CMD_IN_FIFO_CNT12(x) ((x) << S_CMD_IN_FIFO_CNT12)
#define G_CMD_IN_FIFO_CNT12(x) (((x) >> S_CMD_IN_FIFO_CNT12) & M_CMD_IN_FIFO_CNT12)

#define S_CMD_SPLIT_FIFO_CNT12    28
#define M_CMD_SPLIT_FIFO_CNT12    0x3U
#define V_CMD_SPLIT_FIFO_CNT12(x) ((x) << S_CMD_SPLIT_FIFO_CNT12)
#define G_CMD_SPLIT_FIFO_CNT12(x) (((x) >> S_CMD_SPLIT_FIFO_CNT12) & M_CMD_SPLIT_FIFO_CNT12)

#define S_CMD_THROTTLE_FIFO_CNT12    22
#define M_CMD_THROTTLE_FIFO_CNT12    0x3fU
#define V_CMD_THROTTLE_FIFO_CNT12(x) ((x) << S_CMD_THROTTLE_FIFO_CNT12)
#define G_CMD_THROTTLE_FIFO_CNT12(x) (((x) >> S_CMD_THROTTLE_FIFO_CNT12) & M_CMD_THROTTLE_FIFO_CNT12)

#define S_RD_CHNL_FIFO_CNT12    15
#define M_RD_CHNL_FIFO_CNT12    0x7fU
#define V_RD_CHNL_FIFO_CNT12(x) ((x) << S_RD_CHNL_FIFO_CNT12)
#define G_RD_CHNL_FIFO_CNT12(x) (((x) >> S_RD_CHNL_FIFO_CNT12) & M_RD_CHNL_FIFO_CNT12)

#define S_RD_DATA_EXT_FIFO_CNT12    13
#define M_RD_DATA_EXT_FIFO_CNT12    0x3U
#define V_RD_DATA_EXT_FIFO_CNT12(x) ((x) << S_RD_DATA_EXT_FIFO_CNT12)
#define G_RD_DATA_EXT_FIFO_CNT12(x) (((x) >> S_RD_DATA_EXT_FIFO_CNT12) & M_RD_DATA_EXT_FIFO_CNT12)

#define S_RD_DATA_512B_FIFO_CNT12    5
#define M_RD_DATA_512B_FIFO_CNT12    0xffU
#define V_RD_DATA_512B_FIFO_CNT12(x) ((x) << S_RD_DATA_512B_FIFO_CNT12)
#define G_RD_DATA_512B_FIFO_CNT12(x) (((x) >> S_RD_DATA_512B_FIFO_CNT12) & M_RD_DATA_512B_FIFO_CNT12)

#define S_RD_REQ_TAG_FIFO_CNT12    1
#define M_RD_REQ_TAG_FIFO_CNT12    0xfU
#define V_RD_REQ_TAG_FIFO_CNT12(x) ((x) << S_RD_REQ_TAG_FIFO_CNT12)
#define G_RD_REQ_TAG_FIFO_CNT12(x) (((x) >> S_RD_REQ_TAG_FIFO_CNT12) & M_RD_REQ_TAG_FIFO_CNT12)

#define A_MA_TARGET_0_ARBITER_INTERFACE_INTERNAL_REG0 0xa40d

#define S_WR_DATA_FSM0    23
#define V_WR_DATA_FSM0(x) ((x) << S_WR_DATA_FSM0)
#define F_WR_DATA_FSM0    V_WR_DATA_FSM0(1U)

#define S_RD_DATA_FSM0    22
#define V_RD_DATA_FSM0(x) ((x) << S_RD_DATA_FSM0)
#define F_RD_DATA_FSM0    V_RD_DATA_FSM0(1U)

#define S_TGT_CMD_FIFO_CNT0    19
#define M_TGT_CMD_FIFO_CNT0    0x7U
#define V_TGT_CMD_FIFO_CNT0(x) ((x) << S_TGT_CMD_FIFO_CNT0)
#define G_TGT_CMD_FIFO_CNT0(x) (((x) >> S_TGT_CMD_FIFO_CNT0) & M_TGT_CMD_FIFO_CNT0)

#define S_CLNT_NUM_FIFO_CNT0    16
#define M_CLNT_NUM_FIFO_CNT0    0x7U
#define V_CLNT_NUM_FIFO_CNT0(x) ((x) << S_CLNT_NUM_FIFO_CNT0)
#define G_CLNT_NUM_FIFO_CNT0(x) (((x) >> S_CLNT_NUM_FIFO_CNT0) & M_CLNT_NUM_FIFO_CNT0)

#define S_WR_CMD_TAG_FIFO_CNT_TGT0    8
#define M_WR_CMD_TAG_FIFO_CNT_TGT0    0xffU
#define V_WR_CMD_TAG_FIFO_CNT_TGT0(x) ((x) << S_WR_CMD_TAG_FIFO_CNT_TGT0)
#define G_WR_CMD_TAG_FIFO_CNT_TGT0(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT_TGT0) & M_WR_CMD_TAG_FIFO_CNT_TGT0)

#define S_WR_DATA_512B_FIFO_CNT_TGT0    0
#define M_WR_DATA_512B_FIFO_CNT_TGT0    0xffU
#define V_WR_DATA_512B_FIFO_CNT_TGT0(x) ((x) << S_WR_DATA_512B_FIFO_CNT_TGT0)
#define G_WR_DATA_512B_FIFO_CNT_TGT0(x) (((x) >> S_WR_DATA_512B_FIFO_CNT_TGT0) & M_WR_DATA_512B_FIFO_CNT_TGT0)

#define A_MA_TARGET_1_ARBITER_INTERFACE_INTERNAL_REG0 0xa40e

#define S_WR_DATA_FSM1    23
#define V_WR_DATA_FSM1(x) ((x) << S_WR_DATA_FSM1)
#define F_WR_DATA_FSM1    V_WR_DATA_FSM1(1U)

#define S_RD_DATA_FSM1    22
#define V_RD_DATA_FSM1(x) ((x) << S_RD_DATA_FSM1)
#define F_RD_DATA_FSM1    V_RD_DATA_FSM1(1U)

#define S_TGT_CMD_FIFO_CNT1    19
#define M_TGT_CMD_FIFO_CNT1    0x7U
#define V_TGT_CMD_FIFO_CNT1(x) ((x) << S_TGT_CMD_FIFO_CNT1)
#define G_TGT_CMD_FIFO_CNT1(x) (((x) >> S_TGT_CMD_FIFO_CNT1) & M_TGT_CMD_FIFO_CNT1)

#define S_CLNT_NUM_FIFO_CNT1    16
#define M_CLNT_NUM_FIFO_CNT1    0x7U
#define V_CLNT_NUM_FIFO_CNT1(x) ((x) << S_CLNT_NUM_FIFO_CNT1)
#define G_CLNT_NUM_FIFO_CNT1(x) (((x) >> S_CLNT_NUM_FIFO_CNT1) & M_CLNT_NUM_FIFO_CNT1)

#define S_WR_CMD_TAG_FIFO_CNT_TGT1    8
#define M_WR_CMD_TAG_FIFO_CNT_TGT1    0xffU
#define V_WR_CMD_TAG_FIFO_CNT_TGT1(x) ((x) << S_WR_CMD_TAG_FIFO_CNT_TGT1)
#define G_WR_CMD_TAG_FIFO_CNT_TGT1(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT_TGT1) & M_WR_CMD_TAG_FIFO_CNT_TGT1)

#define S_WR_DATA_512B_FIFO_CNT_TGT1    0
#define M_WR_DATA_512B_FIFO_CNT_TGT1    0xffU
#define V_WR_DATA_512B_FIFO_CNT_TGT1(x) ((x) << S_WR_DATA_512B_FIFO_CNT_TGT1)
#define G_WR_DATA_512B_FIFO_CNT_TGT1(x) (((x) >> S_WR_DATA_512B_FIFO_CNT_TGT1) & M_WR_DATA_512B_FIFO_CNT_TGT1)

#define A_MA_TARGET_2_ARBITER_INTERFACE_INTERNAL_REG0 0xa40f

#define S_WR_DATA_FSM2    23
#define V_WR_DATA_FSM2(x) ((x) << S_WR_DATA_FSM2)
#define F_WR_DATA_FSM2    V_WR_DATA_FSM2(1U)

#define S_RD_DATA_FSM2    22
#define V_RD_DATA_FSM2(x) ((x) << S_RD_DATA_FSM2)
#define F_RD_DATA_FSM2    V_RD_DATA_FSM2(1U)

#define S_TGT_CMD_FIFO_CNT2    19
#define M_TGT_CMD_FIFO_CNT2    0x7U
#define V_TGT_CMD_FIFO_CNT2(x) ((x) << S_TGT_CMD_FIFO_CNT2)
#define G_TGT_CMD_FIFO_CNT2(x) (((x) >> S_TGT_CMD_FIFO_CNT2) & M_TGT_CMD_FIFO_CNT2)

#define S_CLNT_NUM_FIFO_CNT2    16
#define M_CLNT_NUM_FIFO_CNT2    0x7U
#define V_CLNT_NUM_FIFO_CNT2(x) ((x) << S_CLNT_NUM_FIFO_CNT2)
#define G_CLNT_NUM_FIFO_CNT2(x) (((x) >> S_CLNT_NUM_FIFO_CNT2) & M_CLNT_NUM_FIFO_CNT2)

#define S_WR_CMD_TAG_FIFO_CNT_TGT2    8
#define M_WR_CMD_TAG_FIFO_CNT_TGT2    0xffU
#define V_WR_CMD_TAG_FIFO_CNT_TGT2(x) ((x) << S_WR_CMD_TAG_FIFO_CNT_TGT2)
#define G_WR_CMD_TAG_FIFO_CNT_TGT2(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT_TGT2) & M_WR_CMD_TAG_FIFO_CNT_TGT2)

#define S_WR_DATA_512B_FIFO_CNT_TGT2    0
#define M_WR_DATA_512B_FIFO_CNT_TGT2    0xffU
#define V_WR_DATA_512B_FIFO_CNT_TGT2(x) ((x) << S_WR_DATA_512B_FIFO_CNT_TGT2)
#define G_WR_DATA_512B_FIFO_CNT_TGT2(x) (((x) >> S_WR_DATA_512B_FIFO_CNT_TGT2) & M_WR_DATA_512B_FIFO_CNT_TGT2)

#define A_MA_TARGET_3_ARBITER_INTERFACE_INTERNAL_REG0 0xa410

#define S_WR_DATA_FSM3    23
#define V_WR_DATA_FSM3(x) ((x) << S_WR_DATA_FSM3)
#define F_WR_DATA_FSM3    V_WR_DATA_FSM3(1U)

#define S_RD_DATA_FSM3    22
#define V_RD_DATA_FSM3(x) ((x) << S_RD_DATA_FSM3)
#define F_RD_DATA_FSM3    V_RD_DATA_FSM3(1U)

#define S_TGT_CMD_FIFO_CNT3    19
#define M_TGT_CMD_FIFO_CNT3    0x7U
#define V_TGT_CMD_FIFO_CNT3(x) ((x) << S_TGT_CMD_FIFO_CNT3)
#define G_TGT_CMD_FIFO_CNT3(x) (((x) >> S_TGT_CMD_FIFO_CNT3) & M_TGT_CMD_FIFO_CNT3)

#define S_CLNT_NUM_FIFO_CNT3    16
#define M_CLNT_NUM_FIFO_CNT3    0x7U
#define V_CLNT_NUM_FIFO_CNT3(x) ((x) << S_CLNT_NUM_FIFO_CNT3)
#define G_CLNT_NUM_FIFO_CNT3(x) (((x) >> S_CLNT_NUM_FIFO_CNT3) & M_CLNT_NUM_FIFO_CNT3)

#define S_WR_CMD_TAG_FIFO_CNT_TGT3    8
#define M_WR_CMD_TAG_FIFO_CNT_TGT3    0xffU
#define V_WR_CMD_TAG_FIFO_CNT_TGT3(x) ((x) << S_WR_CMD_TAG_FIFO_CNT_TGT3)
#define G_WR_CMD_TAG_FIFO_CNT_TGT3(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT_TGT3) & M_WR_CMD_TAG_FIFO_CNT_TGT3)

#define S_WR_DATA_512B_FIFO_CNT_TGT    0
#define M_WR_DATA_512B_FIFO_CNT_TGT    0xffU
#define V_WR_DATA_512B_FIFO_CNT_TGT(x) ((x) << S_WR_DATA_512B_FIFO_CNT_TGT)
#define G_WR_DATA_512B_FIFO_CNT_TGT(x) (((x) >> S_WR_DATA_512B_FIFO_CNT_TGT) & M_WR_DATA_512B_FIFO_CNT_TGT)

#define A_MA_SGE_THREAD_0_CLNT_EXP_RD_CYC_CNT_LO 0xa412
#define A_MA_SGE_THREAD_1_CLNT_EXP_RD_CYC_CNT_LO 0xa413
#define A_MA_ULP_TX_CLNT_EXP_RD_CYC_CNT_LO 0xa414
#define A_MA_ULP_RX_CLNT_EXP_RD_CYC_CNT_LO 0xa415
#define A_MA_ULP_TX_RX_CLNT_EXP_RD_CYC_CNT_LO 0xa416
#define A_MA_TP_THREAD_0_CLNT_EXP_RD_CYC_CNT_LO 0xa417
#define A_MA_TP_THREAD_1_CLNT_EXP_RD_CYC_CNT_LO 0xa418
#define A_MA_LE_CLNT_EXP_RD_CYC_CNT_LO 0xa419
#define A_MA_CIM_CLNT_EXP_RD_CYC_CNT_LO 0xa41a
#define A_MA_PCIE_CLNT_EXP_RD_CYC_CNT_LO 0xa41b
#define A_MA_PM_TX_CLNT_EXP_RD_CYC_CNT_LO 0xa41c
#define A_MA_PM_RX_CLNT_EXP_RD_CYC_CNT_LO 0xa41d
#define A_MA_HMA_CLNT_EXP_RD_CYC_CNT_LO 0xa41e
#define A_T6_MA_EDRAM0_WRDATA_CNT1 0xa800
#define A_T6_MA_EDRAM0_WRDATA_CNT0 0xa801
#define A_T6_MA_EDRAM1_WRDATA_CNT1 0xa802
#define A_T6_MA_EDRAM1_WRDATA_CNT0 0xa803
#define A_T6_MA_EXT_MEMORY0_WRDATA_CNT1 0xa804
#define A_T6_MA_EXT_MEMORY0_WRDATA_CNT0 0xa805
#define A_T6_MA_HOST_MEMORY_WRDATA_CNT1 0xa806
#define A_T6_MA_HOST_MEMORY_WRDATA_CNT0 0xa807
#define A_T6_MA_EXT_MEMORY1_WRDATA_CNT1 0xa808
#define A_T6_MA_EXT_MEMORY1_WRDATA_CNT0 0xa809
#define A_T6_MA_EDRAM0_RDDATA_CNT1 0xa80a
#define A_T6_MA_EDRAM0_RDDATA_CNT0 0xa80b
#define A_T6_MA_EDRAM1_RDDATA_CNT1 0xa80c
#define A_T6_MA_EDRAM1_RDDATA_CNT0 0xa80d
#define A_T6_MA_EXT_MEMORY0_RDDATA_CNT1 0xa80e
#define A_T6_MA_EXT_MEMORY0_RDDATA_CNT0 0xa80f
#define A_T6_MA_HOST_MEMORY_RDDATA_CNT1 0xa810
#define A_T6_MA_HOST_MEMORY_RDDATA_CNT0 0xa811
#define A_T6_MA_EXT_MEMORY1_RDDATA_CNT1 0xa812
#define A_T6_MA_EXT_MEMORY1_RDDATA_CNT0 0xa813
#define A_MA_SGE_THREAD_0_CLNT_ACT_WR_CYC_CNT_HI 0xac00
#define A_MA_SGE_THREAD_0_CLNT_ACT_WR_CYC_CNT_LO 0xac01
#define A_MA_SGE_THREAD_1_CLNT_ACT_WR_CYC_CNT_HI 0xac02
#define A_MA_SGE_THREAD_1_CLNT_ACT_WR_CYC_CNT_LO 0xac03
#define A_MA_ULP_TX_CLNT_ACT_WR_CYC_CNT_HI 0xac04
#define A_MA_ULP_TX_CLNT_ACT_WR_CYC_CNT_LO 0xac05
#define A_MA_ULP_RX_CLNT_ACT_WR_CYC_CNT_HI 0xac06
#define A_MA_ULP_RX_CLNT_ACT_WR_CYC_CNT_LO 0xac07
#define A_MA_ULP_TX_RX_CLNT_ACT_WR_CYC_CNT_HI 0xac08
#define A_MA_ULP_TX_RX_CLNT_ACT_WR_CYC_CNT_LO 0xac09
#define A_MA_TP_THREAD_0_CLNT_ACT_WR_CYC_CNT_HI 0xac0a
#define A_MA_TP_THREAD_0_CLNT_ACT_WR_CYC_CNT_LO 0xac0b
#define A_MA_TP_THREAD_1_CLNT_ACT_WR_CYC_CNT_HI 0xac0c
#define A_MA_TP_THREAD_1_CLNT_ACT_WR_CYC_CNT_LO 0xac0d
#define A_MA_LE_CLNT_ACT_WR_CYC_CNT_HI 0xac0e
#define A_MA_LE_CLNT_ACT_WR_CYC_CNT_LO 0xac0f
#define A_MA_CIM_CLNT_ACT_WR_CYC_CNT_HI 0xac10
#define A_MA_CIM_CLNT_ACT_WR_CYC_CNT_LO 0xac11
#define A_MA_PCIE_CLNT_ACT_WR_CYC_CNT_HI 0xac12
#define A_MA_PCIE_CLNT_ACT_WR_CYC_CNT_LO 0xac13
#define A_MA_PM_TX_CLNT_ACT_WR_CYC_CNT_HI 0xac14
#define A_MA_PM_TX_CLNT_ACT_WR_CYC_CNT_LO 0xac15
#define A_MA_PM_RX_CLNT_ACT_WR_CYC_CNT_HI 0xac16
#define A_MA_PM_RX_CLNT_ACT_WR_CYC_CNT_LO 0xac17
#define A_MA_HMA_CLNT_ACT_WR_CYC_CNT_HI 0xac18
#define A_MA_HMA_CLNT_ACT_WR_CYC_CNT_LO 0xac19
#define A_MA_SGE_THREAD_0_CLNT_WR_REQ_CNT 0xb000
#define A_MA_SGE_THREAD_1_CLNT_WR_REQ_CNT 0xb001
#define A_MA_ULP_TX_CLNT_WR_REQ_CNT 0xb002
#define A_MA_ULP_RX_CLNT_WR_REQ_CNT 0xb003
#define A_MA_ULP_TX_RX_CLNT_WR_REQ_CNT 0xb004
#define A_MA_TP_THREAD_0_CLNT_WR_REQ_CNT 0xb005
#define A_MA_TP_THREAD_1_CLNT_WR_REQ_CNT 0xb006
#define A_MA_LE_CLNT_WR_REQ_CNT 0xb007
#define A_MA_CIM_CLNT_WR_REQ_CNT 0xb008
#define A_MA_PCIE_CLNT_WR_REQ_CNT 0xb009
#define A_MA_PM_TX_CLNT_WR_REQ_CNT 0xb00a
#define A_MA_PM_RX_CLNT_WR_REQ_CNT 0xb00b
#define A_MA_HMA_CLNT_WR_REQ_CNT 0xb00c
#define A_MA_SGE_THREAD_0_CLNT_RD_REQ_CNT 0xb00d
#define A_MA_SGE_THREAD_1_CLNT_RD_REQ_CNT 0xb00e
#define A_MA_ULP_TX_CLNT_RD_REQ_CNT 0xb00f
#define A_MA_ULP_RX_CLNT_RD_REQ_CNT 0xb010
#define A_MA_ULP_TX_RX_CLNT_RD_REQ_CNT 0xb011
#define A_MA_TP_THREAD_0_CLNT_RD_REQ_CNT 0xb012
#define A_MA_TP_THREAD_1_CLNT_RD_REQ_CNT 0xb013
#define A_MA_LE_CLNT_RD_REQ_CNT 0xb014
#define A_MA_CIM_CLNT_RD_REQ_CNT 0xb015
#define A_MA_PCIE_CLNT_RD_REQ_CNT 0xb016
#define A_MA_PM_TX_CLNT_RD_REQ_CNT 0xb017
#define A_MA_PM_RX_CLNT_RD_REQ_CNT 0xb018
#define A_MA_HMA_CLNT_RD_REQ_CNT 0xb019
#define A_MA_SGE_THREAD_0_CLNT_EXP_RD_CYC_CNT_HI 0xb400
#define A_MA_SGE_THREAD_1_CLNT_EXP_RD_CYC_CNT_HI 0xb401
#define A_MA_ULP_TX_CLNT_EXP_RD_CYC_CNT_HI 0xb402
#define A_MA_ULP_RX_CLNT_EXP_RD_CYC_CNT_HI 0xb403
#define A_MA_ULP_TX_RX_CLNT_EXP_RD_CYC_CNT_HI 0xb404
#define A_MA_TP_THREAD_0_CLNT_EXP_RD_CYC_CNT_HI 0xb405
#define A_MA_TP_THREAD_1_CLNT_EXP_RD_CYC_CNT_HI 0xb406
#define A_MA_LE_CLNT_EXP_RD_CYC_CNT_HI 0xb407
#define A_MA_CIM_CLNT_EXP_RD_CYC_CNT_HI 0xb408
#define A_MA_PCIE_CLNT_EXP_RD_CYC_CNT_HI 0xb409
#define A_MA_PM_TX_CLNT_EXP_RD_CYC_CNT_HI 0xb40a
#define A_MA_PM_RX_CLNT_EXP_RD_CYC_CNT_HI 0xb40b
#define A_MA_HMA_CLNT_EXP_RD_CYC_CNT_HI 0xb40c
#define A_MA_SGE_THREAD_0_CLNT_EXP_WR_CYC_CNT_HI 0xb40d
#define A_MA_SGE_THREAD_1_CLNT_EXP_WR_CYC_CNT_HI 0xb40e
#define A_MA_ULP_TX_CLNT_EXP_WR_CYC_CNT_HI 0xb40f
#define A_MA_ULP_RX_CLNT_EXP_WR_CYC_CNT_HI 0xb410
#define A_MA_ULP_TX_RX_CLNT_EXP_WR_CYC_CNT_HI 0xb411
#define A_MA_TP_THREAD_0_CLNT_EXP_WR_CYC_CNT_HI 0xb412
#define A_MA_TP_THREAD_1_CLNT_EXP_WR_CYC_CNT_HI 0xb413
#define A_MA_LE_CLNT_EXP_WR_CYC_CNT_HI 0xb414
#define A_MA_CIM_CLNT_EXP_WR_CYC_CNT_HI 0xb415
#define A_MA_PCIE_CLNT_EXP_WR_CYC_CNT_HI 0xb416
#define A_MA_PM_TX_CLNT_EXP_WR_CYC_CNT_HI 0xb417
#define A_MA_PM_RX_CLNT_EXP_WR_CYC_CNT_HI 0xb418
#define A_MA_HMA_CLNT_EXP_WR_CYC_CNT_HI 0xb419
#define A_MA_SGE_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG1 0xe400

#define S_WR_DATA_EXT_FIFO_CNT0    30
#define M_WR_DATA_EXT_FIFO_CNT0    0x3U
#define V_WR_DATA_EXT_FIFO_CNT0(x) ((x) << S_WR_DATA_EXT_FIFO_CNT0)
#define G_WR_DATA_EXT_FIFO_CNT0(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT0) & M_WR_DATA_EXT_FIFO_CNT0)

#define S_WR_CMD_TAG_FIFO_CNT0    26
#define M_WR_CMD_TAG_FIFO_CNT0    0xfU
#define V_WR_CMD_TAG_FIFO_CNT0(x) ((x) << S_WR_CMD_TAG_FIFO_CNT0)
#define G_WR_CMD_TAG_FIFO_CNT0(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT0) & M_WR_CMD_TAG_FIFO_CNT0)

#define S_WR_DATA_512B_FIFO_CNT0    18
#define M_WR_DATA_512B_FIFO_CNT0    0xffU
#define V_WR_DATA_512B_FIFO_CNT0(x) ((x) << S_WR_DATA_512B_FIFO_CNT0)
#define G_WR_DATA_512B_FIFO_CNT0(x) (((x) >> S_WR_DATA_512B_FIFO_CNT0) & M_WR_DATA_512B_FIFO_CNT0)

#define S_RD_DATA_ALIGN_FSM0    17
#define V_RD_DATA_ALIGN_FSM0(x) ((x) << S_RD_DATA_ALIGN_FSM0)
#define F_RD_DATA_ALIGN_FSM0    V_RD_DATA_ALIGN_FSM0(1U)

#define S_RD_DATA_FETCH_FSM0    16
#define V_RD_DATA_FETCH_FSM0(x) ((x) << S_RD_DATA_FETCH_FSM0)
#define F_RD_DATA_FETCH_FSM0    V_RD_DATA_FETCH_FSM0(1U)

#define S_COHERENCY_TX_FSM0    15
#define V_COHERENCY_TX_FSM0(x) ((x) << S_COHERENCY_TX_FSM0)
#define F_COHERENCY_TX_FSM0    V_COHERENCY_TX_FSM0(1U)

#define S_COHERENCY_RX_FSM0    14
#define V_COHERENCY_RX_FSM0(x) ((x) << S_COHERENCY_RX_FSM0)
#define F_COHERENCY_RX_FSM0    V_COHERENCY_RX_FSM0(1U)

#define S_ARB_REQ_FSM0    13
#define V_ARB_REQ_FSM0(x) ((x) << S_ARB_REQ_FSM0)
#define F_ARB_REQ_FSM0    V_ARB_REQ_FSM0(1U)

#define S_CMD_SPLIT_FSM0    10
#define M_CMD_SPLIT_FSM0    0x7U
#define V_CMD_SPLIT_FSM0(x) ((x) << S_CMD_SPLIT_FSM0)
#define G_CMD_SPLIT_FSM0(x) (((x) >> S_CMD_SPLIT_FSM0) & M_CMD_SPLIT_FSM0)

#define A_MA_SGE_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG1 0xe420

#define S_WR_DATA_EXT_FIFO_CNT1    30
#define M_WR_DATA_EXT_FIFO_CNT1    0x3U
#define V_WR_DATA_EXT_FIFO_CNT1(x) ((x) << S_WR_DATA_EXT_FIFO_CNT1)
#define G_WR_DATA_EXT_FIFO_CNT1(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT1) & M_WR_DATA_EXT_FIFO_CNT1)

#define S_WR_CMD_TAG_FIFO_CNT1    26
#define M_WR_CMD_TAG_FIFO_CNT1    0xfU
#define V_WR_CMD_TAG_FIFO_CNT1(x) ((x) << S_WR_CMD_TAG_FIFO_CNT1)
#define G_WR_CMD_TAG_FIFO_CNT1(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT1) & M_WR_CMD_TAG_FIFO_CNT1)

#define S_WR_DATA_512B_FIFO_CNT1    18
#define M_WR_DATA_512B_FIFO_CNT1    0xffU
#define V_WR_DATA_512B_FIFO_CNT1(x) ((x) << S_WR_DATA_512B_FIFO_CNT1)
#define G_WR_DATA_512B_FIFO_CNT1(x) (((x) >> S_WR_DATA_512B_FIFO_CNT1) & M_WR_DATA_512B_FIFO_CNT1)

#define S_RD_DATA_ALIGN_FSM1    17
#define V_RD_DATA_ALIGN_FSM1(x) ((x) << S_RD_DATA_ALIGN_FSM1)
#define F_RD_DATA_ALIGN_FSM1    V_RD_DATA_ALIGN_FSM1(1U)

#define S_RD_DATA_FETCH_FSM1    16
#define V_RD_DATA_FETCH_FSM1(x) ((x) << S_RD_DATA_FETCH_FSM1)
#define F_RD_DATA_FETCH_FSM1    V_RD_DATA_FETCH_FSM1(1U)

#define S_COHERENCY_TX_FSM1    15
#define V_COHERENCY_TX_FSM1(x) ((x) << S_COHERENCY_TX_FSM1)
#define F_COHERENCY_TX_FSM1    V_COHERENCY_TX_FSM1(1U)

#define S_COHERENCY_RX_FSM1    14
#define V_COHERENCY_RX_FSM1(x) ((x) << S_COHERENCY_RX_FSM1)
#define F_COHERENCY_RX_FSM1    V_COHERENCY_RX_FSM1(1U)

#define S_ARB_REQ_FSM1    13
#define V_ARB_REQ_FSM1(x) ((x) << S_ARB_REQ_FSM1)
#define F_ARB_REQ_FSM1    V_ARB_REQ_FSM1(1U)

#define S_CMD_SPLIT_FSM1    10
#define M_CMD_SPLIT_FSM1    0x7U
#define V_CMD_SPLIT_FSM1(x) ((x) << S_CMD_SPLIT_FSM1)
#define G_CMD_SPLIT_FSM1(x) (((x) >> S_CMD_SPLIT_FSM1) & M_CMD_SPLIT_FSM1)

#define A_MA_ULP_TX_CLIENT_INTERFACE_INTERNAL_REG1 0xe440

#define S_WR_DATA_EXT_FIFO_CNT2    30
#define M_WR_DATA_EXT_FIFO_CNT2    0x3U
#define V_WR_DATA_EXT_FIFO_CNT2(x) ((x) << S_WR_DATA_EXT_FIFO_CNT2)
#define G_WR_DATA_EXT_FIFO_CNT2(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT2) & M_WR_DATA_EXT_FIFO_CNT2)

#define S_WR_CMD_TAG_FIFO_CNT2    26
#define M_WR_CMD_TAG_FIFO_CNT2    0xfU
#define V_WR_CMD_TAG_FIFO_CNT2(x) ((x) << S_WR_CMD_TAG_FIFO_CNT2)
#define G_WR_CMD_TAG_FIFO_CNT2(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT2) & M_WR_CMD_TAG_FIFO_CNT2)

#define S_WR_DATA_512B_FIFO_CNT2    18
#define M_WR_DATA_512B_FIFO_CNT2    0xffU
#define V_WR_DATA_512B_FIFO_CNT2(x) ((x) << S_WR_DATA_512B_FIFO_CNT2)
#define G_WR_DATA_512B_FIFO_CNT2(x) (((x) >> S_WR_DATA_512B_FIFO_CNT2) & M_WR_DATA_512B_FIFO_CNT2)

#define S_RD_DATA_ALIGN_FSM2    17
#define V_RD_DATA_ALIGN_FSM2(x) ((x) << S_RD_DATA_ALIGN_FSM2)
#define F_RD_DATA_ALIGN_FSM2    V_RD_DATA_ALIGN_FSM2(1U)

#define S_RD_DATA_FETCH_FSM2    16
#define V_RD_DATA_FETCH_FSM2(x) ((x) << S_RD_DATA_FETCH_FSM2)
#define F_RD_DATA_FETCH_FSM2    V_RD_DATA_FETCH_FSM2(1U)

#define S_COHERENCY_TX_FSM2    15
#define V_COHERENCY_TX_FSM2(x) ((x) << S_COHERENCY_TX_FSM2)
#define F_COHERENCY_TX_FSM2    V_COHERENCY_TX_FSM2(1U)

#define S_COHERENCY_RX_FSM2    14
#define V_COHERENCY_RX_FSM2(x) ((x) << S_COHERENCY_RX_FSM2)
#define F_COHERENCY_RX_FSM2    V_COHERENCY_RX_FSM2(1U)

#define S_ARB_REQ_FSM2    13
#define V_ARB_REQ_FSM2(x) ((x) << S_ARB_REQ_FSM2)
#define F_ARB_REQ_FSM2    V_ARB_REQ_FSM2(1U)

#define S_CMD_SPLIT_FSM2    10
#define M_CMD_SPLIT_FSM2    0x7U
#define V_CMD_SPLIT_FSM2(x) ((x) << S_CMD_SPLIT_FSM2)
#define G_CMD_SPLIT_FSM2(x) (((x) >> S_CMD_SPLIT_FSM2) & M_CMD_SPLIT_FSM2)

#define A_MA_ULP_RX_CLIENT_INTERFACE_INTERNAL_REG1 0xe460

#define S_WR_DATA_EXT_FIFO_CNT3    30
#define M_WR_DATA_EXT_FIFO_CNT3    0x3U
#define V_WR_DATA_EXT_FIFO_CNT3(x) ((x) << S_WR_DATA_EXT_FIFO_CNT3)
#define G_WR_DATA_EXT_FIFO_CNT3(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT3) & M_WR_DATA_EXT_FIFO_CNT3)

#define S_WR_CMD_TAG_FIFO_CNT3    26
#define M_WR_CMD_TAG_FIFO_CNT3    0xfU
#define V_WR_CMD_TAG_FIFO_CNT3(x) ((x) << S_WR_CMD_TAG_FIFO_CNT3)
#define G_WR_CMD_TAG_FIFO_CNT3(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT3) & M_WR_CMD_TAG_FIFO_CNT3)

#define S_WR_DATA_512B_FIFO_CNT3    18
#define M_WR_DATA_512B_FIFO_CNT3    0xffU
#define V_WR_DATA_512B_FIFO_CNT3(x) ((x) << S_WR_DATA_512B_FIFO_CNT3)
#define G_WR_DATA_512B_FIFO_CNT3(x) (((x) >> S_WR_DATA_512B_FIFO_CNT3) & M_WR_DATA_512B_FIFO_CNT3)

#define S_RD_DATA_ALIGN_FSM3    17
#define V_RD_DATA_ALIGN_FSM3(x) ((x) << S_RD_DATA_ALIGN_FSM3)
#define F_RD_DATA_ALIGN_FSM3    V_RD_DATA_ALIGN_FSM3(1U)

#define S_RD_DATA_FETCH_FSM3    16
#define V_RD_DATA_FETCH_FSM3(x) ((x) << S_RD_DATA_FETCH_FSM3)
#define F_RD_DATA_FETCH_FSM3    V_RD_DATA_FETCH_FSM3(1U)

#define S_COHERENCY_TX_FSM3    15
#define V_COHERENCY_TX_FSM3(x) ((x) << S_COHERENCY_TX_FSM3)
#define F_COHERENCY_TX_FSM3    V_COHERENCY_TX_FSM3(1U)

#define S_COHERENCY_RX_FSM3    14
#define V_COHERENCY_RX_FSM3(x) ((x) << S_COHERENCY_RX_FSM3)
#define F_COHERENCY_RX_FSM3    V_COHERENCY_RX_FSM3(1U)

#define S_ARB_REQ_FSM3    13
#define V_ARB_REQ_FSM3(x) ((x) << S_ARB_REQ_FSM3)
#define F_ARB_REQ_FSM3    V_ARB_REQ_FSM3(1U)

#define S_CMD_SPLIT_FSM3    10
#define M_CMD_SPLIT_FSM3    0x7U
#define V_CMD_SPLIT_FSM3(x) ((x) << S_CMD_SPLIT_FSM3)
#define G_CMD_SPLIT_FSM3(x) (((x) >> S_CMD_SPLIT_FSM3) & M_CMD_SPLIT_FSM3)

#define A_MA_ULP_TX_RX_CLIENT_INTERFACE_INTERNAL_REG1 0xe480

#define S_WR_DATA_EXT_FIFO_CNT4    30
#define M_WR_DATA_EXT_FIFO_CNT4    0x3U
#define V_WR_DATA_EXT_FIFO_CNT4(x) ((x) << S_WR_DATA_EXT_FIFO_CNT4)
#define G_WR_DATA_EXT_FIFO_CNT4(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT4) & M_WR_DATA_EXT_FIFO_CNT4)

#define S_WR_CMD_TAG_FIFO_CNT4    26
#define M_WR_CMD_TAG_FIFO_CNT4    0xfU
#define V_WR_CMD_TAG_FIFO_CNT4(x) ((x) << S_WR_CMD_TAG_FIFO_CNT4)
#define G_WR_CMD_TAG_FIFO_CNT4(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT4) & M_WR_CMD_TAG_FIFO_CNT4)

#define S_WR_DATA_512B_FIFO_CNT4    18
#define M_WR_DATA_512B_FIFO_CNT4    0xffU
#define V_WR_DATA_512B_FIFO_CNT4(x) ((x) << S_WR_DATA_512B_FIFO_CNT4)
#define G_WR_DATA_512B_FIFO_CNT4(x) (((x) >> S_WR_DATA_512B_FIFO_CNT4) & M_WR_DATA_512B_FIFO_CNT4)

#define S_RD_DATA_ALIGN_FSM4    17
#define V_RD_DATA_ALIGN_FSM4(x) ((x) << S_RD_DATA_ALIGN_FSM4)
#define F_RD_DATA_ALIGN_FSM4    V_RD_DATA_ALIGN_FSM4(1U)

#define S_RD_DATA_FETCH_FSM4    16
#define V_RD_DATA_FETCH_FSM4(x) ((x) << S_RD_DATA_FETCH_FSM4)
#define F_RD_DATA_FETCH_FSM4    V_RD_DATA_FETCH_FSM4(1U)

#define S_COHERENCY_TX_FSM4    15
#define V_COHERENCY_TX_FSM4(x) ((x) << S_COHERENCY_TX_FSM4)
#define F_COHERENCY_TX_FSM4    V_COHERENCY_TX_FSM4(1U)

#define S_COHERENCY_RX_FSM4    14
#define V_COHERENCY_RX_FSM4(x) ((x) << S_COHERENCY_RX_FSM4)
#define F_COHERENCY_RX_FSM4    V_COHERENCY_RX_FSM4(1U)

#define S_ARB_REQ_FSM4    13
#define V_ARB_REQ_FSM4(x) ((x) << S_ARB_REQ_FSM4)
#define F_ARB_REQ_FSM4    V_ARB_REQ_FSM4(1U)

#define S_CMD_SPLIT_FSM4    10
#define M_CMD_SPLIT_FSM4    0x7U
#define V_CMD_SPLIT_FSM4(x) ((x) << S_CMD_SPLIT_FSM4)
#define G_CMD_SPLIT_FSM4(x) (((x) >> S_CMD_SPLIT_FSM4) & M_CMD_SPLIT_FSM4)

#define A_MA_TP_THREAD_0_CLIENT_INTERFACE_INTERNAL_REG1 0xe4a0

#define S_WR_DATA_EXT_FIFO_CNT5    30
#define M_WR_DATA_EXT_FIFO_CNT5    0x3U
#define V_WR_DATA_EXT_FIFO_CNT5(x) ((x) << S_WR_DATA_EXT_FIFO_CNT5)
#define G_WR_DATA_EXT_FIFO_CNT5(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT5) & M_WR_DATA_EXT_FIFO_CNT5)

#define S_WR_CMD_TAG_FIFO_CNT5    26
#define M_WR_CMD_TAG_FIFO_CNT5    0xfU
#define V_WR_CMD_TAG_FIFO_CNT5(x) ((x) << S_WR_CMD_TAG_FIFO_CNT5)
#define G_WR_CMD_TAG_FIFO_CNT5(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT5) & M_WR_CMD_TAG_FIFO_CNT5)

#define S_WR_DATA_512B_FIFO_CNT5    18
#define M_WR_DATA_512B_FIFO_CNT5    0xffU
#define V_WR_DATA_512B_FIFO_CNT5(x) ((x) << S_WR_DATA_512B_FIFO_CNT5)
#define G_WR_DATA_512B_FIFO_CNT5(x) (((x) >> S_WR_DATA_512B_FIFO_CNT5) & M_WR_DATA_512B_FIFO_CNT5)

#define S_RD_DATA_ALIGN_FSM5    17
#define V_RD_DATA_ALIGN_FSM5(x) ((x) << S_RD_DATA_ALIGN_FSM5)
#define F_RD_DATA_ALIGN_FSM5    V_RD_DATA_ALIGN_FSM5(1U)

#define S_RD_DATA_FETCH_FSM5    16
#define V_RD_DATA_FETCH_FSM5(x) ((x) << S_RD_DATA_FETCH_FSM5)
#define F_RD_DATA_FETCH_FSM5    V_RD_DATA_FETCH_FSM5(1U)

#define S_COHERENCY_TX_FSM5    15
#define V_COHERENCY_TX_FSM5(x) ((x) << S_COHERENCY_TX_FSM5)
#define F_COHERENCY_TX_FSM5    V_COHERENCY_TX_FSM5(1U)

#define S_COHERENCY_RX_FSM5    14
#define V_COHERENCY_RX_FSM5(x) ((x) << S_COHERENCY_RX_FSM5)
#define F_COHERENCY_RX_FSM5    V_COHERENCY_RX_FSM5(1U)

#define S_ARB_REQ_FSM5    13
#define V_ARB_REQ_FSM5(x) ((x) << S_ARB_REQ_FSM5)
#define F_ARB_REQ_FSM5    V_ARB_REQ_FSM5(1U)

#define S_CMD_SPLIT_FSM5    10
#define M_CMD_SPLIT_FSM5    0x7U
#define V_CMD_SPLIT_FSM5(x) ((x) << S_CMD_SPLIT_FSM5)
#define G_CMD_SPLIT_FSM5(x) (((x) >> S_CMD_SPLIT_FSM5) & M_CMD_SPLIT_FSM5)

#define A_MA_TP_THREAD_1_CLIENT_INTERFACE_INTERNAL_REG1 0xe4c0

#define S_WR_DATA_EXT_FIFO_CNT6    30
#define M_WR_DATA_EXT_FIFO_CNT6    0x3U
#define V_WR_DATA_EXT_FIFO_CNT6(x) ((x) << S_WR_DATA_EXT_FIFO_CNT6)
#define G_WR_DATA_EXT_FIFO_CNT6(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT6) & M_WR_DATA_EXT_FIFO_CNT6)

#define S_WR_CMD_TAG_FIFO_CNT6    26
#define M_WR_CMD_TAG_FIFO_CNT6    0xfU
#define V_WR_CMD_TAG_FIFO_CNT6(x) ((x) << S_WR_CMD_TAG_FIFO_CNT6)
#define G_WR_CMD_TAG_FIFO_CNT6(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT6) & M_WR_CMD_TAG_FIFO_CNT6)

#define S_WR_DATA_512B_FIFO_CNT6    18
#define M_WR_DATA_512B_FIFO_CNT6    0xffU
#define V_WR_DATA_512B_FIFO_CNT6(x) ((x) << S_WR_DATA_512B_FIFO_CNT6)
#define G_WR_DATA_512B_FIFO_CNT6(x) (((x) >> S_WR_DATA_512B_FIFO_CNT6) & M_WR_DATA_512B_FIFO_CNT6)

#define S_RD_DATA_ALIGN_FSM6    17
#define V_RD_DATA_ALIGN_FSM6(x) ((x) << S_RD_DATA_ALIGN_FSM6)
#define F_RD_DATA_ALIGN_FSM6    V_RD_DATA_ALIGN_FSM6(1U)

#define S_RD_DATA_FETCH_FSM6    16
#define V_RD_DATA_FETCH_FSM6(x) ((x) << S_RD_DATA_FETCH_FSM6)
#define F_RD_DATA_FETCH_FSM6    V_RD_DATA_FETCH_FSM6(1U)

#define S_COHERENCY_TX_FSM6    15
#define V_COHERENCY_TX_FSM6(x) ((x) << S_COHERENCY_TX_FSM6)
#define F_COHERENCY_TX_FSM6    V_COHERENCY_TX_FSM6(1U)

#define S_COHERENCY_RX_FSM6    14
#define V_COHERENCY_RX_FSM6(x) ((x) << S_COHERENCY_RX_FSM6)
#define F_COHERENCY_RX_FSM6    V_COHERENCY_RX_FSM6(1U)

#define S_ARB_REQ_FSM6    13
#define V_ARB_REQ_FSM6(x) ((x) << S_ARB_REQ_FSM6)
#define F_ARB_REQ_FSM6    V_ARB_REQ_FSM6(1U)

#define S_CMD_SPLIT_FSM6    10
#define M_CMD_SPLIT_FSM6    0x7U
#define V_CMD_SPLIT_FSM6(x) ((x) << S_CMD_SPLIT_FSM6)
#define G_CMD_SPLIT_FSM6(x) (((x) >> S_CMD_SPLIT_FSM6) & M_CMD_SPLIT_FSM6)

#define A_MA_LE_CLIENT_INTERFACE_INTERNAL_REG1 0xe4e0

#define S_WR_DATA_EXT_FIFO_CNT7    30
#define M_WR_DATA_EXT_FIFO_CNT7    0x3U
#define V_WR_DATA_EXT_FIFO_CNT7(x) ((x) << S_WR_DATA_EXT_FIFO_CNT7)
#define G_WR_DATA_EXT_FIFO_CNT7(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT7) & M_WR_DATA_EXT_FIFO_CNT7)

#define S_WR_CMD_TAG_FIFO_CNT7    26
#define M_WR_CMD_TAG_FIFO_CNT7    0xfU
#define V_WR_CMD_TAG_FIFO_CNT7(x) ((x) << S_WR_CMD_TAG_FIFO_CNT7)
#define G_WR_CMD_TAG_FIFO_CNT7(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT7) & M_WR_CMD_TAG_FIFO_CNT7)

#define S_WR_DATA_512B_FIFO_CNT7    18
#define M_WR_DATA_512B_FIFO_CNT7    0xffU
#define V_WR_DATA_512B_FIFO_CNT7(x) ((x) << S_WR_DATA_512B_FIFO_CNT7)
#define G_WR_DATA_512B_FIFO_CNT7(x) (((x) >> S_WR_DATA_512B_FIFO_CNT7) & M_WR_DATA_512B_FIFO_CNT7)

#define S_RD_DATA_ALIGN_FSM7    17
#define V_RD_DATA_ALIGN_FSM7(x) ((x) << S_RD_DATA_ALIGN_FSM7)
#define F_RD_DATA_ALIGN_FSM7    V_RD_DATA_ALIGN_FSM7(1U)

#define S_RD_DATA_FETCH_FSM7    16
#define V_RD_DATA_FETCH_FSM7(x) ((x) << S_RD_DATA_FETCH_FSM7)
#define F_RD_DATA_FETCH_FSM7    V_RD_DATA_FETCH_FSM7(1U)

#define S_COHERENCY_TX_FSM7    15
#define V_COHERENCY_TX_FSM7(x) ((x) << S_COHERENCY_TX_FSM7)
#define F_COHERENCY_TX_FSM7    V_COHERENCY_TX_FSM7(1U)

#define S_COHERENCY_RX_FSM7    14
#define V_COHERENCY_RX_FSM7(x) ((x) << S_COHERENCY_RX_FSM7)
#define F_COHERENCY_RX_FSM7    V_COHERENCY_RX_FSM7(1U)

#define S_ARB_REQ_FSM7    13
#define V_ARB_REQ_FSM7(x) ((x) << S_ARB_REQ_FSM7)
#define F_ARB_REQ_FSM7    V_ARB_REQ_FSM7(1U)

#define S_CMD_SPLIT_FSM7    10
#define M_CMD_SPLIT_FSM7    0x7U
#define V_CMD_SPLIT_FSM7(x) ((x) << S_CMD_SPLIT_FSM7)
#define G_CMD_SPLIT_FSM7(x) (((x) >> S_CMD_SPLIT_FSM7) & M_CMD_SPLIT_FSM7)

#define A_MA_CIM_CLIENT_INTERFACE_INTERNAL_REG1 0xe500

#define S_WR_DATA_EXT_FIFO_CNT8    30
#define M_WR_DATA_EXT_FIFO_CNT8    0x3U
#define V_WR_DATA_EXT_FIFO_CNT8(x) ((x) << S_WR_DATA_EXT_FIFO_CNT8)
#define G_WR_DATA_EXT_FIFO_CNT8(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT8) & M_WR_DATA_EXT_FIFO_CNT8)

#define S_WR_CMD_TAG_FIFO_CNT8    26
#define M_WR_CMD_TAG_FIFO_CNT8    0xfU
#define V_WR_CMD_TAG_FIFO_CNT8(x) ((x) << S_WR_CMD_TAG_FIFO_CNT8)
#define G_WR_CMD_TAG_FIFO_CNT8(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT8) & M_WR_CMD_TAG_FIFO_CNT8)

#define S_WR_DATA_512B_FIFO_CNT8    18
#define M_WR_DATA_512B_FIFO_CNT8    0xffU
#define V_WR_DATA_512B_FIFO_CNT8(x) ((x) << S_WR_DATA_512B_FIFO_CNT8)
#define G_WR_DATA_512B_FIFO_CNT8(x) (((x) >> S_WR_DATA_512B_FIFO_CNT8) & M_WR_DATA_512B_FIFO_CNT8)

#define S_RD_DATA_ALIGN_FSM8    17
#define V_RD_DATA_ALIGN_FSM8(x) ((x) << S_RD_DATA_ALIGN_FSM8)
#define F_RD_DATA_ALIGN_FSM8    V_RD_DATA_ALIGN_FSM8(1U)

#define S_RD_DATA_FETCH_FSM8    16
#define V_RD_DATA_FETCH_FSM8(x) ((x) << S_RD_DATA_FETCH_FSM8)
#define F_RD_DATA_FETCH_FSM8    V_RD_DATA_FETCH_FSM8(1U)

#define S_COHERENCY_TX_FSM8    15
#define V_COHERENCY_TX_FSM8(x) ((x) << S_COHERENCY_TX_FSM8)
#define F_COHERENCY_TX_FSM8    V_COHERENCY_TX_FSM8(1U)

#define S_COHERENCY_RX_FSM8    14
#define V_COHERENCY_RX_FSM8(x) ((x) << S_COHERENCY_RX_FSM8)
#define F_COHERENCY_RX_FSM8    V_COHERENCY_RX_FSM8(1U)

#define S_ARB_REQ_FSM8    13
#define V_ARB_REQ_FSM8(x) ((x) << S_ARB_REQ_FSM8)
#define F_ARB_REQ_FSM8    V_ARB_REQ_FSM8(1U)

#define S_CMD_SPLIT_FSM8    10
#define M_CMD_SPLIT_FSM8    0x7U
#define V_CMD_SPLIT_FSM8(x) ((x) << S_CMD_SPLIT_FSM8)
#define G_CMD_SPLIT_FSM8(x) (((x) >> S_CMD_SPLIT_FSM8) & M_CMD_SPLIT_FSM8)

#define A_MA_PCIE_CLIENT_INTERFACE_INTERNAL_REG1 0xe520

#define S_WR_DATA_EXT_FIFO_CNT9    30
#define M_WR_DATA_EXT_FIFO_CNT9    0x3U
#define V_WR_DATA_EXT_FIFO_CNT9(x) ((x) << S_WR_DATA_EXT_FIFO_CNT9)
#define G_WR_DATA_EXT_FIFO_CNT9(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT9) & M_WR_DATA_EXT_FIFO_CNT9)

#define S_WR_CMD_TAG_FIFO_CNT9    26
#define M_WR_CMD_TAG_FIFO_CNT9    0xfU
#define V_WR_CMD_TAG_FIFO_CNT9(x) ((x) << S_WR_CMD_TAG_FIFO_CNT9)
#define G_WR_CMD_TAG_FIFO_CNT9(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT9) & M_WR_CMD_TAG_FIFO_CNT9)

#define S_WR_DATA_512B_FIFO_CNT9    18
#define M_WR_DATA_512B_FIFO_CNT9    0xffU
#define V_WR_DATA_512B_FIFO_CNT9(x) ((x) << S_WR_DATA_512B_FIFO_CNT9)
#define G_WR_DATA_512B_FIFO_CNT9(x) (((x) >> S_WR_DATA_512B_FIFO_CNT9) & M_WR_DATA_512B_FIFO_CNT9)

#define S_RD_DATA_ALIGN_FSM9    17
#define V_RD_DATA_ALIGN_FSM9(x) ((x) << S_RD_DATA_ALIGN_FSM9)
#define F_RD_DATA_ALIGN_FSM9    V_RD_DATA_ALIGN_FSM9(1U)

#define S_RD_DATA_FETCH_FSM9    16
#define V_RD_DATA_FETCH_FSM9(x) ((x) << S_RD_DATA_FETCH_FSM9)
#define F_RD_DATA_FETCH_FSM9    V_RD_DATA_FETCH_FSM9(1U)

#define S_COHERENCY_TX_FSM9    15
#define V_COHERENCY_TX_FSM9(x) ((x) << S_COHERENCY_TX_FSM9)
#define F_COHERENCY_TX_FSM9    V_COHERENCY_TX_FSM9(1U)

#define S_COHERENCY_RX_FSM9    14
#define V_COHERENCY_RX_FSM9(x) ((x) << S_COHERENCY_RX_FSM9)
#define F_COHERENCY_RX_FSM9    V_COHERENCY_RX_FSM9(1U)

#define S_ARB_REQ_FSM9    13
#define V_ARB_REQ_FSM9(x) ((x) << S_ARB_REQ_FSM9)
#define F_ARB_REQ_FSM9    V_ARB_REQ_FSM9(1U)

#define S_CMD_SPLIT_FSM9    10
#define M_CMD_SPLIT_FSM9    0x7U
#define V_CMD_SPLIT_FSM9(x) ((x) << S_CMD_SPLIT_FSM9)
#define G_CMD_SPLIT_FSM9(x) (((x) >> S_CMD_SPLIT_FSM9) & M_CMD_SPLIT_FSM9)

#define A_MA_PM_TX_CLIENT_INTERFACE_INTERNAL_REG1 0xe540

#define S_WR_DATA_EXT_FIFO_CNT10    30
#define M_WR_DATA_EXT_FIFO_CNT10    0x3U
#define V_WR_DATA_EXT_FIFO_CNT10(x) ((x) << S_WR_DATA_EXT_FIFO_CNT10)
#define G_WR_DATA_EXT_FIFO_CNT10(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT10) & M_WR_DATA_EXT_FIFO_CNT10)

#define S_WR_CMD_TAG_FIFO_CNT10    26
#define M_WR_CMD_TAG_FIFO_CNT10    0xfU
#define V_WR_CMD_TAG_FIFO_CNT10(x) ((x) << S_WR_CMD_TAG_FIFO_CNT10)
#define G_WR_CMD_TAG_FIFO_CNT10(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT10) & M_WR_CMD_TAG_FIFO_CNT10)

#define S_WR_DATA_512B_FIFO_CNT10    18
#define M_WR_DATA_512B_FIFO_CNT10    0xffU
#define V_WR_DATA_512B_FIFO_CNT10(x) ((x) << S_WR_DATA_512B_FIFO_CNT10)
#define G_WR_DATA_512B_FIFO_CNT10(x) (((x) >> S_WR_DATA_512B_FIFO_CNT10) & M_WR_DATA_512B_FIFO_CNT10)

#define S_RD_DATA_ALIGN_FSM10    17
#define V_RD_DATA_ALIGN_FSM10(x) ((x) << S_RD_DATA_ALIGN_FSM10)
#define F_RD_DATA_ALIGN_FSM10    V_RD_DATA_ALIGN_FSM10(1U)

#define S_RD_DATA_FETCH_FSM10    16
#define V_RD_DATA_FETCH_FSM10(x) ((x) << S_RD_DATA_FETCH_FSM10)
#define F_RD_DATA_FETCH_FSM10    V_RD_DATA_FETCH_FSM10(1U)

#define S_COHERENCY_TX_FSM10    15
#define V_COHERENCY_TX_FSM10(x) ((x) << S_COHERENCY_TX_FSM10)
#define F_COHERENCY_TX_FSM10    V_COHERENCY_TX_FSM10(1U)

#define S_COHERENCY_RX_FSM10    14
#define V_COHERENCY_RX_FSM10(x) ((x) << S_COHERENCY_RX_FSM10)
#define F_COHERENCY_RX_FSM10    V_COHERENCY_RX_FSM10(1U)

#define S_ARB_REQ_FSM10    13
#define V_ARB_REQ_FSM10(x) ((x) << S_ARB_REQ_FSM10)
#define F_ARB_REQ_FSM10    V_ARB_REQ_FSM10(1U)

#define S_CMD_SPLIT_FSM10    10
#define M_CMD_SPLIT_FSM10    0x7U
#define V_CMD_SPLIT_FSM10(x) ((x) << S_CMD_SPLIT_FSM10)
#define G_CMD_SPLIT_FSM10(x) (((x) >> S_CMD_SPLIT_FSM10) & M_CMD_SPLIT_FSM10)

#define A_MA_PM_RX_CLIENT_INTERFACE_INTERNAL_REG1 0xe560

#define S_WR_DATA_EXT_FIFO_CNT11    30
#define M_WR_DATA_EXT_FIFO_CNT11    0x3U
#define V_WR_DATA_EXT_FIFO_CNT11(x) ((x) << S_WR_DATA_EXT_FIFO_CNT11)
#define G_WR_DATA_EXT_FIFO_CNT11(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT11) & M_WR_DATA_EXT_FIFO_CNT11)

#define S_WR_CMD_TAG_FIFO_CNT11    26
#define M_WR_CMD_TAG_FIFO_CNT11    0xfU
#define V_WR_CMD_TAG_FIFO_CNT11(x) ((x) << S_WR_CMD_TAG_FIFO_CNT11)
#define G_WR_CMD_TAG_FIFO_CNT11(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT11) & M_WR_CMD_TAG_FIFO_CNT11)

#define S_WR_DATA_512B_FIFO_CNT11    18
#define M_WR_DATA_512B_FIFO_CNT11    0xffU
#define V_WR_DATA_512B_FIFO_CNT11(x) ((x) << S_WR_DATA_512B_FIFO_CNT11)
#define G_WR_DATA_512B_FIFO_CNT11(x) (((x) >> S_WR_DATA_512B_FIFO_CNT11) & M_WR_DATA_512B_FIFO_CNT11)

#define S_RD_DATA_ALIGN_FSM11    17
#define V_RD_DATA_ALIGN_FSM11(x) ((x) << S_RD_DATA_ALIGN_FSM11)
#define F_RD_DATA_ALIGN_FSM11    V_RD_DATA_ALIGN_FSM11(1U)

#define S_RD_DATA_FETCH_FSM11    16
#define V_RD_DATA_FETCH_FSM11(x) ((x) << S_RD_DATA_FETCH_FSM11)
#define F_RD_DATA_FETCH_FSM11    V_RD_DATA_FETCH_FSM11(1U)

#define S_COHERENCY_TX_FSM11    15
#define V_COHERENCY_TX_FSM11(x) ((x) << S_COHERENCY_TX_FSM11)
#define F_COHERENCY_TX_FSM11    V_COHERENCY_TX_FSM11(1U)

#define S_COHERENCY_RX_FSM11    14
#define V_COHERENCY_RX_FSM11(x) ((x) << S_COHERENCY_RX_FSM11)
#define F_COHERENCY_RX_FSM11    V_COHERENCY_RX_FSM11(1U)

#define S_ARB_REQ_FSM11    13
#define V_ARB_REQ_FSM11(x) ((x) << S_ARB_REQ_FSM11)
#define F_ARB_REQ_FSM11    V_ARB_REQ_FSM11(1U)

#define S_CMD_SPLIT_FSM11    10
#define M_CMD_SPLIT_FSM11    0x7U
#define V_CMD_SPLIT_FSM11(x) ((x) << S_CMD_SPLIT_FSM11)
#define G_CMD_SPLIT_FSM11(x) (((x) >> S_CMD_SPLIT_FSM11) & M_CMD_SPLIT_FSM11)

#define A_MA_HMA_CLIENT_INTERFACE_INTERNAL_REG1 0xe580

#define S_WR_DATA_EXT_FIFO_CNT12    30
#define M_WR_DATA_EXT_FIFO_CNT12    0x3U
#define V_WR_DATA_EXT_FIFO_CNT12(x) ((x) << S_WR_DATA_EXT_FIFO_CNT12)
#define G_WR_DATA_EXT_FIFO_CNT12(x) (((x) >> S_WR_DATA_EXT_FIFO_CNT12) & M_WR_DATA_EXT_FIFO_CNT12)

#define S_WR_CMD_TAG_FIFO_CNT12    26
#define M_WR_CMD_TAG_FIFO_CNT12    0xfU
#define V_WR_CMD_TAG_FIFO_CNT12(x) ((x) << S_WR_CMD_TAG_FIFO_CNT12)
#define G_WR_CMD_TAG_FIFO_CNT12(x) (((x) >> S_WR_CMD_TAG_FIFO_CNT12) & M_WR_CMD_TAG_FIFO_CNT12)

#define S_WR_DATA_512B_FIFO_CNT12    18
#define M_WR_DATA_512B_FIFO_CNT12    0xffU
#define V_WR_DATA_512B_FIFO_CNT12(x) ((x) << S_WR_DATA_512B_FIFO_CNT12)
#define G_WR_DATA_512B_FIFO_CNT12(x) (((x) >> S_WR_DATA_512B_FIFO_CNT12) & M_WR_DATA_512B_FIFO_CNT12)

#define S_RD_DATA_ALIGN_FSM12    17
#define V_RD_DATA_ALIGN_FSM12(x) ((x) << S_RD_DATA_ALIGN_FSM12)
#define F_RD_DATA_ALIGN_FSM12    V_RD_DATA_ALIGN_FSM12(1U)

#define S_RD_DATA_FETCH_FSM12    16
#define V_RD_DATA_FETCH_FSM12(x) ((x) << S_RD_DATA_FETCH_FSM12)
#define F_RD_DATA_FETCH_FSM12    V_RD_DATA_FETCH_FSM12(1U)

#define S_COHERENCY_TX_FSM12    15
#define V_COHERENCY_TX_FSM12(x) ((x) << S_COHERENCY_TX_FSM12)
#define F_COHERENCY_TX_FSM12    V_COHERENCY_TX_FSM12(1U)

#define S_COHERENCY_RX_FSM12    14
#define V_COHERENCY_RX_FSM12(x) ((x) << S_COHERENCY_RX_FSM12)
#define F_COHERENCY_RX_FSM12    V_COHERENCY_RX_FSM12(1U)

#define S_ARB_REQ_FSM12    13
#define V_ARB_REQ_FSM12(x) ((x) << S_ARB_REQ_FSM12)
#define F_ARB_REQ_FSM12    V_ARB_REQ_FSM12(1U)

#define S_CMD_SPLIT_FSM12    10
#define M_CMD_SPLIT_FSM12    0x7U
#define V_CMD_SPLIT_FSM12(x) ((x) << S_CMD_SPLIT_FSM12)
#define G_CMD_SPLIT_FSM12(x) (((x) >> S_CMD_SPLIT_FSM12) & M_CMD_SPLIT_FSM12)

#define A_MA_TARGET_0_ARBITER_INTERFACE_INTERNAL_REG1 0xe5a0

#define S_RD_CMD_TAG_FIFO_CNT0    8
#define M_RD_CMD_TAG_FIFO_CNT0    0xffU
#define V_RD_CMD_TAG_FIFO_CNT0(x) ((x) << S_RD_CMD_TAG_FIFO_CNT0)
#define G_RD_CMD_TAG_FIFO_CNT0(x) (((x) >> S_RD_CMD_TAG_FIFO_CNT0) & M_RD_CMD_TAG_FIFO_CNT0)

#define S_RD_DATA_FIFO_CNT0    0
#define M_RD_DATA_FIFO_CNT0    0xffU
#define V_RD_DATA_FIFO_CNT0(x) ((x) << S_RD_DATA_FIFO_CNT0)
#define G_RD_DATA_FIFO_CNT0(x) (((x) >> S_RD_DATA_FIFO_CNT0) & M_RD_DATA_FIFO_CNT0)

#define A_MA_TARGET_1_ARBITER_INTERFACE_INTERNAL_REG1 0xe5c0

#define S_RD_CMD_TAG_FIFO_CNT1    8
#define M_RD_CMD_TAG_FIFO_CNT1    0xffU
#define V_RD_CMD_TAG_FIFO_CNT1(x) ((x) << S_RD_CMD_TAG_FIFO_CNT1)
#define G_RD_CMD_TAG_FIFO_CNT1(x) (((x) >> S_RD_CMD_TAG_FIFO_CNT1) & M_RD_CMD_TAG_FIFO_CNT1)

#define S_RD_DATA_FIFO_CNT1    0
#define M_RD_DATA_FIFO_CNT1    0xffU
#define V_RD_DATA_FIFO_CNT1(x) ((x) << S_RD_DATA_FIFO_CNT1)
#define G_RD_DATA_FIFO_CNT1(x) (((x) >> S_RD_DATA_FIFO_CNT1) & M_RD_DATA_FIFO_CNT1)

#define A_MA_TARGET_2_ARBITER_INTERFACE_INTERNAL_REG1 0xe5e0

#define S_RD_CMD_TAG_FIFO_CNT2    8
#define M_RD_CMD_TAG_FIFO_CNT2    0xffU
#define V_RD_CMD_TAG_FIFO_CNT2(x) ((x) << S_RD_CMD_TAG_FIFO_CNT2)
#define G_RD_CMD_TAG_FIFO_CNT2(x) (((x) >> S_RD_CMD_TAG_FIFO_CNT2) & M_RD_CMD_TAG_FIFO_CNT2)

#define S_RD_DATA_FIFO_CNT2    0
#define M_RD_DATA_FIFO_CNT2    0xffU
#define V_RD_DATA_FIFO_CNT2(x) ((x) << S_RD_DATA_FIFO_CNT2)
#define G_RD_DATA_FIFO_CNT2(x) (((x) >> S_RD_DATA_FIFO_CNT2) & M_RD_DATA_FIFO_CNT2)

#define A_MA_TARGET_3_ARBITER_INTERFACE_INTERNAL_REG1 0xe600

#define S_RD_CMD_TAG_FIFO_CNT3    8
#define M_RD_CMD_TAG_FIFO_CNT3    0xffU
#define V_RD_CMD_TAG_FIFO_CNT3(x) ((x) << S_RD_CMD_TAG_FIFO_CNT3)
#define G_RD_CMD_TAG_FIFO_CNT3(x) (((x) >> S_RD_CMD_TAG_FIFO_CNT3) & M_RD_CMD_TAG_FIFO_CNT3)

#define S_RD_DATA_FIFO_CNT3    0
#define M_RD_DATA_FIFO_CNT3    0xffU
#define V_RD_DATA_FIFO_CNT3(x) ((x) << S_RD_DATA_FIFO_CNT3)
#define G_RD_DATA_FIFO_CNT3(x) (((x) >> S_RD_DATA_FIFO_CNT3) & M_RD_DATA_FIFO_CNT3)

#define A_MA_SGE_THREAD_0_CLNT_EXP_WR_CYC_CNT_LO 0xe640
#define A_MA_SGE_THREAD_1_CLNT_EXP_WR_CYC_CNT_LO 0xe660
#define A_MA_ULP_TX_CLNT_EXP_WR_CYC_CNT_LO 0xe680
#define A_MA_ULP_RX_CLNT_EXP_WR_CYC_CNT_LO 0xe6a0
#define A_MA_ULP_TX_RX_CLNT_EXP_WR_CYC_CNT_LO 0xe6c0
#define A_MA_TP_THREAD_0_CLNT_EXP_WR_CYC_CNT_LO 0xe6e0
#define A_MA_TP_THREAD_1_CLNT_EXP_WR_CYC_CNT_LO 0xe700
#define A_MA_LE_CLNT_EXP_WR_CYC_CNT_LO 0xe720
#define A_MA_CIM_CLNT_EXP_WR_CYC_CNT_LO 0xe740
#define A_MA_PCIE_CLNT_EXP_WR_CYC_CNT_LO 0xe760
#define A_MA_PM_TX_CLNT_EXP_WR_CYC_CNT_LO 0xe780
#define A_MA_PM_RX_CLNT_EXP_WR_CYC_CNT_LO 0xe7a0
#define A_MA_HMA_CLNT_EXP_WR_CYC_CNT_LO 0xe7c0
#define A_MA_EDRAM0_WR_REQ_CNT_HI 0xe800
#define A_MA_EDRAM0_WR_REQ_CNT_LO 0xe820
#define A_MA_EDRAM1_WR_REQ_CNT_HI 0xe840
#define A_MA_EDRAM1_WR_REQ_CNT_LO 0xe860
#define A_MA_EXT_MEMORY0_WR_REQ_CNT_HI 0xe880
#define A_MA_EXT_MEMORY0_WR_REQ_CNT_LO 0xe8a0
#define A_MA_EXT_MEMORY1_WR_REQ_CNT_HI 0xe8c0
#define A_MA_EXT_MEMORY1_WR_REQ_CNT_LO 0xe8e0
#define A_MA_EDRAM0_RD_REQ_CNT_HI 0xe900
#define A_MA_EDRAM0_RD_REQ_CNT_LO 0xe920
#define A_MA_EDRAM1_RD_REQ_CNT_HI 0xe940
#define A_MA_EDRAM1_RD_REQ_CNT_LO 0xe960
#define A_MA_EXT_MEMORY0_RD_REQ_CNT_HI 0xe980
#define A_MA_EXT_MEMORY0_RD_REQ_CNT_LO 0xe9a0
#define A_MA_EXT_MEMORY1_RD_REQ_CNT_HI 0xe9c0
#define A_MA_EXT_MEMORY1_RD_REQ_CNT_LO 0xe9e0
#define A_MA_SGE_THREAD_0_CLNT_ACT_RD_CYC_CNT_HI 0xec00
#define A_MA_SGE_THREAD_0_CLNT_ACT_RD_CYC_CNT_LO 0xec20
#define A_MA_SGE_THREAD_1_CLNT_ACT_RD_CYC_CNT_HI 0xec40
#define A_MA_SGE_THREAD_1_CLNT_ACT_RD_CYC_CNT_LO 0xec60
#define A_MA_ULP_TX_CLNT_ACT_RD_CYC_CNT_HI 0xec80
#define A_MA_ULP_TX_CLNT_ACT_RD_CYC_CNT_LO 0xeca0
#define A_MA_ULP_RX_CLNT_ACT_RD_CYC_CNT_HI 0xecc0
#define A_MA_ULP_RX_CLNT_ACT_RD_CYC_CNT_LO 0xece0
#define A_MA_ULP_TX_RX_CLNT_ACT_RD_CYC_CNT_HI 0xed00
#define A_MA_ULP_TX_RX_CLNT_ACT_RD_CYC_CNT_LO 0xed20
#define A_MA_TP_THREAD_0_CLNT_ACT_RD_CYC_CNT_HI 0xed40
#define A_MA_TP_THREAD_0_CLNT_ACT_RD_CYC_CNT_LO 0xed60
#define A_MA_TP_THREAD_1_CLNT_ACT_RD_CYC_CNT_HI 0xed80
#define A_MA_TP_THREAD_1_CLNT_ACT_RD_CYC_CNT_LO 0xeda0
#define A_MA_LE_CLNT_ACT_RD_CYC_CNT_HI 0xedc0
#define A_MA_LE_CLNT_ACT_RD_CYC_CNT_LO 0xede0
#define A_MA_CIM_CLNT_ACT_RD_CYC_CNT_HI 0xee00
#define A_MA_CIM_CLNT_ACT_RD_CYC_CNT_LO 0xee20
#define A_MA_PCIE_CLNT_ACT_RD_CYC_CNT_HI 0xee40
#define A_MA_PCIE_CLNT_ACT_RD_CYC_CNT_LO 0xee60
#define A_MA_PM_TX_CLNT_ACT_RD_CYC_CNT_HI 0xee80
#define A_MA_PM_TX_CLNT_ACT_RD_CYC_CNT_LO 0xeea0
#define A_MA_PM_RX_CLNT_ACT_RD_CYC_CNT_HI 0xeec0
#define A_MA_PM_RX_CLNT_ACT_RD_CYC_CNT_LO 0xeee0
#define A_MA_HMA_CLNT_ACT_RD_CYC_CNT_HI 0xef00
#define A_MA_HMA_CLNT_ACT_RD_CYC_CNT_LO 0xef20
#define A_MA_PM_TX_RD_THROTTLE_STATUS 0xf000

#define S_PTMAXTRANS    16
#define V_PTMAXTRANS(x) ((x) << S_PTMAXTRANS)
#define F_PTMAXTRANS    V_PTMAXTRANS(1U)

#define S_PTFLITCNT    0
#define M_PTFLITCNT    0xffU
#define V_PTFLITCNT(x) ((x) << S_PTFLITCNT)
#define G_PTFLITCNT(x) (((x) >> S_PTFLITCNT) & M_PTFLITCNT)

#define A_MA_PM_RX_RD_THROTTLE_STATUS 0xf020

#define S_PRMAXTRANS    16
#define V_PRMAXTRANS(x) ((x) << S_PRMAXTRANS)
#define F_PRMAXTRANS    V_PRMAXTRANS(1U)

#define S_PRFLITCNT    0
#define M_PRFLITCNT    0xffU
#define V_PRFLITCNT(x) ((x) << S_PRFLITCNT)
#define G_PRFLITCNT(x) (((x) >> S_PRFLITCNT) & M_PRFLITCNT)

/* registers for module EDC_0 */
#define EDC_0_BASE_ADDR 0x7900

#define A_EDC_REF 0x7900

#define S_EDC_INST_NUM    18
#define V_EDC_INST_NUM(x) ((x) << S_EDC_INST_NUM)
#define F_EDC_INST_NUM    V_EDC_INST_NUM(1U)

#define S_ENABLE_PERF    17
#define V_ENABLE_PERF(x) ((x) << S_ENABLE_PERF)
#define F_ENABLE_PERF    V_ENABLE_PERF(1U)

#define S_ECC_BYPASS    16
#define V_ECC_BYPASS(x) ((x) << S_ECC_BYPASS)
#define F_ECC_BYPASS    V_ECC_BYPASS(1U)

#define S_REFFREQ    0
#define M_REFFREQ    0xffffU
#define V_REFFREQ(x) ((x) << S_REFFREQ)
#define G_REFFREQ(x) (((x) >> S_REFFREQ) & M_REFFREQ)

#define A_EDC_BIST_CMD 0x7904
#define A_EDC_BIST_CMD_ADDR 0x7908
#define A_EDC_BIST_CMD_LEN 0x790c
#define A_EDC_BIST_DATA_PATTERN 0x7910
#define A_EDC_BIST_USER_WDATA0 0x7914
#define A_EDC_BIST_USER_WDATA1 0x7918
#define A_EDC_BIST_USER_WDATA2 0x791c
#define A_EDC_BIST_NUM_ERR 0x7920
#define A_EDC_BIST_ERR_FIRST_ADDR 0x7924
#define A_EDC_BIST_STATUS_RDATA 0x7928
#define A_EDC_PAR_ENABLE 0x7970

#define S_ECC_UE    2
#define V_ECC_UE(x) ((x) << S_ECC_UE)
#define F_ECC_UE    V_ECC_UE(1U)

#define S_ECC_CE    1
#define V_ECC_CE(x) ((x) << S_ECC_CE)
#define F_ECC_CE    V_ECC_CE(1U)

#define A_EDC_INT_ENABLE 0x7974
#define A_EDC_INT_CAUSE 0x7978

#define S_ECC_UE_PAR    5
#define V_ECC_UE_PAR(x) ((x) << S_ECC_UE_PAR)
#define F_ECC_UE_PAR    V_ECC_UE_PAR(1U)

#define S_ECC_CE_PAR    4
#define V_ECC_CE_PAR(x) ((x) << S_ECC_CE_PAR)
#define F_ECC_CE_PAR    V_ECC_CE_PAR(1U)

#define S_PERR_PAR_CAUSE    3
#define V_PERR_PAR_CAUSE(x) ((x) << S_PERR_PAR_CAUSE)
#define F_PERR_PAR_CAUSE    V_PERR_PAR_CAUSE(1U)

#define A_EDC_ECC_STATUS 0x797c

/* registers for module EDC_1 */
#define EDC_1_BASE_ADDR 0x7980

/* registers for module HMA */
#define HMA_BASE_ADDR 0x7a00

/* registers for module CIM */
#define CIM_BASE_ADDR 0x7b00

#define A_CIM_VF_EXT_MAILBOX_CTRL 0x0

#define S_VFMBGENERIC    4
#define M_VFMBGENERIC    0xfU
#define V_VFMBGENERIC(x) ((x) << S_VFMBGENERIC)
#define G_VFMBGENERIC(x) (((x) >> S_VFMBGENERIC) & M_VFMBGENERIC)

#define A_CIM_VF_EXT_MAILBOX_STATUS 0x4

#define S_MBVFREADY    0
#define V_MBVFREADY(x) ((x) << S_MBVFREADY)
#define F_MBVFREADY    V_MBVFREADY(1U)

#define A_CIM_PF_MAILBOX_DATA 0x240
#define A_CIM_PF_MAILBOX_CTRL 0x280

#define S_MBGENERIC    4
#define M_MBGENERIC    0xfffffffU
#define V_MBGENERIC(x) ((x) << S_MBGENERIC)
#define G_MBGENERIC(x) (((x) >> S_MBGENERIC) & M_MBGENERIC)

#define S_MBMSGVALID    3
#define V_MBMSGVALID(x) ((x) << S_MBMSGVALID)
#define F_MBMSGVALID    V_MBMSGVALID(1U)

#define S_MBINTREQ    2
#define V_MBINTREQ(x) ((x) << S_MBINTREQ)
#define F_MBINTREQ    V_MBINTREQ(1U)

#define S_MBOWNER    0
#define M_MBOWNER    0x3U
#define V_MBOWNER(x) ((x) << S_MBOWNER)
#define G_MBOWNER(x) (((x) >> S_MBOWNER) & M_MBOWNER)

#define A_CIM_PF_MAILBOX_ACC_STATUS 0x284

#define S_MBWRBUSY    31
#define V_MBWRBUSY(x) ((x) << S_MBWRBUSY)
#define F_MBWRBUSY    V_MBWRBUSY(1U)

#define A_CIM_PF_HOST_INT_ENABLE 0x288

#define S_MBMSGRDYINTEN    19
#define V_MBMSGRDYINTEN(x) ((x) << S_MBMSGRDYINTEN)
#define F_MBMSGRDYINTEN    V_MBMSGRDYINTEN(1U)

#define A_CIM_PF_HOST_INT_CAUSE 0x28c

#define S_MBMSGRDYINT    19
#define V_MBMSGRDYINT(x) ((x) << S_MBMSGRDYINT)
#define F_MBMSGRDYINT    V_MBMSGRDYINT(1U)

#define A_CIM_PF_MAILBOX_CTRL_SHADOW_COPY 0x290
#define A_CIM_BOOT_CFG 0x7b00

#define S_BOOTADDR    8
#define M_BOOTADDR    0xffffffU
#define V_BOOTADDR(x) ((x) << S_BOOTADDR)
#define G_BOOTADDR(x) (((x) >> S_BOOTADDR) & M_BOOTADDR)

#define S_UPGEN    2
#define M_UPGEN    0x3fU
#define V_UPGEN(x) ((x) << S_UPGEN)
#define G_UPGEN(x) (((x) >> S_UPGEN) & M_UPGEN)

#define S_BOOTSDRAM    1
#define V_BOOTSDRAM(x) ((x) << S_BOOTSDRAM)
#define F_BOOTSDRAM    V_BOOTSDRAM(1U)

#define S_UPCRST    0
#define V_UPCRST(x) ((x) << S_UPCRST)
#define F_UPCRST    V_UPCRST(1U)

#define A_CIM_FLASH_BASE_ADDR 0x7b04

#define S_FLASHBASEADDR    6
#define M_FLASHBASEADDR    0x3ffffU
#define V_FLASHBASEADDR(x) ((x) << S_FLASHBASEADDR)
#define G_FLASHBASEADDR(x) (((x) >> S_FLASHBASEADDR) & M_FLASHBASEADDR)

#define A_CIM_FLASH_ADDR_SIZE 0x7b08

#define S_FLASHADDRSIZE    4
#define M_FLASHADDRSIZE    0xfffffU
#define V_FLASHADDRSIZE(x) ((x) << S_FLASHADDRSIZE)
#define G_FLASHADDRSIZE(x) (((x) >> S_FLASHADDRSIZE) & M_FLASHADDRSIZE)

#define A_T7_CIM_PERR_ENABLE 0x7b08

#define S_T7_MA_CIM_INTFPERR    31
#define V_T7_MA_CIM_INTFPERR(x) ((x) << S_T7_MA_CIM_INTFPERR)
#define F_T7_MA_CIM_INTFPERR    V_T7_MA_CIM_INTFPERR(1U)

#define S_T7_MBHOSTPARERR    30
#define V_T7_MBHOSTPARERR(x) ((x) << S_T7_MBHOSTPARERR)
#define F_T7_MBHOSTPARERR    V_T7_MBHOSTPARERR(1U)

#define S_MAARBINVRSPTAG    29
#define V_MAARBINVRSPTAG(x) ((x) << S_MAARBINVRSPTAG)
#define F_MAARBINVRSPTAG    V_MAARBINVRSPTAG(1U)

#define S_MAARBFIFOPARERR    28
#define V_MAARBFIFOPARERR(x) ((x) << S_MAARBFIFOPARERR)
#define F_MAARBFIFOPARERR    V_MAARBFIFOPARERR(1U)

#define S_SEMSRAMPARERR    27
#define V_SEMSRAMPARERR(x) ((x) << S_SEMSRAMPARERR)
#define F_SEMSRAMPARERR    V_SEMSRAMPARERR(1U)

#define S_RSACPARERR    26
#define V_RSACPARERR(x) ((x) << S_RSACPARERR)
#define F_RSACPARERR    V_RSACPARERR(1U)

#define S_RSADPARERR    25
#define V_RSADPARERR(x) ((x) << S_RSADPARERR)
#define F_RSADPARERR    V_RSADPARERR(1U)

#define S_T7_PLCIM_MSTRSPDATAPARERR    24
#define V_T7_PLCIM_MSTRSPDATAPARERR(x) ((x) << S_T7_PLCIM_MSTRSPDATAPARERR)
#define F_T7_PLCIM_MSTRSPDATAPARERR    V_T7_PLCIM_MSTRSPDATAPARERR(1U)

#define S_T7_PCIE2CIMINTFPARERR    23
#define V_T7_PCIE2CIMINTFPARERR(x) ((x) << S_T7_PCIE2CIMINTFPARERR)
#define F_T7_PCIE2CIMINTFPARERR    V_T7_PCIE2CIMINTFPARERR(1U)

#define S_T7_NCSI2CIMINTFPARERR    22
#define V_T7_NCSI2CIMINTFPARERR(x) ((x) << S_T7_NCSI2CIMINTFPARERR)
#define F_T7_NCSI2CIMINTFPARERR    V_T7_NCSI2CIMINTFPARERR(1U)

#define S_T7_SGE2CIMINTFPARERR    21
#define V_T7_SGE2CIMINTFPARERR(x) ((x) << S_T7_SGE2CIMINTFPARERR)
#define F_T7_SGE2CIMINTFPARERR    V_T7_SGE2CIMINTFPARERR(1U)

#define S_T7_ULP2CIMINTFPARERR    20
#define V_T7_ULP2CIMINTFPARERR(x) ((x) << S_T7_ULP2CIMINTFPARERR)
#define F_T7_ULP2CIMINTFPARERR    V_T7_ULP2CIMINTFPARERR(1U)

#define S_T7_TP2CIMINTFPARERR    19
#define V_T7_TP2CIMINTFPARERR(x) ((x) << S_T7_TP2CIMINTFPARERR)
#define F_T7_TP2CIMINTFPARERR    V_T7_TP2CIMINTFPARERR(1U)

#define S_CORE7PARERR    18
#define V_CORE7PARERR(x) ((x) << S_CORE7PARERR)
#define F_CORE7PARERR    V_CORE7PARERR(1U)

#define S_CORE6PARERR    17
#define V_CORE6PARERR(x) ((x) << S_CORE6PARERR)
#define F_CORE6PARERR    V_CORE6PARERR(1U)

#define S_CORE5PARERR    16
#define V_CORE5PARERR(x) ((x) << S_CORE5PARERR)
#define F_CORE5PARERR    V_CORE5PARERR(1U)

#define S_CORE4PARERR    15
#define V_CORE4PARERR(x) ((x) << S_CORE4PARERR)
#define F_CORE4PARERR    V_CORE4PARERR(1U)

#define S_CORE3PARERR    14
#define V_CORE3PARERR(x) ((x) << S_CORE3PARERR)
#define F_CORE3PARERR    V_CORE3PARERR(1U)

#define S_CORE2PARERR    13
#define V_CORE2PARERR(x) ((x) << S_CORE2PARERR)
#define F_CORE2PARERR    V_CORE2PARERR(1U)

#define S_CORE1PARERR    12
#define V_CORE1PARERR(x) ((x) << S_CORE1PARERR)
#define F_CORE1PARERR    V_CORE1PARERR(1U)

#define S_GFTPARERR    10
#define V_GFTPARERR(x) ((x) << S_GFTPARERR)
#define F_GFTPARERR    V_GFTPARERR(1U)

#define S_MPSRSPDATAPARERR    9
#define V_MPSRSPDATAPARERR(x) ((x) << S_MPSRSPDATAPARERR)
#define F_MPSRSPDATAPARERR    V_MPSRSPDATAPARERR(1U)

#define S_ER_RSPDATAPARERR    8
#define V_ER_RSPDATAPARERR(x) ((x) << S_ER_RSPDATAPARERR)
#define F_ER_RSPDATAPARERR    V_ER_RSPDATAPARERR(1U)

#define S_FLOWFIFOPARERR    7
#define V_FLOWFIFOPARERR(x) ((x) << S_FLOWFIFOPARERR)
#define F_FLOWFIFOPARERR    V_FLOWFIFOPARERR(1U)

#define S_OBQSRAMPARERR    6
#define V_OBQSRAMPARERR(x) ((x) << S_OBQSRAMPARERR)
#define F_OBQSRAMPARERR    V_OBQSRAMPARERR(1U)

#define S_TIEQOUTPARERR    3
#define V_TIEQOUTPARERR(x) ((x) << S_TIEQOUTPARERR)
#define F_TIEQOUTPARERR    V_TIEQOUTPARERR(1U)

#define S_TIEQINPARERR    2
#define V_TIEQINPARERR(x) ((x) << S_TIEQINPARERR)
#define F_TIEQINPARERR    V_TIEQINPARERR(1U)

#define S_PIFRSPPARERR    1
#define V_PIFRSPPARERR(x) ((x) << S_PIFRSPPARERR)
#define F_PIFRSPPARERR    V_PIFRSPPARERR(1U)

#define S_PIFREQPARERR    0
#define V_PIFREQPARERR(x) ((x) << S_PIFREQPARERR)
#define F_PIFREQPARERR    V_PIFREQPARERR(1U)

#define A_CIM_EEPROM_BASE_ADDR 0x7b0c

#define S_EEPROMBASEADDR    6
#define M_EEPROMBASEADDR    0x3ffffU
#define V_EEPROMBASEADDR(x) ((x) << S_EEPROMBASEADDR)
#define G_EEPROMBASEADDR(x) (((x) >> S_EEPROMBASEADDR) & M_EEPROMBASEADDR)

#define A_CIM_PERR_CAUSE 0x7b0c
#define A_CIM_EEPROM_ADDR_SIZE 0x7b10

#define S_EEPROMADDRSIZE    4
#define M_EEPROMADDRSIZE    0xfffffU
#define V_EEPROMADDRSIZE(x) ((x) << S_EEPROMADDRSIZE)
#define G_EEPROMADDRSIZE(x) (((x) >> S_EEPROMADDRSIZE) & M_EEPROMADDRSIZE)

#define A_CIM_SDRAM_BASE_ADDR 0x7b14

#define S_SDRAMBASEADDR    6
#define M_SDRAMBASEADDR    0x3ffffffU
#define V_SDRAMBASEADDR(x) ((x) << S_SDRAMBASEADDR)
#define G_SDRAMBASEADDR(x) (((x) >> S_SDRAMBASEADDR) & M_SDRAMBASEADDR)

#define A_CIM_SDRAM_ADDR_SIZE 0x7b18

#define S_SDRAMADDRSIZE    4
#define M_SDRAMADDRSIZE    0xfffffffU
#define V_SDRAMADDRSIZE(x) ((x) << S_SDRAMADDRSIZE)
#define G_SDRAMADDRSIZE(x) (((x) >> S_SDRAMADDRSIZE) & M_SDRAMADDRSIZE)

#define A_CIM_EXTMEM2_BASE_ADDR 0x7b1c

#define S_EXTMEM2BASEADDR    6
#define M_EXTMEM2BASEADDR    0x3ffffffU
#define V_EXTMEM2BASEADDR(x) ((x) << S_EXTMEM2BASEADDR)
#define G_EXTMEM2BASEADDR(x) (((x) >> S_EXTMEM2BASEADDR) & M_EXTMEM2BASEADDR)

#define A_CIM_EXTMEM2_ADDR_SIZE 0x7b20

#define S_EXTMEM2ADDRSIZE    4
#define M_EXTMEM2ADDRSIZE    0xfffffffU
#define V_EXTMEM2ADDRSIZE(x) ((x) << S_EXTMEM2ADDRSIZE)
#define G_EXTMEM2ADDRSIZE(x) (((x) >> S_EXTMEM2ADDRSIZE) & M_EXTMEM2ADDRSIZE)

#define A_CIM_UP_SPARE_INT 0x7b24

#define S_TDEBUGINT    4
#define V_TDEBUGINT(x) ((x) << S_TDEBUGINT)
#define F_TDEBUGINT    V_TDEBUGINT(1U)

#define S_BOOTVECSEL    3
#define V_BOOTVECSEL(x) ((x) << S_BOOTVECSEL)
#define F_BOOTVECSEL    V_BOOTVECSEL(1U)

#define S_UPSPAREINT    0
#define M_UPSPAREINT    0x7U
#define V_UPSPAREINT(x) ((x) << S_UPSPAREINT)
#define G_UPSPAREINT(x) (((x) >> S_UPSPAREINT) & M_UPSPAREINT)

#define A_CIM_HOST_INT_ENABLE 0x7b28

#define S_TIEQOUTPARERRINTEN    20
#define V_TIEQOUTPARERRINTEN(x) ((x) << S_TIEQOUTPARERRINTEN)
#define F_TIEQOUTPARERRINTEN    V_TIEQOUTPARERRINTEN(1U)

#define S_TIEQINPARERRINTEN    19
#define V_TIEQINPARERRINTEN(x) ((x) << S_TIEQINPARERRINTEN)
#define F_TIEQINPARERRINTEN    V_TIEQINPARERRINTEN(1U)

#define S_MBHOSTPARERR    18
#define V_MBHOSTPARERR(x) ((x) << S_MBHOSTPARERR)
#define F_MBHOSTPARERR    V_MBHOSTPARERR(1U)

#define S_MBUPPARERR    17
#define V_MBUPPARERR(x) ((x) << S_MBUPPARERR)
#define F_MBUPPARERR    V_MBUPPARERR(1U)

#define S_IBQTP0PARERR    16
#define V_IBQTP0PARERR(x) ((x) << S_IBQTP0PARERR)
#define F_IBQTP0PARERR    V_IBQTP0PARERR(1U)

#define S_IBQTP1PARERR    15
#define V_IBQTP1PARERR(x) ((x) << S_IBQTP1PARERR)
#define F_IBQTP1PARERR    V_IBQTP1PARERR(1U)

#define S_IBQULPPARERR    14
#define V_IBQULPPARERR(x) ((x) << S_IBQULPPARERR)
#define F_IBQULPPARERR    V_IBQULPPARERR(1U)

#define S_IBQSGELOPARERR    13
#define V_IBQSGELOPARERR(x) ((x) << S_IBQSGELOPARERR)
#define F_IBQSGELOPARERR    V_IBQSGELOPARERR(1U)

#define S_IBQSGEHIPARERR    12
#define V_IBQSGEHIPARERR(x) ((x) << S_IBQSGEHIPARERR)
#define F_IBQSGEHIPARERR    V_IBQSGEHIPARERR(1U)

#define S_IBQNCSIPARERR    11
#define V_IBQNCSIPARERR(x) ((x) << S_IBQNCSIPARERR)
#define F_IBQNCSIPARERR    V_IBQNCSIPARERR(1U)

#define S_OBQULP0PARERR    10
#define V_OBQULP0PARERR(x) ((x) << S_OBQULP0PARERR)
#define F_OBQULP0PARERR    V_OBQULP0PARERR(1U)

#define S_OBQULP1PARERR    9
#define V_OBQULP1PARERR(x) ((x) << S_OBQULP1PARERR)
#define F_OBQULP1PARERR    V_OBQULP1PARERR(1U)

#define S_OBQULP2PARERR    8
#define V_OBQULP2PARERR(x) ((x) << S_OBQULP2PARERR)
#define F_OBQULP2PARERR    V_OBQULP2PARERR(1U)

#define S_OBQULP3PARERR    7
#define V_OBQULP3PARERR(x) ((x) << S_OBQULP3PARERR)
#define F_OBQULP3PARERR    V_OBQULP3PARERR(1U)

#define S_OBQSGEPARERR    6
#define V_OBQSGEPARERR(x) ((x) << S_OBQSGEPARERR)
#define F_OBQSGEPARERR    V_OBQSGEPARERR(1U)

#define S_OBQNCSIPARERR    5
#define V_OBQNCSIPARERR(x) ((x) << S_OBQNCSIPARERR)
#define F_OBQNCSIPARERR    V_OBQNCSIPARERR(1U)

#define S_TIMER1INTEN    3
#define V_TIMER1INTEN(x) ((x) << S_TIMER1INTEN)
#define F_TIMER1INTEN    V_TIMER1INTEN(1U)

#define S_TIMER0INTEN    2
#define V_TIMER0INTEN(x) ((x) << S_TIMER0INTEN)
#define F_TIMER0INTEN    V_TIMER0INTEN(1U)

#define S_PREFDROPINTEN    1
#define V_PREFDROPINTEN(x) ((x) << S_PREFDROPINTEN)
#define F_PREFDROPINTEN    V_PREFDROPINTEN(1U)

#define S_MA_CIM_INTFPERR    28
#define V_MA_CIM_INTFPERR(x) ((x) << S_MA_CIM_INTFPERR)
#define F_MA_CIM_INTFPERR    V_MA_CIM_INTFPERR(1U)

#define S_PLCIM_MSTRSPDATAPARERR    27
#define V_PLCIM_MSTRSPDATAPARERR(x) ((x) << S_PLCIM_MSTRSPDATAPARERR)
#define F_PLCIM_MSTRSPDATAPARERR    V_PLCIM_MSTRSPDATAPARERR(1U)

#define S_NCSI2CIMINTFPARERR    26
#define V_NCSI2CIMINTFPARERR(x) ((x) << S_NCSI2CIMINTFPARERR)
#define F_NCSI2CIMINTFPARERR    V_NCSI2CIMINTFPARERR(1U)

#define S_SGE2CIMINTFPARERR    25
#define V_SGE2CIMINTFPARERR(x) ((x) << S_SGE2CIMINTFPARERR)
#define F_SGE2CIMINTFPARERR    V_SGE2CIMINTFPARERR(1U)

#define S_ULP2CIMINTFPARERR    24
#define V_ULP2CIMINTFPARERR(x) ((x) << S_ULP2CIMINTFPARERR)
#define F_ULP2CIMINTFPARERR    V_ULP2CIMINTFPARERR(1U)

#define S_TP2CIMINTFPARERR    23
#define V_TP2CIMINTFPARERR(x) ((x) << S_TP2CIMINTFPARERR)
#define F_TP2CIMINTFPARERR    V_TP2CIMINTFPARERR(1U)

#define S_OBQSGERX1PARERR    22
#define V_OBQSGERX1PARERR(x) ((x) << S_OBQSGERX1PARERR)
#define F_OBQSGERX1PARERR    V_OBQSGERX1PARERR(1U)

#define S_OBQSGERX0PARERR    21
#define V_OBQSGERX0PARERR(x) ((x) << S_OBQSGERX0PARERR)
#define F_OBQSGERX0PARERR    V_OBQSGERX0PARERR(1U)

#define S_PCIE2CIMINTFPARERR    29
#define V_PCIE2CIMINTFPARERR(x) ((x) << S_PCIE2CIMINTFPARERR)
#define F_PCIE2CIMINTFPARERR    V_PCIE2CIMINTFPARERR(1U)

#define S_IBQPCIEPARERR    12
#define V_IBQPCIEPARERR(x) ((x) << S_IBQPCIEPARERR)
#define F_IBQPCIEPARERR    V_IBQPCIEPARERR(1U)

#define S_CORE7ACCINT    22
#define V_CORE7ACCINT(x) ((x) << S_CORE7ACCINT)
#define F_CORE7ACCINT    V_CORE7ACCINT(1U)

#define S_CORE6ACCINT    21
#define V_CORE6ACCINT(x) ((x) << S_CORE6ACCINT)
#define F_CORE6ACCINT    V_CORE6ACCINT(1U)

#define S_CORE5ACCINT    20
#define V_CORE5ACCINT(x) ((x) << S_CORE5ACCINT)
#define F_CORE5ACCINT    V_CORE5ACCINT(1U)

#define S_CORE4ACCINT    19
#define V_CORE4ACCINT(x) ((x) << S_CORE4ACCINT)
#define F_CORE4ACCINT    V_CORE4ACCINT(1U)

#define S_CORE3ACCINT    18
#define V_CORE3ACCINT(x) ((x) << S_CORE3ACCINT)
#define F_CORE3ACCINT    V_CORE3ACCINT(1U)

#define S_CORE2ACCINT    17
#define V_CORE2ACCINT(x) ((x) << S_CORE2ACCINT)
#define F_CORE2ACCINT    V_CORE2ACCINT(1U)

#define S_CORE1ACCINT    16
#define V_CORE1ACCINT(x) ((x) << S_CORE1ACCINT)
#define F_CORE1ACCINT    V_CORE1ACCINT(1U)

#define S_PERRNONZERO    1
#define V_PERRNONZERO(x) ((x) << S_PERRNONZERO)
#define F_PERRNONZERO    V_PERRNONZERO(1U)

#define A_CIM_HOST_INT_CAUSE 0x7b2c

#define S_TIEQOUTPARERRINT    20
#define V_TIEQOUTPARERRINT(x) ((x) << S_TIEQOUTPARERRINT)
#define F_TIEQOUTPARERRINT    V_TIEQOUTPARERRINT(1U)

#define S_TIEQINPARERRINT    19
#define V_TIEQINPARERRINT(x) ((x) << S_TIEQINPARERRINT)
#define F_TIEQINPARERRINT    V_TIEQINPARERRINT(1U)

#define S_TIMER1INT    3
#define V_TIMER1INT(x) ((x) << S_TIMER1INT)
#define F_TIMER1INT    V_TIMER1INT(1U)

#define S_TIMER0INT    2
#define V_TIMER0INT(x) ((x) << S_TIMER0INT)
#define F_TIMER0INT    V_TIMER0INT(1U)

#define S_PREFDROPINT    1
#define V_PREFDROPINT(x) ((x) << S_PREFDROPINT)
#define F_PREFDROPINT    V_PREFDROPINT(1U)

#define S_UPACCNONZERO    0
#define V_UPACCNONZERO(x) ((x) << S_UPACCNONZERO)
#define F_UPACCNONZERO    V_UPACCNONZERO(1U)

#define A_CIM_HOST_UPACC_INT_ENABLE 0x7b30

#define S_EEPROMWRINTEN    30
#define V_EEPROMWRINTEN(x) ((x) << S_EEPROMWRINTEN)
#define F_EEPROMWRINTEN    V_EEPROMWRINTEN(1U)

#define S_TIMEOUTMAINTEN    29
#define V_TIMEOUTMAINTEN(x) ((x) << S_TIMEOUTMAINTEN)
#define F_TIMEOUTMAINTEN    V_TIMEOUTMAINTEN(1U)

#define S_TIMEOUTINTEN    28
#define V_TIMEOUTINTEN(x) ((x) << S_TIMEOUTINTEN)
#define F_TIMEOUTINTEN    V_TIMEOUTINTEN(1U)

#define S_RSPOVRLOOKUPINTEN    27
#define V_RSPOVRLOOKUPINTEN(x) ((x) << S_RSPOVRLOOKUPINTEN)
#define F_RSPOVRLOOKUPINTEN    V_RSPOVRLOOKUPINTEN(1U)

#define S_REQOVRLOOKUPINTEN    26
#define V_REQOVRLOOKUPINTEN(x) ((x) << S_REQOVRLOOKUPINTEN)
#define F_REQOVRLOOKUPINTEN    V_REQOVRLOOKUPINTEN(1U)

#define S_BLKWRPLINTEN    25
#define V_BLKWRPLINTEN(x) ((x) << S_BLKWRPLINTEN)
#define F_BLKWRPLINTEN    V_BLKWRPLINTEN(1U)

#define S_BLKRDPLINTEN    24
#define V_BLKRDPLINTEN(x) ((x) << S_BLKRDPLINTEN)
#define F_BLKRDPLINTEN    V_BLKRDPLINTEN(1U)

#define S_SGLWRPLINTEN    23
#define V_SGLWRPLINTEN(x) ((x) << S_SGLWRPLINTEN)
#define F_SGLWRPLINTEN    V_SGLWRPLINTEN(1U)

#define S_SGLRDPLINTEN    22
#define V_SGLRDPLINTEN(x) ((x) << S_SGLRDPLINTEN)
#define F_SGLRDPLINTEN    V_SGLRDPLINTEN(1U)

#define S_BLKWRCTLINTEN    21
#define V_BLKWRCTLINTEN(x) ((x) << S_BLKWRCTLINTEN)
#define F_BLKWRCTLINTEN    V_BLKWRCTLINTEN(1U)

#define S_BLKRDCTLINTEN    20
#define V_BLKRDCTLINTEN(x) ((x) << S_BLKRDCTLINTEN)
#define F_BLKRDCTLINTEN    V_BLKRDCTLINTEN(1U)

#define S_SGLWRCTLINTEN    19
#define V_SGLWRCTLINTEN(x) ((x) << S_SGLWRCTLINTEN)
#define F_SGLWRCTLINTEN    V_SGLWRCTLINTEN(1U)

#define S_SGLRDCTLINTEN    18
#define V_SGLRDCTLINTEN(x) ((x) << S_SGLRDCTLINTEN)
#define F_SGLRDCTLINTEN    V_SGLRDCTLINTEN(1U)

#define S_BLKWREEPROMINTEN    17
#define V_BLKWREEPROMINTEN(x) ((x) << S_BLKWREEPROMINTEN)
#define F_BLKWREEPROMINTEN    V_BLKWREEPROMINTEN(1U)

#define S_BLKRDEEPROMINTEN    16
#define V_BLKRDEEPROMINTEN(x) ((x) << S_BLKRDEEPROMINTEN)
#define F_BLKRDEEPROMINTEN    V_BLKRDEEPROMINTEN(1U)

#define S_SGLWREEPROMINTEN    15
#define V_SGLWREEPROMINTEN(x) ((x) << S_SGLWREEPROMINTEN)
#define F_SGLWREEPROMINTEN    V_SGLWREEPROMINTEN(1U)

#define S_SGLRDEEPROMINTEN    14
#define V_SGLRDEEPROMINTEN(x) ((x) << S_SGLRDEEPROMINTEN)
#define F_SGLRDEEPROMINTEN    V_SGLRDEEPROMINTEN(1U)

#define S_BLKWRFLASHINTEN    13
#define V_BLKWRFLASHINTEN(x) ((x) << S_BLKWRFLASHINTEN)
#define F_BLKWRFLASHINTEN    V_BLKWRFLASHINTEN(1U)

#define S_BLKRDFLASHINTEN    12
#define V_BLKRDFLASHINTEN(x) ((x) << S_BLKRDFLASHINTEN)
#define F_BLKRDFLASHINTEN    V_BLKRDFLASHINTEN(1U)

#define S_SGLWRFLASHINTEN    11
#define V_SGLWRFLASHINTEN(x) ((x) << S_SGLWRFLASHINTEN)
#define F_SGLWRFLASHINTEN    V_SGLWRFLASHINTEN(1U)

#define S_SGLRDFLASHINTEN    10
#define V_SGLRDFLASHINTEN(x) ((x) << S_SGLRDFLASHINTEN)
#define F_SGLRDFLASHINTEN    V_SGLRDFLASHINTEN(1U)

#define S_BLKWRBOOTINTEN    9
#define V_BLKWRBOOTINTEN(x) ((x) << S_BLKWRBOOTINTEN)
#define F_BLKWRBOOTINTEN    V_BLKWRBOOTINTEN(1U)

#define S_BLKRDBOOTINTEN    8
#define V_BLKRDBOOTINTEN(x) ((x) << S_BLKRDBOOTINTEN)
#define F_BLKRDBOOTINTEN    V_BLKRDBOOTINTEN(1U)

#define S_SGLWRBOOTINTEN    7
#define V_SGLWRBOOTINTEN(x) ((x) << S_SGLWRBOOTINTEN)
#define F_SGLWRBOOTINTEN    V_SGLWRBOOTINTEN(1U)

#define S_SGLRDBOOTINTEN    6
#define V_SGLRDBOOTINTEN(x) ((x) << S_SGLRDBOOTINTEN)
#define F_SGLRDBOOTINTEN    V_SGLRDBOOTINTEN(1U)

#define S_ILLWRBEINTEN    5
#define V_ILLWRBEINTEN(x) ((x) << S_ILLWRBEINTEN)
#define F_ILLWRBEINTEN    V_ILLWRBEINTEN(1U)

#define S_ILLRDBEINTEN    4
#define V_ILLRDBEINTEN(x) ((x) << S_ILLRDBEINTEN)
#define F_ILLRDBEINTEN    V_ILLRDBEINTEN(1U)

#define S_ILLRDINTEN    3
#define V_ILLRDINTEN(x) ((x) << S_ILLRDINTEN)
#define F_ILLRDINTEN    V_ILLRDINTEN(1U)

#define S_ILLWRINTEN    2
#define V_ILLWRINTEN(x) ((x) << S_ILLWRINTEN)
#define F_ILLWRINTEN    V_ILLWRINTEN(1U)

#define S_ILLTRANSINTEN    1
#define V_ILLTRANSINTEN(x) ((x) << S_ILLTRANSINTEN)
#define F_ILLTRANSINTEN    V_ILLTRANSINTEN(1U)

#define S_RSVDSPACEINTEN    0
#define V_RSVDSPACEINTEN(x) ((x) << S_RSVDSPACEINTEN)
#define F_RSVDSPACEINTEN    V_RSVDSPACEINTEN(1U)

#define S_CONWRERRINTEN    31
#define V_CONWRERRINTEN(x) ((x) << S_CONWRERRINTEN)
#define F_CONWRERRINTEN    V_CONWRERRINTEN(1U)

#define A_CIM_HOST_UPACC_INT_CAUSE 0x7b34

#define S_EEPROMWRINT    30
#define V_EEPROMWRINT(x) ((x) << S_EEPROMWRINT)
#define F_EEPROMWRINT    V_EEPROMWRINT(1U)

#define S_TIMEOUTMAINT    29
#define V_TIMEOUTMAINT(x) ((x) << S_TIMEOUTMAINT)
#define F_TIMEOUTMAINT    V_TIMEOUTMAINT(1U)

#define S_TIMEOUTINT    28
#define V_TIMEOUTINT(x) ((x) << S_TIMEOUTINT)
#define F_TIMEOUTINT    V_TIMEOUTINT(1U)

#define S_RSPOVRLOOKUPINT    27
#define V_RSPOVRLOOKUPINT(x) ((x) << S_RSPOVRLOOKUPINT)
#define F_RSPOVRLOOKUPINT    V_RSPOVRLOOKUPINT(1U)

#define S_REQOVRLOOKUPINT    26
#define V_REQOVRLOOKUPINT(x) ((x) << S_REQOVRLOOKUPINT)
#define F_REQOVRLOOKUPINT    V_REQOVRLOOKUPINT(1U)

#define S_BLKWRPLINT    25
#define V_BLKWRPLINT(x) ((x) << S_BLKWRPLINT)
#define F_BLKWRPLINT    V_BLKWRPLINT(1U)

#define S_BLKRDPLINT    24
#define V_BLKRDPLINT(x) ((x) << S_BLKRDPLINT)
#define F_BLKRDPLINT    V_BLKRDPLINT(1U)

#define S_SGLWRPLINT    23
#define V_SGLWRPLINT(x) ((x) << S_SGLWRPLINT)
#define F_SGLWRPLINT    V_SGLWRPLINT(1U)

#define S_SGLRDPLINT    22
#define V_SGLRDPLINT(x) ((x) << S_SGLRDPLINT)
#define F_SGLRDPLINT    V_SGLRDPLINT(1U)

#define S_BLKWRCTLINT    21
#define V_BLKWRCTLINT(x) ((x) << S_BLKWRCTLINT)
#define F_BLKWRCTLINT    V_BLKWRCTLINT(1U)

#define S_BLKRDCTLINT    20
#define V_BLKRDCTLINT(x) ((x) << S_BLKRDCTLINT)
#define F_BLKRDCTLINT    V_BLKRDCTLINT(1U)

#define S_SGLWRCTLINT    19
#define V_SGLWRCTLINT(x) ((x) << S_SGLWRCTLINT)
#define F_SGLWRCTLINT    V_SGLWRCTLINT(1U)

#define S_SGLRDCTLINT    18
#define V_SGLRDCTLINT(x) ((x) << S_SGLRDCTLINT)
#define F_SGLRDCTLINT    V_SGLRDCTLINT(1U)

#define S_BLKWREEPROMINT    17
#define V_BLKWREEPROMINT(x) ((x) << S_BLKWREEPROMINT)
#define F_BLKWREEPROMINT    V_BLKWREEPROMINT(1U)

#define S_BLKRDEEPROMINT    16
#define V_BLKRDEEPROMINT(x) ((x) << S_BLKRDEEPROMINT)
#define F_BLKRDEEPROMINT    V_BLKRDEEPROMINT(1U)

#define S_SGLWREEPROMINT    15
#define V_SGLWREEPROMINT(x) ((x) << S_SGLWREEPROMINT)
#define F_SGLWREEPROMINT    V_SGLWREEPROMINT(1U)

#define S_SGLRDEEPROMINT    14
#define V_SGLRDEEPROMINT(x) ((x) << S_SGLRDEEPROMINT)
#define F_SGLRDEEPROMINT    V_SGLRDEEPROMINT(1U)

#define S_BLKWRFLASHINT    13
#define V_BLKWRFLASHINT(x) ((x) << S_BLKWRFLASHINT)
#define F_BLKWRFLASHINT    V_BLKWRFLASHINT(1U)

#define S_BLKRDFLASHINT    12
#define V_BLKRDFLASHINT(x) ((x) << S_BLKRDFLASHINT)
#define F_BLKRDFLASHINT    V_BLKRDFLASHINT(1U)

#define S_SGLWRFLASHINT    11
#define V_SGLWRFLASHINT(x) ((x) << S_SGLWRFLASHINT)
#define F_SGLWRFLASHINT    V_SGLWRFLASHINT(1U)

#define S_SGLRDFLASHINT    10
#define V_SGLRDFLASHINT(x) ((x) << S_SGLRDFLASHINT)
#define F_SGLRDFLASHINT    V_SGLRDFLASHINT(1U)

#define S_BLKWRBOOTINT    9
#define V_BLKWRBOOTINT(x) ((x) << S_BLKWRBOOTINT)
#define F_BLKWRBOOTINT    V_BLKWRBOOTINT(1U)

#define S_BLKRDBOOTINT    8
#define V_BLKRDBOOTINT(x) ((x) << S_BLKRDBOOTINT)
#define F_BLKRDBOOTINT    V_BLKRDBOOTINT(1U)

#define S_SGLWRBOOTINT    7
#define V_SGLWRBOOTINT(x) ((x) << S_SGLWRBOOTINT)
#define F_SGLWRBOOTINT    V_SGLWRBOOTINT(1U)

#define S_SGLRDBOOTINT    6
#define V_SGLRDBOOTINT(x) ((x) << S_SGLRDBOOTINT)
#define F_SGLRDBOOTINT    V_SGLRDBOOTINT(1U)

#define S_ILLWRBEINT    5
#define V_ILLWRBEINT(x) ((x) << S_ILLWRBEINT)
#define F_ILLWRBEINT    V_ILLWRBEINT(1U)

#define S_ILLRDBEINT    4
#define V_ILLRDBEINT(x) ((x) << S_ILLRDBEINT)
#define F_ILLRDBEINT    V_ILLRDBEINT(1U)

#define S_ILLRDINT    3
#define V_ILLRDINT(x) ((x) << S_ILLRDINT)
#define F_ILLRDINT    V_ILLRDINT(1U)

#define S_ILLWRINT    2
#define V_ILLWRINT(x) ((x) << S_ILLWRINT)
#define F_ILLWRINT    V_ILLWRINT(1U)

#define S_ILLTRANSINT    1
#define V_ILLTRANSINT(x) ((x) << S_ILLTRANSINT)
#define F_ILLTRANSINT    V_ILLTRANSINT(1U)

#define S_RSVDSPACEINT    0
#define V_RSVDSPACEINT(x) ((x) << S_RSVDSPACEINT)
#define F_RSVDSPACEINT    V_RSVDSPACEINT(1U)

#define S_CONWRERRINT    31
#define V_CONWRERRINT(x) ((x) << S_CONWRERRINT)
#define F_CONWRERRINT    V_CONWRERRINT(1U)

#define A_CIM_UP_INT_ENABLE 0x7b38

#define S_MSTPLINTEN    4
#define V_MSTPLINTEN(x) ((x) << S_MSTPLINTEN)
#define F_MSTPLINTEN    V_MSTPLINTEN(1U)

#define S_SEMINT    8
#define V_SEMINT(x) ((x) << S_SEMINT)
#define F_SEMINT    V_SEMINT(1U)

#define S_RSAINT    7
#define V_RSAINT(x) ((x) << S_RSAINT)
#define F_RSAINT    V_RSAINT(1U)

#define S_TRNGINT    6
#define V_TRNGINT(x) ((x) << S_TRNGINT)
#define F_TRNGINT    V_TRNGINT(1U)

#define S_PEERHALTINT    5
#define V_PEERHALTINT(x) ((x) << S_PEERHALTINT)
#define F_PEERHALTINT    V_PEERHALTINT(1U)

#define A_CIM_UP_INT_CAUSE 0x7b3c

#define S_MSTPLINT    4
#define V_MSTPLINT(x) ((x) << S_MSTPLINT)
#define F_MSTPLINT    V_MSTPLINT(1U)

#define A_CIM_UP_ACC_INT_ENABLE 0x7b40
#define A_CIM_UP_ACC_INT_CAUSE 0x7b44
#define A_CIM_QUEUE_CONFIG_REF 0x7b48

#define S_OBQSELECT    4
#define V_OBQSELECT(x) ((x) << S_OBQSELECT)
#define F_OBQSELECT    V_OBQSELECT(1U)

#define S_IBQSELECT    3
#define V_IBQSELECT(x) ((x) << S_IBQSELECT)
#define F_IBQSELECT    V_IBQSELECT(1U)

#define S_QUENUMSELECT    0
#define M_QUENUMSELECT    0x7U
#define V_QUENUMSELECT(x) ((x) << S_QUENUMSELECT)
#define G_QUENUMSELECT(x) (((x) >> S_QUENUMSELECT) & M_QUENUMSELECT)

#define S_MAPOFFSET    11
#define M_MAPOFFSET    0x1fU
#define V_MAPOFFSET(x) ((x) << S_MAPOFFSET)
#define G_MAPOFFSET(x) (((x) >> S_MAPOFFSET) & M_MAPOFFSET)

#define S_MAPSELECT    10
#define V_MAPSELECT(x) ((x) << S_MAPSELECT)
#define F_MAPSELECT    V_MAPSELECT(1U)

#define S_CORESELECT    6
#define M_CORESELECT    0xfU
#define V_CORESELECT(x) ((x) << S_CORESELECT)
#define G_CORESELECT(x) (((x) >> S_CORESELECT) & M_CORESELECT)

#define S_T7_OBQSELECT    5
#define V_T7_OBQSELECT(x) ((x) << S_T7_OBQSELECT)
#define F_T7_OBQSELECT    V_T7_OBQSELECT(1U)

#define S_T7_IBQSELECT    4
#define V_T7_IBQSELECT(x) ((x) << S_T7_IBQSELECT)
#define F_T7_IBQSELECT    V_T7_IBQSELECT(1U)

#define S_T7_QUENUMSELECT    0
#define M_T7_QUENUMSELECT    0xfU
#define V_T7_QUENUMSELECT(x) ((x) << S_T7_QUENUMSELECT)
#define G_T7_QUENUMSELECT(x) (((x) >> S_T7_QUENUMSELECT) & M_T7_QUENUMSELECT)

#define A_CIM_QUEUE_CONFIG_CTRL 0x7b4c

#define S_CIMQSIZE    24
#define M_CIMQSIZE    0x3fU
#define V_CIMQSIZE(x) ((x) << S_CIMQSIZE)
#define G_CIMQSIZE(x) (((x) >> S_CIMQSIZE) & M_CIMQSIZE)

#define S_CIMQBASE    16
#define M_CIMQBASE    0x3fU
#define V_CIMQBASE(x) ((x) << S_CIMQBASE)
#define G_CIMQBASE(x) (((x) >> S_CIMQBASE) & M_CIMQBASE)

#define S_CIMQDBG8BEN    9
#define V_CIMQDBG8BEN(x) ((x) << S_CIMQDBG8BEN)
#define F_CIMQDBG8BEN    V_CIMQDBG8BEN(1U)

#define S_QUEFULLTHRSH    0
#define M_QUEFULLTHRSH    0x1ffU
#define V_QUEFULLTHRSH(x) ((x) << S_QUEFULLTHRSH)
#define G_QUEFULLTHRSH(x) (((x) >> S_QUEFULLTHRSH) & M_QUEFULLTHRSH)

#define S_CIMQ1KEN    30
#define V_CIMQ1KEN(x) ((x) << S_CIMQ1KEN)
#define F_CIMQ1KEN    V_CIMQ1KEN(1U)

#define A_CIM_HOST_ACC_CTRL 0x7b50

#define S_HOSTBUSY    17
#define V_HOSTBUSY(x) ((x) << S_HOSTBUSY)
#define F_HOSTBUSY    V_HOSTBUSY(1U)

#define S_HOSTWRITE    16
#define V_HOSTWRITE(x) ((x) << S_HOSTWRITE)
#define F_HOSTWRITE    V_HOSTWRITE(1U)

#define S_HOSTADDR    0
#define M_HOSTADDR    0xffffU
#define V_HOSTADDR(x) ((x) << S_HOSTADDR)
#define G_HOSTADDR(x) (((x) >> S_HOSTADDR) & M_HOSTADDR)

#define S_T7_HOSTBUSY    31
#define V_T7_HOSTBUSY(x) ((x) << S_T7_HOSTBUSY)
#define F_T7_HOSTBUSY    V_T7_HOSTBUSY(1U)

#define S_T7_HOSTWRITE    30
#define V_T7_HOSTWRITE(x) ((x) << S_T7_HOSTWRITE)
#define F_T7_HOSTWRITE    V_T7_HOSTWRITE(1U)

#define S_HOSTGRPSEL    28
#define M_HOSTGRPSEL    0x3U
#define V_HOSTGRPSEL(x) ((x) << S_HOSTGRPSEL)
#define G_HOSTGRPSEL(x) (((x) >> S_HOSTGRPSEL) & M_HOSTGRPSEL)

#define S_HOSTCORESEL    24
#define M_HOSTCORESEL    0xfU
#define V_HOSTCORESEL(x) ((x) << S_HOSTCORESEL)
#define G_HOSTCORESEL(x) (((x) >> S_HOSTCORESEL) & M_HOSTCORESEL)

#define S_T7_HOSTADDR    0
#define M_T7_HOSTADDR    0xffffffU
#define V_T7_HOSTADDR(x) ((x) << S_T7_HOSTADDR)
#define G_T7_HOSTADDR(x) (((x) >> S_T7_HOSTADDR) & M_T7_HOSTADDR)

#define A_CIM_HOST_ACC_DATA 0x7b54
#define A_CIM_CDEBUGDATA 0x7b58

#define S_CDEBUGDATAH    16
#define M_CDEBUGDATAH    0xffffU
#define V_CDEBUGDATAH(x) ((x) << S_CDEBUGDATAH)
#define G_CDEBUGDATAH(x) (((x) >> S_CDEBUGDATAH) & M_CDEBUGDATAH)

#define S_CDEBUGDATAL    0
#define M_CDEBUGDATAL    0xffffU
#define V_CDEBUGDATAL(x) ((x) << S_CDEBUGDATAL)
#define G_CDEBUGDATAL(x) (((x) >> S_CDEBUGDATAL) & M_CDEBUGDATAL)

#define A_CIM_DEBUG_CFG 0x7b58

#define S_OR_EN    20
#define V_OR_EN(x) ((x) << S_OR_EN)
#define F_OR_EN    V_OR_EN(1U)

#define S_USEL    19
#define V_USEL(x) ((x) << S_USEL)
#define F_USEL    V_USEL(1U)

#define S_HI    18
#define V_HI(x) ((x) << S_HI)
#define F_HI    V_HI(1U)

#define S_SELH    9
#define M_SELH    0x1ffU
#define V_SELH(x) ((x) << S_SELH)
#define G_SELH(x) (((x) >> S_SELH) & M_SELH)

#define S_SELL    0
#define M_SELL    0x1ffU
#define V_SELL(x) ((x) << S_SELL)
#define G_SELL(x) (((x) >> S_SELL) & M_SELL)

#define A_CIM_DEBUG_DATA 0x7b5c
#define A_CIM_IBQ_DBG_CFG 0x7b60

#define S_IBQDBGADDR    16
#define M_IBQDBGADDR    0xfffU
#define V_IBQDBGADDR(x) ((x) << S_IBQDBGADDR)
#define G_IBQDBGADDR(x) (((x) >> S_IBQDBGADDR) & M_IBQDBGADDR)

#define S_IBQDBGWR    2
#define V_IBQDBGWR(x) ((x) << S_IBQDBGWR)
#define F_IBQDBGWR    V_IBQDBGWR(1U)

#define S_IBQDBGBUSY    1
#define V_IBQDBGBUSY(x) ((x) << S_IBQDBGBUSY)
#define F_IBQDBGBUSY    V_IBQDBGBUSY(1U)

#define S_IBQDBGEN    0
#define V_IBQDBGEN(x) ((x) << S_IBQDBGEN)
#define F_IBQDBGEN    V_IBQDBGEN(1U)

#define S_IBQDBGCORE    28
#define M_IBQDBGCORE    0xfU
#define V_IBQDBGCORE(x) ((x) << S_IBQDBGCORE)
#define G_IBQDBGCORE(x) (((x) >> S_IBQDBGCORE) & M_IBQDBGCORE)

#define S_T7_IBQDBGADDR    12
#define M_T7_IBQDBGADDR    0x1fffU
#define V_T7_IBQDBGADDR(x) ((x) << S_T7_IBQDBGADDR)
#define G_T7_IBQDBGADDR(x) (((x) >> S_T7_IBQDBGADDR) & M_T7_IBQDBGADDR)

#define S_IBQDBGSTATE    4
#define M_IBQDBGSTATE    0x3U
#define V_IBQDBGSTATE(x) ((x) << S_IBQDBGSTATE)
#define G_IBQDBGSTATE(x) (((x) >> S_IBQDBGSTATE) & M_IBQDBGSTATE)

#define S_PERRADDRCLR    3
#define V_PERRADDRCLR(x) ((x) << S_PERRADDRCLR)
#define F_PERRADDRCLR    V_PERRADDRCLR(1U)

#define A_CIM_OBQ_DBG_CFG 0x7b64

#define S_OBQDBGADDR    16
#define M_OBQDBGADDR    0xfffU
#define V_OBQDBGADDR(x) ((x) << S_OBQDBGADDR)
#define G_OBQDBGADDR(x) (((x) >> S_OBQDBGADDR) & M_OBQDBGADDR)

#define S_OBQDBGWR    2
#define V_OBQDBGWR(x) ((x) << S_OBQDBGWR)
#define F_OBQDBGWR    V_OBQDBGWR(1U)

#define S_OBQDBGBUSY    1
#define V_OBQDBGBUSY(x) ((x) << S_OBQDBGBUSY)
#define F_OBQDBGBUSY    V_OBQDBGBUSY(1U)

#define S_OBQDBGEN    0
#define V_OBQDBGEN(x) ((x) << S_OBQDBGEN)
#define F_OBQDBGEN    V_OBQDBGEN(1U)

#define S_OBQDBGCORE    28
#define M_OBQDBGCORE    0xfU
#define V_OBQDBGCORE(x) ((x) << S_OBQDBGCORE)
#define G_OBQDBGCORE(x) (((x) >> S_OBQDBGCORE) & M_OBQDBGCORE)

#define S_T7_OBQDBGADDR    12
#define M_T7_OBQDBGADDR    0x1fffU
#define V_T7_OBQDBGADDR(x) ((x) << S_T7_OBQDBGADDR)
#define G_T7_OBQDBGADDR(x) (((x) >> S_T7_OBQDBGADDR) & M_T7_OBQDBGADDR)

#define S_OBQDBGSTATE    4
#define M_OBQDBGSTATE    0x3U
#define V_OBQDBGSTATE(x) ((x) << S_OBQDBGSTATE)
#define G_OBQDBGSTATE(x) (((x) >> S_OBQDBGSTATE) & M_OBQDBGSTATE)

#define A_CIM_IBQ_DBG_DATA 0x7b68
#define A_CIM_OBQ_DBG_DATA 0x7b6c
#define A_CIM_DEBUGCFG 0x7b70

#define S_POLADBGRDPTR    23
#define M_POLADBGRDPTR    0x1ffU
#define V_POLADBGRDPTR(x) ((x) << S_POLADBGRDPTR)
#define G_POLADBGRDPTR(x) (((x) >> S_POLADBGRDPTR) & M_POLADBGRDPTR)

#define S_PILADBGRDPTR    14
#define M_PILADBGRDPTR    0x1ffU
#define V_PILADBGRDPTR(x) ((x) << S_PILADBGRDPTR)
#define G_PILADBGRDPTR(x) (((x) >> S_PILADBGRDPTR) & M_PILADBGRDPTR)

#define S_LAMASKTRIG    13
#define V_LAMASKTRIG(x) ((x) << S_LAMASKTRIG)
#define F_LAMASKTRIG    V_LAMASKTRIG(1U)

#define S_LADBGEN    12
#define V_LADBGEN(x) ((x) << S_LADBGEN)
#define F_LADBGEN    V_LADBGEN(1U)

#define S_LAFILLONCE    11
#define V_LAFILLONCE(x) ((x) << S_LAFILLONCE)
#define F_LAFILLONCE    V_LAFILLONCE(1U)

#define S_LAMASKSTOP    10
#define V_LAMASKSTOP(x) ((x) << S_LAMASKSTOP)
#define F_LAMASKSTOP    V_LAMASKSTOP(1U)

#define S_DEBUGSELH    5
#define M_DEBUGSELH    0x1fU
#define V_DEBUGSELH(x) ((x) << S_DEBUGSELH)
#define G_DEBUGSELH(x) (((x) >> S_DEBUGSELH) & M_DEBUGSELH)

#define S_DEBUGSELL    0
#define M_DEBUGSELL    0x1fU
#define V_DEBUGSELL(x) ((x) << S_DEBUGSELL)
#define G_DEBUGSELL(x) (((x) >> S_DEBUGSELL) & M_DEBUGSELL)

#define A_CIM_DEBUGSTS 0x7b74

#define S_LARESET    31
#define V_LARESET(x) ((x) << S_LARESET)
#define F_LARESET    V_LARESET(1U)

#define S_POLADBGWRPTR    16
#define M_POLADBGWRPTR    0x1ffU
#define V_POLADBGWRPTR(x) ((x) << S_POLADBGWRPTR)
#define G_POLADBGWRPTR(x) (((x) >> S_POLADBGWRPTR) & M_POLADBGWRPTR)

#define S_PILADBGWRPTR    0
#define M_PILADBGWRPTR    0x1ffU
#define V_PILADBGWRPTR(x) ((x) << S_PILADBGWRPTR)
#define G_PILADBGWRPTR(x) (((x) >> S_PILADBGWRPTR) & M_PILADBGWRPTR)

#define A_CIM_PO_LA_DEBUGDATA 0x7b78
#define A_CIM_PI_LA_DEBUGDATA 0x7b7c
#define A_CIM_PO_LA_MADEBUGDATA 0x7b80
#define A_CIM_PI_LA_MADEBUGDATA 0x7b84
#define A_CIM_PO_LA_PIFSMDEBUGDATA 0x7b8c
#define A_CIM_MEM_ZONE0_VA 0x7b90

#define S_MEM_ZONE_VA    4
#define M_MEM_ZONE_VA    0xfffffffU
#define V_MEM_ZONE_VA(x) ((x) << S_MEM_ZONE_VA)
#define G_MEM_ZONE_VA(x) (((x) >> S_MEM_ZONE_VA) & M_MEM_ZONE_VA)

#define A_CIM_MEM_ZONE0_BA 0x7b94

#define S_MEM_ZONE_BA    6
#define M_MEM_ZONE_BA    0x3ffffffU
#define V_MEM_ZONE_BA(x) ((x) << S_MEM_ZONE_BA)
#define G_MEM_ZONE_BA(x) (((x) >> S_MEM_ZONE_BA) & M_MEM_ZONE_BA)

#define S_PBT_ENABLE    5
#define V_PBT_ENABLE(x) ((x) << S_PBT_ENABLE)
#define F_PBT_ENABLE    V_PBT_ENABLE(1U)

#define S_ZONE_DST    0
#define M_ZONE_DST    0x3U
#define V_ZONE_DST(x) ((x) << S_ZONE_DST)
#define G_ZONE_DST(x) (((x) >> S_ZONE_DST) & M_ZONE_DST)

#define S_THREAD_ID    2
#define M_THREAD_ID    0x7U
#define V_THREAD_ID(x) ((x) << S_THREAD_ID)
#define G_THREAD_ID(x) (((x) >> S_THREAD_ID) & M_THREAD_ID)

#define A_CIM_MEM_ZONE0_LEN 0x7b98

#define S_MEM_ZONE_LEN    4
#define M_MEM_ZONE_LEN    0xfffffffU
#define V_MEM_ZONE_LEN(x) ((x) << S_MEM_ZONE_LEN)
#define G_MEM_ZONE_LEN(x) (((x) >> S_MEM_ZONE_LEN) & M_MEM_ZONE_LEN)

#define A_CIM_MEM_ZONE1_VA 0x7b9c
#define A_CIM_MEM_ZONE1_BA 0x7ba0
#define A_CIM_MEM_ZONE1_LEN 0x7ba4
#define A_CIM_MEM_ZONE2_VA 0x7ba8
#define A_CIM_MEM_ZONE2_BA 0x7bac
#define A_CIM_MEM_ZONE2_LEN 0x7bb0
#define A_CIM_MEM_ZONE3_VA 0x7bb4
#define A_CIM_MEM_ZONE3_BA 0x7bb8
#define A_CIM_MEM_ZONE3_LEN 0x7bbc
#define A_CIM_MEM_ZONE4_VA 0x7bc0
#define A_CIM_MEM_ZONE4_BA 0x7bc4
#define A_CIM_MEM_ZONE4_LEN 0x7bc8
#define A_CIM_MEM_ZONE5_VA 0x7bcc
#define A_CIM_MEM_ZONE5_BA 0x7bd0
#define A_CIM_MEM_ZONE5_LEN 0x7bd4
#define A_CIM_MEM_ZONE6_VA 0x7bd8
#define A_CIM_MEM_ZONE6_BA 0x7bdc
#define A_CIM_MEM_ZONE6_LEN 0x7be0
#define A_CIM_MEM_ZONE7_VA 0x7be4
#define A_CIM_MEM_ZONE7_BA 0x7be8
#define A_CIM_MEM_ZONE7_LEN 0x7bec
#define A_CIM_BOOT_LEN 0x7bf0

#define S_BOOTLEN    4
#define M_BOOTLEN    0xfffffffU
#define V_BOOTLEN(x) ((x) << S_BOOTLEN)
#define G_BOOTLEN(x) (((x) >> S_BOOTLEN) & M_BOOTLEN)

#define A_CIM_GLB_TIMER_CTL 0x7bf4

#define S_TIMER1EN    4
#define V_TIMER1EN(x) ((x) << S_TIMER1EN)
#define F_TIMER1EN    V_TIMER1EN(1U)

#define S_TIMER0EN    3
#define V_TIMER0EN(x) ((x) << S_TIMER0EN)
#define F_TIMER0EN    V_TIMER0EN(1U)

#define S_TIMEREN    1
#define V_TIMEREN(x) ((x) << S_TIMEREN)
#define F_TIMEREN    V_TIMEREN(1U)

#define A_CIM_GLB_TIMER 0x7bf8
#define A_CIM_GLB_TIMER_TICK 0x7bfc

#define S_GLBLTTICK    0
#define M_GLBLTTICK    0xffffU
#define V_GLBLTTICK(x) ((x) << S_GLBLTTICK)
#define G_GLBLTTICK(x) (((x) >> S_GLBLTTICK) & M_GLBLTTICK)

#define A_CIM_TIMER0 0x7c00
#define A_CIM_TIMER1 0x7c04
#define A_CIM_DEBUG_ADDR_TIMEOUT 0x7c08

#define S_DADDRTIMEOUT    2
#define M_DADDRTIMEOUT    0x3fffffffU
#define V_DADDRTIMEOUT(x) ((x) << S_DADDRTIMEOUT)
#define G_DADDRTIMEOUT(x) (((x) >> S_DADDRTIMEOUT) & M_DADDRTIMEOUT)

#define S_DADDRTIMEOUTTYPE    0
#define M_DADDRTIMEOUTTYPE    0x3U
#define V_DADDRTIMEOUTTYPE(x) ((x) << S_DADDRTIMEOUTTYPE)
#define G_DADDRTIMEOUTTYPE(x) (((x) >> S_DADDRTIMEOUTTYPE) & M_DADDRTIMEOUTTYPE)

#define A_CIM_DEBUG_ADDR_ILLEGAL 0x7c0c

#define S_DADDRILLEGAL    2
#define M_DADDRILLEGAL    0x3fffffffU
#define V_DADDRILLEGAL(x) ((x) << S_DADDRILLEGAL)
#define G_DADDRILLEGAL(x) (((x) >> S_DADDRILLEGAL) & M_DADDRILLEGAL)

#define S_DADDRILLEGALTYPE    0
#define M_DADDRILLEGALTYPE    0x3U
#define V_DADDRILLEGALTYPE(x) ((x) << S_DADDRILLEGALTYPE)
#define G_DADDRILLEGALTYPE(x) (((x) >> S_DADDRILLEGALTYPE) & M_DADDRILLEGALTYPE)

#define A_CIM_DEBUG_PIF_CAUSE_MASK 0x7c10

#define S_DPIFHOSTMASK    0
#define M_DPIFHOSTMASK    0x1fffffU
#define V_DPIFHOSTMASK(x) ((x) << S_DPIFHOSTMASK)
#define G_DPIFHOSTMASK(x) (((x) >> S_DPIFHOSTMASK) & M_DPIFHOSTMASK)

#define S_T5_DPIFHOSTMASK    0
#define M_T5_DPIFHOSTMASK    0x1fffffffU
#define V_T5_DPIFHOSTMASK(x) ((x) << S_T5_DPIFHOSTMASK)
#define G_T5_DPIFHOSTMASK(x) (((x) >> S_T5_DPIFHOSTMASK) & M_T5_DPIFHOSTMASK)

#define S_T6_T5_DPIFHOSTMASK    0
#define M_T6_T5_DPIFHOSTMASK    0x3fffffffU
#define V_T6_T5_DPIFHOSTMASK(x) ((x) << S_T6_T5_DPIFHOSTMASK)
#define G_T6_T5_DPIFHOSTMASK(x) (((x) >> S_T6_T5_DPIFHOSTMASK) & M_T6_T5_DPIFHOSTMASK)

#define A_CIM_DEBUG_PIF_UPACC_CAUSE_MASK 0x7c14

#define S_DPIFHUPAMASK    0
#define M_DPIFHUPAMASK    0x7fffffffU
#define V_DPIFHUPAMASK(x) ((x) << S_DPIFHUPAMASK)
#define G_DPIFHUPAMASK(x) (((x) >> S_DPIFHUPAMASK) & M_DPIFHUPAMASK)

#define A_CIM_DEBUG_UP_CAUSE_MASK 0x7c18

#define S_DUPMASK    0
#define M_DUPMASK    0x1fffffU
#define V_DUPMASK(x) ((x) << S_DUPMASK)
#define G_DUPMASK(x) (((x) >> S_DUPMASK) & M_DUPMASK)

#define S_T5_DUPMASK    0
#define M_T5_DUPMASK    0x1fffffffU
#define V_T5_DUPMASK(x) ((x) << S_T5_DUPMASK)
#define G_T5_DUPMASK(x) (((x) >> S_T5_DUPMASK) & M_T5_DUPMASK)

#define S_T6_T5_DUPMASK    0
#define M_T6_T5_DUPMASK    0x3fffffffU
#define V_T6_T5_DUPMASK(x) ((x) << S_T6_T5_DUPMASK)
#define G_T6_T5_DUPMASK(x) (((x) >> S_T6_T5_DUPMASK) & M_T6_T5_DUPMASK)

#define A_CIM_DEBUG_UP_UPACC_CAUSE_MASK 0x7c1c

#define S_DUPUACCMASK    0
#define M_DUPUACCMASK    0x7fffffffU
#define V_DUPUACCMASK(x) ((x) << S_DUPUACCMASK)
#define G_DUPUACCMASK(x) (((x) >> S_DUPUACCMASK) & M_DUPUACCMASK)

#define A_CIM_PERR_INJECT 0x7c20
#define A_CIM_FPGA_ROM_EFUSE_CMD 0x7c20
#define A_CIM_PERR_ENABLE 0x7c24

#define S_PERREN    0
#define M_PERREN    0x1fffffU
#define V_PERREN(x) ((x) << S_PERREN)
#define G_PERREN(x) (((x) >> S_PERREN) & M_PERREN)

#define S_T5_PERREN    0
#define M_T5_PERREN    0x1fffffffU
#define V_T5_PERREN(x) ((x) << S_T5_PERREN)
#define G_T5_PERREN(x) (((x) >> S_T5_PERREN) & M_T5_PERREN)

#define S_T6_T5_PERREN    0
#define M_T6_T5_PERREN    0x3fffffffU
#define V_T6_T5_PERREN(x) ((x) << S_T6_T5_PERREN)
#define G_T6_T5_PERREN(x) (((x) >> S_T6_T5_PERREN) & M_T6_T5_PERREN)

#define A_CIM_FPGA_ROM_EFUSE_DATA 0x7c24
#define A_CIM_EEPROM_BUSY_BIT 0x7c28

#define S_EEPROMBUSY    0
#define V_EEPROMBUSY(x) ((x) << S_EEPROMBUSY)
#define F_EEPROMBUSY    V_EEPROMBUSY(1U)

#define A_CIM_MA_TIMER_EN 0x7c2c

#define S_MA_TIMER_ENABLE    0
#define V_MA_TIMER_ENABLE(x) ((x) << S_MA_TIMER_ENABLE)
#define F_MA_TIMER_ENABLE    V_MA_TIMER_ENABLE(1U)

#define S_SLOW_TIMER_ENABLE    1
#define V_SLOW_TIMER_ENABLE(x) ((x) << S_SLOW_TIMER_ENABLE)
#define F_SLOW_TIMER_ENABLE    V_SLOW_TIMER_ENABLE(1U)

#define S_FLASHWRPAGEMORE    5
#define V_FLASHWRPAGEMORE(x) ((x) << S_FLASHWRPAGEMORE)
#define F_FLASHWRPAGEMORE    V_FLASHWRPAGEMORE(1U)

#define S_FLASHWRENABLE    4
#define V_FLASHWRENABLE(x) ((x) << S_FLASHWRENABLE)
#define F_FLASHWRENABLE    V_FLASHWRENABLE(1U)

#define S_FLASHMOREENABLE    3
#define V_FLASHMOREENABLE(x) ((x) << S_FLASHMOREENABLE)
#define F_FLASHMOREENABLE    V_FLASHMOREENABLE(1U)

#define S_WR_RESP_ENABLE    2
#define V_WR_RESP_ENABLE(x) ((x) << S_WR_RESP_ENABLE)
#define F_WR_RESP_ENABLE    V_WR_RESP_ENABLE(1U)

#define A_CIM_UP_PO_SINGLE_OUTSTANDING 0x7c30

#define S_UP_PO_SINGLE_OUTSTANDING    0
#define V_UP_PO_SINGLE_OUTSTANDING(x) ((x) << S_UP_PO_SINGLE_OUTSTANDING)
#define F_UP_PO_SINGLE_OUTSTANDING    V_UP_PO_SINGLE_OUTSTANDING(1U)

#define A_CIM_CIM_DEBUG_SPARE 0x7c34
#define A_CIM_UP_OPERATION_FREQ 0x7c38
#define A_CIM_CIM_IBQ_ERR_CODE 0x7c3c

#define S_CIM_ULP_TX_PKT_ERR_CODE    16
#define M_CIM_ULP_TX_PKT_ERR_CODE    0xffU
#define V_CIM_ULP_TX_PKT_ERR_CODE(x) ((x) << S_CIM_ULP_TX_PKT_ERR_CODE)
#define G_CIM_ULP_TX_PKT_ERR_CODE(x) (((x) >> S_CIM_ULP_TX_PKT_ERR_CODE) & M_CIM_ULP_TX_PKT_ERR_CODE)

#define S_CIM_SGE1_PKT_ERR_CODE    8
#define M_CIM_SGE1_PKT_ERR_CODE    0xffU
#define V_CIM_SGE1_PKT_ERR_CODE(x) ((x) << S_CIM_SGE1_PKT_ERR_CODE)
#define G_CIM_SGE1_PKT_ERR_CODE(x) (((x) >> S_CIM_SGE1_PKT_ERR_CODE) & M_CIM_SGE1_PKT_ERR_CODE)

#define S_CIM_SGE0_PKT_ERR_CODE    0
#define M_CIM_SGE0_PKT_ERR_CODE    0xffU
#define V_CIM_SGE0_PKT_ERR_CODE(x) ((x) << S_CIM_SGE0_PKT_ERR_CODE)
#define G_CIM_SGE0_PKT_ERR_CODE(x) (((x) >> S_CIM_SGE0_PKT_ERR_CODE) & M_CIM_SGE0_PKT_ERR_CODE)

#define S_CIM_PCIE_PKT_ERR_CODE    8
#define M_CIM_PCIE_PKT_ERR_CODE    0xffU
#define V_CIM_PCIE_PKT_ERR_CODE(x) ((x) << S_CIM_PCIE_PKT_ERR_CODE)
#define G_CIM_PCIE_PKT_ERR_CODE(x) (((x) >> S_CIM_PCIE_PKT_ERR_CODE) & M_CIM_PCIE_PKT_ERR_CODE)

#define A_CIM_IBQ_DBG_WAIT_COUNTER 0x7c40
#define A_CIM_QUE_PERR_ADDR 0x7c40

#define S_IBQPERRADDR    16
#define M_IBQPERRADDR    0xfffU
#define V_IBQPERRADDR(x) ((x) << S_IBQPERRADDR)
#define G_IBQPERRADDR(x) (((x) >> S_IBQPERRADDR) & M_IBQPERRADDR)

#define S_OBQPERRADDR    0
#define M_OBQPERRADDR    0xfffU
#define V_OBQPERRADDR(x) ((x) << S_OBQPERRADDR)
#define G_OBQPERRADDR(x) (((x) >> S_OBQPERRADDR) & M_OBQPERRADDR)

#define A_CIM_PIO_UP_MST_CFG_SEL 0x7c44

#define S_PIO_UP_MST_CFG_SEL    0
#define V_PIO_UP_MST_CFG_SEL(x) ((x) << S_PIO_UP_MST_CFG_SEL)
#define F_PIO_UP_MST_CFG_SEL    V_PIO_UP_MST_CFG_SEL(1U)

#define A_CIM_CGEN 0x7c48

#define S_TSCH_CGEN    0
#define V_TSCH_CGEN(x) ((x) << S_TSCH_CGEN)
#define F_TSCH_CGEN    V_TSCH_CGEN(1U)

#define A_CIM_QUEUE_FEATURE_DISABLE 0x7c4c

#define S_OBQ_THROUTTLE_ON_EOP    4
#define V_OBQ_THROUTTLE_ON_EOP(x) ((x) << S_OBQ_THROUTTLE_ON_EOP)
#define F_OBQ_THROUTTLE_ON_EOP    V_OBQ_THROUTTLE_ON_EOP(1U)

#define S_OBQ_READ_CTL_PERF_MODE_DISABLE    3
#define V_OBQ_READ_CTL_PERF_MODE_DISABLE(x) ((x) << S_OBQ_READ_CTL_PERF_MODE_DISABLE)
#define F_OBQ_READ_CTL_PERF_MODE_DISABLE    V_OBQ_READ_CTL_PERF_MODE_DISABLE(1U)

#define S_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE    2
#define V_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE(x) ((x) << S_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE)
#define F_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE    V_OBQ_WAIT_FOR_EOP_FLUSH_DISABLE(1U)

#define S_IBQ_RRA_DSBL    1
#define V_IBQ_RRA_DSBL(x) ((x) << S_IBQ_RRA_DSBL)
#define F_IBQ_RRA_DSBL    V_IBQ_RRA_DSBL(1U)

#define S_IBQ_SKID_FIFO_EOP_FLSH_DSBL    0
#define V_IBQ_SKID_FIFO_EOP_FLSH_DSBL(x) ((x) << S_IBQ_SKID_FIFO_EOP_FLSH_DSBL)
#define F_IBQ_SKID_FIFO_EOP_FLSH_DSBL    V_IBQ_SKID_FIFO_EOP_FLSH_DSBL(1U)

#define S_PCIE_OBQ_IF_DISABLE    5
#define V_PCIE_OBQ_IF_DISABLE(x) ((x) << S_PCIE_OBQ_IF_DISABLE)
#define F_PCIE_OBQ_IF_DISABLE    V_PCIE_OBQ_IF_DISABLE(1U)

#define S_ULP_OBQ_SIZE    8
#define M_ULP_OBQ_SIZE    0x3U
#define V_ULP_OBQ_SIZE(x) ((x) << S_ULP_OBQ_SIZE)
#define G_ULP_OBQ_SIZE(x) (((x) >> S_ULP_OBQ_SIZE) & M_ULP_OBQ_SIZE)

#define S_TP_IBQ_SIZE    6
#define M_TP_IBQ_SIZE    0x3U
#define V_TP_IBQ_SIZE(x) ((x) << S_TP_IBQ_SIZE)
#define G_TP_IBQ_SIZE(x) (((x) >> S_TP_IBQ_SIZE) & M_TP_IBQ_SIZE)

#define S_OBQ_EOM_ENABLE    5
#define V_OBQ_EOM_ENABLE(x) ((x) << S_OBQ_EOM_ENABLE)
#define F_OBQ_EOM_ENABLE    V_OBQ_EOM_ENABLE(1U)

#define A_CIM_CGEN_GLOBAL 0x7c50

#define S_CGEN_GLOBAL    0
#define V_CGEN_GLOBAL(x) ((x) << S_CGEN_GLOBAL)
#define F_CGEN_GLOBAL    V_CGEN_GLOBAL(1U)

#define A_CIM_DPSLP_EN 0x7c54

#define S_PIFDBGLA_DPSLP_EN    0
#define V_PIFDBGLA_DPSLP_EN(x) ((x) << S_PIFDBGLA_DPSLP_EN)
#define F_PIFDBGLA_DPSLP_EN    V_PIFDBGLA_DPSLP_EN(1U)

#define A_CIM_GFT_CMM_CONFIG 0x7c58

#define S_GLFL    31
#define V_GLFL(x) ((x) << S_GLFL)
#define F_GLFL    V_GLFL(1U)

#define S_T7_WRCNTIDLE    16
#define M_T7_WRCNTIDLE    0x7fffU
#define V_T7_WRCNTIDLE(x) ((x) << S_T7_WRCNTIDLE)
#define G_T7_WRCNTIDLE(x) (((x) >> S_T7_WRCNTIDLE) & M_T7_WRCNTIDLE)

#define A_CIM_GFT_CONFIG 0x7c5c

#define S_GFTMABASE    16
#define M_GFTMABASE    0xffffU
#define V_GFTMABASE(x) ((x) << S_GFTMABASE)
#define G_GFTMABASE(x) (((x) >> S_GFTMABASE) & M_GFTMABASE)

#define S_GFTHASHTBLSIZE    12
#define M_GFTHASHTBLSIZE    0xfU
#define V_GFTHASHTBLSIZE(x) ((x) << S_GFTHASHTBLSIZE)
#define G_GFTHASHTBLSIZE(x) (((x) >> S_GFTHASHTBLSIZE) & M_GFTHASHTBLSIZE)

#define S_GFTTCAMPRIORITY    11
#define V_GFTTCAMPRIORITY(x) ((x) << S_GFTTCAMPRIORITY)
#define F_GFTTCAMPRIORITY    V_GFTTCAMPRIORITY(1U)

#define S_GFTMATHREADID    8
#define M_GFTMATHREADID    0x7U
#define V_GFTMATHREADID(x) ((x) << S_GFTMATHREADID)
#define G_GFTMATHREADID(x) (((x) >> S_GFTMATHREADID) & M_GFTMATHREADID)

#define S_GFTTCAMINIT    7
#define V_GFTTCAMINIT(x) ((x) << S_GFTTCAMINIT)
#define F_GFTTCAMINIT    V_GFTTCAMINIT(1U)

#define S_GFTTCAMINITDONE    6
#define V_GFTTCAMINITDONE(x) ((x) << S_GFTTCAMINITDONE)
#define F_GFTTCAMINITDONE    V_GFTTCAMINITDONE(1U)

#define S_GFTTBLMODEEN    0
#define V_GFTTBLMODEEN(x) ((x) << S_GFTTBLMODEEN)
#define F_GFTTBLMODEEN    V_GFTTBLMODEEN(1U)

#define A_CIM_TCAM_BIST_CTRL 0x7c60

#define S_RST_CB    31
#define V_RST_CB(x) ((x) << S_RST_CB)
#define F_RST_CB    V_RST_CB(1U)

#define S_CB_START    0
#define M_CB_START    0xfffffffU
#define V_CB_START(x) ((x) << S_CB_START)
#define G_CB_START(x) (((x) >> S_CB_START) & M_CB_START)

#define A_CIM_TCAM_BIST_CB_PASS 0x7c64

#define S_CB_PASS    0
#define M_CB_PASS    0xfffffffU
#define V_CB_PASS(x) ((x) << S_CB_PASS)
#define G_CB_PASS(x) (((x) >> S_CB_PASS) & M_CB_PASS)

#define A_CIM_TCAM_BIST_CB_BUSY 0x7c68

#define S_CB_BUSY    0
#define M_CB_BUSY    0xfffffffU
#define V_CB_BUSY(x) ((x) << S_CB_BUSY)
#define G_CB_BUSY(x) (((x) >> S_CB_BUSY) & M_CB_BUSY)

#define A_CIM_GFT_MASK 0x7c70

/* registers for module TP */
#define TP_BASE_ADDR 0x7d00

#define A_TP_IN_CONFIG 0x7d00

#define S_TCPOPTPARSERDISCH3    27
#define V_TCPOPTPARSERDISCH3(x) ((x) << S_TCPOPTPARSERDISCH3)
#define F_TCPOPTPARSERDISCH3    V_TCPOPTPARSERDISCH3(1U)

#define S_TCPOPTPARSERDISCH2    26
#define V_TCPOPTPARSERDISCH2(x) ((x) << S_TCPOPTPARSERDISCH2)
#define F_TCPOPTPARSERDISCH2    V_TCPOPTPARSERDISCH2(1U)

#define S_TCPOPTPARSERDISCH1    25
#define V_TCPOPTPARSERDISCH1(x) ((x) << S_TCPOPTPARSERDISCH1)
#define F_TCPOPTPARSERDISCH1    V_TCPOPTPARSERDISCH1(1U)

#define S_TCPOPTPARSERDISCH0    24
#define V_TCPOPTPARSERDISCH0(x) ((x) << S_TCPOPTPARSERDISCH0)
#define F_TCPOPTPARSERDISCH0    V_TCPOPTPARSERDISCH0(1U)

#define S_CRCPASSPRT3    23
#define V_CRCPASSPRT3(x) ((x) << S_CRCPASSPRT3)
#define F_CRCPASSPRT3    V_CRCPASSPRT3(1U)

#define S_CRCPASSPRT2    22
#define V_CRCPASSPRT2(x) ((x) << S_CRCPASSPRT2)
#define F_CRCPASSPRT2    V_CRCPASSPRT2(1U)

#define S_CRCPASSPRT1    21
#define V_CRCPASSPRT1(x) ((x) << S_CRCPASSPRT1)
#define F_CRCPASSPRT1    V_CRCPASSPRT1(1U)

#define S_CRCPASSPRT0    20
#define V_CRCPASSPRT0(x) ((x) << S_CRCPASSPRT0)
#define F_CRCPASSPRT0    V_CRCPASSPRT0(1U)

#define S_VEPAMODE    19
#define V_VEPAMODE(x) ((x) << S_VEPAMODE)
#define F_VEPAMODE    V_VEPAMODE(1U)

#define S_FIPUPEN    18
#define V_FIPUPEN(x) ((x) << S_FIPUPEN)
#define F_FIPUPEN    V_FIPUPEN(1U)

#define S_FCOEUPEN    17
#define V_FCOEUPEN(x) ((x) << S_FCOEUPEN)
#define F_FCOEUPEN    V_FCOEUPEN(1U)

#define S_FCOEENABLE    16
#define V_FCOEENABLE(x) ((x) << S_FCOEENABLE)
#define F_FCOEENABLE    V_FCOEENABLE(1U)

#define S_IPV6ENABLE    15
#define V_IPV6ENABLE(x) ((x) << S_IPV6ENABLE)
#define F_IPV6ENABLE    V_IPV6ENABLE(1U)

#define S_NICMODE    14
#define V_NICMODE(x) ((x) << S_NICMODE)
#define F_NICMODE    V_NICMODE(1U)

#define S_ECHECKSUMCHECKTCP    13
#define V_ECHECKSUMCHECKTCP(x) ((x) << S_ECHECKSUMCHECKTCP)
#define F_ECHECKSUMCHECKTCP    V_ECHECKSUMCHECKTCP(1U)

#define S_ECHECKSUMCHECKIP    12
#define V_ECHECKSUMCHECKIP(x) ((x) << S_ECHECKSUMCHECKIP)
#define F_ECHECKSUMCHECKIP    V_ECHECKSUMCHECKIP(1U)

#define S_EREPORTUDPHDRLEN    11
#define V_EREPORTUDPHDRLEN(x) ((x) << S_EREPORTUDPHDRLEN)
#define F_EREPORTUDPHDRLEN    V_EREPORTUDPHDRLEN(1U)

#define S_IN_ECPL    10
#define V_IN_ECPL(x) ((x) << S_IN_ECPL)
#define F_IN_ECPL    V_IN_ECPL(1U)

#define S_VNTAGENABLE    9
#define V_VNTAGENABLE(x) ((x) << S_VNTAGENABLE)
#define F_VNTAGENABLE    V_VNTAGENABLE(1U)

#define S_IN_EETH    8
#define V_IN_EETH(x) ((x) << S_IN_EETH)
#define F_IN_EETH    V_IN_EETH(1U)

#define S_CCHECKSUMCHECKTCP    6
#define V_CCHECKSUMCHECKTCP(x) ((x) << S_CCHECKSUMCHECKTCP)
#define F_CCHECKSUMCHECKTCP    V_CCHECKSUMCHECKTCP(1U)

#define S_CCHECKSUMCHECKIP    5
#define V_CCHECKSUMCHECKIP(x) ((x) << S_CCHECKSUMCHECKIP)
#define F_CCHECKSUMCHECKIP    V_CCHECKSUMCHECKIP(1U)

#define S_CTAG    4
#define V_CTAG(x) ((x) << S_CTAG)
#define F_CTAG    V_CTAG(1U)

#define S_IN_CCPL    3
#define V_IN_CCPL(x) ((x) << S_IN_CCPL)
#define F_IN_CCPL    V_IN_CCPL(1U)

#define S_IN_CETH    1
#define V_IN_CETH(x) ((x) << S_IN_CETH)
#define F_IN_CETH    V_IN_CETH(1U)

#define S_CTUNNEL    0
#define V_CTUNNEL(x) ((x) << S_CTUNNEL)
#define F_CTUNNEL    V_CTUNNEL(1U)

#define S_VLANEXTENPORT3    31
#define V_VLANEXTENPORT3(x) ((x) << S_VLANEXTENPORT3)
#define F_VLANEXTENPORT3    V_VLANEXTENPORT3(1U)

#define S_VLANEXTENPORT2    30
#define V_VLANEXTENPORT2(x) ((x) << S_VLANEXTENPORT2)
#define F_VLANEXTENPORT2    V_VLANEXTENPORT2(1U)

#define S_VLANEXTENPORT1    29
#define V_VLANEXTENPORT1(x) ((x) << S_VLANEXTENPORT1)
#define F_VLANEXTENPORT1    V_VLANEXTENPORT1(1U)

#define S_VLANEXTENPORT0    28
#define V_VLANEXTENPORT0(x) ((x) << S_VLANEXTENPORT0)
#define F_VLANEXTENPORT0    V_VLANEXTENPORT0(1U)

#define S_VNTAGDEFAULTVAL    13
#define V_VNTAGDEFAULTVAL(x) ((x) << S_VNTAGDEFAULTVAL)
#define F_VNTAGDEFAULTVAL    V_VNTAGDEFAULTVAL(1U)

#define S_ECHECKUDPLEN    12
#define V_ECHECKUDPLEN(x) ((x) << S_ECHECKUDPLEN)
#define F_ECHECKUDPLEN    V_ECHECKUDPLEN(1U)

#define S_FCOEFPMA    10
#define V_FCOEFPMA(x) ((x) << S_FCOEFPMA)
#define F_FCOEFPMA    V_FCOEFPMA(1U)

#define S_VNTAGETHENABLE    8
#define V_VNTAGETHENABLE(x) ((x) << S_VNTAGETHENABLE)
#define F_VNTAGETHENABLE    V_VNTAGETHENABLE(1U)

#define S_IP_CCSM    7
#define V_IP_CCSM(x) ((x) << S_IP_CCSM)
#define F_IP_CCSM    V_IP_CCSM(1U)

#define S_CCHECKSUMCHECKUDP    6
#define V_CCHECKSUMCHECKUDP(x) ((x) << S_CCHECKSUMCHECKUDP)
#define F_CCHECKSUMCHECKUDP    V_CCHECKSUMCHECKUDP(1U)

#define S_TCP_CCSM    5
#define V_TCP_CCSM(x) ((x) << S_TCP_CCSM)
#define F_TCP_CCSM    V_TCP_CCSM(1U)

#define S_CDEMUX    3
#define V_CDEMUX(x) ((x) << S_CDEMUX)
#define F_CDEMUX    V_CDEMUX(1U)

#define S_ETHUPEN    2
#define V_ETHUPEN(x) ((x) << S_ETHUPEN)
#define F_ETHUPEN    V_ETHUPEN(1U)

#define S_CXOFFOVERRIDE    3
#define V_CXOFFOVERRIDE(x) ((x) << S_CXOFFOVERRIDE)
#define F_CXOFFOVERRIDE    V_CXOFFOVERRIDE(1U)

#define S_EGREDROPEN    1
#define V_EGREDROPEN(x) ((x) << S_EGREDROPEN)
#define F_EGREDROPEN    V_EGREDROPEN(1U)

#define S_CFASTDEMUXEN    0
#define V_CFASTDEMUXEN(x) ((x) << S_CFASTDEMUXEN)
#define F_CFASTDEMUXEN    V_CFASTDEMUXEN(1U)

#define A_TP_OUT_CONFIG 0x7d04

#define S_PORTQFCEN    28
#define M_PORTQFCEN    0xfU
#define V_PORTQFCEN(x) ((x) << S_PORTQFCEN)
#define G_PORTQFCEN(x) (((x) >> S_PORTQFCEN) & M_PORTQFCEN)

#define S_EPKTDISTCHN3    23
#define V_EPKTDISTCHN3(x) ((x) << S_EPKTDISTCHN3)
#define F_EPKTDISTCHN3    V_EPKTDISTCHN3(1U)

#define S_EPKTDISTCHN2    22
#define V_EPKTDISTCHN2(x) ((x) << S_EPKTDISTCHN2)
#define F_EPKTDISTCHN2    V_EPKTDISTCHN2(1U)

#define S_EPKTDISTCHN1    21
#define V_EPKTDISTCHN1(x) ((x) << S_EPKTDISTCHN1)
#define F_EPKTDISTCHN1    V_EPKTDISTCHN1(1U)

#define S_EPKTDISTCHN0    20
#define V_EPKTDISTCHN0(x) ((x) << S_EPKTDISTCHN0)
#define F_EPKTDISTCHN0    V_EPKTDISTCHN0(1U)

#define S_TTLMODE    19
#define V_TTLMODE(x) ((x) << S_TTLMODE)
#define F_TTLMODE    V_TTLMODE(1U)

#define S_EQFCDMAC    18
#define V_EQFCDMAC(x) ((x) << S_EQFCDMAC)
#define F_EQFCDMAC    V_EQFCDMAC(1U)

#define S_ELPBKINCMPSSTAT    17
#define V_ELPBKINCMPSSTAT(x) ((x) << S_ELPBKINCMPSSTAT)
#define F_ELPBKINCMPSSTAT    V_ELPBKINCMPSSTAT(1U)

#define S_IPIDSPLITMODE    16
#define V_IPIDSPLITMODE(x) ((x) << S_IPIDSPLITMODE)
#define F_IPIDSPLITMODE    V_IPIDSPLITMODE(1U)

#define S_VLANEXTENABLEPORT3    15
#define V_VLANEXTENABLEPORT3(x) ((x) << S_VLANEXTENABLEPORT3)
#define F_VLANEXTENABLEPORT3    V_VLANEXTENABLEPORT3(1U)

#define S_VLANEXTENABLEPORT2    14
#define V_VLANEXTENABLEPORT2(x) ((x) << S_VLANEXTENABLEPORT2)
#define F_VLANEXTENABLEPORT2    V_VLANEXTENABLEPORT2(1U)

#define S_VLANEXTENABLEPORT1    13
#define V_VLANEXTENABLEPORT1(x) ((x) << S_VLANEXTENABLEPORT1)
#define F_VLANEXTENABLEPORT1    V_VLANEXTENABLEPORT1(1U)

#define S_VLANEXTENABLEPORT0    12
#define V_VLANEXTENABLEPORT0(x) ((x) << S_VLANEXTENABLEPORT0)
#define F_VLANEXTENABLEPORT0    V_VLANEXTENABLEPORT0(1U)

#define S_ECHECKSUMINSERTTCP    11
#define V_ECHECKSUMINSERTTCP(x) ((x) << S_ECHECKSUMINSERTTCP)
#define F_ECHECKSUMINSERTTCP    V_ECHECKSUMINSERTTCP(1U)

#define S_ECHECKSUMINSERTIP    10
#define V_ECHECKSUMINSERTIP(x) ((x) << S_ECHECKSUMINSERTIP)
#define F_ECHECKSUMINSERTIP    V_ECHECKSUMINSERTIP(1U)

#define S_ECPL    8
#define V_ECPL(x) ((x) << S_ECPL)
#define F_ECPL    V_ECPL(1U)

#define S_EPRIORITY    7
#define V_EPRIORITY(x) ((x) << S_EPRIORITY)
#define F_EPRIORITY    V_EPRIORITY(1U)

#define S_EETHERNET    6
#define V_EETHERNET(x) ((x) << S_EETHERNET)
#define F_EETHERNET    V_EETHERNET(1U)

#define S_CCHECKSUMINSERTTCP    5
#define V_CCHECKSUMINSERTTCP(x) ((x) << S_CCHECKSUMINSERTTCP)
#define F_CCHECKSUMINSERTTCP    V_CCHECKSUMINSERTTCP(1U)

#define S_CCHECKSUMINSERTIP    4
#define V_CCHECKSUMINSERTIP(x) ((x) << S_CCHECKSUMINSERTIP)
#define F_CCHECKSUMINSERTIP    V_CCHECKSUMINSERTIP(1U)

#define S_CCPL    2
#define V_CCPL(x) ((x) << S_CCPL)
#define F_CCPL    V_CCPL(1U)

#define S_CETHERNET    0
#define V_CETHERNET(x) ((x) << S_CETHERNET)
#define F_CETHERNET    V_CETHERNET(1U)

#define S_EVNTAGEN    9
#define V_EVNTAGEN(x) ((x) << S_EVNTAGEN)
#define F_EVNTAGEN    V_EVNTAGEN(1U)

#define S_CCPLACKMODE    13
#define V_CCPLACKMODE(x) ((x) << S_CCPLACKMODE)
#define F_CCPLACKMODE    V_CCPLACKMODE(1U)

#define S_RMWHINTENABLE    12
#define V_RMWHINTENABLE(x) ((x) << S_RMWHINTENABLE)
#define F_RMWHINTENABLE    V_RMWHINTENABLE(1U)

#define S_EV6FLWEN    8
#define V_EV6FLWEN(x) ((x) << S_EV6FLWEN)
#define F_EV6FLWEN    V_EV6FLWEN(1U)

#define S_EVLANPRIO    6
#define V_EVLANPRIO(x) ((x) << S_EVLANPRIO)
#define F_EVLANPRIO    V_EVLANPRIO(1U)

#define S_CRXPKTENC    3
#define V_CRXPKTENC(x) ((x) << S_CRXPKTENC)
#define F_CRXPKTENC    V_CRXPKTENC(1U)

#define S_CRXPKTXT    1
#define V_CRXPKTXT(x) ((x) << S_CRXPKTXT)
#define F_CRXPKTXT    V_CRXPKTXT(1U)

#define S_ETOEBYPCSUMNOWAIT    15
#define V_ETOEBYPCSUMNOWAIT(x) ((x) << S_ETOEBYPCSUMNOWAIT)
#define F_ETOEBYPCSUMNOWAIT    V_ETOEBYPCSUMNOWAIT(1U)

#define S_ENICCSUMNOWAIT    14
#define V_ENICCSUMNOWAIT(x) ((x) << S_ENICCSUMNOWAIT)
#define F_ENICCSUMNOWAIT    V_ENICCSUMNOWAIT(1U)

#define A_TP_GLOBAL_CONFIG 0x7d08

#define S_SYNCOOKIEPARAMS    26
#define M_SYNCOOKIEPARAMS    0x3fU
#define V_SYNCOOKIEPARAMS(x) ((x) << S_SYNCOOKIEPARAMS)
#define G_SYNCOOKIEPARAMS(x) (((x) >> S_SYNCOOKIEPARAMS) & M_SYNCOOKIEPARAMS)

#define S_RXFLOWCONTROLDISABLE    25
#define V_RXFLOWCONTROLDISABLE(x) ((x) << S_RXFLOWCONTROLDISABLE)
#define F_RXFLOWCONTROLDISABLE    V_RXFLOWCONTROLDISABLE(1U)

#define S_TXPACINGENABLE    24
#define V_TXPACINGENABLE(x) ((x) << S_TXPACINGENABLE)
#define F_TXPACINGENABLE    V_TXPACINGENABLE(1U)

#define S_ATTACKFILTERENABLE    23
#define V_ATTACKFILTERENABLE(x) ((x) << S_ATTACKFILTERENABLE)
#define F_ATTACKFILTERENABLE    V_ATTACKFILTERENABLE(1U)

#define S_SYNCOOKIENOOPTIONS    22
#define V_SYNCOOKIENOOPTIONS(x) ((x) << S_SYNCOOKIENOOPTIONS)
#define F_SYNCOOKIENOOPTIONS    V_SYNCOOKIENOOPTIONS(1U)

#define S_PROTECTEDMODE    21
#define V_PROTECTEDMODE(x) ((x) << S_PROTECTEDMODE)
#define F_PROTECTEDMODE    V_PROTECTEDMODE(1U)

#define S_PINGDROP    20
#define V_PINGDROP(x) ((x) << S_PINGDROP)
#define F_PINGDROP    V_PINGDROP(1U)

#define S_FRAGMENTDROP    19
#define V_FRAGMENTDROP(x) ((x) << S_FRAGMENTDROP)
#define F_FRAGMENTDROP    V_FRAGMENTDROP(1U)

#define S_FIVETUPLELOOKUP    17
#define M_FIVETUPLELOOKUP    0x3U
#define V_FIVETUPLELOOKUP(x) ((x) << S_FIVETUPLELOOKUP)
#define G_FIVETUPLELOOKUP(x) (((x) >> S_FIVETUPLELOOKUP) & M_FIVETUPLELOOKUP)

#define S_OFDMPSSTATS    16
#define V_OFDMPSSTATS(x) ((x) << S_OFDMPSSTATS)
#define F_OFDMPSSTATS    V_OFDMPSSTATS(1U)

#define S_DONTFRAGMENT    15
#define V_DONTFRAGMENT(x) ((x) << S_DONTFRAGMENT)
#define F_DONTFRAGMENT    V_DONTFRAGMENT(1U)

#define S_IPIDENTSPLIT    14
#define V_IPIDENTSPLIT(x) ((x) << S_IPIDENTSPLIT)
#define F_IPIDENTSPLIT    V_IPIDENTSPLIT(1U)

#define S_IPCHECKSUMOFFLOAD    13
#define V_IPCHECKSUMOFFLOAD(x) ((x) << S_IPCHECKSUMOFFLOAD)
#define F_IPCHECKSUMOFFLOAD    V_IPCHECKSUMOFFLOAD(1U)

#define S_UDPCHECKSUMOFFLOAD    12
#define V_UDPCHECKSUMOFFLOAD(x) ((x) << S_UDPCHECKSUMOFFLOAD)
#define F_UDPCHECKSUMOFFLOAD    V_UDPCHECKSUMOFFLOAD(1U)

#define S_TCPCHECKSUMOFFLOAD    11
#define V_TCPCHECKSUMOFFLOAD(x) ((x) << S_TCPCHECKSUMOFFLOAD)
#define F_TCPCHECKSUMOFFLOAD    V_TCPCHECKSUMOFFLOAD(1U)

#define S_RSSLOOPBACKENABLE    10
#define V_RSSLOOPBACKENABLE(x) ((x) << S_RSSLOOPBACKENABLE)
#define F_RSSLOOPBACKENABLE    V_RSSLOOPBACKENABLE(1U)

#define S_TCAMSERVERUSE    8
#define M_TCAMSERVERUSE    0x3U
#define V_TCAMSERVERUSE(x) ((x) << S_TCAMSERVERUSE)
#define G_TCAMSERVERUSE(x) (((x) >> S_TCAMSERVERUSE) & M_TCAMSERVERUSE)

#define S_IPTTL    0
#define M_IPTTL    0xffU
#define V_IPTTL(x) ((x) << S_IPTTL)
#define G_IPTTL(x) (((x) >> S_IPTTL) & M_IPTTL)

#define S_RSSSYNSTEERENABLE    12
#define V_RSSSYNSTEERENABLE(x) ((x) << S_RSSSYNSTEERENABLE)
#define F_RSSSYNSTEERENABLE    V_RSSSYNSTEERENABLE(1U)

#define S_ISSFROMCPLENABLE    11
#define V_ISSFROMCPLENABLE(x) ((x) << S_ISSFROMCPLENABLE)
#define F_ISSFROMCPLENABLE    V_ISSFROMCPLENABLE(1U)

#define S_ACTIVEFILTERCOUNTS    22
#define V_ACTIVEFILTERCOUNTS(x) ((x) << S_ACTIVEFILTERCOUNTS)
#define F_ACTIVEFILTERCOUNTS    V_ACTIVEFILTERCOUNTS(1U)

#define S_RXSACKPARSE    31
#define V_RXSACKPARSE(x) ((x) << S_RXSACKPARSE)
#define F_RXSACKPARSE    V_RXSACKPARSE(1U)

#define S_RXSACKFWDMODE    29
#define M_RXSACKFWDMODE    0x3U
#define V_RXSACKFWDMODE(x) ((x) << S_RXSACKFWDMODE)
#define G_RXSACKFWDMODE(x) (((x) >> S_RXSACKFWDMODE) & M_RXSACKFWDMODE)

#define S_SRVRCHRSSEN    26
#define V_SRVRCHRSSEN(x) ((x) << S_SRVRCHRSSEN)
#define F_SRVRCHRSSEN    V_SRVRCHRSSEN(1U)

#define S_LBCHNDISTEN    23
#define V_LBCHNDISTEN(x) ((x) << S_LBCHNDISTEN)
#define F_LBCHNDISTEN    V_LBCHNDISTEN(1U)

#define S_ETHTNLLEN2X    20
#define V_ETHTNLLEN2X(x) ((x) << S_ETHTNLLEN2X)
#define F_ETHTNLLEN2X    V_ETHTNLLEN2X(1U)

#define S_EGLBCHNDISTEN    19
#define V_EGLBCHNDISTEN(x) ((x) << S_EGLBCHNDISTEN)
#define F_EGLBCHNDISTEN    V_EGLBCHNDISTEN(1U)

#define A_TP_DB_CONFIG 0x7d0c

#define S_DBMAXOPCNT    24
#define M_DBMAXOPCNT    0xffU
#define V_DBMAXOPCNT(x) ((x) << S_DBMAXOPCNT)
#define G_DBMAXOPCNT(x) (((x) >> S_DBMAXOPCNT) & M_DBMAXOPCNT)

#define S_CXMAXOPCNTDISABLE    23
#define V_CXMAXOPCNTDISABLE(x) ((x) << S_CXMAXOPCNTDISABLE)
#define F_CXMAXOPCNTDISABLE    V_CXMAXOPCNTDISABLE(1U)

#define S_CXMAXOPCNT    16
#define M_CXMAXOPCNT    0x7fU
#define V_CXMAXOPCNT(x) ((x) << S_CXMAXOPCNT)
#define G_CXMAXOPCNT(x) (((x) >> S_CXMAXOPCNT) & M_CXMAXOPCNT)

#define S_TXMAXOPCNTDISABLE    15
#define V_TXMAXOPCNTDISABLE(x) ((x) << S_TXMAXOPCNTDISABLE)
#define F_TXMAXOPCNTDISABLE    V_TXMAXOPCNTDISABLE(1U)

#define S_TXMAXOPCNT    8
#define M_TXMAXOPCNT    0x7fU
#define V_TXMAXOPCNT(x) ((x) << S_TXMAXOPCNT)
#define G_TXMAXOPCNT(x) (((x) >> S_TXMAXOPCNT) & M_TXMAXOPCNT)

#define S_RXMAXOPCNTDISABLE    7
#define V_RXMAXOPCNTDISABLE(x) ((x) << S_RXMAXOPCNTDISABLE)
#define F_RXMAXOPCNTDISABLE    V_RXMAXOPCNTDISABLE(1U)

#define S_RXMAXOPCNT    0
#define M_RXMAXOPCNT    0x7fU
#define V_RXMAXOPCNT(x) ((x) << S_RXMAXOPCNT)
#define G_RXMAXOPCNT(x) (((x) >> S_RXMAXOPCNT) & M_RXMAXOPCNT)

#define A_TP_CMM_TCB_BASE 0x7d10
#define A_TP_CMM_MM_BASE 0x7d14
#define A_TP_CMM_TIMER_BASE 0x7d18
#define A_TP_CMM_MM_FLST_SIZE 0x7d1c

#define S_RXPOOLSIZE    16
#define M_RXPOOLSIZE    0xffffU
#define V_RXPOOLSIZE(x) ((x) << S_RXPOOLSIZE)
#define G_RXPOOLSIZE(x) (((x) >> S_RXPOOLSIZE) & M_RXPOOLSIZE)

#define S_TXPOOLSIZE    0
#define M_TXPOOLSIZE    0xffffU
#define V_TXPOOLSIZE(x) ((x) << S_TXPOOLSIZE)
#define G_TXPOOLSIZE(x) (((x) >> S_TXPOOLSIZE) & M_TXPOOLSIZE)

#define A_TP_PMM_TX_BASE 0x7d20
#define A_TP_PMM_DEFRAG_BASE 0x7d24
#define A_TP_PMM_RX_BASE 0x7d28
#define A_TP_PMM_RX_PAGE_SIZE 0x7d2c
#define A_TP_PMM_RX_MAX_PAGE 0x7d30

#define S_PMRXNUMCHN    31
#define V_PMRXNUMCHN(x) ((x) << S_PMRXNUMCHN)
#define F_PMRXNUMCHN    V_PMRXNUMCHN(1U)

#define S_PMRXMAXPAGE    0
#define M_PMRXMAXPAGE    0x1fffffU
#define V_PMRXMAXPAGE(x) ((x) << S_PMRXMAXPAGE)
#define G_PMRXMAXPAGE(x) (((x) >> S_PMRXMAXPAGE) & M_PMRXMAXPAGE)

#define S_T7_PMRXNUMCHN    29
#define M_T7_PMRXNUMCHN    0x7U
#define V_T7_PMRXNUMCHN(x) ((x) << S_T7_PMRXNUMCHN)
#define G_T7_PMRXNUMCHN(x) (((x) >> S_T7_PMRXNUMCHN) & M_T7_PMRXNUMCHN)

#define A_TP_PMM_TX_PAGE_SIZE 0x7d34
#define A_TP_PMM_TX_MAX_PAGE 0x7d38

#define S_PMTXNUMCHN    30
#define M_PMTXNUMCHN    0x3U
#define V_PMTXNUMCHN(x) ((x) << S_PMTXNUMCHN)
#define G_PMTXNUMCHN(x) (((x) >> S_PMTXNUMCHN) & M_PMTXNUMCHN)

#define S_PMTXMAXPAGE    0
#define M_PMTXMAXPAGE    0x1fffffU
#define V_PMTXMAXPAGE(x) ((x) << S_PMTXMAXPAGE)
#define G_PMTXMAXPAGE(x) (((x) >> S_PMTXMAXPAGE) & M_PMTXMAXPAGE)

#define S_T7_PMTXNUMCHN    29
#define M_T7_PMTXNUMCHN    0x7U
#define V_T7_PMTXNUMCHN(x) ((x) << S_T7_PMTXNUMCHN)
#define G_T7_PMTXNUMCHN(x) (((x) >> S_T7_PMTXNUMCHN) & M_T7_PMTXNUMCHN)

#define A_TP_EXT_CONFIG 0x7d3c

#define S_TNLERRORIPSECARW    29
#define V_TNLERRORIPSECARW(x) ((x) << S_TNLERRORIPSECARW)
#define F_TNLERRORIPSECARW    V_TNLERRORIPSECARW(1U)

#define S_TNLERRORIPSECICV    28
#define V_TNLERRORIPSECICV(x) ((x) << S_TNLERRORIPSECICV)
#define F_TNLERRORIPSECICV    V_TNLERRORIPSECICV(1U)

#define S_DROPERRORIPSECARW    25
#define V_DROPERRORIPSECARW(x) ((x) << S_DROPERRORIPSECARW)
#define F_DROPERRORIPSECARW    V_DROPERRORIPSECARW(1U)

#define S_DROPERRORIPSECICV    24
#define V_DROPERRORIPSECICV(x) ((x) << S_DROPERRORIPSECICV)
#define F_DROPERRORIPSECICV    V_DROPERRORIPSECICV(1U)

#define S_MIBRDMAROCEEN    19
#define V_MIBRDMAROCEEN(x) ((x) << S_MIBRDMAROCEEN)
#define F_MIBRDMAROCEEN    V_MIBRDMAROCEEN(1U)

#define S_MIBRDMAIWARPEN    18
#define V_MIBRDMAIWARPEN(x) ((x) << S_MIBRDMAIWARPEN)
#define F_MIBRDMAIWARPEN    V_MIBRDMAIWARPEN(1U)

#define S_BYPTXDATAACKALLEN    17
#define V_BYPTXDATAACKALLEN(x) ((x) << S_BYPTXDATAACKALLEN)
#define F_BYPTXDATAACKALLEN    V_BYPTXDATAACKALLEN(1U)

#define S_DATAACKEXTEN    16
#define V_DATAACKEXTEN(x) ((x) << S_DATAACKEXTEN)
#define F_DATAACKEXTEN    V_DATAACKEXTEN(1U)

#define S_MACMATCH11FWD    11
#define V_MACMATCH11FWD(x) ((x) << S_MACMATCH11FWD)
#define F_MACMATCH11FWD    V_MACMATCH11FWD(1U)

#define S_USERTMSTPEN    10
#define V_USERTMSTPEN(x) ((x) << S_USERTMSTPEN)
#define F_USERTMSTPEN    V_USERTMSTPEN(1U)

#define S_MMGRCACHEDIS    9
#define V_MMGRCACHEDIS(x) ((x) << S_MMGRCACHEDIS)
#define F_MMGRCACHEDIS    V_MMGRCACHEDIS(1U)

#define S_TXPKTPACKOUTUDPEN    8
#define V_TXPKTPACKOUTUDPEN(x) ((x) << S_TXPKTPACKOUTUDPEN)
#define F_TXPKTPACKOUTUDPEN    V_TXPKTPACKOUTUDPEN(1U)

#define S_IPSECROCECRCMODE    6
#define M_IPSECROCECRCMODE    0x3U
#define V_IPSECROCECRCMODE(x) ((x) << S_IPSECROCECRCMODE)
#define G_IPSECROCECRCMODE(x) (((x) >> S_IPSECROCECRCMODE) & M_IPSECROCECRCMODE)

#define S_IPSECIDXLOC    5
#define V_IPSECIDXLOC(x) ((x) << S_IPSECIDXLOC)
#define F_IPSECIDXLOC    V_IPSECIDXLOC(1U)

#define S_IPSECIDXCAPEN    4
#define V_IPSECIDXCAPEN(x) ((x) << S_IPSECIDXCAPEN)
#define F_IPSECIDXCAPEN    V_IPSECIDXCAPEN(1U)

#define S_IPSECOFEN    3
#define V_IPSECOFEN(x) ((x) << S_IPSECOFEN)
#define F_IPSECOFEN    V_IPSECOFEN(1U)

#define S_IPSECCFG    0
#define M_IPSECCFG    0x7U
#define V_IPSECCFG(x) ((x) << S_IPSECCFG)
#define G_IPSECCFG(x) (((x) >> S_IPSECCFG) & M_IPSECCFG)

#define A_TP_TCP_OPTIONS 0x7d40

#define S_MTUDEFAULT    16
#define M_MTUDEFAULT    0xffffU
#define V_MTUDEFAULT(x) ((x) << S_MTUDEFAULT)
#define G_MTUDEFAULT(x) (((x) >> S_MTUDEFAULT) & M_MTUDEFAULT)

#define S_MTUENABLE    10
#define V_MTUENABLE(x) ((x) << S_MTUENABLE)
#define F_MTUENABLE    V_MTUENABLE(1U)

#define S_SACKTX    9
#define V_SACKTX(x) ((x) << S_SACKTX)
#define F_SACKTX    V_SACKTX(1U)

#define S_SACKRX    8
#define V_SACKRX(x) ((x) << S_SACKRX)
#define F_SACKRX    V_SACKRX(1U)

#define S_SACKMODE    4
#define M_SACKMODE    0x3U
#define V_SACKMODE(x) ((x) << S_SACKMODE)
#define G_SACKMODE(x) (((x) >> S_SACKMODE) & M_SACKMODE)

#define S_WINDOWSCALEMODE    2
#define M_WINDOWSCALEMODE    0x3U
#define V_WINDOWSCALEMODE(x) ((x) << S_WINDOWSCALEMODE)
#define G_WINDOWSCALEMODE(x) (((x) >> S_WINDOWSCALEMODE) & M_WINDOWSCALEMODE)

#define S_TIMESTAMPSMODE    0
#define M_TIMESTAMPSMODE    0x3U
#define V_TIMESTAMPSMODE(x) ((x) << S_TIMESTAMPSMODE)
#define G_TIMESTAMPSMODE(x) (((x) >> S_TIMESTAMPSMODE) & M_TIMESTAMPSMODE)

#define A_TP_DACK_CONFIG 0x7d44

#define S_AUTOSTATE3    30
#define M_AUTOSTATE3    0x3U
#define V_AUTOSTATE3(x) ((x) << S_AUTOSTATE3)
#define G_AUTOSTATE3(x) (((x) >> S_AUTOSTATE3) & M_AUTOSTATE3)

#define S_AUTOSTATE2    28
#define M_AUTOSTATE2    0x3U
#define V_AUTOSTATE2(x) ((x) << S_AUTOSTATE2)
#define G_AUTOSTATE2(x) (((x) >> S_AUTOSTATE2) & M_AUTOSTATE2)

#define S_AUTOSTATE1    26
#define M_AUTOSTATE1    0x3U
#define V_AUTOSTATE1(x) ((x) << S_AUTOSTATE1)
#define G_AUTOSTATE1(x) (((x) >> S_AUTOSTATE1) & M_AUTOSTATE1)

#define S_BYTETHRESHOLD    8
#define M_BYTETHRESHOLD    0x3ffffU
#define V_BYTETHRESHOLD(x) ((x) << S_BYTETHRESHOLD)
#define G_BYTETHRESHOLD(x) (((x) >> S_BYTETHRESHOLD) & M_BYTETHRESHOLD)

#define S_MSSTHRESHOLD    4
#define M_MSSTHRESHOLD    0x7U
#define V_MSSTHRESHOLD(x) ((x) << S_MSSTHRESHOLD)
#define G_MSSTHRESHOLD(x) (((x) >> S_MSSTHRESHOLD) & M_MSSTHRESHOLD)

#define S_AUTOCAREFUL    2
#define V_AUTOCAREFUL(x) ((x) << S_AUTOCAREFUL)
#define F_AUTOCAREFUL    V_AUTOCAREFUL(1U)

#define S_AUTOENABLE    1
#define V_AUTOENABLE(x) ((x) << S_AUTOENABLE)
#define F_AUTOENABLE    V_AUTOENABLE(1U)

#define S_MODE    0
#define V_MODE(x) ((x) << S_MODE)
#define F_MODE    V_MODE(1U)

#define A_TP_PC_CONFIG 0x7d48

#define S_CMCACHEDISABLE    31
#define V_CMCACHEDISABLE(x) ((x) << S_CMCACHEDISABLE)
#define F_CMCACHEDISABLE    V_CMCACHEDISABLE(1U)

#define S_ENABLEOCSPIFULL    30
#define V_ENABLEOCSPIFULL(x) ((x) << S_ENABLEOCSPIFULL)
#define F_ENABLEOCSPIFULL    V_ENABLEOCSPIFULL(1U)

#define S_ENABLEFLMERRORDDP    29
#define V_ENABLEFLMERRORDDP(x) ((x) << S_ENABLEFLMERRORDDP)
#define F_ENABLEFLMERRORDDP    V_ENABLEFLMERRORDDP(1U)

#define S_LOCKTID    28
#define V_LOCKTID(x) ((x) << S_LOCKTID)
#define F_LOCKTID    V_LOCKTID(1U)

#define S_DISABLEINVPEND    27
#define V_DISABLEINVPEND(x) ((x) << S_DISABLEINVPEND)
#define F_DISABLEINVPEND    V_DISABLEINVPEND(1U)

#define S_ENABLEFILTERCOUNT    26
#define V_ENABLEFILTERCOUNT(x) ((x) << S_ENABLEFILTERCOUNT)
#define F_ENABLEFILTERCOUNT    V_ENABLEFILTERCOUNT(1U)

#define S_RDDPCONGEN    25
#define V_RDDPCONGEN(x) ((x) << S_RDDPCONGEN)
#define F_RDDPCONGEN    V_RDDPCONGEN(1U)

#define S_ENABLEONFLYPDU    24
#define V_ENABLEONFLYPDU(x) ((x) << S_ENABLEONFLYPDU)
#define F_ENABLEONFLYPDU    V_ENABLEONFLYPDU(1U)

#define S_ENABLEMINRCVWND    23
#define V_ENABLEMINRCVWND(x) ((x) << S_ENABLEMINRCVWND)
#define F_ENABLEMINRCVWND    V_ENABLEMINRCVWND(1U)

#define S_ENABLEMAXRCVWND    22
#define V_ENABLEMAXRCVWND(x) ((x) << S_ENABLEMAXRCVWND)
#define F_ENABLEMAXRCVWND    V_ENABLEMAXRCVWND(1U)

#define S_TXDATAACKRATEENABLE    21
#define V_TXDATAACKRATEENABLE(x) ((x) << S_TXDATAACKRATEENABLE)
#define F_TXDATAACKRATEENABLE    V_TXDATAACKRATEENABLE(1U)

#define S_TXDEFERENABLE    20
#define V_TXDEFERENABLE(x) ((x) << S_TXDEFERENABLE)
#define F_TXDEFERENABLE    V_TXDEFERENABLE(1U)

#define S_RXCONGESTIONMODE    19
#define V_RXCONGESTIONMODE(x) ((x) << S_RXCONGESTIONMODE)
#define F_RXCONGESTIONMODE    V_RXCONGESTIONMODE(1U)

#define S_HEARBEATONCEDACK    18
#define V_HEARBEATONCEDACK(x) ((x) << S_HEARBEATONCEDACK)
#define F_HEARBEATONCEDACK    V_HEARBEATONCEDACK(1U)

#define S_HEARBEATONCEHEAP    17
#define V_HEARBEATONCEHEAP(x) ((x) << S_HEARBEATONCEHEAP)
#define F_HEARBEATONCEHEAP    V_HEARBEATONCEHEAP(1U)

#define S_HEARBEATDACK    16
#define V_HEARBEATDACK(x) ((x) << S_HEARBEATDACK)
#define F_HEARBEATDACK    V_HEARBEATDACK(1U)

#define S_TXCONGESTIONMODE    15
#define V_TXCONGESTIONMODE(x) ((x) << S_TXCONGESTIONMODE)
#define F_TXCONGESTIONMODE    V_TXCONGESTIONMODE(1U)

#define S_ACCEPTLATESTRCVADV    14
#define V_ACCEPTLATESTRCVADV(x) ((x) << S_ACCEPTLATESTRCVADV)
#define F_ACCEPTLATESTRCVADV    V_ACCEPTLATESTRCVADV(1U)

#define S_DISABLESYNDATA    13
#define V_DISABLESYNDATA(x) ((x) << S_DISABLESYNDATA)
#define F_DISABLESYNDATA    V_DISABLESYNDATA(1U)

#define S_DISABLEWINDOWPSH    12
#define V_DISABLEWINDOWPSH(x) ((x) << S_DISABLEWINDOWPSH)
#define F_DISABLEWINDOWPSH    V_DISABLEWINDOWPSH(1U)

#define S_DISABLEFINOLDDATA    11
#define V_DISABLEFINOLDDATA(x) ((x) << S_DISABLEFINOLDDATA)
#define F_DISABLEFINOLDDATA    V_DISABLEFINOLDDATA(1U)

#define S_ENABLEFLMERROR    10
#define V_ENABLEFLMERROR(x) ((x) << S_ENABLEFLMERROR)
#define F_ENABLEFLMERROR    V_ENABLEFLMERROR(1U)

#define S_ENABLEOPTMTU    9
#define V_ENABLEOPTMTU(x) ((x) << S_ENABLEOPTMTU)
#define F_ENABLEOPTMTU    V_ENABLEOPTMTU(1U)

#define S_FILTERPEERFIN    8
#define V_FILTERPEERFIN(x) ((x) << S_FILTERPEERFIN)
#define F_FILTERPEERFIN    V_FILTERPEERFIN(1U)

#define S_ENABLEFEEDBACKSEND    7
#define V_ENABLEFEEDBACKSEND(x) ((x) << S_ENABLEFEEDBACKSEND)
#define F_ENABLEFEEDBACKSEND    V_ENABLEFEEDBACKSEND(1U)

#define S_ENABLERDMAERROR    6
#define V_ENABLERDMAERROR(x) ((x) << S_ENABLERDMAERROR)
#define F_ENABLERDMAERROR    V_ENABLERDMAERROR(1U)

#define S_ENABLEDDPFLOWCONTROL    5
#define V_ENABLEDDPFLOWCONTROL(x) ((x) << S_ENABLEDDPFLOWCONTROL)
#define F_ENABLEDDPFLOWCONTROL    V_ENABLEDDPFLOWCONTROL(1U)

#define S_DISABLEHELDFIN    4
#define V_DISABLEHELDFIN(x) ((x) << S_DISABLEHELDFIN)
#define F_DISABLEHELDFIN    V_DISABLEHELDFIN(1U)

#define S_ENABLEOFDOVLAN    3
#define V_ENABLEOFDOVLAN(x) ((x) << S_ENABLEOFDOVLAN)
#define F_ENABLEOFDOVLAN    V_ENABLEOFDOVLAN(1U)

#define S_DISABLETIMEWAIT    2
#define V_DISABLETIMEWAIT(x) ((x) << S_DISABLETIMEWAIT)
#define F_DISABLETIMEWAIT    V_DISABLETIMEWAIT(1U)

#define S_ENABLEVLANCHECK    1
#define V_ENABLEVLANCHECK(x) ((x) << S_ENABLEVLANCHECK)
#define F_ENABLEVLANCHECK    V_ENABLEVLANCHECK(1U)

#define S_TXDATAACKPAGEENABLE    0
#define V_TXDATAACKPAGEENABLE(x) ((x) << S_TXDATAACKPAGEENABLE)
#define F_TXDATAACKPAGEENABLE    V_TXDATAACKPAGEENABLE(1U)

#define S_ENABLEFILTERNAT    5
#define V_ENABLEFILTERNAT(x) ((x) << S_ENABLEFILTERNAT)
#define F_ENABLEFILTERNAT    V_ENABLEFILTERNAT(1U)

#define S_ENABLEFINCHECK    31
#define V_ENABLEFINCHECK(x) ((x) << S_ENABLEFINCHECK)
#define F_ENABLEFINCHECK    V_ENABLEFINCHECK(1U)

#define S_ENABLEMIBVFPLD    21
#define V_ENABLEMIBVFPLD(x) ((x) << S_ENABLEMIBVFPLD)
#define F_ENABLEMIBVFPLD    V_ENABLEMIBVFPLD(1U)

#define S_DISABLESEPPSHFLAG    4
#define V_DISABLESEPPSHFLAG(x) ((x) << S_DISABLESEPPSHFLAG)
#define F_DISABLESEPPSHFLAG    V_DISABLESEPPSHFLAG(1U)

#define A_TP_PC_CONFIG2 0x7d4c

#define S_ENABLEMTUVFMODE    31
#define V_ENABLEMTUVFMODE(x) ((x) << S_ENABLEMTUVFMODE)
#define F_ENABLEMTUVFMODE    V_ENABLEMTUVFMODE(1U)

#define S_ENABLEMIBVFMODE    30
#define V_ENABLEMIBVFMODE(x) ((x) << S_ENABLEMIBVFMODE)
#define F_ENABLEMIBVFMODE    V_ENABLEMIBVFMODE(1U)

#define S_DISABLELBKCHECK    29
#define V_DISABLELBKCHECK(x) ((x) << S_DISABLELBKCHECK)
#define F_DISABLELBKCHECK    V_DISABLELBKCHECK(1U)

#define S_ENABLEURGDDPOFF    28
#define V_ENABLEURGDDPOFF(x) ((x) << S_ENABLEURGDDPOFF)
#define F_ENABLEURGDDPOFF    V_ENABLEURGDDPOFF(1U)

#define S_ENABLEFILTERLPBK    27
#define V_ENABLEFILTERLPBK(x) ((x) << S_ENABLEFILTERLPBK)
#define F_ENABLEFILTERLPBK    V_ENABLEFILTERLPBK(1U)

#define S_DISABLETBLMMGR    26
#define V_DISABLETBLMMGR(x) ((x) << S_DISABLETBLMMGR)
#define F_DISABLETBLMMGR    V_DISABLETBLMMGR(1U)

#define S_CNGRECSNDNXT    25
#define V_CNGRECSNDNXT(x) ((x) << S_CNGRECSNDNXT)
#define F_CNGRECSNDNXT    V_CNGRECSNDNXT(1U)

#define S_ENABLELBKCHN    24
#define V_ENABLELBKCHN(x) ((x) << S_ENABLELBKCHN)
#define F_ENABLELBKCHN    V_ENABLELBKCHN(1U)

#define S_ENABLELROECN    23
#define V_ENABLELROECN(x) ((x) << S_ENABLELROECN)
#define F_ENABLELROECN    V_ENABLELROECN(1U)

#define S_ENABLEPCMDCHECK    22
#define V_ENABLEPCMDCHECK(x) ((x) << S_ENABLEPCMDCHECK)
#define F_ENABLEPCMDCHECK    V_ENABLEPCMDCHECK(1U)

#define S_ENABLEELBKAFULL    21
#define V_ENABLEELBKAFULL(x) ((x) << S_ENABLEELBKAFULL)
#define F_ENABLEELBKAFULL    V_ENABLEELBKAFULL(1U)

#define S_ENABLECLBKAFULL    20
#define V_ENABLECLBKAFULL(x) ((x) << S_ENABLECLBKAFULL)
#define F_ENABLECLBKAFULL    V_ENABLECLBKAFULL(1U)

#define S_ENABLEOESPIFULL    19
#define V_ENABLEOESPIFULL(x) ((x) << S_ENABLEOESPIFULL)
#define F_ENABLEOESPIFULL    V_ENABLEOESPIFULL(1U)

#define S_DISABLEHITCHECK    18
#define V_DISABLEHITCHECK(x) ((x) << S_DISABLEHITCHECK)
#define F_DISABLEHITCHECK    V_DISABLEHITCHECK(1U)

#define S_ENABLERSSERRCHECK    17
#define V_ENABLERSSERRCHECK(x) ((x) << S_ENABLERSSERRCHECK)
#define F_ENABLERSSERRCHECK    V_ENABLERSSERRCHECK(1U)

#define S_DISABLENEWPSHFLAG    16
#define V_DISABLENEWPSHFLAG(x) ((x) << S_DISABLENEWPSHFLAG)
#define F_DISABLENEWPSHFLAG    V_DISABLENEWPSHFLAG(1U)

#define S_ENABLERDDPRCVADVCLR    15
#define V_ENABLERDDPRCVADVCLR(x) ((x) << S_ENABLERDDPRCVADVCLR)
#define F_ENABLERDDPRCVADVCLR    V_ENABLERDDPRCVADVCLR(1U)

#define S_ENABLETXDATAARPMISS    14
#define V_ENABLETXDATAARPMISS(x) ((x) << S_ENABLETXDATAARPMISS)
#define F_ENABLETXDATAARPMISS    V_ENABLETXDATAARPMISS(1U)

#define S_ENABLEARPMISS    13
#define V_ENABLEARPMISS(x) ((x) << S_ENABLEARPMISS)
#define F_ENABLEARPMISS    V_ENABLEARPMISS(1U)

#define S_ENABLERSTPAWS    12
#define V_ENABLERSTPAWS(x) ((x) << S_ENABLERSTPAWS)
#define F_ENABLERSTPAWS    V_ENABLERSTPAWS(1U)

#define S_ENABLEIPV6RSS    11
#define V_ENABLEIPV6RSS(x) ((x) << S_ENABLEIPV6RSS)
#define F_ENABLEIPV6RSS    V_ENABLEIPV6RSS(1U)

#define S_ENABLENONOFDHYBRSS    10
#define V_ENABLENONOFDHYBRSS(x) ((x) << S_ENABLENONOFDHYBRSS)
#define F_ENABLENONOFDHYBRSS    V_ENABLENONOFDHYBRSS(1U)

#define S_ENABLEUDP4TUPRSS    9
#define V_ENABLEUDP4TUPRSS(x) ((x) << S_ENABLEUDP4TUPRSS)
#define F_ENABLEUDP4TUPRSS    V_ENABLEUDP4TUPRSS(1U)

#define S_ENABLERXPKTTMSTPRSS    8
#define V_ENABLERXPKTTMSTPRSS(x) ((x) << S_ENABLERXPKTTMSTPRSS)
#define F_ENABLERXPKTTMSTPRSS    V_ENABLERXPKTTMSTPRSS(1U)

#define S_ENABLEEPCMDAFULL    7
#define V_ENABLEEPCMDAFULL(x) ((x) << S_ENABLEEPCMDAFULL)
#define F_ENABLEEPCMDAFULL    V_ENABLEEPCMDAFULL(1U)

#define S_ENABLECPCMDAFULL    6
#define V_ENABLECPCMDAFULL(x) ((x) << S_ENABLECPCMDAFULL)
#define F_ENABLECPCMDAFULL    V_ENABLECPCMDAFULL(1U)

#define S_ENABLEEHDRAFULL    5
#define V_ENABLEEHDRAFULL(x) ((x) << S_ENABLEEHDRAFULL)
#define F_ENABLEEHDRAFULL    V_ENABLEEHDRAFULL(1U)

#define S_ENABLECHDRAFULL    4
#define V_ENABLECHDRAFULL(x) ((x) << S_ENABLECHDRAFULL)
#define F_ENABLECHDRAFULL    V_ENABLECHDRAFULL(1U)

#define S_ENABLEEMACAFULL    3
#define V_ENABLEEMACAFULL(x) ((x) << S_ENABLEEMACAFULL)
#define F_ENABLEEMACAFULL    V_ENABLEEMACAFULL(1U)

#define S_ENABLENONOFDTIDRSS    2
#define V_ENABLENONOFDTIDRSS(x) ((x) << S_ENABLENONOFDTIDRSS)
#define F_ENABLENONOFDTIDRSS    V_ENABLENONOFDTIDRSS(1U)

#define S_ENABLENONOFDTCBRSS    1
#define V_ENABLENONOFDTCBRSS(x) ((x) << S_ENABLENONOFDTCBRSS)
#define F_ENABLENONOFDTCBRSS    V_ENABLENONOFDTCBRSS(1U)

#define S_ENABLETNLOFDCLOSED    0
#define V_ENABLETNLOFDCLOSED(x) ((x) << S_ENABLETNLOFDCLOSED)
#define F_ENABLETNLOFDCLOSED    V_ENABLETNLOFDCLOSED(1U)

#define S_ENABLEFINDDPOFF    14
#define V_ENABLEFINDDPOFF(x) ((x) << S_ENABLEFINDDPOFF)
#define F_ENABLEFINDDPOFF    V_ENABLEFINDDPOFF(1U)

#define A_TP_TCP_BACKOFF_REG0 0x7d50

#define S_TIMERBACKOFFINDEX3    24
#define M_TIMERBACKOFFINDEX3    0xffU
#define V_TIMERBACKOFFINDEX3(x) ((x) << S_TIMERBACKOFFINDEX3)
#define G_TIMERBACKOFFINDEX3(x) (((x) >> S_TIMERBACKOFFINDEX3) & M_TIMERBACKOFFINDEX3)

#define S_TIMERBACKOFFINDEX2    16
#define M_TIMERBACKOFFINDEX2    0xffU
#define V_TIMERBACKOFFINDEX2(x) ((x) << S_TIMERBACKOFFINDEX2)
#define G_TIMERBACKOFFINDEX2(x) (((x) >> S_TIMERBACKOFFINDEX2) & M_TIMERBACKOFFINDEX2)

#define S_TIMERBACKOFFINDEX1    8
#define M_TIMERBACKOFFINDEX1    0xffU
#define V_TIMERBACKOFFINDEX1(x) ((x) << S_TIMERBACKOFFINDEX1)
#define G_TIMERBACKOFFINDEX1(x) (((x) >> S_TIMERBACKOFFINDEX1) & M_TIMERBACKOFFINDEX1)

#define S_TIMERBACKOFFINDEX0    0
#define M_TIMERBACKOFFINDEX0    0xffU
#define V_TIMERBACKOFFINDEX0(x) ((x) << S_TIMERBACKOFFINDEX0)
#define G_TIMERBACKOFFINDEX0(x) (((x) >> S_TIMERBACKOFFINDEX0) & M_TIMERBACKOFFINDEX0)

#define A_TP_TCP_BACKOFF_REG1 0x7d54

#define S_TIMERBACKOFFINDEX7    24
#define M_TIMERBACKOFFINDEX7    0xffU
#define V_TIMERBACKOFFINDEX7(x) ((x) << S_TIMERBACKOFFINDEX7)
#define G_TIMERBACKOFFINDEX7(x) (((x) >> S_TIMERBACKOFFINDEX7) & M_TIMERBACKOFFINDEX7)

#define S_TIMERBACKOFFINDEX6    16
#define M_TIMERBACKOFFINDEX6    0xffU
#define V_TIMERBACKOFFINDEX6(x) ((x) << S_TIMERBACKOFFINDEX6)
#define G_TIMERBACKOFFINDEX6(x) (((x) >> S_TIMERBACKOFFINDEX6) & M_TIMERBACKOFFINDEX6)

#define S_TIMERBACKOFFINDEX5    8
#define M_TIMERBACKOFFINDEX5    0xffU
#define V_TIMERBACKOFFINDEX5(x) ((x) << S_TIMERBACKOFFINDEX5)
#define G_TIMERBACKOFFINDEX5(x) (((x) >> S_TIMERBACKOFFINDEX5) & M_TIMERBACKOFFINDEX5)

#define S_TIMERBACKOFFINDEX4    0
#define M_TIMERBACKOFFINDEX4    0xffU
#define V_TIMERBACKOFFINDEX4(x) ((x) << S_TIMERBACKOFFINDEX4)
#define G_TIMERBACKOFFINDEX4(x) (((x) >> S_TIMERBACKOFFINDEX4) & M_TIMERBACKOFFINDEX4)

#define A_TP_TCP_BACKOFF_REG2 0x7d58

#define S_TIMERBACKOFFINDEX11    24
#define M_TIMERBACKOFFINDEX11    0xffU
#define V_TIMERBACKOFFINDEX11(x) ((x) << S_TIMERBACKOFFINDEX11)
#define G_TIMERBACKOFFINDEX11(x) (((x) >> S_TIMERBACKOFFINDEX11) & M_TIMERBACKOFFINDEX11)

#define S_TIMERBACKOFFINDEX10    16
#define M_TIMERBACKOFFINDEX10    0xffU
#define V_TIMERBACKOFFINDEX10(x) ((x) << S_TIMERBACKOFFINDEX10)
#define G_TIMERBACKOFFINDEX10(x) (((x) >> S_TIMERBACKOFFINDEX10) & M_TIMERBACKOFFINDEX10)

#define S_TIMERBACKOFFINDEX9    8
#define M_TIMERBACKOFFINDEX9    0xffU
#define V_TIMERBACKOFFINDEX9(x) ((x) << S_TIMERBACKOFFINDEX9)
#define G_TIMERBACKOFFINDEX9(x) (((x) >> S_TIMERBACKOFFINDEX9) & M_TIMERBACKOFFINDEX9)

#define S_TIMERBACKOFFINDEX8    0
#define M_TIMERBACKOFFINDEX8    0xffU
#define V_TIMERBACKOFFINDEX8(x) ((x) << S_TIMERBACKOFFINDEX8)
#define G_TIMERBACKOFFINDEX8(x) (((x) >> S_TIMERBACKOFFINDEX8) & M_TIMERBACKOFFINDEX8)

#define A_TP_TCP_BACKOFF_REG3 0x7d5c

#define S_TIMERBACKOFFINDEX15    24
#define M_TIMERBACKOFFINDEX15    0xffU
#define V_TIMERBACKOFFINDEX15(x) ((x) << S_TIMERBACKOFFINDEX15)
#define G_TIMERBACKOFFINDEX15(x) (((x) >> S_TIMERBACKOFFINDEX15) & M_TIMERBACKOFFINDEX15)

#define S_TIMERBACKOFFINDEX14    16
#define M_TIMERBACKOFFINDEX14    0xffU
#define V_TIMERBACKOFFINDEX14(x) ((x) << S_TIMERBACKOFFINDEX14)
#define G_TIMERBACKOFFINDEX14(x) (((x) >> S_TIMERBACKOFFINDEX14) & M_TIMERBACKOFFINDEX14)

#define S_TIMERBACKOFFINDEX13    8
#define M_TIMERBACKOFFINDEX13    0xffU
#define V_TIMERBACKOFFINDEX13(x) ((x) << S_TIMERBACKOFFINDEX13)
#define G_TIMERBACKOFFINDEX13(x) (((x) >> S_TIMERBACKOFFINDEX13) & M_TIMERBACKOFFINDEX13)

#define S_TIMERBACKOFFINDEX12    0
#define M_TIMERBACKOFFINDEX12    0xffU
#define V_TIMERBACKOFFINDEX12(x) ((x) << S_TIMERBACKOFFINDEX12)
#define G_TIMERBACKOFFINDEX12(x) (((x) >> S_TIMERBACKOFFINDEX12) & M_TIMERBACKOFFINDEX12)

#define A_TP_PARA_REG0 0x7d60

#define S_INITCWNDIDLE    27
#define V_INITCWNDIDLE(x) ((x) << S_INITCWNDIDLE)
#define F_INITCWNDIDLE    V_INITCWNDIDLE(1U)

#define S_INITCWND    24
#define M_INITCWND    0x7U
#define V_INITCWND(x) ((x) << S_INITCWND)
#define G_INITCWND(x) (((x) >> S_INITCWND) & M_INITCWND)

#define S_DUPACKTHRESH    20
#define M_DUPACKTHRESH    0xfU
#define V_DUPACKTHRESH(x) ((x) << S_DUPACKTHRESH)
#define G_DUPACKTHRESH(x) (((x) >> S_DUPACKTHRESH) & M_DUPACKTHRESH)

#define S_CPLERRENABLE    12
#define V_CPLERRENABLE(x) ((x) << S_CPLERRENABLE)
#define F_CPLERRENABLE    V_CPLERRENABLE(1U)

#define S_FASTTNLCNT    11
#define V_FASTTNLCNT(x) ((x) << S_FASTTNLCNT)
#define F_FASTTNLCNT    V_FASTTNLCNT(1U)

#define S_FASTTBLCNT    10
#define V_FASTTBLCNT(x) ((x) << S_FASTTBLCNT)
#define F_FASTTBLCNT    V_FASTTBLCNT(1U)

#define S_TPTCAMKEY    9
#define V_TPTCAMKEY(x) ((x) << S_TPTCAMKEY)
#define F_TPTCAMKEY    V_TPTCAMKEY(1U)

#define S_SWSMODE    8
#define V_SWSMODE(x) ((x) << S_SWSMODE)
#define F_SWSMODE    V_SWSMODE(1U)

#define S_TSMPMODE    6
#define M_TSMPMODE    0x3U
#define V_TSMPMODE(x) ((x) << S_TSMPMODE)
#define G_TSMPMODE(x) (((x) >> S_TSMPMODE) & M_TSMPMODE)

#define S_BYTECOUNTLIMIT    4
#define M_BYTECOUNTLIMIT    0x3U
#define V_BYTECOUNTLIMIT(x) ((x) << S_BYTECOUNTLIMIT)
#define G_BYTECOUNTLIMIT(x) (((x) >> S_BYTECOUNTLIMIT) & M_BYTECOUNTLIMIT)

#define S_SWSSHOVE    3
#define V_SWSSHOVE(x) ((x) << S_SWSSHOVE)
#define F_SWSSHOVE    V_SWSSHOVE(1U)

#define S_TBLTIMER    2
#define V_TBLTIMER(x) ((x) << S_TBLTIMER)
#define F_TBLTIMER    V_TBLTIMER(1U)

#define S_RXTPACE    1
#define V_RXTPACE(x) ((x) << S_RXTPACE)
#define F_RXTPACE    V_RXTPACE(1U)

#define S_SWSTIMER    0
#define V_SWSTIMER(x) ((x) << S_SWSTIMER)
#define F_SWSTIMER    V_SWSTIMER(1U)

#define S_LIMTXTHRESH    28
#define M_LIMTXTHRESH    0xfU
#define V_LIMTXTHRESH(x) ((x) << S_LIMTXTHRESH)
#define G_LIMTXTHRESH(x) (((x) >> S_LIMTXTHRESH) & M_LIMTXTHRESH)

#define S_CHNERRENABLE    14
#define V_CHNERRENABLE(x) ((x) << S_CHNERRENABLE)
#define F_CHNERRENABLE    V_CHNERRENABLE(1U)

#define S_SETTIMEENABLE    13
#define V_SETTIMEENABLE(x) ((x) << S_SETTIMEENABLE)
#define F_SETTIMEENABLE    V_SETTIMEENABLE(1U)

#define S_ECNCNGFIFO    19
#define V_ECNCNGFIFO(x) ((x) << S_ECNCNGFIFO)
#define F_ECNCNGFIFO    V_ECNCNGFIFO(1U)

#define S_ECNSYNACK    18
#define V_ECNSYNACK(x) ((x) << S_ECNSYNACK)
#define F_ECNSYNACK    V_ECNSYNACK(1U)

#define S_ECNTHRESH    16
#define M_ECNTHRESH    0x3U
#define V_ECNTHRESH(x) ((x) << S_ECNTHRESH)
#define G_ECNTHRESH(x) (((x) >> S_ECNTHRESH) & M_ECNTHRESH)

#define S_ECNMODE    15
#define V_ECNMODE(x) ((x) << S_ECNMODE)
#define F_ECNMODE    V_ECNMODE(1U)

#define S_ECNMODECWR    14
#define V_ECNMODECWR(x) ((x) << S_ECNMODECWR)
#define F_ECNMODECWR    V_ECNMODECWR(1U)

#define S_FORCESHOVE    10
#define V_FORCESHOVE(x) ((x) << S_FORCESHOVE)
#define F_FORCESHOVE    V_FORCESHOVE(1U)

#define A_TP_PARA_REG1 0x7d64

#define S_INITRWND    16
#define M_INITRWND    0xffffU
#define V_INITRWND(x) ((x) << S_INITRWND)
#define G_INITRWND(x) (((x) >> S_INITRWND) & M_INITRWND)

#define S_INITIALSSTHRESH    0
#define M_INITIALSSTHRESH    0xffffU
#define V_INITIALSSTHRESH(x) ((x) << S_INITIALSSTHRESH)
#define G_INITIALSSTHRESH(x) (((x) >> S_INITIALSSTHRESH) & M_INITIALSSTHRESH)

#define A_TP_PARA_REG2 0x7d68

#define S_MAXRXDATA    16
#define M_MAXRXDATA    0xffffU
#define V_MAXRXDATA(x) ((x) << S_MAXRXDATA)
#define G_MAXRXDATA(x) (((x) >> S_MAXRXDATA) & M_MAXRXDATA)

#define S_RXCOALESCESIZE    0
#define M_RXCOALESCESIZE    0xffffU
#define V_RXCOALESCESIZE(x) ((x) << S_RXCOALESCESIZE)
#define G_RXCOALESCESIZE(x) (((x) >> S_RXCOALESCESIZE) & M_RXCOALESCESIZE)

#define A_TP_PARA_REG3 0x7d6c

#define S_ENABLETNLCNGLPBK    31
#define V_ENABLETNLCNGLPBK(x) ((x) << S_ENABLETNLCNGLPBK)
#define F_ENABLETNLCNGLPBK    V_ENABLETNLCNGLPBK(1U)

#define S_ENABLETNLCNGFIFO    30
#define V_ENABLETNLCNGFIFO(x) ((x) << S_ENABLETNLCNGFIFO)
#define F_ENABLETNLCNGFIFO    V_ENABLETNLCNGFIFO(1U)

#define S_ENABLETNLCNGHDR    29
#define V_ENABLETNLCNGHDR(x) ((x) << S_ENABLETNLCNGHDR)
#define F_ENABLETNLCNGHDR    V_ENABLETNLCNGHDR(1U)

#define S_ENABLETNLCNGSGE    28
#define V_ENABLETNLCNGSGE(x) ((x) << S_ENABLETNLCNGSGE)
#define F_ENABLETNLCNGSGE    V_ENABLETNLCNGSGE(1U)

#define S_RXMACCHECK    