use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 3;
	ok( my $obj = String::Locale->new( {} ),
		q{my $obj = String::Locale->new({})}
	);
	ok( $obj = String::Locale->new(), q{$obj = String::Locale->new()} );
	isa_ok( $obj, 'String::Locale' );
};
subtest 'import' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale->new( {} ),
		q{my $obj = String::Locale->new({})}
	);
	can_ok( $obj, 'import' );
	eval { $obj->import( [], 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->import([], 'limos')}
	);
	eval { $obj->import( 'geras', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->import('geras', 'limos')}
	);
};
subtest 'new_stash' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale->new( {} ),
		q{my $obj = String::Locale->new({})}
	);
	can_ok( $obj, 'new_stash' );
};
done_testing();
