;;; locale-start.el --- startup.el customized for the ro locale.

;; Copyright (C) 1985-6, 1990, 1992-1995, 1997 Free Software Foundation, Inc.
;; Copyright (c) 1993-1997 Sun Microsystems, Inc.
;; Copyright (C) 1995 Board of Trustees, University of Illinois

;; Maintainer: XEmacs Development Team
;; Keywords: internal

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.


;;; Synched up with:  Not in FSF

;;; Commentary:

;;			This file, being an .el file, 
;;			must be in ISO 2022 encoding after installation.
;; @(#)locale-start.el.euc	1.7 97/03/06 13:43:21

;;; Code:

(defun startup-splash-frame-body ()
  (set-buffer-file-coding-system 'iso-8859-2)
  `("\n" ,(emacs-version) "\n"
    ,@(if (string-match "beta" emacs-version)
	  `( (face (bold blue) ( "This is an Experimental version of XEmacs. "
				 " Type " (key describe-beta)
				 " to see what this means.\n")))
	`( "\n"))
    (face bold-italic "\
Copyright (C) 1985-1997 Free Software Foundation, Inc.
Copyright (C) 1990-1994 Lucid, Inc.
Copyright (C) 1993-1997 Sun Microsystems, Inc. All Rights Reserved.
Copyright (C) 1994-1996 Board of Trustees, University of Illinois
Copyright (C) 1995-1996 Ben Wing\n\n")
    
    ,@(if (featurep 'sparcworks)
          `( "\
Sun ofer-B suport doar pentru pachetul de integrare WorkShop/XEmacs.-A
Toate celelalte pachete XEmacs v-B sunt oferite \"FR NICI O GARANIE\".-A
Pute-Bi obine detalii complete tastnd " (key describe-no-warranty)-A
" pentru a v-B referi la a doua versiune de GPL, datat iunie 1991.\n\n"x-A
,@(let ((lang (or (getenv "LC_ALL") (getenv "LC_MESSAGES") (getenv "LANG"))))
    (if (and
         (not (featurep 'mule))         ; Already got mule?
         (not (eq 'tty (console-type))) ; No Mule support on tty's yet
         lang                           ; Non-English locale?
         (not (string= lang "C"))
         (not (string-match "^en" lang))
         (locate-file "xemacs-mule" exec-path)) ; Comes with Sun WorkShop
        '( "\
Aceast-B versiune de XEmacs a fost construit cu suport numai pentru-A
limbile Latin-1.  Pentru a putea folosi alte limbi trebuie s-B rulai o-A
versiune de XEmacs Multi-Lingval (`Mule'), fie rul-Bnd comanda-A
`xemacs-mule', fie folosind resursa X `ESERVE*defaultXEmacsPath:
xemacs-mule' c-Bnd pornii XEmacs-ul din Sun WorkShop.\n\n"))))-A

        '("XEmacs-ul vine f-Br ABSOLUT NICI O GARANIE; tastai "-A
          (key describe-no-warranty) " pentru detalii complete.\n"))
    
    "Pute-Bi distribui copii de XEmacs; tastai "-A
    (key describe-copying) " pentru a afla condi-Biile.\n"-A
    "Tasta-Bi " (key describe-distribution)-A
    " pentru a afla cum pute-Bi obine cea mai recent versiune.\n\n"-A

    "Tasta-Bi " (key help-command)-A
    " sau folosi-Bi meniul " (face bold "Help") " pentru a obine ajutor.\n"-A
    "Tasta-Bi " (key advertised-undo)-A
    " pentru a anula schimb-Brile  (`C-' nseamn c trebuie s folosii tasta Control).\n"-A
    "Pentru a ie-Bi din XEmacs, tastai " (key save-buffers-kill-emacs) ".\n"-A
    "Tasta-Bi " (key help-with-tutorial)-A
    " pentru un tutorial despre folosirea XEmacs-ului.\n"
    "Tasta-Bi " (key info) " pentru a intra n Info, "-A
    "mod ce poate fi folosit pentru a citi documenta-Bia online.\n"-A
    (face (bold red) ( "\
Pentru sugestii -Bi rspunsuri la ntrebri frecvente, citii FAQ-ul XEmacs-ului.-A
\(Este -Bn meniul Help, dar putei tasta i " (key xemacs-local-faq) " [F mare!].\)"))))-A


(defun command-line-do-help (arg)
  "Print the XEmacs usage message and exit."
  (let ((standard-output 'external-debugging-output))
    (princ (concat "\n" (emacs-version) "\n\n"))
    (princ
     (if (featurep 'x)
	 (concat (emacs-name)
		 " accept-B toate opiunile n linia de comand ale Toolkit-ului X standard.\n"-A
		 "-Bn plus, urmtoarele")-A
       "Urm-Btoarele"))-A
    (princ " op-Biuni sunt acceptate:-A

  -t <dispozitiv>       A se folosi TTY <dispozitiv> -Bn loc de terminal pentru-A
			intrare -Bi ieire.  Implic opiunea -nw.-A
  -nw                   A se inhiba folosirea oric-Bror capabiliti de afiare-A
 			grafic-B: se va folosi terminalul curent.-A
  -batch                Execu-Bie neinteractiv (mesajele sunt trimise la-A
			stderr).
  -debug-init           A se intra -Bn depanator n cazul unei erori n-A
			fi-Bierul de iniializare.-A
  -unmapped             A nu se mapa cadrul ini-Bial.-A
  -no-site-file         A nu se -Bncrca fiierul de iniializare specific-A
			site-ului (site-start.el).
  -no-init-file         A nu se -Bncrca fiierul de iniializare specific-A
			utilizatorului (~/.emacs).
  -no-early-packages	A nu se procesa pachetele -Bncrcate devreme.-A
  -no-autoloads		A nu se -Bncrca la iniializare fiierele cu simboli-A
			globali (auto-autoloads). Implic-B i `-vanilla'.-A
  -vanilla		Echivalent cu -q -no-site-file -no-early-packages.
  -q                    La fel ca -no-init-file.
  -user <utilizator>    A se -Bncrca fiierul de iniializare al-A
			<utilizator>-ului, -Bn locul celui propriu.-A
  -u <utilizator>       La fel ca -user.\n")
   (let ((l command-switch-alist)
	  (insert (lambda (&rest x)
		    (princ "  ")
		    (let ((len 2))
		      (while x
			(princ (car x))
			(incf len (length (car x)))
			(setq x (cdr x)))
		      (when (>= len 24)
			(terpri) (setq len 0))
		      (while (< len 24)
			(princ " ")
			(incf len))))))
      (while l
        (let ((name (car (car l)))
              (fn (cdr (car l)))
	      doc arg cons)
	  (cond
	   ((and (symbolp fn) (get fn 'undocumented)) nil)
	   (t
	    (setq doc (documentation fn))
	    (if (member doc '(nil "")) (setq doc "(undocumented)"))
	    (cond ((string-match "\n\\(<.*>\\)\n?\\'" doc)
		   ;; Doc of the form "The frobber switch\n<arg1> <arg2>"
		   (setq arg (substring doc (match-beginning 1) (match-end 1))
			 doc (substring doc 0 (match-beginning 0))))
		  ((string-match "\n+\\'" doc)
		   (setq doc (substring doc 0 (match-beginning 0)))))
	    (if (and (setq cons (rassq fn command-switch-alist))
		     (not (eq cons (car l))))
		(setq doc (format "Same as %s." (car cons))))
	    (if arg
		(funcall insert name " " arg)
	      (funcall insert name))
	    (princ doc)
	    (terpri))))
        (setq l (cdr l))))
    (princ (concat "\
  +N <fi-Bier>             A se ncepe afiarea <fiier>-ului la linia N.-A

Orice altceva este considerat nume de fi-Bier i este ncrcat ntr-un-A
buffer -Bn vederea editrii.-A

" (emacs-name) " are manuale -Bi un tutorial online.  Tastai ^Ht (Control-h t) dup-A
pornirea XEmacs-ului pentru a lansa tutorialul.  Tasta-Bi ^Hi pentru a-A
citi documenta-Bia.  Tastai ^H^H^H (Control-h Control-h Control-h)-A
pentru a ob-Bine mai multe feluri de ajutor.\n")-A

    (kill-emacs 0))))


;;; locale-start.el ends here
