/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#include "cslarts.h"

// Implementation
CSL::StreamParams::StreamParams()
{
}

CSL::StreamParams::StreamParams(long _a_rate, long _a_channels, CSL::StreamFormat _a_format)
{
	this->rate = _a_rate;
	this->channels = _a_channels;
	this->format = _a_format;
}

CSL::StreamParams::StreamParams(Arts::Buffer& stream)
{
	readType(stream);
}

CSL::StreamParams::StreamParams(const CSL::StreamParams& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

CSL::StreamParams& CSL::StreamParams::operator=(const CSL::StreamParams& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void CSL::StreamParams::readType(Arts::Buffer& stream)
{
	rate = stream.readLong();
	channels = stream.readLong();
	format = (CSL::StreamFormat)stream.readLong();
}

void CSL::StreamParams::writeType(Arts::Buffer& stream) const
{
	stream.writeLong(rate);
	stream.writeLong(channels);
	stream.writeLong(format);
}

CSL::StreamStatus::StreamStatus()
{
}

CSL::StreamStatus::StreamStatus(long _a_streamID, const CSL::StreamParams& _a_streamParams, long _a_streamBufferUsed, long _a_streamBufferSize, const CSL::StreamParams& _a_artsParams, long _a_artsBufferUsed, long _a_artsBufferSize)
{
	this->streamID = _a_streamID;
	this->streamParams = _a_streamParams;
	this->streamBufferUsed = _a_streamBufferUsed;
	this->streamBufferSize = _a_streamBufferSize;
	this->artsParams = _a_artsParams;
	this->artsBufferUsed = _a_artsBufferUsed;
	this->artsBufferSize = _a_artsBufferSize;
}

CSL::StreamStatus::StreamStatus(Arts::Buffer& stream)
{
	readType(stream);
}

CSL::StreamStatus::StreamStatus(const CSL::StreamStatus& copyType) : Arts::Type(copyType)
{
	Arts::Buffer buffer;
	copyType.writeType(buffer);
	readType(buffer);
}

CSL::StreamStatus& CSL::StreamStatus::operator=(const CSL::StreamStatus& assignType)
{
	Arts::Buffer buffer;
	assignType.writeType(buffer);
	readType(buffer);
	return *this;
}

void CSL::StreamStatus::readType(Arts::Buffer& stream)
{
	streamID = stream.readLong();
	streamParams.readType(stream);
	streamBufferUsed = stream.readLong();
	streamBufferSize = stream.readLong();
	artsParams.readType(stream);
	artsBufferUsed = stream.readLong();
	artsBufferSize = stream.readLong();
}

void CSL::StreamStatus::writeType(Arts::Buffer& stream) const
{
	stream.writeLong(streamID);
	streamParams.writeType(stream);
	stream.writeLong(streamBufferUsed);
	stream.writeLong(streamBufferSize);
	artsParams.writeType(stream);
	stream.writeLong(artsBufferUsed);
	stream.writeLong(artsBufferSize);
}

CSL::Adapter_base *CSL::Adapter_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	CSL::Adapter_base *castedObject = (CSL::Adapter_base *)skel->_cast(CSL::Adapter_base::_IID);
	assert(castedObject);
	return castedObject;
}

CSL::Adapter_base *CSL::Adapter_base::_fromString(std::string objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return CSL::Adapter_base::_fromReference(r,true);
	return 0;
}

CSL::Adapter_base *CSL::Adapter_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	CSL::Adapter_base *result;
	result = (CSL::Adapter_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"CSL::Adapter");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new CSL::Adapter_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("CSL::Adapter")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> CSL::Adapter_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> CSL::Adapter_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *CSL::Adapter_base::_cast(unsigned long iid)
{
	if(iid == CSL::Adapter_base::_IID) return (CSL::Adapter_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

CSL::Adapter_stub::Adapter_stub()
{
	// constructor for subclasses (don't use directly)
}

CSL::Adapter_stub::Adapter_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

long CSL::Adapter_stub::open(const std::string& role, CSL::Direction dir)
{
	long methodID = _lookupMethodFast("method:000000056f70656e00000000056c6f6e6700000000020000000200000007737472696e670000000005726f6c6500000000000000000f43534c3a3a446972656374696f6e0000000004646972000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(role);
	request->writeLong(dir);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

bool CSL::Adapter_stub::setParams(long streamID, const CSL::StreamParams& params)
{
	long methodID = _lookupMethodFast("method:0000000a736574506172616d730000000008626f6f6c65616e000000000200000002000000056c6f6e67000000000973747265616d494400000000000000001243534c3a3a53747265616d506172616d730000000007706172616d73000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	params.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occured
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void CSL::Adapter_stub::setTitle(long streamID, const std::string& title)
{
	long methodID = _lookupMethodFast("method:000000097365745469746c650000000005766f6964000000000200000002000000056c6f6e67000000000973747265616d4944000000000000000007737472696e6700000000067469746c65000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->writeString(title);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void CSL::Adapter_stub::close(long streamID)
{
	long methodID = _lookupMethodFast("method:00000006636c6f73650000000005766f6964000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void CSL::Adapter_stub::write(long streamID, const std::vector<Arts::mcopbyte>& bytes)
{
	long methodID = _lookupMethodFast("method:0000000677726974650000000005766f6964000000000100000002000000056c6f6e67000000000973747265616d49440000000000000000062a6279746500000000066279746573000000000000000000");
	Arts::Buffer *request = Arts::Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	request->writeLong(streamID);
	request->writeByteSeq(bytes);
	request->patchLength();
	_connection->qSendBuffer(request);

}

std::vector<Arts::mcopbyte> * CSL::Adapter_stub::read(long streamID, long len)
{
	long methodID = _lookupMethodFast("method:000000057265616400000000062a62797465000000000200000002000000056c6f6e67000000000973747265616d49440000000000000000056c6f6e6700000000046c656e000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->writeLong(len);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	std::vector<Arts::mcopbyte> *_returnCode = new std::vector<Arts::mcopbyte>;
	if(!result) return _returnCode; // error occured
	result->readByteSeq(*_returnCode);
	delete result;
	return _returnCode;
}

void CSL::Adapter_stub::activate(long streamID)
{
	long methodID = _lookupMethodFast("method:0000000961637469766174650000000005766f6964000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void CSL::Adapter_stub::suspend(long streamID)
{
	long methodID = _lookupMethodFast("method:0000000873757370656e640000000005766f6964000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

bool CSL::Adapter_stub::active(long streamID)
{
	long methodID = _lookupMethodFast("method:000000076163746976650000000008626f6f6c65616e000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occured
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

CSL::StreamStatus CSL::Adapter_stub::status(long streamID)
{
	long methodID = _lookupMethodFast("method:00000007737461747573000000001243534c3a3a53747265616d537461747573000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return CSL::StreamStatus(); // error occured
	CSL::StreamStatus _returnCode(*result);
	delete result;
	return _returnCode;
}

void CSL::Adapter_stub::clearBuffer(long streamID)
{
	long methodID = _lookupMethodFast("method:0000000c636c6561724275666665720000000005766f6964000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long CSL::Adapter_stub::waitBufferLevel(long streamID, long bufferUsed)
{
	long methodID = _lookupMethodFast("method:00000010776169744275666665724c6576656c00000000056c6f6e67000000000200000002000000056c6f6e67000000000973747265616d49440000000000000000056c6f6e67000000000b62756666657255736564000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->writeLong(bufferUsed);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void CSL::Adapter_stub::waitPlayed(long streamID)
{
	long methodID = _lookupMethodFast("method:0000000b77616974506c617965640000000005766f6964000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::vector<std::string> * CSL::Adapter_stub::channelMaps(long streamID)
{
	long methodID = _lookupMethodFast("method:0000000c6368616e6e656c4d61707300000000082a737472696e67000000000200000001000000056c6f6e67000000000973747265616d4944000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	std::vector<std::string> *_returnCode = new std::vector<std::string>;
	if(!result) return _returnCode; // error occured
	result->readStringSeq(*_returnCode);
	delete result;
	return _returnCode;
}

bool CSL::Adapter_stub::setChannelMapping(long streamID, long channel, const std::string& mapping)
{
	long methodID = _lookupMethodFast("method:000000127365744368616e6e656c4d617070696e670000000008626f6f6c65616e000000000200000003000000056c6f6e67000000000973747265616d49440000000000000000056c6f6e6700000000086368616e6e656c000000000000000007737472696e6700000000086d617070696e67000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->writeLong(channel);
	request->writeString(mapping);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occured
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

std::string CSL::Adapter_stub::getChannelMapping(long streamID, long channel)
{
	long methodID = _lookupMethodFast("method:000000126765744368616e6e656c4d617070696e670000000007737472696e67000000000200000002000000056c6f6e67000000000973747265616d49440000000000000000056c6f6e6700000000086368616e6e656c000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(streamID);
	request->writeLong(channel);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occured
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

std::string CSL::Adapter_skel::_interfaceName()
{
	return "CSL::Adapter";
}

bool CSL::Adapter_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "CSL::Adapter") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string CSL::Adapter_skel::_interfaceNameSkel()
{
	return "CSL::Adapter";
}

// open
static void _dispatch_CSL_Adapter_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	std::string role;
	request->readString(role);
	CSL::Direction dir = (CSL::Direction)request->readLong();
	result->writeLong(((CSL::Adapter_skel *)object)->open(role,dir));
}

// setParams
static void _dispatch_CSL_Adapter_01(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	CSL::StreamParams params(*request);
	result->writeBool(((CSL::Adapter_skel *)object)->setParams(streamID,params));
}

// setTitle
static void _dispatch_CSL_Adapter_02(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	std::string title;
	request->readString(title);
	((CSL::Adapter_skel *)object)->setTitle(streamID,title);
}

// close
static void _dispatch_CSL_Adapter_03(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	((CSL::Adapter_skel *)object)->close(streamID);
}

// write
static void _dispatch_CSL_Adapter_04(void *object, Arts::Buffer *request)
{
	long streamID = request->readLong();
	std::vector<Arts::mcopbyte> bytes;
	request->readByteSeq(bytes);
	((CSL::Adapter_skel *)object)->write(streamID,bytes);
}

// read
static void _dispatch_CSL_Adapter_05(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	long len = request->readLong();
	std::vector<Arts::mcopbyte> *_returnCode = ((CSL::Adapter_skel *)object)->read(streamID,len);
	result->writeByteSeq(*_returnCode);
	delete _returnCode;
}

// activate
static void _dispatch_CSL_Adapter_06(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	((CSL::Adapter_skel *)object)->activate(streamID);
}

// suspend
static void _dispatch_CSL_Adapter_07(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	((CSL::Adapter_skel *)object)->suspend(streamID);
}

// active
static void _dispatch_CSL_Adapter_08(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	result->writeBool(((CSL::Adapter_skel *)object)->active(streamID));
}

// status
static void _dispatch_CSL_Adapter_09(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	CSL::StreamStatus _returnCode = ((CSL::Adapter_skel *)object)->status(streamID);
	_returnCode.writeType(*result);
}

// clearBuffer
static void _dispatch_CSL_Adapter_10(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	((CSL::Adapter_skel *)object)->clearBuffer(streamID);
}

// waitBufferLevel
static void _dispatch_CSL_Adapter_11(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	long bufferUsed = request->readLong();
	result->writeLong(((CSL::Adapter_skel *)object)->waitBufferLevel(streamID,bufferUsed));
}

// waitPlayed
static void _dispatch_CSL_Adapter_12(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long streamID = request->readLong();
	((CSL::Adapter_skel *)object)->waitPlayed(streamID);
}

// channelMaps
static void _dispatch_CSL_Adapter_13(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	std::vector<std::string> *_returnCode = ((CSL::Adapter_skel *)object)->channelMaps(streamID);
	result->writeStringSeq(*_returnCode);
	delete _returnCode;
}

// setChannelMapping
static void _dispatch_CSL_Adapter_14(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	long channel = request->readLong();
	std::string mapping;
	request->readString(mapping);
	result->writeBool(((CSL::Adapter_skel *)object)->setChannelMapping(streamID,channel,mapping));
}

// getChannelMapping
static void _dispatch_CSL_Adapter_15(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long streamID = request->readLong();
	long channel = request->readLong();
	result->writeString(((CSL::Adapter_skel *)object)->getChannelMapping(streamID,channel));
}

void CSL::Adapter_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000056f70656e00000000056c6f6e6700000000020000000200"
        "000007737472696e670000000005726f6c6500000000000000000f43534c3a3a44"
        "6972656374696f6e00000000046469720000000000000000000000000a73657450"
        "6172616d730000000008626f6f6c65616e000000000200000002000000056c6f6e"
        "67000000000973747265616d494400000000000000001243534c3a3a5374726561"
        "6d506172616d730000000007706172616d73000000000000000000000000097365"
        "745469746c650000000005766f6964000000000200000002000000056c6f6e6700"
        "0000000973747265616d4944000000000000000007737472696e67000000000674"
        "69746c6500000000000000000000000006636c6f73650000000005766f69640000"
        "00000200000001000000056c6f6e67000000000973747265616d49440000000000"
        "000000000000000677726974650000000005766f69640000000001000000020000"
        "00056c6f6e67000000000973747265616d49440000000000000000062a62797465"
        "00000000066279746573000000000000000000000000057265616400000000062a"
        "62797465000000000200000002000000056c6f6e67000000000973747265616d49"
        "440000000000000000056c6f6e6700000000046c656e0000000000000000000000"
        "000961637469766174650000000005766f6964000000000200000001000000056c"
        "6f6e67000000000973747265616d49440000000000000000000000000873757370"
        "656e640000000005766f6964000000000200000001000000056c6f6e6700000000"
        "0973747265616d4944000000000000000000000000076163746976650000000008"
        "626f6f6c65616e000000000200000001000000056c6f6e67000000000973747265"
        "616d494400000000000000000000000007737461747573000000001243534c3a3a"
        "53747265616d537461747573000000000200000001000000056c6f6e6700000000"
        "0973747265616d49440000000000000000000000000c636c656172427566666572"
        "0000000005766f6964000000000200000001000000056c6f6e6700000000097374"
        "7265616d494400000000000000000000000010776169744275666665724c657665"
        "6c00000000056c6f6e67000000000200000002000000056c6f6e67000000000973"
        "747265616d49440000000000000000056c6f6e67000000000b6275666665725573"
        "65640000000000000000000000000b77616974506c617965640000000005766f69"
        "64000000000200000001000000056c6f6e67000000000973747265616d49440000"
        "000000000000000000000c6368616e6e656c4d61707300000000082a737472696e"
        "67000000000200000001000000056c6f6e67000000000973747265616d49440000"
        "00000000000000000000127365744368616e6e656c4d617070696e670000000008"
        "626f6f6c65616e000000000200000003000000056c6f6e67000000000973747265"
        "616d49440000000000000000056c6f6e6700000000086368616e6e656c00000000"
        "0000000007737472696e6700000000086d617070696e6700000000000000000000"
        "0000126765744368616e6e656c4d617070696e670000000007737472696e670000"
        "00000200000002000000056c6f6e67000000000973747265616d49440000000000"
        "000000056c6f6e6700000000086368616e6e656c000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_CSL_Adapter_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_08,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_09,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_10,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_11,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_12,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_13,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_14,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Adapter_15,this,Arts::MethodDef(m));
}

CSL::Adapter_skel::Adapter_skel()
{
}

Arts::Object_base* CSL::Adapter::_Creator() {
	return CSL::Adapter_base::_create();
}

unsigned long CSL::Adapter_base::_IID = Arts::MCOPUtils::makeIID("CSL::Adapter");

CSL::Stream_base *CSL::Stream_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	CSL::Stream_base *castedObject = (CSL::Stream_base *)skel->_cast(CSL::Stream_base::_IID);
	assert(castedObject);
	return castedObject;
}

CSL::Stream_base *CSL::Stream_base::_fromString(std::string objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return CSL::Stream_base::_fromReference(r,true);
	return 0;
}

CSL::Stream_base *CSL::Stream_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	CSL::Stream_base *result;
	result = (CSL::Stream_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"CSL::Stream");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new CSL::Stream_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("CSL::Stream")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> CSL::Stream_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> CSL::Stream_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *CSL::Stream_base::_cast(unsigned long iid)
{
	if(iid == CSL::Stream_base::_IID) return (CSL::Stream_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

CSL::Stream_stub::Stream_stub()
{
	// constructor for subclasses (don't use directly)
}

CSL::Stream_stub::Stream_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void CSL::Stream_stub::clearBuffer()
{
	long methodID = _lookupMethodFast("method:0000000c636c6561724275666665720000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

void CSL::Stream_stub::close()
{
	long methodID = _lookupMethodFast("method:00000006636c6f73650000000005766f696400000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long CSL::Stream_stub::ID()
{
	long methodID = _lookupMethodFast("method:000000085f6765745f494400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

CSL::Direction CSL::Stream_stub::direction()
{
	long methodID = _lookupMethodFast("method:0000000f5f6765745f646972656374696f6e000000000f43534c3a3a446972656374696f6e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return (CSL::Direction)0; // error occured
	CSL::Direction returnCode = (CSL::Direction)result->readLong();
	delete result;
	return returnCode;
}

std::string CSL::Stream_stub::role()
{
	long methodID = _lookupMethodFast("method:0000000a5f6765745f726f6c650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occured
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

std::string CSL::Stream_stub::title()
{
	long methodID = _lookupMethodFast("method:0000000b5f6765745f7469746c650000000007737472696e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return""; // error occured
	std::string returnCode;
	result->readString(returnCode);
	delete result;
	return returnCode;
}

void CSL::Stream_stub::title(const std::string& newValue)
{
	long methodID = _lookupMethodFast("method:0000000b5f7365745f7469746c650000000005766f696400000000020000000100000007737472696e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeString(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

long CSL::Stream_stub::bufferUsed()
{
	long methodID = _lookupMethodFast("method:000000105f6765745f6275666665725573656400000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

long CSL::Stream_stub::bufferSize()
{
	long methodID = _lookupMethodFast("method:000000105f6765745f62756666657253697a6500000000056c6f6e6700000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return 0; // error occured
	long returnCode = result->readLong();
	delete result;
	return returnCode;
}

void CSL::Stream_stub::bufferSize(long newValue)
{
	long methodID = _lookupMethodFast("method:000000105f7365745f62756666657253697a650000000005766f6964000000000200000001000000056c6f6e6700000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

CSL::StreamParams CSL::Stream_stub::params()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f706172616d73000000001243534c3a3a53747265616d506172616d7300000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return CSL::StreamParams(); // error occured
	CSL::StreamParams _returnCode(*result);
	delete result;
	return _returnCode;
}

void CSL::Stream_stub::params(const CSL::StreamParams& newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f706172616d730000000005766f69640000000002000000010000001243534c3a3a53747265616d506172616d7300000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	newValue.writeType(*request);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

bool CSL::Stream_stub::active()
{
	long methodID = _lookupMethodFast("method:0000000c5f6765745f6163746976650000000008626f6f6c65616e00000000020000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(!result) return false; // error occured
	bool returnCode = result->readBool();
	delete result;
	return returnCode;
}

void CSL::Stream_stub::active(bool newValue)
{
	long methodID = _lookupMethodFast("method:0000000c5f7365745f6163746976650000000005766f696400000000020000000100000008626f6f6c65616e00000000096e657756616c7565000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeBool(newValue);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	if(result) delete result;
}

std::string CSL::Stream_skel::_interfaceName()
{
	return "CSL::Stream";
}

bool CSL::Stream_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "CSL::Stream") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string CSL::Stream_skel::_interfaceNameSkel()
{
	return "CSL::Stream";
}

// clearBuffer
static void _dispatch_CSL_Stream_00(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((CSL::Stream_skel *)object)->clearBuffer();
}

// close
static void _dispatch_CSL_Stream_01(void *object, Arts::Buffer *, Arts::Buffer *)
{
	((CSL::Stream_skel *)object)->close();
}

// _get_ID
static void _dispatch_CSL_Stream_02(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((CSL::Stream_skel *)object)->ID());
}

// _get_direction
static void _dispatch_CSL_Stream_03(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((CSL::Stream_skel *)object)->direction());
}

// _get_role
static void _dispatch_CSL_Stream_04(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((CSL::Stream_skel *)object)->role());
}

// _get_title
static void _dispatch_CSL_Stream_05(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeString(((CSL::Stream_skel *)object)->title());
}

// _set_title
static void _dispatch_CSL_Stream_06(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	std::string newValue;
	request->readString(newValue);
	((CSL::Stream_skel *)object)->title(newValue);
}

// _get_bufferUsed
static void _dispatch_CSL_Stream_07(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((CSL::Stream_skel *)object)->bufferUsed());
}

// _get_bufferSize
static void _dispatch_CSL_Stream_08(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeLong(((CSL::Stream_skel *)object)->bufferSize());
}

// _set_bufferSize
static void _dispatch_CSL_Stream_09(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	long newValue = request->readLong();
	((CSL::Stream_skel *)object)->bufferSize(newValue);
}

// _get_params
static void _dispatch_CSL_Stream_10(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	CSL::StreamParams _returnCode = ((CSL::Stream_skel *)object)->params();
	_returnCode.writeType(*result);
}

// _set_params
static void _dispatch_CSL_Stream_11(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	CSL::StreamParams newValue(*request);
	((CSL::Stream_skel *)object)->params(newValue);
}

// _get_active
static void _dispatch_CSL_Stream_12(void *object, Arts::Buffer *, Arts::Buffer *result)
{
	result->writeBool(((CSL::Stream_skel *)object)->active());
}

// _set_active
static void _dispatch_CSL_Stream_13(void *object, Arts::Buffer *request, Arts::Buffer *)
{
	bool newValue = request->readBool();
	((CSL::Stream_skel *)object)->active(newValue);
}

void CSL::Stream_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000c636c6561724275666665720000000005766f6964000000"
        "0002000000000000000000000006636c6f73650000000005766f69640000000002"
        "0000000000000000000000085f6765745f494400000000056c6f6e670000000002"
        "00000000000000000000000f5f6765745f646972656374696f6e000000000f4353"
        "4c3a3a446972656374696f6e000000000200000000000000000000000a5f676574"
        "5f726f6c650000000007737472696e67000000000200000000000000000000000b"
        "5f6765745f7469746c650000000007737472696e67000000000200000000000000"
        "000000000b5f7365745f7469746c650000000005766f6964000000000200000001"
        "00000007737472696e6700000000096e657756616c756500000000000000000000"
        "0000105f6765745f6275666665725573656400000000056c6f6e67000000000200"
        "00000000000000000000105f6765745f62756666657253697a6500000000056c6f"
        "6e6700000000020000000000000000000000105f7365745f62756666657253697a"
        "650000000005766f6964000000000200000001000000056c6f6e6700000000096e"
        "657756616c75650000000000000000000000000c5f6765745f706172616d730000"
        "00001243534c3a3a53747265616d506172616d7300000000020000000000000000"
        "0000000c5f7365745f706172616d730000000005766f6964000000000200000001"
        "0000001243534c3a3a53747265616d506172616d7300000000096e657756616c75"
        "650000000000000000000000000c5f6765745f6163746976650000000008626f6f"
        "6c65616e000000000200000000000000000000000c5f7365745f61637469766500"
        "00000005766f696400000000020000000100000008626f6f6c65616e0000000009"
        "6e657756616c7565000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_CSL_Stream_00,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_01,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_02,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_03,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_04,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_05,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_06,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_07,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_08,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_09,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_10,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_11,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_12,this,Arts::MethodDef(m));
	_addMethod(_dispatch_CSL_Stream_13,this,Arts::MethodDef(m));
	Arts::SynthModule_skel::_buildMethodTable();
}

CSL::Stream_skel::Stream_skel()
{
}

Arts::Object_base* CSL::Stream::_Creator() {
	return CSL::Stream_base::_create();
}

unsigned long CSL::Stream_base::_IID = Arts::MCOPUtils::makeIID("CSL::Stream");

CSL::PlayStream_base *CSL::PlayStream_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	CSL::PlayStream_base *castedObject = (CSL::PlayStream_base *)skel->_cast(CSL::PlayStream_base::_IID);
	assert(castedObject);
	return castedObject;
}

CSL::PlayStream_base *CSL::PlayStream_base::_fromString(std::string objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return CSL::PlayStream_base::_fromReference(r,true);
	return 0;
}

CSL::PlayStream_base *CSL::PlayStream_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	CSL::PlayStream_base *result;
	result = (CSL::PlayStream_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"CSL::PlayStream");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new CSL::PlayStream_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("CSL::PlayStream")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> CSL::PlayStream_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	return ret;
}
std::vector<std::string> CSL::PlayStream_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	ret.push_back("left");
	ret.push_back("right");
	return ret;
}

void *CSL::PlayStream_base::_cast(unsigned long iid)
{
	if(iid == CSL::PlayStream_base::_IID) return (CSL::PlayStream_base *)this;
	if(iid == CSL::Stream_base::_IID) return (CSL::Stream_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

CSL::PlayStream_stub::PlayStream_stub()
{
	// constructor for subclasses (don't use directly)
}

CSL::PlayStream_stub::PlayStream_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

void CSL::PlayStream_stub::write(const std::vector<Arts::mcopbyte>& bytes)
{
	long methodID = _lookupMethodFast("method:0000000677726974650000000005766f6964000000000100000001000000062a6279746500000000066279746573000000000000000000");
	Arts::Buffer *request = Arts::Dispatcher::the()->createOnewayRequest(_objectID,methodID);
	request->writeByteSeq(bytes);
	request->patchLength();
	_connection->qSendBuffer(request);

}

std::string CSL::PlayStream_skel::_interfaceName()
{
	return "CSL::PlayStream";
}

bool CSL::PlayStream_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "CSL::PlayStream") return true;
	if (interfacename == "CSL::Stream") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string CSL::PlayStream_skel::_interfaceNameSkel()
{
	return "CSL::PlayStream";
}

// write
static void _dispatch_CSL_PlayStream_00(void *object, Arts::Buffer *request)
{
	std::vector<Arts::mcopbyte> bytes;
	request->readByteSeq(bytes);
	((CSL::PlayStream_skel *)object)->write(bytes);
}

void CSL::PlayStream_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:0000000677726974650000000005766f6964000000000100000001"
        "000000062a6279746500000000066279746573000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_CSL_PlayStream_00,this,Arts::MethodDef(m));
	CSL::Stream_skel::_buildMethodTable();
}

CSL::PlayStream_skel::PlayStream_skel()
{
	_initStream("left",&left,74);
	_initStream("right",&right,74);
}

Arts::Object_base* CSL::PlayStream::_Creator() {
	return CSL::PlayStream_base::_create();
}

unsigned long CSL::PlayStream_base::_IID = Arts::MCOPUtils::makeIID("CSL::PlayStream");

CSL::RecordStream_base *CSL::RecordStream_base::_create(const std::string& subClass)
{
	Arts::Object_skel *skel = Arts::ObjectManager::the()->create(subClass);
	assert(skel);
	CSL::RecordStream_base *castedObject = (CSL::RecordStream_base *)skel->_cast(CSL::RecordStream_base::_IID);
	assert(castedObject);
	return castedObject;
}

CSL::RecordStream_base *CSL::RecordStream_base::_fromString(std::string objectref)
{
	Arts::ObjectReference r;

	if(Arts::Dispatcher::the()->stringToObjectReference(r,objectref))
		return CSL::RecordStream_base::_fromReference(r,true);
	return 0;
}

CSL::RecordStream_base *CSL::RecordStream_base::_fromReference(Arts::ObjectReference r, bool needcopy)
{
	CSL::RecordStream_base *result;
	result = (CSL::RecordStream_base *)Arts::Dispatcher::the()->connectObjectLocal(r,"CSL::RecordStream");
	if(result)
	{
		if(!needcopy)
			result->_cancelCopyRemote();
	}
	else
	{
		Arts::Connection *conn = Arts::Dispatcher::the()->connectObjectRemote(r);
		if(conn)
		{
			result = new CSL::RecordStream_stub(conn,r.objectID);
			if(needcopy) result->_copyRemote();
			result->_useRemote();
			if (!result->_isCompatibleWith("CSL::RecordStream")) {
				result->_release();
				return 0;
			}
		}
	}
	return result;
}

std::vector<std::string> CSL::RecordStream_base::_defaultPortsIn() const {
	std::vector<std::string> ret;
	ret.push_back("left");
	ret.push_back("right");
	return ret;
}
std::vector<std::string> CSL::RecordStream_base::_defaultPortsOut() const {
	std::vector<std::string> ret;
	return ret;
}

void *CSL::RecordStream_base::_cast(unsigned long iid)
{
	if(iid == CSL::RecordStream_base::_IID) return (CSL::RecordStream_base *)this;
	if(iid == CSL::Stream_base::_IID) return (CSL::Stream_base *)this;
	if(iid == Arts::SynthModule_base::_IID) return (Arts::SynthModule_base *)this;
	if(iid == Arts::Object_base::_IID) return (Arts::Object_base *)this;
	return 0;
}

CSL::RecordStream_stub::RecordStream_stub()
{
	// constructor for subclasses (don't use directly)
}

CSL::RecordStream_stub::RecordStream_stub(Arts::Connection *connection, long objectID)
	: Arts::Object_stub(connection, objectID)
{
	// constructor to create a stub for an object
}

std::vector<Arts::mcopbyte> * CSL::RecordStream_stub::read(long len)
{
	long methodID = _lookupMethodFast("method:000000057265616400000000062a62797465000000000200000001000000056c6f6e6700000000046c656e000000000000000000");
	long requestID;
	Arts::Buffer *request, *result;
	request = Arts::Dispatcher::the()->createRequest(requestID,_objectID,methodID);
	request->writeLong(len);
	request->patchLength();
	_connection->qSendBuffer(request);

	result = Arts::Dispatcher::the()->waitForResult(requestID,_connection);
	std::vector<Arts::mcopbyte> *_returnCode = new std::vector<Arts::mcopbyte>;
	if(!result) return _returnCode; // error occured
	result->readByteSeq(*_returnCode);
	delete result;
	return _returnCode;
}

std::string CSL::RecordStream_skel::_interfaceName()
{
	return "CSL::RecordStream";
}

bool CSL::RecordStream_skel::_isCompatibleWith(const std::string& interfacename)
{
	if (interfacename == "CSL::RecordStream") return true;
	if (interfacename == "CSL::Stream") return true;
	if (interfacename == "Arts::SynthModule") return true;
	if (interfacename == "Arts::Object") return true;
	return false;
}

std::string CSL::RecordStream_skel::_interfaceNameSkel()
{
	return "CSL::RecordStream";
}

// read
static void _dispatch_CSL_RecordStream_00(void *object, Arts::Buffer *request, Arts::Buffer *result)
{
	long len = request->readLong();
	std::vector<Arts::mcopbyte> *_returnCode = ((CSL::RecordStream_skel *)object)->read(len);
	result->writeByteSeq(*_returnCode);
	delete _returnCode;
}

void CSL::RecordStream_skel::_buildMethodTable()
{
	Arts::Buffer m;
	m.fromString(
        "MethodTable:000000057265616400000000062a62797465000000000200000001"
        "000000056c6f6e6700000000046c656e000000000000000000",
		"MethodTable"
	);
	_addMethod(_dispatch_CSL_RecordStream_00,this,Arts::MethodDef(m));
	CSL::Stream_skel::_buildMethodTable();
}

CSL::RecordStream_skel::RecordStream_skel()
{
	_initStream("left",&left,73);
	_initStream("right",&right,73);
}

Arts::Object_base* CSL::RecordStream::_Creator() {
	return CSL::RecordStream_base::_create();
}

unsigned long CSL::RecordStream_base::_IID = Arts::MCOPUtils::makeIID("CSL::RecordStream");

static Arts::IDLFileReg IDLFileReg_cslarts("cslarts",
    "IDLFile:0000000100000000020000000f43534c3a3a446972656374696f6e00000000"
    "0200000009646972496e7075740000000000000000000000000a6469724f7574707574"
    "000000000100000000000000000000001243534c3a3a53747265616d466f726d617400"
    "000000100000000a73665f73697a655f380000000008000000000000000b73665f7369"
    "7a655f31360000000010000000000000000b73665f73697a655f333200000000200000"
    "00000000000d73665f73697a655f6d61736b00000000ff000000000000000d73665f65"
    "6e6469616e5f6c650000000100000000000000000d73665f656e6469616e5f62650000"
    "000200000000000000000f73665f656e6469616e5f6d61736b0000000f000000000000"
    "00001a73665f656e636f64696e675f6c696e6561725f7369676e656400000010000000"
    "00000000001c73665f656e636f64696e675f6c696e6561725f756e7369676e65640000"
    "002000000000000000001273665f656e636f64696e675f666c6f617400000030000000"
    "00000000001173665f656e636f64696e675f6d61736b000000f0000000000000000006"
    "73665f75380000002008000000000000000a73665f7331365f6c650000001110000000"
    "000000000a73665f7331365f62650000001210000000000000000c73665f666c6f6174"
    "5f6c650000003120000000000000000c73665f666c6f61745f62650000003220000000"
    "0000000000000000020000001243534c3a3a53747265616d506172616d730000000003"
    "000000056c6f6e670000000005726174650000000000000000056c6f6e670000000009"
    "6368616e6e656c7300000000000000001243534c3a3a53747265616d466f726d617400"
    "00000007666f726d61740000000000000000000000001243534c3a3a53747265616d53"
    "74617475730000000007000000056c6f6e67000000000973747265616d494400000000"
    "000000001243534c3a3a53747265616d506172616d73000000000d73747265616d5061"
    "72616d730000000000000000056c6f6e67000000001173747265616d42756666657255"
    "7365640000000000000000056c6f6e67000000001173747265616d4275666665725369"
    "7a6500000000000000001243534c3a3a53747265616d506172616d73000000000b6172"
    "7473506172616d730000000000000000056c6f6e67000000000f617274734275666665"
    "72557365640000000000000000056c6f6e67000000000f617274734275666665725369"
    "7a65000000000000000000000000040000000d43534c3a3a4164617074657200000000"
    "0000000010000000056f70656e00000000056c6f6e6700000000020000000200000007"
    "737472696e670000000005726f6c6500000000000000000f43534c3a3a446972656374"
    "696f6e00000000046469720000000000000000000000000a736574506172616d730000"
    "000008626f6f6c65616e000000000200000002000000056c6f6e670000000009737472"
    "65616d494400000000000000001243534c3a3a53747265616d506172616d7300000000"
    "07706172616d73000000000000000000000000097365745469746c650000000005766f"
    "6964000000000200000002000000056c6f6e67000000000973747265616d4944000000"
    "000000000007737472696e6700000000067469746c6500000000000000000000000006"
    "636c6f73650000000005766f6964000000000200000001000000056c6f6e6700000000"
    "0973747265616d49440000000000000000000000000677726974650000000005766f69"
    "64000000000100000002000000056c6f6e67000000000973747265616d494400000000"
    "00000000062a6279746500000000066279746573000000000000000000000000057265"
    "616400000000062a62797465000000000200000002000000056c6f6e67000000000973"
    "747265616d49440000000000000000056c6f6e6700000000046c656e00000000000000"
    "00000000000961637469766174650000000005766f6964000000000200000001000000"
    "056c6f6e67000000000973747265616d49440000000000000000000000000873757370"
    "656e640000000005766f6964000000000200000001000000056c6f6e67000000000973"
    "747265616d4944000000000000000000000000076163746976650000000008626f6f6c"
    "65616e000000000200000001000000056c6f6e67000000000973747265616d49440000"
    "0000000000000000000007737461747573000000001243534c3a3a53747265616d5374"
    "61747573000000000200000001000000056c6f6e67000000000973747265616d494400"
    "00000000000000000000000c636c6561724275666665720000000005766f6964000000"
    "000200000001000000056c6f6e67000000000973747265616d49440000000000000000"
    "0000000010776169744275666665724c6576656c00000000056c6f6e67000000000200"
    "000002000000056c6f6e67000000000973747265616d49440000000000000000056c6f"
    "6e67000000000b627566666572557365640000000000000000000000000b7761697450"
    "6c617965640000000005766f6964000000000200000001000000056c6f6e6700000000"
    "0973747265616d49440000000000000000000000000c6368616e6e656c4d6170730000"
    "0000082a737472696e67000000000200000001000000056c6f6e670000000009737472"
    "65616d4944000000000000000000000000127365744368616e6e656c4d617070696e67"
    "0000000008626f6f6c65616e000000000200000003000000056c6f6e67000000000973"
    "747265616d49440000000000000000056c6f6e6700000000086368616e6e656c000000"
    "000000000007737472696e6700000000086d617070696e670000000000000000000000"
    "00126765744368616e6e656c4d617070696e670000000007737472696e670000000002"
    "00000002000000056c6f6e67000000000973747265616d49440000000000000000056c"
    "6f6e6700000000086368616e6e656c0000000000000000000000000000000000000000"
    "000000000c43534c3a3a53747265616d000000000100000012417274733a3a53796e74"
    "684d6f64756c6500000000020000000c636c6561724275666665720000000005766f69"
    "640000000002000000000000000000000006636c6f73650000000005766f6964000000"
    "000200000000000000000000000800000003494400000000056c6f6e67000000001200"
    "0000000000000a646972656374696f6e000000000f43534c3a3a446972656374696f6e"
    "00000000120000000000000005726f6c650000000007737472696e6700000000120000"
    "0000000000067469746c650000000007737472696e670000000013000000000000000b"
    "6275666665725573656400000000056c6f6e670000000012000000000000000b627566"
    "66657253697a6500000000056c6f6e6700000000130000000000000007706172616d73"
    "000000001243534c3a3a53747265616d506172616d7300000000130000000000000007"
    "6163746976650000000008626f6f6c65616e0000000013000000000000000000000000"
    "0000001043534c3a3a506c617953747265616d00000000010000000c43534c3a3a5374"
    "7265616d00000000010000000677726974650000000005766f69640000000001000000"
    "01000000062a6279746500000000066279746573000000000000000000000000020000"
    "00056c6566740000000006666c6f6174000000004a0000000000000006726967687400"
    "00000006666c6f6174000000004a0000000000000002000000056c6566740000000006"
    "726967687400000000000000001243534c3a3a5265636f726453747265616d00000000"
    "010000000c43534c3a3a53747265616d0000000001000000057265616400000000062a"
    "62797465000000000200000001000000056c6f6e6700000000046c656e000000000000"
    "00000000000002000000056c6566740000000006666c6f617400000000490000000000"
    "00000672696768740000000006666c6f61740000000049000000000000000200000005"
    "6c65667400000000067269676874000000000000000000"
);
