
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesource.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesource.h>
#include <bse/bseundostack.h>
#include <bse/gslieee754.h>


#line 28 "bsesource.proc"

/* --- set-input-by-id --- */
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsesource.proc"
 {
#line 31 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 43 "bsesource.proc"
 }
static BseErrorType
#line 43 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 46 "bsesource.proc"
{
#line 47 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error;
  
#line 54 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 59 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);

#line 64 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 70 "bsesource.proc"
 {
#line 72 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 84 "bsesource.proc"
 }
static BseErrorType
#line 84 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 87 "bsesource.proc"
{
#line 88 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_name = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_name = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error;
  
#line 96 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel_name || !ochannel_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 102 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_name);
  ochannel = bse_source_find_ochannel (osource, ochannel_name);
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
  
#line 109 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 115 "bsesource.proc"
 {
#line 117 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 129 "bsesource.proc"
 }
static BseErrorType
#line 129 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 132 "bsesource.proc"
{
#line 133 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 140 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 144 "bsesource.proc"
  
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }

#line 155 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 161 "bsesource.proc"
 {
#line 163 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 175 "bsesource.proc"
 }
static BseErrorType
#line 175 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 178 "bsesource.proc"
{
#line 179 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_name = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_name = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error = BSE_ERROR_NONE;
  
#line 187 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      !ichannel_name || !ochannel_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 192 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_name);
  ochannel = bse_source_find_ochannel (osource, ochannel_name);
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }
  
#line 205 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 211 "bsesource.proc"
 {
#line 213 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 216 "bsesource.proc"
 }
static BseErrorType
#line 216 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 219 "bsesource.proc"
{
#line 220 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 224 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 228 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-inputs %s", bse_object_debug_name (isource));
  bse_source_backup_ichannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-inputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 238 "bsesource.proc"
 {
#line 240 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 243 "bsesource.proc"
 }
static BseErrorType
#line 243 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 246 "bsesource.proc"
{
#line 247 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;

#line 251 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 255 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-outputs %s", bse_object_debug_name (isource));
  bse_source_backup_ochannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-outputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- has-outputs --- */
static void
has_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 265 "bsesource.proc"
 {
#line 267 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", "Has Outputs", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 272 "bsesource.proc"
 }
static BseErrorType
#line 272 "bsesource.proc"
has_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 275 "bsesource.proc"
{
#line 276 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 279 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 283 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, source->outputs != NULL);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 289 "bsesource.proc"
 {
#line 291 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 296 "bsesource.proc"
 }
static BseErrorType
#line 296 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 299 "bsesource.proc"
{
#line 300 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 303 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 307 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-name --- */
static void
ichannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 313 "bsesource.proc"
 {
#line 315 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 322 "bsesource.proc"
 }
static BseErrorType
#line 322 "bsesource.proc"
ichannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 325 "bsesource.proc"
{
#line 326 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 330 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 334 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_NAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-ident --- */
static void
ichannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 340 "bsesource.proc"
 {
#line 342 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 349 "bsesource.proc"
 }
static BseErrorType
#line 349 "bsesource.proc"
ichannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 352 "bsesource.proc"
{
#line 353 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 357 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 361 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_IDENT (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 367 "bsesource.proc"
 {
#line 369 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 376 "bsesource.proc"
 }
static BseErrorType
#line 376 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 379 "bsesource.proc"
{
#line 380 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 384 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 388 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 394 "bsesource.proc"
 {
#line 396 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 403 "bsesource.proc"
 }
static BseErrorType
#line 403 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 406 "bsesource.proc"
{
#line 407 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 411 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 415 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 421 "bsesource.proc"
 {
#line 423 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 430 "bsesource.proc"
 }
static BseErrorType
#line 430 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 433 "bsesource.proc"
{
#line 434 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  gchar *ichannel   = sfi_value_get_string (in_values++);
  guint id;
  
#line 439 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 443 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  sfi_value_set_bool (out_values++,
		      id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 451 "bsesource.proc"
 {
#line 453 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_joints", "Number of Connections", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 460 "bsesource.proc"
 }
static BseErrorType
#line 460 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 463 "bsesource.proc"
{
#line 464 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 469 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 473 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    sfi_value_set_int (out_values++, input->jdata.n_joints);
  else
    sfi_value_set_int (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 483 "bsesource.proc"
 {
#line 485 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("osource", "Output Source", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 494 "bsesource.proc"
 }
static BseErrorType
#line 494 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 497 "bsesource.proc"
{
#line 498 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 504 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 508 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    bse_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    bse_value_set_object (out_values++, input->idata.osource);
  else
    bse_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 520 "bsesource.proc"
 {
#line 522 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("ochannel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 531 "bsesource.proc"
 }
static BseErrorType
#line 531 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 534 "bsesource.proc"
{
#line 535 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 541 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 545 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    sfi_value_set_int (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    sfi_value_set_int (out_values++, input->idata.ochannel);
  else
    sfi_value_set_int (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 557 "bsesource.proc"
 {
#line 559 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 564 "bsesource.proc"
 }
static BseErrorType
#line 564 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 567 "bsesource.proc"
{
#line 568 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 571 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 575 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-name --- */
static void
ochannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 581 "bsesource.proc"
 {
#line 583 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 590 "bsesource.proc"
 }
static BseErrorType
#line 590 "bsesource.proc"
ochannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 593 "bsesource.proc"
{
#line 594 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 598 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 602 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_NAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-ident --- */
static void
ochannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 608 "bsesource.proc"
 {
#line 610 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_name", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 617 "bsesource.proc"
 }
static BseErrorType
#line 617 "bsesource.proc"
ochannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 620 "bsesource.proc"
{
#line 621 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 625 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 629 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_IDENT (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 635 "bsesource.proc"
 {
#line 637 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 644 "bsesource.proc"
 }
static BseErrorType
#line 644 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 647 "bsesource.proc"
{
#line 648 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 652 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 656 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- set-pos --- */
static void
set_pos_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 662 "bsesource.proc"
 {
#line 669 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("x-pos", "X Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("y-pos", "Y Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
}
#line 676 "bsesource.proc"
 }
static BseErrorType
#line 676 "bsesource.proc"
set_pos_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 679 "bsesource.proc"
{
#line 680 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  SfiReal xpos      = sfi_value_get_real (in_values++);
  SfiReal ypos      = sfi_value_get_real (in_values++);
  SfiReal epsilon = 1e-5;

#line 686 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || GSL_DOUBLE_IS_NANINF (xpos) || GSL_DOUBLE_IS_NANINF (ypos))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 690 "bsesource.proc"
  
  if (fabs (xpos - source->pos_x) > epsilon ||
      fabs (ypos - source->pos_y) > epsilon)
    {
      BseUndoStack *ustack = bse_item_undo_open (source, "set-xy-pos");
      bse_item_set (source,
                    "pos_x", xpos,
                    "pos_y", ypos,
                    NULL);
      bse_item_undo_close (ustack);
    }

  return BSE_ERROR_NONE;
}


/* --- Export to BSE --- */
static BseExportNodeProc __enode_set_input_by_id = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Set Input By Id",
    "Connect a module input to another module's output.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, set_input_by_id_setup, set_input_by_id_exec, 
};
static BseExportNodeProc __enode_set_input = {
  { (BseExportNode*) &__enode_set_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input", 
    NULL,
    "/Methods/BseSource/General/Set Input",
    "Connect a module input to another module's output.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, set_input_setup, set_input_exec, 
};
static BseExportNodeProc __enode_unset_input_by_id = {
  { (BseExportNode*) &__enode_set_input, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Unset Input By Id",
    "Disconnect a module input.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, unset_input_by_id_setup, unset_input_by_id_exec, 
};
static BseExportNodeProc __enode_unset_input = {
  { (BseExportNode*) &__enode_unset_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input", 
    NULL,
    "/Methods/BseSource/General/Unset Input",
    "Disconnect a module input.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, unset_input_setup, unset_input_exec, 
};
static BseExportNodeProc __enode_clear_inputs = {
  { (BseExportNode*) &__enode_unset_input, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-inputs", 
    NULL,
    "/Methods/BseSource/General/Clear Inputs",
    "Disconnect all module inputs.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, clear_inputs_setup, clear_inputs_exec, 
};
static BseExportNodeProc __enode_clear_outputs = {
  { (BseExportNode*) &__enode_clear_inputs, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-outputs", 
    NULL,
    "/Methods/BseSource/General/Clear Outputs",
    "Disconnect all module outputs.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, clear_outputs_setup, clear_outputs_exec, 
};
static BseExportNodeProc __enode_has_outputs = {
  { (BseExportNode*) &__enode_clear_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+has-outputs", 
    NULL,
    "/Methods/BseSource/General/Has Outputs",
    "Check whether a module has output channel connections.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, has_outputs_setup, has_outputs_exec, 
};
static BseExportNodeProc __enode_n_ichannels = {
  { (BseExportNode*) &__enode_has_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ichannels", 
    NULL,
    "/Methods/BseSource/General/N Ichannels",
    "Get the number of input channels of a module.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, n_ichannels_setup, n_ichannels_exec, 
};
static BseExportNodeProc __enode_ichannel_name = {
  { (BseExportNode*) &__enode_n_ichannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-name", 
    NULL,
    "/Methods/BseSource/General/Ichannel Name",
    "Get input channel name.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_name_setup, ichannel_name_exec, 
};
static BseExportNodeProc __enode_ichannel_ident = {
  { (BseExportNode*) &__enode_ichannel_name, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ichannel Ident",
    "Get canonical input channel name.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_ident_setup, ichannel_ident_exec, 
};
static BseExportNodeProc __enode_ichannel_blurb = {
  { (BseExportNode*) &__enode_ichannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ichannel Blurb",
    "Get input channel description.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_blurb_setup, ichannel_blurb_exec, 
};
static BseExportNodeProc __enode_is_joint_ichannel_by_id = {
  { (BseExportNode*) &__enode_ichannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel-by-id", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel By Id",
    "Check if an input channel is a joint (multi-connect) channel.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, 
};
static BseExportNodeProc __enode_is_joint_ichannel = {
  { (BseExportNode*) &__enode_is_joint_ichannel_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel",
    "Check if an input channel is a joint (multi-connect) channel.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, is_joint_ichannel_setup, is_joint_ichannel_exec, 
};
static BseExportNodeProc __enode_ichannel_get_n_joints = {
  { (BseExportNode*) &__enode_is_joint_ichannel, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-n-joints", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get N Joints",
    "Retrieve the number of inputs connected to an input channel.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, 
};
static BseExportNodeProc __enode_ichannel_get_osource = {
  { (BseExportNode*) &__enode_ichannel_get_n_joints, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-osource", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Osource",
    "Retrieve output module connected to a specific joint of an input channel",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_get_osource_setup, ichannel_get_osource_exec, 
};
static BseExportNodeProc __enode_ichannel_get_ochannel = {
  { (BseExportNode*) &__enode_ichannel_get_osource, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-ochannel", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Ochannel",
    "Retrieve output channel of the module connected to a specific joint of an input channel.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, 
};
static BseExportNodeProc __enode_n_ochannels = {
  { (BseExportNode*) &__enode_ichannel_get_ochannel, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ochannels", 
    NULL,
    "/Methods/BseSource/General/N Ochannels",
    "Get the number of output channels of a module.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, n_ochannels_setup, n_ochannels_exec, 
};
static BseExportNodeProc __enode_ochannel_name = {
  { (BseExportNode*) &__enode_n_ochannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-name", 
    NULL,
    "/Methods/BseSource/General/Ochannel Name",
    "Get output channel name.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ochannel_name_setup, ochannel_name_exec, 
};
static BseExportNodeProc __enode_ochannel_ident = {
  { (BseExportNode*) &__enode_ochannel_name, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ochannel Ident",
    "Get canonical output channel name.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ochannel_ident_setup, ochannel_ident_exec, 
};
static BseExportNodeProc __enode_ochannel_blurb = {
  { (BseExportNode*) &__enode_ochannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ochannel Blurb",
    "Get output channel description.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, ochannel_blurb_setup, ochannel_blurb_exec, 
};
static BseExportNodeProc __enode_set_pos = {
  { (BseExportNode*) &__enode_ochannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+set-pos", 
    NULL,
    "/Methods/BseSource/General/Set Pos",
    "Set the x and y position of a module. In contrast to setting the position "
          "through ordinary object property setters, this function will not update "
          "the module position if the passed in arguments are sufficiently equal to "
          "the values already set on the object. As such, it does not record an extra "
          "undo step for setting properties to values they already have and if necessary "
          "turns setting of x and y positions into an atomic undo operation.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, set_pos_setup, set_pos_exec, 
};
BseExportNode* bse__builtin_init_bsesource_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsesource_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_set_pos;
}

/**
 ** Generated data ends here
 **/
